'Non Ex Terra
'
'By Kyle Petersen
'
'Inspired by: Legend Of the Red Dragon
'             Legacy of the Lost Scrolls
'-----------------------------------------------------------------------------
DECLARE SUB checkcigars ()
DECLARE FUNCTION sellarmour% ()
DECLARE SUB armour ()
DECLARE SUB buyarmour ()
DECLARE FUNCTION sellweapon% ()
DECLARE SUB buyweapon ()
DECLARE SUB weapons ()
DECLARE SUB endgame (leave%)
DECLARE FUNCTION canrun% (bg%, fl%)
DECLARE SUB youlost (bg%, fl%)
DECLARE SUB youwon (bg%, fl%)
DECLARE FUNCTION attack% (bg%, fl%)
DECLARE FUNCTION choosebadguy% (flv%)
DECLARE SUB fightwith (badguy%, flv%)
DECLARE SUB loadbadguy (flv%)
DECLARE SUB lookforsomeone ()
DECLARE SUB saveplayer (filename$)
DECLARE FUNCTION findbeauty$ ()
DECLARE SUB disp (text$)
DECLARE FUNCTION SpInput$ (x%, y%, nlen%, fcol%, bcol%, fill$, curs$)
DECLARE SUB forest ()
DECLARE SUB loadplayer (filename$)
DECLARE FUNCTION exists% (filename$)
DECLARE FUNCTION isplayer% (plrname$)
DECLARE FUNCTION cvt$ (num%)
DECLARE FUNCTION rand% (value%)
DECLARE FUNCTION findalign$ ()
DECLARE SUB waitkey ()
DECLARE SUB viewstats ()
DECLARE FUNCTION loaddpf% (filename$)
DECLARE SUB bank ()
DECLARE SUB pause (del!)
DECLARE FUNCTION menu% (choices$(), select$(), nchoices%)
DECLARE SUB Town ()
DECLARE FUNCTION recnuminp% (ft%, lt%)
DECLARE SUB newplayer ()
DECLARE FUNCTION yesno% ()
DECLARE SUB ask4player ()
DECLARE SUB InitGame ()
DEFINT A-Z
ON ERROR GOTO errcatcher
RANDOMIZE TIMER

TYPE user
 prace AS INTEGER    'Race
 pjob AS INTEGER     'Occupation
 psex AS INTEGER     'Player's sex
 pgold AS INTEGER    'Gold on hand
 pbank AS INTEGER    'Gold in bank
 parmour AS INTEGER  'Armour
 pweapon AS INTEGER  'Weapon
 pexpr AS INTEGER    'Experience
 pstrn AS INTEGER    'Strength
 pmstrn AS INTEGER   'Maximum Strength
 phand AS INTEGER    'Hand agility
 pmhand AS INTEGER   'Maximum hand agility
 peye AS INTEGER     'Eyesight
 pmeye AS INTEGER    'Maximum eyesight
 pspell AS INTEGER   'Spell strength
 pmspell AS INTEGER  'Maximum spell strength
 pspeed AS INTEGER   'Speed
 pmspeed AS INTEGER  'Maximum speed
 pendr AS INTEGER    'Endurance
 pmendr AS INTEGER   'Maximum endurance
 phits AS INTEGER    'Hit strength
 pmhits AS INTEGER   'Maximum hit strength
 palign AS INTEGER   'Alignment. (0 - Neutral. Good > 0 > Bad)
 plevel AS INTEGER   'Player's current level
 pfights AS INTEGER  'Player's fights left
 pbeauty AS INTEGER  'Player's beauty
END TYPE

TYPE game
 fcol AS INTEGER
 bcol AS INTEGER
END TYPE

TYPE bguy
  bhits AS INTEGER
  bgold AS INTEGER
  bexpr AS INTEGER
  bweap AS INTEGER
END TYPE

DIM SHARED user AS user, game AS game, cmenu$(20), smenu$(20)
DIM SHARED pname$, prname$, pjname$, wpname$(10), amname$(10)
DIM SHARED wpcost(10), amcost(10), wpdam(10), amdam(10), ferror
DIM SHARED filen$, bname$(19, 9), barm(19, 9), bwea(19, 9)
DIM SHARED barmn$(19, 9), bwean$(19, 9), deathw$(19, 9), nbd(9)
DIM SHARED bguy AS bguy, badguy, flv
InitGame
ask4player
Town

errcatcher:
ferror = 0
RESUME NEXT

SUB armour
DO
nm = loaddpf("armour.dpf")

ch = menu(cmenu$(), smenu$(), nm)
pause .2
SELECT CASE ch
  CASE 0: buyarmour
  CASE 1: blnk = sellarmour
  CASE 2: checkcigars
  CASE 3: viewstats
  CASE 4: EXIT DO
END SELECT
LOOP


END SUB

SUB ask4player
disp "%f7What is your name: (                )"
pname$ = SpInput(21, CSRLIN - 1, 15, 15, 0, "_", " ")
IF pname$ = "" THEN SYSTEM
IF isplayer(pname$) = 0 THEN newplayer
IF user.phits <= 0 THEN user.phits = user.pmhits / 2
user.pfights = 20
END SUB

FUNCTION attack (bg, fl)
disp "%f2You rush toward " + bname$(bg, fl) + " and attack!"
mn = rand(wpdam(user.pweapon)) + user.pstrn
IF mn = 0 THEN disp "%f:Your attack is blocked!"
IF mn <> 0 THEN disp "%f<You do " + cvt$(mn) + " damage!"
bguy.bhits = bguy.bhits - mn
IF bguy.bhits <= 0 THEN attack = 1: EXIT FUNCTION
disp "%f2" + bname$(bg, fl) + " lunges towards you..."
mn = rand(bguy.bweap) - rand(amdam(user.parmour))
IF mn < 0 THEN mn = 0
IF mn = 0 THEN disp "%f:And you swiftly step to the side!"
IF mn <> 0 THEN disp "%f<You are hit with " + cvt$(mn) + " of damage!"
user.phits = user.phits - mn
IF user.phits <= 0 THEN attack = 2: EXIT FUNCTION
attack = 0
END FUNCTION

SUB bank
DO
nm = loaddpf("bank.dpf")

ch = menu(cmenu$(), smenu$(), nm)
pause .2
SELECT CASE ch
  CASE 0  'Deposit
    PRINT
    disp "%f7You have " + cvt$(user.pgold) + " on hand, and " + cvt$(user.pbank) + " in the bank."
    disp "%f7How much do you wish to put in. (1 for all.)"
    disp "%f7:"
    amnt = VAL(SpInput$(2, CSRLIN - 1, 5, 7, 0, " ", "_"))
    PRINT
    IF amnt > user.pgold + (user.pgold / 2) THEN
       disp "%f7%QHey%Q, yells the teller, %QWhat are you trying to pull?%Q"
       disp "%f7%QI'm smart enough to know you don't have that much on you!%Q"
    ELSEIF (amnt <= user.pgold) THEN
       IF amnt <> 0 THEN
        IF amnt = 1 THEN amnt = user.pgold
        disp "%f7The teller takes your money and puts in the bank vault, he then dutifully"
        disp "%f7writes the amount in the account book. %QThank you%Q, he says."
        user.pbank = user.pbank + amnt
        user.pgold = user.pgold - amnt
       ELSE
        disp "%f7The teller stares blankly at you for a minute, then walks to the other"
        disp "%f7side of the room and looks at a small piece of paper. Moments later he"
        disp "%f7walks back to you and says, %qYou know, you didn't give me any money to"
        disp "%f7deposit. So I don't think I can help you any.%Q"
       END IF
    ELSEIF amnt > user.pgold AND amnt < user.pgold + (user.pgold / 2) THEN
       IF rand(5) = 0 AND bcheat = 0 THEN
         disp "%f7The teller takes your money and puts in the bank vault, he then dutifully"
         disp "%f7writes the amount in the account book. %QThank you%Q, he says."
         disp "%f7You secretly think to yourself what a dumb teller that man is."
         disp "%f?(%f7You've already tricked the teller once, I don't think he'll be"
         disp "%f7 stupid enough to fall for it again. At least for today.%f?)"
         user.pbank = user.pbank + amnt
         user.pgold = user.pgold - amnt
         IF user.pgold < 0 THEN user.pgold = 0
         bcheat = 1
       ELSE
         disp "%f7%QHey%Q, yells the teller, %QWhat are you trying to pull?%Q"
         disp "%f7%QI'm smart enough to know you don't have that much on you!%Q"
       END IF
    END IF
    PRINT
    waitkey
  CASE 1
    PRINT
    disp "%f7You have " + cvt$(user.pgold) + " on hand, and " + cvt$(user.pbank) + " in the bank."
    disp "%f7How much do you wish to take out. (1 for all.)"
    disp "%f7:"
    amnt = VAL(SpInput$(2, CSRLIN - 1, 5, 7, 0, " ", "_"))
    PRINT
    IF amnt > user.pbank THEN
         disp "%f7%QSorry, you don't have that much in the bank.%Q, the teller"
         disp "%f7kindly points out to you."
    ELSEIF amnt <= user.pbank THEN
         IF amnt <> 0 THEN
            IF amnt = 1 THEN amnt = user.pbank
            disp "%f7The teller hands you the money that you asked for. %QHere you"
            disp "%f7go%q, he says. You pick up the coins and put them into the folds"
            disp "%f7of your cloak."
            user.pgold = user.pgold + amnt
            user.pbank = user.pbank - amnt
         ELSE
            disp "%f7The teller looks around, and then leans close to your ear. %QI don't"
            disp "%f7think you can withdraw zero coins, sir.%q, he whispers. Then he backs"
            disp "%f7away from you with the air of a person who just helped someone dumber"
            disp "%f7than himself."
         END IF
    END IF
    PRINT
    waitkey
  CASE 2: viewstats
  CASE 3: EXIT DO
END SELECT
LOOP
END SUB

SUB buyarmour
IF user.parmour <> 0 THEN
  disp "%n%f7You can't have more than one type of armour. How about if I buy"
  disp "%x%f7that " + amname$(user.parmour) + " from you. "
  IF yesno = 0 THEN EXIT SUB
  IF sellweapon = 0 THEN EXIT SUB
END IF
disp "%n%f7The girl looks around for something. Running over to the desk"
disp "%f7she picks a small scroll and hands it to you. You open it."
PRINT
FOR t = 1 TO 8
  disp "%f?" + cvt$(t) + " %f7- Cost:%f;" + cvt$(amcost(t)) + "%f7...%f<" + amname$(t)
NEXT
disp "%f?9%f7 - Quit"
disp "%n%x%f?:"
cm = recnuminp(1, 9)
IF cm = 9 THEN EXIT SUB
IF amcost(cm) > user.pgold THEN disp "%f7%qHey, you don't have enough gold on you!%q": EXIT SUB
disp "%f7%qOk... Give me your money, uh hu... Here you go, your new " + amname$(cm) + "."
user.pgold = user.pgold - amcost(cm)
user.parmour = cm

END SUB

SUB buyweapon
IF user.pweapon <> 0 THEN
  disp "%n%f7You can't have more than one weapon. How about if I buy"
  disp "%x%f7that " + wpname$(user.pweapon) + " from you. "
  IF yesno = 0 THEN EXIT SUB
  IF sellweapon = 0 THEN EXIT SUB
END IF
disp "%n%f7The man looks under the counter and rummages through some papers."
disp "%f7Soon he stands up and hands you a small scroll. You open it."
PRINT
FOR t = 1 TO 8
  disp "%f?" + cvt$(t) + " %f7- Cost:%f;" + cvt$(wpcost(t)) + "%f7...%f<" + wpname$(t)
NEXT
disp "%f?9%f7 - Quit"
disp "%n%x%f?:"
cm = recnuminp(1, 9)
IF cm = 9 THEN EXIT SUB
IF wpcost(cm) > user.pgold THEN disp "%f7%qHey, you don't have enough gold on you!%q": EXIT SUB
disp "%f7%qOk... Give me your money, uh hu... Here you go, your new " + wpname$(cm) + "."
user.pgold = user.pgold - wpcost(cm)
user.pweapon = cm
END SUB

FUNCTION canrun (bg, fl)
IF user.prace = 7 THEN  'Is this a wyvern?
  disp "%n%f>Using your wings, you fly away from the fight."
  waitkey
  canrun = 1
  EXIT FUNCTION
END IF

blk = rand((fl + 1) * 2) + 1
spd = rand(user.pspeed)
rd = rand(user.pexpr) + 1
IF blk > spd + rd THEN
  disp "%n%f9" + bname$(bg, fl) + " blocks your attempt to escape."
  dmg = rand(bguy.bweap + 1)
  disp "%f9It then hits you with " + cvt$(dmg) + " points of damage."
  user.phits = user.phits - dmg
  IF user.phits <= 0 THEN youlost bg, fl
  waitkey
  canrun = 0
ELSE
  disp "%n%f=You turn tail and run!"
  waitkey
  canrun = 1
END IF
END FUNCTION

SUB checkcigars
disp "%f7Sorry, this option is currently unavailible."
waitkey
END SUB

FUNCTION choosebadguy (flv)
numbd = nbd(flv - 1)
cbg = rand(numbd)
bguy.bgold = rand(flv * 20) + 5
bguy.bexpr = rand(10) + 1
bguy.bhits = barm(cbg, flv - 1)
bguy.bweap = bwea(cbg, flv - 1)
IF (bguy.bexpr + user.pexpr) / 30 > user.plevel THEN bguy.bexpr = (user.plevel * 30) - user.pexpr
choosebadguy = cbg
END FUNCTION

FUNCTION cvt$ (num)
cvt$ = MID$(STR$(num), 2, LEN(STR$(num)) - 1)
END FUNCTION

SUB disp (text$)
FOR t = 1 TO LEN(text$)
  IF MID$(text$, t, 1) = "%" THEN
   t = t + 1
   IF MID$(text$, t, 1) = "%" THEN PRINT "%";
   IF UCASE$(MID$(text$, t, 1)) = "Q" THEN PRINT CHR$(34);
   IF UCASE$(MID$(text$, t, 1)) = "N" THEN PRINT
   IF UCASE$(MID$(text$, t, 1)) = "X" THEN newline = 1
   IF UCASE$(MID$(text$, t, 1)) = "A" THEN PRINT amname$(user.parmour);
   IF UCASE$(MID$(text$, t, 1)) = "W" THEN PRINT wpname$(user.pweapon);
   IF UCASE$(MID$(text$, t, 1)) = "H" THEN PRINT cvt$(user.phits);
   IF UCASE$(MID$(text$, t, 1)) = "M" THEN PRINT cvt$(user.pmhits);
   IF UCASE$(MID$(text$, t, 1)) = "P" THEN PRINT pname$;
   IF UCASE$(MID$(text$, t, 1)) = "G" THEN PRINT bname$(badguy, flv - 1);
   IF UCASE$(MID$(text$, t, 1)) = "D" THEN PRINT cvt$(bguy.bhits);
   IF UCASE$(MID$(text$, t, 1)) = "F" THEN
    t = t + 1
    game.fcol = ASC(MID$(text$, t, 1)) - 48
   END IF
   IF UCASE$(MID$(text$, t, 1)) = "B" THEN
    t = t + 1
    game.bcol = ASC(MID$(text$, t, 1)) - 48
   END IF
   COLOR game.fcol, game.bcol
  ELSE
   PRINT MID$(text$, t, 1);
  END IF
NEXT
IF newline = 0 THEN PRINT
END SUB

SUB endgame (leave)
IF leave = 1 THEN
  disp "%x%f7Are you sure you wish to leave? "
  IF yesno = 0 THEN EXIT SUB
END IF
saveplayer filen$
SYSTEM
END SUB

FUNCTION exists (filename$)
ferror = 1
handle = FREEFILE
OPEN filename$ FOR INPUT AS #handle
CLOSE #handle
exists = ferror
END FUNCTION

SUB fightwith (badguy, flv)
disp "%f7You stumble across " + bname$(badguy, flv - 1)
disp "%f7%f9Weapon%f7: %f3" + bwean$(badguy, flv - 1)
LOCATE CSRLIN - 1, 40
disp "%f7%f9Armour%f7: %f3" + barmn$(badguy, flv - 1)
PRINT
disp "%f7Pulling up short, you set yourself to fight."
DO
 nm = loaddpf("attackm.dpf")
 ch = menu(cmenu$(), smenu$(), nm)
 SELECT CASE ch
    CASE 0
      at = attack(badguy, flv - 1)
      IF at = 1 THEN youwon badguy, flv - 1: EXIT DO
      IF at = 2 THEN youlost badguy, flv - 1: EXIT DO
    CASE 1
      rn = canrun(badguy, flv - 1)
      IF rn = 1 THEN EXIT DO
    CASE 3: viewstats
 END SELECT
LOOP
END SUB

FUNCTION findalign$
IF user.palign > 50 THEN al$ = "Upstanding"
IF user.palign > 25 THEN al$ = "Good"
IF user.palign > 0 THEN al$ = "Civil"
IF user.palign = 0 THEN al$ = "Neutral"
IF user.palign < 0 THEN al$ = "Grumpy"
IF user.palign < -25 THEN al$ = "Bad"
IF user.palign < -50 THEN al$ = "Treacharous"
findalign$ = al$
END FUNCTION

FUNCTION findbeauty$
IF user.pbeauty > 0 THEN fb$ = "a handsome "
IF user.pbeauty > 10 THEN fb$ = "a pretty "
IF user.pbeauty > 20 THEN fb$ = "a beautiful "
IF user.pbeauty > 30 THEN fb$ = "a gorgeous "
IF user.pbeauty = 40 THEN fb$ = "an astounding "
IF user.pbeauty = 0 THEN fb$ = "an average "
IF user.pbeauty < 0 THEN fb$ = "a scarred "
IF user.pbeauty < -10 THEN fb$ = "an ugly "
IF user.pbeauty < -20 THEN fb$ = "a hideous "
IF user.pbeauty < -30 THEN fb$ = "a loathsome "
IF user.pbeauty = -40 THEN fb$ = "a ghastly "
IF user.psex = 1 THEN fb$ = fb$ + "male" ELSE fb$ = fb$ + "female"
findbeauty$ = fb$
END FUNCTION

SUB forest
DO
nm = loaddpf("forest.dpf")

disp "%f2You are currently at level " + cvt$(user.plevel) + "."
disp "%f2Your experience is " + cvt$(user.pexpr)
LOCATE CSRLIN - 1, 25
IF user.pfights = 1 THEN s$ = "" ELSE s$ = "s"   'Is it fights or fight?
disp "%f2You can fight " + cvt$(user.pfights) + " more fight" + s$ + " today."
'New line
disp "%f2Your health is %f7" + cvt$(user.phits) + "%f8/%f7" + cvt$(user.pmhits)
LOCATE CSRLIN - 1, 25
disp "%f2Your weapon is: %f<" + wpname$(user.pweapon)
'New line
disp "%f2Your armour is: %f<" + amname$(user.parmour)
'New line
disp "%f4-%f<" + STRING$(78, "-") + "%f4-"
PRINT

ch = menu(cmenu$(), smenu$(), nm)
pause .2
SELECT CASE ch
  CASE 0: lookforsomeone
  CASE 1:
  CASE 2: viewstats
  CASE 3: EXIT DO
END SELECT
LOOP

END SUB

SUB InitGame
SCREEN 0
WIDTH 80

CLS
PRINT "Loading weapons and armour names..."
handle = FREEFILE
IF exists("attacks.dat") = 0 THEN PRINT "File ATTACKS.DAT not found... ABORTING!": SYSTEM
OPEN "attacks.dat" FOR INPUT AS #handle
  FOR t = 0 TO 9
    LINE INPUT #1, wpname$(t)
    INPUT #1, wpcost(t)
    INPUT #1, wpdam(t)
  NEXT
  FOR t = 0 TO 9
    LINE INPUT #1, amname$(t)
    INPUT #1, amcost(t)
    INPUT #1, amdam(t)
  NEXT
CLOSE #handle

handle = FREEFILE
FOR t = 0 TO 9
  flname$ = "bad.dt" + cvt$(t)
  IF exists(flname$) = 1 THEN
  OPEN flname$ FOR INPUT AS #handle
     cnt = 0
     spcnt = 0
     ls = 0
     DO
      LINE INPUT #handle, tmp$
      'Parse out any comments
      ps = INSTR(tmp$, "//")
      IF ps <> 0 THEN tmp$ = MID$(tmp$, 1, ps - 1)
      IF tmp$ = "FILES END" THEN EXIT DO
      IF tmp$ <> "" THEN
        IF ls = 2 THEN
         SELECT CASE cnt
            CASE 0: bname$(spcnt, t) = tmp$
            CASE 1
               ps = INSTR(tmp$, ",")
               barm(spcnt, t) = VAL(MID$(tmp$, ps + 1, LEN(tmp$) - ps))
               barmn$(spcnt, t) = LEFT$(tmp$, ps - 1)
            CASE 2
               ps = INSTR(tmp$, ",")
               bwea(spcnt, t) = VAL(MID$(tmp$, ps + 1, LEN(tmp$) - ps))
               bwean$(spcnt, t) = LEFT$(tmp$, ps - 1)
            CASE 3: deathw$(spcnt, t) = tmp$: spcnt = spcnt + 1
         END SELECT
         cnt = (cnt + 1) MOD 4
        ELSE
         IF ls = 1 THEN maxw = VAL(tmp$): ls = ls + 1
         IF ls = 0 THEN maxa = VAL(tmp$): ls = ls + 1
        END IF
      END IF
     LOOP UNTIL EOF(handle)
     nbd(t) = spcnt - 1
  CLOSE #handle
  END IF
NEXT
END SUB

FUNCTION isplayer (plrname$)
handle = FREEFILE
IF exists("players.dat") = 0 THEN isplayer = 0: EXIT FUNCTION
OPEN "players.dat" FOR INPUT AS #handle
 DO
  LINE INPUT #handle, playern$
  LINE INPUT #handle, filen$
  IF playern$ = UCASE$(plrname$) THEN loadplayer (filen$): isplayer = 1: EXIT DO
 LOOP UNTIL EOF(handle)
CLOSE #handle
END FUNCTION

FUNCTION loaddpf (filename$)
handle = FREEFILE
OPEN filename$ FOR INPUT AS #handle
ccnt = 0
scnt = 0
 DO
  tmp$ = ""
  LINE INPUT #handle, tmp$
  ps = LEN(tmp$)
  IF ps > 0 THEN
   SELECT CASE MID$(tmp$, 1, 2)
     CASE "BL": PRINT
     CASE "DS"
       ft = INSTR(tmp$, CHR$(34))
       tmp1$ = MID$(tmp$, ft + 1, LEN(tmp$) - ft)
       lt = INSTR(tmp1$, CHR$(34))
       tmp1$ = MID$(tmp1$, 1, lt - 1)
       disp tmp1$
     CASE "CM"
       ft = INSTR(tmp$, CHR$(34))
       tmp1$ = MID$(tmp$, ft + 1, LEN(tmp$) - ft)
       lt = INSTR(tmp1$, CHR$(34))
       tmp1$ = MID$(tmp1$, 1, lt - 1)
       cmenu$(ccnt) = tmp1$
       smenu$(ccnt) = MID$(tmp$, 4, 1)
       ccnt = ccnt + 1
   END SELECT
  END IF
 LOOP UNTIL EOF(handle)
CLOSE #handle
loaddpf = ccnt - 1
END FUNCTION

SUB loadplayer (filename$)
handle = FREEFILE
OPEN filename$ FOR INPUT AS #handle
  LINE INPUT #handle, prname$
  LINE INPUT #handle, pjname$
  INPUT #handle, user.prace
  INPUT #handle, user.pjob
  INPUT #handle, user.pgold
  INPUT #handle, user.pbank
  INPUT #handle, user.parmour
  INPUT #handle, user.pweapon
  INPUT #handle, user.pexpr
  INPUT #handle, user.pstrn
  INPUT #handle, user.pmstrn
  INPUT #handle, user.phand
  INPUT #handle, user.pmhand
  INPUT #handle, user.peye
  INPUT #handle, user.pmeye
  INPUT #handle, user.pspell
  INPUT #handle, user.pmspell
  INPUT #handle, user.pspeed
  INPUT #handle, user.pmspeed
  INPUT #handle, user.pendr
  INPUT #handle, user.pmendr
  INPUT #handle, user.phits
  INPUT #handle, user.pmhits
  INPUT #handle, user.palign
  INPUT #handle, user.plevel
  INPUT #handle, user.pfights
  INPUT #handle, user.psex
  INPUT #handle, user.pbeauty
CLOSE #handle

END SUB

SUB lookforsomeone
IF user.pfights = 0 THEN  'Does the player have any fight left in him.
  disp "%f7You're to tired to fight today."
  disp "%f7Try again tommorrow when you are rested."
  waitkey
  EXIT SUB
END IF

DO
rn = rand(5)
IF rn = 1 AND rand(10) = 1 THEN rn = 1:  ELSE rn = 0
LOOP WHILE rn > 1

SELECT CASE rn
   CASE 0  'Fight!
      flv = user.plevel
      IF rand(user.plevel) = 0 THEN flv = rand(user.plevel - 1) + 1
      badguy = choosebadguy(flv)
      fightwith badguy, flv
   CASE 1  'Merry band of partyers
      disp "%n%f;W%f9hilst walking through the woods today,"
      disp "%f;Y%f9ou came across some men at play,"
      disp "%f;T%f9hough taken by surprise,"
      disp "%f;Y%f9ou partyed until night,"
      disp "%f;A%f9nd awoke refreshed and feeling great."
      user.pfights = user.pfights - 1
      user.phits = user.pmhits
      waitkey
END SELECT
END SUB

FUNCTION menu (choices$(), select$(), nchoices)
FOR t = 0 TO nchoices
  disp "%f:" + UCASE$(select$(t)) + " %f8- %f2" + choices$(t)
NEXT
PRINT
disp "%x%f7Choose: "
DO
 a$ = INKEY$
 IF a$ <> "" THEN
  FOR t = 0 TO nchoices
    IF UCASE$(a$) = UCASE$(select$(t)) THEN
      PRINT UCASE$(a$)
      menu = t
      EXIT DO
    END IF
  NEXT
 END IF
LOOP
END FUNCTION

SUB newgame

END SUB

SUB newplayer
PRINT
disp "%f7Player, I couldn't find your name in the scrolls of lore. Are you sure your"
disp "%x%f7name is " + pname$ + "? "
IF yesno = 0 THEN PRINT : ask4player: EXIT SUB
PRINT
disp "%x%f9Do you wish to enter this world of wonder and terror? %f;[%f?y%f7/%f?n%f;] %f?"
IF yesno = 0 THEN SYSTEM
PRINT
disp "%f;I see you are new to this realm. Don't be startled, I can tell you"
disp "%f;are foreign by your clothes. I would be happy to get you some new"
disp "%f;ones, but I must know what race you are so I can fit them correctly."
PRINT
disp "%f?KEY %f7- %f>Ey %f9= %f;Eyesight. %f>St %f9= %f;Strength. %f>Sp %f9= %f;Speed. %f>En %f9= %f;Endurance."
PRINT
disp "%f?1 %f7- %f>Human  %f7Ey***   St***   Sp***   En***  "
disp "%f?2 %f7- %f>Elf    %f7Ey***** St**    Sp***** En**   "
disp "%f?3 %f7- %f>Dwarf  %f7Ey***   St****  Sp**    En*****"
disp "%f?4 %f7- %f>Orc    %f7Ey***   St****  Sp***   En**   "
disp "%f?5 %f7- %f>Hobbit %f7Ey****  St**    Sp***   En***   %f9Good at thievery."
disp "%f?6 %f7- %f>Troll  %f7Ey**    St***** Sp**    En*****"
disp "%f?7 %f7- %f>Wyvern %f7Ey***** St*     Sp***** En***   %f9Has wings to outreach others."
PRINT
disp "%x%f7Choose one. [1 - 7] "
nm = recnuminp(1, 7)
user.prace = nm
SELECT CASE nm
  CASE 1  'Human
       prname$ = "Human"
       user.pmeye = 30
       user.pmstrn = 30
       user.pmspeed = 30
       user.pmendr = 30
       user.pmhand = 10
  CASE 2  'Elf
       prname$ = "Elf"
       user.pmeye = 50
       user.pmstrn = 20
       user.pmspeed = 50
       user.pmendr = 20
       user.pmhand = 15
  CASE 3  'Dwarf
       prname$ = "Dwarf"
       user.pmeye = 30
       user.pmstrn = 40
       user.pmspeed = 20
       user.pmendr = 50
       user.pmhand = 5
  CASE 4  'Orc
       prname$ = "Orc"
       user.pmeye = 30
       user.pmstrn = 40
       user.pmspeed = 30
       user.pmendr = 20
       user.pmhand = 10
  CASE 5  'Hobbit
       prname$ = "Hobbit"
       user.pmeye = 40
       user.pmstrn = 20
       user.pmspeed = 30
       user.pmendr = 30
       user.pmhand = 20
  CASE 6  'Troll
       prname$ = "Troll"
       user.pmeye = 20
       user.pmstrn = 50
       user.pmspeed = 20
       user.pmendr = 50
       user.pmhand = 5
  CASE 7  'Wyvern
       prname$ = "Wyvern"
       user.pmeye = 50
       user.pmstrn = 10
       user.pmspeed = 50
       user.pmendr = 30
       user.pmhand = 15
END SELECT
PRINT
disp "%f;Ah, I see now... You are " + pname$ + " the " + prname$ + "."
PRINT
disp "%f;Good, very good. You know that you are always welcome in this world."
disp "%f;But before I let you enter, I must know what your occupation is."
disp "%f;So, " + pname$ + ", if you would please tell me what you do for a living,"
disp "%f;then you may begin your journey."
PRINT
disp "%f?1 %f7- %f>Magician."
disp "%f?2 %f7- %f>Warrior."
disp "%f?3 %f7- %f>Priest."
disp "%f?4 %f7- %f>Thief."
disp "%f?5 %f7- %f>Farmer."
PRINT
disp "%x%f7Choose one. [1 - 5] "
nm = recnuminp(1, 5)
user.pjob = 1
SELECT CASE nm
   CASE 1  'Magician
      pjname$ = "Magician"
      user.pmspell = user.pmspell * 3
      user.pmhand = user.pmhand * 3
   CASE 2  'Warrior
      pjname$ = "Warrior"
      user.pmstrn = user.pmstrn * 2
      user.pmhand = user.pmhand * 2
      user.pmeye = user.pmeye * 2
      user.pmspeed = user.pmspeed * 2
   CASE 3  'Priest
      pjname$ = "Priest"
      user.pmspell = user.pmspell * 2
      user.pmhand = user.pmhand * 3
   CASE 4  'Thief
      pjname$ = "Thief"
      user.pmhand = user.pmhand * 4
      user.pmeye = user.pmeye * 2
      user.pmspeed = user.pmspeed * 4
   CASE 5  'Farmer
      pjname$ = "Farmer"
      user.pmstrn = user.pmstrn * 3
      user.pmeye = user.pmeye * 4
      user.pmspeed = user.pmspeed * 2
END SELECT
PRINT
disp "%f;Just out of curiosity, what is your sex?"
PRINT
disp "%f?1 %f7- %f>Male"
disp "%f?2 %f7- %f>Female"
PRINT
disp "%x%f7Choose one: [1, 2] "
nm = recnuminp(1, 2)
disp "%f7Yep, that's what I thought."
user.psex = nm
PRINT
disp "%f;Hmm... " + pname$ + " the " + prname$ + " " + pjname$ + ". It does have a certain ring to it."
disp "%f;I like it, and I like you. Not to be boasting, but I am a pretty good judge of"
disp "%f;character, and I think you will do fine. But just to be safe, I'll give you"
disp "%f;fifty gold coins to get you started. I suggest you put them in your bank"
disp "%f;account, but you can do whatever you want with them."
user.pgold = 50
PRINT
disp "%f;That road there will take you into town. Just follow it, you should be there"
disp "%f;in a few minutes. Good luck!"
PRINT
disp "%f7Press Any Key To Begin..."
w$ = INPUT$(1)
user.phits = 10
user.pmhits = 20
user.parmour = 0
user.pweapon = 0
user.pbank = 0
user.pexpr = 1
user.palign = 0
user.pendr = 0
user.pstrn = 1
user.phand = 0
user.pspeed = 0
user.peye = 0
user.plevel = 1
FOR t = 0 TO 99
  IF exists("player" + cvt$(t) + ".pdf") = 0 THEN cnt = t: EXIT FOR
NEXT
handle = FREEFILE
filen$ = "player" + cvt$(cnt) + ".pdf"
OPEN "players.dat" FOR APPEND AS #handle
  PRINT #handle, UCASE$(pname$)
  PRINT #handle, filen$
CLOSE #handle
saveplayer filename$
END SUB

SUB pause (del!)
x! = TIMER + del!: WHILE x! >= TIMER: WEND
END SUB

FUNCTION rand (value)
rand = INT(RND(1) * (value + 1))
END FUNCTION

FUNCTION recnuminp (ft, lt)
DO
 a$ = INKEY$
 IF a$ <> "" THEN
  IF ASC(a$) - 48 >= ft AND ASC(a$) - 48 <= lt THEN recnuminp = ASC(a$) - 48: EXIT DO
 END IF
LOOP
PRINT ASC(a$) - 48
END FUNCTION

SUB saveplayer (filename$)
handle = FREEFILE
OPEN filename$ FOR OUTPUT AS #handle
  PRINT #handle, prname$
  PRINT #handle, pjname$
  PRINT #handle, user.prace
  PRINT #handle, user.pjob
  PRINT #handle, user.pgold
  PRINT #handle, user.pbank
  PRINT #handle, user.parmour
  PRINT #handle, user.pweapon
  PRINT #handle, user.pexpr
  PRINT #handle, user.pstrn
  PRINT #handle, user.pmstrn
  PRINT #handle, user.phand
  PRINT #handle, user.pmhand
  PRINT #handle, user.peye
  PRINT #handle, user.pmeye
  PRINT #handle, user.pspell
  PRINT #handle, user.pmspell
  PRINT #handle, user.pspeed
  PRINT #handle, user.pmspeed
  PRINT #handle, user.pendr
  PRINT #handle, user.pmendr
  PRINT #handle, user.phits
  PRINT #handle, user.pmhits
  PRINT #handle, user.palign
  PRINT #handle, user.plevel
  PRINT #handle, user.pfights
  PRINT #handle, user.psex
  PRINT #handle, user.pbeauty
CLOSE #handle
END SUB

FUNCTION sellarmour
pay = amcost(user.parmour) - (amcost(user.parmour) / 20)
disp "%f7For each returned armour I take off 20%% of the original value."
disp "%f7So, I'll give you " + cvt$(pay) + "$ for your " + amname$(user.parmour) + "."
disp "%xYes or no? "
IF yesno = 0 THEN sellarmour = 0: EXIT FUNCTION
user.pgold = user.pgold + pay
user.parmour = 0
sellarmour = 1

END FUNCTION

FUNCTION sellweapon
pay = wpcost(user.pweapon) - (wpcost(user.pweapon) / 20)
disp "%f7For each returned weapon I take off 20%% of the original value."
disp "%f7So, I'll give you " + cvt$(pay) + "$ for your " + wpname$(user.pweapon) + "."
disp "%xYes or no? "
IF yesno = 0 THEN sellweapon = 0: EXIT FUNCTION
user.pgold = user.pgold + pay
user.pweapon = 0
sellweapon = 1
END FUNCTION

FUNCTION SpInput$ (x, y, nlen, fcol, bcol, fill$, curs$)
visible = 1
y1 = y
x1 = x
text$ = ""
COLOR fcol, bcol

LOCATE y, x: PRINT text$
LOCATE y1, x1: PRINT STRING$(nlen + 1, fill$)

DO
 a$ = INKEY$

 IF a$ <> "" THEN
  SELECT CASE ASC(a$)
    CASE 13: EXIT DO
    CASE 27: text$ = "": EXIT DO
    CASE IS > 31
        IF LEN(text$) < nlen THEN
          text$ = text$ + a$
          LOCATE y, x: PRINT text$
          x1 = x1 + 1
        END IF
    CASE 8
        IF LEN(text$) > 0 THEN
          text$ = MID$(text$, 1, LEN(text$) - 1)
          LOCATE y, x: PRINT text$
          LOCATE y1, x1: PRINT STRING$(nlen - LEN(text$), fill$)
          x1 = x1 - 1
        END IF
  END SELECT

 END IF

 IF TIMER > blnk! THEN
  IF visible = 1 THEN LOCATE y1, x1: PRINT fill$ ELSE LOCATE y1, x1: PRINT curs$
  blnk! = TIMER + .1
  visible = visible XOR 1
 END IF
LOOP

SpInput$ = text$
END FUNCTION

SUB Town
DO
nm = loaddpf("town.dpf")

ch = menu(cmenu$(), smenu$(), nm)
pause .2
SELECT CASE ch
  CASE 0: forest
  CASE 2: armour
  CASE 3: weapons
  CASE 4: bank
  CASE 7
    IF user.plevel = (user.pexpr / 30) THEN
      disp "%f7Your level goes up by one."
      disp "%f7Because of your training, you now have 6 more hit points."
      disp "%f7You feel more refreshed."
      user.pmhits = user.pmhits + 6
      user.phits = user.pmhits
      user.plevel = user.plevel + 1
      IF user.plevel > 4 THEN user.plevel = 4
      waitkey
    ELSE
      disp "%f7I cannot teach you because you do not have enough experience."
      disp "%f7You will need " + cvt$((user.plevel) * 30) + " experience before"
      disp "%f7I can teach you."
      waitkey
    END IF
  CASE 8: viewstats
  CASE 9: endgame 1
END SELECT
LOOP
END SUB

SUB viewstats
disp "%f2Name: %f<" + pname$                     'Name
LOCATE CSRLIN - 1, 25
disp "%f2Race: %f<" + prname$                    'Race
LOCATE CSRLIN - 1, 50
disp "%f2Occupation: %f<" + pjname$              'Job
'New line
disp "%f2Alignment: %f<" + findalign$            'Alignment
LOCATE CSRLIN - 1, 25
disp "%f2Max level: %f<" + cvt$(user.plevel)     'Max level
LOCATE CSRLIN - 1, 50
disp "%f2Experience: %f<" + cvt$(user.pexpr)     'Experience
'New line
disp "%f2Gold on hand: %f<" + cvt$(user.pgold)   'Gold in hand
LOCATE CSRLIN - 1, 25
disp "%f2Gold in bank: %f<" + cvt$(user.pbank)   'Gold in bank
LOCATE CSRLIN - 1, 50
disp "%f2Fights left: %f<" + cvt$(user.pfights)  'Fights left
'New line
disp "%f2Weapon: %f<" + wpname$(user.pweapon)    'Weapon
LOCATE CSRLIN - 1, 25
disp "%f2Armour: %f<" + amname$(user.parmour)    'Armour
LOCATE CSRLIN - 1, 50
disp "%f2You are " + findbeauty$ + "."           'Sex and attractivness
'New line
PRINT
disp "%f2Eyesight: %f<" + cvt$(user.peye) + "/" + cvt$(user.pmeye)   'Eyesight
LOCATE CSRLIN - 1, 25
disp "%f2Speed: %f<" + cvt$(user.pspeed) + "/" + cvt$(user.pmspeed)  'Speed
LOCATE CSRLIN - 1, 50
disp "%f2Strength: %f<" + cvt$(user.pstrn) + "/" + cvt$(user.pmstrn) 'Strength
'New line
disp "%f2Endurance: %f<" + cvt$(user.pendr) + "/" + cvt$(user.pmendr)'Endurance
LOCATE CSRLIN - 1, 25
disp "%f2Hit strength: %f<" + cvt$(user.phits) + "/" + cvt$(user.pmhits)'Hit strength

LOCATE CSRLIN - 1, 50
IF user.pjob < 4 THEN
 disp "%f2Spell strength: %f<" + cvt$(user.pspell) + "/" + cvt$(user.pmspell) 'Spell strength
ELSE
 disp "%f2Hand agility: %f<" + cvt$(user.phand) + "/" + cvt$(user.pmhand)  'Hand agility
END IF
'New line
PRINT
special$ = "No special skills"
IF user.prace = 5 THEN special$ = "Excellent thievery skills."
IF user.prace = 7 THEN special$ = "Wings to fly where others cannot go."
disp "%f2Speciality: %f>" + special$     'Special skills
PRINT
PRINT
PRINT
PRINT
PRINT
PRINT
PRINT
PRINT
PRINT
PRINT
PRINT
PRINT
PRINT
waitkey
END SUB

SUB waitkey
disp "%f7Press a key..."
DO: LOOP UNTIL INKEY$ = ""
w$ = INPUT$(1)
END SUB

SUB weapons
DO
nm = loaddpf("weapons.dpf")

ch = menu(cmenu$(), smenu$(), nm)
pause .2
SELECT CASE ch
  CASE 0: buyweapon
  CASE 1: blnk = sellweapon
  CASE 2: viewstats
  CASE 3: EXIT DO
END SELECT
LOOP

END SUB

FUNCTION yesno
DO
 a$ = INKEY$
 IF a$ = "Y" OR a$ = "y" THEN
   PRINT "yes"
   yesno = 1
   pause .2
   EXIT DO
 END IF
 IF a$ = "N" OR a$ = "n" THEN
   PRINT "no"
   yesno = 0
   pause .2
   EXIT DO
 END IF
LOOP
END FUNCTION

SUB youlost (bg, fl)
disp "%f2" + bname$(bg, fl) + " slaughtered you!"
disp "%nYou lose!"
disp "%n%n%f7You will return with %f?" + cvt$(user.pmhits / 2) + "%f7/%f?" + cvt$(user.pmhits) + "%f7 health."
waitkey
disp "%n%x%f7Do you wish to play again?"
IF yesno = 0 THEN endgame 0
user.phits = user.pmhits / 2
END SUB

SUB youwon (bg, fl)
user.pfights = user.pfights - 1
disp "%n%f2You won the fight!"
disp "%f2" + deathw$(bg, fl)
disp "%n%f2It seems that " + bname$(bg, fl) + " dropped " + cvt$(bguy.bgold) + " gold."
disp "%f2You pick it up. You got " + cvt$(bguy.bexpr) + " experience from this fight."

IF bguy.bexpr = 0 THEN
   disp "%f?You can't gain anymore experience on this level."
ELSE
   IF (user.pstrn < user.pmstrn) AND (user.pstrn < (user.pexpr / 5)) THEN
      user.pstrn = user.pstrn + 1
      disp "%f2Your strength goes up by one."
   END IF
END IF

user.pgold = user.pgold + bguy.bgold
user.pexpr = user.pexpr + bguy.bexpr
waitkey
END SUB

