UNIT Road;

interface
(************************** 3D PROCS SECTION *****************************)
Uses NETUNIT;
Const
     ConstSpeed=350;

Type
     timeslot=record
              h   :word;
              m   :word;
              s   :word;
              c   :word;
              end;

     Puntpol= ^pol;

     pol    = record
              Numpol :byte;
              edge   :array[1..4] of word;
              tipo   :byte;
              color  :byte;
              last   :puntpol;
              Next   :puntpol;
              end;

     puntsec= ^sector;

     sector = record
              x,y  :array [0..30] of integer;
              Maxroad:integer;
              Minroad:integer;
              Maxspc :integer;
              Minspc :integer;
              Numsec:word;
              curpn:byte;
              maxpn:byte;
              maxpol:byte;
              Numcar:byte;
              NumSmk:byte;
              NumSpc:byte;
              Special:byte;
              ppolys:puntpol;
              cpolys:puntpol;
              rise :shortint;
              turn :shortint;
              taxis:integer;
              Next :puntsec;
              last :puntsec
              end;

     track = record
             ultimo: puntsec;
             primo : puntsec;
             curs  : puntsec;
             maxsec: integer;
             back  : string[30];
             setgrf: string[30];
             setdat: string[30];
             Special:array[1..8] of string[30];
             end;

Type CamSettings   = record
                     NumSec,X,Y,Z,
                     Angle,Orizont      : integer;
                     Reverse            : boolean;
                     end;
Var
LastWinner                        :byte;
WinCars                           :array[1..9] of byte;
Winners                           :array[1..9] of string[3];
LogoBob                           :word;
TimUrto                           :integer;
Replay                            :File;
ReplayStatus                      :byte;
FFWD,EndReplay,ReplayAval,Oscil   :Boolean;
ReplaySize,ReplayIndex            :Longint;
ReplayBuf                         :pointer;
SegRepBuf,OfsRepBuf               :word;
Ran                               :integer;
Mon1,Mon2,Mon3,Mon4               :integer;
Spia                              :boolean;
DemoRel,MaxCars,Mirror,TimeMirr   :Byte;
GlobalTime                        :longint;
CamSetting                        :array [1..20] of CamSettings;
NumCamPos                         :byte;
Pause                             :boolean;
GRoad                             :track;
ColFra                            :byte;
MsX1Clip,MsX2Clip,
MsY1Clip,MsY2Clip      :array [1..8] of Integer;
AddHan                 :array [1..8] of Integer;
BanDis                 :array [1..8] of integer;

TaddHan                :integer;
AuxY12Clip,AuxY22Clip  :word;
AllCars                :boolean;
Difficulty,DDifficulty :byte;
Rdifficulty            :byte;
GameMode,Detail        :byte;
TypeCon1               :byte;
TypeCon2               :byte;
NumPla                 :byte;
Maxdistance            :integer;
Secdistance            :integer;
Backcol,Backdy,SkyCol  :byte;
Cround,RouAva          :byte;
Carname                :array[1..10] of string[10];
Safe,Safe2             :byte;
CarBandit,CarPl1,CarPl2,BanCar,CopCar,WinCar
                       :byte;

Function SmokeFree: byte;
Function Gangle(Sec:PuntSec):integer;
Function Bit(Value: byte; n:shortint): boolean;
Function ProxCar(NumCar:byte):byte;
Function ProxCar2(NumCar:byte):byte;
Procedure LoadLogo(nBob:word);
Procedure PlaceLogo;
Procedure LoadFFWDTimes;
Procedure SaveFFWDTimes;
Procedure LoadInitReplay;
Procedure SaveInitReplay(Seeker: Byte);
Procedure CloseReplay;
Procedure KillReplay;
Procedure SaveRepFrame;
Function  LoadRepFrame: Boolean;
Procedure InitMisc;
Procedure KillMisc;
Procedure DelSec (var road: track; Num : word);
Procedure Nextsec(var road: track);
Procedure Lastsec(var road: track);
Procedure LoadRoad(var road: track; name: string);
Procedure KillRoad(var road: track);
Procedure TraceRoadCar(NumCar:byte; Y:integer);
Procedure TraceCars(Num,X,Y,Z,Angle,Brise,Cdim,Offset,Azimuth: integer; N:byte);
Procedure TraceSmk (Num,X,Y,Z,Angle,Cdim,Offset,Azimuth: integer; N:byte);
Procedure TraceSign(const num: word; x,y,z,offset,azimuth: integer);
Procedure AdjRevs(Num: byte);
Procedure Settime(var Time:timeslot; h,m,s,c:word);
Procedure Addtime(Var time1,time2:timeslot);
Procedure Subtime(Var time1,time2:timeslot);
Procedure MillToTime(Var Time:TimeSlot; Millisec: Longint);
Function  TimeToStr(Time:TimeSlot):String;
(*************************** CARS PROCS SECTION **************************)

Type
Specials   = record
             Tdobj              :string[12];
             Sample             :string[12];
             Class              :byte;
             Sam,Hide           :boolean;
             Number             :byte;
             Tipo               :byte;
             X,Z,Y              :extended;
             Angle              :integer;
             Speed              :integer;
             img                :shortint;
             SX,SZ,SY           :integer;
             SAngle             :integer;
             SSpeed             :integer;
             Simg               :byte;
             id                 :byte;
             DisPerc            :integer;
             Sec,SSec           :puntSec;
             CurrDist           :integer;
             CurrRise           :integer;
             Reverse,Sreverse   :boolean;
             end;

Smokes     = record
             X,Z,Y  :integer;
             Sec    :puntsec;
             Disperc:integer;
             Img    :byte;
             id     :byte;
             Tipo   :byte;
             end;

Auto       = record
             Points,Chassis      : byte;
             PilotType           : byte;
             Dash,Infos          : boolean;
             Sec                 : puntsec;
             X,Z,Y               : extended;
             Sterzo              : integer;
             intX,intZ,intY      : integer;
             Angle1,Angle2       : integer;
             Velang,DeAngle      : integer;
             Grise,GAngle        : integer;
             Xrot,Zrot           : integer;
             Speed               : integer;
             CurrRise,Sgom       : integer;
             SgomTim,MaxSpd,Accel: Byte;
             CurrDist            : integer;
             Revs1,Revs2         : Longint;
             Gear,SpeedTim       : shortint;
             Trab,Reverse,Ahead  : boolean;
             TrabVal,Mass,Gears  : byte;
             Id                  : byte;
             Sosp                : shortint;
             CPUx,CpuEfX         : integer;
             lsport,rsport       : byte;
             cof,fro,rear        : byte;
             lf,rf,lr,rr         : byte;
             p1rr,p2rr           : byte;
             p3rr,p4rr           : byte;
             p1rl,p2rl           : byte;
             p3rl,p4rl           : byte;
             cx,cy,cz            : integer;
             DisPerc,Wcnt        : integer;
             Wval,ExGear         : Shortint;
             En1,En2             : integer;
             Jump,Automatic,Fin  : boolean;
             Glass,FinPos        : byte;
             Energy              : integer;
             EnergyDec           : integer;
             Team                : Byte;
             end;

Camera     = record
             Mode          : byte;
             Sec           : puntsec;
             X,Z,Y         : extended;
             Angle         : integer;
             GAngle        : integer;
             Grise         : integer;
             CurrRise      : integer;
             CurrDist      : integer;
             Reverse,Enable: boolean;
             DisPerc       : integer;
             Orizont       : integer;
             Speed         : integer;
             end;

Var
(********** TRACE VARS **********************)
Up1,Dw1,Lf1,Rg1,Ba1,Bb1,Up2,Dw2,Lf2,Rg2,Ba2,Bb2 : byte;
px,py                                           : array[0..800] of integer;
chk                                             : array[0..800] of Boolean;
Xsec,Ysec,Zsec,Asec,Cdim,Bsec                   : array[0.. 25] of integer;
edge                                            : array[0..  4] of word;
cnt1,cnt2                                       : integer;
x,z,efx,CurrSecDist                             : integer;
auxx,auxy,auxz,Zrot,Ymy                         : integer;
baserise,rise,BaseAngle,Angle,AdjOffset,Azimuth : integer;
pv2,pv4                                         : integer;
pv1,pv3                                         : longint;
totalpoints,currpoint,edgebase                  : word;
tipo,colr,drawed,StStart                        : byte;
aux1                                            : puntsec;
curpol                                          : puntpol;
Start,Drawing,Flash                             : boolean;
AuxString                                       : string[12];
Mess                                            : array[1..20] of string[24];
MirrMess                                        : array[1..5] of string[6];
TimeMess                                        : word;
(********************************************)
XTrottle,YTrottle          :array[1.. 8] of integer;
Cgear,Han,Lap              :array[1.. 8] of shortint;
LapTime,BestTime           :array[1.. 8] of Timeslot;
RecTime                    :TimeSlot;
RecId                      :string[3];

SfLapTime,SfBestTime       :array[ 1.. 8] of Timeslot;
SfRecTime                  :TimeSlot;
SfStartTime                :array[ 1.. 8] of Longint;
SfGlobalTime               :Longint;

LapTimes,BestTimes         :array[ 1.. 8] of String[4];
RecTimes                   :String[4];
StartTime                  :array[ 1.. 8] of Longint;
Touch                      :array[ 1.. 8] of boolean;
Car                        :array[ 1.. 8] of Auto;

Smoke                      :array[ 1.. 8] of Smokes;
SpecialObj                 :array[21..28] of Specials;
Cam                        :array[ 1.. 8] of Camera;
Extipomess,Tipomess        :array[ 1.. 8] of word;


Function  Position  (Num:byte):byte;
Function  Position2 (Num:byte):boolean;
Procedure TraceDash (Num:byte;YCoor: Word);
Procedure CarNextSec(Num:byte);
Procedure CarLastSec(Num:byte);
Procedure SpecialObjNextSec(Num: byte);
Procedure SpecialObjLastSec(Num: byte);
Procedure LoadChas(NumCar: byte; filename: string);
Procedure CheckCollision(Car1,Car2: byte);
Procedure CheckCollSPC(Carnum,SPCnum: byte);
Procedure LoadCar (NumCar: byte;BaseText: word; NameCar: string);
Procedure LoadCar2(NumCar: byte;BaseText: word; NameCar: string);
Procedure AnimCar(Num:word);

implementation
Uses CRT,DOS,GENERAL,GRAPHICS,SOUND,KEYB,PERSPECT,JOYS,CAMUNIT,PILUNIT,CDUNIT,CDVARS;

(************* TIME FUNCTIONS ********************)
Procedure Settime(var Time:timeslot; h,m,s,c:word);
begin
time.h:=h;
time.m:=m;
time.s:=s;
time.c:=c;
end;

Procedure Addtime(Var time1,time2:timeslot);
var riptime:word;
begin
time1.c:=time1.c+time2.c;
riptime:=time1.c div 100;
time1.c:=time1.c mod 100;
time1.s:=time1.s+time2.s+riptime;
riptime:=time1.s div 60;
time1.s:=time1.s mod 60;
time1.m:=time1.m+time2.m+riptime;
riptime:=time1.m div 60;
time1.m:=time1.m mod 60;
time1.h:=time1.h+time2.h+riptime;
end;

Procedure Subtime(Var time1,time2:timeslot);
var Auxtime,Riptime:integer;
begin
Auxtime:=integer(Time1.c)-integer(Time2.c);
if Auxtime<0 then Riptime:=-1;
Auxtime:=Auxtime mod 100;if Auxtime<0 then inc(Auxtime,100);
Time1.c:=Auxtime;
Auxtime:=integer(Time1.s)-integer(Time2.s)+RipTime;
if Auxtime<0 then Riptime:=-1;
Auxtime:=Auxtime mod 60;if Auxtime<0 then inc(Auxtime,60);
Time1.s:=Auxtime;
Auxtime:=integer(Time1.m)-integer(Time2.m)+RipTime;
if Auxtime<0 then Riptime:=-1;
Auxtime:=Auxtime mod 60;if Auxtime<0 then inc(Auxtime,60);
Time1.m:=Auxtime;
Auxtime:=integer(Time1.h)-integer(Time2.h)+RipTime;
if Auxtime<0 then Auxtime:=0;
Time1.h:=Auxtime;
end;

Function TimeToStr(Time:TimeSlot):String;
Var AStr:String[10];
begin
AStr:='';
AStr:=     Tostr(Time.m,0);if Time.s<10 then AStr:=Astr+'0';
AStr:=AStr+Tostr(Time.s,0);if Time.c<10 then AStr:=Astr+'0';
AStr:=AStr+Tostr(Time.c,0);
TimeToStr:=Astr;
end;

Procedure MillToTime(Var Time:TimeSlot; Millisec: Longint);
Var RipTime:word;
begin
 Time.m :=Millisec div 60000;
 Riptime:=Millisec mod 60000;
 Time.s :=RipTime div 1000;
 RipTime:=RipTime mod 1000;
 Time.c :=RipTime div 10;
end;
(*********** END TIME FUNCTIONS ******************)
(*********** REPLAY FUNCTIONS ********************)

Procedure SaveFFWDTimes;
Var cnt:Byte;
begin
For cnt:=1 to 8 do begin
 SfLaptime  [cnt]:=LapTime [cnt];
 SfBestTime [cnt]:=BestTime[cnt];
 SfStartTime[cnt]:=StartTime[cnt];
end;
 sfRecTime      :=Rectime      ;
 SfGlobalTime:=GlobalTime;
end;

Procedure LoadFFWDTimes;
Var cnt:Byte;
begin
For cnt:=1 to 8 do begin
 Laptime  [cnt]:=SfLapTime  [cnt];
 BestTime [cnt]:=SfBestTime [cnt];
 StartTime[cnt]:=SfStartTime[cnt];
end;
 RecTime      :=sfRectime      ;
 GlobalTime   :=sfGlobalTime;

For cnt:=1 to 8 do begin
 Laptimes [cnt]:=TimeToStr(sfLapTime [cnt]);
 BestTimes[cnt]:=TimeToStr(sfBestTime[cnt]);
end;
 RecTimes      :=TimeToStr(sfRectime      );

end;


Procedure CopyToReplay;
var
  FromF :file;
  Rimane,SizeBytes:Longint;
  Buf: pointer;
  Ok: Boolean;
begin
  Getmem(Buf,2048);
  Assign (FromF, 'Tracks/Replay.Bak'); { Open input file }
  Reset  (FromF, 1);                   { Record size = 1 }
  Assign (Replay,'Tracks/Replay.Dat'); { Open output file }
  Rewrite(Replay,1);                   { Record size = 1 }
  Ok:=False;
  Sizebytes:=0;
  repeat
   Rimane:=(Filesize(FromF)-SizeBytes);
   if Rimane>2048 then begin
    Ok:=False;
    BlockRead (FromF , Buf^, 2048);
    BlockWrite(Replay, Buf^, 2048);
    inc(SizeBytes,2048);
   end else begin
    Ok:=true;
    BlockRead (FromF , Buf^, Rimane);
    BlockWrite(Replay, Buf^, Rimane);
   end;
  until Ok;
  Close(FromF);
  freemem(Buf,2048);
end;

Procedure SaveInitReplay(Seeker: Byte);
Var ReplayBak:File;
begin
 ReplayAval:=((DiskFree(0) div 1000)>1000) and (GameMode<>3);

 EndReplay:=False;

 if Seeker=0 then begin
  Assign(Replay,'Tracks/Replay.DAT');
  Rewrite(Replay,1);
 end else begin
  CopyFile('Tracks/Replay.Dat','Tracks/Replay.bak');
  CopyToReplay;
 end;
 ReplayIndex:=Filesize(Replay);
 ReplaySize :=Filesize(Replay);
end;

Procedure LoadInitReplay;
begin
 ReplayAval:=((DiskFree(0) div 1000)>1000) and (GameMode<>3);
 ReplayIndex:=0;
 EndReplay:=False;
 Assign(Replay,'Tracks/Replay.DAT');
 Reset(Replay,1);
 ReplaySize :=Filesize(Replay);
end;

Procedure CloseReplay;
Begin
Close(Replay);
end;

Procedure KillReplay;
Var F:File;
Begin
Assign(F,'Tracks/Replay.Dat');
Rewrite(F,1);
Close(F);
Assign(F,'Tracks/Replay.Bak');
Rewrite(F,1);
Close(F);
end;

Procedure SaveRepFrame;
Var cnt:Byte;
Begin
 if ReplayAval then begin
 For cnt:=1 to NumPla do begin
  MemW[SegRepBuf:OfsRepBuf+(cnt-1)*5+0]:=Xtrottle[cnt];
  MemW[SegRepBuf:OfsRepBuf+(cnt-1)*5+2]:=Ytrottle[cnt];
  Mem [SegRepBuf:OfsRepBuf+(cnt-1)*5+4]:=Cgear   [cnt];
 end;
  Blockwrite(Replay,ReplayBuf^,8*NumPla);
  inc(ReplayIndex,8*NumPla);
  inc(ReplaySize,8*NumPla);
 end;
end;

Function LoadRepFrame: Boolean;
Var cnt:Byte;
Begin
 LoadRepFrame:=True;
 inc(ReplayIndex,8*NumPla);
 Blockread(Replay,ReplayBuf^,8*NumPla);
 For cnt:=1 to NumPla do begin
  Xtrottle[cnt]:=MemW[SegRepBuf:OfsRepBuf+(cnt-1)*5+0];
  Ytrottle[cnt]:=MemW[SegRepBuf:OfsRepBuf+(cnt-1)*5+2];
  Cgear   [cnt]:=Mem [SegRepBuf:OfsRepBuf+(cnt-1)*5+4];
 end;
 if Eof(Replay) then begin
  LoadRepFrame:=False;
  EndReplay:=True
 end
end;

(*********** END REPLAY FUNCTIONS ****************)
Procedure LoadLogo(nBob:word);
begin
LogoBob:=Nbob;
Lbob('Pics\WorScrip.pcx','Data\WorScrip.dat',LogoBob);
end;

Procedure PlaceLogo;
begin
Bob(LogoBob,161 shl SVGA-GetHx(LogoBob) div 2,5 shl SVGA);
end;

Procedure AdjRevs(Num: byte);
begin
if Car[Num].Gear=0 then exit;
if sgn(Car[Num].Speed)=-sgn(Car[Num].Gear) then
     Car[Num].Revs1:=-Car[Num].Speed*25 div Car[Num].Gear
else Car[Num].Revs1:= Car[Num].Speed*25 div Car[Num].Gear
end;

Procedure Ammacca(NumCar:byte; xa,za:integer);
Var Def              :Boolean;
    ObjD,ObjA,Cnt    :Word;
    x,y,z,
    x1,y1,z1,x2,y2,z2,
    x3,y3,z3,x4,y4,z4:integer;
    fcseg,fcofs      :word;
begin
ObjD:=NumCar;
ObjA:=NumCar+30;

fcseg:=seg(objs[ObjD].faces^);
fcofs:=ofs(objs[ObjD].faces^);

For Cnt:=1 To Objs[ObjD].Npoint-1 do begin
 GetPoint(OBjD,Cnt,x3,y3,z3);

 Def:=(z3<za+35) and
      (x3>xa-35) and
      (z3>za-35) and
      (x3<xa+35);

 if Def then begin
  GetPoint(OBjA,Cnt,x4,y4,z4);
  x1:=(x3+x4) div 2;
  y1:=(y3+y4) div 2;
  z1:=(z3+z4) div 2;
  ChgPoint(ObjD,Cnt,x1,y1,z1);
 end
end;

for cnt:=0 to Objs[ObjD].nfaces-1 do begin
 tipo:=mem[fcseg:fcofs+cnt*6+4];
 colr:=mem[fcseg:fcofs+cnt*6+5];
 if (tipo>2) and (tipo<10) then begin
  GetPoint(OBjd,mem[fcseg:fcofs+cnt*6+0]+1,x1,y1,z1);
  GetPoint(OBjd,mem[fcseg:fcofs+cnt*6+1]+1,x2,y2,z2);
  GetPoint(OBjd,mem[fcseg:fcofs+cnt*6+2]+1,x3,y3,z3);
  GetPoint(OBjd,mem[fcseg:fcofs+cnt*6+3]+1,x4,y4,z4);
  x:=(x1+x2+x3+x4) div 4;
  z:=(z1+z2+z3+z4) div 4;

  Def:=(z>za-40) and (x>xa-40) and
       (z<za+40) and (x<xa+40);

  if Def then begin
               if (Colr=1) or (Colr=2) then begin
               CopyBob(Objs[Objd].Bstx+501,Objs[Objd].Bstx+1);
               CopyBob(Objs[Objd].Bstx+502,Objs[Objd].Bstx+2);
               end else
               CopyBob(Objs[Objd].Bstx+Colr+500,Objs[Objd].Bstx+Colr);
              end
 end
end
end;

Procedure CheckCollision(Car1,Car2: byte);
var  Dx1,Dz1,Dx2,Dz2,Acos,Asen,X1,Z1,X2,Z2,Dx,Dz,DeSpeed,Aux,Deangle :integer;

begin
if Abs(integer(Car[Car1].Sec^.NumSec)-integer(Car[Car2].Sec^.NumSec))<2 then begin
 if (abs(Car[Car1].IntY-Car[Car2].IntY)>40) then exit;
 if Car[Car1].Sec^.NumSec>Car[Car2].Sec^.NumSec then begin
  X1:=Car[Car1].IntX;
  Z1:=Car[Car1].IntZ+SecDistance;
  X2:=Car[Car2].IntX;
  Z2:=Car[Car2].IntZ
 end else
 if Car[Car1].Sec^.NumSec<Car[Car2].Sec^.NumSec then begin
  X1:=Car[Car1].IntX;
  Z1:=Car[Car1].IntZ;
  X2:=Car[Car2].IntX;
  Z2:=Car[Car2].IntZ+SecDistance;
 end else begin
  X1:=Car[Car1].IntX;
  Z1:=Car[Car1].IntZ;
  X2:=Car[Car2].IntX;
  Z2:=Car[Car2].IntZ
 end;

   Dx:=(X2-X1);
   Dz:=(Z1-Z2);

   if Car[Car1].Reverse=Car[Car2].Reverse
   then DeSpeed:=abs(Car[Car2].Speed-Car[Car1].Speed) div 2
   else DeSpeed:=abs(Car[Car2].Speed+Car[Car1].Speed) div 2;

 if  ((GameMode=2) and
 ((Car[Car1].Team=1)      and (Car[Car2].Team=2)          and
   Car[Car1].Reverse      and (abs(Car[Car1].Angle2)<450) and
  (Car[Car1].PilotType>0) and (Car[Car1].PilotType<4)) or
 ((Car[Car2].Team=1)      and (Car[Car1].Team=2)          and
   Car[Car2].Reverse      and (abs(Car[Car2].Angle2)<450) and
  (Car[Car2].PilotType>0) and (Car[Car2].PilotType<4)))then exit;

 if abs(Dx)+abs(Dz)<200+abs(DeSpeed) div 2 then begin

   Deangle:=(Car[Car1].Angle1-Car[Car2].Angle1) div 10 mod 360;
   if Deangle<0 then inc(Deangle,360);

   if (abs(Dx)<40+abs(sn[Deangle]) shl 1 div 3) and
      (abs(Dz)<40+abs(cs[Deangle]) shl 1 div 3) then begin

   if Car[Car1].Reverse then Angle:=180+Car[Car1].Angle1 div 10
                        else Angle:=    Car[Car1].Angle1 div 10;

   Angle:=Angle mod 360; if Angle<0 then inc(Angle,360);

   Acos:=Cs[Angle];
   Asen:=Sn[Angle];
   Aux:=trunc(Sqrt(Sqr(Dx)+sqr(Dz)))+1;
   Dz:=Dz*55 div Aux;
   Dx:=Dx*55 div Aux;
   Dz1:=integer(Dz*Asen+Dx*Acos) div 128;
   Dx1:=integer(Dz*Acos-Dx*Asen) div 128;

   if Car[Car2].Reverse then Angle:=180+Car[Car2].Angle1 div 10
                        else Angle:=    Car[Car2].Angle1 div 10;

   Angle:=Angle mod 360; if Angle<0 then inc(Angle,360);

   Dx:=(X1-X2);
   Dz:=(Z2-Z1);

   Acos:=Cs[Angle];
   Asen:=Sn[Angle];
   Dz:=Dz*55 div Aux;
   Dx:=Dx*55 div Aux;
   Dz2:=integer(Dz*Asen+Dx*Acos) div 128;
   Dx2:=integer(Dz*Acos-Dx*Asen) div 128;

   Dx:=(X1-X2) div 6;
   Dz:=(Z1-Z2) div 6;

   inc(Car[Car1].intX,Dx);
   dec(Car[Car2].intX,Dx);
   inc(Car[Car1].intZ,Dz);
   dec(Car[Car2].intZ,Dz);
   Car[Car1].X:=Car[Car1].intX;
   Car[Car1].Z:=Car[Car1].intZ;
   Car[Car2].X:=Car[Car2].intX;
   Car[Car2].Z:=Car[Car2].intZ;
   if Car[Car1].Reverse=Car[Car2].Reverse then begin
    Swp(Car[Car1].Speed,Car[Car2].Speed);
    Car[Car1].Speed:=Car[Car1].Speed;
    Car[Car2].Speed:=Car[Car2].Speed;
    Aux:= sgn(dz) shl 3;
    inc(Car[Car1].Velang,Car[Car1].Speed *Aux div Car[Car1].Mass);
    Aux:=-sgn(dz) shl 3;
    inc(Car[Car2].Velang,Car[Car2].Speed *Aux div Car[Car2].Mass);
    AdjRevs(Car1);
    AdjRevs(Car2);
   end else begin
    Swp(Car[Car1].Speed,Car[Car2].Speed);
    Car[Car1].Speed:=-Car[Car1].Speed;
    Car[Car2].Speed:=-Car[Car2].Speed;
    Aux:= sgn(dz) shl 3;
    inc(Car[Car1].Velang,Car[Car1].Speed *Aux div Car[Car1].Mass);
    Aux:=-sgn(dz) shl 3;
    inc(Car[Car2].Velang,Car[Car2].Speed *Aux div Car[Car2].Mass);
    AdjRevs(Car1);
    AdjRevs(Car2);

    if (Car[Car1].Revs1<0)    or (Car[Car1].Revs2<0)    then begin
     Car[Car1].Revs1:=0;
     Car[Car1].Revs2:=0
    end else
    if (Car[Car1].Revs1>4000) or (Car[Car1].Revs2>4000) then begin
     Car[Car1].Revs1:=4000;
     Car[Car1].Revs2:=4000
    end;
    if (Car[Car2].Revs1<0)    or (Car[Car2].Revs2<0)    then begin
     Car[Car2].Revs1:=0;
     Car[Car2].Revs2:=0
    end else
    if (Car[Car2].Revs1>4000) or (Car[Car2].Revs2>4000) then begin
     Car[Car2].Revs1:=4000;
     Car[Car2].Revs2:=4000
    end;
   end;

   if DeSpeed>10 then begin
                       if Despeed>20 then begin
                         Ammacca(Car1,dx1,dz1);
                         Ammacca(Car2,dx2,dz2);
                       end;
                        if (Car[Car1].PilotType=1) or
                           (Car[Car1].PilotType=2) or
                           (Car[Car1].PilotType=3)
                        then begin
                          if ((Car[Car1].Team=1) and (Car[Car2].Team=0)) or
                             ((Car[Car1].Team=2) and (Car[Car2].Team=1)) and (abs(Car[Car1].Speed)>30) and (Timurto>20)
                             then begin Timurto:=0; dec(Car[Car1].Energy,DeSpeed*2 div 3) end;
                        end else begin
                          if ((Car[Car1].Team=1) and (Car[Car2].Team=0)) or
                             ((Car[Car1].Team=2) and (Car[Car2].Team=1)) and (abs(Car[Car1].Speed)>30) and (Timurto>20)
                             then begin Timurto:=0; dec(Car[Car1].Energy,DeSpeed*2 div 3) end;
                        end;
                        if (Car[Car2].PilotType=1) or
                           (Car[Car2].PilotType=2) or
                           (Car[Car2].PilotType=3)
                        then begin
                          if ((Car[Car2].Team=1) and (Car[Car1].Team=0)) or
                             ((Car[Car2].Team=2) and (Car[Car1].Team=1)) and (abs(Car[Car1].Speed)>30) and (Timurto>20)
                             then begin Timurto:=0; dec(Car[Car2].Energy,DeSpeed*2 div 3) end;
                        end else begin
                          if ((Car[Car2].Team=1) and (Car[Car1].Team=0)) or
                             ((Car[Car2].Team=2) and (Car[Car1].Team=1)) and (abs(Car[Car1].Speed)>30) and (Timurto>20)
                             then begin Timurto:=0; dec(Car[Car2].Energy,DeSpeed*2 div 3) end;
                        end;
                        if Despeed>40 then begin
                         Despeed:=40;
                         if not Car[Car1].Jump then begin
                          Car[Car1].En1 :=DeSpeed div 4;
                          Car[Car1].Jump:=true;
                         end;
                         if not Car[2].Jump then begin
                          Car[Car2].Jump:=true;
                          Car[Car2].En1 :=DeSpeed div 4;
                         end;
                        end;
                       end;

     if (Dx1> 30) and (Dz1> 15) then inc(Car[Car1].Velang,DeSpeed shl 4 div Car[Car1].Mass) else
     if (Dx1<-30) and (Dz1<-15) then inc(Car[Car1].Velang,DeSpeed shl 4 div Car[Car1].Mass) else
     if (Dx1> 30) and (Dz1<-15) then dec(Car[Car1].Velang,DeSpeed shl 4 div Car[Car1].Mass) else
     if (Dx1<-30) and (Dz1> 15) then dec(Car[Car1].Velang,DeSpeed shl 4 div Car[Car1].Mass) ;

     if (Dx2> 30) and (Dz2> 15) then inc(Car[Car2].Velang,DeSpeed shl 4 div Car[Car2].Mass) else
     if (Dx2<-30) and (Dz2<-15) then inc(Car[Car2].Velang,DeSpeed shl 4 div Car[Car2].Mass) else
     if (Dx2> 30) and (Dz2<-15) then dec(Car[Car2].Velang,DeSpeed shl 4 div Car[Car2].Mass) else
     if (Dx2<-30) and (Dz2> 15) then dec(Car[Car2].Velang,DeSpeed shl 4 div Car[Car2].Mass) ;

   if ((Car[Car1].Team=1) and (Car[Car2].Team=2)) then Safe2:=Car1;
   if ((Car[Car2].Team=1) and (Car[Car1].Team=2)) then Safe2:=Car2;

   if (GameMode<>2) then begin
    if Car[Car1].PilotType>0 then dec(Car[Car1].Energy,DeSpeed div 4);
    if Car[Car2].PilotType>0 then dec(Car[Car2].Energy,DeSpeed div 4);
   end;

   if Car[Car1].Energy<0 then Car[Car1].Energy:=0;
   if Car[Car2].Energy<0 then Car[Car2].Energy:=0;

   if ((GameMode<>3) and
      ((Car[Car1].PilotType=1) or (Car[Car1].PilotType=2) or (Car[Car1].PilotType=3) or
       (Car[Car2].PilotType=1) or (Car[Car2].PilotType=2) or (Car[Car2].PilotType=3))) or
      ((GameMode=3) and ((Car1=Myslot) or (Car2=Myslot)))
   then begin
    playsample(4,6,48,70,100);
      if (Car[Car1].Speed>160) or (Car[Car2].Speed>160) then begin
       inc(ColFra,Random(2)+1);if ColFra>6 then ColFra:=0;
       if ColFra=0 then PlaySampleHd('Samples\YouCrazy.raw',False) else
       if ColFra=1 then PlaySampleHd('Samples\haha.raw'    ,False) else
       if ColFra=2 then PlaySampleHd('Samples\SlowDown.raw',False) else
       if ColFra=3 then PlaySampleHd('Samples\Banzai.raw'  ,False) else
       if ColFra=5 then PlaySampleHd('Samples\AirBag.raw'  ,False) else
       if ColFra=4 then PlaySampleHd('Samples\wowo.raw'    ,False) else
       if ColFra=6 then PlaySampleHd('Samples\Helpme.raw'  ,False)
      end
     end;
  end
  end
 end
end;

Procedure CheckCollSPC(CARnum,SPCnum: byte);
var  Dx1,Dz1,Dx2,Dz2,Acos,Asen,X1,Z1,X2,Z2,Dx,Dz,DeSpeed,Aux,Deangle :integer;
begin
if Abs(integer(Car[CarNum].Sec^.NumSec)-integer(SpecialObj[SpcNum].Sec^.NumSec))<2 then begin

 if Car[CarNum].Sec^.NumSec>SpecialObj[SPCNum].Sec^.NumSec then begin
  X1:=Car[CarNum].IntX;
  Z1:=Car[CarNum].IntZ+SecDistance;
  X2:=Trunc(SpecialObj[SpcNum].X);
  Z2:=Trunc(SpecialObj[SpcNum].Z)
 end else
 if Car[CarNum].Sec^.NumSec<SpecialObj[SPCNum].Sec^.NumSec then begin
  X1:=Car[CarNum].IntX;
  Z1:=Car[CarNum].IntZ;
  X2:=Trunc(SpecialObj[SpcNum].X);
  Z2:=Trunc(SpecialObj[SpcNum].Z)+SecDistance;
 end else begin
  X1:=Car[CarNum].IntX;
  Z1:=Car[CarNum].IntZ;
  X2:=Trunc(SpecialObj[SpcNum].X);
  Z2:=Trunc(SpecialObj[SpcNum].Z)
 end;

 Dx:=(X2-X1);
 Dz:=(Z1-Z2);
 if Car[CarNum].Reverse=SpecialObj[SpcNum].Reverse
   then DeSpeed:=abs(Car[CarNum].Speed-SpecialObj[SpcNum].Speed) div 2
   else DeSpeed:=abs(Car[CarNum].Speed+SpecialObj[SpcNum].Speed) div 2;

 if (abs(Dx)+abs(Dz)<200+DeSpeed) and
    ((Car[CarNum].PilotType=1) or (Car[CarNum].PilotType=2) or (Car[CarNum].PilotType=3)) or
    (abs(Dx)+abs(Dz)<50+DeSpeed div 2) then begin

  Deangle:=(Car[CarNum].Angle1 div 10-SpecialObj[SpcNum].Angle) mod 360;
  if Deangle<0 then inc(Deangle,360);

  if (abs(Dx)<50+abs(sn[Deangle]) shl 1 div 3) and
     (abs(Dz)<50+abs(cs[Deangle]) shl 1 div 3) then begin

   if Car[CarNum].Reverse then Angle:=180+Car[CarNum].Angle1 div 10
                          else Angle:=    Car[CarNum].Angle1 div 10;

   Angle:=Angle mod 360; if Angle<0 then inc(Angle,360);

   Acos:=Cs[Angle];
   Asen:=Sn[Angle];
   Aux:=trunc(Sqrt(Sqr(Dx)+sqr(Dz)))+1;
   Dz:=Dz*55 div Aux;
   Dx:=Dx*55 div Aux;
   Dz1:=integer(Dz*Asen+Dx*Acos) div 120;
   Dx1:=integer(Dz*Acos-Dx*Asen) div 120;

   if SpecialObj[SpcNum].Reverse then Angle:=180+SpecialObj[SpcNum].Angle
                                 else Angle:=    SpecialObj[SpcNum].Angle;

   Angle:=Angle mod 360; if Angle<0 then inc(Angle,360);

   Dx:=(X1-X2);
   Dz:=(Z2-Z1);

   Acos:=Cs[Angle];
   Asen:=Sn[Angle];
   Aux:=trunc(Sqrt(Sqr(Dx)+sqr(Dz)));
   Dz:=Dz*55 div Aux;
   Dx:=Dx*55 div Aux;
   Dz2:=integer(Dz*Asen+Dx*Acos) div 128;
   Dx2:=integer(Dz*Acos-Dx*Asen) div 128;

   Dx:=(X1-X2) div 6;
   Dz:=(Z1-Z2) div 6;

   inc(Car[CarNum].intX,Dx);
   inc(Car[CarNum].intZ,Dz);

(* SpecialObj[SpcNum].X:=SpecialObj[NumSpc].X-Dx;
   SpecialObj[SpcNum].Z:=SpecialObj[NumSpc].Z-DZ;  *)

   Car[CarNum].X:=Car[CarNum].intX;
   Car[CarNum].Z:=Car[CarNum].intZ;

   if Car[CarNum].Reverse=SpecialObj[SpcNum].Reverse then begin
    swp(Car[CarNum].Speed,SpecialObj[SpcNum].Speed);
    Car[CarNum].Speed:=Car[CarNum].Speed div (3+Car[CarNum].Mass div 6);
    SpecialObj[SpcNum].Speed:=Min(SpecialObj[SpcNum].Speed,30);
    AdjRevs(CarNum);

   end else begin
    swp(Car[CarNum].Speed,SpecialObj[SpcNum].Speed);
    Car[CarNum].Speed:=-Car[CarNum].Speed div (3+Car[CarNum].Mass div 6);
    SpecialObj[SpcNum].Speed:=-Min(SpecialObj[SpcNum].Speed,30);
   end;

   if (Car[CarNum].Revs1<   0) or (Car[CarNum].Revs2<   0) then begin
    Car[CarNum].Revs1:=0;
    Car[CarNum].Revs2:=0
   end else
   if (Car[CarNum].Revs1>4000) or (Car[CarNum].Revs2>4000) then begin
    Car[CarNum].Revs1:=4000;
    Car[CarNum].Revs2:=4000
   end;

   if DeSpeed>40 then begin
                       Ammacca(CarNum,dx1,dz1);
                       Despeed:=40;
                      end;

   if Car[CarNum].PilotType<>0 then dec(Car[CarNum].Energy,DeSpeed div 10);
   if Car[CarNum].Energy<0 then Car[CarNum].Energy:=0;

   if (Car[CarNum].PilotType=1) or
      (Car[CarNum].PilotType=2) or
      (Car[CarNum].PilotType=3) then playsample(4,6,48,70,100);
  end
 end
end
end;

Procedure LoadAttr(NumCar :byte; Filename: String);
var F:File;
begin
Assign(f,Filename);
reset(f,1);
blockread(f,Car[NumCar].MaxSpd,1);
blockread(f,Car[NumCar].Accel ,1);
blockread(f,Car[NumCar].Mass  ,1);
blockread(f,Car[NumCar].Energy,1);
blockread(f,Car[NumCar].Gears ,1);
Car[NumCar].EnergyDec:=Car[NumCar].Energy;
close(f);
end;

Procedure LoadChas(NumCar :byte; filename: string);
var f: file;
begin
Assign(f,filename);
reset(f,1);
blockread(f,Car[NumCar].lsport,1);
blockread(f,Car[NumCar].rsport,1);
blockread(f,Car[NumCar].cof   ,1);
blockread(f,Car[NumCar].fro   ,1);
blockread(f,Car[NumCar].rear  ,1);
blockread(f,Car[NumCar].lf    ,1);
blockread(f,Car[NumCar].rf    ,1);
blockread(f,Car[NumCar].lr    ,1);
blockread(f,Car[NumCar].rr    ,1);
blockread(f,Car[NumCar].p1rr  ,1);
blockread(f,Car[NumCar].p2rr  ,1);
blockread(f,Car[NumCar].p3rr  ,1);
blockread(f,Car[NumCar].p4rr  ,1);
blockread(f,Car[NumCar].p1rl  ,1);
blockread(f,Car[NumCar].p2rl  ,1);
blockread(f,Car[NumCar].p3rl  ,1);
blockread(f,Car[NumCar].p4rl  ,1);
close(f);
end;

Function Bit(Value: byte; n:shortint): boolean;
var Fatt: byte;
begin
Fatt:=1 shl (n-1);
Bit:=Value and fatt=fatt;
end;

Procedure TraceSign(const num: word; x,y,z,offset,azimuth: integer);
var
px,py                    : integer;
ex,ey,ez                 : integer;
cnt,cnt1                 : integer;

begin
if (abs(x)>z shr 3+400) or (Z<100) then exit;
 ez:=z;
 if ez>20 then begin
  ez:=ez shr 3+1;
  ex:=x;
  ey:=y;
  px:=integer(ex shl 5 div ez) shl SVGA+offset -GetHx(Num) shr 1;
  py:=integer(ey shl 5 div ez) shl SVGA+azimuth-GetHy(Num);
  if (px<-200)then px:=-200 else
  if (px> 720)then px:= 720;
  if GameMode=3 then begin
   if (Ez>60) and (ez<150) then Text(px+5 shl SVGA,py+5 shl SVGA,Ids[Num],true)
  end else Bob(Num,Px,Py);
 end;
end;

Procedure TraceCars(Num,X,Y,Z,Angle,Brise,Cdim,Offset,Azimuth: integer; N:byte);
var AuxX,AuxZ,ExAngle: integer;
    AuxAngle         : integer;
    k,k1,SmkFree     : byte;

begin
 ExAngle:=Angle;
 for K:=1 to MaxCars do if bit(N,K) and (Num<>K) then begin

  if (Car[K].Sgom>0) or (Car[k].Energy<20) or (Car[k].EnergyDec>Car[k].Energy) then begin
   SmkFree:=SmokeFree;
    if Smoke[SmkFree].img=0 then begin
    if (Car[k].Energy<20) or (Car[k].EnergyDec>Car[k].Energy) then Smoke[SmkFree].Tipo:=1 else Smoke[SmkFree].Tipo:=0;
    Smoke[SmkFree].Sec:=Car[K].Sec;
    K1:=sgn(Car[k].Speed);
    if Car[k].reverse then begin
     Smoke[SmkFree].x:=Car[K].intX+cs[Car[k].Angle2 div 10+270]*K1 div 2;
     Smoke[SmkFree].z:=Car[K].intZ-sn[Car[k].Angle2 div 10+270]*K1 div 2;
    end else begin
     Smoke[SmkFree].x:=Car[K].intX+cs[Car[k].Angle2 div 10+ 90]*K1 div 2;
     Smoke[SmkFree].z:=Car[K].intZ-sn[Car[k].Angle2 div 10+ 90]*K1 div 2;
    end;
    Smoke[SmkFree].y:=Car[K].intY;
    Smoke[SmkFree].DisPerc:=Car[K].Disperc;
    Smoke[SmkFree].img:=1;
    inc(Smoke[SmkFree].Sec^.NumSmk,Smoke[SmkFree].id);
   end
  end;

  Angle:=ExAngle mod 360; if Angle<0 then inc(Angle,360);
  AuxZ:=integer((longint(Car[K].IntZ-Cdim*Car[K].DisPerc div 10)*cs[360-Angle]+
                 longint(Car[K].IntX)                           *sn[360-Angle])div 128)+Z;

  if AuxZ<1000 then begin K1:=K;AnimCar(K1) end else K1:=K+10;

  AuxX:=integer((longint(Car[K].IntZ-Cdim*Car[K].DisPerc div 10)*sn[360-Angle]-
                 longint(Car[K].IntX)                           *cs[360-Angle])div 128)+X;

  if Car[K].Reverse then begin
   Angle:=(Angle+Car[K].Angle1 div 10+180) mod 360;
   if Angle<0 then inc(Angle,360);
  end else begin
   Angle:=(Angle+Car[K].Angle1 div 10) mod 360;
   if Angle<0 then inc(Angle,360);
  end;
  if Car[Num].Reverse then begin

   If Car[K].Team>0 then
   TraceSign(557+Car[K].Team,AuxX,Y+(10-Car[K].DisPerc)*brise div 150+(Car[Num].Zrot*AuxX) div 150-60,AuxZ,OffSet,Azimuth);
   if GameMode=3 then
   TraceSign(K,AuxX,Y+(10-Car[K].DisPerc)*brise div 150+(Car[Num].Zrot*AuxX) div 150-60,AuxZ,OffSet,Azimuth);
 
   if Car[K].Reverse then begin
    putobj(20,AuxX,Y+(10-Car[K].DisPerc)*brise div 150+(Car[Num].Zrot*AuxX) div 150,
              AuxZ,Angle, Brise div 20            ,0,Offset,Azimuth);
    putobj(K1,AuxX,Y+(10-Car[K].DisPerc)*Brise div 150-(Car[K].intY-39)+(Car[Num].Zrot*AuxX) div 150,
              AuxZ,Angle, Brise div 20+Car[K].Xrot,Car[K].Zrot,Offset,Azimuth);
   end else begin
    putobj(20,AuxX,Y+(10-Car[K].DisPerc)*Brise div 150+(Car[Num].Zrot*AuxX) div 150,
              AuxZ,Angle,-Brise div 20            ,0,Offset,Azimuth);
    putobj(K1,AuxX,Y+(10-Car[K].DisPerc)*Brise div 150-(Car[K].intY-39)+(Car[Num].Zrot*AuxX) div 150,
              AuxZ,Angle,-Brise div 20+Car[K].Xrot,Car[K].Zrot,Offset,Azimuth);
   end
  end else begin

   If Car[K].Team>0 then
   TraceSign(557+Car[K].Team,AuxX,Y-(10-Car[K].DisPerc)*brise div 150+(Car[Num].Zrot*AuxX) div 150-60,AuxZ,OffSet,Azimuth);
   if GameMode=3 then
   TraceSign(K,AuxX,Y+(10-Car[K].DisPerc)*brise div 150+(Car[Num].Zrot*AuxX) div 150-60,AuxZ,OffSet,Azimuth);
   if Car[K].Reverse then begin
    putobj(20,AuxX,Y-(10-Car[K].DisPerc)*Brise div 150+(Car[Num].Zrot*AuxX) div 150,
              AuxZ,Angle,-Brise div 20            ,0,Offset,Azimuth);
    putobj(K1,AuxX,Y-(10-Car[K].DisPerc)*Brise div 150-(Car[K].intY-39)+(Car[Num].Zrot*AuxX) div 150,
              AuxZ,Angle,-Brise div 20+Car[K].Xrot,Car[K].Zrot,Offset,Azimuth);
   end else begin
    putobj(20,AuxX,Y-(10-Car[K].DisPerc)*Brise div 150+(Car[Num].Zrot*AuxX) div 150,
              AuxZ,Angle, Brise div 20            ,0,Offset,Azimuth);
    putobj(K1,AuxX,Y-(10-Car[K].DisPerc)*Brise div 150-(Car[K].intY-39)+(Car[Num].Zrot*AuxX) div 150,
              AuxZ,Angle, Brise div 20+Car[K].Xrot,Car[K].Zrot,Offset,Azimuth);
   end
  end
 end
end;

Function Position (Num:byte):byte;
var Cnt1,Cnt2:byte;
    Distance: array[1..8] of word;
begin
  for cnt1:=1 to MaxCars do Distance[Cnt1]:=(word(Lap[cnt1])*Groad.MaxSec+Car[cnt1].Sec^.NumSec)*14+Car[cnt1].intZ div 10;
  cnt2:=1;
  for cnt1:=1 to MaxCars do if Distance[Num]<Distance[Cnt1]then Inc(Cnt2);
  Position:=Cnt2;
end;

Function Position2(Num:byte):boolean;
var Cnt1,Cnt2,b:byte;
    Distance: array[1..8] of word;
begin
  B:=Bancar;
  Distance[num]:=(word(Lap[num]+2)*Groad.MaxSec+Car[num].Sec^.NumSec)*14+Car[num].intZ div 10;
  Distance[b]:=(word(Lap[b])*Groad.MaxSec+Car[b].Sec^.NumSec)*14+Car[b].intZ div 10;
  Position2:=False;
  if (Distance[num]>Distance[b]) then Position2:=true;
end;

Procedure TraceSPC(Num,X,Y,Z,Angle,Brise,Cdim,Offset,Azimuth: integer; N:byte; Hide:Boolean);
var AuxX,AuxZ,ExAngle :integer;
    k,k1              :byte;
    Volume            :integer;

begin
ExAngle:=Angle;
 for K:=1 to 8 do if bit(N,K) and ((SpecialObj[K+20].Class=2)=Hide) then begin
  K1:=K+20;
  if NumPla=1 then begin
   if Z>0 then Volume:=42-(abs(x)+z) div 200 else Volume:=42+z div 10;
   if Volume<0 then Volume:=0;
   if (Ch[4].StAlert=0) And SpecialObj[K1].Sam then PlaySample(4,K1-10,Volume,120,0) else Ch[4].Vl:=Volume;
  end;
  Angle:=ExAngle mod 360; if Angle<0 then inc(Angle,360);
  AuxZ:=integer((longint(trunc(SpecialObj[K1].Z)-Cdim*SpecialObj[K1].DisPerc div 10)*cs[360-Angle]+
                 longint(trunc(SpecialObj[K1].X))                                   *sn[360-Angle])div 128)+Z;

  AuxX:=integer((longint(trunc(SpecialObj[K1].Z)-Cdim*SpecialObj[K1].DisPerc div 10)*sn[360-Angle]-
                 longint(trunc(SpecialObj[K1].X))                                   *cs[360-Angle])div 128)+X;

  if SpecialObj[K1].Reverse then begin
   Angle:=(Angle+SpecialObj[K1].Angle+180) mod 360;
   if Angle<0 then inc(Angle,360);
  end else begin
   Angle:=(Angle+SpecialObj[K1].Angle) mod 360;
   if Angle<0 then inc(Angle,360);
  end;

 if Car[Num].Reverse then begin
  if SpecialObj[k1].Reverse then
    putobj(K1,AuxX,Y+(10-SpecialObj[K1].DisPerc)*Brise div 150-trunc(SpecialObj[K1].Y)+(Car[Num].Zrot*AuxX) div 150,
              AuxZ,Angle, Brise div 20,0,Offset,Azimuth)
  else
    putobj(K1,AuxX,Y+(10-SpecialObj[K1].DisPerc)*Brise div 150-trunc(SpecialObj[K1].Y)+(Car[Num].Zrot*AuxX) div 150,
              AuxZ,Angle,-Brise div 20,0,Offset,Azimuth);
 end else begin
  if SpecialObj[k1].Reverse then
    putobj(K1,AuxX,Y-(10-SpecialObj[K1].DisPerc)*Brise div 150-trunc(SpecialObj[K1].Y)+(Car[Num].Zrot*AuxX) div 150,
              AuxZ,Angle,-Brise div 20,0,Offset,Azimuth)
  else
    putobj(K1,AuxX,Y-(10-SpecialObj[K1].DisPerc)*Brise div 150-trunc(SpecialObj[K1].Y)+(Car[Num].Zrot*AuxX) div 150,
              AuxZ,Angle, Brise div 20,0,Offset,Azimuth);
  end;
 end
end;


Function SmokeFree: byte;
var Cnt:byte;
begin
cnt:=0;
repeat
inc(cnt);
until (cnt=8) or (Smoke[cnt].img=0);
SmokeFree:=cnt;
end;

Procedure TraceSmk (Num,X,Y,Z,Angle,Cdim,Offset,Azimuth: integer; N:byte);
var AuxX,AuxZ        : integer;
    k                : byte;
begin
 Angle:=Angle mod 360; if Angle<0 then inc(Angle,360);
 for K:=1 to 8 do if bit(N,K) then begin
  AuxZ:=integer((longint(Smoke[K].Z-Cdim*Smoke[K].DisPerc div 10)*cs[360-Angle]+
                 longint(Smoke[K].X)                             *sn[360-Angle])div 128)+Z;
  AuxX:=integer((longint(Smoke[K].Z-Cdim*Smoke[K].DisPerc div 10)*sn[360-Angle]-
                 longint(Smoke[K].X)                             *cs[360-Angle])div 128)+X;
  chgface(19,0,Smoke[K].img shr 2+1);
  if Smoke[k].Tipo=0 then Putobj(19,AuxX,Y,AuxZ,0,0,0,Offset,Azimuth)
                     else Putobj(29,AuxX,Y-Smoke[k].img*5,AuxZ,0,0,0,Offset,Azimuth);
 end
end;

Procedure AnimCar(Num:word);
var
Angolo,auxi:integer;

begin
  if    (Car[Num].Sec^.special=1) and (Car[Num].Glass =2) then
   begin Copybob(97+Num*50,61+Num*50); Car[Num].Glass:=1 end else
  if not(Car[Num].Sec^.special=1) and (Car[Num].Glass =1) then
   begin Copybob(96+Num*50,61+Num*50); Car[Num].Glass:=2 end;

if Car[num].Glass=2 then  SlideBob(61+Num*50,0,Car[Num].Speed div 180+sgn(Car[num].Speed div 20)) else
if Car[num].Glass=1 then  SlideBob(61+Num*50,0,Car[Num].Speed div  60+sgn(Car[num].Speed div 20));

Angolo:=Car[Num].sterzo div 2;

chgpoint(Num,Car[Num].p1rr,Car[Num].cx-12,Car[Num].cy, Car[Num].cz+Angolo);
chgpoint(Num,Car[Num].p2rr,Car[Num].cx+12,Car[Num].cy, Car[Num].cz-Angolo);
chgpoint(Num,Car[Num].p3rr,Car[Num].cx+12,          0, Car[Num].cz-Angolo);
chgpoint(Num,Car[Num].p4rr,Car[Num].cx-12,          0, Car[Num].cz+Angolo);

chgpoint(Num,Car[Num].p1rl,Car[Num].cx+12,Car[Num].cy,-Car[Num].cz-Angolo);
chgpoint(Num,Car[Num].p2rl,Car[Num].cx-12,Car[Num].cy,-Car[Num].cz+Angolo);
chgpoint(Num,Car[Num].p3rl,Car[Num].cx-12,          0,-Car[Num].cz+Angolo);
chgpoint(Num,Car[Num].p4rl,Car[Num].cx+12,          0,-Car[Num].cz-Angolo);

if Ytrottle[Num]>0 then chgface(Num,Car[Num].rear,2) else chgface(Num,Car[Num].rear,1);

if abs(Car[Num].Speed)>100 then Car[Num].Wval:=3 else
if abs(Car[Num].Speed)> 40 then Car[Num].Wval:=2 else
if abs(Car[Num].Speed)>  0 then begin
 inc(Car[Num].Wcnt,abs(Car[Num].Speed));
 if (Car[Num].Wcnt>40) then begin
  Dec(Car[Num].Wcnt,40);
  if Car[Num].Wval=1 then Car[Num].Wval:=0 else
  if Car[Num].Wval=0 then Car[Num].Wval:=1 else Car[Num].Wval:=0;
 end else Car[Num].Wval:=0;
end;

chgface(Num,Car[Num].rr, 7+Car[Num].Wval);
chgface(Num,Car[Num].lr, 7+Car[Num].Wval);
chgface(Num,Car[Num].rf, 3+Car[Num].Wval);
chgface(Num,Car[Num].lf, 3+Car[Num].Wval);
end;

Procedure ReNumSec(var road: track);
var
aux1: puntsec;
cnt : integer;
begin
aux1:=road.primo;
if aux1=nil then exit;
aux1^.Numsec:=1;
cnt:=1;
while aux1^.Next<>nil do begin
inc(cnt);
aux1:=aux1^.Next;
aux1^.Numsec:=cnt;
end;
end;

Procedure DelAllPol(sec:puntsec);
var
aux:puntpol;
begin
while sec^.maxpol>0 do begin
 dec(sec^.maxpol);
 aux:=sec^.ppolys;
 sec^.ppolys:=sec^.ppolys^.Next;
 dispose(aux);
end;
sec^.cpolys:=nil;
sec^.ppolys:=nil;
end;

Procedure delsec(var road: track; Num : word);
var
aux1: puntsec;
aux4: puntsec;
aux2: puntpol;
aux3: puntpol;

begin
 if road.maxsec=0 then exit;

 if road.maxsec=1 then begin
  if road.primo^.maxpol>0 then DelAllPol(road.primo);
  dispose(road.primo);
  road.primo:=nil;
  road.curs:=nil;
 end else begin

  if Num=1 then begin
   aux1:=road.primo;
   DelAllPol(aux1);
   road.primo:=road.primo^.Next;
   road.curs:=road.primo;
   dispose(aux1);
   road.primo^.last:=nil;
  end else begin

   aux1:=road.primo;
   while (aux1^.Numsec<Num) do aux1:=aux1^.Next;
   if aux1^.maxpol>0 then DelAllPol(aux1);
   if aux1^.last<>nil then aux1^.last^.Next:=aux1^.Next;
   dispose(aux1);
   road.curs:=road.primo;
  end;
 end;
 dec(road.maxsec);
 ReNumSec(road);
end;

Procedure CopySpec(NumS,NumD:byte);
begin
SpecialObj[NumD]:=SpecialObj[NumS];
CopyObj(NumS,NumD);
LoadSample(NumD-10,'Samples\'+Specialobj[NumD].Sample);
end;

Procedure LoadSpec(num:byte);
var
f :file;
Number:byte;
AuxStr:string;
begin

if GRoad.Special[num] =''then begin SpecialObj[Num+20].id:=0; exit; end;
assign(f,'Spec\'+GRoad.Special[num]);
reset(f,1);
Number:=Num+20;
Blockread(F,SpecialObj[number].Class,1);
Readfile(AuxStr,12,f);
SpecialObj[number].TdObj:=AuxStr;
Readfile(AuxStr,12,f);
SpecialObj[number].Sample:=AuxStr;

Blockread(F,SpecialObj[number].Tipo,1);
Blockread(F,SpecialObj[number].SX,2);
Blockread(F,SpecialObj[number].SY,2);
Blockread(F,SpecialObj[number].SZ,2);
Blockread(F,SpecialObj[number].SAngle,2);
Blockread(F,SpecialObj[number].SSpeed,2);
Blockread(F,SpecialObj[number].SImg  ,1);
close(F);

SpecialObj[number].Sreverse:=False;

If (SpecialObj[number].Sangle> 90) and
   (SpecialObj[number].Sangle<270) then begin
    SpecialObj[Number].SReverse:=True; SpecialObj[Number].Sangle:=SpecialObj[Number].Sangle-180;
   end;
if  SpecialObj[Number].Sangle>=270 then SpecialObj[Number].Sangle:=SpecialObj[Number].Sangle-360;

SpecialObj[number].id:=1 shl (num-1);
LoadObj   (Number   ,500+(Number-21)*6,'3Data\'+Specialobj[number].TdObj);
SpecialObj[Number].Sam:=SpecialObj[Number].Sample<>'';
if SpecialObj[Number].Sam then LoadSample(Number-10,'Samples\'+Specialobj[number].Sample);
end;

Procedure LoadCar (NumCar: byte;BaseText: word; NameCar: string);
var xc1,xc2,zc1,zc2,zc3,zc4: integer;
begin
LoadObj     (NumCar   ,BaseText,'3Data\'+NameCar+'.obj');
LoadWir     (NumCar+10,BaseText,'3Data\'+NameCar+'2.obj');
LoadWir     (NumCar+30,BaseText,'3Data\'+NameCar+'R.obj');
LFbob       ('Pics\'+Namecar+'R.pcx','Data\'+Namecar+'.dat',BaseText+500);
LoadChas    (NumCar,          'Data\'+NameCar+'.chs');
LoadAttr    (NumCar,          'Data\'+NameCar+'.Att');
lbob('Pics\'+NameCar+'dh.pcx','Data\'+NameCar+'dh.dat',Basetext+48);
getpoint(NumCar,Car[NumCar].p1rr,xc1,zc3,zc1);
getpoint(NumCar,Car[NumCar].p2rr,xc2,zc4,zc2);
Car[NumCar].cx:=(xc1+xc2) div 2;
Car[NumCar].cy:=zc3;
Car[NumCar].cz:=zc1;
end;

Procedure LoadCar2 (NumCar: byte;BaseText: word; NameCar: string);
var xc1,xc2,zc1,zc2,zc3,zc4: integer;
begin
LoadObj     (NumCar   ,BaseText,'3Data\'+NameCar+'.obj');
end;

Function Gangle(Sec:PuntSec):integer;
var cnt:integer;
    NumSec:integer;
    Angle :integer;
begin
Angle:=0;
NumSec:=Sec^.NumSec;
Sec:=Groad.primo;
for cnt:=1 to NumSec do begin
dec(Angle,Sec^.Turn);
Sec:=Sec^.Next;
end;
Gangle:=Angle;
end;

Procedure LoadRoad(var road: track; name: string);
var
f               :File;
aux1            :puntsec;
aux2            :puntpol;
cnt1,cnt2       :integer;
auxI            :integer;
Auxstr          :string;
begin
 assign(F,'Data\'+Name+'.Cam');
  reset(F,1);
  for cnt1:=1 to 20 do begin
   Blockread(F,CamSetting[cnt1].NumSec ,2);
   Blockread(F,CamSetting[cnt1].X      ,2);
   Blockread(F,CamSetting[cnt1].Y      ,2);
   Blockread(F,CamSetting[cnt1].Z      ,2);
   Blockread(F,CamSetting[cnt1].Angle  ,2);
   Blockread(F,CamSetting[cnt1].Orizont,2);
   Blockread(F,CamSetting[cnt1].Reverse,1);
  end;
 close(f);

Name:='Tracks\'+Name+'.Trk';

assign(f,name);
reset(f,1);

readfile(auxstr,30,f)  ;
road.back:=copy(auxstr,10,27);

Loadpcx(road.back,pseg,pofs);

Loadpcx(road.back,pseg,pofs);

Getfbob(MaxBobs,0,0,159,149);
BackDy:=149;

Backcol:=point(0,140);
SkyCol :=point(0,0);

readfile(auxstr,30,f);
road.setgrf:=copy(auxstr,10,27);
readfile(auxstr,30,f);
road.setdat:=copy(auxstr,10,27);

readfile(auxstr,30,f);
road.special[1]:=copy(auxstr,1,30);
readfile(auxstr,30,f);
road.special[2]:=copy(auxstr,1,30);
readfile(auxstr,30,f);
road.special[3]:=copy(auxstr,1,30);
readfile(auxstr,30,f);
road.special[4]:=copy(auxstr,1,30);
readfile(auxstr,30,f);
road.special[5]:=copy(auxstr,1,30);
readfile(auxstr,30,f);
road.special[6]:=copy(auxstr,1,30);
readfile(auxstr,30,f);
road.special[7]:=copy(auxstr,1,30);
readfile(auxstr,30,f);
road.special[8]:=copy(auxstr,1,30);

for cnt1:=1 to 8 do loadspec(cnt1);

blockread(f,road.maxsec,2);
if road.maxsec>0 then begin
 new(road.primo);
 road.curs:=road.primo;
 aux1:=road.curs;
 aux1^.last:=nil;
 aux1^.Next:=nil;
 blockread(f,aux1^.Numsec,2);
 blockread(f,aux1^.curpn,1);
 blockread(f,aux1^.maxpn,1);
 blockread(f,aux1^.Maxroad,2);
 blockread(f,aux1^.Minroad,2);
 blockread(f,aux1^.Maxspc ,2);
 blockread(f,aux1^.Minspc ,2);
 blockread(f,aux1^.Special,1);

 aux1^.Numcar:=0;
 aux1^.NumSmk:=0;
 aux1^.NumSpc:=0;

 if (Aux1^.special>20) and (Aux1^.special<29) then PlaceSpc(Aux1,Aux1^.Special);

 auxi         := aux1^.Maxroad;
 aux1^.Maxroad:=-aux1^.Minroad;
 aux1^.Minroad:=-auxi;
 auxi         := aux1^.Maxspc;
 aux1^.Maxspc :=-aux1^.Minspc;
 aux1^.Minspc :=-auxi;

 for cnt1:=1 to aux1^.maxpn do begin
  blockread(f,aux1^.x[cnt1],2);
  blockread(f,aux1^.y[cnt1],2);
 end;

 blockread(f,aux1^.maxpol,1);

 if aux1^.maxpol>0 then begin
  new(aux1^.ppolys);
  aux1^.cpolys:=aux1^.ppolys;
  aux2:=aux1^.ppolys;
  blockread(f,aux2^.Numpol,1);
  blockread(f,aux2^.edge[1],2);
  blockread(f,aux2^.edge[2],2);
  blockread(f,aux2^.edge[3],2);
  blockread(f,aux2^.edge[4],2);
  blockread(f,aux2^.tipo,1);
  blockread(f,aux2^.color,1);
  aux2^.Next:=nil;
  aux2^.last:=nil;
  while aux2^.Numpol<aux1^.maxpol do begin
   new(aux2^.Next);
   aux2^.Next^.last:=aux2;
   aux2:=aux2^.Next;
   blockread(f,aux2^.Numpol,1);
   blockread(f,aux2^.edge[1],2);
   blockread(f,aux2^.edge[2],2);
   blockread(f,aux2^.edge[3],2);
   blockread(f,aux2^.edge[4],2);
   blockread(f,aux2^.tipo,1);
   blockread(f,aux2^.color,1);
   aux2^.Next:=nil;
  end;
 end else begin
 aux1^.ppolys:=nil;
 aux1^.cpolys:=nil;
 end;
 blockread(f,aux1^.rise,1);
 blockread(f,aux1^.turn,1);
 blockread(f,aux1^.taxis,2);

  while aux1^.Numsec<road.maxsec do begin
  new(aux1^.Next);

  aux1^.Next^.Last:=aux1;
  aux1:=aux1^.Next;
  blockread(f,aux1^.Numsec,2);
  blockread(f,aux1^.curpn,1);
  blockread(f,aux1^.maxpn,1);
  blockread(f,aux1^.Maxroad,2);
  blockread(f,aux1^.Minroad,2);
  blockread(f,aux1^.Maxspc ,2);
  blockread(f,aux1^.Minspc ,2);
  blockread(f,aux1^.Special,1);

  aux1^.Numcar:=0;
  aux1^.NumSmk:=0;
  aux1^.NumSpc:=0;

 if (Aux1^.special>20) and (Aux1^.special<29) then PlaceSpc(Aux1,Aux1^.Special);

 auxi         := aux1^.Maxroad;
 aux1^.Maxroad:=-aux1^.Minroad;
 aux1^.Minroad:=-auxi;
 auxi         := aux1^.Maxspc;
 aux1^.Maxspc :=-aux1^.Minspc;
 aux1^.Minspc :=-auxi;

  for cnt1:=1 to aux1^.maxpn do begin

   blockread(f,aux1^.x[cnt1],2);
   blockread(f,aux1^.y[cnt1],2);
  end;
  blockread(f,aux1^.maxpol,1);
  aux1^.Next:=nil;

  if aux1^.maxpol>0 then begin
   new(aux1^.ppolys);
   aux1^.cpolys:=aux1^.ppolys;
   aux2:=aux1^.ppolys;
   blockread(f,aux2^.Numpol,1);
   blockread(f,aux2^.edge[1],2);
   blockread(f,aux2^.edge[2],2);
   blockread(f,aux2^.edge[3],2);
   blockread(f,aux2^.edge[4],2);
   blockread(f,aux2^.tipo,1);
   blockread(f,aux2^.color,1);
   aux2^.Next:=nil;
   aux2^.last:=nil;
   while aux2^.Numpol<aux1^.maxpol do begin
    new(aux2^.Next);
    aux2^.Next^.last:=aux2;
    aux2:=aux2^.Next;
    blockread(f,aux2^.Numpol,1);
    blockread(f,aux2^.edge[1],2);
    blockread(f,aux2^.edge[2],2);
    blockread(f,aux2^.edge[3],2);
    blockread(f,aux2^.edge[4],2);
    blockread(f,aux2^.tipo,1);
    blockread(f,aux2^.color,1);
    aux2^.Next:=nil;
   end;
  end else begin
   aux1^.ppolys:=nil;
   aux1^.cpolys:=nil;
  end;
  blockread(f,aux1^.rise,1);
  blockread(f,aux1^.turn,1);
  blockread(f,aux1^.taxis,2);
 end;
end else begin
road.primo:=nil;
road.curs:=nil;
end;
 aux1:=road.primo;
 while aux1^.Next<>nil do aux1:=aux1^.Next;
 road.ultimo:=aux1;
close(f);

LfBob(road.setgrf,road.setdat,1);
Loadpal(road.setgrf,20,255);
end;

Procedure KillRoad(var road: track);
begin
road.primo^.last:=nil;
road.ultimo^.Next:=nil;
while road.maxsec>0 do delsec(road,1);
end;

Procedure TraceRoadCar(NumCar:byte; Y:integer);
var Pcos,Psen,Yfond: integer;

begin
 Fillchar(chk,SizeOf(Chk),0);
 Azimuth :=Car[NumCar].Xrot+Car[NumCar].trabval+Y+20;
 Zrot    :=Car[NumCar].Zrot;
 Ymy     :=Car[NumCar].Inty+Car[NumCar].Fro;

 Yfond:=(-Car[NumCar].Grise div 50*Cs[Car[NumCar].Angle1 div 10+180] div 128) shl SVGA;
 if Yfond> 20  shl SVGA then Yfond:= 20 shl SVGA else
 if Yfond<-20  shl SVGA then Yfond:=-20 shl SVGA;
 inc(Yfond,Y-85+Car[NumCar].Xrot shl SVGA);
 Bar (0,0,319 Shl SVGA,Yfond, SkyCol);
 Bar (0,Yfond+BackDy,319 Shl SVGA,199 Shl SVGA,BackCol);
 Back(MaxBobs,Car[NumCar].GAngle shl 2 mod 160-160,Yfond);
 CurrSecdist:=0;

 if Not Car[NumCar].Reverse then begin
  aux1 :=Car[NumCar].Sec;
  drawed:=0;
  totalpoints:=0;
  cnt2:=2;

  baserise:=-Car[NumCar].CurrRise;
  rise:=0;

  BaseAngle:=Car[NumCar].Angle1 div 10;
  AdjOffset:=160 shl SVGA+(Car[NumCar].Angle1 div 2 mod 5 div 2) shl 1;
  Angle:=BaseAngle mod 360; if Angle<0 then inc(Angle,360);
  Angle:=360-Angle;

  x:=integer( longint(Car[NumCar].IntZ)*sn[Angle] div 128+longint(Car[NumCar].IntX)*cs[Angle] div 128);
  z:=integer(-longint(Car[NumCar].IntZ)*cs[Angle] div 128+longint(Car[NumCar].IntX)*sn[Angle] div 128)-80;

  for cnt1:=1 to 3 do begin
   if (aux1^.turn<>0) then begin
    dec(BaseAngle,aux1^.turn);
    Angle:=BaseAngle mod 360; if Angle<0 then inc(Angle,360);
    Angle:=360-Angle;
    inc(x,longint(aux1^.taxis)*sn[Angle] div 128);
    dec(z,longint(aux1^.taxis)*cs[Angle] div 128);
   end else begin
    inc(x,longint(SecDistance)*sn[Angle] div 128);
    dec(z,longint(SecDistance)*cs[Angle] div 128);
   end;
   aux1:=Aux1^.last;
  end;

  while (cnt2<maxdistance) do begin
   if (Aux1^.NumCar>0) or (Aux1^.NumSmk>0) or (Aux1^.NumSpc>0) then begin
    Xsec[cnt2]:=x;
    Ysec[cnt2]:=Ymy-rise div 15;
    Zsec[cnt2]:=z+128;
    Bsec[cnt2]:=BaseRise;
    Asec[cnt2]:=Angle;
    Cdim[cnt2]:=CurrSecDist;
   end;

   currpoint:=totalpoints;
   Pcos:=cs[Angle];
   Psen:=sn[Angle];
   for cnt1:=1 to aux1^.maxpn do begin
    inc(currpoint);
    efx :=    aux1^.x[cnt1] div 4;
    auxx:=integer(efx*Pcos div 32)+x;
    auxz:=integer(efx*Psen div 32)+z+128;
    if (abs(auxx)<700+auxz shr 2) and (auxz>0) then begin
     auxy:=ymy-aux1^.y[cnt1]-rise div 15+(Zrot*auxx) div 150;
     auxz:=auxz shr 4+1;
     px[currpoint]:=(auxx shl PRAP2 div auxz) shl SVGA+AdjOffset;
     py[currpoint]:=(auxy shl PRAP2 div auxz) shl SVGA+azimuth;
     if px[currpoint]> 840 then px[currpoint]:= 840 else
     if px[currpoint]<-200 then px[currpoint]:=-200;
     chk[currpoint]:=true;
    end else chk[currpoint]:=false;
   end;
   aux1:=aux1^.Next;
   inc(totalpoints,30);
   inc(cnt2);
   if (aux1^.turn<>0) then begin
    dec(x,longint(aux1^.taxis+CurrSecDist)*Psen div 128);
    inc(z,longint(aux1^.taxis+CurrSecDist)*Pcos div 128);
    inc(BaseAngle,aux1^.turn);
    Angle:=BaseAngle mod 360; if Angle<0 then inc(Angle,360);
    Angle:=360-Angle;
   end else begin
    dec(x,longint(SecDistance+CurrSecDist)*sn[Angle] div 128);
    inc(z,longint(SecDistance+CurrSecDist)*cs[Angle] div 128);
   end;

   if cnt2>4 then begin
    inc(baserise ,aux1^.rise); inc(rise,baserise);
    if cnt2>10 then inc(CurrSecDist,10);
   end;
   inc(drawed);
  end;

  while drawed>0 do begin
   dec(drawed);

   aux1:=aux1^.last;
   edgebase:=drawed*30;
   curpol:=aux1^.ppolys;

   if (Aux1^.Last^.NumSPC>0) then
   TraceSPC (NumCar,Xsec[Drawed+1],
                    Ysec[Drawed+1],
                    Zsec[Drawed+1],
                    Asec[Drawed+1],
                    Bsec[Drawed+1],
                    Cdim[Drawed+1],AdjOffset,Azimuth,Aux1^.Last^.NumSPC,True);

   while curpol<>nil do begin
    edge[1]:=edgebase+curpol^.edge[1];
    edge[2]:=edgebase+curpol^.edge[2];
    edge[3]:=edgebase+curpol^.edge[3];
    if curpol^.edge[3]=0 then chk[edge[3]]:=true;
    edge[4]:=edgebase+curpol^.edge[4];
    if curpol^.edge[4]=0 then chk[edge[4]]:=true;

    if chk[edge[1]] and chk[edge[2]] and chk[edge[3]] and chk[edge[4]] and
    (edge[1]<750) and (edge[2]<750) and (edge[3]<750) and (edge[4]<750)
    then begin
     pv1:=(py[edge[2]]-py[edge[1]]) div (SVGA+1);
     pv2:=(px[edge[3]]-px[edge[1]]) div (SVGA+1);
     pv3:=(px[edge[2]]-px[edge[1]]) div (SVGA+1);
     pv4:=(py[edge[3]]-py[edge[1]]) div (SVGA+1);

     if (pv1*pv2<pv3*pv4+150) then begin

      tipo:=curpol^.tipo;
      colr:=curpol^.color;

(*     if (tipo=1) or (tipo=2) or (tipo=5) or (tipo=6) or (tipo=7) or (tipo=8) then begin
                    line      (px[edge[1]],py[edge[1]],px[edge[2]],py[edge[2]],88);
                    line      (px[edge[2]],py[edge[2]],px[edge[3]],py[edge[3]],88);
                    line      (px[edge[3]],py[edge[3]],px[edge[4]],py[edge[4]],88);
                    line      (px[edge[4]],py[edge[4]],px[edge[1]],py[edge[1]],88);
                    end;
  *)
      if (tipo=0) and (edge[1]>0) and (edge[2]>0) then
      line      (px[edge[1]],py[edge[1]],px[edge[2]],py[edge[2]],colr  ) else
      if (tipo=1) and (edge[1]>0) and (edge[2]>0) and (edge[3]>0) and (edge[4]>0) then
      polygon   (px[edge[1]],py[edge[1]],px[edge[2]],py[edge[2]],
                 px[edge[3]],py[edge[3]],px[edge[4]],py[edge[4]],colr) else
      if (tipo=2) and (edge[1]>0) and (edge[2]>0) and (edge[3]>0) and (edge[4]>0) and (drawed>15) then
      polygon   (px[edge[1]],py[edge[1]],px[edge[2]],py[edge[2]],
                px[edge[3]],py[edge[3]],px[edge[4]],py[edge[4]],colr) else
      if (tipo=4) and (edge[1]>0) and (edge[2]>0) and(tipo=4) and (Px[edge[1]]>-200) and (Px[Edge[1]]<840) then
      frbob    (colr,px[edge[1]],py[edge[1]],px[edge[2]],py[edge[2]],3);
      if (tipo=5) and (edge[1]>0) and (edge[2]>0) and (edge[3]>0) and (edge[4]>0) then
      vmapbob   (px[edge[1]],px[edge[2]],py[edge[1]],py[edge[2]],py[edge[3]],py[edge[4]],colr) else
      if (tipo=6) and (edge[1]>0) and (edge[2]>0) and (edge[3]>0) and (edge[4]>0) then
      mapbob    (px[edge[1]],py[edge[1]],px[edge[2]],py[edge[2]],
                 px[edge[3]],py[edge[3]],px[edge[4]],py[edge[4]],colr) else
      if (tipo=7) and (edge[1]>0) and (edge[2]>0) and (edge[3]>0) and (edge[4]>0) then
      tvmapbob  (px[edge[1]],px[edge[2]],py[edge[1]],py[edge[2]],py[edge[3]],py[edge[4]],colr) else
      if (tipo=8) and (edge[1]>0) and (edge[2]>0) and (edge[3]>0) and (edge[4]>0) then
      tmapbob   (px[edge[1]],py[edge[1]],px[edge[2]],py[edge[2]],
                px[edge[3]],py[edge[3]],px[edge[4]],py[edge[4]],colr);
     end
    end;
    curpol:=curpol^.Next;
   end;
   if (Drawed<Maxdistance-6) then begin
    if (Aux1^.Next^.NumSPC>0) then
    TraceSPC (NumCar,Xsec[Drawed+3],
                     Ysec[Drawed+3],
                     Zsec[Drawed+3],
                     Asec[Drawed+3],
                     Bsec[Drawed+3],
                     Cdim[Drawed+3],AdjOffset,Azimuth,Aux1^.Next^.NumSPC,False);

    if Aux1^.Next^.NumCar>0 then
    TraceCars(NumCar,Xsec[Drawed+3],
                     Ysec[Drawed+3],
                     Zsec[Drawed+3],
                     Asec[Drawed+3],
                     Bsec[Drawed+3],
                     Cdim[Drawed+3],AdjOffset,Azimuth,Aux1^.Next^.NumCar);

    if Aux1^.Next^.NumSmk>0 then
    TraceSmk (NumCar,Xsec[Drawed+3],
                     Ysec[Drawed+3],
                     Zsec[Drawed+3],
                     Asec[Drawed+3],
                     Cdim[Drawed+3],AdjOffset,Azimuth,Aux1^.Next^.NumSmk);
   end
  end
 end else begin

(*******************************************************************)
(********************* GO IN REVERSE *******************************)
(*******************************************************************)

  aux1 :=Car[NumCar].Sec;
  drawed:=0;
  totalpoints:=720;
  cnt2:=2;

  baserise:=-Car[NumCar].CurrRise;
  rise:=0;

  BaseAngle:=Car[NumCar].Angle1 div 10;
  AdjOffset:=160 shl SVGA+(Car[NumCar].Angle1 div 2 mod 5 div 2) shl 1;
  Angle:=BaseAngle mod 360; if Angle<0 then inc(Angle,360);
  Angle:=360-Angle;

  x:= integer( longint(-Car[NumCar].IntZ)*sn[Angle] div 128+longint(-Car[NumCar].IntX)*cs[Angle] div 128);
  z:= integer(-longint(-Car[NumCar].IntZ)*cs[Angle] div 128+longint(-Car[NumCar].IntX)*sn[Angle] div 128)-80;
  for cnt1:=1 to 4 do begin
   Aux1:=Aux1^.Next;
   if aux1^.turn<>0 then begin
    inc(x,longint(aux1^.taxis)*sn[Angle] div 128);
    dec(z,longint(aux1^.taxis)*cs[Angle] div 128);
    dec(BaseAngle,-aux1^.turn);
    Angle:=BaseAngle mod 360; if Angle<0 then inc(Angle,360);
    Angle:=360-Angle;
   end else begin
    inc(x,longint(SecDistance)*sn[Angle] div 128);
    dec(z,longint(SecDistance)*cs[Angle] div 128);
   end;
  end;

  Pcos:=cs[Angle];
  Psen:=sn[Angle];

  while (cnt2<maxdistance) do begin

   if (Aux1^.NumCar>0) or (Aux1^.NumSmk>0) or (Aux1^.NumSpc>0) then begin
    Xsec[cnt2]:=x;
    Ysec[cnt2]:=Ymy-rise div 15;
    Zsec[cnt2]:=z+128;
    Bsec[cnt2]:=BaseRise;
    Asec[cnt2]:=Angle;
    Cdim[cnt2]:=CurrSecDist;
   end;

   currpoint:=totalpoints;
   for cnt1:=1 to aux1^.maxpn do begin
    inc(currpoint);
    efx :=   -aux1^.x[cnt1] div 4;
    auxx:=  integer(efx*Pcos div 32)+x;
    auxz:=  integer(efx*Psen div 32)+z+128;
(*  px[currpoint]:= (auxx div 5)+160;
    py[currpoint]:=-(auxz div 5)+80;
    plot(px[currpoint],py[currpoint],20);*)
    if (abs(auxx)<700+auxz shr 2) and (auxz>0) then begin
     auxy:=ymy-aux1^.y[cnt1]-rise div 15+(Zrot*auxx) div 150;
     auxz:=auxz shr 4+1;
     px[currpoint]:=(auxx shl PRAP2 div auxz)Shl SVGA+AdjOffset;
     py[currpoint]:=(auxy shl PRAP2 div auxz)Shl SVGA+azimuth;
     if px[currpoint]> 840 then px[currpoint]:= 840 else
     if px[currpoint]<-200 then px[currpoint]:=-200;
     chk[currpoint]:=true;
    end else chk[currpoint]:=false;
   end;
   dec(totalpoints,30);
   inc(cnt2);
   if (aux1^.turn<>0) then begin
    inc(BaseAngle,-aux1^.turn);
    Angle:=BaseAngle mod 360; if Angle<0 then inc(Angle,360);
    Angle:=360-Angle;
    Pcos:=cs[Angle];
    Psen:=sn[Angle];
    dec(x,longint(aux1^.taxis+CurrSecDist)*Psen div 128);
    inc(z,longint(aux1^.taxis+CurrSecDist)*Pcos div 128);
   end else begin
    dec(x,longint(SecDistance+CurrSecDist)*Psen div 128);
    inc(z,longint(SecDistance+CurrSecDist)*Pcos div 128);
   end;
   if cnt2>6 then begin
    inc(baserise ,aux1^.rise); inc(rise,baserise);
    if cnt2>10 then inc(CurrSecDist,10);
   end;
   inc(drawed);
   aux1:=aux1^.last;
  end;

  while drawed>0 do begin

   dec(drawed);
   aux1:=aux1^.Next;
   edgebase:=720-drawed*30;
   curpol:=aux1^.ppolys;

   if (Aux1^.Next^.NumSPC>0) then
    TraceSPC (NumCar,Xsec[Drawed+1],
                     Ysec[Drawed+1],
                     Zsec[Drawed+1],
                     Asec[Drawed+1]+180,
                     Bsec[Drawed+1],
                     Cdim[Drawed+1],AdjOffset,Azimuth,Aux1^.Next^.NumSPC,True);

   while curpol<>nil do begin
    edge[1]:=edgebase+curpol^.edge[1];
    edge[2]:=edgebase+curpol^.edge[2];
    edge[3]:=edgebase+curpol^.edge[3];if curpol^.edge[3]=0 then chk[edge[3]]:=true;
    edge[4]:=edgebase+curpol^.edge[4];if curpol^.edge[4]=0 then chk[edge[4]]:=true;

    if chk[edge[1]] and chk[edge[2]] and chk[edge[3]] and chk[edge[4]] and
        (edge[1]<750) and (edge[2]<750)
    and (edge[3]<750) and (edge[4]<750) then begin

     pv1:=(py[edge[2]]-py[edge[1]]) div (SVGA+1);
     pv2:=(px[edge[3]]-px[edge[1]]) div (SVGA+1);
     pv3:=(px[edge[2]]-px[edge[1]]) div (SVGA+1);
     pv4:=(py[edge[3]]-py[edge[1]]) div (SVGA+1);

     if (pv1*pv2<pv3*pv4+150) then begin

      tipo:=curpol^.tipo;
      colr:=curpol^.color;

(*   if (tipo=1) or (tipo=2) or (tipo=5) or (tipo=6) or (tipo=7) or (tipo=8) then begin
                    line      (px[edge[1]],py[edge[1]],px[edge[2]],py[edge[2]],88);
                    line      (px[edge[2]],py[edge[2]],px[edge[3]],py[edge[3]],88);
                    line      (px[edge[3]],py[edge[3]],px[edge[4]],py[edge[4]],88);
                    line      (px[edge[4]],py[edge[4]],px[edge[1]],py[edge[1]],88);
                    end;
  *)

      if(tipo=0) and (edge[1]>0) and (edge[2]>0) then
      line      (px[edge[1]],py[edge[1]],px[edge[2]],py[edge[2]],colr  ) else
      if(tipo=1) and (edge[1]>0) and (edge[2]>0) and (edge[3]>0) and (edge[4]>0) then
      polygon   (px[edge[1]],py[edge[1]],px[edge[2]],py[edge[2]],
                 px[edge[3]],py[edge[3]],px[edge[4]],py[edge[4]],colr  ) else
      if (tipo=2) and (edge[1]>0) and (edge[2]>0) and (edge[3]>0) and (edge[4]>0) and (drawed>15) then
      polygon   (px[edge[1]],py[edge[1]],px[edge[2]],py[edge[2]],
                 px[edge[3]],py[edge[3]],px[edge[4]],py[edge[4]],colr  ) else
      if(tipo=4) and (edge[1]>0) and (edge[2]>0)  and (Px[edge[1]]>-200) and (Px[Edge[1]]<840) then
      frbob    (colr,px[edge[1]],py[edge[1]],px[edge[2]],py[edge[2]],3) else
      if(tipo=5) and (edge[1]>0) and (edge[2]>0) and (edge[3]>0) and (edge[4]>0) then
      vmapbob   (px[edge[1]],px[edge[2]],py[edge[1]],py[edge[2]],py[edge[3]],py[edge[4]],colr) else
      if(tipo=6) and (edge[1]>0) and (edge[2]>0) and (edge[3]>0) and (edge[4]>0) then
      mapbob    (px[edge[1]],py[edge[1]],px[edge[2]],py[edge[2]],
                px[edge[3]],py[edge[3]],px[edge[4]],py[edge[4]],colr) else
      if(tipo=7) and (edge[1]>0) and (edge[2]>0) and (edge[3]>0) and (edge[4]>0) then
      tvmapbob  (px[edge[1]],px[edge[2]],py[edge[1]],py[edge[2]],py[edge[3]],py[edge[4]],colr) else
      if(tipo=8) and (edge[1]>0) and (edge[2]>0) and (edge[3]>0) and (edge[4]>0) then
      tmapbob   (px[edge[1]],py[edge[1]],px[edge[2]],py[edge[2]],
                 px[edge[3]],py[edge[3]],px[edge[4]],py[edge[4]],colr);
     end
    end;
    curpol:=curpol^.Next;
   end;

   if (Drawed<Maxdistance-6) then begin
    if (Aux1^.Last^.NumSPC>0) then
    TraceSPC (NumCar,Xsec[Drawed+3],
                     Ysec[Drawed+3],
                     Zsec[Drawed+3],
                     Asec[Drawed+3]+180,
                     Bsec[Drawed+3],
                     Cdim[Drawed+3],AdjOffset,Azimuth,Aux1^.Last^.NumSPC,false);

    if Aux1^.Last^.NumCar>0 then
    TraceCars(NumCar,Xsec[Drawed+3],
                     Ysec[Drawed+3],
                     Zsec[Drawed+3],
                     Asec[Drawed+3]+180,
                     Bsec[Drawed+3],
                     Cdim[Drawed+3],AdjOffset,Azimuth,Aux1^.Last^.NumCar);

    if Aux1^.Last^.NumSmk>0 then
    TraceSmk (NumCar,Xsec[Drawed+3],
                     Ysec[Drawed+3],
                     Zsec[Drawed+3],
                     Asec[Drawed+3]+180,
                     Cdim[Drawed+3],AdjOffset,Azimuth,Aux1^.Last^.NumSmk);
   end
  end
 end
end;

Procedure Nextsec(var road: track);
begin
if road.curs^.Next<>nil then road.curs:=road.curs^.Next else road.curs:=road.primo;
end;

Procedure lastsec(var road: track);
begin
if road.curs^.last<>nil then road.curs:=road.curs^.last else road.curs:=road.ultimo;
end;

(*************************** CARS PROCS SECTION *******************************)
(******************************************************************************)



Function ProxCar(NumCar:byte):byte;
var
Dist      :integer;
NumSecCar :integer;
Examine   :integer;
cnt       :byte;

begin
NumSecCar:=Car[NumCar].Sec^.NumSec;
ProxCar:=1;Dist:=1000;
if allcars then begin
 for cnt:=1 to 8 do if Cnt<>NumCar then begin
  Examine:=abs(integer(Car[Cnt].Sec^.NumSec)-NumSecCar);
  if (Examine>Groad.MaxSec shr 1) then Examine:=Groad.Maxsec-Examine;
  if Examine<Dist then begin Dist:=Examine; ProxCar:=Cnt; end
 end
end else if NumCar=1 then Proxcar:=2 else Proxcar:=1;
end;

Function ProxCar2(NumCar:byte):byte;
var
Dist      :integer;
NumSecCar :integer;
Examine   :integer;
cnt       :byte;

begin
NumSecCar:=Car[NumCar].Sec^.NumSec;
ProxCar2:=1;Dist:=1000;
if allcars then begin
 for cnt:=1 to 8 do if (Cnt<>NumCar) and (Car[cnt].team=0) then begin
  Examine:=abs(integer(Car[Cnt].Sec^.NumSec)-NumSecCar);
  if (Examine>Groad.MaxSec shr 1) then Examine:=Groad.Maxsec-Examine;
  if Examine<Dist then begin Dist:=Examine; ProxCar2:=Cnt; end
 end
end;
end;


Procedure CarNextSec(Num: byte);
Var ExNumSec: word;
begin
dec(Car[Num].Sec^.NumCar,Car[Num].Id);
ExNumSec:=Car[num].Sec^.NumSec;
Car[Num].Sec:=Car[Num].Sec^.Next;

if (Car[num].Sec^.NumSec<ExNumSec) and ((GlobalTime+Time-StartTime[Num]>20000) or FFWD) then begin
 inc(Lap[Num]);
 if GameMode<>2 then begin
  if Lap[Num]>10 then Begin
   Car[num].FinPos:=Position(Num); Car[Num].Fin:=True;
  end;

  if (Num=1) or ((Num=2) and (NumPla=2)) then begin
   Auxstring:='None';
   MillToTime(LapTime[Num],GlobalTime+Time-StartTime[Num]);
   LapTimeS[Num]:=TimeToStr(LapTime[Num]);
   StartTime[Num]:=(GlobalTime+Time);
   if Not FFWD then begin
   if (LapTime[Num].m< RecTime.m) then begin
    RecTimes:=LapTimes[Num]; RecTime:=LapTime[Num]; RecId:=Ids[Num];
   end else
   if (LapTime[Num].m<=RecTime.m) and
      (LapTime[Num].s< RecTime.s) then begin
    RecTimes:=LapTimes[Num];
    RecTime :=LapTime [Num];
   end else
   if (LapTime[Num].m<=RecTime.m) and
      (LapTime[Num].s<=RecTime.s) and
      (LapTime[Num].c< RecTime.c) then begin
    RecTimes:=LapTimes[Num];
    RecTime :=LapTime [Num];
   end;

   if (LapTime[Num].m< BestTime[Num].m) then begin
    BestTimes[Num]:=LapTimes[Num]; BestTime[Num]:=LapTime[Num];
    if Lap[Num]>1 then AuxString:='Best.Raw'
   end else
   if (LapTime[Num].m<=BestTime[Num].m) and
      (LapTime[Num].s< BestTime[Num].s) then begin
    BestTimes[Num]:=LapTimes[Num];
    BestTime [Num]:=LapTime [Num];
    if Lap[Num]>1 then AuxString:='Best.Raw'
   end else
   if (LapTime[Num].m<=BestTime[Num].m) and
      (LapTime[Num].s<=BestTime[Num].s) and
      (LapTime[Num].c< BestTime[Num].c) then begin
    BestTimes[Num]:=LapTimes[Num];
    BestTime [Num]:=LapTime [Num];

    if Lap[Num]>1 then AuxString:='Best.Raw'
   end else AuxString:='Another.Raw';
   if Lap[Num]=10 then AuxString:='Final.Raw';
   if Car[Num].Fin then begin
    if  Car[num].FinPos=1 then AuxString:='Champion.Raw' else
    if (Car[num].FinPos=2) or (Car[num].FinPos=3) then AuxString:='GoodRace.Raw' else
    AuxString:='MorePrat.Raw'
   end;
   end else AuxString:='None';
   if AuxString<>'None' then PlaysampleHd('Samples\'+AuxString,False)
  end
 end
end;

inc(Car[Num].Sec^.NumCar,Car[Num].Id);
end;

Procedure CarLastSec(Num: byte);
Var ExNumSec: word;
begin
dec(Car[Num].Sec^.NumCar,Car[Num].Id);
ExNumSec:=Car[num].Sec^.NumSec;
Car[Num].Sec:=Car[Num].Sec^.Last;
if (Car[num].Sec^.NumSec>ExNumSec) and (Lap[num]>0) then begin
 dec(Lap[Num]);
 StartTime[Num]:=GlobalTime-30000;
end;
inc(Car[Num].Sec^.NumCar,Car[Num].Id);
end;

Procedure SpecialObjNextSec(Num: byte);
begin
dec(SpecialObj[Num].Sec^.NumSpc,SpecialObj[Num].Id);
SpecialObj[Num].Sec:=SpecialObj[Num].Sec^.Next;
inc(SpecialObj[Num].Sec^.NumSpc,SpecialObj[Num].Id);
end;

Procedure SpecialObjLastSec(Num: byte);
begin
dec(SpecialObj[Num].Sec^.NumSpc,SpecialObj[Num].Id);
SpecialObj[Num].Sec:=SpecialObj[Num].Sec^.Last;
inc(specialObj[Num].Sec^.NumSpc,specialObj[Num].Id);
end;

Procedure TraceBar (Title: String;x,y,value,rap:integer);
begin
   if Value>220 then Value:=220;
   Text   (x,y,Title,true);
   BarPatt(x+70 shl SVGA,y+2 shl SVGA,x+(70+value div rap) shl SVGA,y+8 shl SVGA,570);
   Box    (x+70 shl SVGA,y+2 shl SVGA,x+(70+220   div rap) shl SVGA,y+8 shl SVGA,  0);
end;

Procedure TraceBarShort (Title: String;x,y,value,rap:integer);
begin
   if Value>255 then Value:=255;
   Text   (x,y,Title,true);
   BarPatt(x,y+10 shl SVGA,x+(value div rap) shl SVGA,y+15 shl SVGA,570);
   Box    (x,y+10 shl SVGA,x+(255   div rap) shl SVGA,y+15 shl SVGA,  0);
end;



Procedure TraceDash (Num:byte;YCoor: Word);
var Aux,Angle,Volume,Dis:integer;
    Voice:byte;

begin
clipgraph(MsX1clip[Num],MsY1Clip[num],MsX2Clip[Num],MsY2Clip[Num]);

if Num=1 then Voice:=1 else Voice:=2;
if Gamemode=3 then Voice:=1;

if Ch[Voice].StAlert=0 then
if Car[Num].Sec^.Special=1 then playsample(Voice,2,32,min(Car[Num].Revs2 div 3,500)+50,100)
                           else playsample(Voice,3,32,min(Car[Num].Revs2 div 3,500)+50,100)
                           else Ch[Voice].Fq:=min(Car[Num].Revs2 div 3,500)+50;

if ((Ch[3].StAlert=4) or (Ch[3].StAlert=0)) then begin
 if (Car[num].Team=1) and start then playsample(3,8,64,130,100)
 else
 if (Car[Num].sgom>0) then playsample(3,4,Min(Car[Num].Sgom+10,28),90,100);
end;

if NumPla=1 then begin
 Aux:=ProxCar(num);
 Dis:=abs(integer(Car[num].Sec^.Numsec)-integer(Car[Aux].Sec^.Numsec));
 if Dis+32>Groad.MaxSec Then Dis:=integer(Groad.Maxsec)-Dis;
 Volume:=32-Dis shl 1;
 if Volume<0 then Volume:=0;
 if ch[2].StAlert=0 then begin
  if Car[Aux].Team=1 then PlaySample(2,8,Volume,130,0)
  else PlaySample(2,3,Volume,min(Car[Aux].Revs2 div 3,500)+50,0)
 end else begin
  if Car[Aux].Team=1 then Ch[2].Fq:=130 else Ch[2].Fq:=min(Car[Aux].Revs2 div 3,500)+50;
  Ch[2].Vl:=Volume
 end
end;

if Car[Num].Dash and Drawing then bob(98+(50*Num),0,Ycoor+55 shl SVGA+3*SVGA);

if Car[Num].Infos then begin
 if Drawing then begin
  bob(80              ,MsX1Clip[Num]+5  shl SVGA,Ycoor +1 shl SVGA);
  bob(82+Car[Num].Gear,MsX1Clip[Num]+36 shl SVGA,Ycoor+38 shl SVGA);

  if Car[Num].Fin and (GameMode<>2) then Bob(549+Car[num].FinPos,150 shl SVGA,Ycoor);

  Angle:=(Car[Num].Revs2 div 5+90);
  if Angle>350 then Angle:=350;
  line(MsX1Clip[Num]+(30                     ) shl SVGA,Ycoor+(35                     ) shl SVGA,
       MsX1Clip[Num]+(30+15*cs[Angle] div 128) shl SVGA,Ycoor+(35+15*sn[Angle] div 128) shl SVGA,36);

  if Car[Num].Speed> 99 then text(MsX1Clip[Num]+32 shl SVGA,Ycoor,tostr( Car[Num].Speed,-15),True) else
  if Car[Num].Speed>  9 then text(MsX1Clip[Num]+40 shl SVGA,Ycoor,tostr( Car[Num].Speed,-15),True) else
  if Car[Num].Speed>  0 then text(MsX1Clip[Num]+48 shl SVGA,Ycoor,tostr( Car[Num].Speed,-15),True) else
  if Car[Num].Speed> -9 then text(MsX1Clip[Num]+48 shl SVGA,Ycoor,tostr(-Car[Num].Speed,-15),True) else
                             text(MsX1Clip[Num]+40 shl SVGA,Ycoor,tostr(-Car[Num].Speed,-15),True) ;
 end;

clipgraph(MsX1clip[Num],MsY1Clip[num],319 shl SVGA,MsY2Clip[Num]);

(****** GameModes ******)
 if GameMode=2 then begin
  if Car[Num].Team=1 then begin
   AddHan[Num]:=15-Ord(Position2(Num))*15;
   if ((ExTipoMess[num]<>TipoMess[num]) and (TimeMess>70)) or (TimeMess>150) then begin TimeMess:=0; ExtipoMess:=TipoMess end;
   BanDis[num]:=abs(integer(Car[Num].Sec^.Numsec)-integer(Car[BanCar].Sec^.Numsec));
   if BanDis[Num]>Groad.MaxSec shr 1 Then BanDis[num]:=integer(Groad.Maxsec)-BanDis[num];
   if BanDis[Num]> 60 then TipoMess[num]:=5 else
   if BanDis[Num]> 40 then TipoMess[num]:=4 else
   if BanDis[Num]> 15 then TipoMess[num]:=3 else
   if BanDis[Num]>  5 then TipoMess[num]:=2 else
   if BanDis[Num]>  1 then TipoMess[num]:=1 ;
   inc(TimeMess);
   if TimeMess<50 then Text(MsX1Clip[Num]+70 shl SVGA,MsY1Clip[Num]+35 shl SVGA,Mess[ExTipoMess[num]],True);
   if NumPla=1 then begin
    TraceBar ('Enemy'   ,MsX1Clip[Num]+5 shl SVGA,MsY1Clip[Num]+ 5 shl SVGA,Car[BanCar].Energy ,1);
    TraceBar ('Distance',MsX1Clip[Num]+5 shl SVGA,MsY1Clip[Num]+13 shl SVGA,BanDis[Num]*5      ,1);
    TraceBar ('Frontier',MsX1Clip[Num]+5 shl SVGA,MsY1Clip[Num]+21 shl SVGA,(6-Lap[BanCar])*50,1);
   end else begin
    FBob(94,278 shl SVGA,MsY1CLip[Num]);
    TraceBarShort ('Enemy   ',280 shl SVGA,MsY1Clip[Num]+ 10 shl SVGA,Car[BanCar].Energy ,7);
    TraceBarShort ('Distance',280 shl SVGA,MsY1Clip[Num]+ 25 shl SVGA,BanDis[Num] shl 2  ,7);
    TraceBarShort ('Frontier',280 shl SVGA,MsY1Clip[Num]+ 40 shl SVGA,(6-Lap[BanCar])*50 ,7);
   end
  end else
  if Car[Num].Team=2 then begin
   AddHan[Num]:=5-Min(Bandis[1],Bandis[2]) div 10;
   ExTipoMess[num]:=ExtipoMess[CopCar];
   if TimeMess<50 then Text(MsX1Clip[Num]+70 shl SVGA,MsY1Clip[Num]+35 shl SVGA,Mess[ExTipoMess[num]+10],True);
   if NumPla=1 then begin
    TraceBar ('Energy  ',MsX1Clip[Num]+5 shl SVGA,MsY1Clip[Num]+ 5 shl SVGA,Car[Num].Energy,1);
    TraceBar ('Distance',MsX1Clip[Num]+5 shl SVGA,MsY1Clip[Num]+13 shl SVGA,Min(BanDis[1],BanDis[2])*5,1);
    TraceBar ('Frontier',MsX1Clip[Num]+5 shl SVGA,MsY1Clip[Num]+21 shl SVGA,(6-Lap[BanCar])*50,1);
   end else begin
    FBob(94,278 shl SVGA,MsY1CLip[Num]);
    TraceBarShort ('Energy  ',280 shl SVGA,MsY1Clip[Num]+ 10 shl SVGA,Car[Num   ].Energy,7);
    TraceBarShort ('Distance',280 shl SVGA,MsY1Clip[Num]+ 25 shl SVGA,Min(BanDis[1],BanDis[2])shl 2,7);
    TraceBarShort ('Frontier',280 shl SVGA,MsY1Clip[Num]+ 40 shl SVGA,(6-Lap[BanCar])*50,7);
   end
  end
  (****** END GAMEMODE>1 *****)
 end else begin
  if NumPla=1 then begin
   AddHan[Num]:=Position(Num);
   FBob(88,  0 shl SVGA,MsY1CLip[Num]);
   Text(    53 shl SVGA,MsY1Clip[Num]+ 8 shl SVGA,tostr(Lap     [Num],0),True );
   Text(    97 shl SVGA,MsY1Clip[Num]+ 8 shl SVGA,      LapTimeS[Num]   ,False);
   Text(   141 shl SVGA,MsY1Clip[Num]+ 8 shl SVGA,     BestTimeS[Num]   ,False);
   Text(   185 shl SVGA,MsY1Clip[Num]+ 8 shl SVGA,     RecTimeS         ,False);
   Text(   230 shl SVGA,MsY1Clip[Num]+ 8 shl SVGA,tostr(  AddHan[Num],0),False);
  end else begin
   AddHan[Num]:=Position(Num);
   FBob(89,278 shl SVGA,MsY1CLip[Num]+ 1);
   Text(   283 shl SVGA,MsY1Clip[Num]+ 8 shl SVGA,tostr(Lap     [Num],0),True );
   Text(   283 shl SVGA,MsY1Clip[Num]+29 shl SVGA,     BestTimeS[Num]   ,False);
   Text(   283 shl SVGA,MsY1Clip[Num]+50 shl SVGA,tostr(AddHan  [Num],0),False);
  end;
  AddHan[num]:=Addhan[num]*2-ord(addHan[num]<2)*5;
 end
end;
if Car[Num].Energy<=0 then Text(120 shl SVGA,MsY2Clip[Num]-15 shl SVGA,'Wreaked...',true);
end;

Procedure InitMisc;
var cnt :byte;
    cnt2:byte;
    F   :File;
 BackStr:String[8];

begin
GetMem(ReplayBuf,45);
SegRepBuf:=Seg(ReplayBuf^);
OfsRepBuf:=Ofs(ReplayBuf^);
Assign(F,'Data\CarsList.CFG');
Reset(F,1);
Blockread(F,BackStr,1);
for cnt:=1 to 10 do begin
BackStr:='';
Blockread(F,BackStr,8);

Carname[cnt]:='';
For cnt2:=1 to 6 do if BackStr[Cnt2]<>' ' then Carname[cnt]:=Carname[cnt]+BackStr[Cnt2];
BlockRead(F,BackStr,3);
end;
close(F);
           Mess[1]:='  ...Hit Bandit Car... ';
           Mess[2]:='   ...Visual Chase...  ';
           Mess[3]:='  ...Please Come On... ';
           Mess[4]:='..Warning Low Contact..';
           Mess[5]:='   ...Contact Lost...  ';
           Mess[6]:='Bandit Take Frontier...';
           Mess[7]:='Bandit Car is Wreaked..';
           Mess[8]:='Bandit is under Arrest ';

           Mess[11]:='..Warning Cop is Near..';
           Mess[12]:='...mmmh, I see a Cop...';
           Mess[13]:=' ...Please Speed Up... ';
           Mess[14]:='..Warning Low Contact..';
           Mess[15]:='   ...You are Safe...  ';
           Mess[16]:='...You Take Frontier...';
           Mess[17]:='..Your Car is Wreaked..';
           Mess[18]:='..You are under Arrest..';

       MirrMess[1]:='Rear';
       MirrMess[2]:='Chase';
       MirrMess[3]:='Front';
       MirrMess[4]:='TV';
       MirrMess[5]:='Mirror';

For cnt:=1 to 8 do Smoke[cnt].id:=1 shl (cnt-1)
end;

Procedure KillMisc;
begin
FreeMem(ReplayBuf,45);
end;

begin
end.
