Unit Fx;

Interface

Const Text1='Visit http://www.datacomm.ch/asuter';

Procedure FadeOut;
Procedure FadeIn;
Procedure GetPal(PalNum:byte;Var R,G,B:byte);
Procedure RestorePal;
Procedure SavePal;
Procedure ScreenOn;
Procedure ScreenOff;
Procedure SetPal(PalNum,R,G,B:Byte);
Procedure WaitRetrace;

Implementation

Var SaveTable:Array [0..255] Of Record
                                      R,G,B:Byte;
                                End;

Procedure GetPal;

Begin
     Port[$3C7]:=PalNum;
     R:=Port[$3C9];
     G:=Port[$3C9];
     B:=Port[$3C9];
End;

Procedure SetPal;Assembler;

Asm
   mov dx, $03c8
   mov al, Palnum
   out dx, al
   inc dx
   mov al, R
   out dx, al
   mov al, G
   out dx, al
   mov al, B
   out dx, al
End;

Procedure WaitRetrace; Assembler;

Asm
   mov dx,$03da
   @l1:
   in al,dx
   and al,$08
   jnz @l1
   @l2:
   in al,dx
   and al,$08
   jz @l2
End;

Procedure FadeOut;

Var I,II:Integer;
    R,G,B:Byte;

Begin
     For I:=0 To 63 Do
         Begin
              For II:=0 To 255 Do
                  Begin
                       GetPal(II,R,G,B);
                       If (R>0) Then Dec(R);
                       If (G>0) Then Dec(G);
                       If (B>0) Then Dec(B);
                       SetPal(II,R,G,B);
                  End;
              WaitRetrace;
         End;
End;

Procedure FadeIn;

Var I,II:Integer;
    R,G,B:Byte;

Begin
     For I:=0 To 63 Do
         Begin
              For II:=0 To 255 Do
                  Begin
                       GetPal(II,R,G,B);
                       If (R<SaveTable[II].R) Then Inc(R);
                       If (G<SaveTable[II].G) Then Inc(G);
                       If (B<SaveTable[II].B) Then Inc(B);
                       SetPal(II,R,G,B);
                  End;
              WaitRetrace;
         End;
End;

Procedure RestorePal;

Var I:Integer;

Begin
     For I:=0 To 255 Do SetPal(I,SaveTable[I].R,SaveTable[I].G,SaveTable[I].B);
End;

Procedure SavePal;

Var I:Integer;

Begin
     For I:=0 To 255 Do GetPal(I,SaveTable[I].R,SaveTable[I].G,SaveTable[I].B);
End;

procedure screenon;assembler;

asm
   mov ah,$12
   mov al,0;
   mov bl,$36
   int 10h
end;

procedure screenoff;assembler;

asm
   mov ah,$12
   mov al,1
   mov bl,$36
   int 10h
end;

Begin
     WriteLn(Text1);
End.
