'Poker Solitaire  v1.0
' Another Public Domain game by Daniel Kalna
' I can be reached at: Helenh@utarlg.uta.edu
'
' This program was written in QuickBasic 4.5
' Compile this program for greater speed.
' Except where noted, all code was written by me.

'NOTE!
' To run this program in the QB45 enviroment,
' run QB45 using the default library:
'      ex:  QB poker /L

' Read POKER.TXT for game play instructions.


DECLARE SUB dispnumb (tsc%, x%, y%)
DECLARE SUB dispresult (x%, y%, sflag%)
DECLARE SUB dispcard (P%, xx%, yy%)
DECLARE SUB Mouse (Funcode%, result%, P2%, P3%, P4%)
OPTION BASE 1
DEFINT A-Z

'$INCLUDE: 'QB.BI'

'--- constants used for the mouse routines.
CONST MInit = 0
CONST showCur = 1
CONST HideCur = 2
CONST MStatus = 3
CONST FALSE = 0, TRUE = NOT FALSE
DIM SHARED Regs AS RegType

RANDOMIZE TIMER

'----- easy mode increases chances of a royal flush being in the deck
' remove the following first REM for a 20% chance of a royal flush,
' or remove the following second REM for a 100% chance.
'
  REM  IF INT(RND * 10) + 1 > 8 THEN easy.mode = 1
  REM  easy.mode=1

start:

 tscore = 0

 REDIM ndx$(53), deck$(52)     'cards index and deck
 REDIM H$(5, 5), HH(5, 5)
 REDIM t$(5)
 REDIM myimage(1)

 GOSUB setup
 GOSUB shuffle.cards
 GOSUB display.hand

top:
  z$ = INKEY$
  IF z$ = CHR$(27) THEN GOTO fini     '---ESC pressed, abort game
 
  Mouse MStatus, 0, MouseButton, MX, MY   '---check mouse status

  fx = 0               '---variables returned by check.mouse showing
  fy = 0               '---what the player selected with the mouse.
  GOSUB check.mouse    '---check to see if and what the mouse was clicked on.

  '---start new game  - mouse clicked on new game icon.  the check mark.
  IF fx = 8 AND fy = 8 THEN
     Mouse HideCur, 0, 0, 0, 0
     GOTO start
  END IF

  '---quit game - mouse clicked on quit game icon.  the X symbol
  IF fx = 9 AND fy = 9 THEN GOTO fini

  '--- mouse clicked on location to place next card.
  IF fx <> 0 AND fy <> 0 THEN
    IF H$(fx, fy) = "" THEN        '---is space available?
       H$(fx, fy) = deck$(dptr)    '---yes, place card on table.
       dptr = dptr + 1             '---increase number of cards placed.
       GOSUB check.score           '---check to see if a hand scored.
       GOSUB display.hand          '---display cards on table.
    END IF
  END IF

  '---if 25 cards have been played, then the game is over.
  IF dptr > 25 THEN LOCATE 26, 62: PRINT " GAME OVER "

GOTO top


'===========================================================================
'--- this block of code display the icons (binary pictures)
'--- for quit, play again, the score chart, and poker title.

disp.icon:

 IF fil$ = "" THEN RETURN

 OPEN fil$ FOR BINARY AS #2
 myArraySize = LOF(2) / 2

 REDIM myimage(myArraySize)

 FOR i = 1 TO myArraySize
   GET #2, , myimage(i)
 NEXT i
 CLOSE #2

 PUT (ix, iy), myimage, PSET

RETURN

'===========================================================================
'---this really BIG block of code checks the cards on the table
'---for any scoring hands.

check.score:
 LOCATE 10, 60
 oxx = 10
 tscore = 0

 'check across
 FOR y = 1 TO 5
   FOR x = 1 TO 5
     t$(x) = H$(x, y)
   NEXT x
   GOSUB analyze.hand
   IF sflag > 0 THEN dispresult 380, yyy(y), sflag: GOSUB ADD.IT
 NEXT y
 
 'check down
 FOR x = 1 TO 5
   FOR y = 1 TO 5
     t$(y) = H$(x, y)
   NEXT y
   GOSUB analyze.hand
   IF sflag > 0 THEN dispresult xxx(x), 460, sflag: GOSUB ADD.IT
 NEXT x
 

RETURN

'------------
ADD.IT:
 IF sflag = 1 THEN tscore = tscore + 1000
 IF sflag = 2 THEN tscore = tscore + 500
 IF sflag = 3 THEN tscore = tscore + 100
 IF sflag = 4 THEN tscore = tscore + 50
 IF sflag = 5 THEN tscore = tscore + 20
 IF sflag = 6 THEN tscore = tscore + 15
 IF sflag = 7 THEN tscore = tscore + 10
 IF sflag = 8 THEN tscore = tscore + 5

RETURN

'------------
analyze.hand:
 sflag = 0

 FOR i = 1 TO 5
  IF t$(i) = "" THEN t$(i) = "999"
 NEXT i
 GOSUB sort.hand
 FOR i = 1 TO 5
  IF t$(i) = "999" THEN t$(i) = ""
 NEXT i

 'check for royal flush
 IF t$(1) = "1S" AND t$(2) = "10S" AND t$(3) = "11S" AND t$(4) = "12S" AND t$(5) = "13S" THEN sflag = 1: RETURN
 IF t$(1) = "1H" AND t$(2) = "10H" AND t$(3) = "11H" AND t$(4) = "12H" AND t$(5) = "13H" THEN sflag = 1: RETURN
 IF t$(1) = "1D" AND t$(2) = "10D" AND t$(3) = "11D" AND t$(4) = "12D" AND t$(5) = "13D" THEN sflag = 1: RETURN
 IF t$(1) = "1C" AND t$(2) = "10C" AND t$(3) = "11C" AND t$(4) = "12C" AND t$(5) = "13C" THEN sflag = 1: RETURN

 'check for straight flush
 CFR = 0
 CFS = 0
 IF VAL(t$(1)) <> VAL(t$(2)) - 1 THEN CFR = 1
 IF VAL(t$(2)) <> VAL(t$(3)) - 1 THEN CFR = 1
 IF VAL(t$(3)) <> VAL(t$(4)) - 1 THEN CFR = 1
 IF VAL(t$(4)) <> VAL(t$(5)) - 1 THEN CFR = 1
 CFF$ = RIGHT$(t$(1), 1)
 IF RIGHT$(t$(2), 1) = CFF$ AND RIGHT$(t$(3), 1) = CFF$ AND RIGHT$(t$(4), 1) = CFF$ AND RIGHT$(t$(5), 1) = CFF$ THEN CFS = 1
 IF CFR = 0 AND CFS = 1 THEN sflag = 2: RETURN

 'check for 4 of a kind
 CFF = VAL(t$(1))
 IF CFF <> 0 THEN IF VAL(t$(2)) = CFF AND VAL(t$(3)) = CFF AND VAL(t$(4)) = CFF THEN sflag = 3: RETURN
 CFF = VAL(t$(2))
 IF CFF <> 0 THEN IF VAL(t$(3)) = CFF AND VAL(t$(4)) = CFF AND VAL(t$(5)) = CFF THEN sflag = 3: RETURN

 'check for full house
 CF1 = VAL(t$(1))
 CF2 = VAL(t$(2))
 CF3 = VAL(t$(3))
 CF4 = VAL(t$(4))
 CF5 = VAL(t$(5))
 IF CF1 <> 0 AND CF2 <> 0 AND CF3 <> 0 AND CF4 <> 0 AND CF5 <> 0 THEN
   IF CF1 = CF2 AND CF3 = CF4 AND CF3 = CF5 THEN sflag = 4: RETURN
   IF CF1 = CF2 AND CF1 = CF3 AND CF4 = CF5 THEN sflag = 4: RETURN
 END IF

 'check for flush
 CFF$ = RIGHT$(t$(1), 1)
 IF CFF$ <> "" THEN IF RIGHT$(t$(2), 1) = CFF$ AND RIGHT$(t$(3), 1) = CFF$ AND RIGHT$(t$(4), 1) = CFF$ AND RIGHT$(t$(5), 1) = CFF$ THEN sflag = 5: RETURN

 'check for straight
 IF VAL(t$(1)) = 1 THEN
    CFR = 0
    IF VAL(t$(2)) <> VAL(t$(3)) - 1 THEN CFR = 1
    IF VAL(t$(3)) <> VAL(t$(4)) - 1 THEN CFR = 1
    IF VAL(t$(4)) <> VAL(t$(5)) - 1 THEN CFR = 1
    IF CFR = 0 THEN sflag = 6: RETURN
  ELSE
    CFR = 0
    IF VAL(t$(1)) <> VAL(t$(2)) - 1 THEN CFR = 1
    IF VAL(t$(2)) <> VAL(t$(3)) - 1 THEN CFR = 1
    IF VAL(t$(3)) <> VAL(t$(4)) - 1 THEN CFR = 1
    IF VAL(t$(4)) <> VAL(t$(5)) - 1 THEN CFR = 1
    IF CFR = 0 THEN sflag = 6: RETURN
 END IF


 'check for 3 of a kind
 CFF = VAL(t$(1))
 IF CFF <> 0 THEN IF VAL(t$(2)) = CFF AND VAL(t$(3)) = CFF THEN sflag = 7: RETURN
 CFF = VAL(t$(2))
 IF CFF <> 0 THEN IF VAL(t$(3)) = CFF AND VAL(t$(4)) = CFF THEN sflag = 7: RETURN
 CFF = VAL(t$(3))
 IF CFF <> 0 THEN IF VAL(t$(4)) = CFF AND VAL(t$(5)) = CFF THEN sflag = 7: RETURN

 'check for 2 pair
 CF1 = VAL(t$(1))
 CF2 = VAL(t$(2))
 CF3 = VAL(t$(3))
 CF4 = VAL(t$(4))
 CF5 = VAL(t$(5))
 IF CF1 <> 0 AND CF3 <> 0 THEN IF CF1 = CF2 AND CF3 = CF4 THEN sflag = 8: RETURN
 IF CF1 <> 0 AND CF4 <> 0 THEN IF CF1 = CF2 AND CF4 = CF5 THEN sflag = 8: RETURN
 IF CF2 <> 0 AND CF4 <> 0 THEN IF CF2 = CF3 AND CF4 = CF5 THEN sflag = 8: RETURN

RETURN

'------------
sort.hand:
 flag = 1
 WHILE flag = 1
   flag = 0
   FOR i = 1 TO 4
    IF VAL(t$(i)) > VAL(t$(i + 1)) THEN SWAP t$(i), t$(i + 1): flag = 1
   NEXT i
 WEND

RETURN

'===========================================================================
'---this block of code checks where the mouse was clicked on the table.

check.mouse:
  IF MouseButton = 1 THEN
     IF MX > 12 AND MY > 7 AND MX < 72 AND MY < 90 THEN fx = 1: fy = 1
     IF MX > 87 AND MY > 7 AND MX < 147 AND MY < 90 THEN fx = 2: fy = 1
     IF MX > 162 AND MY > 7 AND MX < 222 AND MY < 90 THEN fx = 3: fy = 1
     IF MX > 237 AND MY > 7 AND MX < 297 AND MY < 90 THEN fx = 4: fy = 1
     IF MX > 312 AND MY > 7 AND MX < 372 AND MY < 90 THEN fx = 5: fy = 1

     IF MX > 12 AND MY > 99 AND MX < 72 AND MY < 181 THEN fx = 1: fy = 2
     IF MX > 87 AND MY > 99 AND MX < 147 AND MY < 181 THEN fx = 2: fy = 2
     IF MX > 162 AND MY > 99 AND MX < 222 AND MY < 181 THEN fx = 3: fy = 2
     IF MX > 237 AND MY > 99 AND MX < 297 AND MY < 181 THEN fx = 4: fy = 2
     IF MX > 312 AND MY > 99 AND MX < 372 AND MY < 181 THEN fx = 5: fy = 2

     IF MX > 12 AND MY > 189 AND MX < 72 AND MY < 272 THEN fx = 1: fy = 3
     IF MX > 87 AND MY > 189 AND MX < 147 AND MY < 272 THEN fx = 2: fy = 3
     IF MX > 162 AND MY > 189 AND MX < 222 AND MY < 272 THEN fx = 3: fy = 3
     IF MX > 237 AND MY > 189 AND MX < 297 AND MY < 272 THEN fx = 4: fy = 3
     IF MX > 312 AND MY > 189 AND MX < 372 AND MY < 272 THEN fx = 5: fy = 3

     IF MX > 12 AND MY > 280 AND MX < 72 AND MY < 363 THEN fx = 1: fy = 4
     IF MX > 87 AND MY > 280 AND MX < 147 AND MY < 363 THEN fx = 2: fy = 4
     IF MX > 162 AND MY > 280 AND MX < 222 AND MY < 363 THEN fx = 3: fy = 4
     IF MX > 237 AND MY > 280 AND MX < 297 AND MY < 363 THEN fx = 4: fy = 4
     IF MX > 312 AND MY > 280 AND MX < 372 AND MY < 363 THEN fx = 5: fy = 4

     IF MX > 12 AND MY > 371 AND MX < 72 AND MY < 456 THEN fx = 1: fy = 5
     IF MX > 87 AND MY > 371 AND MX < 147 AND MY < 456 THEN fx = 2: fy = 5
     IF MX > 162 AND MY > 371 AND MX < 222 AND MY < 456 THEN fx = 3: fy = 5
     IF MX > 237 AND MY > 371 AND MX < 297 AND MY < 456 THEN fx = 4: fy = 5
     IF MX > 312 AND MY > 371 AND MX < 372 AND MY < 456 THEN fx = 5: fy = 5
    
     '---check for new game - did mouse click here?
     IF MX > 478 AND MY > 339 AND MX < 513 AND MY < 370 THEN fx = 8: fy = 8
    
     'check for quit game
     IF MX > 555 AND MY > 339 AND MX < 590 AND MY < 370 THEN fx = 9: fy = 9

  END IF
RETURN

'===========================================================================
'--- this block of code displays all the cards played so far.

display.hand:
 Mouse HideCur, 0, 0, 0, 0

 FOR i = 1 TO 52
  IF deck$(dptr) = ndx$(i) THEN P = i: EXIT FOR
 NEXT i

 dispcard P, 511, 10

 xx = 10
 yy = 5
 P = 0
 FOR y = 1 TO 5
  FOR x = 1 TO 5
   P = 53
   FOR i = 1 TO 52
    IF H$(x, y) = ndx$(i) AND HH(x, y) = 0 THEN HH(x, y) = 1: P = i: EXIT FOR
   NEXT i
   IF P <> 53 THEN dispcard P, xx, yy
   IF P = 53 AND ftime = 0 THEN dispcard P, xx, yy
   xx = xx + 75
  NEXT x
  yy = yy + 91: xx = 10
 NEXT y

 ftime = 1
 LOCATE 28, 60: PRINT "SCORE:"

 dispnumb tscore, 525, 430

 Mouse showCur, 0, 0, 0, 0

RETURN

'===========================================================================
'--- shuffle the cards....

shuffle.cards:
 RANDOMIZE TIMER

 '---if easy.mode is on then the deck is stacked to insure a royal flush
 '--- will be in the deck.

 RESTORE
 IF easy.mode = 1 THEN
   sht = INT(RND * 4) + 1
   IF sht = 1 THEN RESTORE CHT.DATA1
   IF sht = 2 THEN RESTORE CHT.DATA2
   IF sht = 3 THEN RESTORE CHT.DATA3
   IF sht = 4 THEN RESTORE CHT.DATA4
 END IF

 DATA 1H,2H,3H,4H,5H,6H,7H,8H,9H,10H,11H,12H,13H
 DATA 1D,2D,3D,4D,5D,6D,7D,8D,9D,10D,11D,12D,13D
 DATA 1S,2S,3S,4S,5S,6S,7S,8S,9S,10S,11S,12S,13S
 DATA 1C,2C,3C,4C,5C,6C,7C,8C,9C,10C,11C,12C,13C
 DATA 00
CHT.DATA1:
 DATA 1H,10H,11H,12H,13H,2H,3H,4H,5H,6H,7H,8H,9H
 DATA 1D,2D,3D,4D,5D,6D,7D,8D,9D,10D,11D,12D,13D
 DATA 1S,2S,3S,4S,5S,6S,7S,8S,9S,10S,11S,12S,13S
 DATA 1C,2C,3C,4C,5C,6C,7C,8C,9C,10C,11C,12C,13C
 DATA 00
CHT.DATA2:
 DATA 1D,10D,11D,12D,13D,2D,3D,4D,5D,6D,7D,8D,9D
 DATA 1S,2S,3S,4S,5S,6S,7S,8S,9S,10S,11S,12S,13S
 DATA 1C,2C,3C,4C,5C,6C,7C,8C,9C,10C,11C,12C,13C
 DATA 1H,2H,3H,4H,5H,6H,7H,8H,9H,10H,11H,12H,13H
 DATA 00
CHT.DATA3:
 DATA 1S,10S,11S,12S,13S,2S,3S,4S,5S,6S,7S,8S,9S
 DATA 1C,2C,3C,4C,5C,6C,7C,8C,9C,10C,11C,12C,13C
 DATA 1H,2H,3H,4H,5H,6H,7H,8H,9H,10H,11H,12H,13H
 DATA 1D,2D,3D,4D,5D,6D,7D,8D,9D,10D,11D,12D,13D
 DATA 00
CHT.DATA4:
 DATA 1C,10C,11C,12C,13C,2C,3C,4C,5C,6C,7C,8C,9C
 DATA 1H,2H,3H,4H,5H,6H,7H,8H,9H,10H,11H,12H,13H
 DATA 1D,2D,3D,4D,5D,6D,7D,8D,9D,10D,11D,12D,13D
 DATA 1S,2S,3S,4S,5S,6S,7S,8S,9S,10S,11S,12S,13S
 DATA 00

 FOR i = 1 TO 52
  READ deck$(i)
 NEXT i

 IF easy.mode = 1 THEN
  FOR i = 1 TO 1000
    s1 = INT(RND * 47) + 6
    s2 = INT(RND * 47) + 6
    IF s1 <> s2 THEN SWAP deck$(s1), deck$(s2)
  NEXT i
 END IF

 FOR i = 1 TO 1000
   IF easy.mode = 1 THEN s1 = INT(RND * 25) + 1 ELSE s1 = INT(RND * 52) + 1
   IF easy.mode = 1 THEN s2 = INT(RND * 25) + 1 ELSE s2 = INT(RND * 52) + 1
   IF s1 <> s2 THEN SWAP deck$(s1), deck$(s2)
 NEXT i

 REDIM H$(5, 5), HH(5, 5)
 dptr = 1
 ftime = 0

RETURN

'===========================================================================
'===========================================================================
'--- this block of code initializes the game, draw the game board, display
'--- binary graphics, etc....

setup:
 SCREEN 12
 WIDTH 80, 30
 CLS

 RANDOMIZE TIMER

 LINE (0, 0)-(640, 480), 2, BF
 LINE (448, 110)-(635, 329), 14, B
 LINE (448, 0)-(635, 479), 14, B

 fil$ = "poker.bin": ix = 510: iy = 112
 GOSUB disp.icon

 fil$ = "score1.bin": ix = 450: iy = 140
 GOSUB disp.icon

 fil$ = "score2.bin": ix = 450: iy = 225
 GOSUB disp.icon

 fil$ = "start.bin": ix = 475: iy = 335
 GOSUB disp.icon

 fil$ = "stop.bin": ix = 550: iy = 335
 GOSUB disp.icon

 dispnumb 1000, 565, 140
 dispnumb 500, 565, 161
 dispnumb 100, 565, 182
 dispnumb 50, 565, 203
 dispnumb 20, 565, 224
 dispnumb 15, 565, 245
 dispnumb 10, 565, 266
 dispnumb 5, 565, 287

 'Initialize mouse driver
 Mouse MInit, result, Buttons, 0, 0
 IF NOT result THEN SCREEN 0: PRINT "No mouse detected.": END

 'read  in card index
 OPEN "cardsm.ndx" FOR INPUT AS #1
 FOR i = 1 TO 53: INPUT #1, ndx$(i): NEXT i: CLOSE #1

'------------------------------
 xxx(1) = 12
 xxx(2) = 87
 xxx(3) = 162
 xxx(4) = 238
 xxx(5) = 312

 yyy(1) = 36
 yyy(2) = 127
 yyy(3) = 218
 yyy(4) = 310
 yyy(5) = 400

 Mouse showCur, 0, 0, 0, 0
RETURN

'===========================================================================
'--- the game is over, hide the mouse, quit the program.

fini:
 Mouse HideCur, 0, 0, 0, 0
 SCREEN 0
 CLOSE
 END

SUB dispcard (i, xx, yy)

 filename$ = "cardsm.dat"
 xloc = xx
 yloc = yy
 CurrentFrame& = i
 blocksize& = 1604

 REDIM destarray(1 TO blocksize&)
 fileoffset& = ((blocksize& * 2) * CurrentFrame&) - (blocksize& * 2) + 1
 datalength& = blocksize& * 2
      

'==========================================================================
' The following code to quickly load arrays is provided by:

'           Fast Loader for QBasic/QuickBASIC v1.0 (freeware)
'            Written by Molnar \ Kucalaba Productions, 1996
' FLoad  -- Quickly loads a file's contents into specified integer array.

' --Parameters--
' FileName$  = The file name to load
' FileOffset& = The offset of the file to start loading
' DataLength& = The amount, in bytes, of data to load.
' DestArray() = The array to load all the data into.

IF fileoffset& = 0 THEN fileoffset& = 1

RemBytes& = datalength&
BufferSize% = 32766   ' The buffer size to use.  If you get out of string
                      ' space errors, lower it.  (result : it's slower)

BufStart% = LBOUND(destarray) ' Lowest element number of buffer

DEF SEG = VARSEG(destarray(BufStart%)) ' The segment of the song buffer

Ptr& = VARPTR(destarray(BufStart%))    ' Pointer to the song buffer

LeftBytes& = RemBytes& MOD BufferSize% ' The amount of left over bytes

 ff = FREEFILE
 OPEN filename$ FOR BINARY AS ff
  SEEK ff, fileoffset&
   IF (LeftBytes& < RemBytes&) THEN
      FOR QuickLoad% = 1 TO (datalength& - LeftBytes&) / BufferSize%
          Buffer$ = SPACE$(BufferSize%)
          GET ff, , Buffer$
          FOR x% = 1 TO BufferSize%
              POKE Ptr&, ASC(MID$(Buffer$, x%, 1))
              Ptr& = Ptr& + 1
          NEXT x%
          Buffer$ = ""
          RemBytes& = RemBytes& - BufferSize%
      NEXT QuickLoad%
   END IF
   IF (LeftBytes& > 0) THEN
      Buffer$ = SPACE$(LeftBytes&)
      GET ff, , Buffer$
      FOR x% = 1 TO LeftBytes&
          POKE Ptr&, ASC(MID$(Buffer$, x%, 1))
          Ptr& = Ptr& + 1
      NEXT x%
      Buffer$ = ""
   END IF
   DEF SEG
                                                                                                                                                                               
   CLOSE ff

   PUT (xloc, yloc), destarray, PSET

END SUB

SUB dispnumb (tsc, x, y)

 tsc$ = LTRIM$(RTRIM$(STR$(tsc)))
 xx = x
 yy = y

 FOR i = 1 TO LEN(tsc$)
  t = VAL(MID$(tsc$, i, 1)) + 1
 
  filename$ = "screen1.dat"
  CurrentFrame& = t
  blocksize& = 74
  
  REDIM destarray(1 TO blocksize&)
  fileoffset& = ((blocksize& * 2) * CurrentFrame&) - (blocksize& * 2) + 1
  datalength& = blocksize& * 2
      

  '==========================================================================
  ' The following code to quickly load arrays is provided by:

  '           Fast Loader for QBasic/QuickBASIC v1.0 (freeware)
  '            Written by Molnar \ Kucalaba Productions, 1996
  ' FLoad  -- Quickly loads a file's contents into specified integer array.

  ' --Parameters--
  ' FileName$  = The file name to load
  ' FileOffset& = The offset of the file to start loading
  ' DataLength& = The amount, in bytes, of data to load.
  ' DestArray() = The array to load all the data into.
  
  IF fileoffset& = 0 THEN fileoffset& = 1
  
  RemBytes& = datalength&
  BufferSize% = 32766   ' The buffer size to use.  If you get out of string
                        ' space errors, lower it.  (result : it's slower)
  
  BufStart% = LBOUND(destarray) ' Lowest element number of buffer
  
  DEF SEG = VARSEG(destarray(BufStart%)) ' The segment of the song buffer
  
  Ptr& = VARPTR(destarray(BufStart%))    ' Pointer to the song buffer
  
  LeftBytes& = RemBytes& MOD BufferSize% ' The amount of left over bytes
  
   ff = FREEFILE
   OPEN filename$ FOR BINARY AS ff
    SEEK ff, fileoffset&
     IF (LeftBytes& < RemBytes&) THEN
        FOR QuickLoad% = 1 TO (datalength& - LeftBytes&) / BufferSize%
            Buffer$ = SPACE$(BufferSize%)
            GET ff, , Buffer$
            FOR x% = 1 TO BufferSize%
                POKE Ptr&, ASC(MID$(Buffer$, x%, 1))
                Ptr& = Ptr& + 1
            NEXT x%
            Buffer$ = ""
            RemBytes& = RemBytes& - BufferSize%
        NEXT QuickLoad%
     END IF
     IF (LeftBytes& > 0) THEN
        Buffer$ = SPACE$(LeftBytes&)
        GET ff, , Buffer$
        FOR x% = 1 TO LeftBytes&
            POKE Ptr&, ASC(MID$(Buffer$, x%, 1))
            Ptr& = Ptr& + 1
        NEXT x%
        Buffer$ = ""
     END IF
     DEF SEG
                                                                                                                                                                                 
     CLOSE ff
  
     PUT (xx, yy), destarray, PSET
   
    '========
    xx = xx + 12
    
 NEXT i

END SUB

SUB dispresult (x, y, sflag)

  xx = x: yy = y
  filename$ = "screen2.dat"
  CurrentFrame& = sflag
  blocksize& = 272
 
  REDIM destarray(1 TO blocksize&)
  fileoffset& = ((blocksize& * 2) * CurrentFrame&) - (blocksize& * 2) + 1
  datalength& = blocksize& * 2
     

  '==========================================================================
  ' The following code to quickly load arrays is provided by:

  '           Fast Loader for QBasic/QuickBASIC v1.0 (freeware)
  '            Written by Molnar \ Kucalaba Productions, 1996
  ' FLoad  -- Quickly loads a file's contents into specified integer array.

  ' --Parameters--
  ' FileName$  = The file name to load
  ' FileOffset& = The offset of the file to start loading
  ' DataLength& = The amount, in bytes, of data to load.
  ' DestArray() = The array to load all the data into.
 
  IF fileoffset& = 0 THEN fileoffset& = 1
 
  RemBytes& = datalength&
  BufferSize% = 32766   ' The buffer size to use.  If you get out of string
                        ' space errors, lower it.  (result : it's slower)
 
  BufStart% = LBOUND(destarray) ' Lowest element number of buffer
 
  DEF SEG = VARSEG(destarray(BufStart%)) ' The segment of the song buffer
 
  Ptr& = VARPTR(destarray(BufStart%))    ' Pointer to the song buffer
 
  LeftBytes& = RemBytes& MOD BufferSize% ' The amount of left over bytes
 
   ff = FREEFILE
   OPEN filename$ FOR BINARY AS ff
    SEEK ff, fileoffset&
     IF (LeftBytes& < RemBytes&) THEN
        FOR QuickLoad% = 1 TO (datalength& - LeftBytes&) / BufferSize%
            Buffer$ = SPACE$(BufferSize%)
            GET ff, , Buffer$
            FOR x% = 1 TO BufferSize%
                POKE Ptr&, ASC(MID$(Buffer$, x%, 1))
                Ptr& = Ptr& + 1
            NEXT x%
            Buffer$ = ""
            RemBytes& = RemBytes& - BufferSize%
        NEXT QuickLoad%
     END IF
     IF (LeftBytes& > 0) THEN
        Buffer$ = SPACE$(LeftBytes&)
        GET ff, , Buffer$
        FOR x% = 1 TO LeftBytes&
            POKE Ptr&, ASC(MID$(Buffer$, x%, 1))
            Ptr& = Ptr& + 1
        NEXT x%
        Buffer$ = ""
     END IF
     DEF SEG
                                                                                                                                                                                
     CLOSE ff
 
     PUT (xx, yy), destarray, PSET

END SUB

SUB Mouse (Funcode, result, P2, P3, P4)
'---I found the mouse routines in a demo program
'---called rodent.bas by PC Magazine.
Regs.ax = Funcode
Regs.bx = P2
Regs.cx = P3
Regs.dx = P4
INTERRUPT &H33, Regs, Regs
result = Regs.ax
P2 = Regs.bx
P3 = Regs.cx
P4 = Regs.dx
END SUB

