'                                     
'       ۰           ۰              ۱
'       ۰    ۰  ۰    ۰  ۰   ۰  ۰    ۰     ۱    ۱        
'          ۰    ۰  ۰   ۰  ۰           ۱       ۱
'       ۰   ۰    ۰  ۰   ۰  ۰          ۱       
'       ۰        ۰    ۰  ۰   ۰  ۰   ۰          ۱      ۱
'       ۰            ۰    ۰                 
'                                              
'
'       Copyright (C) DarkDreams Software, 1997
'
'       Programmed by: DarkDread
'
'       darkdread@geocities.com
'       http://www.GeoCities.com/SiliconValley/Pines/1732/
'
'       Well, a while back, as programming Dark Crown (My Final Fantasy (tm)
'       style RPG, in case you didn't know) was getting boring, I decided to
'       take a break and work on something new.  Since there are many Pong
'       games out there already I thought to myself: "What could I do to make
'       Pong interesting?"
'       So, that is how I came up with the idea of Pong 97.  Basically, if
'       you know Pong, then you shouldn't have a problem with Pong 97.  The
'       difference is that this version has over 50 levels with all kinds of
'       suprises.  You can play either a 1 player game, where you go through
'       all of the levels, or a two player game where you can load any level
'       and go head-to-head with a friend.
'       Finally, what makes Pong 97 interesting (Aside from the actual game!)
'       is the fact that you can create your own levels! Using the Pong 97
'       Level Editor (tm) you can make all kinds of levels! So, what I'm
'       getting at here is: if you've made some cool levels (Either for 1 or
'       for 2 player mode) then send 'em in to me (darkdread@geocities.com)
'       and I'll post them on my website with your name beside 'em!
'       Well, thanks for listening (If you bothered to read this!) and have
'       fun with the game.
'       Oh yeah, this game is freeware.  You may use it for as long as you
'       wish, so long as you don't distribute modified copies.  You may also
'       use any part of this code in your own programs as long as you give
'       me (DarkDread) credit.  Use this software at your own risk, I assume
'       no responsibility.
'
'       Special Thanks
'
'       Angelo Mottola Soft (For the 'SoundLab' sound fx editor)
'       Kurt Kuzba (For the PIT delay)
'       Petter Holmberg (For the fade routines)
'       ???? (For the SB volume code, I forget who I got this from!)
'       Lianne (For some helpful ideas)
'
'       One more thing: This game might run a bit slow on a 486/33 or lower
'       machine in Qbasic.  Compile it and it should be fine.  A compiled
'       version of this runs great on my machine [A 386/40 (Please don't make
'       fun of those who have slow computers) :o] so you should have no
'       problem.
'
'       Oh, and the controls are as follows:
'
'                               Left            Right           Stop
'       Player One:                A                D              S
'       Player Two:       Left Arrow      Right Arrow     Down Arrow
'
'       More is explained in the help option at the main menu.  Enjoy.
'
'                       Hail from the Darkness...
'
'                                                ... DarkDread
'

DECLARE SUB AreaClear ()
DECLARE SUB Beat45 ()
DECLARE SUB BoomPlayer ()
DECLARE SUB Credits ()
DECLARE SUB DCPreview ()
DECLARE SUB DialogBox ()
DECLARE SUB Delay (Seconds!)
DECLARE SUB DrawField ()
DECLARE SUB EndMessage ()
DECLARE SUB EnterName ()
DECLARE SUB EnterScore ()
DECLARE SUB Extend1 ()
DECLARE SUB Extend2 ()
DECLARE SUB FastPlayer1 ()
DECLARE SUB FastPlayer2 ()
DECLARE SUB Fence ()
DECLARE SUB GameMenu ()
DECLARE SUB GetBallDir ()
DECLARE SUB Help ()
DECLARE SUB LocateFX ()
DECLARE SUB LoadFile ()
DECLARE SUB LoadLevel ()
DECLARE SUB LoadSound ()
DECLARE SUB MakeFence ()
DECLARE SUB Mixer (Left%, Right%, GetVol%)
DECLARE SUB MoveBall ()
DECLARE SUB MoveComputer1 ()
DECLARE SUB MoveComputer2 ()
DECLARE SUB MovePlayer1 ()
DECLARE SUB MovePlayer2 ()
DECLARE SUB Pulse ()
DECLARE SUB PutBlank1 ()
DECLARE SUB PutBlank2 ()
DECLARE SUB PutPaddle1 ()
DECLARE SUB PutPaddle2 ()
DECLARE SUB SetUp ()
DECLARE SUB Shorten1 ()
DECLARE SUB Shorten2 ()
DECLARE SUB ShowHighScores ()
DECLARE SUB ShowMenu ()
DECLARE SUB SlowPlayer1 ()
DECLARE SUB SlowPlayer2 ()
DECLARE SUB TitleScreen ()
DECLARE SUB UpdateStatus ()
DECLARE FUNCTION PITCal& ()

TYPE PalType
  red AS INTEGER
  green AS INTEGER
  blue AS INTEGER
END TYPE

DIM SHARED rgbpal(0 TO 255) AS PalType
DIM SHARED palmem(0 TO 255) AS PalType

DECLARE SUB WaitRetrace ()

DECLARE SUB FadeOut (keepcolor%, rangestart%, rangeend%, rgbpal() AS PalType, palmem() AS PalType)
DECLARE SUB FadeIn (keepcolor%, rangestart%, rangeend%, rgbpal() AS PalType, palmem() AS PalType)
DECLARE SUB BrightenOut (keepcolor%, rangestart%, rangeend%, rgbpal() AS PalType, palmem() AS PalType)
DECLARE SUB BrightenIn (keepcolor%, rangestart%, rangeend%, rgbpal() AS PalType, palmem() AS PalType)

'$DYNAMIC
DEFINT A-Z

DECLARE SUB PlayFX (FXnum)
DECLARE FUNCTION LoadFx (FXFileName$)

ON ERROR GOTO ErrorTrap

DIM SHARED Block1(201)          ' Blinking steel like block.
DIM SHARED Block2(201)          ' Regular steel like block.
DIM SHARED Block3(201)          ' Slow down player one.
DIM SHARED Block4(201)          ' Speed up player one.
DIM SHARED Block5(201)          ' Slow down player two.
DIM SHARED Block6(201)          ' Speed up player two.
DIM SHARED Block7(201)          ' Extend player two.
DIM SHARED Block8(201)          ' Extend player one.
DIM SHARED Block9(201)          ' Shorten player one.
DIM SHARED Block10(201)         ' Shorten player two.
DIM SHARED Block11(201)         ' Bubble-like block.
DIM SHARED Block12(201)         ' Evil face.
DIM SHARED Block13(201)         ' Castle wall.
DIM SHARED Paddle1a(101)        ' Blue player 1 paddle.
DIM SHARED Paddle1b(151)        ' Blue player 1 paddle + 5.
DIM SHARED Paddle1c(201)        ' Blue player 1 paddle + 10.
DIM SHARED Paddle2a(101)        ' Green player 2 paddle.
DIM SHARED Paddle2b(151)        ' Green player 2 paddle + 5.
DIM SHARED Paddle2c(201)        ' Green player 2 paddle + 10.
DIM SHARED Blank1(101)          ' Black box a.
DIM SHARED Blank2(151)          ' Black box b.
DIM SHARED Blank3(201)          ' Black box c.
DIM SHARED Ball(42)             ' The ball!
DIM SHARED EndPic(5387)         ' Picture shown after each area is cleared.

DIM SHARED Level(16, 9)

DIM SHARED FileName$
DIM SHARED BallDir$
DIM SHARED Player1Dir$, Player2Dir$
DIM SHARED Player1X AS INTEGER, Player2X AS INTEGER
DIM SHARED BallX AS INTEGER, BallY AS INTEGER
DIM SHARED Collision AS INTEGER
DIM SHARED Quit AS INTEGER
DIM SHARED Players AS INTEGER
DIM SHARED Score1 AS INTEGER, Score2 AS INTEGER
DIM SHARED red AS INTEGER, green AS INTEGER, blue AS INTEGER
DIM SHARED Wins1 AS INTEGER, Wins2 AS INTEGER
DIM SHARED Speed1 AS INTEGER, Speed2 AS INTEGER
DIM SHARED Length1 AS INTEGER, Length2 AS INTEGER
DIM SHARED SpeedCpu2 AS INTEGER
DIM SHARED CurrentLevel AS INTEGER
DIM SHARED HitWhat AS INTEGER
DIM SHARED LevelLoaded AS INTEGER
DIM SHARED FenceType AS INTEGER
DIM SHARED File AS INTEGER
DIM SHARED SoundCard%, Speed!
REDIM SHARED Snd(1 TO 500) AS STRING * 30
DIM SHARED PIT(1) AS LONG

BasePort% = &H220                               ' ***************************
                                                ' * NOTE: You may need to   *
                                                ' * Change this to whatever *
                                                ' * the base port of your   *
                                                ' * sound card is, but 220  *
                                                ' * is fairly standard so   *
                                                ' * you probably shouldn't  *
                                                ' * worry.  If you do not   *
                                                ' * have a sound card, then *
                                                ' * this won't affect you.  *
                                                ' ***************************
CONST True = -1, False = 0
CONST Player1Y = 190, Player2Y = 20
PIT(0) = PITCal: COLOR 12

File = 1
OPEN "SETTINGS.CFG" FOR INPUT AS #1
INPUT #1, Speed!, SoundCard%
CLOSE #1

File = 2

SCREEN 13
PRINT "Free array memory:"; FRE(-1)
PRINT "Please wait..."

FadeOut 0, 0, 255, rgbpal(), palmem()
DEF SEG = &HA000
BLOAD "RETRO.FSI"
FadeIn 0, 0, 255, rgbpal(), palmem()

CALL SetUp
IF SoundCard% THEN
    CALL LoadSound
    CALL Mixer(15, 15, -1)
END IF

FadeOut 0, 0, 255, rgbpal(), palmem()
CALL TitleScreen
FadeIn 0, 0, 255, rgbpal(), palmem()

WHILE INKEY$ <> "": WEND
LOCATE 14, 13
PRINT "Press any key.."
WHILE INKEY$ = "": WEND

RANDOMIZE TIMER

DO
    IF Players = 2 THEN CALL GameMenu
    IF Quit THEN EXIT DO
   
    DO
        CALL GetBallDir
        CALL DrawField
   
        DO
            SELECT CASE INKEY$
            CASE IS = "A", "a"
                Player1Dir$ = "l"
            CASE IS = "D", "d"
                Player1Dir$ = "r"
            CASE IS = "S", "s"
                Player1Dir$ = "s"
            CASE CHR$(0) + CHR$(75)
                Player2Dir$ = "l"
            CASE CHR$(0) + CHR$(77)
                Player2Dir$ = "r"
            CASE CHR$(0) + CHR$(80)
                Player2Dir$ = "s"
            CASE IS = "P", "p"
                CALL DialogBox
                LOCATE 14, 17
                PRINT "Paused"
                WHILE INKEY$ <> "": WEND
                WHILE INKEY$ = "": WEND
                CALL DrawField
            CASE CHR$(27)
                Done = True
            END SELECT
   
            CALL MoveBall
            CALL MovePlayer1
            IF Players = 2 THEN CALL MovePlayer2 ELSE CALL MoveComputer1
            CALL Pulse

            IF Speed! > 0 THEN Delay Speed!
            WAIT &H3DA, 8

            IF BallY + 10 > 199 OR BallY < 21 OR Done THEN LostLife = True
  
        LOOP UNTIL LostLife
   
        CALL BoomPlayer
        Speed1 = 2: Speed2 = 2: SpeedCpu2 = 1
        Length1 = 0: Length2 = 0
        IF BallY + 10 > 199 THEN Score2 = Score2 + 1 ELSE IF BallY < 21 THEN Score1 = Score1 + 1
        IF Score1 = 4 OR Score2 = 4 OR Done THEN GameOver = True
        LostLife = False
        CALL UpdateStatus
   
    LOOP UNTIL GameOver

    IF Players = 2 THEN

            Wins1 = 0: Wins2 = 0
            CLS

            PRINT "Final Score"
            PRINT
            PRINT "Player 1: "; Score1
            PRINT "Player 2: "; Score2
            PRINT

            IF Score1 > Score2 THEN
                    COLOR 1
                    PRINT "Player 1 is the winner!"
                ELSEIF Score1 < Score2 THEN
                    COLOR 2
                    PRINT "Player 2 is the winner!"
                ELSE
                    COLOR 4
                    PRINT "We have a draw!"
            END IF
            Delay 2
            WHILE INKEY$ = "": WEND
        ELSE
            IF Score2 < 4 AND Score1 < 4 THEN Score2 = 4
            IF Score2 > Score1 THEN
                    COLOR 2
                    CALL DialogBox
                    LOCATE 14, 14
                    PRINT "You have lost."
                    Delay 2
                    WHILE INKEY$ = "": WEND
                    CALL EnterScore
                    CurrentLevel = 1
                    Wins1 = 0: Wins2 = 0
                    Players = 2
                ELSEIF Score1 > Score2 THEN
                    COLOR 1
                    CALL DialogBox
                    LOCATE 14, 8
                    PRINT "Advancing to next level..."
                    Delay 3
                    IF CurrentLevel < 46 THEN CurrentLevel = CurrentLevel + 1
                    Wins1 = Wins1 + 1
                    IF CurrentLevel = 16 OR CurrentLevel = 31 OR CurrentLevel = 46 THEN CALL AreaClear
                    IF CurrentLevel < 46 THEN
                        FileName$ = "level" + RTRIM$(LTRIM$(STR$(CurrentLevel)))
                        CALL LoadFile
                    END IF
                    IF CurrentLevel = 46 THEN CALL Beat45

            END IF
    END IF
    Score1 = 0: Score2 = 0: GameOver = False: Done = False

LOOP

SYSTEM

ErrorTrap:
SELECT CASE ERR
CASE IS = 53
    IF File = 1 THEN
            CLS
            PRINT "Please run the SETUP.BAS file first..."
            WHILE INKEY$ = "": WEND
            SYSTEM
        ELSEIF File = 2 THEN
            FileExist = False
            CALL DialogBox
            LOCATE 14, 4
            PRINT "That file does not exist!"
            WHILE INKEY$ = "": WEND
            RESUME NEXT
    END IF
CASE ELSE
    SCREEN 0: WIDTH 80
    PRINT "An unexpected program error has occured.  The error code was:"; ERR
    PRINT "Why not be a dear (Or a moose, if you want), and e-mail me with the error code  "
    PRINT "number.  Thanks.                                         darkdread@geocities.com"
    WHILE INKEY$ = "": WEND
END SELECT

SYSTEM

REM $STATIC
SUB AreaClear

    LINE (0, 0)-(319, 199), 0, BF
    FOR I = 0 TO 199
        Y = INT(RND * 200)
        X = INT(RND * 320)
        Colour = INT(RND * 2) + 7
        PSET (X, Y), Colour
    NEXT I
    PUT (93, 20), EndPic, PSET
    COLOR 4
    LOCATE 15, 13
    PRINT "Congratulations!"
    IF CurrentLevel = 16 THEN
            Area = 1
        ELSEIF CurrentLevel = 31 THEN
            Area = 2
        ELSEIF CurrentLevel = 46 THEN
            Area = 3
    END IF
    LOCATE 17, 10
    PRINT "You have beaten area"; Area
    WHILE INKEY$ = "": WEND

END SUB

SUB Beat45
   
    LINE (0, 0)-(319, 199), 0, BF
    FOR NumStars = 1 TO 200
        Y = INT(RND * 200)
        X = INT(RND * 320)
        Colour = INT(RND * 2) + 7
        PSET (X, Y), Colour
    NEXT NumStars

    COLOR 1
    LOCATE 2, 13
    PRINT "Congratulations!"
    LOCATE 4, 5
    PRINT "You have completed the main   "
    LOCATE 5, 5
    PRINT "levels of Pong 97! Thank you  "
    LOCATE 6, 5
    PRINT "for playing...                "
    WHILE INKEY$ = "": WEND
   
    CALL Credits
    CALL EnterScore
    CurrentLevel = 1
    Wins1 = 0: Wins2 = 0
    Players = 2

END SUB

SUB BoomPlayer

    CALL Mixer(15, 15, 0)
    IF BallY < 21 THEN
            LINE (20, 20)-(299, 39), 0, BF
            IF SoundCard% THEN CALL PlayFX(3)
            FOR I = 1 TO 20
                PixelX = INT(RND * 20) + Length2 + 1
                PixelY = INT(RND * 9) + 1
                Colour = INT(RND * 10) + 20
                PSET (Player2X + PixelX, Player2Y + PixelY), Colour
            NEXT I
            Delay 2.5
        ELSEIF BallY + 10 > 199 THEN
            LINE (20, 180)-(299, 199), 0, BF
            IF SoundCard% THEN CALL PlayFX(6)
            FOR I = 1 TO 20
                PixelX = INT(RND * 20) + Length1 + 1
                PixelY = INT(RND * 9) + 1
                Colour = INT(RND * 10) + 20
                PSET (Player1X + PixelX, Player1Y + PixelY), Colour
            NEXT I
            Delay 2.5
    END IF

END SUB

DEFSNG A-Z
SUB BrightenIn (keepcolor%, rangestart%, rangeend%, rgbpal() AS PalType, palmem() AS PalType)

' Description:
' ------------
' This SUB fades back a previously brightened out screen:
'
' Input:
' ------
' palmem() : Previous palette values.
'
' keepcolor%  : Color to keep (0:none, 1:red, 2:green, 3:blue,
'                              4:yellow, 5:magneta, 6:cyan, 7:all)
' rangestart% : First color index to brighten in (0-255).
' rangeend%   : Last color index to brighten in (0-255).

' --- Save the present palette for modification:

OUT &H3C7, rangestart%

FOR savepresentpal% = rangestart% TO rangeend%
   rgbpal(savepresentpal%).red = INP(&H3C9)
   rgbpal(savepresentpal%).green = INP(&H3C9)
   rgbpal(savepresentpal%).blue = INP(&H3C9)
NEXT savepresentpal%

' --- Set the new palette:

FOR brighteninpal% = 0 TO 63

   FOR brightenscan% = rangestart% TO rangeend%
      SELECT CASE keepcolor%
      CASE 0
       IF palmem(brightenscan%).red < brighteninpal% AND rgbpal(brightenscan%).red > palmem(brightenscan%).red THEN rgbpal(brightenscan%).red = rgbpal(brightenscan%).red - 1
       IF palmem(brightenscan%).green < brighteninpal% AND rgbpal(brightenscan%).green > palmem(brightenscan%).green THEN rgbpal(brightenscan%).green = rgbpal(brightenscan%).green - 1
       IF palmem(brightenscan%).blue < brighteninpal% AND rgbpal(brightenscan%).blue > palmem(brightenscan%).blue THEN rgbpal(brightenscan%).blue = rgbpal(brightenscan%).blue - 1
      CASE 1
       IF palmem(brightenscan%).green < brighteninpal% AND rgbpal(brightenscan%).green > palmem(brightenscan%).green THEN rgbpal(brightenscan%).green = rgbpal(brightenscan%).green - 1
       IF palmem(brightenscan%).blue < brighteninpal% AND rgbpal(brightenscan%).blue > palmem(brightenscan%).blue THEN rgbpal(brightenscan%).blue = rgbpal(brightenscan%).blue - 1
      CASE 2
       IF palmem(brightenscan%).red < brighteninpal% AND rgbpal(brightenscan%).red > palmem(brightenscan%).red THEN rgbpal(brightenscan%).red = rgbpal(brightenscan%).red - 1
       IF palmem(brightenscan%).blue < brighteninpal% AND rgbpal(brightenscan%).blue > palmem(brightenscan%).blue THEN rgbpal(brightenscan%).blue = rgbpal(brightenscan%).blue - 1
      CASE 3
       IF palmem(brightenscan%).red < brighteninpal% AND rgbpal(brightenscan%).red > palmem(brightenscan%).red THEN rgbpal(brightenscan%).red = rgbpal(brightenscan%).red - 1
       IF palmem(brightenscan%).green < brighteninpal% AND rgbpal(brightenscan%).green > palmem(brightenscan%).green THEN rgbpal(brightenscan%).green = rgbpal(brightenscan%).green - 1
      CASE 4
       IF palmem(brightenscan%).blue < brighteninpal% AND rgbpal(brightenscan%).blue > palmem(brightenscan%).blue THEN rgbpal(brightenscan%).blue = rgbpal(brightenscan%).blue - 1
      CASE 5
       IF palmem(brightenscan%).green < brighteninpal% AND rgbpal(brightenscan%).green > palmem(brightenscan%).green THEN rgbpal(brightenscan%).green = rgbpal(brightenscan%).green - 1
      CASE 6
       IF palmem(brightenscan%).red < brighteninpal% AND rgbpal(brightenscan%).red > palmem(brightenscan%).red THEN rgbpal(brightenscan%).red = rgbpal(brightenscan%).red - 1
      END SELECT
   NEXT brightenscan%

   OUT &H3C8, rangestart%
   WaitRetrace

   FOR brightenpal% = rangestart% TO rangeend%
      OUT &H3C9, rgbpal(brightenpal%).red
      OUT &H3C9, rgbpal(brightenpal%).green
      OUT &H3C9, rgbpal(brightenpal%).blue
   NEXT brightenpal%

NEXT brighteninpal%

END SUB

SUB BrightenOut (keepcolor%, rangestart%, rangeend%, rgbpal() AS PalType, palmem() AS PalType)

' Description:
' ------------
' This SUB brightens desired RGB values to white:
'
' Input:
' ------
' keepcolor%  : Color to keep (0:none, 1:red, 2:green, 3:blue,
'                              4:yellow, 5:magneta, 6:cyan, 7:all)
' rangestart% : First color index to brighten out (0-255).
' rangeend%   : Last color index to brighten out (0-255).
'
' Output:
' ------
' palmem() : Previous palette values.

' --- Save the old palette:

OUT &H3C7, rangestart%

FOR saveoldpal% = rangestart% TO rangeend%
   palmem(saveoldpal%).red = INP(&H3C9)
   palmem(saveoldpal%).green = INP(&H3C9)
   palmem(saveoldpal%).blue = INP(&H3C9)
NEXT saveoldpal%

' --- Save the present palette for modification:

OUT &H3C7, rangestart%

FOR savepresentpal% = rangestart% TO rangeend%
   rgbpal(savepresentpal%).red = INP(&H3C9)
   rgbpal(savepresentpal%).green = INP(&H3C9)
   rgbpal(savepresentpal%).blue = INP(&H3C9)
NEXT savepresentpal%

' --- Set the new palette:

FOR brightenoutpal% = 0 TO 63
   FOR brightenscan% = rangestart% TO rangeend%
      SELECT CASE keepcolor%
      CASE 0
       IF rgbpal(brightenscan%).red < 63 THEN rgbpal(brightenscan%).red = rgbpal(brightenscan%).red + 1
       IF rgbpal(brightenscan%).green < 63 THEN rgbpal(brightenscan%).green = rgbpal(brightenscan%).green + 1
       IF rgbpal(brightenscan%).blue < 63 THEN rgbpal(brightenscan%).blue = rgbpal(brightenscan%).blue + 1
      CASE 1
       IF rgbpal(brightenscan%).green < 63 THEN rgbpal(brightenscan%).green = rgbpal(brightenscan%).green + 1
       IF rgbpal(brightenscan%).blue < 63 THEN rgbpal(brightenscan%).blue = rgbpal(brightenscan%).blue + 1
      CASE 2
       IF rgbpal(brightenscan%).red < 63 THEN rgbpal(brightenscan%).red = rgbpal(brightenscan%).red + 1
       IF rgbpal(brightenscan%).blue < 63 THEN rgbpal(brightenscan%).blue = rgbpal(brightenscan%).blue + 1
      CASE 3
       IF rgbpal(brightenscan%).red < 63 THEN rgbpal(brightenscan%).red = rgbpal(brightenscan%).red + 1
       IF rgbpal(brightenscan%).green < 63 THEN rgbpal(brightenscan%).green = rgbpal(brightenscan%).green + 1
      CASE 4
       IF rgbpal(brightenscan%).blue < 63 THEN rgbpal(brightenscan%).blue = rgbpal(brightenscan%).blue + 1
      CASE 5
       IF rgbpal(brightenscan%).green < 63 THEN rgbpal(brightenscan%).green = rgbpal(brightenscan%).green + 1
      CASE 6
       IF rgbpal(brightenscan%).red < 63 THEN rgbpal(brightenscan%).red = rgbpal(brightenscan%).red + 1
      END SELECT
   NEXT brightenscan%

   OUT &H3C8, rangestart%
   WaitRetrace

   FOR brightenpal% = rangestart% TO rangeend%
      OUT &H3C9, rgbpal(brightenpal%).red
      OUT &H3C9, rgbpal(brightenpal%).green
      OUT &H3C9, rgbpal(brightenpal%).blue
   NEXT brightenpal%

NEXT brightenoutpal%

END SUB

DEFINT A-Z
SUB Credits
   
    FadeOut 0, 0, 255, rgbpal(), palmem()
    CLS
    LOCATE 12, 16
    PRINT "Programmer"
    LOCATE 14, 16
    PRINT "DarkDread"
    FadeIn 0, 0, 255, rgbpal(), palmem()
    Delay 1
    FadeOut 0, 0, 255, rgbpal(), palmem()
    CLS
    LOCATE 12, 17
    PRINT "Graphics"
    LOCATE 14, 16
    PRINT "DarkDread"
    FadeIn 0, 0, 255, rgbpal(), palmem()
    Delay 1
    FadeOut 0, 0, 255, rgbpal(), palmem()
    CLS
    LOCATE 12, 18
    PRINT "Sound"
    LOCATE 14, 16
    PRINT "DarkDread"
    FadeIn 0, 0, 255, rgbpal(), palmem()
    Delay 1
    FadeOut 0, 0, 255, rgbpal(), palmem()
    CLS
    LOCATE 12, 14
    PRINT "Special Thanks"
    LOCATE 14, 11
    PRINT "Angelo Mottola Soft"
    FadeIn 0, 0, 255, rgbpal(), palmem()
    Delay 1
    FadeOut 0, 0, 255, rgbpal(), palmem()
    CLS
    LOCATE 12, 14
    PRINT "Special Thanks"
    LOCATE 14, 16
    PRINT "Kurt Kuzba"
    FadeIn 0, 0, 255, rgbpal(), palmem()
    Delay 1
    FadeOut 0, 0, 255, rgbpal(), palmem()
    CLS
    LOCATE 12, 14
    PRINT "Special Thanks"
    LOCATE 14, 13
    PRINT "Petter Holmberg"
    FadeIn 0, 0, 255, rgbpal(), palmem()
    Delay 1
    FadeOut 0, 0, 255, rgbpal(), palmem()
    CLS
    LOCATE 12, 14
    PRINT "Special Thanks"
    LOCATE 14, 18
    PRINT "Lianne"
    FadeIn 0, 0, 255, rgbpal(), palmem()
    Delay 1
    FadeOut 0, 0, 255, rgbpal(), palmem()
    CLS
    LOCATE 13, 17
    PRINT "THE END"
    FadeIn 0, 0, 255, rgbpal(), palmem()
    WHILE INKEY$ <> "": WEND
    WHILE INKEY$ = "": WEND

END SUB

SUB DCPreview

    OUT &H3C8, 250: OUT &H3C9, 50: OUT &H3C9, 0: OUT &H3C9, 0
    OUT &H3C8, 249: OUT &H3C9, 40: OUT &H3C9, 0: OUT &H3C9, 0
    OUT &H3C8, 248: OUT &H3C9, 30: OUT &H3C9, 0: OUT &H3C9, 0
   
    FOR Preview = 0 TO 6
        FadeOut 0, 0, 255, rgbpal(), palmem()
        Preview$ = LTRIM$(RTRIM$(STR$(Preview)))
        DEF SEG = &HA000
        BLOAD "PREVIEW" + Preview$ + ".FSI"
        IF Preview = 3 THEN
            OUT &H3C8, 250: OUT &H3C9, 0: OUT &H3C9, 0: OUT &H3C9, 10
            OUT &H3C8, 249: OUT &H3C9, 0: OUT &H3C9, 0: OUT &H3C9, 40
            OUT &H3C8, 248: OUT &H3C9, 0: OUT &H3C9, 0: OUT &H3C9, 30
        END IF
        FadeIn 0, 0, 255, rgbpal(), palmem()
        IF Preview < 6 THEN Delay 3 ELSE SLEEP 30
        IF INKEY$ <> "" THEN EXIT FOR
    NEXT Preview

END SUB

SUB Delay (Seconds!)

    d& = FIX(Seconds! * PIT(0))
    FOR t& = 0 TO d&: WAIT 64, 128: WAIT 64, 128, 128: NEXT
 
    'CurrentTime# = TIMER
    'DO: LOOP UNTIL TIMER > CurrentTime# + seconds%

END SUB

SUB DialogBox

    LINE (19, 99)-(300, 119), 0, BF
    LINE (19, 99)-(300, 119), 105, B
    LINE (20, 100)-(299, 118), 1, B
    LINE (21, 101)-(298, 117), 32, B
    LINE (22, 102)-(297, 116), 1, B

END SUB

SUB DrawField
   
    LINE (0, 0)-(319, 199), 0, BF

    LINE (0, 0)-(319, 19), 195, B
    LINE (1, 1)-(318, 18), 120, B
    LINE (2, 2)-(317, 17), 10, B
    LINE (3, 3)-(316, 16), 120, B

    CALL MakeFence
    CALL UpdateStatus
   
    FOR Y = 2 TO 8
        FOR X = 2 TO 15
            IF Level(X, Y) = 1 THEN
                    PUT ((X - 1) * 20, Y * 20), Block1, PSET
                ELSEIF Level(X, Y) = 2 THEN
                    PUT ((X - 1) * 20, Y * 20), Block2, PSET
                ELSEIF Level(X, Y) = 3 THEN
                    PUT ((X - 1) * 20, Y * 20), Block3, PSET
                ELSEIF Level(X, Y) = 4 THEN
                    PUT ((X - 1) * 20, Y * 20), Block4, PSET
                ELSEIF Level(X, Y) = 5 THEN
                    PUT ((X - 1) * 20, Y * 20), Block5, PSET
                ELSEIF Level(X, Y) = 6 THEN
                    PUT ((X - 1) * 20, Y * 20), Block6, PSET
                ELSEIF Level(X, Y) = 7 THEN
                    PUT ((X - 1) * 20, Y * 20), Block7, PSET
                ELSEIF Level(X, Y) = 8 THEN
                    PUT ((X - 1) * 20, Y * 20), Block8, PSET
                ELSEIF Level(X, Y) = 9 THEN
                    PUT ((X - 1) * 20, Y * 20), Block9, PSET
                ELSEIF Level(X, Y) = 10 THEN
                    PUT ((X - 1) * 20, Y * 20), Block10, PSET
                ELSEIF Level(X, Y) = 11 THEN
                    PUT ((X - 1) * 20, Y * 20), Block11, PSET
                ELSEIF Level(X, Y) = 12 THEN
                    PUT ((X - 1) * 20, Y * 20), Block12, PSET
                ELSEIF Level(X, Y) = 13 THEN
                    PUT ((X - 1) * 20, Y * 20), Block13, PSET
            END IF
        NEXT X
    NEXT Y

END SUB

SUB EndMessage

    BrightenOut 0, 0, 255, rgbpal(), palmem()
    LINE (0, 0)-(319, 199), 0, BF
    COLOR 1
    PRINT "Thanks for playing Pong 97!"
    COLOR 4
    PRINT "Created by: DarkDread"
    PRINT "Copyright (C) 1997 DarkDreams Software"
    BrightenIn 0, 0, 255, rgbpal(), palmem()
    WHILE INKEY$ <> "": WEND
    PRINT "Press any key..."
    WHILE INKEY$ = "": WEND

END SUB

SUB EnterName
   
    CALL DialogBox
    LOCATE 14, 4
    PRINT "Enter File Name: ........         "
    FileName$ = ""

    DO
      
        N$ = INPUT$(1)
        IF N$ = CHR$(8) THEN
            IF Length = 9 THEN Length = 8
            IF Length <> 0 THEN Length = Length - 1
            FileName$ = LEFT$(FileName$, Length)
            LOCATE 14, 21: PRINT FileName$ + "."
        END IF
        IF N$ = CHR$(13) AND Length > 0 THEN EXIT DO
        IF N$ <> CHR$(8) THEN
            IF N$ > CHR$(47) AND N$ < CHR$(58) OR N$ > CHR$(64) AND N$ < CHR$(91) OR N$ > CHR$(96) AND N$ < CHR$(123) THEN
                FileName$ = FileName$ + N$
                IF Length < 8 THEN Length = Length + 1
            END IF
        END IF
        IF Length = 8 THEN FileName$ = LEFT$(FileName$, 8)
        LOCATE 14, 21: PRINT FileName$
  
    LOOP

END SUB

SUB EnterScore
   
    CLS
    DIM Scores(11), Names$(11)
    OPEN "HIGHS.DAT" FOR INPUT AS #1
    FOR I = 1 TO 10
        INPUT #1, Scores(I), Names$(I)
    NEXT I
    CLOSE #1
    
    FOR I = 1 TO 10
        IF Wins1 > Scores(I) AND NoMore = 0 THEN
            FOR J = 10 TO I STEP -1
                Scores(J + 1) = Scores(J)
                Names$(J + 1) = Names$(J)
            NEXT J
            PRINT "Congratulations! You got a high score!"
            PRINT "Enter your name: ............"
            
            DO
                N$ = INPUT$(1)
                IF N$ = CHR$(8) THEN
                    IF Length = 13 THEN Length = 12
                         IF Length <> 0 THEN Length = Length - 1
                         Name$ = LEFT$(Name$, Length)
                         LOCATE 2, 18: PRINT Name$ + "."
                    END IF
                    IF Length < 13 AND N$ <> CHR$(8) THEN Length = Length + 1
                    IF N$ = CHR$(13) THEN EXIT DO
                    IF N$ <> CHR$(8) THEN Name$ = Name$ + N$
                    IF Length = 13 THEN Name$ = LEFT$(Name$, 12)
                    LOCATE 2, 18: PRINT Name$
            LOOP
            Scores(I) = Wins1
            Names$(I) = Name$
            NoMore = 1
        END IF
    NEXT I
   
    OPEN "HIGHS.DAT" FOR OUTPUT AS #1
    FOR I = 1 TO 10
        WRITE #1, Scores(I), Names$(I)
    NEXT I
    CLOSE #1

END SUB

SUB Extend1

    HitWhat = True
    IF Length1 = 0 THEN
            Length1 = 10
            IF Player1X + 10 < 22 THEN
                    Player1X = 32
                ELSEIF Player1X + 10 > 278 THEN
                    Player1X = 268
            END IF
        ELSEIF Length1 = 10 THEN
            Length1 = 20
            IF Player1X + 20 < 22 THEN
                    Player1X = 42
                ELSEIF Player1X + 20 > 278 THEN
                    Player1X = 258
            END IF
    END IF

END SUB

SUB Extend2
   
    HitWhat = True
    IF Length2 = 0 THEN
            Length2 = 10
            IF Player2X + 10 < 22 THEN
                    Player2X = 32
                ELSEIF Player2X + 10 > 278 THEN
                    Player2X = 268
            END IF
        ELSEIF Length2 = 10 THEN
            Length2 = 20
            IF Player2X + 20 < 22 THEN
                    Player2X = 42
                ELSEIF Player2X + 20 > 278 THEN
                    Player2X = 248
            END IF
    END IF

END SUB

DEFSNG A-Z
SUB FadeIn (keepcolor%, rangestart%, rangeend%, rgbpal() AS PalType, palmem() AS PalType)

' Description:
' ------------
' This SUB fades back a previously faded out screen:
'
' Input:
' ------
' palmem() : Previous palette values.
'
' keepcolor%  : Color to keep (0:none, 1:red, 2:green, 3:blue,
'                              4:yellow, 5:magneta, 6:cyan, 7:all)
' rangestart% : First color index to fade in (0-255).
' rangeend%   : Last color index to fade in (0-255).

' --- Save the present palette for modification:

OUT &H3C7, rangestart%

FOR savepresentpal% = rangestart% TO rangeend%
   rgbpal(savepresentpal%).red = INP(&H3C9)
   rgbpal(savepresentpal%).green = INP(&H3C9)
   rgbpal(savepresentpal%).blue = INP(&H3C9)
NEXT savepresentpal%

' --- Set the new palette:

FOR fadeinpal% = 0 TO 63

   FOR fadescan% = rangestart% TO rangeend%
      SELECT CASE keepcolor%
      CASE 0
       IF 63 - palmem(fadescan%).red < fadeinpal% AND rgbpal(fadescan%).red < palmem(fadescan%).red THEN rgbpal(fadescan%).red = rgbpal(fadescan%).red + 1
       IF 63 - palmem(fadescan%).green < fadeinpal% AND rgbpal(fadescan%).green < palmem(fadescan%).green THEN rgbpal(fadescan%).green = rgbpal(fadescan%).green + 1
       IF 63 - palmem(fadescan%).blue < fadeinpal% AND rgbpal(fadescan%).blue < palmem(fadescan%).blue THEN rgbpal(fadescan%).blue = rgbpal(fadescan%).blue + 1
      CASE 1
       IF 63 - palmem(fadescan%).green < fadeinpal% AND rgbpal(fadescan%).green < palmem(fadescan%).green THEN rgbpal(fadescan%).green = rgbpal(fadescan%).green + 1
       IF 63 - palmem(fadescan%).blue < fadeinpal% AND rgbpal(fadescan%).blue < palmem(fadescan%).blue THEN rgbpal(fadescan%).blue = rgbpal(fadescan%).blue + 1
      CASE 2
       IF 63 - palmem(fadescan%).red < fadeinpal% AND rgbpal(fadescan%).red < palmem(fadescan%).red THEN rgbpal(fadescan%).red = rgbpal(fadescan%).red + 1
       IF 63 - palmem(fadescan%).blue < fadeinpal% AND rgbpal(fadescan%).blue < palmem(fadescan%).blue THEN rgbpal(fadescan%).blue = rgbpal(fadescan%).blue + 1
      CASE 3
       IF 63 - palmem(fadescan%).red < fadeinpal% AND rgbpal(fadescan%).red < palmem(fadescan%).red THEN rgbpal(fadescan%).red = rgbpal(fadescan%).red + 1
       IF 63 - palmem(fadescan%).green < fadeinpal% AND rgbpal(fadescan%).green < palmem(fadescan%).green THEN rgbpal(fadescan%).green = rgbpal(fadescan%).green + 1
      CASE 4
       IF 63 - palmem(fadescan%).blue < fadeinpal% AND rgbpal(fadescan%).blue < palmem(fadescan%).blue THEN rgbpal(fadescan%).blue = rgbpal(fadescan%).blue + 1
      CASE 5
       IF 63 - palmem(fadescan%).green < fadeinpal% AND rgbpal(fadescan%).green < palmem(fadescan%).green THEN rgbpal(fadescan%).green = rgbpal(fadescan%).green + 1
      CASE 6
       IF 63 - palmem(fadescan%).red < fadeinpal% AND rgbpal(fadescan%).red < palmem(fadescan%).red THEN rgbpal(fadescan%).red = rgbpal(fadescan%).red + 1
      END SELECT
   NEXT fadescan%

   OUT &H3C8, rangestart%
   WaitRetrace

   FOR fadepal% = rangestart% TO rangeend%
      OUT &H3C9, rgbpal(fadepal%).red
      OUT &H3C9, rgbpal(fadepal%).green
      OUT &H3C9, rgbpal(fadepal%).blue
   NEXT fadepal%

NEXT fadeinpal%

END SUB

SUB FadeOut (keepcolor%, rangestart%, rangeend%, rgbpal() AS PalType, palmem() AS PalType)

' Description:
' ------------
' This SUB fades desired RGB values to black:
'
' Input:
' ------
' keepcolor%  : Color to keep (0:none, 1:red, 2:green, 3:blue,
'                              4:yellow, 5:magneta, 6:cyan, 7:all)
' rangestart% : First color index to fade out (0-255).
' rangeend%   : Last color index to fade out (0-255).
'
' Output:
' ------
' palmem() : Previous palette values.

' --- Save the old palette:

OUT &H3C7, rangestart%

FOR saveoldpal% = rangestart% TO rangeend%
   palmem(saveoldpal%).red = INP(&H3C9)
   palmem(saveoldpal%).green = INP(&H3C9)
   palmem(saveoldpal%).blue = INP(&H3C9)
NEXT saveoldpal%

' --- Save the present palette for modification:

OUT &H3C7, rangestart%

FOR savepresentpal% = rangestart% TO rangeend%
   rgbpal(savepresentpal%).red = INP(&H3C9)
   rgbpal(savepresentpal%).green = INP(&H3C9)
   rgbpal(savepresentpal%).blue = INP(&H3C9)
NEXT savepresentpal%

' --- Set the new palette:

FOR fadeoutpal% = 0 TO 63
   FOR fadescan% = rangestart% TO rangeend%
      SELECT CASE keepcolor%
      CASE 0
       IF rgbpal(fadescan%).red > 0 THEN rgbpal(fadescan%).red = rgbpal(fadescan%).red - 1
       IF rgbpal(fadescan%).green > 0 THEN rgbpal(fadescan%).green = rgbpal(fadescan%).green - 1
       IF rgbpal(fadescan%).blue > 0 THEN rgbpal(fadescan%).blue = rgbpal(fadescan%).blue - 1
      CASE 1
       IF rgbpal(fadescan%).green > 0 THEN rgbpal(fadescan%).green = rgbpal(fadescan%).green - 1
       IF rgbpal(fadescan%).blue > 0 THEN rgbpal(fadescan%).blue = rgbpal(fadescan%).blue - 1
      CASE 2
       IF rgbpal(fadescan%).red > 0 THEN rgbpal(fadescan%).red = rgbpal(fadescan%).red - 1
       IF rgbpal(fadescan%).blue > 0 THEN rgbpal(fadescan%).blue = rgbpal(fadescan%).blue - 1
      CASE 3
       IF rgbpal(fadescan%).red > 0 THEN rgbpal(fadescan%).red = rgbpal(fadescan%).red - 1
       IF rgbpal(fadescan%).green > 0 THEN rgbpal(fadescan%).green = rgbpal(fadescan%).green - 1
      CASE 4
       IF rgbpal(fadescan%).blue > 0 THEN rgbpal(fadescan%).blue = rgbpal(fadescan%).blue - 1
      CASE 5
       IF rgbpal(fadescan%).green > 0 THEN rgbpal(fadescan%).green = rgbpal(fadescan%).green - 1
      CASE 6
       IF rgbpal(fadescan%).red > 0 THEN rgbpal(fadescan%).red = rgbpal(fadescan%).red - 1
      END SELECT
   NEXT fadescan%

   OUT &H3C8, rangestart%
   WaitRetrace

   FOR fadepal% = rangestart% TO rangeend%
      OUT &H3C9, rgbpal(fadepal%).red
      OUT &H3C9, rgbpal(fadepal%).green
      OUT &H3C9, rgbpal(fadepal%).blue
   NEXT fadepal%

NEXT fadeoutpal%

END SUB

DEFINT A-Z
SUB FastPlayer1
   
    HitWhat = True
    Speed1 = Speed1 + 1
    IF Speed1 = 5 THEN Speed1 = 4

END SUB

SUB FastPlayer2
   
    HitWhat = True
    Speed2 = Speed2 + 1
    IF Speed2 = 5 THEN Speed2 = 4
    IF Speed2 > 1 THEN SpeedCpu2 = Speed2 - 1

END SUB

SUB Fence
   
    FOR Y = 0 TO 180 STEP 20
        PUT (0, Y), Block2, PSET
        PUT (300, Y), Block2, PSET
    NEXT Y
    FOR X = 20 TO 280 STEP 20
        PUT (X, 0), Block2, PSET
        PUT (X, 180), Block2, PSET
    NEXT X

END SUB

SUB GameMenu
   
    CALL ShowMenu
    DO

        SELECT CASE INKEY$
        CASE IS = "1"
            IF Players = 2 THEN
                Wins1 = 0: Wins2 = 0
            END IF
            Players = 1
            ChoiceMade = True
            IF LoadedLevel THEN
                    LoadedLevel = False
                ELSE
                    FileName$ = "level1"
                    CALL LoadFile
            END IF
        CASE IS = "2"
            IF Players = 1 THEN
                Wins1 = 0: Wins2 = 0
            END IF
            Players = 2
            ChoiceMade = True
        CASE IS = "3"
            FileExist = True
            CALL EnterName
            OPEN FileName$ + ".p97" FOR INPUT AS #1
            CLOSE #1
            IF FileExist THEN
                CALL LoadFile
                LoadedLevel = True
            END IF
            CALL ShowMenu
            FileName$ = ""
        CASE IS = "4"
            CALL DrawField
            LINE (73, 43)-(245, 155), 0, BF
            LINE (69, 39)-(249, 159), 195, B
            LINE (70, 40)-(248, 158), 120, B
            LINE (71, 41)-(247, 157), 10, B
            LINE (72, 42)-(246, 156), 120, B
            CALL ShowHighScores
            CALL ShowMenu
        CASE IS = "5"
            CALL Help
            CALL ShowMenu
        CASE IS = "6"
            CALL DCPreview
            CALL EndMessage
            SYSTEM
        END SELECT

    LOOP UNTIL ChoiceMade

END SUB

SUB GetBallDir

    BallDir = INT(RND * 4) + 1

    IF BallDir = 1 THEN
            BallDir$ = "NE"
        ELSEIF BallDir = 2 THEN
            BallDir$ = "SE"
        ELSEIF BallDir = 3 THEN
            BallDir$ = "SW"
        ELSEIF BallDir = 4 THEN
            BallDir$ = "NW"
    END IF
   
    Player1Dir$ = "": Player2Dir$ = ""
    BallX = 154: BallY = 94
    Player1X = 149: Player2X = 149

END SUB

SUB Help

    LINE (0, 0)-(319, 199), 0, BF
    CALL Fence
    COLOR 32
    LOCATE 4, 15
    PRINT "PONG 97 HELP"

    LOCATE 7, 4
    PRINT "Much like the original pong, the  "
    LOCATE 8, 4
    PRINT "object of Pong 97 is to hit the   "
    LOCATE 9, 4
    PRINT "ball past your opponent's paddle. "
    LOCATE 10, 4
    PRINT "A game is won whenever one of the "
    LOCATE 11, 4
    PRINT "players gets 4 points.  A point is"
    LOCATE 12, 4
    PRINT "obtained every time the ball is   "
    LOCATE 13, 4
    PRINT "hit past a player's paddle.       "
    PRINT
    LOCATE 14, 4
    PRINT "However, unlike the original pong;"
    LOCATE 15, 4
    PRINT "Pong 97 has some added features.  "
    LOCATE 16, 4
    PRINT "There are 99 different levels in  "
    LOCATE 17, 4
    PRINT "addition to the standard one; all "
    LOCATE 18, 4
    PRINT "of which have various blocks and  "
    LOCATE 19, 4
    PRINT "traps in them."
    LOCATE 22, 27
    PRINT "Page 1 of 5"
    WHILE INKEY$ = "": WEND
    LINE (20, 20)-(299, 179), 0, BF
    LOCATE 4, 4
    PRINT "Most of the blocks are normal, but"
    LOCATE 5, 4
    PRINT "there are some which do special   "
    LOCATE 6, 4
    PRINT "things when they are hit:         "
    PUT (24, 56), Block4, PSET
    LOCATE 8, 7
    PRINT "<-- This block will slow down  "
    LOCATE 9, 7
    PRINT "    the first player's paddle. "
    PUT (24, 80), Block3, PSET
    LOCATE 11, 7
    PRINT "<-- This block will slow down  "
    LOCATE 12, 7
    PRINT "    the second player's paddle."
    PUT (24, 104), Block5, PSET
    LOCATE 14, 7
    PRINT "<-- This block will speed up   "
    LOCATE 15, 7
    PRINT "    the first player's paddle. "
    PUT (24, 128), Block6, PSET
    LOCATE 17, 7
    PRINT "<-- This block will speed up   "
    LOCATE 18, 7
    PRINT "    the second player's paddle."
    LOCATE 22, 27
    PRINT "Page 2 of 5"
    WHILE INKEY$ = "": WEND
    LINE (20, 20)-(299, 179), 0, BF
    PUT (24, 32), Block7, PSET
    LOCATE 5, 7
    PRINT "<-- This block will enlarge the"
    LOCATE 6, 7
    PRINT "    second player's paddle.    "
    PUT (24, 56), Block8, PSET
    LOCATE 8, 7
    PRINT "<-- This block will enlarge the"
    LOCATE 9, 7
    PRINT "    first player's paddle.     "
    PUT (24, 80), Block9, PSET
    LOCATE 11, 7
    PRINT "<-- This block will shrink the "
    LOCATE 12, 7
    PRINT "    first player's paddle.     "
    PUT (24, 104), Block10, PSET
    LOCATE 14, 7
    PRINT "<-- This block will shrink the "
    LOCATE 15, 7
    PRINT "    second player's paddle.    "
    LOCATE 17, 4
    PRINT "All of the paddles have limits as "
    LOCATE 18, 4
    PRINT "to how much they can speed up/slow"
    LOCATE 19, 4
    PRINT "down and enlarge/shrink.          "
    LOCATE 20, 4
    PRINT "As you can see, Pong 97 is no     "
    LOCATE 21, 4
    PRINT "ordinary game of pong.            "
    LOCATE 22, 27
    PRINT "Page 3 of 5"
    WHILE INKEY$ = "": WEND
    LINE (20, 20)-(299, 179), 0, BF
    LOCATE 4, 4
    PRINT "The controls for Pong 97 are as   "
    LOCATE 5, 4
    PRINT "follows:"
    LOCATE 7, 4
    PRINT "               LEFT   RIGHT   STOP"
    LOCATE 8, 4
    PRINT "Player 1:         A       D      S"
    LOCATE 9, 4
    PRINT "Player 2:        <-      ->   Down"
    LOCATE 11, 4
    PRINT "Esc quits the current game.       "
    LOCATE 13, 4
    PRINT "Pong 97 also comes with its own   "
    LOCATE 14, 4
    PRINT "level editor which allows you to  "
    LOCATE 15, 4
    PRINT "create lots of new levels! To use "
    LOCATE 16, 4
    PRINT "any level you've created, simply  "
    LOCATE 17, 4
    PRINT "select option 3 (Load a Level) at "
    LOCATE 18, 4
    PRINT "the main menu and type in the file"
    LOCATE 19, 4
    PRINT "name of your level.  You may then "
    LOCATE 20, 4
    PRINT "select a 1 or 2 player game.      "
    LOCATE 22, 27
    PRINT "Page 4 of 5"
    WHILE INKEY$ = "": WEND
    LINE (20, 20)-(299, 179), 0, BF
    LOCATE 4, 5
    PRINT "Prorgramming, Graphics, and Sound"
    LOCATE 5, 16
    PRINT "DarkDread"
    LOCATE 7, 14
    PRINT "Special Thanks"
    LOCATE 8, 11
    PRINT "Angelo Mottola Soft"
    LOCATE 9, 15
    PRINT "Kurt Kuzba"
    LOCATE 10, 13
    PRINT "Petter Holmberg"
    LOCATE 11, 17
    PRINT "Lianne"
    LOCATE 13, 18
    PRINT "Hails"
    LOCATE 14, 4
    PRINT "Lianne, John, Garnet, Cory, Jason,"
    LOCATE 15, 4
    PRINT "Neo, My Dying Bride, William Yu,  "
    LOCATE 16, 4
    PRINT "Mallard, Laz, all of the Dark     "
    LOCATE 17, 4
    PRINT "Crown supporters, and anyone else "
    LOCATE 18, 4
    PRINT "I forgot..."
    LOCATE 22, 27
    PRINT "Page 5 of 5"
    WHILE INKEY$ = "": WEND

END SUB

SUB LoadFile
   
    OPEN FileName$ + ".p97" FOR INPUT AS #1
   
    INPUT #1, FenceType
    FOR Y = 2 TO 8
        FOR X = 2 TO 15
            INPUT #1, Level(X, Y)
        NEXT X
    NEXT Y

    CLOSE #1

END SUB

FUNCTION LoadFx (FXFileName$)
OPEN FXFileName$ FOR BINARY AS #1
IF LOF(1) = 0 THEN LoadFx = 0: CLOSE #1: EXIT FUNCTION
DIM id AS STRING * 4
GET #1, , id
IF MID$(id, 1, 2) <> "SL" THEN LoadFx = 1: CLOSE #1: EXIT FUNCTION
IF MID$(id, 3, 2) <> "10" THEN LoadFx = 2: CLOSE #1: EXIT FUNCTION
GET #1, , NumSound
REDIM Snd(1 TO NumSound) AS STRING * 30
FOR I = 1 TO NumSound
  GET #1, , Snd(I)
  temp$ = SPACE$(20)
  GET #1, , temp$
NEXT I
CLOSE #1
LoadFx = -1
END FUNCTION

SUB LoadSound

    Result = LoadFx("PONG97.SND")

    SELECT CASE Result
    CASE 0
        PRINT "Error: file not found."
        PRINT : END
    CASE 1
        PRINT "Unknown file format!"
        PRINT : END
    CASE 2
        PRINT "Advanced file format encoutered."
        PRINT : END
    END SELECT

END SUB

SUB LocateFX
   
    IF BallX < 110 THEN
            CALL Mixer(15, 13, 0)
        ELSEIF BallX > 210 THEN
            CALL Mixer(13, 15, 0)
        ELSE
            CALL Mixer(15, 15, 0)
    END IF

END SUB

SUB MakeFence

    IF FenceType = 1 THEN
             FOR Y = 20 TO 198 STEP 20
                 PUT (0, Y), Block2, PSET
                 PUT (300, Y), Block2, PSET
             NEXT Y
        ELSEIF FenceType = 2 THEN
             FOR Y = 20 TO 198 STEP 20
                 PUT (0, Y), Block11, PSET
                 PUT (300, Y), Block11, PSET
             NEXT Y
        ELSEIF FenceType = 3 THEN
             FOR Y = 20 TO 198 STEP 20
                 PUT (0, Y), Block13, PSET
                 PUT (300, Y), Block13, PSET
             NEXT Y
    END IF

END SUB

SUB Mixer (Left%, Right%, GetVol%)
   
    SHARED BasePort%
    OUT BasePort% + 4, &H22
    IF GetVol% THEN
       Left% = INP(BasePort% + 5) \ 16
       Right% = INP(BasePort% + 5) AND &HF
       EXIT SUB
    ELSE
       OUT BasePort% + 5, (Right% + Left% * 16) AND &HFF
    END IF

END SUB

SUB MoveBall
   
    LINE (BallX, BallY)-(BallX + 9, BallY + 9), 0, BF
    IF BallDir$ = "NE" THEN
            BallX = BallX + 1: BallY = BallY - 1
            FOR I = 1 TO 9
                IF POINT(BallX + I, BallY) > 0 AND POINT(BallX + 9, BallY + I) > 0 THEN
                        IF POINT(BallX + I, BallY) = 49 OR POINT(BallX + 9, BallY + I) = 49 THEN
                                CALL SlowPlayer2
                            ELSEIF POINT(BallX + I, BallY) = 32 OR POINT(BallX + 9, BallY + I) = 32 THEN
                                CALL SlowPlayer1
                            ELSEIF POINT(BallX + I, BallY) = 2 OR POINT(BallX + 9, BallY + I) = 2 THEN
                                CALL FastPlayer2
                            ELSEIF POINT(BallX + I, BallY) = 1 OR POINT(BallX + 9, BallY + I) = 1 THEN
                                CALL FastPlayer1
                            ELSEIF POINT(BallX + I, BallY) = 14 OR POINT(BallX + 9, BallY + I) = 14 THEN
                                CALL Extend1
                            ELSEIF POINT(BallX + I, BallY) = 44 OR POINT(BallX + 9, BallY + I) = 44 THEN
                                CALL Extend2
                            ELSEIF POINT(BallX + I, BallY) = 113 OR POINT(BallX + 9, BallY + I) = 113 THEN
                                CALL Shorten1
                            ELSEIF POINT(BallX + I, BallY) = 185 OR POINT(BallX + 9, BallY + I) = 185 THEN
                                CALL Shorten2
                            ELSEIF POINT(BallX + I, BallY) = 64 OR POINT(BallX + 9, BallY + I) = 64 THEN
                                HitBlock = 11
                                HitWhat = True
                            ELSEIF POINT(BallX + I, BallY) = 201 OR POINT(BallX + 9, BallY + I) = 201 THEN
                                HitBlock = 12
                                HitWhat = True
                        END IF
                        BallY = BallY + 2: BallX = BallX - 2
                        BallDir$ = "SW"
                        Collision = True
                    ELSEIF POINT(BallX + I, BallY) > 0 THEN
                        IF POINT(BallX + I, BallY) = 49 THEN
                                CALL SlowPlayer2
                            ELSEIF POINT(BallX + I, BallY) = 32 THEN
                                CALL SlowPlayer1
                            ELSEIF POINT(BallX + I, BallY) = 2 THEN
                                CALL FastPlayer2
                            ELSEIF POINT(BallX + I, BallY) = 1 THEN
                                CALL FastPlayer1
                            ELSEIF POINT(BallX + I, BallY) = 14 THEN
                                CALL Extend1
                            ELSEIF POINT(BallX + I, BallY) = 44 THEN
                                CALL Extend2
                            ELSEIF POINT(BallX + I, BallY) = 113 THEN
                                CALL Shorten1
                            ELSEIF POINT(BallX + I, BallY) = 185 THEN
                                CALL Shorten2
                            ELSEIF POINT(BallX + I, BallY) = 64 THEN
                                HitBlock = 11
                                HitWhat = True
                            ELSEIF POINT(BallX + I, BallY) = 201 THEN
                                HitBlock = 12
                                HitWhat = True
                        END IF
                        BallY = BallY + 2
                        BallDir$ = "SE"
                        Collision = True
                    ELSEIF POINT(BallX + 9, BallY + I) > 0 THEN
                        IF POINT(BallX + 9, BallY + I) = 49 THEN
                                CALL SlowPlayer2
                            ELSEIF POINT(BallX + 9, BallY + I) = 32 THEN
                                CALL SlowPlayer1
                            ELSEIF POINT(BallX + 9, BallY + I) = 2 THEN
                                CALL FastPlayer2
                            ELSEIF POINT(BallX + 9, BallY + I) = 1 THEN
                                CALL FastPlayer1
                            ELSEIF POINT(BallX + 9, BallY + I) = 14 THEN
                                CALL Extend1
                            ELSEIF POINT(BallX + 9, BallY + I) = 44 THEN
                                CALL Extend2
                            ELSEIF POINT(BallX + 9, BallY + I) = 113 THEN
                                CALL Shorten1
                            ELSEIF POINT(BallX + 9, BallY + I) = 185 THEN
                                CALL Shorten2
                            ELSEIF POINT(BallX + 9, BallY + I) = 64 THEN
                                HitBlock = 11
                                HitWhat = True
                            ELSEIF POINT(BallX + 9, BallY + I) = 201 THEN
                                HitBlock = 12
                                HitWhat = True
                        END IF
                        BallX = BallX - 2
                        BallDir$ = "NW"
                        Collision = True
                END IF
                IF Collision THEN EXIT FOR
            NEXT I
        ELSEIF BallDir$ = "SE" THEN
            BallX = BallX + 1: BallY = BallY + 1
            FOR I = 1 TO 9
                IF POINT(BallX + I, BallY + 9) > 0 AND POINT(BallX + 9, BallY + I) > 0 THEN
                        IF POINT(BallX + I, BallY + 9) = 49 OR POINT(BallX + 9, BallY + I) = 49 THEN
                                CALL SlowPlayer2
                            ELSEIF POINT(BallX + I, BallY + 9) = 32 OR POINT(BallX + 9, BallY + I) = 32 THEN
                                CALL SlowPlayer1
                            ELSEIF POINT(BallX + I, BallY + 9) = 2 OR POINT(BallX + 9, BallY + I) = 2 THEN
                                CALL FastPlayer2
                            ELSEIF POINT(BallX + I, BallY + 9) = 1 OR POINT(BallX + 9, BallY + I) = 1 THEN
                                CALL FastPlayer1
                            ELSEIF POINT(BallX + I, BallY + 9) = 14 OR POINT(BallX + 9, BallY + I) = 14 THEN
                                CALL Extend1
                            ELSEIF POINT(BallX + I, BallY + 9) = 44 OR POINT(BallX + 9, BallY + I) = 44 THEN
                                CALL Extend2
                            ELSEIF POINT(BallX + I, BallY + 9) = 113 OR POINT(BallX + 9, BallY + I) = 113 THEN
                                CALL Shorten1
                            ELSEIF POINT(BallX + I, BallY + 9) = 185 OR POINT(BallX + 9, BallY + I) = 185 THEN
                                CALL Shorten2
                            ELSEIF POINT(BallX + I, BallY + 9) = 64 OR POINT(BallX + 9, BallY + I) = 64 THEN
                                HitBlock = 11
                                HitWhat = True
                            ELSEIF POINT(BallX + I, BallY + 9) = 201 OR POINT(BallX + 9, BallY + I) = 201 THEN
                                HitBlock = 12
                                HitWhat = True
                        END IF
                        BallY = BallY - 2: BallX = BallX - 2
                        BallDir$ = "NW"
                        Collision = True
                    ELSEIF POINT(BallX + I, BallY + 9) > 0 THEN
                        IF POINT(BallX + I, BallY + 9) = 49 THEN
                                CALL SlowPlayer2
                            ELSEIF POINT(BallX + I, BallY + 9) = 32 THEN
                                CALL SlowPlayer1
                            ELSEIF POINT(BallX + I, BallY + 9) = 2 THEN
                                CALL FastPlayer2
                            ELSEIF POINT(BallX + I, BallY + 9) = 1 THEN
                                CALL FastPlayer1
                            ELSEIF POINT(BallX + I, BallY + 9) = 14 THEN
                                CALL Extend1
                            ELSEIF POINT(BallX + I, BallY + 9) = 44 THEN
                                CALL Extend2
                            ELSEIF POINT(BallX + I, BallY + 9) = 113 THEN
                                CALL Shorten1
                            ELSEIF POINT(BallX + I, BallY + 9) = 185 THEN
                                CALL Shorten2
                            ELSEIF POINT(BallX + I, BallY + 9) = 64 THEN
                                HitBlock = 11
                                HitWhat = True
                            ELSEIF POINT(BallX + I, BallY + 9) = 201 THEN
                                HitBlock = 12
                                HitWhat = True
                        END IF
                        BallY = BallY - 2
                        BallDir$ = "NE"
                        Collision = True
                    ELSEIF POINT(BallX + 9, BallY + I) > 0 THEN
                        IF POINT(BallX + 9, BallY + I) = 49 THEN
                                CALL SlowPlayer2
                            ELSEIF POINT(BallX + 9, BallY + I) = 32 THEN
                                CALL SlowPlayer1
                            ELSEIF POINT(BallX + 9, BallY + I) = 2 THEN
                                CALL FastPlayer2
                            ELSEIF POINT(BallX + 9, BallY + I) = 1 THEN
                                CALL FastPlayer1
                            ELSEIF POINT(BallX + 9, BallY + I) = 14 THEN
                                CALL Extend1
                            ELSEIF POINT(BallX + 9, BallY + I) = 44 THEN
                                CALL Extend2
                            ELSEIF POINT(BallX + 9, BallY + I) = 113 THEN
                                CALL Shorten1
                            ELSEIF POINT(BallX + 9, BallY + I) = 185 THEN
                                CALL Shorten2
                            ELSEIF POINT(BallX + 9, BallY + I) = 64 THEN
                                HitBlock = 11
                                HitWhat = True
                            ELSEIF POINT(BallX + 9, BallY + I) = 201 THEN
                                HitBlock = 12
                                HitWhat = True
                        END IF
                        BallX = BallX - 2
                        BallDir$ = "SW"
                        Collision = True
                END IF
                IF Collision THEN EXIT FOR
            NEXT I
        ELSEIF BallDir$ = "SW" THEN
            BallX = BallX - 1: BallY = BallY + 1
            FOR I = 1 TO 9
                IF POINT(BallX + I, BallY + 9) > 0 AND POINT(BallX, BallY + I) > 0 THEN
                        IF POINT(BallX + I, BallY + 9) = 49 OR POINT(BallX, BallY + I) = 49 THEN
                                CALL SlowPlayer2
                            ELSEIF POINT(BallX + I, BallY + 9) = 32 OR POINT(BallX, BallY + I) = 32 THEN
                                CALL SlowPlayer1
                            ELSEIF POINT(BallX + I, BallY + 9) = 2 OR POINT(BallX, BallY + I) = 2 THEN
                                CALL FastPlayer2
                            ELSEIF POINT(BallX + I, BallY + 9) = 1 OR POINT(BallX, BallY + I) = 1 THEN
                                CALL FastPlayer1
                            ELSEIF POINT(BallX + I, BallY + 9) = 14 OR POINT(BallX, BallY + I) = 14 THEN
                                CALL Extend1
                            ELSEIF POINT(BallX + I, BallY + 9) = 44 OR POINT(BallX, BallY + I) = 44 THEN
                                CALL Extend2
                            ELSEIF POINT(BallX + I, BallY + 9) = 113 OR POINT(BallX, BallY + I) = 113 THEN
                                CALL Shorten1
                            ELSEIF POINT(BallX + I, BallY + 9) = 185 OR POINT(BallX, BallY + I) = 185 THEN
                                CALL Shorten2
                            ELSEIF POINT(BallX + I, BallY + 9) = 64 OR POINT(BallX, BallY + I) = 64 THEN
                                HitBlock = 11
                                HitWhat = True
                            ELSEIF POINT(BallX + I, BallY + 9) = 201 OR POINT(BallX, BallY + I) = 201 THEN
                                HitBlock = 12
                                HitWhat = True
                        END IF
                        BallY = BallY - 2: BallX = BallX + 2
                        BallDir$ = "NE"
                        Collision = True
                    ELSEIF POINT(BallX + I, BallY + 9) > 0 THEN
                        IF POINT(BallX + I, BallY + 9) = 49 THEN
                                CALL SlowPlayer2
                            ELSEIF POINT(BallX + I, BallY + 9) = 32 THEN
                                CALL SlowPlayer1
                            ELSEIF POINT(BallX + I, BallY + 9) = 2 THEN
                                CALL FastPlayer2
                            ELSEIF POINT(BallX + I, BallY + 9) = 1 THEN
                                CALL FastPlayer1
                            ELSEIF POINT(BallX + I, BallY + 9) = 14 THEN
                                CALL Extend1
                            ELSEIF POINT(BallX + I, BallY + 9) = 44 THEN
                                CALL Extend2
                            ELSEIF POINT(BallX + I, BallY + 9) = 113 THEN
                                CALL Shorten1
                            ELSEIF POINT(BallX + I, BallY + 9) = 185 THEN
                                CALL Shorten2
                            ELSEIF POINT(BallX + I, BallY + 9) = 64 THEN
                                HitBlock = 11
                                HitWhat = True
                            ELSEIF POINT(BallX + I, BallY + 9) = 201 THEN
                                HitBlock = 12
                                HitWhat = True
                        END IF
                        BallY = BallY - 2
                        BallDir$ = "NW"
                        Collision = True
                    ELSEIF POINT(BallX, BallY + I) > 0 THEN
                        IF POINT(BallX, BallY + I) = 49 THEN
                                CALL SlowPlayer2
                            ELSEIF POINT(BallX, BallY + I) = 32 THEN
                                CALL SlowPlayer1
                            ELSEIF POINT(BallX, BallY + I) = 2 THEN
                                CALL FastPlayer2
                            ELSEIF POINT(BallX, BallY + I) = 1 THEN
                                CALL FastPlayer1
                            ELSEIF POINT(BallX, BallY + I) = 14 THEN
                                CALL Extend1
                            ELSEIF POINT(BallX, BallY + I) = 44 THEN
                                CALL Extend2
                            ELSEIF POINT(BallX, BallY + I) = 113 THEN
                                CALL Shorten1
                            ELSEIF POINT(BallX, BallY + I) = 185 THEN
                                CALL Shorten2
                            ELSEIF POINT(BallX, BallY + I) = 64 THEN
                                HitBlock = 11
                                HitWhat = True
                            ELSEIF POINT(BallX, BallY + I) = 201 THEN
                                HitBlock = 12
                                HitWhat = True
                        END IF
                        BallX = BallX + 2
                        BallDir$ = "SE"
                        Collision = True
                END IF
                IF Collision THEN EXIT FOR
            NEXT I
        ELSEIF BallDir$ = "NW" THEN
            BallX = BallX - 1: BallY = BallY - 1
            FOR I = 1 TO 9
                IF POINT(BallX + I, BallY) > 0 AND POINT(BallX, BallY + I) > 0 THEN
                        IF POINT(BallX + I, BallY) = 49 AND POINT(BallX, BallY + I) = 49 THEN
                                CALL SlowPlayer2
                            ELSEIF POINT(BallX + I, BallY) = 32 AND POINT(BallX, BallY + I) = 32 THEN
                                CALL SlowPlayer1
                            ELSEIF POINT(BallX + I, BallY) = 2 AND POINT(BallX, BallY + I) = 2 THEN
                                CALL FastPlayer2
                            ELSEIF POINT(BallX + I, BallY) = 1 AND POINT(BallX, BallY + I) = 1 THEN
                                CALL FastPlayer1
                            ELSEIF POINT(BallX + I, BallY) = 14 OR POINT(BallX, BallY + I) = 14 THEN
                                CALL Extend1
                            ELSEIF POINT(BallX + I, BallY) = 44 OR POINT(BallX, BallY + I) = 44 THEN
                                CALL Extend2
                            ELSEIF POINT(BallX + I, BallY) = 113 OR POINT(BallX, BallY + I) = 113 THEN
                                CALL Shorten1
                            ELSEIF POINT(BallX + I, BallY) = 185 OR POINT(BallX, BallY + I) = 185 THEN
                                CALL Shorten2
                            ELSEIF POINT(BallX + I, BallY) = 64 OR POINT(BallX, BallY + I) = 64 THEN
                                HitBlock = 11
                                HitWhat = True
                            ELSEIF POINT(BallX + I, BallY) = 201 OR POINT(BallX, BallY + I) = 201 THEN
                                HitBlock = 12
                                HitWhat = True
                        END IF
                        BallY = BallY + 2: BallX = BallX + 2
                        BallDir$ = "SE"
                        Collision = True
                    ELSEIF POINT(BallX + I, BallY) > 0 THEN
                        IF POINT(BallX + I, BallY) = 49 THEN
                                CALL SlowPlayer2
                            ELSEIF POINT(BallX + I, BallY) = 32 THEN
                                CALL SlowPlayer1
                            ELSEIF POINT(BallX + I, BallY) = 2 THEN
                                CALL FastPlayer2
                            ELSEIF POINT(BallX + I, BallY) = 1 THEN
                                CALL FastPlayer1
                            ELSEIF POINT(BallX + I, BallY) = 14 THEN
                                CALL Extend1
                            ELSEIF POINT(BallX + I, BallY) = 44 THEN
                                CALL Extend2
                            ELSEIF POINT(BallX + I, BallY) = 113 THEN
                                CALL Shorten1
                            ELSEIF POINT(BallX + I, BallY) = 185 THEN
                                CALL Shorten2
                            ELSEIF POINT(BallX + I, BallY) = 64 THEN
                                HitBlock = 11
                                HitWhat = True
                            ELSEIF POINT(BallX + I, BallY) = 201 THEN
                                HitBlock = 12
                                HitWhat = True
                        END IF
                        BallY = BallY + 2
                        BallDir$ = "SW"
                        Collision = True
                    ELSEIF POINT(BallX, BallY + I) > 0 THEN
                        IF POINT(BallX, BallY + I) = 49 THEN
                                CALL SlowPlayer2
                            ELSEIF POINT(BallX, BallY + I) = 32 THEN
                                CALL SlowPlayer1
                            ELSEIF POINT(BallX, BallY + I) = 2 THEN
                                CALL FastPlayer2
                            ELSEIF POINT(BallX, BallY + I) = 1 THEN
                                CALL FastPlayer1
                            ELSEIF POINT(BallX, BallY + I) = 14 THEN
                                CALL Extend1
                            ELSEIF POINT(BallX, BallY + I) = 44 THEN
                                CALL Extend2
                            ELSEIF POINT(BallX, BallY + I) = 113 THEN
                                CALL Shorten1
                            ELSEIF POINT(BallX, BallY + I) = 185 THEN
                                CALL Shorten2
                            ELSEIF POINT(BallX, BallY + I) = 64 THEN
                                HitBlock = 11
                                HitWhat = True
                            ELSEIF POINT(BallX, BallY + I) = 201 THEN
                                HitBlock = 12
                                HitWhat = True
                        END IF
                        BallX = BallX + 2
                        BallDir$ = "NE"
                        Collision = True
                END IF
                IF Collision THEN EXIT FOR
            NEXT I
    END IF
    IF Collision AND HitWhat AND SoundCard% THEN
            CALL LocateFX
            IF HitBlock = 0 THEN
                    CALL PlayFX(2)
                ELSEIF HitBlock = 11 THEN
                    CALL PlayFX(4)
                ELSEIF HitBlock = 12 THEN
                    CALL PlayFX(5)
            END IF
        ELSEIF Collision THEN
            CALL LocateFX
            CALL PlayFX(1)
    END IF
    HitWhat = False
    HitBlock = 0
    Collision = False
    IF BallY + 10 < 200 AND BallY > 1 THEN PUT (BallX, BallY), Ball, PSET

END SUB

SUB MoveComputer1

    IF BallDir$ = "NE" OR BallDir$ = "NW" THEN
            IF BallX + 4 > Player2X + 9 THEN
                    IF Player2X < 278 - Length2 THEN
                        Player2Dir$ = "r"
                        CALL PutBlank2
                        Player2X = Player2X + SpeedCpu2
                    END IF
                ELSE
                    IF Player2X > 22 THEN
                        Player2Dir$ = "l"
                        CALL PutBlank2
                        Player2X = Player2X - SpeedCpu2
                    END IF
            END IF
        ELSE
            ChooseDir = INT(RND * 15) + 1
            IF ChooseDir = 1 AND Player2Dir$ <> "r" THEN
                    IF Player2X < 278 - Length2 THEN
                        Player2Dir$ = "r"
                        CALL PutBlank2
                        Player2X = Player2X + SpeedCpu2
                    END IF
                ELSEIF ChooseDir = 7 AND Player2Dir$ <> "l" THEN
                    IF Player2X > 22 THEN
                        Player2Dir$ = "l"
                        CALL PutBlank2
                        Player2X = Player2X - SpeedCpu2
                    END IF
                ELSE
                    IF Player2Dir$ = "l" THEN
                            IF Player2X > 22 THEN
                                CALL PutBlank2
                                Player2X = Player2X - SpeedCpu2
                            END IF
                        ELSEIF Player2Dir$ = "r" THEN
                            IF Player2X < 278 - Length2 THEN
                                CALL PutBlank2
                                Player2X = Player2X + SpeedCpu2
                            END IF
                    END IF
            END IF
    END IF
    CALL PutPaddle2

END SUB

SUB MoveComputer2
   
    IF BallDir$ = "SE" OR BallDir$ = "SW" THEN
            IF BallX + 4 > Player1X + 9 THEN
                    IF Player1X < 278 - Length1 THEN
                        Player1Dir$ = "r"
                        CALL PutBlank1
                        Player1X = Player1X + Speed1
                    END IF
                ELSE
                    IF Player1X > 22 THEN
                        Player1Dir$ = "l"
                        CALL PutBlank1
                        Player1X = Player1X - Speed1
                    END IF
            END IF
        ELSE
            ChooseDir = INT(RND * 15) + 1
            IF ChooseDir = 1 AND Player1Dir$ <> "r" THEN
                    IF Player1X < 278 - Length1 THEN
                        Player1Dir$ = "r"
                        CALL PutBlank1
                        Player1X = Player1X + Speed1
                    END IF
                ELSEIF ChooseDir = 7 AND Player1Dir$ <> "l" THEN
                    IF Player1X > 22 THEN
                        Player1Dir$ = "l"
                        CALL PutBlank1
                        Player1X = Player1X - Speed1
                    END IF
                ELSE
                    IF Player1Dir$ = "l" THEN
                            IF Player1X > 22 THEN
                                CALL PutBlank1
                                Player1X = Player1X - Speed1
                            END IF
                        ELSE
                            IF Player1X < 278 - Length1 THEN
                                CALL PutBlank1
                                Player1X = Player1X + Speed1
                            END IF
                    END IF
            END IF
    END IF
    CALL PutPaddle1

END SUB

SUB MovePlayer1
   
    IF Player1Dir$ = "r" THEN
            IF Player1X < 278 - Length1 THEN
                CALL PutBlank1
                Player1X = Player1X + Speed1
            END IF
        ELSEIF Player1Dir$ = "l" THEN
            IF Player1X > 22 THEN
                CALL PutBlank1
                Player1X = Player1X - Speed1
            END IF
    END IF
    CALL PutPaddle1

END SUB

SUB MovePlayer2
   
    IF Player2Dir$ = "r" THEN
            IF Player2X < 278 - Length2 THEN
                CALL PutBlank2
                Player2X = Player2X + Speed2
            END IF
        ELSEIF Player2Dir$ = "l" THEN
            IF Player2X > 22 THEN
                CALL PutBlank2
                Player2X = Player2X - Speed2
            END IF
    END IF
    CALL PutPaddle2

END SUB

FUNCTION PITCal&
   p& = 0: DEF SEG = 0: X% = (PEEK(&H46C) + 1) AND 255
   WHILE X% <> (PEEK(&H46C) AND 255): WEND
   WHILE X% = (PEEK(&H46C) AND 255)
      p& = p& + 33
      FOR t% = 1 TO 19: WAIT (64), 128, 128: WAIT (64), 128: NEXT
   WEND
   PITCal& = p& * 11.02
END FUNCTION

SUB PlayFX (Num)
FOR I = 1 TO 15
  OUT &H388, ASC(MID$(Snd(Num), (I * 2) - 1, 1))
  FOR ii = 1 TO 6: temp = INP(&H388): NEXT ii
  OUT &H389, ASC(MID$(Snd(Num), (I * 2)))
  FOR ii = 1 TO 35: temp = INP(&H388): NEXT ii
NEXT I
END SUB

SUB Pulse STATIC

    green = green + 1: red = red + 1: blue = blue + 1
    IF green = 61 THEN green = 10
    IF red = 61 THEN red = 10
    IF blue = 61 THEN blue = 10

    OUT &H3C8, 254: OUT &H3C9, 0: OUT &H3C9, green: OUT &H3C9, 0
    OUT &H3C8, 253: OUT &H3C9, red: OUT &H3C9, 0: OUT &H3C9, 0
    OUT &H3C8, 252: OUT &H3C9, 0: OUT &H3C9, 0: OUT &H3C9, blue

END SUB

SUB PutBlank1

    IF Length1 = 0 THEN
            PUT (Player1X, Player1Y), Blank1, PSET
        ELSEIF Length1 = 10 THEN
            PUT (Player1X, Player1Y), Blank2, PSET
        ELSEIF Length1 = 20 THEN
            PUT (Player1X, Player1Y), Blank3, PSET
    END IF

END SUB

SUB PutBlank2
   
    IF Length2 = 0 THEN
            PUT (Player2X, Player2Y), Blank1, PSET
        ELSEIF Length2 = 10 THEN
            PUT (Player2X, Player2Y), Blank2, PSET
        ELSEIF Length2 = 20 THEN
            PUT (Player2X, Player2Y), Blank3, PSET
    END IF

END SUB

SUB PutPaddle1
   
    IF Length1 = 0 THEN
            PUT (Player1X, Player1Y), Paddle1a, PSET
        ELSEIF Length1 = 10 THEN
            PUT (Player1X, Player1Y), Paddle1b, PSET
        ELSEIF Length1 = 20 THEN
            PUT (Player1X, Player1Y), Paddle1c, PSET
    END IF

END SUB

SUB PutPaddle2
   
    IF Length2 = 0 THEN
            PUT (Player2X, Player2Y), Paddle2a, PSET
        ELSEIF Length2 = 10 THEN
            PUT (Player2X, Player2Y), Paddle2b, PSET
        ELSEIF Length2 = 20 THEN
            PUT (Player2X, Player2Y), Paddle2c, PSET
    END IF

END SUB

SUB SetUp

    DEF SEG = VARSEG(Paddle1a(0)): BLOAD "PADDLE1A.BSG", VARPTR(Paddle1a(0))
    DEF SEG = VARSEG(Paddle1b(0)): BLOAD "PADDLE1B.BSG", VARPTR(Paddle1b(0))
    DEF SEG = VARSEG(Paddle1c(0)): BLOAD "PADDLE1C.BSG", VARPTR(Paddle1c(0))
    DEF SEG = VARSEG(Paddle2a(0)): BLOAD "PADDLE2A.BSG", VARPTR(Paddle2a(0))
    DEF SEG = VARSEG(Paddle2b(0)): BLOAD "PADDLE2B.BSG", VARPTR(Paddle2b(0))
    DEF SEG = VARSEG(Paddle2c(0)): BLOAD "PADDLE2C.BSG", VARPTR(Paddle2c(0))
    DEF SEG = VARSEG(Ball(0)): BLOAD "BALL.BSG", VARPTR(Ball(0))

    DEF SEG = VARSEG(Block1(0)): BLOAD "BLOCK1.BSG", VARPTR(Block1(0))
    DEF SEG = VARSEG(Block2(0)): BLOAD "BLOCK2.BSG", VARPTR(Block2(0))
    DEF SEG = VARSEG(Block3(0)): BLOAD "BLOCK3.BSG", VARPTR(Block3(0))
    DEF SEG = VARSEG(Block4(0)): BLOAD "BLOCK4.BSG", VARPTR(Block4(0))
    DEF SEG = VARSEG(Block5(0)): BLOAD "BLOCK5.BSG", VARPTR(Block5(0))
    DEF SEG = VARSEG(Block6(0)): BLOAD "BLOCK6.BSG", VARPTR(Block6(0))
    DEF SEG = VARSEG(Block7(0)): BLOAD "BLOCK7.BSG", VARPTR(Block7(0))
    DEF SEG = VARSEG(Block8(0)): BLOAD "BLOCK8.BSG", VARPTR(Block8(0))
    DEF SEG = VARSEG(Block9(0)): BLOAD "BLOCK9.BSG", VARPTR(Block9(0))
    DEF SEG = VARSEG(Block10(0)): BLOAD "BLOCK10.BSG", VARPTR(Block10(0))
    DEF SEG = VARSEG(Block11(0)): BLOAD "BLOCK11.BSG", VARPTR(Block11(0))
    DEF SEG = VARSEG(Block12(0)): BLOAD "BLOCK12.BSG", VARPTR(Block12(0))
    DEF SEG = VARSEG(Block13(0)): BLOAD "BLOCK13.BSG", VARPTR(Block13(0))

    DEF SEG = VARSEG(EndPic(0)): BLOAD "ENDPIC.BSG", VARPTR(EndPic(0))

    GET (0, 0)-(19, 9), Blank1
    GET (0, 0)-(29, 9), Blank2
    GET (0, 0)-(39, 9), Blank3

    green = 34: red = 9: blue = 34
    Speed1 = 2: Speed2 = 2: SpeedCpu2 = 1
    CurrentLevel = 1: Players = 2
    Length1 = 0: Length2 = 0

END SUB

SUB Shorten1
   
    HitWhat = True
    IF Length1 = 20 THEN
            Length1 = 10
        ELSEIF Length1 = 10 THEN
            Length1 = 0
    END IF
    LINE (20, 190)-(299, 199), 0, BF

END SUB

SUB Shorten2
   
    HitWhat = True
    IF Length2 = 20 THEN
            Length2 = 10
        ELSEIF Length2 = 10 THEN
            Length2 = 0
    END IF
    LINE (20, 20)-(299, 29), 0, BF

END SUB

SUB ShowHighScores
   
    COLOR 4
    DIM Scores(11), Names$(11)
    LOCATE 7, 11: PRINT "NAME"
    LOCATE 7, 26: PRINT "WINS"
    OPEN "HIGHS.DAT" FOR INPUT AS #1
        FOR I = 1 TO 10
            INPUT #1, Scores(I), Names$(I)
            LOCATE I + 9, 11: PRINT Names$(I)
            LOCATE I + 9, 25: PRINT USING "#####"; Scores(I)
        NEXT I
    CLOSE #1
    WHILE INKEY$ = "": WEND
    COLOR 15

END SUB

SUB ShowMenu
   
    LINE (0, 0)-(319, 199), 0, BF
    CALL Fence
    COLOR 32
    LOCATE 4, 17
    PRINT "PONG 97"
    COLOR 41
    LOCATE 7, 12
    PRINT "1 PLAYER vs. CPU"
    COLOR 42
    LOCATE 9, 12
    PRINT "2 PLAYER vs. PLAYER"
    COLOR 43
    LOCATE 11, 12
    PRINT "3 LOAD A LEVEL"
    COLOR 42
    LOCATE 13, 12
    PRINT "4 HIGH SCORES"
    COLOR 41
    LOCATE 15, 12
    PRINT "5 VIEW HELP"
    COLOR 40
    LOCATE 17, 12
    PRINT "6 QUIT"
    COLOR 32
    LOCATE 20, 8
    PRINT "CHOOSE AN OPTION [ 1 - 6 ]"

END SUB

SUB SlowPlayer1

    HitWhat = True
    Speed1 = Speed1 - 1
    IF Speed1 = 0 THEN Speed1 = 1

END SUB

SUB SlowPlayer2
   
    HitWhat = True
    Speed2 = Speed2 - 1
    IF Speed2 = 0 THEN Speed2 = 1
    IF Speed2 > 1 THEN SpeedCpu2 = Speed2 - 1

END SUB

SUB TitleScreen

    DEF SEG = &HA000
    BLOAD "PONG97.FSI"
   
    CALL Fence

END SUB

SUB UpdateStatus

    COLOR 1
    LOCATE 2, 2
    PRINT "P1:";
    PRINT USING "###"; Score1;
    PRINT " WINS:";
    PRINT USING "###"; Wins1
    COLOR 2
    LOCATE 2, 23
    IF Players = 2 THEN
            PRINT " P2:";
        ELSE
            PRINT "CPU:";
    END IF
    PRINT USING "###"; Score2;
    PRINT " WINS:";
    PRINT USING "####"; Wins2
    COLOR 4
    LOCATE 2, 19
    PRINT USING "##"; CurrentLevel
    COLOR 15

END SUB

SUB WaitRetrace

' Description:
' ------------
' This SUB waits for the beginning of a vertical retrace.
'
' Usage:
' ------
' This SUB eliminates screen flickering during palette modification.

WAIT (&H3DA), 8    ' Wait for a screen update.
WAIT (&H3DA), 8, 8 ' Wait for the vertical retrace.

END SUB

