'       Pong 97 Setup Utility
'
'       Written by: DarkDread
'
'       Thanks go to:
'
'       Jesse Dorland - for the sound card detection code.
'       Erika Schulze and Gunther Ilzig - for the CPU detection code.
'
'       Please run this file before you run PONG97.BAS or PONG97ED.BAS so
'       the program may determine your system type and create the proper
'       settings.  This is to ensure that program execution is as smooth as
'       possible.
'
DECLARE SUB DetectCPU ()
DECLARE SUB DetectSoundCard ()
DECLARE FUNCTION GetCPU% ()
DECLARE FUNCTION Adlib% ()

DIM SHARED CPUType%
DIM SHARED Speed!

CLS

CALL DetectCPU
CALL DetectSoundCard

IF CPUType% < 3 THEN
        PRINT
        PRINT "WARNING: Pong 97 requires an 8x386 or faster machine to run properly."
        PRINT "The program has detected as slower machine.  Pong 97 will not run.   "
    ELSE
        PRINT "Writing SETTINGS.CFG file..."
        OPEN "SETTINGS.CFG" FOR OUTPUT AS #1
        WRITE #1, Speed!, Adlib%
        CLOSE #1
        PRINT
        PRINT "SETTINGS.CFG file competed.  You may now load PONG97.BAS to run the program."
END IF

SYSTEM

FUNCTION Adlib%
    OUT &H388, &H4: FOR A7 = 1 TO 6: A11 = INP(&H388): NEXT
    OUT &H389, &H60: FOR A7 = 1 TO 35: A11 = INP(&H388): NEXT
    OUT &H388, &H4: FOR A7 = 1 TO 6: A11 = INP(&H388): NEXT
    OUT &H389, &H80: FOR A7 = 1 TO 35: A11 = INP(&H388): NEXT
    Astat1 = INP(&H388)
    OUT &H388, &H2: FOR A7 = 1 TO 6: A11 = INP(&H388): NEXT
    OUT &H389, &HFF: FOR A7 = 1 TO 35: A11 = INP(&H388): NEXT
    OUT &H388, &H4: FOR A7 = 1 TO 6: A11 = INP(&H388): NEXT
    OUT &H389, &H21: FOR A7 = 1 TO 35: A11 = INP(&H388): NEXT
    Astat2 = INP(&H388)
    OUT &H388, &H4: FOR A7 = 1 TO 6: A11 = INP(&H388): NEXT
    OUT &H389, &H60: FOR A7 = 1 TO 35: A11 = INP(&H388): NEXT
    OUT &H388, &H4: FOR A7 = 1 TO 6: A11 = INP(&H388): NEXT
    OUT &H389, &H80: FOR A7 = 1 TO 35: A11 = INP(&H388): NEXT
    Ares1 = Astat1 AND &HE0: Ares2 = Astat2 AND &HE0
    Adlib% = 0: IF Ares1 = 0 AND Ares2 = 192 THEN Adlib% = -1
END FUNCTION

SUB ConvertSpeed

    IF CPUType% = 3 THEN
            Speed! = 0
        ELSEIF CPUType% = 4 THEN
            Speed! = .05
        ELSEIF CPUType% = 5 OR CPUType% = 6 THEN
            Speed! = .2
    END IF

END SUB

SUB DetectCPU

    CPUid% = 100
    CPUid% = GetCPU%
    CPUType% = GetCPU%
    SELECT CASE CPUid%
        CASE IS = 0
            PRINT "8x86 or 8x88 detected."
        CASE IS = 1
            PRINT "8x186 detected."
        CASE IS = 2
            PRINT "8x286 detected."
        CASE IS = 3
            PRINT "8x386 SX or DX detected."
        CASE IS = 4
            PRINT "8x486 SX or DX detected."
        CASE IS = 5
            PRINT "Pentium or 8x586 detected."
        CASE IS = 6
            PRINT "Pentium Pro or 8x686 detected."
    END SELECT

END SUB

SUB DetectSoundCard

    IF Adlib% = -1 THEN
            BlastEnv$ = ENVIRON$("BLASTER")
            CardType% = VAL(MID$(BlastEnv$, INSTR(BlastEnv$, "T") + 1, 1))
            SELECT CASE CardType%
                CASE IS = 1, 3
                    PRINT "Sound Blaster or compatible detected."
                CASE IS = 2, 4, 5
                    PRINT "Sound Blaster Pro or compatible detected."
                CASE IS = 6
                    PRINT "Sound Blaster 16/16ASP/AWE32 or compatible detected."
                CASE ELSE
                    PRINT "Unknown sound card detected."
                END SELECT
        ELSE
            PRINT "No Adlib or Sound Blaster compatible card found!"
    END IF

END SUB

FUNCTION GetCPU%

    DIM asm AS STRING
    DIM gdt%(2)
    offset% = 0
    temp% = 100
 
    asm = asm + CHR$(&H55)                              'push   bp                                             
    asm = asm + CHR$(&H8B) + CHR$(&HEC)                 'mov    bp,sp
    asm = asm + CHR$(&H8B) + CHR$(&H76) + CHR$(&H6)     'mov    si,[bp+6]
    asm = asm + CHR$(&H8B) + CHR$(&H7E) + CHR$(&H8)     'mov    di,[bp+8]
    asm = asm + CHR$(&H8B) + CHR$(&HC4)                 'mov    ax,sp
    asm = asm + CHR$(&H83) + CHR$(&HE4) + CHR$(&HFC)    'and    sp,not 3
    asm = asm + CHR$(&HB1) + CHR$(&H20)                 'mov    cl,20h
    asm = asm + CHR$(&HD3) + CHR$(&HE8)                 'shr    ax,cl
    asm = asm + CHR$(&H74) + CHR$(&H41)                 'jz     @@50
    asm = asm + CHR$(&H54)                              'push   sp
    asm = asm + CHR$(&H58)                              'pop    ax
    asm = asm + CHR$(&HA8) + CHR$(&H2)                  'test   al,2
    asm = asm + CHR$(&HB0) + CHR$(&H1)                  'mov    al,1
    asm = asm + CHR$(&H75) + CHR$(&H39)                 'jnz    @@50
    asm = asm + CHR$(&H40)                              'inc    ax
    asm = asm + CHR$(&HF) + CHR$(&H1) + CHR$(&H4)       'sgdt   fword ptr [si]
    asm = asm + CHR$(&H80) + CHR$(&H7C) + CHR$(&H5) + CHR$(&HFF)
    asm = asm + CHR$(&H74) + CHR$(&H2F)                 'jz     @@50
    asm = asm + CHR$(&H66) + CHR$(&H9C)                 'pushfd
    asm = asm + CHR$(&H66) + CHR$(&H9C)                 'pushfd
    asm = asm + CHR$(&H66) + CHR$(&H58)                 'pop    eax
    asm = asm + CHR$(&H66) + CHR$(&HD) + CHR$(&H0) + CHR$(&H0) + CHR$(&H24) + CHR$(&H0)
    asm = asm + CHR$(&H66) + CHR$(&H50)                 'push   eax
    asm = asm + CHR$(&H66) + CHR$(&H9D)                 'popfd
    asm = asm + CHR$(&H66) + CHR$(&H9C)                 'pushfd
    asm = asm + CHR$(&H66) + CHR$(&H58)                 'pop    eax
    asm = asm + CHR$(&H66) + CHR$(&HC1) + CHR$(&HE8) + CHR$(&H10)
    asm = asm + CHR$(&H24) + CHR$(&H24)                 'and    al,24h
    asm = asm + CHR$(&H74) + CHR$(&HF)                  'jz     @@30
    asm = asm + CHR$(&H3C) + CHR$(&H4)                  'cmp    al,4
    asm = asm + CHR$(&H74) + CHR$(&HD)                  'jz     @@40
    asm = asm + CHR$(&HB8) + CHR$(&H1) + CHR$(0)        'mov    ax,1
    asm = asm + CHR$(&HF) + CHR$(&HA2)                  'cpuid
    asm = asm + CHR$(&H8A) + CHR$(&HC4)                 'mov    al,ah
    asm = asm + CHR$(&H24) + CHR$(&HF)                  'and    al,0fh
    asm = asm + CHR$(&HEB) + CHR$(&H2)                  'jmp    short @@40
    asm = asm + CHR$(&HB0) + CHR$(&H3)                  'mov    al,3
    asm = asm + CHR$(&H66) + CHR$(&H9D)                 'popfd
    asm = asm + CHR$(&H89) + CHR$(&H5)                  'mov    [di],ax
    asm = asm + CHR$(&H8B) + CHR$(&HE5)                 'mov    sp,bp
    asm = asm + CHR$(&H5D)                              'pop    bp
    asm = asm + CHR$(&HCA) + CHR$(&H4) + CHR$(&H0)      'ret    4

    offset% = SADD(asm)
    DEF SEG = VARSEG(asm)
    CALL ABSOLUTE(temp%, gdt%(0), offset%)
    DEF SEG

    GetCPU% = temp%

END FUNCTION

