'****************************************************************************
' Pong V1.5
' Programmed by Aaron Severn (rlsevern@idirect.com)
'               www.geocities.com/SiliconValley/Peaks/9572/
' V1   - August 13, 1997 - August 16, 1997
' V1.5 - September 30, 1997 (added the key ISR)
'
' I threw this thing together in 4 days.  Hope you enjoy it.  This code is
' public domain so do what you like with it.  There's some useful routines in
' here such as the keyboard ISR which I wrote to replace INKEY$, it makes it
' possible to register multiple keys being held down at the same time and
' eliminates the annoying delay that comes with INKEY$.  If you use any of
' this code or learn from it and use that knowledge in your own programs give
' credit where credit is due, and maybe a thank-you note, besides, you'd be a
' real asshole if you didn't, right.
'
' Since I like to practice what I preach, here's my own list of thanks:
'       -To Denthor of Asphyxia for writing VGA Tutorial 8 on 3D.
'       -To Lithium of VLA for writing Three Dimensional Rotations For
'          Computer Graphics
'       -To Brett Levin for writing SBSOUND.BAS, the basis for the sound
'          effects in this program.
'       -To Steven Sensarn for writing KEYISR.BAS.  The GetVect and SetVect
'          routines are his and InstallISR is based on a routine from that
'          program.  Without that stuff the new key ISR would have been
'          impossible.
'****************************************************************************

DEFINT A-Z

DECLARE SUB ChangeBackground ()
DECLARE FUNCTION DetectCard% ()
DECLARE SUB FileCheck (name$)
DECLARE SUB FinalScore ()
DECLARE SUB GameLoop (numPlayers)
DECLARE SUB GetGameInfo (numPlayers)
DECLARE FUNCTION GetString$ (length, x, y, font())
DECLARE SUB GetVect (s, o, i)
DECLARE SUB GPrint (x, y, text$, font())
DECLARE SUB InitTrigTables ()
DECLARE SUB InstallISR ()
DECLARE SUB Instructions ()
DECLARE FUNCTION Intro ()
DECLARE SUB LoadFont (font(), name$)
DECLARE SUB LoadGameInfo ()
DECLARE SUB LoadPalette (name$)
DECLARE SUB LoadSprite (array(), name$)
DECLARE SUB Pause ()
DECLARE SUB SBInit ()
DECLARE SUB SetColours (first, last)
DECLARE SUB SetFX (chan%, curFX%())
DECLARE SUB SetVect (s, o, i)
DECLARE SUB SFXPlay (chan%, freq%, vol%)
DECLARE SUB WriteReg (reg%, value%)

TYPE PNT
    x AS INTEGER
    y AS INTEGER
    Z AS INTEGER
    p AS INTEGER
END TYPE

TYPE HUES
    r AS INTEGER
    g AS INTEGER
    B AS INTEGER
END TYPE

COMMON SHARED endScore, difficulty, endGameFlag, tileType, snd
COMMON SHARED oldKeyIntSeg, oldKeyIntOff

'$DYNAMIC

DIM SHARED pal(255) AS HUES
DIM SHARED sine!(359)
DIM SHARED cosine!(359)
DIM SHARED score(1)
DIM SHARED player$(1)
DIM SHARED keyboard(63)

CONST PI = 3.141592

RANDOMIZE TIMER

IF DetectCard% THEN
  snd = 0

  PRINT "AdLib-compatible sound card detected."
  PRINT " Initalizing...";
  SBInit
  PRINT " Done."
ELSE
  snd = 2
  PRINT "Unable to find/detect sound card."
  PRINT "Sound effects disabled."
  PRINT "Press a key..."
  BEEP
  SLEEP
END IF

LoadGameInfo

SCREEN 13
CLS

LoadPalette "pong.pal"
InitTrigTables

DO
  choice = Intro
 
  SELECT CASE choice
         CASE 1 TO 2
             score(0) = 0: score(1) = 0: endScore = 5
             player$(0) = "Player 1": player$(1) = "Player 2"
            
             GetGameInfo choice
            
             InstallISR
             DO
               GameLoop choice
               DEF SEG = VARSEG(keyboard(0))
             LOOP UNTIL score(0) = endScore OR score(1) = endScore OR endGameFlag
             SetVect oldKeyIntSeg, oldKeyIntOff, &H9
            
             DEF SEG = &H40
             POKE &H17, PEEK(&H17) AND &HFAF0
            
             FinalScore
         CASE 3
             Instructions
         CASE 4
             ChangeBackground
         CASE 5
             CLS
             IF snd <> 2 THEN
               FOR i = 0 TO 4
                  WriteReg &HA0 + i, 0: WriteReg &HB0 + i, 0
               NEXT i
             END IF
             SYSTEM
  END SELECT
LOOP

' 3D data
DATA -999
DATA 20,-100,30,1,20,-100,-30,1
DATA 20,-100,30,1,20,-65,30,1
DATA 20,-90,0,1,20,-65,0,1
DATA 20,-65,30,1,20,-55,15,1
DATA 20,-65,0,1,20,-55,15,1
DATA 20,-90,0,1,20,-90,-30,1
DATA 20,-100,-30,1,20,-90,-30,1
DATA 20,-90,20,1,20,-90,10,1
DATA 20,-90,20,1,20,-70,20,1
DATA 20,-90,10,1,20,-70,10,1
DATA 20,-70,10,1,20,-70,20,1

DATA 20,-27,30,1,20,-49,0,1
DATA 20,-27,30,1,20,-5,0,1
DATA 20,-49,0,1,20,-27,-30,1
DATA 20,-5,0,1,20,-27,-30,1
DATA 20,-27,15,1,20,-39,0,1
DATA 20,-27,15,1,20,-15,0,1
DATA 20,-27,-15,1,20,-39,0,1
DATA 20,-27,-15,1,20,-15,0,1

DATA 20,0,30,1,20,0,-30,1
DATA 20,45,30,1,20,45,-30,1
DATA 20,0,30,1,20,10,30,1
DATA 20,0,-30,1,20,10,-30,1
DATA 20,35,30,1,20,45,30,1
DATA 20,35,-30,1,20,45,-30,1
DATA 20,10,30,1,20,35,-10,1
DATA 20,10,-30,1,20,10,10,1
DATA 20,35,30,1,20,35,-10,1
DATA 20,35,-30,1,20,10,10,1

DATA 20,72,30,1,20,50,0,1
DATA 20,72,30,1,20,95,30,1
DATA 20,95,30,1,20,95,10,1
DATA 20,95,10,1,20,80,10,1
DATA 20,80,10,1,20,80,20,1
DATA 20,80,20,1,20,65,0,1
DATA 20,50,0,1,20,50,-15,1
DATA 20,65,0,1,20,65,-15,1
DATA 20,50,-15,1,20,65,-30,1
DATA 20,65,-15,1,20,80,-15,1
DATA 20,65,-30,1,20,80,-30,1
DATA 20,80,-30,1,20,95,-15,1
DATA 20,95,-15,1,20,95,-5,1
DATA 20,80,-15,1,20,75,-5,1
DATA 20,75,-5,1,20,95,-5,1

DATA -20,-100,30,1,-20,-100,-30,1
DATA -20,-100,30,1,-20,-65,30,1
DATA -20,-90,0,1,-20,-65,0,1
DATA -20,-65,30,1,-20,-55,15,1
DATA -20,-65,0,1,-20,-55,15,1
DATA -20,-90,0,1,-20,-90,-30,1
DATA -20,-100,-30,1,-20,-90,-30,1
DATA -20,-90,20,1,-20,-90,10,1
DATA -20,-90,20,1,-20,-70,20,1
DATA -20,-90,10,1,-20,-70,10,1
DATA -20,-70,10,1,-20,-70,20,1

DATA -20,-27,30,1,-20,-49,0,1
DATA -20,-27,30,1,-20,-5,0,1
DATA -20,-49,0,1,-20,-27,-30,1
DATA -20,-5,0,1,-20,-27,-30,1
DATA -20,-27,15,1,-20,-39,0,1
DATA -20,-27,15,1,-20,-15,0,1
DATA -20,-27,-15,1,-20,-39,0,1
DATA -20,-27,-15,1,-20,-15,0,1

DATA -20,0,30,1,-20,0,-30,1
DATA -20,45,30,1,-20,45,-30,1
DATA -20,0,30,1,-20,10,30,1
DATA -20,0,-30,1,-20,10,-30,1
DATA -20,35,30,1,-20,45,30,1
DATA -20,35,-30,1,-20,45,-30,1
DATA -20,10,30,1,-20,35,-10,1
DATA -20,10,-30,1,-20,10,10,1
DATA -20,35,30,1,-20,35,-10,1
DATA -20,35,-30,1,-20,10,10,1

DATA -20,72,30,1,-20,50,0,1
DATA -20,72,30,1,-20,95,30,1
DATA -20,95,30,1,-20,95,10,1
DATA -20,95,10,1,-20,80,10,1
DATA -20,80,10,1,-20,80,20,1
DATA -20,80,20,1,-20,65,0,1
DATA -20,50,0,1,-20,50,-15,1
DATA -20,65,0,1,-20,65,-15,1
DATA -20,50,-15,1,-20,65,-30,1
DATA -20,65,-15,1,-20,80,-15,1
DATA -20,65,-30,1,-20,80,-30,1
DATA -20,80,-30,1,-20,95,-15,1
DATA -20,95,-15,1,-20,95,-5,1
DATA -20,80,-15,1,-20,75,-5,1
DATA -20,75,-5,1,-20,95,-5,1

DATA 0,-110,0,1,0,110,0,1

REM $STATIC
SUB ChangeBackground

DIM font(1585)
DIM tile1(201)
DIM tile2(201)
DIM tile3(201)
DIM tile4(201)
DIM tile5(201)
DIM tile6(201)
DIM tile7(201)
DIM tile8(201)

LoadFont font(), "pong.fnt"
LoadSprite tile1(), "tile1.bsv"
LoadSprite tile2(), "tile2.bsv"
LoadSprite tile3(), "tile3.bsv"
LoadSprite tile4(), "tile4.bsv"
LoadSprite tile5(), "tile5.bsv"
LoadSprite tile6(), "tile6.bsv"
LoadSprite tile7(), "tile7.bsv"
LoadSprite tile8(), "tile8.bsv"

CLS

GPrint 160 - 3.5 * 23, 80, "Select a background tile", font()

change = 1

DO
  IF tileType = 1 THEN
    PUT (150, 100), tile1, PSET
  ELSEIF tileType = 2 THEN
    PUT (150, 100), tile2, PSET
  ELSEIF tileType = 3 THEN
    PUT (150, 100), tile3, PSET
  ELSEIF tileType = 4 THEN
    PUT (150, 100), tile4, PSET
  ELSEIF tileType = 5 THEN
    PUT (150, 100), tile5, PSET
  ELSEIF tileType = 6 THEN
    PUT (150, 100), tile6, PSET
  ELSEIF tileType = 7 THEN
    PUT (150, 100), tile7, PSET
  ELSEIF tileType = 8 THEN
    PUT (150, 100), tile8, PSET
  END IF

  DO: a$ = INKEY$: LOOP UNTIL a$ = ""
  DO: a$ = INKEY$: LOOP UNTIL a$ <> ""

  IF a$ = CHR$(0) + CHR$(72) AND tileType < 8 THEN
    tileType = tileType + 1
  ELSEIF a$ = CHR$(0) + CHR$(80) AND tileType > 1 THEN
    tileType = tileType - 1
  ELSEIF ASC(a$) = 13 THEN
    EXIT DO
  END IF
LOOP

OPEN "pong.ini" FOR BINARY AS #1

PUT #1, , tileType

CLOSE #1

END SUB

' Function to detect the sound card written by Brett Levin.
FUNCTION DetectCard%

WriteReg &H4, &H60
WriteReg &H4, &H80
B = INP(&H388)
WriteReg &H2, &HFF
WriteReg &H4, &H21

FOR x% = 0 TO 130
   a = INP(&H388)
NEXT x%

c = INP(&H388)
WriteReg &H4, &H60
WriteReg &H4, &H80
Success% = 0
IF (B AND &HE0) = &H0 THEN
  IF (c AND &HE0) = &HC0 THEN
    Success% = -1
  END IF
END IF
DetectCard% = Success%

END FUNCTION

SUB FileCheck (name$)

OPEN name$ FOR BINARY AS #1

IF LOF(1) = 0 THEN
  CLOSE #1
  KILL name$
  PRINT "Missing game file, "; name$; ", program terminated."
  SYSTEM
END IF

CLOSE #1

END SUB

SUB FinalScore

DIM font(1585)
DIM tile(201)

LoadFont font(), "pong.fnt"

IF tileType = 1 THEN
  LoadSprite tile(), "tile1.bsv"
ELSEIF tileType = 2 THEN
  LoadSprite tile(), "tile2.bsv"
ELSEIF tileType = 3 THEN
  LoadSprite tile(), "tile3.bsv"
ELSEIF tileType = 4 THEN
  LoadSprite tile(), "tile4.bsv"
ELSEIF tileType = 5 THEN
  LoadSprite tile(), "tile5.bsv"
ELSEIF tileType = 6 THEN
  LoadSprite tile(), "tile6.bsv"
ELSEIF tileType = 7 THEN
  LoadSprite tile(), "tile7.bsv"
ELSEIF tileType = 8 THEN
  LoadSprite tile(), "tile8.bsv"
END IF

DIM SFX%(12)
SFX%(1) = 15: SFX%(2) = 15: SFX%(3) = 100: SFX%(4) = 0
SFX%(5) = 241: SFX%(6) = 243: SFX%(7) = 3: SFX%(8) = 3
SFX%(9) = 0: SFX%(10) = 1: SFX%(11) = 0: SFX%(12) = 1
FOR i = 0 TO 2
   WriteReg &HA0 + i, 0: WriteReg &HB0 + i, 0: SetFX i, SFX%()
NEXT i

CLS

FOR i = 0 TO 300 STEP 20
   PUT (i, 0), tile, PSET
   PUT (i, 20), tile, PSET
   PUT (i, 160), tile, PSET
   PUT (i, 180), tile, PSET
NEXT i

FOR i = 40 TO 140 STEP 20
   PUT (0, i), tile, PSET
   PUT (300, i), tile, PSET
NEXT i

IF score(0) > score(1) THEN
  congratsStr$ = "Congratulations, " + player$(0) + "."
ELSEIF score(0) < score(1) THEN
  congratsStr$ = "Congratulations, " + player$(1) + "."
ELSE
  congratsStr$ = "Tie game, you both lose."
END IF

GPrint 160 - 3.5 * (LEN(congratsStr$) - 1), 50, congratsStr$, font()
GPrint 160 - 3.5 * 10, 100, "Final Score", font()
GPrint 100 - 3.5 * (LEN(player$(0)) - 1), 120, player$(0), font()
GPrint 220 - 3.5 * (LEN(player$(1)) - 1), 120, player$(1), font()
score$ = LTRIM$(RTRIM$(STR$(score(0))))
GPrint 100 - 3.5 * (LEN(score$) - 1), 130, score$, font()
score$ = LTRIM$(RTRIM$(STR$(score(1))))
GPrint 220 - 3.5 * (LEN(score$) - 1), 130, score$, font()

IF snd = 0 THEN
  WriteReg &HA0, 0: WriteReg &HB0, 0: SFXPlay 0, 0, 200
  curTime! = TIMER: DO: newTime! = TIMER: LOOP UNTIL newTime! > curTime! + .4
  WriteReg &HA0 + 1, 0: WriteReg &HB0 + 1, 0: SFXPlay 1, 125, 200
  curTime! = TIMER: DO: newTime! = TIMER: LOOP UNTIL newTime! > curTime! + .4
  WriteReg &HA0 + 2, 0: WriteReg &HB0 + 2, 0: SFXPlay 2, 255, 200
  curTime! = TIMER: DO: newTime! = TIMER: LOOP UNTIL newTime! > curTime! + .3
  WriteReg &HA0, 0: WriteReg &HB0, 0: SFXPlay 0, 255, 200
  curTime! = TIMER: DO: newTime! = TIMER: LOOP UNTIL newTime! > curTime! + .1
  WriteReg &HA0 + 1, 0: WriteReg &HB0 + 1, 0: SFXPlay 1, 255, 200
  curTime! = TIMER: DO: newTime! = TIMER: LOOP UNTIL newTime! > curTime! + .4
  WriteReg &HA0 + 2, 0: WriteReg &HB0 + 2, 0: SFXPlay 2, 125, 200
  curTime! = TIMER: DO: newTime! = TIMER: LOOP UNTIL newTime! > curTime! + .4
  WriteReg &HA0, 0: WriteReg &HB0, 0: SFXPlay 0, 55, 200
  curTime! = TIMER: DO: newTime! = TIMER: LOOP UNTIL newTime! > curTime! + .4
  WriteReg &HA0 + 1, 0: WriteReg &HB0 + 1, 0: SFXPlay 1, 0, 200
  WriteReg &HA0 + 2, 0: WriteReg &HB0 + 2, 0: SFXPlay 2, 125, 200
ELSE
  curTime! = TIMER: DO: newTime! = TIMER: LOOP UNTIL newTime! > curTime! + .8
END IF

Pause

END SUB

SUB GameLoop (numPlayers)

DIM ball1(41)
DIM ball2(41)
DIM ball3(41)
DIM ball4(41)
DIM ballMask(41)
DIM pad1(41)
DIM pad1Mask(41)
DIM pad2(41)
DIM pad2Mask(41)
DIM tile(201)
DIM back1(41)
DIM back2(41)
DIM back3(41)
DIM font(1585)

DIM ballStats!(6)
DIM padStats(1, 3)

LoadSprite ball1(), "ball1.bsv"
LoadSprite ball2(), "ball2.bsv"
LoadSprite ball3(), "ball3.bsv"
LoadSprite ball4(), "ball4.bsv"
LoadSprite ballMask(), "ball.msk"
LoadSprite pad1(), "pad1.bsv"
LoadSprite pad1Mask(), "pad1.msk"
LoadSprite pad2(), "pad2.bsv"
LoadSprite pad2Mask(), "pad2.msk"

IF tileType = 1 THEN
  LoadSprite tile(), "tile1.bsv"
ELSEIF tileType = 2 THEN
  LoadSprite tile(), "tile2.bsv"
ELSEIF tileType = 3 THEN
  LoadSprite tile(), "tile3.bsv"
ELSEIF tileType = 4 THEN
  LoadSprite tile(), "tile4.bsv"
ELSEIF tileType = 5 THEN
  LoadSprite tile(), "tile5.bsv"
ELSEIF tileType = 6 THEN
  LoadSprite tile(), "tile6.bsv"
ELSEIF tileType = 7 THEN
  LoadSprite tile(), "tile7.bsv"
ELSEIF tileType = 8 THEN
  LoadSprite tile(), "tile8.bsv"
END IF

LoadFont font(), "pong.fnt"

DIM SFX%(12)
SFX%(1) = 10: SFX%(2) = 5: SFX%(3) = 143: SFX%(4) = 0: SFX%(5) = 241
SFX%(6) = 243: SFX%(7) = 7: SFX%(8) = 9: SFX%(9) = 0: SFX%(10) = 3
SFX%(11) = 6: SFX%(12) = 0
WriteReg &HA0 + 3, 0: WriteReg &HB0 + 3, 0: SetFX 3, SFX%()

SFX%(1) = 5: SFX%(2) = 5: SFX%(3) = 123: SFX%(4) = 0: SFX%(5) = 241
SFX%(6) = 243: SFX%(7) = 9: SFX%(8) = 11: SFX%(9) = 0: SFX%(10) = 1
SFX%(11) = 3: SFX%(12) = 0
WriteReg &HA0 + 4, 0: WriteReg &HB0 + 4, 0: SetFX 4, SFX%()

SFX%(1) = 10: SFX%(2) = 10: SFX%(3) = 100: SFX%(4) = 0
SFX%(5) = 241: SFX%(6) = 243: SFX%(7) = 3: SFX%(8) = 3
SFX%(9) = 0: SFX%(10) = 1: SFX%(11) = 0: SFX%(12) = 3
FOR i = 0 TO 2
   WriteReg &HA0 + i, 0: WriteReg &HB0 + i, 0: SetFX i, SFX%()
NEXT i

CLS

FOR i = 0 TO 9
   LINE (0, i)-(319, i), 174 - i
   LINE (0, i + 130)-(319, i + 130), 165 + i
NEXT i

FOR y = 10 TO 110 STEP 20
   FOR x = 0 TO 300 STEP 20
      PUT (x, y), tile, PSET
   NEXT x
NEXT y

ballStats!(4) = RND * 35
tempNum = INT(RND * 4)
IF tempNum = 1 THEN ballStats!(4) = ballStats!(4) + 145
IF tempNum = 2 THEN ballStats!(4) = ballStats!(4) + 180
IF tempNum = 3 THEN ballStats!(4) = ballStats!(4) + 325

ballStats!(0) = 155: ballStats!(2) = 155
ballStats!(1) = 65: ballStats!(3) = 65
ballStats!(5) = 0
ballStats!(6) = 1

padStats(0, 0) = 0: padStats(0, 2) = 0
padStats(0, 1) = 60: padStats(0, 3) = 60

padStats(1, 0) = 315: padStats(1, 2) = 315
padStats(1, 1) = 60: padStats(1, 3) = 60

GET (ballStats!(0), ballStats!(1))-(ballStats!(0) + 9, ballStats!(1) + 7), back1
GET (padStats(0, 0), padStats(0, 1))-(padStats(0, 0) + 3, padStats(0, 1) + 19), back2
GET (padStats(1, 0), padStats(1, 1))-(padStats(1, 0) + 3, padStats(1, 1) + 19), back3

PUT (ballStats!(0), ballStats!(1)), ballMask, AND
PUT (padStats(0, 0), padStats(0, 1)), pad1Mask, AND
PUT (padStats(1, 0), padStats(1, 1)), pad2Mask, AND

PUT (ballStats!(0), ballStats!(1)), ball1, XOR
PUT (padStats(0, 0), padStats(0, 1)), pad1, XOR
PUT (padStats(1, 0), padStats(1, 1)), pad2, XOR

GPrint 1, 145, player$(0), font()
score$ = LTRIM$(RTRIM$(STR$(score(0))))
GPrint 1, 155, score$, font()
GPrint 319 - LEN(player$(1)) * 7, 145, player$(1), font()
score$ = LTRIM$(RTRIM$(STR$(score(1))))
GPrint 319 - LEN(score$) * 7, 155, score$, font()

chan% = 0
FOR i = 55 TO 255 STEP 25
   IF snd = 0 THEN
     WriteReg &HA0 + chan%, 0: WriteReg &HB0 + chan%, 0
     SFXPlay chan%, i, 220
     chan% = (chan% + 1) MOD 3
   END IF

   curTime! = TIMER
   DO: newTime! = TIMER: LOOP UNTIL curTime! <> newTime!
NEXT i

skipOut = 0
DO
  padStats(0, 3) = padStats(0, 1)
  padStats(1, 3) = padStats(1, 1)
  ballStats!(2) = ballStats!(0)
  ballStats!(3) = ballStats!(1)

  IF numPlayers = 2 THEN
    DEF SEG = VARSEG(keyboard(0))
    IF PEEK(72) = 0 THEN
      IF padStats(1, 1) > 10 THEN padStats(1, 1) = padStats(1, 1) - 1
    END IF
   
    DEF SEG = VARSEG(keyboard(0))
    IF PEEK(80) = 0 THEN
      IF padStats(1, 1) < 110 THEN padStats(1, 1) = padStats(1, 1) + 1
    END IF
  ELSE
    IF difficulty = 2 THEN
      IF padStats(1, 1) > ballStats!(1) - 5 AND padStats(1, 1) > 10 THEN padStats(1, 1) = padStats(1, 1) - 1
      IF padStats(1, 1) < ballStats!(1) - 5 AND padStats(1, 1) < 110 THEN padStats(1, 1) = padStats(1, 1) + 1
    ELSE
      tempNum = INT(RND * 5)
      IF padStats(1, 1) > ballStats!(1) - 5 AND padStats(1, 1) > 10 AND tempNum < 2 THEN
        padStats(1, 1) = padStats(1, 1) - 1
      ELSE
        padStats(1, 1) = padStats(1, 1) + 1
      END IF

      IF padStats(1, 1) < ballStats!(1) - 5 AND padStats(1, 1) < 110 AND tempNum < 2 THEN
        padStats(1, 1) = padStats(1, 1) + 1
      ELSE
        padStats(1, 1) = padStats(1, 1) - 1
      END IF
    END IF
  END IF
 
  DEF SEG = VARSEG(keyboard(0))
  IF PEEK(&H1E) = 0 THEN
    IF padStats(0, 1) > 10 THEN padStats(0, 1) = padStats(0, 1) - 1
  END IF

  DEF SEG = VARSEG(keyboard(0))
  IF PEEK(&H2C) = 0 THEN
    IF padStats(0, 1) < 110 THEN padStats(0, 1) = padStats(0, 1) + 1
  END IF

  DEF SEG = VARSEG(keyboard(0))
  IF PEEK(&H19) = 0 AND PEEK(&H1D) = 0 THEN
    DO: LOOP WHILE PEEK(&H19) = 0
    DO: LOOP UNTIL PEEK(&H19) = 0
  END IF
 
  IF PEEK(&H1F) = 0 AND PEEK(&H1D) = 0 THEN
    IF snd = 0 THEN
      snd = 1
    ELSEIF snd = 1 THEN
      snd = 0
    END IF
  END IF
 
  ballStats!(4) = ballStats!(4) + ballStats!(5)
  IF ballStats!(4) >= 360 THEN ballStats!(4) = ballStats!(4) - 360
  IF ballStats!(4) < 0 THEN ballStats!(4) = ballStats!(4) + 360
 
  ballStats!(6) = ballStats!(6) + ballStats!(5)
  IF ballStats!(6) >= 5 THEN ballStats!(6) = ballStats!(6) - 4
  IF ballStats!(6) < 1 THEN ballStats!(6) = ballStats!(6) + 4
  
  ballStats!(0) = ballStats!(0) + cosine!(INT(ballStats!(4))) * 2
  ballStats!(1) = ballStats!(1) + sine!(INT(ballStats!(4))) * 2

  IF ballStats!(4) > 90 AND ballStats!(4) < 270 THEN
    tempAn! = ballStats!(4) - 90
    IF tempAn! < 0 THEN tempAn! = tempAn! + 360
  ELSE
    tempAn! = ballStats!(4) + 90
    IF tempAn! >= 360 THEN tempAn! = tempAn! - 360
  END IF

  anChange = 0
  IF ballStats!(1) < 10 THEN
    tempAn! = ABS(tempAn! - 540)
    anChange = 1
    IF snd = 0 THEN
      WriteReg &HA0 + 3, 0: WriteReg &HB0 + 3, 0: SFXPlay 3, 255, 200
    END IF
  ELSEIF ballStats!(1) > 123 THEN
    tempAn! = ABS(tempAn! - 180)
    anChange = 1
    IF snd = 0 THEN
      WriteReg &HA0 + 3, 0: WriteReg &HB0 + 3, 0: SFXPlay 3, 255, 200
    END IF
  END IF

  IF ballStats!(4) > 90 AND ballStats!(4) < 270 THEN
    ballStats!(4) = tempAn! + 90
    IF ballStats!(4) < 0 THEN ballStats!(4) = ballStats!(4) + 360
    IF ballStats!(4) >= 360 THEN ballStats!(4) = ballStats!(4) - 360
    IF anChange THEN
      ballStats!(0) = ballStats!(0) + cosine!(INT(ballStats!(4))) * 2
      ballStats!(1) = ballStats!(1) + sine!(INT(ballStats!(4))) * 2
    END IF
  ELSE
    ballStats!(4) = tempAn! - 90
    IF ballStats!(4) < 0 THEN ballStats!(4) = ballStats!(4) + 360
    IF ballStats!(4) >= 360 THEN ballStats!(4) = ballStats!(4) - 360
    IF anChange THEN
      ballStats!(0) = ballStats!(0) + cosine!(INT(ballStats!(4))) * 2
      ballStats!(1) = ballStats!(1) + sine!(INT(ballStats!(4))) * 2
    END IF
  END IF
   
  IF ballStats!(4) > 180 THEN
    IF ballStats!(0) < 5 AND padStats(0, 1) < ballStats!(1) + 7 AND padStats(0, 1) + 17 > ballStats!(1) THEN
      ballStats!(4) = ABS(ballStats!(4) - 540)
      DEF SEG = VARSEG(keyboard(0))
      IF PEEK(&H1E) = 0 AND ballStats!(5) < 2 THEN ballStats!(5) = ballStats!(5) + (RND * .5)
      IF PEEK(&H2C) = 0 AND ballStats!(5) > -2 THEN ballStats!(5) = ballStats!(5) - (RND * .5)
      ballStats!(0) = ballStats!(0) + cosine!(INT(ballStats!(4))) * 2
      ballStats!(1) = ballStats!(1) + sine!(INT(ballStats!(4))) * 2
      IF snd = 0 THEN
        WriteReg &HA0 + 4, 0: WriteReg &HB0 + 4, 0: SFXPlay 4, 100, 200
      END IF
    ELSEIF ballStats!(0) > 305 AND padStats(1, 1) < ballStats!(1) + 7 AND padStats(1, 1) + 17 > ballStats!(1) THEN
      ballStats!(4) = ABS(ballStats!(4) - 540)
      IF numPlayers = 2 THEN
        DEF SEG = VARSEG(keyboard(0))
        IF PEEK(72) = 0 AND ballStats!(5) > -2 THEN ballStats!(5) = ballStats!(5) - (RND * .5)
        IF PEEK(80) = 0 AND ballStats!(5) < 2 THEN ballStats!(5) = ballStats!(5) + (RND * .5)
      ELSE
        IF padStats(1, 1) > ballStats!(1) - 3 AND ballStats!(5) > -2 THEN ballStats!(5) = ballStats!(5) - (RND * .5)
        IF padStats(1, 1) < ballStats!(1) - 7 AND ballStats!(5) < 2 THEN ballStats!(5) = ballStats!(5) + (RND * .5)
      END IF
      ballStats!(0) = ballStats!(0) + cosine!(INT(ballStats!(4))) * 2
      ballStats!(1) = ballStats!(1) + sine!(INT(ballStats!(4))) * 2
      IF snd = 0 THEN
        WriteReg &HA0 + 4, 0: WriteReg &HB0 + 4, 0: SFXPlay 4, 100, 200
      END IF
    END IF
  ELSEIF ballStats!(4) <= 180 THEN
    IF ballStats!(0) < 5 AND padStats(0, 1) < ballStats!(1) + 7 AND padStats(0, 1) + 17 > ballStats!(1) THEN
      ballStats!(4) = ABS(ballStats!(4) - 180)
      DEF SEG = VARSEG(keyboard(0))
      IF PEEK(&H1E) = 0 AND ballStats!(5) < 2 THEN ballStats!(5) = ballStats!(5) + (RND * .5)
      IF PEEK(&H2C) = 0 AND ballStats!(5) > -2 THEN ballStats!(5) = ballStats!(5) - (RND * .5)
      ballStats!(0) = ballStats!(0) + cosine!(INT(ballStats!(4))) * 2
      ballStats!(1) = ballStats!(1) + sine!(INT(ballStats!(4))) * 2
      IF snd = 0 THEN
        WriteReg &HA0 + 4, 0: WriteReg &HB0 + 4, 0: SFXPlay 4, 100, 200
      END IF
    ELSEIF ballStats!(0) > 305 AND padStats(1, 1) < ballStats!(1) + 7 AND padStats(1, 1) + 17 > ballStats!(1) THEN
      ballStats!(4) = ABS(ballStats!(4) - 180)
      IF numPlayers = 2 THEN
        DEF SEG = VARSEG(keyboard(0))
        IF PEEK(72) = 0 AND ballStats!(5) > -2 THEN ballStats!(5) = ballStats!(5) - (RND * .5)
        IF PEEK(80) = 0 AND ballStats!(5) < 2 THEN ballStats!(5) = ballStats!(5) + (RND * .5)
      ELSE
        IF padStats(1, 1) > ballStats!(1) - 3 AND ballStats!(5) > -2 THEN ballStats!(5) = ballStats!(5) - (RND * .5)
        IF padStats(1, 1) < ballStats!(1) - 7 AND ballStats!(5) < 2 THEN ballStats!(5) = ballStats!(5) + (RND * .5)
      END IF
      ballStats!(0) = ballStats!(0) + cosine!(INT(ballStats!(4))) * 2
      ballStats!(1) = ballStats!(1) + sine!(INT(ballStats!(4))) * 2
      IF snd = 0 THEN
        WriteReg &HA0 + 4, 0: WriteReg &HB0 + 4, 0: SFXPlay 4, 100, 200
      END IF
    END IF
  END IF

  IF ballStats!(0) < 3 THEN
    score(1) = score(1) + 1
    skipOut = 1
    EXIT DO
  ELSEIF ballStats!(0) > 307 THEN
    score(0) = score(0) + 1
    skipOut = 1
    EXIT DO
  END IF
 
  WAIT &H3DA, 8

  PUT (INT(ballStats!(2)), INT(ballStats!(3))), back1, PSET
  PUT (padStats(0, 2), padStats(0, 3)), back2, PSET
  PUT (padStats(1, 2), padStats(1, 3)), back3, PSET

  GET (INT(ballStats!(0)), INT(ballStats!(1)))-(INT(ballStats!(0)) + 9, INT(ballStats!(1)) + 7), back1
  GET (padStats(0, 0), padStats(0, 1))-(padStats(0, 0) + 3, padStats(0, 1) + 19), back2
  GET (padStats(1, 0), padStats(1, 1))-(padStats(1, 0) + 3, padStats(1, 1) + 19), back3
  
  PUT (INT(ballStats!(0)), INT(ballStats!(1))), ballMask, AND
  PUT (padStats(0, 0), padStats(0, 1)), pad1Mask, AND
  PUT (padStats(1, 0), padStats(1, 1)), pad2Mask, AND

  SELECT CASE INT(ballStats!(6))
         CASE 1
             PUT (INT(ballStats!(0)), INT(ballStats!(1))), ball1, XOR
         CASE 2
             PUT (INT(ballStats!(0)), INT(ballStats!(1))), ball2, XOR
         CASE 3
             PUT (INT(ballStats!(0)), INT(ballStats!(1))), ball3, XOR
         CASE 4
             PUT (INT(ballStats!(0)), INT(ballStats!(1))), ball4, XOR
  END SELECT

  PUT (padStats(0, 0), padStats(0, 1)), pad1, XOR
  PUT (padStats(1, 0), padStats(1, 1)), pad2, XOR
  DEF SEG = VARSEG(keyboard(0))
LOOP UNTIL PEEK(1) = 0

endGameFlag = 0
IF PEEK(1) = 0 THEN endGameFlag = 1

IF skipOut THEN PUT (INT(ballStats!(2)), INT(ballStats!(3))), back1, PSET

chan% = 0
FOR i = 255 TO 15 STEP -30
   IF snd = 0 THEN
     WriteReg &HA0 + chan%, 0: WriteReg &HB0 + chan%, 0
     SFXPlay chan%, i, 220
     chan% = (chan% + 1) MOD 3
     curTime! = TIMER
     DO: newTime! = TIMER: LOOP UNTIL curTime! <> newTime!
   END IF
NEXT i

curTime! = TIMER
DO: newTime! = TIMER: LOOP UNTIL newTime! > curTime! + 1.5

END SUB

SUB GetGameInfo (numPlayers)

DIM font(1585)

LoadFont font(), "pong.fnt"

CLS
GPrint 10, 95, "Player 1, enter your name:", font()
player$(0) = GetString$(15, 195, 95, font())

IF numPlayers = 2 THEN
  CLS
  GPrint 10, 95, "Player 2, enter your name:", font()
  player$(1) = GetString$(15, 195, 95, font())
ELSE
  CLS
  GPrint 40, 95, "Computer skill level:", font()
  GPrint 190, 95, "Beginner", font()
  difficulty = 1
  player$(1) = "Timmy"

  DO
    DO: a$ = INKEY$: LOOP UNTIL a$ = ""
    DO: a$ = INKEY$: LOOP UNTIL a$ <> ""

    IF a$ = CHR$(0) + CHR$(72) AND difficulty = 1 THEN
      difficulty = 2
      LINE (190, 95)-(320, 105), 0, BF
      GPrint 190, 95, "Expert", font()
      player$(1) = "Xavius"
    ELSEIF a$ = CHR$(0) + CHR$(80) AND difficulty = 2 THEN
      difficulty = 1
      LINE (190, 95)-(320, 105), 0, BF
      GPrint 190, 95, "Beginner", font()
      player$(1) = "Timmy"
    ELSEIF ASC(a$) = 13 THEN
      EXIT DO
    END IF
  LOOP
END IF

CLS
GPrint 30, 90, "How many goals will this game go to?", font()
endScore$ = LTRIM$(RTRIM$(STR$(endScore)))
GPrint 160 - 4 * LEN(endScore$), 100, endScore$, font()

DO
  DO: a$ = INKEY$: LOOP UNTIL a$ = ""
  DO: a$ = INKEY$: LOOP UNTIL a$ <> ""

  IF a$ = CHR$(0) + CHR$(72) THEN
    LINE (160 - 4 * LEN(endScore$), 100)-(160 + 4 * LEN(endScore$), 109), 0, BF
    IF endScore < 32767 THEN endScore = endScore + 1
    endScore$ = LTRIM$(RTRIM$(STR$(endScore)))
    GPrint 160 - 4 * LEN(endScore$), 100, endScore$, font()
  ELSEIF a$ = CHR$(0) + CHR$(80) THEN
    LINE (160 - 4 * LEN(endScore$), 100)-(160 + 4 * LEN(endScore$), 109), 0, BF
    IF endScore > 1 THEN endScore = endScore - 1
    endScore$ = LTRIM$(RTRIM$(STR$(endScore)))
    GPrint 160 - 4 * LEN(endScore$), 100, endScore$, font()
  ELSEIF ASC(a$) = 13 THEN
    EXIT DO
  END IF
LOOP

END SUB

' This is the routine that sets up the cool input with the funky blinking
' cursor.  Written by me.
FUNCTION GetString$ (length, x, y, font())

ctr = 1
boxStage = 0
boxTime! = TIMER
changeBox = 1

DO: a$ = INKEY$: LOOP UNTIL a$ = ""

DO
  IF changeBox THEN
    LINE (x + 7 * (ctr - 1), y)-(x + 7 * (ctr - 1) + 5, y + 7), 0, BF
    LINE (x + 7 * (ctr - 1) + boxStage, y + boxStage)-(x + 7 * (ctr - 1) + 5 - boxStage, y + 7 - boxStage), 15 - boxStage * 2, B
    changeBox = 0
  END IF

  a$ = INKEY$

  IF a$ <> "" THEN
    asciiVal = ASC(a$)
   
    IF ctr < length THEN
      SELECT CASE asciiVal
             CASE 32
                 tempStr$ = tempStr$ + a$
                 LINE (x + 7 * (ctr - 1), y)-(x + 7 * (ctr - 1) + 5, y + 7), 0, BF
                 ctr = ctr + 1
             CASE 33 TO 59
                 tempStr$ = tempStr$ + a$
                 LINE (x + 7 * (ctr - 1), y)-(x + 7 * (ctr - 1) + 5, y + 7), 0, BF
                 GPrint x + 7 * (ctr - 1), y, a$, font()
                 ctr = ctr + 1
             CASE 61
                 tempStr$ = tempStr$ + a$
                 LINE (x + 7 * (ctr - 1), y)-(x + 7 * (ctr - 1) + 5, y + 7), 0, BF
                 GPrint x + 7 * (ctr - 1), y, a$, font()
                 ctr = ctr + 1
             CASE 63 TO 91
                 tempStr$ = tempStr$ + a$
                 LINE (x + 7 * (ctr - 1), y)-(x + 7 * (ctr - 1) + 5, y + 7), 0, BF
                 GPrint x + 7 * (ctr - 1), y, a$, font()
                 ctr = ctr + 1
             CASE 93 TO 94
                 tempStr$ = tempStr$ + a$
                 LINE (x + 7 * (ctr - 1), y)-(x + 7 * (ctr - 1) + 5, y + 7), 0, BF
                 GPrint x + 7 * (ctr - 1), y, a$, font()
                 ctr = ctr + 1
             CASE 97 TO 123
                 tempStr$ = tempStr$ + a$
                 LINE (x + 7 * (ctr - 1), y)-(x + 7 * (ctr - 1) + 5, y + 7), 0, BF
                 GPrint x + 7 * (ctr - 1), y, a$, font()
                 ctr = ctr + 1
             CASE 125
                 tempStr$ = tempStr$ + a$
                 LINE (x + 7 * (ctr - 1), y)-(x + 7 * (ctr - 1) + 5, y + 7), 0, BF
                 GPrint x + 7 * (ctr - 1), y, a$, font()
                 ctr = ctr + 1
      END SELECT
    END IF

    IF asciiVal = 13 THEN
      EXIT DO
    ELSEIF asciiVal = 8 THEN
      IF ctr > 2 THEN
        LINE (x + 7 * (ctr - 1), y)-(x + 7 * (ctr - 1) + 5, y + 7), 0, BF
        ctr = ctr - 1
        tempStr$ = LEFT$(tempStr$, ctr - 1)
        LINE (x + 7 * (ctr - 1), y)-(x + 7 * (ctr - 1) + 5, y + 7), 0, BF
      ELSEIF ctr = 2 THEN
        LINE (x + 7 * (ctr - 1), y)-(x + 7 * (ctr - 1) + 5, y + 7), 0, BF
        ctr = 1
        LINE (x + 7 * (ctr - 1), y)-(x + 7 * (ctr - 1) + 5, y + 7), 0, BF
        tempStr$ = ""
      END IF
    END IF

    DO: a$ = INKEY$: LOOP UNTIL a$ = ""
  END IF

  IF boxTime! <> TIMER THEN
    boxStage = (boxStage + 1) MOD 3
    changeBox = 1
    boxTime! = TIMER
  END IF
LOOP

GetString$ = tempStr$

END FUNCTION

' Written by Steven Sensarn.
SUB GetVect (s, o, i)

    'GETVECT RETURNS THE ADDRESS OF A FUNCTION POINTED TO IN THE
    'INTERRUPT VECTOR TABLE (STARTS AT 0000:0000H)

    STATIC ASM AS STRING 'THE CODE FOR GETVECT

    STATIC INI AS INTEGER 'USED TO DETECT WHETHER GETVECT HAS PREVIOUSLY
                          'BEEN CALLED
    IF INI = 0 THEN
      
        'CREATE ML FUNCTION IF NOT ALREADY CREATED

        ASM = ASM + CHR$(&H55)                          'PUSH    BP
        ASM = ASM + CHR$(&H89) + CHR$(&HE5)             'MOV     BP,SP
        ASM = ASM + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H6) 'MOV     BX,[BP+06]
        ASM = ASM + CHR$(&H8A) + CHR$(&H7)              'MOV     AL,[BX]
        ASM = ASM + CHR$(&HB4) + CHR$(&H35)             'MOV     AH,35
        ASM = ASM + CHR$(&HCD) + CHR$(&H21)             'INT     21
        ASM = ASM + CHR$(&H53)                          'PUSH    BX
        ASM = ASM + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HA) 'MOV     BX,[BP+0A]
        ASM = ASM + CHR$(&H8C) + CHR$(&H7)              'MOV     [BX],ES
        ASM = ASM + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8) 'MOV     BX,[BP+08]
        ASM = ASM + CHR$(&H58)                          'POP     AX
        ASM = ASM + CHR$(&H89) + CHR$(&H7)              'MOV     [BX],AX
        ASM = ASM + CHR$(&H5D)                          'POP     BP
        ASM = ASM + CHR$(&HCA) + CHR$(&H6) + CHR$(&H0)  'RETF    0006
        INI = 1 'FLAG CREATION
    END IF

    DEF SEG = VARSEG(ASM)
    CALL ABSOLUTE(s, o, i, SADD(ASM)) 'RUN FUNCTION

END SUB

' Just a graphical print routine to make the text look better. Written by me.
SUB GPrint (x, y, text$, font())

text$ = UCASE$(text$)
length = LEN(text$)

FOR i = 1 TO length
   ascii = ASC(MID$(text$, i, 1))
   SELECT CASE ascii
          CASE 65 TO 90
              ascii = ascii - 65
          CASE 48
              ascii = 9 + 26
          CASE 49 TO 57
              ascii = ascii - 49 + 26
          CASE 33
              ascii = 36
          CASE 64
              ascii = 37
          CASE 35 TO 37
              ascii = ascii - 35 + 38
          CASE 94
              ascii = 41
          CASE 38
              ascii = 42
          CASE 42
              ascii = 43
          CASE 40 TO 41
              ascii = ascii - 40 + 44
          CASE 45
              ascii = 46
          CASE 43
              ascii = 47
          CASE 61
              ascii = 48
          CASE 123
              ascii = 49
          CASE 125
              ascii = 50
          CASE 91
              ascii = 51
          CASE 93
              ascii = 52
          CASE 58 TO 59
              ascii = ascii - 58 + 53
          CASE 34
              ascii = 55
          CASE 39
              ascii = 56
          CASE 44
              ascii = 57
          CASE 46
              ascii = 58
          CASE 63
              ascii = 59
          CASE 47
              ascii = 60
          CASE ELSE
              ascii = 61
   END SELECT

   IF ascii < 61 THEN
     PUT (x, y), font(26 * ascii)
     x = x + 7
   ELSE
     x = x + 7
   END IF
NEXT i

END SUB

SUB InitTrigTables

FOR i = 0 TO 359
   sine!(i) = SIN(i * PI / 180)
   cosine!(i) = COS(i * PI / 180)
NEXT i

END SUB

' This routine is based on a routine from KEYISR.BAS by Steven Sensarn.  I
' replaced the assembly code with my own routine that keeps track of all the
' keys, other than that it's pretty much the same.
SUB InstallISR

DIM SGL AS INTEGER, SGH AS INTEGER              'Segment of keyboard()
DIM OFL AS INTEGER, OFH AS INTEGER              'Offset of keyboard()

DIM BYTE AS STRING * 1

STATIC ASM AS STRING                            'Holds machine code for ISR

SGL = VARSEG(keyboard(0)) AND &HFF              'Get low byte of segment
SGH = INT(VARSEG(keyboard(0)) / 256) AND &HFF   'Get high byte of segment

OFL = VARPTR(keyboard(0)) AND &HFF              'Get low byte of offset
OFH = INT(VARPTR(keyboard(0)) / 256) AND &HFF   'Get high byte of offset

'Assembly code for the ISR.

ASM = ""
ASM = ASM + CHR$(&H52)                          'PUSH DX
ASM = ASM + CHR$(&H51)                          'PUSH CX
ASM = ASM + CHR$(&H53)                          'PUSH BX
ASM = ASM + CHR$(&H50)                          'PUSH AX
ASM = ASM + CHR$(&H1E)                          'PUSH DS
ASM = ASM + CHR$(&H56)                          'PUSH SI
ASM = ASM + CHR$(&HFB)                          'STI
ASM = ASM + CHR$(&HE4) + CHR$(&H60)             'IN   AL,60h
ASM = ASM + CHR$(&H30) + CHR$(&HE4)             'XOR  AH,AH
ASM = ASM + CHR$(&HB1) + CHR$(&H7F)             'MOV  CL,7Fh
ASM = ASM + CHR$(&H88) + CHR$(&HC3)             'MOV  BL,AL
ASM = ASM + CHR$(&H20) + CHR$(&HCB)             'AND  BL,CL
ASM = ASM + CHR$(&HBA) + CHR$(SGL) + CHR$(SGH)  'MOV  DX,SEG keyboard()
ASM = ASM + CHR$(&H8E) + CHR$(&HDA)             'MOV  DS,DX
ASM = ASM + CHR$(&HB1) + CHR$(&H80)             'MOV  CL,80h
ASM = ASM + CHR$(&H20) + CHR$(&HC8)             'AND  AL,CL
ASM = ASM + CHR$(&H30) + CHR$(&HFF)             'XOR  BH,BH
ASM = ASM + CHR$(&HBE) + CHR$(OFL) + CHR$(OFH)  'MOV  SI,OFFSET keyboard()
ASM = ASM + CHR$(&H1) + CHR$(&HDE)              'ADD  SI,BX
ASM = ASM + CHR$(&H88) + CHR$(&H4)              'MOV  [SI],AL
ASM = ASM + CHR$(&HE4) + CHR$(&H61)             'IN   AL,61h
ASM = ASM + CHR$(&H80) + CHR$(&HCC) + CHR$(&H82)'OR   AH,82h
ASM = ASM + CHR$(&HE6) + CHR$(&H61)             'OUT  61h,AL
ASM = ASM + CHR$(&H24) + CHR$(&H7F)             'AND  AL,7Fh
ASM = ASM + CHR$(&HE6) + CHR$(&H61)             'OUT  61h,AL
ASM = ASM + CHR$(&HB0) + CHR$(&H20)             'MOV  AL,20h
ASM = ASM + CHR$(&HE6) + CHR$(&H20)             'OUT  20h,AL
ASM = ASM + CHR$(&H5E)                          'POP  SI
ASM = ASM + CHR$(&H1F)                          'POP  DS
ASM = ASM + CHR$(&H58)                          'POP  AX
ASM = ASM + CHR$(&H5B)                          'POP  BX
ASM = ASM + CHR$(&H59)                          'POP  CX
ASM = ASM + CHR$(&H5A)                          'POP  DX
ASM = ASM + CHR$(&HCF)                          'IRET
       
BYTE = CHR$(INP(&H21))
   
OUT &H21, (ASC(BYTE) AND (255 XOR 2))           'Clear bit 2 (irq 1)

CALL GetVect(oldKeyIntSeg, oldKeyIntOff, &H9)   'Save old ISR address
CALL SetVect(VARSEG(ASM), SADD(ASM), &H9)       'Load new ISR address

DEF SEG = VARSEG(keyboard(0))
FOR i = 0 TO 127: POKE i, 128: NEXT i    'Initialize the flags

END SUB

SUB Instructions

DIM font(1585)

LoadFont font(), "pong.fnt"

CLS

GPrint 160 - 3.5 * 7, 20, "Controls", font()
GPrint 160 - 3.5 * 7, 50, "Player 1", font()
GPrint 160 - 3.5 * 10, 65, "Move up - A", font()
GPrint 160 - 3.5 * 12, 75, "Move down - Z", font()
GPrint 160 - 3.5 * 7, 95, "Player 2", font()
GPrint 160 - 3.5 * 17, 110, "Move up - Up arrow", font()
GPrint 160 - 3.5 * 21, 120, "Move down - Down arrow", font()
GPrint 160 - 3.5 * 14, 145, "Esc - Quit game", font()
GPrint 160 - 3.5 * 22, 155, "Ctrl + S - Sound on/off", font()
GPrint 160 - 3.5 * 34, 165, "Ctrl + P - Pause, press P to resume", font()

Pause

END SUB

' The 3D routine contained in this function was written by me, Aaron Severn
' while studying the two documents mentioned in the list of thanks at the
' start of the code written by Denthor of Asphyxia and Lithium of VLA.  Much
' thanks to these two, without whom the 3D you see in this game would never
' have been possible.
FUNCTION Intro

DIM font(1585)
DIM tile(201)

LoadFont font(), "pong.fnt"

IF tileType = 1 THEN
  LoadSprite tile(), "tile1.bsv"
ELSEIF tileType = 2 THEN
  LoadSprite tile(), "tile2.bsv"
ELSEIF tileType = 3 THEN
  LoadSprite tile(), "tile3.bsv"
ELSEIF tileType = 4 THEN
  LoadSprite tile(), "tile4.bsv"
ELSEIF tileType = 5 THEN
  LoadSprite tile(), "tile5.bsv"
ELSEIF tileType = 6 THEN
  LoadSprite tile(), "tile6.bsv"
ELSEIF tileType = 7 THEN
  LoadSprite tile(), "tile7.bsv"
ELSEIF tileType = 8 THEN
  LoadSprite tile(), "tile8.bsv"
END IF

CLS

numLines = 89 - 1

DIM origLine(numLines, 1) AS PNT
DIM newLine(numLines, 1) AS PNT
DIM scrX(numLines, 1)
DIM scrY(numLines, 1)
DIM oldX(numLines, 1)
DIM oldY(numLines, 1)

GPrint 160 - 3.5 * 21, 128, "A Game By Aaron Severn", font()
GPrint 160 - 3.5 * 17, 150, "1. One player game", font()
GPrint 160 - 3.5 * 17, 160, "2. Two player game", font()
GPrint 160 - 3.5 * 14, 170, "3. Instructions", font()
GPrint 160 - 3.5 * 19, 180, "4. Change Background", font()
GPrint 160 - 3.5 * 6, 190, "5. Quit", font()

FOR y = 0 TO 180 STEP 20
   PUT (0, y), tile, PSET
   PUT (20, y), tile, PSET
   PUT (40, y), tile, PSET
   PUT (260, y), tile, PSET
   PUT (280, y), tile, PSET
   PUT (300, y), tile, PSET
NEXT y

RESTORE
   
DO: READ garbage: LOOP UNTIL garbage = -999

FOR i = 0 TO numLines
   READ origLine(i, 0).x, origLine(i, 0).y, origLine(i, 0).Z, origLine(i, 0).p
   READ origLine(i, 1).x, origLine(i, 1).y, origLine(i, 1).Z, origLine(i, 1).p
NEXT

xCenter = 160: yCenter = 63: zCenter = 450
theta = 0: phi = 0: lineClr = 159: clrDir = 0

DO: a$ = INKEY$: LOOP UNTIL a$ = ""

justStarted = 1
DO
  theta = (theta + 1) MOD 360
  phi = (phi + 1) MOD 360
 
  FOR i = 0 TO numLines
     oldX(i, 0) = scrX(i, 0): oldY(i, 0) = scrY(i, 0)
     oldX(i, 1) = scrX(i, 1): oldY(i, 1) = scrY(i, 1)
  
     newLine(i, 0).x = -origLine(i, 0).x * sine!(theta) + origLine(i, 0).y * cosine!(theta)
     newLine(i, 0).y = -origLine(i, 0).x * cosine!(theta) * sine!(phi) - origLine(i, 0).y * sine!(theta) * sine!(phi) - origLine(i, 0).Z * cosine!(phi) + origLine(i, 0).p
     newLine(i, 0).Z = -origLine(i, 0).x * cosine!(theta) * cosine!(phi) - origLine(i, 0).y * sine!(theta) * cosine!(phi) + origLine(i, 0).Z * sine!(phi)

     newLine(i, 1).x = -origLine(i, 1).x * sine!(theta) + origLine(i, 1).y * cosine!(theta)
     newLine(i, 1).y = -origLine(i, 1).x * cosine!(theta) * sine!(phi) - origLine(i, 1).y * sine!(theta) * sine!(phi) - origLine(i, 1).Z * cosine!(phi) + origLine(i, 1).p
     newLine(i, 1).Z = -origLine(i, 1).x * cosine!(theta) * cosine!(phi) - origLine(i, 1).y * sine!(theta) * cosine!(phi) + origLine(i, 1).Z * sine!(phi)

     IF (newLine(i, 0).Z + zCenter) <> 0 THEN
       scrX(i, 0) = 256 * (newLine(i, 0).x / (newLine(i, 0).Z + zCenter)) + xCenter
       scrY(i, 0) = 256 * (newLine(i, 0).y / (newLine(i, 0).Z + zCenter)) + yCenter
     END IF

     IF (newLine(i, 1).Z + zCenter) <> 0 THEN
       scrX(i, 1) = 256 * (newLine(i, 1).x / (newLine(i, 1).Z + zCenter)) + xCenter
       scrY(i, 1) = 256 * (newLine(i, 1).y / (newLine(i, 1).Z + zCenter)) + yCenter
     END IF
  NEXT i

  WAIT &H3DA, 8
  IF justStarted = 0 THEN
    FOR i = 0 TO numLines
       LINE (oldX(i, 0), oldY(i, 0))-(oldX(i, 1), oldY(i, 1)), 0
    NEXT i
  END IF

  FOR i = 0 TO numLines
     LINE (scrX(i, 0), scrY(i, 0))-(scrX(i, 1), scrY(i, 1)), lineClr
  NEXT i

  justStarted = 0
 
  IF clrDir = 0 THEN
    lineClr = lineClr - 1
    IF lineClr = 144 THEN clrDir = 1
  ELSEIF clrDir = 1 THEN
    lineClr = lineClr + 1
    IF lineClr = 159 THEN clrDir = 0
  END IF

  a$ = INKEY$
LOOP UNTIL a$ = "1" OR a$ = "2" OR a$ = "3" OR a$ = "4" OR a$ = "5"

choice = VAL(a$)
DO: a$ = INKEY$: LOOP UNTIL a$ = ""

Intro = choice

END FUNCTION

SUB LoadFont (font(), name$)

FileCheck name$
DEF SEG = VARSEG(font(0))
BLOAD name$, 0

END SUB

SUB LoadGameInfo

OPEN "pong.ini" FOR BINARY AS #1

IF LOF(1) = 0 THEN
  tileType = 3
  PUT #1, , tileType
ELSE
  GET #1, , tileType
END IF

CLOSE #1

END SUB

SUB LoadPalette (name$)

FileCheck name$
OPEN name$ FOR BINARY AS #1

FOR i = 0 TO 255
   GET #1, , pal(i).r
   GET #1, , pal(i).g
   GET #1, , pal(i).B
NEXT i

CLOSE #1

SetColours 0, 255

END SUB

SUB LoadSprite (array(), name$)

FileCheck name$
DEF SEG = VARSEG(array(0))
BLOAD name$, 0

END SUB

SUB Pause

DO: a$ = INKEY$: LOOP UNTIL a$ = ""
DO: a$ = INKEY$: LOOP UNTIL a$ <> ""
DO: a$ = INKEY$: LOOP UNTIL a$ = ""

END SUB

' Initializes the sound card.  Written by Brett Levin.
SUB SBInit

FOR q% = 1 TO &HF5
   WriteReg q%, 0
NEXT q%

END SUB

SUB SetColours (first, last)

OUT &H3C8, first
FOR i = first TO last
   OUT &H3C9, pal(i).r
   OUT &H3C9, pal(i).g
   OUT &H3C9, pal(i).B
NEXT i

END SUB

' Sets the type of sound to be played.  This routine was written by me,
' derived from code by Brett Levin.
SUB SetFX (chan%, curFX%())

IF chan% > 5 THEN chan% = chan% + 5
IF chan% > 2 THEN chan% = chan% + 5

WriteReg &H20 + chan%, curFX%(1)  ' Set modulator's multiple
WriteReg &H40 + chan%, curFX%(3)  ' Set modulator's level
WriteReg &H60 + chan%, curFX%(5)  ' Modulator attack
WriteReg &H80 + chan%, curFX%(7)  ' Modulator sustain
WriteReg &HE0 + chan%, curFX%(9)
WriteReg &HC0 + chan%, curFX%(11)
                 
WriteReg &H23 + chan%, curFX%(2)  ' Set carrier's multiple
WriteReg &H43 + chan%, curFX%(4)  ' Set carrier's level
WriteReg &H63 + chan%, curFX%(6)  ' Carrier attack
WriteReg &H83 + chan%, curFX%(8)  ' Carrier sustain
WriteReg &HE3 + chan%, curFX%(10)
WriteReg &HC0 + chan%, curFX%(12)

END SUB

' Written by Steven Sensarn.
SUB SetVect (s, o, i)

    'SETVECT CHANGES THE ADDRESSES IN THE INTERRUPT VECTOR TABLE
    'TO POINT TO NEW FUNCTIONS

    STATIC ASM AS STRING 'HOLDS THE SETVECT FUNCTION
    STATIC INI AS INTEGER 'USED TO TEST WHETHER OR NOT FUNCTION HAS PREVOUSLY
                          'BEEN CALLED
    IF INI = 0 THEN

        'CREATE FUNCTION IF NOT ALREADY CREATED

        ASM = ""
        ASM = ASM + CHR$(&H55)                          'PUSH BP
        ASM = ASM + CHR$(&H89) + CHR$(&HE5)             'MOV BP,SP
        ASM = ASM + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8) 'MOV BX,[BP+08]
        ASM = ASM + CHR$(&H8B) + CHR$(&H17)             'MOV DX,[BX]
        ASM = ASM + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H6) 'MOV BX,[BP+06]
        ASM = ASM + CHR$(&H8A) + CHR$(&H7)              'MOV AL,[BX]
        ASM = ASM + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HA) 'MOV BX,[BP+0A]
        ASM = ASM + CHR$(&H1E)                          'PUSH DS
        ASM = ASM + CHR$(&H8E) + CHR$(&H1F)             'MOV DS,[BX]
        ASM = ASM + CHR$(&HB4) + CHR$(&H25)             'MOV AH,25
        ASM = ASM + CHR$(&HCD) + CHR$(&H21)             'INT 21
        ASM = ASM + CHR$(&H1F)                          'POP DS
        ASM = ASM + CHR$(&H5D)                          'POP BP
        ASM = ASM + CHR$(&HCA) + CHR$(&H6) + CHR$(&H0)  'RETF 0006
        INI = 1 'FLAG CREATION
    END IF
    DEF SEG = VARSEG(ASM)
    CALL ABSOLUTE(s, o, i, SADD(ASM)) 'RUN SETVECT

END SUB

' Plays a sound effects.  Written by me, derived from code by Brett Levin.
SUB SFXPlay (chan%, freq%, vol%)

channel% = chan%
IF channel% > 5 THEN channel% = channel% + 5
IF channel% > 2 THEN channel% = channel% + 5

WriteReg &H43 + channel%, vol%

WriteReg &HA0 + chan%, freq%

WriteReg &HB0 + chan%, &H26

WriteReg &HE0 + chan%, &H0

END SUB

' Writes a byte to an SB register.  Written by Brett Levin.
SUB WriteReg (reg%, value%)

OUT &H388, reg%     '388h = address/status port, 389h = dataport

FOR x = 0 TO 5     ' This tells the SB what register we want to write to
   a = INP(&H388)  ' After we write to the address port we must wait 3.3ms
NEXT x

OUT &H389, value%   ' Send the value for the register to 389h

FOR x = 0 TO 34    ' Here we must also wait, this time 23ms
   a = INP(&H388)
NEXT x

END SUB

