uses crt,dos,graph,drivers;

const nox=10;
      noy=8;
      card_pattern=9;
      card_color=green;
      card_border=red;
      mouseint=$33;

type
s20=string[20];
card=record
exposed:boolean;
pic:byte;
end;
mouse_info=record
mx,my,but:integer;
lc,rc:byte;
end;
graph_info=record
soff:longint;
sseg:longint;
gpos:longint;
lpos:longint;
memtot:longint;
memleft:longint;
end;
picture=record
start:longint;
x,y:byte;
end;
selected=record
x,y:byte;
pic:byte;
end;
winner_information=record
name:string[30];
sc:integer;
end;
time_record=record
o_hr,o_min,o_sec,o_sec100:word;
hr,min,sec,sec100:word;
a_sec,a_min:word;
end;

var b:array[1..nox,1..noy] of card;
    mouse:mouse_info;
    gi:graph_info;
    tester:pointer;
    zero,one,two,three,four,five,six,seven,eight,nine,colon:picture;
    back:picture;
    s:array[1..4] of selected;
    os:byte;
    turns:integer;
    off,ok,exit,exit2,go_clean:boolean;
    pics:array[1..20] of picture;
    opened:byte;
    score,exit_b,score_b,chunk:picture;
    bgidirec:string;
    mb:array[1..62000] of byte;
    wins:array[1..10] of winner_information;
    time:time_record;

procedure fatal(fcall:string);
begin
textmode(CO80);
clrscr;
writeln('A fatal error has occured');
writeln('Error: ',fcall);
writeln;
write('Hit enter to halt program--');
readln;
halt;
end;

procedure showmouse;
begin
 asm
 mov ax, 1;
 int mouseint;
 end;
end;

procedure hidemouse;
begin
asm
mov ax, 2;
int mouseint;
end;
end;

procedure getmouse;
var x,y:integer;
begin
asm
mov ax, 3;
int mouseint
mov mouse.mx, cx
mov mouse.my, dx
mov mouse.but, bx
end;
mouse.mx:=mouse.mx div 2;
end;

procedure move_mouse(x,y:integer);
begin
asm
shl x,1
mov ax, 4
mov cx, x
mov dx, y
int mouseint
end;
end;

procedure ginit640x480x16(direc:string);
var grd,grmode,errcode:integer;
begin
closegraph;
grd:=9;
grmode:=2;
initgraph(grd,grmode,direc);
ErrCode := GraphResult;
if ErrCode <> grOk then fatal('PROC[GINIT640X480X16]- CANNOT INITIALIZE 640x480x16 GRAPHICS MODE');
setgraphmode(2);
end;

procedure clean_board;
var x,y:byte;
begin
y:=1;
repeat
x:=1;
repeat
b[x,y].pic:=0;
b[x,y].exposed:=false;
inc(x);
until x>nox;
inc(y);
until y>noy
end;

procedure init_pictures;
begin
gi.memtot:=62500;
gi.memleft:=62500;
gi.gpos:=1;
gi.lpos:=62500;
end;

procedure load_drw(filen:string; Var tp:picture);
var t,temp:text;
    ver,line:s20;
    x,y,num:byte;
    ch,ch1,ch2:char;
    s:string;
    error,c:integer;
begin
assign(t,filen);
{$i-}
reset(t);
{$i+}
if ioresult<>0 then fatal('Load_drw: Cannot locate drw file: '+filen);
readln(t,ver);
delete(ver,1,pos(':',ver));
if filen<>'temp.$$$' then
begin
cleardevice;
setcolor(green);
outtextxy(0,0,'Decompressing and loading images, please wait...['+filen+']');
end;

if ver='1.1' then
begin
readln(t,x);
readln(t,y);
tp.start:=gi.gpos;
{load x,y coords in stack}
tp.x:=x;
tp.y:=y;
mb[gi.gpos]:=x;
inc(gi.gpos);
mb[gi.gpos]:=y;
inc(gi.gpos);
{end load x,y}
{load colors}
repeat
readln(t,c);
mb[gi.gpos]:=c;
inc(gi.gpos);
dec(gi.memleft);
until eof(t);
close(t);
if filen='temp.$$$' then erase(t);
{end load colors}
end;

if ver='1.2' then
begin
readln(t,x);
readln(t,y);
tp.start:=gi.gpos;
{load x,y coords in stack}
tp.x:=x;
tp.y:=y;
mb[gi.gpos]:=x;
inc(gi.gpos);
mb[gi.gpos]:=y;
inc(gi.gpos);
dec(gi.memleft,2);
{end load x,y}
{load colors}
repeat
read(t,ch);
if ch<>'' then
begin
mb[gi.gpos]:=ord(ch);
inc(gi.gpos);
dec(gi.memleft);
end;
until eof(t);
close(t);
{end load colors}
end;

if ver='1.3' then
begin
tp.start:=gi.gpos;
readln(t,x);
readln(t,y);
tp.x:=x;
tp.y:=y;

mb[gi.gpos]:=x;
inc(gi.gpos);
mb[gi.gpos]:=y;
inc(gi.gpos);

repeat
read(t,ch1);
read(t,ch2);
if ch<>'' then
begin
end;
num:=ord(ch2);

c:=1;
repeat
mb[gi.gpos]:=ord(ch1);
inc(gi.gpos);
inc(c);
until c>num;

until eof(t);
close(t);
end;

end;

procedure showpic(xp,yp:integer; Var tp:picture);
var x,y,x1,y1:byte;
    tx:integer;
begin
x:=mb[tp.start];
y:=mb[tp.start+1];
y1:=1;
tx:=3;
repeat
x1:=1;
repeat
putpixel(xp+(x1-1),yp+(y1-1),mb[tp.start+(tx-1)]);
inc(x1);
inc(tx);
until x1>x;
inc(y1);
until y1>y;
end;

procedure update_secs;
var num:string;
    plc:byte;
begin
with time do
begin
str(a_sec,num);
if length(num)=1 then insert('0',num,0);
plc:=1; {440}
showpic(605,453,colon);
repeat                                    {450}
if num[plc]='0' then showpic(((plc-1)*11)+615,453,zero);
if num[plc]='1' then showpic(((plc-1)*11)+615,453,one);
if num[plc]='2' then showpic(((plc-1)*11)+615,453,two);
if num[plc]='3' then showpic(((plc-1)*11)+615,453,three);
if num[plc]='4' then showpic(((plc-1)*11)+615,453,four);
if num[plc]='5' then showpic(((plc-1)*11)+615,453,five);
if num[plc]='6' then showpic(((plc-1)*11)+615,453,six);
if num[plc]='7' then showpic(((plc-1)*11)+615,453,seven);
if num[plc]='8' then showpic(((plc-1)*11)+615,453,eight);
if num[plc]='9' then showpic(((plc-1)*11)+615,453,nine);
inc(plc);
until plc>length(num);

end;
end;

procedure update_mins;
var num:string;
    plc:byte;
    nn:byte;
begin
with time do
begin
str(a_min,num);
if length(num)=1 then insert('0',num,0);
plc:=1;
nn:=length(num)*11;
repeat                                    {441}
if num[plc]='0' then showpic(((plc-1)*11)+606-nn,453,zero);
if num[plc]='1' then showpic(((plc-1)*11)+606-nn,453,one);
if num[plc]='2' then showpic(((plc-1)*11)+606-nn,453,two);
if num[plc]='3' then showpic(((plc-1)*11)+606-nn,453,three);
if num[plc]='4' then showpic(((plc-1)*11)+606-nn,453,four);
if num[plc]='5' then showpic(((plc-1)*11)+606-nn,453,five);
if num[plc]='6' then showpic(((plc-1)*11)+606-nn,453,six);
if num[plc]='7' then showpic(((plc-1)*11)+606-nn,453,seven);
if num[plc]='8' then showpic(((plc-1)*11)+606-nn,453,eight);
if num[plc]='9' then showpic(((plc-1)*11)+606-nn,453,nine);
inc(plc);
until plc>length(num);

end;
end;

procedure get_original_time;
begin
with time do
begin
a_sec:=0;
a_min:=0;
gettime(o_hr,o_min,o_sec,o_sec100);
gettime(hr,min,sec,sec100);
end;
end;

procedure update_time;
begin
with time do
begin
gettime(hr,min,sec,sec100);

if sec<>o_sec then
begin
inc(a_sec);
if a_sec<=60 then update_secs;
end;
if a_sec>60 then
begin
a_sec:=0;
inc(a_min);
update_mins;
update_secs;
end;

o_hr:=hr;
o_min:=min;
o_sec:=sec;
o_sec100:=sec;
end;
end;


procedure showturn(x,y:integer);
var num:string;
    plc:byte;
begin
hidemouse;
str(turns,num);
plc:=1;
if (x=0) and (y=0) then
begin
repeat
if num[plc]='0' then showpic(((plc-1)*11)+4,453,zero);
if num[plc]='1' then showpic(((plc-1)*11)+4,453,one);
if num[plc]='2' then showpic(((plc-1)*11)+4,453,two);
if num[plc]='3' then showpic(((plc-1)*11)+4,453,three);
if num[plc]='4' then showpic(((plc-1)*11)+4,453,four);
if num[plc]='5' then showpic(((plc-1)*11)+4,453,five);
if num[plc]='6' then showpic(((plc-1)*11)+4,453,six);
if num[plc]='7' then showpic(((plc-1)*11)+4,453,seven);
if num[plc]='8' then showpic(((plc-1)*11)+4,453,eight);
if num[plc]='9' then showpic(((plc-1)*11)+4,453,nine);
inc(plc);
until plc>length(num);
end;
if (x<>0) or (y<>0) then
begin
repeat
if num[plc]='0' then showpic(((plc-1)*11)+x,y,zero);
if num[plc]='1' then showpic(((plc-1)*11)+x,y,one);
if num[plc]='2' then showpic(((plc-1)*11)+x,y,two);
if num[plc]='3' then showpic(((plc-1)*11)+x,y,three);
if num[plc]='4' then showpic(((plc-1)*11)+x,y,four);
if num[plc]='5' then showpic(((plc-1)*11)+x,y,five);
if num[plc]='6' then showpic(((plc-1)*11)+x,y,six);
if num[plc]='7' then showpic(((plc-1)*11)+x,y,seven);
if num[plc]='8' then showpic(((plc-1)*11)+x,y,eight);
if num[plc]='9' then showpic(((plc-1)*11)+x,y,nine);
inc(plc);
until plc>length(num);
end;
showmouse;
end;

procedure makecard(x,y:byte);
var xp,yp:integer;
    sx,sy:string[3];
begin
hidemouse;
xp:=((x-1)*63);
yp:=((y-1)*56);
setcolor(card_border);
setfillstyle(1,0);
bar(xp+1,yp+1,xp+62,yp+55);
rectangle(xp,yp,xp+63,yp+56);
if b[x,y].exposed=false then
begin
showpic(xp+1,yp+1,back);
end;
showmouse;
if b[x,y].exposed=true then
begin
hidemouse;
showpic(xp+7,yp+4,pics[b[x,y].pic]);
showmouse;
end;
end;

function used(pic:byte):byte;
var cx,cy,u:byte;
begin
used:=0;
u:=0;
cy:=1;
repeat
cx:=1;
repeat
if b[cx,cy].pic=pic then inc(u);
inc(cx);
until cx>nox;
inc(cy);
until cy>noy;
used:=u;
end;

procedure set_board;
var cx,cy,pic:byte;
begin
setcolor(0);
outtextxy(0,470,(#219+#219+#219+#219+#219+#219+#219+#219+#219+#219+#219+#219+#219+#219+#219+#219+#219+#219+#219+#219+
+#219+#219+#219+#219+#219+#219+#219+#219+#219));
setcolor(green);
outtextxy(0,470,'Dealing board, please wait...');

randomize;
cy:=1;
repeat
cx:=1;
repeat
repeat
pic:=random(20)+1;
until used(pic)<4;
b[cx,cy].pic:=pic;
makecard(cx,cy);
inc(cx);
until cx>nox;
inc(cy);
until cy>noy;
setcolor(0);
outtextxy(0,470,(#219+#219+#219+#219+#219+#219+#219+#219+#219+#219+#219+#219+#219+#219+#219+#219+#219+#219+#219+#219+
+#219+#219+#219+#219+#219+#219+#219+#219+#219));
end;

procedure fire_works;

const
nof=30;

type
fires=record
x,y:integer;
direct:byte;
speed:integer;
explode:boolean;
color:byte;
oex:byte;
end;

var fire:array[1..nof] of fires;

procedure clean_fires;
var c:integer;
begin
c:=1;
repeat
fire[c].direct:=random(2)+1;
fire[c].color:=random(15)+1;
fire[c].x:=random(639);
fire[c].y:=479;
fire[c].explode:=false;
fire[c].speed:=random(20)+15;
fire[c].oex:=1;
inc(c);
until c>nof;
end;

procedure inact;
var c:integer;
begin

c:=1;
repeat

if fire[c].explode=false then
begin
setcolor(fire[c].color);
circle(fire[c].x,fire[c].y,1);
end;

if (fire[c].explode=true) and (fire[c].oex<10) then
begin
setcolor(fire[c].color);
circle(fire[c].x,fire[c].y,fire[c].oex);
setcolor(random(15)+1);
circle(fire[c].x,fire[c].y,fire[c].oex-1);
end;

inc(c);
until c>nof;

delay(75);
gotoxy(1,1);

c:=1;
repeat
setcolor(0);
circle(fire[c].x,fire[c].y,1);

if (fire[c].explode=true) and (fire[c].oex<10) then
begin
circle(fire[c].x,fire[c].y,fire[c].oex);
circle(fire[c].x,fire[c].y,fire[c].oex-1);
inc(fire[c].oex);
end;

if fire[c].explode=false then
begin
dec(fire[c].speed,1);
dec(fire[c].y,fire[c].speed);
if fire[c].direct=1 then inc(fire[c].x,2);
if fire[c].direct=2 then dec(fire[c].x,2);
if fire[c].speed<=-1*random(11) then fire[c].explode:=true;
end;

inc(c);
until c>nof;
c:=1;
end;

function exploded:boolean;
var c:integer;
    m:boolean;
begin
c:=1;
m:=true;
repeat
if fire[c].oex<6 then m:=false;
inc(c);
until (c>nof);
exploded:=m;
end;

begin
cleardevice;
randomize;
repeat
clean_fires;
repeat
inact;
until (exploded=true) or (keypressed);
until keypressed;

end;

procedure win;
var w:text;
    n,m,s:string;
    c,c2:byte;
    stop:boolean;
begin
hidemouse;
fire_works;
cleardevice;
str(time.a_min,m);
str(time.a_sec,s);
stop:=false;
c:=1;
repeat
if turns<=wins[c].sc then
begin
c2:=0;
repeat
wins[10-c2]:=wins[9-c2];
inc(c2);
until (10-c2)=c;
stop:=true;
end;
inc(c);
until (stop=true) or (turns>wins[10].sc);
dec(c);
if turns<=wins[10].sc then
begin
ok:=true;
assign(w,'winners.txt');
rewrite(w);
closegraph;
textmode(co80+font8x8);
clrscr;
repeat
write('Enter your name: ');
readln(n);
writeln;
if length(n)>15 then writeln('Name can not be longer than 15 characters');
writeln;
until length(n)<=15;
n:=n+' ['+m+':'+s+']';
wins[c].name:=n;
wins[c].sc:=turns;
c:=1;
end;
repeat
str(wins[c].sc,n);
writeln(w,'n: '+wins[c].name);
writeln(w,'s: '+n);
inc(c);
until c>10;
close(w);
ginit640x480x16(bgidirec);
off:=false;
clean_board;
set_board;
turns:=0;
showpic(0,450,score);
showpic(80,450,score_b);
showpic(150,450,exit_b);
showpic(569,450,score);
showturn(0,0);
exit:=false;
exit2:=false;
get_original_time;
update_secs;
update_mins;
move_mouse(0,0);
showmouse;
end;

procedure show_scores;
var x,y,c:byte;
begin
hidemouse;

y:=1;
repeat
x:=1;
showpic(x+135,(y-1)*21,score);
showpic(x,(y-1)*21,score);
showpic(x+204,(y-1)*21,score);
repeat
showpic(((x-1)*10)+3,(y-1)*21,chunk);
inc(x);
until x>20;
inc(y);
until y>10;

c:=1;
repeat
if wins[c].name<>'' then
begin
setcolor(white);
outtextxy(4,7+((c-1)*21),wins[c].name);
turns:=wins[c].sc;
showturn(211,3+((c-1)*21));
end;
inc(c);
until c>10;
turns:=0;
gotoxy(1,1);
readln;

off:=false;
clean_board;
set_board;
turns:=0;
showpic(0,450,score);
showpic(80,450,score_b);
showpic(150,450,exit_b);
showpic(569,450,score);
showturn(0,0);
exit:=false;
exit2:=false;
get_original_time;
update_secs;
update_mins;
move_mouse(0,0);
showmouse;
end;

procedure interpret;
var mpx,mpy:byte;
    sx,sy:string;
begin
getmouse;

if mouse.but=0 then off:=false;

if (mouse.but=1) and (off=false) then
begin
off:=true;
mpx:=mouse.mx*2 div 63;
mpy:=(mouse.my) div 56;

if (mouse.mx*2>=80) and (mouse.mx*2<=129) and (mouse.my>=450) and (mouse.my<=466) and (ok=true) then show_scores;
if (mouse.mx*2>=150) and (mouse.mx*2<=199) and (mouse.my>=450) and (mouse.my<=466) then
begin
exit:=true;
exit2:=true;
end;

inc(mpx);
inc(mpy);
if (b[mpx,mpy].exposed=false) and (mpx>=1) and (mpy>=1) and (mpx<=10) and (mpy<=8) then
begin
setfillstyle(1,0);
bar(80,450,130,466);
ok:=false;
b[mpx,mpy].exposed:=true;
makecard(mpx,mpy);
inc(os);
s[os].x:=mpx;
s[os].y:=mpy;
s[os].pic:=b[mpx,mpy].pic;
end;
end;

if os=4 then
begin
inc(turns);
showturn(0,0);
os:=0;
delay(700);
inc(opened);
if not((s[1].pic=s[2].pic) and (s[1].pic=s[3].pic) and (s[1].pic=s[4].pic)) then
begin
dec(opened);
b[s[1].x,s[1].y].exposed:=false;
b[s[2].x,s[2].y].exposed:=false;
b[s[3].x,s[3].y].exposed:=false;
b[s[4].x,s[4].y].exposed:=false;
makecard(s[1].x,s[1].y);
makecard(s[2].x,s[2].y);
makecard(s[3].x,s[3].y);
makecard(s[4].x,s[4].y);
end;
if opened=20 then win;
end;

if ok=false then
begin
update_time;
{show_time;}
end;

end;

procedure load_pics;
var c:byte;
    s:string;
begin
load_drw('n0.drw',zero);
load_drw('n1.drw',one);
load_drw('n2.drw',two);
load_drw('n3.drw',three);
load_drw('n4.drw',four);
load_drw('n5.drw',five);
load_drw('n6.drw',six);
load_drw('n7.drw',seven);
load_drw('n8.drw',eight);
load_drw('n9.drw',nine);
load_drw('nc.drw',colon);
load_drw('back.drw',back);
load_drw('score.drw',score);
load_drw('exit_b.drw',exit_b);
load_drw('scores_b.drw',score_b);
load_drw('chunk.drw',chunk);
c:=1;
repeat
str(c,s);
load_drw('p'+s+'.drw',pics[c]);
inc(c);
until c>20;
end;

procedure load_winners;
var w:text;
    c:byte;
    s,s2:string;
    nn,error:integer;
begin
c:=1;
repeat
wins[c].name:='';
wins[c].sc:=maxint;
inc(c);
until c>10;
assign(w,'winners.txt');
{$i-}
reset(w);
{$i+}
if ioresult<>0 then rewrite(w);
c:=1;
repeat
readln(w,s);

if s<>'' then
begin
readln(w,s2);
if s2<>'' then
begin
if s[1]<>'n' then rewrite(w);
if s2[1]<>'s' then rewrite(w);
if (s[1]='n') and (s2[1]='s') then
begin
delete(s,1,3);
delete(s2,1,3);
wins[c].name:=s;
val(s2,wins[c].sc,error);
if error<>0 then rewrite(w);
if error=0 then inc(c);
end;
end;
end;

until eof(w);
close(w);
end;

procedure clean;
begin
closegraph;
go_clean:=false;
bgidirec:='';
ginit640x480x16(bgidirec);
setcolor(card_border);
init_pictures;
load_pics;
load_winners;
ok:=true;
opened:=0;
os:=0;
s[1].x:=0;
s[2].x:=0;
s[3].x:=0;
off:=false;
clean_board;
set_board;
turns:=0;
showpic(0,450,score);
showpic(80,450,score_b);
showpic(150,450,exit_b);
showpic(569,450,score);
showturn(0,0);
exit:=false;
exit2:=false;
move_mouse(0,0);
get_original_time;
update_secs;
update_mins;
showmouse;
end;

begin
clean;
repeat
interpret;
until exit=true;
closegraph;
textmode(co80);
clrscr;
writeln('Thanks for playing Quadruple Memory');
writeln('Feel free to distribute this software.');
writeln;
writeln('Programmed by: Justin Pierce');
writeln('Graphics by: Whitney Pierce');
writeln('Inspired by: Jos Dickman''s triple memory!');
writeln;
writeln('If any pascal programmers want to see the source code of this program');
writeln('or want to know how I did a particular section please feel free to E-mail');
writeln('me at victor@intrex.net .');
end.
