unit key;
interface
uses dos;
const
  scEscape = $01;
  scLeft = $4B;
  scDown = $50;
  scUp = $48;
  scRight = $4D;
var
  pressed : array [0..127] of boolean;
  lastpressed : byte;
  lastreleased : byte;
  saveint09 : pointer;
procedure int09handler;
procedure install_handler;
procedure restore_handler;
implementation
procedure int09handler;assembler;
asm
  push ax
  push dx
  push si
  push ds
  mov ax,seg @data
  mov ds,ax
  in al,60h
  mov dl,al
  mov al,20h
  out 20h,al
  cmp dl,0E0h
  je @@finish
  xor dh,dh
  mov si,dx
  and si,007Fh
  test dl,80h
  jnz @@released
    mov [lastpressed],dl
    mov al,true
  jmp @@savestate
  @@released:
    and dl,7Fh
    mov [lastreleased],dl
    mov al,false
  @@savestate:
  mov ds:byte ptr [pressed+si],al
  @@finish:
  pop ds
  pop si
  pop dx
  pop ax
  iret
end;

procedure install_handler;
Begin
  FillChar(Pressed,SizeOf(Pressed),False);
  GetIntVec(9,SaveInt09);
  SetIntVec(9,@int09handler);
End;
{asm
  xor ax,ax
  mov di,offset pressed
  mov cx,(128+1+1)/2
  cld
  segds rep stosw
  cli
  mov es,ax
  mov ax,es:[09h*4]
  mov bx,es:[09h*4+2]
  mov word ptr [saveint09],ax
  mov word ptr [saveint09+2],bx
  mov es:word ptr [09h*4],offset int09handler
  mov es:word ptr [09h*4+2],cs
  sti
end;}

procedure restore_handler;
Begin
  SetIntVec(9,SaveInt09);
End;
{
asm
  cli
  xor ax,ax
  mov es,ax
  mov ax,word ptr [saveint09]
  mov bx,word ptr [saveint09+2]
  mov es:[09h*4],ax
  mov es:[09h*4+2],bx
  sti
end;}
end.