{$A+,B-,D+,E+,F-,G+,I+,L+,N+,P-,Q-,R-,S+,T-,V+,X+,Y+}
{$M 16384,0}
Uses WinApi,Dos,Crt,Vesa,Vesa257,Key;

Type REAL=DOUBLE;
     TTime = record
       Time,Min,Sec,Mil : LongInt;
     End;

Const QX : Array[0..35] of real=
      (0,-1,-1,-2,-2,-3,-4,-4,-5,-5,-5,-4,-4,-3,-2,-2,-1,-1, 0, 1,
       1, 2, 2, 3, 4, 4, 5,5,5,4,4,3,2,2,1,1);
      QY : Array[0..35] of real=
      (5, 4, 4, 4, 3, 3, 2, 1, 1, 0,-1,-1,-2,-2,-3,-4,-4,-5,-5,-5,
      -4,-4,-3,-2,-2,-1,-1,0,1,1,2,3,3,4,4,4);
      LR_SENSIVITY = 2;
      SP_SENSIVITY = 1;
      BreakSpeedDown = 10;
      MINSP = 50;
      GRAVSP = 3;
      GOODANGLE = 7;
      GOODSPEED = 50;
      ZANDEC = 0.3;
      ZANKOEF = 1.4;
      PENTIME = 100;
      NumOfSpeeds = 200;
      BackSpeeds = -30;
      NAI = 4;
      SpeedDec = 20;
      SpDec = 5;
      SpDiv = 2;
      OBGON = 3;
      CAISp : Array[1..NAI] of LongInt = (110,130,150,170);
      CAISt : Array[1..NAI] of LongInt = (1,1,2,2);
      CAIMS : Array[1..NAI] of LongInt = (140,160,180,200);
      NumComp = 4;
      Colors : Array[1..NumComp] of Byte = (9,10,11,13);
      CSp : Array[1..NumComp] of LongInt = (0,0,0,0);
      CAI : Array[1..NumComp] of Byte = (4,3,3,4);

Var S1,M1 : Word;
F : File;
Pal,Pal2 : TPalette;
H,W : Word;
S : String;
ErCd : Integer;
A,B : LongInt;
C : Byte;
Frames : Array[0..35] of record s,m : word; end;
Fields : Array[0..20] of record s,m : word; end;
OldN,N,Posi : ShortInt;
X,Y,X1,Y1,X2,Y2,X3,Y3 : Real;
Speed : LongInt;
Sensiv : Array[1..4] of LongInt;
G : Byte;
Tim_s : Word;
Tim : Byte; { flag time (0=timer off(0sec)),1=timer on,2=timer off(finish)
                         3=waiting car(on) ) }
Time,AllT : LongInt;
All,Cur,Last,Best,Pen : TTime;
Replay,Match : Boolean;
ReplN : Byte;
Laps : Array[0..NumComp] of LongInt;
Fin : Array[1..NumComp] of Boolean;
CurPlace : Byte;
Trk : Array[0..50,0..50] of Char;
PT : Array[0..50,0..50] of LongInt;
TrX,TrY : LongInt;
LastLeft,LastRight : Byte;
FirstPX,FirstPY,LastPX,LastPY : Real;
Zan : Boolean;
SPCount : LongInt;
FinD : Byte;
PenT : LongInt;
PenG : Boolean;
TrkR,TrkLast,TrkBeg : LongInt;
CLX,CLY,CX,CY : Array[1..NumComp] of Real;
CPos,CD : Array[1..NumComp] of Byte;
CL : Array[1..NumComp] of Char;
CCh,CSPC,CTrkR,CTX,CTY,CTrkBeg : Array[1..NumComp] of LongInt;

Function GetTrans(x,y,w,h,from,where:word):Byte;far;external;
{ (set)bit 0=(slow/grass),bit 1=(wall),bit 2=(start/finish) }
Procedure ShowTransl(x,y,w,h,from,where:word;Color:Byte);far;external;
Procedure ShTransC(x,y,w,h,x1,y1,x2,y2,from,where:word;color:byte);far;external;
Procedure ShClip(x,y,w,h,x1,y1,x2,y2,from,where:word);far;external;
{$L rally}

procedure VRT; assembler;
asm
  mov dx,3DAh
@VRT1:
  in al,dx
  test al,8
  jnz @VRT1
@VRT2:
  in al,dx
  test al,8
  jz @VRT2
end;

Procedure ShowTransC(x,y:integer;w,h,from,where:word;Color:Byte);
Var A,B,C,D : Word;
Begin
  If (X>=0) and (Y>=0) and (X<641-W) and (Y<481-H) then
    ShowTransl(X,Y,W,H,From,Where,Color) else
    Begin
      If (X<=-W) or (X>=640) or (Y<=-H) or (Y>=480) then Exit;
      A:=0;B:=0;C:=W-1;D:=H-1;
      If X<0 then Begin A:=-X;X:=0; End;
      If Y<0 then Begin B:=-Y;Y:=0; End;
      If X>640-W then C:=639-X;
      If Y>480-H then D:=479-Y;
      ShTransC(X,Y,W,H,A,B,C,D,from,where,color);
    End;
End;

Procedure ShowClip(X,Y:integer;W,H,from,where:word);
Var A,B,C,D : Word;
Begin
  If (X>=0) and (Y>=0) and (X<641-W) and (Y<481-H) then
    ShowImage(X,Y,W,H,From,Where) else
    Begin
      If (X<=-W) or (X>=640) or (Y<=-H) or (Y>=480) then Exit;
      A:=0;B:=0;C:=W-1;D:=H-1;
      If X<0 then Begin A:=-X;X:=0; End;
      If Y<0 then Begin B:=-Y;Y:=0; End;
      If X>640-W then C:=639-X;
      If Y>480-H then D:=479-Y;
      ShClip(X,Y,W,H,A,B,C,D,from,where);
    End;
End;

Procedure ShowImageBig(X,Y,Sel:word);
Var A,B : LongInt;
XX,YY : LongInt;
Begin
  XX:=X mod 160;YY:=Y mod 160;
  X:=X div 160;Y:=Y div 160;
  For A:=1 to 3 do
    For B:=1 to 2 do
      ShowImage(A*160-XX,B*160-YY,160,160,Fields[Ord(Trk[A+X+1,Y+B+1])-Ord('a')].S,Sel);
  For A:=0 to 4 do
  Begin
    ShowClip(A*160-XX,-YY,160,160,Fields[Ord(Trk[A+X+1,Y+1])-Ord('a')].S,Sel);
    ShowClip(A*160-XX,480-YY,160,160,Fields[Ord(Trk[A+X+1,Y+3+1])-Ord('a')].S,Sel);
  End;
  For B:=1 to 2 do
  Begin
    ShowClip(-XX,B*160-YY,160,160,Fields[Ord(Trk[X+1,Y+B+1])-Ord('a')].S,Sel);
    ShowClip(640-XX,B*160-YY,160,160,Fields[Ord(Trk[4+X+1,Y+B+1])-Ord('a')].S,Sel);
  End;
End;

Procedure ConvertTime(Var T : TTime);
Begin
  T.Sec:=Trunc(T.Time/18.2);
  T.Mil:=Trunc(Frac(T.Time/18.2)*10);
  T.Min:=T.Sec div 60;
  T.Sec:=T.Sec mod 60;
End;

Function MakeTimeB(T : TTime) : String;
Var S,S1 : String;
Begin
  Str(T.Min,S);
  If Length(S)=1 then S:='0'+S;
  Str(T.Sec,S1);
  If Length(S1)=1 then S1:='0'+S1;
  S:=S+':'+S1;
  Str(T.Mil,S1);
  S:=S+'.'+S1;
  MakeTimeB:=S;
End;

Function MakeTime(Var T : TTime) : String;
Var S,S1 : String;
Begin
  If T.Min>0 then
    MakeTime:='59.9' else
    Begin
      Str(T.Sec,S);
      If Length(S)=1 then S:='0'+S;
      Str(T.Mil,S1);
      S:=S+'.'+S1;
      MakeTime:=S;
    End;
End;

Procedure Start; { Start/Finish }
Var A : LongInt;
Begin
  If ((FinD=1) and (X>=X2)) or ((FinD=2) and (X<=X2)) or ((FinD=3) and
  (Y<=Y2)) or ((FinD=4) and (Y>=Y2)) then
  Begin
    If Tim=1 then { Timer is on already, it's FINISH!!! }
    Begin
      Dec(Laps[0]);
      Time:=MemL[Tim_s:0]-Time;
      Tim:=3;
{      If Replay then Tim:=2 else Tim:=3;}
      Time:=MemL[Tim_s:0];
      If Cur.Time<Best.Time then Best:=Cur;
      Last:=Cur;
{      CurPlace:=1;
      For A:=1 to NumComp do
        If Laps[A]<=Laps[0] then
        Begin
          Inc(CurPlace);
          Fin[A]:=True;
        End else Fin[A]:=False;}
    End else
    If Tim=0 then
    Begin { Timer is off, it's start }
      Tim:=3; { Now timer is on, but waiting for go throw start/finish line }
      Time:=MemL[Tim_s:0]; { Start timer }
    End;
  End else
  Begin
    If (Tim=1) or (Tim=3) then
      Tim:=0;
  End;
End;

Procedure PrintTime;
Var S,T : String;
Timer : LongInt;
Begin
  All.Time:=MemL[Tim_s:0]-AllT;
  ConvertTime(All);
  If Tim=0 then Timer:=0 else
    If Tim=2 then Timer:=Time else Timer:=MemL[Tim_s:0]-Time;
  Cur.Time:=Timer;
  ConvertTime(Cur);
  Str(Speed,S);
  T:='Last:'+MakeTimeB(Last)+' Current:'+MakeTimeB(Cur)+' Best:'+
  MakeTimeB(Best)+' All:'+MakeTimeB(All)+' Speed:'+S+' km/h';
{  If Match then
  Begin
    Str(Laps[0],S);
    T:=T+' Laps left:'+S;
    Str(CurPlace,S);
    T:=T+' Place:'+S;
  End;}
  Print(0,2,15,T,1,2,sel_d);
  If PenG then
  Begin
    Dec(PenT);
    If PenT=0 then PenG:=False else
{    If PenT mod 50<25 then}
    Begin
      T:='PENALTY TIME : '+MakeTimeB(Pen);
      Print(140,234,11,T,2,2,sel_d);
    End;
  End;
End;

Procedure PrintStats;
Var S,T : String;
Begin
  T:='';
  Str(Speed,S);
  T:=T+'Speed:'+S+'km/h';
  Print(0,2,15,T,1,2,sel_d);
End;

Procedure CPU(N : Byte);
Var A,B,C,D,AX,AY,BX,BY,Was : LongInt;
F : Boolean;
Old : LongInt;

Function Srav(Var X1,Y1 : Real;P1 : Integer;Var S1 : LongInt;Var X2,Y2 : Real;P2 : Integer;Var S2 : LongInt) : Byte;
Var D1,D2 : Byte;
Begin
  Srav:=0;
  If (Abs(X1-X2)>55) or (Abs(Y1-Y2)>35) then Exit;
  If (P1<5) or (P1>30) then D1:=4 else
    If (P1>4) and (P1<14) then D1:=2 else
      If (P1>13) and (P1<23) then D1:=3 else D1:=1;
  If (P2<5) or (P2>30) then D2:=4 else
    If (P2>4) and (P2<14) then D2:=2 else
      If (P2>13) and (P2<23) then D2:=3 else D2:=1;
  If (X2>X1) and (D2=2) then
  Begin
    X1:=X1+(SpDec+S2/SpDiv)*QX[P2];
    Y1:=Y1+(SpDec+S2/SpDiv)*QY[P2];
    X2:=X2-S2*QX[P2]; Y2:=Y2-S2*QY[P2]; Dec(S2,SpeedDec);
  End;
  If (X2<X1) and (D2=1) then
  Begin
    X1:=X1+(SpDec+S2/SpDiv)*QX[P2];
    Y1:=Y1+(SpDec+S2/SpDiv)*QY[P2];
    X2:=X2-S2*QX[P2]; Y2:=Y2-S2*QY[P2]; Dec(S2,SpeedDec);
  End;
  If (X1<X2) and (D1=1) then
  Begin
    X2:=X2+(SpDec+S1/SpDiv)*QX[P1];
    Y2:=Y2+(SpDec+S1/SpDiv)*QY[P1];
    X1:=X1-S1*QX[P1]; Y1:=Y1-S1*QY[P1]; Dec(S1,SpeedDec);
    Srav:=1;
  End;
  If (X2<X1) and (D1=2) then
  Begin
    X2:=X2+(SpDec+S1/SpDiv)*QX[P1];
    Y2:=Y2+(SpDec+S1/SpDiv)*QY[P1];
    X1:=X1-S1*QX[P1]; Y1:=Y1-S1*QY[P1]; Dec(S1,SpeedDec);
    Srav:=1;
  End;
  If (Y2<Y1) and (D2=4) then
  Begin
    X1:=X1+(SpDec+S2/SpDiv)*QX[P2];
    Y1:=Y1+(SpDec+S2/SpDiv)*QY[P2];
    X2:=X2-S2*QX[P2]; Y2:=Y2-S2*QY[P2]; Dec(S2,SpeedDec);
  End;
  If (Y1<Y2) and (D2=3) then
  Begin
    X1:=X1+(SpDec+S2/SpDiv)*QX[P2];
    Y1:=Y1+(SpDec+S2/SpDiv)*QY[P2];
    X2:=X2-S2*QX[P2]; Y2:=Y2-S2*QY[P2]; Dec(S2,SpeedDec);
  End;
  If (Y1>Y2) and (D1=3) then
  Begin
    X2:=X2+(SpDec+S1/SpDiv)*QX[P1];
    Y2:=Y2+(SpDec+S1/SpDiv)*QY[P1];
    X1:=X1-S1*QX[P1]; Y1:=Y1-S1*QY[P1]; Dec(S1,SpeedDec);
    Srav:=1;
  End;
  If (Y2>Y1) and (D1=4) then
  Begin
    X2:=X2+(SpDec+S1/SpDiv)*QX[P1];
    Y2:=Y2+(SpDec+S1/SpDiv)*QY[P1];
    X1:=X1-S1*QX[P1]; Y1:=Y1-S1*QY[P1]; Dec(S1,SpeedDec);
    Srav:=1;
  End;
  If S1<0 then S1:=0;
  If S2<0 then S2:=0;
  If X1<-285 then X1:=-285;
  If Y1<-215 then Y1:=-215;
  If X1>TrX*160-640+285 then X1:=TrX*160-640+285;
  If Y1>TrY*160-480+215 then Y1:=TrY*160-480+215;
  If X2<-285 then X2:=-285;
  If Y2<-215 then Y2:=-215;
  If X2>TrX*160-640+285 then X2:=TrX*160-640+285;
  If Y2>TrY*160-480+215 then Y2:=TrY*160-480+215;
End;

Function Srav2(Var X1,Y1 : Real;P1 : Integer;Var X2,Y2 : Real;P2 : Integer) : Boolean;
Var D1,D2 : LongInt;
Begin
  Srav2:=False;
  If (Abs(X1-X2)>105) or (Abs(Y1-Y2)>85) then Exit;
  If (P1<5) or (P1>30) then D1:=4 else
    If (P1>4) and (P1<14) then D1:=2 else
      If (P1>13) and (P1<23) then D1:=3 else D1:=1;
  If (P2<5) or (P2>30) then D2:=4 else
    If (P2>4) and (P2<14) then D2:=2 else
      If (P2>13) and (P2<23) then D2:=3 else D2:=1;
  If ((X1<X2) and (Abs(Y1-Y2)<35) and (D=1)) or ((X1>X2) and (Abs(Y1-Y2)<35) and (D=2)) or
  ((Y1>Y2) and (Abs(X1-X2)<55) and (D=3)) or ((Y1<Y2) and (Abs(X1-X2)<55) and (D=4)) then Srav2:=True;
End;

Begin
  CX[N]:=CX[N]+CSp[N]*QX[CPos[N]];
  CY[N]:=CY[N]+CSp[N]*QY[CPos[N]];
  If CX[N]<-285 then CX[N]:=-285;
  If CY[N]<-215 then CY[N]:=-215;
  If CX[N]>TrX*160-640+285 then CX[N]:=TrX*160-640+285;
  If CY[N]>TrY*160-480+215 then CY[N]:=TrY*160-480+215;
  If CSp[N]>100 then
  Begin
    Inc(CSPC[N]);
    If CSPC[N]>=2+(CSp[N]-100) div 20 then
    Begin
      Inc(CSp[N]);
      CSPC[N]:=0;
    End;
  End else
    Inc(CSp[N]);
  If CSp[N]>CAIMS[CAI[N]] then Dec(CSp[N]);
  AX:=Trunc((CX[N]+305)/160)+1;
  AY:=Trunc((CY[N]+235)/160)+1;
  BX:=AX;BY:=AY;
  F:=False;
  For A:=1 to NumComp do
    If A<>N then
    Begin
      If Srav(CX[N],CY[N],CPos[N],CSp[N],CX[A],CY[A],CPos[A],CSp[A])=1 then F:=True;
      If Srav2(CX[N],CY[N],CPos[N],CX[A],CY[A],CPos[A]) then F:=True;
    End;
  If Srav(CX[N],CY[N],CPos[N],CSp[N],X,Y,Posi,Speed)=1 then F:=True;
  If Srav2(CX[N],CY[N],CPos[N],X,Y,Posi) then F:=True;
  If F then
  Begin
    If CCh[N]=0 then
      If Random(10)>4 then
        CCh[N]:=OBGON else
        CCh[N]:=-OBGON;
  End else CCh[N]:=0;
  F:=False;
  If (AX=CTX[N]) and (AY=CTY[N]) then CTrkBeg[N]:=PT[AX,AY];
  If ((CD[N]=1) and (AY=CTY[N]) and ((AX=CTX[N]) or (AX=CTX[N]-1))) or
     ((CD[N]=2) and (AY=CTY[N]) and ((AX=CTX[N]) or (AX=CTX[N]+1))) or
     ((CD[N]=3) and (AX=CTX[N]) and ((AY=CTY[N]) or (AY=CTY[N]+1))) or
     ((CD[N]=4) and (AX=CTX[N]) and ((AY=CTY[N]) or (AY=CTY[N]-1))) then
     else F:=True;
  If Not (Trk[AX,AY] in ['a','b','c','d','i','j','u','t','k']) or
     ((PT[AX,AY]<>CTrkBeg[N]) and (PT[AX,AY]-1<>CTrkBeg[N]) and (Trk[AX,AY]<>'k')) or
     ((Trk[AX,AY]='k') and F) then
  Begin
    If Trk[AX,AY]='l' then If CSp[N]>MINSP then Dec(CSp[N],GRAVSP) else else
      If Not (Trk[AX,AY] in ['a','b','c','d','i','j','u','t','k']) then
        CSp[N]:=30;
    A:=0;
    If AX<CTX[N] then A:=27;
    If AX>CTX[N] then A:=9;
    If AY<CTY[N] then
      If A=9 then A:=5 else
      If A=27 then A:=31 else A:=0;
    If AY>CTY[N] then
      If A=9 then A:=14 else
      If A=27 then A:=23 else A:=18;
    If A<18 then
      If (CPos[N]>A) and (CPos[N]<A+19) then Dec(CPos[N]) else
        If CPos[N]=35 then CPos[N]:=0 else Inc(CPos[N]);
    If A>=18 then
      If (CPos[N]<A) and (CPos[N]>A-19) then Inc(CPos[N]) else
        If CPos[N]=0 then CPos[N]:=35 else Dec(CPos[N]);
    Exit;
  End;
  F:=False;
  For A:=1 to CAISt[CAI[N]] do
  Begin
    If (((D=1) or (D=2)) and (Trk[BX,BY] in ['a','b','c','d'])) or
       (((D=3) or (D=4)) and (Trk[BX,BY] in ['a','b','c','d'])) then F:=True;
    If F then Break;
    If D=1 then Inc(BX);
    If D=2 then Dec(BX);
    If D=3 then Dec(BY);
    If D=4 then Inc(BY);
  End;
  If F and (CSp[N]>CAISp[CAI[N]]) then Dec(CSp[N],BreakSpeedDown);
  D:=CD[N];C:=CPos[N];
  If CL[N]<>Trk[AX,AY] then
  Begin
    Case CL[N] of
    'a': If D=3 then D:=1 else D:=4;
    'b': If D=1 then D:=4 else D:=2;
    'c': If D=4 then D:=2 else D:=3;
    'd': If D=2 then D:=3 else D:=1;
    End;
    CD[N]:=D;
    CL[N]:=Trk[AX,AY];
    CLX[N]:=CX[N];CLY[N]:=CY[N];
  End;
  CTrkBeg[N]:=PT[AX,AY];
  Case Trk[AX,AY] of
  'a':
    If D=3 then Begin CTX[N]:=AX+1; CTY[N]:=AY; End else
      Begin CTX[N]:=AX; CTY[N]:=AY+1; End;
  'b':
    If D=1 then Begin CTX[N]:=AX; CTY[N]:=AY+1; End else
      Begin CTX[N]:=AX-1; CTY[N]:=AY; End;
  'c':
    If D=4 then Begin CTX[N]:=AX-1; CTY[N]:=AY; End else
      Begin CTX[N]:=AX; CTY[N]:=AY-1; End;
  'd':
    If D=2 then Begin CTX[N]:=AX; CTY[N]:=AY-1; End else
      Begin CTX[N]:=AX+1; CTY[N]:=AY; End;
  'i','u','j','t','k':
    If D=1 then Begin CTX[N]:=AX+1; CTY[N]:=AY; End else
      If D=2 then Begin CTX[N]:=AX-1; CTY[N]:=AY; End else
        If D=3 then Begin CTX[N]:=AX; CTY[N]:=AY-1; End else
          Begin CTX[N]:=AX; CTY[N]:=AY+1; End;
  End;
  If CCh[N]>1 then
    If CPos[N]=0 then CPos[N]:=35 else Dec(CPos[N]) else
    If CCh[N]<-1 then If CPos[N]=35 then CPos[N]:=0 else Inc(CPos[N]);
  F:=False;
  If ((Trunc((CX[N]+305-60)/160)+1<>AX) and (Trk[AX,AY] in [{'a','d',}'j','t'])) then
  Begin
    F:=True;
    Was:=CPos[N];
    If (CPos[N]=19) and (D=3) then Was:=18 else
      If (CPos[N]=35) and (D=4) then Was:=0;
    If (CPos[N]=18) and (D=3) then CPos[N]:=19 else
      If (CPos[N]=0) and (D=4) then CPos[N]:=35;
  End;
  If ((Trunc((CX[N]+305+60)/160)+1<>AX) and (Trk[AX,AY] in [{'b','c',}'j','t'])) then
  Begin
    F:=True;
    Was:=CPos[N];
    If (CPos[N]=17) and (D=3) then Was:=18 else
      If (CPos[N]=1) and (D=4) then Was:=0;
    If (CPos[N]=18) and (D=3) then CPos[N]:=17 else
      If (CPos[N]=0) and (D=4) then CPos[N]:=1;
  End;
  If ((Trunc((CY[N]+235-45)/160)+1<>AY) and (Trk[AX,AY] in [{'a','b',}'i','u'])) then
  Begin
    F:=True;
    Was:=CPos[N];
    If (CPos[N]=28) and (D=1) then Was:=27 else
      If (CPos[N]=10) and (D=2) then Was:=9;
    If (CPos[N]=27) and (D=1) then CPos[N]:=28 else
      If (CPos[N]=9) and (D=2) then CPos[N]:=10;
  End;
  If ((Trunc((CY[N]+235+45)/160)+1<>AY) and (Trk[AX,AY] in [{'c','d',}'i','u'])) then
  Begin
    F:=True;
    Was:=CPos[N];
    If (CPos[N]=26) and (D=1) then Was:=27 else
      If (CPos[N]=8) and (D=2) then Was:=9;
    If (CPos[N]=27) and (D=1) then CPos[N]:=26 else
      If (CPos[N]=9) and (D=2) then CPos[N]:=8;
  End;
  C:=CPos[N];
  If CCh[N]<>0 then Old:=CPos[N];
  If F and (CSp[N]>MINSP) then Dec(CSp[N],GRAVSP+1);
  If (Abs(CLX[N]-CX[N])>25) or (Abs(CLY[N]-CY[N])>20) then
  Case Trk[AX,AY] of
  'a':
    If D=3 then
    Begin
      If (C>=9) and (C<27) then Inc(CPos[N]) else
        If C=0 then CPos[N]:=35 else
          If (C>27) or (C<9) then Dec(CPos[N]);
    End else
    Begin
      If C<>0 then
        If C=35 then CPos[N]:=0 else
          If C>18 then Inc(CPos[N]) else Dec(CPos[N]);
    End;
  'b':
    If D=1 then
    Begin
      If C<>0 then
        If C=35 then CPos[N]:=0 else
          If C>18 then Inc(CPos[N]) else Dec(CPos[N]);
    End else
    Begin
      If (C>9) and (C<=27) then Dec(CPos[N]) else
        If C=35 then CPos[N]:=0 else
          If C<>9 then Inc(CPos[N]);
    End;
  'c':
    If D=4 then
    Begin
      If (C>9) and (C<=27) then Dec(CPos[N]) else
        If C=35 then CPos[N]:=0 else
          If C<>9 then Inc(CPos[N]);
    End else
    Begin
      If (C>18) then Dec(CPos[N]) else
        If C<>18 then Inc(CPos[N]);
    End;
  'd':
    If D=2 then
    Begin
      If (C>18) then Dec(CPos[N]) else
        If C<>18 then Inc(CPos[N]);
    End else
    Begin
      If (C>=9) and (C<27) then Inc(CPos[N]) else
        If C=0 then CPos[N]:=35 else
          If (C>27) or (C<9) then Dec(CPos[N]);
    End;
  'i','u':
    If D=1 then
    Begin
      If F and (Was=27) then else
      If (C>=9) and (C<27) then Inc(CPos[N]) else
        If C=0 then CPos[N]:=35 else
          If (C>27) or (C<9) then Dec(CPos[N]);
    End else
    Begin
      If F and (Was=9) then else
      If (C>9) and (C<=27) then Dec(CPos[N]) else
        If C=35 then CPos[N]:=0 else
          If C<>9 then Inc(CPos[N]);
    End;
  'j','t':
    If D=3 then
    Begin
      If F and (Was=18) then else
      If (C>18) then Dec(CPos[N]) else
        If C<>18 then Inc(CPos[N]);
    End else
    Begin
      If F and (Was=0) then else
      If C<>0 then
        If C=35 then CPos[N]:=0 else
          If C>18 then Inc(CPos[N]) else Dec(CPos[N]);
    End;
  'l':
    If CSp[N]>MINSP then Dec(CSp[N],GRAVSP);
  'k':
    If D=1 then
    Begin
      If F and (Was=27) then else
      If (C>=9) and (C<27) then Inc(CPos[N]) else
        If C=0 then CPos[N]:=35 else
          If (C>27) or (C<9) then Dec(CPos[N]);
    End else
    If D=2 then
    Begin
      If F and (Was=9) then else
      If (C>9) and (C<=27) then Dec(CPos[N]) else
        If C=35 then CPos[N]:=0 else
          If C<>9 then Inc(CPos[N]);
    End else
    If D=3 then
    Begin
      If F and (Was=18) then else
      If (C>18) then Dec(CPos[N]) else
        If C<>18 then Inc(CPos[N]);
    End else
    Begin
      If F and (Was=0) then else
      If C<>0 then
        If C=35 then CPos[N]:=0 else
          If C>18 then Inc(CPos[N]) else Dec(CPos[N]);
    End;
  else
  Begin
    CX[N]:=CX[N]-CSp[N]*QX[C];
    CY[N]:=CY[N]-CSp[N]*QY[C];
    CSp[N]:=0;
  End;
  End;
  If (CCh[N]<>0) and (CSp[N]>30) then CPos[N]:=Old;
  If CCh[N]>1 then Dec(CCh[N]) else If CCh[N]<-1 then Inc(CCh[N]);
End;

Procedure ReadFromPcxs;
Var X,Y : LongInt;
Begin
  Assign(F,'sprf.dat');
  ReWrite(F,1);
  S:='00';
  X:=0;Y:=0;
  N:=0;
  Repeat
    ReadPCX(S+'.pcx',S1,M1,Pal,H,W);
    SetPalette(Pal);
    ShowImage(X,Y,W,H,S1,sel_d);
    Inc(X,160);
    If X>640-160 then
    Begin
      X:=0;
      Inc(Y,160);
      If Y>480-160 then repeat until pressed[scLeft];
      If Y>480-160 then Y:=0;
    End;
    If S[2]='9' then
    Begin
      Inc(S[1]); S[2]:='0';
    End else Inc(S[2]);
    If S='19' then S:='00';
    ShowDouble;
    BlockWrite(F,Ptr(S1,0)^,160*160);
    BigFree(M1);
    FreeSelector(S1);
    Inc(N);
  Until S='00';
{  BlockWrite(F,Pal,SizeOf(Pal));}
  Close(F);
  repeat until pressed[scEscape];
End;

Procedure ReadTrack;
Var F : Text;
A,B,C,D : LongInt;
AX,AY : LongInt;
Begin
  Assign(F,'t1.trk');
  ReSet(F);
  Read(F,TrX); ReadLn(F,TrY);
  FillChar(Trk,SizeOf(Trk),'p');
  For A:=1 to TrY do
  Begin
    For B:=1 to TrX do
      Read(F,Trk[B,A]);
    ReadLn(F);
  End;
  Read(F,AX);
  Read(F,AY);
  ReadLn(F,N);
  ReadLn(F,FinD);
  For A:=1 to NumComp do
  Begin
    Read(F,B);
    CX[A]:=B*160-205;
    Read(F,C);
    CY[A]:=C*160-135;
    CTX[A]:=B; CTY[A]:=C;
    CL[A]:=Trk[B+1,C+1];
    CLX[A]:=CX[A];CLY[A]:=CY[A];
    ReadLn(F,B);
    Case B of
    1: CPos[A]:=27;
    2: CPos[A]:=9;
    3: CPos[A]:=18;
    4: CPos[A]:=0;
    End;
    CD[A]:=B;
  End;
  X:=AX*160-205;
  Y:=AY*160-135;
  Close(F);
  FillChar(PT,SizeOf(PT),0);
  C:=1;D:=N;
  Inc(AX); Inc(AY);
  Repeat
    PT[AX,AY]:=C;
    Inc(C);
    A:=0;B:=0;
    Case Trk[AX,AY] of
    'a':
      If D=2 then
      Begin
        B:=1;
        D:=4;
      End else
      Begin
        A:=1;
        D:=1;
      End;
    'b':
      If D=1 then
      Begin
        B:=1;
        D:=4;
      End else
      Begin
        A:=-1;
        D:=2;
      End;
    'c':
      If D=4 then
      Begin
        A:=-1;
        D:=2;
      End else
      Begin
        B:=-1;
        D:=3;
      End;
    'd':
      If D=4 then
      Begin
        A:=1;
        D:=1;
      End else
      Begin
        B:=-1;
        D:=3;
      End;
{ e,f,g... are not realized }
    'i','u':
      If D=1 then A:=1 else A:=-1;
    'j','t':
      If D=3 then B:=-1 else B:=1;
    'k':
      If D=1 then A:=1 else If D=2 then A:=-1 else If D=3 then B:=-1 else B:=1;
    End;
    Inc(AX,A); Inc(AY,B);
  Until PT[AX,AY]=1;
  For A:=1 to NumComp do
  Begin
    CTrkBeg[A]:=PT[Trunc((CX[A]+305)/160)+1,Trunc((CY[A]+235)/160)+1];
    CTrkR[A]:=0;
    CSPC[A]:=0;
    CCh[A]:=0;
  End;
  TrkLast:=C-1;
End;

Procedure IsRightWay;
Var A,B,AX,AY : LongInt;
Begin
  { calculate BIGARRAY coords }
  AX:=Trunc((X+285)/160)+1;
  AY:=Trunc((Y+215)/160)+1;
  { analyse it }
  If Tim<>1 then
  Begin
    TrkBeg:=PT[AX,AY];
    Exit;
  End;
  If Trk[AX,AY]='k' then Exit;
  If Trk[AX,AY] in ['a'..'d','i','j','t','u'] then
  Begin
    If (TrkBeg>=TrkLast-3) and (PT[AX,AY]<3) then
      TrkBeg:=PT[AX,AY] else
    If TrkBeg>PT[AX,AY] then Exit else
    If PT[AX,AY]-TrkBeg<4 then
      TrkBeg:=PT[AX,AY] else
      Begin
        If (TrkR=0) or (TrkR=PT[AX,AY]) then
        Begin
          TrkR:=PT[AX,AY];
          Exit;
        End;
        TrkR:=0;
        PenG:=True;
        PenT:=PENTIME;
        { Calculate add time }
        A:=20*(PT[AX,AY]-TrkBeg);
        TrkBeg:=PT[AX,AY];
        { Make penalty}
        Pen.Time:=A;
        ConvertTime(Pen);
        Dec(Time,A);
        Dec(AllT,A);
      End;
  End;
End;

Procedure MulM(B : Real);
Var A : LongInt;
Begin
  For A:=0 to 35 do
  Begin
    QX[A]:=QX[A]*B;
    QY[A]:=QY[A]*B;
  End;
End;

Type TA = array[1..40000] of byte;

Var T : Word;
Midi : ^TA;
MidiLen : LongInt;

Procedure InitMidi;
Var F : File;
A,B : Word;
Begin
  Assign(F,'test.xmi');
  ReSet(F,1);
  GetM(40000,T,A);
  Midi:=Ptr(T,0);
  MidiLen:=FileSize(F);
  BlockRead(F,Midi^,Midilen);
  Close(F);
  T:=A;
  A:=Long(MidiLen).Low;
  B:=Long(MidiLen).Hi;
  asm
    mov ax,704h
    mov cx,T
    mov bx,0
    mov si,A
    mov di,B
    int 66h
    mov ax,702h
    mov bx,0
    int 66h
    mov ax,703h
    mov bx,1
    mov cx,$FFFF
    int 66h
  end;
End;

Procedure LookMidi;
Var R : Word;
Begin
  asm
    mov ax,70ch
    int 66h
    mov R,ax
  end;
  If R<>1 then
  Begin
    asm
      mov ax,702h
      mov bx,0
      int 66h
    end;
  End;
End;

Procedure DoneMidi;
Begin
  asm
    mov ax,705h
    int 66h
  end;
  FreeM(Seg(Midi^));
End;

Begin
  InitMidi;
  VesaInit(257,327680{640*480});
  If VesaError<>0 then
  Begin
    WriteLn(VesaErrorMessage(VesaError));
    Halt;
  End;
  Install_handler;
{  ReadFromPcxs;}
  ReadTrack;
  Assign(F,'spr.dat');
  ReSet(F,1);
  For A:=0 to 35 do
  Begin
    BigAlloc(70*50,Frames[A].S,Frames[A].M);
    BlockRead(F,Ptr(Frames[A].S,0)^,70*50);
  End;
  BlockRead(F,Pal,SizeOf(Pal));
  SetPalette(Pal);
  Close(F);
  Assign(F,'sprf.dat');
  ReSet(F,1);
  For A:=0 to 20 do
  Begin
    BigAlloc(160*160,Fields[A].S,Fields[A].M);
    BlockRead(F,Ptr(Fields[A].S,0)^,160*160);
  End;
{  BlockRead(F,Pal,SizeOf(Pal));
  For A:=0 to 100 do SetPalReg(A,Pal[A].R,Pal[A].G,Pal[A].B);}
  Close(F);
  SetPalReg($0E,180,180,90); { background(grass) }
  SetPalReg($03,50,100,130); { tree-root }
  SetPalReg($12,200,100,0);  { tree }
  SetPalReg(21,250,00,100); { start/finish }
  MulM(0.013);
  A:=N;
  Case A of
  1: N:=27;
  2: N:=9;
  3: N:=18;
  4: N:=0;
  End;
  FillChar(Sensiv,SizeOf(Sensiv),0);
  Best.Time:=MaxLongInt;
  Best.Min:=99;Best.Sec:=59;Best.Mil:=9;
  Pen:=Best;
  Last:=Best;
  Tim:=0;
  Tim_s:=AllocSel($46c,4);
  AllT:=MemL[Tim_s:0];
  Speed:=0; LastLeft:=0; LastRight:=0; SpCount:=0; TrkBeg:=1;
  PenG:=False;PenT:=0;TrkR:=0;
  Repeat
    LookMidi;
    Posi:=N;
{    X:=CX[3]-70;Y:=CY[3]-70;N:=CPos[3];Speed:=CSp[3];}
    X1:=X;Y1:=Y; If X1<0 then X1:=0; If Y1<0 then Y1:=0;
    If X1>TrX*160-640 then X1:=TrX*160-640; If Y1>TrY*160-480 then Y1:=TrY*160-480;
    ShowImageBig(Trunc(X1),Trunc(Y1),sel_d);
    If X1>X then X1:=X else If X1<X then X1:=X-X1 else X1:=0;
    If Y1>Y then Y1:=Y else If Y1<Y then Y1:=Y-Y1 else Y1:=0;
    X1:=X1+285;Y1:=Y1+215;
    G:=GetTrans(Trunc(X1),Trunc(Y1),70,50,Frames[N].S,Sel_d);
    If G and 2=2 then { wall }
    Begin
      Speed:=0;N:=OldN; LastLeft:=0; LastRight:=0; Zan:=False;
      X:=X2;Y:=Y2;
      X1:=X;Y1:=Y; If X1<0 then X1:=0; If Y1<0 then Y1:=0;
      If X1>TrX*160-640 then X1:=TrX*160-640; If Y1>TrY*160-480 then Y1:=TrY*160-480;
      ShowImageBig(Trunc(X1),Trunc(Y1),sel_d);
      If X1>X then X1:=X else If X1<X then X1:=X-X1 else X1:=0;
      If Y1>Y then Y1:=Y else If Y1<Y then Y1:=Y-Y1 else Y1:=0;
      X1:=X1+285;Y1:=Y1+215;
    End else
    Begin
      If G and 1=1 then
      Begin
        If Speed>MINSP then Dec(Speed,GRAVSP);
      End;
      If G and 4=4 then
        Start else If Tim=3 then Tim:=1;
    End;
    ShowTransl(Trunc(X1),Trunc(Y1),70,50,Frames[N].S,Sel_d,12);
    For A:=1 to NumComp do
    Begin
      X1:=X;Y1:=Y; If X1<0 then X1:=0; If Y1<0 then Y1:=0;
      If X1>TrX*160-640 then X1:=TrX*160-640; If Y1>TrY*160-480 then Y1:=TrY*160-480;
      X3:=CX[A]-X1+285;Y3:=CY[A]-Y1+215;
{      If (X3>=0) and (X3<=640-70) and (Y3>=0) and (Y3<=480-50) then}
      ShowTransC(Trunc(X3),Trunc(Y3),70,50,Frames[CPos[A]].S,Sel_d,Colors[A]);
      CPU(A);
    End;
    PrintTime;
    IsRightWay;
    VRT;
    ShowDouble;
    If Pressed[scUp] then
    Begin
      Inc(Sensiv[1]);
      If Sensiv[1]>=SP_SENSIVITY then
      Begin
        If Speed<0 then
        Begin
          Inc(Speed,BreakSpeedDown);
          If Speed>0 then Speed:=0;
        End;
        If Speed<NumOfSpeeds then
        Begin
          If Speed>100 then
          Begin
            Inc(SPCount);
            If SpCount>=2+(Speed-100) div 20 then
            Begin
              Inc(Speed);
              SpCount:=0;
            End;
          End else
            Inc(Speed);
        End;
        Sensiv[1]:=0;
      End;
    End;
    If Pressed[scDown] then
    Begin
      Inc(Sensiv[2]);
      If Sensiv[2]>=SP_SENSIVITY then
      Begin
        Dec(Speed,BreakSpeedDown);
        If (Speed<0) and (Speed+BreakSpeedDown>0) then
          Speed:=0 else
          If Speed<0 then Speed:=Speed+BreakSpeedDown-1;
        If Speed<BackSpeeds then Speed:=BackSpeeds;
        Sensiv[2]:=0;
      End;
    End;
    OldN:=N;
    If Sensiv[3]<LR_SENSIVITY then Inc(Sensiv[3]);
    If Sensiv[4]<LR_SENSIVITY then Inc(Sensiv[4]);
    If Pressed[scLeft] then
    Begin
      If Sensiv[3]>=LR_SENSIVITY then
      Begin
        Inc(LastLeft);
        If LastLeft=1 then
        Begin
          FirstPX:=QX[N]*Speed/ZANKOEF;
          FirstPY:=QY[N]*Speed/ZANKOEF;
        End;
        Dec(N);
        Sensiv[3]:=0;
      End;
    End;
    If Pressed[scRight] then
    Begin
      If Sensiv[4]>=LR_SENSIVITY then
      Begin
        Inc(LastRight);
        If LastRight=1 then
        Begin
          FirstPX:=QX[N]*Speed/ZANKOEF;
          FirstPY:=QY[N]*Speed/ZANKOEF;
        End;
        Inc(N);
        Sensiv[4]:=0;
      End;
    End;
{    If (Speed<-1) and (Speed>-1.01) then Speed:=0;}
    If Sensiv[3]=LR_SENSIVITY then LastLeft:=0;
    If Sensiv[4]=LR_SENSIVITY then LastRight:=0;
    If N<0 then N:=35;
    If N>35 then N:=0;
    Posi:=N;
    X2:=X;Y2:=Y;
    X:=X+QX[N]*Speed;
    Y:=Y+QY[N]*Speed;
    If ((LastLeft>GOODANGLE) or (LastRight>GOODANGLE) and (Speed>GOODSPEED)) then
    Begin
      Zan:=True;
      LastPX:=FirstPX;
      LastPY:=FirstPY;
      FirstPX:=FirstPX*0.9;
      FirstPY:=FirstPY*0.9;
    End;
    If Zan then
    Begin
      X:=X+LastPX;
      Y:=Y+LastPY;
      LastPX:=LastPX-ZANDEC;
      LastPY:=LastPY-ZANDEC;
      If LastPX<0 then LastPX:=0;
      If LastPY<0 then LastPY:=0;
      If (LastPX=0) and (LastPY=0) then Zan:=False;
    End;
    If X<-285 then X:=-285;
    If Y<-215 then Y:=-215;
    If X>TrX*160-640+285 then X:=TrX*160-640+285;
    If Y>TrY*160-480+215 then Y:=TrY*160-480+215;
  Until Pressed[scEscape] {or (Match and (Laps[0]<=0))};
  For A:=0 to 35 do
  Begin
    BigFree(Frames[A].M);
    FreeSelector(Frames[A].S);
  End;
  For A:=0 to 20 do
  Begin
    BigFree(Fields[A].M);
    FreeSelector(Fields[A].S);
  End;
  FreeSelector(Tim_s);
  VesaDone;
  Restore_handler;
  DoneMidi;
End.