{$L pcxload}
Unit vesa;
Interface
Uses WinApi,Dos;

{ =======================  interface section ============================ }

Const
     PalMask = $36C;  { For      }
     PalRegR = $3C7;  { work     }
     PalRegW = $3C8;  { with     }
     PalData = $3C9;  { palette  }

Type PCX_Header = record
       manufacture,version,encoding,bits_per_pixel : Byte;
       X,Y,width,height,horz_res,vert_res : Word;
       ega_palette : array[0..15,1..3] of Byte;
       reserved : Byte;
       NumColorPlanes : Byte;
       BytesPerLine,PaletteType : Word;
       padding : array[1..58] of Byte;
     End;
     Long = record    { Record for work with 32bit registers (because type }
       Low,Hi : Word; { LongInt is signed and we need unsigned type ) }
     End;
     TPalette = Array[0..255] of record { Palette for modes with 256 colors }
                                   R,G,B : Byte;
                                 End;
     TFont = Array[0..255,0..7] of Byte;

Var
   Mem_mode : LongInt; { This variable keep amount of memory used
                         for setting mode }
   Fnt : TFont;  { Font, which is currently used to print chars }
   Sel_v : Word; { Selector to work with vesa linear frambuffer }
   Sel_d : Word; { Selector to work with double buffer memory }
   WinSeg : Word;
   Sel_f : Word; { Selector to work with font }
   Handle_d : THandle; { Handle of double buffer memory }
   VesaError : Byte; { This variable is set to zero is VesaInit
                       has no problems and to one of the following
                       numbers, if while used VesaInit were problems:
                       1        can't allocate selector
                       2        error initializing mode
                       3        vesa doesn't support linear framebuffer
                                for this mode (often : univbe not loaded)
                       4        allocation low memory error
                       5        allocation memory for double buffer error }

{ ======================  declare procedures  ====================== }
Procedure VesaInit(Mode : Word; Mem_need : LongInt);
{ Set video mode, used Mem_need memory for double buffer and screen.
Selector of screen will be in Sel_v, selector for double buffer in Sel_d.
If there were any errors when tried to set mode, this error will be in
VesaError variable }
Procedure VesaDone;
{ Free all memory, which is used by unit }
Function SetMode(Mode : Word) : Word;
{ Sets mode and return selector of screen }
Procedure SetTextMode;
{ Set again text mode, if now vesa mode is set }
Function AllocSel(Base : LongInt; Limit : LongInt) : Word;
{ Allocate selector. Return allocated selector }
Procedure Dos_Int(IntNo : Byte;var R : Registers);
{ Emulate Dos interrupt with registers R. Return registers after interrupt }
Function VesaErrorMessage(ErrorNo : Byte)  : String;
{ Returns error message by vesa error number }
Procedure SetPalReg(index,Red,Green,Blue : Byte);
{ Set up Red,Green,Blue (RGB) for index color }
Procedure GetPalReg(index : Byte; Var Red,Green,Blue : Byte);
{ Read Red,Green,Blue (RGB) for index color }
Procedure SetPalette(Pal : TPalette);
{ Change current palette to the Pal }
Procedure GetPalette(Var Pal : TPalette);
{ Reads currect palette into Pal }
Procedure LoadPalette(FileName : String);
{ Load and set up palette from file for 256 color mode }
Procedure SavePalette(FileName : String);
{ Save current palette to file for 256 color mode }
Procedure BigAlloc(Size : LongInt;Var Sel : Word;Var MemH : THandle);
{ Allocate Size bytes and return selector to access to this memory
(offset in pointer = 0) and Memory Handle to Free this memory at last }
Procedure BigFree(MemH : THandle);
{ Free memory, allocating by BigAlloc. Program must take care about
selector, i.e. after BigFree(MemH) must be FreeSelector(Sel) }
Procedure ReadPCX(FileName : String;Var Sel : Word;Var MemH : THandle;Var Pal : TPalette;Var Height,Width : Word);
{ Read .pcx file into memory (memory is allocated by the ReadPCX
procedure) and return selector to access loaded sprite, memory handler
to free this mmemory at last, palette of the pcx file, height and width
of the picture. Before program will done, it must FreeSelector(Sel) and
BigFree(MemH) }
Procedure InitFont;
{ Initialization of font. This procedure allocate selector for font use }
Procedure DoneFont;
{ Free selector for font }
Procedure LoadFont(FileName : String);
{ Load font from file }
Procedure SaveFont(FileName : String);
{ Save current font to file }
Procedure RestoreDefaultFont;
{ copy default font from ROM }
Procedure GetM(Size : LongInt;Var Sel,Seg : Word);
Procedure FreeM(Sel : Word);

Implementation

Type TPcxBuf = Array[1..32768] of Byte;

{ internal variables }

Var OldExitProc : Pointer;
PH : PCX_Header;
F : File;
PcxBuf : ^TPcxBuf;
Readed : LongInt;
NR : Word;
CurOfs : LongInt;
S1 : Word;
M1 : THandle;

{ ==========================  private section =========================== }
Procedure CopyToBig_asm(ofs1 : LongInt;S1 : Word;ofs2 : LongInt;
S2 : Word;Count : Word); far; external;

Procedure TrPcx_asm(S1,S2 : Word;Count : LongInt); far; external;

Procedure VesaExit;
Begin
  If ErrorAddr<>nil then
  Begin
       WriteLn('Fatal Error #',ExitCode);
    ErrorAddr:=nil; { Pascal will not write HIS error message }
  End;
  ExitProc:=OldExitProc;
  Halt(1); { Return to os with error message 1 }
End;

Procedure GetM(Size : LongInt;Var Sel,Seg : Word);
Var R : Registers;
Begin
  R.ax:=$100;
  R.bx:=(Size+$F) shr 4;
  Intr($31,R);
  If R.flags and fCarry<>0 then
  Begin
    VesaError:=4;
    Exit;
  End;
  Sel:=R.dx;
  Seg:=R.ax;
End;

Procedure FreeM(Sel : Word);
Var R : Registers;
Begin
  R.ax:=$101;
  R.dx:=Sel;
  Intr($31,R);
  If R.flags and fCarry<>0 then
  Begin
    VesaError:=4;
    Exit;
  End;
End;

Function Map(Base,Limit : LongInt) : LongInt;
Var R : Registers;
Var B,L : Long;
Begin
  B:=Long(Base);
  L:=Long(Limit);
  R.ax:=$800;
  R.bx:=B.Hi;
  R.cx:=B.Low;
  R.si:=L.Hi;
  R.di:=L.Low;
  Intr($31,R);
  Map:=(LongInt(R.bx) shl 16)+R.cx
End;

Function ReadVbeData(Mode : Word) : LongInt; { return adress of framebuffer }
Type TModeInfo = Array[1..250] of LongInt;
Var Sel1,Seg1 : Word;
P : ^TModeInfo;
R : Registers;
I : LongInt;
Begin
  GetM(1000,Sel1,Seg1); { Get Dos memory from low 640K and return }
  If VesaError<>0 then Exit;
  P:=Ptr(Sel1,0);       { protected mode selector and real mode segment }
  R.cx:=mode;
  R.ax:=$4f01;
  R.es:=Seg1;
  Dos_Int($10,R); { Emulate Dos interrupt because of specific work of
                    this vesa function. Return ModeInfo in P^ }
  I:=P^[11]; { Here is adress of linear framebuffer }
  If I=0 then { Doesn't support linear framebuffer for this mode }
  Begin
    VesaError:=3;
    Exit;
  End;
  Asm
    xor ax,ax
    mov es,ax
  End;
  FreeM(Sel1); { Free Dos memory }
  ReadVbeData:=I;
End;

{ =======================  implementation section ======================= }

Procedure VesaInit(Mode : Word; Mem_need : LongInt);
Var P : Pointer;
Begin
  VesaError:=0;
  asm
    mov ax,4F02h
    mov bx,mode
    int 10h
  end;
  WinSeg:=SegA000;
  Mem_mode:=Mem_need;
  Sel_v:=0;
  Handle_d:=GlobalAlloc(GMEM_MOVEABLE,Mem_mode);
  If Handle_d=0 then
  Begin
    SetTextMode;
    VesaError:=5;
    Exit;
  End;
  P:=GlobalLock(Handle_d);
  If P=nil then
  Begin
    SetTextMode;
    VesaError:=5;
    Exit;
  End;
  Sel_d:=AllocSel(GetSelectorBase(Seg(P^))+Ofs(P^),Mem_mode);
  InitFont;
  RestoreDefaultFont;
End;

Procedure VesaDone;
Begin
  DoneFont;
{  FreeSelector(Sel_v);}
  FreeSelector(Sel_d);
  GlobalUnlock(Handle_d);
  GlobalFree(Handle_d);
  SetTextMode;
End;

Procedure SetTextMode; assembler;
Asm
  mov ax,3
  Int $10
End;

Function SetMode(Mode : Word) : Word;
Var R : Registers;
Adr,Ad : LongInt;
Sel : Word;
Begin
  Ad:=ReadVbeData(Mode);
  If VesaError<>0 then Exit;
  R.ax:=$4f02;
  R.bx:=mode or $4000; { to set mode using linear framebuffer }
  Intr($10,R);
  If R.flags and fCarry<>0 then
  Begin
    VesaError:=2;
    Exit;
  End;
  Adr:=Map(Ad,Mem_mode);
  Sel:=AllocSel(Adr,Mem_mode);
  SetMode:=Sel;
End;

Function AllocSel(Base,Limit : LongInt) : Word;
Var R : Registers;
Sel : Word;
B,L : Long;
Begin
  B:=Long(Base);
  L:=Long(Limit);
  { begin allocating selector }
  R.ax:=0;
  R.cx:=1;
  Intr($31,R);
  If R.flags and fCarry<>0 then
  Begin
    VesaError:=1;
    Exit;
  End;
  sel:=R.ax;
  { end allocate selector }
  { begin setbase of selector }
  R.ax:=7;
  R.bx:=sel;
  R.cx:=B.Hi;
  R.dx:=B.Low;
  Intr($31,R);
  If R.flags and fCarry<>0 then
  Begin
    Vesaerror:=1;
    Exit;
  End;
  { end setbase of selector }
  { begin setlimit of selector }
  If Limit>$FFFFF then { selector limit greater than 1MB }
    Limit:=Limit or $FFF; { all selectors which are greater than 1MB
                            must be alligned to the last $FFF }
  L:=Long(Limit);
  R.ax:=8;
  R.bx:=sel;
  R.cx:=L.Hi;
  R.dx:=L.Low;
  Intr($31,R);
  If R.flags and fCarry<>0 then
    R.ax:=0;
  If R.ax=0 then
  Begin
    R.bx:=Sel;
    If Limit>$FFFFF then R.cx:=$80F2 else R.cx:=$00F2;
    R.ax:=9;
    Intr($31,R);
    If R.flags and fCarry<>0 then R.ax:=0;
  End;
  If R.ax=0 then
  Begin
    R.ax:=8;
    R.bx:=sel;
    R.cx:=L.Hi;
    R.dx:=L.Low;
    Intr($31,R);
    If R.flags and fCarry<>0 then
    Begin
      VesaError:=1;
      Exit;
    End;
  End;
  AllocSel:=Sel;
End;

Procedure Dos_Int(IntNo : Byte;var R : Registers);
Type rmiinfo = record
       edi,esi,ebp,reserv,ebx,edx,ecx,eax : LongInt;
       flags : Word;
       es,ds,fs,gs,ip,cs,sp,ss : Word;
     End;
Var vr : rmiinfo;
Begin
  FillChar(Vr,SizeOf(Vr),0); { clear all registers }
  vr.ecx:=LongInt(r.cx);
  vr.eax:=LongInt(r.ax);
  vr.ebx:=LongInt(r.bx);
  vr.edx:=LongInt(r.dx);
  vr.esi:=LongInt(r.si);
  vr.edi:=LongInt(r.di);
  vr.es:=r.es;
  vr.edi:=0;
  r.es:=Seg(vr);
  r.di:=Ofs(vr);
  r.ax:=$300;
  r.bl:=IntNo;
  r.bh:=0;
  r.cx:=0;
  Intr($31,R);
  r.ax:=Word(vr.eax);
  r.bx:=Word(vr.ebx);
  r.cx:=Word(vr.ecx);
  r.dx:=Word(vr.edx);
  r.si:=Word(vr.esi);
  r.di:=Word(vr.edi);
  r.es:=vr.es;
End;

Function VesaErrorMessage(ErrorNo : Byte) : String;
Begin
  Case ErrorNo of
  0 : VesaErrorMessage:='Success';
  1 : VesaErrorMessage:='Error allocating selector';
  2 : VesaErrorMessage:='Error initializing mode';
  3 : VesaErrorMessage:='Vesa doesn"t support linear framebuffer for this mode, start univbe.exe';
  4 : VesaErrorMessage:='Allocating low dos memory error';
  5 : VesaErrorMessage:='Allocating memory for double buffer error (need at least 1MB free memory)';
  else
    VesaErrorMessage:='Error number isn"t vesa error';
  End;
End;

Procedure SetPalReg(index,Red,Green,Blue : Byte);
Begin
  Port[PalMask]:=$FF;
  Port[PalRegW]:=index;
  Port[PalData]:=Red;
  Port[PalData]:=Green;
  Port[PalData]:=Blue;
End;

Procedure GetPalReg(index : Byte; Var Red,Green,Blue : Byte);
Begin
  Port[PalMask]:=$FF;
  Port[PalRegR]:=index;
  Red:=Port[PalData];
  Green:=Port[PalData];
  Blue:=Port[PalData];
End;

Procedure SetPalette(Pal : TPalette);
Var A : Byte;
Begin
  For A:=0 to 255 do
    SetPalReg(A,Pal[A].R,Pal[A].G,Pal[A].B);
End;

Procedure GetPalette(Var Pal : TPalette);
Var A : Byte;
Begin
  For A:=0 to 255 do
    GetPalReg(A,Pal[A].R,Pal[A].G,Pal[A].B);
End;

Procedure LoadPalette(FileName : String);
Var F : File of TPalette;
CurPal : TPalette;
A:byte;
Begin
  Assign(F,FileName);
  ReSet(F);
  Read(F,CurPal);
  Close(F);
  SetPalette(CurPal);
End;

Procedure SavePalette(FileName : String);
Var F : File of TPalette;
CurPal : TPalette;
A : Byte;
Begin
  GetPalette(CurPal);
  Assign(F,FileName);
  ReWrite(F);
  Write(F,CurPal);
  Close(F);
End;

Procedure BigAlloc(Size : LongInt;Var Sel : Word;Var MemH : THandle);
Var P : Pointer;
Begin
  MemH:=GlobalAlloc(GMEM_MOVEABLE,Size);
  P:=GlobalLock(MemH);
  Sel:=AllocSel(GetSelectorBase(Seg(P^))+LongInt(Ofs(P^)),Size);
End;

Procedure BigFree(MemH : THandle);
Begin
  GlobalUnlock(MemH);
  GlobalFree(MemH);
End;

Procedure ReadPCX(FileName : String;Var Sel : Word;Var MemH : THandle;Var Pal : TPalette;Var Height,Width : Word);
Var A : Byte;
Begin
  Assign(F,FileName);
  ReSet(F,1);
  BlockRead(F,PH,SizeOf(PH));
  Inc(PH.height);
  Inc(PH.width);
  Seek(F,FileSize(F)-768);
  BlockRead(F,Pal,SizeOf(Pal));
  For A:=0 to 255 do
  Begin
    Pal[A].R:=Pal[A].R shr 2;
    Pal[A].G:=Pal[A].G shr 2;
    Pal[A].B:=Pal[A].B shr 2;
  End;
  Seek(F,SizeOf(PH));
  BigAlloc(LongInt(PH.height)*LongInt(PH.width),Sel,MemH);
  Readed:=FileSize(F)-SizeOf(Pal)-SizeOf(PH);
  BigAlloc(Readed,S1,M1);
  New(PcxBuf);
  Height:=PH.height;
  Width:=PH.width;
  CurOfs:=0;
  Repeat
    If Readed>=SizeOf(PcxBuf^) then
      BlockRead(F,PcxBuf^,SizeOf(PcxBuf^),NR) else
      BlockRead(F,PcxBuf^,Readed,NR);
    Dec(Readed,NR);
    CopyToBig_asm(CurOfs,S1,LongInt(Ofs(PcxBuf^)),Seg(PcxBuf^),NR);
    Inc(CurOfs,NR);
  Until Readed<=0;
  Close(F);
  Dispose(PcxBuf);
  TrPcx_asm(S1,Sel,CurOfs-1);
  BigFree(M1);
  FreeSelector(S1);
End;

Procedure InitFont;
Begin
  Sel_f:=AllocSel(GetSelectorBase(Seg(Fnt))+Ofs(Fnt),SizeOf(TFont));
End;

Procedure DoneFont;
Begin
  FreeSelector(Sel_f);
End;

Procedure LoadFont(FileName : String);
Var F : file of TFont;
Begin
  Assign(F,FileName);
  ReSet(F);
  Read(F,Fnt);
  Close(F);
End;

Procedure SaveFont(FileName : String);
Var F : File of TFont;
Begin
  Assign(F,FileName);
  ReWrite(F);
  Write(F,Fnt);
  Close(F);
End;

Procedure RestoreDefaultFont;
Var S : Word;
Begin
  S:=AllocSel($FFA6E,1024);
  Move(Ptr(S,0)^,Fnt,1024);
  FreeSelector(S);
End;
{ =======================  initialization section ======================= }

Begin
  OldExitProc:=ExitProc; { When error occupied program, all selectors and }
  ExitProc:=@Vesaexit;   { memory, which is used by this unit will be free }
End.