DECLARE SUB loadroot ()
DECLARE SUB soundfx (freq AS INTEGER)
DECLARE SUB over ()
DECLARE SUB scroll (blue AS INTEGER, green AS INTEGER, red AS INTEGER, text AS STRING, cview AS INTEGER, csize AS INTEGER, speed AS INTEGER, mirror AS INTEGER, rad AS INTEGER, swirl AS INTEGER, rotate AS INTEGER)
DECLARE SUB title ()
DECLARE SUB found (nr AS INTEGER)
DECLARE SUB pastethn (snr AS INTEGER, xpos AS INTEGER, ypos AS INTEGER)
DECLARE SUB drawmap (xspd AS INTEGER, yspd AS INTEGER)
DECLARE SUB firstmap ()
DECLARE SUB clearcontact ()
DECLARE SUB contactmap ()
DECLARE SUB game ()
DECLARE SUB makeact ()
DECLARE SUB getword ()
DECLARE SUB clearkeybuf ()
DECLARE SUB compmove (snr AS INTEGER)
DECLARE SUB loadthn (nr AS INTEGER)
DECLARE SUB loadspr (nam AS INTEGER)
DECLARE SUB loadobj (inpt AS INTEGER)
DECLARE SUB loaddefault ()
DECLARE SUB default ()
DECLARE SUB story ()
DECLARE SUB initspecs ()
DECLARE SUB contact (nr AS INTEGER)
DECLARE SUB contactdetect ()
DECLARE SUB maxload ()
DECLARE SUB pastespr (snr AS INTEGER, xpos AS INTEGER, ypos AS INTEGER, xspd AS INTEGER, yspd AS INTEGER)
DECLARE SUB pasteobj (xpos AS INTEGER, ypos AS INTEGER)
DECLARE SUB loadsprpic ()
DECLARE SUB blink (inp$)
DECLARE SUB sprbird ()
DECLARE SUB sprcomp (snr AS INTEGER)
DECLARE SUB spruser ()
DECLARE SUB dark (inpt AS STRING)
DECLARE SUB make (chosen AS INTEGER)
DECLARE SUB drawline (nam AS INTEGER, xpos AS INTEGER, ypos AS INTEGER, col AS INTEGER)
DECLARE SUB check (xspd AS INTEGER, yspd AS INTEGER, snr AS INTEGER)
DECLARE SUB putpic (xp AS INTEGER, yp AS INTEGER, nm AS INTEGER)
DECLARE SUB sprmove (snr AS INTEGER, sprdir AS INTEGER)
DECLARE SUB clearbuf (xpos AS INTEGER, ypos AS INTEGER)
DECLARE SUB loadpal (pname AS INTEGER)
DECLARE SUB cameraview ()
DECLARE SUB slow (i AS INTEGER)
DECLARE SUB clearscreen ()
DECLARE SUB clearview ()
DECLARE SUB options ()
DECLARE SUB sprites ()

DECLARE FUNCTION fight% (pval AS INTEGER, eval AS INTEGER, pnrg AS INTEGER, enrg AS INTEGER)
DECLARE FUNCTION parser$ (inpt AS STRING)
DECLARE FUNCTION specnr% (inpt AS STRING)
DECLARE FUNCTION unscribble$ (word AS STRING)
DECLARE FUNCTION rword$ (word1 AS STRING, word2 AS STRING)
DECLARE FUNCTION form$ (inpt AS INTEGER)
DECLARE FUNCTION loadpic% (npic AS STRING)
DECLARE FUNCTION marked$ (chosen AS INTEGER)
DECLARE FUNCTION keyboard$ ()

CONST false = 0
CONST true = 1
CONST typmax = 4
CONST limx = 640
CONST limy = 480
CONST maxx = 150
CONST maxy = 150
CONST cback = 13
CONST cfore = 14
CONST csize = 20
CONST cview = 6
CONST cmore = cview / 2
CONST cposx = limx / 2 - csize / 2
CONST cposy = limy / 2 - csize / 2
CONST cbord = 4
CONST pmax = 9
CONST bagmax = 5
CONST menumax = 7
CONST sprsz = 10
CONST sprpicmax = 5
CONST lvl = 1
CONST thnmax = 15
CONST thnsz = 6

TYPE sprite
 called  AS STRING * 15
 x       AS INTEGER
 y       AS INTEGER
 x1      AS INTEGER
 y1      AS INTEGER
 x2      AS INTEGER
 y2      AS INTEGER
 direc   AS INTEGER
 species AS STRING * 10
 sex     AS STRING * 10
 job     AS STRING * 10
 energy  AS INTEGER
 intel   AS STRING * 10
 status  AS STRING * 10
END TYPE

TYPE thing
 called  AS STRING * 10
 x       AS INTEGER
 y       AS INTEGER
END TYPE

DIM SHARED root AS STRING
loadroot

DIM SHARED objmax AS INTEGER
DIM SHARED sprmax AS INTEGER
DIM SHARED camera AS INTEGER
DIM SHARED player AS INTEGER
maxload

DIM spr(sprmax) AS sprite
DIM thn(thnmax) AS thing
DIM choice AS STRING
DIM specs(5) AS STRING
DIM act(1 TO 2) AS STRING
DIM wordbuf AS STRING
DIM bag(sprmax, bagmax) AS STRING
DIM obj(maxx, maxy) AS INTEGER
DIM picbuffer(9) AS INTEGER
DIM typ(objmax) AS INTEGER
DIM mapcol(objmax) AS INTEGER
DIM lastnr AS INTEGER
DIM leave AS INTEGER
DIM shown AS INTEGER
DIM sprnr AS INTEGER
DIM thnnr AS INTEGER
DIM buffer(-cview TO cview, -cview TO cview) AS INTEGER
DIM sprpic(1 TO sprpicmax, 1 TO 4, sprsz, sprsz) AS INTEGER
DIM sprpicbuf(0 TO sprmax, sprsz, sprsz) AS INTEGER
DIM thnpicbuf(0 TO thnmax, thnsz, thnsz) AS INTEGER

DIM pmem AS INTEGER
pmem = 500

' $DYNAMIC
DIM pic1(pmem), pic2(pmem), pic3(pmem) AS INTEGER
DIM pic4(pmem), pic5(pmem), pic6(pmem) AS INTEGER
DIM pic7(pmem), pic8(pmem), pic9(pmem) AS INTEGER

SCREEN 12
RANDOMIZE TIMER

title
dark "please wait..."
initspecs
loadobj 1
loadspr 1
loadthn 1
loadsprpic
loaddefault
clearscreen
clearview
cameraview
loadpal 1

DO

 IF wordbuf = "" THEN
  default
  choice = keyboard$
  clearkeybuf
  options
 ELSE
  getword
 END IF

 spruser
 FOR sprnr = 1 TO sprmax - 1
  sprcomp sprnr
 NEXT
 sprbird

 FOR thnnr = 0 TO thnmax
  IF RND * 160 > 158 THEN
   pastethn thnnr, thn(thnnr).x, thn(thnnr).y
  END IF
  IF thn(thnnr).x = spr(player).x AND thn(thnnr).y = spr(player).y THEN
   found (thnnr)
  END IF
 NEXT

LOOP

REM $STATIC
SUB blink (inp$)

SHARED wordbuf AS STRING
SHARED choice AS STRING
SHARED act() AS STRING
SHARED shown AS INTEGER

IF wordbuf <> "" THEN
 LOCATE CSRLIN - 1, LEN(wordbuf) + 1
 PRINT "  "
 act(1) = ""
 act(2) = ""
 wordbuf = ""
 shown = false
 PRINT "SOMETHING INTERRUPTS YOUR THOUGHTS..."
END IF

DIM xp AS INTEGER
DIM letter AS STRING

FOR xp = 1 TO LEN(inp$)

 letter = MID$(inp$, xp, 1)

 IF letter = UCASE$(letter) AND letter >= "A" AND letter <= "Z" OR letter = " " OR letter = "<" THEN
  COLOR 1
 ELSE
  letter = UCASE$(letter)
  COLOR cfore
 END IF

 PRINT letter;

NEXT

PRINT

END SUB

SUB cameraview

SHARED spr() AS sprite
SHARED thn() AS thing

DIM grx AS INTEGER
DIM gry AS INTEGER
DIM nr AS INTEGER

FOR grx = -cview TO cview
 FOR gry = -cview TO cview
  pasteobj grx + spr(camera).x, gry + spr(camera).y
 NEXT
NEXT

FOR nr = 0 TO sprmax - 1
 pastespr nr, spr(nr).x, spr(nr).y, -2, 0
NEXT

FOR nr = 0 TO thnmax
 pastethn nr, thn(nr).x, thn(nr).y
NEXT

END SUB

SUB check (xspd AS INTEGER, yspd AS INTEGER, snr AS INTEGER)

SHARED spr() AS sprite
SHARED thn() AS thing
SHARED obj() AS INTEGER
SHARED typ() AS INTEGER

IF snr <> camera THEN

 IF spr(snr).x + xspd >= 0 AND spr(snr).x + xspd <= maxx THEN
 IF spr(snr).y + yspd >= 0 AND spr(snr).y + yspd <= maxy THEN

  SELECT CASE typ(obj(spr(snr).x + xspd, spr(snr).y + yspd))

   CASE 0 ' background
    pastespr snr, spr(snr).x, spr(snr).y, 0, 0

    spr(snr).x = spr(snr).x + xspd
    spr(snr).y = spr(snr).y + yspd
    
    pastespr snr, spr(snr).x, spr(snr).y, xspd, yspd
   
   CASE 1 ' barrier
    IF spr(snr).x >= spr(camera).x - cview AND spr(snr).x <= spr(camera).x + cview THEN
    IF spr(snr).y >= spr(camera).y - cview AND spr(snr).y <= spr(camera).y + cview THEN
     soundfx 1
    END IF
    END IF

   CASE 2 ' switch back
    clearbuf spr(snr).x, spr(snr).y
    pasteobj spr(snr).x, spr(snr).y
    spr(snr).x = spr(snr).x + xspd
    spr(snr).y = spr(snr).y + yspd
    pastespr snr, spr(snr).x, spr(snr).y, xspd, yspd
  
    obj(spr(snr).x, spr(snr).y) = obj(spr(snr).x, spr(snr).y) + 1

   CASE 3 ' switch barr
    IF spr(snr).x >= spr(camera).x - cview AND spr(snr).x <= spr(camera).x + cview THEN
    IF spr(snr).y >= spr(camera).y - cview AND spr(snr).y <= spr(camera).y + cview THEN
     soundfx 1
    END IF
    END IF
    obj(spr(snr).x + xspd, spr(snr).y + yspd) = obj(spr(snr).x + xspd, spr(snr).y + yspd) + 1
    clearbuf spr(snr).x + xspd, spr(snr).y + yspd
    pasteobj spr(snr).x + xspd, spr(snr).y + yspd

   CASE 4 ' danger
    IF spr(snr).x >= spr(camera).x - cview AND spr(snr).x <= spr(camera).x + cview THEN
    IF spr(snr).y >= spr(camera).y - cview AND spr(snr).y <= spr(camera).y + cview THEN
     soundfx 3
     IF snr = player THEN
      blink "you HURT yourself!"
     ELSE
      blink RTRIM$(spr(snr).called) + " has HURT himself!"
     END IF
    END IF
    END IF
    
    spr(snr).energy = spr(snr).energy - 10
    IF spr(snr).energy <= 0 THEN
     soundfx 4
     blink RTRIM$(spr(snr).called) + " has DIED!"
     IF snr = player THEN over
    END IF

  END SELECT

 END IF
 END IF

ELSE

 DIM nr AS INTEGER

 FOR nr = 0 TO sprmax - 1
  clearbuf spr(nr).x, spr(nr).y
 NEXT
 FOR nr = 0 TO thnmax
  clearbuf thn(nr).x, thn(nr).y
 NEXT

 spr(snr).x = spr(snr).x + xspd
 spr(snr).y = spr(snr).y + yspd
 cameraview
 drawmap xspd, yspd

END IF

END SUB

SUB clearbuf (xpos AS INTEGER, ypos AS INTEGER)

SHARED spr() AS sprite
SHARED buffer() AS INTEGER

IF xpos - spr(camera).x >= -cview AND xpos - spr(camera).x <= cview THEN
IF ypos - spr(camera).y >= -cview AND ypos - spr(camera).y <= cview THEN

 buffer(xpos - spr(camera).x, ypos - spr(camera).y) = 0

END IF
END IF

END SUB

SUB clearcontact
  
LINE (20, 160)-STEP(160, 160), cfore, BF
LINE (20 + 5, 160 + 5)-STEP(160 - 10, 160 - 10), 0, BF

END SUB

SUB clearkeybuf

SHARED choice AS STRING
STATIC lastkey AS STRING
DIM dummy AS STRING

IF choice <> "none" AND choice = lastkey THEN
 dummy = INKEY$

ELSE
 lastkey = choice

END IF

END SUB

SUB clearscreen

DIM mr AS INTEGER
DIM xx, yy AS INTEGER

FOR mr = 0 TO cbord
 LINE (0 + mr, 0 + mr)-(limx - mr, limy - mr), cfore, B
NEXT

LINE (cbord, cbord)-(limx - cbord, limy - cbord), cback, BF

FOR mr = 0 TO 1000
 xx = RND * limx
 yy = RND * limy
 PSET (xx - RND * 3, yy + RND * 3), 1
 PSET (xx - RND * 3, yy + RND * 3), cfore
 PSET (xx - RND * 3, yy + RND * 3), cback
 PSET (xx - RND * 3, yy + RND * 3), 0
NEXT

FOR mr = 0 TO menumax
 drawline mr, mr * 75 + 10 + 1, 355 - 2, 0
 drawline mr, mr * 75 + 10 + 1, 355 - 1, 0
 drawline mr, mr * 75 + 10, 355, 14
NEXT
drawline 0, 10, 355, 1

LINE (0, 8)-(limx, 100), cfore, BF
LINE (0, 10)-(limx, 98), 0, BF

PALETTE 15, 0
VIEW PRINT 2 TO 6
LOCATE 2

PRINT "     CONTACT SCREEN                                          AUTOMAPPING"

FOR xx = 0 TO limx
 FOR yy = 14 TO 14 + 14
  IF POINT(xx, yy) <> 0 THEN
   LINE (xx, 300 + yy * 2)-STEP(0, 2), cfore, BF
  END IF
 NEXT
NEXT

LINE (20, 160)-STEP(160, 160), cfore, BF
clearcontact
LINE (460, 160)-STEP(160, 160), cfore, BF
LINE (460 + 5, 160 + 5)-STEP(160 - 10, 160 - 10), 0, BF

firstmap

LOCATE 4

END SUB

SUB clearview

LINE (cposx - (csize * cview + csize / 2 - cbord), cposy - (csize * cview + csize / 2 - cbord))-(cposx + (csize * cview + csize / 2 - cbord) + csize, cposy + (csize * cview + csize / 2 - cbord) + csize), cfore, BF

END SUB

SUB compmove (snr AS INTEGER)

SHARED spr() AS sprite
SHARED player AS INTEGER
DIM tx AS INTEGER
DIM ty AS INTEGER
DIM tn AS INTEGER

IF spr(snr).direc = 1 THEN
 tx = spr(snr).x1
 ty = spr(snr).y1
 tn = 2
ELSEIF spr(snr).direc = 2 THEN
 tx = spr(snr).x2
 ty = spr(snr).y2
 tn = 1
END IF

IF spr(snr).x < tx THEN
 check 1, 0, snr
ELSEIF spr(snr).x > tx THEN
 check -1, 0, snr
ELSEIF spr(snr).y < ty THEN
 check 0, 1, snr
ELSEIF spr(snr).y > ty THEN
 check 0, -1, snr
ELSE
 spr(snr).direc = tn
END IF

END SUB

SUB contact (nr AS INTEGER)

STATIC met AS INTEGER
SHARED lastnr AS INTEGER
SHARED leave AS INTEGER
SHARED spr() AS sprite
SHARED act() AS STRING
SHARED bag() AS STRING

IF lastnr <> nr THEN
 soundfx 2
 blink "you meet a " + RTRIM$(spr(nr).sex) + " " + RTRIM$(spr(nr).species) + "."
 lastnr = nr

 contactmap
 SELECT CASE RTRIM$(spr(nr).status)

  CASE "very angry"
   blink rword$("he/she", spr(nr).sex) + " starts a fight!"

  CASE "angry"
   IF met = 0 THEN
    blink "<<let me alone>> " + rword$("he/she", spr(nr).sex) + " says."
   ELSE
    blink "<<i said let me alone>> " + rword$("he/she", spr(nr).sex) + " says."
   END IF

  CASE "neutral"
   IF met = 0 THEN
    blink "<<hello>> " + rword$("he/she", spr(nr).sex) + " says."
   END IF

  CASE "friendly"
   IF met = 0 THEN
    blink "<<hello my friend>> " + rword$("he/she", spr(nr).sex) + " says."
   ELSE
    blink "<<don't i know you?>> " + rword$("he/she", spr(nr).sex) + " says."
   END IF

  CASE "very friendly"
   IF met = 0 THEN
    blink "<<hello my friend, what can i do for you?>> " + rword$("he/she", spr(nr).sex) + " says."
   ELSE
    blink "<<nice to meet you again>> " + rword$("he/she", spr(nr).sex) + " says."
   END IF

 END SELECT

 met = true

ELSEIF RND * 50000 < 10 THEN
 
 SELECT CASE RTRIM$(spr(nr).status)
 
  CASE "very angry"
   blink rword$("he/she", spr(nr).sex) + " starts a fight!"

  CASE "angry"
   blink rword$("he/she", spr(nr).sex) + " starts a fight!"
 
  CASE "neutral"
   leave = true
   clearcontact
 
  CASE "friendly"
   blink "<<well, i gotta go now>> " + rword$("he/she", spr(nr).sex) + " says."
   leave = true
   clearcontact

  CASE "very friendly"
   blink "<<nice weather, ain't it>> " + rword$("he/she", spr(nr).sex) + " says."
 
  END SELECT

END IF

IF act(1) <> "none" AND act(1) <> "none" AND act(2) <> "" AND act(2) <> "none" THEN

 DIM w1 AS STRING
 DIM w2 AS STRING
 DIM w3 AS STRING

 SELECT CASE act(1)
 
  CASE "talk"
   act(1) = "none"
  
   blink "the " + RTRIM$(spr(nr).species) + " looks at you."
  
   IF act(2) = "job" THEN
    blink "<<i'm a " + RTRIM$(spr(nr).job) + "...>>"
   ELSEIF act(2) = "name" THEN
    blink "<<i'm called " + RTRIM$(spr(nr).called) + "...>>"
   ELSE
   
    OPEN root + "data\spr\" + form$(lvl) + "\" + form$(nr) + ".tlk" FOR INPUT AS #1
     DO WHILE NOT EOF(1)
      INPUT #1, w1, w2
      w1 = unscribble$(w1)
      w2 = unscribble$(w2)
      IF act(2) = w1 THEN w3 = w2
     LOOP
    CLOSE #1
    
    IF w3 = "" THEN
     blink rword$("he/she", spr(nr).sex) + " doesn't seem to be interested."
    ELSE
     blink ">>" + w3 + "<<"
    END IF
  
   END IF

  CASE "give"
   act(1) = "none"
  
   DIM n AS INTEGER
   DIM place1 AS INTEGER
   DIM place2 AS INTEGER

   blink "you look through your bag..."
   FOR n = 1 TO bagmax
    IF act(2) = bag(player, n) THEN
     place1 = n
     EXIT FOR
    END IF
   NEXT
  
   IF place1 = 0 THEN
    blink "there is not " + rword$("a/an", act(2)) + " " + act(2) + " in your bag."
  
   ELSE
    blink "you offer " + rword$("a/an", act(2)) + " " + act(2) + " to the " + RTRIM$(spr(nr).species) + "."
    blink rword$("he/she", spr(nr).sex) + " takes a look at it..."
   
    OPEN root + "data\spr\" + form$(lvl) + "\" + form$(nr) + ".xch" FOR INPUT AS #1
     DO WHILE NOT EOF(1)
      INPUT #1, w1, w2
      w1 = unscribble$(w1)
      w2 = unscribble$(w2)
      IF act(2) = w1 THEN w3 = w2
     LOOP
    CLOSE #1
   
    IF w3 = "" THEN
     blink ">>i don't need that.<<"
    ELSE
     blink ">>i could need that.<<"
     blink rword$("he/she", spr(nr).sex) + " looks through " + rword$("his/her", spr(nr).sex) + " bag..."
    
     FOR n = 1 TO bagmax
      IF w3 = bag(nr, n) THEN
       place2 = n
       EXIT FOR
      END IF
     NEXT
    
     IF place2 = 0 THEN
      blink ">>problem is i have nothing i would offer you."
     ELSE
      blink ">>i'll give you a " + w3 + "for it."
      blink "you swap the things."
      SWAP bag(player, place1), bag(nr, place2)
     END IF
   
    END IF
  
   END IF

  CASE "attack"
   act(1) = "none"
  
   blink "you look through your bag..."
   FOR n = 1 TO bagmax
    IF act(2) = bag(player, n) THEN
     place1 = n
     EXIT FOR
    END IF
   NEXT
  
   IF place1 = 0 THEN
    blink "there is not " + rword$("a/an", act(2)) + " " + act(2) + " in your bag."
 
   ELSE
   
    IF RTRIM$(spr(nr).status) = "friendly" OR RTRIM$(spr(nr).status) = "very friendly" THEN
     blink "there is no reason to attack a FRIENDLY person."
   
    ELSE
     DIM tname AS STRING
     DIM tval AS INTEGER
     DIM pval AS INTEGER
     DIM eval AS INTEGER

     OPEN root + "data\spr\fival.dat" FOR INPUT AS #1
      DO WHILE NOT EOF(1)
       INPUT #1, tname, tval
       tname = RTRIM$(unscribble$(tname))
       IF tname = bag(player, place1) THEN
        pval = tval
       END IF
      LOOP
     CLOSE #1
   
     OPEN root + "data\spr\fival.dat" FOR INPUT AS #1
      FOR place2 = 0 TO bagmax
       DO WHILE NOT EOF(1)
        INPUT #1, tname, tval
        tname = RTRIM$(unscribble$(tname))
        IF tname = bag(nr, place2) THEN
         eval = tval
        END IF
       LOOP
       IF eval > 0 THEN EXIT FOR
      NEXT
     CLOSE #1
   
     blink "you pull out " + rword$("a/an", bag(player, place1)) + " " + bag(player, place1) + "."
     blink rword$("he/she", spr(nr).sex) + " uses " + rword$("a/an", bag(nr, place2)) + " " + bag(nr, place2) + " to fight."
     blink "you and the " + RTRIM$(spr(nr).species) + " start to fight..."
              
     IF fight%(pval, eval, spr(player).energy, spr(nr).energy) = 0 THEN
      blink "the " + RTRIM$(spr(nr).species) + " was too STRONG for you."
      over
    
     ELSE
      blink "you WIN the fight and kill the " + RTRIM$(spr(nr).species) + "."
      pastespr nr, spr(nr).x, spr(nr).y, 0, 0
      spr(nr).x = 0
      spr(nr).y = 0
     
      IF RTRIM$(spr(nr).status) = "neutral" OR RTRIM$(spr(nr).sex) = "female" THEN
       blink "nevertheless, you don't feel like your attack was justified."
      END IF

     END IF
    
    END IF

   END IF

 END SELECT

END IF

END SUB

SUB contactmap

SHARED spr() AS sprite

cmsz = 4.9

FOR px = 0 - sprsz TO sprsz + sprsz
 FOR py = 0 - sprsz TO sprsz + sprsz
  LINE (73 + px * cmsz, 213 + py * cmsz)-STEP(cmsz, cmsz), POINT(cposx + (spr(snr).x - spr(camera).x) * csize + sprsz / 2 + px, cposy + (spr(snr).y - spr(camera).y) * csize + sprsz / 2 + py), BF
 NEXT
NEXT

END SUB

SUB dark (inpt AS STRING)

DIM nr AS INTEGER

FOR nr = 1 TO 14
 PALETTE nr, 0
NEXT

COLOR 15
LOCATE 15, 40 - INT(LEN(inpt) / 2)
PRINT UCASE$(inpt)

END SUB

SUB default

SHARED spr() AS sprite
SHARED act() AS STRING

IF act(1) <> "none" THEN

 SELECT CASE act(1)

  CASE "attack"
   blink "there is NOTHING HERE to attack."
 
  CASE "magic"
   blink "this was NO MAGIC spell."
 
  CASE "give"
   blink "there is NOBODY HERE to give something to."
 
  CASE "take"
   blink "there is NOTHING here to take."
 
  CASE "talk"
   blink "NOBODY listens to you."

 END SELECT

END IF

END SUB

SUB drawline (nam AS INTEGER, xpos AS INTEGER, ypos AS INTEGER, col AS INTEGER)

DIM nr, nrn AS INTEGER
DIM x1, y1, x2, y2 AS INTEGER

OPEN root + "graphic\menu\" + RTRIM$(LTRIM$(STR$(nam))) + ".dat" FOR INPUT AS #1

INPUT #1, nr
FOR nrn = 2 TO nr STEP 2
 INPUT #1, x1, y1, x2, y2

 LINE (xpos + x1, ypos + y1)-(xpos + x2, ypos + y2), col

NEXT

CLOSE #1

END SUB

SUB drawmap (xspd AS INTEGER, yspd AS INTEGER)

SHARED spr() AS sprite
SHARED mapcol() AS INTEGER
SHARED obj() AS INTEGER

DIM xp AS INTEGER
DIM yp AS INTEGER

IF spr(camera).x - cview >= 0 AND spr(camera).x + cview <= maxx THEN
 IF spr(camera).y - cview >= 0 AND spr(camera).y + cview <= maxy THEN

  IF xspd = 1 THEN
   xp = spr(camera).x + cview
   FOR yp = spr(camera).y - cview TO spr(camera).y + cview
    PSET (465 + xp, 165 + yp), mapcol(obj(xp, yp))
   NEXT
 
  ELSEIF xspd = -1 THEN
   xp = spr(camera).x - cview
   FOR yp = spr(camera).y - cview TO spr(camera).y + cview
    PSET (465 + xp, 165 + yp), mapcol(obj(xp, yp))
   NEXT
 
  ELSEIF yspd = 1 THEN
   yp = spr(camera).y + cview
   FOR xp = spr(camera).x - cview TO spr(camera).x + cview
    PSET (465 + xp, 165 + yp), mapcol(obj(xp, yp))
   NEXT
 
  ELSEIF yspd = -1 THEN
   yp = spr(camera).y - cview
   FOR xp = spr(camera).x - cview TO spr(camera).x + cview
    PSET (465 + xp, 165 + yp), mapcol(obj(xp, yp))
   NEXT
 
  END IF

 END IF
END IF

END SUB

FUNCTION fight% (pval AS INTEGER, eval AS INTEGER, pnrg AS INTEGER, enrg AS INTEGER)

DIM hval AS INTEGER

DO

 IF INT(RND * 2) + 1 = 1 THEN
  blink "your are attacking the enemy!"
  soundfx pval
  hval = INT(RND * 3) + 1
  enrg = enrg - (hval * pval)
 
  IF hval = 1 THEN
   blink "your hit was weak."
  ELSEIF hval = 3 THEN
   blink "your hit was strong."
  END IF
 
  IF enrg <= 0 THEN fight% = 1
 
 ELSE
  blink "you are attacked by your enemy!"
  soundfx eval
  pnrg = pnrg - (INT(RND * 2) * eval)
 
  IF hval = 1 THEN
   blink "you defended the hit well."
  ELSEIF hval = 3 THEN
   blink "you defended the hit badly."
  END IF
 
  IF pnrg <= 0 THEN fight% = 0
 
 END IF

LOOP UNTIL enrg <= 0 OR pnrg <= 0

END FUNCTION

SUB firstmap

SHARED spr() AS sprite
SHARED mapcol() AS INTEGER
SHARED obj() AS INTEGER

DIM xp AS INTEGER
DIM yp AS INTEGER

IF spr(camera).x - cview >= 0 AND spr(camera).x + cview <= maxx THEN
 IF spr(camera).y - cview >= 0 AND spr(camera).y + cview <= maxy THEN

   FOR xp = spr(camera).x - cview TO spr(camera).x + cview
    FOR yp = spr(camera).y - cview TO spr(camera).y + cview
     PSET (465 + xp, 165 + yp), mapcol(obj(xp, yp))
    NEXT
   NEXT
 
 END IF
END IF

END SUB

FUNCTION form$ (inpt AS INTEGER)

form$ = LTRIM$(RTRIM$(LEFT$(STR$(inpt), 8)))

END FUNCTION

SUB found (nr AS INTEGER)

SHARED bag() AS STRING
SHARED spr() AS sprite
SHARED thn() AS thing
SHARED act() AS STRING
SHARED lastnr AS INTEGER

IF lastnr <> nr + 1 THEN
 soundfx 2
 blink "you step on " + rword$("a/an", thn(nr).called) + " " + RTRIM$(thn(nr).called) + "."
 lastnr = nr + 1
END IF

SELECT CASE act(1)

 CASE "take"
  DIM place, bnr AS INTEGER
 
  blink "there is " + rword$("a/an", thn(nr).called) + " " + RTRIM$(thn(nr).called) + "."
  blink "you check out if there is a place in your BAG..."
  FOR bnr = 1 TO bagmax
   IF bag(player, bnr) = "" THEN
    place = bnr
   END IF
  NEXT

  IF place = 0 THEN
   blink "your bag is already FULL."

  ELSE
   blink "you take the " + RTRIM$(thn(nr).called) + "."
   bag(player, place) = thn(nr).called
   act(1) = ""
   clearbuf thn(nr).x, thn(nr).y
   pasteobj thn(nr).x, thn(nr).y
   pastespr player, spr(player).x, spr(player).y, -2, 0
   thn(nr).x = 0
   thn(nr).y = 0
  
  END IF

END SELECT

END SUB

SUB getword

SHARED wordbuf AS STRING
SHARED choice AS STRING
SHARED act() AS STRING
SHARED shown AS INTEGER
STATIC lin AS INTEGER
STATIC side AS INTEGER
DIM letter AS STRING

IF shown = false THEN
 PRINT wordbuf
 LINE (LEN(wordbuf) * 8, 64 + ABS(lin / 100))-(LEN(wordbuf) * 8 + 8, 64 + 13 - ABS(lin / 100)), cfore, BF
 shown = true
END IF

IF lin > 0 THEN
 LINE (LEN(wordbuf) * 8, 64 + ABS(lin / 100))-STEP(8, 0), 0, B
 LINE (LEN(wordbuf) * 8, 64 + 13 - ABS(lin / 100))-STEP(8, 0), 0, B
END IF
lin = lin + 1
IF lin >= 700 THEN lin = -700
LINE (LEN(wordbuf) * 8, 64 + ABS(lin / 100))-STEP(8, 0), cfore, B
LINE (LEN(wordbuf) * 8, 64 + 13 - ABS(lin / 100))-STEP(8, 0), cfore, B

letter = INKEY$

SELECT CASE letter

 CASE ""

 CASE "a" TO "z", " "
  IF LEN(wordbuf) < 78 THEN
   wordbuf = wordbuf + UCASE$(letter)
   LOCATE CSRLIN - 1, LEN(wordbuf)
   PRINT RIGHT$(wordbuf, 1)
   LINE (LEN(wordbuf) * 8, 64 + ABS(lin / 100))-(LEN(wordbuf) * 8 + 8, 64 + 13 - ABS(lin / 100)), cfore, BF
  END IF

 CASE CHR$(8)
  IF LEN(wordbuf) > 1 THEN
   LOCATE CSRLIN - 1, LEN(wordbuf)
   PRINT "   "
   wordbuf = LEFT$(wordbuf, LEN(wordbuf) - 1)
   LINE (LEN(wordbuf) * 8, 64 + ABS(lin / 100))-(LEN(wordbuf) * 8 + 8, 64 + 13 - ABS(lin / 100)), cfore, BF
  END IF

 CASE CHR$(13)
  LOCATE CSRLIN - 1, LEN(wordbuf) + 1
  PRINT "  "
  act(2) = RIGHT$(wordbuf, (LEN(wordbuf) - 1))
  wordbuf = ""
  shown = false
  makeact

 CASE ELSE
  LOCATE CSRLIN - 1, LEN(wordbuf) + 1
  PRINT "  "
  act(1) = ""
  act(2) = ""
  wordbuf = ""
  shown = false
  blink "maybe later..."

END SELECT

END SUB

SUB initspecs

SHARED specs() AS STRING
DIM nr AS INTEGER

OPEN root + "data\spr\defin\1.dat" FOR INPUT AS #1

 FOR nr = 1 TO sprpicmax
  INPUT #1, specs(nr)
  specs(nr) = RTRIM$(unscribble$(specs(nr)))
 NEXT

CLOSE #1

END SUB

FUNCTION keyboard$

SELECT CASE INKEY$
 CASE CHR$(0) + "M": keyboard$ = "east"
 CASE CHR$(0) + "K": keyboard$ = "west"
 CASE CHR$(0) + "P": keyboard$ = "south"
 CASE CHR$(0) + "H": keyboard$ = "north"
 CASE CHR$(13):      keyboard$ = "make"
 CASE CHR$(27):      keyboard$ = "quit"
 CASE " ":           keyboard$ = "next"
 CASE "b":           keyboard$ = "back"
 CASE ELSE:          keyboard$ = "none"
END SELECT

END FUNCTION

SUB loaddefault

SHARED typ() AS INTEGER
SHARED mapcol() AS INTEGER

DIM nr AS INTEGER

OPEN root + "data\default.dat" FOR INPUT AS #1

 FOR nr = 0 TO objmax
  IF NOT EOF(1) THEN INPUT #1, mapcol(nr), typ(nr)
 NEXT

CLOSE #1

END SUB

SUB loadobj (inpt AS INTEGER)

SHARED obj() AS INTEGER

DIM xd, yd AS INTEGER

OPEN root + "data\obj\" + form$(inpt) + ".dat" FOR BINARY AS #1

 FOR xd = 0 TO maxx
 FOR yd = 0 TO maxx
  GET #1, , obj(xd, yd)
 NEXT
 NEXT

CLOSE #1

END SUB

SUB loadpal (pname AS INTEGER)

DIM c, c1, c2, c3 AS INTEGER

OPEN root + "graphic\pal\" + form$(pname) + ".dat" FOR INPUT AS #1
 FOR c = 0 TO 15
  INPUT #1, c1
  INPUT #1, c2
  INPUT #1, c3
  PALETTE c, 2 ^ 16 * c1 + 2 ^ 8 * c2 + c3
 NEXT
CLOSE #1

END SUB

FUNCTION loadpic% (npic AS STRING)
            
SHARED pic1(), pic2(), pic3() AS INTEGER
SHARED pic4(), pic5(), pic6() AS INTEGER
SHARED pic7(), pic8(), pic9() AS INTEGER
SHARED picbuffer() AS INTEGER

DIM pnr AS INTEGER
DIM lpc AS INTEGER

FOR pnr = 1 TO pmax
 IF picbuffer(pnr) = 0 THEN
  lpc = pnr
  EXIT FOR
 END IF
NEXT

IF lpc = 0 THEN lpc = INT(RND * pmax) + 1

SELECT CASE lpc
 CASE 1
  DEF SEG = VARSEG(pic1(0))
  BLOAD root + "graphic\obj\" + npic + ".GRH", VARPTR(pic1(0))
 CASE 2
  DEF SEG = VARSEG(pic2(0))
  BLOAD root + "graphic\obj\" + npic + ".GRH", VARPTR(pic2(0))
 CASE 3
  DEF SEG = VARSEG(pic3(0))
  BLOAD root + "graphic\obj\" + npic + ".GRH", VARPTR(pic3(0))
 CASE 4
  DEF SEG = VARSEG(pic4(0))
  BLOAD root + "graphic\obj\" + npic + ".GRH", VARPTR(pic4(0))
 CASE 5
  DEF SEG = VARSEG(pic5(0))
  BLOAD root + "graphic\obj\" + npic + ".GRH", VARPTR(pic5(0))
 CASE 6
  DEF SEG = VARSEG(pic6(0))
  BLOAD root + "graphic\obj\" + npic + ".GRH", VARPTR(pic6(0))
 CASE 7
  DEF SEG = VARSEG(pic7(0))
  BLOAD root + "graphic\obj\" + npic + ".GRH", VARPTR(pic7(0))
 CASE 8
  DEF SEG = VARSEG(pic8(0))
  BLOAD root + "graphic\obj\" + npic + ".GRH", VARPTR(pic8(0))
 CASE 9
  DEF SEG = VARSEG(pic9(0))
  BLOAD root + "graphic\obj\" + npic + ".GRH", VARPTR(pic9(0))
END SELECT

DEF SEG
loadpic% = lpc

END FUNCTION

SUB loadroot

OPEN "root.txt" FOR INPUT AS #1
 INPUT #1, root
CLOSE #1

END SUB

SUB loadspr (nam AS INTEGER)

SHARED spr() AS sprite
SHARED bag() AS STRING
DIM nrx, wordnr AS INTEGER
DIM nrn AS STRING
DIM nr AS INTEGER
DIM wordfor(1 TO 5, 1 TO 20) AS STRING

FOR wordnr = 1 TO 5
 OPEN root + "data\spr\defin\" + form$(wordnr) + ".dat" FOR INPUT AS #1
  FOR nrx = 1 TO 20
   INPUT #1, nrn
   wordfor(wordnr, nrx) = RTRIM$(unscribble$(nrn))
   IF wordfor(wordnr, nrx) = "-" THEN EXIT FOR
  NEXT
 CLOSE #1
NEXT

FOR nr = 0 TO 5 'sprmax - 1 '###
 OPEN root + "data\spr\" + form$(nam) + "\" + form$(nr) + ".spr" FOR INPUT AS #1
  INPUT #1, spr(nr).called
  spr(nr).called = unscribble$(spr(nr).called)
  INPUT #1, spr(nr).x1
  INPUT #1, spr(nr).y1
  INPUT #1, spr(nr).x2
  INPUT #1, spr(nr).y2
  
  INPUT #1, nrx
  spr(nr).species = wordfor(1, nrx)
  INPUT #1, nrx
  spr(nr).sex = wordfor(2, nrx)
  INPUT #1, nrx
  spr(nr).job = wordfor(3, nrx)
  INPUT #1, spr(nr).energy
  INPUT #1, nrx
  spr(nr).intel = wordfor(4, nrx)
  INPUT #1, nrx
  spr(nr).status = wordfor(5, nrx)

  spr(nr).x = spr(nr).x1
  spr(nr).y = spr(nr).y1
  spr(nr).direc = 1
 CLOSE #1
NEXT

spr(camera).x = spr(player).x
spr(camera).y = spr(player).y
spr(camera).species = ""

FOR nr = 0 TO sprmax - 1
 OPEN root + "data\spr\" + form$(nam) + "\" + form$(nr) + ".bag" FOR INPUT AS #1
  FOR nrx = 1 TO bagmax
   INPUT #1, bag(nr, nrx)
   bag(nr, nrx) = unscribble$(bag(nr, nrx))
  NEXT
 CLOSE #1
NEXT

END SUB

SUB loadsprpic

SHARED sprpic() AS INTEGER
DIM px, py, sprpicx, sprpics, sprpicf AS INTEGER
DIM nr AS INTEGER
DIM side AS INTEGER

FOR nr = 1 TO sprpicmax
 FOR side = 1 TO 4
 
  OPEN root + "\graphic\spr\0.dat" FOR INPUT AS #1
  OPEN root + "\graphic\spr\" + form$(nr) + "s" + form$(side) + ".dat" FOR INPUT AS #2

   FOR px = 0 TO sprsz
   FOR py = 0 TO sprsz
    INPUT #1, sprpics
    INPUT #2, sprpicx
   
    IF sprpicx = 0 THEN
     sprpicf = sprpics
    ELSE
     sprpicf = sprpicx
    END IF
  
    sprpic(nr, side, px, py) = sprpicf
   NEXT
   NEXT

  CLOSE #1
  CLOSE #2

 NEXT
NEXT

END SUB

SUB loadthn (nr AS INTEGER)

SHARED thn() AS thing

OPEN root + "data\spr\thn" + form$(nr) + ".dat" FOR INPUT AS #1
 FOR nr = 0 TO thnmax
  INPUT #1, thn(nr).called, thn(nr).x, thn(nr).y
 NEXT
CLOSE #1

END SUB

SUB make (chosen AS INTEGER)

SHARED wordbuf AS STRING
SHARED spr() AS sprite
SHARED thn() AS thing
SHARED act() AS STRING
SHARED bag() AS STRING

act(1) = marked$(chosen)
act(2) = "none"

SELECT CASE act(1)

 CASE "status"
  blink "you are " + RTRIM$(spr(player).called) + ", " + rword$("he/she", spr(player).species) + RTRIM$(spr(player).species) + " " + RTRIM$(spr(player).job) + "."
  blink "your current location is the world of gnor. if people had something like"
  blink "an ENERGY LEVEL then yours would be " + LTRIM$(STR$(spr(player).energy)) + "."
  PRINT "YOUR BAG CONTAINS: ";
  FOR nr = 1 TO bagmax
   IF bag(player, nr) <> "" THEN PRINT UCASE$(rword$("a/an", bag(player, nr)) + " " + bag(player, nr) + "... ");
  NEXT

 CASE "quit"
  blink "REALLY quit?"
  wordbuf = " "

 CASE "take"
  blink "you look around."
 
 CASE "give"
  blink "what do you want to GIVE?"
  wordbuf = " "

 CASE "attack"
  blink "what do you want to ATTACK with?"
  wordbuf = " "

 CASE "magic"
  blink "which SPELL you want to do?"
  wordbuf = " "

 CASE "talk"
  blink "what do you want to TALK about?"
  wordbuf = " "

 END SELECT

END SUB

SUB makeact

SHARED wordbuf AS STRING
SHARED spr() AS sprite
SHARED act() AS STRING

SELECT CASE act(1)

 CASE "quit"
  IF LCASE$(LEFT$(act(2), 1)) = "y" THEN
   blink "hope you ENJOYED the game."
   SLEEP 2
   END
  ELSE
   blink "i'll take that as a NO."
  END IF

 CASE "give"
  act(2) = parser$(act(2))
  IF act(2) = "help" THEN
   blink "enter the object you want to GIVE to the person"
   blink "you met. you can only give things you have. if"
   blink "you want to know what your bag contains choose the"
   blink "STATUS item on the menubar."
   act(1) = "none"
  ELSEIF act(2) = "" THEN
   blink "you have to be more SPECIFIC. type HELP if you"
   blink "want to know more about GIVING."
   act(1) = "none"
  END IF

 CASE "attack"
  act(2) = parser$(act(2))
  IF act(2) = "help" THEN
   blink "you have to define your weapon if you want to"
   blink "attack someone."
   act(1) = "none"
  ELSEIF act(2) = "" THEN
   blink "you have to be more SPECIFIC. type HELP if you"
   blink "want to know more about FIGHTING."
   act(1) = "none"
  END IF
 
 CASE "magic"
  act(2) = parser$(act(2))
  IF act(2) = "help" THEN
   blink "just enter a spell you remember if you might think"
   blink "it is useful in a situation. HOWEVER, magic spells"
   blink "lower your energy."
   act(1) = "none"
  ELSEIF act(2) = "" THEN
   blink "you have to be more SPECIFIC. type HELP if you"
   blink "want to know more about MAGIC SPELLS."
   act(1) = "none"
  ELSE
   blink "you mutter some words..."
  END IF

 CASE "talk"
  act(2) = parser$(act(2))
  IF act(2) = "help" THEN
   blink "to get useful information you have to enter a TOPIC that"
   blink "you think the other person might be interested in. you"
   blink "could for example talk about his name, job, or just things"
   blink "in general."
   act(1) = "none"
  ELSEIF act(2) = "" THEN
   blink "you have to be more SPECIFIC. type HELP if you"
   blink "want to know more about TALKING."
   act(1) = "none"
  ELSE
   blink "you mutter some words..."
  END IF

 END SELECT

END SUB

FUNCTION marked$ (chosen AS INTEGER)

SELECT CASE chosen
 CASE 0: marked$ = "take"
 CASE 1: marked$ = "give"
 CASE 2: marked$ = "attack"
 CASE 3: marked$ = "magic"
 CASE 4: marked$ = "talk"
 CASE 5: marked$ = "status"
 CASE 6: marked$ = "options"
 CASE 7: marked$ = "quit"
END SELECT

END FUNCTION

SUB maxload

OPEN root + "data\obj\max.dat" FOR INPUT AS #1
 INPUT #1, objmax
CLOSE #1

OPEN root + "data\spr\1\max.dat" FOR INPUT AS #1
 INPUT #1, sprmax
CLOSE #1

player = 0
camera = sprmax

END SUB

SUB old

'pmem = 4 + INT(((csize + 1) + 7) / 8) * 4 * (csize + 1)

'TYPE thing
' carried AS INTEGER
' p1      AS INTEGER
' p2      AS INTEGER
'END TYPE

'DIM stuff(20)           AS thing

END SUB

SUB options

STATIC menu AS INTEGER
STATIC lastchoice AS STRING
SHARED choice AS STRING
SHARED act() AS STRING
DIM lastmenu AS INTEGER

act(1) = "none"

SELECT CASE choice

 CASE "next"
  IF menu < menumax THEN
   menu = menu + 1
   lastmenu = menu - 1
  ELSE
   menu = 0
   lastmenu = menumax
  END IF
  drawline lastmenu, lastmenu * 75 + 10, 355, 14
  drawline menu, menu * 75 + 10, 355, 1
 
 CASE "back"
  IF menu > 0 THEN
   menu = menu - 1
   lastmenu = menu + 1
  ELSE
   menu = menumax
   lastmenu = 0
  END IF
  drawline lastmenu, lastmenu * 75 + 10, 355, 14
  drawline menu, menu * 75 + 10, 355, 1

 CASE "make"
  soundfx 1
  make menu

 CASE "quit"
  soundfx 1
  make 7
 
END SELECT

END SUB

SUB over

SLEEP 2
blink "you are dead. game over."
SLEEP 2
END

END SUB

FUNCTION parser$ (inpt AS STRING)

inpt = LCASE$(RTRIM$(LTRIM$(inpt)))

SELECT CASE inpt

 CASE "?", "i don't know", "help me", "give me a hint", "please help"
  inpt = "help"

 'CASE "hand", "bare hands", "nothing", "body"
 ' inpt = "hands"

 CASE "his job", "work", "mission"
  inpt = "job"

 CASE "his name", "title", "identity"
  inpt = "name"

 CASE "nothing in particular", "things in general", "weather"
  inpt = "anything"

END SELECT

parser$ = inpt

END FUNCTION

SUB pasteobj (xpos AS INTEGER, ypos AS INTEGER)

SHARED mapcol() AS INTEGER
SHARED obj() AS INTEGER
SHARED buffer() AS INTEGER
SHARED spr() AS sprite

IF xpos - spr(camera).x >= -cview AND xpos - spr(camera).x <= cview THEN
IF ypos - spr(camera).y >= -cview AND ypos - spr(camera).y <= cview THEN

 IF xpos >= 0 AND xpos <= maxx AND ypos >= 0 AND ypos <= maxy THEN
  
  DIM pic AS INTEGER
  pic = obj(xpos, ypos)
   
  IF pic <> buffer(xpos - spr(camera).x, ypos - spr(camera).y) THEN
   buffer(xpos - spr(camera).x, ypos - spr(camera).y) = pic
   putpic cposx + (xpos - spr(camera).x) * csize, cposy + (ypos - spr(camera).y) * csize, pic
  END IF
  
 ELSE
  LINE (cposx + (xpos - spr(camera).x) * csize, cposy + (ypos - spr(camera).y) * csize)-STEP(csize, csize), 0, BF
  clearbuf xpos, ypos
 END IF
  
END IF
END IF

END SUB

SUB pastespr (snr AS INTEGER, xpos AS INTEGER, ypos AS INTEGER, xspd AS INTEGER, yspd AS INTEGER)

STATIC lastpos AS INTEGER
SHARED spr() AS sprite
SHARED sprpic() AS INTEGER
SHARED lastnr AS INTEGER
SHARED leave AS INTEGER
SHARED sprpicbuf() AS INTEGER

IF xpos - spr(camera).x >= -cview AND xpos - spr(camera).x <= cview THEN
IF ypos - spr(camera).y >= -cview AND ypos - spr(camera).y <= cview THEN

 DIM cspecnr, px, py, pxpos, pypos, col, side, xad, yad AS INTEGER

 IF xspd = 1 THEN
  side = 1
 ELSEIF yspd = 1 THEN
  side = 2
 ELSEIF xspd = -1 THEN
  side = 3
 ELSEIF yspd = -1 THEN
  side = 4
 ELSE
  IF snr = player THEN
   IF lastpos = 0 THEN lastpos = INT(RND * 4) + 1
   side = lastpos
  ELSE
   side = INT(RND * 4) + 1
  END IF
 END IF

 IF snr = player THEN
  IF lastnr <> false THEN clearcontact '###
  lastpos = side
  lastnr = false
  leave = false
  xad = -sprsz / 2
  yad = -sprsz / 2
 ELSE
  xad = sprsz / 2
  yad = sprsz / 2
 END IF

 pxpos = cposx + (xpos - spr(camera).x) * csize + sprsz / 2
 pypos = cposy + (ypos - spr(camera).y) * csize + sprsz / 2

 cspecnr = specnr%(spr(snr).species)

 IF xspd <> 0 OR yspd <> 0 THEN
  FOR px = 0 TO sprsz
  FOR py = 0 TO sprsz
   sprpicbuf(snr, px, py) = POINT(pxpos + px + xad, pypos + py + yad)
   col = sprpic(cspecnr, side, px, py)
   IF col > 0 THEN
    PSET (pxpos + px + xad, pypos + py + yad), col
   END IF
  NEXT
  NEXT
 
 ELSE
  FOR px = 0 TO sprsz
  FOR py = 0 TO sprsz
   PSET (pxpos + px + xad, pypos + py + yad), sprpicbuf(snr, px, py)
  NEXT
  NEXT

 END IF

END IF
END IF

END SUB

SUB pastethn (snr AS INTEGER, xpos AS INTEGER, ypos AS INTEGER)

SHARED spr() AS sprite
SHARED thnpicbuf() AS INTEGER
STATIC col AS INTEGER

IF xpos - spr(camera).x >= -cview AND xpos - spr(camera).x <= cview THEN
IF ypos - spr(camera).y >= -cview AND ypos - spr(camera).y <= cview THEN

 DIM px, py, pxpos, pypos, xad, yad AS INTEGER

 SELECT CASE INT(RND * 2)
  CASE 0: col = 1
  CASE 1: col = cfore
  CASE 2: col = cback
 END SELECT

 xad = csize / 2
 yad = csize / 2

 pxpos = cposx + (xpos - spr(camera).x) * csize + thnsz / 2
 pypos = cposy + (ypos - spr(camera).y) * csize + thnsz / 2

 CIRCLE (pxpos + xad + thnsz / 2, pypos + yad + thnsz / 2), thnsz / 2, col
 PAINT STEP(0, 0), 0, col

END IF
END IF

END SUB

SUB putpic (xp AS INTEGER, yp AS INTEGER, nm AS INTEGER)

SHARED pic1(), pic2(), pic3() AS INTEGER
SHARED pic4(), pic5(), pic6() AS INTEGER
SHARED pic7(), pic8(), pic9() AS INTEGER
SHARED picbuffer() AS INTEGER

DIM pnr AS INTEGER
DIM lpc AS INTEGER

FOR pnr = 1 TO pmax
 IF nm = picbuffer(pnr) THEN
  lpc = pnr
  EXIT FOR
 END IF
NEXT

IF lpc = 0 THEN

 lpc = loadpic%(RTRIM$(LTRIM$(STR$(nm))))
 picbuffer(lpc) = nm

END IF

SELECT CASE lpc
CASE 1: PUT (xp, yp), pic1, PSET
CASE 2: PUT (xp, yp), pic2, PSET
CASE 3: PUT (xp, yp), pic3, PSET
CASE 4: PUT (xp, yp), pic4, PSET
CASE 5: PUT (xp, yp), pic5, PSET
CASE 6: PUT (xp, yp), pic6, PSET
CASE 7: PUT (xp, yp), pic7, PSET
CASE 8: PUT (xp, yp), pic8, PSET
CASE 9: PUT (xp, yp), pic9, PSET
END SELECT

END SUB

FUNCTION rword$ (word1 AS STRING, word2 AS STRING)

word2 = RTRIM$(word2)

SELECT CASE word1

 CASE "he/she"
  SELECT CASE word2
   CASE "male":   rword$ = "he"
   CASE "female": rword$ = "she"
   'CASE ELSE:    rword$ = "it"
  END SELECT
    
 CASE "his/her"
  SELECT CASE word2
   CASE "male":   rword$ = "his"
   CASE "female": rword$ = "her"
   'CASE ELSE:    rword$ = "its"
  END SELECT
 
 CASE "a/an"
  SELECT CASE LEFT$(word2, 1)
   CASE "a", "e", "i", "o", "u": rword$ = "an"
   CASE ELSE:                    rword$ = "a"
  END SELECT

END SELECT

END FUNCTION

SUB scroll (blue AS INTEGER, green AS INTEGER, red AS INTEGER, text AS STRING, cview AS INTEGER, csize AS INTEGER, speed AS INTEGER, mirror AS INTEGER, rad AS INTEGER, swirl AS INTEGER, rotate AS INTEGER)

CLS

DIM col(15, 2), clr(2) AS INTEGER
DIM cp, xp, yp AS INTEGER

clr(0) = blue
clr(1) = green
clr(2) = red

FOR atb = 1 TO 15

 FOR cr = 0 TO 2
  IF clr(cr) = 0 THEN
   col(atb, cr) = INT(atb * INT(63 / 15))
  ELSE
   col(atb, cr) = INT(63 - 63 / (atb + 1) + 1)
  END IF
 NEXT

 PALETTE atb, 2 ^ 16 * col(atb, 0) + 2 ^ 8 * col(atb, 1) + col(atb, 2)

NEXT

LOCATE 1
COLOR 1
PALETTE 1, 0

PRINT SPACE$(cview * 2) + UCASE$(LEFT$(text, 79 - cview * 4)) + SPACE$(cview * 2)

FOR cp = cview * 8 TO (LEN(text) + cview * 4) * 8 - cview * 8 STEP speed
 FOR xp = -cview * 8 TO cview * 8
  FOR yp = 2 TO 11
   LINE (limx / 2 + xp * csize + (rad * yp), limy / 2 + (((ABS(13 * mirror - yp)) * (rotate * (xp / 20) + 1)) * csize) - (rad * xp) + ((xp / 2) ^ 2) * swirl)-STEP(csize, csize), POINT(cp + xp, yp) * (15 - yp), BF
  NEXT
 NEXT
 IF INKEY$ <> "" THEN EXIT FOR
NEXT

END SUB

SUB slow (i AS INTEGER)

DIM dummy1, dummy2 AS INTEGER

FOR dummy1 = 1 TO i * 100
FOR dummy2 = 1 TO i * 100
NEXT
NEXT

END SUB

SUB soundfx (freq AS INTEGER)

DIM nr AS INTEGER

FOR nr = -freq * 100 TO freq * 100 STEP 10
 SOUND 600 - ABS(nr), .03
NEXT

END SUB

FUNCTION specnr% (inpt AS STRING)

SHARED specs() AS STRING

SELECT CASE RTRIM$(inpt)
 CASE specs(1): specnr% = 1
 CASE specs(2): specnr% = 2
 CASE specs(3): specnr% = 3
 CASE specs(4): specnr% = 4
 CASE specs(5): specnr% = 5
 'CASE ELSE: specnr% = 1
END SELECT

END FUNCTION

SUB sprbird

SHARED spr() AS sprite

IF INT(RND * 100) < 100 THEN

 IF spr(camera).x < spr(player).x - cmore THEN
  check 1, 0, camera
 ELSEIF spr(camera).x > spr(player).x + cmore THEN
  check -1, 0, camera
 ELSEIF spr(camera).y < spr(player).y - cmore THEN
  check 0, 1, camera
 ELSEIF spr(camera).y > spr(player).y + cmore THEN
  check 0, -1, camera
 END IF

END IF

END SUB

SUB sprcomp (snr AS INTEGER)

SHARED leave AS INTEGER
SHARED spr() AS sprite
SHARED player AS INTEGER

IF spr(snr).x = spr(player).x AND spr(snr).y = spr(player).y AND leave = false THEN

 contact (snr)

ELSEIF INT(RND * 160) > 158 THEN

 compmove (snr)

END IF

END SUB

SUB spruser

SHARED choice AS STRING

SELECT CASE choice
 CASE "east": check 1, 0, player
 CASE "west":  check -1, 0, player
 CASE "south": check 0, 1, player
 CASE "north": check 0, -1, player
END SELECT

END SUB

SUB title

scroll 1, 1, 0, "shadow over gnor", 2, 5, 1, 0, 0, 1, 0
scroll 1, 0, 0, "(c) 1997 by philipp lenssen", 2, 5, 1, 0, -1, 0, 0

END SUB

FUNCTION unscribble$ (word AS STRING)

DIM l AS STRING

FOR nr = 1 TO LEN(word)
 l = MID$(word, nr, 1)
 l = CHR$(ASC(l) - nr)
 MID$(word, nr, 1) = l
NEXT

unscribble$ = word

END FUNCTION

