#include <stdio.h>
#include <stdlib.h>

struct riffHeader
{
	char riffId[4];
	unsigned long len;
};

struct waveHeader
{
	char waveId[4];
	char fmtId[4];
	unsigned long len;
	unsigned short format;
	unsigned short channels;
	unsigned long freq;
	unsigned long bps;
	unsigned short blockAlign;
	unsigned short fspec;
};

struct dataHeader
{
	char dataId[4];
	unsigned long dataLen;
};

struct riffHeader rHead;
struct waveHeader wHead;
struct dataHeader dHead;
int bits;

char tempName[80];
char tempName2[80];

int shorten=0;
int loop=0;
long fadeRate=-0x80000000; /* instant cut-off */

signed short logTable[256]=
{
	0      ,14     ,28     ,42     ,57     ,72     ,88     ,104    ,
	121    ,139    ,157    ,176    ,196    ,216    ,237    ,259    ,
	282    ,305    ,329    ,354    ,380    ,407    ,435    ,464    ,
	494    ,524    ,557    ,590    ,624    ,660    ,696    ,735    ,
	774    ,815    ,857    ,901    ,947    ,994    ,1043   ,1093   ,
	1145   ,1199   ,1256   ,1314   ,1374   ,1436   ,1501   ,1567   ,
	1637   ,1708   ,1783   ,1859   ,1939   ,2021   ,2107   ,2195   ,
	2287   ,2382   ,2480   ,2582   ,2687   ,2796   ,2909   ,3026   ,
	3147   ,3273   ,3403   ,3538   ,3677   ,3821   ,3971   ,4126   ,
	4286   ,4452   ,4625   ,4803   ,4987   ,5178   ,5376   ,5581   ,
	5794   ,6014   ,6241   ,6477   ,6721   ,6974   ,7236   ,7508   ,
	7789   ,8080   ,8381   ,8693   ,9016   ,9351   ,9698   ,10057  ,
	10429  ,10814  ,11213  ,11626  ,12054  ,12497  ,12956  ,13431  ,
	13923  ,14433  ,14961  ,15508  ,16074  ,16660  ,17267  ,17896  ,
	18548  ,19222  ,19921  ,20645  ,21394  ,22170  ,22974  ,23806  ,
	24668  ,25561  ,26486  ,27443  ,28435  ,29462  ,30526  ,31628  ,
	-32767 ,-31628 ,-30526 ,-29462 ,-28435 ,-27443 ,-26486 ,-25561 ,
	-24668 ,-23806 ,-22974 ,-22170 ,-21394 ,-20645 ,-19921 ,-19222 ,
	-18548 ,-17896 ,-17267 ,-16660 ,-16074 ,-15508 ,-14961 ,-14433 ,
	-13923 ,-13431 ,-12956 ,-12497 ,-12054 ,-11626 ,-11213 ,-10814 ,
	-10429 ,-10057 ,-9698  ,-9351  ,-9016  ,-8693  ,-8381  ,-8080  ,
	-7789  ,-7508  ,-7236  ,-6974  ,-6721  ,-6477  ,-6241  ,-6014  ,
	-5794  ,-5581  ,-5376  ,-5178  ,-4987  ,-4803  ,-4625  ,-4452  ,
	-4286  ,-4126  ,-3971  ,-3821  ,-3677  ,-3538  ,-3403  ,-3273  ,
	-3147  ,-3026  ,-2909  ,-2796  ,-2687  ,-2582  ,-2480  ,-2382  ,
	-2287  ,-2195  ,-2107  ,-2021  ,-1939  ,-1859  ,-1783  ,-1708  ,
	-1637  ,-1567  ,-1501  ,-1436  ,-1374  ,-1314  ,-1256  ,-1199  ,
	-1145  ,-1093  ,-1043  ,-994   ,-947   ,-901   ,-857   ,-815   ,
	-774   ,-735   ,-696   ,-660   ,-624   ,-590   ,-557   ,-524   ,
	-494   ,-464   ,-435   ,-407   ,-380   ,-354   ,-329   ,-305   ,
	-282   ,-259   ,-237   ,-216   ,-196   ,-176   ,-157   ,-139   ,
	-121   ,-104   ,-88    ,-72    ,-57    ,-42    ,-28    ,-14
};

unsigned char tempTable[65536];

void BuildTable(void)
{
	int i,j,k,q,l,n;
	signed short p;
	FILE *stream;

	stream=fopen("temptab.dat","rb");
	if(stream)
	{
		fread(tempTable,1,65536,stream);
		fclose(stream);
		return;
	}

	for(j=0;j<65536;j++)
	{
		int a,b,c,d;

		p=(signed short)(j&0xFFFF);
		q=p;

		for(i=0;i<256;i++)
		{
			d=q-logTable[i];
			if(d<0) d=-d;

			if(i==0 || d<b)
			{
				b=d;
				a=i;
			}
		}

		tempTable[j]=a;
	}

	stream=fopen("temptab.dat","wb");
	if(stream)
	{
		fwrite(tempTable,1,65536,stream);
		fclose(stream);
	}
}


void ParseCmd(int argc, char **argv)
{
	int i;

	for(i=2;i<argc;i++)
	{
		if(argv[i][0]=='-')
		{
			if(!stricmp(argv[i]+1,"shorten"))
			{
				shorten=atoi(argv[i+1]);
				i++;
			}
			else if(!stricmp(argv[i]+1,"loop"))
			{
				loop=1;
			}
			else if(!stricmp(argv[i]+1,"fade"))
			{
				fadeRate=atoi(argv[i+1]);
				i++;
			}
			else
			{
				printf("Invalid argument: %s\n",argv[i]);
				exit(1);
			}
		}
	}
}

void main(int argc,char **argv)
{
	FILE *in,*out,*out2;
	int i,j;
	unsigned long hi;
	signed char lo;

	BuildTable();

	ParseCmd(argc,argv);


	in=fopen(argv[1],"rb");
	if(!in) exit(1);

	for(i=0;argv[1][i];i++)
	{
		if(i==':') break;
	}
	if(!argv[1][i]) i=0;
	else i++;
	j=0;
	for(;argv[1][i] && argv[1][i]!='.';i++)
	{
		tempName[j++]=argv[1][i];
	}
	tempName[j]=0;


	sprintf(tempName2,"%s.08",tempName);

	out=fopen(tempName2,"wb");
	if(!out)
	{
		printf("can't open output for 8-bit\n");
		exit(1);
	}

	sprintf(tempName2,"%s.16",tempName);
	out2=fopen(tempName2,"wb");
	if(!out)
	{
		printf("can't open output for 16-bit\n");
		exit(1);
	}

	fread(&rHead,1,sizeof(struct riffHeader),in);

	if(rHead.riffId[0]!='R' ||
	   rHead.riffId[1]!='I' ||
	   rHead.riffId[2]!='F' ||
	   rHead.riffId[3]!='F')
	{
		printf("Not a RIFF file\n");
		exit(1);
	}

	fread(&wHead,1,sizeof(struct waveHeader),in);

	if(wHead.waveId[0]!='W' ||
	   wHead.waveId[1]!='A' ||
	   wHead.waveId[2]!='V' ||
	   wHead.waveId[3]!='E')
	{
		printf("Not a WAVE file\n");
		exit(1);
	}

	printf("Format      : %04x\n",wHead.format);
	printf("Channels    : %d\n",wHead.channels);
	printf("Freq        : %d\n",wHead.freq);
	printf("BPS         : %d\n",wHead.bps);
	printf("Block align : %d\n",wHead.blockAlign);
	printf("Format-spec : %04x\n",wHead.fspec);

	if(wHead.format!=1)
	{
		printf("Unknown format\n");
		exit(1);
	}

	bits=(wHead.blockAlign * 8);
	printf("%d bits per sample\n",bits);

	fread(&dHead,1,sizeof(struct dataHeader),in);
	if(dHead.dataId[0]!='d' ||
	   dHead.dataId[1]!='a' ||
	   dHead.dataId[2]!='t' ||
	   dHead.dataId[3]!='a')
	{
		printf("Invalid DATA header\n");
		exit(1);
	}

	fwrite("BS08",1,4,out);
	fwrite("BS16",1,4,out2);

	i=dHead.dataLen/wHead.blockAlign;
	fwrite(&i,1,4,out);
	fwrite(&i,1,4,out2);

	i=0;
	fwrite(&i,1,4,out);
	fwrite(&i,1,4,out2);

	if(!loop)
	{
		i=0;
		fwrite(&i,1,4,out);
		fwrite(&i,1,4,out2);
	}
	else
	{
		i=dHead.dataLen/wHead.blockAlign;
		fwrite(&i,1,4,out);
		fwrite(&i,1,4,out2);
	}
	fwrite(&wHead.freq,1,4,out);
	fwrite(&wHead.freq,1,4,out2);

	fwrite(&fadeRate,1,4,out);
	fwrite(&fadeRate,1,4,out2);

	for(i=0;i<dHead.dataLen-(shorten * wHead.blockAlign);i+=wHead.blockAlign)
	{
		if(bits==8)
		{
			j=fgetc(in);
			hi=((unsigned long)j)<<8;
			lo=j;
		}
		else
		{
			j=fgetc(in); j+=fgetc(in)<<8;
			hi=j;
			lo=j>>8;
		}

		fputc(lo,out);
		fputc(tempTable[hi],out2);
	}

	fclose(out);
	fclose(out2);
	fclose(in);
}

