'---- -  
'             ** SMILEYS SMALL ADVENTURE (GAME) **
'                  Created by Davey W Taylor
'
' This is my latest game. I have not yet implemented any sound or
' music since I can't get the sound to work properly and my music
' routines are still in beta stage. I have only created one level
' so you will have to look at CVMAP.BAS for information on how to
' create your own levels.                   Please send comments!
'---     
' ** If you have any comments / suggestions / questions, my email is: **
' ** audio.squad@mailbox.swipnet.se                         <<< EMAIL **

DECLARE SUB ShowScore ()
DECLARE SUB ShowKeys ()
DECLARE SUB ShowLives ()
DECLARE SUB WipeScreen ()
DECLARE SUB PlayGame ()
DECLARE SUB Display (XPos%, YPos%)
DECLARE SUB SetPal (pal$)
DECLARE SUB LoadLevel ()
DECLARE FUNCTION Hit! (x%, y%)

ON ERROR GOTO NoScreen
WIDTH 80, 25
ON ERROR GOTO Unknown

CLS
COLOR 0, 2
PRINT STRING$(32, 32);
PRINT "SSA Startup v1.0";
PRINT STRING$(32, 32)
COLOR 7, 0
PRINT

PRINT "Allocating memory... ";
ON ERROR GOTO NoMem
DIM SPal AS STRING * 768
DIM SHARED MPal AS STRING * 768
DIM SSALogo(1 TO 142, 1 TO 85) AS INTEGER
DIM PreCal(1 TO 85) AS INTEGER
DIM SHARED Sprites(1 TO 2600) AS INTEGER
DIM SHARED Masking(1 TO 2600) AS INTEGER
DIM SHARED LevelMap(1 TO 128, 1 TO 64) AS STRING * 2
DIM SHARED Level%, Score%, Lives%
DIM SHARED RedKeys%, GreenKeys%, BlueKeys%
DIM SHARED PlayerX%, PlayerY%
ON ERROR GOTO Unknown
PRINT "OK!"

PRINT "Loading sprites      [                    ]";
LOCATE , 23
ON ERROR GOTO NoFile
OPEN "Sprites.img" FOR INPUT AS #1: CLOSE #1
ON ERROR GOTO Unknown
OPEN "Sprites.img" FOR BINARY ACCESS READ AS #1

p% = 1
FOR s% = 1 TO 20
 Sprites(p%) = 128
 Sprites(p% + 1) = 16
 p% = p% + 2
 FOR p% = p% TO p% + 127
  GET #1, , Sprites(p%)
 NEXT p%
 PRINT ".";
NEXT s%
CLOSE #1
PRINT

PRINT "Masking sprites      [                    ]";
LOCATE , 23
p% = 1
FOR s% = 1 TO 20
 Masking(p%) = 128
 Masking(p% + 1) = 16
 p% = p% + 2
 FOR p% = p% TO p% + 127
  x$ = MKI$(Sprites(p%))
  IF ASC(MID$(x$, 1, 1)) = 0 THEN MID$(x$, 1, 1) = CHR$(255) ELSE MID$(x$, 1, 1) = CHR$(0)
  IF ASC(MID$(x$, 2, 1)) = 0 THEN MID$(x$, 2, 1) = CHR$(255) ELSE MID$(x$, 2, 1) = CHR$(0)
  Masking(p%) = CVI(x$)
 NEXT p%
 PRINT ".";
NEXT s%
PRINT

PRINT "Loading palettes     [0  , 0  ]";
ON ERROR GOTO NoFile
OPEN "Sprites.pal" FOR INPUT AS #1: CLOSE #1
ON ERROR GOTO Unknown
OPEN "Sprites.pal" FOR BINARY ACCESS READ AS #1

rgb$ = STRING$(3, 0)
FOR p% = 0 TO 255
 GET #1, , rgb$
 MID$(SPal, 1 + p% * 3, 3) = rgb$
 LOCATE , 23: PRINT LTRIM$(STR$(p% + 1));
NEXT p%
CLOSE #1

ON ERROR GOTO NoFile
OPEN "SSALogo.pal" FOR INPUT AS #1: CLOSE #1
ON ERROR GOTO Unknown
OPEN "SSALogo.pal" FOR BINARY ACCESS READ AS #1

FOR p% = 0 TO 255
 GET #1, , rgb$
 MID$(MPal, 1 + p% * 3, 3) = rgb$
 LOCATE , 28: PRINT LTRIM$(STR$(p% + 1));
NEXT p%
CLOSE #1
PRINT

PRINT "Loading SSAlogo...   ";
ON ERROR GOTO NoFile
OPEN "SSALogo.img" FOR INPUT AS #1: CLOSE #1
ON ERROR GOTO Unknown
OPEN "SSALogo.img" FOR BINARY ACCESS READ AS #1

FOR s% = 1 TO 85
 SSALogo(1, s%) = 2240
 SSALogo(2, s%) = 1
 FOR p% = 1 TO 140
  GET #1, , SSALogo(p% + 2, s%)
 NEXT p%
NEXT s%
CLOSE #1
PRINT "OK!"

ON ERROR GOTO No13
PRINT "Entering mode 13h... "
ON ERROR GOTO Unknown
delay# = TIMER: DO: LOOP UNTIL ABS(TIMER - delay#) >= .2
SCREEN 13

SetPal MPal
COLOR 255

RANDOMIZE TIMER
Level% = 1: Score% = 0: Lives% = 3

NewLevel:
x$ = CHR$(0)
f$ = "SSA" + LTRIM$(STR$(Level%)) + ".map"
ON ERROR GOTO GameOver
OPEN f$ FOR INPUT AS #1: CLOSE #1
ON ERROR GOTO Unknown
OPEN f$ FOR BINARY ACCESS READ AS #1
 GET #1, , x$
 IF x$ = CHR$(0) THEN GOTO GameOver
 title$ = STRING$(ASC(x$), 0)
 GET #1, , title$
CLOSE #1

Menu:
CLS
LOCATE 14
PRINT "  N - New Game"
PRINT "  C - Continue ("; title$; ")"
PRINT "  H - How To Play"
PRINT "  S - Save Game"
PRINT "  L - Load Game"
PRINT "  Q - Quit Smileys Small Adventure!"
PRINT
PRINT "  A - About"

DO
 GOSUB Logo

 SELECT CASE UCASE$(INKEY$)
  CASE "N"
   CLS
   LOCATE 14
   PRINT "  New Game!"
   PRINT "  Are you sure? [Y/N]"

   DO
  
    GOSUB Logo
  
    in$ = UCASE$(INKEY$)
    IF in$ = "Y" THEN
     Level% = 1: Score% = 0: Lives% = 3
     GOTO Menu
    ELSEIF in$ = "N" THEN
     GOTO Menu
    END IF
   LOOP

  CASE "C"
   WipeScreen
   SetPal SPal
   LoadLevel
   PlayGame
   GOTO NewLevel

  CASE "H"
   CLS
   SetPal SPal
   PUT (0, 0), Sprites(1)
   PUT (25, 0), Sprites(131)
   PUT (51, 0), Sprites(261)
   LOCATE 1, 12: PRINT "- Wall..."
   LOCATE 2, 12: PRINT "  Don't try to walk trough!"
   PUT (25, 16), Sprites(391)
   LOCATE 3, 12: PRINT "- Secret door..."
   LOCATE 4, 12: PRINT "  This wall can be passed."
   PUT (0, 32), Sprites(521)
   PUT (17, 32), Sprites(651)
   PUT (34, 32), Sprites(781)
   PUT (51, 32), Sprites(911)
   LOCATE 5, 12: PRINT "- Floors..."
   LOCATE 6, 12: PRINT "  Usually used to walk on..."
   PUT (0, 48), Sprites(1041)
   PUT (25, 48), Sprites(1171)
   PUT (51, 48), Sprites(1301)
   LOCATE 7, 12: PRINT "- Treasure..."
   LOCATE 8, 12: PRINT "  FrL: 10, 100, 1000 points."
   PUT (0, 64), Sprites(1431)
   PUT (25, 64), Sprites(1561)
   PUT (51, 64), Sprites(1691)
   LOCATE 9, 12: PRINT "- Keys..."
   LOCATE 10, 12: PRINT "  Used to unlock doors."
   PUT (0, 80), Sprites(1821)
   PUT (25, 80), Sprites(1951)
   PUT (51, 80), Sprites(2081)
   LOCATE 11, 12: PRINT "- Doors..."
   LOCATE 12, 12: PRINT "  Unlocked by keys."
   PUT (0, 96), Sprites(2341)
   PUT (25, 96), Sprites(2211)
   PUT (51, 96), Sprites(2471)
   LOCATE 13, 12: PRINT "- Smiley, Life and Exit..."
   LOCATE 14, 12: PRINT "  Self explanitory!"
   LINE (76, 0)-(76, 116), 255
   LINE (0, 116)-(319, 116), 255
   LOCATE 16
   PRINT "Keys:"
   PRINT " Lt, Rt, Up, Dn - Move Smiley."
   PRINT " Escape         - Use when trapped, will"
   PRINT "                  cost you one life."
   LOCATE 23
   PRINT "                    Press Any Key..."
   DO: LOOP WHILE INKEY$ = ""
   SetPal MPal
   GOTO Menu
  CASE "S"
   CLS
   LOCATE 14
   x$ = STRING$(20, 0)
   FOR n% = 1 TO 8
    OPEN "SSA" + LTRIM$(STR$(n%)) + ".sav" FOR BINARY ACCESS READ AS #1
    GET #1, , x$
    PRINT " "; n%; " - ["; x$; "]"
    CLOSE #1
   NEXT n%
   DO
    GOSUB Logo
    in$ = INKEY$
    SELECT CASE in$
     CASE "1" TO "8"
      LOCATE 13 + VAL(in$), 9
      PRINT STRING$(20, 32);
      LOCATE , 9
      LINE INPUT "", ssa$
      IF ssa$ <> "" THEN
       ssa$ = LEFT$(ssa$, 20)
       ssa$ = ssa$ + STRING$(20 - LEN(ssa$), 32)
       OPEN "SSA" + LTRIM$(STR$(VAL(in$))) + ".sav" FOR BINARY ACCESS WRITE AS #1
       PUT #1, , ssa$
       PUT #1, , Level%
       PUT #1, , Score%
       PUT #1, , Lives%
       CLOSE #1
      END IF
      GOTO Menu

     CASE CHR$(27)
      GOTO Menu

    END SELECT
   LOOP

  CASE "L"
   CLS
   LOCATE 14
   x$ = STRING$(20, 0)
   FOR n% = 1 TO 8
    OPEN "SSA" + LTRIM$(STR$(n%)) + ".sav" FOR BINARY ACCESS READ AS #1
    GET #1, , x$
    PRINT " "; n%; " - ["; x$; "]"
    CLOSE #1
   NEXT n%
   DO
    GOSUB Logo
    in$ = INKEY$
    SELECT CASE in$
     CASE "1" TO "8"
      OPEN "SSA" + LTRIM$(STR$(VAL(in$))) + ".sav" FOR BINARY ACCESS READ AS #1
      GET #1, , x$
      GET #1, , Level%
      GET #1, , Score%
      GET #1, , Lives%
      CLOSE #1
      GOTO Menu

     CASE CHR$(27)
      GOTO Menu
  
    END SELECT
   LOOP

  CASE "Q"
   CLS
   LOCATE 14
   PRINT "  Quit SSA!"
   PRINT "  Are you sure? [Y/N]"

   DO
   
    GOSUB Logo
   
    in$ = UCASE$(INKEY$)
    IF in$ = "Y" THEN
     WIDTH 80, 25
     PRINT "Thank you for playing Smileys Small Adventure!"
     END
    ELSEIF in$ = "N" THEN
     GOTO Menu
    END IF
   LOOP

  CASE "A"
   CLS
   LOCATE 14
   PRINT "     ** SMILEYS SMALL ADVENTURE **"
   PRINT "   Idea, Graphics And Programming by"
   PRINT "            Davey W Taylor"
   PRINT
   PRINT "              Thanks to:"
   PRINT " William Yu And All ABC Submitters For"
   PRINT "        Giving Me Inspiration"
   PRINT
   PRINT "           Mikael Bengtsson"
   PRINT "        For Being My Friend :)"
   DO
    GOSUB Logo
   LOOP WHILE INKEY$ = ""
   GOTO Menu

 END SELECT
LOOP

NoScreen:
PRINT "Video error!"
END

No13:
PRINT "ERROR: Mode 13h is not availavle!"
END

NoMem:
PRINT "ERROR: Not enugh memory!"
END

Unknown:
WIDTH 80, 25
PRINT "Unknown error!"
END

NoFile:
PRINT "ERROR: File not found!"
END

Logo:
 s! = s! + .1
 s! = ((s! * 10000) MOD 62830) / 10000

 FOR n% = 1 TO 85
  c! = s! + n% / 20
  PreCal(n%) = (9 + SIN(c!) * 9)
 NEXT n%

 WAIT &H3DA, 8
 FOR n% = 1 TO 85
  PUT (PreCal(n%), n% - 1), SSALogo(1, n%), PSET
 NEXT n%
RETURN

GameOver:
WIDTH 80, 25
PRINT "GameOver (Sorry about the boring ending...)"
END
NoError:
RESUME NEXT

SUB Display (XPos%, YPos%) STATIC
 ON ERROR GOTO 0

 IF XPos% <= 0 AND YPos% <= 0 THEN
 
  IF XPos% < 0 THEN
   xs% = PlayerX% - 5
   IF xs% < 1 THEN xs% = 1
   IF xs% > 247 THEN xs% = 247
  END IF
  IF YPos% < 0 THEN
   ys% = PlayerY% - 5
   IF ys% < 1 THEN ys% = 1
   IF ys% > 119 THEN ys% = 119
  END IF

  FOR x% = 0 TO 10
   FOR y% = 0 TO 10
    v% = ASC(LevelMap(x% + xs%, y% + ys%))
    IF v% = 0 THEN
     LINE (11 + x% * 16, 11 + y% * 16)-(26 + x% * 16, 26 + y% * 16), 0, BF
   
    ELSEIF v% = 21 THEN
     PUT (11 + x% * 16, 11 + y% * 16), Sprites(1 + 3 * 130), PSET

    ELSEIF v% = 22 THEN
     vx% = ASC(RIGHT$(LevelMap(x% + xs%, y% + ys%), 1))
     PUT (11 + x% * 16, 11 + y% * 16), Sprites(1 + (vx% - 1) * 130), PSET
     IF x% = PlayerX% - xs% AND y% = PlayerY% - ys% THEN
      PUT (11 + x% * 16, 11 + y% * 16), Masking(2341), AND
      PUT (11 + x% * 16, 11 + y% * 16), Sprites(2341), OR
     END IF

    ELSEIF v% > 8 THEN
     vx% = ASC(RIGHT$(LevelMap(x% + xs%, y% + ys%), 1))
     PUT (11 + x% * 16, 11 + y% * 16), Sprites(1 + (vx% - 1) * 130), PSET
     PUT (11 + x% * 16, 11 + y% * 16), Masking(1 + (v% - 1) * 130), AND
     PUT (11 + x% * 16, 11 + y% * 16), Sprites(1 + (v% - 1) * 130), OR
   
    ELSE
     PUT (11 + x% * 16, 11 + y% * 16), Sprites(1 + (v% - 1) * 130), PSET
     IF x% = PlayerX% - xs% AND y% = PlayerY% - ys% THEN
      PUT (11 + x% * 16, 11 + y% * 16), Masking(2341), AND
      PUT (11 + x% * 16, 11 + y% * 16), Sprites(2341), OR
     END IF
 
    END IF
   NEXT y%
  NEXT x%

 ELSE

  ok% = 0
  SELECT CASE ASC(LevelMap(XPos%, YPos%))
   CASE 5, 6, 7, 8
    ok% = 2

   CASE 9
    Score% = Score% + 10
    ok% = 1
    ShowScore

   CASE 10
    Score% = Score% + 100
    ok% = 1
    ShowScore

   CASE 11
    Score% = Score% + 1000
    ok% = 1
    ShowScore

   CASE 12
    RedKeys% = RedKeys% + 1
    ok% = 1
    ShowKeys

   CASE 13
    GreenKeys% = GreenKeys% + 1
    ok% = 1
    ShowKeys

   CASE 14
    BlueKeys% = BlueKeys% + 1
    ok% = 1
    ShowKeys
  
   CASE 15
    IF RedKeys% > 0 THEN
     RedKeys% = RedKeys% - 1
     ok% = 1
     ShowKeys
    END IF

   CASE 16
    IF GreenKeys% > 0 THEN
     GreenKeys% = GreenKeys% - 1
     ok% = 1
     ShowKeys
    END IF

   CASE 17
    IF BlueKeys% > 0 THEN
     BlueKeys% = BlueKeys% - 1
     ok% = 1
     ShowKeys
    END IF

   CASE 18
    Lives% = Lives% + 1
    ok% = 1
    ShowLives

   CASE 20
    Level% = Level% + 1
    ok% = 1

   CASE 21
    ok% = 1

   CASE 22
    ok% = 2

  END SELECT
 
  IF ok% > 0 THEN
   IF ok% = 1 THEN
    LevelMap(XPos%, YPos%) = RIGHT$(LevelMap(XPos%, YPos%), 1) + CHR$(0)
   END IF
  
   IF LEFT$(LevelMap(PlayerX%, PlayerY%), 1) = CHR$(22) THEN
    LevelMap(PlayerX%, PlayerY%) = CHR$(INT(RND * 3) + 1) + CHR$(0)
   END IF

   px% = PlayerX% - xs%
   py% = PlayerY% - ys%
   xp% = XPos% - xs%
   yp% = YPos% - ys%

   PUT (11 + px% * 16, 11 + py% * 16), Sprites(1 + (ASC(LevelMap(PlayerX%, PlayerY%)) - 1) * 130), PSET
   IF RIGHT$(LevelMap(XPos%, YPos%), 1) > CHR$(0) THEN
    PUT (11 + xp% * 16, 11 + yp% * 16), Sprites(1 + (ASC(RIGHT$(LevelMap(XPos%, YPos%), 1)) - 1) * 130), PSET
   ELSE
    PUT (11 + xp% * 16, 11 + yp% * 16), Sprites(1 + (ASC(LevelMap(XPos%, YPos%)) - 1) * 130), PSET
   END IF
   PUT (11 + xp% * 16, 11 + yp% * 16), Masking(1 + 18 * 130), AND
   PUT (11 + xp% * 16, 11 + yp% * 16), Sprites(1 + 18 * 130), OR

   PlayerX% = XPos%: PlayerY% = YPos%
   IF xp% = 1 OR xp% = 9 THEN
    Display -1, 0
   END IF
   IF yp% = 1 OR yp% = 9 THEN
    Display 0, -1
   END IF

  END IF
 END IF
END SUB

FUNCTION Hit (x%, y%)

END FUNCTION

SUB LoadLevel

 FOR y% = 1 TO 64
  FOR x% = 1 TO 128
   LevelMap(x%, y%) = STRING$(2, 0)
  NEXT x%
 NEXT y%

 RedKeys% = 0: GreenKeys% = 0: BlueKeys% = 0
 x$ = CHR$(0)
 f$ = "SSA" + LTRIM$(STR$(Level%)) + ".map"

 OPEN f$ FOR BINARY ACCESS READ AS #1
 GET #1, , x$
 t$ = STRING$(ASC(x$), 0)
 GET #1, , t$

 GET #1, , x$
 xs% = ASC(x$)
 GET #1, , x$
 ys% = ASC(x$)

 FOR y% = 1 TO ys%
  FOR x% = 1 TO xs%
  
   GET #1, , x$
   SELECT CASE x$
    CASE CHR$(19)
     LevelMap(x%, y%) = CHR$(INT(RND * 4) + 5) + CHR$(0)
     PlayerX% = x%: PlayerY% = y%
   
    CASE IS > CHR$(8)
     LevelMap(x%, y%) = x$ + CHR$(INT(RND * 4) + 5)

    CASE ELSE
     LevelMap(x%, y%) = x$ + CHR$(0)

   END SELECT
 
  NEXT x%
 NEXT y%

 CLOSE #1
END SUB

SUB PlayGame
 ShowScore
 ShowLives
 ShowKeys
 Display -1, -1
 StartLevel% = Level%
 DO
  SELECT CASE INKEY$
   CASE CHR$(0) + "H"
    Display PlayerX%, PlayerY% - 1

   CASE CHR$(0) + "P" 'down
    Display PlayerX%, PlayerY% + 1
  
   CASE CHR$(0) + "K" 'left
    Display PlayerX% - 1, PlayerY%

   CASE CHR$(0) + "M" 'right
    Display PlayerX% + 1, PlayerY%

   CASE CHR$(27)
    WipeScreen
    SetPal MPal
    EXIT SUB

  END SELECT
  IF Level% > StartLevel% THEN
   WipeScreen
   SetPal MPal
   EXIT SUB
  END IF
 LOOP
END SUB

SUB SetPal (pal$)
 FOR n% = 1 TO LEN(pal$) / 3
  OUT &H3C7, n% - 1
  OUT &H3C8, n% - 1
  OUT &H3C9, INT(ASC(MID$(pal$, (n% - 1) * 3 + 1, 1)) / 4)
  OUT &H3C9, INT(ASC(MID$(pal$, (n% - 1) * 3 + 2, 1)) / 4)
  OUT &H3C9, INT(ASC(MID$(pal$, (n% - 1) * 3 + 3, 1)) / 4)
 NEXT n%
END SUB

SUB ShowKeys
 LOCATE 8, 30
 PRINT "Keys:"
 LOCATE 9, 30
 PRINT RedKeys%; " red"
 LOCATE 10, 30
 PRINT GreenKeys%; " green"
 LOCATE 11, 30
 PRINT BlueKeys%; " blue"
END SUB

SUB ShowLives
 LOCATE 5, 30
 PRINT "Lives:"
 LOCATE 6, 30
 PRINT Lives%
END SUB

SUB ShowScore
 IF Score% >= 10000 THEN
  Lives% = Lives% + 1
  ShowLives
  Score% = Score% - 10000
 END IF
 LOCATE 2, 30
 PRINT "Score:"
 LOCATE 3, 30
 PRINT Score%
END SUB

SUB WipeScreen
 FOR temp% = 0 TO 319
  IF INT(temp% / 10) = temp% / 10 THEN WAIT &H3DA, 8
  LINE (temp%, 0)-(319 - temp%, 199), 0
 NEXT
 FOR temp% = 199 TO 0 STEP -1
  IF INT(temp% / 10) = temp% / 10 THEN WAIT &H3DA, 8
  LINE (0, temp%)-(319, 199 - temp%), 0
 NEXT
END SUB

