'/=================================================================\
'  (C) David Joffe 1997                     e-mail: dj1@pixie.co.za
'  DJ Software; April '97  http://www.geocities.com/SoHo/Lofts/2018/
'-------------------------------------------------------------------
'  Sokoban v1.0, for QBasic!
'-------------------------------------------------------------------
'  -[ The object of the game: ]----------------------------------
'  You are CharacterDollarTwo; you must push all the crate-type
'  blocks onto the destionation-type blocks. There are 90 levels,
'  which I got from XSokoban, an XWindows sokoban on the Net.
'  --------------------------------------------------------------
'
'  Whipped up in a few hours for Net QBasic collections.
'  You can include this program, along with DJSOK.DAT, anywhere
'  and in any medium you like, with one condition: None of
'  the files DJSOK.BAS or DJSOK.DAT must be changed! Please contact
'  me if you ever want to distribute the game as a compiled .exe,
'  as I would like it if these comments stay with the game.
'
'  Please send me bug-reports and any other feedback; i.e. tell
'  me you like it or hate it or have no opinion about it, but just
'  tell me something!
'
'  New levels: I would love it if you create new levels if you
'  would send them to me; they will probably be included in later
'  versions, in which case you will get credit.
'
'  The savegame file format is a really tough one to crack, but
'  see if you can give it a go ;-)
'\=================================================================/

' Default data type to integer for fastest processing
DEFINT A-Z

' Constants
CONST NUMLEVELS = 90
CONST LEVELFILENAME = "djsok.dat"

CONST MAXX = 20
CONST MAXY = 17

' Set this to 1 to enable cheats; then pressing "$" advances a level
CONST CHEATSENABLED = 0

' Search string: position of a character in string is used as the
' index for Colour array dereferencing and for how to handle that
' type of character in the game
GameData$ = "Һ̵ʻ " ' This one got replaced :)
GameData$ = " " ' by this one!
GameData$ = "۰ " ' and then by this one!
'GameData$ = " " ' Yup, yet another one!

' Offsets into GameData$ of certain important character types
CONST POSCRATE = 19
CONST POSCRATEATDEST = 20
CONST POSDEST = 17
' Certain important character types
CharCrate$ = MID$(GameData$, POSCRATE, 1)
CharCrateAtDest$ = MID$(GameData$, POSCRATEATDEST, 1)
CharDest$ = MID$(GameData$, POSDEST, 1)

' Data structures
DIM TempMap(0 TO MAXY + 1) AS STRING * 22
DIM Map(0 TO MAXY + 1) AS STRING * 22

' Colours of different types of characters
DIM Colours(1 TO 21)   ' Foreground
DIM BColours(1 TO 21)  ' Background

' Read in foreground and background color data
RESTORE ColourData
FOR i = 1 TO 21
  READ Colours(i)
NEXT i
FOR i = 1 TO 21
  READ BColours(i)
NEXT i

' Colours for block types in GameData$
ColourData:
DATA 09,09,09,09,09,09,09,09,09,09,09,09,09,09,09,09,6,7,6,6,14
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,7,7,0

' Initialize screen
SCREEN 0: WIDTH 40, 25
COLOR 15, 0: CLS

' Level should be set to 0 here to make entry point level 1
Level = 0
Won = 1

'===========================================================[ BEGIN MAIN ]==
MainLoop:
  ' Get keypress
  a$ = INKEY$

  ' Reset level or advance level
  IF Won = 1 OR UCASE$(a$) = "R" THEN
    IF (UCASE$(a$) <> "R") AND (Level >= 1) THEN
      COLOR 15, 0
      LOCATE 20, 1: PRINT "Press a key ...";
      WHILE INKEY$ = "": WEND
    END IF
    IF (UCASE$(a$) <> "R") THEN Level = Level + 1
    IF (Level > NUMLEVELS) THEN GOTO FinishedGame
    GOSUB LoadLevel
    GOSUB DrawLevel
    GOTO MovePlayer
  END IF
 
  ' Player pressed nothing
  IF a$ = "" THEN GOTO MainLoop

  ' Player pressed escape
  IF a$ = CHR$(27) THEN GOTO EndGame
 
  ' Save game
  IF UCASE$(a$) = "S" THEN GOSUB SaveGame: GOTO MainLoop

  ' Cheat to advance to next level
  IF a$ = "$" AND CHEATSENABLED = 1 THEN Won = 1: GOTO MainLoop

  ' Load game
  IF UCASE$(a$) = "L" THEN GOSUB LoadGame: GOTO MainLoop

  ' About
  IF UCASE$(a$) = "A" THEN GOSUB About: GOTO MainLoop

  ' Up, down, left and right respectively
  IF a$ = CHR$(0) + "H" THEN xd = 0: yd = -1: GOTO MovePlayer
  IF a$ = CHR$(0) + "P" THEN xd = 0: yd = 1: GOTO MovePlayer
  IF a$ = CHR$(0) + "K" THEN xd = -1: yd = 0: GOTO MovePlayer
  IF a$ = CHR$(0) + "M" THEN xd = 1: yd = 0: GOTO MovePlayer
GOTO MainLoop
'=============================================================[ END MAIN ]==

MovePlayer:
  ' read character directly in front of player
  character$ = MID$(Map$(y + yd), x + xd + 1, 1)
  n = INSTR(GameData$, character$)
 
  ' If it's a wall, then leave
  IF n <= 16 THEN GOTO MainLoop

  ' If there is a crate in front of us, find the character two positions
  ' away in front of us
  IF ((character$ = CharCrate$) OR (character$ = CharCrateAtDest$)) THEN
    character2$ = MID$(Map$(y + yd + yd), x + xd + xd + 1, 1)
    n2 = INSTR(GameData$, character2$)
    ' If the character 2 away from us is a wall or a crate, leave
    IF n2 <= 16 OR character2$ = CharCrate$ OR character2$ = CharCrateAtDest$ THEN GOTO MainLoop
   
    ' Else we can move the crate in front of us
    LOCATE y + yd + yd + 1, x + xd + xd + 1
    ' If we're moving a crate onto a destination-type block
    IF (character2$ = CharDest$) THEN
      MID$(Map$(y + yd + yd), x + xd + xd + 1, 1) = CharCrateAtDest$
      COLOR Colours(POSCRATEATDEST), BColours(POSCRATEATDEST)
      PRINT CharCrateAtDest$;
      NumPushes = NumPushes + 1: GOSUB ShowNumPushes
      ' If we're moving it from a destination-type block onto another dest-type
      IF character$ = CharCrateAtDest$ THEN
        MID$(Map$(y + yd), x + xd + 1, 1) = CharDest$
      ELSE ' we're moving it onto a dest-type from a space
        MID$(Map$(y + yd), x + xd + 1, 1) = " "
        NumPlaced = NumPlaced + 1
      END IF
      IF (NumPlaced = NumCrates) THEN Won = 1
    ELSE ' We're moving the crate onto a blank space
      MID$(Map$(y + yd + yd), x + xd + xd + 1, 1) = CharCrate$
      COLOR Colours(POSCRATE), BColours(POSCRATE)
      PRINT CharCrate$;
      NumPushes = NumPushes + 1: GOSUB ShowNumPushes
      ' If we're moving a crate off of a destination block
      IF character$ = CharCrateAtDest$ THEN
        MID$(Map$(y + yd), x + xd + 1, 1) = CharDest$
        NumPlaced = NumPlaced - 1
      ELSE ' we're moving a crate off of a space
        MID$(Map$(y + yd), x + xd + 1, 1) = " "
      END IF
    END IF
  END IF

  ' Erase our hero
  COLOR Colours(INSTR(GameData$, MID$(Map$(y), x + 1, 1))), BColours(INSTR(GameData$, MID$(Map$(y), x + 1, 1)))
  LOCATE y + 1, x + 1: PRINT MID$(Map$(y), x + 1, 1);
  ' Update hero's location
  x = x + xd
  y = y + yd
  IF NOT (xd = 0 AND yd = 0) THEN NumMoves = NumMoves + 1: GOSUB ShowNumMoves
  ' Re-draw our hero
  COLOR 14, 0
  LOCATE y + 1, x + 1: PRINT "";
GOTO MainLoop

SaveGame:
  GOSUB InputFileName
  IF filename$ <> "" THEN
    filename$ = filename$ + ".sok"
    OPEN filename$ FOR OUTPUT AS #1
    PRINT #1, Level
    CLOSE
    LOCATE 20, 1: PRINT "File "; filename$; " saved ...";
    SLEEP 1
  END IF
  LOCATE 20, 1: PRINT SPACE$(40);
RETURN

LoadGame:
  GOSUB InputFileName
  IF filename$ <> "" THEN
    filename$ = filename$ + ".sok"
    Level = 0
    ' The following error handler can be used to determine if a given file
    ' exists.
    ON ERROR GOTO NoFile
    OPEN filename$ FOR INPUT AS #1
    ' If file exists:
    IF filename$ <> "" THEN
      INPUT #1, Level
      CLOSE
      GOSUB LoadLevel
      GOSUB DrawLevel
    END IF
  END IF
  ' Disable the error handler
  ON ERROR GOTO 0
  LOCATE 20, 1: PRINT SPACE$(40);
RETURN

NoFile:
  LOCATE 20, 1: PRINT "File not found! Press a key ...";
  ' Set filename$ to "" so that we know the file doesn't exist
  filename$ = ""
  ' Clear keyboard buffer and wait for keypress
  WHILE INKEY$ <> "": WEND
  WHILE INKEY$ = "": WEND
' Go back to the line after the error occured
RESUME NEXT

' Routine to allow user to enter a string of length at most 8 for
' getting filenames
InputFileName:
  COLOR 15
  xval = 17
  filename$ = ""
  LOCATE 20, 1: PRINT "Enter filename: _";
EnternameLoop:
    s$ = INKEY$
    IF s$ = "" THEN GOTO EnternameLoop
    ' Escape
    IF s$ = CHR$(27) THEN filename$ = "": GOTO sReturn
    ' Enter
    IF s$ = CHR$(13) THEN GOTO sReturn
    ' Backspace
    IF filename$ <> "" AND s$ = CHR$(8) THEN
      filename$ = LEFT$(filename$, LEN(filename$) - 1)
      LOCATE 20, xval: PRINT filename$ + "_ ";
    END IF
    IF s$ < "0" THEN GOTO EnternameLoop
    IF s$ > "9" THEN
      IF s$ < "A" THEN GOTO EnternameLoop
      IF s$ > "Z" THEN
        IF s$ < "a" OR s$ > "z" THEN GOTO EnternameLoop
      END IF
    END IF
    IF LEN(filename$) = 8 THEN GOTO EnternameLoop
    filename$ = filename$ + s$
    LOCATE 20, xval: PRINT filename$ + "_ ";
GOTO EnternameLoop
sReturn:
RETURN

' Loads levels from the file as it needs them because all the levels
' in memory at once might place a bit of strain on QBasic :-)
LoadLevel:
  x = 0
  y = 0
  xd = 0
  yd = 0
  NumCrates = 0
  NumDestinations = 0
  NumPlaced = 0
  NumMoves = 0
  NumPushes = 0
  Won = 0

  ' Blank out the strings
  FOR i = 0 TO MAXY + 1
    TempMap$(i) = STRING$(MAXX + 2, " ")
    Map$(i) = STRING$(MAXX + 2, " ")
  NEXT i

  OPEN LEVELFILENAME FOR INPUT AS #1
  LINE INPUT #1, f$
  LevelString$ = RTRIM$(LTRIM$(STR$(Level)))
  ' Read until we find the string corresponding to the current Level number
  WHILE (f$ <> LevelString$) AND NOT EOF(1)
    LINE INPUT #1, f$
  WEND
  ' If we didn't find it, something went wrong
  IF f$ <> LevelString$ THEN CLOSE : GOTO lReturn

  ' Read in the level
  LINE INPUT #1, f$
  count = 1
  WHILE f$ <> "~"
    TempMap$(count) = " " + f$
    LINE INPUT #1, f$
    count = count + 1
  WEND
  CLOSE

  ' Centre the level vertically
  ' Adding 0.5 and doing an integer divide effectively rounds upwards
  extra = ((MAXY - count) + .5) \ 2
  FOR i = count TO 1 STEP -1
    TempMap$(i + extra) = TempMap$(i)
  NEXT i
  FOR i = 1 TO extra
    TempMap$(i) = ""
  NEXT i

  ' Interpret the raw data and convert to our own format
  FOR i = 1 TO MAXY
    Map$(i) = TempMap$(i)
    FOR j = 2 TO MAXX + 1
      IF (MID$(Map$(i), j, 1) = "@") THEN
        MID$(Map$(i), j, 1) = " "
        x = j - 1
        y = i
      END IF
      IF (MID$(Map$(i), j, 1) = "$") THEN
        MID$(Map$(i), j, 1) = CharCrate$
        NumCrates = NumCrates + 1
      END IF
      IF (MID$(Map$(i), j, 1) = "*") THEN
        MID$(Map$(i), j, 1) = CharCrateAtDest$
        NumCrates = NumCrates + 1
        NumDestinations = NumDestinations + 1
        NumPlaced = NumPlaced + 1
      END IF
      IF (MID$(Map$(i), j, 1) = ".") THEN
        MID$(Map$(i), j, 1) = CharDest$
        NumDestinations = NumDestinations + 1
      END IF
     
      ' This is used when the walls look different depending on what walls
      ' are adjacent to them, e.g. ,,, etc.
      ' A binary code is used XXXX where each of the four digits corresponds
      ' to above, right-of, below, and left-of. This will generate a number
      ' from 0 to 15 that is used as the offset into GameData$ to determine
      ' the character used.
      IF (MID$(Map$(i), j, 1) = "#") THEN
        code = 0
        IF (MID$(TempMap$(i - 1), j, 1) = "#") THEN code = code + 1
        IF (MID$(TempMap$(i), j + 1, 1) = "#") THEN code = code + 2
        IF (MID$(TempMap$(i + 1), j, 1) = "#") THEN code = code + 4
        IF (MID$(TempMap$(i), j - 1, 1) = "#") THEN code = code + 8
        MID$(Map$(i), j, 1) = MID$(GameData$, code + 1, 1)
      END IF
    NEXT j
  NEXT i

  ' If the level is impossible, generate an error message.
  IF NumCrates < NumDestinations THEN
    COLOR 7, 0: CLS
    PRINT "Error: Level"; Level; "impossible!"
    PRINT "Did you fiddle with the level file?"
    PRINT "Is the level file there?"
    PRINT "If this wasn't your fault please contact me."
    WHILE INKEY$ = "": WEND
    END
  END IF
lReturn:
RETURN

DrawLevel:
  COLOR 10, 0: CLS
  LOCATE 1, 1
  PRINT ""
  FOR i = 1 TO MAXY
    PRINT "                    "
  NEXT i
  PRINT ""
 
  FOR i = 1 TO MAXY
    FOR j = 2 TO MAXX + 1
      COLOR Colours(INSTR(GameData$, MID$(Map$(i), j, 1))), BColours(INSTR(GameData$, MID$(Map$(i), j, 1)))
      LOCATE i + 1, j
      PRINT MID$(Map$(i), j, 1);
    NEXT j
    PRINT
  NEXT i
  COLOR 14
  LOCATE y + 1, x + 1
  PRINT ""

  COLOR 12, 0
  LOCATE 1, 24: PRINT "";
  LOCATE 2, 24: PRINT "  Sokoban v1.0 ";
  LOCATE 3, 24: PRINT "";
  COLOR 9, 0
  LOCATE 5, 24: PRINT "";
  LOCATE 6, 24: PRINT "               ";
  LOCATE 7, 24: PRINT USING " Level:  ####  "; Level;
  LOCATE 8, 24: PRINT USING " Moves:  ####  "; NumMoves;
  LOCATE 9, 24: PRINT USING " Pushes: ####  "; NumPushes
  LOCATE 10, 24: PRINT "               ";
  LOCATE 11, 24: PRINT "";

  COLOR 14, 0
  LOCATE 13, 24: PRINT ""
  LOCATE , 24: PRINT " R  : Reset    "
  LOCATE , 24: PRINT " L  : Load     "
  LOCATE , 24: PRINT " S  : Save     "
  LOCATE , 24: PRINT " A  : About    "
  LOCATE , 24: PRINT " Esc: Quit     "
  LOCATE , 24: PRINT ""
 
  COLOR 13
  LOCATE 21, 8: PRINT ""
  LOCATE , 8: PRINT " (C) ";
  COLOR 12: PRINT "D";
  COLOR 14: PRINT "J";
  PRINT " ";
  COLOR 10: PRINT "S";
  COLOR 11: PRINT "o";
  COLOR 9: PRINT "f";
  COLOR 13: PRINT "t";
  COLOR 12: PRINT "w";
  COLOR 14: PRINT "a";
  COLOR 10: PRINT "r";
  COLOR 11: PRINT "e";
  COLOR 13: PRINT " 1997 "
  LOCATE , 8: PRINT ""

RETURN

ShowNumMoves:
  COLOR 9, 0
  LOCATE 8, 24: PRINT USING " Moves:  ####  "; NumMoves;
RETURN

ShowNumPushes:
  COLOR 9, 0
  LOCATE 9, 24: PRINT USING " Pushes: ####  "; NumPushes;
RETURN

About:
  ' Save the contents of the screen in an off-screen area of video
  ' memory that is just after what is on the screen
  DEF SEG = &HB800 ' Segment where text screen data is stored
  FOR i = 0 TO (40 * 25 * 2) - 1
    n = PEEK(i)
    POKE i + 2000, n
  NEXT i
  DEF SEG
 
  COLOR 15, 1
  LOCATE 1, 1
  LOCATE 5, 3: PRINT ""
  LOCATE , 3: PRINT "                                  "; : COLOR 8: PRINT "": COLOR 15
  LOCATE , 3: PRINT "          Sokoban v1.0          "; : COLOR 8: PRINT "": COLOR 15
  LOCATE , 3: PRINT "                                  "; : COLOR 8: PRINT "": COLOR 15
  LOCATE , 3: PRINT "         DJ Software 1997         "; : COLOR 8: PRINT "": COLOR 15
  LOCATE , 3: PRINT "         (C) David Joffe          "; : COLOR 8: PRINT "": COLOR 15
  LOCATE , 3: PRINT "                                  "; : COLOR 8: PRINT "": COLOR 15
  LOCATE , 3: PRINT "    Whipped up in a few hours     "; : COLOR 8: PRINT "": COLOR 15
  LOCATE , 3: PRINT "            for the Net           "; : COLOR 8: PRINT "": COLOR 15
  LOCATE , 3: PRINT "                                  "; : COLOR 8: PRINT "": COLOR 15
  LOCATE , 3: PRINT "www.geocities.com/SoHo/Lofts/2018/"; : COLOR 8: PRINT "": COLOR 15
  LOCATE , 3: PRINT "     e-mail: dj1@pixie.co.za      "; : COLOR 8: PRINT "": COLOR 15
  LOCATE , 3: PRINT "                                  "; : COLOR 8: PRINT "": COLOR 15
  LOCATE , 3: PRINT ""; : COLOR 8: PRINT "": COLOR 15
  COLOR 8
  LOCATE , 4: PRINT "";
  WHILE INKEY$ = "": WEND

  ' Restore the contents of the screen
  DEF SEG = &HB800
  FOR i = 0 TO (40 * 25 * 2) - 1
    n = PEEK(i + 2000)
    POKE i, n
  NEXT i
  DEF SEG
RETURN

EndGame:
  WIDTH 80, 25
  COLOR 15, 0: CLS
  PRINT "*Sniff* .. I hate goodbyes .. *sob* ..."
  PRINT
  PRINT "Feedback (and bug reports :) welcome!"
  PRINT
  GOTO ContactMessage

FinishedGame:
  WIDTH 80, 25
  COLOR 15, 0: CLS
  PRINT "You finished the game. Yay!"
  PRINT "I suppose you were expecting something more spectacular then? You must be"
  PRINT "quite disappointed! :-)"
  PRINT
  PRINT "Actually, I would love to know if anyone actually *did* get this far (with-"
  PRINT "out cheating, of course), so let me know!"
  PRINT
  GOTO ContactMessage


ContactMessage:
  PRINT "Try e-mail me (David Joffe) at "; : COLOR 14: PRINT "dj1@pixie.co.za"; : COLOR 15: PRINT "; if that's become out-"
  PRINT "dated, have a look at:"
  COLOR 14
  PRINT "http://www.geocities.com/SoHo/Lofts/2018/"
  COLOR 15
  PRINT
  PRINT "I have other stuff at the above URL, with source code etc, so check it out!"
  PRINT
  PRINT "Also, if you make any new levels, I'd love to see them! Maybe I'll add them"
  PRINT "to the game for for a future re-release/re-write, in which case I'll give"
  PRINT "you appropriate credit; I'll give each level a 'Creator' field."
  PRINT
  PRINT "Cheers from everyone here (just me :) at ";
  COLOR 12: PRINT "-+ D";
  COLOR 14: PRINT "J";
  PRINT " ";
  COLOR 10: PRINT "S";
  COLOR 11: PRINT "o";
  COLOR 9: PRINT "f";
  COLOR 13: PRINT "t";
  COLOR 12: PRINT "w";
  COLOR 14: PRINT "a";
  COLOR 10: PRINT "r";
  COLOR 11: PRINT "e +-"
  COLOR 15

  PRINT
  PRINT " - David Joffe"
END

