' SPLAT.BAS
' By Peter Aylett - 22/5/97
' peter_a@uuscss.cs.su.oz.au
' Happy 18th Birthday Vincent.
' (Maybe I should have rewritten RoadKill)

DECLARE SUB BackDrop ()
DECLARE SUB CheckLevel ()
DECLARE SUB DetectHit (x, y)
DECLARE SUB Disp (poss, col, txt$)
DECLARE SUB DispHelp ()
DECLARE SUB DispPCX (title$)
DECLARE SUB DrawCritters ()
DECLARE SUB EraseCrit (num)
DECLARE SUB InitHoles ()
DECLARE SUB Initialize ()
DECLARE SUB InitImages ()
DECLARE SUB LoadImgData ()
DECLARE SUB MainGame ()
DECLARE SUB MouseHide ()
DECLARE SUB MouseInit ()
DECLARE SUB MousePut (x%, y%)
DECLARE SUB MouseShow ()
DECLARE SUB MouseStatus (lb%, rb%, Xmouse%, Ymouse%)
DECLARE SUB MouseDriver (ax%, bx%, cd%, dx%)
DECLARE SUB PalGet (col, r, g, b)
DECLARE SUB PalScroll ()
DECLARE SUB PalSet (col, r, g, b)
DECLARE SUB PauseGame ()
DECLARE SUB PlaceCrit (num, difi)
DECLARE SUB SoundEffect (num)
DECLARE SUB UpdateDisplay ()

DECLARE FUNCTION GetData% (adrs&)
DECLARE FUNCTION MouseOver (num, x, y, acc)
DECLARE FUNCTION NewGame ()


CONST False = 0
CONST True = NOT False
CONST ViewPCX = True
CONST Help = True

TYPE levelType
  score AS INTEGER
  speed AS INTEGER
  mcrit AS INTEGER
  rclim AS INTEGER
  bclim AS INTEGER
END TYPE

TYPE critterType
  pres  AS INTEGER
  time  AS INTEGER
  dead  AS INTEGER
END TYPE

TYPE holeType
  x     AS INTEGER
  y     AS INTEGER
  size  AS INTEGER
  leng  AS INTEGER
  crit  AS critterType
END TYPE

DIM SHARED Hole(12) AS holeType
DIM SHARED Level(12) AS levelType
DIM SHARED bufr(0 TO 1) AS STRING * 32767
DIM SHARED pausefrm(12000)
DIM SHARED image(1300, 9)
DIM SHARED bkgnd(1300, 3)
DIM SHARED mouse$

DIM SHARED SoundFX
DIM SHARED Scroll
DIM SHARED Critup
DIM SHARED score
DIM SHARED Shots
DIM SHARED THits
DIM SHARED curlev
DIM SHARED Escaped
DIM SHARED Critmax
DIM SHARED prevScore

Initialize
MainGame
PRINT "QBasic Rulz.. Ok."
END

MouseData:
DATA 55,89,E5,8B,5E,0C,8B,07,50,8B,5E,0A,8B,07,50,8B
DATA 5E,08,8B,0F,8B,5E,06,8B,17,5B,58,1E,07,CD,33,53
DATA 8B,5E,0C,89,07,58,8B,5E,0A,89,07,8B,5E,08,89,0F
DATA 8B,5E,06,89,17,5D,CA,08,00

HoleData:
DATA 25,35,1,29,85,35,1,29,145,35,1,29,205,35,1,29
DATA 265,35,1,29,35,66,2,39,106,66,2,39,177,66,2,39
DATA 248,66,2,39,45,108,3,49,135,108,3,49,225,108,3,49

ImgRefData:
DATA 1,6,10,2,3,1,9,8,7,10,11,12

LevelData:
DATA 0,1,1,18,16,100,2,1,18,16,200,3,2,18,15,500,4,2,18,14
DATA 1000,5,3,17,14,1500,6,3,17,13,2000,7,4,16,13,2500,8,4,16,12
DATA 3000,9,5,15,11,3500,10,5,15,10,4000,11,6,14,10,4500,12,6,14,9

REM $STATIC
SUB BackDrop


  LINE (0, 0)-(319, 40), 11, BF
  FOR a = 40 TO 182
    LINE (0, a)-(319, a), INT((LOG(a) - LOG(40)) * 24 / (LOG(183) - LOG(40))) + 32, BF
  NEXT a
 
  FOR a = 0 TO 4
    CIRCLE (a * 60 + 40, 60), 15, 0, , , .3
    PAINT (a * 60 + 40, 60), 0, 0
    IF a < 4 THEN
      CIRCLE (a * 71 + 55, 100), 20, 0, , , .3
      PAINT (a * 71 + 55, 100), 0, 0
    END IF
    IF a < 3 THEN
      CIRCLE (a * 90 + 70, 150), 25, 0, , , .3
      PAINT (a * 90 + 70, 150), 0, 0
    END IF
  NEXT a

  'Box Em
  'FOR a = 1 TO 12
  '  LINE (hole(a).x, hole(a).y)-(hole(a).x + hole(a).leng, hole(a).y + hole(a).leng), 0, B
  'NEXT a

END SUB

SUB CheckLevel
 
  prevlev = 0
  curlev = 0
  FOR a = 1 TO 12
    IF prevScore >= Level(a).score THEN prevlev = a
    IF score >= Level(a).score THEN curlev = a
  NEXT a

  IF prevlev <> curlev THEN
    SoundEffect 5
    Critmax = Level(curlev).mcrit
    UpdateDisplay
  END IF
  prevScore = score


END SUB

SUB DetectHit (x, y)
 
  hit = 0
  FOR a = 1 TO 12
    IF MouseOver(a, x, y, True) = True THEN
      hit = a
      EXIT FOR
    END IF
  NEXT a
 
  IF hit <> 0 THEN
    IF Hole(hit).crit.pres <> 0 THEN
      score = score + 5 * 2 ^ (Hole(hit).crit.pres - 1)
      Hole(hit).crit.pres = False
      Hole(hit).crit.dead = True
      Hole(hit).crit.time = INT(Hole(hit).crit.time * RND)
      MouseHide
      EraseCrit hit
      MouseShow
      THits = THits + 1
      SoundEffect 3
    ELSE
      SoundEffect 2
    END IF
  ELSE
    SoundEffect 2
  END IF
  Shots = Shots + 1

  UpdateDisplay
 
END SUB

SUB Disp (poss, col, text$)

  COLOR col
  LOCATE poss + 23, 1: PRINT SPACE$(39);
  LOCATE poss + 23, 20 - INT(LEN(text$) / 2)
  PRINT text$;

END SUB

SUB DispHelp

  SCREEN 13
  CLS

  Disp -20, 14, "<<<<< SPLAT >>>>>"
  Disp -18, 12, "Happy 18th Birthday"
  Disp -17, 12, "Vincent !!"
  Disp -15, 13, "The object of the game is to splat as"
  Disp -14, 13, "many critters as possible. As the game"
  Disp -13, 13, "continues more and more will appear at"
  Disp -12, 13, "once. The speed will also increase."
  Disp -10, 9, "Green = 50  Points"
  Disp -9, 9, "Pink  = 100 Points"
  Disp -8, 9, "Blue  = 200 Points"
  Disp -6, 10, "Press SPACE to pause.     "
  Disp -5, 10, "Press ESC to quit.        "
  Disp -4, 10, "Press F10 to toggle sound."
  Disp 1, 11, "By Peter Aylett 22/5/97"

  WHILE INKEY$ <> "": WEND
  WHILE INKEY$ = "": WEND


END SUB

SUB DispPCX (title$)

SCREEN 13
OPEN title$ FOR BINARY AS #1
  GET #1, 1, bufr(0)
  GET #1, 32768, bufr(1)
  length& = LOF(1)
CLOSE

IF length& <> 0 THEN

  REM *** PALETTE ***
  where& = length& - 767
  FOR col = 0 TO 255
    r = INT(GetData(where&) / 4)
    g = INT(GetData(where& + 1) / 4)
    b = INT(GetData(where& + 2) / 4)
    PalSet col, r, g, b
    where& = where& + 3
  NEXT col

  REM *** DECODE / DISPLAY ***
  where& = 129 'Skip Header
  g = 0 ' Current screen location

  WHILE g <> -1536
    a = GetData(where&)
    IF a < 192 THEN
      DEF SEG = &HA000
      POKE g, a
      IF g < 32767 THEN
      g = g + 1
      ELSE
        g = &H8000
      END IF
      where& = where& + 1
    ELSE                                  ' Run RLE decompression
      F = a - 192
      where& = where& + 1
      a = GetData(where&)
      where& = where& + 1
      FOR b = 1 TO F
        DEF SEG = &HA000
        POKE g, a
        IF g < 32767 THEN
          g = g + 1
        ELSE
          g = &H8000
        END IF
      NEXT b
    END IF
  WEND

  WHILE INKEY$ = "": WEND
  SCREEN 0: SCREEN 13
END IF

END SUB

SUB DrawCritters

  ' Big Ones
  FOR a = 0 TO 2
    IF a = 0 THEN c = 2
    IF a = 1 THEN c = 4
    IF a = 2 THEN c = 1
    xo = a * 90
    LINE (50 + xo, 150)-(60 + xo, 130), c
    LINE (90 + xo, 150)-(80 + xo, 130), c
    CIRCLE (70 + xo, 150), 20, c, 3.142, , .2
    CIRCLE (70 + xo, 120), 18, c, , , .6
    PAINT (70 + xo, 150), c + 8, c
    PAINT (70 + xo, 120), c + 8, c
    LINE (73 + xo, 117)-(79 + xo, 121), 15, BF
    LINE (61 + xo, 117)-(67 + xo, 121), 15, BF
    CIRCLE (64 + xo, 119), 4, 0
    CIRCLE (76 + xo, 119), 4, 0
    LINE (63 + xo, 120)-(65 + xo, 121), 0, BF
    LINE (75 + xo, 120)-(77 + xo, 121), 0, BF
    CIRCLE (70 + xo, 125), 5.5, 0, 3.142, , .3
  NEXT a

  ' Midi Ones
  FOR a = 0 TO 3
    IF a = 0 THEN c = 4
    IF a = 1 THEN c = 1
    IF a = 2 THEN c = 4
    IF a = 3 THEN c = 2
    xo = a * 71
    LINE (39 + xo, 100)-(47 + xo, 84), c
    LINE (71 + xo, 100)-(63 + xo, 84), c
    CIRCLE (55 + xo, 100), 16, c, 3.142, , .2
    CIRCLE (55 + xo, 76), 14.4, c, , , .6
    PAINT (55 + xo, 100), c + 8, c
    PAINT (55 + xo, 76), c + 8, c
    LINE (47 + xo, 74)-(53 + xo, 76), 0, BF
    LINE (48 + xo, 73)-(52 + xo, 77), 0, BF
    LINE (48 + xo, 74)-(52 + xo, 76), 15, BF
    LINE (57 + xo, 74)-(63 + xo, 76), 0, BF
    LINE (58 + xo, 73)-(62 + xo, 77), 0, BF
    LINE (58 + xo, 74)-(62 + xo, 76), 15, BF
    LINE (49 + xo, 76)-(51 + xo, 76), 0, BF
    LINE (59 + xo, 76)-(61 + xo, 76), 0, BF
    CIRCLE (55 + xo, 80), 4.4, 0, 3.142, , .3
  NEXT a
 
  ' Li'l Ones
  FOR a = 0 TO 4
    IF a = 0 THEN c = 1
    IF a = 1 THEN c = 2
    IF a = 2 THEN c = 4
    IF a = 3 THEN c = 2
    IF a = 4 THEN c = 1
    xo = a * 60
    LINE (28 + xo, 60)-(34 + xo, 48), c
    LINE (52 + xo, 60)-(46 + xo, 48), c
    CIRCLE (40 + xo, 60), 12, c, 3.142, , .2
    CIRCLE (40 + xo, 42), 10.8, c, , , .6
    PAINT (40 + xo, 60), c + 8, c
    PAINT (40 + xo, 42), c + 8, c
    LINE (36 + xo, 40)-(38 + xo, 42), 15, BF
    LINE (42 + xo, 40)-(44 + xo, 42), 15, BF
    CIRCLE (37 + xo, 41), 2, 0
    CIRCLE (43 + xo, 41), 2, 0
    PSET (37 + xo, 42), 0
    PSET (43 + xo, 42), 0
    CIRCLE (40 + xo, 45), 3.3, 0, 3.142, , .3
  NEXT a


END SUB

SUB EraseCrit (num)

  PUT (Hole(num).x, Hole(num).y), bkgnd(0, Hole(num).size), PSET

  Hole(num).crit.pres = False
 
END SUB

FUNCTION GetData (adrs&)

  DEF SEG = VARSEG(bufr(0))
  GetData = PEEK(adrs& - 1)

END FUNCTION

SUB InitHoles

  RESTORE HoleData

  FOR a = 1 TO 12
    READ Hole(a).x
    READ Hole(a).y
    READ Hole(a).size
    READ Hole(a).leng
 
    Hole(a).crit.pres = False
    Hole(a).crit.time = 0
 
  NEXT a

END SUB

SUB Initialize
 
  SCREEN 13
  CLS
  RANDOMIZE TIMER

  IF ViewPCX = True THEN DispPCX "splat.dat"
  IF Help = True THEN DispHelp
  InitHoles
  BackDrop
  InitImages
  Disp 1, 14, "Prepare to"
  Disp 2, 12, ">>>> S P L A T <<<<"

  MouseInit
  MouseShow

  RESTORE LevelData
  FOR a = 1 TO 12
    READ Level(a).score
    READ Level(a).mcrit
    READ Level(a).speed
    READ Level(a).bclim
    READ Level(a).rclim
  NEXT a

END SUB

' Must be run after Background
' Must be run after InitHoles
SUB InitImages

  RESTORE ImgRefData

  FOR a = 1 TO 3
    READ p
    xfar = Hole(p).x + Hole(p).leng
    yfar = Hole(p).y + Hole(p).leng
    GET (Hole(p).x, Hole(p).y)-(xfar, yfar), bkgnd(0, a)
  NEXT a

 
  DrawCritters
 
  FOR a = 1 TO 9
    READ p
    xfar = Hole(p).x + Hole(p).leng
    yfar = Hole(p).y + Hole(p).leng
    GET (Hole(p).x, Hole(p).y)-(xfar, yfar), image(0, a)
  NEXT a


END SUB

SUB MainGame

  SoundFX = True
 
  DO
 
  WHILE INKEY$ <> "": WEND
  WHILE a$ = ""
    a$ = INKEY$
    MouseStatus lb%, rb%, x%, y%
    IF lb% <> 0 THEN a$ = "X"
  WEND

  Disp 1, 1, ""
  Disp 2, 1, ""
  FOR a = 1 TO 12
    EraseCrit a
  NEXT a
 
  THits = 0
  score = 0
  Shots = 0
  Escaped = 0
  Critup = 0
  PalClock = 0
  curlev = 1
  Critmax = Level(curlev).mcrit
 
  ShootOk = True
  Quit = False
  Scroll = False

  DO
    FOR a = 1 TO 12
      IF Hole(a).crit.pres <> False THEN
        Hole(a).crit.time = Hole(a).crit.time - 1
        IF Hole(a).crit.time <= 0 THEN
          EraseCrit (a)
          Critup = Critup - 1
          Escaped = Escaped + 1
          UpdateDisplay
          SoundEffect 1
        END IF
      ELSE
        IF Hole(a).crit.dead = True THEN
          Hole(a).crit.time = Hole(a).crit.time - 1
          IF MouseOver(a, x%, y%, False) = False THEN EraseCrit a
          IF Hole(a).crit.time <= 0 THEN
            Critup = Critup - 1
            Hole(a).crit.dead = False
          END IF
        ELSE
          IF Critup < Critmax AND (RND > .98) THEN
            WhichCrit = 1
            j = INT(RND * 20)
            IF j > Level(a).rclim THEN WhichCrit = 2
            IF j > Level(a).bclim THEN WhichCrit = 3
            PlaceCrit a, WhichCrit
            Hole(a).crit.time = (4 - Hole(a).crit.pres) * 180 - Level(curlev).speed * 10
            Critup = Critup + 1
          ELSE
            IF MouseOver(a, x%, y%, False) = False THEN EraseCrit a
          END IF
        END IF
      END IF
    NEXT a

    PalClock = PalClock + 1
    IF PalClock = 100 THEN
      IF Scroll = True THEN PalScroll
      PalClock = 0
    END IF

    CheckLevel
                                                     
    FOR a = 1 TO 11 - Level(curlev).speed
      MouseStatus lb%, rb%, x%, y%
      IF lb% = -1 THEN
        IF ShootOk = True THEN DetectHit x%, y%
        ShootOk = False
      ELSE
        ShootOk = True
      END IF
      a$ = INKEY$
      IF a$ = " " THEN PauseGame
      IF a$ = CHR$(27) THEN Quit = True
      IF a$ = CHR$(0) + CHR$(68) THEN SoundFX = NOT SoundFX
      IF a$ = CHR$(0) + CHR$(66) THEN Scroll = NOT Scroll
    NEXT a

  LOOP UNTIL Escaped = 50 OR Quit = True

  IF Quit = False THEN SoundEffect 4

  LOOP WHILE NewGame = True

  MouseHide
 
  SCREEN 9
  SCREEN 0, 0, 0
  CLS
  COLOR 15

END SUB

' Access Machince Code Subroutine
'
SUB MouseDriver (ax%, bx%, cx%, dx%)
  DEF SEG = VARSEG(mouse$)
  mouse% = SADD(mouse$)
  CALL Absolute(ax%, bx%, cx%, dx%, mouse%)
END SUB

' Disables automatic display of cursor
'
SUB MouseHide
 ax% = 2
 MouseDriver ax%, 0, 0, 0
END SUB

' Initialize Mouse
'
SUB MouseInit

  RESTORE MouseData
  mouse$ = SPACE$(57)
  FOR I% = 1 TO 57
    READ a$
    h$ = CHR$(INT(VAL("&H" + a$)))
    MID$(mouse$, I%, 1) = h$
  NEXT I%
 
  ax% = 0
  MouseDriver ax%, 0, 0, 0

END SUB

FUNCTION MouseOver (num, x, y, acc)

  SELECT CASE acc

    CASE True
 
      IF Hole(num).x < x AND Hole(num).x + Hole(num).leng > x THEN
      IF Hole(num).y < y AND Hole(num).y + Hole(num).leng > y THEN
        MouseOver = True
      ELSE
        MouseOver = False
      END IF
      END IF
  
    CASE False

      IF Hole(num).x - 16 < x AND Hole(num).x + Hole(num).leng > x THEN
      IF Hole(num).y - 16 < y AND Hole(num).y + Hole(num).leng > y THEN
        MouseOver = True
      ELSE
        MouseOver = False
      END IF
      END IF
 
  END SELECT


END FUNCTION

' Move the current cursor position of the mouse to (x%, y%)
'
SUB MousePut (x%, y%)
  ax% = 4
  cx% = x%
  dx% = y%
  MouseDriver ax%, 0, cx%, dx%
END SUB

' Enables automatic display of cursor
'
SUB MouseShow
  ax% = 1
  MouseDriver ax%, 0, 0, 0
END SUB

' Return current mouse Status
' Position status and button status
'
SUB MouseStatus (lb%, rb%, Xmouse%, Ymouse%)
  ax% = 3
  MouseDriver ax%, bx%, cx%, dx%
  lb% = ((bx% AND 1) <> 0)
  rb% = ((bx% AND 2) <> 0)
  Xmouse% = INT(cx% / 2)
  Ymouse% = dx%
END SUB

FUNCTION NewGame
 
  MouseHide

  GET (80, 60)-(240, 130), pausefrm
  LINE (80, 60)-(240, 130), 14, BF
  LINE (80, 60)-(240, 130), 0, B
  LINE (83, 63)-(237, 127), 0, BF

  COLOR 13
  LOCATE 10, 14: PRINT "END OF GAME"
  LOCATE 12, 14: PRINT "Score ="; STR$(score) + "0"
  LOCATE 14, 14: PRINT "Do you wish to"
  LOCATE 15, 14: PRINT "play again ?"
 
  flag = False: Replay = True
  DO
    a$ = UCASE$(INKEY$)
    IF a$ = CHR$(27) OR a$ = "Q" OR a$ = "N" THEN Replay = False: flag = True
    IF a$ = CHR$(13) OR a$ = "Y" OR a$ = " " THEN Replay = True: flag = True
  LOOP UNTIL flag = True

  PUT (80, 60), pausefrm, PSET

  MouseShow

  IF Replay = True THEN
    FOR a = 1 TO 12
      PlaceCrit a, INT(RND * 3) + 1
      Hole(a).crit.time = 0
      Hole(a).crit.pres = False
      Disp 1, 14, "Prepare to"
      Disp 2, 12, ">>>> S P L A T <<<<"
    NEXT a
  END IF
  NewGame = Replay

END FUNCTION

SUB PalGet (col, r, g, b)

  OUT &H3C6, &HFF
  OUT &H3C7, col
  r = INP(&H3C9)
  g = INP(&H3C9)
  b = INP(&H3C9)
  
END SUB

SUB PalScroll

  PalGet 32, rx, gx, bx

  FOR a = 32 TO 54
    PalGet a + 1, r, g, b
    PalSet a, r, g, b
  NEXT a

  PalSet 55, rx, gx, bx

END SUB

SUB PalSet (col, r, g, b)

  OUT &H3C6, &HFF
  OUT &H3C8, col
  OUT &H3C9, r
  OUT &H3C9, g
  OUT &H3C9, b

END SUB

SUB PauseGame

  MouseHide

  GET (80, 60)-(240, 130), pausefrm
  LINE (80, 60)-(240, 130), 14, BF
  LINE (80, 60)-(240, 130), 0, B
  LINE (83, 63)-(237, 127), 0, BF

  COLOR 13
  LOCATE 10, 15: PRINT "GAME PAUSED"
  LOCATE 12, 14: PRINT "Press any key"
  LOCATE 13, 14: PRINT "to resume the"
  LOCATE 14, 18: PRINT "game."
  WHILE INKEY$ <> "": WEND
  WHILE INKEY$ = "": WEND
  PUT (80, 60), pausefrm, PSET

  MouseShow

END SUB

SUB PlaceCrit (num, difi)

  imgRef = Hole(num).size * 3 + difi - 3
  PUT (Hole(num).x, Hole(num).y), image(0, imgRef), PSET
 
  Hole(num).crit.pres = difi
  Hole(num).crit.dead = False
  
END SUB

SUB SoundEffect (num)

  IF SoundFX = True THEN

    SELECT CASE num
      CASE 1 ' Critter Pop Up
        FOR a = 300 TO 1000 STEP 50
          SOUND a, .1
        NEXT a
      CASE 2 ' Missed shot
        FOR a = 1 TO 4
          FOR b = 3000 TO 1000 STEP -100
            SOUND b, .05
          NEXT b
        NEXT a
      CASE 3 ' Got him
        FOR a = 1 TO 2
          FOR b = 2800 TO 1200 STEP -110
            SOUND b, .1
          NEXT b
        NEXT a
      CASE 4 ' End of Game
        FOR a = 2400 TO 3000 STEP 15
          SOUND a, .1
        NEXT a
        FOR a = 3000 TO 500 STEP -10
          SOUND a, .1
        NEXT a
      CASE 5 ' Next stage
        FOR a = 100 TO curlev * 50 + 100 STEP curlev
          SOUND a, .1
        NEXT a
    END SELECT
 
  END IF

END SUB

SUB UpdateDisplay

  COLOR 9: LOCATE 24, 1: PRINT "Score ="; STR$(score) + "0";
  COLOR 14: LOCATE 25, 1: PRINT "Shots ="; Shots;
  COLOR 10: LOCATE 24, 16: PRINT "Hits    ="; THits;
  COLOR 13: LOCATE 25, 16: PRINT "Escaped ="; Escaped;
  COLOR 12: LOCATE 24, 31: PRINT "Speed ="; Level(curlev).speed;
  COLOR 11: LOCATE 25, 31: PRINT "Crits ="; Critmax;

END SUB
