Unit BigRunningString;

Interface
type tchar=array[0..15] of byte;
     tfont=array[0..255] of tchar;
     screen=array[1..26,1..80,1..2] of char;

     tRunningString=object
       s:string; i,j,y:integer;
       Constructor Init(iy:byte; is:string);
       Procedure Draw; virtual;
       Procedure Next; virtual;
       Function StopString:boolean; virtual;
       Destructor Done; virtual;
     end;
     pRunningString=^tRunningString;
     Procedure Waitretrace;
     Procedure BigWrite(x,y:integer; s:string; var m:screen);
implementation
uses crt;
var font:tfont;
    video:screen absolute $B800:0000;

Procedure SaveChar(CharNum: Byte; var Pic:tchar);
Begin
  Inline($FA);PortW[$3C4]:=$0402;PortW[$3C4]:=$0704;PortW[$3CE]:=$0204;
  PortW[$3CE]:=$0005;PortW[$3CE]:=$0006;Move(Pic, Mem[$A000:CharNum*32], 16);
  PortW[$3C4]:=$0302;PortW[$3C4]:=$0304;PortW[$3CE]:=$0004;PortW[$3CE]:=$1005;
  PortW[$3CE]:=$0E06;Inline($FB);
end;

Procedure LoadChar(CharNum: Byte; var Pic:tchar);
Begin
  Inline($FA);PortW[$3C4]:=$0402;PortW[$3C4]:=$0704;PortW[$3CE]:=$0204;
  PortW[$3CE]:=$0005;PortW[$3CE]:=$0006;Move(Mem[$A000:CharNum*32],Pic, 16);
  PortW[$3C4]:=$0302;PortW[$3C4]:=$0304;PortW[$3CE]:=$0004;PortW[$3CE]:=$1005;
  PortW[$3CE]:=$0E06;Inline($FB);
end;

Const BigFont:array['A'..'Z',1..4] of string[9]=(
  {A}    (' ¿  ','     ','   ','     '),
  {B}    (' ¿   ','  _   ','   ۿ  ','   '),
  {C}    (' ¿  ','       ','       ','   '),
  {D}    (' ¿  ','     ','     ','   '),
  {E}    (' ¿  ','      ','       ','   '),
  {F}    (' ¿  ','       ','     ','      '),
  {G}    (' ¿  ','       ','  ¿  ','   '),
  {H}    (' ڿ  ڿ  ','     ','   ','     '),
  {I}    (' ¿  ','       ','       ','   '),
  {J}    ('   ','       ',' ڿ    ','    '),
  {K}    ('   ڿ  ','    ','   ۿ  ','    '),
  {L}    (' ¿    ','       ','   ڿ  ','   '),
  {M}    (' ڿ  ڿ  ',' ۿ  ','   ','     '),
  {N}    (' ڿ  ڿ  ',' ۿ   ','   ','    '),
  {O}    (' ¿  ','     ','     ','   '),
  {P}    (' ¿  ','     ','   ','       '),
  {Q}    (' ¿  ','     ','    ',' ۿ '),
  {R}    (' ¿  ','     ','   ','   ¿ '),
  {S}    (' ¿  ',' ۿ     ','    ۿ  ','   '),
  {T}    (' ¿  ','       ','       ','  ¿   '),
  {U}    (' ڿ  ڿ  ','     ','     ','   '),
  {V}    (' ڿ  ڿ  ','     ','     ','     '),
  {W}    ('ڿ    ڿ ','     ','ڿڿ ','   '),
  {X}    (' ڿ  ڿ  ','     ','  ¿   ','     '),
  {Y}    (' ڿ  ڿ  ','     ','       ','     '),
  {Z}    (' ¿  ','      ','      ','   '));

{$L textmode.obj}
Procedure TextModeFont; external;

Procedure WaitRetrace; assembler;
Asm
  MOV DX,$03DA
@@1:
  IN AL,DX
  TEST AL,8
  JZ @@1
@@2:
  IN  AL,DX
  TEST AL,8
  JNZ @@2
End;

Procedure BigWriteChar(x,y:integer; c:char; var m:screen);
var i,j:byte;
begin
  for i:=1 to 4 do for j:=1 to 9 do
   if (x+j>1) and (x+j<82) then m[y+i-1,x+j-1,1]:=BigFont[c,i,j];
end;

Procedure BigWrite(x,y:integer; s:string; var m:screen);
var i:byte;
begin
  for i:=1 to length(s) do if s[i] in ['A'..'Z'] then BigWriteChar(x+(i-1)*8,y,s[i],m);
end;


Constructor tRunningString.Init(iy:byte; is:string);
var ji:byte;
begin
  move(mem[Seg(TextModeFont):ofs(TextModeFont)],font,4096);
  for ji:=0 to 255 do SaveChar(ji,font[ji]);
  s:='          '+is; y:=iy; i:=1; j:=0;
  draw;
end;

Procedure tRunningString.Draw;
var m:^screen;
begin
  New(m);
  move(video[y],m^[y],160*4);
  BigWrite(j,y,copy(s,i,11),m^);
  dec(j);
  if j<-7 then begin j:=0; inc(i); if i>length(s) then i:=1; end;

  move(m^[y],video[y],160*4);
  dispose(m);
end;

Procedure tRunningString.Next;
begin Draw end;

Function tRunningString.StopString:boolean;
begin
  StopString:= (i=11) and (j=0);
end;

Destructor tRunningString.Done;
begin end;


begin
end.