DECLARE FUNCTION LoadAndPlayMIDI% (filename$)
DECLARE FUNCTION SongTime! ()
DECLARE SUB Again ()
DECLARE SUB CheckSetup ()
DECLARE SUB NextSong ()
DECLARE SUB DrawMenuBackGround ()
DECLARE SUB CheckInput ()
DECLARE SUB Help ()
DECLARE SUB Intro ()
DECLARE SUB SelectDelay ()
DECLARE SUB PutBlock ()
DECLARE SUB DrawBackGround ()
DECLARE SUB RandomBlock ()
DECLARE SUB StartingValue ()
DECLARE SUB DropBlock ()
DECLARE SUB RotateBlock ()
DECLARE SUB CheckLeft ()
DECLARE SUB CheckRight ()
DECLARE SUB RemoveBlock ()
DECLARE SUB RemoveRow (RowNr%)
DECLARE SUB CheckDown ()
DECLARE SUB NextBlock ()
DECLARE SUB CheckForFullRows ()
DECLARE SUB CheckSort ()
DECLARE SUB UpdateScore ()
DECLARE SUB PrintHighScores ()
DECLARE SUB Check ()
DECLARE SUB DisplayNextBlock ()
DECLARE SUB SaveHighScores ()
DECLARE SUB InputName ()
DECLARE SUB NameInput (Length%, b%, c%)
DECLARE SUB CheckHighScore ()
DECLARE SUB MenuScreen ()
DECLARE SUB OpenHighScores ()
DECLARE SUB Title ()
DECLARE SUB GetBlocks ()
DECLARE SUB StopMidi ()

DIM SHARED Over AS INTEGER, output$
DIM SHARED Temp1(121) AS INTEGER, Temp2(121) AS INTEGER, Temp3(121) AS INTEGER
DIM SHARED Temp4(121) AS INTEGER, Temp5(121) AS INTEGER
DIM SHARED BlockNext AS INTEGER, Score AS INTEGER, Level AS INTEGER
DIM SHARED CurrentBlock AS INTEGER, FirstTime AS INTEGER
DIM SHARED x AS INTEGER, Y AS INTEGER, Tim AS SINGLE, Sort AS INTEGER
DIM SHARED Delay AS SINGLE, TempDelay AS SINGLE, Speed AS INTEGER
DIM SHARED Rows AS INTEGER
DIM SHARED Name1 AS STRING * 6, Name2 AS STRING * 6, Name3 AS STRING * 6
DIM SHARED Name4 AS STRING * 6, Name$
DIM SHARED Score1 AS LONG, Score2 AS LONG, Score3 AS LONG
DIM SHARED menu(1 TO 4) AS INTEGER, MaxRows AS INTEGER, ExitSub AS INTEGER
DIM SHARED PlaySound AS INTEGER, Tim2 AS SINGLE, Song AS INTEGER
DIM SHARED FirstSong  AS INTEGER
COMMON SHARED BasePort%, LenPort%, Channel%

'$INCLUDE: 'future.bi'
'$DYNAMIC
CLS : SCREEN 12: DEFINT A-Z
CONST ScorePerBlock = 1
CONST ScorePerSingle = 10
CONST ScorePerDouble = 25
CONST ScorePerTriple = 40
CONST ScorePerTetris = 60

StopMidi
CheckSetup              '*** Check for setup (sound) ***
OpenHighScores          '*** Open the highscores ***
Title                   '*** Display intro ***
Beginning:
GetBlocks               '*** Get the blocks from a files (Tetris.gfx) ***
DrawBackGround          '*** Draws the Background ***
StartingValue           '*** Value of the variables ***
SelectDelay             '*** Select the delay (level) ***
RandomBlock             '*** Next block is random ***
DisplayNextBlock        '*** Show the next block
UpdateScore
PutBlock

timerstart:
Tim = TIMER                             '*** Start the timer ***
Start:
DO: k$ = INKEY$                         '*** Check key$ ***
IF TIMER > Tim + Delay THEN CheckDown: GOTO timerstart
IF PlaySound = 1 THEN
IF TIMER >= Tim2 + SongTime! THEN NextSong: Tim2 = TIMER   '*** Next midi ***
END IF
IF k$ <> "" THEN P = ASC(RIGHT$(k$, 1)): EXIT DO
LOOP UNTIL LEN(k$)

SELECT CASE P                           '*** Which key is pressed? ***
CASE 27:                                '*** ESC ***
StopMidi
CheckHighScore
AgainBox12
Again
GOTO Beginning
CASE 32: DropBlock                      '*** Spacebar ***
CASE 72: RotateBlock                    '*** UP ***
CASE 75: CheckLeft                      '*** LEFT ***
CASE 77: CheckRight                     '*** RIGHT ***
CASE 80: CheckDown: GOTO timerstart     '*** DOWN ***
CASE 112: Pause
END SELECT
IF Over THEN Over = 0: GOTO Beginning
GOTO Start
END

101       '*** Highscores not found, create new highscores ***
Name1$ = "Jorden": Name2$ = "Jorden": Name3$ = "Jorden"
Score1 = 1000: Score2 = 500: Score3 = 250: MaxRows = 10
SaveHighScores
RESUME                          '*** resume program

103                             '*** didn't run setup first... ***
LOCATE 1, 1: PRINT "Please run SETUP.EXE first..."
LOCATE 2, 1: PRINT "Press any key to continue"
DO: LOOP WHILE INKEY$ = ""
END

104 StopMidi
CLS                     '*** You miss a file! ***
LOCATE 1, 1: PRINT "File not found! Please be sure all the files are in the same directory!"
PRINT "Press any key to continue"
DO: LOOP WHILE INKEY$ = ""
END

105 CLS : SCREEN 12
LOCATE 1, 1: PRINT "An error happened! Ending..."
DO: LOOP WHILE INKEY$ = ""
END

REM $STATIC
SUB Again
'*** Restore old values, display menu-screen again ***
Score = 0: Level = 1: ExitSub = 0: Delay = 1.5: x = 160: Y = 20: Level = 1
FirstSong = 0
MenuScreen
NextSong
END SUB

SUB Check
'*** Check if the blocks reach the top, check if you're in the next level ***
FOR A = 130 TO 210 STEP 20
        FOR b = 30 TO 70 STEP 20
                IF POINT(A, b) THEN
IF PlaySound = 1 THEN StopMidi: WavPlay "ohmygod.wav", 20000
        CheckHighScore
        AgainBox12
        Again
        Over = 1
        END IF
        NEXT
NEXT
IF Rows >= Level * 10 THEN
Level = Level + 1
END IF
END SUB

SUB CheckDown
'*** Check under your block ***
SELECT CASE CurrentBlock
CASE 1:
IF POINT(x + 10, Y + 50) THEN NextBlock: EXIT SUB
IF POINT(x + 30, Y + 50) THEN NextBlock: EXIT SUB
CASE 2:
IF POINT(x + 10, Y + 50) THEN NextBlock: EXIT SUB
IF POINT(x + 30, Y + 50) THEN NextBlock: EXIT SUB
IF POINT(x + 50, Y + 50) THEN NextBlock: EXIT SUB
CASE 3:
IF POINT(x + 30, Y + 70) THEN NextBlock: EXIT SUB
IF POINT(x + 50, Y + 50) THEN NextBlock: EXIT SUB
CASE 4:
IF POINT(x + 30, Y + 70) THEN NextBlock: EXIT SUB
IF POINT(x + 50, Y + 50) THEN NextBlock: EXIT SUB
IF POINT(x + 10, Y + 50) THEN NextBlock: EXIT SUB
CASE 5:
IF POINT(x + 10, Y + 50) THEN NextBlock: EXIT SUB
IF POINT(x + 30, Y + 70) THEN NextBlock: EXIT SUB
CASE 6:
IF POINT(x + 10, Y + 90) THEN NextBlock: EXIT SUB
CASE 7:
IF POINT(x + 10, Y + 70) THEN NextBlock: EXIT SUB
IF POINT(x + 30, Y + 70) THEN NextBlock: EXIT SUB
IF POINT(x + 50, Y + 70) THEN NextBlock: EXIT SUB
IF POINT(x + 70, Y + 70) THEN NextBlock: EXIT SUB
CASE 8:
IF POINT(x + 10, Y + 70) THEN NextBlock: EXIT SUB
IF POINT(x + 30, Y + 70) THEN NextBlock: EXIT SUB
CASE 9:
IF POINT(x + 10, Y + 50) THEN NextBlock: EXIT SUB
IF POINT(x + 30, Y + 50) THEN NextBlock: EXIT SUB
IF POINT(x + 50, Y + 50) THEN NextBlock: EXIT SUB
CASE 10:
IF POINT(x + 10, Y + 30) THEN NextBlock: EXIT SUB
IF POINT(x + 30, Y + 70) THEN NextBlock: EXIT SUB
CASE 11:
IF POINT(x + 10, Y + 70) THEN NextBlock: EXIT SUB
IF POINT(x + 30, Y + 50) THEN NextBlock: EXIT SUB
IF POINT(x + 50, Y + 50) THEN NextBlock: EXIT SUB
CASE 12:
IF POINT(x + 10, Y + 70) THEN NextBlock: EXIT SUB
IF POINT(x + 30, Y + 70) THEN NextBlock: EXIT SUB
CASE 13:
IF POINT(x + 10, Y + 30) THEN NextBlock: EXIT SUB
IF POINT(x + 30, Y + 30) THEN NextBlock: EXIT SUB
IF POINT(x + 50, Y + 50) THEN NextBlock: EXIT SUB
CASE 14:
IF POINT(x + 10, Y + 70) THEN NextBlock: EXIT SUB
IF POINT(x + 30, Y + 30) THEN NextBlock: EXIT SUB
CASE 15:
IF POINT(x + 10, Y + 70) THEN NextBlock: EXIT SUB
IF POINT(x + 30, Y + 70) THEN NextBlock: EXIT SUB
IF POINT(x + 50, Y + 70) THEN NextBlock: EXIT SUB
CASE 16:
IF POINT(x + 10, Y + 30) THEN NextBlock: EXIT SUB
IF POINT(x + 30, Y + 50) THEN NextBlock: EXIT SUB
IF POINT(x + 50, Y + 50) THEN NextBlock: EXIT SUB
CASE 17:
IF POINT(x + 10, Y + 70) THEN NextBlock: EXIT SUB
IF POINT(x + 30, Y + 50) THEN NextBlock: EXIT SUB
CASE 18:
IF POINT(x + 10, Y + 50) THEN NextBlock: EXIT SUB
IF POINT(x + 30, Y + 50) THEN NextBlock: EXIT SUB
IF POINT(x + 50, Y + 30) THEN NextBlock: EXIT SUB
CASE 19:
IF POINT(x + 10, Y + 50) THEN NextBlock: EXIT SUB
IF POINT(x + 30, Y + 70) THEN NextBlock: EXIT SUB
END SELECT
RemoveBlock
Y = Y + 20
PutBlock
END SUB

SUB CheckForFullRows
'*** Check if any rows are full ***
Sort = 0
10 AA = 0
FOR A = 410 TO 30 STEP -20
       AA = AA + 1
        FOR b = 30 TO 310 STEP 20
                ch = POINT(b, A)
                IF ch = 0 THEN EXIT FOR
        NEXT
        IF ch THEN
        LINE (20, A - 10)-(320, A + 10), 0, BF
                RemoveRow AA
                GOTO 10
        END IF
NEXT
CheckSort
END SUB

SUB CheckHighScore
'*** Do you have a HIGHSCORE? ***
IF Score > Score3 THEN InputName
IF Score > Score3 AND Score <= Score2 THEN Score3 = Score: Name3$ = Name$
IF Score > Score2 AND Score <= Score1 THEN
Score3 = Score2: Name3$ = Name2$
Score2 = Score: Name2$ = Name$
END IF
IF Score > Score1 THEN
Score3 = Score2: Name3$ = Name2$
Score2 = Score1: Name2$ = Name1$
Score1 = Score: Name1$ = Name$
END IF

IF Rows > MaxRows THEN
IF Name$ = "" THEN InputName
MaxRows = Rows: Name4$ = Name$
END IF
SaveHighScores
END SUB

SUB CheckInput
'*** Where did you click? ***
MouseStatus Xm, Ym, Buttons
IF Buttons = 1 THEN
        IF Xm > 236 AND Xm < 328 THEN
                IF Ym >= 142 AND Ym < 159 THEN MouseHide: ExitSub = 1
                IF Ym >= 159 AND Ym < 176 THEN PrintHighScores
                IF Ym >= 176 AND Ym < 192 THEN Help
                IF Ym >= 192 AND Ym < 207 THEN END
        END IF
END IF
END SUB

SUB CheckLeft
'*** Check at the left site of your block ***
SELECT CASE CurrentBlock
CASE 1:
IF POINT(x - 10, Y + 10) THEN EXIT SUB
IF POINT(x - 10, Y + 30) THEN EXIT SUB
CASE 2:
IF POINT(x + 10, Y + 10) THEN EXIT SUB
IF POINT(x - 10, Y + 30) THEN EXIT SUB
CASE 3:
IF POINT(x + 10, Y + 10) THEN EXIT SUB
IF POINT(x + 10, Y + 30) THEN EXIT SUB
IF POINT(x + 10, Y + 50) THEN EXIT SUB
CASE 4:
IF POINT(x - 10, Y + 30) THEN EXIT SUB
IF POINT(x + 10, Y + 50) THEN EXIT SUB
CASE 5:
IF POINT(x + 10, Y + 10) THEN EXIT SUB
IF POINT(x - 10, Y + 30) THEN EXIT SUB
IF POINT(x + 10, Y + 50) THEN EXIT SUB
CASE 6:
IF POINT(x - 10, Y + 10) THEN EXIT SUB
IF POINT(x - 10, Y + 30) THEN EXIT SUB
IF POINT(x - 10, Y + 50) THEN EXIT SUB
IF POINT(x - 10, Y + 70) THEN EXIT SUB
CASE 7:
IF POINT(x - 10, Y + 50) THEN EXIT SUB
CASE 8:
IF POINT(x - 10, Y + 10) THEN EXIT SUB
IF POINT(x - 10, Y + 30) THEN EXIT SUB
IF POINT(x - 10, Y + 50) THEN EXIT SUB
CASE 9:
IF POINT(x + 30, Y + 10) THEN EXIT SUB
IF POINT(x - 10, Y + 30) THEN EXIT SUB
CASE 10:
IF POINT(x - 10, Y + 10) THEN EXIT SUB
IF POINT(x + 10, Y + 30) THEN EXIT SUB
IF POINT(x + 10, Y + 50) THEN EXIT SUB
CASE 11:
IF POINT(x - 10, Y + 30) THEN EXIT SUB
IF POINT(x - 10, Y + 50) THEN EXIT SUB
CASE 12:
IF POINT(x + 10, Y + 10) THEN EXIT SUB
IF POINT(x + 10, Y + 30) THEN EXIT SUB
IF POINT(x - 10, Y + 50) THEN EXIT SUB
CASE 13:
IF POINT(x - 10, Y + 30) THEN EXIT SUB
IF POINT(x + 30, Y + 50) THEN EXIT SUB
CASE 14:
IF POINT(x - 10, Y + 10) THEN EXIT SUB
IF POINT(x - 10, Y + 30) THEN EXIT SUB
IF POINT(x - 10, Y + 50) THEN EXIT SUB
CASE 15:
IF POINT(x - 10, Y + 30) THEN EXIT SUB
IF POINT(x - 10, Y + 50) THEN EXIT SUB
CASE 16:
IF POINT(x - 10, Y + 10) THEN EXIT SUB
IF POINT(x + 10, Y + 30) THEN EXIT SUB
CASE 17:
IF POINT(x + 10, Y + 10) THEN EXIT SUB
IF POINT(x - 10, Y + 30) THEN EXIT SUB
IF POINT(x - 10, Y + 50) THEN EXIT SUB
CASE 18:
IF POINT(x + 10, Y + 10) THEN EXIT SUB
IF POINT(x - 10, Y + 30) THEN EXIT SUB
CASE 19:
IF POINT(x - 10, Y + 10) THEN EXIT SUB
IF POINT(x - 10, Y + 30) THEN EXIT SUB
IF POINT(x + 10, Y + 50) THEN EXIT SUB
END SELECT
RemoveBlock
x = x - 20
PutBlock
END SUB

SUB CheckRight
'*** Check at the right site of your block ***
SELECT CASE CurrentBlock
CASE 1:
IF POINT(x + 50, Y + 10) THEN EXIT SUB
IF POINT(x + 50, Y + 30) THEN EXIT SUB
CASE 2:
IF POINT(x + 50, Y + 10) THEN EXIT SUB
IF POINT(x + 70, Y + 30) THEN EXIT SUB
CASE 3:
IF POINT(x + 50, Y + 10) THEN EXIT SUB
IF POINT(x + 70, Y + 30) THEN EXIT SUB
IF POINT(x + 50, Y + 50) THEN EXIT SUB
CASE 4:
IF POINT(x + 70, Y + 50) THEN EXIT SUB
IF POINT(x + 50, Y + 70) THEN EXIT SUB
CASE 5:
IF POINT(x + 50, Y + 10) THEN EXIT SUB
IF POINT(x + 50, Y + 30) THEN EXIT SUB
IF POINT(x + 50, Y + 50) THEN EXIT SUB
CASE 6:
IF POINT(x + 30, Y + 10) THEN EXIT SUB
IF POINT(x + 30, Y + 30) THEN EXIT SUB
IF POINT(x + 30, Y + 50) THEN EXIT SUB
IF POINT(x + 30, Y + 70) THEN EXIT SUB
CASE 7:
IF POINT(x + 90, Y + 50) THEN EXIT SUB
CASE 8:
IF POINT(x + 30, Y + 10) THEN EXIT SUB
IF POINT(x + 30, Y + 30) THEN EXIT SUB
IF POINT(x + 50, Y + 50) THEN EXIT SUB
CASE 9:
IF POINT(x + 70, Y + 10) THEN EXIT SUB
IF POINT(x + 70, Y + 30) THEN EXIT SUB
CASE 10:
IF POINT(x + 50, Y + 10) THEN EXIT SUB
IF POINT(x + 50, Y + 30) THEN EXIT SUB
IF POINT(x + 50, Y + 50) THEN EXIT SUB
CASE 11:
IF POINT(x + 70, Y + 30) THEN EXIT SUB
IF POINT(x + 30, Y + 50) THEN EXIT SUB
CASE 12:
IF POINT(x + 50, Y + 10) THEN EXIT SUB
IF POINT(x + 50, Y + 30) THEN EXIT SUB
IF POINT(x + 50, Y + 50) THEN EXIT SUB
CASE 13:
IF POINT(x + 70, Y + 10) THEN EXIT SUB
IF POINT(x + 70, Y + 30) THEN EXIT SUB
CASE 14:
IF POINT(x + 50, Y + 10) THEN EXIT SUB
IF POINT(x + 30, Y + 30) THEN EXIT SUB
IF POINT(x + 30, Y + 50) THEN EXIT SUB
CASE 15:
IF POINT(x + 30, Y + 30) THEN EXIT SUB
IF POINT(x + 70, Y + 50) THEN EXIT SUB
CASE 16:
IF POINT(x + 50, Y + 10) THEN EXIT SUB
IF POINT(x + 70, Y + 30) THEN EXIT SUB
CASE 17:
IF POINT(x + 50, Y + 10) THEN EXIT SUB
IF POINT(x + 50, Y + 30) THEN EXIT SUB
IF POINT(x + 30, Y + 50) THEN EXIT SUB
CASE 18:
IF POINT(x + 70, Y + 10) THEN EXIT SUB
IF POINT(x + 50, Y + 30) THEN EXIT SUB
CASE 19:
IF POINT(x + 30, Y + 10) THEN EXIT SUB
IF POINT(x + 50, Y + 30) THEN EXIT SUB
IF POINT(x + 50, Y + 50) THEN EXIT SUB
END SELECT
RemoveBlock
x = x + 20
PutBlock
END SUB

SUB CheckSetup
'*** Do you want sound? ***
ON ERROR GOTO 103
CLOSE
OPEN "Sound.cfg" FOR INPUT AS 1
INPUT #1, PlaySound
CLOSE 1
END SUB

SUB CheckSort
'*** Check how many rows you have at a time ***
COLOR 14
SELECT CASE Sort
CASE 1:
        LOCATE 15, 50: PRINT "SINGLE"
        Score = Score + ScorePerSingle: Rows = Rows + 1
        IF PlaySound = 1 THEN WavPlay "FullRow.wav", 20000
CASE 2:
        LOCATE 15, 50: PRINT "DOUBLE"
        Score = Score + ScorePerDouble: Rows = Rows + 2
        IF PlaySound = 1 THEN WavPlay "FullRow2.wav", 20000
CASE 3:
        LOCATE 15, 50: PRINT "TRIPLE"
        Score = Score + ScorePerTriple: Rows = Rows + 3
        IF PlaySound = 1 THEN WavPlay "FullRow3.wav", 10000
CASE 4:
        LOCATE 15, 50: PRINT "TETRI$"
        Score = Score + ScorePerTetris: Rows = Rows + 4
        IF PlaySound = 1 THEN WavPlay "waytogo.wav", 10000
END SELECT
Check
END SUB

SUB DisplayNextBlock
'*** Display the next block ***
Box 400, 300, 520, 400, 0
SELECT CASE BlockNext
CASE 1:
PUT (410, 310), Temp1
PUT (410, 330), Temp1
PUT (430, 310), Temp1
PUT (430, 330), Temp1
CASE 2:
PUT (410, 330), Temp2
PUT (430, 330), Temp2
PUT (430, 310), Temp2
PUT (450, 330), Temp2
CASE 3:
PUT (410, 310), Temp2
PUT (410, 330), Temp2
PUT (410, 350), Temp2
PUT (430, 330), Temp2
CASE 4:
PUT (410, 310), Temp2
PUT (430, 310), Temp2
PUT (430, 330), Temp2
PUT (450, 310), Temp2
CASE 5:
PUT (430, 310), Temp2
PUT (430, 330), Temp2
PUT (430, 350), Temp2
PUT (410, 330), Temp2
CASE 6:
PUT (410, 310), Temp3
PUT (410, 330), Temp3
PUT (410, 350), Temp3
PUT (410, 370), Temp3
CASE 7:
PUT (410, 310), Temp3
PUT (430, 310), Temp3
PUT (450, 310), Temp3
PUT (470, 310), Temp3
CASE 8:
PUT (410, 310), Temp4
PUT (410, 330), Temp4
PUT (410, 350), Temp4
PUT (430, 350), Temp4
CASE 9:
PUT (410, 330), Temp4
PUT (430, 330), Temp4
PUT (450, 330), Temp4
PUT (450, 310), Temp4
CASE 10:
PUT (410, 310), Temp4
PUT (430, 310), Temp4
PUT (430, 330), Temp4
PUT (430, 350), Temp4
CASE 11:
PUT (410, 310), Temp4
PUT (410, 330), Temp4
PUT (430, 310), Temp4
PUT (450, 310), Temp4
CASE 12:
PUT (430, 310), Temp5
PUT (430, 330), Temp5
PUT (430, 350), Temp5
PUT (410, 350), Temp5
CASE 13:
PUT (410, 310), Temp5
PUT (430, 310), Temp5
PUT (450, 310), Temp5
PUT (450, 330), Temp5
CASE 14:
PUT (410, 310), Temp5
PUT (430, 310), Temp5
PUT (410, 330), Temp5
PUT (410, 350), Temp5
CASE 15:
PUT (410, 310), Temp5
PUT (410, 330), Temp5
PUT (430, 330), Temp5
PUT (450, 330), Temp5
CASE 16:
PUT (410, 310), Temp1
PUT (430, 310), Temp1
PUT (430, 330), Temp1
PUT (450, 330), Temp1
CASE 17:
PUT (430, 310), Temp1
PUT (430, 330), Temp1
PUT (410, 330), Temp1
PUT (410, 350), Temp1
CASE 18:
PUT (430, 310), Temp2
PUT (450, 310), Temp2
PUT (410, 330), Temp2
PUT (430, 330), Temp2
CASE 19:
PUT (410, 310), Temp2
PUT (410, 330), Temp2
PUT (430, 330), Temp2
PUT (430, 350), Temp2
END SELECT
END SUB

DEFSNG A-Z
SUB DrawBackGround
'*** Draw the background ***
Back
Box 19, 20, 320, 421, 0
Box 370, 20, 550, 420, 0
COLOR 10
LOCATE 5, 50: PRINT "SCORE: "
LOCATE 7, 50: PRINT "LEVEL: "
LOCATE 9, 50: PRINT "ROWS: "
LOCATE 11, 50: PRINT "HIGHSCORE: "; Score1
LOCATE 18, 50: PRINT "NEXT: "
Box 400, 300, 520, 400, 0
END SUB

DEFINT A-Z
SUB DrawMenuBackGround
'*** Draw the menu-background ***
CLS
CIRCLE (240, 150), 3, 4: PAINT (240, 150), 4
CIRCLE (240, 167), 3, 4: PAINT (240, 167), 4
CIRCLE (240, 182), 3, 4: PAINT (240, 182), 4
CIRCLE (240, 199), 3, 4: PAINT (240, 199), 4
COLOR 15
LOCATE 10, 32: PRINT " LAY GAME"
LOCATE 11, 33: PRINT "IGH SCORES"
LOCATE 12, 32: PRINT "H LP"
LOCATE 13, 33: PRINT "UIT"
COLOR 4
LOCATE 10, 32: PRINT "P"
LOCATE 11, 32: PRINT "H"
LOCATE 12, 33: PRINT "E"
LOCATE 13, 32: PRINT "Q"
END SUB

SUB DropBlock
'*** Drop the block ***
IF Speed = 0 THEN
TempDelay = Delay
Delay = .001: Speed = 1
END IF
END SUB

SUB GetBlocks
'*** Get the blocks fporm a file ***
CLOSE
OPEN "Tetris.gfx" FOR RANDOM AS #1 LEN = 8
FOR n = 0 TO 121
posit = posit + 1
GET #1, posit, Temp1(n)
NEXT n
FOR n = 0 TO 121
posit = posit + 1
GET #1, posit, Temp2(n)
NEXT n
FOR n = 0 TO 121
posit = posit + 1
GET #1, posit, Temp3(n)
NEXT n
FOR n = 0 TO 121
posit = posit + 1
GET #1, posit, Temp4(n)
NEXT n
FOR n = 0 TO 121
posit = posit + 1
GET #1, posit, Temp5(n)
NEXT n
CLOSE
END SUB

SUB Help
'*** Player selected help from menu-screen ***
MouseHide
CLS
SHELL "Type Tetris.txt|more"
DO: LOOP UNTIL INKEY$ <> ""
DrawMenuBackGround
MouseShow
END SUB

SUB InputName
'*** Asks for name (for high-score list) ***
Box 55, 155, 280, 250, 0
IF PlaySound = 1 THEN WavPlay "Doe.wav", 10000
LOCATE 12, 10: PRINT " You've broken a record! "
LOCATE 13, 10: PRINT "Please type in your name:"

NameInput 6, 2, 1
Name$ = output$
END SUB

SUB Intro
'*** The INTRO! ***
ON ERROR GOTO 104
IF PlaySound = 1 THEN
IF LoadAndPlayMIDI%("intro.mid") THEN GOTO StartIntro
END IF
StartIntro:
Scrollmessage$ = "FUTURE SOFTWARE PRESENTS:        TETRIS!   "
Scrollmessage$ = Scrollmessage$ + "     PROGRAMMED BY JORDEN CHAMID"
Scrollmessage$ = Scrollmessage$ + "     THANX TO MARCEL SMOLENAARS FOR THIS SCROLLTEXT (AND SOME OTHER THINGS)"
Scrollmessage$ = Scrollmessage$ + "     THANX ALSO TO R. GERAERTS FOR HIS GRABMAP/MAPVIEW UTILITY"
Scrollmessage$ = Scrollmessage$ + "     THANX TO MIKE HUFF FOR (PARTS OF) HIS WAV-PLAYER FOR QUICKBASIC"
Scrollmessage$ = Scrollmessage$ + "     THANX TO JESSE DORLAND (JESSEDORLAND@HOTMAIL.COM) FOR HIS QB-MIDI PLAYER"
Scrollmessage$ = Scrollmessage$ + "     VISIT MY HOMEPAGE AT HTTP://WWW.GEOCITIES.COM/SILICONVALLEY/BAY/7029"
Scrollmessage$ = Scrollmessage$ + "     E-MAIL ME AT CHAMID@GLOBALXS.NL"
Scrollmessage$ = Scrollmessage$ + SPACE$(20)
SetPal 128, 63, 0, 0
ScrollText Scrollmessage$, 183
END SUB

SUB MenuScreen
CLS : SCREEN 12
MouseInit
DrawMenuBackGround
MouseShow
MenuStart:
DO
CheckInput
A$ = INKEY$
IF A$ <> "" THEN EXIT DO
IF ExitSub = 1 THEN EXIT SUB
LOOP

SELECT CASE UCASE$(A$)
CASE CHR$(27): END
CASE "P": MouseHide: EXIT SUB
CASE "H": PrintHighScores
CASE "E": Help
CASE "Q": StopMidi: END
END SELECT
IF ExitSub = 1 THEN EXIT SUB
GOTO MenuStart
END SUB

SUB NameInput (Length, b, c)
output$ = "": i$ = "": lin = 14: min = 21: current = 0
COLOR b
WHILE i$ <> CHR$(13)
    LOCATE lin, min + current: PRINT "_"
    i$ = ""
    WHILE i$ = ""
      i$ = INKEY$
    WEND
    IF ASC(i$) > 31 AND ASC(i$) < 127 AND current <> Length THEN
      LOCATE lin, min + current: PRINT i$
      output$ = output$ + i$: current = current + 1
    END IF
    IF ASC(i$) = 8 AND current > 0 THEN
      current = current - 1: output$ = LEFT$(output$, LEN(output$) - 1)
      LOCATE lin, min + current + 1: PRINT " "
    END IF
  WEND
LOCATE lin, min + current: PRINT " "
END SUB

SUB NextBlock
Check
COLOR 0: LOCATE 15, 50: PRINT "      "
Score = Score + ScorePerBlock
CheckForFullRows
UpdateScore
IF Speed THEN Delay = TempDelay: Speed = 0
x = 160: Y = 20
RandomBlock
DisplayNextBlock
PutBlock
END SUB

SUB NextSong
StopMidi
Song = Song + 1
IF Song = 6 THEN Song = 1
IF FirstSong = 0 THEN FirstSong = 1: Song = RND * 4 + 1
SELECT CASE Song
CASE 1: IF LoadAndPlayMIDI%("Play1.mid") THEN EXIT SUB
CASE 2: IF LoadAndPlayMIDI%("Play2.mid") THEN EXIT SUB
CASE 3: IF LoadAndPlayMIDI%("Play3.mid") THEN EXIT SUB
CASE 4: IF LoadAndPlayMIDI%("Play4.mid") THEN EXIT SUB
CASE 5: IF LoadAndPlayMIDI%("Play5.mid") THEN EXIT SUB
END SELECT
END SUB

SUB OpenHighScores
ON ERROR GOTO 101
OPEN "Tetris.hs" FOR INPUT AS 1
INPUT #1, Name1$
INPUT #1, Score1
INPUT #1, Name2$
INPUT #1, Score2
INPUT #1, Name3$
INPUT #1, Score3
INPUT #1, Name4$
INPUT #1, MaxRows
CLOSE (1)
ON ERROR GOTO 105
END SUB

SUB PrintHighScores
IF PlaySound = 1 THEN WavPlay "Applaus.wav", 20000
Box 100, 340, 320, 430, 0
COLOR 15
LOCATE 23, 17: PRINT "1. "; Name1$; Score1
LOCATE 24, 17: PRINT "2. "; Name2$; Score2
LOCATE 25, 17: PRINT "3. "; Name3$; Score3
LOCATE 26, 17: PRINT "MOST ROWS: "; Name4$; MaxRows
DO
MouseStatus Xm, Ym, Buttons
IF Buttons = 1 THEN EXIT DO
LOOP UNTIL INKEY$ <> ""
LINE (90, 310)-(330, 440), 0, BF
END SUB

SUB PutBlock
SELECT CASE CurrentBlock
CASE 1:
PUT (x, Y + 1), Temp1: PUT (x + 20, Y + 1), Temp1
PUT (x, Y + 21), Temp1: PUT (x + 20, Y + 21), Temp1
CASE 2:
PUT (x, Y + 21), Temp2: PUT (x + 20, Y + 1), Temp2
PUT (x + 20, Y + 21), Temp2: PUT (x + 40, Y + 21), Temp2
CASE 3:
PUT (x + 20, Y + 1), Temp2: PUT (x + 20, Y + 21), Temp2
PUT (x + 20, Y + 41), Temp2: PUT (x + 40, Y + 21), Temp2
CASE 4:
PUT (x, Y + 21), Temp2: PUT (x + 20, Y + 21), Temp2
PUT (x + 40, Y + 21), Temp2: PUT (x + 20, Y + 41), Temp2
CASE 5:
PUT (x + 20, Y + 1), Temp2: PUT (x, Y + 21), Temp2
PUT (x + 20, Y + 21), Temp2: PUT (x + 20, Y + 41), Temp2
CASE 6:
PUT (x, Y + 1), Temp3: PUT (x, Y + 21), Temp3
PUT (x, Y + 41), Temp3: PUT (x, Y + 61), Temp3
CASE 7:
PUT (x, Y + 41), Temp3: PUT (x + 20, Y + 41), Temp3
PUT (x + 40, Y + 41), Temp3: PUT (x + 60, Y + 41), Temp3
CASE 8:
PUT (x, Y + 1), Temp4: PUT (x, Y + 21), Temp4
PUT (x, Y + 41), Temp4: PUT (x + 20, Y + 41), Temp4
CASE 9:
PUT (x + 40, Y + 1), Temp4: PUT (x + 40, Y + 21), Temp4
PUT (x + 20, Y + 21), Temp4: PUT (x, Y + 21), Temp4
CASE 10:
PUT (x, Y + 1), Temp4: PUT (x + 20, Y + 1), Temp4
PUT (x + 20, Y + 21), Temp4: PUT (x + 20, Y + 41), Temp4
CASE 11:
PUT (x, Y + 21), Temp4: PUT (x, Y + 41), Temp4
PUT (x + 20, Y + 21), Temp4: PUT (x + 40, Y + 21), Temp4
CASE 12:
PUT (x, Y + 41), Temp5: PUT (x + 20, Y + 1), Temp5
PUT (x + 20, Y + 21), Temp5: PUT (x + 20, Y + 41), Temp5
CASE 13:
PUT (x, Y + 1), Temp5: PUT (x + 20, Y + 1), Temp5
PUT (x + 40, Y + 1), Temp5: PUT (x + 40, Y + 21), Temp5
CASE 14:
PUT (x, Y + 1), Temp5: PUT (x, Y + 21), Temp5
PUT (x, Y + 41), Temp5: PUT (x + 20, Y + 1), Temp5
CASE 15:
PUT (x, Y + 21), Temp5: PUT (x, Y + 41), Temp5
PUT (x + 20, Y + 41), Temp5: PUT (x + 40, Y + 41), Temp5
CASE 16:
PUT (x, Y + 1), Temp1: PUT (x + 20, Y + 1), Temp1
PUT (x + 20, Y + 21), Temp1: PUT (x + 40, Y + 21), Temp1
CASE 17:
PUT (x + 20, Y + 1), Temp1: PUT (x + 20, Y + 21), Temp1
PUT (x, Y + 21), Temp1: PUT (x, Y + 41), Temp1
CASE 18:
PUT (x + 20, Y + 1), Temp2: PUT (x + 40, Y + 1), Temp2
PUT (x, Y + 21), Temp2: PUT (x + 20, Y + 21), Temp2
CASE 19:
PUT (x, Y + 1), Temp2: PUT (x, Y + 21), Temp2
PUT (x + 20, Y + 21), Temp2: PUT (x + 20, Y + 41), Temp2
END SELECT
END SUB

SUB RandomBlock
RANDOMIZE TIMER
IF FirstTime = 0 THEN
        FirstTime = 1
        A = (RND * 27) + 1
        IF A = 20 THEN A = 6
        IF A = 21 THEN A = 7
        IF A > 21 AND A < 25 THEN A = 1
        IF A = 25 THEN A = 16
        IF A = 26 THEN A = 17
        IF A = 27 THEN A = 18
        IF A = 28 THEN A = 19
        BlockNext = A
        A = (RND * 27) + 1
END IF

CurrentBlock = BlockNext
A = (RND * 27) + 1
IF A = 20 THEN A = 6
IF A = 21 THEN A = 7
IF A > 21 AND A < 25 THEN A = 1
IF A = 25 THEN A = 16
IF A = 26 THEN A = 17
IF A = 27 THEN A = 18
IF A = 28 THEN A = 19

BlockNext = A
IF BlockNext = 20 THEN CurrentBlock = 6
IF BlockNext = 21 THEN CurrentBlock = 7
IF BlockNext > 21 AND A < 25 THEN CurrentBlock = 1
IF BlockNext = 25 THEN CurrentBlock = 16
IF BlockNext = 26 THEN CurrentBlock = 17
IF BlockNext = 27 THEN CurrentBlock = 18
IF BlockNext = 28 THEN CurrentBlock = 19
END SUB

SUB RemoveBlock
SELECT CASE CurrentBlock
CASE 1: LINE (x, Y)-(x + 39, Y + 39), 0, BF
CASE 2:
LINE (x, Y + 20)-(x + 59, Y + 39), 0, BF
LINE (x + 20, Y)-(x + 39, Y + 19), 0, BF
CASE 3:
LINE (x + 20, Y)-(x + 39, Y + 59), 0, BF
LINE (x + 40, Y + 20)-(x + 59, Y + 39), 0, BF
CASE 4:
LINE (x, Y + 20)-(x + 59, Y + 39), 0, BF
LINE (x + 20, Y + 40)-(x + 39, Y + 59), 0, BF
CASE 5:
LINE (x + 20, Y)-(x + 39, Y + 59), 0, BF
LINE (x, Y + 20)-(x + 19, Y + 39), 0, BF
CASE 6: LINE (x, Y)-(x + 19, Y + 79), 0, BF
CASE 7: LINE (x, Y + 40)-(x + 79, Y + 59), 0, BF
CASE 8:
LINE (x, Y)-(x + 19, Y + 59), 0, BF
LINE (x + 20, Y + 40)-(x + 39, Y + 59), 0, BF
CASE 9:
LINE (x, Y + 20)-(x + 59, Y + 39), 0, BF
LINE (x + 40, Y)-(x + 59, Y + 19), 0, BF
CASE 10:
LINE (x + 20, Y)-(x + 39, Y + 59), 0, BF
LINE (x, Y)-(x + 19, Y + 19), 0, BF
CASE 11:
LINE (x, Y + 20)-(x + 59, Y + 39), 0, BF
LINE (x, Y + 40)-(x + 19, Y + 59), 0, BF
CASE 12:
LINE (x + 20, Y)-(x + 39, Y + 59), 0, BF
LINE (x, Y + 40)-(x + 19, Y + 59), 0, BF
CASE 13:
LINE (x, Y)-(x + 59, Y + 19), 0, BF
LINE (x + 40, Y + 20)-(x + 59, Y + 39), 0, BF
CASE 14:
LINE (x, Y)-(x + 19, Y + 59), 0, BF
LINE (x + 20, Y)-(x + 39, Y + 19), 0, BF
CASE 15:
LINE (x, Y + 40)-(x + 59, Y + 59), 0, BF
LINE (x, Y + 20)-(x + 19, Y + 39), 0, BF
CASE 16:
LINE (x, Y)-(x + 39, Y + 19), 0, BF
LINE (x + 20, Y + 20)-(x + 59, Y + 39), 0, BF
CASE 17:
LINE (x, Y + 20)-(x + 19, Y + 59), 0, BF
LINE (x + 20, Y)-(x + 39, Y + 39), 0, BF
CASE 18:
LINE (x + 20, Y)-(x + 59, Y + 19), 0, BF
LINE (x, Y + 20)-(x + 39, Y + 39), 0, BF
CASE 19:
LINE (x, Y)-(x + 19, Y + 39), 0, BF
LINE (x + 20, Y + 20)-(x + 39, Y + 59), 0, BF
END SELECT
END SUB

SUB RemoveRow (RowNr)
DIM Row1(800) AS SINGLE, Row2(800) AS SINGLE, Row3(800) AS SINGLE
DIM Row4(800) AS SINGLE, Row5(800) AS SINGLE, Row6(800) AS SINGLE
DIM Row7(800) AS SINGLE, Row8(800) AS SINGLE, Row9(800) AS SINGLE
DIM Row10(800) AS SINGLE, Row11(800) AS SINGLE, Row12(800) AS SINGLE
DIM Row13(800) AS SINGLE, Row14(800) AS SINGLE, Row15(800) AS SINGLE
DIM Row16(800) AS SINGLE, Row17(800) AS SINGLE, Row18(800) AS SINGLE
DIM Row19(800) AS SINGLE, Row20(800) AS SINGLE

Sort = Sort + 1
SELECT CASE RowNr
CASE 1: GOSUB R1: GOSUB P1
CASE 2: GOSUB R2: GOSUB P2
CASE 3: GOSUB R3: GOSUB P3
CASE 4: GOSUB R4: GOSUB P4
CASE 5: GOSUB R5: GOSUB P5
CASE 6: GOSUB R6: GOSUB P6
CASE 7: GOSUB R7: GOSUB P7
CASE 8: GOSUB R8: GOSUB P8
CASE 9: GOSUB R9: GOSUB P9
CASE 10: GOSUB R10: GOSUB P10
CASE 11: GOSUB R11: GOSUB P11
CASE 12: GOSUB R12: GOSUB P12
CASE 13: GOSUB R13: GOSUB P13
CASE 14: GOSUB R14: GOSUB P14
CASE 15: GOSUB R15: GOSUB P15
CASE 16: GOSUB R16: GOSUB P16
CASE 17: GOSUB R17: GOSUB P17
CASE 18: GOSUB R18: GOSUB P18
CASE 19: GOSUB R19: GOSUB P19
END SELECT
EXIT SUB
R1: GET (20, 380)-(320, 399), Row2
R2: GET (20, 360)-(320, 379), Row3
R3: GET (20, 340)-(320, 359), Row4
R4: GET (20, 320)-(320, 339), Row5
R5: GET (20, 300)-(320, 319), Row6
R6: GET (20, 280)-(320, 299), Row7
R7: GET (20, 260)-(320, 279), Row8
R8: GET (20, 240)-(320, 259), Row9
R9: GET (20, 220)-(320, 239), Row10
R10: GET (20, 200)-(320, 219), Row11
R11: GET (20, 180)-(320, 199), Row12
R12: GET (20, 160)-(320, 179), Row13
R13: GET (20, 140)-(320, 159), Row14
R14: GET (20, 120)-(320, 139), Row15
R15: GET (20, 100)-(320, 119), Row16
R16: GET (20, 80)-(320, 99), Row17
R17: GET (20, 60)-(320, 79), Row18
R18: GET (20, 40)-(320, 59), Row19
R19: GET (20, 20)-(320, 39), Row20
RETURN
P1: PUT (20, 400), Row2, PSET
P2: PUT (20, 380), Row3, PSET
P3: PUT (20, 360), Row4, PSET
P4: PUT (20, 340), Row5, PSET
P5: PUT (20, 320), Row6, PSET
P6: PUT (20, 300), Row7, PSET
P7: PUT (20, 280), Row8, PSET
P8: PUT (20, 260), Row9, PSET
P9: PUT (20, 240), Row10, PSET
P10: PUT (20, 220), Row11, PSET
P11: PUT (20, 200), Row12, PSET
P12: PUT (20, 180), Row13, PSET
P13: PUT (20, 160), Row14, PSET
P14: PUT (20, 140), Row15, PSET
P15: PUT (20, 120), Row16, PSET
P16: PUT (20, 100), Row17, PSET
P17: PUT (20, 80), Row18, PSET
P18: PUT (20, 60), Row19, PSET
P19: PUT (20, 40), Row20, PSET
RETURN
END SUB

SUB RotateBlock
SELECT CASE CurrentBlock
CASE 1:
RemoveBlock
CurrentBlock = 1
CASE 2:
IF POINT(x + 30, Y + 50) THEN EXIT SUB
RemoveBlock
CurrentBlock = 5
CASE 3:
IF POINT(x + 10, Y + 30) THEN EXIT SUB
RemoveBlock
CurrentBlock = 2
CASE 4:
IF POINT(x + 10, Y + 10) THEN EXIT SUB
IF POINT(x + 10, Y + 50) THEN EXIT SUB
RemoveBlock
CurrentBlock = 3
CASE 5:
IF POINT(x + 50, Y + 30) THEN EXIT SUB
RemoveBlock
CurrentBlock = 4
CASE 6:
IF POINT(x + 30, Y + 50) THEN EXIT SUB
IF POINT(x + 50, Y + 50) THEN EXIT SUB
IF POINT(x + 70, Y + 50) THEN EXIT SUB
RemoveBlock
CurrentBlock = 7
CASE 7:
IF POINT(x + 10, Y + 10) THEN EXIT SUB
IF POINT(x + 10, Y + 30) THEN EXIT SUB
IF POINT(x + 10, Y + 70) THEN EXIT SUB
RemoveBlock
CurrentBlock = 6
CASE 8:
IF POINT(x + 30, Y + 30) THEN EXIT SUB
IF POINT(x + 50, Y + 30) THEN EXIT SUB
IF POINT(x + 50, Y + 10) THEN EXIT SUB
RemoveBlock
CurrentBlock = 9
CASE 9:
IF POINT(x + 30, Y + 10) THEN EXIT SUB
RemoveBlock
CurrentBlock = 10
CASE 10:
IF POINT(x + 10, Y + 30) THEN EXIT SUB
IF POINT(x + 50, Y + 30) THEN EXIT SUB
RemoveBlock
CurrentBlock = 11
CASE 11:
IF POINT(x + 10, Y + 10) THEN EXIT SUB
IF POINT(x + 30, Y + 50) THEN EXIT SUB
RemoveBlock
CurrentBlock = 8
CASE 12:
IF POINT(x + 10, Y + 10) THEN EXIT SUB
IF POINT(x + 50, Y + 10) THEN EXIT SUB
IF POINT(x + 50, Y + 30) THEN EXIT SUB
RemoveBlock
CurrentBlock = 13
CASE 13:
IF POINT(x + 30, Y + 30) THEN EXIT SUB
IF POINT(x + 30, Y + 50) THEN EXIT SUB
RemoveBlock
CurrentBlock = 14
CASE 14:
IF POINT(x + 30, Y + 50) THEN EXIT SUB
IF POINT(x + 50, Y + 50) THEN EXIT SUB
RemoveBlock
CurrentBlock = 15
CASE 15:
IF POINT(x + 30, Y + 10) THEN EXIT SUB
IF POINT(x + 30, Y + 30) THEN EXIT SUB
RemoveBlock
CurrentBlock = 12
CASE 16:
IF POINT(x + 10, Y + 30) THEN EXIT SUB
IF POINT(x + 10, Y + 50) THEN EXIT SUB
RemoveBlock
CurrentBlock = 17
CASE 17:
IF POINT(x + 10, Y + 10) THEN EXIT SUB
IF POINT(x + 50, Y + 30) THEN EXIT SUB
RemoveBlock
CurrentBlock = 16
CASE 18:
IF POINT(x + 10, Y + 10) THEN EXIT SUB
IF POINT(x + 30, Y + 50) THEN EXIT SUB
RemoveBlock
CurrentBlock = 19
CASE 19:
IF POINT(x + 30, Y + 10) THEN EXIT SUB
IF POINT(x + 50, Y + 10) THEN EXIT SUB
RemoveBlock
CurrentBlock = 18
END SELECT
PutBlock
END SUB

SUB SaveHighScores
CLOSE
OPEN "Tetris.hs" FOR OUTPUT AS 1
PRINT #1, Name1$
PRINT #1, Score1
PRINT #1, Name2$
PRINT #1, Score2
PRINT #1, Name3$
PRINT #1, Score3
PRINT #1, Name4$
PRINT #1, MaxRows
CLOSE 1
END SUB

SUB SelectDelay
SELECT CASE Level
CASE 1: Delay = 1.5
CASE 2: Delay = 1.4
CASE 3: Delay = 1.3
CASE 4: Delay = 1.2
CASE 5: Delay = 1.1
CASE 6: Delay = 1
CASE 7: Delay = .9
CASE 8: Delay = .8
CASE 9: Delay = .7
CASE 10: Delay = .6
CASE 11: Delay = .5
CASE 12: Delay = .4
CASE 13: Delay = .3
CASE 14: Delay = .2
CASE 15: Delay = .1
CASE 16:
CheckHighScore
AgainBox12
Over = 1
END SELECT
END SUB

FUNCTION SongTime!
SELECT CASE Song
CASE 1: SongTime! = 95
CASE 2: SongTime! = 123
CASE 3: SongTime! = 164
CASE 4: SongTime! = 51
CASE 5: SongTime! = 194
END SELECT
END FUNCTION

SUB StartingValue
Delay = 1.5: x = 160: Y = 20: Level = 1
END SUB

SUB Title
SCREEN 13
GetFontData
SHELL "Mapview Future.map"
Intro
ScreenEffect 4
SCREEN 12
MenuScreen
END SUB

SUB UpdateScore
COLOR 10
LOCATE 5, 65 - LEN(Score): PRINT Score
LOCATE 7, 65 - LEN(Level): PRINT Level
LOCATE 9, 65 - LEN(Rows): PRINT Rows
END SUB

