program doubletris;
{ Double Tetris by MAK-TRAXON's Prophet.
  Started 5/6/93 in Pascal and Assembler, after that a multitasking
  Modula-2 version has proved to be Multi-Bugged. }

{$A+} {$B-} {$D-} {$E-} {$F-}  {$I-} {$L-} {$N-} {$O-}
{$R-} {$S-} {$V-}

uses crt,dos;

const
     width    = 10;
     height   = 20;
     esc      = 1;
     null     = #0;
     tab      = $f;
     cr       = $1c;
     maxlevel = 13;
     nbpieces = 7;
     levels   : array[0..maxlevel] of byte
              = (40,36,32,28,24,20,16,12,8,5,4,3,2,1);
     base1    = 6;
     base2    = 53;
     pbase    = 33;

type
  str8 = string[8];

  descrpiece = array [1..4,1..2] of 1..4;
  {  for each of the squares, its x and y coordinates (from 1 to 4) }
  piece = record
            rotations  :        1..4;
            shape      : array [1..4] of descrpiece;
          end;

  contents     = (full,empty,falling);

  tetris_well  = array[-3..height+4,-3..width+4] of contents;
  { the edges of the tetris well are filled with 4 levels of "full".   }
  { this allows not to check that coordinates are within the well.     }
  { the y coordinate comes first so that entire lines are stored in    }
  { consecutive memory positions                                       }

  tlines      = array[-3..height+4] of 0..width;
  { this type of vars holds how many filled squares there are in each line }

  scrtype     = array[1..2048] of word;
  { this is a text screen }

const
  pieces:array[1..nbpieces] of piece = (

      { first piece: ++++++++ }

      (rotations:2;
       shape:   (((1,3),(2,3),(3,3),(4,3)),
                 ((3,1),(3,2),(3,3),(3,4)),
                 ((1,3),(2,3),(3,3),(4,3)),
                 ((3,1),(3,2),(3,3),(3,4)))
      ),


      {second piece: ++++  }
      {              ++++  }
      (rotations:1;
       shape:   (((2,3),(3,3),(2,2),(3,2)),
                 ((2,3),(3,3),(2,2),(3,2)),
                 ((2,3),(3,3),(2,2),(3,2)),
                 ((2,3),(3,3),(2,2),(3,2)))
      ),


      {third piece=   ++++++    }
      {                 ++      }
      (rotations:4;
       shape:   (((3,2),(2,3),(3,3),(4,3)),
                 ((3,2),(3,3),(3,4),(4,3)),
                 ((2,2),(3,2),(4,2),(3,3)),
                 ((2,3),(3,2),(3,3),(3,4)))
      ),


      {fourth piece:    ++++++    }
      {                     ++    }
      (rotations:4;
       shape:  (((2,3),(3,3),(4,2),(4,3)),
                ((3,2),(3,3),(3,4),(4,4)),
                ((2,2),(3,2),(4,2),(2,3)),
                ((2,2),(3,2),(3,3),(3,4)))

      ),


      {fifth piece:  ++++++     }
      {              ++         }
      (rotations:4;
       shape:   (((2,2),(2,3),(3,3),(4,3)),
                 ((3,2),(3,3),(3,4),(4,2)),
                 ((2,2),(3,2),(4,2),(4,3)),
                 ((2,4),(3,2),(3,3),(3,4)))
      ),


      {sixth piece:     ++++  }
      {               ++++    }
      (rotations:2;
       shape:   (((2,2),(3,2),(3,3),(4,3)),
                 ((3,3),(3,4),(4,2),(4,3)),
                 ((2,2),(3,2),(3,3),(4,3)),
                 ((3,3),(3,4),(4,2),(4,3)))
      ),


      {seventh piece:   ++++    }
      {                   ++++  }
      (rotations:2;
       shape:   (((2,3),(3,2),(3,3),(4,2)),
                 ((3,2),(3,3),(4,3),(4,4)),
                 ((2,3),(3,2),(3,3),(4,2)),
                 ((3,2),(3,3),(4,3),(4,4)))
      ));

type playerdata = record
                    cube:tetris_well;
                    nlines,posix,posiy,rotation,fallen:integer;
                    thepiece:^piece;
                    cubes,whichpiece,next:word;
                    llines:tlines;
                    left,right,rot,rot2,tdrop:byte;
                    bufkey:byte;
                    pkeys:set of byte;
                    score:longint;
                    halted:boolean;
                    addlines:byte;
                  end;
type
  sndata = record
             freq:word;
             time:word;
           end;

var
  wonleft,wonright:word;
  level,totallines:integer;
  savecrstype,dela:word;
  lost,tsound,level_up,tnext:byte;
  dsound,snext,nlock,stop_game,tab_pressed:boolean;
  scr:scrtype;
  savemode,crsx,crsy:byte;
  hiscore:longint;
  players:array[0..1] of playerdata;
  commonkeys:set of byte;
  ints:array[0..255] of pointer absolute 0:0;
  saveint8,saveint9:pointer;
  key:byte;
  sndbuffer:array[0..19] of sndata;
  sndptr:word;
  time0,time1:byte;
  chainint9:boolean;
  thescreen:^scrtype;
  chain8:byte;

const
  sz = sizeof(sndbuffer) - 4;

procedure cursoff; assembler;
{ clear cursor }
asm
  mov ah,1
  mov cx,2020h
  int 10h
end;

procedure curson; assembler;
{ display cursor; assumes savescr has already been called  }
asm
  mov ah,1
  cmp savemode,7
  mov cx,8b8ch
  jz @mode7
  mov cx,savecrstype
  @mode7:
  int 10h
end;

procedure prt(sc:byte;c:str8);
begin
  case sc of
    cr : write(#17,#196,#217);
    $39: write('sp');
    tab: write('tab');
    else write(c);
  end;
end;

procedure normkeys;
begin
  level_up:=$4e;
  tnext:=cr;
  tsound:=$1f;
  commonkeys:=[level_up,tnext,tsound,tab,esc];
  with players[1] do
  begin
    left:=$4b;
    right:=$4d;
    rot:=$4c;
    tdrop:=$52;
    rot2:=$48;
    pkeys:=commonkeys+[left,right,rot,rot2,tdrop];
  end;
  with players[0] do
  begin
    left:=$23;
    right:=$25;
    rot:=$24;
    tdrop:=$39;
    rot2:=$16;
    pkeys:=commonkeys+[left,right,rot,rot2,tdrop];
  end;
end;

procedure newint9; interrupt;
var
  ch:byte;
begin
  ch:=port[$60];
  if (ch<>$2a) and (ch<$80) then
  begin
    key:=ch;
    if key in players[0].pkeys then players[0].bufkey:=ch;
    if key in players[1].pkeys then players[1].bufkey:=ch;
  end;
  if chainint9 then
  asm
    pushf
    call dword ptr saveint9
  end else
  asm
    in al,61h
    mov ah,al
    or al,80h
    out 61h,al
    mov al,ah
    out 61h,al
    mov al,20h
    out 20h,al
  end;
end;

{
procedure newint9;
asm
  push ax
  push bx
  push ds
  mov ax,seg key
  mov ds,ax
  in al,60h
  mov bl,al
  cmp chainint9,0
  jnz @noouts
  in al,61h
  mov ah,al
  or al,80h
  out 61h,al
  mov al,ah
  out 61h,al
  mov al,20h
  out 20h,al
  @noouts:
  cmp bl,2ah
  jz @ignorekey
  cmp bl,80h
  jae @ignorekey
  mov key,bl
  @ignorekey:

  cmp chainint9,0
  jnz @chain
  pop ds
  pop bx
  pop ax
  iret

  @chain:
  lds ax,saveint9
  mov word ptr cs:[offset @offset9],ax
  mov word ptr cs:[offset @segment9],ds
  jmp @cont
  @cont:
  pop ds
  pop bx
  pop ax
  db 0eah
  @offset9: dw 0
  @segment9: dw 0
end;
}


procedure newint8; assembler;
asm
  push ax
  push bx
  push cx
  push dx
  push si
  push ds

  mov ax,seg(sndbuffer)
  mov ds,ax

  sub time0,1
  adc time0,0
  sub time1,1
  adc time1,0

  mov si,offset sndbuffer + 2
  mov ax,[si]
  or ax,ax
  jz @nosound
  sub si,2

  mov ax,[si]
  or ax,ax
  jz @decsnd
  mov word ptr [si],0

  mov bx,ax
  mov ax,34DDh
  mov dx,12h
  cmp dx,bx
  jae @loc_2
  div bx
  mov bx,ax
  in al,61h
  test al,3
  jnz @loc_1
  or al,3
  out 61h,al
  mov al,0B6h
  out 43h,al
@loc_1:
  mov al,bl
  out 42h,al
  mov al,bh
  out 42h,al
@loc_2:
  jmp @nosound
  @decsnd:
  add si,2
  dec word ptr [si]
  jnz @nosound
  in al,61h
  and al,0fch
  out 61h,al
  add si,2
  push di
  push es
  push ds
  pop es
  mov di,si
  sub di,4
  mov cx,sz
  cld
  rep movsb
  pop es
  pop di
  dec sndptr

  @nosound:
  push ds
  lds ax,saveint8
  mov word ptr cs:[offset @offset8],ax
  mov word ptr cs:[offset @segment8],ds
  pop ds
  jmp @cont
  @cont:
  sub chain8,1
  jnc @outs
  mov chain8,3
  pop ds
  pop si
  pop dx
  pop cx
  pop bx
  pop ax
  db 0eah
  @offset8: dw 0
  @segment8: dw 0
  @outs:
  mov al,20h
  out 20h,al
  pop ds
  pop si
  pop dx
  pop cx
  pop bx
  pop ax
  iret
end;

procedure putsound(freq1,time1:word);
begin
  if sndptr<19 then
  begin
    asm cli end;
    sndbuffer[sndptr].freq:=freq1;
    sndbuffer[sndptr].time:=time1;
    inc(sndptr);
    asm sti end;
  end;
end;

function scanpressed:boolean;
begin
  scanpressed:=key<>0;
end;

function readscan:byte;
begin
  repeat until scanpressed;
  readscan:=key;
  key:=0;
end;

procedure savescr;
{ save screen type and contents, cursor shape and position }
{ init interrupt and sound handling }
var
  monoscr  : scrtype absolute $b000:$0000;
  colorscr : scrtype absolute $b800:$0000;
  vmode    : byte    absolute $0000:$0449;
begin
  savemode:=vmode;
  if vmode=7 then
  begin
    scr:=monoscr;
    thescreen:=ptr($b000,0);
  end else
  begin
    scr:=colorscr;
    thescreen:=ptr($b800,0);
  end;
  crsx:=wherex;
  crsy:=wherey;
  asm
    mov ax,300h
    int 10h
    mov savecrstype,cx
  end;
  fillchar(sndbuffer,sizeof(sndbuffer),0);
  sndptr:=0;
  asm
    cli
  end;
  chainint9:=false;
  saveint8:=ints[8];
  ints[8]:=@newint8;
  saveint9:=ints[9];
  ints[9]:=@newint9;
  normkeys;

  key:=0;
  players[0].bufkey:=0;
  players[1].bufkey:=0;

  key:=0;
  asm
    mov al,36h
    out 43h,al
    mov al,0
    out 40h,al
    mov al,40h
    out 40h,al
  end;
  chain8:=3;
  { quadruple the int 8 frequency }
  asm
    sti
  end;
end;

procedure disp(x,y:integer;lj:byte);
begin
  if lj=0 then
    case players[lj].cube[y,x] of
      full,falling  : begin
                        thescreen^[base1+x+x+80*(23-y)]:=219+7*$100;
                        thescreen^[base1+1+x+x+80*(23-y)]:=219+7*$100;
                      end;
      empty         : begin
                        thescreen^[base1+x+x+80*(23-y)]:=176+7*$100;
                        thescreen^[base1+1+x+x+80*(23-y)]:=176+7*$100;
                      end;
    end
  else
    case players[lj].cube[y,x] of
      full,falling  : begin
                        thescreen^[base2+x+x+80*(23-y)]:=219+7*$100;
                        thescreen^[base2+1+x+x+80*(23-y)]:=219+7*$100;
                      end;
      empty         : begin
                        thescreen^[base2+x+x+80*(23-y)]:=176+7*$100;
                        thescreen^[base2+1+x+x+80*(23-y)]:=176+7*$100;
                      end;
    end;
end;

procedure show;
var
  x,y:integer;
  lj:byte;
  i:byte;
begin
  for y:=height downto 1 do
    for x:=1 to width do
      for lj:=0 to 1 do
        disp(x,y,lj);
  gotoxy(29,1);
  write('D O U B L E   T E T R I S');
  for y:=1 to height do
  begin
    gotoxy(base1+1,24-y);
    write(#186);
    gotoxy(base1+22,24-y);
    write(#186);
  end;
  gotoxy(base1+1,24);
  write(#200);
  for x:=1 to 2*width do write(#205);
  write(#188);
  for y:=1 to height do
  begin
    gotoxy(base2+1,24-y);
    write(#186);
    gotoxy(base2+22,24-y);
    write(#186);
  end;
  gotoxy(base2+1,24);
  write(#200);
  for x:=1 to 2*width do write(#205);
  write(#188);

  gotoxy(pbase,5);
  write('Level: ');
  gotoxy(pbase,7);
  write('Left Score: ');
  gotoxy(pbase,8);
  write('Right Score: ');
  gotoxy(pbase,9);
  if hiscore<>0 then
  begin
    write('High Score: ');
    write(hiscore);
    i:=1;
  end else i:=0;
  gotoxy(pbase,10+i);
  write('Left Lines: ');
  gotoxy(pbase,11+i);
  write('Right Lines: ');
  gotoxy(pbase,13+i);
  write('Next : ');
  gotoxy(pbase,14+i);
  write('Sound: ');
  if wonright+wonleft<>0 then
  begin
    gotoxy(13,25);
    write('Games: ',wonleft);
    gotoxy(61,25);
    write('Games: ',wonright);
  end;
end;

procedure gameover;
begin
  if lost=0 then
  begin
    gotoxy(base1+2,12);
    textcolor(black+blink);
    textbackground(lightgray);
    write('                    ');
    gotoxy(base1+2,13);
    write(' G A M E    O V E R ');
    gotoxy(base1+2,14);
    write('                    ');
    textcolor(lightgray);
    textbackground(black);
  end else
  begin
    gotoxy(base2+2,12);
    textcolor(black+blink);
    textbackground(lightgray);
    write('                    ');
    gotoxy(base2+2,13);
    write(' G A M E    O V E R ');
    gotoxy(base2+2,14);
    write('                    ');
    textcolor(lightgray);
    textbackground(black);
  end;
end;

procedure init;
var
  x,y:integer;
  lj:byte;
begin
  for lj:=0 to 1 do
  begin
    for x:=-3 to width+4 do
      for y:=-3 to height+4 do
        if (x>0) and (x<=width) and  (y>0) and (y<=height) then
          players[lj].cube[y,x]:=empty else
          players[lj].cube[y,x]:=full;
    for x:=-3 to height+4 do players[lj].llines[x]:=0;
    players[lj].addlines:=0;
  end;
end;

procedure prtscore;
var i:byte;
begin
  gotoxy(pbase+7,5);
  write(level);

  gotoxy(pbase+12,7);
  write(players[0].score);

  gotoxy(pbase+13,8);
  write(players[1].score);

  if hiscore<>0 then
  begin
    gotoxy(pbase+12,9);
    write(hiscore);
    i:=1;
  end else i:=0;

  gotoxy(pbase+12,10+i);
  write(players[0].nlines);

  gotoxy(pbase+13,11+i);
  write(players[1].nlines);

  gotoxy(pbase+7,13+i);
  if snext then write('ON   ') else write('OFF    ');
  gotoxy(pbase+7,14+i);
  if dsound then write('ON  ') else write('OFF  ');
  gotoxy(pbase+4,16+i);
  if players[0].score>players[1].score then
    write('<') else
    if players[1].score>players[0].score then
      write('>') else
      write('       ');
end;

procedure drawnext(lj:byte);
var
  q:integer;
  b:byte;
begin
  b:=11*lj;
  gotoxy(pbase+2,19);
  write('Next:     ');
  gotoxy(pbase+b-1,20);
  write('           ');
  gotoxy(pbase+b-1,21);
  write('           ');
  gotoxy(pbase+b-1,22);
  write('           ');
  gotoxy(pbase+b-1,23);
  write('           ');
  for q:=1 to 4 do
  begin
    gotoxy(2*
     pieces[players[lj].next].shape[1,q,1]+pbase-3+b,
           24-pieces[players[lj].next].shape[1,q,2]);
    write(#219#219);
  end;
end;

procedure clrnext;
begin
  gotoxy(pbase+2,19);
  write('      ');
  gotoxy(pbase-1,20);
  write('                   ');
  gotoxy(pbase-1,21);
  write('                   ');
  gotoxy(pbase-1,22);
  write('                   ');
  gotoxy(pbase-1,23);
  write('                   ');
end;

function rkey:char;
var
  ch:char;
begin
  ch:=readkey;
  case ord(ch) of
    71 : rkey:='7';
    72 : rkey:='8';
    73 : rkey:='9';
    75 : rkey:='4';
    77 : rkey:='6';
    79 : rkey:='1';
    80 : rkey:='2';
    81 : rkey:='3';
    82 : rkey:='0';
    83 : rkey:='.';
    else rkey:=ch ;
  end;
end;

procedure kname(sc:byte; var ch:str8);
begin
  case sc of
    29 : ch:='Ctrl';
    56 : ch:='Alt';
    58 : ch:='Caps';
    54 : ch:='RShift';
    42 : ch:='LShift';
    69 : ch:='NumLock';
    else ch:='????';
  end;
end;

procedure readsckey(var sc:byte;var ch:str8);
{ assumes chainint9 = true }
var
  c:char;
begin
  while keypressed do readkey;
  key:=0;
  sc:=readscan;
  if keypressed then
  begin
    c:=upcase(readkey);
    if c=#0 then ch:=rkey else ch:=c;
  end else kname(sc,ch);
end;

procedure ask_keys;
var
  keys:set of byte;
  ch:str8;
  lj:byte;
begin
  curson;
  clrscr;
  chainint9:=true;
  keys:=[tab,0];

  gotoxy(20,2);
  write('       Left Player:');
  lj:=0;
  repeat
    gotoxy(10,8);
    write ('          Key to move left [H] >      ',#8,#8,#8,#8);
    mem[0:$417]:=mem[0:$417] or $20;

    readsckey(players[lj].left,ch);
    prt(players[lj].left,ch);
    if players[lj].left=esc  then
    begin
      normkeys;
      cursoff;
      chainint9:=false;
      key:=0;
      exit;
    end;
  until not (players[lj].left in keys);
  keys:=[players[lj].left]+keys ;

  repeat
    gotoxy(10,10);
    write ('         Key to move right [K] >      ',#8,#8,#8,#8);
    mem[0:$417]:=mem[0:$417] or $20;
    readsckey(players[lj].right,ch);
    prt(players[lj].right,ch);
    if players[lj].right=esc  then
    begin
      normkeys;
      cursoff;
      chainint9:=false;
      key:=0;
      exit;
    end;
  until not (players[lj].right in keys);
  keys:=[players[lj].right]+keys;
  repeat
    gotoxy(10,12);
    write ('              Key to drop [sp] >      ',#8,#8,#8,#8);
    mem[0:$417]:=mem[0:$417] or $20;
    readsckey(players[lj].tdrop,ch);
    prt(players[lj].tdrop,ch);
    if players[lj].tdrop=esc  then
    begin
      normkeys;
      cursoff;
      chainint9:=false;
      key:=0;
      exit;
    end;
  until not (players[lj].tdrop in keys);
  keys:=[players[lj].tdrop]+keys;
  repeat
    gotoxy(10,14);
    write ('             Key to rotate [J] >      ',#8,#8,#8,#8);
    mem[0:$417]:=mem[0:$417] or $20;
    readsckey(players[lj].rot,ch);
    prt(players[lj].rot,ch);
    if players[lj].rot=esc then
    begin
      normkeys;
      cursoff;
      chainint9:=false;
      key:=0;
      exit;
    end;
  until not (players[lj].rot in keys);
  keys:=[players[lj].rot]+keys;
  repeat
    gotoxy(10,16);
    write ('    Key to rotate backward [U] >      ',#8,#8,#8,#8);
    mem[0:$417]:=mem[0:$417] or $20;
    readsckey(players[lj].rot2,ch);
    prt(players[lj].rot2,ch);
    if players[lj].rot2=esc then
    begin
      normkeys;
      cursoff;
      chainint9:=false;
      key:=0;
      exit;
    end;
  until not (players[lj].rot2 in keys);
  keys:=[players[lj].rot2]+keys ;

  clrscr;
  gotoxy(20,2);
  write('       Right Player:');
  lj:=1;

  repeat
    gotoxy(10,8);
    write ('          Key to move left [4] >      ',#8,#8,#8,#8);
    mem[0:$417]:=mem[0:$417] or $20;

    readsckey(players[lj].left,ch);
    prt(players[lj].left,ch);
    if players[lj].left=esc  then
    begin
      normkeys;
      cursoff;
      chainint9:=false;
      key:=0;
      exit;
    end;
  until not (players[lj].left in keys);
  keys:=[players[lj].left]+keys ;

  repeat
    gotoxy(10,10);
    write ('         Key to move right [6] >      ',#8,#8,#8,#8);
    mem[0:$417]:=mem[0:$417] or $20;
    readsckey(players[lj].right,ch);
    prt(players[lj].right,ch);
    if players[lj].right=esc  then
    begin
      normkeys;
      cursoff;
      chainint9:=false;
      key:=0;
      exit;
    end;
  until not (players[lj].right in keys);
  keys:=[players[lj].right]+keys;
  repeat
    gotoxy(10,12);
    write ('               Key to drop [0] >      ',#8,#8,#8,#8);
    mem[0:$417]:=mem[0:$417] or $20;
    readsckey(players[lj].tdrop,ch);
    prt(players[lj].tdrop,ch);
    if players[lj].tdrop=esc  then
    begin
      normkeys;
      cursoff;
      chainint9:=false;
      key:=0;
      exit;
    end;
  until not (players[lj].tdrop in keys);
  keys:=[players[lj].tdrop]+keys;
  repeat
    gotoxy(10,14);
    write ('             Key to rotate [5] >      ',#8,#8,#8,#8);
    mem[0:$417]:=mem[0:$417] or $20;
    readsckey(players[lj].rot,ch);
    prt(players[lj].rot,ch);
    if players[lj].rot=esc then
    begin
      normkeys;
      cursoff;
      chainint9:=false;
      key:=0;
      exit;
    end;
  until not (players[lj].rot in keys);
  keys:=[players[lj].rot]+keys;
  repeat
    gotoxy(10,16);
    write ('    Key to rotate backward [8] >      ',#8,#8,#8,#8);
    mem[0:$417]:=mem[0:$417] or $20;
    readsckey(players[lj].rot2,ch);
    prt(players[lj].rot2,ch);
    if players[lj].rot2=esc then
    begin
      normkeys;
      cursoff;
      chainint9:=false;
      key:=0;
      exit;
    end;
  until not (players[lj].rot2 in keys);
  keys:=[players[lj].rot2]+keys ;

  clrscr;
  gotoxy(20,2);
  write('       Common Keys:');

  repeat
    gotoxy(10,8);
    write ('     Key to increase level [+] >      ',#8,#8,#8,#8);
    mem[0:$417]:=mem[0:$417] or $20;
    readsckey(level_up,ch);
    prt(level_up,ch);
    if level_up=esc then
    begin
      normkeys;
      cursoff;
      chainint9:=false;
      key:=0;
      exit;
    end;
  until not (level_up in keys);
  keys:=[level_up]+keys ;

  repeat
    gotoxy(10,10);
    write ('        Key to draw NEXT [',#17,#196,#217,'] >      ',#8,#8,#8,#8);
    mem[0:$417]:=mem[0:$417] or $20;
    readsckey(tnext,ch);
    prt(tnext,ch);
    if tnext=esc  then
    begin
      normkeys;
      cursoff;
      chainint9:=false;
      key:=0;
      exit;
    end;
  until not (tnext in keys);
  keys:=[tnext]+keys ;
  repeat
    gotoxy(10,12);
    write ('  Key to turn sound ON/OFF [S] >      ',#8,#8,#8,#8);
    mem[0:$417]:=mem[0:$417] or $20;
    readsckey(tsound,ch);
    prt(tsound,ch);
    if tsound=esc  then
    begin
      normkeys;
      cursoff;
      chainint9:=false;
      key:=0;
      exit;
    end;
  until not (tsound in keys);
  keys:=[tsound]+keys ;
  chainint9:=false;
  cursoff;
  commonkeys:=[level_up,tnext,tsound,tab,esc];
  with players[1] do
    pkeys:=commonkeys+[left,right,rot,rot2,tdrop];
  with players[0] do
    pkeys:=commonkeys+[left,right,rot,rot2,tdrop];
end;

procedure quit;
var
  vmode    : byte    absolute $0000:$0449;
  monoscr  : scrtype absolute $b000:$0000;
  colorscr : scrtype absolute $b800:$0000;
  tb,tc    : byte;

procedure pcolor(c:integer);
begin
  if c=0 then
  begin
    textcolor(lightgray   );
    textbackground(black  );
  end else
  begin
    textcolor(tc          );
    textbackground(tb     );
  end;
end;

begin
  asm
    cli
  end;
  ints[8]:=saveint8;

  asm
    mov al,36h
    out 43h,al
    xor al,al       { set standard int 8 rate }
    out 40h,al
    out 40h,al
  end;

  ints[9]:=saveint9;
  asm
    sti
  end;
  if vmode=7 then monoscr:=scr else colorscr:=scr;
  gotoxy(crsx,crsy);
  curson;
  writeln;
  if vmode=7 then tb:=lightgray else tb:=red;
  tc:=black;
  pcolor(0);
  write('   ');
  pcolor(1);
  write('                   ');
  pcolor(0);
  writeln;
  write('   ');
  pcolor(1);
  write('  DOUBLE TETRIS !  ');
  pcolor(0);
  writeln;
  write('   ');
  pcolor(1);
  write('                   ');
  pcolor(0);
  writeln;
  if nlock then mem[0:$417]:=mem[0:$417] or $20
    else mem[0:$417]:=mem[0:$417] and $df;
  halt(0);
end;

procedure center(s:string;y:byte);
begin
  gotoxy(41-length(s) shr 1,y);
  write(s);
end;

procedure ask_level;
const
  keys : set of byte =
  [ $39,      { space }
    $2..$b,   { 0..9, top row }
    cr,
    esc,
    $52,      { 0, num pad }
    $4f..$51, { 1..3, num pad }
    $4b..$4d, { 4..6, num pad }
    $47..$49  { 7..9, num pad }
  ];
const
  b1=30;
  b2=10;
var
  key:byte;
begin
  clrscr;
  repeat

    center('', 3);
    center(' D O U B L E   T E T R I S ', 4);
    center('  by MAK-TRAXON''s Prophet  ',5);
    center('', 6);

    center('',22);
    center(' R :  Redefine Keys       ',23);
    center(' Z :  Reset Game Counters ',24);
    center('',25);

    gotoxy(b1,b2);
    write('');
    gotoxy(b1,b2+1);
    write('  Left Games : ',wonleft:2,'   ');
    gotoxy(b1,b2+2);
    write(' Right Games : ',wonright:2,'   ');
    gotoxy(b1,b2+3);
    write('                    ');
    gotoxy(b1,b2+4);
    write(' Level (+,-) : ',level:2,'   ');
    gotoxy(b1,b2+5);
    write('                    ');
    gotoxy(b1,b2+6);
    if dsound then
    write('   Sound (S) :  ON  ') else
    write('   Sound (S) :  OFF ');
    gotoxy(b1,b2+7);
    if snext then
    write('    Next (N) :  ON  ') else
    write('    Next (N) :  OFF ');
    gotoxy(b1,b2+8);
    write('');

    key:=readscan;
    case key of
      $13     : begin            { 'R' }
                  ask_keys;
                  clrscr;
                end;
      $11,$2c : begin          { Z on QWERTY and AZERTY keyboards }
                  wonleft:=0;
                  wonright:=0;
                end;
      $1f     : dsound:=not dsound;   { 'S' }
      $31     : snext:=not snext;     { 'N' }
      $4e     : if level<maxlevel then inc(level); { '+' }
      $4a     : if level>0 then dec(level);        { '-' }
    end;
  until key in keys;
  case key of
    $2..$a  : level:=key-1;
    $52,$b  : level:=0;
    $4f..$51: level:=key-$4e;
    $4b..$4d: level:=key-$47;
    $47..$49: level:=key-$40;
    esc     : quit;
  end;
end;

function fits(lj:byte):boolean;
{ returns False if the current piece at the current position (defined by  }
{ posix, posiy and rotation) "hits" some other piece, else returns True   }
var
  k:byte;
begin
  fits:=true;
  for k:=1 to 4 do
    if players[lj].cube[players[lj].posiy-1+players[lj].thepiece^.shape[players[lj].rotation,k,2],
            players[lj].posix-1+players[lj].thepiece^.shape[players[lj].rotation,k,1]] = full then
    begin
      fits:=false;
      exit
    end;
end;

procedure change(what:contents;lj:byte);
{ requires posix and posiy to be correct, but not rotation }
var
  x,y,x2,y2:integer;
begin
  for x:=1 to 4 do for y:=1 to 4 do
  begin
    x2:=x+players[lj].posix-1;
    y2:=y+players[lj].posiy-1;
    if players[lj].cube[y2,x2]=falling then
    begin
      players[lj].cube[y2,x2]:=what;
      disp(x2,y2,lj);
      if what=full then
      begin
        inc(players[lj].llines[y2]);
        inc(players[lj].cubes);
      end;
    end;
  end;
end;

procedure putmem(lj:byte);
var
  k:byte;
  x2,y2:integer;
begin
  for k:=1 to 4 do
  begin
    x2:=players[lj].posix-1+players[lj].thepiece^.shape[players[lj].rotation,k,1];
    y2:=players[lj].posiy-1+players[lj].thepiece^.shape[players[lj].rotation,k,2];
    players[lj].cube[y2,x2]:=falling;
    disp(x2,y2,lj);
  end;
end;

procedure keyboard(lj:byte);
var
  ch:byte;
  lastrot:integer;
  temp,temp2:integer;
begin
  with players[lj] do
  begin
    while bufkey in pkeys do
    begin
      ch:=bufkey;
      bufkey:=0;
      if players[1-lj].bufkey=ch then players[1-lj].bufkey:=0;
      if key=ch then key:=0;
      if (ch=level_up) and (level<maxlevel) then
      begin
        inc(level);
        prtscore;
      end else
      if ch=left then
      begin
        dec(posix);
        if not fits(lj) then inc(posix) else
        begin
          inc(posix);
          change(empty,lj);
          dec(posix);
          putmem(lj);
        end;
      end else
      if ch=right then
      begin
        inc(posix);
        if not fits(lj) then dec(posix) else
        begin
          dec(posix);
          change(empty,lj);
          inc(posix);
          putmem(lj);
        end;
      end else
{     if ch=esc then quit else }
      if (ch=tab) or (ch=esc) then
      begin
        stop_game:=true;
        tab_pressed:=true;
      end else
      if ch=tdrop then
      begin
        temp:=posiy;
        repeat
          dec(posiy);
          inc(fallen);
        until not fits(lj);
        dec(fallen);
        temp2:=posiy;
        posiy:=temp;
        change(empty,lj);
        posiy:=temp2+1;
        putmem(lj);
      end else
      if (ch=rot) and (thepiece^.rotations>1) then
      begin
        lastrot:=rotation;
        inc(rotation);
        if rotation>thepiece^.rotations then rotation:=1;
        if fits(lj) then
        begin
          change(empty,lj);
          putmem(lj);
        end else
        begin
          dec(posiy);
          if fits(lj) then
          begin
            inc(posiy);
            change(empty,lj);
            dec(posiy);
            putmem(lj);
          end else
          begin
            rotation:=lastrot;
            inc(posiy);
          end;
        end;
      end else
      if (ch=rot2) and (thepiece^.rotations>1) then
      begin
        lastrot:=rotation;
        dec(rotation);
        if rotation<1 then rotation:=thepiece^.rotations;
        if fits(lj) then
        begin
          change(empty,lj);
          putmem(lj);
        end else
        begin
          dec(posiy);
          if fits(lj) then
          begin
            inc(posiy);
            change(empty,lj);
            dec(posiy);
            putmem(lj);
          end else
          begin
            rotation:=lastrot;
            inc(posiy);
          end;
        end;
      end else
      if ch=tnext then
      begin
        snext:=not snext;
        if snext then
        begin
          drawnext(0);
          drawnext(1);
        end else clrnext;
        prtscore;
      end else
      if ch=tsound then
      begin
        dsound:=not dsound;
        prtscore;
      end;
    end;
  end;
end;

procedure lines(lj:byte);
var
  x2,y2,x3,y3 : integer;
  how_many    : byte;
begin
  with players[lj] do
  begin
    y2:=posiy;
    how_many:=0;
    repeat
      if llines[y2]=width then
      begin
        dec(cubes,width);
        inc(how_many);
        for y3:=y2+1 to height do
        begin
          llines[y3-1]:=llines[y3];
          cube[y3-1]:=cube[y3];
          for x3:=1 to width do disp(x3,y3-1,lj);
        end;
        for x3:=1 to width do
        begin
          cube[height,x3]:=empty;
          disp(x3,height,lj);
        end;
        llines[height]:=0;
        inc(score,15);
        inc(nlines);
        if (nlines div 10 > level) and (level<maxlevel) then inc(level);
        prtscore;
        if dsound then
        begin
          putsound(400,2);
          putsound(600,3);
          putsound(0,1);
        end;
      end else inc(y2);
      keyboard(1-lj);
    until y2>=posiy+4;
    if how_many=4 then
    begin
      inc(score,247);
      if dsound then putsound(1200,6);
    end;
    if how_many>1 then inc(players[1-lj].addlines,how_many);
  end;
end;

procedure up_1(lj:byte);
var
  x,y:integer;
begin
  with players[lj] do
  begin
    dec(addlines);
    if llines[height]<>0 then
    begin
      fallen:=0;
      addlines:=0;
    end else
    begin
      for y:=height downto 2 do
      begin
        llines[y]:=llines[y-1];
        cube[y]:=cube[y-1];
        for x:=1 to width do disp(x,y,lj);
      end;
      players[lj].llines[1]:=0;
      for x:=1 to width do
      begin
        if random(3)=0 then cube[1,x]:=empty else
        begin
          cube[1,x]:=full;
          inc(cubes);
          inc(llines[1]);
        end;
        disp(x,1,lj);
      end;
    end;
  end;
end;

procedure game;
var
  ch:byte;
  level0:integer;
  i:word;
  test:boolean;
begin
  level0:=level;
  repeat
    players[0].bufkey:=0;
    players[1].bufkey:=0;
    init;
    totallines:=0;
    clrscr;
    tab_pressed:=false;
    show;

    with players[0] do
    begin
      score:=0;
      nlines:=0;
      cubes:=0;
      whichpiece:=random(nbpieces)+1;
      thepiece:=@pieces[whichpiece];
      next:=random(nbpieces)+1;
      posiy:=height-2;
      posix:=4;
      rotation:=1;
      putmem(0);
      fallen:=1;                 { init the piece that is going to fall }
      time0:=levels[level];
      if snext then drawnext(0);
    end;

    with players[1] do
    begin
      score:=0;
      nlines:=0;
      cubes:=0;
      whichpiece:=random(nbpieces)+1;
      thepiece:=@pieces[whichpiece];
      next:=random(nbpieces)+1;
      posiy:=height-2;
      posix:=4;
      rotation:=1;
      putmem(1);
      fallen:=1;                 { init the piece that is going to fall }
      time1:=levels[level];
      if snext then drawnext(1);
    end;
    prtscore;
    stop_game:=false;

    repeat
      if time0=0 then with players[0] do
      begin
        time0:=levels[level];
        change(empty,0);
        dec(posiy);                 { bring the piece one step down }
        if fits(0) then
        begin
          putmem(0);
          inc(fallen);
        end else
        begin
          score:=score+10+2*level+(fallen shr 2)+random(3);
          if snext then dec(score,7);
          prtscore;                    { show score }
          if fallen>0 then
          begin
            inc(posiy);
            putmem(0);
            change(full,0);
            lines(0);
            if cubes=0 then
            begin
              inc(score,527);
              if dsound then
              begin
                putsound(450,4);
                putsound(900,5);
                putsound(1200,9);
              end;
            end;
            rotation:=1;
            whichpiece:=next;
            next:=random(nbpieces)+1;
            if snext then drawnext(0);
            thepiece:=@pieces[whichpiece];
            posiy:=height-2;
            posix:=4;
            fallen:=0;                 { init the piece that is going to fall }
            if fits(0) then putmem(0) else
            begin
              stop_game:=true;
              inc(wonright);
              lost:=0;
            end;
          end else
          begin
            stop_game:=true;
            inc(wonright);
            lost:=0;
          end;
        end;
      end;

      if time1=0 then with players[1] do
      begin
        time1:=levels[level];
        change(empty,1);
        dec(posiy,1);               { bring the piece one step down }
        if fits(1) then
        begin
          putmem(1);
          inc(fallen);
        end else
        begin
          score:=score+10+2*level+(fallen shr 2)+random(3);
          if snext then dec(score,7);
          prtscore;                    { show score }
          if fallen>0 then
          begin
            inc(posiy);
            putmem(1);
            change(full,1);
            lines(1);
            if cubes=0 then
            begin
              inc(score,527);
              if dsound then
              begin
                putsound(450,4);
                putsound(900,5);
                putsound(1200,9);
              end;
            end;
            rotation:=1;
            whichpiece:=next;
            next:=random(nbpieces)+1;
            if snext then drawnext(1);
            thepiece:=@pieces[whichpiece];
            posiy:=height-2;
            posix:=4;
            fallen:=0;                 { init the piece that is going to fall }
            if fits(1) then putmem(1) else
            begin
              stop_game:=true;
              inc(wonleft);
              lost:=1;
            end;
          end else
          begin
            stop_game:=true;
            inc(wonleft);
            lost:=1;
          end;
        end;
      end;

      if random(2)=0 then
      begin
        keyboard(0);
        keyboard(1);
      end else
      begin
        keyboard(1);
        keyboard(0);
      end;

      if players[0].addlines>0 then
      begin
        change(empty,0);
        test:=true;
        while test and (players[0].addlines>0) do
        begin
          dec(players[0].posiy);
          if not fits(0) then
          begin
            inc(players[0].posiy);
            test:=false;
          end else
          begin
            inc(players[0].posiy);
            up_1(0);
          end;
        end;
        if fits(0) then putmem(0);
      end;

      if players[1].addlines>0 then
      begin
        change(empty,1);
        test:=true;
        while test and (players[1].addlines>0) do
        begin
          dec(players[1].posiy);
          if not fits(1) then
          begin
            inc(players[1].posiy);
            test:=false;
          end else
          begin
            inc(players[1].posiy);
            up_1(1);
          end;
        end;
        if fits(1) then putmem(1);
      end;

    until stop_game;

    if not tab_pressed then
    begin
      if dsound then
      begin
        putsound(250,3);
        putsound(150,6);
        putsound(100,16);
      end;
      gameover;
      key:=0;
      time1:=100;
      while (time1>0) and (key<>esc) do;
      key:=0;
      while (time1>0) and (key<>esc) do;
      ch:=readscan;
      if ch=$13 then level:=level0;
    end;
    if players[0].score>hiscore then hiscore:=players[0].score;
    if players[1].score>hiscore then hiscore:=players[1].score;
  until (ch<>$13) or tab_pressed;
end;

begin
  snext:=true;
  level:=5;
  mem[0:$417]:=mem[0:$417] and $f0;
  wonleft:=0;
  wonright:=0;
  dsound:=true;
  nlock:=(mem[0:$417] and $20)<>0;  { init some vars }
  normkeys;                         { init keys      }
  randseed:=meml[0:$46c];           { randomize      }
  while keypressed do if readkey=#0 then; { clear kbd buffer }
  savescr;                          { save text screen and cursor position }
  cursoff;
  hiscore:=0;
  repeat
    ask_level;
    game;
  until false;                      { loop forever }
end.
