UNIT graphza;

INTERFACE

CONST on=0;
      off=1;

TYPE point_2d=RECORD
	x,y:INTEGER;
	END;
     rgbcolor=RECORD
	red,green,blue:BYTE;
	END;

VAR pix:PROCEDURE (x,y:INTEGER;c:BYTE);
    getpix:FUNCTION (x,y:INTEGER):BYTE;
	x_max,y_max:INTEGER;
    afftext:PROCEDURE (x,y,col:BYTE;mess:STRING);
	ligne:PROCEDURE (x1,y1,x2,y2:INTEGER;col:BYTE);
	lignehoriz:PROCEDURE (y,x1,x2:INTEGER;col:BYTE);
	col_max:BYTE;

PROCEDURE graphmode(gm:BYTE);
FUNCTION  readmode:BYTE;
PROCEDURE ecran(p:BYTE);
PROCEDURE activpage(pg:BYTE);
PROCEDURE cercle(cenx,ceny,rad,col:INTEGER);
PROCEDURE pal(r,c:BYTE);
PROCEDURE palrgb(col,r,g,b:BYTE);
PROCEDURE setallpalrgb(VAR buf;deb,nb:INTEGER);
PROCEDURE readallpalrgb(VAR buf;deb,nb:INTEGER);
PROCEDURE paldefaut(b:BYTE);
PROCEDURE fill(xg,yg:INTEGER;col:BYTE;fond:BYTE);
PROCEDURE triangle(a,b,c:point_2d;col:BYTE);
PROCEDURE quadri(a,b,c,d:point_2d;col:BYTE);
PROCEDURE squarepixel;
PROCEDURE scrolling(x,y:INTEGER);


IMPLEMENTATION

CONST warning='Mode graphique non-initialis avec GRAPHMODE';

{$f+}
PROCEDURE noaff(x,y,col:BYTE;mess:STRING);
BEGIN
writeln('Mode graphique non-initialis avec graphmode');
halt(1);
END;

PROCEDURE afftexthi(x,y,col:BYTE;mess:STRING);
VAR i,c:BYTE;
BEGIN
ASM
mov ax,0005h
mov dx,03CEh
out dx,ax
mov ax,0FF08h
out dx,ax
mov ah,2
mov bh,0
mov dh,y
mov dl,x
int 10h
END;
FOR i:=1 TO length(mess) DO
BEGIN
c:=MEM[seg(mess):ofs(mess)+i];
ASM
mov ah,0Eh
mov al,c
mov bl,col
int 10h
END;
END;
ASM
mov ax,0205h
mov dx,03CEh
out dx,ax
END;
END;

PROCEDURE afftext256(x,y,col:BYTE;mess:STRING);
VAR i,c:BYTE;
BEGIN
ASM
mov ah,2
mov bh,0
mov dh,y
mov dl,x
int 10h
END;
FOR i:=1 TO length(mess) DO
BEGIN
c:=MEM[seg(mess):ofs(mess)+i];
ASM
mov ah,0Eh
mov al,c
mov bl,col
int 10h
END;
END;
END;

{$f-}
PROCEDURE pal(r,c:BYTE);assembler;
ASM
mov ax,1000h
mov bl,r
mov bh,c
int 10h
END;

PROCEDURE palrgb(col,r,g,b:BYTE);ASSEMBLER;
ASM
mov dx,3C8h
mov al,col
out dx,al
inc dx
mov al,r
out dx,al
mov al,g
out dx,al
mov al,b
out dx,al
END;

PROCEDURE setallpalrgb(VAR buf;deb,nb:INTEGER);assembler;
ASM
mov ax,WORD ptr [buf+2]
mov es,ax
mov ax,1012h
mov bx,deb
mov cx,nb
mov dx,WORD ptr [buf]
int 10h
END;

PROCEDURE readallpalrgb(VAR buf;deb,nb:INTEGER);assembler;
ASM
mov ax,WORD ptr [buf+2]
mov es,ax
mov ax,1017h
mov bx,deb
mov cx,nb
mov dx,WORD ptr [buf]
int 10h
END;

PROCEDURE activpage(pg:BYTE);
BEGIN ASM
mov ah,5h
mov al,pg
int 10h
END;END;

PROCEDURE cercle(cenx,ceny,rad,col:INTEGER);
VAR x,y,delta:INTEGER;
BEGIN
y:=rad;x:=-1;
delta:=3-(rad SHL 2);
REPEAT
 inc(x);
 pix(x+cenx,y+ceny,col);
 pix(x+cenx,ceny-y,col);
 pix(cenx-x,ceny-y,col);
 pix(cenx-x,y+ceny,col);
 pix(y+cenx,x+ceny,col);
 pix(y+cenx,ceny-x,col);
 pix(cenx-y,ceny-x,col);
 pix(cenx-y,x+ceny,col);
 IF delta<0 THEN delta:=delta+(x SHL 2)+6
	    ELSE BEGIN
		 delta:=delta+((x-y) SHL 2)+10;
                 dec(y);
		 END;

UNTIL x>=y;
END;

PROCEDURE ecran(p:BYTE);assembler;
ASM
mov ah,12h
mov bl,36h
mov al,p
int 10h
END;

{$f+}
PROCEDURE nogrmode1(x,y:INTEGER;c:BYTE);
BEGIN
writeln(warning);
halt(0);
END;

PROCEDURE nogrmode2;
BEGIN
writeln(warning);
halt(0);
END;

FUNCTION nogrmode3(x,y:INTEGER):BYTE;
BEGIN
writeln(warning);
nogrmode3:=0;
halt(0);
END;

FUNCTION getpix256(x,y:INTEGER):BYTE;assembler;
ASM
mov ax,0a000h
mov es,ax
mov ax,x
mov bx,y
mov cl,6
SHL bx,cl
mov cx,bx
SHL bx,1
SHL bx,1
add bx,cx
add bx,ax
mov al,es:[bx]
END;

PROCEDURE pix256(x,y:INTEGER;c:BYTE);assembler;
ASM
mov ax,0a000h
mov es,ax
mov di,y
mov cl,6
SHL di,cl
mov cx,di
SHL di,1
SHL di,1
add di,cx
add di,x
mov al,c
stosb
END;

PROCEDURE ligne256(x1,y1,x2,y2:INTEGER;col:BYTE);ASSEMBLER;
ASM
pushf
cli
push ds
push bp
mov ax,0A000h
mov es,ax
mov bx,320
mov ax,y1
mul bx
add ax,x1
mov di,ax
xor cx,cx
mov ax,x2
sub ax,x1
jg @a
jz @b
dec cx
neg ax
jmp @b
@a:
inc cx
@b:
xor dx,dx
mov bx,y2
sub bx,y1
jg @c
jz @d
mov dx,-320
neg bx
jmp @d
@c:
mov dx,320
@d:
cmp bx,ax
jl @g
xchg ax,bx
xchg cx,dx
@g:
mov si,dx
mov dl,col
mov bp,cx
xchg si,sp
mov ds,si
shl bx,1
mov si,bx
sub si,ax
mov cx,ax
inc cx
shl ax,1
@bcl:
	mov es:[di],dl
	or si,si
	jl @j
		add di,sp
		sub si,ax
	@j:
	add di,bp
	add si,bx
loop @bcl
mov sp,ds
pop bp
pop ds
popf
END;

PROCEDURE lignehi(x1,y1,x2,y2:INTEGER;col:BYTE);assembler;
asm
pushf
cli
mov dx,3ceh
mov al,5
out dx,al
inc dx
in al,dx
push ax
or al,11b
out dx,al
dec dx
xor al,al
mov ah,col
out dx,ax
mov al,8
mov ah,0ffh
out dx,ax
mov ax,0A000h
mov es,ax
mov bx,80
mov ax,y1
mul bx
mov bx,x1
mov cl,3
shr bx,cl
add ax,bx
mov di,ax
mov ax,x2
sub ax,x1
jg @a
jl @b
xor cx,cx
jmp @c
@a:
mov cx,1
jmp @c
@b:
mov cx,-1
neg ax
@c:
mov bx,y2
sub bx,y1
jg @d
jl @e
xor dx,dx
jmp @f
@d:
mov dx,80
jmp @f
@e:
mov dx,-80
neg bx
@f:
cmp bx,ax
jl @g
xchg ax,bx
xchg cx,dx
@g:
mov word ptr cs:@modif1,0CAD0h
mov word ptr cs:@modif1+3,00D7h
or dx,dx
jge @a1
mov byte ptr cs:@modif1+1,0C2h
mov byte ptr cs:@modif1+3,0DFh
@a1:
test dx,1
jnz @a2
mov word ptr cs:@modif1,1111100011111000b
mov byte ptr cs:@modif1+4,50h
@a2:
or dx,dx
jnz @a3
mov byte ptr cs:@modif1+4,00h
@a3:
mov word ptr cs:@modif2,0CAD0h
mov word ptr cs:@modif2+3,00D7h
or cx,cx
jge @b1
mov byte ptr cs:@modif2+1,0C2h
mov byte ptr cs:@modif2+3,0DFh
@b1:
test cx,1
jnz @b2
mov word ptr cs:@modif2,1111100011111000b
mov byte ptr cs:@modif2+4,50h
@b2:
or cx,cx
jnz @b3
mov byte ptr cs:@modif2+4,00h
@b3:
mov si,bx
shl si,1
sub si,ax
mov cl,byte ptr x1
and cl,7
mov dl,80h
shr dl,cl
mov cx,ax
inc cx
shl ax,1
shl bx,1
@bcl:
	mov dh,es:[di]
	mov es:[di],dl
	or si,si
	jl @j
		@modif1: db 0,0,83h,0,0
		sub si,ax
	@j:
	@modif2: db 0,0,83h,0,0
	add si,bx
loop @bcl
mov dx,3ceh
pop ax
mov ah,5
xchg ah,al
out dx,ax
popf
END;

PROCEDURE lignehoriz256(y,x1,x2:INTEGER;col:BYTE);assembler;
ASM
cld
mov ax,0A000h
mov es,ax
mov di,y
mov cl,6
SHL di,cl
mov si,di
SHL di,1
SHL di,1
add di,si
add di,x1
mov cx,x2
inc cx
sub cx,x1
mov al,col
rep stosb
END;


PROCEDURE pixhi (x,y:INTEGER;c:BYTE);assembler;
ASM
mov bx,y
mov ax,0A000h
mov es,ax
mov ax,x
mov cl,4
SHL bx,cl
mov cx,bx
SHL bx,1
SHL bx,1
add bx,cx
mov cx,ax
SHR cx,1
SHR cx,1
SHR cx,1
add bx,cx
AND ax,7
mov cl,al
mov ah,80h
SHR ah,cl
mov al,8
mov dx,3CEh
out dx,ax
mov al,BYTE ptr es:[bx]
mov dl,c
mov BYTE ptr es:[bx],dl
END;

FUNCTION getpixhi (x,y:INTEGER):BYTE;assembler;
ASM
mov di,y
mov dx,15
mov ax,0A000h
mov es,ax
mov ax,x
mov cl,4
SHL di,cl
mov cx,di
SHL di,1
SHL di,1
add di,cx
mov cx,ax
SHR cx,1
SHR cx,1
SHR cx,1
add di,cx  {dans di, offset du BYTE voulu}

AND ax,7    {3 bits infrieur pour localiser le bit recherch}
mov cl,al
mov ah,80h
SHR ah,cl   {dans ah, masque pour bit voulu}
mov ch,ah

XOR bl,bl

mov dx,03ceh
mov ax,0304h

@gp1:out dx,ax
mov bh,es:[di]
AND bh,ch
neg bh
rol bx,1
dec ah
jge @gp1
mov al,bl
END;

PROCEDURE lignehorizhi(y,x1,x2:INTEGER;col:BYTE);assembler;
ASM
cld
mov dx,03CEh
mov ax,0A000h
mov es,ax
mov si,y
mov cl,4
SHL si,cl
mov di,si
SHL si,1
SHL si,1
add si,di
mov di,si
mov ax,x1
dec cl
SHR ax,cl
add si,ax
mov ax,x2
SHR ax,cl
add di,ax

mov ax,0ffffh
mov cx,x1
AND cl,7
SHR ah,cl
mov cx,x2
AND cl,7
inc cl
SHR al,cl
NOT al
cmp si,di

jne @multi
AND ah,al
mov al,8
out dx,ax
mov al,col
mov bl,es:[di]
mov es:[di],al
jmp @fin

@multi:
push ax
mov al,8
out dx,ax
mov bl,col
mov cl,es:[si]
mov es:[si],bl
pop ax
xchg ah,al
mov al,8
out dx,ax
mov cl,es:[di]
mov es:[di],bl

mov ah,0ffh
out dx,ax
mov cx,di
sub cx,si
dec cx
xchg si,di
inc di
mov al,col
rep stosb

@fin:

END;
{$f-}

PROCEDURE paldefaut(b:BYTE);ASSEMBLER;
ASM
mov ah,12h
mov bl,31h
mov al,b
int 10h
END;

PROCEDURE graphmode(gm:BYTE);
BEGIN
ASM
mov ah,0
mov al,gm
int 10h
END;
IF (gm>7) AND (gm<19) THEN
	BEGIN
	afftext:=afftexthi;
	ASM
	mov dx,3ceh
	mov ax,0205h
	out dx,ax
	END;
	pix:=pixhi;
	getpix:=getpixhi;
	lignehoriz:=lignehorizhi;
	ligne:=lignehi;
	END;
IF (gm=19) OR (gm=147) THEN
	BEGIN
	afftext:=afftext256;
	pix:=pix256;
	getpix:=getpix256;
	lignehoriz:=lignehoriz256;
	ligne:=ligne256;
	END;
IF gm<8 THEN
	BEGIN
	pix:=nogrmode1;
	getpix:=nogrmode3;
	END;
CASE gm OF
4,5,13,19,147:x_max:=319;
6,14,15,16,17,18:x_max:=639;
END;
CASE gm OF
4,5,6,13,14,19,147:y_max:=199;
15,16:y_max:=349;
17,18:y_max:=479;
END;
CASE gm OF
6,17:col_max:=1;
4,5:col_max:=3;
13,14,16,18:col_max:=15;
19,147:col_max:=255;
END;

END;

PROCEDURE squarepixel;
BEGIN
	ASM
	mov dx,03c2h
	mov al,11000011b
	out dx,al
	END;
END;

FUNCTION readmode:BYTE;assembler;
ASM
mov ah,0Fh
int 10h
END;

{************}
TYPE    ptpile=RECORD 		{** Dfinit un point}
	x,y,x2:INTEGER;
	h,b:BOOLEAN;
	xdeb,xfin:INTEGER;
	END;

{*******************************}
VAR fillpile:ARRAY [0..1023] OF ptpile;	{** Pile en Ring-Buffer qui sert  la PROCEDURE de remplissage}
    lp,ep   :INTEGER;			{** Pointeurs sur la pile en Ring-Buffer: Lp pour la lecture et Ep pour l'criture}

{*******************}
PROCEDURE push(p:ptpile);  	{** "Pushe" un argument-point dans la pile en Ring-Buffer}
BEGIN
fillpile[ep]:=p;        {"Pushe"}
ep:=(ep+1) AND 1023;	{et incrmente le compteur d'criture qui revient  0 si il dpasse la fin de la pile: Ring-Buffer}
END;

{**********************}
PROCEDURE pop(VAR p:ptpile);	{** PROCEDURE qui "pope" un point de la pile en Ring-Buffer}
BEGIN
p:=fillpile[lp]; 	{"Pope"}
lp:=(lp+1) AND 1023;	{et incrmente le compteur de lecture de la mme faon que le compteur d'criture}
END;


PROCEDURE fill(xg,yg:INTEGER;col:BYTE;fond:BYTE);

VAR xmin,xmax,savx,savy:INTEGER;
    pxl,px2,px3:ptpile;
    hf,bf,hf2,bf2:BOOLEAN;

LABEL htest,btest;

BEGIN
ep:=0;
lp:=0;
pxl.x:=xg;
pxl.y:=yg;
pxl.x2:=xg;
pxl.b:=FALSE;
pxl.h:=FALSE;
push(pxl);

WHILE ep<>lp DO
	BEGIN
	hf:=TRUE;
	bf:=TRUE;
	hf2:=FALSE;
	bf2:=FALSE;
	px2.b:=TRUE;
	px2.h:=FALSE;
	px3.b:=FALSE;
	px3.h:=TRUE;
	pop(pxl);
	IF (pxl.y>=0) AND (pxl.y<=y_max) THEN
	IF getpix(pxl.x,pxl.y)=fond THEN
		BEGIN

		{* Affichage de la ligne courante}
		INC(pxl.x2);
		WHILE (getpix(pxl.x2,pxl.y)=fond)
		      AND (pxl.x<=x_max)DO
			INC(pxl.x2);
		xmax:=pxl.x2-1;
		dec(pxl.x);
		WHILE (getpix(pxl.x,pxl.y)=fond)
                      AND (pxl.x>=0) DO
			DEC(pxl.x);
		INC(pxl.x);
		xmin:=pxl.x;
		lignehoriz(pxl.y,xmin,xmax,col);

		{* Test des points du dessus et du dessous}
		FOR pxl.x:=xmin TO xmax DO
			BEGIN
			INC(pxl.y);
			IF pxl.h THEN
				IF (pxl.x>=pxl.xdeb) THEN
					IF (pxl.x<=pxl.xfin) THEN
						goto htest;
			IF getpix(pxl.x,pxl.y)=fond THEN
				BEGIN
				IF hf THEN
					px2.x:=pxl.x;
				hf:=FALSE;
				END
			ELSE
				BEGIN
				IF NOT hf THEN
					BEGIN
					px2.x2:=pxl.x-1;
					px2.y:=pxl.y;
					px2.xdeb:=xmin;
					px2.xfin:=xmax;
					push(px2);
					END;
				hf:=TRUE;
				END;
			htest:
			DEC(pxl.y,2);
			IF pxl.b THEN
				IF (pxl.x>=pxl.xdeb) THEN
					IF (pxl.x<=pxl.xfin) THEN
						goto btest;
			IF getpix(pxl.x,pxl.y)=fond THEN
				BEGIN
				IF bf THEN
					px3.x:=pxl.x;
				bf:=FALSE;
				END
			ELSE
				BEGIN
				IF NOT bf THEN
					BEGIN
					px3.x2:=pxl.x-1;
					px3.y:=pxl.y;
					px3.xdeb:=xmin;
					px3.xfin:=xmax;
					push(px3);
					END;
				bf:=TRUE;
				END;
			btest:
			INC(pxl.y);
			END; {FOR}
		IF NOT hf THEN
			BEGIN
			px2.x2:=pxl.x;
			px2.y:=pxl.y+1;
			px2.xdeb:=xmin;
			px2.xfin:=xmax;
			push(px2);
			END;
		IF NOT bf THEN
			BEGIN
			px3.x2:=pxl.x;
			px3.y:=pxl.y-1;
			px3.xdeb:=xmin;
			px3.xfin:=xmax;
			push(px3);
			END;
		END; {IF}
	END; {WHILE}
END; {PROC}

VAR ydep,yfin:INTEGER;                  {Variables de la PROCEDURE}
    tramemin:ARRAY[0..479] OF INTEGER;  {de remplissage des quadrilatres}
    tramemax:ARRAY[0..479] OF INTEGER;  {qui composent la grille}

PROCEDURE lignetrame(a,b:point_2d);assembler;
VAR x1,y1,x2,y2,dfx,dfy,d1,d2,d3,d4:WORD;
    flipped,bug:BYTE;
LABEL noflip,noflip2,linelp,noflip3,dl1,dl2,dl3,dl4,dldone;
ASM
mov bug,0
mov ax,WORD ptr a
mov bx,WORD ptr a+2
sub bx,ydep
mov si,WORD ptr b
mov di,WORD ptr b+2
sub di,ydep
mov flipped,0
mov x1,ax
mov y1,bx
sub ax,si
cwd
XOR ax,dx
sub ax,dx
mov dfx,ax
mov ax,bx
sub ax,di
cwd
XOR ax,dx
sub ax,dx
mov dfy,ax

cmp ax,dfx
jle noflip

mov flipped,1
mov dfx,ax
mov ax,x1
mov bx,y1
mov x1,bx
mov y1,ax
mov ax,si
mov si,di
mov di,ax

noflip:
mov x2,si
mov y2,di
mov ax,x1
cmp ax,x2
jle noflip2
mov ax,y2
mov bx,y1
mov y1,ax
mov y2,bx
mov ax,x2
mov bx,x1
mov x2,bx
mov x1,ax

noflip2:
mov ax,y2
sub ax,y1
mov dfy,ax
SHL ax,1
mov d2,ax
sub ax,dfx
mov d1,ax
mov ax,dfy
sub ax,dfx
SHL ax,1
mov d3,ax
mov ax,dfy
add ax,dfx
SHL ax,1
mov d4,ax

linelp:
cmp flipped,0
jne noflip3
mov ax,x1
mov bx,y1
jmp dl1

noflip3:
mov ax,y1
mov bx,x1

dl1:
SHL bx,1                  {Voil le tri}
push bx
add bx,offset tramemin
cmp [bx],ax
jng @nomin
mov [bx],ax
@nomin:
pop bx
add bx,offset tramemax
cmp [bx],ax
jnl @nomax
mov [bx],ax
@nomax:
mov ax,x1
cmp ax,x2
jge dldone
inc x1
cmp d1,0
jge dl2
cmp dfy,0
jge dl3
cmp bug,0
jne @nob
inc y1
inc bug
@nob:
dec y1
mov ax,d4
jmp dl4

dl2:
cmp dfy,0
jl  dl3
inc y1
mov ax,d3
jmp dl4

dl3:
mov ax,d2
dl4:
add d1,ax
jmp linelp
dldone:
END;

PROCEDURE triangle(a,b,c:point_2d;col:BYTE);
VAR j:INTEGER;

BEGIN
ydep:=1000;
yfin:=0;

IF a.y<ydep THEN ydep:=a.y;    {Tri pour "encadrer" le polygone  afficher}
IF b.y<ydep THEN ydep:=b.y;
IF c.y<ydep THEN ydep:=c.y;
IF a.y>yfin THEN yfin:=a.y;
IF b.y>yfin THEN yfin:=b.y;
IF c.y>yfin THEN yfin:=c.y;

ASM                            {On initialise ici les parties de "tramemin"}
cld                            {et de "tramemax" dont on va se servir pour}
push ds                        {le tri dans le Bresenham modifi}
pop es
mov cx,yfin
sub cx,ydep
inc cx
mov di,offset tramemax
XOR ax,ax
push cx
rep stosw
pop cx
mov di,offset tramemin
mov ax,1000
rep stosw
END;

lignetrame(a,b);               {On appelle le Bresenham modifi pour les}
lignetrame(b,c);               {cts. On peut donc rajouter des cts}
lignetrame(c,a);               {si le polygone est convexe.}

FOR j:=0 TO (yfin-ydep) DO
lignehoriz(ydep+j,tramemin[j],tramemax[j],col); {On affiche}
END;


PROCEDURE quadri(a,b,c,d:point_2d;col:BYTE);
VAR j:INTEGER;

BEGIN
ydep:=1000;
yfin:=0;

IF a.y<ydep THEN ydep:=a.y;    {Tri pour "encadrer" le polygone  afficher}
IF b.y<ydep THEN ydep:=b.y;
IF c.y<ydep THEN ydep:=c.y;
IF d.y<ydep THEN ydep:=d.y;
IF a.y>yfin THEN yfin:=a.y;
IF b.y>yfin THEN yfin:=b.y;
IF c.y>yfin THEN yfin:=c.y;
IF d.y>yfin THEN yfin:=d.y;

ASM                            {On initialise ici les parties de "tramemin"}
cld                            {et de "tramemax" dont on va se servir pour}
push ds                        {le tri dans le Bresenham modifi}
pop es
mov cx,yfin
sub cx,ydep
inc cx
mov di,offset tramemax
XOR ax,ax
push cx
rep stosw
pop cx
mov di,offset tramemin
mov ax,1000
rep stosw
END;

lignetrame(a,b);               {On appelle le Bresenham modifi pour les}
lignetrame(b,c);               {cts. On peut donc rajouter des cts}
lignetrame(c,d);               {si le polygone est convexe.}
lignetrame(d,a);

FOR j:=0 TO (yfin-ydep) DO
lignehoriz(ydep+j,tramemin[j],tramemax[j],col); {On affiche}
END;

PROCEDURE scrolling(x,y:INTEGER);ASSEMBLER;
VAR offset:INTEGER;
ASM
pushf
cli
mov ax,y
mov cl,4
SHL ax,cl
mov bx,ax
SHL ax,1
SHL ax,1
add ax,bx
mov cx,x
SHR cx,1
SHR cx,1
add ax,cx
mov bx,ax
mov dx,3DAh
@a:
IN al,dx
test al,8
jz @a
@b:
IN al,dx
test al,8
jnz @b
mov dx,3D4h
mov al,0Ch
mov ah,bh
out dx,ax
inc al
mov ah,bl
out dx,ax
mov ax,x
AND al,11b
SHL al,1
mov ah,al
mov al,33h
mov dx,3C0h
out dx,al
xchg al,ah
out dx,al
popf
END;

BEGIN
afftext:=noaff;
pix:=nogrmode1;
getpix:=nogrmode3;
END.