{$A+} {$B-} {$D-} {$E-} {$F-} {$G-} {$I-} {$L-} {$N-} {$O-}
{$R-} {$S-} {$V-} {$X+}


unit hexgraph;

interface

procedure initgraphics;
procedure closegraphics;
procedure hexaff(x,y:integer);
procedure hexdel(x,y:integer);

implementation

uses graphza;

const hexbitmap:array[0..13,0..14] of byte=
		((0,0,0,0,1,1,1,1,1,1,1,0,0,0,0),
		 (0,0,0,1,2,2,2,2,2,2,2,1,0,0,0),
		 (0,0,0,1,2,3,3,3,3,3,2,1,0,0,0),
		 (0,0,1,2,3,4,4,4,4,4,3,2,1,0,0),
		 (0,1,2,3,4,5,5,5,5,5,4,3,2,1,0),
		 (0,1,2,3,4,5,6,6,6,5,4,3,2,1,0),
		 (1,2,3,4,5,6,7,7,7,6,5,4,3,2,1),
		 (1,2,3,4,5,6,7,7,7,6,5,4,3,2,1),
		 (0,1,2,3,4,5,6,6,6,5,4,3,2,1,0),
		 (0,1,2,3,4,5,5,5,5,5,4,3,2,1,0),
		 (0,0,1,2,3,4,4,4,4,4,3,2,1,0,0),
		 (0,0,0,1,2,3,3,3,3,3,2,1,0,0,0),
		 (0,0,0,1,2,2,2,2,2,2,2,1,0,0,0),
		 (0,0,0,0,1,1,1,1,1,1,1,0,0,0,0));
      ybase=450;
      xbase=235;

procedure hexaff(x,y:integer);
var i,j,xo,yo:integer;
begin
xo:=xbase+x*11;yo:=ybase-y*14+(x and 1)*7;
if getpix(xo+4,yo)=0 then
begin
for j:=0 to 13 do
for i:=0 to 14 do
if hexbitmap[j,i]<>0 then pix(i+xo,j+yo,hexbitmap[j,i]);
end;
end;

procedure hexdel(x,y:integer);
var i,j,xo,yo:integer;
begin
xo:=xbase+x*11;yo:=ybase-y*14+(x and 1)*7;
if getpix(xo+4,yo)<>0 then
begin
for j:=0 to 13 do
for i:=0 to 14 do
if hexbitmap[j,i]<>0 then pix(i+xo,j+yo,0);
pix(xo+7,yo+7,1);
pix(xo+7,yo+8,1);
end;
end;

procedure initgraphics;
var i,j,xo,yo:integer;
begin
graphmode(18);
palrgb(0,60,60,60);
palrgb(1,0,0,0);
for i:=2 to 7 do
begin
pal(i,i);
palrgb(i,20+i*5,20+i*5,20+i*5);
end;
for i:=0 to 30 do
begin
hexaff(0,i);
hexaff(14,i);
end;
for i:=1 to 13 do
hexaff(i,0);
for j:=1 to 30 do
for i:=1 to 13 do
begin
xo:=xbase+i*11;yo:=ybase-j*14+(i and 1)*7;
pix(xo+7,yo+7,1);
pix(xo+7,yo+8,1);
end;
end;

procedure closegraphics;
begin
graphmode(3);
end;

begin
end.