program tetris_hexagonal;

{$A+} {$B-} {$D-} {$E-} {$F-} {$G-} {$I-} {$L-} {$N-} {$O-}
{$R-} {$S-} {$V-} {$X+}

uses crt,dos,hexgraph,graphza;

const
     delta    = -1    ;
     bas      = true  ;
     haut     = not bas ;
     largeur  = 13    ;
     hauteur  = 30    ;
     esc      = #27   ;
     null     = #0    ;
     tab      = #9    ;
     cr       = #13   ;
     mxniveau = 15    ;
     nbpieces = 10    ;
     rotmax   = 6     ;
     nbelement= 4     ;
     hilevels : array[10..mxniveau] of word
              = (40,32,25,18,12,8);
     largeurbas = (largeur-delta)/2 ;
     largeurhaut= (largeur+delta)/2 ;

(*  la largeur doit etre impaire pour que les deux colonnes du bord    *)
(*  soient alignees;                                                   *)
(*  DELTA=1 ssi les impairs sont + hauts que les pairs                 *)
(*  BAS vaut false dans ces conditions, true dans le K contraire       *)

type
  descrpiece           = array [1..nbelement,1..2] of 1..nbelement;
  (*  pour chacun des hexagones, ses coordonnees x et y de 1 a 4 *)
  piece = record
            rotations :        1..6;
            yinit     :        integer;
            forme     : array [1..6,false..true] of descrpiece;
            (* la description de chacune de ses rotations, pour des posix
               pairs et impairs; les positions des posix pairs sont celles
               des posix impairs avec la coordonnee Y augmentee de 1 quand
               X est paire                                                 *)
          end;

  contenu       = (plein,vide,tombant);

  uneligne      = array[-3..largeur+4] of contenu;

  tableau       = array[-3..hauteur+4] of uneligne;
     (*  le bord du cube est forme de 4 niveaux marques comme pleins      *)
     (*  les coordonnees sont, par ordre: y,x , pour accelere la chute    *)
     (*  des cubes                                                        *)

  tlignes      = array[-3..hauteur+4,false..true] of 0..largeur;

  typescr      = array[1..2048] of word;

  st11         = string[11];

  updentree    = record
                   x,y:integer;
                 end;

const

  pieces:array[1..nbpieces] of piece = (

      (* premiere piece: ++++++++ *)
      (rotations:3;
       yinit:-3;
       forme:  ((((1,2),(2,3),(3,3),(4,4)),
                 ((1,2),(2,2),(3,3),(4,3))),
                (((3,1),(3,2),(3,3),(3,4)),
                 ((3,1),(3,2),(3,3),(3,4))),
                (((1,4),(2,4),(3,3),(4,3)),
                 ((1,4),(2,3),(3,3),(4,2))),
                (((1,2),(2,3),(3,3),(4,4)),
                 ((1,2),(2,2),(3,3),(4,3))),
                (((3,1),(3,2),(3,3),(3,4)),
                 ((3,1),(3,2),(3,3),(3,4))),
                (((1,4),(2,4),(3,3),(4,3)),
                 ((1,4),(2,3),(3,3),(4,2))))),

      (*                    ++                   *)
      (*deuxieme piece:   ++  ++                 *)
      (*                ++                       *)
      (rotations:6;
       yinit:-2;
       forme:  ((((1,2),(2,3),(3,3),(4,3)),
                 ((1,2),(2,2),(3,3),(4,2))),
                (((2,2),(2,3),(2,4),(3,4)),
                 ((2,1),(2,2),(2,3),(3,4))),
                (((1,4),(1,3),(2,3),(3,2)),
                 ((1,4),(1,3),(2,2),(3,2))),
                (((1,3),(2,3),(3,3),(4,4)),
                 ((1,3),(2,2),(3,3),(4,3))),
                (((2,2),(3,2),(3,3),(3,4)),
                 ((2,1),(3,2),(3,3),(3,4))),
                (((1,4),(2,4),(3,3),(3,2)),
                 ((1,4),(2,3),(3,3),(3,2))))),

      (*                     ++               *)
      (*troisieme piece=   ++  ++             *)
      (*                         ++           *)
      (rotations:6;
       yinit:-3;
       forme:  ((((1,3),(2,4),(3,3),(4,3)),
                 ((1,3),(2,3),(3,3),(4,2))),
                (((1,2),(1,3),(2,4),(3,4)),
                 ((1,2),(1,3),(2,3),(3,4))),
                (((2,4),(2,3),(2,2),(3,1)),
                 ((2,3),(2,2),(2,1),(3,1))),
                (((1,3),(2,3),(3,2),(4,3)),
                 ((1,3),(2,2),(3,2),(4,2))),
                (((1,2),(2,3),(3,3),(3,4)),
                 ((1,2),(2,2),(3,3),(3,4))),
                (((2,4),(3,3),(3,2),(3,1)),
                 ((2,3),(3,3),(3,2),(3,1))))),

      (*                         ++                  *)
      (*quatrieme piece:       ++++                  *)
      (*                     ++                      *)
      (rotations:6;
       yinit:-2;
       forme:  ((((1,2),(2,3),(3,3),(3,2)),
                 ((1,2),(2,2),(3,3),(3,2))),
                (((2,2),(2,3),(2,4),(3,3)),
                 ((2,1),(2,2),(2,3),(3,3))),
                (((1,3),(2,3),(3,2),(2,4)),
                 ((1,3),(2,2),(3,2),(2,3))),
                (((1,2),(1,3),(2,3),(3,3)),
                 ((1,2),(1,3),(2,2),(3,3))),
                (((1,2),(2,2),(2,3),(2,4)),
                 ((1,2),(2,1),(2,2),(2,3))),
                (((1,3),(2,3),(3,2),(2,2)),
                 ((1,3),(2,2),(3,2),(2,1))))),


      (*                  ++         *)
      (*cinquieme piece:  ++++       *)
      (*                      ++     *)
      (rotations:6;
       yinit:-2;
       forme:  ((((1,2),(1,3),(2,3),(3,2)),
                 ((1,2),(1,3),(2,2),(3,2))),
                (((1,2),(2,3),(2,2),(3,3)),
                 ((1,2),(2,2),(2,1),(3,3))),
                (((2,2),(2,3),(2,4),(3,2)),
                 ((2,1),(2,2),(2,3),(3,2))),
                (((1,3),(2,3),(3,2),(3,3)),
                 ((1,3),(2,2),(3,2),(3,3))),
                (((1,2),(2,3),(3,3),(2,4)),
                 ((1,2),(2,2),(3,3),(2,3))),
                (((2,2),(2,3),(2,4),(1,3)),
                 ((2,1),(2,2),(2,3),(1,3))))),


      (*                    ++        *)
      (*sixieme piece:     ++++       *)
      (*                    ++        *)
      (rotations:3;
       yinit:-3;
       forme:  ((((1,3),(2,3),(2,4),(3,3)),
                 ((1,3),(2,2),(2,3),(3,3))),
                (((2,3),(2,4),(3,3),(3,4)),
                 ((2,2),(2,3),(3,3),(3,4))),
                (((2,3),(2,4),(3,2),(3,3)),
                 ((2,2),(2,3),(3,2),(3,3))),
                (((1,3),(2,3),(2,4),(3,3)),
                 ((1,3),(2,2),(2,3),(3,3))),
                (((2,3),(2,4),(3,3),(3,4)),
                 ((2,2),(2,3),(3,3),(3,4))),
                (((2,3),(2,4),(3,2),(3,3)),
                 ((2,2),(2,3),(3,2),(3,3))))),


      (*                   ++    *)
      (*septieme piece:    ++    *)
      (*                 ++  ++  *)
      (rotations:2;
       yinit:-3;
       forme:  ((((1,2),(2,3),(3,2),(2,4)),
                 ((1,2),(2,2),(3,2),(2,3))),
                (((2,2),(2,3),(1,3),(3,3)),
                 ((2,1),(2,2),(1,3),(3,3))),
                (((1,2),(2,3),(3,2),(2,4)),
                 ((1,2),(2,2),(3,2),(2,3))),
                (((2,2),(2,3),(1,3),(3,3)),
                 ((2,1),(2,2),(1,3),(3,3))),
                (((1,2),(2,3),(3,2),(2,4)),
                 ((1,2),(2,2),(3,2),(2,3))),
                (((2,2),(2,3),(1,3),(3,3)),
                 ((2,1),(2,2),(1,3),(3,3))))),



      (*huitieme piece:    ++  ++        *)
      (*                 ++  ++          *)
      (rotations:3;
       yinit:-3;
       forme:  ((((1,3),(2,4),(3,3),(4,4)),
                 ((1,3),(2,3),(3,3),(4,3))),
                (((2,2),(2,3),(3,3),(3,4)),
                 ((2,1),(2,2),(3,3),(3,4))),
                (((1,4),(2,4),(2,3),(3,2)),
                 ((1,4),(2,3),(2,2),(3,2))),
                (((1,3),(2,4),(3,3),(4,4)),
                 ((1,3),(2,3),(3,3),(4,3))),
                (((2,2),(2,3),(3,3),(3,4)),
                 ((2,1),(2,2),(3,3),(3,4))),
                (((1,4),(2,4),(2,3),(3,2)),
                 ((1,4),(2,3),(2,2),(3,2))))),



      (*neuvieme piece:    ++  ++         *)
      (*                     ++  ++       *)
      (rotations:3;
       yinit:-2;
       forme:  ((((1,3),(2,3),(3,3),(4,3)),
                 ((1,3),(2,2),(3,3),(4,2))),
                (((1,2),(2,3),(2,4),(3,4)),
                 ((1,2),(2,2),(2,3),(3,4))),
                (((2,4),(2,3),(3,2),(3,1)),
                 ((2,3),(2,2),(3,2),(3,1))),
                (((1,3),(2,3),(3,3),(4,3)),
                 ((1,3),(2,2),(3,3),(4,2))),
                (((1,2),(2,3),(2,4),(3,4)),
                 ((1,2),(2,2),(2,3),(3,4))),
                (((2,4),(2,3),(3,2),(3,1)),
                 ((2,3),(2,2),(3,2),(3,1))))),



      (*                 ++          *)
      (*dixieme piece:   ++  ++      *)
      (*                   ++        *)
      (rotations:6;
       yinit:-2;
       forme:  ((((1,3),(1,2),(2,2),(3,2)),
                 ((1,3),(1,2),(2,1),(3,2))),
                (((1,2),(2,2),(3,2),(3,3)),
                 ((1,2),(2,1),(3,2),(3,3))),
                (((2,2),(3,2),(3,3),(2,4)),
                 ((2,1),(3,2),(3,3),(2,3))),
                (((3,2),(3,3),(2,4),(1,3)),
                 ((3,2),(3,3),(2,3),(1,3))),
                (((3,3),(2,4),(1,3),(1,2)),
                 ((3,3),(2,3),(1,3),(1,2))),
                (((2,4),(1,3),(1,2),(2,2)),
                 ((2,3),(1,3),(1,2),(2,1))))));


var
{  testcube, } cube:tableau;
  pcube:^tableau;
  cubes,quelle,next,niveau,nlignes,
    chute,posix,posiy,larotation,videapartirde:integer;
  lapiece:^piece;
  savecrstype,dela:word;
  leslignes:^tlignes;
{  testlignes, } llignes:tlignes;
  tsound,gauche,droite,rot,rot2,tchute,plniv,{ tdemo, } tnext,ch:char;
  dsound,snext,{ demo,demo2, } essai,nlock,arreter:boolean;
  scr:typescr;
  savemode,crsx,crsy:byte;
{  keys2,keys:string[20];     }
  time0,score,hiscore:longint;
  update:array[0..30] of updentree;
  updidx:integer;   (*  pointe sur la 1ere entree libre *)

procedure cursoff;
begin
  inline (
    $b4/$01/       (*    mov ah,1      *)     (* vire le curseur *)
    $b9/$20/$20/   (*    mov cx,2020h  *)
    $cd/$10 );     (*    int 10h       *)
end;

procedure curson;
var r:registers;
begin
  if savemode=7 then r.cx:=$8b8c else r.cx:=savecrstype;
  r.ax:=$100;
  intr($10,r);
end;

procedure prt(c:char);
begin
  case c of
    cr                : write(#17,#196,#217);
    ' '               : write('sp'         );
    tab               : write('tab'        );
    else                write( c           );
  end;
end;

procedure graphprt(x,y:byte; c:char);
begin
  case c of
    cr                : afftext(x,y,1,#17#196#217);
    ' '               : afftext(x,y,1,'sp');
    tab               : afftext(x,y,1,'tab');
    else                afftext(x,y,1,c);
  end;
end;

procedure savescr;
var
  monoscr  : typescr absolute $b000:$0000;
  colorscr : typescr absolute $b800:$0000;
  vmode    : byte    absolute $0000:$0449;
  r        : registers;
begin
  savemode:=vmode;
  if vmode=7 then scr:=monoscr else scr:=colorscr;
  crsx:=wherex;
  crsy:=wherey;
  r.ax:=$300;
  intr($10,r);
  savecrstype:=r.cx;
  time0:=meml[0:$46c];
  meml[0:$46c]:=0;
end;

procedure attend(n:byte);
var
  c      :byte;
  gtiempo:word;
begin
  for c:=1 to n do
  begin
    gtiempo:=memw[0:$46c];
    repeat until gtiempo<>memw[0:$46c];
  end;
end;

procedure disp(x,y:integer);
begin
  if essai then exit;
  if pcube^[y,x] = vide then hexdel(x,y) else hexaff(x,y);
end;

procedure doupdate;
begin
  while updidx>0 do
  begin
    dec(updidx);
    disp(update[updidx].x,update[updidx].y);
  end;
end;

procedure montre;
var
  x,y:integer;
begin
{  afftext(34,1,1,'H E X T R I S');   }
  afftext(57,6,1,'Keys are:');
  afftext(57,8,1,'Move Left    :');
  graphprt(73,8,gauche);
  afftext(57,9,1,'Move Right   :');
  graphprt(73,9,droite);
  afftext(57,10,1,'Rotate       :   ');
  graphprt(73,10,rot);
  afftext(57,11,1,'Rotate Back  :   ');
  graphprt(73,11,rot2);
  afftext(57,12,1,'Drop         :   ');
  graphprt(73,12,tchute);
  afftext(57,13,1,'Speed Up     :   ');
  graphprt(73,13,plniv);
{ afftext(57,14,1,'Demo ON/OFF  :   ');
  graphprt(73,14,tdemo);                       }
  afftext(57,14,1,'Next  ON/OFF :   ');
  graphprt(73,14,tnext);
  afftext(57,15,1,'Sound ON/OFF :   ');
  graphprt(73,15,tsound);
  afftext(57,16,1,'Stop Game    :  TAB');
  afftext(57,17,1,'Exit to DOS  :  ESC');
  afftext(54,21,1,'    P  L  A  Y ');
  afftext(54,23,1,'H  E  X  T  R  I  S  !');
end;

procedure gameover;
begin
  afftext(28,13,1,'                       ');
  afftext(28,14,1, '   G A M E    O V E R  ');
  afftext(28,15,1,'                       ');
end;

procedure initialise;
var
  x,y:integer;
begin
  for x:=-3 to largeur+4 do
    for y:=-3 to hauteur+4 do
      if (x>0) and (x<=largeur) and
         (y>0) and (y<=hauteur )
      then
        pcube^[y,x]:=vide
      else
        pcube^[y,x]:=plein;
  for x:=-3 to hauteur+4 do
  begin
    leslignes^[x,false]:=0;
    leslignes^[x,true]:=0;
  end;
  videapartirde:=0;
  updidx:=0;
end;

function intstr(i:integer):st11;
var s:st11;
begin
  str(i,s);
  intstr:=s;
end;

procedure prtscore;
begin
  afftext(5,5,1,'Level: '+intstr(niveau)+'    ');
  afftext(5,7,1,'Score: '+intstr(score)+'    ');
  afftext(5,9,1,'Lines: '+intstr(nlignes)+'    ');
{  if demo then afftext(5,11,1,'Demo : ON    ') else
    afftext(5,11,1,'Demo : OFF    ');                     }
  if snext then afftext(5,11,1,'Next : ON   ') else
    afftext(5,11,1,'Next : OFF    ');
  if dsound then afftext(5,13,1,'Sound: ON  ') else
    afftext(5,13,1,'Sound: OFF  ');
  if hiscore<>0 then
    afftext(5,15,1,'High Score: '+intstr(hiscore)+'    ');
end;

procedure drawnext;
var q:integer;
begin
  afftext(5,19,1,'Next:      ');
  afftext(3,20,1,'           ');
  afftext(3,21,1,'           ');
  afftext(3,22,1,'           ');
  afftext(3,23,1,'           ');
  afftext(3,24,1,'           ');
  for q:=1 to nbelement do
  begin
    hexaff(pieces[next].forme[1,false,q,1]-19,
           4+pieces[next].forme[1,false,q,2]);
  end;
end;

procedure clrnext;
begin
  afftext(3,19,1,'           ');
  afftext(3,20,1,'           ');
  afftext(3,21,1,'           ');
  afftext(3,22,1,'           ');
  afftext(3,23,1,'           ');
end;

procedure normkeys;
begin
  gauche   :='4';
  droite   :='6';
  rot      :='5';
  tchute   :=#32;
  plniv    :='+';
{  tdemo    :='0'; }
  tnext    :=cr ;
  rot2     :='8';
  tsound   :='S';
end;

procedure askeys;
  var
    touches:set of char;
    ch:char;
    nt:byte;

  function rkey:char;
  begin
    ch:=readkey;
    case ord(ch) of
      71 : rkey:='7';
      72 : rkey:='8';
      73 : rkey:='9';
      75 : rkey:='4';
      77 : rkey:='6';
      79 : rkey:='1';
      80 : rkey:='2';
      81 : rkey:='3';
      82 : rkey:='0';
      83 : rkey:='.';
      else rkey:=ch ;
    end;
  end;

begin
  curson;
  clrscr;
  touches:=[tab];
  repeat
    gotoxy(7,4);
    write ('          Key to move left [4] >      ',#8,#8,#8,#8);
    mem[0:$417]:=mem[0:$417] or $20;
    gauche:=upcase(readkey);
    if gauche=null then gauche:=rkey;
    prt(gauche);
    if gauche=esc  then
    begin
      normkeys;
      cursoff;
      exit;
    end;
  until not (gauche in touches);
  touches := [gauche] + touches ;
  repeat
    gotoxy(7,6);
    write ('         Key to move right [6] >      ',#8,#8,#8,#8);
    mem[0:$417]:=mem[0:$417] or $20;
    droite:=upcase(readkey);
    if droite=null then droite:=rkey;
    prt(droite);
    if droite=esc  then
    begin
      normkeys;
      cursoff;
      exit;
    end;
  until not (droite in touches);
  touches:=  [droite] + touches ;
  repeat
    gotoxy(7,8);
    write ('              Key to drop [sp] >      ',#8,#8,#8,#8);
    mem[0:$417]:=mem[0:$417] or $20;
    tchute:=upcase(readkey);
    if tchute=null then tchute:=rkey;
    prt(tchute);
    if tchute=esc  then
    begin
      normkeys;
      cursoff;
      exit;
    end;
  until not (tchute in touches);
  touches:=  [tchute] + touches ;
  repeat
    gotoxy(7,10);
    write ('             Key to rotate [5] >      ',#8,#8,#8,#8);
    mem[0:$417]:=mem[0:$417] or $20;
    rot:=upcase(readkey);
    if rot=null then rot:=rkey;
    prt(rot);
    if rot=esc  then
    begin
      normkeys;
      cursoff;
      exit;
    end;
  until not (rot in touches);
  touches:=  [rot] + touches ;
  repeat
    gotoxy(7,12);
    write ('    Key to rotate backward [8] >      ',#8,#8,#8,#8);
    mem[0:$417]:=mem[0:$417] or $20;
    rot2:=upcase(readkey);
    if rot2=null then rot2:=rkey;
    prt(rot2);
    if rot2=esc  then
    begin
      normkeys;
      cursoff;
      exit;
    end;
  until not (rot2 in touches);
  touches:=  [rot2] + touches ;
  repeat
    gotoxy(7,14);
    write ('     Key to increase level [+] >      ',#8,#8,#8,#8);
    mem[0:$417]:=mem[0:$417] or $20;
    plniv:=upcase(readkey);
    if plniv=null then plniv:=rkey;
    prt(plniv);
    if plniv=esc  then
    begin
      normkeys;
      cursoff;
      exit;
    end;
  until not (plniv in touches);
  touches:=  [plniv] + touches ;
{  repeat
    gotoxy(7,14);
    write ('              Key for DEMO [0] >      ',#8,#8,#8,#8);
    mem[0:$417]:=mem[0:$417] or $20;
    tdemo:=upcase(readkey);
    if tdemo=null then tdemo:=rkey;
    prt(tdemo);
    if tdemo=esc  then
    begin
      normkeys;
      cursoff;
      exit;
    end;
  until not (tdemo in touches);
  touches:=  [tdemo] + touches ;      }
  repeat
    gotoxy(7,16);
    write ('        Key to draw NEXT [',#17,#196,#217,'] >      ',#8,#8,#8,#8);
    mem[0:$417]:=mem[0:$417] or $20;
    tnext:=upcase(readkey);
    if tnext=null then tnext:=rkey;
    prt(tnext);
    if tnext=esc  then
    begin
      normkeys;
      cursoff;
      exit;
    end;
  until not (tnext in touches);
  touches:=  [tnext] + touches ;
  repeat
    gotoxy(7,18);
    write ('  Key to turn sound ON/OFF [S] >      ',#8,#8,#8,#8);
    mem[0:$417]:=mem[0:$417] or $20;
    tsound:=upcase(readkey);
    if tsound=null then tsound:=rkey;
    prt(tsound);
    if tsound=esc  then
    begin
      normkeys;
      cursoff;
      exit;
    end;
  until not (tsound in touches);
  touches:=  [tsound] + touches ;
  cursoff;
end;

procedure sortir;
var
  monoscr  : typescr absolute $b000:$0000;
  colorscr : typescr absolute $b800:$0000;
  tb,tc    : byte;

procedure pcolor(c:integer);
begin
  if c=0 then
  begin
    textcolor(lightgray   );
    textbackground(black  );
  end else
  begin
    textcolor(tc          );
    textbackground(tb     );
  end;
end;

begin
  graphmode(savemode);
  if savemode=7 then monoscr:=scr else colorscr:=scr;
  gotoxy(crsx,crsy);
  curson;
  writeln;
  if savemode=7 then tb:=lightgray else tb:=red;
  tc:=black;
  pcolor(0);
  write('   ');
  pcolor(1);
  write('                  ');
  pcolor(0);
  writeln;
  write('   ');
  pcolor(1);
  write('  PLAY HEXTRIS !  ');
  pcolor(0);
  writeln;
  write('   ');
  pcolor(1);
  write('                  ');
  pcolor(0);
  writeln;
  inc(meml[0:$46c],time0);
  if nlock then mem[0:$417]:=mem[0:$417] or $20
    else mem[0:$417]:=mem[0:$417] and $df;
  memw[0:$4fe]:=0;
  halt(0);
end;

procedure asklevel;
var
  touche:char;
begin
  repeat
    clrscr;
    gotoxy(28,3);
    write('H  E  X  T  R  I  S');
    gotoxy(26,6);
    write('by  MAK-TRAXON''s Prophet');
    gotoxy(25,7);
    write('Graphics by Zt le Grnd');
    gotoxy(27,24);
    write('Press R to redefine keys');
{    gotoxy(24,23);
    write('D for Demo, F for Fastest demo');
    mem[0:$417]:=mem[0:$417] or $20;  }
    gotoxy(24,13);
    write('Enter your level (0-9) [5] >  ');
    curson;
    touche:=readkey;
    cursoff;
    if touche=null then
    begin
      touche:=readkey;
      touche:=null;
    end else touche:=upcase(touche);
    if touche='R' then askeys;
  until touche<>'R';
{  demo:=false; }
  case touche of
    '0'..'9': niveau:=ord(touche)-ord('0');
{    'F'     : begin
                demo:=true;
                niveau:=mxniveau;
                demo2:=true;
              end;
    'D'     : begin
                demo:=true;
                niveau:=mxniveau;
                demo2:=false;
              end;                      }
    esc     : sortir;
    else      niveau:=5;
  end;
  gotoxy(55,13);
  write(niveau);
end;

function fit:boolean;
var
  k:byte;
begin
  fit:=true;
  for k:=1 to nbelement do
    if pcube^[posiy-1+lapiece^.forme[larotation,odd(posix),k,2],
              posix-1+lapiece^.forme[larotation,odd(posix),k,1]]
              = plein then
    begin
      fit:=false;
      exit
    end;
end;

procedure change(avec:contenu);
var
  x,y,x2,y2:integer;
begin
  for x:=1 to 4 do for y:=1 to 4 do
  begin
    x2:=x+posix-1;
    y2:=y+posiy-1;
    if pcube^[y2,x2]=tombant then
    begin
      pcube^[y2,x2]:=avec;
      if avec=plein then
      begin
        inc(leslignes^[y2,odd(x2)]);
        inc(cubes);
        if y2>=videapartirde then videapartirde:=y2+1;
      end else
      begin
        update[updidx].x:=x2;
        update[updidx].y:=y2;
        inc(updidx);
      end;
    end;
  end;
end;

procedure putmem;
var
  k:byte;
  x2,y2:integer;
begin
  for k:=1 to nbelement do
  begin
    x2:=posix-1+lapiece^.forme[larotation,odd(posix),k,1];
    y2:=posiy-1+lapiece^.forme[larotation,odd(posix),k,2];
    if pcube^[y2,x2]=vide then
    begin
      update[updidx].x:=x2;
      update[updidx].y:=y2;
      inc(updidx);
    end;
    pcube^[y2,x2]:=tombant;
  end;
end;

procedure clavier;
var
  ch:char;
  lapos1,laro1:integer;
  movido:boolean;
  temp,temp2:integer;
begin
  mem[0:$417]:=mem[0:$417] or $20;
  while keypressed { or (length(keys2)<>0) } do
  begin
    mem[0:$417]:=mem[0:$417] or $20;
{    if keys2='' then }  ch:=upcase(readkey) { else
    begin
      ch:=upcase(keys2[1]);
      keys2:=copy(keys2,2,length(keys2)-1);
      keys:=keys2;
    end }       ;
    if ch=null then ch:=readkey;
    if (ch=plniv) and (niveau<mxniveau) then
    begin
      inc(niveau);
      prtscore;
    end else
    if ch=gauche then
    begin
      dec(posix);
      if not fit then inc(posix) else
      begin
        inc(posix);
        change(vide);
        dec(posix);
        putmem;
        doupdate;
      end;
    end else
    if ch=droite then
    begin
      inc(posix);
      if not fit then dec(posix) else
      begin
        dec(posix);
        change(vide);
        inc(posix);
        putmem;
        doupdate;
      end;
    end else
    if ch=esc then sortir else
    if ch=tab then arreter:=true else
    if ch=tchute then
    begin
      temp:=posiy;
      repeat
        dec(posiy);
        inc(chute);
      until not fit;
      dec(chute);
      temp2:=posiy;
      posiy:=temp;
      change(vide);
      posiy:=temp2+1;
      putmem;
      doupdate;
    end else
    if (ch=rot) and (lapiece^.rotations>1) then
    begin
      laro1:=larotation;
      inc(larotation);
      if larotation>lapiece^.rotations then larotation:=1;
      if fit then
      begin
        change(vide);
        putmem;
        doupdate;
      end else
      begin
        dec(posiy);
        if fit then
        begin
          inc(posiy);
          change(vide);
          dec(posiy);
          putmem;
          doupdate;
        end else
        begin
          larotation:=laro1;
          inc(posiy);
        end;
      end;
    end else
    if (ch=rot2) and (lapiece^.rotations>1) then
    begin
      laro1:=larotation;
      dec(larotation);
      if larotation<1 then larotation:=lapiece^.rotations;
      if fit then
      begin
        change(vide);
        putmem;
        doupdate;
      end else
      begin
        dec(posiy);
        if fit then
        begin
          inc(posiy);
          change(vide);
          dec(posiy);
          putmem;
          doupdate;
        end else
        begin
          larotation:=laro1;
          inc(posiy);
        end;
      end;
    end else
{    if ch=tdemo then
    begin
      demo:=not demo;
      prtscore;
    end else                }
    if ch=tnext then
    begin
      snext:=not snext;
      if snext then drawnext else clrnext;
      prtscore;
    end else
    if ch=tsound then
    begin
      dsound:=not dsound;
      prtscore;
    end;
  end;
end;

procedure pointsligne;
begin
  inc(score,15);
  inc(nlignes);
  if (nlignes div 10 > niveau) and (niveau<mxniveau) then inc(niveau);
  prtscore;
  if dsound then
  begin
    sound(400);
    attend(1);
    sound(600);
    attend(1);
    nosound;
  end;
end;

procedure effetligne(y:integer);
var x:integer;
begin
  for x:=1 to largeur do hexdel(x,y);
  delay(100);
  for x:=1 to largeur do disp(x,y);
  delay(100);
  for x:=1 to largeur do hexdel(x,y);
  delay(100);
  for x:=1 to largeur do disp(x,y);
  delay(100);
end;

procedure lignes;
var
  x2,y2,x3,y3,der   : integer;
  combien           : byte   ;
  saveligne         : uneligne;
begin
  y2:=posiy-2;
  combien:=0;
  der:=-44;
  repeat
    if ((leslignes^[y2,false]+leslignes^[y2,true])=largeur) and
    ( (der=y2) or (leslignes^[y2-1,haut]=largeurhaut) or
                  (leslignes^[y2+1,bas]=largeurbas) ) then
    begin
(*    faire disparaitre la ligne y2 entiere  *)
      der:=y2;
      effetligne(y2);
      dec(cubes,largeur);
      inc(combien);
      for y3:=y2+1 to videapartirde do
      begin
        saveligne:=pcube^[y3-1];
        leslignes^[y3-1]:=leslignes^[y3];
        pcube^[y3-1]:=pcube^[y3];
        for x3:=1 to largeur do
          if pcube^[y3-1,x3]<>saveligne[x3] then
            disp(x3,y3-1);
      end;
      for x3:=1 to largeur do
      begin
        pcube^[videapartirde,x3]:=vide;
        disp(x3,videapartirde);
      end;
      leslignes^[videapartirde,false]:=0;
      leslignes^[videapartirde,true]:=0;
      pointsligne;
      dec(videapartirde);
    end else
(*    if (leslignes^[y2,haut]+leslignes^[y2+1,bas]) = largeur then  *)
    (* ligne entre y2.haut et y2+1.bas  *)
 (*   begin
      dec(cubes,largeur);
      inc(combien);
      for x3:=1 to largeur do
        if odd(x3)=haut then
        begin
          pcube^[y2,x3]:=pcube^[y2+1,x3];
          disp(x3,y2);
        end;
      for y3:=y2+2 to videapartirde do
      begin
        leslignes^[y3-1]:=leslignes^[y3];
        pcube^[y3-1]:=pcube^[y3];
        for x3:=1 to largeur do disp(x3,y3-1);
      end;
      for x3:=1 to largeur do
      begin
        pcube^[videapartirde,x3]:=vide;
        disp(x3,videapartirde);
      end;
      leslignes^[videapartirde,false]:=0;
      leslignes^[videapartirde,true]:=0;
      pointsligne;
      dec(videapartirde);
      end else *) inc(y2);
  until y2>=posiy+5;
  if combien>=nbelement then
  begin
    inc(score,247);
    if dsound then
    begin
      sound(1200);
      attend(1);
      nosound;
    end;
  end;
end;

{
procedure actlignes;
var
  x,y,x2,y2:integer;
begin
  for x:=1 to 4 do for y:=1 to 4 do
  begin
    x2:=x+posix-1;
    y2:=y+posiy-1;
    if pcube^[y2,x2]=tombant then inc(leslignes^[y2,odd(x2)]);
  end;
end;
 }
(* function evalue:longint;   *)
(*  pcube^ contient un cube auquel il faut donner une "ponctuation", plus  *)
(*  elevee quand la situation est meilleure; les tombants doivent etre pris*)
(*  comme des pleins; leslignes^ compte deja avec la piece.                *)
(*
var
  x,y,k,puits,bujad,bdx:integer;
  valeur:longint;
  f:boolean;
begin
  valeur:=0;
  bujad:=-44;
  bdx:=-44;
  for x:=1 to largeur do
  begin
    y:=hauteur;
    while (y>0) and ((pcube^[y,x]=vide) or (leslignes^[y]=largeur)) do
      dec(y);
    f:=pcube^[y,x]=plein;
    dec(y);
    while y>0 do
    begin
      if pcube^[y,x]=vide then
      begin
        dec(valeur,14);
        if f and (y>bujad) then
        begin
          bujad:=y;
          bdx:=x;
        end;
      end else f:=f or (pcube^[y,x]=plein);
      dec(y);
    end;
    y:=hauteur;
    puits:=0;
    if (not snext) or (quelle=1) or (next<>1) then
    (* si on montre la suivante, elle est plane et l'actuelle ne l'est pas *)
    (* ne pas regarder les puits                                           *)
(*    begin
      while (y>0) and (pcube^[y,x]=vide) and
        ((pcube^[y,x-1]=vide) or (pcube^[y,x+1]=vide)) do dec(y);
      while (y>0) and (pcube^[y,x]=vide) *)
(*      and ((pcube^[y,x-1]<>vide) and (pcube^[y,x+1]<>vide))  *)
(*      do
      begin
        dec(y);
        inc(puits);
      end;
      if puits>=2 then dec(valeur,5*(puits-1));
    end;
  end;
  for k:=1 to nbelement do
    if (posix-1+lapiece^.forme[larotation,k,1]=bdx) and
       (leslignes^[posiy-1+lapiece^.forme[larotation,k,2]]<>largeur)
    then dec(valeur,6);
  for y:=1 to hauteur do if leslignes^[y]=largeur then inc(valeur,15);
  valeur:=valeur-3*posiy+2*(larotation and 1)+abs(posix-largeur div 2);
  if ((quelle=4) and (larotation=2) and (pcube^[posiy+2,posix+3]=vide))
    or
     ((quelle=5) and (larotation=4) and (pcube^[posiy+2,posix+1]=vide))
    then dec(valeur,30);
  evalue:=valeur;
end;

procedure decide;
type
  entree = record
             px,rt,aaaa:integer;
           end;
var
  savecube:^tableau;
  savelignes:^tlignes;
  savelarotation,saveposix,saveposiy,ppx:integer;
  valeurs:array[0..(largeur+6)*nbrot] of entree;
  aaa,indicateur,c,d:integer;
  valeur,max:longint;
  posiys:array[-3..largeur+1,1..nbrot] of integer;

begin   *)
  (* initaliation: les fonctions du style de fit traitent un tableau *)
  (* d'essais et peuvent etre utilisees ici                          *)
(*  keys:='';     *)
  (*  +1 pour bouger a droite a la fin, -1 a gauche, 0 rien *)
(*  for c:=-3 to largeur+1 do for d:=1 to nbrot do posiys[c,d]:=-200;
  essai:=true;
  savecube:=@pcube^;
  savelignes:=@leslignes^;
  pcube:=@testcube;
  leslignes:=@testlignes;
  pcube^:=savecube^;
  leslignes^:=savelignes^;
  savelarotation:=larotation;
  saveposix:=posix;
  saveposiy:=posiy;
  (* ici commence le travail *)
 (*
  max:=-200000000;
  indicateur:=0;
  for posix:=-2 to largeur do for larotation:=1 to lapiece^.rotations do
  begin
    posiy:=hauteur-3;
    if fit then
    begin
      repeat dec(posiy) until not fit;
      inc(posiy);
      posiys[posix,larotation]:=posiy;
    end;
  end;
  for ppx:=-2 to largeur do for larotation:=1 to lapiece^.rotations do
  begin
    posix:=ppx;
    posiy:=posiys[posix,larotation];
    if posiy>-100 then
    begin
      leslignes^:=savelignes^;
      putmem;
      actlignes;
      valeur:=evalue;
      change(vide);
      if valeur>max then
      begin
        indicateur:=1;
        max:=valeur;
        valeurs[0].rt:=larotation;
        valeurs[0].px:=posix;
        valeurs[0].aaaa:=0;
      end else
      if valeur=max then
      begin
        valeurs[indicateur].rt:=larotation;
        valeurs[indicateur].px:=posix;
        valeurs[indicateur].aaaa:=0;
        inc(indicateur);
      end;
      if posiy<posiys[posix-1,larotation] then
      begin
        dec(posix);
        if fit then
        begin
          repeat dec(posix) until not fit;
          inc(posix);
          leslignes^:=savelignes^;
          putmem;
          actlignes;
          valeur:=evalue;
          change(vide);
          if valeur>max then
          begin
            indicateur:=1;
            max:=valeur;
            valeurs[0].rt:=larotation;
            valeurs[0].px:=ppx;
            valeurs[0].aaaa:=posix-ppx;
          end;
        end;
      end;
      posix:=ppx;
      if posiy<posiys[posix+1,larotation] then
      begin
        inc(posix);
        if fit then
        begin
          repeat inc(posix) until not fit;
          dec(posix);
          leslignes^:=savelignes^;
          putmem;
          actlignes;
          valeur:=evalue;
          change(vide);
          if valeur>max then
          begin
            indicateur:=1;
            max:=valeur;
            valeurs[0].rt:=larotation;
            valeurs[0].px:=ppx;
            valeurs[0].aaaa:=posix-ppx;
          end;
        end;
      end;
    end;
  end;
  if indicateur<>0 then
  begin
    indicateur:=random(indicateur);
    posix:=valeurs[indicateur].px;
    aaa:=valeurs[indicateur].aaaa;
    larotation:=valeurs[indicateur].rt;
    while (larotation-savelarotation) mod lapiece^.rotations <> 0 do
    begin
      keys:=keys+rot;
      dec(larotation);
    end;
    if posix>saveposix then for c:=1 to posix-saveposix do keys:=keys+droite;
    if posix<saveposix then for c:=1 to saveposix-posix do keys:=keys+gauche;
    if demo2 then keys:=keys+tchute;
    if aaa<>0 then
    begin
      if not demo2 then keys:=keys+tchute;
      while aaa>0 do
      begin
        keys:=keys+droite;
        dec(aaa);
      end;
      while aaa<0 do
      begin
        inc(aaa);
        keys:=keys+gauche;
      end;
    end;
  end;        *)
    (* en sortant, remettre les pointeurs *)
(*  pcube:=@savecube^;
  leslignes:=@savelignes^;
  larotation:=savelarotation;
  posix:=saveposix;
  posiy:=saveposiy;
  essai:=false;
end;
*)

procedure jeu;
var
  ch     : char;
  niv0   : integer;
begin
  niv0   :=niveau;
  repeat
    initialise;
    initgraphics;
    score  :=0;
  { keys   :='';
    keys2  :='';       }
    snext  :=false;
    nlignes:=0;
    cubes  :=0;
    montre;
    prtscore;
    next:=random(nbpieces)+1;
    repeat
      arreter   :=false;
      larotation:=1;
      quelle    :=next;
      next      :=random(nbpieces)+1;
      if snext then drawnext;
      lapiece   :=@pieces[quelle];
  {    if not demo2 then }  while keypressed do readkey;
      posiy     :=hauteur+lapiece^.yinit;
      posix     :=largeur shr 1;
      chute     :=0;
  (*  if demo then decide;       *)
      (* met dans KEYS la sequence de touches a simuler *)
      while fit and (not arreter) do
      begin
        putmem;
        doupdate;
        inc (chute);
  {      if chute>1 then keys2:=keys;                     }
  {      if demo2 and (not keypressed) then clavier
        else } if niveau<10 then
        begin
          dela:=memw[0:$46c]+10-niveau;
          while memw[0:$46c]<dela do clavier;
        end else
        begin
          clavier;
          delay(hilevels[niveau]);
        end;
        change(vide);
        dec(posiy);
      end;
      if chute>0 then
      begin
        inc(posiy);
        putmem;
        change(plein);
        doupdate;
        score:=score+10+(niveau shl 1)+quelle+(chute shr 2)+random(3);
        if snext then dec(score,7);
        prtscore;
        lignes;
      end;
      if cubes=0 then
      begin
        inc(score,527);
        if dsound then
        begin
          sound(450);
          attend(1);
          sound(900);
          attend(2);
          sound(1200);
          attend(3);
          nosound;
        end;
      end;
    until (chute=0) or arreter;
    if not arreter then
    begin
      if dsound then
      begin
        attend(1);
        sound(250);
        attend(1);
        sound(150);
        attend(3);
        nosound;
      end;
      gameover;
      ch:=upcase(readkey);
      case ch of
        #0 :  readkey;
        #27:  sortir;
        'R':  niveau:=niv0;
      end;
    end;
    graphmode(savemode);
  until (ch<>'R') or arreter;
end;

begin
  essai   :=false;
  dsound  :=true;
  pcube   :=@cube;
  leslignes:=@llignes;
  memw[0:$4fe]:=$9091;
  nlock   :=(mem[0:$417] and $20)<>0;
  normkeys;
  randseed:=memw[0:$46c];
  while keypressed do readkey;
  savescr;
  cursoff;
  hiscore:=0;
  repeat
    asklevel;
    jeu;
    if score>hiscore then hiscore:=score;
  until false;
end.
