program autotetris;

{ Tetris with Demo, by MAK-TRAXON's Prophet                             }
{ Started a long time ago ...                                           }
{ Latest update: 17/2/1993                                              }

{$A+} {$B-} {$D-} {$E-} {$F-}  {$I-} {$L-} {$N-} {$O-}
{$R-} {$S-} {$V-}

uses crt,dos;

const
     width    = 10    ;
     height   = 20    ;
     esc      = #27   ;
     null     = #0    ;
     tab      = #9    ;
     cr       = #13   ;
     maxlevel  = 15   ;
     nbpieces = 7     ;
     hilevels : array[9..maxlevel] of word
              = (80,60,45,35,28,22,10);

type
  descrpiece = array [1..4,1..2] of 1..4;
  {  for each of the squares, its x and y coordinates (from 1 to 4) }
  piece = record
            rotations  :        1..4;
            shape      : array [1..4] of descrpiece;
          end;

  contents     = (full,empty,falling);

  tetris_well  = array[-3..height+4,-3..width+4] of contents;
  { the edges of the tetris well are filled with 4 levels of "full".   }
  { this allows not to check that coordinates are within the well.     }
  { the y coordinate comes first so that entire lines are stored in    }
  { consecutive memory positions                                       }

  tlines      = array[-3..height+4] of 0..width;
  { this type of vars holds how many filled squares there are in each line }

  scrtype     = array[1..2048] of word;
  { this is a text screen }

const
  pieces:array[1..nbpieces] of piece = (

      { first piece: ++++++++ }

      (rotations:2;
       shape:   (((1,3),(2,3),(3,3),(4,3)),
                 ((3,1),(3,2),(3,3),(3,4)),
                 ((1,3),(2,3),(3,3),(4,3)),
                 ((3,1),(3,2),(3,3),(3,4)))
      ),


      {second piece: ++++  }
      {              ++++  }
      (rotations:1;
       shape:   (((2,3),(3,3),(2,2),(3,2)),
                 ((2,3),(3,3),(2,2),(3,2)),
                 ((2,3),(3,3),(2,2),(3,2)),
                 ((2,3),(3,3),(2,2),(3,2)))
      ),


      {third piece=   ++++++    }
      {                 ++      }
      (rotations:4;
       shape:   (((3,2),(2,3),(3,3),(4,3)),
                 ((3,2),(3,3),(3,4),(4,3)),
                 ((2,2),(3,2),(4,2),(3,3)),
                 ((2,3),(3,2),(3,3),(3,4)))
      ),


      {fourth piece:    ++++++    }
      {                     ++    }
      (rotations:4;
       shape:  (((2,3),(3,3),(4,2),(4,3)),
                ((3,2),(3,3),(3,4),(4,4)),
                ((2,2),(3,2),(4,2),(2,3)),
                ((2,2),(3,2),(3,3),(3,4)))

      ),


      {fifth piece:  ++++++     }
      {              ++         }
      (rotations:4;
       shape:   (((2,2),(2,3),(3,3),(4,3)),
                 ((3,2),(3,3),(3,4),(4,2)),
                 ((2,2),(3,2),(4,2),(4,3)),
                 ((2,4),(3,2),(3,3),(3,4)))
      ),


      {sixth piece:     ++++  }
      {               ++++    }
      (rotations:2;
       shape:   (((2,2),(3,2),(3,3),(4,3)),
                 ((3,3),(3,4),(4,2),(4,3)),
                 ((2,2),(3,2),(3,3),(4,3)),
                 ((3,3),(3,4),(4,2),(4,3)))
      ),


      {seventh piece:   ++++    }
      {                   ++++  }
      (rotations:2;
       shape:   (((2,3),(3,2),(3,3),(4,2)),
                 ((3,2),(3,3),(4,3),(4,4)),
                 ((2,3),(3,2),(3,3),(4,2)),
                 ((3,2),(3,3),(4,3),(4,4)))
      ));

var
  testcube,cube:tetris_well;
  thecube:^tetris_well;
  cubes,whichpiece,next,level,nlines,fallen,posix,posiy,rotation:integer;
  thepiece:^piece;
  savecrstype,dela:word;
  thelines:^tlines;
  testlines,llines:tlines;
  tsound,left,right,rot,rot2,tdrop,level_up,tdemo,tnext,ch:char;
  dsound,snext,demo,demo2,test,nlock,stop_game:boolean;
  scr:scrtype;
  savemode,crsx,crsy:byte;
  keys2,keys:string[20];
  time0,score,hiscore:longint;

procedure cursoff;
{ clear cursor }
begin
  inline (
    $b4/$01/       {    mov ah,1      }
    $b9/$20/$20/   {    mov cx,2020h  }
    $cd/$10 );     {    int 10h       }
end;

procedure curson;
{ display cursor; assumes savescr has already been called  }
var r:registers;
begin
  if savemode=7 then r.cx:=$8b8c else r.cx:=savecrstype;
  r.ax:=$100;
  intr($10,r);
end;

procedure prt(c:char);
begin
  case c of
    cr                : write(#17,#196,#217);
    ' '               : write('sp'         );
    tab               : write('tab'        );
    else                write( c           );
  end;
end;

procedure savescr;
{ save screen type and contents, and cursor shape and position }
{ init time handling }
var
  monoscr  : scrtype absolute $b000:$0000;
  colorscr : scrtype absolute $b800:$0000;
  vmode    : byte    absolute $0000:$0449;
  r        : registers;
begin
  savemode:=vmode;
  if vmode=7 then scr:=monoscr else scr:=colorscr;
  crsx:=wherex;
  crsy:=wherey;
  r.ax:=$300;
  intr($10,r);
  savecrstype:=r.cx;
  time0:=meml[0:$46c];
  meml[0:$46c]:=0;
end;

procedure wait(n:byte);
{ wait for n 18ths of a second }
var
  c:byte;
  gtime:word;
begin
  for c:=1 to n do
  begin
    gtime:=memw[0:$46c];
    repeat until gtime<>memw[0:$46c];
  end;
end;

procedure disp(x,y:integer);
{ display a Tetris screen position }
begin
  if test then exit;   { do not display if we are only testing a position }
  gotoxy(28+2*x,24-y);
  case thecube^[y,x] of
    full,falling : write(#219,#219);
    empty        : write(#176,#176);
  end;
end;

procedure show;
var
  x,y:integer;
begin
  for y:=height downto 1 do
    for x:=1 to width do
      disp(x,y);
  gotoxy (32, 1);
  write  ('T  E  T  R  I  S');
  for y:=1 to height do
  begin
    gotoxy(29,24-y);
    write(#186);
    gotoxy(50,24-y);
    write(#186);
  end;
  gotoxy(29,24);
  write(#200);
  for x:=1 to 2*width do write(#205);
  write(#188);
  gotoxy(57,5);
  write('Keys are:');
  gotoxy(57,8);
  write('Move Left    :   ');
  prt(left);
  gotoxy(57,9);
  write('Move Right   :   ');
  prt(right);
  gotoxy(57,10);
  write('Rotate       :   ');
  prt(rot);
  gotoxy(57,11);
  write('Rotate Back  :   ');
  prt(rot2);
  gotoxy(57,12);
  write('Drop         :   ');
  prt(tdrop);
  gotoxy(57,13);
  write('Speed Up     :   ');
  prt(level_up);
  gotoxy(57,14);
  write('Demo ON/OFF  :   ');
  prt(tdemo);
  gotoxy(57,15);
  write('Next ON/OFF  :   ');
  prt(tnext);
  gotoxy(57,16);
  write('Sound ON/OFF :   ');
  prt(tsound);
end;

procedure gameover;
begin
  gotoxy(30,12);
  textcolor(black+blink);
  textbackground(lightgray);
  write('                    ');
  gotoxy(30,13);
  write(' G A M E    O V E R ');
  gotoxy(30,14);
  write('                    ');
  textcolor(lightgray);
  textbackground(black);
end;

procedure init;
var
  x,y:integer;
begin
  for x:=-3 to width+4 do
    for y:=-3 to height+4 do
      if (x>0) and (x<=width) and
         (y>0) and (y<=height )
      then
        thecube^[y,x]:=empty
      else
        thecube^[y,x]:=full;
  for x:=-3 to height+4 do thelines^[x]:=0;
end;

procedure prtscore;
begin
  gotoxy(5,5);
  write('Level: ', level,'    ');
  gotoxy(5,7);
  write('Score: ',score,'    ');
  gotoxy(5,9);
  write('Lines: ',nlines,'    ');
  gotoxy(5,11);
  write('Demo : ');
  if demo then write('ON    ') else write('OFF    ');
  gotoxy(5,13);
  write('Next : ');
  if snext then write('ON   ') else write('OFF    ');
  gotoxy(5,15);
  write('Sound: ');
  if dsound then write('ON  ') else write('OFF  ');
  gotoxy(5,17);
  if hiscore<>0 then
    write('High Score: ',hiscore,'    ');
end;

procedure drawnext;
var q:integer;
begin
  gotoxy(5,19);
  write('Next:     ');
  gotoxy(3,20);
  write('           ');
  gotoxy(3,21);
  write('           ');
  gotoxy(3,22);
  write('           ');
  gotoxy(3,23);
  write('           ');
  for q:=1 to 4 do
  begin
    gotoxy(2*pieces[next].shape[1,q,1]+1,24-pieces[next].shape[1,q,2]);
    write(#219,#219);
  end;
end;

procedure clrnext;
begin
  gotoxy(3,19);
  write('           ');
  gotoxy(3,20);
  write('           ');
  gotoxy(3,21);
  write('           ');
  gotoxy(3,22);
  write('           ');
  gotoxy(3,23);
  write('           ');
end;

procedure normkeys;
begin
  left    :='4';
  right   :='6';
  rot     :='5';
  tdrop   :=' ';
  level_up:='+';
  tdemo   :='0';
  tnext   :=cr ;
  rot2    :='8';
  tsound  :='S';
end;

procedure ask_keys;
  var
    keys:set of char;
    ch:char;
    nt:byte;

  function rkey:char;
  begin
    ch:=readkey;
    case ord(ch) of
      71 : rkey:='7';
      72 : rkey:='8';
      73 : rkey:='9';
      75 : rkey:='4';
      77 : rkey:='6';
      79 : rkey:='1';
      80 : rkey:='2';
      81 : rkey:='3';
      82 : rkey:='0';
      83 : rkey:='.';
      else rkey:=ch ;
    end;
  end;

begin
  curson;
  clrscr;
  keys:=[tab];
  repeat
    gotoxy(10,2);
    write ('          Key to move left [4] >      ',#8,#8,#8,#8);
    mem[0:$417]:=mem[0:$417] or $20;
    left:=upcase(readkey);
    if left=null then left:=rkey;
    prt(left);
    if left=esc  then
    begin
      normkeys;
      cursoff;
      exit;
    end;
  until not (left in keys);
  keys:=[left]+keys ;
  repeat
    gotoxy(10,4);
    write ('         Key to move right [6] >      ',#8,#8,#8,#8);
    mem[0:$417]:=mem[0:$417] or $20;
    right:=upcase(readkey);
    if right=null then right:=rkey;
    prt(right);
    if right=esc  then
    begin
      normkeys;
      cursoff;
      exit;
    end;
  until not (right in keys);
  keys:=[right]+keys;
  repeat
    gotoxy(10,6);
    write ('              Key to drop [sp] >      ',#8,#8,#8,#8);
    mem[0:$417]:=mem[0:$417] or $20;
    tdrop:=upcase(readkey);
    if tdrop=null then tdrop:=rkey;
  prt(tdrop);
  if tdrop=esc  then
  begin
    normkeys;
    cursoff;
    exit;
  end;
  until not (tdrop in keys);
  keys:=[tdrop]+keys;
  repeat
    gotoxy(10,8);
    write ('             Key to rotate [5] >      ',#8,#8,#8,#8);
    mem[0:$417]:=mem[0:$417] or $20;
    rot:=upcase(readkey);
    if rot=null then rot:=rkey;
    prt(rot);
    if rot=esc then
    begin
      normkeys;
      cursoff;
      exit;
    end;
  until not (rot in keys);
  keys:=[rot]+keys;
  repeat
    gotoxy(10,10);
    write ('    Key to rotate backward [8] >      ',#8,#8,#8,#8);
    mem[0:$417]:=mem[0:$417] or $20;
    rot2:=upcase(readkey);
    if rot2=null then rot2:=rkey;
    prt(rot2);
    if rot2=esc then
    begin
      normkeys;
      cursoff;
      exit;
    end;
  until not (rot2 in keys);
  keys:=[rot2]+keys ;
  repeat
    gotoxy(10,12);
    write ('     Key to increase level [+] >      ',#8,#8,#8,#8);
    mem[0:$417]:=mem[0:$417] or $20;
    level_up:=upcase(readkey);
    if level_up=null then level_up:=rkey;
    prt(level_up);
    if level_up=esc then
    begin
      normkeys;
      cursoff;
      exit;
    end;
  until not (level_up in keys);
  keys:=[level_up]+keys ;
  repeat
    gotoxy(10,14);
    write ('              Key for DEMO [0] >      ',#8,#8,#8,#8);
    mem[0:$417]:=mem[0:$417] or $20;
    tdemo:=upcase(readkey);
    if tdemo=null then tdemo:=rkey;
    prt(tdemo);
    if tdemo=esc  then
    begin
      normkeys;
      cursoff;
      exit;
    end;
  until not (tdemo in keys);
  keys:=[tdemo]+keys ;
  repeat
    gotoxy(10,16);
    write ('        Key to draw NEXT [',#17,#196,#217,'] >      ',#8,#8,#8,#8);
    mem[0:$417]:=mem[0:$417] or $20;
    tnext:=upcase(readkey);
    if tnext=null then tnext:=rkey;
    prt(tnext);
    if tnext=esc  then
    begin
      normkeys;
      cursoff;
      exit;
    end;
  until not (tnext in keys);
  keys:=[tnext]+keys ;
  repeat
    gotoxy(10,18);
    write ('  Key to turn sound ON/OFF [S] >      ',#8,#8,#8,#8);
    mem[0:$417]:=mem[0:$417] or $20;
    tsound:=upcase(readkey);
    if tsound=null then tsound:=rkey;
    prt(tsound);
    if tsound=esc  then
    begin
      normkeys;
      cursoff;
      exit;
    end;
  until not (tsound in keys);
  keys:=[tsound]+keys ;
  cursoff;
end;

procedure quit;
var
  vmode    : byte    absolute $0000:$0449;
  monoscr  : scrtype absolute $b000:$0000;
  colorscr : scrtype absolute $b800:$0000;
  tb,tc    : byte;

procedure pcolor(c:integer);
begin
  if c=0 then
  begin
    textcolor(lightgray   );
    textbackground(black  );
  end else
  begin
    textcolor(tc          );
    textbackground(tb     );
  end;
end;

begin
  if vmode=7 then monoscr:=scr else colorscr:=scr;
  gotoxy(crsx,crsy);
  curson;
  writeln;
  if vmode=7 then tb:=lightgray else tb:=red;
  tc:=black;
  pcolor(0);
  write('   ');
  pcolor(1);
  write('                 ');
  pcolor(0);
  writeln;
  write('   ');
  pcolor(1);
  write('  PLAY TETRIS !  ');
  pcolor(0);
  writeln;
  write('   ');
  pcolor(1);
  write('                 ');
  pcolor(0);
  writeln;
  inc(meml[0:$46c],time0);
  if nlock then mem[0:$417]:=mem[0:$417] or $20
    else mem[0:$417]:=mem[0:$417] and $df;
  halt(0);
end;

procedure ask_level;
var
  key:char;
begin
  repeat
    clrscr;
    gotoxy(30,4);
    writeln('T  E  T  R  I  S');
    gotoxy(27,6);
    writeln('by MAK-TRAXON''s Prophet');
    gotoxy(27,21);
    write ('Press R to redefine keys,');
    gotoxy(24,23);
    write ('D for Demo, F for Fastest demo');
    mem[0:$417]:=mem[0:$417] or $20;
    gotoxy(24,13);
    write ('Enter your level (0-9) [5] >  ');
    curson;
    key:=readkey;
    cursoff;
    if key=null then
    begin
      key:=readkey;
      key:=null;
    end else key:=upcase(key);
    if key='R' then ask_keys;
  until key<>'R';
  demo:=false;
  demo2:=false;
  case key of
    '0'..'9': level:=ord(key)-ord('0');
    'F'     : begin
                demo:=true;
                level:=maxlevel;
                demo2:=true;
              end;
    'D'     : begin
                demo:=true;
                level:=maxlevel;
                demo2:=false;
              end;
    esc     : quit;
    else      level:=5;
  end;
  gotoxy(55,13);
  write(level);
end;

function fits:boolean;
{ returns False if the current piece at the current position (defined by  }
{ posix, posiy and rotation) "hits" some other piece, else returns True   }
var
  k:byte;
begin
  fits:=true;
  for k:=1 to 4 do
    if thecube^[posiy-1+thepiece^.shape[rotation,k,2],
            posix-1+thepiece^.shape[rotation,k,1]] = full then
    begin
      fits:=false;
      exit
    end;
end;

procedure change(what:contents);
{ requires posix and posiy to be correct, but not rotation }
var
  x,y,x2,y2:integer;
begin
  for x:=1 to 4 do for y:=1 to 4 do
  begin
    x2:=x+posix-1;
    y2:=y+posiy-1;
    if thecube^[y2,x2]=falling then
    begin
      thecube^[y2,x2]:=what;
      disp(x2,y2);
      if what=full then
      begin
        inc(thelines^[y2]);
        inc(cubes);
      end;
    end;
  end;
end;

procedure putmem;
var
  k:byte;
  x2,y2:integer;
begin
  for k:=1 to 4 do
  begin
    x2:=posix-1+thepiece^.shape[rotation,k,1];
    y2:=posiy-1+thepiece^.shape[rotation,k,2];
    thecube^[y2,x2]:=falling;
    disp(x2,y2);
  end;
end;

procedure keyboard;
var
  ch:char;
  lastrot:integer;
  temp,temp2:integer;
begin
  mem[0:$417]:=mem[0:$417] or $20;
  while keypressed or (length(keys2)<>0) do
  begin
    mem[0:$417]:=mem[0:$417] or $20;
    if keys2='' then ch:=upcase(readkey) else
    begin
      ch:=upcase(keys2[1]);
      keys2:=copy(keys2,2,length(keys2)-1);
      keys:=keys2;
    end;
    if ch=null then ch:=readkey;
    if (ch=level_up) and (level<maxlevel) then
    begin
      inc(level);
      prtscore;
    end else
    if ch=left then
    begin
      dec(posix);
      if not fits then inc(posix) else
      begin
        inc(posix);
        change(empty);
        dec(posix);
        putmem;
      end;
    end else
    if ch=right then
    begin
      inc(posix);
      if not fits then dec(posix) else
      begin
        dec(posix);
        change(empty);
        inc(posix);
        putmem;
      end;
    end else
    if ch=esc then quit else
    if ch=tab then stop_game:=true else
    if ch=tdrop then
    begin
      temp:=posiy;
      repeat
        dec(posiy);
        inc(fallen);
      until not fits;
      dec(fallen);
      temp2:=posiy;
      posiy:=temp;
      change(empty);
      posiy:=temp2+1;
      putmem;
    end else
    if (ch=rot) and (thepiece^.rotations>1) then
    begin
      lastrot:=rotation;
      inc(rotation);
      if rotation>thepiece^.rotations then rotation:=1;
      if fits then
      begin
        change(empty);
        putmem;
      end else
      begin
        dec(posiy);
        if fits then
        begin
          inc(posiy);
          change(empty);
          dec(posiy);
          putmem;
        end else
        begin
          rotation:=lastrot;
          inc(posiy);
        end;
      end;
    end else
    if (ch=rot2) and (thepiece^.rotations>1) then
    begin
      lastrot:=rotation;
      dec(rotation);
      if rotation<1 then rotation:=thepiece^.rotations;
      if fits then
      begin
        change(empty);
        putmem;
      end else
      begin
        dec(posiy);
        if fits then
        begin
          inc(posiy);
          change(empty);
          dec(posiy);
          putmem;
        end else
        begin
          rotation:=lastrot;
          inc(posiy);
        end;
      end;
    end else
    if ch=tdemo then
    begin
      demo:=not demo;
      prtscore;
    end else
    if ch=tnext then
    begin
      snext:=not snext;
      if snext then drawnext else clrnext;
      prtscore;
    end else
    if ch=tsound then
    begin
      dsound:=not dsound;
      prtscore;
    end;
  end;
end;

procedure lines;
var
  x2,y2,x3,y3 : integer;
  how_many    : byte;
begin
  y2:=posiy;
  how_many:=0;
  repeat
    if thelines^[y2]=width then
    begin
      dec(cubes,width);
      inc(how_many);
      for y3:=y2+1 to height do
      begin
        thelines^[y3-1]:=thelines^[y3];
        thecube^[y3-1]:=thecube^[y3];
        for x3:=1 to width do disp(x3,y3-1);
      end;
      for x3:=1 to width do
      begin
        thecube^[height,x3]:=empty;
        disp(x3,height);
      end;
      thelines^[height]:=0;
      inc(score,15);
      inc(nlines);
      if (nlines div 10 > level) and (level<maxlevel) then inc(level);
      prtscore;
      if dsound then
      begin
        sound(400);
        wait(1);
        sound(600);
        wait(1);
        nosound;
      end;
    end else inc(y2);
  until y2>=posiy+4;
  if how_many=4 then
  begin
    inc(score,247);
    if dsound then
    begin
      sound(1200);
      wait(1);
      nosound;
    end;
  end;
end;

procedure update_lines;
var
  x,y,x2,y2:integer;
begin
  for x:=1 to 4 do for y:=1 to 4 do
  begin
    x2:=x+posix-1;
    y2:=y+posiy-1;
    if thecube^[y2,x2]=falling then inc(thelines^[y2]);
  end;
end;

function eval:longint;
{  thecube^ contains a tetris well which must be evaluated }
var
  x,y,k,pit,hole_to_fill,bdx:integer;
  value:longint;
  f:boolean;
begin
  value:=0;
  hole_to_fill:=-44;
  bdx:=-44;
  for x:=1 to width do
  begin
    y:=height;
    while (y>0) and ((thecube^[y,x]=empty) or (thelines^[y]=width)) do
      dec(y);
    f:=thecube^[y,x]=full;
    dec(y);
    while y>0 do
    begin
      if thecube^[y,x]=empty then
      begin
        dec(value,14);       { penalise holes }
        if f and (y>hole_to_fill) then
        begin
          hole_to_fill:=y;   { and determine hole_to_fill }
          bdx:=x;
        end;
      end else f:=f or (thecube^[y,x]=full);
      dec(y);
    end;
    y:=height;
    pit:=0;
    if (not snext) or (whichpiece=1) or (next<>1) then
    { if we are showing the next piece, it is +++++++, and the current  }
    { piece is different from ++++++, then skip looking for pits        }
    begin
      while (y>0) and (thecube^[y,x]=empty) and
        ((thecube^[y,x-1]=empty) or (thecube^[y,x+1]=empty)) do dec(y);
      while (y>0) and (thecube^[y,x]=empty) do
      begin
        dec(y);
        inc(pit);
      end;
      if pit>=2 then dec(value,5*(pit-1));
    end;
  end;
  for k:=1 to 4 do
    if (posix-1+thepiece^.shape[rotation,k,1]=bdx) and
       (thelines^[posiy-1+thepiece^.shape[rotation,k,2]]<>width)
    then dec(value,6);
  { give less points to the situation if the current piece comes over the }
  { hole_to_fill, unless these squares make a line                        }
  for y:=1 to height do if thelines^[y]=width then inc(value,15);
  { give points if lines are filled                                       }
  value:=value-3*posiy+2*(rotation and 1)+abs(posix-width div 2);
  { favour the pieces being dropped very low, in flat positions, and near }
  { the right or left edge                                                }
  if posiy>=height-6 then dec(value,10);
  { avoid putting the pieces very high }
  if ((whichpiece=4) and (rotation=2) and (thecube^[posiy+2,posix+3]=empty))
    or
     ((whichpiece=5) and (rotation=4) and (thecube^[posiy+2,posix+1]=empty))
    then dec(value,30);
  { penalise a silly move which the automatic player tended to do often   }
  eval:=value;
end;

procedure decide;
{ decide where the piece must go, and                          }
{ put all the keys that must be simulated in the "keys" string }
type
  entry = record
              px,rt,aaaa:integer;
              { posix, rotation, and number of times the piece must be
                moved sideways once it has falled (positive for right,
                negative for left }
          end;
var
  savecube:^tetris_well;
  savelines:^tlines;
  saverotation,saveposix,saveposiy,ppx:integer;
  values:array[0..(width+6)*4] of entry;
  { this will contain the x positions and rotations of all the possibilities
    which have so far had the maximum score
    (to pick one at random afterwards)       }
  aaa,i,c,d:integer;
  value,max:longint;
  posiys:array[-3..width+1,1..4] of integer;

begin
  { make copies of what must be saved, init the pointers }
  keys:='';
  for c:=-3 to width+1 do for d:=1 to 4 do posiys[c,d]:=-200;
  test:=true;
  savecube:=@thecube^;
  savelines:=@thelines^;
  thecube:=@testcube;
  thelines:=@testlines;
  thecube^:=savecube^;
  thelines^:=savelines^;
  saverotation:=rotation;
  saveposix:=posix;
  saveposiy:=posiy;

  max:=-200000000;
  i:=0;
  for posix:=-2 to width do for rotation:=1 to thepiece^.rotations do
  begin
    posiy:=height-3;
    if fits then
    begin
      repeat dec(posiy) until not fits;
      inc(posiy);
      posiys[posix,rotation]:=posiy;
    end;
  end;
  { remember for each x position at which level would the piece stop }
  for ppx:=-2 to width do for rotation:=1 to thepiece^.rotations do
  { for each of the positions }
  begin
    posix:=ppx;
    posiy:=posiys[posix,rotation];
    if posiy>-100 then
    begin
      thelines^:=savelines^;
      putmem;
      update_lines;
      value:=eval;   { put the piece and eval the resulting screen }
      change(empty);
      if value>max then
      begin
        i:=1;
        max:=value;
        values[0].rt:=rotation;   { if it was the best so far, put it }
        values[0].px:=posix;      { alone in the values array         }
        values[0].aaaa:=0;
      end else
      if value=max then
      begin
        values[i].rt:=rotation;   { if it was as good as the bes so far, }
        values[i].px:=posix;      { add it to the values array           }
        values[i].aaaa:=0;
        inc(i);
      end;
      if posiy<posiys[posix-1,rotation] then
      begin
        dec(posix);
        if fits then    { check if we can move it left after is has fallen }
        begin
          repeat dec(posix) until not fits;
          inc(posix);
          thelines^:=savelines^;
          putmem;
          update_lines;
          value:=eval;
          change(empty);
          if value>max then
          begin                  { if so record its score only if it was }
            i:=1;                { better than the best so far           }
            max:=value;
            values[0].rt:=rotation;
            values[0].px:=ppx;
            values[0].aaaa:=posix-ppx;
          end;
        end;
      end;
      posix:=ppx;
      if posiy<posiys[posix+1,rotation] then
      begin
        inc(posix);               { same thing for moving it right }
        if fits then
        begin
          repeat inc(posix) until not fits;
          dec(posix);
          thelines^:=savelines^;
          putmem;
          update_lines;
          value:=eval;
          change(empty);
          if value>max then
          begin
            i:=1;
            max:=value;
            values[0].rt:=rotation;
            values[0].px:=ppx;
            values[0].aaaa:=posix-ppx;
          end;
        end;
      end;
    end;
  end;
  if i<>0 then
  begin
    i:=random(i);                   { pick a winner }
    posix:=values[i].px;
    aaa:=values[i].aaaa;
    rotation:=values[i].rt;
    while (rotation-saverotation) mod thepiece^.rotations <> 0 do
    begin
      keys:=keys+rot;       { add "rot" to "keys" as many times as the }
      dec(rotation);        { piece must be rotated                    }
    end;
    if posix>saveposix then for c:=1 to posix-saveposix do keys:=keys+right;
    if posix<saveposix then for c:=1 to saveposix-posix do keys:=keys+left;
                            { add "right" or "left" to keys }
    if demo2 then keys:=keys+tdrop;   { drop the piece immediately if we }
                                      { are in fastest demo mode         }
    if aaa<>0 then                    { if we must move sideways         }
    begin
      if not demo2 then keys:=keys+tdrop; { then drop the piece }
      while aaa>0 do
      begin
        keys:=keys+right;                 { and move right      }
        dec(aaa);
      end;
      while aaa<0 do
      begin
        inc(aaa);
        keys:=keys+left;                  { or left             }
      end;
    end;
  end;
  thecube:=@savecube^;
  thelines:=@savelines^;
  rotation:=saverotation;      { restore saved pointers }
  posix:=saveposix;
  posiy:=saveposiy;
  test:=false;
end;

procedure game;
var
  ch:char;
  level0:integer;
  i:word;
begin
  level0:=level;
  repeat
    init;
    score:=0;
    keys:='';
    keys2:='';
    snext:=false;
    nlines:=0;
    cubes:=0;
    clrscr;
    show;
    prtscore;
    next:=random(nbpieces)+1;  { init everything, chose 1st piece }
    repeat
      stop_game:=false;
      rotation:=1;
      whichpiece:=next;
      next:=random(nbpieces)+1;
      if snext then drawnext;
      thepiece:=@pieces[whichpiece];
      if not demo2 then while keypressed do ch:=readkey;
      posiy:=height-2;
      posix:=4;
      fallen:=0;                 { init the piece that is going to fall }
      if demo then decide;       { call the automatic player if DEMO is ON }
      while fits and (not stop_game) do
      begin
        putmem;
        inc(fallen);
        if fallen>1 then keys2:=keys;  { activate the automatic player's }
                                       { keys after the piece has fallen }
                                       { one step                        }
        if demo2 and (not keypressed) then keyboard
        else
        if level<9 then
          for i:=1 to 10-level do
          begin
            dela:=memw[0:$46c];
            repeat keyboard until dela<>memw[0:$46c];
                                  { wait while polling kbd }
          end
        else
        begin
          keyboard;
          delay(hilevels[level]); { or do it just once for fast levels }
        end;
        change(empty);
        dec(posiy);               { bring the piece one step down }
      end;
      score:=score+10+2*level+(fallen div 4)+random(3);
      if snext then dec(score,7);
      prtscore;                    { show score }
      if (not stop_game) and (fallen>0) then
      begin
        inc(posiy);
        putmem;
        change(full);
        lines;                     { drop full lines }
      end;
      if (cubes=0) and not stop_game then
      begin
        inc(score,527);
        if dsound then
        begin
          sound(450);
          wait(1);
          sound(900);        { beep and give points if the Tetris well }
          wait(2);           { has been emptied                        }
          sound(1200);
          wait(3);
          nosound;
        end;
      end;
    until (fallen=0) or stop_game;
    if not stop_game then
    begin
      if dsound then
      begin
        wait(1);
        sound(250);
        wait(1);
        sound(150);
        wait(3);
        nosound;
      end;
      gameover;                       { GAME OVER  !!! }
      ch:=upcase(readkey);
      case ch of
        #0 :  ch:=readkey;       { wait for a key; if it is R, then Replay }
        #27:  quit;              { with the same level                     }
        'R':  level:=level0;
      end;
    end;
    if score>hiscore then hiscore:=score;
  until (ch<>'R') or stop_game;
end;

begin
  test:=false;
  dsound:=true;
  thecube:=@cube;
  thelines:=@llines;
  nlock:=(mem[0:$417] and $20)<>0;  { init some vars }
  normkeys;                         { init keys      }
  randseed:=memw[0:$46c];           { randomize      }
  while keypressed do if readkey=#0 then; { clear kbd buffer }
  savescr;                          { save text screen and cursor position }
  cursoff;
  hiscore:=0;
  repeat
    ask_level;
    game;
  until false;                      { loop forever }
end.
