unit trigraph;

interface

const xbase=200;
      ybase=420;
      tribitmap:array[0..14,0..13] of byte=
      ((1,0,0,0,0,0,0,0,0,0,0,0,0,0),
       (1,1,1,0,0,0,0,0,0,0,0,0,0,0),
       (1,2,2,1,1,0,0,0,0,0,0,0,0,0),
       (1,2,3,3,2,1,1,0,0,0,0,0,0,0),
       (1,2,3,4,4,3,2,1,1,0,0,0,0,0),
       (1,2,3,4,5,5,4,3,2,1,1,0,0,0),
       (1,2,3,4,5,6,6,5,4,3,2,1,1,0),
       (1,2,3,4,5,6,7,7,6,5,4,3,2,1),
       (1,2,3,4,5,6,6,5,4,3,2,1,1,0),
       (1,2,3,4,5,5,4,3,2,1,1,0,0,0),
       (1,2,3,4,4,3,2,1,1,0,0,0,0,0),
       (1,2,3,3,2,1,1,0,0,0,0,0,0,0),
       (1,2,2,1,1,0,0,0,0,0,0,0,0,0),
       (1,1,1,0,0,0,0,0,0,0,0,0,0,0),
       (1,0,0,0,0,0,0,0,0,0,0,0,0,0));

procedure triaff(x,y:shortint);
procedure tridel(x,y:shortint);
procedure initgraphics;

implementation

uses graphza;

procedure triaff(x,y:shortint);
var i,j,xo,yo:integer;
begin
xo:=xbase+x*14;yo:=ybase-y*8;
if odd(x+y) then
 begin
 if getpix(xo,yo)=0 then
  begin
  for j:=0 to 14 do
  for i:=0 to 13 do
  if tribitmap[j,i]<>0 then pix(i+xo,j+yo,tribitmap[j,i]);
  end;
 end
 else
  begin
  if getpix(xo+13,yo)=0 then
   begin
   for j:=0 to 14 do
   for i:=0 to 13 do
   if tribitmap[14-j,13-i]<>0 then pix(i+xo,j+yo,tribitmap[14-j,13-i]);
   end;
end;
end;

procedure tridel(x,y:shortint);
var i,j,xo,yo:integer;
begin
xo:=xbase+x*14;yo:=ybase-y*8;
if odd(x+y) then
 begin
 if getpix(xo,yo)<>0 then
  begin
  for j:=0 to 14 do
  for i:=0 to 13 do
  if tribitmap[j,i]<>0 then pix(i+xo,j+yo,0);
  end;
 end
 else
  begin
  if getpix(xo+13,yo)<>0 then
   begin
   for j:=0 to 14 do
   for i:=0 to 13 do
   if tribitmap[14-j,13-i]<>0 then pix(i+xo,j+yo,0);
   end;
end;
if not odd(x+y) then begin pix(xo+7,yo+8,1);pix(xo+7,yo+7,1) end;
end;

procedure initgraphics;
var i,j,xo,yo:integer;
begin
graphmode(18);
palrgb(0,60,60,60);
palrgb(1,0,0,0);
for i:=2 to 7 do
begin
pal(i,i);
palrgb(i,20+i*5,20+i*5,20+i*5);
end;
for i:=0 to 40 do
begin
triaff(0,i);
triaff(13,i);
end;
for i:=1 to 13 do
begin
triaff(i,0);
if i<>13 then
triaff(i,-1);
end;
for j:=1 to 20 do
for i:=1 to 12 do
begin
xo:=xbase+i*14;
yo:=ybase-j*16+(i and 1) shl 3;
pix(xo+7,yo+7,1);
pix(xo+7,yo+8,1);
end;


end;

begin
end.