DEFINT A-Z
OPTION BASE 0

TYPE LocationStr
 NameV  AS STRING * 50
 Plural AS INTEGER
 TypeV  AS INTEGER
 x      AS INTEGER
 y      AS INTEGER
END TYPE

TYPE RegistersStr
 ax    AS INTEGER
 bx    AS INTEGER
 cx    AS INTEGER
 dx    AS INTEGER
 ps    AS INTEGER
 si    AS INTEGER
 di    AS INTEGER
 flags AS INTEGER
END TYPE

DECLARE FUNCTION CorrectAnswer (Location, Count, Locations() AS LocationStr, MouseX, MouseY)
DECLARE FUNCTION DisplayError (Index)
DECLARE FUNCTION Extension$ (NewExtension$)
DECLARE FUNCTION GetErrorText$ (Index)
DECLARE FUNCTION GetMouseStatus (MouseX, MouseY)
DECLARE FUNCTION GetNumber (x, y, Prompt$, MaximumLength)
DECLARE FUNCTION GetText$ (Index)
DECLARE FUNCTION LoadLocations (AreaFile$, Locations() AS LocationStr)
DECLARE FUNCTION SelectLocation (Count, Locations() AS LocationStr)
DECLARE SUB AskQuit ()
DECLARE SUB Center (x, Text$, Padding)
DECLARE SUB DisplayImage (x, y, Image$, Mask$, ImageWidth, ImageHeight)
DECLARE SUB DisplayInformation ()
DECLARE SUB DisplayMenu ()
DECLARE SUB DisplayMistake (Locations() AS LocationStr, MouseX, MouseY, MarginX, MarginY)
DECLARE SUB DisplayTitle ()
DECLARE SUB DrawBox (y, Height, Text$, Padding)
DECLARE SUB DrawLegenda ()
DECLARE SUB DrawTextBox (x, y, Wdth, Height)
DECLARE SUB GetSize (Text$, Columns, Rows)
DECLARE SUB InitializeMouse ()
DECLARE SUB Interrupt (InterruptNr, RegistersIn AS RegistersStr, RegistersOut AS RegistersStr)
DECLARE SUB MakeButton (x, y, Wdth, Text$, Edged)
DECLARE SUB Practice (AreaFile$)
DECLARE SUB PressButton (MouseX, MouseY, ButtonWidth)
DECLARE SUB Quit ()
DECLARE SUB SelectLanguage ()
DECLARE SUB WaitForMouseClick ()
ON ERROR GOTO ErrorTrap1
Text$ = GetErrorText$(-1)
ON ERROR GOTO ErrorTrap2
SCREEN 12: WIDTH 80, 60: PALETTE 5, &H1E0000: COLOR 15: CLS
Text$ = GetText$(-1)
InitializeMouse
DisplayTitle
DisplayMenu
END

Areas:
DATA "Belgium",9,5
DATA "Germany",18,5
DATA "Europe*",27,5
DATA "France",36,5
DATA "Britain",45,5
DATA "Italy",9,55
DATA "Holland",18,55
DATA "Portugal",27,55
DATA "Spain",36,55
DATA "USA",45,55

ErrorTrap1:
SCREEN 0: CLS
PRINT " Topography 3, Error:"
PRINT
PRINT " File could not be found or is damaged."
PRINT
PRINT " If the file TOPO3.SET is missing,"
PRINT " look in the Data subdirectory in the"
PRINT " directory where Topography 3 is located "
PRINT " and check which extension(s) the files"
PRINT " have and select an extension, then type"
PRINT " "; CHR$(34); "TOPO3.EXE extension"; CHR$(34); " in Topography 3's"
PRINT " main directory. For example: Topo3 Eng."
PRINT
PRINT " Press any key to quit."
Key$ = INPUT$(1)
Quit

ErrorTrap2:
ErrorCode = ERR
SELECT CASE ErrorCode
 CASE 5
  Choice = DisplayError(1)
 CASE 7, 14
  Choice = DisplayError(3)
 CASE 9
  Choice = DisplayError(4)
 CASE 52, 62
  Choice = DisplayError(5)
 CASE 53
  Choice = DisplayError(6)
 CASE 55
  Choice = DisplayError(7)
 CASE 61
  Choice = DisplayError(8)
 CASE 70
  Choice = DisplayError(9)
 CASE 71
  Choice = DisplayError(10)
 CASE 72
  Choice = DisplayError(11)
 CASE 75, 76
  Choice = DisplayError(12)
 CASE ELSE
  Choice = DisplayError(13)
END SELECT
SELECT CASE Choice
 CASE 1: RESUME
 CASE 2: RESUME NEXT
 CASE 3: Quit
END SELECT

SUB AskQuit
DIM RegistersIn AS RegistersStr, RegistersOut AS RegistersStr

DrawBox 15, 45, GetText$(27), 0
MakeButton 18, 30, 6, GetText$(28), -1
MakeButton 18, 44, 6, GetText$(29), -1

DO
 DO
 LOOP UNTIL GetMouseStatus(MouseX, MouseY) = 1
 MouseX = INT(MouseX / 8) + 1
 MouseY = INT(MouseY / 8) + 1
 IF MouseX > 29 AND MouseX < 36 AND MouseY = 18 THEN
  PressButton 30, 18, 7
  Quit
 ELSEIF MouseX > 43 AND MouseX < 51 AND MouseY = 18 THEN
  PressButton 44, 18, 7
  EXIT DO
 END IF
LOOP

RegistersIn.ax = &H2: Interrupt &H33, RegistersIn, RegistersOut
DrawBox -1, 0, "", 0
RegistersIn.ax = &H1: Interrupt &H33, RegistersIn, RegistersOut
END SUB

SUB Center (x, Text$, Padding)
IF NOT RIGHT$(Text$, 1) = CHR$(13) THEN Text$ = Text$ + CHR$(13)
IF x > 0 THEN LOCATE x

DO
 Index = INSTR(Text$, CHR$(13))
 IF Index = 0 THEN EXIT DO
 Fragment$ = LEFT$(Text$, Index - 1)
 IF Padding > LEN(Fragment$) THEN Fragment$ = Fragment$ + SPACE$(Padding - LEN(Fragment$))
 LOCATE , INT(40 - (LEN(Fragment$) / 2))
 PRINT Fragment$
 Text$ = MID$(Text$, Index + 1)
LOOP
END SUB

FUNCTION CorrectAnswer (Location, Count, Locations() AS LocationStr, MouseX, MouseY)
DIM Background(&H130), RegistersIn AS RegistersStr, RegistersOut AS RegistersStr

SELECT CASE Locations(Location).TypeV
 CASE 1, 3, 4
  MarginX = 5: MarginY = 5
 CASE 2
  MarginX = 15: MarginY = 10
 CASE 5
  MarginX = 15: MarginY = 13
END SELECT

IsCorrect = 0
IF MouseX >= Locations(Location).x - MarginX AND MouseX <= Locations(Location).x + MarginX AND MouseY >= Locations(Location).y - MarginY AND MouseY <= Locations(Location).y + MarginY THEN
 IsCorrect = -1
ELSE
 RegistersIn.ax = &H2: Interrupt &H33, RegistersIn, RegistersOut
 SOUND 37, 5
 DisplayMistake Locations(), MouseX, MouseY, MarginX, MarginY
 LOCATE 2, 2: PRINT SPACE$(78): LOCATE 2, 3
 IF NOT Locations(Location).Plural THEN
  PRINT GetText$(20); RTRIM$(Locations(Location).NameV); GetText$(22);
 ELSEIF Locations(Location).Plural THEN
  PRINT GetText$(21); RTRIM$(Locations(Location).NameV); GetText$(23);
 END IF
 PRINT GetText$(24);
 GET (Locations(Location).x - MarginX - 1, Locations(Location).y - MarginY - 1)-STEP((MarginX + 1) * 2, (MarginY + 1) * 2), Background
 LINE (Locations(Location).x - MarginX, Locations(Location).y - MarginY)-STEP(MarginX * 2, MarginY * 2), 0, B
 LINE (Locations(Location).x - MarginX - 1, Locations(Location).y - MarginY - 1)-STEP((MarginX + 1) * 2, (MarginY + 1) * 2), 0, B
 WaitForMouseClick
 PUT (Locations(Location).x - MarginX - 1, Locations(Location).y - MarginY - 1), Background, PSET
 RegistersIn.ax = &H1: Interrupt &H33, RegistersIn, RegistersOut
END IF

CorrectAnswer = IsCorrect
END FUNCTION

FUNCTION DisplayError (Index)
DIM ErrorBackground(&H7FFF)
GetSize GetErrorText$(Index), Columns, Rows

IF Index = 1 THEN
 SCREEN 0: WIDTH 80, 25: PALETTE
 PALETTE 2, &H3F: COLOR 0, 1: CLS
 COLOR , 2
 DrawTextBox 4, INT(40 - (Columns / 2)) - 1, Columns, Rows
 Center 5, GetErrorText$(Index), Columns
 Key$ = INPUT$(1)
 Choice$ = "3"
ELSE
 GET (125, 20)-STEP(365, 185), ErrorBackground
 COLOR 15
 DrawBox 4, -1, GetErrorText$(Index), Columns
 COLOR 7: Center 10, GetErrorText$(0), 0
 DO
  Choice$ = INPUT$(1)
 LOOP WHILE INSTR("123", Choice$) = 0
 PUT (125, 20), ErrorBackground, PSET
END IF

DisplayError = VAL(Choice$)
END FUNCTION

SUB DisplayImage (x, y, Image$, Mask$, ImageWidth, ImageHeight)
DIM Image(&H7FF0)

DEF SEG = VARSEG(Image(0))
IF Mask$ = "" THEN
 BLOAD ".\Images\" + Image$, VARPTR(Image(0))
 PUT (x, y), Image, PSET
ELSE
 BLOAD ".\Images\" + Mask$, VARPTR(Image(0))
 PUT (x, y), Image, AND
 BLOAD ".\Images\" + Image$, VARPTR(Image(0))
 PUT (x, y), Image, XOR
END IF

ImageWidth = Image(0)
ImageHeight = Image(1)
END SUB

SUB DisplayInformation
DIM RegistersIn AS RegistersStr, RegistersOut AS RegistersStr

Text$ = ""
FOR Index = 30 TO 32
 Text$ = Text$ + GetText$(Index) + CHR$(13)
NEXT Index
DrawBox 9, 40, Text$, 0

WaitForMouseClick
RegistersIn.ax = &H2: Interrupt &H33, RegistersIn, RegistersOut
DrawBox -1, 0, "", 0
RegistersIn.ax = &H1: Interrupt &H33, RegistersIn, RegistersOut
END SUB

SUB DisplayMenu
DIM RegistersIn AS RegistersStr, RegistersOut AS RegistersStr

DO
 CLS
 LINE (0, 0)-(639, 479), 5, BF
 COLOR 15
 RESTORE Areas
 OPEN ".\Data\Areas." + Extension$("") FOR INPUT LOCK READ WRITE AS 1
  FOR Index = 0 TO 9
   READ AreaFile$, x, y
   IF RIGHT$(AreaFile$, 1) = "*" THEN AreaFile$ = LEFT$(AreaFile$, LEN(AreaFile$) - 1)
   DisplayImage ((y * 8) + 45), ((x * 8) - 60), AreaFile$ + ".flg", "", 0, 0
   LINE INPUT #1, Text$
   MakeButton x, y, 21, Text$, 0
  NEXT Index
 CLOSE 1
 
 MakeButton 49, 5, 10, GetText$(0), 0
 MakeButton 52, 5, 14, GetText$(1), 0
 MakeButton 49, 55, 8, GetText$(2), 0

 RegistersIn.ax = &H1: Interrupt &H33, RegistersIn, RegistersOut
 DO
  DO
  LOOP UNTIL GetMouseStatus(MouseX, MouseY) = 1
  MouseX = INT(MouseX / 8) + 1
  MouseY = INT(MouseY / 8) + 1
  IF MouseX > 4 AND MouseX < 16 AND MouseY = 49 THEN
   PressButton 5, 49, 11
   SelectLanguage
   EXIT DO
  ELSEIF MouseX > 54 AND MouseX < 64 AND MouseY = 49 THEN
   PressButton 55, 49, 9
   AskQuit
  ELSEIF MouseX > 4 AND MouseX < 19 AND MouseY = 52 THEN
   PressButton 5, 52, 15
   DisplayInformation
  ELSE
   RESTORE Areas
   FOR Index = 0 TO 9
    READ AreaFile$, x, y
    IF MouseX >= y AND MouseX <= y + 21 AND MouseY = x THEN
     PressButton y, x, 22
     Practice AreaFile$
     EXIT DO
    END IF
   NEXT Index
  END IF
 LOOP
LOOP
END SUB

SUB DisplayMistake (Locations() AS LocationStr, MouseX, MouseY, MarginX, MarginY)
LocationFound = 0
FOR Location = 0 TO 99
 IF Locations(Location).NameV = "" THEN EXIT FOR
 IF MouseX >= Locations(Location).x - MarginX AND MouseX <= Locations(Location).x + MarginX THEN
  IF MouseY >= Locations(Location).y - MarginY AND MouseY <= Locations(Location).y + MarginY THEN
   LocationFound = -1
   EXIT FOR
  END IF
 END IF
NEXT Location

LOCATE 2, 2: PRINT SPACE$(78)
IF LocationFound THEN
 LOCATE 2, 3
 IF NOT Locations(Location).Plural THEN
  PRINT GetText$(17); RTRIM$(Locations(Location).NameV); GetText$(22);
 ELSEIF Locations(Location).Plural THEN
  PRINT GetText$(18); RTRIM$(Locations(Location).NameV); GetText$(23);
 END IF
ELSE
 LOCATE 2, 3: PRINT GetText$(19);
END IF
PRINT GetText$(24);

WaitForMouseClick
LOCATE 2, 2: PRINT SPACE$(78)
END SUB

SUB DisplayTitle
DIM Map1(&H6400), Map2(&H1D0)

Data$ = ""
OPEN "Title." + Extension$("") FOR INPUT LOCK READ WRITE AS 1
 DO UNTIL EOF(1)
  LINE INPUT #1, NewData$
  Data$ = Data$ + NewData$
 LOOP
CLOSE 1

CLS : COLOR 15: LOCATE 1
FOR y = 0 TO 11
 FOR x = 0 TO 79
  LINE (x * 8, y * 4)-STEP(7, 3), VAL("&H" + MID$(Data$, ((y * 80) + x) + 1, 1)), BF
 NEXT x
NEXT y

COLOR 7: Center 38, GetText$(34), 0

DisplayImage 95, 60, "World.map", "", 0, 0
DO
 GET (95, 60)-STEP(445, 225), Map1
 GET (541, 60)-STEP(2, 225), Map2
 PUT (95, 60), Map2, PSET
 PUT (98, 60), Map1, PSET
LOOP WHILE INKEY$ = ""
END SUB

SUB DrawBox (y, Height, Text$, Padding)
DIM Box(&H7FFF)
STATIC Background(), BoxX, BoxY

IF y = -1 THEN
 PUT (BoxX, BoxY), Background, PSET
 EXIT SUB
ELSE
 REDIM Background(&H7FFF)
END IF

GetSize Text$, Columns, Rows

Columns = ((Columns + 1) * 8) + 8
x = CINT(312 - (Columns / 2))
y = (y - 1) * 8
IF Height = -1 THEN Height = (Rows + 2) * 8
GET (x, y)-STEP(Columns + 10, Height + 2), Background
LINE (x + 2, y + 2)-STEP(Columns, Height), 8, BF
LINE (x, y)-STEP(Columns, Height), 0, BF
LINE (x + 1, y + 1)-STEP(Columns - 2, Height - 2), 15, B
Center ((y / 8) + 2), Text$, Padding
GET (x, y)-STEP(Columns, Height), Box
PUT (x, y), Box, PRESET

BoxX = x
BoxY = y
END SUB

SUB DrawLegenda
DIM Legenda(&H1400)

LINE (465, 80)-STEP(167, 120), 8, BF
LINE (467, 82)-STEP(167, 120), 8, BF
LINE (466, 81)-STEP(165, 118), 15, B
LOCATE 12, 65: PRINT GetText$(5)
PRINT
FOR Index = 6 TO 10
 LOCATE , 66: PRINT GetText$(Index)
 PRINT
NEXT Index
GET (465, 80)-STEP(167, 120), Legenda
PUT (465, 80), Legenda, PRESET
LINE (485, 106)-STEP(10, 5), 4, BF
CIRCLE (490, 124), 3, 4: PAINT (490, 124), 4
CIRCLE (490, 140), 3, 1: PAINT (490, 140), 1

DisplayImage 480, 152, "Mountain.img", "Mountain.msk", 0, 0
DisplayImage 480, 168, "Volcano.img", "Volcano.msk", 0, 0
END SUB

SUB DrawTextBox (x, y, Wdth, Height)
LOCATE x, y: PRINT CHR$(218); STRING$(Wdth, 196); CHR$(191)
FOR Row = 1 TO Height
 LOCATE , y: PRINT CHR$(179);
 LOCATE , y + Wdth + 1: PRINT CHR$(179)
NEXT Row
LOCATE , y: PRINT CHR$(192); STRING$(Wdth, 196); CHR$(217);
END SUB

FUNCTION Extension$ (NewExtension$)
STATIC CurrentExtension$

IF CurrentExtension$ = "" THEN
 IF COMMAND$ = "" THEN
  OPEN "Topo3.set" FOR INPUT LOCK READ WRITE AS 1
   LINE INPUT #1, CurrentExtension$
  CLOSE 1
 ELSE
  NewExtension$ = COMMAND$
 END IF
END IF

IF NOT NewExtension$ = "" THEN
 OPEN "Topo3.set" FOR OUTPUT LOCK READ WRITE AS 1
  PRINT #1, NewExtension$;
 CLOSE 1
 CurrentExtension$ = NewExtension$
END IF

Extension$ = CurrentExtension$
END FUNCTION

FUNCTION GetErrorText$ (Index)
STATIC ErrorText$(), Loaded

IF Index = -1 THEN
 Index = 0
 Loaded = 0
END IF

IF NOT Loaded THEN
 REDIM ErrorText$(13)
 Index = 0
 Loaded = -1
 OPEN "Errors." + Extension$("") FOR INPUT LOCK READ WRITE AS 1
  DO UNTIL EOF(1)
   LINE INPUT #1, Data$
    IF RTRIM$(Data$) = "-" THEN
    Index = Index + 1
   ELSE
    IF NOT ErrorText$(Index) = "" THEN Data$ = CHR$(13) + Data$
    ErrorText$(Index) = ErrorText$(Index) + Data$
   END IF
  LOOP
 CLOSE 1
END IF

GetErrorText$ = ErrorText$(Index)
END FUNCTION

FUNCTION GetMouseStatus (MouseX, MouseY)
DIM RegistersIn AS RegistersStr, RegistersOut AS RegistersStr
IF INKEY$ = CHR$(27) THEN Quit
RegistersIn.ax = &H3: Interrupt &H33, RegistersIn, RegistersOut
MouseX = RegistersOut.cx: MouseY = RegistersOut.dx
GetMouseStatus = RegistersOut.bx
END FUNCTION

FUNCTION GetNumber (x, y, Prompt$, MaximumLength)
DIM Background(&H600)

GET (0, (x - 1) * 8)-STEP(639, 8), Background
Number$ = ""
LOCATE x, y: PRINT SPACE$(LEN(Prompt$) + 4)
DO
 LOCATE x, y: PRINT Prompt$; Number$; "_ "
 DO
  Key$ = INKEY$
 LOOP WHILE Key$ = ""
 Length = LEN(Number$)
 SELECT CASE ASC(Key$)
  CASE 8
   IF Length > 0 THEN Number$ = LEFT$(Number$, Length - 1)
  CASE 13
   EXIT DO
  CASE 27
   Number$ = "": EXIT DO
  CASE 48 TO 57
   IF Length < MaximumLength THEN Number$ = Number$ + Key$
 END SELECT
LOOP
PUT (0, (x - 1) * 8), Background, PSET
GetNumber = VAL(Number$)
END FUNCTION

SUB GetSize (Text$, Columns, Rows)
Columns = 0
Index = 0
Rows = 0
Widest = 0
DO UNTIL Index >= LEN(Text$)
 PreviousIndex = Index
 Index = INSTR(PreviousIndex + 1, Text$, CHR$(13))
 IF Index = 0 THEN Index = LEN(Text$) + 1
 IF Index - PreviousIndex > Widest THEN Widest = Index - PreviousIndex
 Rows = Rows + 1
LOOP
IF Widest = 0 THEN Columns = LEN(Text$) ELSE Columns = Widest - 1
END SUB

FUNCTION GetText$ (Index)
STATIC Loaded, Text$()

IF Index = -1 THEN
 Index = 0
 Loaded = 0
END IF

IF NOT Loaded THEN
 REDIM Text$(34)
 CurrentIndex = 0
 Loaded = -1
 OPEN ".\Data\Text." + Extension$("") FOR INPUT LOCK READ WRITE AS 1
  DO UNTIL EOF(1)
   LINE INPUT #1, Text$(CurrentIndex)
   CurrentIndex = CurrentIndex + 1
  LOOP
 CLOSE 1
END IF

GetText$ = Text$(Index)
END FUNCTION

SUB InitializeMouse
DIM RegistersIn AS RegistersStr, RegistersOut AS RegistersStr

DO
 RegistersIn.ax = &H0: Interrupt &H33, RegistersIn, RegistersOut
 IF RegistersOut.ax = &H0 THEN
  Choice = DisplayError(2)
  IF NOT Choice = 1 THEN
   IF Choice = 2 THEN EXIT DO
   IF Choice = 3 THEN Quit
  END IF
 ELSE
  EXIT DO
 END IF
LOOP

RegistersIn.ax = &H7
RegistersIn.cx = 0
RegistersIn.dx = 639
Interrupt &H33, RegistersIn, RegistersOut
RegistersIn.ax = &H8
RegistersIn.cx = 0
RegistersIn.dx = 479
Interrupt &H33, RegistersIn, RegistersOut
END SUB

FUNCTION LoadLocations (AreaFile$, Locations() AS LocationStr)
REDIM Locations(99) AS LocationStr

Count = 0
OPEN ".\Data\" + AreaFile$ + "." + Extension$("") FOR INPUT LOCK READ WRITE AS 1
 DO UNTIL EOF(1)
  LINE INPUT #1, Locations(Count).NameV
  IF RTRIM$(Locations(Count).NameV) = "" THEN EXIT DO
  Count = Count + 1
 LOOP
CLOSE 1

OPEN ".\Data\Locatns.dat" FOR INPUT LOCK READ WRITE AS 1
 DO UNTIL EOF(1)
  LINE INPUT #1, Data$
  IF LTRIM$(RTRIM$(LCASE$(Data$))) = LCASE$(AreaFile$) THEN EXIT DO
 LOOP

 FOR Location = 0 TO Count - 1
  INPUT #1, Locations(Location).x
  INPUT #1, Locations(Location).y
  INPUT #1, Locations(Location).TypeV
  INPUT #1, Locations(Location).Plural

  Locations(Location).x = Locations(Location).x + 10
  Locations(Location).y = Locations(Location).y + 20

  SELECT CASE Locations(Location).TypeV
   CASE 1
    DisplayImage Locations(Location).x - 14, Locations(Location).y - 7, "Mountain.img", "Mountain.msk", 0, 0
   CASE 2
    LINE (Locations(Location).x - 5, Locations(Location).y - 2)-STEP(10, 5), 4, BF
   CASE 3
    CIRCLE (Locations(Location).x, Locations(Location).y), 3, 1
    PAINT (Locations(Location).x, Locations(Location).y), 1
   CASE 4
    CIRCLE (Locations(Location).x, Locations(Location).y), 3, 4
    PAINT (Locations(Location).x, Locations(Location).y), 4
   CASE 5
    DisplayImage Locations(Location).x - 14, Locations(Location).y - 7, "Volcano.img", "Volcano.msk", 0, 0
  END SELECT
 NEXT Location
CLOSE 1

LoadLocations = Count
END FUNCTION

SUB MakeButton (x, y, Wdth, Text$, Edged)
DIM Button(&H600)

Text$ = " " + Text$
LOCATE x, y: PRINT Text$; SPACE$(Wdth - LEN(Text$));

Wdth = Wdth * 8
SWAP y, x
x = (x - 1) * 8
y = (y - 1) * 8

GET (x, y)-STEP(Wdth - 1, 7), Button
LINE (x, y)-STEP(Wdth, 8), 0, BF
DRAW "C8 BM" + STR$(x + 2) + "," + STR$(y + 9) + " R" + STR$(Wdth - 1) + "U7 R1 D8 L" + STR$(Wdth)
PUT (x, y), Button, PRESET
IF Edged THEN DRAW "C0 BM" + STR$(x - 1) + "," + STR$(y - 1) + " D8 U8 R" + STR$(Wdth)
END SUB

SUB Practice (AreaFile$)
DIM Locations(99) AS LocationStr, RegistersIn AS RegistersStr, RegistersOut AS RegistersStr

RANDOMIZE TIMER
Right = 0: Wrong = 0
RegistersIn.ax = &H2: Interrupt &H33, RegistersIn, RegistersOut

CLS
LINE (0, 0)-(639, 479), 5, BF
COLOR 15
Turns = GetNumber(5, 5, GetText$(3), 2)
IF Turns = 0 THEN EXIT SUB

CLS
LINE (0, 0)-(639, 479), 5, BF

IF RIGHT$(AreaFile$, 1) = "*" THEN
 AreaFile$ = LEFT$(AreaFile$, LEN(AreaFile$) - 1)
 DisplayImage 10, 20, AreaFile$ + ".map", "", MapWidth, MapHeight
 DisplayImage 10, 20 + MapHeight, AreaFile$ + ".ext", "", MapWidth, AddedHeight
 MapHeight = MapHeight + AddedHeight
ELSE
 DisplayImage 10, 20, AreaFile$ + ".map", "", MapWidth, MapHeight
END IF

Count = LoadLocations(AreaFile$, Locations())

MakeButton 47, 60, 8, GetText$(4), 0
LOCATE 4, 65: PRINT GetText$(11)
LOCATE 6, 64: PRINT GetText$(12)
LOCATE 8, 58: PRINT GetText$(13)

DrawLegenda
Location = SelectLocation(Count, Locations())
RegistersIn.ax = &H1: Interrupt &H33, RegistersIn, RegistersOut
DO UNTIL Turns = 0
 LOCATE 4, 73: PRINT USING "###"; Right
 LOCATE 6, 73: PRINT USING "###"; Wrong
 LOCATE 8, 73: PRINT USING "###"; Turns
 DO
 LOOP UNTIL GetMouseStatus(MouseX, MouseY) = 1
 IF MouseX > 10 AND MouseY > 20 AND MouseX < MapWidth + 10 AND MouseY < MapHeight + 20 THEN
  DO: LOOP UNTIL GetMouseStatus(MouseX, MouseY) = 0
  IF CorrectAnswer(Location, Count, Locations(), MouseX, MouseY) THEN
   Right = Right + 1
  ELSE
   Wrong = Wrong + 1
  END IF
  Location = SelectLocation(Count, Locations())
  IF Turns > 0 THEN Turns = Turns - 1
 ELSE
  MouseX = INT(MouseX / 8) + 1
  MouseY = INT(MouseY / 8) + 1
  IF MouseX > 59 AND MouseX < 69 AND MouseY = 47 THEN
   PressButton 60, 47, 9
   EXIT DO
  END IF
 END IF
LOOP
LOCATE 2, 2: PRINT SPACE$(78)
LOCATE 2, 2: PRINT GetText$(25)
WaitForMouseClick
RegistersIn.ax = &H2: Interrupt &H33, RegistersIn, RegistersOut
END SUB

SUB PressButton (MouseX, MouseY, ButtonWidth)
DIM Pressed(&H600), RegistersIn AS RegistersStr, RegistersOut AS RegistersStr, Unpressed(&H600)

RegistersIn.ax = &H2: Interrupt &H33, RegistersIn, RegistersOut
x = (MouseX - 1) * 8
y = (MouseY - 1) * 8
ButtonWidth = (ButtonWidth - 1) * 8
GET (x, y)-STEP(ButtonWidth, 8), Pressed
GET (x, y)-STEP(ButtonWidth + 2, 10), Unpressed
LINE (x, y)-STEP(ButtonWidth, 8), 0, BF
PUT (x + 2, y + 2), Pressed, PSET
DO
 RegistersIn.ax = &H3: Interrupt &H33, RegistersIn, RegistersOut
LOOP UNTIL RegistersOut.bx = &H0
PUT (x, y), Unpressed, PSET
RegistersIn.ax = &H1: Interrupt &H33, RegistersIn, RegistersOut
END SUB

SUB Quit
SCREEN 0: WIDTH 80, 25
PALETTE: COLOR 7, 0: CLS
SYSTEM
END SUB

SUB SelectLanguage
DIM Cursor(&H180), Extensions$(9), RegistersIn AS RegistersStr, RegistersOut AS RegistersStr

RegistersIn.ax = &H2: Interrupt &H33, RegistersIn, RegistersOut

Text$ = GetText$(26)
OPEN "Lnguages.dat" FOR INPUT LOCK READ WRITE AS 1
 FOR Index = 0 TO 9
  IF EOF(1) THEN EXIT FOR
  INPUT #1, Language$, Extensions$(Index)
  Text$ = Text$ + CHR$(13) + Language$ + SPACE$(18 - LEN(Language$))
 NEXT Index
CLOSE 1
     
DrawBox 9, 100, Text$, 0
Index = 0
DO
 y = (Index + 10) * 8
 GET (232, y)-STEP(160, 8), Cursor
 PUT (232, y), Cursor, PRESET
 DO
  Key$ = INKEY$
 LOOP WHILE Key$ = ""
 PUT (232, y), Cursor, PSET
 SELECT CASE Key$
  CASE CHR$(0) + "H"
   IF Index = 0 THEN Index = 9 ELSE Index = Index - 1
  CASE CHR$(0) + "P"
   IF Index = 9 THEN Index = 0 ELSE Index = Index + 1
  CASE CHR$(13)
   IF NOT Extensions$(Index) = "" THEN
    Text$ = Extension$(Extensions$(Index))
    Text$ = GetErrorText$(-1)
    Text$ = GetText$(-1)
    EXIT DO
   END IF
  CASE CHR$(27)
   CLOSE 1
   DrawBox -1, 0, "", 0
   EXIT DO
 END SELECT
LOOP
RegistersIn.ax = &H1: Interrupt &H33, RegistersIn, RegistersOut
END SUB

FUNCTION SelectLocation (Count, Locations() AS LocationStr)
STATIC LastLocation

DO
 Location = INT(RND * Count)
 IF Count < 2 THEN EXIT DO
LOOP WHILE Location = LastLocation
LastLocation = Location

LOCATE 2, 2: PRINT SPACE$(78)
LOCATE 2, 3: PRINT GetText$(14); RTRIM$(Locations(Location).NameV);

IF NOT Locations(Location).Plural THEN
 PRINT GetText$(15);
ELSEIF Locations(Location).Plural THEN
 PRINT GetText$(16);
END IF

SelectLocation = Location
END FUNCTION

SUB WaitForMouseClick
DO: LOOP UNTIL GetMouseStatus(MouseX, MouseY) = 0
DO: LOOP UNTIL GetMouseStatus(MouseX, MouseY) = 1
DO: LOOP UNTIL GetMouseStatus(MouseX, MouseY) = 0
END SUB

