' Note:
'  If you know the right moves, you can erase a trashcan.
'  You have to play level eight twice.
'
DEFINT A-Z                                            ' declares subs,
DECLARE SUB font (file$, xcol, ycol, colr, text$)     ' functions,
DECLARE SUB gifload (a$)                              ' variables, constants
DECLARE SUB youlose ()                                '
DECLARE SUB youwin ()                                 '
DECLARE SUB bomb (x, y)                               '
DECLARE SUB prompt ()                                 '
DECLARE SUB total ()                                  '
DECLARE SUB setpal ()                                 '
DECLARE SUB movebroom (way, direc)                    '
DECLARE SUB broom (x, y, face)                        '
DECLARE SUB broccoli (x, y)                           '
DECLARE SUB tomato (x, y)                             '
DECLARE SUB carrot (x, y)                             '
DECLARE SUB banana (x, y)                             '
DECLARE SUB apple (x, y)                              '
DECLARE SUB paper (x, y)                              '
DECLARE SUB popcan (x, y)                             '
DECLARE SUB sock (x, y)                               '
DECLARE SUB gamescrn ()                               '
DECLARE SUB intro ()                                  '
DECLARE SUB delay (spd#)                              '
DECLARE SUB fallcan (x, y, spd#)                      '
DECLARE SUB can (x, y)                                '
DECLARE SUB colcan (col)                              '
DECLARE SUB flash (col1, col2, tim)                   '
DECLARE SUB alberto ()                                '
DECLARE FUNCTION rand0 (max)                          '
DECLARE FUNCTION rand1 (max)                          '
DIM SHARED fontstr$(255)                              '
DIM SHARED occupied(20, 20)                           '
DIM SHARED length AS INTEGER                          '
DIM SHARED cool AS INTEGER                            '
DIM SHARED sptime AS INTEGER                          '
DIM SHARED seconds AS LONG                            '
DIM SHARED broomx AS INTEGER                          '
DIM SHARED broomy AS INTEGER                          '
DIM SHARED broomdir AS INTEGER                        '
DIM SHARED won AS INTEGER                             '
DIM SHARED level AS INTEGER                           '
DIM SHARED albub AS INTEGER                           '
DIM SHARED score AS INTEGER                           '
CONST TRUE = 1                                        '
CONST FALSE = NOT TRUE                                '
SCREEN 13                                   ' screen mode   
CLS                                         '
CHDIR "."      ' change to directory containing files
RANDOMIZE TIMER                          ' sets random number seed

ON KEY(8) GOSUB exitgame      ' sets F8 to `quit`

intro         ' goto intro screen

start:
prompt        ' do the text at the beginning

KEY(8) ON          ' triggers F8
score = 0          ' sets score to 0

FOR level = 1 TO 8        ' for...next loop of the levels
FOR dg1 = 0 TO 19                        ' clears the screen contents
FOR dg2 = 0 TO 19                        ' array for new level
occupied(dg1, dg2) = FALSE               '
NEXT dg2                                 '
NEXT dg1                                 '
albub = FALSE                      ' you are not on the 2nd level 8 variable
gamescrn                         ' draws the game screen
GOTO dum                             ' handles the
bub: albub = TRUE                    ' two level 8's
dum:                                 '
colcan 7                           ' sets the trashcan color to white

setpal                            ' sets the whole color palette

font "trashfnt.fnt", 1, 1, 15, "LEVEL" + STR$(level)           ' does screen
font "trashfnt.fnt", 220, 1, 15, "SCORE" + STR$(score)         ' text
font "trashfnt.fnt", 110, 1, 15, "TIMER"                       '

IF albub = FALSE THEN broomx = 0                            ' sets the broom
IF albub = FALSE THEN broomy = 26                           ' coordinates
IF albub = FALSE THEN broomdir = 1                          ' and direction

FOR vardud = 1 TO 2

1 : posx = rand0(15)    ' draws the broccoli
posy = rand0(4): IF occupied(posx, posy) = TRUE THEN GOTO 1:  ELSE occupied(posx, posy) = TRUE
broccoli posx * 17 + 19, posy * 25 + 27

IF level > 1 THEN
3 : posx = rand0(15)    ' draws the tomatoes
posy = rand0(4): IF occupied(posx, posy) = TRUE THEN GOTO 3:  ELSE occupied(posx, posy) = TRUE
tomato posx * 17 + 19, posy * 25 + 27
END IF

IF level > 2 THEN
5 : posx = rand0(15)   ' draws the carrots
posy = rand0(4): IF occupied(posx, posy) = TRUE THEN GOTO 5:  ELSE occupied(posx, posy) = TRUE
carrot posx * 17 + 19, posy * 25 + 27
END IF

IF level > 3 THEN
7 : posx = rand0(15)   ' draws the bananas
posy = rand0(4): IF occupied(posx, posy) = TRUE THEN GOTO 7:  ELSE occupied(posx, posy) = TRUE
banana posx * 17 + 19, posy * 25 + 27
END IF

IF level > 4 THEN
9 : posx = rand0(15)   ' draws the apples
posy = rand0(4): IF occupied(posx, posy) = TRUE THEN GOTO 9:  ELSE occupied(posx, posy) = TRUE
apple posx * 17 + 19, posy * 25 + 27
END IF

IF level > 5 THEN
11 : posx = rand0(15)  ' draws the crumpled papers
posy = rand0(4): IF occupied(posx, posy) = TRUE THEN GOTO 11:  ELSE occupied(posx, posy) = TRUE
paper posx * 17 + 19, posy * 25 + 27
END IF

IF level > 6 THEN
13 : posx = rand0(15)  ' draws the crushed pop cans
posy = rand0(4): IF occupied(posx, posy) = TRUE THEN GOTO 13:  ELSE occupied(posx, posy) = TRUE
popcan posx * 17 + 19, posy * 25 + 27
END IF

IF level > 7 THEN
15 : posx = rand0(15)  ' draws the socks
posy = rand0(4): IF occupied(posx, posy) = TRUE THEN GOTO 15:  ELSE occupied(posx, posy) = TRUE
sock posx * 17 + 19, posy * 25 + 27
END IF

NEXT vardud

IF albub = FALSE THEN
17 : posx = rand0(15)  ' draws the bomb
posy = rand0(4): IF occupied(posx, posy) = TRUE THEN GOTO 17:  ELSE occupied(posx, posy) = TRUE
bomb posx * 17 + 19, posy * 25 + 27
END IF

SELECT CASE level                  ' sets the amount of time
CASE 1                             ' on each level
length = 12                        '
CASE 2                             '
length = 14                        '
CASE 3                             '
length = 17                        '
CASE 4                             '
length = 20                        '
CASE 5                             '
length = 22                        '
CASE 6                             '
length = 23                        '
CASE 7                             '
length = 26                        '
CASE 8                             '
length = 28                        '
END SELECT                         '
length = length + (sptime * 2)     '

seconds = INT(TIMER)                ' starts timer
broom broomx, broomy, broomdir       ' draws the broom in its first position
DO                                    ' starts keyboard input loop
cool = INT(TIMER) - seconds                      ' counts seconds
IF cool <> lcool THEN                            '
dumx = POINT(0)                                  '
dumy = POINT(1)                                  '
LINE (160, 1)-(190, 15), 0, BF                   '
font "trashfnt.fnt", 160, 1, 15, STR$(cool)      '
DRAW "bm" + STR$(dumx) + "," + STR$(dumy)        '
END IF                                           '
IF cool = INT(length * .75) THEN BEEP            ' beeps
IF cool = length THEN youlose                    '
lcool = cool                                     '

SELECT CASE INKEY$                          ' gets arrow keys input
CASE CHR$(0) + "H"                          '
movebroom 1, broomdir                       '
CASE CHR$(0) + "P"                          '
movebroom 3, broomdir                       '
CASE CHR$(0) + "K"                          '
broomdir = 2                                '
movebroom 4, broomdir                       '
CASE CHR$(0) + "M"                          '
broomdir = 1                                '
movebroom 2, broomdir                       '
END SELECT                                  '

IF won = TRUE THEN won = FALSE: EXIT DO         ' did you win?

LOOP

score = score + (length - cool)                     ' records score
IF level = 8 AND albub = FALSE THEN              '
dumx = POINT(0)                                  ' which level 8 are you on?
dumy = POINT(1)                                  '
LINE (190, 1)-(300, 15), 0, BF                   '
DRAW "bm" + STR$(dumx) + "," + STR$(dumy)        '
GOTO bub                                         '
END IF

NEXT level

END                                        ' you're done

exitgame:                                      ' exits the game
CLS                                            ' if you press F8
END                                            '

SUB alberto   ' sub to check if you've won or hit the bomb
FOR doota = 0 TO 319 STEP 3
FOR bobo = 30 TO 180 STEP 3
IF POINT(doota, bobo) = 210 OR POINT(doota, bobo) = 211 OR POINT(doota, bobo) = 212 THEN GOTO dup2
NEXT bobo
NEXT doota
youlose
dup2:
FOR doota = 0 TO 319 STEP 3
FOR bobo = 30 TO 180 STEP 3
IF POINT(doota, bobo) > 99 AND POINT(doota, bobo) < 199 THEN GOTO dup
NEXT bobo
NEXT doota
youwin
dup:
END SUB

SUB apple (x, y)   ' draws an apple
' Apple: 140, 141, 142
CIRCLE (x, y + 10), 0
DRAW "c140 u1r2u1r5d1r2d1l3u1l3d1l3 r5c142 r1d2l1d2 r1d2l3u2r1u2l1u2r2 d1l2"
DRAW "r1d4l1r2"
DRAW "c140bd1bl5r2d1r5u1r2 d1l2d1l5u1l2"
CIRCLE (x, y + 10), 0, 140
DRAW "br4bu2 c141 u2 l2u1"

END SUB

SUB banana (x, y)   ' draws a banana
' Banana: 130, 131
CIRCLE (x - 3, y + 10), 0
DRAW "c130 r8u1r2d1r8u1l8 u1l2d1l8 br7bu1"
DRAW "c131 u1 r1u2r2d2r1d1 u1l1u1l1d1"

END SUB

SUB bomb (x, y)   ' draws the bomb
' Bomb: 210, 211, 212
CIRCLE (x + 5, y + 13), 0, 0
CIRCLE STEP(0, 0), 5, 210
PAINT STEP(0, 0), 210, 210
CIRCLE STEP(0, 0), 3, 211, -2, -3
CIRCLE STEP(0, 0), 3, 211, 2, 2.4
PSET STEP(0, 0), 210
PSET STEP(-2, -1), 211
PSET STEP(1, 0), 211
DRAW "bu4br1 c212 u1h1"
END SUB

SUB broccoli (x, y)   ' draws a broccoli
' Broccoli: 110, 111
DRAW "c111 bm" + STR$(x + 1) + "," + STR$(y + 4) + "d4r5u1r4u1r3u2l11 bf1 p111,111 bh1"
DRAW "c110 bd4br2 d3r1d5r4u6l1u2l4bf1 p110,110 bh1"

END SUB

SUB broom (x, y, face)   ' draws the broom at position x, y, facing
SELECT CASE face         ' face direction
CASE 1
CIRCLE (x + 2, y + 2), 0, 0
DRAW "c200 r1d3r1d3r1d3r1d3r1d2 r1d1l1 l3d3r10u3l6 bd1 p200,200 bu1"
DRAW "bl4 bd4 c201 nd2 r2 nd2 r2 nd2 r2 nd2 r2 nd2 r2 nd2"
CASE 2
CIRCLE (x + 15, y + 2), 0, 0
DRAW "c200 l1d3l1d3l1d3l1d3l1d2 l1d1r1 r3d3l10u3r6 bd1 p200,200 bu1"
DRAW "br4 bd4 c201 nd2 l2 nd2 l2 nd2 l2 nd2 l2 nd2 l2 nd2"
END SELECT
END SUB

SUB can (x, y)   ' draws a trash can at position x, y
LINE (x - 2, y - 2)-(x + 12, y - 1), 31, BF
LINE (x - 2, y - 2)-(x + 11, y - 1), 30, BF
LINE (x - 2, y - 2)-(x + 10, y - 1), 29, BF
LINE (x - 2, y - 2)-(x + 9, y - 1), 28, BF
LINE (x - 2, y - 2)-(x + 8, y - 1), 27, BF
LINE (x - 2, y - 2)-(x + 7, y - 1), 26, BF
LINE (x - 2, y - 2)-(x + 6, y - 1), 25, BF
LINE (x - 2, y - 2)-(x + 5, y - 1), 24, BF
LINE (x - 2, y - 2)-(x + 4, y - 1), 23, BF
LINE (x - 2, y - 2)-(x + 3, y - 1), 22, BF
LINE (x - 2, y - 2)-(x + 2, y - 1), 21, BF
LINE (x - 2, y - 2)-(x + 1, y - 1), 20, BF
LINE (x - 2, y - 2)-(x, y - 1), 19, BF
LINE (x - 2, y - 2)-(x - 1, y - 1), 18, BF
LINE (x - 2, y - 2)-(x - 2, y - 1), 17, BF

LINE (x, y)-STEP(10, 20), 30, BF
LINE (x, y)-STEP(9, 20), 29, BF
LINE (x, y)-STEP(8, 20), 28, BF
LINE (x, y)-STEP(7, 20), 27, BF
LINE (x, y)-STEP(6, 20), 26, BF
LINE (x, y)-STEP(5, 20), 25, BF
LINE (x, y)-STEP(4, 20), 24, BF
LINE (x, y)-STEP(3, 20), 23, BF
LINE (x, y)-STEP(2, 20), 22, BF
LINE (x, y)-STEP(1, 20), 21, BF
LINE (x, y)-STEP(0, 20), 20, BF
END SUB

SUB carrot (x, y)   ' draws a carrot
' Carrot: 120, 121
DRAW "c120 bm" + STR$(x + 10) + "," + STR$(y + 18) + " l1u2l1u2l1u2l1u2l1u2l1"
DRAW "r6 d9 bu2 bl1 p120,120"
DRAW "bm" + STR$(x) + "," + STR$(y + 8) + "c121 br7 u2l1u2l2r2d2r3u1r2u2d2l3u2"

END SUB

SUB colcan (col)   ' colors the cans col color
FOR pal = 20 TO 2 STEP -1
SELECT CASE col
CASE 1
PALETTE pal + 15, 65536 * (pal * 3) + 256 * 0 + 0
CASE 2
PALETTE pal + 15, 65536 * 0 + 256 * (pal * 3) + 0
CASE 3
PALETTE pal + 15, 65536 * (pal * 3) + 256 * (pal * 3) + 0
CASE 4
PALETTE pal + 15, 65536 * 0 + 256 * 0 + (pal * 3)
CASE 5
PALETTE pal + 15, 65536 * (pal * 3) + 256 * 0 + (pal * 3)
CASE 6
PALETTE pal + 15, 65536 * 0 + 256 * (pal * 3) + (pal * 3)
CASE 7
PALETTE pal + 15, 65536 * (pal * 3) + 256 * (pal * 3) + (pal * 3)
END SELECT
NEXT pal
END SUB

SUB delay (spd#)   ' delays spd# number of seconds
k# = TIMER
DO
LOOP UNTIL TIMER >= k# + spd#
END SUB

SUB fallcan (x, y, spd#)   ' makes a trashcan fall to position x, y
cy = 3
DO
cy = cy + 1
can x, cy
delay spd#
IF cy <> y THEN PAINT STEP(0, 0), 0, 0
LOOP UNTIL cy = y
END SUB

SUB flash (col1, col2, tim)   ' makes the trash cans flash between colors
FOR clr = 1 TO tim            ' col1 and col2, tim number of times
IF clr MOD 2 = 1 THEN colcan col1
IF clr MOD 2 = 0 THEN colcan col2
delay .3
NEXT clr
END SUB

SUB font (file$, xcol, ycol, colr, text$)   ' loads fonts made with
OPEN file$ FOR INPUT AS #1                  ' Clocker's Font Maker
INPUT #1, hi$
INPUT #1, wid$
FOR ctr = 0 TO 255
INPUT #1, fontstr$(ctr)
NEXT ctr

FOR charcount = 1 TO LEN(text$)
char = ASC(MID$(text$, charcount, 1))
count = 0
FOR j = 1 TO VAL(wid$)
FOR k = 1 TO VAL(hi$)
count = count + 1
fx = (j + (charcount - 1) * VAL(wid$)) - 1
fy = k - 1
IF MID$(fontstr$(char), count, 1) = "1" THEN PSET (fx + xcol, fy + ycol), colr
NEXT k
NEXT j
NEXT charcount
CLOSE
END SUB

SUB gamescrn   ' draws the game screen
fill = 19

FOR fll = 3 TO 320 STEP 17
fallcan fll - 1, 180, 0        ' Bottom
NEXT fll

FOR cn = 1 TO fill
pos2x = rand1(17)
pos2y = rand1(6)
occupied(pos2x, pos2y - 1) = TRUE
fallcan pos2x * 17 + 19, pos2y * 25 + 5, 0   ' Middle
NEXT cn

FOR lin = 25 TO 20 STEP -1
LINE (0, lin)-(639, lin), INT(lin * 1.04)
NEXT lin

flash 4, 1, 6

END SUB

DEFSNG A-Z
SUB gifload (a$)   ' loads a 87a GIF
DEFINT A-Z
DIM Prefix(4095), Suffix(4095), OutStack(4095), shiftout%(8)
DIM Ybase AS LONG, powersof2(11) AS LONG, WorkCode AS LONG

FOR a% = 0 TO 7: shiftout%(8 - a%) = 2 ^ a%: NEXT a%
FOR a% = 0 TO 11: powersof2(a%) = 2 ^ a%: NEXT a%
IF a$ = "" THEN INPUT "GIF file"; a$: IF a$ = "" THEN END
IF INSTR(a$, ".") = 0 THEN a$ = a$ + ".gif"
OPEN a$ FOR BINARY AS #1
a$ = "      ": GET #1, , a$
IF a$ <> "GIF87a" THEN PRINT "Not a GIF87a file.": END
GET #1, , TotalX: GET #1, , TotalY: GOSUB GetByte
NumColors = 2 ^ ((a% AND 7) + 1): NoPalette = (a% AND 128) = 0
GOSUB GetByte: Background = a%
GOSUB GetByte: IF a% <> 0 THEN PRINT "Bad screen descriptor.": END
IF NoPalette = 0 THEN P$ = SPACE$(NumColors * 3): GET #1, , P$
DO
    GOSUB GetByte
    IF a% = 44 THEN
        EXIT DO
    ELSEIF a% <> 33 THEN
        PRINT "Unknown extension type.": END
    END IF
    GOSUB GetByte
    DO: GOSUB GetByte: a$ = SPACE$(a%): GET #1, , a$: LOOP UNTIL a% = 0
LOOP
GET #1, , XStart: GET #1, , YStart: GET #1, , XLength: GET #1, , YLength
XEnd = XStart + XLength: YEnd = YStart + YLength: GOSUB GetByte
IF a% AND 128 THEN PRINT "Can't handle local colormaps.": END
Interlaced = a% AND 64: PassNumber = 0: PassStep = 8
GOSUB GetByte
ClearCode = 2 ^ a%
EOSCode = ClearCode + 1
FirstCode = ClearCode + 2: NextCode = FirstCode
StartCodeSize = a% + 1: CodeSize = StartCodeSize
StartMaxCode = 2 ^ (a% + 1) - 1: MaxCode = StartMaxCode

BitsIn = 0: BlockSize = 0: BlockPointer = 1
x% = XStart: y% = YStart: Ybase = y% * 320&

SCREEN 13: DEF SEG = &HA000
IF NoPalette = 0 THEN
    OUT &H3C7, 0: OUT &H3C8, 0
    FOR a% = 1 TO NumColors * 3: OUT &H3C9, ASC(MID$(P$, a%, 1)) \ 4: NEXT a%
END IF
LINE (0, 0)-(319, 199), Background, BF
DO
    GOSUB GetCode
    IF Code <> EOSCode THEN
        IF Code = ClearCode THEN
            NextCode = FirstCode
            CodeSize = StartCodeSize
            MaxCode = StartMaxCode
            GOSUB GetCode
            CurCode = Code: LastCode = Code: LastPixel = Code
            IF x% < 320 THEN POKE x% + Ybase, LastPixel
            x% = x% + 1: IF x% = XEnd THEN GOSUB NextScanLine
        ELSE
            CurCode = Code: StackPointer = 0
            IF Code > NextCode THEN EXIT DO
            IF Code = NextCode THEN
                CurCode = LastCode
                OutStack(StackPointer) = LastPixel
                StackPointer = StackPointer + 1
            END IF

            DO WHILE CurCode >= FirstCode
                OutStack(StackPointer) = Suffix(CurCode)
                StackPointer = StackPointer + 1
                CurCode = Prefix(CurCode)
            LOOP

            LastPixel = CurCode
            IF x% < 320 THEN POKE x% + Ybase, LastPixel
            x% = x% + 1: IF x% = XEnd THEN GOSUB NextScanLine

            FOR a% = StackPointer - 1 TO 0 STEP -1
                IF x% < 320 THEN POKE x% + Ybase, OutStack(a%)
                x% = x% + 1: IF x% = XEnd THEN GOSUB NextScanLine
            NEXT a%

            IF NextCode < 4096 THEN
                Prefix(NextCode) = LastCode
                Suffix(NextCode) = LastPixel
                NextCode = NextCode + 1
                IF NextCode > MaxCode AND CodeSize < 12 THEN
                    CodeSize = CodeSize + 1
                    MaxCode = MaxCode * 2 + 1
                END IF
            END IF
            LastCode = Code
        END IF
    END IF
LOOP UNTIL DoneFlag OR Code = EOSCode
'BEEP
'A$ = INPUT$(1)
CLOSE #1
EXIT SUB

GetByte: a$ = " ": GET #1, , a$: a% = ASC(a$): RETURN

NextScanLine:
    IF Interlaced THEN
        y% = y% + PassStep
        IF y% >= YEnd THEN
            PassNumber = PassNumber + 1
            SELECT CASE PassNumber
            CASE 1: y% = 4: PassStep = 8
            CASE 2: y% = 2: PassStep = 4
            CASE 3: y% = 1: PassStep = 2
            END SELECT
        END IF
    ELSE
        y% = y% + 1
    END IF
    x% = XStart: Ybase = y% * 320&: DoneFlag = y% > 199
RETURN
GetCode:
    IF BitsIn = 0 THEN GOSUB ReadBufferedByte: LastChar = a%: BitsIn = 8
    WorkCode = LastChar \ shiftout%(BitsIn)
    DO WHILE CodeSize > BitsIn
        GOSUB ReadBufferedByte: LastChar = a%
        WorkCode = WorkCode OR LastChar * powersof2(BitsIn)
        BitsIn = BitsIn + 8
    LOOP
    BitsIn = BitsIn - CodeSize
    Code = WorkCode AND MaxCode
RETURN
ReadBufferedByte:
    IF BlockPointer > BlockSize THEN
        GOSUB GetByte: BlockSize = a%
        a$ = SPACE$(BlockSize): GET #1, , a$
        BlockPointer = 1
    END IF
    a% = ASC(MID$(a$, BlockPointer, 1)): BlockPointer = BlockPointer + 1
RETURN

END SUB

SUB intro   ' does the introduction
gifload "ccp.gif"
font "trashfnt.fnt", 110, 90, 15, "PRESENTS"
SLEEP 3
FOR lin = 0 TO 199 STEP 6
LINE (0, lin)-(319, lin), 15
delay .0001
LINE (0, lin)-(319, lin), 0
LINE (0, lin - 1)-(319, lin - 1), 0
LINE (0, lin - 2)-(319, lin - 2), 0
LINE (0, lin - 3)-(319, lin - 3), 0
LINE (0, lin - 4)-(319, lin - 4), 0
LINE (0, lin - 5)-(319, lin - 5), 0
NEXT lin
fallspeed# = 0
colcan 7
'T
fallcan 5, 10, fallspeed#
fallcan 21, 110, fallspeed#
fallcan 21, 85, fallspeed#
fallcan 21, 60, fallspeed#
fallcan 21, 35, fallspeed#
fallcan 21, 10, fallspeed#
fallcan 37, 10, fallspeed#
'R
fallcan 65, 110, fallspeed#
fallcan 65, 85, fallspeed#
fallcan 65, 60, fallspeed#
fallcan 65, 35, fallspeed#
fallcan 65, 10, fallspeed#
fallcan 99, 110, fallspeed#
fallcan 90, 85, fallspeed#
fallcan 82, 60, fallspeed#
fallcan 82, 10, fallspeed#
fallcan 99, 35, fallspeed#
fallcan 99, 10, fallspeed#
'A
fallcan 125, 110, fallspeed#
fallcan 125, 85, fallspeed#
fallcan 125, 60, fallspeed#
fallcan 125, 35, fallspeed#
fallcan 142, 60, fallspeed#
fallcan 142, 10, fallspeed#
fallcan 159, 110, fallspeed#
fallcan 159, 85, fallspeed#
fallcan 159, 60, fallspeed#
fallcan 159, 35, fallspeed#
'S
fallcan 182, 97, fallspeed#
fallcan 199, 110, fallspeed#
fallcan 216, 97, fallspeed#
fallcan 216, 72, fallspeed#
fallcan 199, 60, fallspeed#
fallcan 182, 47, fallspeed#
fallcan 182, 22, fallspeed#
fallcan 199, 10, fallspeed#
fallcan 216, 22, fallspeed#
'H
fallcan 245, 110, fallspeed#
fallcan 245, 85, fallspeed#
fallcan 245, 60, fallspeed#
fallcan 245, 35, fallspeed#
fallcan 245, 10, fallspeed#
fallcan 262, 60, fallspeed#
fallcan 279, 110, fallspeed#
fallcan 279, 85, fallspeed#
fallcan 279, 60, fallspeed#
fallcan 279, 35, fallspeed#
fallcan 279, 10, fallspeed#
font "trashfnt.fnt", 60, 170, 30, "(C) 1997 TOM WATSON"
delay 2
colcan 4
delay .4
colcan 7
delay 1
END SUB

SUB movebroom (way, direc)  ' moves the broom one unit

SELECT CASE way                        '   1
CASE 1                                 ' 4   2
IF broomy < 30 THEN EXIT SUB           '   3
broomy = broomy - 5
FOR egg = 0 TO 16
IF POINT(broomx + egg, broomy) > 15 AND POINT(broomx + egg, broomy) < 32 THEN broomy = broomy + 5
NEXT egg

CASE 2
IF broomx > 300 THEN EXIT SUB
broomx = broomx + 5
FOR egg = 0 TO 24
IF POINT(broomx + 16, broomy + egg) > 15 AND POINT(broomx + 16, broomy + egg) < 32 THEN broomx = broomx - 5
NEXT egg

CASE 3
IF broomy > 175 THEN EXIT SUB
broomy = broomy + 5
FOR egg = 0 TO 16
IF POINT(broomx + egg, broomy + 26) > 15 AND POINT(broomx + egg, broomy + 26) < 32 THEN broomy = broomy - 5
NEXT egg

CASE 4
IF broomx < 5 THEN EXIT SUB
broomx = broomx - 5
FOR egg = 0 TO 24
IF POINT(broomx - 1, broomy + egg) > 15 AND POINT(broomx - 1, broomy + egg) < 32 THEN broomx = broomx + 5
NEXT egg
END SELECT

DRAW "p0,0"
broom broomx, broomy, broomdir

alberto

END SUB

SUB paper (x, y)   ' draws a crumpled piece of paper
' Paper: 150, 151
CIRCLE (x + 7, y + 7), 0
DRAW "C150 F5 R5 G5L2 H5 G5 U7 D4 L2 H3 E5 R6 BL1 BD1 P151,150"

END SUB

SUB popcan (x, y)   ' draws a crushed pop can
' Popcan: 160, 161
CIRCLE (x, y + 4), 0
DRAW "c160 r8 f3g3f2g1f3l8 h3e3h2e1h3 bf5 p161,160 bh5 c160 r5d1f2g2f2g2f2"

END SUB

SUB prompt  ' does the text at the beginning
CLS
file$ = "trashfnt.fnt"
font file$, 10, 10, 15, "THE OBJECT OF TRASH IS TO"
font file$, 10, 25, 15, "SWEEP UP ALL THE TRASH ON"
font file$, 10, 40, 15, "THE SCREEN BEFORE THE BOMB"
font file$, 10, 55, 15, "EXPLODES.  IT EXPLODES WHEN"
font file$, 10, 70, 15, "YOUR TIME RUNS OUT OR IF"
font file$, 10, 85, 15, "YOU TOUCH IT.  A SERIES OF"
font file$, 10, 100, 15, "BEEPS WILL SOUND WHEN YOUR"
font file$, 10, 115, 15, "TIME LEFT IS LOW.  PRESS"
font file$, 10, 130, 15, "F8 TO QUIT THE GAME."
font file$, 10, 160, 15, "PRESS A KEY TO CONTINUE."
SLEEP
CLS
font file$, 10, 10, 15, "PLEASE SELECT THE AMOUNT OF"
font file$, 10, 25, 15, "TIME YOU WOULD LIKE ON EACH"
font file$, 10, 40, 15, "LEVEL. IF YOU HAVE A SLOWER"
font file$, 10, 55, 15, "COMPUTER OR YOU WANT AN EASY"
font file$, 10, 70, 15, "GAME, SELECT A HIGH NUMBER."
font file$, 10, 85, 15, "IF YOU HAVE A FAST COMPUTER"
font file$, 10, 100, 15, "OR YOU WANT A HARD GAME,"
font file$, 10, 115, 15, "SELECT A LOW NUMBER."
font file$, 10, 145, 15, "1   2   3   4   5   6   7"
DO: sptime = INT(VAL(INKEY$))
LOOP UNTIL sptime > 0 AND sptime < 8
DO: LOOP UNTIL INKEY$ = ""
END SUB

FUNCTION rand0 (max)   ' randomly selects an integer from 0 to max
rand0 = INT((RND(1) * (max + 1)) + 1)
END FUNCTION

FUNCTION rand1 (max)   ' randomly selects an integer from 1 to max
rand1 = (INT((RND(1) * max) + 1))
END FUNCTION

SUB setpal   ' sets the palette colors
' Broccoli
PALETTE 100, 60
PALETTE 101, 256 * 30
' Tomato
PALETTE 110, 256 * 55
PALETTE 111, 256 * 30
' Carrot
PALETTE 120, 256 * 25 + 60
PALETTE 121, 256 * 35
' Banana
PALETTE 130, 256 * 55 + 60
PALETTE 131, 256 * 45 + 45
' Apple
PALETTE 140, 55
PALETTE 141, 256 * 40
PALETTE 142, 65536 * 45 + 256 * 47 + 47
' Paper
PALETTE 150, 65536 * 60 + 256 * 60 + 60
PALETTE 151, 65536 * 30 + 256 * 30 + 30
' Popcan
PALETTE 160, 65536 * 63 + 256 * 61 + 62
PALETTE 161, 256 * 20 + 55
' Sock
PALETTE 170, 65536 * 55
PALETTE 171, 65536 * 55 + 256 * 55 + 55
' Broom
PALETTE 200, 256 * 25 + 42
PALETTE 201, 256 * 45 + 45
' Bomb
PALETTE 210, 65536 * 10 + 256 * 11 + 12
PALETTE 211, 65536 * 55 + 256 * 57 + 58
PALETTE 212, 256 * 60 + 63
END SUB

SUB sock (x, y)   ' draws a sock
' Sock: 170, 171
CIRCLE (x + 3, y + 4), 0
DRAW "c171 r7 d1 c170 l7 d1 c171 r7 l7 d1"
DRAW "c170 d5 g5 d4 f1 r3 e4r3e2u2h2e1u4 l7 bf1 p170,170 bh1"

END SUB

SUB tomato (x, y)   ' draws a tomato
' Tomato: 100, 101
x = x + 8
y = y + 12
CIRCLE (x - 5, y), 5, 100, , , 1: PAINT STEP(0, 0), 100, 100
CIRCLE (x + 2, y), 5, 100, , , 1: PAINT STEP(0, 0), 100, 100
DRAW "c101 bu3 bl3 u2l2u2l2r2d2r2u2r2"

END SUB

SUB total  ' you've won the second level eight

FOR clr = 1 TO 20
IF clr MOD 2 = 1 THEN colcan 1
IF clr MOD 2 = 0 THEN colcan 4
delay .09
NEXT clr
CLS
colcan 7
LINE (20, 20)-(120, 160), 31, BF
LINE (20, 20)-(110, 160), 30, BF
LINE (20, 20)-(100, 160), 29, BF
LINE (20, 20)-(90, 160), 28, BF
LINE (20, 20)-(80, 160), 27, BF
LINE (20, 20)-(70, 160), 26, BF
LINE (20, 20)-(60, 160), 25, BF
LINE (20, 20)-(50, 160), 24, BF
LINE (20, 20)-(40, 160), 23, BF
LINE (20, 20)-(30, 160), 22, BF

LINE (10, 10)-(130, 20), 31, BF
LINE (10, 10)-(120, 20), 30, BF
LINE (10, 10)-(110, 20), 29, BF
LINE (10, 10)-(100, 20), 28, BF
LINE (10, 10)-(90, 20), 27, BF
LINE (10, 10)-(80, 20), 26, BF
LINE (10, 10)-(70, 20), 25, BF
LINE (10, 10)-(60, 20), 24, BF
LINE (10, 10)-(50, 20), 23, BF
LINE (10, 10)-(40, 20), 22, BF
LINE (10, 10)-(30, 20), 21, BF
LINE (10, 10)-(19, 20), 20, BF

LINE (200, 10)-(260, 120), 200
LINE (201, 10)-(261, 120), 200
LINE (202, 10)-(262, 120), 200
LINE (203, 10)-(263, 120), 200
LINE (210, 120)-(315, 140), 200, BF
LINE (210, 140)-(315, 145), 201, BF
FOR dum = 215 TO 315 STEP 10
LINE (dum - 5, 145)-(dum, 155), 201, BF
NEXT dum
SLEEP 1
colcan 5

txt$ = "CONGRATULATIONS!"
file$ = "trashfnt.fnt"
FOR dkim = 1 TO LEN(txt$)
ix = dkim * 10 + 20
iy = dkim * 5 + 50
font file$, ix, iy, 15, MID$(txt$, dkim, 1)
NEXT dkim

txt$ = "YOU REALLY CLEANED UP!"
file$ = "trashfnt.fnt"
FOR dkim = 1 TO LEN(txt$)
ix = dkim * 10 + 20
iy = dkim * 5 + 20
font file$, ix, iy, 15, MID$(txt$, dkim, 1)
NEXT dkim

END
END SUB

SUB youlose   ' you've lost
FOR green = 0 TO 63
PALETTE 0, 256 * green + 63
NEXT green
FOR green = 63 TO 0 STEP -1
PALETTE 0, 256 * green + 63
NEXT green
FOR blue = 0 TO 63
PALETTE 0, 65536 * blue + 63
NEXT blue
CLS
FOR black = 63 TO 0 STEP -1
PALETTE 0, 65536 * black + black
NEXT black
PALETTE
font "trashfnt.fnt", 5, 30, 15, "YOU LOST! TRY HARDER NEXT TIME."
END
END SUB

SUB youwin   ' you've won a level
SELECT CASE level
CASE 8
IF albub = TRUE THEN score = score + (length - cool): total
flash 6, 3, 6
colcan 2
delay 2
flash 1, 4, 4
colcan 6
delay .8
colcan 2
delay 1
CASE ELSE
flash 5, 2, 6
colcan 7
END SELECT
won = TRUE
END SUB

