unit tunel4;
{}
INTERFACE
{}
const SoundBoardAvailable:boolean=false;
      IsPlaying          :boolean=false;
      IsPaused           :boolean=false;
      Ready              :boolean=false;
      enab:array[false..true] of string[8]=('Disabled','Enabled');
      onof:array[false..true] of string[3]=('Off','On');
      yesno:array[false..true] of string[3]=('No','Yes');
      uspech:array[false..true] of string[7]=('failed ','ready');
{}
type t_nibble=0..15;
     t_buf=
     record
      d:^char;
      s,f:longint;
      g,o:word;
     end;
     t_options=
     record
      w,t:byte;
     end;
     t_strela=
     record
      x,y:byte;
      smer:t_nibble;
      p:boolean;
     end;
     t_sndcfg=
     record
      vol:byte; p:boolean;
      dev,stat,hz:integer;
      md:string;
     end;
     t_spl=
     record
      d:^char;
      s:word;
      sr:byte
     end;
     tcfg=
     record
      a,i,d,t:word
     end;
{}
function najdimod:string;
function input4(s:string; x,y:word; l,l2:byte; e,where:word):string;
function str2(n:longint):string;
function scankeykomplex:byte;
function choosedevice(scrg,scro:word; scfgvol:byte; scfgp:boolean; scfgdev,scfgstat,scfghz:integer; scfgmd:string):byte;
function enabstr(boo:boolean):string;
function loadpalfromcfg(name:string):boolean;
function loadspl(var spl:t_spl):boolean;
function reloadspl(var spl:t_spl):boolean;
function quited:boolean;

procedure fw(text2:string; x,y:integer; color,info:byte; where:word);
procedure quad(x,y,w,t:word; col:byte; where:word);
procedure othercheck(n:t_nibble; exesize:longint; verze:string);
procedure help(scrg,scro:word; const verze:string);
procedure splsetup(scrg,scro,scrs:word; var loadsfx,sfxp,p:boolean; var sfxlng,sfxfst,sfxt,vol:byte);
procedure tunbody(num:byte; scrg,scro:word);
procedure powery(var p1,p2,p3,p4:boolean);
procedure PlaySound_sp(g,o,od,l2,ww:word); {prehraje sampl nebo jeho cast pod PC Speakerem}
procedure gfx_cfg(scrg,scro:word; scrs:longint; var wt4:byte; var mono:boolean);
procedure vysvit(ra:byte; boo:boolean);
procedure savetmp(flname:string);
procedure loadtmp(flname:string);
procedure intropic(faze:boolean);

 function GetMemBuffer(MemSize:word):pointer;
 function GetMemVOCHandle(BufSize, SampleRate:word;var Sample:t_spl):boolean;
 function PlaySound_sb(g,o,w,hz:word):boolean; {prehraje sampl nebo jeho cast pod SoundBlasterem}
 function PlaySound_sb2(var Sample:t_spl):boolean;
 function PauseSound:boolean;
 function sb_playing:boolean;
 function RestartSound:boolean;
 function StopSound:boolean;
 function findblaster(filename:string; var a,i,d,t:word):boolean;
 function LoadVOCFile(FileName:string; var Sample:t_spl):boolean;
 function LoadWAVFile(FileName:string; var Sample:t_spl):boolean;
 function loadRAWFile(filename:string; var Sample:t_spl; hz:word):boolean;

 procedure UnloadBuffer(var Sample:t_spl);
 procedure SetVolume(Value:byte);

{}
IMPLEMENTATION
{}
uses dos,ch;
{}
{$L MOD-obj.OBJ}
{$F+}
{}
procedure modvolume(v1,v2,v3,v4:integer); external;
procedure moddevice(var device:integer); external;
procedure modsetup(var status:integer;device,mixspeed,pro,loop:integer;var str:string); external;
procedure modstop; external;
procedure modinit; external;
{$F-}
const ll=true;
      oo=false;
      wtg4:array[0..2] of string[16]=('Vertical Retrace','Display Retrace','Nothing');
      ismono:array[false..true] of string[5]=('Color','Mono');
      KEYBOARDINTR=9;
      KEYBOARDPORT=$60;
      c_rezerva=4096; {Je dobre nechat nejakou dynamickou pamet volnou}
      c_samplu=20;
      c_tmpname='tmp_col.$$$';
      c_splfname='tun.voc';
      sg:array[0..c_samplu+1] of longint=(c_samplu,
       $00001,$02F11,$039B3,$0413A,$061A0,$07454,$08679,$0A296,$0FE96,
       $17FE5,$1C0C9,$1FE90,$2266E,$256A2,$2882A,$2BFAB,$2E4F8,$2FE6C,$33143,$37C6E,$385E4);
      wv:array[1..c_samplu] of byte=(60,40,80,60,45,65,45,55,55,50,55,55,45,55,70,80,80,50,35,35);
      scw:array[1..8] of byte=(4,164,4,164,76,236,76,236);
      sct:array[1..8] of byte=(6,6,106,106,46,46,146,146);
      spofcomp:array[0..19] of byte=(1,4,11,15,20,25,33,40,50,66,75,80,90,100,125,133,150,166,200,250);
      recomend:array[0..19] of word=(0,4,10,18,30,40,70,100,130,180,230,280,360,460,580,700,850,1000,1200,1400);
      amp:array[0..255] of byte=(0,0,0,0,0,1,1,1,1,1,2,2,2,2,2,3,3,3,3,4,4,4,4,4,5,5,5,5,5,6,6,6,6,6,7,7,7,7,
       8,8,8,8,8,9,9,9,9,9,10,10,10,10,11,11,11,11,11,12,12,12,12,12,13,13,13,13,13,14,14,14,14,15,15,15,15,15,
       16,16,16,16,16,17,17,17,17,18,18,18,18,18,19,19,19,19,19,20,20,20,20,20,21,21,21,21,22,22,22,22,22,23,23,23,23,23,
       24,24,24,24,24,25,25,25,25,26,26,26,26,26,27,27,27,27,27,28,28,28,28,29,29,29,29,29,30,30,30,30,30,31,31,31,31,31,
       32,32,32,32,33,33,33,33,33,34,34,34,34,34,35,35,35,35,36,36,36,36,36,37,37,37,37,37,38,38,38,38,38,39,39,39,39,
       40,40,40,40,40,41,41,41,41,41,42,42,42,42,42,43,43,43,43,44,44,44,44,44,45,45,45,45,45,46,46,46,46,47,47,47,47,47,
       48,48,48,48,48,49,49,49,49,49,50,50,50,50,51,51,51,51,51,52,52,52,52,52,53,53,53,53,54);
      c_klv:array[1..4,1..5] of byte=((17,32,45,30,56),(23,38,51,36,57),(200,205,208,203,157),(72,77,80,75,82));
      ractiv:array[0..25] of word=(100,95,90,85,80,75,70,65,60,55,50,45,40,35,30,25,20,15,10,5,1,200,300,400,500,600);
      tank:array[1..4,0..7] of byte=(
       (24,24,90,126,126,126,126,66),(0,252,120,127,127,120,252,0),
       (66,126,126,126,126,90,24,24),(0,63,30,254,254,30,63,0));
      scnkey:array[0..255] of string[12]=('NUL',
       'Esc','1','2','3','4','5','6','7','8','9',
       '0','-','= or +','BackSpace','TAB','Q','W','E','R','T',
       'Y','U','I','O','P','[ or {','] or }','Enter','Left_CTRL','A',
       'S','D','F','G','H','J','K','L','; or :',#39' or "',
       '` or ~','Left_Shift','','Z','X','C','V','B','N','M',
       ', or <','. or >','/ or ?','Rigth_Shift','Pause?','Left_Alt','Space','CapsLock','F1','F2',
       'F3','F4','F5','F6','F7','F8','F9','F10','NumLock','ScrollLock',
       'KeyPad 7','KeyPad 8','KeyPad 9','KeyPad -','KeyPad 4','KeyPad 5','KeyPad 6','KeyPad +','KeyPad 1','KeyPad 2',
       'KeyPad 3','KeyPad 0','KeyPad .','','','','F11','F12','','',
       '','','','','','','','','','',
       '','','','','','','','','','',
       '','','','','','','','','','',
       '','','','','','','','',{128}'','',
       '','','','','','','','','','',
       '','','','','','','','','','',
       '','','','','','KeyPad Enter','Rigth CTRL','','','',
       '','','','','','','','','','PtrScreen',
       '','','','','','','','','','',
       'KeyPad /','','PrtScreen','Right Alt','','','','','','',
       '','','','','','','','','Home','Arrow Up',
       'Page Up','','Arrow Left','','Arrow Right','','End','Arrow Down','Page Down','Insert',
       'Delete','','','','','','','','','',
       '','','','','','','','','','',
       '','','','','','','','','Macro','',
       '','','','','','','','','','',
       '','','','','');
      font:array[0..255,0..15] of byte=(
       (0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),
       (124,130,170,130,186,130,124,0,0,0,0,0,0,0,0,0),
       (124,254,214,254,186,198,124,0,0,0,0,0,0,0,0,0),
       (0,108,254,254,124,56,16,0,0,0,0,0,0,0,0,0),
       (0,24,60,126,126,60,24,0,0,0,0,0,0,0,0,0),
       (60,126,24,126,126,60,24,124,0,0,0,0,0,0,0,0),
       (0,8,28,62,127,62,28,62,0,0,0,0,0,0,0,0),
       (0,0,0,24,60,24,0,0,0,0,0,0,0,0,0,0),
       (255,255,255,231,195,231,255,255,0,0,0,0,0,0,0,0),
       (0,0,60,102,102,60,0,0,0,0,0,0,0,0,0,0),
       (255,255,195,153,153,195,255,255,0,0,0,0,0,0,0,0),
       (15,7,63,109,108,108,56,0,0,0,0,0,0,0,0,0),
       (60,102,102,102,60,24,126,24,0,0,0,0,0,0,0,0),
       (31,25,31,24,24,56,120,48,0,0,0,0,0,0,0,0),
       (63,33,63,33,33,231,198,0,0,0,0,0,0,0,0,0),
       (0,146,84,56,254,56,84,146,0,0,0,0,0,0,0,0),
       (128,224,248,254,248,224,128,0,0,0,0,0,0,0,0,0),
       (1,7,31,127,31,7,1,0,0,0,0,0,0,0,0,0),
       (24,60,126,24,24,126,60,24,0,0,0,0,0,0,0,0),
       (54,54,54,54,54,0,54,0,0,0,0,0,0,0,0,0),
       (62,106,106,58,10,10,10,0,0,0,0,0,0,0,0,0),
       (62,96,60,102,60,6,124,0,0,0,0,0,0,0,0,0),
       (0,0,0,60,126,126,60,0,0,0,0,0,0,0,0,0),
       (24,60,126,24,126,60,24,255,0,0,0,0,0,0,0,0),
       (24,60,126,24,24,24,24,0,0,0,0,0,0,0,0,0),
       (24,24,24,24,126,60,24,0,0,0,0,0,0,0,0,0),
       (0,8,12,126,126,12,8,0,0,0,0,0,0,0,0,0),
       (0,16,48,126,126,48,16,0,0,0,0,0,0,0,0,0),
       (0,0,0,64,64,124,0,0,0,0,0,0,0,0,0,0),
       (0,0,36,102,255,102,36,0,0,0,0,0,0,0,0,0),
       (0,0,24,60,126,255,0,0,0,0,0,0,0,0,0,0),
       (0,0,255,126,60,24,0,0,0,0,0,0,0,0,0,0),
       (0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),
       (24,24,24,24,24,0,24,0,0,0,0,0,0,0,0,0),
       (54,54,20,0,0,0,0,0,0,0,0,0,0,0,0,0),
       (36,126,126,36,126,126,36,0,0,0,0,0,0,0,0,0),
       (24,62,96,60,6,124,24,0,0,0,0,0,0,0,0,0),
       (98,102,12,24,48,102,70,0,0,0,0,0,0,0,0,0),
       (16,40,40,50,76,92,50,0,0,0,0,0,0,0,0,0),
       (24,24,48,0,0,0,0,0,0,0,0,0,0,0,0,0),
       (12,24,24,24,24,24,12,0,0,0,0,0,0,0,0,0),
       (48,24,24,24,24,24,48,0,0,0,0,0,0,0,0,0),
       (0,0,36,24,126,24,36,0,0,0,0,0,0,0,0,0),
       (0,0,24,24,126,24,24,0,0,0,0,0,0,0,0,0),
       (0,0,0,0,0,24,24,48,0,0,0,0,0,0,0,0),
       (0,0,0,0,60,0,0,0,0,0,0,0,0,0,0,0),
       (0,0,0,0,0,24,24,0,0,0,0,0,0,0,0,0),
       (2,6,12,24,48,96,64,0,0,0,0,0,0,0,0,0),
       (60,102,110,118,102,102,60,0,0,0,0,0,0,0,0,0),
       (56,24,24,24,24,24,60,0,0,0,0,0,0,0,0,0),
       (124,6,6,60,96,96,126,0,0,0,0,0,0,0,0,0),
       (60,6,6,12,6,6,60,0,0,0,0,0,0,0,0,0),
       (102,102,102,62,6,6,6,0,0,0,0,0,0,0,0,0),
       (126,96,96,124,6,6,124,0,0,0,0,0,0,0,0,0),
       (60,96,96,124,102,102,60,0,0,0,0,0,0,0,0,0),
       (124,6,6,6,6,6,6,0,0,0,0,0,0,0,0,0),
       (60,102,102,60,102,102,60,0,0,0,0,0,0,0,0,0),
       (60,102,102,62,6,6,60,0,0,0,0,0,0,0,0,0),
       (0,24,24,0,24,24,0,0,0,0,0,0,0,0,0,0),
       (0,24,24,0,24,24,48,0,0,0,0,0,0,0,0,0),
       (12,24,48,96,48,24,12,0,0,0,0,0,0,0,0,0),
       (0,0,126,0,126,0,0,0,0,0,0,0,0,0,0,0),
       (48,24,12,6,12,24,48,0,0,0,0,0,0,0,0,0),
       (60,102,6,28,24,0,24,0,0,0,0,0,0,0,0,0),
       (60,66,90,90,76,64,62,0,0,0,0,0,0,0,0,0),
       (60,102,102,102,126,102,102,0,0,0,0,0,0,0,0,0),
       (124,102,102,124,102,102,124,0,0,0,0,0,0,0,0,0),
       (62,96,96,96,96,96,62,0,0,0,0,0,0,0,0,0),
       (124,102,102,102,102,102,124,0,0,0,0,0,0,0,0,0),
       (126,96,96,126,96,96,126,0,0,0,0,0,0,0,0,0),
       (126,96,96,126,96,96,96,0,0,0,0,0,0,0,0,0),
       (62,96,96,110,102,102,60,0,0,0,0,0,0,0,0,0),
       (102,102,102,126,102,102,102,0,0,0,0,0,0,0,0,0),
       (60,24,24,24,24,24,60,0,0,0,0,0,0,0,0,0),
       (60,24,24,24,24,24,24,48,0,0,0,0,0,0,0,0),
       (102,108,120,112,120,108,102,0,0,0,0,0,0,0,0,0),
       (96,96,96,96,96,96,126,0,0,0,0,0,0,0,0,0),
       (62,107,107,107,99,99,99,0,0,0,0,0,0,0,0,0),
       (102,102,118,126,110,102,102,0,0,0,0,0,0,0,0,0),
       (60,102,102,102,102,102,60,0,0,0,0,0,0,0,0,0),
       (124,102,102,124,96,96,96,0,0,0,0,0,0,0,0,0),
       (60,102,102,102,102,110,60,6,0,0,0,0,0,0,0,0),
       (124,102,102,124,120,108,102,0,0,0,0,0,0,0,0,0),
       (62,96,96,60,6,6,124,0,0,0,0,0,0,0,0,0),
       (126,24,24,24,24,24,24,0,0,0,0,0,0,0,0,0),
       (102,102,102,102,102,102,60,0,0,0,0,0,0,0,0,0),
       (102,102,102,102,102,60,24,0,0,0,0,0,0,0,0,0),
       (99,99,99,107,107,107,62,0,0,0,0,0,0,0,0,0),
       (66,102,60,24,60,102,66,0,0,0,0,0,0,0,0,0),
       (102,102,102,60,24,24,24,0,0,0,0,0,0,0,0,0),
       (126,6,12,24,48,96,126,0,0,0,0,0,0,0,0,0),
       (28,24,24,24,24,24,28,0,0,0,0,0,0,0,0,0),
       (64,96,48,24,12,6,2,0,0,0,0,0,0,0,0,0),
       (56,24,24,24,24,24,56,0,0,0,0,0,0,0,0,0),
       (24,52,98,0,0,0,0,0,0,0,0,0,0,0,0,0),
       (0,0,0,0,0,0,0,126,0,0,0,0,0,0,0,0),
       (24,24,12,0,0,0,0,0,0,0,0,0,0,0,0,0),
       (0,0,60,6,62,102,62,0,0,0,0,0,0,0,0,0),
       (96,96,124,102,102,102,124,0,0,0,0,0,0,0,0,0),
       (0,0,60,96,96,96,60,0,0,0,0,0,0,0,0,0),
       (6,6,62,102,102,102,62,0,0,0,0,0,0,0,0,0),
       (0,0,60,102,126,96,62,0,0,0,0,0,0,0,0,0),
       (12,24,24,60,24,24,24,0,0,0,0,0,0,0,0,0),
       (0,0,62,102,102,62,6,60,0,0,0,0,0,0,0,0),
       (96,96,124,102,102,102,102,0,0,0,0,0,0,0,0,0),
       (0,24,0,24,24,24,24,0,0,0,0,0,0,0,0,0),
       (0,24,0,24,24,24,24,48,0,0,0,0,0,0,0,0),
       (96,96,100,108,120,120,108,0,0,0,0,0,0,0,0,0),
       (24,24,24,24,24,24,24,0,0,0,0,0,0,0,0,0),
       (0,0,126,107,107,99,99,0,0,0,0,0,0,0,0,0),
       (0,0,124,102,102,102,102,0,0,0,0,0,0,0,0,0),
       (0,0,60,102,102,102,60,0,0,0,0,0,0,0,0,0),
       (0,0,124,102,102,102,124,96,0,0,0,0,0,0,0,0),
       (0,0,62,102,102,102,62,6,0,0,0,0,0,0,0,0),
       (0,0,60,96,96,96,96,0,0,0,0,0,0,0,0,0),
       (0,0,30,48,28,6,60,0,0,0,0,0,0,0,0,0),
       (24,24,60,24,24,24,12,0,0,0,0,0,0,0,0,0),
       (0,0,102,102,102,102,62,0,0,0,0,0,0,0,0,0),
       (0,0,102,102,102,60,24,0,0,0,0,0,0,0,0,0),
       (0,0,99,99,107,107,62,0,0,0,0,0,0,0,0,0),
       (0,0,102,60,24,60,102,0,0,0,0,0,0,0,0,0),
       (0,0,102,102,102,62,6,124,0,0,0,0,0,0,0,0),
       (0,0,62,6,28,48,62,0,0,0,0,0,0,0,0,0),
       (12,24,24,48,24,24,12,0,0,0,0,0,0,0,0,0),
       (24,24,24,0,24,24,24,0,0,0,0,0,0,0,0,0),
       (48,24,24,12,24,24,48,0,0,0,0,0,0,0,0,0),
       (54,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0),
       (0,0,24,44,70,70,126,0,0,0,0,0,0,0,0,0),
       (62,96,96,96,96,62,4,24,0,0,0,0,0,0,0,0),
       (102,0,102,102,102,102,62,0,0,0,0,0,0,0,0,0),
       (12,24,60,102,126,96,62,0,0,0,0,0,0,0,0,0),
       (60,66,60,6,62,102,62,0,0,0,0,0,0,0,0,0),
       (54,0,60,6,62,102,62,0,0,0,0,0,0,0,0,0),
       (48,24,60,6,62,102,62,0,0,0,0,0,0,0,0,0),
       (24,44,24,60,6,62,30,0,0,0,0,0,0,0,0,0),
       (0,60,96,96,96,60,8,48,0,0,0,0,0,0,0,0),
       (60,66,60,102,126,96,60,0,0,0,0,0,0,0,0,0),
       (102,0,60,102,126,96,60,0,0,0,0,0,0,0,0,0),
       (112,0,60,102,126,96,62,0,0,0,0,0,0,0,0,0),
       (40,0,56,24,24,24,60,0,0,0,0,0,0,0,0,0),
       (60,66,24,24,24,24,24,0,0,0,0,0,0,0,0,0),
       (112,0,24,24,24,24,24,0,0,0,0,0,0,0,0,0),
       (102,0,60,102,126,102,102,0,0,0,0,0,0,0,0,0),
       (24,44,24,60,102,126,102,0,0,0,0,0,0,0,0,0),
       (12,24,126,96,126,96,126,0,0,0,0,0,0,0,0,0),
       (0,0,44,22,60,76,54,0,0,0,0,0,0,0,0,0),
       (0,62,88,88,126,88,94,0,0,0,0,0,0,0,0,0),
       (60,66,60,102,102,102,60,0,0,0,0,0,0,0,0,0),
       (102,0,60,102,102,102,60,0,0,0,0,0,0,0,0,0),
       (14,60,102,102,102,102,60,0,0,0,0,0,0,0,0,0),
       (60,66,0,102,102,102,62,0,0,0,0,0,0,0,0,0),
       (112,0,102,102,102,102,62,0,0,0,0,0,0,0,0,0),
       (102,0,102,102,102,62,6,124,0,0,0,0,0,0,0,0),
       (102,0,60,102,102,102,60,0,0,0,0,0,0,0,0,0),
       (102,0,102,102,102,102,60,0,0,0,0,0,0,0,0,0),
       (0,8,62,96,96,62,8,0,0,0,0,0,0,0,0,0),
       (6,8,29,8,40,80,47,0,0,0,0,0,0,0,0,0),
       (0,36,24,126,24,126,24,0,0,0,0,0,0,0,0,0),
       (124,102,124,96,110,100,100,0,0,0,0,0,0,0,0,0),
       (12,26,24,60,24,88,48,0,0,0,0,0,0,0,0,0),
       (12,24,60,6,62,102,62,0,0,0,0,0,0,0,0,0),
       (12,24,0,24,24,24,24,0,0,0,0,0,0,0,0,0),
       (12,24,60,102,102,102,60,0,0,0,0,0,0,0,0,0),
       (14,0,102,102,102,102,62,0,0,0,0,0,0,0,0,0),
       (54,92,0,124,102,102,102,0,0,0,0,0,0,0,0,0),
       (20,40,102,118,126,110,102,0,0,0,0,0,0,0,0,0),
       (0,60,108,62,0,126,0,0,0,0,0,0,0,0,0,0),
       (60,102,102,60,0,126,0,0,0,0,0,0,0,0,0,0),
       (0,24,0,24,48,96,60,0,0,0,0,0,0,0,0,0),
       (0,0,0,124,96,96,96,0,0,0,0,0,0,0,0,0),
       (0,0,0,124,12,12,12,0,0,0,0,0,0,0,0,0),
       (64,196,72,84,34,68,8,14,0,0,0,0,0,0,0,0),
       (64,196,72,82,42,78,2,0,0,0,0,0,0,0,0,0),
       (24,0,24,24,24,24,24,0,0,0,0,0,0,0,0,0),
       (0,0,18,36,72,36,18,0,0,0,0,0,0,0,0,0),
       (0,0,72,36,18,36,72,0,0,0,0,0,0,0,0,0),
       (34,136,34,136,34,136,34,136,34,136,34,136,34,136,34,136),
       (170,85,170,85,170,85,170,85,170,85,170,85,170,85,170,85),
       (119,221,119,221,119,221,119,221,119,221,119,221,119,221,119,221),
       (24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24),
       (24,24,24,248,248,24,24,24,24,24,24,24,24,24,24,24),
       (24,24,248,24,24,248,24,24,24,24,24,24,24,24,24,24),
       (36,36,36,228,228,36,36,36,36,36,36,36,36,36,36,36),
       (0,0,0,252,252,36,36,36,36,36,36,36,36,36,36,36),
       (0,0,248,24,24,248,24,24,24,24,24,24,24,24,24,24),
       (36,36,228,4,4,228,36,36,36,36,36,36,36,36,36,36),
       (36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36),
       (0,0,252,4,4,228,36,36,36,36,36,36,36,36,36,36),
       (36,36,228,4,4,252,0,0,0,0,0,0,0,0,0,0),
       (36,36,36,252,252,0,0,0,0,0,0,0,0,0,0,0),
       (24,24,248,24,24,248,0,0,0,0,0,0,0,0,0,0),
       (0,0,0,248,248,24,24,24,24,24,24,24,24,24,24,24),
       (24,24,24,31,31,0,0,0,0,0,0,0,0,0,0,0),
       (24,24,24,255,255,0,0,0,0,0,0,0,0,0,0,0),
       (0,0,0,255,255,24,24,24,24,24,24,24,24,24,24,24),
       (24,24,24,31,31,24,24,24,24,24,24,24,24,24,24,24),
       (0,0,0,255,255,0,0,0,0,0,0,0,0,0,0,0),
       (24,24,24,255,255,24,24,24,24,24,24,24,24,24,24,24),
       (24,24,31,24,24,31,24,24,24,24,24,24,24,24,24,24),
       (36,36,36,39,39,36,36,36,36,36,36,36,36,36,36,36),
       (36,36,39,32,32,63,0,0,0,0,0,0,0,0,0,0),
       (0,0,63,32,32,39,36,36,36,36,36,36,36,36,36,36),
       (36,36,231,0,0,255,0,0,0,0,0,0,0,0,0,0),
       (0,0,255,0,0,231,36,36,36,36,36,36,36,36,36,36),
       (36,36,39,32,32,39,36,36,36,36,36,36,36,36,36,36),
       (0,0,255,0,0,255,0,0,0,0,0,0,0,0,0,0),
       (36,36,231,0,0,231,36,36,36,36,36,36,36,36,36,36),
       (24,24,255,0,0,255,0,0,0,0,0,0,0,0,0,0),
       (24,24,24,255,255,0,0,0,0,0,0,0,0,0,0,0),
       (0,0,255,0,0,255,24,24,24,24,24,24,24,24,24,24),
       (0,0,0,255,255,36,36,36,36,36,36,36,36,36,36,36),
       (36,36,36,63,63,0,0,0,0,0,0,0,0,0,0,0),
       (24,24,31,24,24,31,0,0,0,0,0,0,0,0,0,0),
       (0,0,31,24,24,31,24,24,24,24,24,24,24,24,24,24),
       (0,0,0,63,63,36,36,36,36,36,36,36,36,36,36,36),
       (36,36,36,255,255,36,36,36,36,36,36,36,36,36,36,36),
       (24,24,255,24,24,255,24,24,24,24,24,24,24,24,24,24),
       (24,24,24,248,248,0,0,0,0,0,0,0,0,0,0,0),
       (0,0,0,31,31,24,24,24,24,24,24,24,24,24,24,24),
       (255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255),
       (0,0,0,0,255,255,255,255,0,0,0,0,0,0,0,0),
       (240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240),
       (15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15),
       (255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0),
       (0,0,50,92,72,92,50,0,0,0,0,0,0,0,0,0),
       (60,102,102,108,102,102,108,96,0,0,0,0,0,0,0,0),
       (126,102,96,96,96,96,96,0,0,0,0,0,0,0,0,0),
       (0,126,36,36,36,36,36,0,0,0,0,0,0,0,0,0),
       (126,98,48,24,48,98,126,0,0,0,0,0,0,0,0,0),
       (0,0,62,108,108,108,56,0,0,0,0,0,0,0,0,0),
       (0,102,102,102,102,124,96,192,0,0,0,0,0,0,0,0),
       (0,35,86,28,24,24,24,0,0,0,0,0,0,0,0,0),
       (126,24,60,102,60,24,126,0,0,0,0,0,0,0,0,0),
       (24,36,102,126,102,36,24,0,0,0,0,0,0,0,0,0),
       (0,60,102,70,46,44,110,0,0,0,0,0,0,0,0,0),
       (14,24,12,62,102,102,60,0,0,0,0,0,0,0,0,0),
       (0,0,36,90,90,90,36,0,0,0,0,0,0,0,0,0),
       (0,2,36,90,90,90,36,64,0,0,0,0,0,0,0,0),
       (0,0,62,96,124,96,62,0,0,0,0,0,0,0,0,0),
       (0,60,102,102,102,102,102,0,0,0,0,0,0,0,0,0),
       (0,126,0,126,0,126,0,0,0,0,0,0,0,0,0,0),
       (0,24,24,126,24,24,126,0,0,0,0,0,0,0,0,0),
       (0,24,12,6,12,24,0,126,0,0,0,0,0,0,0,0),
       (0,24,48,96,48,24,0,126,0,0,0,0,0,0,0,0),
       (12,30,26,24,24,24,24,24,0,0,0,0,0,0,0,0),
       (24,24,24,24,24,88,120,48,0,0,0,0,0,0,0,0),
       (24,24,0,126,0,24,24,0,0,0,0,0,0,0,0,0),
       (0,50,76,0,50,76,0,0,0,0,0,0,0,0,0,0),
       (24,36,24,0,0,0,0,0,0,0,0,0,0,0,0,0),
       (0,0,0,24,24,0,0,0,0,0,0,0,0,0,0,0),
       (0,0,0,0,24,0,0,0,0,0,0,0,0,0,0,0),
       (31,16,208,80,80,32,32,32,0,0,0,0,0,0,0,0),
       (96,80,80,80,0,0,0,0,0,0,0,0,0,0,0,0),
       (96,16,32,112,0,0,0,0,0,0,0,0,0,0,0,0),
       (0,0,60,60,60,60,0,0,0,0,0,0,0,0,0,0),
       (0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,0));
{}
var keys:string[2];
    Board:tcfg;
    OrgInt:pointer;
{}
function najdimod:string;
var di:searchrec;
begin
 findfirst('*.mod',39,di);
 if doserror=0 then najdimod:=di.name else najdimod:=''
end;
{}
procedure quad(x,y,w,t:word; col:byte; where:word); {Nakresli obdelnik, pozn. pro obrazovku dejte where:=$A000}
var i:word; begin  for i:=y to y+t-1 do fillch(mem[where:i*320+x+8],w,col) end;
{}
procedure fw(text2:string; x,y:integer; color,info:byte; where:word);
var tx,ty:word; i:byte;
begin
 if info>100 then begin; dec(info,100); quad(x,y+4,ord(text2[0])*info,8,0,where); end;
 if info<-100 then begin; inc(info,100); quad(x,y+4,ord(text2[0])*info,8,0,where); end;
 for i:=1 to wil(length(text2),(320-x) div info) do
  begin
   if color=155 then cekej(20);
   for ty:=0 to 7 do
    for tx:=0 to 7 do
     if font[ord(text2[i]),ty] and ($80 shr tx)<>0 then
        byte(ptr(where,x+tx+i*abs(info)+(y+ty)*320)^):=color
  end
end;
{}
function scankeykomplex:byte;
var k:byte;
begin
 k:=port[KEYBOARDPORT];
 repeat until k<>port[KEYBOARDPORT];
 k:=port[KEYBOARDPORT];
 if k=224 then
    repeat
     k:=port[KEYBOARDPORT];
     if (k<>224) and (k<>42) then
        begin
         scankeykomplex:=128+k;
         exit;
        end;
    until false;
 scankeykomplex:=k;
end;
{}
function str2(n:longint):string;
var s:string[11];
begin
 Str(n,s);
 Str2:=s
end;
{}
function input4(s:string; x,y:word; l,l2:byte; e,where:word):string;
var v,keys:string;
    loop1,zac,c:byte;
{                                      }
procedure fw2(zn:char; xx,where:word);
var sax,say:t_nibble;
begin
 for say:=0 to 7 do
  for sax:=0 to 7 do
   if (font[ord(zn),say] and ($80 shr sax))>0 then mem[where:(y+say)*320+xx+sax+8]:=29
end;
{                                      }
procedure fcur(x,y,where:word);
var sax,say:word;
begin
 for say:=y+5*byte(mem[0:$417] and 128=0) to y+7 do
  for sax:=x to x+7 do
   case mem[where:say*320+sax] of
   0: mem[where:say*320+sax]:=23;
   29: mem[where:say*320+sax]:=31
   end
end;
{                                      }
begin
 if ord(s[0])>l then v:=left(s,l) else v:=s;
 c:=1; zac:=0; if mem[0:$417]<128 then inc(mem[0:$417],128);
 quad(x,y,ord(v[0])*8+8,8,0,where);
 for loop1:=zac+1 to ord(v[0]) do
  if loop1-zac>l2 then break else fw2(v[loop1],x+(loop1-zac-1)*8,where);
 fcur(x+c*8,y,where);
 repeat
  repeat keys:=inkeys until keys<>'';
  if keys=#27 then
     begin
      input4:='';
      exit
     end;
  if (((e and 1=1)  and (keys[1] in ['0'..'9'])) or
     ((e and  2=2)  and (keys[1] in ['A'..'Z'])) or
     ((e and  4=4)  and (keys[1] in ['a'..'z'])) or
     ((e and  8=8)  and (keys[1] in [#32..#64])) or
     ((e and 16=16) and (keys[1] in [#1..#7,#10..#12,#14..#31])) or
     ((e and 32=32) and (keys[1] in [#91..''])) or
     ((e and 64=64) and (keys[1] in [''..#255]))) and
     (((ord(v[0])<l) and (not ins)) or ins) then
     begin
      if ins then
         if c=ord(v[0])+1 then v:=v+keys[1]
         else v[c]:=keys[1]
      else v:=left(v,c-1)+keys[1]+right(v,ord(v[0])-c+1);
      if ord(v[0])>l then v[0]:=chr(l);
      c:=asb(c+1,0,ord(v[0])+1)
     end;
  if (keys=#8) and (c>1) then
     begin
      c:=asb(c-1,0,ord(v[0])+1);
      v:=left(v,c-1)+right(v,ord(v[0])-c)
     end;
  if (keys=#13) or (keys=#9) then
     begin
      input4:=v;
      exit
     end;
  if keys=#0'K' then c:=asb(c-1,1,ord(v[0])+1);
  if keys=#0'M' then c:=asb(c+1,1,ord(v[0])+1);
  if keys=#0'G' then c:=1;
  if keys=#0'O' then c:=ord(v[0])+1;
  if (keys=#0'S') and (c<ord(v[0])+1) then v:=left(v,c-1)+right(v,ord(v[0])-c);
  while c-zac-1>l2 do zac:=asb(zac+1,0,l-l2+1);
  while c<zac+1 do zac:=asb(zac-l2,0,l-l2+1);
  quad(x,y,ord(v[0])*8+8+8*byte(keys=#8),8,0,where);
  for loop1:=zac+1 to ord(v[0]) do
   if loop1-zac>l2 then break else fw2(v[loop1],x+(loop1-zac-1)*8,where);
  fcur(x+c*8,y,where)
 until false;
end;
{}
function choosedevice(scrg,scro:word; scfgvol:byte; scfgp:boolean; scfgdev,scfgstat,scfghz:integer; scfgmd:string):byte;
const c_opak:array[0..4] of string[3]=('No','No','No','No','Yes');
      c_plstp:array[false..true] of string[7]=('Play it','Stop it');
var ra,say:byte;
    sax:word; keys:string[2];
begin
 fillchar(mem[scrg:scro+7040],51200,0);
 WRT; move(mem[scrg:scro],mem[$A000:0],64000);
 fw('PC Speaker           ',40,23,29,8,scrg);
 fw('D/A converter on LPT1',40,33,29,8,scrg);
 fw('D/A converter on LPT2',40,43,29,8,scrg);
 fw('D/A converter on LPT3',40,53,29,8,scrg);
 fw('D/A on 1&2   (Stereo)',40,63,29,8,scrg);
 fw('D/A on 1&2     (Mono)',40,73,29,8,scrg);
 fw('Reserved             ',40,83,29,8,scrg);
 fw('Sound Blaster   (2?0)',40,93,29,8,scrg);
 fw('Mono D/A User Defined',40,103,29,8,scrg);
 fw('Stereo D/A User Def. ',40,113,29,8,scrg);
 fw('"Stereo-on-1"  (LPT?)',40,123,29,8,scrg);
 fw('Disney Snd Src (LPT1)',40,133,29,8,scrg);
 fw('Disney Snd Src (LPT2)',40,143,29,8,scrg);
 fw('Disney Snd Src (LPT3)',40,153,29,8,scrg);
 fw('Quad-on-one    (LPT?)',40,163,29,8,scrg);
 fw('No sound             ',40,173,29,8,scrg);
 WRT; move(mem[scrg:scro],mem[$A000:0],64000);
 ra:=asb(scfgdev+2,0,10);
 repeat
  for say:=ra*10+3 to ra*10+11 do
   for sax:=40 to 300 do
    if mem[$A000:say*320+sax]=29 then mem[$A000:say*320+sax]:=40;
  repeat keys:=inkeys until keys<>'';
  for say:=ra*10+3 to ra*10+11 do
   for sax:=40 to 300 do
    if mem[$A000:say*320+sax]=40 then mem[$A000:say*320+sax]:=29;
  if keys=#0'H' then ra:=smycka(ra-1,2,17);
  if keys=#0'P' then ra:=smycka(ra+1,2,17);
  if keys=#0'G' then ra:=2;
  if keys=#0'O' then ra:=17;
  if (keys=#0'H') and (ra in [8]) then dec(ra);
  if (keys=#0'P') and (ra in [8]) then inc(ra);
  if keys=#27 then
     begin
      choosedevice:=15;
      break
     end;
  if keys=#13 then
     begin
      choosedevice:=ra-2;
      exit
     end;
  if (GOdstin(0,1)>0) or (GOdstin(0,2)>0) or (GOdstin(0,3)>0) then pal(0,0,0,0);
 until false;
end;
{}
procedure othercheck(n:t_nibble; exesize:longint; verze:string);
var di:searchrec; zn:char; validm13:boolean; oldmode:byte;
begin
 if n=0 then
    if (paramstr(1)='/?') or (paramstr(1)='/H') or (paramstr(1)='/h') or
       (paramstr(1)='-?') or (paramstr(1)='-H') or (paramstr(1)='-h') then
       begin
        writeln('Tunel v.1.0');
        writeln('Syntax: ',paramstr(0),' (parameter)');
        writeln('Passible parameters:');
        writeln('  /noload   not to load configuration at the initialization.');
        writeln('  /V        to get actual version number.');
        halt;
       end else exit;
 if n=2 then
    begin
     writeln('Size of conventional memory: ',memw[0:$413],' kB.');
     writeln('All free conventional memory: ',round(memavail/1024),' kB.');
     writeln('Largest continuous block of memory: ',round(maxavail/1024),' kB.');
     writeln('This program needs at least ',round((64000+51000)/1024),' kB of conventional memory.');
     halt
    end;
 oldmode:=cur_mod; if maxrow>25 then oldmode:=oldmode and 127+128;
 validm13:=validmode($13);
 if oldmode=128+3 then setth else setmode(oldmode);
 fb(14,1); writeln(' TUNEL v.1.0 (n) No rights reserved 1997 '+stringy(memw[0:$44A]-41,' '));
 fb(7,0);
 writeln('Procesor       : ',isa);
 writeln('Coprocesor     : ',iskopr);
 writeln('BIOS           : ',memstring($F000,$FFF5,8));
 writeln('Video mode     : ',validm13);
 writeln('Mouse          : ',ismouse);
 writeln('Joystick       : ',isjoy,#13#10);
 writeln('Current version: ',verze);
 if not validm13 then
    begin
     writeln('Sorry, but I am unable to set mode 13h (320x200x256colors)');
     writeln('what this "game" needs. Program can not continue.');
     halt
    end;
 if (lcase(right(paramstr(0),9))<>'tunel.exe') and (lcase(right(paramstr(0),5))<>'tunel') then
    writeln('Warning        : Original name of this program is "tunel.exe" and not "',jenjmeno(paramstr(0)),'".');
 write(#13#10'File size checking: ');
 findfirst(paramstr(0),39,di);
 if doserror<>0 then
    begin
     writeln(#13#10'Unable to check the size of original EXE file.');
     writeln('Press any key to continue..');
     sleep
    end
 else
    if di.size=exesize then write('Done.')
    else
       begin
        writeln(#13#10'The size of "',paramstr(0),'" file (',di.size,' bytes)');
        writeln('is not responding to original EXE file (',exesize,' bytes)!');
        writeln('Press Esc to stop the program or any key to continue..');
        zn:=getchar;
        if zn='' then halt
       end
end;
{}
procedure vysvit(ra:byte; boo:boolean);
var say:byte;
    sax:word;
begin
 case boo of
 false: for say:=ra*10 to ra*10+9 do
         for sax:=24 to 319 do
          if mem[video:say*320+sax]=40 then mem[video:say*320+sax]:=29;
 true:  for say:=ra*10 to ra*10+9 do
         for sax:=24 to 319 do
          if mem[video:say*320+sax]=29 then mem[video:say*320+sax]:=40
 end
end;
{}
procedure help(scrg,scro:word; const verze:string);
const lalist=9;
var say,ra:byte; sax:word;
    keys:string[2];
begin
 fillchar(mem[scrg:scro],64000,0);
 for say:=0 to 19 do
  for sax:=0 to 319 do mem[scrg:scro+say*320+sax]:=25+random(4);
 fw('HELP',136,10,188,8,scrg);
 for say:=181 to 199 do
  for sax:=0 to 319 do mem[scrg:scro+say*320+sax]:=25+random(4);
 ra:=1;
 repeat
  case ra of
  1: begin
      fillchar(mem[scrg:scro+6400],51200,0);
      fw('TUNEL is only a remake of',15,40,29,8,scrg);
      fw('very similar game called',15,50,29,8,scrg);
      fw('Tuneller. This program is',15,60,29,8,scrg);
      fw('CardWare. Send me a postcard',15,70,29,8,scrg);
      fw('of your native town, city or',15,80,29,8,scrg);
      fw('a village (if you know where',15,90,29,8,scrg);
      fw('I live) and feel free to copy',15,100,29,8,scrg);
      fw('it to your friends. Perhaps,',15,110,29,8,scrg);
      fw('You may write, what bugs does',15,120,29,8,scrg);
      fw('this program have and you',15,130,29,8,scrg);
      fw('wish it be recovered.',15,140,29,8,scrg);
      fw('I will appreciate any object,',15,150,29,8,scrg);
      fw('advance, note or critic.',15,160,29,8,scrg);
      fw(stri(ra)+'/'+stri(lalist),296,170,24,7,scrg);
      WRT; move(mem[scrg:scro],mem[$A000:0],64000);
      repeat keys:=inkeys until keys<>'';
      if keys='' then break
      else if (keys=#0'H') or (keys=#0'K') or (keys=#0'I') or (keys=#8) then ra:=smycka(ra-1,1,lalist)
      else if keys=#0'G' then ra:=1
      else if keys=#0'O' then ra:=lalist
      else ra:=smycka(ra+1,1,lalist)
     end;
  2: begin
      fillchar(mem[scrg:scro+6400],51200,0);
      fw('TUNEL is a two, three or',15,40,29,8,scrg);
      fw('four players game. The',15,50,29,8,scrg);
      fw('goal of this game is simple',15,60,29,8,scrg);
      fw('and clear - to destroy the',15,70,29,8,scrg);
      fw('enemy tanks and survive.',15,80,29,8,scrg);
      fw('Game is played in a sand',15,90,29,8,scrg);
      fw('world by tanks. Each tank',15,100,29,8,scrg);
      fw('has its base which is',15,110,29,8,scrg);
      fw('giving it very essential',15,120,29,8,scrg);
      fw('energy. Exept the energy',15,130,29,8,scrg);
      fw('each tank has got a shield,',15,140,29,8,scrg);
      fw('what its life depences on.',15,150,29,8,scrg);
      fw('And not only about this..',15,160,29,8,scrg);
      fw(stri(ra)+'/'+stri(lalist),296,170,24,7,scrg);
      WRT; move(mem[scrg:scro],mem[$A000:0],64000);
      repeat keys:=inkeys until keys<>'';
      if keys='' then break
      else if (keys=#0'H') or (keys=#0'K') or (keys=#0'I') or (keys=#8) then ra:=smycka(ra-1,1,lalist)
      else if keys=#0'G' then ra:=1
      else if keys=#0'O' then ra:=lalist
      else ra:=smycka(ra+1,1,lalist)
     end;
  3: begin
      fillchar(mem[scrg:scro+6400],51200,0);
      fw('The energy is getting',15,40,29,8,scrg);
      fw('down while a tank is out',15,50,29,8,scrg);
      fw('of a base. The shield',15,60,29,8,scrg);
      fw('is getting down while you',15,70,29,8,scrg);
      fw('have been shot by enemy.',15,80,29,8,scrg);
      fw('As soon as either shield',15,90,29,8,scrg);
      fw('or energy is on a zero,',15,100,29,8,scrg);
      fw('you are dead. As I said,',15,110,29,8,scrg);
      fw('energy can be refuel in',15,120,29,8,scrg);
      fw('any of the bases but only',15,130,29,8,scrg);
      fw('your base is able to',15,140,29,8,scrg);
      fw('refuel you shield..',15,150,29,8,scrg);
      fw(stri(ra)+'/'+stri(lalist),296,170,24,7,scrg);
      WRT; move(mem[scrg:scro],mem[$A000:0],64000);
      repeat keys:=inkeys until keys<>'';
      if keys='' then break
      else if (keys=#0'H') or (keys=#0'K') or (keys=#0'I') or (keys=#8) then ra:=smycka(ra-1,1,lalist)
      else if keys=#0'G' then ra:=1
      else if keys=#0'O' then ra:=lalist
      else ra:=smycka(ra+1,1,lalist)
     end;
  4: begin
      fillchar(mem[scrg:scro+6400],51200,0);
      fw('You can move your tank',15,40,29,8,scrg);
      fw('and dig the sand world.',15,50,29,8,scrg);
      fw('You may rub to the enemy',15,60,29,8,scrg);
      fw('base, refresh your',15,70,29,8,scrg);
      fw('energy and be waiting',15,80,29,8,scrg);
      fw('for enemy return.. and after',15,90,29,8,scrg);
      fw('that you can fire from',15,100,29,8,scrg);
      fw('a cannon of your tank.',15,110,29,8,scrg);
      fw('There can be up to 256',15,120,29,8,scrg);
      fw('projectils on a field.',15,130,29,8,scrg);
      fw('Remeber: If you are out',15,140,29,8,scrg);
      fw('of the bases then really',15,150,29,8,scrg);
      fw('EVERYTHING cost some energy.',15,160,29,8,scrg);
      fw(stri(ra)+'/'+stri(lalist),296,170,24,7,scrg);
      WRT; move(mem[scrg:scro],mem[$A000:0],64000);
      fillchar(mem[scrg:scro+6400],51200,0);
      repeat keys:=inkeys until keys<>'';
      if keys='' then break
      else if (keys=#0'H') or (keys=#0'K') or (keys=#0'I') or (keys=#8) then ra:=smycka(ra-1,1,lalist)
      else if keys=#0'G' then ra:=1
      else if keys=#0'O' then ra:=lalist
      else ra:=smycka(ra+1,1,lalist)
     end;
  5: begin
      fillchar(mem[scrg:scro+6400],51200,0);
      fw('Version 1.2 of this game',15,40,29,8,scrg);
      fw('brought a optionable keyboard',15,50,29,8,scrg);
      fw('delay (for the owners of',15,60,29,8,scrg);
      fw('faster computers) and mainly',15,70,29,8,scrg);
      fw('the playing-field-elements:',15,80,29,8,scrg);
      fw('(originally) yellow cells',15,90,29,8,scrg);
      fw('what gives full health',15,100,29,8,scrg);
      fw('and energy to all tanks and',15,110,29,8,scrg);
      fw('(originaly) dark gray highly',15,120,29,8,scrg);
      fw('explosive elements you can',15,130,29,8,scrg);
      fw('use as cartridges for tank.',15,140,29,8,scrg);
      fw('And finally, changing of the',15,150,29,8,scrg);
      fw('wall type and other modes.',15,160,29,8,scrg);
      fw(stri(ra)+'/'+stri(lalist),296,170,24,7,scrg);
      WRT; move(mem[scrg:scro],mem[$A000:0],64000);
      fillchar(mem[scrg:scro+6400],51200,0);
      repeat keys:=inkeys until keys<>'';
      if keys='' then break
      else if (keys=#0'H') or (keys=#0'K') or (keys=#0'I') or (keys=#8) then ra:=smycka(ra-1,1,lalist)
      else if keys=#0'G' then ra:=1
      else if keys=#0'O' then ra:=lalist
      else ra:=smycka(ra+1,1,lalist)
     end;
  6: begin
      fillchar(mem[scrg:scro+6400],51200,0);
      fw('There are two kinds of',15,40,29,8,scrg);
      fw('a victory. Winner either',15,50,29,8,scrg);
      fw('stayed last on a SandWorld',15,60,29,8,scrg);
      fw('or he did the most of',15,70,29,8,scrg);
      fw('his "work". You gain',15,80,29,8,scrg);
      fw('some points for moving,',15,90,29,8,scrg);
      fw('diging, firing and of',15,100,29,8,scrg);
      fw('course eliminating of your',15,110,29,8,scrg);
      fw('enemies. Therefore player,',15,120,29,8,scrg);
      fw('whose tactic is to stay at',15,130,29,8,scrg);
      fw('his base and wait for the',15,140,29,8,scrg);
      fw('last living enemy, will',15,150,29,8,scrg);
      fw('probably not gain too many',15,160,29,8,scrg);
      fw('points to be first.',15,170,29,8,scrg);
      fw(stri(ra)+'/'+stri(lalist),296,170,24,7,scrg);
      WRT; move(mem[scrg:scro],mem[$A000:0],64000);
      fillchar(mem[scrg:scro+6400],51200,0);
      repeat keys:=inkeys until keys<>'';
      if keys='' then break
      else if (keys=#0'H') or (keys=#0'K') or (keys=#0'I') or (keys=#8) then ra:=smycka(ra-1,1,lalist)
      else if keys=#0'G' then ra:=1
      else if keys=#0'O' then ra:=lalist
      else ra:=smycka(ra+1,1,lalist)
     end;
  7: begin
      fillchar(mem[scrg:scro+6400],51200,0);
      fw('I thing it''s not so',15,40,29,8,scrg);
      fw('difficult to control TUNEL.',15,50,29,8,scrg);
      fw('Use cursor arrows and <Enter>',15,60,29,8,scrg);
      fw('in menu to set the item',15,70,29,8,scrg);
      fw('you want to your desired',15,80,29,8,scrg);
      fw('value. F4 key gives you an',15,90,29,8,scrg);
      fw('opportunity to configure',15,100,29,8,scrg);
      fw('the keys, your tank will',15,110,29,8,scrg);
      fw('be controlled by and save',15,120,29,8,scrg);
      fw('all of it to a file.',15,130,29,8,scrg);
      fw('F5 key lets you create',15,140,29,8,scrg);
      fw('a pallette of 256 colours.',15,150,29,8,scrg);
      fw('F6 is Sound setup.',15,160,29,8,scrg);
      fw('(F7 is a "Boss-is-comming" key)',7,170,19,8,scrg);
      fw(stri(ra)+'/'+stri(lalist),296,170,24,7,scrg);
      WRT; move(mem[scrg:scro],mem[$A000:0],64000);
      fillchar(mem[scrg:scro+6400],51200,0);
      repeat keys:=inkeys until keys<>'';
      if keys='' then break
      else if (keys=#0'H') or (keys=#0'K') or (keys=#0'I') or (keys=#8) then ra:=smycka(ra-1,1,lalist)
      else if keys=#0'G' then ra:=1
      else if keys=#0'O' then ra:=lalist
      else ra:=smycka(ra+1,1,lalist)
     end;
  8: begin
      fillchar(mem[scrg:scro+6400],51200,0);
      fw('Well, that''s nearly all.',15,40,29,8,scrg);
      fw('I really don''t thing about',15,50,29,8,scrg);
      fw('brilliant TUNEL II because',15,60,29,8,scrg);
      fw('I have a lot of work at',15,70,29,8,scrg);
      fw('this time. If you want',15,80,29,8,scrg);
      fw('to send me a postcard',15,90,29,8,scrg);
      fw('write to the following',15,100,29,8,scrg);
      fw('address: U Akademie 1',15,110,29,8,scrg);
      fw('Prague 7, 170 00',15,120,29,8,scrg);
      fw('Czech republic.',15,130,29,8,scrg);
      fw('Enjoy Tunel with your',15,140,29,8,scrg);
      fw('friends on a very fast',15,150,29,8,scrg);
      fw('computer be well.',15,160,29,8,scrg);
      fw(stri(ra)+'/'+stri(lalist),296,170,24,7,scrg);
      WRT; move(mem[scrg:scro],mem[$A000:0],64000);
      fillchar(mem[scrg:scro+6400],51200,0);
      repeat keys:=inkeys until keys<>'';
      if keys='' then break
      else if (keys=#0'H') or (keys=#0'K') or (keys=#0'I') or (keys=#8) then ra:=smycka(ra-1,1,lalist)
      else if keys=#0'G' then ra:=1
      else if keys=#0'O' then ra:=lalist
      else ra:=smycka(ra+1,1,lalist)
     end;
  lalist:
     begin
      fillchar(mem[scrg:scro+6400],51200,0);
      fw('TUNEL, version '+verze,15,40,29,8,scrg);
      fw('requires PC AT 286 but rather',15,50,29,8,scrg);
      fw('at least 80386DX processor',15,60,29,8,scrg);
      fw('is strongly recommended. It',15,70,29,8,scrg);
      fw('also requires a VGA card',15,80,29,8,scrg);
      fw('and at least 112 kiloBytes',15,90,29,8,scrg);
      fw('of conventional memory.',15,100,29,8,scrg);
      fw('Sounds are only through',15,110,29,8,scrg);
      fw('PC Speaker, but music is',15,120,29,8,scrg);
      fw('supported by various',15,130,29,8,scrg);
      fw('sound cards. Support of',15,140,29,8,scrg);
      fw('other hardware should',15,150,29,8,scrg);
      fw('come with the next version',15,160,29,8,scrg);
      fw('(if you''ll write me details).',15,170,23,8,scrg);
      fw(stri(ra)+'/'+stri(lalist),296,170,24,7,scrg);
      WRT; move(mem[scrg:scro],mem[$A000:0],64000);
      fillchar(mem[scrg:scro+6400],51200,0);
      repeat keys:=inkeys until keys<>'';
      if keys='' then break
      else if (keys=#0'H') or (keys=#0'K') or (keys=#0'I') or (keys=#8) then ra:=smycka(ra-1,1,lalist)
      else if keys=#0'G' then ra:=1
      else if keys=#0'O' then ra:=lalist
      else ra:=smycka(ra+1,1,lalist);
      fillchar(mem[scrg:scro+6400],51200,0)
     end
  end; {case}
  if (GOdstin(0,1)>0) or (GOdstin(0,2)>0) or (GOdstin(0,3)>0) then pal(0,0,0,0)
 until false
end;
{}
function str3(n:longint):string;
begin if n>0 then str3:='+'+str2(n) else if n=0 then str3:=' '+str2(n) else str3:=str2(n) end;
{}
function enabstr(boo:boolean):string;
begin if boo then enabstr:='Enabled' else enabstr:='Disabled' end;
{}
procedure splsetup(scrg,scro,scrs:word; var loadsfx,sfxp,p:boolean; var sfxlng,sfxfst,sfxt,vol:byte);
const c_dev2:array[0..2] of string[12]=('No Sound','PC SPEAKER','SoundBlaster');
var sax:word; say:byte; ra:t_nibble;
begin
 fillchar(mem[scrg:scro+7040],51200,0);
 WRT; move(mem[scrg:scro],mem[$A000:0],scrs);
 if not(exist('tunelsfx.spl')) and loadsfx then loadsfx:=false;
 sfxfst:=smycka(sfxfst,0,200);
 sfxlng:=smycka(sfxlng,0,100);
 if p then sfxp:=false;
 fw('Loading     :'+enabstr(loadsfx),60,80,29,8,scrg);
 if sfxp then fw('Switched    :On',60,90,29,8,scrg)
 else fw('Switched    :Off',60,90,29,8,scrg);
 fw('Play through:'+c_dev2[sfxt],60,100,29,8,scrg);
 fw('Add speed   :'+str3(sfxfst-100),60,110,29,8,scrg);
 fw('Fire length :'+stri(sfxlng)+'%',60,120,29,8,scrg);
 fw('OK',60,130,29,8,scrg);
 WRT; move(mem[scrg:scro],mem[$A000:0],scrs); ra:=8;
 repeat
  for say:=ra*10 to ra*10+9 do
   for sax:=60 to 319 do
    if mem[$A000:say*320+sax]=29 then mem[$A000:say*320+sax]:=40;
  repeat keys:=inkeys until keys<>'';
  for say:=ra*10 to ra*10+9 do
   for sax:=60 to 319 do
    if mem[$A000:say*320+sax]=40 then mem[$A000:say*320+sax]:=29;
  if keys=#27 then break;
  if keys=#0'H' then ra:=smycka(ra-1,8,13);
  if keys=#0'P' then ra:=smycka(ra+1,8,13);
  if keys=#0'G' then ra:=8;
  if keys=#0'O' then ra:=13;
  if keys=#13 then
     case ra of
     8:  begin
          loadsfx:=not loadsfx;
          if not exist('tunelsfx.spl') then loadsfx:=false;
          if not loadsfx then sfxp:=false;
         end;
     9:  begin
          sfxp:=not sfxp;
          if p then sfxp:=false;
          if not(loadsfx) then
             begin
              if exist('tunelsfx.spl') then loadsfx:=true
              else loadsfx:=false;
              if sfxp and not(loadsfx) then sfxp:=false;
             end;
         end;
     10: sfxt:=smycka(sfxt+1,0,2);
     11: begin
          i:=asb(value(input4(stri(sfxfst),156,110,3,29,1,video)),0,200);
          sfxfst:=i+100
         end;
     12: sfxlng:=asb(value(input4(stri(sfxlng),156,120,3,29,1,video)),1,100);
     13: break;
     end;
  if keys=#0'K' then
     case ra of
     9:  begin
          sfxp:=not sfxp;
          if p then sfxp:=false;
          if not(loadsfx) then
             begin
              if exist('tunelsfx.spl') then loadsfx:=true
              else loadsfx:=false;
              if sfxp and not(loadsfx) then sfxp:=false;
             end;
         end;
     10: sfxt:=smycka(integer(sfxt-1),0,2);
     11: sfxfst:=smycka(sfxfst-1,0,200);
     12: sfxlng:=smycka(sfxlng-1,1,100);
     13: break;
     end;
  if keys=#0'M' then
     case ra of
     9:  begin
          sfxp:=not sfxp;
          if p then sfxp:=false;
          if not(loadsfx) then
             begin
              if exist('tunelsfx.spl') then loadsfx:=true
              else loadsfx:=false;
              if sfxp and not(loadsfx) then sfxp:=false;
             end;
         end;
     10: sfxt:=smycka(sfxt+1,0,2);
     11: sfxfst:=smycka(sfxfst+1,0,200);
     12: sfxlng:=smycka(sfxlng+1,1,100);
     13: break;
     end;
  if (GOdstin(0,1)>0) or (GOdstin(0,2)>0) or (GOdstin(0,3)>0) then pal(0,0,0,0);
  quad(164,80,96,50,0,scrg);
  fw(enabstr(loadsfx),164,80,29,8,scrg);
  if sfxp then fw('On',164,90,29,8,scrg)
  else fw('Off',164,90,29,8,scrg);
  fw(c_dev2[sfxt],164,100,29,8,scrg);
  fw(str3(sfxfst-100),164,110,29,8,scrg);
  fw(stri(sfxlng)+'%',164,120,29,8,scrg);
  WRT; move(mem[scrg:scro],mem[$A000:0],scrs);
 until false;
 if sfxt=2 then SetVolume(vol);
end;
{}
procedure tunbody(num:byte; scrg,scro:word);
var sax:word; say:byte;
begin
 case num of
 14: fw('Sorry, but I can''t save this Hi-Score.',10,160,28,8,$A000);
 21: begin
      fw('Player:',5,5,0,8,scrg);
      fw('Victories:',5,30,0,8,scrg);
      fw('Name:',5,45,0,8,scrg);
      fw('Points:',5,60,0,8,scrg);
      fw('Travelled:',5,75,0,8,scrg);
      fw('Exterminated:',5,90,0,8,scrg);
      fw('Fired:',5,105,0,8,scrg);
      fw('Hit:',5,120,0,8,scrg);
      fw('Energy lost:',5,135,0,8,scrg);
      fw('Survaved time:',5,150,0,8,scrg);
      fw('Place:',5,175,0,8,scrg)
     end;
 22: fw('File saved.',150,130,40,8,$A000);
 23: fw('File NOT saved.',150,130,40,8,$A000);
 24: fw('File loaded.',150,138,40,8,$A000);
 25: fw('File not found.',150,138,40,8,$A000);
 26: fw('File not found.',180,150,40,8,$A000);
 27: fw('File deleted.',180,160,40,8,$A000);
 28: fw('File NOT deleted.',180,160,40,8,$A000);
 29: fw('File not found.',180,160,40,8,$A000);
 31: begin
      fillchar(mem[scrg:scro],64000,0);
      for say:=0 to 19 do
       for sax:=0 to 319 do mem[scrg:scro+say*320+sax]:=random(4)+25;
      for say:=181 to 199 do
       for sax:=0 to 319 do mem[scrg:scro+say*320+sax]:=random(4)+25;
      fw('Sorry, Hi-Score can not be saved.',10,60,28,8,scrg);
      WRT; move(mem[scrg:scro],mem[$A000:0],64000); cekej(2000);
     end;
 32: begin
      for say:=0 to 19 do
       for sax:=0 to 319 do mem[scrg:scro+say*320+sax]:=random(4)+25;
      for say:=181 to 199 do
       for sax:=0 to 319 do mem[scrg:scro+say*320+sax]:=random(4)+25
     end;
 33: begin
      fillchar(mem[scrg:scro],64000,0);
      for say:=0 to 19 do
       for sax:=0 to 319 do mem[scrg:scro+say*320+sax]:=random(4)+25;
      for say:=181 to 199 do
       for sax:=0 to 319 do mem[scrg:scro+say*320+sax]:=random(4)+25;
      fw('Sorry, Hi-Score not found.',10,60,28,8,scrg);
      WRT; move(mem[scrg:scro],mem[$A000:0],64000); cekej(800)
     end;
 41: begin
      fillchar(mem[scrg:scro],64000,0);
      for say:=0 to 19 do
       for sax:=0 to 319 do mem[scrg:scro+say*320+sax]:=25+random(4);
      fw('OPTIONS-SFX',110,10,188,8,scrg);
      for say:=181 to 199 do
       for sax:=0 to 319 do mem[scrg:scro+say*320+sax]:=25+random(4)
     end;
 42: begin
      fw('F6 SFX config ',165,100,40,8,scrg);
      WRT; move(mem[scrg:scro],mem[$A000:0],64000)
     end;
 43: begin
      fw('Please write your message..',10,60,30,8,scrg);
      WRT; move(mem[scrg:scro],mem[$A000:0],64000)
     end;
 44: fw('Press any key to continue..',10,160,20,8,$A000);
 45: fw('Saving...',10,160,20,8,$A000);
 46: begin
      quad(10,160,72,8,0,$A000);
      fw('Saved.',10,160,20,8,$A000)
     end;
 51: begin
      fillchar(mem[scrg:scro],64000,0);
      for say:=0 to 19 do
       for sax:=0 to 319 do mem[scrg:scro+say*320+sax]:=25+random(4);
      fw('OPTIONS',125,10,188,8,scrg);
      for say:=181 to 199 do
       for sax:=0 to 319 do mem[scrg:scro+say*320+sax]:=25+random(4)
     end;
 52: begin
      fillchar(mem[scrg:scro],64000,0);
      for say:=0 to 19 do
       for sax:=0 to 319 do mem[scrg:scro+say*320+sax]:=25+random(4);
      for say:=181 to 199 do
       for sax:=0 to 319 do mem[scrg:scro+say*320+sax]:=25+random(4)
     end;
 53: begin
      fillchar(mem[scrg:scro],64000,0);
      for say:=0 to 19 do
       for sax:=0 to 319 do mem[scrg:scro+say*320+sax]:=25+random(4);
      fw('HI SCORES',80,25,189,8,scrg);
      for say:=181 to 199 do
       for sax:=0 to 319 do mem[scrg:scro+say*320+sax]:=25+random(4)
     end;
 61: begin
      fillchar(mem[scrg:scro],64000,0);
      for say:=0 to 19 do
       for sax:=0 to 319 do mem[scrg:scro+say*320+sax]:=25+random(4);
      fw('OPTIONS-GFX',110,10,188,8,scrg);
      for say:=181 to 199 do
       for sax:=0 to 319 do mem[scrg:scro+say*320+sax]:=25+random(4)
     end;
 62: begin
      fw('F5 GFX config ',165,80,40,8,scrg);
      WRT; move(mem[scrg:scro],mem[$A000:0],64000)
     end;
 63: begin
      fw('F9 options    ',165,120,40,8,scrg);
      WRT; move(mem[scrg:scro],mem[$A000:0],64000)
     end;
 72: begin
      fw('F1 Help       ',165,40,29,8,scrg);
      fw('F4 Edit keys  ',165,60,29,8,scrg);
      fw('F5 GFX config ',165,80,29,8,scrg);
      fw('F6 SFX config ',165,100,29,8,scrg);
      fw('F9 options    ',165,120,29,8,scrg)
     end;
 73: begin
      fillchar(mem[scrg:scro],64000,0);
      fw('WATCH OUT!',110,60,29,10,scrg);
      WRT; move(mem[scrg:scro],mem[$A000:0],64000);
      cekej(800);
      fillchar(mem[scrg:scro],64000,0);
      fw('BOSS IS COMING!',85,60,29,10,scrg);
      WRT; move(mem[scrg:scro],mem[$A000:0],64000);
      cekej(800);
      fillchar(mem[scrg:scro],64000,0);
      fw('DO SOMETHING!',95,60,29,10,scrg);
      WRT; move(mem[scrg:scro],mem[$A000:0],64000);
      cekej(800);
      fw('QUICKLY!',120,90,40,10,scrg);
      WRT; move(mem[scrg:scro],mem[$A000:0],64000);
      cekej(600);
      fillchar(mem[scrg:scro],64000,0)
     end;
 74: begin
      fillchar(mem[scrg:scro],64000,0);
      fw('IS THE BOSS OUT?',80,60,29,10,scrg);
      WRT; move(mem[scrg:scro],mem[$A000:0],64000);
      cekej(2000);
      fillchar(mem[scrg:scro],64000,0);
      fw('OK. LET''S GO ON!',80,60,29,10,scrg);
      WRT; move(mem[scrg:scro],mem[$A000:0],64000);
      cekej(1000);
      fillchar(mem[scrg:scro],64000,0)
     end;
 75: begin
      fw('Alt-X exits',15,170,40,8,$A000);
      cekej(100);
      fw('Alt-X exits',15,170,0,8,$A000)
     end;
 76: begin
      fw('Esc exits :)',15,170,40,8,$A000);
      cekej(100);
      fw('Esc exits :)',15,170,0,8,$A000)
     end;
 77: begin
      fillchar(mem[scrg:scro],64000,25);
      for say:=0 to 199 do
       for sax:=0 to 319 do
        mem[scrg:scro+say*320+sax]:=random(4)+26;
      fillchar(mem[scrg:scro+4800],320,0);
     end;
 80: begin
      fw('F4 Edit keys  ',165,60,40,8,scrg);
      WRT; move(mem[scrg:scro],mem[$A000:0],64000)
     end;
 81: begin
      fillchar(mem[scrg:scro],64000,0);
      for say:=0 to 19 do
       for sax:=0 to 319 do mem[scrg:scro+say*320+sax]:=25+random(4);
      fw('OPTIONS-keys',100,10,188,8,scrg);
      for say:=181 to 199 do
       for sax:=0 to 319 do mem[scrg:scro+say*320+sax]:=25+random(4)
     end;
 82: begin
      fw('Reset keys',40,120,29,8,scrg);
      fw('Save CFG',40,130,29,8,scrg);
      fw('Load CFG',40,140,29,8,scrg);
      fw('View Hi Scores',40,150,29,8,scrg);
      fw('Delete Hi Scores',40,160,29,8,scrg);
      fw('OK',40,170,29,8,scrg)
     end;
 83: begin
      quad(20,20,280,160,25,scrg);
      quad(20,20,2,159,27,scrg);
      quad(22,20,277,2,27,scrg);
      quad(21,178,279,2,23,scrg);
      quad(298,21,2,159,23,scrg);
      mem[scrg:scro+7019]:=25;
      mem[scrg:scro+57301]:=25;
      fw('Run-time debug',105,28,0,8,scrg);
      fw('Run-time debug',104,27,29,8,scrg);
      fillchar(mem[scrg:scro+16032],256,29);
     end;
 84: fw('Advanced options',96,10,189,8,scrg);
 85: fw('Ok',15,170,29,8,scrg);
 86: fw('OK',24,130,29,8,scrg);
 87: fw('World ready',165,140,29,8,scrg);
 88: fw('World NOT ready',165,140,29,8,scrg);
 89: fw('SandWorld ready',165,140,29,8,scrg);
 90: fw('SandWorld NOT ready',165,140,29,8,scrg);
 91: begin
      fillchar(mem[scrg:scro],64000,0);
      for say:=0 to 19 do
       for sax:=0 to 319 do mem[scrg:scro+say*320+sax]:=random(4)+25;
      for say:=181 to 199 do
       for sax:=0 to 319 do mem[scrg:scro+say*320+sax]:=random(4)+25;
      fw('HI SCORES',80,25,189,8,scrg)
     end;
 92: begin
      fw('Press any key..',100,188,23,8,scrg);
      WRT; move(mem[scrg:scro],mem[$A000:0],64000)
     end;
 95: begin
      fw('F1 Help       ',165,40,40,8,scrg);
      WRT; move(mem[scrg:scro],mem[$A000:0],64000)
     end;
 99: begin
      writeln('Dekujeme, ze jste si ns vsimli.');
      halt
     end
 end;
end;
{}
procedure powery(var p1,p2,p3,p4:boolean);
var f:text;
    zn:char;
    wi:word;
begin
 assign(f,'tunel.cfg');
 {$I+} reset(f); {$I-}
 if IOResult<>0 then
    begin
     p1:=true;
     p2:=true;
     p3:=true;
     p4:=true;
     exit;
    end;
 for wi:=1 to 792 do read(f,zn);
 readln(f);
 readln(f);
 for wi:=1 to 4 do read(f,zn);
 if zn>#0 then p1:=true else p1:=false;
 read(f,zn); if zn>#0 then p2:=true else p2:=false;
 read(f,zn); if zn>#0 then p3:=true else p3:=false;
 read(f,zn); if zn>#0 then p4:=true else p4:=false;
 close(f)
end;
{}
function loadpalfromcfg(name:string):boolean;
var f:text;
    sax,say:byte;
    zn:char;
begin
 loadpalfromcfg:=false;
 if lcase(paramstr(1))='/noload' then exit;
 if exist('tunel.cfg') then
    begin
     assign(f,'tunel.cfg');
     reset(f);
     for sax:=1 to 20 do read(f,zn);
     for say:=0 to 255 do
      for sax:=1 to 3 do
       begin
        read(f,char(i));
        case sax of
        1: pal(say,i,godstin(say,2),godstin(say,3));
        2: pal(say,godstin(say,1),i,godstin(say,3));
        3: pal(say,godstin(say,1),godstin(say,2),i);
        end;
       end;
     close(f);
     loadpalfromcfg:=true
    end
 else exit;
end;
{}
function quited:boolean;
var zn:char;
begin
 quad(88,10,144,8,0,$A000);
 fw('Quit really <Y/N>?',88,10,29,8,$A000);
 repeat
  zn:=getchar;
  if zn in ['y','Y','a','A','n','N','q','Q',#13,''] then break
 until false;
 case zn of
 'y','Y','a','A','q','Q',#13: quited:=true;
 'n','N','': quited:=false
 end
end;
{}
procedure PlaySound_sp(g,o,od,l2,ww:word); {pod PC Speakerem}
var loop:word; i:longint;
begin
 Port[67]:=$90; Port[97]:=Port[97] or 3;
 inline($FA); i:=od;
 repeat
   Port[66]:=amp[byte(ptr(g,o+i)^)];
   for loop:=0 to ww do;
   Port[66]:=amp[byte(ptr(g,o+i)^)];
   for loop:=0 to ww do;
   inc(i); if i>=od+l2 then break
 until false;
 inline($FB);
 Port[97]:=Port[97] and $FC; Port[67]:=$B6
end;
{}
procedure savetmp(flname:string);
var f:text;
    i:byte;
begin
 assign(f,flname);
 rewrite(f);
 for i:=0 to 255 do write(f,chr(GOdstin(i,1))+chr(GOdstin(i,2))+chr(GOdstin(i,3)));
 close(f)
end;
{}
procedure loadtmp(flname:string);
var f:text;
    i:byte;
    zn1,zn2,zn3:char;
begin
 if sizefile(flname)<>768 then exit;
 assign(f,flname);
 reset(f);
 for i:=0 to 255 do
  begin
   read(f,zn1);
   read(f,zn2);
   read(f,zn3);
   pal(i,ord(zn1),ord(zn2),ord(zn3))
  end;
 close(f)
end;
{}
procedure gfx_cfg(scrg,scro:word; scrs:longint; var wt4:byte; var mono:boolean);
var sax:word;
    ra,say,curb:byte;
    keys:string[2];
    f:text;
{                                      }
procedure resume_gfx;
begin
 if not loadpalfromcfg('tunel.cfg') then
    begin
     pal(3,0,50,50);
     pal(5,40,40,20);
     pal(6,45,45,25);
     pal(13,60,60,60);
     pal(9,0,20,63);
     pal(11,0,40,40)
    end;
 tunbody(61,scrg,scro);
 fw('Waiting for   :'+wtg4[wt4],40,40,29,8,scrg);
 fw('Color number  :'+stri(curb),40,60,29,8,scrg);
 fw('Red shade     :'+stri(GOdstin(curb,1)),40,80,29,8,scrg);
 fw('Green shade   :'+stri(GOdstin(curb,2)),40,90,29,8,scrg);
 fw('Blue shade    :'+stri(GOdstin(curb,3)),40,100,29,8,scrg);
 fw('Mode          :'+ismono[mono],40,110,29,8,scrg);
 fw('Restart',40,120,29,8,scrg);
 fw('OK',40,130,29,8,scrg);
 quad(192,55,30,20,curb,scrg);
 WRT; move(mem[scrg:scro],mem[video:0],scrs)
end;
{                                      }
procedure vysvit(boo:boolean);
var say:byte;
    sax:word;
begin
 case boo of
 false: for say:=ra*10 to ra*10+9 do
         for sax:=40 to 300 do
          if mem[video:say*320+sax]=40 then mem[video:say*320+sax]:=29;
 true:  for say:=ra*10 to ra*10+9 do
         for sax:=40 to 300 do
          if mem[video:say*320+sax]=29 then mem[video:say*320+sax]:=40
 end
end;
{                                      }
begin
 curb:=1;
 resume_gfx;
 ra:=4;
 vysvit(true);
 repeat
  repeat keys:=inkeys until keys<>'';
  vysvit(false);
  if (keys=#27) or (keys=#0'D') then exit;
  if keys=#0'H' then ra:=smycka(ra-1,4,13);
  if keys=#0'P' then ra:=smycka(ra+1,4,13);
  if (keys=#0'H') and (ra in [5,7]) then dec(ra);
  if (keys=#0'P') and (ra in [5,7]) then inc(ra);
  if keys=#13 then
     case ra of
     4:  wt4:=smycka(wt4+1,0,2);
     6:  begin
          curb:=value(input4(stri(curb),152,60,3,29,1,video));
          quad(192,55,30,20,curb,scrg)
         end;
     8:  begin
          sax:=asb(value(input4(stri(godstin(curb,1)),152,80,3,29,1,video)),0,63);
          pal(curb,sax,godstin(curb,2),godstin(curb,3))
         end;
     9:  begin
          sax:=asb(value(input4(stri(godstin(curb,2)),152,90,3,29,1,video)),0,63);
          pal(curb,godstin(curb,1),sax,godstin(curb,3))
         end;
     10: begin
          sax:=asb(value(input4(stri(godstin(curb,3)),152,100,3,29,1,video)),0,63);
          pal(curb,godstin(curb,1),godstin(curb,2),sax)
         end;
     11: begin
          mono:=not mono;
          if mono then
             begin
              savetmp(c_tmpname);
              setmono
             end
          else
             begin
              setcolorful;
              loadtmp(c_tmpname);
              delfile(c_tmpname)
             end
         end;
     12: begin
          inline($b8/$3/$00/$cd/$10/$b8/$13/$00/$cd/$10);
          resume_gfx;
          pal(3,0,50,50);
          pal(5,40,40,20);
          pal(6,45,45,25);
          pal(13,60,60,60);
          pal(9,0,20,63);
          pal(11,0,40,40)
         end;
     13: break
     end;
  if keys=#0'M' then
     case ra of
     4:  wt4:=smycka(wt4+1,0,2);
     6:  curb:=smycka(curb+1,0,255);
     8:  pal(curb,asb(godstin(curb,1)+1,0,63),godstin(curb,2),godstin(curb,3));
     9:  pal(curb,godstin(curb,1),asb(godstin(curb,2)+1,0,63),godstin(curb,3));
     10: pal(curb,godstin(curb,1),godstin(curb,2),asb(godstin(curb,3)+1,0,63));
     11: begin
          mono:=not mono;
          if mono then
             begin
              savetmp(c_tmpname);
              setmono
             end
          else
             begin
              setcolorful;
              loadtmp(c_tmpname);
              delfile(c_tmpname)
             end
         end;
     12: begin
          inline($b8/$3/$00/$cd/$10/$b8/$13/$00/$cd/$10);
          resume_gfx;
          pal(3,0,50,50);
          pal(5,40,40,20);
          pal(6,45,45,25);
          pal(13,60,60,60);
          pal(9,0,20,63);
          pal(11,0,40,40)
         end;
     13: break
     end;
  if keys=#0'K' then
     case ra of
     4:  wt4:=smycka(wt4-1,0,2);
     6:  curb:=smycka(curb-1,0,255);
     8:  pal(curb,asb(godstin(curb,1)-1,0,63),godstin(curb,2),godstin(curb,3));
     9:  pal(curb,godstin(curb,1),asb(godstin(curb,2)-1,0,63),godstin(curb,3));
     10: pal(curb,godstin(curb,1),godstin(curb,2),asb(godstin(curb,3)-1,0,63));
     11: begin
          mono:=not mono;
          if mono then
             begin
              savetmp(c_tmpname);
              setmono
             end
          else
             begin
              setcolorful;
              loadtmp(c_tmpname);
              delfile(c_tmpname)
             end
         end;
     12: begin
          inline($b8/$3/$00/$cd/$10/$b8/$13/$00/$cd/$10);
          resume_gfx;
          pal(3,0,50,50);
          pal(5,40,40,20);
          pal(6,45,45,25);
          pal(13,60,60,60);
          pal(9,0,20,63);
          pal(11,0,40,40)
         end;
     13: break
     end;
  if keys=#0'I' then
     case ra of
     4:  wt4:=smycka(wt4+1,0,2);
     6:  curb:=smycka(curb+16,0,255);
     8:  pal(curb,asb(godstin(curb,1)+16,0,63),godstin(curb,2),godstin(curb,3));
     9:  pal(curb,godstin(curb,1),asb(godstin(curb,2)+16,0,63),godstin(curb,3));
     10: pal(curb,godstin(curb,1),godstin(curb,2),asb(godstin(curb,3)+16,0,63));
     end;
  if keys=#0'Q' then
     case ra of
     4:  wt4:=smycka(wt4-1,0,2);
     6:  curb:=smycka(curb-16,0,255);
     8:  pal(curb,asb(godstin(curb,1)-16,0,63),godstin(curb,2),godstin(curb,3));
     9:  pal(curb,godstin(curb,1),asb(godstin(curb,2)-16,0,63),godstin(curb,3));
     10: pal(curb,godstin(curb,1),godstin(curb,2),asb(godstin(curb,3)-16,0,63));
     end;
  if keys=#0'G' then
     case ra of
     4:  wt4:=0;
     6:  curb:=0;
     8:  pal(curb,0,godstin(curb,2),godstin(curb,3));
     9:  pal(curb,godstin(curb,1),0,godstin(curb,3));
     10: pal(curb,godstin(curb,1),godstin(curb,2),0);
     end;
  if keys=#0'O' then
     case ra of
     4:  wt4:=2;
     6:  curb:=255;
     8:  pal(curb,63,godstin(curb,2),godstin(curb,3));
     9:  pal(curb,godstin(curb,1),63,godstin(curb,3));
     10: pal(curb,godstin(curb,1),godstin(curb,2),63);
     end;
  quad(160,40,128,130,0,scrg);
  fw(wtg4[wt4],160,40,29,8,scrg);
  fw(stri(curb),160,60,29,8,scrg);
  fw(stri(GOdstin(curb,1)),160,80,29,8,scrg);
  fw(stri(GOdstin(curb,2)),160,90,29,8,scrg);
  fw(stri(GOdstin(curb,3)),160,100,29,8,scrg);
  fw(ismono[mono],160,110,29,8,scrg);
  quad(192,55,30,20,curb,scrg); quad(0,21,319,19,0,scrg);
  WRT; move(mem[scrg:scro],mem[video:0],scrs);
  vysvit(true)
 until false
end;
{}
function loadspl(var spl:t_spl):boolean;
begin
 loadspl:=false;
 if not exist(c_splfname) then exit;
 loadspl:=LoadVOCFile(c_splfname,spl);
end;
{}
function reloadspl(var spl:t_spl):boolean;
begin
 if spl.d<>nil then unloadbuffer(spl);
 reloadspl:=loadspl(spl);
end;
{}
function GetMemBuffer(MemSize:word):pointer;
type tPtr=
     record
      case integer of
      0:(p:pointer);
      1:(Ofs_, Seg_:word)
      end;
var Dummy,Result:tPtr;
    a,d:longint;
begin
  Result.p:=nil;
  GetMem(Dummy.p,MemSize);
  if (Dummy.Ofs_<>0) or ((Dummy.Seg_ and $0FFF)<>0) then
  begin
    Result.Seg_:=(Dummy.Seg_ and $8000)+$1000;
    Result.Ofs_:=0;
    a:=longint(Dummy.Seg_) shl 4+Dummy.Ofs_;
    d:=longint(Result.Seg_) shl 4-a;
    FreeMem(Dummy.p,MemSize);
    GetMem(Dummy.p,word(d));
    GetMem(Result.p,MemSize);
    FreeMem(Dummy.p,word(d))
  end
  else Result.p:=Dummy.p;
  if ((Result.Seg_ and $0FFF)<>0) or (Result.Ofs_<>0) then Result.p:=nil;
  GetMemBuffer:=Result.p
end;
{}
procedure UnloadBuffer(var Sample:t_spl);
begin
  if SoundBoardAvailable then
  with Sample do
    if (d<>nil) and (s>0) then
    begin
      FreeMem(d,s);
      d:=nil;
      s:=0;
      sr:=0
    end
end;
{}
function LoadVOCFile(FileName:string;var Sample:t_spl):boolean;
type tHeader=
     record
      case integer of
        0:(IDText:array[0..19] of char;
           Data,Version,cVers:word);
        1:(b:array[0..25] of byte)
      end;
var
 f:file of byte;
 g:file;
 m,n,BlockType:byte;
 w:word;
 h:tHeader;
 FilePtr,BlockSize,i:longint;
 Ready,Closed,Result:boolean;
{                                      }
  function GetBlockSize:longint;
  var nn:byte; rr:longint;
  begin
    read(f,nn); rr:=nn;
    read(f,nn); rr:=rr+256*longint(nn);
    read(f,nn); GetBlockSize:=rr+65536*longint(nn)
  end;
{                                      }
function pridelpamet(kolik:word):pointer;
var l_buf:pointer;
begin
 pridelpamet:=nil;
 if kolik+c_rezerva>maxavail then exit;
 getmem(l_buf,kolik);
 pridelpamet:=l_buf
end;
{                                      }
begin
 if not exist(FileName) then
    begin
     LoadVOCFile:=false;
     exit
    end;
 with Sample do
 begin
   d:=nil;
   s:=0;
   SR:=0
 end;
 Result:=false;
 if (length(FileName)>0) and SoundBoardAvailable then
 begin
    assign(f,FileName);
    reset(f);
    if IOResult=0 then
    begin
      Closed:=false;
      seek(f,0);
      for n:=0 to SizeOf(tHeader)-1 do read(f,h.b[n]);
      for n:=0 to 19 do if h.IDText[n]=#$1A then h.IDText[n]:=#$00;
      if h.IDText='Creative Voice File'+#0 then
      begin
        FilePtr:=h.Data;
        Ready:=false;
        repeat
          seek(f,FilePtr);
          read(f,BlockType);
          case BlockType of
            0:Ready:=true;
            1:begin
                  BlockSize:=GetBlockSize-2;
                  read(f,n);
                  read(f,m);
                  if (BlockSize>0) and (n>0) and (m=0) then
                  begin
                    Sample.s:=wil(Blocksize,65528);
                    if maxavail<c_rezerva then exit;
                    Sample.s:=wil(maxavail-c_rezerva,Sample.s);
                    Sample.SR:=n;
                    Sample.d:=pridelpamet(Sample.s);
                    {Sample.d:=GetMemBuffer(Sample.s);}
                    if Sample.d<>nil then
                    begin
                      close(f); Closed:=true;
                      assign(g,FileName);
                      reset(g,1);
                      seek(g,FilePtr+6);
                      BlockRead(g,Sample.d^,Sample.s,w);
                      if w=Sample.s then Result:=true;
                      close(g)
                    end
                  end;
                  Ready:=true
                end;
            2:FilePtr:=FilePtr+GetBlockSize+4;
            3:FilePtr:=FilePtr+7;
            4:FilePtr:=FilePtr+6;
            5:FilePtr:=FilePtr+GetBlockSize+4;
            6:FilePtr:=FilePtr+6;
            7:FilePtr:=FilePtr+6;
            8:Ready:=true;
            9:Ready:=true;
           else Ready:=true
          end
        until Ready or (IOResult<>0)
      end;
      if not Closed then close(f)
    end
  end;
  LoadVocFile:=Result;

  assign(g,'result.tmp');
  FileMode:=1;
  rewrite(g,1);
  blockwrite(g,sample.d^,sample.s);
  close(g);
end;
{}
function GetMemVOCHandle(BufSize, SampleRate:word;var Sample:t_spl):boolean;
begin
  GetMemVOCHandle:=false;
  if (BufSize>0) and (BufSize<65529) and (SampleRate>0) and SoundBoardAvailable then
  begin
    Sample.d:=GetMemBuffer(BufSize);
    if Sample.d<>nil then
    begin
      Sample.s:=BufSize;
      Sample.SR:=256 - 1000000 div SampleRate;
      GetMemVOCHandle:=true
    end
  end
end;
{}
function SBInit(var BoardParams:tcfg):boolean; assembler;
asm
  push es
  les  bx,BoardParams   { Adresse der Kartenparameter in ES:BX }
  mov  cx,es:[bx]       { 1. Record-Variable (hier io) in CX }
  mov  dx,cx            { und CX }
  add  dx,6             { Index fr Reset-Register dazuaddieren }
  mov  al,1             { eine "1" auf Reset-Register ausgeben }
  out  dx,al
  xor  al,al            { ein bichen warten (mind. 3s) }
  @1:
  nop
  dec  al
  jnz  @1
  out  dx,al            { eine "0" auf Reset-Register ausgeben }
  mov  ax,2000h         { nochmal ein bichen warten }
  @2:
  nop
  dec  ax
  jnz  @2
  mov  dx,cx            { Status ermitteln }
  add  dx,14
  in   al,dx
  test al,80h           { Bit 7 gesetzt? }
  jz   @NotOk           { Sprung, wenn nein }
  mov  dx,cx            { zustzliche Prfung }
  add  dx,10            { aus dem DSP-Datenregister mu AAh gelesen werden }
  in   al,dx
  cmp  al,0AAh
  jne  @NotOk
  mov  ax,1             { Funktionsergebnis true }
  jmp  @Ready
  @NotOk:
  xor  ax,ax            { Funktionsergebnis false }
  @Ready:
  pop  es
end;
{}
procedure SBWrite(io:word; Data:byte); assembler;
asm
  mov  dx,io         { Basisadresse der Sound-Karte }
  add  dx,12         { Index fr Ausgaberegister hinzuaddieren }
  @1:
  in   al,dx         { Prfen, ob der DSP zur Datenaufnahme bereits ist }
  and  al,80h
  jnz  @1
  mov  al,[Data]     { Kommando bzw. Datenbyte ausgeben }
  out  dx,al
end;
{}
procedure SetIntProc(var BoardParams:tcfg; IntProc:pointer);
begin
  with BoardParams do
  begin
    if i<8 then
    begin   { IRQ 0..7 --> Int 8..15 }
      GetIntVec(i+$08,OrgInt);
      SetIntVec(i+$08,IntProc);
      Port[$21]:=Port[$21] and not(1 shl i)
    end
    else
    begin   { IRQ 8..15 --> Int 112..119 (AT) }
      GetIntVec(i+$68,OrgInt);
      SetIntVec(i+$68,IntProc);
      Port[$A1]:=Port[$A1] and not(1 shl (i-8))
    end
  end
end;
{}
procedure RestoreIntProc(var BoardParams:tcfg);
begin
  with BoardParams do
  begin
    if i<8 then
    begin
      SetIntVec(i+$08,OrgInt);               { IRQ 0..7 --> Int 8..15 }
      Port[$21]:=Port[$21] or (1 shl i)      { IRQ sperren }
    end
    else
    begin
      SetIntVec(i+$68,OrgInt);               { IRQ 8..15 --> Int 112..119 (AT) }
      Port[$A1]:=Port[$A1] or (1 shl (i-8))  { IRQ sperren }
    end
  end
end;
{}
{$F+}
procedure SndIntProc; interrupt;
var Status:byte;
begin
  Status:=Port[Board.a+14];
  Port[$20]:=$20;
  Port[$A0]:=$20;
  SBWrite(Board.a,$D3);
  RestoreIntProc(Board);
  IsPlaying:=false
end;
{$F-}
{}
procedure InitDMA(var BoardParams:tcfg;Buffer:pointer; BufSize:word);
type
  tPtr=record
           case integer of
           0:(p:pointer);
           1:(Ofs_, Seg_:word)
         end;
var b:tPtr; x:byte;
begin
  with BoardParams do
  begin
    Port[$0A]:=$04+d;
    Port[$0C]:=$00;
    Port[$0B]:=$48+d;
    Port[d shl 1]:=$00;
    Port[d shl 1]:=$00;
    dec(BufSize);
    Port[(d shl 1)+1]:=Lo(BufSize);
    Port[(d shl 1)+1]:=Hi(BufSize);
    b.p:=Buffer;
    case d of
      0:x:=$87;
      1:x:=$83;
      2:x:=$81;
      3:x:=$82
    end;
    Port[x]:=b.Seg_ shr 12;
    Port[$0A]:=d;
    Port[$08]:=$10
  end
end;
{}
procedure SetVolume(Value:byte);
begin
  with Board do
  begin
    Value:=Value shr 4;
    Value:=(Value shl 4)+Value;
    Port[a+4]:=$04;
    Port[a+5]:=Value
  end
end;
{}
function PlaySound_sb(g,o,w,hz:word):boolean;
{PlaySound_sb(seg(sple.d^),ofs(sple.d^),sple.s,sple.SR); prehrava pod SoundBlasterem}
begin
  PlaySound_sb:=false;
  if SoundBoardAvailable and (ptr(g,o)<>nil) and (w>0)
    and (not IsPlaying) then
  begin
    if SBInit(Board) then
    begin
      SetIntProc(Board,@SndIntProc);
      SBWrite(Board.a,$D1);
      SBWrite(Board.a,$40);
      SBWrite(Board.a,hz);
      InitDMA(Board,ptr(g,o),w);
      SBWrite(Board.a,$14);
      dec(w);
      SBWrite(Board.a,Lo(w));
      SBWrite(Board.a,Hi(w));
      IsPlaying:=true;
      PlaySound_sb:=true
    end
  end
end;
{}
function PlaySound_sb2(var Sample:t_spl):boolean;
var w:word;
begin
  PlaySound_sb2:=false;
  if SoundBoardAvailable and (Sample.d<>nil) and (Sample.s>0)
    and (not IsPlaying) then
  begin
    if SBInit(Board) then
    begin
      SetIntProc(Board,@SndIntProc);
      SBWrite(Board.a,$D1);
      SBWrite(Board.a,$40);
      SBWrite(Board.a,Sample.SR);
      InitDMA(Board,Sample.d,Sample.s);
      w:=Sample.s-1;
      SBWrite(Board.a,$14);
      SBWrite(Board.a,Lo(w));
      SBWrite(Board.a,Hi(w));
      IsPlaying:=true;
      PlaySound_sb2:=true
    end
  end
end;
{}
function sb_playing:boolean;
begin sb_playing:=IsPlaying end; {Jenom kvuli pristupu teto promenne}
{}
function PauseSound:boolean;
begin
  PauseSound:=false;
  if IsPlaying and (not IsPaused) then
  begin
    SBWrite(Board.a,$D0);
    IsPaused:=true;
    PauseSound:=true
  end
end;
{}
function RestartSound:boolean;
begin
  RestartSound:=false;
  if IsPlaying and IsPaused then
  begin
    SBWrite(Board.a,$D4);
    IsPaused:=false;
    RestartSound:=true
  end
end;
{}
function StopSound:boolean;
begin
  StopSound:=false;
  if IsPlaying then
  begin
    SBWrite(Board.a,$D0);
    SBWrite(Board.a,$D3);
    RestoreIntProc(Board);
    SBInit(Board);
    IsPlaying:=false;
    IsPaused:=false;
    StopSound:=true
  end
end;
{}
function findblaster(filename:string; var a,i,d,t:word):boolean;
{Pokusi se najit ze souboru nastaveni typu 'SET BLASTER=A220 I5 D1 T4'}
var f:text; veta:string;
{                                      }
 function GetSubStr(s:string; odkud:byte):string;
 var index:byte;
 begin
  s:=right(s,length(s)-odkud)+#0;
  for index:=1 to length(s) do
   if s[index] in ['0'..'9'] then break;
  s:=right(s,length(s)-index+1);
  for index:=1 to length(s) do
   if not(s[index] in ['0'..'9']) then break;
  s:=left(s,index-1);
  GetSubStr:=s;
 end;
{                                      }
 function hex2dec(s:string):word;
 var bi:byte;
 const wi:word=0;
 begin
  s:=lcase(s);
  if length(s)>4 then
     begin
      hex2dec:=$FFFF;
      exit;
     end;
  for bi:=1 to length(s) do
   if not(s[bi] in ['0'..'9','a'..'f']) then
      begin
       hex2dec:=0;
       exit;
      end
   else
      case s[bi] of
      '0'..'9': wi:=wi shl 4+(ord(s[bi])-ord('0'));
      'a'..'f': wi:=wi shl 4+(ord(s[bi])-ord('a'))
      end;
  hex2dec:=wi;
 end;
{                                      }
begin
 if filename='' then filename:='c:\autoexec.bat';
 assign(f,filename);
 reset(f);
 repeat
  readln(f,veta);
  veta:=lcase(veta);
  if veta[0]>#1 then
     begin
      while veta[1]=' ' do veta:=right(veta,length(veta)-1);
      while veta[length(veta)]=' ' do veta:=left(veta,length(veta)-1);
      if left(veta,4)<>'rem ' then
         if pos('set blaster',veta)>0 then
            begin
             veta:=right(veta,length(veta)-10-pos('set blaster',veta));
             a:=hex2dec(getSubStr(veta,pos('a',veta)));
             i:=value(getSubStr(veta,pos('i',veta)));
             d:=value(getSubStr(veta,pos('d',veta)));
             t:=value(getSubStr(veta,pos('t',veta)));
             close(f);
             if (pos('a',veta)>0) and (pos('i',veta)>0) and
                (pos('d',veta)>0) and (pos('t',veta)>0) then findblaster:=true
             else
                begin
                 findblaster:=true;
                 if (a=0) or (pos('a',veta)=0) then begin a:=$220; findblaster:=false end;
                 if (i=0) or (pos('i',veta)=0) then begin i:=5; findblaster:=false end;
                 if (d=0) or (pos('d',veta)=0) then begin d:=1; findblaster:=false end;
                 if (t=0) or (pos('t',veta)=0) then begin t:=4; end;
                end;
             exit;
            end;
     end;
 until eof(f);
 close(f);
 a:=$220; i:=5; d:=1; t:=4;
 findblaster:=false;
end;
{}
function LoadWAVFile(FileName:string; var Sample:t_spl):boolean;
const c_riffID=1179011410;
var g:file;
    LI:LongInt;
{                                      }
 function GetNumber(kde:longint; long:boolean):longint;
 var orig_seek:longint;
     number:array[0..3] of byte;
 begin
  orig_seek:=filepos(g);
  seek(g,kde);
  blockread(g,number,2+2*byte(long));
  if long then GetNumber:=word(number[0]+number[1])
  else GetNumber:=longint(number);
  seek(g,orig_seek);
 end;
{                                      }
begin
 if exist(filename) then
    begin
     LoadWavFile:=false;
     exit
    end;
 if (sample.d<>nil) and (sample.s>0) then
    freemem(sample.d,sample.s);
 with Sample do
 begin
   d:=nil;
   s:=0;
   sr:=0
 end;
 assign(g,filename);
 reset(g,1);
 seek(g,0);
 if (getnumber(0,true)<>c_riffID) or not(getnumber(22,false) in [1,2]) then
    begin
     {Kdyz nepozna hlavicku formatu WAV, pak nahraje cely soubor resp. prvnich
      64kB do buferu a bude doufat, ze je to 8-bitova SoundMapa. Pokud neni,
      pak uzivatel pravdepodobne prijde o usi.}
     sample.s:=wil(wil(filesize(g),65528),wig(0,maxavail-4096));
     sample.d:=getmembuffer(sample.s);
     blockread(g,sample.d^,sample.s);
     close(g);
     sample.sr:=211; {Nevim, jakou frekvenci je sampl nahran, volim 22050    (211 vznikne jako 256-1000000 div 22050)}
     LoadWAVFile:=true;
     exit;
    end;
 sample.s:=getnumber(4,true);
 if getnumber(22,false)=2 then
    begin
     {Kdyz je sample nahran ve stereu, prevede ho (aspon teda doufam) na mono}
     sample.s:=wil(getnumber(24+getnumber(16,true),true) div 2,65528);
     sample.s:=wil(sample.s,wil(maxavail-4095-byte(maxavail div 2=maxavail/2),0));
     sample.d:=getmembuffer(sample.s);
     for li:=24+getnumber(16,true) to filesize(g) do
      begin
       if filepos(g)+1>filesize(g) then break;
       mem[seg(sample.d^):ofs(sample.d^)]:=byte(getnumber(li,false) div 256);
       inc(li);
      end;
     sample.SR:=256-1000000 div getnumber(24,false);
     close(g);
     LoadWAVFile:=true;
     exit;
    end;
 sample.SR:=256-1000000 div getnumber(24,false);
 sample.s:=wil(getnumber(24+getnumber(16,true),true) div 2,65528);
 sample.s:=wil(sample.s,wil(maxavail-4095-byte(maxavail div 2=maxavail/2),0));
 sample.d:=getmembuffer(sample.s);
 blockread(g,sample.d^,sample.s);
 close(g);
 LoadWAVFile:=true;
end;
{}
function loadRAWFile(filename:string; var Sample:t_spl; hz:word):boolean;
var g:file;
    at:word;
begin
 if exist(filename) then
    begin
     LoadRAWFile:=false;
     exit
    end;
 if (sample.d<>nil) and (sample.s>0) then
    freemem(sample.d,sample.s);
 with Sample do
 begin
  d:=nil;
  s:=0;
  sr:=0
 end;
 assign(g,filename);
 Filemode:=0;
 GetFattr(g,at);
 setFattr(g,32);
 reset(g,1);
 sample.s:=filesize(g);
 sample.d:=getmembuffer(sample.s);
 seek(g,0);
 blockread(g,sample.d^,sample.s);
 setFattr(g,at);
 close(g);
 sample.sr:=hz;
 loadRAWFile:=true;
end;
{}
procedure intropic(faze:boolean);
const intropic1:array[1..2728] of byte=( {  124 x 22  }
      111,104,106,104,104,106,0,110,104,104,104,104,104,104,104,104,112,112,
      104,104,104,104,94,0,0,106,91,91,94,88,88,83,83,78,78,78,70,86,0,0,0,101,54,51,51,
      47,46,45,44,57,0,0,103,41,34,37,32,32,32,34,32,33,32,35,82,0,0,0,0,79,47,47,51,51,
      54,54,63,105,0,113,78,78,78,83,88,88,83,88,94,94,102,0,104,104,98,99,99,99,99,104,
      111,0,0,112,104,104,99,104,104,104,106,104,106,104,104,106,111,0,0,0,0,0,0,0,110,
      97,99,99,97,104,0,110,99,99,99,99,99,99,99,99,111,111,91,91,94,84,91,0,0,94,84,75,
      77,76,72,76,67,70,67,59,59,74,0,0,0,95,47,41,39,37,33,31,31,52,0,0,92,23,18,18,16,
      16,17,16,16,16,15,20,32,103,0,0,0,66,33,35,39,43,43,47,51,95,0,109,70,61,70,67,70,
      78,72,77,80,83,98,0,94,91,91,91,85,85,84,97,110,0,0,111,99,97,96,99,99,97,99,99,
      99,99,99,104,106,0,0,0,0,0,0,0,110,97,97,99,99,111,0,106,97,97,99,99,97,99,97,99,
      111,113,104,97,94,91,91,113,0,0,110,77,77,78,76,78,70,67,61,59,102,0,0,0,0,0,109,
      51,35,32,31,37,82,0,0,0,0,109,52,19,13,10,13,10,13,11,11,15,18,40,0,0,0,0,95,45,
      33,39,41,63,105,0,0,0,0,93,61,67,70,76,72,77,80,80,98,0,112,111,100,91,85,89,91,
      99,111,0,0,0,113,104,97,97,99,97,99,99,99,99,106,113,0,0,0,0,0,0,0,0,110,97,97,99,
      111,0,0,104,97,97,99,97,97,97,96,96,111,0,0,104,94,84,84,113,0,0,0,84,80,78,76,74,
      70,67,61,61,0,0,0,0,0,0,0,0,45,31,29,87,0,0,0,0,0,0,0,55,10,9,9,9,9,9,10,13,14,19,
      55,0,0,0,0,101,35,35,49,0,0,0,0,0,0,102,59,62,62,67,72,72,77,77,88,0,0,0,0,113,99,
      85,91,99,111,0,0,0,0,106,96,97,97,97,97,99,97,97,110,0,0,0,0,0,0,0,0,0,110,97,97,
      104,0,0,0,104,96,96,96,97,96,96,96,96,110,0,0,112,91,84,84,113,0,0,0,84,76,78,74,
      70,67,67,59,61,0,0,0,0,0,0,0,0,51,26,37,0,0,0,0,0,0,0,0,0,34,7,7,7,7,8,9,9,12,17,
      19,82,0,0,0,0,45,33,60,0,0,0,0,0,0,105,56,58,62,68,68,72,77,80,88,0,0,0,0,0,0,104,
      91,104,111,0,0,0,0,106,97,97,97,96,97,97,97,96,110,0,0,0,0,0,0,0,0,0,110,97,97,110,
      0,0,0,104,96,96,96,96,97,97,97,96,111,0,0,0,104,84,84,113,0,0,0,83,77,76,76,67,62,
      62,59,53,0,0,0,0,0,0,0,0,51,26,33,0,0,0,0,0,0,0,0,101,103,17,5,5,5,5,7,8,9,12,13,
      29,107,0,0,0,45,27,63,0,0,0,0,0,0,102,59,61,62,62,72,72,77,80,88,0,0,0,0,0,0,113,
      96,91,110,0,0,0,0,106,97,96,96,96,99,97,97,96,106,0,0,0,0,0,0,0,0,0,111,97,99,112,
      0,0,0,106,96,96,96,96,97,97,96,97,110,0,0,0,106,84,91,113,0,0,0,84,72,68,67,62,62,
      56,59,59,0,0,0,0,0,0,0,0,51,25,31,0,0,0,0,0,0,0,0,42,42,69,8,4,3,5,5,5,7,9,10,11,
      40,0,0,0,44,27,60,0,0,0,0,0,0,105,59,59,62,67,68,76,72,80,88,0,0,0,0,106,110,0,106,
      104,112,0,0,0,0,106,97,97,97,97,99,99,97,96,110,0,0,0,0,0,0,0,0,0,113,106,110,0,
      0,0,0,104,97,96,96,97,96,97,99,96,111,0,0,0,113,98,100,0,0,0,0,80,72,72,68,62,58,
      59,53,54,0,0,0,0,0,0,0,0,51,22,31,0,0,0,0,0,0,0,0,40,8,42,42,3,3,3,4,4,7,8,9,9,15,
      57,0,0,44,31,57,0,0,0,0,0,0,105,50,59,61,67,72,72,76,80,90,0,0,0,111,91,94,0,0,0,
      0,0,0,0,0,110,99,99,97,97,99,99,97,97,106,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,106,96,
      97,96,97,97,97,97,97,110,0,0,0,0,0,0,0,0,0,0,83,77,72,68,62,59,59,61,54,0,0,0,0,
      0,0,0,0,51,21,29,0,0,0,0,0,0,0,0,40,2,19,0,28,2,2,2,4,5,7,7,9,13,23,92,0,42,29,60,
      0,0,0,0,0,0,102,53,61,62,67,68,72,76,80,90,0,0,113,94,94,91,0,0,0,0,0,0,0,0,110,
      99,99,99,99,97,97,97,96,110,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,106,97,96,96,97,97,99,
      97,96,110,0,0,0,0,0,0,0,0,0,0,83,72,72,67,62,56,56,50,54,0,0,0,0,0,0,0,0,52,20,29,
      0,0,0,0,0,0,0,0,40,7,12,0,92,9,2,2,4,5,7,7,9,11,13,32,108,48,29,57,0,0,0,0,0,0,105,
      50,61,61,62,67,72,76,76,90,0,110,91,84,91,94,0,0,0,0,0,0,0,0,110,99,99,99,97,97,
      97,99,97,110,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,106,96,97,97,97,97,97,97,96,110,0,0,
      0,0,0,0,0,0,0,0,88,76,72,67,62,58,59,50,53,0,0,0,0,0,0,0,0,49,20,29,0,0,0,0,0,0,
      0,0,40,7,12,0,0,65,4,2,2,4,6,7,9,11,13,16,48,103,37,60,0,0,0,0,0,0,105,50,59,61,
      62,68,72,72,80,90,0,94,84,84,84,91,0,0,0,0,0,0,0,0,106,99,99,99,97,96,97,97,97,106,
      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,106,97,97,97,97,96,96,96,89,110,0,0,0,0,0,0,0,0,
      0,0,83,76,72,72,62,59,56,50,53,0,0,0,0,0,0,0,0,52,21,29,0,0,0,0,0,0,0,0,36,7,12,
      0,0,0,42,2,3,3,6,7,9,10,13,16,23,69,82,66,0,0,0,0,0,0,105,50,59,58,62,68,72,76,76,
      88,0,102,84,84,84,94,0,0,0,0,0,0,0,0,106,99,99,99,97,96,96,97,97,110,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,0,0,106,99,97,97,99,97,96,96,96,110,0,0,0,0,0,0,0,0,0,0,88,76,72,
      70,67,61,56,50,54,0,0,0,0,0,0,0,0,52,20,30,0,0,0,0,0,0,0,0,40,8,12,0,0,0,0,24,3,
      6,7,8,9,10,13,16,21,32,101,0,0,0,0,0,0,0,105,50,56,58,58,68,68,72,77,88,0,0,112,
      91,91,91,0,0,0,0,0,0,0,0,106,99,99,99,97,96,97,97,99,110,0,0,0,0,0,0,0,0,0,0,0,0,
      0,0,0,0,106,99,99,99,99,99,96,96,89,110,0,0,0,0,0,0,0,0,0,0,88,72,76,70,67,61,56,
      53,53,0,0,0,0,0,0,0,0,52,21,30,0,0,0,0,0,0,0,0,37,1,12,0,0,0,0,101,12,6,7,8,12,10,
      14,16,21,26,44,0,0,0,0,0,0,0,105,53,56,58,58,68,72,76,72,88,0,0,0,106,84,91,0,0,
      0,0,0,0,0,0,106,97,99,97,96,96,97,97,99,110,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,106,
      97,99,99,99,99,97,96,89,110,0,0,0,0,0,0,0,0,0,0,88,72,72,72,67,67,59,59,54,0,0,0,
      0,0,0,0,0,55,23,30,0,0,0,0,0,0,0,0,40,2,14,0,0,0,0,0,64,9,8,9,12,13,14,18,25,26,
      27,71,0,0,0,0,0,0,105,59,56,58,62,68,72,72,77,88,0,0,0,113,94,98,0,113,111,113,0,
      0,0,0,110,97,97,97,96,96,97,97,99,110,0,0,0,0,0,0,110,104,111,0,0,0,0,0,0,0,106,
      99,97,97,97,99,97,96,89,110,0,0,0,0,0,0,0,0,0,0,83,77,72,68,67,61,59,50,50,0,0,0,
      0,0,0,0,0,52,25,37,0,0,0,0,0,0,0,0,42,4,14,0,0,0,0,0,0,48,8,10,10,14,15,20,25,26,
      31,57,0,0,0,0,0,0,105,61,59,58,62,68,76,76,77,88,0,0,0,0,0,0,0,106,97,106,0,0,0,
      0,106,97,97,97,97,97,97,97,99,110,0,0,0,0,0,113,99,104,110,0,0,0,0,0,0,0,106,97,
      97,97,97,99,97,96,96,111,0,0,0,0,0,0,0,0,0,0,94,77,72,68,67,62,59,56,59,0,0,0,0,
      0,0,0,0,45,26,44,0,0,0,0,0,0,0,0,42,5,17,0,0,0,0,0,0,0,32,10,14,15,20,25,26,27,33,
      63,0,0,0,0,0,0,105,61,61,58,67,72,78,78,80,88,0,0,0,0,0,0,112,97,84,104,0,0,0,0,
      106,97,97,97,97,96,97,97,97,110,0,0,0,0,0,110,99,104,111,0,0,0,0,0,0,0,106,96,97,
      97,99,99,99,97,96,111,0,0,0,0,0,0,0,0,0,0,100,77,68,68,67,67,62,59,59,113,0,0,0,
      0,0,0,87,33,26,64,0,0,0,0,0,0,0,0,40,7,17,0,0,0,0,0,0,0,101,23,16,20,23,26,26,27,
      33,63,0,0,0,0,0,0,105,61,61,62,67,76,78,78,80,90,0,0,0,0,0,113,104,91,89,104,0,0,
      0,0,106,97,97,97,96,97,99,99,96,110,0,0,0,0,112,99,104,104,111,0,0,0,0,0,0,0,106,
      97,96,97,97,99,97,97,96,111,0,0,0,0,0,0,0,0,0,0,112,80,72,72,72,67,70,61,53,93,0,
      0,0,0,0,87,43,33,41,108,0,0,0,0,0,0,0,101,18,10,10,55,0,0,0,0,0,0,0,69,25,23,26,
      29,27,33,38,63,0,0,0,0,0,0,102,61,70,67,72,72,76,80,80,88,0,0,0,0,111,99,91,96,96,
      104,0,0,0,0,106,97,97,96,96,99,99,99,97,110,0,0,0,111,104,99,97,99,111,0,0,0,0,0,
      112,110,104,97,97,97,97,99,99,99,99,104,106,113,0,0,0,0,0,0,0,0,0,111,80,72,72,70,
      70,61,61,61,81,109,105,73,60,45,39,41,87,0,0,0,0,0,0,0,64,26,13,13,10,14,37,92,0,
      0,0,0,0,0,55,29,29,31,33,33,38,66,0,0,0,0,0,102,74,70,67,70,72,76,76,80,80,94,0,
      110,98,99,91,99,91,94,97,98,0,0,113,111,104,99,97,96,97,99,99,99,99,110,112,106,
      106,99,104,99,99,104,111,0,0,0,0,0,104,104,99,99,97,97,96,97,99,99,97,97,91,104,
      0,0,0,0,0,0,0,0,0,0,113,90,76,70,70,61,61,61,53,86,95,47,46,45,51,105,0,0,0,0,0,
      0,0,79,21,16,16,14,16,14,14,34,0,0,0,0,0,0,0,46,31,32,35,39,39,73,0,0,0,0,105,62,
      59,62,70,70,76,76,80,77,77,88,0,94,91,84,91,91,94,97,91,104,0,0,110,99,99,97,97,
      97,97,99,104,97,99,110,111,97,99,99,99,99,99,99,110,0,0,0,0,0,112,111,110,110,106,
      106,106,110,110,110,106,106,110,112,0,0,0,0,0,0,0,0,0,0,0,0,0,102,90,78,78,70,61,
      95,105,63,73,101,0,0,0,0,0,0,0,0,0,107,57,48,52,48,48,52,52,82,0,0,0,0,0,0,0,105,
      60,66,63,71,73,95,0,0,0,0,0,102,86,93,90,95,98,100,100,100,100,110,0,111,110,106,
      110,110,110,110,106,110,0,0,113,110,110,106,110,110,110,111,111,110,111,112,112,
      110,110,110,111,110,110,111,112);
      intropal1:array[0..354] of byte=(
      118,0,0,0,39,46,39,38,44,38,38,43,38,37,44,37,36,43,36,36,41,36,35,42,35,34,40,34,33,
      40,33,32,38,32,31,40,31,32,37,32,31,38,31,30,37,30,29,38,29,29,37,29,30,35,30,29,
      35,29,29,33,29,27,36,27,27,34,27,25,36,25,26,33,26,27,31,27,25,34,25,24,33,24,23,
      32,23,26,26,26,24,30,24,24,29,24,23,30,23,23,29,23,21,30,21,22,26,22,20,29,20,22,
      25,22,21,26,21,19,30,19,19,28,19,20,24,20,19,26,19,19,22,19,17,26,17,18,24,18,17,
      25,17,16,22,16,15,24,15,16,21,16,15,22,15,12,24,12,14,20,14,15,18,15,12,22,12,12,
      21,12,14,17,14,10,24,10,13,17,13,9,24,9,10,22,10,12,18,12,10,21,10,9,22,9,11,18,
      11,12,15,12,13,13,13,10,16,10,8,20,8,7,22,7,11,13,11,8,19,8,10,14,10,7,20,7,9,15,
      9,8,17,8,5,22,5,6,19,6,5,20,5,6,17,6,8,12,8,5,18,5,7,14,7,8,11,8,4,16,4,3,18,3,2,
      20,2,6,12,6,6,10,6,4,14,4,1,20,1,4,13,4,2,17,2,6,8,6,5,10,5,2,15,2,5,9,5,0,18,0,
      0,16,0,2,12,2,0,15,0,2,11,2,4,6,4,2,9,2,4,4,4,0,12,0,3,6,3,0,10,0,3,3,3,4,3,2,2,
      4,2,0,8,0,0,7,0,0,4,0,0,2,0,0,6,0,0,20,0,0,22,0,0,24,0);
var i,k:word; j:byte;
begin
 case faze of
 true:  begin
         if cur_mod<>$13 then setvga;
         for i:=0 to 255 do pal(i,0,0,0);
         for i:=1 to sizeof(intropic1) do
          pix(98+i mod 124,89+i div 124,ord(intropic1[i]),video);
         for j:=63 downto 0 do
          for i:=0 to ord(intropal1[0])-1 do
           begin
            pal(i,asb(integer(ord(intropal1[i*3+1])-j),0,63),
                  asb(integer(ord(intropal1[i*3+2])-j),0,63),
                  asb(integer(ord(intropal1[i*3+3])-j),0,63));
            for k:=1 to 400 do
           end
        end;
 false: begin
         for i:=1 to 2000 do if keyhit then break;
         for j:=0 to 63 do
          for i:=0 to ord(intropal1[0])-1 do
           begin
            pal(i,asb(integer(ord(intropal1[i*3+1])-j),0,63),
                  asb(integer(ord(intropal1[i*3+2])-j),0,63),
                  asb(integer(ord(intropal1[i*3+3])-j),0,63));
            for k:=1 to 400 do
           end;
         quad(50,50,220,100,0,video);
         if not loadpalfromcfg('tunel.cfg') then
            begin
             setvga;
             pal(3,0,50,50);
             pal(5,40,40,20);
             pal(6,45,45,25);
             pal(13,60,60,60);
             pal(9,0,20,63);
             pal(11,0,40,40)
            end
        end
 end
end;
{}
begin
 SoundBoardAvailable:=FindBlaster('',board.a,board.i,board.d,board.t)
end.