unit gif;                       {Header for gif.asm}

Interface
uses modexlib;                  {because of SetPal}
  var
  vram_pos,                     {current position in VGA-RAM}
  rest, errorno:word;           {remaining bytes in RAM and error}

  gifname:String;               {Name, including #0}
  Procedure LoadGif(GName:String);
                                {Loads Gif file "GName.gif" into vscreen}
  Procedure LoadGif_Pos(GName:String;Posit:Word);
                                {Loads Gif file at screen offset Posit}

Implementation
  Procedure ReadGif;external;   {custom Gif loader, complete in Assembler}
  {$l gif}

  Procedure LoadGif;
  {Loads Gif file "GName.gif" into vscreen}
  Begin
    If pos('.',gname) = 0 then  {add ".gif" extension if necessary}
      gname:=gname+'.gif';
    Gifname:=GName+#0;;         {generate ASCIIZ string}
    vram_pos:=0;                {start in VGA-Ram at Offset 0}
    ReadGif;                    {and load image}
    If Errorno <> 0 Then        {terminate if error}
      Halt(Errorno);
    SetPal;                     {set loaded palette}
  End;

  Procedure LoadGif_pos;
  {Loads Gif file at screen offset Posit}
  Begin
    If pos('.',gname) = 0 then  {add ".gif" extension if necessary}
      gname:=gname+'.gif';
    Gifname:=GName+#0;          {generate ASCIIZ string}
    vram_pos:=posit;            {start in VGA-Ram at passed offset}
    ReadGif;                    {and load image}
    If Errorno <> 0 Then        {terminate if error}
      Halt(Errorno);
    SetPal;                     {set loaded palette}
  End;
Begin
  errorno:=0;                   {normally no error}
  GetMem(VScreen,64000);        {allocate virtual screen}
End.
