Uses MyGraph;

Type
  FaceType = Array[0..28, 0..28] Of Byte;
  PFaceType = ^FaceType;

Var
  F : File;
  Face : PFaceType;

Procedure SetPix(X, Y : Word; C : Byte);

Var
  W : Word;

Begin
  W:=320*Y+X;
  Asm
    MOV  AX, 0A000H
    MOV  ES, AX
    MOV  DI, W
    MOV  AL, C
    MOV  CX, 1
    STOSB
  End;
End;

Procedure MCL2Screen(Var Face : PFaceType; XLoc, YLoc : Word);

Var
  X, Y : Word;

Begin
  For Y:=0 To 28 Do
    For X:=0 To 28 Do SetPix(XLoc+X, YLoc+Y, Face^[Y, X]);
End;

Begin
  Assign(F, ParamStr(1));
  Reset(F, 1);
  GetMem(Face, FileSize(F));
  BlockRead(F, Face^, FileSize(F));
  Close(F);
  InitGraphics($13);
  MCL2Screen(Face, 25, 55);
End.

