/*        display.c                                   */

/* Most of the new code for wanderer has been placed here.
   This file contains all the functions for the graphical
   user interface of wanderer. It contains functions for
   drawing on the screen, displaying status information,
   the menu selector corresponding to the function
   button F6 and creating audio special effects. Most
   of the interaction with the ALLEGRO game development
   package occurs here.
*/


#include "wand_hea.h"
#include <allegro.h>

/* files created by allegro/tools/dat from the *.dat files */
#include "wandat.h"   /* sprite definitions */
#include "fonts.h"    /* font   definition  */
#include "samples.h"  /* audio sample definitions */

int set_refresh =1;  /* signals whether to blit to screen or not */
int tile;
int active_spritebase; /* indicates the desired sprite database */ 
int signal_reload;   /* signal to game.c to load a new screen */

extern char lscreen[NOOFROWS][ROWLEN+1];  /* the level map */
extern char screen_name[61];
extern char *edit_memory, *memory_end;  /* for storing all key strokes */
extern int pause2;                     /* controls delays in playback */
extern int pause1;                     /* controls speed of falling blocks */
extern int debug_disp;            /* map or zoom mode */
extern int leveldir;              /* chooses between directories for levels */
extern int gamelevel;             /* desired starting level  */
extern int spritebase;            /* desired sprite database */
extern int playback_flag;         /* signals whether F5 button active */
extern int audio_flag;            /* signals whether audio is on or off */
extern int midi_flag;             /* signals whether midi is on or off */
extern char * screenpath;         /* path name to the level directory */
extern int midi_playing;          /* signals whether midi playing now */
extern int vga;			  /* signals svga or vga mode (1 or 2) */


DATAFILE *data;           /* sprites */
DATAFILE *datafonts;      /* font    */
DATAFILE *datasamples;    /* audio samples */

BITMAP *screen;
BITMAP *board;
BITMAP *control_bar;
MIDI   *music;

extern int nx,ny;   /* coordinates of explorer */
extern int levelnum;
int tilespace = 16;
int fontsel = font18;

show_cover()
{
BITMAP *cover;
RGB pall[256];
clear_to_color(screen,0);
cover = load_pcx("cover.pcx",pall);
set_pallete(pall);
blit(cover,screen,0,0,0,0,320,240);
destroy_bitmap(cover);
getch();
clear_to_color(screen,0);
}

create_bitmaps()
/* creates the bitmaps for storing the game level. */
/* We need board bitmap so we can zoom and scroll. */ 
/* The screen bitmap comes for free with ALLEGRO. */
{
board = create_bitmap(640,256);
if(board == NULL)
    {alert_crash("Not enough memory to create bitmap"); exit(0);}
control_bar = create_bitmap(640,40);
clear(board);
clear(control_bar);
}


load_datafiles()
{
/*  Load the Allgero datafile. These were created by */
/*  grabber and xspred.                              */
 if(vga == 2) 
   {
   fontsel = font9;
   tilespace = 8;
   }
 change_spritebase();
 datafonts = load_datafile("dat/fonts.dat");
 if(datafonts == NULL)
   {alert_crash("unable to load file fonts.dat"); exit(0);}
 datasamples = load_datafile("dat/samples.dat");
 if(data == NULL)
   {alert_crash("unable to load file wandspr0.dat"); exit(0);}
 if(datasamples == NULL) 
   {alert_crash("unable to load file samples.dat"); exit(0);}
 set_pallete(data[PAL].dat);
 active_spritebase=0;
}


change_spritebase()
{
/* This code permits flipping between the sprite databases */
unload_datafile(data);
 switch (spritebase)
  {
  case 0:
  if(vga == 2)
  data = load_datafile("dat/vgaspr0.dat");
  else
  data = load_datafile("dat/wandspr0.dat");
  break;

  case 1:
  if(vga == 2)
  data = load_datafile("dat/vgaspr1.dat");
  else
  data = load_datafile("dat/wandspr1.dat");
  break;
 
  default:
  if(vga == 2)
  data = load_datafile("dat/vgaspr1.dat");
  else
  data = load_datafile("dat/wandspr1.dat");
  }
if(data == NULL) alert_crash("Trouble loading wandspr* data.");
active_spritebase = spritebase;
}  


change_leveldir()
{
/* This code permits flipping between the level subdirectories */
switch (leveldir)
 {
  case 0:
  screenpath = "./easy";
  break;

  case 1:
  screenpath = "./screens";
  break;

  default:
  screenpath = "./screens";
  break;
  }
}


char * bar_str[7] = {"quit", "help", "about", "size", "restart",
 "playback","configure"};

make_control_bar()
{
/* Creates the bitmap of the control bar which appears on top of the      */
/* screen. The control bar is not mouse sensitive but is just informative */
/* to  the player.                                                        */
int i;
int width;
char str[32];
clear_to_color(control_bar,28);
text_mode(-1);
width=75+(vga-1)*15;
for (i=0;i<7;i++)
  {
  rectfill(control_bar,i*width/vga+1,1,(i+1)*width/vga-1
      ,38/vga-(vga-1)*2,24);
  line(control_bar,i*width/vga+2,2,(i+1)*width/vga-1,2,20);
  line(control_bar,i*width/vga+2,2,i*width/vga+2,38/vga-(vga-1)*2,20);
  if(i==0) sprintf(str,"ESC");
  else sprintf(str,"F%d",i);
  textout(control_bar,datafonts[fontsel].dat,str,i*width/vga+4,4,4);
  if (playback_flag || i != 5)
    textout(control_bar,datafonts[fontsel].dat,bar_str[i],i*width/vga+4
     ,21/vga,4);
  }
blit(control_bar,screen,0,0,80-40*vga,0,width*7/vga,40);
text_mode(0);
}

/* The next three functions display the board bitmap onto */
/* the screen in VGA (640 x 480) graphics; either in map  */
/* mode or zoom/scrolling mode.                           */

void refresh_board()
{
blit(board,screen,0,0,0,42/vga,640/vga,256/vga);
}


void refresh_scroll_board()
{
int scroll_x,scroll_y;
scroll_x = nx-10;
scroll_y = ny-10;
if(scroll_x <0) scroll_x =0;
if(scroll_y <0) scroll_y =0;
if(scroll_x>20) scroll_x= 20;
if(scroll_y>4)  scroll_y=4;
if(vga == 1)
  stretch_blit(board,screen,scroll_x*tilespace,scroll_y*tilespace,
    320,192,0,42,640,386);
else
  stretch_blit(board,screen,scroll_x*tilespace,scroll_y*tilespace,
    160,96,0,21,320,193);
}

void refresh_screen()
{
if(debug_disp) refresh_board();
else refresh_scroll_board();
}


void clear_remnant()
/* There is a little piece on the screen we have to clear when we */
/* switch from zoom mode back to map mode. This function is called*/
/* in game.c                                                      */
{
rectfill(screen,0,257/vga,639/vga,427/vga,0);
}


/* To provide variety there are different background tiles that
   we can use to represent free space. The tile is chosen based
   on the level number of the screen.
*/

int select_tile(level)
int level;
{
int i,itile;
i= level%5;

switch (i)
 {
 case 0:
  itile = ZTILE1;
  break;

 case 1:
  itile = ZTILE2;
  break;

 case 2:
  itile = ZTILE3;
  break;

 case 3:
  itile = ZTILE4;
  break;

 case 4:
  itile = ZTILE5;
  break;
  }
return itile;
}


void draw_object (y, x, glyph)
     int x, y;
     char glyph;
/* This function is used to modify the tile on the board bitmap. */
/* It is called in many places in game.c, fall.c and monsters.c. */ 
/* First we draw the background tile (representing free space).  */
/* In order to get a nice lattice we flip alternate tiles left to*/
/* right or up to down. Then we paste in transparent mode the    */
/* other sprites.                                                */
{
  int spr;
  int i,j,k;
  char str[4];
  i = x%2;
  j = y%2;
  k = i + (j<<1);
  switch (k)  /* for proper tesselation of tiles */
   {
   case 0:
   draw_sprite (board, data[tile].dat, x * tilespace, y * tilespace);
   break;

   case 1:
   draw_sprite_h_flip(board, data[tile].dat, x * tilespace, y * tilespace);
   break;

   case 2:
   draw_sprite_v_flip (board, data[tile].dat, x * tilespace, y * tilespace);
   break;

   case 3:
   draw_sprite_vh_flip (board, data[tile].dat, x * tilespace, y * tilespace);
   break;
   }

/* ARRIVE, ARROWR etc were defined in wandat.h             */
  switch (glyph)
    {
    case 'A':
      spr = ARRIVE;
      break;
    case '>':
      spr = ARROWR;
      break;
    case '<':
      spr = ARROWL;
      break;
    case 'S':
      spr = BABY_MONSTER;
      break;
    case '\\':
      spr = BACKSLASH;
      break;
    case '^':
      spr = BALLOON;
      break;
    case 'O':
      spr = BOULDER;
      break;
    case '+':
      spr = CAGE;
      break;
    case '*':
      spr = DIAMOND;
      break;
    case ':':
      spr = DUST;
      break;
    case 'X':
      spr = EXIT;
      break;
    case '@':
      spr = EXPLORER;
      break;
    case '!':
      spr = MINE;
      break;
    case 'M':
      spr = MONSTER;
      break;
    case '#':
      spr = ROCK1;
      break;
    case '=':
      spr = ROCK2;
      break;
    case '/':
      spr = SLASH;
      break;
    case 'T':
      spr = TELEPORT;
      break;
    case ' ':
      spr = BLANK;
      break;
    case 'C':
      spr = TIMECAPSULE;
      break;
    case 'B':
      spr = BOMB;
      break;
    case '~':
      spr = THINGY;
      break;
    default:
      text_mode(-1);
      spr = BLANK;
      sprintf(str,"%c",glyph);
      textout(board,datafonts[fontsel].dat,str,
        x*tilespace,y*tilespace,1);
      text_mode(1);
    }
  draw_sprite (board, data[spr].dat, x * tilespace, y * tilespace);
  if(set_refresh) refresh_screen();
}


void map (row_ptr)
char (*row_ptr)[ROWLEN + 1];
{
/* This function creates the whole board bitmap after we have */
/* loaded a new level or restarted the same level.            */
  int x, y;
  char ch;

  set_refresh=0;   /* we don't want to do a whole screen blit each */
                   /* time we call draw_object.                    */ 
  tile = select_tile(levelnum);
  for (y = 0; y < NOOFROWS; y++)
    {
    for (x = 0; x < ROWLEN; x++)
      {
	ch = row_ptr[y][x];
	draw_object (y, x, ch);
      }
    }
  refresh_screen();
}




void redraw_screen( maxmoves, num, score, nf, diamonds, mx, sx, sy, frow)
 
int  maxmoves, num, nf, diamonds, mx, sx, sy;
long score;
char (*frow)[ROWLEN+1];
{
char buffer[50];

clear_to_color(screen,0);

make_control_bar();

notify_screen_name(num,screen_name);

map(frow);
}

/*           NOTIFICATION AND ALERT FUNCTIONS       */


notify_screen_name(num,name)
int num;
char * name;
{
char str[80];
if ((name[0] == '#') || (name[0] == '\0'))
   sprintf(name,"no name            ");
sprintf(str,"screen %2d :%s",num,name);
rectfill(screen,0,440/vga,450/vga,458/vga,0);
textout(screen,datafonts[fontsel].dat,str,0,440/vga,4);
}


notify_score(score)
int score;
{
char str[30];
sprintf(str,"score=%4d  ",score);
textout(screen,datafonts[fontsel].dat,str,0,460/vga,4);
}


notify_diamonds(nf,diamonds)
int nf,diamonds;
{
char str[30];
sprintf(str,"diamonds=%3d/%-2d  ",nf,diamonds);
textout(screen,datafonts[fontsel].dat,str,130/vga,460/vga,4);
}


notify_maxmoves(moves)
int moves;
{
char str[30];
if(moves != -1)
sprintf(str,"%4d moves left   ",moves);
else
sprintf(str,"maxmoves=no limit");
textout(screen,datafonts[fontsel].dat,str,320/vga,460/vga,4);
}



/*              POPUP  WINDOWS                              */
/* The next three functions are used to send a message      */
/* via a popup window. The first function is fairly general */
/* and can be used sending warning messages, like file not  */
/* found. The other two functions have specific purposes.   */
 
alert_message(msg)
char *msg;
{
while (kbhit()) getch(); /* clear keyboard buffer */
rectfill(screen,100/vga,300/vga,400/vga+(vga-1)*30,360/vga,24);
text_mode(-1);
textout(screen,datafonts[fontsel].dat,msg,120/vga,320/vga,4);
textout(screen,datafonts[fontsel].dat,"Hit any key to continue"
    ,120/vga,340/vga,4);
getch();
rectfill(screen,100/vga,300/vga,400/vga+(vga-1)*30,360/vga,0);
text_mode(1);
}

alert_crash(msg)
char *msg;
{
while (kbhit()) getch(); /* clear keyboard buffer */
rectfill(screen,100/vga,300/vga,400/vga,360/vga,24);
text_mode(-1);
textout(screen,font,msg,120/vga,320/vga,4);
textout(screen,font,"Hit any key to continue",120/vga,340/vga,4);
getch();
rectfill(screen,100/vga,300/vga,400/vga,360/vga,0);
text_mode(1);
}


int alert_kill_status(msg)
char *msg;
{
char ch;
char str[60];
sprintf(str,"Killed by %s",msg);
rectfill(screen,300/vga,380/vga,570/vga+(vga-1)*40,460/vga,24);
text_mode(-1);
textout(screen,datafonts[fontsel].dat,str,310/vga,390/vga,4);
textout(screen,datafonts[fontsel].dat,"Press any key to continue."
  ,310/vga,420/vga,4);
textout(screen,datafonts[fontsel].dat,"ESC key exits the game."
  ,310/vga,435/vga,4);
rest(500);
text_mode(1);
while (kbhit()) getch(); /* clear keyboard buffer */
ch = getkey();
rectfill(screen,300/vga,380/vga,570/vga+(vga-1)*40,460/vga,0);
if (ch == 27) return 1;
else return 0;
}

char *congrat_msg1[] = {"Congratulations, you completed this level",
			"for the first time. The solution has been",
			"saved in the subdrectory solu. Please ",
			"e-mail the solutions to me."};

char *congrat_msg2[] = {"Congratulations, you found a better",
			"solution. It shall replace the old",
			"solution in the subdirectory solu." };


alert_congratulations(select)
int select;
{
int i;
rectfill(screen,200/vga,340/vga,575/vga+(vga-1)*30,425/vga,24);
text_mode(-1);
if(select == 0)
  for (i=0;i<4;i++)
   textout(screen,datafonts[fontsel].dat,congrat_msg1[i]
      ,205/vga,(350 + i*15)/vga,4);
else
  for (i=0;i<3;i++)
   textout(screen,datafonts[fontsel].dat,congrat_msg2[i]
     ,205/vga,(350 + i*15)/vga,4);

text_mode(0);
rest(2000);
getch();
rectfill(screen,200/vga,340/vga,575/vga+(vga-1)*30,425/vga,0);
}



/*     Unless you use the cntl-W, cntl-R keys for saving
       and restoring your solution files, you will not
       use this code. This code is here to maintain the
       old functions in the original wanderer code. It
       is also useful for testing and debugging.
*/ 
       


notify_message(msg)
char *msg;
{
  textout(screen,datafonts[fontsel].dat,msg,240/vga,380/vga,4);
}


clear_notify_message()
{
notify_message("                                   ");
}


/* entering textual information in ALLEGRO is a little
   tricky, because you can no longer depend on printf,
   scanf functions after switching to VGA mode. The
   falling function tries to mimic scanf for inputting
   a character string. (i.e support the rubout key.)
   It doesn't do a perfect job, but it is adequate.
*/
char readtext(str, size, ix, iy, col)
char *str;
int size;
int ix,iy,col;
{
/* read and echos char string input up to size letters */
/* ix,iy,col place and colour to echo string           */
    char *string;
    int count = 0;
    char ch;

    string = str;
    for (;;) {
	ch = getch();
	if (ch == 13) {
	    *str = '\0';
	    break;
	}

        if(ch==0) ch=getch();

	if ((ch == '\010') || (ch == 83)) {
	    if (count == 0)
		continue;
	    str--; count--;
            *str = ' ';
	    textout(screen,datafonts[fontsel].dat,string,ix,iy,col);
	    continue;
	}
	if (count == size) {
	    printf("\007");
            fflush(stdout);
	    continue;
	}
	*str = ch;
	str++; count++;
        *str = '\0';
        textout(screen,datafonts[fontsel].dat,string,ix,iy,col);
    }
}

/* The following 4 functions allow the user to specify the
   filename for saving, restoring game files and solution files.
   That is it provides supports for the R, S Cntl-R and Cntl-W
   commands available in wand330.zip. Now these commands are
   only used for diagnostics and debugging.
*/

save_game_file_name(name)
char *name;
{
notify_message("Save game file name:");
readtext(name,40,420 - (vga-1)*180, 380/vga,4);
rectfill(screen,240/vga,370/vga,580/vga,430/vga,0);
}

restore_game_file_name(name)
char *name;
{
notify_message("Restore game file name:");
readtext(name,40,430 - (vga-1)*190,380/vga,4);
rectfill(screen,240/vga,370/vga,580/vga,430/vga,0);
}


save_soln_file_name(name)
char *name;
{
notify_message("Save solution file name:");
readtext(name,40,420 - (vga-1)*180,380/vga,4);
rectfill(screen,240/vga,370/vga,580/vga,430/vga,0);
}

load_soln_file_name(name)
char *name;
{
notify_message("solution file name to load:");
readtext(name,40,440 - (vga-1)*185,380/vga,4);
rectfill(screen,240/vga,370/vga,580/vga,430/vga,0);
}


/*            AUDIO                            */


play_audio_sample(int n)
{
play_sample(datasamples[n].dat,150,55,1000,0);
}


/*            MIDI                            */

/* read the list of midi files in the file ./mids/index */

char midifiles[20][32];

int n_midi;

read_midis()
{
FILE *handle;
char buffer[32];
char *ret;
if(exists("./mids/index"))
  {
  n_midi=0;
  handle = fopen("./mids/index","rt");
  while(fgets(buffer,32,handle) && n_midi<20)
   {
   sscanf(buffer,"%s",midifiles[n_midi]);
//   printf("%s\n",midifiles[n_midi]);
   n_midi++;
   }
  }
}

load_and_play_midi()
{
char buffer[32],message[64];
if(midi_playing) destroy_midi(music);
sprintf(buffer,"./mids/%s",midifiles[(gamelevel-1) % n_midi]);
if(exists(buffer))
  {
  music = load_midi(buffer);
  play_midi(music,0);
  midi_playing=1;
  }
else
 {
  sprintf(message,"can't find %s",buffer);
  alert_message(message);
  midi_playing=0;
 }
}

switch_off_midi()
{
if(midi_playing) destroy_midi(music);
midi_playing =0;
}




/*      MENU SUPPORT FUNCTIONS              */

#define UP_ARROW 328
#define DOWN_ARROW 336
#define LEFT_ARROW 331
#define RIGHT_ARROW 333
#define ESC 27
#define CR 13

#define MENU_TOP 100
#define MENU_LEFT 100

char *menuheaders[7] =
{"level set", "sprites", "starting level",
 "animation", "playback" ,"audio", "music"};
char *menuhelp[7] =
{
 "Select directory for finding levels",
 "Select the set of sprites to use",
 "Begin game at this level",
 "Large numbers slow down animation",
 "Large numbers slow down playback",
 "Turn audio effects on or off",
 "Turn background music on or off "};


int menupar[7];


show_menu (int item)
{
  char string[20];
  int i;

  rectfill (screen, (MENU_LEFT+10)/vga, (MENU_TOP+ 20)/vga,
            (MENU_LEFT+ 320)/vga+(vga-1)*40, (MENU_TOP+ 180)/vga, 24);
  for (i = 0; i < 7; i++)
    {
      if (i == item)
	textout (screen, datafonts[fontsel].dat, menuheaders[i]
           ,(MENU_LEFT+20)/vga,(MENU_TOP+ 30 + 15 * i)/vga, 4);
      else
	textout (screen, datafonts[fontsel].dat, menuheaders[i],
           (MENU_LEFT+20)/vga, (MENU_TOP + 30 + 15 * i)/vga, 5);
    }
  if (menupar[0] == 0)
    textout(screen,datafonts[fontsel].dat,"training levels"
       ,(MENU_LEFT+160)/vga,(MENU_TOP+30)/vga,1);
  else 
    textout(screen,datafonts[fontsel].dat,"standard levels"
      ,(MENU_LEFT+160)/vga,(MENU_TOP+30)/vga,1);

  if (menupar[1] == 1)
    textout(screen,datafonts[fontsel].dat,"girl explorer"
      ,(MENU_LEFT+160)/vga, (MENU_TOP+30 + 15)/vga, 1);
  else
    textout(screen,datafonts[fontsel].dat,"baby explorer"
      ,(MENU_LEFT+160)/vga, (MENU_TOP+30 + 15)/vga, 1);

  sprintf(string,"%2d",menupar[2]);
  textout (screen, datafonts[fontsel].dat, string,
        (MENU_LEFT+160)/vga, (MENU_TOP+30 + 30)/vga , 1);

  sprintf(string,"%2d",menupar[3]);
  textout (screen, datafonts[fontsel].dat, string
      , (MENU_LEFT+160)/vga, (MENU_TOP+30 + 45)/vga , 1);

  sprintf(string,"%2d",menupar[4]);
  textout (screen, datafonts[fontsel].dat, string, 
     (MENU_LEFT+160)/vga, (MENU_TOP+30 + 60)/vga , 1);

  if(menupar[5]) 
    textout (screen, datafonts[fontsel].dat, "on", 
       (MENU_LEFT+160)/vga, (MENU_TOP+30 + 75)/vga , 1);
   else
    textout (screen, datafonts[fontsel].dat, "off", 
       (MENU_LEFT+160)/vga, (MENU_TOP+30 + 75)/vga , 1);

  if(menupar[6]) 
    textout (screen, datafonts[fontsel].dat, "on", 
       (MENU_LEFT+160)/vga, (MENU_TOP+30 + 90)/vga , 1);
   else
    textout (screen, datafonts[fontsel].dat, "off", 
       (MENU_LEFT+160)/vga, (MENU_TOP+30 + 90)/vga , 1);

  textout (screen, datafonts[fontsel].dat,
        menuhelp[item], (MENU_LEFT+20)/vga, (MENU_TOP+140)/vga, 6);
  textout (screen, datafonts[fontsel].dat, "Use arrow keys or ESC"
        ,(MENU_LEFT+20)/vga,(MENU_TOP+155)/vga,6);

}


menu_interface ()
{
  int item;
  int key_in;
  menupar[0] = leveldir;
  menupar[1] = spritebase;
  menupar[2] = gamelevel;
  menupar[3] = pause1;
  menupar[4] = pause2;
  menupar[5] = audio_flag;
  menupar[6] = midi_flag;
  item = 0;
  signal_reload = 0;
  text_mode (-1);
  show_menu (item);
  do
    {
      key_in = getkey();
      if (key_in == UP_ARROW && item > 0)
	item--;
      else if (key_in == DOWN_ARROW && item < 6)
	item++;
      else if (key_in == LEFT_ARROW)
        {
        if (item == 0)
           menupar[0] = 1- menupar[0];
        else if (item == 1)
           menupar[1] = 1 - menupar[1];
        else if (item == 2 && menupar[2] >1)
           menupar[2] -= 1;
        else if (item == 3 && menupar[3] >5)
           menupar[3] -= 5; 
        else if (item == 4 && menupar[4] >5)
           menupar[4] -= 5; 
        else if (item == 5) 
           menupar[5] = 1 - menupar[5]; 
        else if (item == 6) 
           menupar[6] = 1 - menupar[6]; 
        }
      else if (key_in == RIGHT_ARROW)
        {
        if (item == 0 )
           menupar[0] = 1 - menupar[0];
        else if (item == 1)
           menupar[1] = 1 - menupar[1];
        else if (item == 2 && menupar[2] < 60)
           menupar[2] += 1;
        else if (item == 3)
           menupar[3] += 5; 
        else if (item == 4)
           menupar[4] += 5; 
        else if (item == 5) 
           menupar[5] = 1 - menupar[5]; 
        else if (item == 6) 
           menupar[6] = 1 - menupar[6]; 
        }
      show_menu (item);
    }
   while (key_in != ESC && key_in != CR);
  text_mode(1);
  if(leveldir != menupar[0])
     {
     leveldir = menupar[0];
     change_leveldir();
     signal_reload = 1;
     }
  if (midi_flag != menupar[6])
    {
    if(menupar[6]) load_and_play_midi();
    else switch_off_midi();
    }

  if(menupar[2] != gamelevel) signal_reload = 1;

  leveldir = menupar[0];
  spritebase = menupar[1];
  gamelevel = menupar[2];
  pause1 = menupar[3];
  pause2 = menupar[4];
  audio_flag = menupar[5];
  midi_flag  = menupar[6];

  if (active_spritebase != spritebase)
    {
    change_spritebase();
    map(lscreen);
    }
}


