/*               m.c                       */

/*     This file contains the main program */

#include <stdio.h>
#include <string.h>
#include "wand_hea.h"
#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <allegro.h>
#include "wandat.h"



/* This structure will contain all the bitmaps and audio samples
   used by this game. The array is allocated and loaded by the allegro
   function load_datafile("wandspr.dat").
 */

extern char *playscreen();
extern int rscreen();
extern void map();
int err;
int debug_disp = 1;
char lscreen[NOOFROWS][ROWLEN+1];
int edit_mode = 0;
int saved_game = 0;
char *edit_screen = (char *) 0;
char *edit_memory = (char *) 0;
char *memory_end = (char *) 0;
char screen_name[61] ;
long dictsize = 0L;
int old_score=0;
int pause1 = 30; /* delay time for moving objects */
int pause2 = 80; /* delay time for playback */
int recording=0; /* need to link it also with fall.c */
int levelnum=1;
int leveldir = 1;
int gamelevel = 1;
int spritebase = 0;
int audio_flag = 1;
int midi_flag = 1;
int midi_playing =0;
int vga = 1;
char  *screenpath = "./screens";

int * newwin();

int readline(fd, ptr, max)
int fd, max;
char *ptr;
{
    int count = 0;
    while (read(fd,ptr,1) == 1) {
	if (++count == max)
	    break;
	if (*ptr=='\n')
	    break;
	ptr++;
    }
    *ptr = '\0';
    return count;
}


first_time()
{
char ans;
printf("The game is designed to run in SVGA mode (640 x 480 x 8).\n");
printf("Some video cards may not be able to run properly in SVGA mode\n");
printf("in this game. If it is unable to switch to SVGA mode, then this\n");
printf("game will revert to VGA mode (320 x 240 x 8) which is supported\n");
printf("by all graphics boards. However, in some systems the game may\n");
printf("crash on switching to SVGA mode. If this happens, then you should\n");
printf("start the game in VGA mode. When the program exits normally, it\n");
printf("create a file contained winallg.ini which indicates what mode\n");
printf("your system supports (see README files for details).\n\n");
printf("Do you wish to try the SVGA mode? Type y or n and press enter key:");
fflush(stdout);
scanf("%c",&ans);
rest(100);
if(ans == 'y') vga=1;
else vga=2;
}



/* read or write wandallg.ini which contains
   initialization parameters.
*/

char *tokens[] = {"level", "sprite", "audio", "pause1", "pause2"
                  ,"directory", "midi", "vga"};


write_ini()
{
FILE *handle;
handle = fopen("wandallg.ini","wt");
fprintf(handle,"%s=%d\n",tokens[0],gamelevel);
fprintf(handle,"%s=%d\n",tokens[1],spritebase);
fprintf(handle,"%s=%d\n",tokens[2],audio_flag);
fprintf(handle,"%s=%d\n",tokens[3],pause1);
fprintf(handle,"%s=%d\n",tokens[4],pause2);
fprintf(handle,"%s=%d\n",tokens[5],leveldir);
fprintf(handle,"%s=%d\n",tokens[6],midi_flag);
fprintf(handle,"%s=%d\n",tokens[7],vga);
fclose(handle);
}

read_ini()
{
FILE *handle;
char buffer[100];
char *param,*value,*ret;
int i;
if(exists("wandallg.ini"))
  {
  handle = fopen("wandallg.ini","rt");
  ret = buffer;
  do
   {
    ret = fgets(buffer,100,handle);
    if(!ret) break;
    param = strtok(buffer,"=");
    value = strtok(0," \n");
    for (i=0;i<7;i++)
      if(!strcmp(tokens[i],param)) break;
    switch (i)
     {
     case 0:
     gamelevel = atoi(value);
     levelnum = gamelevel;
     break;

     case 1:
     spritebase = atoi(value);
     break;

     case 2:
     audio_flag = atoi(value);
     break;

     case 3:
     pause1 = atoi(value);
     break;

     case 4:
     pause2 = atoi(value);
     break;

     case 5:
     leveldir = atoi(value);
     break;

     case 6:
     midi_flag = atoi(value);
     break;

     case 7:
     vga = atoi(value);
     if(vga>2) vga=2;
     if(vga<1) vga=1;
     break;

     default:
     break;
     }
    } while (ret);

  fclose(handle);
  change_spritebase();
  change_leveldir();
  }
else first_time();
}



/*          MAIN      PROGRAM            */


main(argc, argv)
int  argc;
char **argv;
{
    char (*frow)[ROWLEN+1] = lscreen;
    long score = 0;
    int fp,  maxmoves = 0, x, y;
    char howdead[25], buffer[100], *name, *keys, *dead;
    char c, *malloc();
    struct stat statbuf;
    int ier;
    extern MIDI *music;

    keys = (char *) 0;
    memory_end = edit_memory = malloc(EMSIZE * sizeof(char));
    while ((c = getopt(argc,argv,"01k:et:r:fmCcvs")) != -1)
	switch (c) {
	case 'v':
         printf("\nWANDERER Copyright (C) 1988 S. Shipway. Version %s.\n\n",VERSION);
 	 printf("Adapted for MSDOS and ALLEGRO package (using DJGPP).\n");
         printf("by seymour.shlien@crc.doc.ca\n");
 	 exit (0);


	default:
	    fprintf(stderr,"Usage: %s [ -v | -0 | -1 ] [ file ]\n",argv[0]);
	    exit(1);
	}



    name = "noname";

    if (!keys)
	if ((keys = (char *)getenv("NEWKEYS")) == NULL) {
	    keys = malloc(5);
 	    strcpy(keys,"kjhl");	    
	}



   read_ini();
   read_midis();


      /* Initialise Allegro Units */
  allegro_init ();
  install_timer();
  ier = install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, NULL);
  if (ier)
     {
     printf("%s\n\n",allegro_error);
     printf("An error occurred while attempting to install_sound.\n");
     printf("\n\nPress any key to continue.\n");
     getch();
     }
  set_volume(255, 255);

  ier = set_gfx_mode (GFX_MODEX, 320, 240, 0, 0);

  if(exists("cover.mid"))
   {
   music = load_midi("cover.mid");
   play_midi(music,0);
   }

  if(!exists("cover.pcx"))
    {
    printf("could not find file cover.pcx\n");
    getch();
    }
  else show_cover();



  play_midi(NULL,0);
  if(music) destroy_midi(music);
 
    /* Create Main Screen */
  if(vga == 1)
   {
   ier = set_gfx_mode (GFX_AUTODETECT, 640, 480, 0, 0);
   if(ier)
    {
    set_gfx_mode(GFX_TEXT,640,480,0,0);
     printf("%s\n\n",allegro_error);
    printf("The program was unable to switch to SVGA mode using your\n");
    printf("video adapter driver and running in MSDOS. It requires a\n");
    printf("screen 640 by 480 by 8 bits. A UniVBE drive may fix this\n");
    printf("problem.\n");
    printf("\n\nPress any key to continue in VGA mode.\n");
    getch();
    vga = 2;
    ier = set_gfx_mode (GFX_MODEX, 320, 240, 0, 0);
    }
   }

  create_bitmaps();
  load_datafiles();



/* MAIN PROGRAM HERE */
/* The main loop reads in screen (levelnum) and runs the
   playscreen game. The function playscreen returns the game
   status via the character array dead. There are 4 possible
   outcomes.
   1) The player completes the level and is ready for the
      next level.
   2) The player dies and may wish to retry the same level
      or quit.
   3) The player wishes to quit.
   4) The player wishes to restart the same level or start
      a different level.
   These outcomes are signalled by the contents of the char
   array, dead. If dead is NULL, then we restart with which
   ever level is specified in int variable levelnum. If dead is
   not null, then if dead[0] = '~', the level to be done
   next is specified; otherwise the player was killed and
   dead[] contains the postmortem.
*/
        recording = 1; /* always start recording unless in replay */
        if(midi_flag) load_and_play_midi();
	for (;;) {
	    if (rscreen(levelnum,&maxmoves)) {
		strcpy(howdead,"a non-existant screen");
                levelnum=1;
	//	break;
	    }
	    dead = playscreen(&levelnum,&score,maxmoves,keys);

	    if ((dead != NULL) && (*dead == '~'))  /* retry or do level num */
            {
		levelnum = (int)(dead[1]) - 1;
		dead = NULL;
	    }
	    if (dead != NULL) {     /* player died or wished to quit */
		strcpy(howdead,dead);
		if(alert_kill_status(howdead) == 1) break;
		else {levelnum--; score = old_score;}
                  /* decrement because it will be incremented below */
	    }
	    levelnum++; /* carry on with this level */
            gamelevel = levelnum;
	}
/* END OF MAIN PROGRAM */

    write_ini();
    ier = set_gfx_mode (GFX_TEXT, 640, 480, 0, 0);
    
    printf("WANDERER (C) 1988 S. Shipway. DJGPP MSDOS version by S.Shlien (1997).\n");
//    if (record_file != -1) close(record_file);
}

