Unit SBlaster;
{ Unit to init/deinit soundblaster and to play midi/digital sound }

interface

{$L MidPak}
{$L DigPak}
{$L MidAdv}
{$L MidAd}

Uses Dos,Crt,WinApi;

Type DPMIRegs = record
       edi,esi,ebp,reserv,ebx,edx,ecx,eax : LongInt;
       flags : Word;
       es,ds,fs,gs,ip,cs,sp,ss : Word;
     End;
     TSound = Record
       SoundOfs : Word;
       SoundSeg : Word;
       Len : Word;
       IsPlaying : ^Word;
       Freq : Word;
     End;

Procedure SetMidi(BaseAddr,Irq,DMA : Word);
{ This procedure !#MUST#! be called before InitMidi }
Procedure SetDigital(BaseAddr,Irq,DMA : Word);
{ This procedure !#MUST#! be called before InitDigital }
Procedure InitMidi;
Procedure RegisterXMidi(Midi : Word;Len : LongInt);
Procedure PlaySequence(Seq : Word);
Procedure SegueSequence(Seq,Act : Word);
Procedure MidiStop;
Procedure ResumePlaying;
Function SeqStatus(Seq : Word) : Word;
Function RelVolume : Word;
Procedure SetRelVolume(Vol : Word;Time : Word);
Procedure InitDigital;
Procedure MassageAudio(Snd : Word);
Procedure DigPlay1(Snd : Word);
Procedure DigPlay2(Snd : Word);
Procedure StopDigital;
Function IsDig : Boolean;
Procedure DoneMidi;
Procedure DoneDigital;

{ service procs only for pmode }
Function AllocSel(Base,Limit : LongInt) : Word;
Procedure GetM(Size : LongInt;Var Sel,Seg : Word);
Procedure FreeM(Sel : Word);
Procedure CallReal(Se,O : Word;Var Reg : DPMIRegs);

implementation
Type TMidPak = Array[0..13455] of byte;
     TDigPak = Array[0..4559] of byte;
     TMidAdv = Array[0..14742] of byte;
     TMidAd = Array[0..3621] of byte;
     TWord = Record Low,Hi : Byte; End;
     TLong = Record Low,Hi : Word; End;

Var
MidPakS,MidPakM : Word;
DigPakS,DigPakM : Word;
MidAdvS,MidAdvM : Word;
MidAdS,MidAdM : Word;

Procedure MidPak; far; external;
Procedure DigPak; far; external;
Procedure MidAd; far; external;
Procedure MidAdv; far; external;

Function AllocSel(Base,Limit : LongInt) : Word;
Type Long = record low,hi : Word; end;
Var R : Registers;
Sel : Word;
B,L : Long;
Begin
  B:=Long(Base);
  L:=Long(Limit);
  { begin allocating selector }
  R.ax:=0;
  R.cx:=1;
  Intr($31,R);
  If R.flags and fCarry<>0 then
  Begin
    Exit;
  End;
  sel:=R.ax;
  { end allocate selector }
  { begin setbase of selector }
  R.ax:=7;
  R.bx:=sel;
  R.cx:=B.Hi;
  R.dx:=B.Low;
  Intr($31,R);
  If R.flags and fCarry<>0 then
  Begin
    Exit;
  End;
  { end setbase of selector }
  { begin setlimit of selector }
  If Limit>$FFFFF then { selector limit greater than 1MB }
    Limit:=Limit or $FFF; { all selectors which are greater than 1MB
                            must be alligned to the last $FFF }
  L:=Long(Limit);
  R.ax:=8;
  R.bx:=sel;
  R.cx:=L.Hi;
  R.dx:=L.Low;
  Intr($31,R);
  If R.flags and fCarry<>0 then
    R.ax:=0;
  If R.ax=0 then
  Begin
    R.bx:=Sel;
    If Limit>$FFFFF then R.cx:=$80F2 else R.cx:=$00F2;
    R.ax:=9;
    Intr($31,R);
    If R.flags and fCarry<>0 then R.ax:=0;
  End;
  If R.ax=0 then
  Begin
    R.ax:=8;
    R.bx:=sel;
    R.cx:=L.Hi;
    R.dx:=L.Low;
    Intr($31,R);
    If R.flags and fCarry<>0 then
    Begin
      Exit;
    End;
  End;
  AllocSel:=Sel;
End;

Procedure CallReal(Se,O : Word;Var Reg : DPMIRegs);
Var R : Registers;
Begin
  FillChar(R,SizeOf(R),0);
  Reg.cs:=Se;
  Reg.ip:=O;
  R.es:=Seg(Reg);
  R.di:=Ofs(Reg);
  R.ax:=$301;
  Intr($31,R);
End;

Procedure GetM(Size : LongInt;Var Sel,Seg : Word);
Var A : LongInt;
Begin
  A:=GlobalDosAlloc(Size);
  Sel:=LoWord(A);
  Seg:=HiWord(A);
  If Sel=0 then Halt;
End;

Procedure FreeM(Sel : Word);
Begin
  GlobalDosFree(Sel);
End;

Procedure SetMidi(BaseAddr,Irq,DMA : Word);
Var MidPakP : ^TMidPak;
Begin
  MidPakP:=Ptr(MidPakS,0);
  MidPakP^[$106]:=TWord(BaseAddr).Low;
  MidPakP^[$107]:=TWord(BaseAddr).Hi;
  MidPakP^[$108]:=TWord(Irq).Low;
  MidPakP^[$109]:=TWord(Irq).Hi;
  MidPakP^[$10A]:=TWord(DMA).Low;
  MidPakP^[$10B]:=TWord(DMA).Hi;
End;

Procedure SetDigital(BaseAddr,Irq,DMA : Word);
Var DigPakP : ^TMidPak;
Begin
  DigPakP:=Ptr(DigPakS,0);
  DigPakP^[$106]:=TWord(BaseAddr).Low;
  DigPakP^[$107]:=TWord(BaseAddr).Hi;
  DigPakP^[$108]:=TWord(Irq).Low;
  DigPakP^[$109]:=TWord(Irq).Hi;
  DigPakP^[$10A]:=TWord(DMA).Low;
  DigPakP^[$10B]:=TWord(DMA).Hi;
End;

Procedure InitMidi;
Var Re : DPMIRegs;
R : Registers;
Begin
  FillChar(Re,SizeOf(Re),0);
  CallReal(MidPakM-$10,$200,Re);
  R.ax:=$710;
  R.bx:=MidAdvM;
  R.cx:=0;
  R.dx:=MidAdM;
  R.si:=0;
  Intr($66,R);
End;

Procedure RegisterXMidi(Midi : Word;Len : LongInt);
Var R : Registers;
Begin
  R.ax:=$704;
  R.cx:=Midi;
  R.bx:=0;
  R.si:=TLong(Len).Low;
  R.di:=TLong(Len).Hi;
  Intr($66,R);
End;

Procedure PlaySequence(Seq : Word); assembler;
Asm
  mov ax,$702
  mov bx,Seq
  int $66
End;

Procedure SegueSequence(Seq,Act : Word); assembler;
Asm
  mov ax,$703
  mov bx,Seq
  mov cx,Act
  int $66
End;

Procedure MidiStop; assembler;
Asm
  mov ax,$705
  int $66
End;

Procedure ResumePlaying; assembler;
Asm
  mov ax,$70B
  int $66
End;

Function SeqStatus(Seq : Word) : Word; assembler;
Asm
  mov ax,$70C
  int $66
End;

Function RelVolume : Word; assembler;
Asm
  mov ax,$70E
  int $66
End;

Procedure SetRelVolume(Vol : Word;Time : Word); assembler;
Asm
  mov ax,$70F
  mov bx,Vol
  mov cx,Time
End;

Procedure DoneMidi;
Var R : DPMIRegs;
Begin
  FillChar(R,SizeOf(R),0);
  CallReal(MidPakM-$10,$203,R);
  FreeM(MidPakS);
  FreeM(MidAdvS);
  FreeM(MidAdS);
End;

Procedure InitDigital;
Var Re : DPMIRegs;
R : Registers;
Begin
  FillChar(Re,SizeOf(Re),0);
  CallReal(DigPakM-$10,$200,Re);
  R.ax:=$6A0;
  R.dx:=1;
  Intr($66,R); { Set DPMI mode }
End;

Procedure DigPlay1(Snd : Word);
Var S : LongInt;
L,H : Word;
Begin
  S:=LongInt(Snd) shl 4;
  L:=TLong(S).Low;
  H:=TLong(S).Hi;
  Asm
    push H
    push L
    db $66; pop si
    mov ax,$688
    int $66
  End;
End;

Procedure MassageAudio(Snd : Word);
Var S : LongInt;
L,H : Word;
Begin
  S:=LongInt(Snd) shl 4;
  L:=TLong(S).Low;
  H:=TLong(S).Hi;
  Asm
    push ds
    push H
    push L
    db $66; pop si
    mov ax,$68A
{    mov ds,zsel}
    int $66
    pop ds
  End;
End;

Procedure DigPlay2(Snd : Word);
Var S : LongInt;
L,H : Word;
Begin
  S:=LongInt(Snd) shl 4;
  L:=TLong(S).Low;
  H:=TLong(S).Hi;
  Asm
    push ds
    push H
    push L
    db $66; pop si
    mov ax,$68B
{    mov ds,zsel}
    int $66
    pop ds
  End;
End;

Function IsDig : Boolean; assembler;
Asm
  mov ax,$689
  int $66
End;

Procedure StopDigital; assembler;
Asm
  mov ax,$68F
  int $66
End;

Procedure DoneDigital;
Var R : DPMIRegs;
Begin
  FillChar(R,SizeOf(R),0);
  CallReal(DigPakM-$10,$203,R);
  FreeM(DigPakS);
End;

Begin
  GetM(SizeOf(TMidPak),MidPakS,MidPakM);
  Move(Ptr(Seg(MidPak),Ofs(MidPak))^,Ptr(MidPakS,0)^,SizeOf(TMidPak));
  GetM(SizeOf(TMidAdv),MidAdvS,MidAdvM);
  Move(Ptr(Seg(MidAdv),Ofs(MidAdv))^,Ptr(MidAdvS,0)^,SizeOf(TMidAdv));
  GetM(SizeOf(TMidAd),MidAdS,MidAdM);
  Move(Ptr(Seg(MidAd),Ofs(MidAd))^,Ptr(MidAdS,0)^,SizeOf(TMidAd));
  GetM(SizeOf(TDigPak),DigPakS,DigPakM);
  Move(Ptr(Seg(DigPak),Ofs(DigPak))^,Ptr(DigPakS,0)^,SizeOf(TDigPak));
End.