'Autonomy 1.05
'Michael Adams Programming

'Declare variables
DIM SHARED Z AS INTEGER                          'Standard
DIM SHARED BL AS INTEGER                         'Used for loading
DIM SHARED WARCALL AS INTEGER                    'Used for inciting war
DIM SHARED W AS INTEGER                          'Temporary Variable
DIM SHARED TEMP AS LONG                          'Temporary Variable
DIM SHARED TEMP1 AS LONG                         'Temporary Variable
DIM SHARED TEMP2 AS LONG                         'Temporary Variable
DIM SHARED TEMP3 AS LONG                         'Temporary Variable
DIM SHARED TEMP4 AS LONG                         'Temporary Variable
DIM SHARED TEMP5 AS LONG                         'Temporary Variable
DIM SHARED TEMP7 AS INTEGER                      'Temporary Variable
DIM SHARED RNDEVENT(10) AS INTEGER               'What random event occured?
DIM SHARED EVENT(10) AS STRING                   'The report of the event
DIM SHARED EVENTRUN AS INTEGER                   'Did the EVENTS sub run?
DIM SHARED DELAY AS LONG                         'Delay counter
DIM SHARED DIFICIL AS LONG                       '# of AI cycles per turn
DIM SHARED SND AS INTEGER                        'Sound active?

'Identifying Vars.
DIM SHARED TURN AS INTEGER                       'Turn Number
DIM SHARED ACTIVE AS INTEGER                     'Active Player (Save/Load)
DIM SHARED CN(10) AS STRING                      'Country Name
DIM SHARED CP(10) AS STRING                      'Player Name
DIM SHARED CCC(10) AS INTEGER                    'Country Color
DIM SHARED CPC(10) AS INTEGER                    'Player Color
DIM SHARED CONTROL(10) AS INTEGER                'Who Controls
DIM SHARED STATUS(10) AS INTEGER                 'Control Status

  'Nation Vars.
DIM SHARED MORALE(10) AS LONG                    'Morale Factor
DIM SHARED TAXES(10) AS LONG                     'Tax Factor
DIM SHARED TAXED(10) AS LONG                     'Collected Taxes
DIM SHARED GROWTH(10) AS LONG                    'Growth Factor
DIM SHARED TECH(10) AS LONG                      'Technology Factor
DIM SHARED FREEDOM(10) AS LONG                   'Freedom Factor
DIM SHARED WIN(10) AS LONG                       '# of Wins
DIM SHARED LOSS(10) AS LONG                      '# of Battle Losses
DIM SHARED PEOPLE(10) AS LONG                    '# of People
DIM SHARED ECONOMY(10) AS LONG                   'Economic Rate
DIM SHARED MONEY(10) AS LONG                     'Amount of Money
DIM SHARED ARMY(10) AS LONG                      '# of Soldiers
DIM SHARED WEAPONS(10) AS LONG                   '# of Weapons
DIM SHARED AGENTS(10) AS LONG                    '# of Intellegence Agents

'Declare subroutines
DECLARE SUB INTRO ()
DECLARE SUB MAINMENU ()
DECLARE SUB GOODBYE ()
DECLARE SUB GAMEMENU ()
DECLARE SUB PLAYMENU (N AS INTEGER)
DECLARE SUB MAP ()
DECLARE SUB AI (N AS INTEGER)
DECLARE SUB CONTROLLER ()
DECLARE SUB EVENTS ()
DECLARE SUB STATC (N AS INTEGER)
DECLARE SUB LISTPLAYERS ()
DECLARE SUB WAR (N AS INTEGER)
DECLARE SUB SAVE ()
DECLARE SUB LOAD ()
DECLARE SUB VICTORY (N AS INTEGER)
DECLARE SUB CWAR (N AS INTEGER)

'Main program
CLEAR
        'Sound
WHILE TEMP1 < 1
CLS
LOCATE 4, 1: COLOR 10: PRINT "Sound"
LOCATE 6, 1: COLOR 15
PRINT "On"
PRINT "Off"
COLOR 14
LOCATE 6, 20: PRINT "2";
LOCATE 7, 20: PRINT "1";
LOCATE 11, 1: COLOR 15: INPUT "Enter sound option: ", TEMP6$
IF TEMP6$ <> "" THEN TEMP1 = TEMP1 + 1
SND = VAL(TEMP6$)
IF SND < 1 THEN SND = 1
IF SND > 2 THEN SND = 2
WEND
TEMP1 = 0

        'Delay Adjustment
TEMP1 = TIMER
TEMP2 = TEMP1 + 1
WHILE TIMER < TEMP2
DELAY = DELAY + 1
WEND
DELAY = DELAY * 2
TEMP1 = 0

        'Continue
SCREEN 12
CALL INTRO
CALL MAINMENU
END

'General corrections
ERRORPROC:
MORALE(N) = 1
RESUME NEXT

'For a SUB
Ignore:
RESUME NEXT

'For the LOAD subroutine
Badload:
BL = 1
CLS
LOCATE 4, 1: COLOR 4: PRINT "The file you have selected is not available!"
LOCATE 30, 1: COLOR 15: PRINT "Press ENTER to continue..."; : LA$ = INPUT$(1)
RESUME NEXT

SUB AI (N AS INTEGER)
LOCATE 10, 1: COLOR 15: PRINT "Player"; N; " (Computer) playing"
LOCATE 11, 1: PRINT "Turn: "; : LOCATE 11, 7: COLOR 14: PRINT TURN: COLOR 15

'Run it the # of times set in DIFICIL
FOR X = 1 TO DIFICIL

'Determine random event
RANDOMIZE TIMER
CRNDEVENT = (RND * 13)

'Make assumptions on necessity, ordered in priority

IF GROWTH(N) < 5 THEN CRNDEVENT = 6          'Increase technology for growth
IF ECONOMY(N) < 10 THEN CRNDEVENT = 8               'Country's economy is bad
IF ARMY(N) > 99 AND WEAPONS(N) < 99 THEN CRNDEVENT = 3    'Country needs arms
IF ARMY(N) < 101 THEN CRNDEVENT = 1                       'Country needs army
        'Invade
 IF ARMY(N) > 499 THEN
  IF WEAPONS(N) > 99 THEN CRNDEVENT = 12
 END IF
        'Hire Army
 IF CRNDEVENT = 1 THEN
 TEMP1 = (RND * 250)
 TEMP2 = TEMP1 * 1000
  IF TEMP2 < MONEY(N) THEN
  MONEY(N) = MONEY(N) - TEMP2
  ARMY(N) = ARMY(N) + TEMP1
  END IF
 END IF
        'Dismiss Army
 IF CRNDEVENT = 2 THEN
 TEMP1 = (RND * 250)
 TEMP2 = TEMP1 * 200
 MONEY(N) = MONEY(N) + TEMP2
 ARMY(N) = ARMY(N) - TEMP1
 END IF
        'Buy Weapons
 IF CRNDEVENT = 3 THEN
 TEMP1 = (RND * 250)
 TEMP2 = TEMP1 * 100
  IF TEMP2 < MONEY(N) THEN
  MONEY(N) = MONEY(N) - TEMP2
  WEAPONS(N) = WEAPONS(N) + TEMP1
  END IF
 END IF
        'Sell Weapons
 IF CRNDEVENT = 4 THEN
 TEMP1 = (RND * 250)
 TEMP2 = TEMP1 * 50
 MONEY(N) = MONEY(N) + TEMP2
 WEAPONS(N) = WEAPONS(N) - TEMP1
 END IF
        'Change Tax Rate
 IF CRNDEVENT = 5 THEN
 TAXA = CLNG(RND * 10)
 TAXB = CLNG(RND * 10)
 TAXC = TAXA - TAXB
 TAXES(N) = TAXES(N) + TAXC
 IF TAXES(N) < 1 THEN TAXES(N) = 1
 IF TAXES(N) > 100 THEN TAXES(N) = 100
 END IF
        'Technology Increase
 IF CRNDEVENT = 6 THEN
 TEMP1 = CLNG(RND * 1000000)
                'Sufficient money?
  IF TEMP1 < MONEY(N) THEN
  TEMP2 = TEMP1 / 100000: TECH(N) = TECH(N) + TEMP2
  MONEY(N) = MONEY(N) - TEMP1
  END IF
                'Sufficient money?
  IF TEMP1 = MONEY(N) THEN
  TEMP2 = TEMP1 / 100000: TECH(N) = TECH(N) + TEMP2
  MONEY(N) = MONEY(N) - TEMP1
  END IF
 END IF
        'Invest in Economy
 IF CRNDEVENT = 8 THEN
 TEMP1 = CLNG(RND * 100000)
                'Sufficient Funds?
  IF TEMP1 < MONEY(N) THEN
  TEMP2 = TEMP1 / 10000: ECONOMY(N) = ECONOMY(N) + TEMP2
  MONEY(N) = MONEY(N) - TEMP1
  END IF
                'Sufficient Funds?
  IF TEMP1 = MONEY(N) THEN
  TEMP2 = TEMP1 / 10000: ECONOMY(N) = ECONOMY(N) + TEMP2
  MONEY(N) = MONEY(N) - TEMP1
  END IF
 END IF
        'Hire Spies
 IF CRNDEVENT = 9 THEN
 TEMP1 = CLNG(RND * 5)
 TEMP2 = TEMP1 * 2500
                'Sufficient Funds?
  IF TEMP2 < MONEY(N) THEN
  AGENTS(N) = AGENTS(N) + TEMP1
  MONEY(N) = MONEY(N) - TEMP2
  END IF
                'Sufficient Funds?
  IF TEMP2 = MONEY(N) THEN
  AGENTS(N) = AGENTS(N) + TEMP1
  MONEY(N) = MONEY(N) - TEMP2
  END IF
 END IF
        'Fire Spies
 IF CRNDEVENT = 10 THEN
 TEMP1 = CLNG(RND * 5)
 TEMP2 = TEMP1 * 500
                'Sufficient Funds?
  IF TEMP1 < AGENTS(N) THEN
  AGENTS(N) = AGENTS(N) - TEMP1
  MONEY(N) = MONEY(N) + TEMP2
  END IF
                'Sufficient Funds?
  IF TEMP1 = AGENTS(N) THEN
  AGENTS(N) = AGENTS(N) - TEMP1
  MONEY(N) = MONEY(N) + TEMP2
  END IF
 END IF
       
       
       
        'Conduct Sabotage

 IF CRNDEVENT = 11 THEN
  WHILE TEMP < 1
  W = (RND * 10)
  IF CCC(W) <> CCC(N) THEN TEMP = 1
  WEND
 TEMP = AGENTS(W)

  'Agents available
 IF AGENTS(N) > 0 THEN
      'Enemy has less
  IF TEMP < AGENTS(N) THEN
  CLS
  RANDOMIZE TIMER
  TEMP1 = 0: TEMP1 = CLNG(RND * 4)
          'Kill people
   IF TEMP1 = 1 THEN
   TEMP2 = CLNG(PEOPLE(W) / 10)
   PEOPLE(W) = PEOPLE(W) - TEMP2
   END IF
          'Kill soldiers
   IF TEMP1 = 2 THEN
   TEMP2 = CLNG(ARMY(W) / 10)
   ARMY(W) = ARMY(W) - TEMP2
   END IF
          'Kill agents
   IF TEMP1 = 3 THEN
   TEMP2 = CLNG(AGENTS(W) / 10)
   AGENTS(W) = AGENTS(W) - TEMP2
   END IF
          'Cut tech factor by 1
   IF TEMP1 = 4 THEN
   TECH(W) = TECH(W) - 1
   END IF
  
    'Kill off your agents
   IF AGENTS(N) > 1 THEN
   CLS
   TEMP2 = 0
   ON ERROR GOTO ERRORPROC
   TEMP3 = CLNG(RND * 10): TEMP2 = CLNG(AGENTS(N) / TEMP3): AGENTS(N) = AGENTS(N) - TEMP2
   END IF
  END IF
 END IF
 END IF

       
       
        'Invasion
 IF CRNDEVENT = 12 THEN
                'Pick country to fight
 RANDOMIZE TIMER
 W = (RND * 10)
                'There aren't enough agents to report on enemy
  IF AGENTS(N) < AGENTS(W) THEN
  TEMP1 = CLNG(RND * 5)
  TEMP2 = TEMP1 * 2500
                        'Sufficient Funds?
   IF TEMP2 < MONEY(N) THEN
   AGENTS(N) = AGENTS(N) + TEMP1
   MONEY(N) = MONEY(N) - TEMP2
   END IF
                        'Sufficient Funds?
   IF TEMP2 = MONEY(N) THEN
   AGENTS(N) = AGENTS(N) + TEMP1
   MONEY(N) = MONEY(N) - TEMP2
   END IF
  END IF

                'There are enough agents to allow fight
  IF AGENTS(N) > AGENTS(W) THEN
   IF ARMY(N) > ARMY(W) THEN
   CALL CWAR(N)
   END IF
  END IF

 END IF

       
        'Coup d'Etat
 IF CRNDEVENT = 13 THEN
 RANDOMIZE TIMER
 W = (RND * 10)
 TEMP = AGENTS(W)

        'The country is not yours
  IF CCC(N) <> CCC(W) THEN
                'You have agents
   IF AGENTS(N) > 0 THEN
                        'The enemy has less
    IF TEMP < AGENTS(N) THEN
    CLS
    RANDOMIZE TIMER
    TEMP4 = (RND * 45): TEMP5 = 0
    IF TEMP4 = 15 THEN TEMP5 = 1
    IF TEMP4 = 30 THEN TEMP5 = 1
    IF TEMP4 = 45 THEN TEMP5 = 1
                                'Success?
     IF TEMP5 = 1 THEN
     CP(W) = CP(N)
     CPC(W) = CPC(N)
     CCC(W) = CPC(N)
     CONTROL(W) = CONTROL(N)
     STATUS(W) = STATUS(N)
     FREEDOM(W) = FREEDOM(N)
     TAXES(W) = TAXES(N)
     TECH(W) = TECH(N)
     END IF
 
    'Kill off your agents
    TEMP2 = 0
    ON ERROR GOTO ERRORPROC
    TEMP3 = CLNG(RND * 10): TEMP2 = CLNG(AGENTS(N) / TEMP3)
    AGENTS(N) = AGENTS(N) - TEMP2
    END IF
   END IF
  END IF
 END IF

NEXT X
END SUB

SUB CONTROLLER
DIM N AS INTEGER

'Reactivate Saved Game
 IF ACTIVE > 0 THEN
  TURN = Z
  FOR N = ACTIVE TO 10
   IF STATUS(N) = 1 THEN                                      'Human Turn
   CLS
   LOCATE 10: COLOR 15: PRINT "Player"; N; ", "; CP(N); ", ready to play?"
   LOCATE 30, 1: COLOR 15: PRINT "Press ENTER to continue..."; : LA$ = INPUT$(1)
   CALL PLAYMENU(N)                                           'Play Menu
   END IF
   IF STATUS(N) = 2 THEN CALL AI(N)                           'Comp. Turn
  CALL EVENTS                                                'Event Proc.
  NEXT N
 END IF

'Normal Play
FOR TURN = Z TO 32000
 FOR N = 1 TO 10
  GOSUB VICTOR                                                'Did game end?
  IF STATUS(N) = 1 THEN                                       'Human Turn
   CLS
   LOCATE 10: COLOR 15: PRINT "Player"; N; ", "; CP(N); " ready to play?"
   LOCATE 30, 1: COLOR 15: PRINT "Press ENTER to continue..."; : LA$ = INPUT$(1)
 
    'If the events routine ran at least once, report what happened
    IF EVENTRUN = 1 THEN
    CLS
    LOCATE 1, 1: COLOR 13: PRINT "Event Report"
    COLOR 15
    LOCATE 4, 1: PRINT "Population      :";
    LOCATE 5, 1: PRINT "Money           :";
    LOCATE 6, 1: PRINT "Economy         :";
    LOCATE 7, 1: PRINT "Technology Level:";
    LOCATE 8, 1: PRINT "Tax Rate        :";
    LOCATE 9, 1: PRINT "Army            :";
    LOCATE 10, 1: PRINT "Weapons         :";
    LOCATE 11, 1: PRINT "Agents          :";
    LOCATE 12, 1: PRINT "Growth Rate     :";
    LOCATE 14, 1: PRINT "Taxes collected:";
    COLOR 14
    LOCATE 4, 18: PRINT PEOPLE(N);
    LOCATE 5, 18: PRINT MONEY(N);
    LOCATE 6, 18: PRINT ECONOMY(N);
    LOCATE 7, 18: PRINT TECH(N);
    LOCATE 8, 18: PRINT TAXES(N);
    LOCATE 9, 18: PRINT ARMY(N);
    LOCATE 10, 18: PRINT WEAPONS(N);
    LOCATE 11, 18: PRINT AGENTS(N);
    LOCATE 12, 18: PRINT GROWTH(N);
    LOCATE 14, 18: PRINT TAXED(N);
    LOCATE 17, 1: COLOR 14: PRINT EVENT(N);
    LOCATE 30, 1: COLOR 15: PRINT "Press ENTER to continue..."; : LA$ = INPUT$(1)
    END IF

   CALL PLAYMENU(N)                                           'Play Menu
  END IF
 
    'Comp. Turn
  IF STATUS(N) = 2 THEN CALL AI(N)
 NEXT N
'Cycle war probability
IF WARCALL < 10 THEN WARCALL = WARCALL + 1
 IF WARCALL = 10 THEN
 TEMP7 = (RND * 10)
 W = (RND * 10)
 ARMY(TEMP7) = ARMY(TEMP7) + 150
 WEAPONS(TEMP7) = WEAPONS(TEMP7) + 25
 IF TEMP7 <> W THEN CALL CWAR(TEMP7)
 END IF
'Go to other stuff
CALL EVENTS                                                   'Event Proc.
       
        'Readjust Delay
TEMP1 = TIMER
TEMP2 = TEMP1 + 1
WHILE TIMER < TEMP2
DELAY = DELAY + 1
WEND
DELAY = DELAY * 2
TEMP1 = 0

NEXT TURN                                                     'Next Turn
EXIT SUB


'Did all the players get conquered?
VICTOR:
 IF CCC(1) = CCC(N) THEN
  IF CCC(2) = CCC(N) THEN
   IF CCC(3) = CCC(N) THEN
    IF CCC(4) = CCC(N) THEN
     IF CCC(5) = CCC(N) THEN
      IF CCC(6) = CCC(N) THEN
       IF CCC(7) = CCC(N) THEN
        IF CCC(8) = CCC(N) THEN
         IF CCC(9) = CCC(N) THEN
          IF CCC(10) = CCC(N) THEN
          CALL VICTORY(N)
          END IF
         END IF
        END IF
       END IF
      END IF
     END IF
    END IF
   END IF
  END IF
 END IF
RETURN

END SUB

SUB CWAR (N AS INTEGER)

'Inquire of the defender & setup for battle
RESULT = 0: TEMP = 0
GOSUB CICHECKA
EXIT SUB

'Invasion Control
CINVADE:
ON ERROR GOTO ERRORPROC
WARCALL = 0

        'Morale change
MORALE(N) = FREEDOM(N) + TECH(N) + WIN(N) + LOSS(N)
MORALE(W) = FREEDOM(W) + TECH(W) + WIN(W) + LOSS(W)
IF MORALE(N) < 1 THEN MORALE(N) = 1
IF MORALE(W) < 1 THEN MORALE(W) = 1

'Battle Display
 WHILE RESULT < 1
 GOSUB CBATTLE
 WEND
IF RESULT = 1 THEN GOSUB CLOST
IF RESULT = 2 THEN GOSUB CWON
RETURN

'Actual Battle
CBATTLE:
        'Is the defender helpless?
 IF ARMY(W) < 2 THEN RESULT = 2
        'Did either army collapse? Also corrects for negative soldiers.
  IF ARMY(N) < 1 THEN
  ARMY(N) = 0
  RESULT = 1
  END IF
  IF ARMY(W) < 1 THEN
  ARMY(W) = 0
  RESULT = 2
  END IF
        'Attack Power
 TEMP2 = CLNG(ARMY(N) + WEAPONS(N))
 TEMP3 = CLNG(TEMP2 / MORALE(N))
        'Defense Power
 TEMP4 = CLNG(ARMY(W) + WEAPONS(W))
 TEMP5 = CLNG(TEMP4 / MORALE(N))
        'Casualties
 ARMY(N) = CLNG(ARMY(N) - TEMP5)
 ARMY(W) = CLNG(ARMY(W) - TEMP3)
 WEAPONS(N) = CLNG(WEAPONS(N) - CLNG(TEMP5 / 10))
 WEAPONS(W) = CLNG(WEAPONS(W) - CLNG(TEMP3 / 10))
 PEOPLE(W) = CLNG(PEOPLE(W) - CLNG(TEMP5 / 8))
        'Correct for negative stuff
 IF ARMY(N) < 1 THEN ARMY(N) = 0
 IF ARMY(W) < 1 THEN ARMY(W) = 0
 IF WEAPONS(N) < 1 THEN WEAPONS(N) = 0
 IF WEAPONS(W) < 1 THEN WEAPONS(W) = 0
 IF PEOPLE(W) < 1 THEN PEOPLE(W) = 0
 CLS
 COLOR 14
 PRINT "Computer Invasion!"
 COLOR 15
 LOCATE 3, 1: PRINT "Name:"
 PRINT "# of People:"
 PRINT "# of Soldiers:"
 PRINT "# of Weapons:"
 PRINT "Technology Rating:"
 PRINT "Morale Rating:"
 COLOR 10
 LOCATE 3, 21: PRINT CN(N);
 LOCATE 4, 20: PRINT PEOPLE(N);
 LOCATE 5, 20: PRINT ARMY(N);
 LOCATE 6, 20: PRINT WEAPONS(N);
 LOCATE 7, 20: PRINT TECH(N);
 LOCATE 8, 20: PRINT MORALE(N);
 COLOR 13
 LOCATE 3, 41: PRINT CN(W);
 LOCATE 4, 40: PRINT PEOPLE(W);
 LOCATE 5, 40: PRINT ARMY(W);
 LOCATE 6, 40: PRINT WEAPONS(W);
 LOCATE 7, 40: PRINT TECH(W);
 LOCATE 8, 40: PRINT MORALE(W);
 FOR D = 1 TO DELAY: NEXT D
RETURN

'You won!
CWON:
        'Take over country
CP(W) = CP(N)
CPC(W) = CPC(N)
CCC(W) = CPC(N)
CONTROL(W) = CONTROL(N)
STATUS(W) = STATUS(N)
FREEDOM(W) = FREEDOM(N)
TAXES(W) = TAXES(N)
WIN(N) = WIN(N) + 1
LOSS(W) = LOSS(W) + 1
MONEY(N) = MONEY(N) + MONEY(W)
MONEY(W) = 0
TECH(W) = TECH(N)
        'Leave half of troops and weapons for defense
TEMP4 = ARMY(N) / 5: TEMP5 = WEAPONS(N) / 5
ARMY(N) = ARMY(N) - TEMP4: ARMY(W) = ARMY(W) + TEMP4
WEAPONS(N) = WEAPONS(N) - TEMP5: WEAPONS(W) = WEAPONS(W) + TEMP5
        'Initalize Map & Data Screen
CALL MAP
LINE (320, 410)-(639, 479), 0, BF
LINE (320, 410)-(639, 479), 15, B
COLOR 15: LOCATE 27, 42: PRINT "Turn:";
COLOR 14: LOCATE 27, 52: PRINT TURN;
COLOR 15: LOCATE 28, 42: PRINT "Player:";
COLOR 14: LOCATE 28, 52: PRINT CP(N);
COLOR 15: LOCATE 29, 42: PRINT "Country:";
COLOR 14: LOCATE 29, 52: PRINT CN(N);
FOR D = 1 TO DELAY * 15: NEXT D
RETURN

'You lost!
CLOST:
WIN(W) = WIN(W) + 1
LOSS(N) = LOSS(N) + 1
RETURN

'Check invasion limits
CICHECKA:
TEMP = 0
        'Is this your country?
 IF N = W THEN
 CLS
 TEMP = 1
 END IF
        'It's not your country
 IF N <> W THEN
                'Is the target invalid?
  IF N < 1 OR N > 10 THEN
  CLS
  TEMP = 1
  END IF
                'Is it already yours?
  IF CCC(N) = CCC(W) THEN
  CLS
  TEMP = 1
  END IF
  IF TEMP = 0 THEN GOSUB CICHECKB
 END IF
RETURN

'Check to see if target is a neighbor
CICHECKB:
        'Country 1
 IF N = 1 THEN
  IF W = 2 THEN GOSUB CINVADE
  IF W = 4 THEN GOSUB CINVADE
  IF W = 5 THEN GOSUB CINVADE
 END IF
        'Country 2
 IF N = 2 THEN
  IF W = 1 THEN GOSUB CINVADE
  IF W = 3 THEN GOSUB CINVADE
  IF W = 5 THEN GOSUB CINVADE
  IF W = 7 THEN GOSUB CINVADE
  IF W = 8 THEN GOSUB CINVADE
 END IF
        'Country 3
 IF N = 3 THEN
  IF W = 2 THEN GOSUB CINVADE
  IF W = 8 THEN GOSUB CINVADE
 END IF
        'Country 4
 IF N = 4 THEN
  IF W = 1 THEN GOSUB CINVADE
  IF W = 5 THEN GOSUB CINVADE
  IF W = 6 THEN GOSUB CINVADE
  IF W = 9 THEN GOSUB CINVADE
 END IF
        'Country 5
 IF N = 5 THEN
  IF W = 1 THEN GOSUB CINVADE
  IF W = 2 THEN GOSUB CINVADE
  IF W = 4 THEN GOSUB CINVADE
  IF W = 6 THEN GOSUB CINVADE
  IF W = 7 THEN GOSUB CINVADE
 END IF
        'Country 6
 IF N = 6 THEN
  IF W = 4 THEN GOSUB CINVADE
  IF W = 5 THEN GOSUB CINVADE
  IF W = 7 THEN GOSUB CINVADE
  IF W = 9 THEN GOSUB CINVADE
 END IF
        'Country 7
 IF N = 7 THEN
  IF W = 2 THEN GOSUB CINVADE
  IF W = 5 THEN GOSUB CINVADE
  IF W = 6 THEN GOSUB CINVADE
  IF W = 8 THEN GOSUB CINVADE
  IF W = 10 THEN GOSUB CINVADE
 END IF
        'Country 8
 IF N = 8 THEN
  IF W = 2 THEN GOSUB CINVADE
  IF W = 3 THEN GOSUB CINVADE
  IF W = 7 THEN GOSUB CINVADE
  IF W = 10 THEN GOSUB CINVADE
 END IF
        'Country 9
 IF N = 9 THEN
  IF W = 4 THEN GOSUB CINVADE
  IF W = 6 THEN GOSUB CINVADE
  IF W = 10 THEN GOSUB CINVADE
 END IF
        'Country 10
 IF N = 10 THEN
  IF W = 7 THEN GOSUB CINVADE
  IF W = 8 THEN GOSUB CINVADE
  IF W = 9 THEN GOSUB CINVADE
 END IF
RETURN

END SUB

SUB EVENTS
CLS
 FOR N = 1 TO 10

 'Note that this routine has been used
 EVENTRUN = 1

 'Conduct national growth and changes
 ON ERROR GOTO ERRORPROC

    'Morale Change
 MORALE(N) = FREEDOM(N) + TECH(N) + WIN(N) + LOSS(N)
 IF MORALE(N) < 1 THEN MORALE(N) = 1

    'Growth Rate
 GROWTH(N) = TECH(N) + MORALE(N)

    'Population Growth
 TEMP1 = CLNG(PEOPLE(N) / GROWTH(N))
 TEMP2 = CLNG(TEMP1 / 5)
 PEOPLE(N) = CLNG(PEOPLE(N) + TEMP2)

    'Economic Growth
 TEMP1 = CLNG(ECONOMY(N) / GROWTH(N))
 TEMP2 = CLNG(TEMP1 / 10)
 ECONOMY(N) = ECONOMY(N) + TEMP2

    'Taxing the people
 TEMP1 = PEOPLE(N) * ECONOMY(N)
 TEMP2 = TEMP1 * TAXES(N)
 TAXED(N) = CLNG(TEMP2 / 1000)
 MONEY(N) = MONEY(N) + TAXED(N)



 'Conducting random events
 RANDOMIZE TIMER
 EVENT(N) = ""
 RNDEVENT(N) = CLNG(RND * 30)
 RNDNUM = CLNG(RND * 1000)

    'Economic Boom
 IF RNDEVENT(N) = 5 THEN
 ECONOMY(N) = ECONOMY(N) + CLNG(RND * 30)
 EVENT(N) = "A Economic Boom has occured!"
 END IF
    'Economic Depression
 IF RNDEVENT(N) = 10 THEN
 ECONOMY(N) = ECONOMY(N) - CLNG(RND * 30)
 IF ECONOMY(N) < 0 THEN ECONOMY(N) = 0
 EVENT(N) = "An Economic Depression has occured!"
 END IF
    'Army Volunteers
 IF RNDEVENT(N) = 15 THEN
 ARMY(N) = ARMY(N) + RNDNUM
 EVENT(N) = STR$(RNDNUM) + " people have volunteered for the army!"
 END IF
    'Natural Disaster
 IF RNDEVENT(N) = 20 THEN
 ECONOMY(N) = ECONOMY(N) - 15
 PEOPLE(N) = PEOPLE(N) - 1000
 IF PEOPLE(N) < 0 THEN PEOPLE(N) = 0
 EVENT(N) = "A Natural Disaster has killed 1000 and hurt the economy!"
 END IF
    'Immigration
 IF RNDEVENT(N) = 25 THEN
 PEOPLE(N) = PEOPLE(N) + 1000
 EVENT(N) = "1000 new immigrants have arrived!"
 END IF
    'Army Deserters
 IF RNDEVENT(N) = 30 THEN
 ARMY(N) = ARMY(N) - RNDNUM
 IF ARMY(N) < 0 THEN ARMY(N) = 0
 EVENT(N) = STR$(RNDNUM) + " soldiers have deserted the army!"
 END IF

 NEXT N
END SUB

SUB GAMEMENU
      
        'Difficulty
WHILE TEMP1 < 1
CLS
LOCATE 4, 1: COLOR 10: PRINT "Difficulty (# of Computer Actions per Turn)"
LOCATE 6, 1: COLOR 15
PRINT "Very Hard"
PRINT "Hard"
PRINT "Average"
PRINT "Easy"
COLOR 14
LOCATE 6, 20: PRINT "40+";
LOCATE 7, 20: PRINT "30";
LOCATE 8, 20: PRINT "20";
LOCATE 9, 20: PRINT "10";
LOCATE 11, 1: COLOR 15: INPUT "Enter difficulty: ", TEMP6$
IF TEMP6$ <> "" THEN TEMP1 = TEMP1 + 1
DIFICIL = VAL(TEMP6$)
IF DIFICIL < 1 THEN DIFICIL = 1
WEND

'Call Map
CLS
CALL MAP
LOCATE 30, 1: COLOR 15: PRINT "Press ENTER to continue..."; : LA$ = INPUT$(1)

'Assign Players
FOR N = 1 TO 10
 CLS
  TEMP = 0
  WHILE TEMP < 1
  COLOR 6: PRINT "Player"; : COLOR 14: PRINT N;
  COLOR 6: PRINT "is a (H)uman or (C)omputer Player?"
  A$ = INPUT$(1): A$ = UCASE$(A$)
   IF A$ = "H" THEN
   INDICATE = 2
   TEMP = 1
   END IF
   TEMP3 = 0
  
   IF A$ = "C" THEN
   PRINT : PRINT
   COLOR 6: PRINT
   PRINT "-10: Communist"
   PRINT "-5 : Dictatoral"
   PRINT "0  : Balanced (Default)"
   PRINT "5  : Conservative Democracy"
   PRINT "10 : Progressive Democracy"
   COLOR 14: PRINT : INPUT "What will be the regime"; TEMP4
   IF TEMP4 < -10 THEN TEMP4 = 10
   IF TEMP4 > 10 THEN TEMP4 = 10
   FREEDOM(N) = TEMP4:
   INDICATE = 0
   TEMP = 1
   END IF
  WEND
    'Computer player
 IF INDICATE < 2 THEN
  CP(N) = "Computer"
  GOSUB FINDNAME
  INDICATE = 0
  CPC(N) = N + 2
  CONTROL(N) = N
  STATUS(N) = 2
 END IF
    'Human player
 IF INDICATE = 2 THEN
  INPUT "Your name "; CP(N)
  INPUT "Your country's name "; CN(N)
  IF CN(N) = "" THEN GOSUB FINDNAME
  INDICATE = 0
  CPC(N) = N + 2
  CONTROL(N) = N
  STATUS(N) = 1
 END IF
        'Seed Country
 CCC(N) = CPC(N)             'Set Colors
 TAXES(N) = 10               'Tax Factor
 GROWTH(N) = 1               'Growth Factor
 TECH(N) = 1                 'Technology Factor
 PEOPLE(N) = 10000           '# of People
 ECONOMY(N) = 100            'Economic Rate
 MONEY(N) = 100000           'Amount of Money
 WEAPONS(N) = 0              '# of Weapons
        'Display Current Map
 CLS
 CALL MAP
 LOCATE 30, 1: COLOR 15: PRINT "Press ENTER to continue..."; : LA$ = INPUT$(1)
NEXT N

'List Players
CALL LISTPLAYERS
LOCATE 30, 1: COLOR 15: PRINT "Press ENTER to continue..."; : LA$ = INPUT$(1)

'Intro
CLS
CALL MAP
IF SND = 2 THEN PLAY "MNT150L8O3D+.L16CL4<G+>CD+L2G+L8>C.L16<A+L4G+CDL2D+"
LOCATE 30, 1: COLOR 15: PRINT "Press ENTER to continue..."; : LA$ = INPUT$(1)

ACTIVE = 0: Z = 1
CALL CONTROLLER
EXIT SUB

'Make up names for unnamed & computer countries
FINDNAME:
IF N = 1 THEN CN(N) = "Northland"
IF N = 2 THEN CN(N) = "Siber"
IF N = 3 THEN CN(N) = "Islak"
IF N = 4 THEN CN(N) = "Nazhon"
IF N = 5 THEN CN(N) = "Centra"
IF N = 6 THEN CN(N) = "Turnica"
IF N = 7 THEN CN(N) = "Traiga"
IF N = 8 THEN CN(N) = "Eastland"
IF N = 9 THEN CN(N) = "Western Brogh"
IF N = 10 THEN CN(N) = "Eaibrogh"
RETURN

END SUB

SUB GOODBYE
CLS
NAME$ = "Goodbye"
FOR X = 1 TO 7
 TEMP6$ = MID$(NAME$, X, 1)
 FOR D = 1 TO DELAY: NEXT D
 LOCATE 10, 35 + X: COLOR X + 1: PRINT TEMP6$;
NEXT X
 IF SND = 2 THEN
 PLAY "T250A3B7C8F3"
 PLAY "T200A3B7C8F3"
 PLAY "T150A3B7C8F3"
 PLAY "T100A3B7C8F3"
 PLAY "                      "
 END IF
END
END SUB

SUB INTRO
'Creator Intro
CLS
NAME$ = "Michael Adams Programming presents......"
COL = 1
 FOR X = 1 TO 40
 TEMP6$ = MID$(NAME$, X, 1)
 FOR D = 1 TO DELAY: NEXT D
 LOCATE 10, 20 + X
 COL = COL + 1: IF COL = 16 THEN COL = 1
 COLOR COL: PRINT TEMP6$;
 NEXT X

'Intro Menu
CLS
NAME$ = "Autonomy"
 FOR X = 1 TO 8
 TEMP6$ = MID$(NAME$, X, 1)
 FOR D = 1 TO DELAY: NEXT D
 LOCATE 10, 35 + X: COLOR X + 1: PRINT TEMP6$;
 NEXT X
LOCATE 11, 25: COLOR 8: PRINT "Michael Adams Programming, 1998"
 IF SND = 2 THEN
 PLAY "T100A3B7C8F3"
 PLAY "T150A3B7C8F3"
 PLAY "T200A3B7C8F3"
 PLAY "T250A3B7C8F3"
 END IF
LOCATE 22, 1: COLOR 15: PRINT "Press ENTER to continue..."
LA$ = INPUT$(1)
END SUB

SUB LISTPLAYERS
'Player List
CLS
COLOR 10: PRINT "The Players"
FOR N = 1 TO 10
 LOCATE N + 2, 1: COLOR 14: PRINT N;
 LOCATE N + 2, 7: COLOR 15: PRINT CN(N);
 LOCATE N + 2, 30: COLOR CPC(N): PRINT CP(N);
NEXT N
END SUB

SUB LOAD

'Reset the load checker
BL = 0

'Filename
CLS
COLOR 10: PRINT "Load Game": PRINT
COLOR 15: INPUT "Directory of saved games (Blank = Current Dir.)"; DIR$
CLS
COLOR 10: PRINT "Load Game"
LOCATE 4, 1: COLOR 14: PRINT "Saved games in current directory..."
DIRB$ = "C:\COMMAND.COM /C" + " DIR " + DIR$ + "*.SAV /B"
LOCATE 5, 1: COLOR 15: SHELL DIRB$
LOCATE 20, 1: COLOR 15
INPUT "What file would you like to load from (Don't include .SAV)"; TEMP6$
IF TEMP6$ = "" THEN EXIT SUB
TEMP6$ = DIR$ + UCASE$(TEMP6$) + ".SAV"

'Load the game

 ON ERROR GOTO Badload                 'If file dosen't load, it'll exit sub
 OPEN TEMP6$ FOR INPUT AS #1
 IF BL = 1 THEN EXIT SUB

 CLS
 COLOR 9: LOCATE 1, 1: PRINT "Load Game"
 COLOR 15: LOCATE 8, 1: PRINT "Action:";
 COLOR 10: LOCATE 8, 10: PRINT "Loading Info"
 INPUT #1, Z
 INPUT #1, ACTIVE
 INPUT #1, DIFICIL
  FOR X = 1 TO 10
  COLOR 14: LOCATE 8, 10: PRINT "Loading Player "; X
  INPUT #1, CN(X)
  INPUT #1, CP(X)
  INPUT #1, CCC(X)
  INPUT #1, CPC(X)
  INPUT #1, CONTROL(X)
  INPUT #1, STATUS(X)
  INPUT #1, MORALE(X)
  INPUT #1, TAXES(X)
  INPUT #1, GROWTH(X)
  INPUT #1, TECH(X)
  INPUT #1, FREEDOM(X)
  INPUT #1, WIN(X)
  INPUT #1, LOSS(X)
  INPUT #1, PEOPLE(X)
  INPUT #1, ECONOMY(X)
  INPUT #1, MONEY(X)
  INPUT #1, ARMY(X)
  INPUT #1, WEAPONS(X)
  INPUT #1, AGENTS(X)
  NEXT X
CLOSE #1


'Reactivate saved game
CALL MAP
IF SND = 2 THEN PLAY "MNT150L8O3D+.L16CL4<G+>CD+L2G+L8>C.L16<A+L4G+CDL2D+"
LOCATE 30, 1: COLOR 15: PRINT "Press ENTER to continue..."; : LA$ = INPUT$(1)
CALL LISTPLAYERS
LOCATE 30, 1: COLOR 15: PRINT "Press ENTER to continue..."; : LA$ = INPUT$(1)
CALL CONTROLLER
END SUB

SUB MAINMENU

'Main Menu
WHILE MMENU$ <> "Q"
 CLS
 PRINT "Main Menu"

  'Options
 COLOR 14
 LOCATE 5, 1: PRINT "P"
 LOCATE 6, 1: PRINT "L"
 LOCATE 8, 1: PRINT "Q"

  'Option Names
 COLOR 9
 LOCATE 5, 11: PRINT "Play New Game"
 LOCATE 6, 11: PRINT "Load Old Game"
 LOCATE 8, 11: PRINT "Quit"
 LOCATE 12, 1: COLOR 14
 INPUT "Choice: ", MMENU$
 MMENU$ = UCASE$(MMENU$)
 IF MMENU$ = "P" THEN CALL GAMEMENU
 IF MMENU$ = "L" THEN CALL LOAD
WEND
CALL GOODBYE
END SUB

SUB MAP
'The Map
CLS

  'Ocean
PAINT (1, 1), 1

  'Country 1
LINE (160, 20)-(250, 62), CCC(1)
LINE (250, 62)-(250, 119), CCC(1)
LINE (250, 119)-(20, 119), CCC(1)
LINE (20, 119)-(160, 20), CCC(1)
PAINT (160, 40), CCC(1)
LOCATE 5, 20: COLOR 15: PRINT "1"
  'Country 2
LINE (251, 62)-(370, 119), CCC(2)
LINE (370, 119)-(250, 119), CCC(2)
LINE (251, 119)-(250, 62), CCC(2)
PAINT (270, 90), CCC(2)
LOCATE 7, 35: COLOR 15: PRINT "2"
  'Country 3
LINE (350, 20)-(510, 20), CCC(3)
LINE (510, 20)-(530, 100), CCC(3)
LINE (530, 100)-(350, 20), CCC(3)
PAINT (400, 25), CCC(3)
LOCATE 3, 60: COLOR 15: PRINT "3"
  'Country 4
LINE (20, 120)-(160, 120), CCC(4)
LINE (160, 120)-(160, 280), CCC(4)
LINE (160, 280)-(155, 280), CCC(4)
LINE (155, 280)-(20, 245), CCC(4)
LINE (20, 245)-(20, 120), CCC(4)
PAINT (100, 200), CCC(4)
LOCATE 13, 10: COLOR 15: PRINT "4"
  'Country 5
LINE (161, 120)-(299, 120), CCC(5)
LINE (299, 120)-(299, 219), CCC(5)
LINE (299, 219)-(161, 219), CCC(5)
LINE (161, 219)-(161, 120), CCC(5)
PAINT (200, 200), CCC(5)
LOCATE 13, 25: COLOR 15: PRINT "5"
  'Country 6
LINE (161, 220)-(299, 220), CCC(6)
LINE (299, 220)-(299, 239), CCC(6)
LINE (299, 239)-(270, 245), CCC(6)
LINE (270, 245)-(300, 275), CCC(6)
LINE (300, 275)-(161, 280), CCC(6)
LINE (161, 280)-(161, 220), CCC(6)
PAINT (200, 260), CCC(6)
LOCATE 16, 25: COLOR 15: PRINT "6"
  'Country 7
LINE (300, 120)-(300, 239), CCC(7)
LINE (300, 239)-(349, 249), CCC(7)
LINE (349, 249)-(349, 120), CCC(7)
LINE (349, 120)-(300, 120), CCC(7)
PAINT (325, 180), CCC(7)
LOCATE 13, 41: COLOR 15: PRINT "7"
  'Country 8
LINE (350, 120)-(370, 120), CCC(8)
LINE (370, 120)-(500, 180), CCC(8)
LINE (500, 180)-(520, 280), CCC(8)
LINE (520, 280)-(350, 249), CCC(8)
LINE (350, 249)-(350, 120), CCC(8)
PAINT (360, 200), CCC(8)
LOCATE 13, 50: COLOR 15: PRINT "8"
  'Country 9
LINE (160, 320)-(310, 346), CCC(9)
LINE (310, 346)-(310, 400), CCC(9)
LINE (310, 400)-(160, 320), CCC(9)
PAINT (250, 340), CCC(9)
LOCATE 23, 35: COLOR 15: PRINT "9"
  'Country 10
LINE (311, 346)-(450, 370), CCC(10)
LINE (450, 370)-(470, 390), CCC(10)
LINE (470, 390)-(311, 400), CCC(10)
LINE (311, 400)-(311, 346), CCC(10)
PAINT (320, 360), CCC(10)
LOCATE 24, 45: COLOR 15: PRINT "10"
END SUB

SUB PLAYMENU (N AS INTEGER)

MAINMENU:
'Main Menu
WHILE A$ <> "Q"
 MH$ = "Main Menu"
 GOSUB MENUINIT
  'Hotkeys
 COLOR 14
 LOCATE 24, 2: PRINT "M";
 LOCATE 25, 2: PRINT "D";
 LOCATE 26, 2: PRINT "I";
 LOCATE 27, 2: PRINT "O";
 LOCATE 28, 2: PRINT "Q";
 LOCATE 29, 2: PRINT "E";
  'Hotkey Text
 COLOR 15
 LOCATE 24, 4: PRINT "Military";
 LOCATE 25, 4: PRINT "Domestic";
 LOCATE 26, 4: PRINT "Intelligence";
 LOCATE 27, 4: PRINT "Other";
 LOCATE 28, 4: PRINT "Quit Turn";
 LOCATE 29, 4: PRINT "Exit Game";
 A$ = INPUT$(1)
 A$ = UCASE$(A$)
 IF A$ = "M" THEN GOSUB MILITARY
 IF A$ = "D" THEN GOSUB DOMESTIC
 IF A$ = "I" THEN GOSUB INTEL
 IF A$ = "O" THEN GOSUB Other
 IF A$ = "E" THEN CALL GOODBYE
WEND
EXIT SUB

MILITARY:
WHILE SA$ <> "Q"
 MH$ = "Military Menu"
 GOSUB MENUINIT
  'Hotkeys
 COLOR 14
 LOCATE 24, 2: PRINT "E";
 LOCATE 25, 2: PRINT "D";
 LOCATE 26, 2: PRINT "B";
 LOCATE 27, 2: PRINT "S";
 LOCATE 28, 2: PRINT "I";
 LOCATE 29, 2: PRINT "Q";
  'Hotkey Text
 COLOR 15
 LOCATE 24, 4: PRINT "Enlist Soldiers";
 LOCATE 25, 4: PRINT "Dismiss Soldiers";
 LOCATE 26, 4: PRINT "Buy Weapons";
 LOCATE 27, 4: PRINT "Sell Weapons";
 LOCATE 28, 4: PRINT "Conduct an Invasion";
 LOCATE 29, 4: PRINT "Quit Menu";
 SA$ = INPUT$(1)
 SA$ = UCASE$(SA$)
 IF SA$ = "E" THEN GOSUB EARMY
 IF SA$ = "D" THEN GOSUB DARMY
 IF SA$ = "B" THEN GOSUB BW
 IF SA$ = "S" THEN GOSUB SW
 IF SA$ = "I" THEN CALL WAR(N)
WEND
RETURN

DOMESTIC:
WHILE SA$ <> "Q"
 MH$ = "Domestic Menu"
 GOSUB MENUINIT
  'Hotkeys
 COLOR 14
 LOCATE 24, 2: PRINT "S";
 LOCATE 25, 2: PRINT "T";
 LOCATE 26, 2: PRINT "I";
 LOCATE 27, 2: PRINT "F";
 LOCATE 28, 2: PRINT "E";
 LOCATE 29, 2: PRINT "Q";
  'Hotkey Text
 COLOR 15
 LOCATE 24, 4: PRINT "Send to Another Coun.";
 LOCATE 25, 4: PRINT "Tax Rate";
 LOCATE 26, 4: PRINT "Increase Tech Level";
 LOCATE 27, 4: PRINT "Set Freedom Factor";
 LOCATE 28, 4: PRINT "Economic Investment";
 LOCATE 29, 4: PRINT "Quit Menu";
 SA$ = INPUT$(1)
 SA$ = UCASE$(SA$)
 IF SA$ = "S" THEN GOSUB SENDGOOD
 IF SA$ = "T" THEN GOSUB TAX
 IF SA$ = "I" THEN GOSUB ITECH
 IF SA$ = "F" THEN GOSUB FREEFACT
 IF SA$ = "E" THEN GOSUB INVEST
WEND
RETURN

INTEL:
WHILE SA$ <> "Q"
 MH$ = "Intellegence"
 GOSUB MENUINIT
  'Hotkeys
 COLOR 14
 LOCATE 24, 2: PRINT "E";
 LOCATE 25, 2: PRINT "D";
 LOCATE 26, 2: PRINT "S";
 LOCATE 27, 2: PRINT "I";
 LOCATE 28, 2: PRINT "C";
 LOCATE 29, 2: PRINT "Q";
  'Hotkey Text
 COLOR 15
 LOCATE 24, 4: PRINT "Enlist Agents";
 LOCATE 25, 4: PRINT "Dismiss Agents";
 LOCATE 26, 4: PRINT "Spy on a Country";
 LOCATE 27, 4: PRINT "Inflict Sabotage";
 LOCATE 28, 4: PRINT "Coup d'Etat";
 LOCATE 29, 4: PRINT "Quit Menu";
 SA$ = INPUT$(1)
 SA$ = UCASE$(SA$)
 IF SA$ = "E" THEN GOSUB ESPY
 IF SA$ = "D" THEN GOSUB DSPY
 IF SA$ = "S" THEN GOSUB SPY
 IF SA$ = "I" THEN GOSUB SABO
 IF SA$ = "C" THEN GOSUB COUP
WEND
RETURN

Other:
WHILE SA$ <> "Q"
 MH$ = "Other Menu"
 GOSUB MENUINIT
  'Hotkeys
 COLOR 14
 LOCATE 24, 2: PRINT "I";
 LOCATE 25, 2: PRINT "D";
 LOCATE 26, 2: PRINT "L";
 LOCATE 27, 2: PRINT "V";
 LOCATE 28, 2: PRINT "S";
 LOCATE 29, 2: PRINT "Q";
  'Hotkey Text
 COLOR 15
 LOCATE 24, 4: PRINT "Nation Info";
 LOCATE 25, 4: PRINT "Delegation";
 LOCATE 26, 4: PRINT "List Players";
 LOCATE 27, 4: PRINT "Version Info";
 LOCATE 28, 4: PRINT "Save Game";
 LOCATE 29, 4: PRINT "Quit Menu";
 SA$ = INPUT$(1)
 SA$ = UCASE$(SA$)
 IF SA$ = "D" THEN GOSUB DELEGATE
 IF SA$ = "I" THEN CALL STATC(N)
  IF SA$ = "L" THEN
  CALL LISTPLAYERS
  LOCATE 30, 1: COLOR 15: PRINT "Press ENTER to continue...";
  LA$ = INPUT$(1)
  END IF
 IF SA$ = "V" THEN GOSUB VERSION
 IF SA$ = "S" THEN
 ACTIVE = N
 CALL SAVE
 END IF
WEND
RETURN

'Enlist Soliders
EARMY:
CLS
COLOR 6
PRINT "An army means power. Soldiers can take over other nations, suppress"
PRINT "citizens, or just plain help out. You decide."
PRINT
PRINT "One soldier costs only $1000 to hire."
COLOR 13
LOCATE 7, 1: PRINT "Current # of Soldiers:";
LOCATE 8, 1: PRINT "Current money:";
COLOR 14
LOCATE 7, 25: PRINT ARMY(N);
LOCATE 8, 25: PRINT MONEY(N);
TEMP1 = 0: TEMP2 = 0
LOCATE 10, 1: COLOR 10: INPUT "Soldiers to hire? ", TEMP1
TEMP2 = TEMP1 * 1000
 IF TEMP2 > MONEY(N) THEN
 LOCATE 15, 1: COLOR 4: PRINT "Insufficient funds!"
 END IF
 IF TEMP2 < MONEY(N) THEN
 ARMY(N) = ARMY(N) + TEMP1
 MONEY(N) = MONEY(N) - TEMP2
 LOCATE 15, 1: COLOR 14: PRINT "Soldiers hired!"
 END IF
 IF TEMP2 = MONEY(N) THEN
 ARMY(N) = ARMY(N) + TEMP1
 MONEY(N) = MONEY(N) - TEMP2
 LOCATE 15, 1: COLOR 14: PRINT "Soldiers hired!"
 END IF
LOCATE 20, 1: COLOR 12: PRINT "New army manpool: "
COLOR 14: LOCATE 20, 30: PRINT ARMY(N);
LOCATE 21, 1: COLOR 10: PRINT "Money: "
COLOR 14: LOCATE 21, 30: PRINT MONEY(N);
LOCATE 30, 1: COLOR 15: PRINT "Press ENTER to continue..."; : LA$ = INPUT$(1)
RETURN

'Dismiss Soldiers
DARMY:
CLS
COLOR 6
PRINT "When you need money, dismissing soldiers will help. It's always good"
PRINT "to keep some though."
PRINT
PRINT "One dismissal brings in $200."
COLOR 13
LOCATE 7, 1: PRINT "Current # of Soldiers:";
LOCATE 8, 1: PRINT "Current money:";
COLOR 14
LOCATE 7, 25: PRINT ARMY(N);
LOCATE 8, 25: PRINT MONEY(N);
TEMP1 = 0
LOCATE 10, 1: COLOR 10: INPUT "Soldiers to fire? ", TEMP1
TEMP2 = TEMP1 * 200
 IF TEMP1 > ARMY(N) THEN
 LOCATE 15, 1: COLOR 4: PRINT "Insufficient soldiers!"
 END IF
 IF TEMP1 < ARMY(N) THEN
 ARMY(N) = ARMY(N) - TEMP1
 MONEY(N) = MONEY(N) + TEMP2
 LOCATE 15, 1: COLOR 14: PRINT "Soldiers fired!"
 END IF
 IF TEMP1 = ARMY(N) THEN
 ARMY(N) = ARMY(N) - TEMP1
 MONEY(N) = MONEY(N) + TEMP2
 LOCATE 15, 1: COLOR 14: PRINT "Soldiers fired!"
 END IF
LOCATE 20, 1: COLOR 12: PRINT "New army manpool: "
COLOR 14: LOCATE 20, 30: PRINT ARMY(N);
LOCATE 21, 1: COLOR 10: PRINT "Money: "
COLOR 14: LOCATE 21, 30: PRINT MONEY(N);
LOCATE 30, 1: COLOR 15: PRINT "Press ENTER to continue..."; : LA$ = INPUT$(1)
RETURN

'Buy Weapons
BW:
CLS
COLOR 8
PRINT "Weapons are the key to successful military operation. If each soldier"
PRINT "had weapons to use, their fighting power will be enhanced."
PRINT
PRINT "A weapon costs only $100 to purchase."
COLOR 13
LOCATE 7, 1: PRINT "Current # of Weapons:";
LOCATE 8, 1: PRINT "Current money:";
COLOR 14
LOCATE 7, 25: PRINT WEAPONS(N);
LOCATE 8, 25: PRINT MONEY(N);
TEMP1 = 0
LOCATE 10, 1: COLOR 10: INPUT "Weapons to buy? ", TEMP1
TEMP2 = TEMP1 * 100
 IF TEMP2 > MONEY(N) THEN
 LOCATE 15, 1: COLOR 4: PRINT "Insufficient funds!"
 END IF
 IF TEMP2 < MONEY(N) THEN
 WEAPONS(N) = WEAPONS(N) + TEMP1
 MONEY(N) = MONEY(N) - TEMP2
 LOCATE 15, 1: COLOR 14: PRINT "Weapons purchased!"
 END IF
 IF TEMP2 = MONEY(N) THEN
 WEAPONS(N) = WEAPONS(N) + TEMP1
 MONEY(N) = MONEY(N) - TEMP2
 LOCATE 15, 1: COLOR 14: PRINT "Weapons purchased!"
 END IF
LOCATE 20, 1: COLOR 12: PRINT "New arms stockpile: "
COLOR 14: LOCATE 20, 30: PRINT WEAPONS(N);
LOCATE 21, 1: COLOR 10: PRINT "Money: "
COLOR 14: LOCATE 21, 30: PRINT MONEY(N);
LOCATE 30, 1: COLOR 15: PRINT "Press ENTER to continue..."; : LA$ = INPUT$(1)
RETURN

'Sell Weapons
SW:
CLS
COLOR 8
PRINT "So you want to be an arms dealer? The arms market gives a 50% return"
PRINT "on weapons, as there are plenty of needing countries to sell to."
PRINT
PRINT "One weapon brings in $50."
COLOR 13
LOCATE 7, 1: PRINT "Current # of Weapons:";
LOCATE 8, 1: PRINT "Current money:";
COLOR 14
LOCATE 7, 25: PRINT WEAPONS(N);
LOCATE 8, 25: PRINT MONEY(N);
TEMP1 = 0
LOCATE 10, 1: COLOR 10: INPUT "Weapons to sell? ", TEMP1
TEMP2 = TEMP1 * 50
 IF TEMP1 > WEAPONS(N) THEN
 LOCATE 15, 1: COLOR 4: PRINT "Insufficient weapons!"
 END IF
 IF TEMP1 < WEAPONS(N) THEN
 WEAPONS(N) = WEAPONS(N) - TEMP1
 MONEY(N) = MONEY(N) + TEMP2
 LOCATE 15, 1: COLOR 14: PRINT "Weapons sold!"
 END IF
 IF TEMP1 = WEAPONS(N) THEN
 WEAPONS(N) = WEAPONS(N) - TEMP1
 MONEY(N) = MONEY(N) + TEMP2
 LOCATE 15, 1: COLOR 14: PRINT "Weapons sold!"
 END IF
LOCATE 20, 1: COLOR 12: PRINT "New arms stockpile: "
COLOR 14: LOCATE 20, 30: PRINT WEAPONS(N);
LOCATE 21, 1: COLOR 10: PRINT "Money: "
COLOR 14: LOCATE 21, 30: PRINT MONEY(N);
LOCATE 30, 1: COLOR 15: PRINT "Press ENTER to continue..."; : LA$ = INPUT$(1)
RETURN

'Transfer goods to others
SENDGOOD:
CLS
CALL LISTPLAYERS
LOCATE 30, 1: COLOR 15: INPUT "What country do you wish to send goods to"; TEMP6$
 IF TEMP6$ = "" THEN RETURN
 TEMP = VAL(TEMP6$)
        'Is it your country?
 IF N = TEMP THEN
 CLS
 LOCATE 4, 1: COLOR 4: PRINT "You can't send goods to your own country!"
 END IF
        'It's not your country
 IF N <> TEMP THEN
                'Is it not under your control?
  IF CCC(TEMP) <> CCC(N) THEN
  CLS
  LOCATE 4, 1: COLOR 4: PRINT "You do not control the selected country!"
  END IF
                'It is yours!
  IF CCC(TEMP) = CCC(N) THEN
  CLS
  COLOR 15
  LOCATE 7, 1: PRINT "Name:"
  PRINT "# of Soldiers:"
  PRINT "# of Weapons:"
  PRINT "# of Spies:"
  PRINT "Technology Rating:"
  PRINT "Morale Rating:"
  PRINT "Money:"
  PRINT "Economic Factor:"
  COLOR 10
  LOCATE 7, 21: PRINT CN(N);
  LOCATE 8, 20: PRINT ARMY(N);
  LOCATE 9, 20: PRINT WEAPONS(N);
  LOCATE 10, 20: PRINT AGENTS(N);
  LOCATE 11, 20: PRINT TECH(N);
  LOCATE 12, 20: PRINT MORALE(N);
  LOCATE 13, 20: PRINT MONEY(N);
  LOCATE 14, 20: PRINT ECONOMY(N);
  COLOR 13
  LOCATE 7, 41: PRINT CN(TEMP);
  LOCATE 8, 40: PRINT ARMY(TEMP);
  LOCATE 9, 40: PRINT WEAPONS(TEMP);
  LOCATE 10, 40: PRINT AGENTS(TEMP);
  LOCATE 11, 40: PRINT TECH(TEMP);
  LOCATE 12, 40: PRINT MORALE(TEMP);
  LOCATE 13, 40: PRINT MONEY(TEMP);
  LOCATE 14, 40: PRINT ECONOMY(TEMP);
  LOCATE 16, 1: COLOR 15
      'Make requests & check to see if too big
        'Army
   INPUT "# of Soldiers to send"; TEMP2
   IF TEMP2 > ARMY(N) THEN TEMP2 = ARMY(N)
   ARMY(N) = ARMY(N) - TEMP2: ARMY(TEMP) = ARMY(TEMP) + TEMP2
        'Weapons
   INPUT "# of Weapons to send"; TEMP3
   IF TEMP3 > WEAPONS(N) THEN TEMP3 = WEAPONS(N)
   WEAPONS(N) = WEAPONS(N) - TEMP3: WEAPONS(TEMP) = WEAPONS(TEMP) + TEMP3
        'Agents
   INPUT "# of Spies to send"; TEMP4
   IF TEMP4 > AGENTS(N) THEN TEMP4 = AGENTS(N)
   AGENTS(N) = AGENTS(N) - TEMP4: AGENTS(TEMP) = AGENTS(TEMP) + TEMP4
        'Money
   INPUT "Amount of Money to send"; TEMP5
   IF TEMP5 > MONEY(N) THEN TEMP5 = MONEY(N)
   MONEY(N) = MONEY(N) - TEMP5: MONEY(TEMP) = MONEY(TEMP) + TEMP5
        'Show change
  CLS
  COLOR 15
  LOCATE 7, 1: PRINT "Name:"
  PRINT "# of Soldiers:"
  PRINT "# of Weapons:"
  PRINT "# of Spies:"
  PRINT "Technology Rating:"
  PRINT "Morale Rating:"
  PRINT "Money:"
  PRINT "Economic Factor:"
  COLOR 10
  LOCATE 7, 21: PRINT CN(N);
  LOCATE 8, 20: PRINT ARMY(N);
  LOCATE 9, 20: PRINT WEAPONS(N);
  LOCATE 10, 20: PRINT AGENTS(N);
  LOCATE 11, 20: PRINT TECH(N);
  LOCATE 12, 20: PRINT MORALE(N);
  LOCATE 13, 20: PRINT MONEY(N);
  LOCATE 14, 20: PRINT ECONOMY(N);
  COLOR 13
  LOCATE 7, 41: PRINT CN(TEMP);
  LOCATE 8, 40: PRINT ARMY(TEMP);
  LOCATE 9, 40: PRINT WEAPONS(TEMP);
  LOCATE 10, 40: PRINT AGENTS(TEMP);
  LOCATE 11, 40: PRINT TECH(TEMP);
  LOCATE 12, 40: PRINT MORALE(TEMP);
  LOCATE 13, 40: PRINT MONEY(TEMP);
  LOCATE 14, 40: PRINT ECONOMY(TEMP);
  END IF
 END IF
LOCATE 30, 1: COLOR 15: PRINT "Press ENTER to continue..."; : LA$ = INPUT$(1)
RETURN

'Set tax rate
TAX:
CLS
COLOR 15
PRINT "The tax rate is a number from 0 to 100, accounting for how much of"
PRINT "people's incomes will be taken for government use."
LOCATE 4, 1: COLOR 10: PRINT "Current Tax Rate: ";
LOCATE 4, 20: COLOR 14: PRINT TAXES(N);
LOCATE 6, 1: COLOR 12: INPUT "New tax rate"; TEMP6$
 IF TEMP6$ = "" THEN TEMP6$ = STR$(TAXES(N))
 TAXES(N) = VAL(TEMP6$)
 IF TAXES(N) < 1 THEN TAXES(N) = 1
 IF TAXES(N) > 100 THEN TAXES(N) = 100
LOCATE 20, 1: COLOR 11: PRINT "New tax rate:";
LOCATE 20, 20: COLOR 14: PRINT TAXES(N)
LOCATE 30, 1: COLOR 15: PRINT "Press ENTER to continue..."; : LA$ = INPUT$(1)
RETURN

'Increase Technology
ITECH:
CLS
COLOR 15
PRINT "By increasing technology, quality of life improves and military is"
PRINT "strengthend."
PRINT
COLOR 10
PRINT "You can help increase this number by investing. $100000 will increase"
PRINT "the factor by 1."
PRINT
COLOR 10
LOCATE 7, 1: PRINT "Current technology factor: ";
LOCATE 8, 1: PRINT "Current money:";
COLOR 14
LOCATE 7, 30: PRINT TECH(N);
LOCATE 8, 30: PRINT MONEY(N);
PRINT : TEMP1 = 0
COLOR 12: INPUT "Amount of money to invest"; TEMP1
 IF TEMP1 > MONEY(N) THEN
 LOCATE 15, 1: COLOR 4: PRINT "Insufficient funds!"
 END IF
 IF TEMP1 < MONEY(N) THEN
 TEMP2 = CLNG(TEMP1 / 100000): TECH(N) = TECH(N) + TEMP2
 MONEY(N) = MONEY(N) - TEMP1
 LOCATE 15, 1: COLOR 10: PRINT "Invested!"
 END IF
 IF TEMP1 = MONEY(N) THEN
 TEMP2 = CLNG(TEMP1 / 100000): TECH(N) = TECH(N) + TEMP2
 MONEY(N) = MONEY(N) - TEMP1
 LOCATE 15, 1: COLOR 10: PRINT "Invested!"
 END IF
LOCATE 20, 1: COLOR 11: PRINT "New technology factor: "
COLOR 14: LOCATE 20, 30: PRINT TECH(N);
LOCATE 21, 1: COLOR 10: PRINT "Money: "
COLOR 14: LOCATE 21, 30: PRINT MONEY(N);
LOCATE 30, 1: COLOR 15: PRINT "Press ENTER to continue..."; : LA$ = INPUT$(1)
RETURN

'Set Freedom Factor
FREEFACT:
CLS
COLOR 15
PRINT "The Freedom Factor is a number from -10 to 10, accounting for how much"
PRINT "freedom the people shall enjoy. - is restrictive, + is open."
LOCATE 4, 1: COLOR 10: PRINT "Current Freedom Factor: ";
LOCATE 4, 30: COLOR 14: PRINT FREEDOM(N);
LOCATE 6, 1: COLOR 12: INPUT "New Freedom Factor"; TEMP6$
IF TEMP6$ = "" THEN TEMP6$ = STR$(FREEDOM(N))
FREEDOM(N) = VAL(TEMP6$)
IF FREEDOM(N) < -10 THEN FREEDOM(N) = -10
IF FREEDOM(N) > 10 THEN FREEDOM(N) = 10
LOCATE 20, 1: COLOR 11: PRINT "New Freedom Factor:";
LOCATE 20, 30: COLOR 14: PRINT FREEDOM(N)
LOCATE 30, 1: COLOR 15: PRINT "Press ENTER to continue..."; : LA$ = INPUT$(1)
RETURN

'Economic Investment
INVEST:
CLS
COLOR 15
PRINT "The economy factor is based on an average of people's wealth. A factor"
PRINT "of 100 will mean that every person has an average of 100 dollars in"
PRINT "their name. Also, this factor will change, from time to time."
PRINT
COLOR 10
PRINT "You can help increase this number by investing. $10000 will increase"
PRINT "the factor by 1."
PRINT
COLOR 10
LOCATE 8, 1: PRINT "Current economic factor: ";
LOCATE 9, 1: PRINT "Current money:";
COLOR 14
LOCATE 8, 30: PRINT ECONOMY(N);
LOCATE 9, 30: PRINT MONEY(N);
PRINT : TEMP1 = 0
COLOR 12: INPUT "Amount of money to invest"; TEMP1
 IF TEMP1 > MONEY(N) THEN
 LOCATE 15, 1: COLOR 4: PRINT "Insufficient funds!"
 END IF
 IF TEMP1 < MONEY(N) THEN
 TEMP2 = TEMP1 / 10000: ECONOMY(N) = ECONOMY(N) + TEMP2
 MONEY(N) = MONEY(N) - TEMP1
 LOCATE 15, 1: COLOR 10: PRINT "Invested!"
 END IF
 IF TEMP1 = MONEY(N) THEN
 TEMP2 = TEMP1 / 10000: ECONOMY(N) = ECONOMY(N) + TEMP2
 MONEY(N) = MONEY(N) - TEMP1
 LOCATE 15, 1: COLOR 10: PRINT "Invested!"
 END IF
LOCATE 20, 1: COLOR 11: PRINT "New economic factor: "
COLOR 14: LOCATE 20, 30: PRINT ECONOMY(N);
LOCATE 21, 1: COLOR 10: PRINT "Money: "
COLOR 14: LOCATE 21, 30: PRINT MONEY(N);
LOCATE 30, 1: COLOR 15: PRINT "Press ENTER to continue..."; : LA$ = INPUT$(1)
RETURN

'Hire Spies
ESPY:
CLS
COLOR 5
PRINT "Hiring spies can allow you to spy on your enemies or inflict"
PRINT "sabotage: Either action will be potentially disruptive to them."
PRINT
PRINT "One spy costs only $2500 to hire."
COLOR 13
LOCATE 7, 1: PRINT "Current # of Spies:";
LOCATE 8, 1: PRINT "Current money:";
COLOR 14
LOCATE 7, 25: PRINT AGENTS(N);
LOCATE 8, 25: PRINT MONEY(N);
TEMP1 = 0
LOCATE 10, 1: COLOR 10: INPUT "Spies to hire? ", TEMP1
TEMP2 = TEMP1 * 2500
 IF TEMP2 > MONEY(N) THEN
 LOCATE 15, 1: COLOR 4: PRINT "Insufficient funds!"
 END IF
 IF TEMP2 < MONEY(N) THEN
 AGENTS(N) = AGENTS(N) + TEMP1
 MONEY(N) = MONEY(N) - TEMP2
 LOCATE 15, 1: COLOR 14: PRINT "Agents hired!"
 END IF
 IF TEMP2 = MONEY(N) THEN
 AGENTS(N) = AGENTS(N) + TEMP1
 MONEY(N) = MONEY(N) - TEMP2
 LOCATE 15, 1: COLOR 14: PRINT "Agents hired!"
 END IF
LOCATE 20, 1: COLOR 12: PRINT "New spy manpool: "
COLOR 14: LOCATE 20, 30: PRINT AGENTS(N);
LOCATE 21, 1: COLOR 10: PRINT "Money: "
COLOR 14: LOCATE 21, 30: PRINT MONEY(N);
LOCATE 30, 1: COLOR 15: PRINT "Press ENTER to continue..."; : LA$ = INPUT$(1)
RETURN

'Dismiss Spies
DSPY:
CLS
COLOR 5
PRINT "When you need money, dismissing spies will help. It's always good to"
PRINT "keep some though."
PRINT
PRINT "One dismissal brings in $500."
COLOR 13
LOCATE 7, 1: PRINT "Current # of Spies:";
LOCATE 8, 1: PRINT "Current money:";
COLOR 14
LOCATE 7, 25: PRINT AGENTS(N);
LOCATE 8, 25: PRINT MONEY(N);
TEMP1 = 0
LOCATE 10, 1: COLOR 10: INPUT "Spies to fire? ", TEMP1
TEMP2 = TEMP1 * 500
 IF TEMP1 > AGENTS(N) THEN
 LOCATE 15, 1: COLOR 4: PRINT "Insufficient agents!"
 END IF
 IF TEMP1 < AGENTS(N) THEN
 AGENTS(N) = AGENTS(N) - TEMP1
 MONEY(N) = MONEY(N) + TEMP2
 LOCATE 15, 1: COLOR 14: PRINT "Agents fired!"
 END IF
 IF TEMP1 = AGENTS(N) THEN
 AGENTS(N) = AGENTS(N) - TEMP1
 MONEY(N) = MONEY(N) + TEMP2
 LOCATE 15, 1: COLOR 14: PRINT "Agents fired!"
 END IF
LOCATE 20, 1: COLOR 12: PRINT "New spy manpool: "
COLOR 14: LOCATE 20, 30: PRINT AGENTS(N);
LOCATE 21, 1: COLOR 10: PRINT "Money: "
COLOR 14: LOCATE 21, 30: PRINT MONEY(N);
LOCATE 30, 1: COLOR 15: PRINT "Press ENTER to continue..."; : LA$ = INPUT$(1)
RETURN

'Conduct Espionage
SPY:
CLS
CALL LISTPLAYERS
W = 0
LOCATE 30, 1: COLOR 5: INPUT "Which country do you wish to know about"; W
TEMP = AGENTS(W)
IF W > 0 THEN

        'The country is yours
 IF CCC(N) = CCC(W) THEN
 CALL STATC(W)
 END IF
        'The country is not yours
 IF CCC(N) <> CCC(W) THEN
                'You have no agents
  IF AGENTS(N) < 1 THEN
  CLS
  LOCATE 4, 1: COLOR 4: PRINT "You have no agents!"
  LOCATE 30, 1: COLOR 15: PRINT "Press ENTER to continue..."; : LA$ = INPUT$(1)
  END IF
                'You have agents
  IF AGENTS(N) > 0 THEN
                        'You both have the same
   IF TEMP = AGENTS(N) THEN
   CLS
   LOCATE 5, 1: COLOR 13: PRINT "You sent as many agents as they have!"
   PRINT "Nothing can be done!"
   LOCATE 30, 1: COLOR 15: PRINT "Press ENTER to continue..."; : LA$ = INPUT$(1)
   END IF
                        'The enemy has more
   IF TEMP > AGENTS(N) THEN
   CLS
   LOCATE 5, 1: COLOR 4: PRINT "The enemy uses superior numbers to block your attempt."
   LOCATE 30, 1: COLOR 15: PRINT "Press ENTER to continue..."; : LA$ = INPUT$(1)
   END IF
                        'The enemy has less
   IF TEMP < AGENTS(N) THEN
   CALL STATC(W)
   END IF
  END IF
 END IF
END IF
RETURN

'Conduct Sabotage
SABO:
CLS
CALL LISTPLAYERS
W = 0
LOCATE 30, 1: COLOR 5: INPUT "Which country do you wish to sabotage"; W
IF W > 0 THEN
TEMP = AGENTS(W)
 
  'No agents
 IF AGENTS(N) = 0 THEN
 CLS
 LOCATE 5, 1: COLOR 4: PRINT "You have no agents!";
 LOCATE 30, 1: COLOR 15: PRINT "Press ENTER to continue..."; : LA$ = INPUT$(1)
 END IF
 
  'Agents available
 IF AGENTS(N) > 0 THEN
    'Enemy has the same # of agents
  IF TEMP = AGENTS(N) THEN
  CLS
  LOCATE 5, 1: COLOR 13: PRINT "You sent as many agents as they have!"
  PRINT "Nothing can be done!"
  LOCATE 30, 1: COLOR 15: PRINT "Press ENTER to continue..."; : LA$ = INPUT$(1)
  END IF
      'Enemy has more
  IF TEMP > AGENTS(N) THEN
  CLS
  LOCATE 5, 1: COLOR 4: PRINT "The enemy uses superior numbers to block your attempt."
  LOCATE 30, 1: COLOR 15: PRINT "Press ENTER to continue..."; : LA$ = INPUT$(1)
  END IF
      'Enemy has less
  IF TEMP < AGENTS(N) THEN
  CLS
  RANDOMIZE TIMER
  TEMP1 = 0: TEMP1 = CLNG(RND * 4)
  IF TEMP1 < 1 THEN TEMP1 = 1: IF TEMP1 > 4 THEN TEMP1 = 4
          'Kill people
   IF TEMP1 = 1 THEN
   TEMP2 = CLNG(PEOPLE(W) / 10)
   PEOPLE(W) = PEOPLE(W) - TEMP2
   LOCATE 5, 1: COLOR 14: PRINT TEMP2; " enemy people are now dead.";
   END IF
          'Kill soldiers
   IF TEMP1 = 2 THEN
   TEMP2 = CLNG(ARMY(W) / 10)
   ARMY(W) = ARMY(W) - TEMP2
   LOCATE 5, 1: COLOR 14: PRINT TEMP2; " enemy soldiers are now dead.";
   END IF
          'Kill agents
   IF TEMP1 = 3 THEN
   TEMP2 = CLNG(AGENTS(W) / 10)
   AGENTS(W) = AGENTS(W) - TEMP2
   LOCATE 5, 1: COLOR 14: PRINT TEMP2; " of their agents are now dead.";
   END IF
          'Cut tech factor by 1
   IF TEMP1 = 4 THEN
   TECH(W) = TECH(W) - 1
   LOCATE 5, 1: COLOR 14: PRINT "They have lost 1 technology factor.";
   END IF
  
   LOCATE 30, 1: COLOR 15: PRINT "Press ENTER to continue..."; : LA$ = INPUT$(1)
   
    'Kill off your agents
   IF AGENTS(N) > 1 THEN
   CLS
   TEMP2 = 0
   ON ERROR GOTO ERRORPROC
   TEMP3 = CLNG(RND * 10): TEMP2 = CLNG(AGENTS(N) / TEMP3): AGENTS(N) = AGENTS(N) - TEMP2
   LOCATE 5, 1: COLOR 4: PRINT "You lose        of your agents in the attempt."
   LOCATE 5, 10: COLOR 14: PRINT TEMP2;
   LOCATE 30, 1: COLOR 15: PRINT "Press ENTER to continue..."; : LA$ = INPUT$(1)
   END IF
  END IF
  
 END IF
END IF
RETURN



'Coup d'Etat
COUP:
CLS
CALL LISTPLAYERS
W = 0
LOCATE 30, 1: COLOR 5: INPUT "Which country do you wish to coerce"; W
TEMP = AGENTS(W)
IF W > 0 THEN

        'The country is yours
 IF CCC(N) = CCC(W) THEN
 CLS
 LOCATE 4, 1: COLOR 4: PRINT "The country is already yours!"
 LOCATE 30, 1: COLOR 15: PRINT "Press ENTER to continue..."; : LA$ = INPUT$(1)
 END IF
        'The country is not yours
 IF CCC(N) <> CCC(W) THEN
                'You have no agents
  IF AGENTS(N) < 1 THEN
  CLS
  LOCATE 4, 1: COLOR 4: PRINT "You have no agents!"
  LOCATE 30, 1: COLOR 15: PRINT "Press ENTER to continue..."; : LA$ = INPUT$(1)
  END IF
                'You have agents
  IF AGENTS(N) > 0 THEN
                        'You both have the same
   IF TEMP = AGENTS(N) THEN
   CLS
   LOCATE 5, 1: COLOR 13: PRINT "You sent as many agents as they have!"
   PRINT "Nothing can be done!"
   LOCATE 30, 1: COLOR 15: PRINT "Press ENTER to continue..."; : LA$ = INPUT$(1)
   END IF
                        'The enemy has more
   IF TEMP > AGENTS(N) THEN
   CLS
   LOCATE 5, 1: COLOR 4: PRINT "The enemy uses superior numbers to block your attempt."
   LOCATE 30, 1: COLOR 15: PRINT "Press ENTER to continue..."; : LA$ = INPUT$(1)
   END IF
                        'The enemy has less
   IF TEMP < AGENTS(N) THEN
   CLS
   RANDOMIZE TIMER
   TEMP4 = (RND * 45): TEMP5 = 0
   IF TEMP4 = 15 THEN TEMP5 = 1
   IF TEMP4 = 30 THEN TEMP5 = 1
   IF TEMP4 = 45 THEN TEMP5 = 1
                                'Success?
    IF TEMP5 = 0 THEN
    LOCATE 4, 1: COLOR 4: PRINT "You were not successful!"
    END IF
   
    IF TEMP5 = 1 THEN
    LOCATE 4, 1: COLOR 10: PRINT "The target has been coerced!"
    CP(W) = CP(N)
    CPC(W) = CPC(N)
    CCC(W) = CPC(N)
    CONTROL(W) = CONTROL(N)
    STATUS(W) = STATUS(N)
    FREEDOM(W) = FREEDOM(N)
    TAXES(W) = TAXES(N)
    TECH(W) = TECH(N)
    END IF
  
   LOCATE 30, 1: COLOR 15: PRINT "Press ENTER to continue...";
   LA$ = INPUT$(1)
   'Kill off your agents
   CLS
   TEMP2 = 0
   ON ERROR GOTO ERRORPROC
   TEMP3 = CLNG(RND * 10): TEMP2 = CLNG(AGENTS(N) / TEMP3)
   AGENTS(N) = AGENTS(N) - TEMP2
   LOCATE 5, 1: COLOR 4: PRINT "You lose        of your agents in the attempt."
   LOCATE 5, 10: COLOR 14: PRINT TEMP2;
   LOCATE 30, 1: COLOR 15: PRINT "Press ENTER to continue..."; : LA$ = INPUT$(1)
   END IF
 
  END IF
 END IF
END IF
RETURN



'Delegation Menu
DELEGATE:
CLS
CALL LISTPLAYERS:
W = 0
LOCATE 30, 1: COLOR 5: INPUT "Which country do you wish to adjust"; W
IF W > 0 THEN

 'If not owned by you
 IF CCC(W) <> CCC(N) THEN
 CLS
 LOCATE 4, 1: COLOR 4: PRINT "You do not own that country."
 LOCATE 30, 1: COLOR 15: PRINT "Press ENTER to continue..."; : LA$ = INPUT$(1)
 END IF

 'If owned by you
 IF CCC(W) = CCC(N) THEN
 TEMP7 = 0
        'Auto-Control is Disabled
  IF TEMP7 <> 1 THEN
   IF STATUS(W) = 1 THEN
   CLS
   LOCATE 4, 1: COLOR 13
   PRINT "Auto-Control is Disabled. You are in direct control the selected"
   PRINT "country."
   LOCATE 15, 1: COLOR 15
   PRINT "Enable Auto-Control (Y/N)?"; : LA$ = INPUT$(1)
   LA$ = UCASE$(LA$)
    IF LA$ = "Y" THEN
    STATUS(W) = 2
    TEMP7 = 1
    END IF
   END IF
  END IF
        'Auto-Control is Enabled
  IF TEMP7 <> 1 THEN
   IF STATUS(W) = 2 THEN
   CLS
   LOCATE 4, 1: COLOR 13
   PRINT "Auto-Control is Enabled. You do not directly control the"
   PRINT "selected country."
   LOCATE 15, 1: COLOR 15
   PRINT "Disable Auto-Control (Y/N)?"; : LA$ = INPUT$(1)
   LA$ = UCASE$(LA$)
    IF LA$ = "Y" THEN
    STATUS(W) = 1
    TEMP7 = 1
    END IF
   END IF
  END IF

 LOCATE 30, 1: COLOR 15: PRINT "Press ENTER to continue..."; : LA$ = INPUT$(1)
 END IF
END IF
RETURN

'Version Data
VERSION:
CLS
COLOR 12: PRINT "Autonomy, version 1.05";
PRINT
COLOR 13: PRINT "Compiled March 14, 1998";
PRINT
COLOR 14: PRINT "Authored by Michael Adams of Michael Adams Programming.";
LOCATE 30, 1: COLOR 15: PRINT "Press ENTER to continue..."; : LA$ = INPUT$(1)
RETURN

'Initalize Display
MENUINIT:
CALL MAP                                              'Display Map
SA$ = ""

        'Initialize Menu Screen
LINE (1, 325)-(200, 479), 0, BF
LINE (1, 325)-(200, 479), 15, B
COLOR 9: LOCATE 22, 2: PRINT MH$;

        'Initalize Data Screen
LINE (320, 410)-(639, 479), 0, BF
LINE (320, 410)-(639, 479), 15, B
COLOR 15: LOCATE 27, 42: PRINT "Turn:";
COLOR 14: LOCATE 27, 52: PRINT TURN;
COLOR 15: LOCATE 28, 42: PRINT "Player:";
COLOR 14: LOCATE 28, 52: PRINT CP(N);
COLOR 15: LOCATE 29, 42: PRINT "Country:";
COLOR 14: LOCATE 29, 52: PRINT CN(N);
RETURN

END SUB

SUB SAVE

'Filename
CLS
COLOR 10: PRINT "Save Game": PRINT
COLOR 15: INPUT "Directory of saved games (Blank = Current Dir.)"; DIR$
CLS
COLOR 10: PRINT "Save Game"
LOCATE 4, 1: COLOR 14: PRINT "Saved games in current directory..."
DIRB$ = "C:\COMMAND.COM /C" + " DIR " + DIR$ + "*.SAV /B"
LOCATE 5, 1: COLOR 15: SHELL DIRB$
LOCATE 20, 1: COLOR 15
INPUT "What file would you like to save to (Don't include .SAV)"; TEMP6$
IF TEMP6$ = "" THEN EXIT SUB
GAMEB$ = LEFT$(TEMP6$, 8)
TEMP6$ = DIR$ + UCASE$(GAMEB$) + ".SAV"

'Save the game
CLS
COLOR 9: LOCATE 3, 1: PRINT "Game Save"
COLOR 15: LOCATE 8, 1: PRINT "Action:";
OPEN TEMP6$ FOR OUTPUT AS #1
COLOR 10: LOCATE 8, 10: PRINT "Saving Info"
PRINT #1, TURN
PRINT #1, ACTIVE
PRINT #1, DIFICIL
 FOR X = 1 TO 10
 COLOR 14: LOCATE 8, 10: PRINT "Saving Player "; X
 PRINT #1, CN(X)
 PRINT #1, CP(X)
 PRINT #1, CCC(X)
 PRINT #1, CPC(X)
 PRINT #1, CONTROL(X)
 PRINT #1, STATUS(X)
 PRINT #1, MORALE(X)
 PRINT #1, TAXES(X)
 PRINT #1, GROWTH(X)
 PRINT #1, TECH(X)
 PRINT #1, FREEDOM(X)
 PRINT #1, WIN(X)
 PRINT #1, LOSS(X)
 PRINT #1, PEOPLE(X)
 PRINT #1, ECONOMY(X)
 PRINT #1, MONEY(X)
 PRINT #1, ARMY(X)
 PRINT #1, WEAPONS(X)
 PRINT #1, AGENTS(X)
 NEXT X
CLOSE #1
END SUB

SUB STATC (N AS INTEGER)
CLS
COLOR 15
LOCATE 1, 1: PRINT "Player Name     :";
LOCATE 2, 1: PRINT "Country Name    :";
LOCATE 3, 1: PRINT "Population      :";
LOCATE 4, 1: PRINT "Money           :";
LOCATE 5, 1: PRINT "Economy         :";
LOCATE 6, 1: PRINT "Technology Level:";
LOCATE 7, 1: PRINT "Tax Rate        :";
LOCATE 8, 1: PRINT "Army            :";
LOCATE 9, 1: PRINT "Weapons         :";
LOCATE 10, 1: PRINT "Agents          :";
LOCATE 11, 1: PRINT "Growth Rate     :";
LOCATE 12, 1: PRINT "Freedom Factor  :";
COLOR 14
LOCATE 1, 19: PRINT CP(N);
LOCATE 2, 19: PRINT CN(N);
LOCATE 3, 18: PRINT PEOPLE(N);
LOCATE 4, 18: PRINT MONEY(N);
LOCATE 5, 18: PRINT ECONOMY(N);
LOCATE 6, 18: PRINT TECH(N);
LOCATE 7, 18: PRINT TAXES(N);
LOCATE 8, 18: PRINT ARMY(N);
LOCATE 9, 18: PRINT WEAPONS(N);
LOCATE 10, 18: PRINT AGENTS(N);
LOCATE 11, 18: PRINT GROWTH(N);
LOCATE 12, 18: PRINT FREEDOM(N);
LOCATE 30, 1: COLOR 15: PRINT "Press ENTER to continue..."; : LA$ = INPUT$(1)
END SUB

SUB VICTORY (N AS INTEGER)
SCREEN 12
CALL MAP
RANDOMIZE TIMER
 WHILE TEMP < DELAY
 X = (RND * 639)
 Y = (RND * 479)
 PSET (X, Y), 0
 X = (RND * 639)
 Y = (RND * 479)
 PSET (X, Y), 0
 X = (RND * 639)
 Y = (RND * 479)
 PSET (X, Y), 0
 TEMP = TEMP + 1
 WEND
CLS
COLOR CCC(N): PRINT CP(N); " has won!"
NAME1$ = "The long war is over."
NAME2$ = "You have unified the warring nations under a single flag."
NAME3$ = "The thousand year old dream of emperors is now realized."
NAME4$ = "May all know your name for ages to come!"
 FOR Y = 1 TO 4
  FOR X = 1 TO 60
  IF Y = 1 THEN TEMP6$ = MID$(NAME1$, X, 1)
  IF Y = 2 THEN TEMP6$ = MID$(NAME2$, X, 1)
  IF Y = 3 THEN TEMP6$ = MID$(NAME3$, X, 1)
  IF Y = 4 THEN TEMP6$ = MID$(NAME4$, X, 1)
  FOR D = 1 TO DELAY: NEXT D
  LOCATE 4 + Y, X: COLOR 3: PRINT TEMP6$;
  NEXT X
 NEXT Y
LOCATE 30, 1: COLOR 15: INPUT "Press ENTER to continue...", LA$
CALL GOODBYE
END SUB

SUB WAR (N AS INTEGER)

'Inquire if it's turn 1
 IF TURN < 2 THEN
 CLS
 LOCATE 4, 1: COLOR 12: PRINT "It is only turn 1!"
 LOCATE 5, 1: COLOR 13: PRINT "All computer nations are helpless."
 LOCATE 6, 1: COLOR 14: PRINT "Try next turn!"
 LOCATE 30, 1: COLOR 15: PRINT "Press ENTER to continue..."; : LA$ = INPUT$(1)
 EXIT SUB
 END IF

'Inquire if there are no troops
 IF ARMY(N) < 1 THEN
 CLS
 LOCATE 4, 1: COLOR 12: PRINT "You have no troops!"
 LOCATE 30, 1: COLOR 15: PRINT "Press ENTER to continue..."; : LA$ = INPUT$(1)
 EXIT SUB
 END IF

'Inquire of the defender & setup for battle
CLS
CALL LISTPLAYERS
LOCATE 30, 1: COLOR 5: INPUT "Which country do you wish to invade"; W
RESULT = 0: TEMP = 0
GOSUB ICHECKA
EXIT SUB

'Invasion Control
INVADE:
ON ERROR GOTO ERRORPROC
   
        'Morale change
MORALE(N) = FREEDOM(N) + TECH(N) + WIN(N) + LOSS(N)
MORALE(W) = FREEDOM(W) + TECH(W) + WIN(W) + LOSS(W)

'Display pre-combat stats
CLS
COLOR 14
PRINT "Invasion!"
COLOR 15
LOCATE 3, 1: PRINT "Name:"
PRINT "# of People:"
PRINT "# of Soldiers:"
PRINT "# of Weapons:"
PRINT "Technology Rating:"
PRINT "Morale Rating:"
COLOR 10
LOCATE 3, 21: PRINT CN(N);
LOCATE 4, 20: PRINT PEOPLE(N);
LOCATE 5, 20: PRINT ARMY(N);
LOCATE 6, 20: PRINT WEAPONS(N);
LOCATE 7, 20: PRINT TECH(N);
LOCATE 8, 20: PRINT MORALE(N);
COLOR 13
LOCATE 3, 41: PRINT CN(W);
LOCATE 4, 40: PRINT PEOPLE(W);
LOCATE 5, 40: PRINT ARMY(W);
LOCATE 6, 40: PRINT WEAPONS(W);
LOCATE 7, 40: PRINT TECH(W);
LOCATE 8, 40: PRINT MORALE(W);
LOCATE 30, 1: COLOR 15: PRINT "Press ENTER to continue..."; : LA$ = INPUT$(1)

'Battle Display
CLS
COLOR 14
PRINT "Invasion!"
COLOR 15
LOCATE 3, 1: PRINT "Name:"
PRINT "# of People:"
PRINT "# of Soldiers:"
PRINT "# of Weapons:"
PRINT "Technology Rating:"
PRINT "Morale Rating:"
 WHILE RESULT < 1
 COLOR 10
 LOCATE 3, 21: PRINT CN(N);
 LOCATE 4, 20: PRINT PEOPLE(N);
 LOCATE 5, 20: PRINT ARMY(N);
 LOCATE 6, 20: PRINT WEAPONS(N);
 LOCATE 7, 20: PRINT TECH(N);
 LOCATE 8, 20: PRINT MORALE(N);
 COLOR 13
 LOCATE 3, 41: PRINT CN(W);
 LOCATE 4, 40: PRINT PEOPLE(W);
 LOCATE 5, 40: PRINT ARMY(W);
 LOCATE 6, 40: PRINT WEAPONS(W);
 LOCATE 7, 40: PRINT TECH(W);
 LOCATE 8, 40: PRINT MORALE(W);
 FOR D = 1 TO DELAY: NEXT D
 GOSUB BATTLE
 WEND
CLS
IF RESULT = 1 THEN GOSUB LOST
IF RESULT = 2 THEN GOSUB won
LOCATE 30, 1: COLOR 15: PRINT "Press ENTER to continue..."; : LA$ = INPUT$(1)
RETURN

'Actual Battle
BATTLE:
        'Is the defender helpless?
IF ARMY(W) < 2 THEN RESULT = 2
        'Defender is not helpless
 IF ARMY(W) > 1 THEN
        'Did either army collapse? Also corrects for negative soldiers.
  IF ARMY(N) < 1 THEN
  ARMY(N) = 0
  RESULT = 1
  END IF
  IF ARMY(W) < 1 THEN
  ARMY(W) = 0
  RESULT = 2
  END IF
        'Attack Power
 TEMP2 = CLNG(ARMY(N) + WEAPONS(N))
 TEMP3 = CLNG(TEMP2 / MORALE(N))
        'Defense Power
 TEMP4 = CLNG(ARMY(W) + WEAPONS(W))
 TEMP5 = CLNG(TEMP4 / MORALE(N))
        'Casualties
 ARMY(N) = CLNG(ARMY(N) - TEMP5)
 ARMY(W) = CLNG(ARMY(W) - TEMP3)
 WEAPONS(N) = CLNG(WEAPONS(N) - CLNG(TEMP5 / 10))
 WEAPONS(W) = CLNG(WEAPONS(W) - CLNG(TEMP3 / 10))
 PEOPLE(W) = CLNG(PEOPLE(W) - CLNG(TEMP5 / 8))
        'Correct for negative stuff
 IF ARMY(N) < 1 THEN ARMY(N) = 0
 IF ARMY(W) < 1 THEN ARMY(W) = 0
 IF WEAPONS(N) < 1 THEN WEAPONS(N) = 1
 IF WEAPONS(W) < 1 THEN WEAPONS(W) = 1
 IF PEOPLE(W) < 1 THEN PEOPLE(W) = 0
 END IF
RETURN

'You won!
won:
        'Display stats of current & occupied country
CLS
LOCATE 4, 1: COLOR 14: PRINT "You have won!"
COLOR 15
LOCATE 7, 1: PRINT "Name:"
PRINT "# of People:"
PRINT "# of Soldiers:"
PRINT "# of Weapons:"
PRINT "# of Spies:"
PRINT "Technology Rating:"
PRINT "Morale Rating:"
PRINT "Money:"
PRINT "Economic Factor:"
COLOR 10
LOCATE 7, 21: PRINT CN(N);
LOCATE 8, 20: PRINT PEOPLE(N);
LOCATE 9, 20: PRINT ARMY(N);
LOCATE 10, 20: PRINT WEAPONS(N);
LOCATE 11, 20: PRINT AGENTS(N);
LOCATE 12, 20: PRINT TECH(N);
LOCATE 13, 20: PRINT MORALE(N);
LOCATE 14, 20: PRINT MONEY(N);
LOCATE 15, 20: PRINT ECONOMY(N);
COLOR 13
LOCATE 7, 41: PRINT CN(W);
LOCATE 8, 40: PRINT PEOPLE(W);
LOCATE 9, 40: PRINT ARMY(W);
LOCATE 10, 40: PRINT WEAPONS(W);
LOCATE 11, 40: PRINT AGENTS(W);
LOCATE 12, 40: PRINT TECH(W);
LOCATE 13, 40: PRINT MORALE(W);
LOCATE 14, 40: PRINT MONEY(W);
LOCATE 15, 40: PRINT ECONOMY(W);
LOCATE 17: COLOR 3
PRINT "The conquered country will retain all but it's monetary assets."
PRINT "However, it will gain your technological advances."
PRINT "You will have to run it like it was another country."
PRINT "Use the Domestic menu to transfer goods to it."
COLOR 14: PRINT "May this be a great step to your global conquest!"

        'Take over country
CP(W) = CP(N)
CPC(W) = CPC(N)
CCC(W) = CPC(N)
CONTROL(W) = CONTROL(N)
STATUS(W) = STATUS(N)
FREEDOM(W) = FREEDOM(N)
TAXES(W) = TAXES(N)
WIN(N) = WIN(N) + 1
LOSS(W) = LOSS(W) + 1
MONEY(N) = MONEY(N) + MONEY(W)
MONEY(W) = 0
TECH(W) = TECH(N)
LOCATE 30, 1: COLOR 15: PRINT "Press ENTER to continue..."; : LA$ = INPUT$(1)
       
        'Ask for Auto-Control
CLS
LA$ = ""
COLOR 10: PRINT "Auto-Control"
LOCATE 4, 1: COLOR 15
PRINT "Auto-Control will allow your country to operate as though it was"
PRINT "under the computer's control, but with your flag. This can be"
PRINT "reversed with the Delegation submenu under Other."
LOCATE 15, 1: COLOR 15: PRINT "Enable Auto-Control (Y/N)?"; : LA$ = INPUT$(1)
LA$ = UCASE$(LA$)
IF LA$ = "Y" THEN STATUS(W) = 2
RETURN

'You lost!
LOST:
        'Display stats of current & targeted country
CLS
LOCATE 4, 1: COLOR 4: PRINT "Tattered lieutenants & generals return from failure."
COLOR 15
LOCATE 7, 1: PRINT "Name:"
PRINT "# of People:"
PRINT "# of Soldiers:"
PRINT "# of Weapons:"
PRINT "# of Spies:"
PRINT "Technology Rating:"
PRINT "Morale Rating:"
PRINT "Money:"
PRINT "Economic Factor:"
COLOR 10
LOCATE 7, 21: PRINT CN(N);
LOCATE 8, 20: PRINT PEOPLE(N);
LOCATE 9, 20: PRINT ARMY(N);
LOCATE 10, 20: PRINT WEAPONS(N);
LOCATE 11, 20: PRINT AGENTS(N);
LOCATE 12, 20: PRINT TECH(N);
LOCATE 13, 20: PRINT MORALE(N);
LOCATE 14, 20: PRINT MONEY(N);
LOCATE 15, 20: PRINT ECONOMY(N);
COLOR 13
LOCATE 7, 41: PRINT CN(W);
LOCATE 8, 40: PRINT PEOPLE(W);
LOCATE 9, 40: PRINT ARMY(W);
LOCATE 10, 40: PRINT WEAPONS(W);
LOCATE 11, 40: PRINT AGENTS(W);
LOCATE 12, 40: PRINT TECH(W);
LOCATE 13, 40: PRINT MORALE(W);
LOCATE 14, 40: PRINT MONEY(W);
LOCATE 15, 40: PRINT ECONOMY(W);
LOCATE 17: COLOR 3
WIN(W) = WIN(W) + 1
LOSS(N) = LOSS(N) + 1
RETURN

'Check invasion limits
ICHECKA:
        'Is this your country?
 IF N = W THEN
 CLS
 LOCATE 4, 1: COLOR 4: PRINT "You cannot invade your own country!"
 LOCATE 30, 1: COLOR 15: PRINT "Press ENTER to continue..."; : LA$ = INPUT$(1)
 TEMP = 1
 END IF
        'It's not your country
 IF N <> W THEN
                'Is the target invalid?
  IF N < 1 OR N > 10 THEN
  CLS
  LOCATE 4, 1: COLOR 4: PRINT "Invalid Target!"
  LOCATE 30, 1: COLOR 15: PRINT "Press ENTER to continue..."; : LA$ = INPUT$(1)
  TEMP = 1
  END IF
                'Is it already yours?
  IF CCC(N) = CCC(W) THEN
  CLS
  LOCATE 4, 1: COLOR 4: PRINT "You already deprived the target of Autonomy!"
  LOCATE 30, 1: COLOR 15: PRINT "Press ENTER to continue..."; : LA$ = INPUT$(1)
  TEMP = 1
  END IF
  IF TEMP = 0 THEN GOSUB ICHECKB
 END IF
RETURN

'Check to see if target is a neighbor
ICHECKB:
        'Country 1
 IF N = 1 THEN
  IF W = 2 THEN GOSUB INVADE
  IF W = 3 THEN GOSUB FARAWAY
  IF W = 4 THEN GOSUB INVADE
  IF W = 5 THEN GOSUB INVADE
  IF W = 6 THEN GOSUB FARAWAY
  IF W = 7 THEN GOSUB FARAWAY
  IF W = 8 THEN GOSUB FARAWAY
  IF W = 9 THEN GOSUB FARAWAY
  IF W = 10 THEN GOSUB FARAWAY
 END IF
        'Country 2
 IF N = 2 THEN
  IF W = 1 THEN GOSUB INVADE
  IF W = 3 THEN GOSUB INVADE
  IF W = 4 THEN GOSUB FARAWAY
  IF W = 5 THEN GOSUB INVADE
  IF W = 6 THEN GOSUB FARAWAY
  IF W = 7 THEN GOSUB INVADE
  IF W = 8 THEN GOSUB INVADE
  IF W = 9 THEN GOSUB FARAWAY
  IF W = 10 THEN GOSUB FARAWAY
 END IF
        'Country 3
 IF N = 3 THEN
  IF W = 1 THEN GOSUB FARAWAY
  IF W = 2 THEN GOSUB INVADE
  IF W = 4 THEN GOSUB FARAWAY
  IF W = 5 THEN GOSUB FARAWAY
  IF W = 6 THEN GOSUB FARAWAY
  IF W = 7 THEN GOSUB FARAWAY
  IF W = 8 THEN GOSUB INVADE
  IF W = 9 THEN GOSUB FARAWAY
  IF W = 10 THEN GOSUB FARAWAY
 END IF
        'Country 4
 IF N = 4 THEN
  IF W = 1 THEN GOSUB INVADE
  IF W = 2 THEN GOSUB FARAWAY
  IF W = 3 THEN GOSUB FARAWAY
  IF W = 5 THEN GOSUB INVADE
  IF W = 6 THEN GOSUB INVADE
  IF W = 7 THEN GOSUB FARAWAY
  IF W = 8 THEN GOSUB FARAWAY
  IF W = 9 THEN GOSUB INVADE
  IF W = 10 THEN GOSUB FARAWAY
 END IF
        'Country 5
 IF N = 5 THEN
  IF W = 1 THEN GOSUB INVADE
  IF W = 2 THEN GOSUB INVADE
  IF W = 3 THEN GOSUB FARAWAY
  IF W = 4 THEN GOSUB INVADE
  IF W = 6 THEN GOSUB INVADE
  IF W = 7 THEN GOSUB INVADE
  IF W = 8 THEN GOSUB FARAWAY
  IF W = 9 THEN GOSUB FARAWAY
  IF W = 10 THEN GOSUB FARAWAY
 END IF
        'Country 6
 IF N = 6 THEN
  IF W = 1 THEN GOSUB FARAWAY
  IF W = 2 THEN GOSUB FARAWAY
  IF W = 3 THEN GOSUB FARAWAY
  IF W = 4 THEN GOSUB INVADE
  IF W = 5 THEN GOSUB INVADE
  IF W = 7 THEN GOSUB INVADE
  IF W = 8 THEN GOSUB FARAWAY
  IF W = 9 THEN GOSUB INVADE
  IF W = 10 THEN GOSUB FARAWAY
 END IF
        'Country 7
 IF N = 7 THEN
  IF W = 1 THEN GOSUB FARAWAY
  IF W = 2 THEN GOSUB INVADE
  IF W = 3 THEN GOSUB FARAWAY
  IF W = 4 THEN GOSUB FARAWAY
  IF W = 5 THEN GOSUB INVADE
  IF W = 6 THEN GOSUB INVADE
  IF W = 8 THEN GOSUB INVADE
  IF W = 9 THEN GOSUB FARAWAY
  IF W = 10 THEN GOSUB INVADE
 END IF
        'Country 8
 IF N = 8 THEN
  IF W = 1 THEN GOSUB FARAWAY
  IF W = 2 THEN GOSUB INVADE
  IF W = 3 THEN GOSUB INVADE
  IF W = 4 THEN GOSUB FARAWAY
  IF W = 5 THEN GOSUB FARAWAY
  IF W = 6 THEN GOSUB FARAWAY
  IF W = 7 THEN GOSUB INVADE
  IF W = 9 THEN GOSUB FARAWAY
  IF W = 10 THEN GOSUB INVADE
 END IF
        'Country 9
 IF N = 9 THEN
  IF W = 1 THEN GOSUB FARAWAY
  IF W = 2 THEN GOSUB FARAWAY
  IF W = 3 THEN GOSUB FARAWAY
  IF W = 4 THEN GOSUB INVADE
  IF W = 5 THEN GOSUB FARAWAY
  IF W = 6 THEN GOSUB INVADE
  IF W = 7 THEN GOSUB FARAWAY
  IF W = 8 THEN GOSUB FARAWAY
  IF W = 10 THEN GOSUB INVADE
 END IF
        'Country 10
 IF N = 10 THEN
  IF W = 1 THEN GOSUB FARAWAY
  IF W = 2 THEN GOSUB FARAWAY
  IF W = 3 THEN GOSUB FARAWAY
  IF W = 4 THEN GOSUB FARAWAY
  IF W = 5 THEN GOSUB FARAWAY
  IF W = 6 THEN GOSUB FARAWAY
  IF W = 7 THEN GOSUB INVADE
  IF W = 8 THEN GOSUB INVADE
  IF W = 9 THEN GOSUB INVADE
 END IF
RETURN

'Border check failed!
FARAWAY:
CLS
LOCATE 4, 1: COLOR 4: PRINT "The target does not border yours!"
LOCATE 30, 1: COLOR 15: PRINT "Press ENTER to continue..."; : LA$ = INPUT$(1)
RETURN

END SUB

