DECLARE SUB scdpause ()
DECLARE SUB SCDPlay (BeginSec&, LengthSec&)
DECLARE SUB initCD ()
DECLARE SUB SCDTrackInfo (track%, start&, ctrl%)
DECLARE SUB SCDDiskInfo (Low%, High%, Leadout&)
DECLARE FUNCTION SCDDeviceStatus% ()
DECLARE FUNCTION RBAtoHSG& (RBAMin%, RBASec%, RBAFrm%)
DECLARE SUB Prepcb (code%)
DECLARE SUB Preprh (command%)
DECLARE SUB Call10 ()
DECLARE SUB InitDrives ()
DECLARE SUB GetDrives (numdrives%, first%)
DECLARE FUNCTION CheckMSCDEX% (major$, minor$)
DECLARE SUB Byte (Expression&, b1$, b2$, b3$, b4$)
DECLARE FUNCTION BitCheck% (Bit%, DecNum%)
DECLARE FUNCTION lbyte% (word%)
DECLARE FUNCTION hbyte% (word%)
DECLARE SUB GetTrack (lowest%, highest%, max&)
DECLARE SUB cht ()
DECLARE SUB loadgame ()
DECLARE SUB savgame ()
DECLARE SUB help ()
DECLARE SUB credits ()
DECLARE SUB conc ()
DECLARE FUNCTION conf% ()
DECLARE SUB pfont (text$, X%, Y%, colour%)
DECLARE SUB qfont (text$, X%, Y%, colour%)
TYPE PaletteType
red AS INTEGER
green AS INTEGER
blue AS INTEGER
END TYPE
DECLARE SUB palette.set (nColor%, pInfo AS PaletteType)
DECLARE SUB Palette.Get (nColor%, pInfo AS PaletteType)
DECLARE SUB palette.fadein ()
DECLARE SUB palette.fadeout ()
DECLARE SUB loadassembly ()
DECLARE SUB onkb ()
DECLARE SUB offkb ()
DECLARE SUB movelevel ()
DECLARE SUB drawlevel ()
DECLARE SUB raycast ()
DECLARE SUB project (wdth%, colour%, pixelno%)
DECLARE SUB scenary ()
DECLARE SUB gun ()
DECLARE SUB drawenemies ()
DECLARE SUB drawitems ()
DECLARE SUB checkdes (eno%)
DECLARE SUB checkf ()
DECLARE FUNCTION checkpace% ()
DECLARE SUB movenemy (eno%)
DECLARE SUB setp7 (tipe%)
DECLARE SUB loadlevel (mapfile$, itemfile$)
DECLARE SUB bar ()
DECLARE SUB intro ()
DECLARE FUNCTION playlevel% ()
DECLARE SUB rinit ()
DECLARE SUB pinit ()
DECLARE SUB menu ()
DECLARE FUNCTION checkexit% ()
DECLARE FUNCTION rand% ()
DECLARE SUB checkkey ()
DEFINT F
COMMON SHARED font()
DECLARE SUB playsfx (fx$)
'$INCLUDE: 'qb.bi'
DIM SHARED inregsx AS RegTypeX
DIM SHARED outregsx AS RegTypeX
TYPE tracktype
	start AS LONG
	length AS LONG
	ctrlinfo AS INTEGER
END TYPE

TYPE disktype
	Low     AS INTEGER
	High    AS INTEGER
	Leadout AS LONG
END TYPE

'$DYNAMIC
'----------------------------------------------------------------
'env/status vars
COMMON SHARED drv%, lowest%, highest%                'current drive
COMMON SHARED rhlength%             'length of request header
COMMON SHARED cblength%             'length of control block
COMMON SHARED max&                  'length of control block
COMMON SHARED numdrives AS INTEGER
ON ERROR GOTO errh
DIM SHARED drivearray(0, 0) AS INTEGER
DIM SHARED rh(Z) AS STRING * 1      'request header - dynamic array
DIM SHARED cb(Z) AS STRING * 1      'command block  - dynamic array
DIM SHARED trackinfo(Z) AS tracktype
DIM SHARED diskinfo(Z) AS disktype
								
'Define some default values

max& = 0

CLS
LOCATE 1, 1: COLOR 14, 4: PRINT STRING$(80, 32): LOCATE 1, 29: PRINT "Avenger 3d version 1.0": COLOR 15, 0
PRINT "loading FM register for 9 channels..."
DIM SHARED c$(8)   'FM register information for 9 channels
c$(0) = "&hB0&h20&h23&h40&h43&h60&h63&h80&h83&hA0&HBD&HC0&HE0&HE3&hB0"
c$(1) = "&hB1&h21&h24&h41&h44&h61&h64&h81&h84&hA1&HBD&HC1&HE1&HE4&hB1"
c$(2) = "&hB2&h22&h25&h42&h45&h62&h65&h82&h85&hA2&HBD&HC2&HE2&HE5&hB2"
c$(3) = "&hB3&h28&h2B&h48&h4B&h68&h6B&h88&h8B&hA3&HBD&HC3&HE8&HEB&hB3"
c$(4) = "&hB4&h29&h2C&h49&h4C&h69&h6C&h89&h8C&hA4&HBD&HC4&HE9&HEC&hB4"
c$(5) = "&hB5&h2A&h2D&h4A&h4D&h6A&h6D&h8A&h8D&hA5&HBD&HC5&HEA&HED&hB5"
c$(6) = "&hB6&h30&h33&h50&h53&h70&h73&h90&h93&hA6&HBD&HC6&HF0&HF3&hB6"
c$(7) = "&hB7&h31&h34&h51&h54&h71&h74&h91&h94&hA7&HBD&HC7&HF1&HF4&hB7"
c$(8) = "&hB8&h32&h35&h52&h55&h72&h75&h92&h95&hA8&HBD&HC8&HF2&HF5&hB8"
PRINT "loading sound effects [" + STRING$(14, 32) + "]"
LOCATE 3, 24
DIM SHARED sfx$(13)                          'dim array to hold 26 sounds
OPEN "out.sfx" FOR INPUT AS #1    'open the .SFX file
FOR sfxnum% = 0 TO 13                 'load all sounds
PRINT ".";
 INPUT #1, sfx$(sfxnum%)              'load sound into string
NEXT                                  'next
CLOSE #1                              'close the file
PRINT
PRINT "loading Fonts..."
DIM font(127, 4, 6)                   'DIM array for fonts
DEF SEG = VARSEG(font(0, 0, 0))       'Point to it
BLOAD "font.fnt", 0               'Load 'em in
PRINT "initializing variables..."
DIM SHARED pal AS PaletteType
DIM SHARED pData%(0 TO 255, 1 TO 3)
DIM SHARED ang, X, Y, map%, fr%, br%, lno%, enrgy%, tstart!, amm%, rkey%, bkey%, gkey%, ms$, mcount%, gf%
DIM SHARED l$, kbmatrix%(4), sund%, cros%, sped%, load%, tpst%, qwv%, cc%, ht%, cdro%, dtcd%
DIM SHARED e$(10), ex$(10), ey$(10), epo%(10), t%, rt%, ew1x%, ewy%, ew2x%
DIM SHARED en$(10), md$(10), am$(10)
DIM SHARED i$(10), amm$(10), wpn%
PRINT "allocating memory for graphics..."
DIM SHARED w%(1346)
DIM SHARED X%(4932)
DIM SHARED p%(664)
DIM SHARED Y%(14404)

PRINT "loading graphics [" + STRING$(30, 32) + "]"
LOCATE 7, 19
DEF SEG = VARSEG(Y%(0))
BLOAD "shooter.blk", VARPTR(Y%(0))
PRINT STRING$(15, 46);
DEF SEG = VARSEG(w%(0))
BLOAD "gun.blk", VARPTR(w%(0))
PRINT STRING$(3, 46);
DEF SEG = VARSEG(X%(0))
BLOAD "gun1.blk", VARPTR(X%(0))
PRINT STRING$(10, 46);
DEF SEG = VARSEG(p%(0))
BLOAD "pointer.blk", VARPTR(p%(0))
PRINT STRING$(2, 46)
PRINT "reading configuration file: " + CHR$(34) + "avenger.cfg" + CHR$(34)
OPEN "avenger.cfg" FOR BINARY AS #1
GET #1, , sund%
GET #1, , cros%
GET #1, , sped%
GET #1, , cdro%
CLOSE #1
IF COMMAND$ = "/NOCD" THEN
dtcd% = 1
PRINT "CD audio disabled."
PRINT "press any key to continue..."
SLEEP
ELSE
PRINT "initializing CD audio...";
initCD
SELECT CASE dtcd%
CASE 0: PRINT "done"
CASE 1: PRINT "audio tracks not found"
END SELECT
END IF
PRINT "launching..."
palette.fadeout
SCREEN 13
intro
restart:
menu
0 SCREEN 7, , 0, 1
CONST pi = 3.141592654#
loadassembly
IF load% = 0 THEN enrgy% = 100: str% = 1: CALL palette.fadeout
IF load% = 1 THEN str% = lno%
FOR lno% = str% TO 3
DO
IF load% = 0 THEN
CALL rinit
CALL setp7(0)
PCOPY 7, 1
palette.fadein
loadlevel "lv" + RIGHT$(STR$(lno%), LEN(STR$(lno%)) - 1) + ".dat", "it" + RIGHT$(STR$(lno%), LEN(STR$(lno%)) - 1) + ".dat"
END IF
IF load% = 1 THEN load% = 0
onkb
IF cdro% = 0 AND dtcd% = 0 THEN
RANDOMIZE TIMER
start& = trackinfo(lowest% + INT(RND * highest%)).start
SCDPlay start&, max&
END IF
res% = playlevel%
scdpause

offkb
LOOP WHILE res% = 2
setp7 (1)
PCOPY 7, 1
palette.fadein
SLEEP
palette.fadeout
tpst% = 0
NEXT
conc
GOTO restart
IF cc% = -1 THEN GOTO 0
SYSTEM


kf:
kbmatrix%(0) = 1
gf% = 1
RETURN

kfr:
kbmatrix%(0) = 0
RETURN

ku:
kbmatrix%(1) = 1
RETURN

kur:
kbmatrix%(1) = 0
RETURN

kl:
kbmatrix%(2) = 1
RETURN

klr:
kbmatrix%(2) = 0
RETURN

kr:
kbmatrix%(3) = 1
RETURN

krr:
kbmatrix%(3) = 0
RETURN

kd:
kbmatrix%(4) = 1
RETURN

kdr:
kbmatrix%(4) = 0
RETURN

map:
SELECT CASE map%
CASE 0: map% = 1: FOR nbv% = 2 TO 9: PALETTE nbv%, 0: NEXT
CASE 1: map% = 0: PCOPY 2, 1: PALETTE
END SELECT
RETURN

g1:
wpn% = 0
RETURN

g2:
wpn% = 1
RETURN

br:
SELECT CASE br%
CASE 0: br% = 1
CASE 1: br% = 0
END SELECT
RETURN

sg:
savgame
RETURN

cheat:
ht% = 1
RETURN

ext:
IF conf% = 0 THEN RETURN
scdpause

playsfx sfx$(9)
palette.fadeout
pinit
offkb
SCREEN 13
palette.fadeout
load% = 0
GOTO restart

errh:
scdpause

SCREEN 0: WIDTH 80:

PRINT ERL
ERROR ERR

SYSTEM

REM $STATIC
DEFSNG F
SUB bar
bc% = 1
uc% = 9
asd$ = "UL"
IF amm% > 0 AND wpn% = 1 THEN asd$ = RIGHT$(STR$(amm%), LEN(STR$(amm%)) - 1)
IF enrgy% < 21 THEN bc% = 4: uc% = 12
LINE (26, 170)-(128, 189), bc%, BF
LINE (26, 170)-(128, 189), uc%, B
LINE (225, 170)-(294, 189), 1, BF
LINE (225, 170)-(294, 189), 9, B
LINE (270, 10)-(310, 35), 5, BF
LINE (270, 10)-(310, 35), 13, B
pfont "Level:" + STR$(lno%), 6, 14, 2
pfont "Level:" + STR$(lno%), 5, 13, 11
pfont "keys", 275, 14, 13
pfont "Health:" + RIGHT$(STR$(enrgy%), LEN(STR$(enrgy%)) - 1), 38, 176, uc%
pfont "Ammo:" + asd$, 230, 176, 9
IF bkey% = 1 THEN qfont CHR$(12), 278, 24, 9
IF rkey% = 1 THEN qfont CHR$(12), 288, 24, 12
IF gkey% = 1 THEN qfont CHR$(12), 298, 24, 2
END SUB

FUNCTION BitCheck% (Bit%, DecNum%)
'This function checks if a certain bit in a number is set
'
'ARGS:  Bit%                - The number of the bit you want to check (0-15)
'       DecNum%             - The number you want to check
'RET:   Function Value      - 1 (1) = bit is set
'                             0 (0) = bit not set

IF (DecNum% AND 2 ^ Bit%) THEN
		BitCheck% = 1
	ELSE
		BitCheck% = 0
	END IF
END FUNCTION

SUB Byte (Expression&, b1$, b2$, b3$, b4$)
'This subroutine seperates a 4-byte number into its components.
'
'ARGS:  Expression& - 4-byte number
'       b1$         - string to store first byte in
'       b2$         - string to store second byte in
'       b3$         - string to store third byte in
'       b4$         - string to store fourth byte in
'RET:   Expression& - unchanged
'       b1$ - b4$   - containing the bytes

ts& = Expression&
b1$ = CHR$(ts& \ 2 ^ 24)
ts& = ts& MOD 2 ^ 24
b2$ = CHR$(ts& \ 2 ^ 16)
ts& = ts& MOD 2 ^ 16
b3$ = CHR$(ts& \ 2 ^ 8)
b4$ = CHR$(ts& MOD 2 ^ 8)
END SUB

SUB Call10 STATIC
' Calls function &H10 and takes care of filling in the
' selected drive, and the pointer to our request header
'
' ARGS:     None, but assumes that drivearray(), Drive,
'           and rh() are defined and ready
' RETS:     Nothing

'PRINT "Request Header length"; rhlength%
'FOR a = 1 TO rhlength%
'      PRINT ASC(rh(a));
'NEXT
'PRINT
'PRINT "Control Block length"; cblength%
'FOR a = 1 TO cblength%
'      PRINT ASC(cb(a));
'NEXT
'PRINT "drivearray"; drivearray(Drive, 1)
inregsx.ax = &H1510
inregsx.cx = drivearray(1, 1)
inregsx.es = VARSEG(rh(1))
inregsx.bx = VARPTR(rh(1))

CALL INTERRUPTX(&H2F, inregsx, outregsx)

'Check Error bit of Status field
IF BitCheck(7, ASC(rh(5))) = 1 THEN
dtcd% = 1: EXIT SUB
END IF
END SUB

SUB checkdes (eno%)
IF fr% = 1 AND POINT(0) >= 159 AND POINT(0) <= 161 AND POINT(1) < 100 THEN
FOR xc% = 159 TO 161
FOR v% = POINT(1) TO 100
IF POINT(xc%, v%) >= 10 THEN
d% = 1
END IF
NEXT
NEXT
IF d% = 0 THEN
epo%(eno%) = epo%(eno%) - 1: IF epo%(eno%) > 0 THEN playsfx sfx$(2)
IF epo%(eno%) = 0 THEN
playsfx sfx$(8)
e$(eno%) = "0": t% = 1: rt% = 100 - POINT(1)
END IF
END IF
END IF

END SUB

FUNCTION checkexit%
FOR kj% = 158 TO 161
FOR jk% = 99 TO 101
IF POINT(kj%, jk%) = 4 THEN checkexit% = 1
NEXT
NEXT
END FUNCTION

SUB checkf
RANDOMIZE TIMER
IF POINT(ew1x%, ewy%) = 6 AND RND > .8 THEN
playsfx sfx$(9)
enrgy% = enrgy% - rand%: IF enrgy% < 0 THEN enrgy% = 0
LINE (ew1x%, ewy%)-(145, 200), 13: LINE (ew1x%, ewy%)-(175, 200), 13:
PAINT (160, 199), 4, 13
ELSE
RANDOMIZE TIMER
IF POINT(ew2x%, ewy%) = 6 AND RND > .8 THEN
playsfx sfx$(9)
enrgy% = enrgy% - rand%: IF enrgy% < 0 THEN enrgy% = 0
LINE (ew2x%, ewy%)-(145, 200), 13: LINE (ew2x%, ewy%)-(175, 200), 13
PAINT (160, 199), 4, 13
END IF
END IF
END SUB

SUB checkkey
FOR kj% = 158 TO 161
FOR jk% = 99 TO 101
IF POINT(kj%, jk%) = 5 AND rkey% = 0 THEN rkey% = 1: ms$ = "Got red key": mcount% = 7: playsfx sfx$(5)
IF POINT(kj%, jk%) = 6 AND gkey% = 0 THEN gkey% = 1: ms$ = "Got green key": mcount% = 7: playsfx sfx$(5)
IF POINT(kj%, jk%) = 7 AND bkey% = 0 THEN bkey% = 1: ms$ = "Got blue key": mcount% = 7: playsfx sfx$(5)
NEXT
NEXT
END SUB

FUNCTION CheckMSCDEX% (major$, minor$)
'Check if MSCDEX is installed
'
'ARGS:  two strings which will hold the major and minor
'       version numbers
'RET:   major$          - major version number
'       minor$          - minor version number
'       function value  - 1 = MSCDEX installed
'                         0 = MSCDEX not installed

inregsx.ax = &H150C
inregsx.bx = &H0
CALL INTERRUPTX(&H2F, inregsx, outregsx)

IF hbyte(outregsx.bx) = 0 THEN
		CheckMSCDEX = 0
	ELSE
		CheckMSCDEX = 1
		major$ = LTRIM$(STR$(hbyte(outregsx.bx)))
		minor$ = LTRIM$(STR$(lbyte(outregsx.bx)))
	END IF
END FUNCTION

FUNCTION checkpace%
FOR kj% = 158 TO 161
FOR jk% = 99 TO 101
IF kj% = POINT(0) AND jk% = POINT(1) THEN checkpace% = 1
NEXT
NEXT
END FUNCTION

SUB cht
SCREEN 7, , 1, 1
qfont "Enter code:", 4, 4, 5
DO
DO: vf$ = INKEY$: IF vf$ = "" THEN vf$ = " ":
LOOP UNTIL (ASC(vf$) >= 97 AND ASC(vf$) <= 122) OR vf$ = CHR$(27) OR vf$ = CHR$(13)
IF vf$ = CHR$(27) THEN SCREEN 7, , 0, 1: EXIT SUB
g$ = g$ + vf$
qfont "Enter code:" + g$, 4, 4, 5
LOOP UNTIL vf$ = CHR$(13)
g$ = LEFT$(g$, LEN(g$) - 1)
SELECT CASE g$
CASE "s" + "t" + "b" + "r" + "v":
t$ = "God mode o"
SELECT CASE qwv%
CASE 0: qwv% = 1: ms$ = t$ + "n"
CASE 1: qwv% = 0: ms$ = t$ + "ff"
END SELECT
CASE "s" + "t" + "h" + "n" + "d":
amm% = 100
ms$ = "Got full ammo"
CASE "s" + "t" + "k" + "e" + "y" + "s"
bkey% = 1: gkey% = 1: rkey% = 1
ms$ = "Got all keys"
CASE "s" + "t" + "l" + "w" + "l":
t$ = "No clipping mode o"
SELECT CASE cc%
CASE 0: cc% = 1: ms$ = t$ + "n"
CASE 1: cc% = 0: ms$ = t$ + "ff"
END SELECT
CASE ELSE: ms$ = "Code incorrect"
END SELECT
mcount% = 7
SCREEN 7, , 0, 1
END SUB

SUB conc
offkb
SCREEN 13
CLS
palette.fadeout
DEF SEG = &HA000
BLOAD "con1.p13", 0
qfont CHR$(34) + "At last, here is someone", 23, 43, 4
qfont "worth my interest" + CHR$(34), 44, 53, 4
playsfx sfx$(7)
IF cdro% = 0 AND dtcd% = 0 THEN
RANDOMIZE TIMER
start& = trackinfo(lowest% + INT(RND * highest%)).start
SCDPlay start&, max&
END IF
palette.fadein
SLEEP 2
IF INKEY$ = CHR$(27) THEN CALL palette.fadeout: EXIT SUB
palette.fadeout
CLS
DEF SEG = &HA000
BLOAD "con2.p13", 0
qfont CHR$(34) + "Hey boss, this guy is good.", 135, 23, 149
qfont "I can't believe he made it this ", 135, 33, 149
qfont "far. I wonder how longer he will", 135, 43, 149
qfont "survive your robots. Boss, what", 135, 53, 149
qfont "do you say I go and finish him", 135, 63, 149
qfont "of right now? the guy looks like", 135, 73, 149
qfont "trouble to me." + CHR$(34), 135, 83, 149
palette.fadein
SLEEP 4
IF INKEY$ = CHR$(27) THEN CALL palette.fadeout: EXIT SUB
palette.fadeout
CLS
DEF SEG = &HA000
BLOAD "con1.p13", 0
qfont CHR$(34) + "No. I have other plans for him." + CHR$(34), 23, 43, 4
palette.fadein
SLEEP 1
IF INKEY$ = CHR$(27) THEN CALL palette.fadeout: EXIT SUB
palette.fadeout
CLS
re$ = "E N D  O F  D E M O  V E R S I O N"
DEF SEG = &HA000
BLOAD "title1.p13", 0
FOR de% = 31 TO 16 STEP -4
pfont re$, 23 + (de% - 15) / 4, 105 + (de% - 15) / 4, de%
pfont re$, 23 - (de% - 15) / 4, 105 + (de% - 15) / 4, de%
pfont re$, 23 + (de% - 15) / 4, 105 - (de% - 15) / 4, de%
pfont re$, 23 - (de% - 15) / 4, 105 - (de% - 15) / 4, de%
NEXT
pfont re$, 23, 105, 40
qfont "press any key...", 118, 138, 14
palette.fadein
SLEEP
playsfx sfx$(9)
pinit
palette.fadeout
load% = 0
scdpause

END SUB

DEFINT F
FUNCTION conf%
SCREEN 7, , 1, 1
qfont "Quit current game? (y/n)", 101, 96, 12
qfont "Quit current game? (y/n)", 100, 95, 11
SCREEN 7, , 0, 1
DO: w$ = INKEY$: LOOP UNTIL w$ = "y" OR w$ = "n"
IF w$ = "y" THEN conf% = 1
END FUNCTION

DEFSNG F
SUB credits
CLS
DEF SEG = &HA000
BLOAD "title1.p13", 0
qfont "Avenger 3d- compiled 17 sep 1998", 5, 5, 35
qfont "main programmer:" + "S" + "h" + "u" + "c" + "h" + "i" + "n" + " Md Taher (Bravo)", 5, 15, 35
qfont "sound & font routines by Tim Truman", 5, 25, 35
qfont "CD music routines by Marco Koegler and Toshihiro Horie", 5, 35, 35
qfont "special thanks to:", 5, 55, 2
qfont "All others who have participated in distributing it.", 5, 65, 2
qfont "Anyone who appreciates it.", 5, 75, 2
qfont "About Storm Group...", 5, 95, 43
qfont "We are a programming group and intend to devlope our own computer", 5, 105, 43
qfont "programmes. Our curent members are..", 5, 115, 43
qfont "Shuchin Md Taher alias Bravo ( thats me! )", 5, 125, 0
qfont "Mahfujul Haque Tanim alias Excel ( A no.1 lazy )", 5, 135, 0
qfont "Ahmed Anwar Hasan alias Sting ( Hopeless )", 5, 145, 0
qfont "Shuchin Md Taher alias Bravo ( thats me! )", 4, 124, 12
qfont "Mahfujul Haque Tanim alias Excel ( A no.1 lazy )", 4, 134, 12
qfont "Ahmed Anwar Hasan alias Sting ( Hopeless )", 4, 144, 12

qfont "Anyone willing to prove his/her competence is welcome to", 5, 155, 43
qfont "join us.", 5, 165, 43
qfont "our email address:dq@fsbd.net;ssv@bangla.net", 5, 175, 43
qfont "Phone:888966;9331016", 5, 185, 43
palette.fadein
SLEEP
palette.fadeout
CLS
END SUB

SUB drawenemies
FOR v% = 0 TO 10
DRAW "bm" + en$(v%)
IF e$(v%) = "9" THEN
movenemy (v%)
DRAW "bm" + ex$(v%) + "," + ey$(v%)
checkdes (v%)
DRAW "c" + e$(v%) + "u0"
IF map% = 1 AND e$(v%) = "9" AND POINT(0) < 170 AND POINT(0) > 150 AND POINT(1) < 110 AND POINT(1) > 90 AND RND > .8 THEN
playsfx sfx$(9)
enrgy% = enrgy% - rand%
IF enrgy% < 0 THEN enrgy% = 0
END IF
IF map% = 0 AND e$(v%) = "9" AND POINT(0) < 170 AND POINT(0) > 150 AND POINT(1) < 110 AND POINT(1) > 100 AND RND > .8 THEN
playsfx sfx$(9)
enrgy% = enrgy% - rand%
IF enrgy% < 0 THEN enrgy% = 0
END IF
SELECT CASE LEFT$(ex$(v%), 1)
CASE "-": vx$ = "+" + RIGHT$(ex$(v%), LEN(ex$(v%)) - 1)
CASE "+": vx$ = "-" + RIGHT$(ex$(v%), LEN(ex$(v%)) - 1)
END SELECT
SELECT CASE LEFT$(ey$(v%), 1)
CASE "-": vy$ = "+" + RIGHT$(ey$(v%), LEN(ey$(v%)) - 1)
CASE "+": vy$ = "-" + RIGHT$(ey$(v%), LEN(ey$(v%)) - 1)
END SELECT
DRAW "bm" + vx$ + "," + vy$
'DRAW "c1bu8u1"
END IF
NEXT
END SUB

SUB drawitems
FOR v% = 0 TO 10
DRAW "bm" + md$(v%)
IF i$(v%) = "2" THEN
IF enrgy% < 100 AND checkpace% THEN i$(v%) = "0": enrgy% = enrgy% + 25: playsfx sfx$(13): ms$ = "Picked up a medikit": mcount% = 7: IF enrgy% > 100 THEN enrgy% = 100
DRAW "c" + i$(v%) + "u0"
END IF
NEXT
FOR v% = 0 TO 10
DRAW "bm" + am$(v%)
IF amm$(v%) = "3" THEN
IF amm% < 100 AND checkpace THEN amm$(v%) = "0": amm% = amm% + 20: playsfx sfx$(12): ms$ = "Picked up Ammo for special weapon": mcount% = 7: IF amm% > 100 THEN amm% = 100
DRAW "c" + amm$(v%) + "u0"
END IF
NEXT

END SUB

SUB drawlevel
SELECT CASE X
CASE IS > 0: w$ = "bl" + STR$(CINT(X))
CASE IS < 0: w$ = "br" + STR$(CINT(-1 * X))
END SELECT
SELECT CASE Y
CASE IS > 0: u$ = "bd" + STR$(CINT(Y))
CASE IS < 0: u$ = "bu" + STR$(CINT(-1 * Y))
END SELECT

DRAW "bm160,100ta" + STR$(-ang) + w$ + u$ + l$
drawenemies
drawitems
checkkey
IF map% = 1 THEN PSET (160, 100)
END SUB

SUB GetDrives (numdrives%, first%)
' Gets the number of drives installed on a system and
' the drive letter number of the first drive
'
' ARGS: two integers which will hold the returned
'       values
' RET:  numdrives%      - total number of CD-ROMs
'       first%          - drive letter number of first
'                         drive on system

inregsx.ax = &H1500
inregsx.bx = &H0
inregsx.cx = &H0

CALL INTERRUPTX(&H2F, inregsx, outregsx)

numdrives% = outregsx.bx
first% = outregsx.cx
END SUB

DEFINT A-Z
SUB GetTrack (lowest%, highest%, max&) STATIC
REDIM trackinfo(lowest% TO highest%) AS tracktype
'LOCATE 9, 1: COLOR 15, 3
' GETTRACK
' pre: lowest and highest track numbers
' ret: trackinfo array with start,length, and ctrlinfo in HSG format

FOR trk% = lowest% TO highest%
	'PRINT "TRACK="; trk%,
	SCDTrackInfo trk%, start&, ctrl%
	trackinfo(trk%).ctrlinfo = ctrl%

	trackinfo(trk%).start = start&
	'PRINT "track start="; trackinfo(trk%).start,
	IF trk% <> lowest% THEN
		trackinfo(trk% - 1).length = trackinfo(trk%).start - trackinfo(trk% - 1).start
	END IF

	'PRINT "track control info"; trackinfo(trk%).ctrlinfo
	AudioTrack = 1 XOR BitCheck(6, trackinfo(trk%).ctrlinfo)
	IF NOT AudioTrack AND highest% = lowest% THEN
		dtcd% = 1: EXIT SUB
	END IF

NEXT trk%
trackinfo(highest%).length = max& - trackinfo(highest%).start
END SUB

DEFSNG A-Z
SUB gun
IF amm% = 0 AND wpn% = 1 THEN
ms$ = "No Ammo available for special weapon.": mcount% = 7
wpn% = 0
END IF
STATIC gseq
SELECT CASE gseq
CASE 0: gseq = 1
CASE 1: gseq = 0
END SELECT
SELECT CASE wpn%
CASE 0
IF fr% = 1 THEN
CIRCLE (161, 127), 17, 14
DRAW "bm161,127p14,14"
playsfx sfx$(3)
END IF
DRAW "c0bm160,200 m161,194m155,166m165,159m155,139m155,125m167,122m182,129m187,157m202,157m213,200 m160,200bm170,198p0,0bm170,170p0,0bm170,125p0,0bm180,190p0,0"
PUT (155, 115), w%, XOR
CASE 1
IF fr% = 1 THEN
playsfx sfx$(1)
IF gseq = 0 THEN
amm% = amm% - 1: IF amm% = 0 THEN wpn% = 0
CIRCLE (161, 150), 19, 14
DRAW "bm161,147p14,14"
CIRCLE (183, 150), 19, 14
DRAW "bm183,147p14,14"
CIRCLE (204, 150), 19, 14
DRAW "bm204,147p14,14"
END IF
END IF
LINE (157, 150)-(216, 200), 0, BF
LINE (91, 175)-(156, 200), 0, BF
LINE (217, 170)-(238, 200), 0, BF
DRAW "c0bm80,199m80,189m90,179m90,175m106,170m122,170m131,167m137,170m156,170m151,161m155,157m155,150m167,144m177,147m187,144m197,147m204,144m211,145m228,158m228,163m231,163m256,185m256,199m80,199"
DRAW "bm89,190p0,0bm105,173p0,0bm155,163p0,0bm165,147p0,0bm225,163p0,0bm242,190p0,0"
PUT (70, 144), X%, XOR
END SELECT
IF cros% = 0 THEN DRAW "c14bm156,100m164,100bm160,96m160,104"
END SUB

FUNCTION hbyte% (word%)
'Returns the high byte of a 2-byte number (INNTEGER)
'
'ARGS:  word%               - 2-byte number (INTEGER)
'RET:   Function Value      - High byte or word%

IF word% >= 0 THEN
		hbyte% = word% \ 256
	ELSE
		hbyte% = (65536 + word%) \ 256
	END IF
END FUNCTION

SUB help
CLS
DEF SEG = &HA000
BLOAD "title1.p13", 0

fpos% = 3: GOSUB hlp
fpos% = 2: ec% = 43: ce% = 42: GOSUB hlp
palette.fadein
SLEEP
palette.fadeout
CLS
EXIT SUB
hlp:
qfont "Avenger 3d- compiled 17 sep 1998", fpos% + 3, fpos%, ec%
qfont "Game controls:", fpos% + 3, fpos% + 10, ec%
qfont "forward:up arrow key", fpos% + 3, fpos% + 20, ec%
qfont "backward:down arrow key", fpos% + 3, fpos% + 30, ec%
qfont "left:left arrow key", fpos% + 3, fpos% + 40, ec%
qfont "right:right arrow key", fpos% + 3, fpos% + 50, ec%
qfont "fire:control key", fpos% + 3, fpos% + 60, ec%
qfont "troggle map mode:tab", fpos% + 3, fpos% + 70, ec%
qfont "abort game:f1", fpos% + 3, fpos% + 80, ec%
qfont "select normal weapon:f2", fpos% + 3, fpos% + 90, ec%
qfont "select special weapon:f3", fpos% + 3, fpos% + 100, ec%
qfont "troggle status bar:f4", fpos% + 3, fpos% + 110, ec%
qfont "save game:f5", fpos% + 3, fpos% + 120, ec%
qfont "use cheat code:f6", fpos% + 3, fpos% + 130, ec%
qfont "Game story:", fpos% + 3, fpos% + 140, ce%
qfont "You are a mercenary trapped in a 3D world. To escape", fpos% + 3, fpos% + 150, ce%
qfont "alive, you have no other choice but to kill your way", fpos% + 3, fpos% + 160, ce%
qfont "through. To complete each level you have to collect all", fpos% + 3, fpos% + 170, ce%
qfont "three keys, the Red key, the Blue key and the Green", fpos% + 3, fpos% + 180, ce%
qfont "key, and find the spot marked EXIT.", fpos% + 3, fpos% + 190, ce%
RETURN
END SUB

SUB initCD
IF CheckMSCDEX(major$, minor$) = 0 THEN dtcd% = 1: EXIT SUB
InitDrives
drv% = drivearray(1, 1):
status% = SCDDeviceStatus
IF BitCheck(4, status%) = 0 THEN
	dtcd% = 1: EXIT SUB
END IF
SCDDiskInfo lowest%, highest%, max&
status% = SCDDeviceStatus
IF highest% = 0 THEN
dtcd% = 1: EXIT SUB
END IF
GetTrack lowest%, highest%, max&
END SUB

SUB InitDrives
' Modifies the array passed to it and stores the Drive
' Management Structure in it
'
' ARGS: An integer array which will hold the returned
'       values
' RET:  drivearray()    - Drive Management Structure
'    ** Drive           - Sets default drive to 1 (Drive is init. HERE!)

GetDrives numdrives%, first%

DIM temp1(1 TO numdrives% * 5) AS STRING * 1
DIM temp2(1 TO numdrives%) AS STRING * 1
REDIM drivearray(1 TO numdrives%, 1 TO 2) AS INTEGER

inregsx.ax = &H1501
inregsx.es = VARSEG(temp1(1))
inregsx.bx = VARPTR(temp1(1))
CALL INTERRUPTX(&H2F, inregsx, outregsx)

inregsx.ax = &H150D
inregsx.es = VARSEG(temp2(1))
inregsx.bx = VARPTR(temp2(1))
CALL INTERRUPTX(&H2F, inregsx, outregsx)

FOR X = 1 TO numdrives%
	drivearray(X, 1) = ASC(temp2(X))
	drivearray(X, 2) = ASC(temp1(1 + (X - 1) * 5))
NEXT X
END SUB

SUB intro
palette.fadeout
DEF SEG = &HA000
BLOAD "title.p13", 0
palette.fadein
SLEEP 1
palette.fadeout
CLS
IF cdro% = 0 AND dtcd% = 0 THEN
RANDOMIZE TIMER
start& = trackinfo(lowest% + INT(RND * highest%)).start
SCDPlay start&, max&
END IF
DEF SEG = &HA000
BLOAD "title1.p13", 0
playsfx sfx$(11)
palette.fadein
SLEEP 2
palette.fadeout
END SUB

FUNCTION lbyte% (word%)
'Returns the low byte of a 2-byte number (INNTEGER)
'
'ARGS:  word%               - 2-byte number (INTEGER)
'RET:   Function Value      - Low byte or word%

IF word% >= 0 THEN
		lbyte% = word% MOD 256
	ELSE
		lbyte% = (65536 + word%) MOD 256
	END IF
END FUNCTION

SUB loadassembly
KEY 15, CHR$(0) + CHR$(&HF)
KEY 16, CHR$(0) + CHR$(&H1D)
KEY 17, CHR$(0) + CHR$(128 + &H1D)
KEY 18, CHR$(&H80) + CHR$(72)
KEY 19, CHR$(&H80) + CHR$(200)
KEY 20, CHR$(&H80) + CHR$(75)
KEY 21, CHR$(&H80) + CHR$(203)
KEY 22, CHR$(&H80) + CHR$(77)
KEY 23, CHR$(&H80) + CHR$(205)
KEY 24, CHR$(&H80) + CHR$(80)
KEY 25, CHR$(&H80) + CHR$(208)
ON KEY(1) GOSUB ext
ON KEY(6) GOSUB cheat
ON KEY(15) GOSUB map
ON KEY(16) GOSUB kf
ON KEY(17) GOSUB kfr
ON KEY(18) GOSUB ku
ON KEY(19) GOSUB kur
ON KEY(20) GOSUB kl
ON KEY(21) GOSUB klr
ON KEY(22) GOSUB kr
ON KEY(23) GOSUB krr
ON KEY(24) GOSUB kd
ON KEY(25) GOSUB kdr
ON KEY(2) GOSUB g1
ON KEY(3) GOSUB g2
ON KEY(4) GOSUB br
ON KEY(5) GOSUB sg
END SUB

SUB loadgame
LINE (172, 153)-(300, 173), 0, BF
pfont "Enter slot no(1-9)", 172, 155, 1
pfont "Enter slot no(1-9)", 174, 153, 32
DO: w$ = INKEY$: LOOP UNTIL (VAL(w$) > 0 AND VAL(w$) < 10) OR w$ = CHR$(27)
IF w$ = CHR$(27) THEN EXIT SUB
OPEN "sav" + RIGHT$(STR$(VAL(w$)), 1) + ".sav" FOR INPUT AS #1
INPUT #1, ang:
INPUT #1, X:
INPUT #1, Y:
INPUT #1, map%:
INPUT #1, br%
INPUT #1, t%:
INPUT #1, rt%:
INPUT #1, wpn%:
INPUT #1, lno%
INPUT #1, bkey%:
INPUT #1, rkey%:
INPUT #1, gkey%
INPUT #1, amm%
INPUT #1, enrgy%
INPUT #1, tpst%
FOR w% = 0 TO 10
LINE INPUT #1, e$(w%)
INPUT #1, epo%(w%)
LINE INPUT #1, ex$(w%)
LINE INPUT #1, ey$(w%)
LINE INPUT #1, i$(w%)
LINE INPUT #1, amm$(w%)
NEXT
CLOSE #1
OPEN "lv" + RIGHT$(STR$(lno%), LEN(STR$(lno%)) - 1) + ".dat" FOR INPUT AS #1
l$ = ""
DO
INPUT #1, gh%
l$ = l$ + CHR$(gh%)
LOOP UNTIL EOF(1)
CLOSE #1
load% = 1
OPEN "it" + RIGHT$(STR$(lno%), LEN(STR$(lno%)) - 1) + ".dat" FOR INPUT AS #1
FOR v = 0 TO 10
LINE INPUT #1, en$(v)
NEXT
FOR v = 0 TO 10
LINE INPUT #1, md$(v)
NEXT
FOR v = 0 TO 10
LINE INPUT #1, am$(v)
NEXT
CLOSE #1
END SUB

SUB loadlevel (m$, it$)
l$ = ""
OPEN m$ FOR INPUT AS #1
DO
INPUT #1, gh%
l$ = l$ + CHR$(gh%)
LOOP UNTIL EOF(1)
CLOSE #1
FOR w% = 0 TO 10
e$(w%) = "9"
epo%(w%) = 2
ex$(w%) = "+0": ey$(w%) = "+0"
i$(w%) = "2"
amm$(w%) = "3"
NEXT

OPEN it$ FOR INPUT AS #1
FOR v = 0 TO 10
LINE INPUT #1, en$(v)
NEXT
FOR v = 0 TO 10
LINE INPUT #1, md$(v)
NEXT
FOR v = 0 TO 10
LINE INPUT #1, am$(v)
NEXT
CLOSE #1
END SUB

SUB menu
STATIC mmu%
IF cdro% = 0 AND dtcd% = 0 THEN
IF mmu% = 0 THEN
RANDOMIZE TIMER
mmu% = lowest% + INT(RND * highest%)
END IF
start& = trackinfo(mmu%).start
SCDPlay start&, max&
END IF
DIM snd$(1)
snd$(0) = "on"
snd$(1) = "off"
playsfx sfx$(10)
2 FOR c5% = 1 TO 20
u$ = INKEY$
NEXT
DEF SEG = &HA000
BLOAD "menu.p13", 0
PUT (104, 18 + pp% * 35), p%, XOR:
palette.fadein
DO
SELECT CASE INKEY$
CASE CHR$(0) + "H"
IF pp% > 0 THEN
playsfx sfx$(4)
PUT (104, 18 + pp% * 35), p%, XOR:
pp% = pp% - 1:
PUT (104, 18 + pp% * 35), p%, XOR
END IF
CASE CHR$(0) + "P"
IF pp% < 4 THEN
playsfx sfx$(4)
PUT (104, 18 + pp% * 35), p%, XOR:
pp% = pp% + 1:
PUT (104, 18 + pp% * 35), p%, XOR
END IF
CASE CHR$(13):
playsfx sfx$(6)
EXIT DO
END SELECT
LOOP
SELECT CASE pp%
CASE 0
palette.fadeout
scdpause

EXIT SUB
CASE 1
3 LINE (100, 0)-(320, 200), 0, BF
PUT (120, 48 + np% * 35), p%
pfont "GAME OPTIONS", 172, 15, 4
pfont "Sound:" + snd$(sund%), 172, 50, 1
pfont "Crosshair:" + snd$(cros%), 172, 85, 1
pfont "Game slowth:" + STR$(sped%), 172, 120, 1
pfont "Load game", 172, 155, 1
pfont "GAME OPTIONS", 174, 13, 40
pfont "Sound:" + snd$(sund%), 174, 48, 32
pfont "Crosshair:" + snd$(cros%), 174, 83, 32
pfont "Game slowth:" + STR$(sped%), 174, 118, 32
pfont "Load game", 174, 153, 32
DO
SELECT CASE INKEY$
CASE CHR$(0) + "H"
IF np% > 0 THEN
PUT (120, 48 + np% * 35), p%
playsfx (sfx$(4))
np% = np% - 1
PUT (120, 48 + np% * 35), p%
END IF
CASE CHR$(0) + "P"
IF np% < 3 THEN
PUT (120, 48 + np% * 35), p%
playsfx (sfx$(4))
np% = np% + 1
PUT (120, 48 + np% * 35), p%
END IF
CASE CHR$(13):
SELECT CASE np%
CASE 0
SELECT CASE sund%
CASE 0: sund% = 1: cdro% = 1
CASE 1: sund% = 0: cdro% = 0
END SELECT
CASE 1
SELECT CASE cros%
CASE 0: cros% = 1
CASE 1: cros% = 0
END SELECT
CASE 3
loadgame
IF load% = 1 THEN EXIT SUB ELSE GOTO 3
END SELECT
GOTO 3
CASE CHR$(27)
playsfx sfx$(6)
palette.fadeout
CLS : GOTO 2
CASE CHR$(0) + "K": IF np% = 2 AND sped% > 0 THEN sped% = sped% - 1: GOTO 3
CASE CHR$(0) + "M": IF np% = 2 AND sped% < 999 THEN sped% = sped% + 1: GOTO 3
END SELECT
LOOP



CASE 2:
palette.fadeout
credits
GOTO 2
CASE 3
palette.fadeout
help
GOTO 2

CASE 4:
palette.fadeout
scdpause

OPEN "avenger.cfg" FOR BINARY AS #1
PUT #1, , sund%
PUT #1, , cros%
PUT #1, , sped%
PUT #1, , cdro%
CLOSE #1
SYSTEM
END SELECT
END SUB

SUB movelevel
STATIC chance%
STATIC scount%
scount% = scount% + 1: IF scount% = 4 THEN scount% = 0
IF kbmatrix%(1) THEN
'IF POINT(160, 95) <= 0 AND POINT(160, 96) <= 0 AND POINT(160, 97) <= 0 AND POINT(160, 98) <= 0 AND POINT(160, 99) <= 0 THEN
IF (POINT(159, 98) <= 9 AND POINT(160, 98) <= 9 AND POINT(161, 98) <= 9) OR cc% = 1 THEN
IF (POINT(159, 97) <= 9 AND POINT(160, 97) <= 9 AND POINT(161, 97) <= 9) OR cc% = 1 THEN
IF (POINT(159, 96) <= 9 AND POINT(160, 96) <= 9 AND POINT(161, 96) <= 9) OR cc% = 1 THEN
IF scount% = 0 THEN playsfx sfx$(0)
X = X - 3 * SIN(ang * pi / 180)
Y = Y + 3 * COS(ang * pi / 180)
END IF
END IF
END IF
END IF
IF kbmatrix%(2) THEN
ang = ang + 15: ang = ang MOD 360
END IF
IF kbmatrix%(3) THEN
ang = ang - 15: ang = ang + 360: ang = ang MOD 360
END IF
IF kbmatrix%(4) THEN
'IF POINT(160, 105) <= 0 AND POINT(160, 104) <= 0 AND POINT(160, 103) <= 0 AND POINT(160, 102) <= 0 AND POINT(160, 101) <= 0 THEN
IF (POINT(159, 101) <= 9 AND POINT(160, 101) <= 9 AND POINT(161, 101) <= 9) OR cc% = 1 THEN
IF (POINT(159, 102) <= 9 AND POINT(160, 102) <= 9 AND POINT(161, 102) <= 9) OR cc% = 1 THEN
IF (POINT(159, 103) <= 9 AND POINT(160, 103) <= 9 AND POINT(161, 103) <= 9) OR cc% = 1 THEN
IF scount% = 0 THEN playsfx sfx$(0)
X = X + 3 * SIN(ang * pi / 180)
Y = Y - 3 * COS(ang * pi / 180)
END IF
END IF
END IF
END IF
fr% = 0
IF kbmatrix%(0) = 1 AND wpn% = 1 THEN
fr% = 1
END IF
IF wpn% = 0 AND gf% = 1 AND chance% = 1 THEN fr% = 1: gf% = 0: chance% = 0: 'playsfx sfx$(3)
IF kbmatrix%(0) = 0 THEN chance% = 1
END SUB

SUB movenemy (eno%)
RANDOMIZE TIMER
vx$ = ex$(eno%): vy$ = ey$(eno%)
DRAW "bm" + vx$ + "," + vy$
SELECT CASE RND

CASE IS < .25
DRAW "bm-1,+0": GOSUB check
DRAW "bm+0,+1": GOSUB check
DRAW "bm+0,-2": GOSUB check
IF clip% = 0 THEN
ex$(eno%) = STR$(VAL(ex$(eno%)) - 1)
IF LEFT$(ex$(eno%), 1) <> "-" THEN ex$(eno%) = "+" + ex$(eno%)
END IF
DRAW "bm+1,+1"

CASE .25 TO .5
DRAW "bm+0,-1": GOSUB check
DRAW "bm+1,+0": GOSUB check
DRAW "bm-2,+0": GOSUB check
IF clip% = 0 THEN
ey$(eno%) = STR$(VAL(ey$(eno%)) - 1)
IF LEFT$(ey$(eno%), 1) <> "-" THEN ey$(eno%) = "+" + ey$(eno%)
END IF
DRAW "bm+1,+1"

CASE .5 TO .75
DRAW "bm+0,+1": GOSUB check
DRAW "bm+1,+0": GOSUB check
DRAW "bm-2,+0": GOSUB check
IF clip% = 0 THEN
ey$(eno%) = STR$(VAL(ey$(eno%)) + 1)
IF LEFT$(ey$(eno%), 1) <> "-" THEN ey$(eno%) = "+" + ey$(eno%)
END IF
DRAW "bm+1,-1"

CASE IS > .75
DRAW "bm+1,+0": GOSUB check
DRAW "bm+0,+1": GOSUB check
DRAW "bm+0,-2": GOSUB check
IF clip% = 0 THEN
ex$(eno%) = STR$(VAL(ex$(eno%)) + 1)
IF LEFT$(ex$(eno%), 1) <> "-" THEN ex$(eno%) = "+" + ex$(eno%)
END IF
DRAW "bm-1,+1"
END SELECT
SELECT CASE LEFT$(vx$, 1)
CASE "-": vx$ = "+" + RIGHT$(vx$, LEN(vx$) - 1)
CASE "+": vx$ = "-" + RIGHT$(vx$, LEN(vx$) - 1)
END SELECT
SELECT CASE LEFT$(vy$, 1)
CASE "-": vy$ = "+" + RIGHT$(vy$, LEN(vy$) - 1)
CASE "+": vy$ = "-" + RIGHT$(vy$, LEN(vy$) - 1)
END SELECT

DRAW "bm" + vx$ + "," + vy$
EXIT SUB

check:
IF POINT(POINT(0), POINT(1)) >= 10 THEN clip% = 1
RETURN

END SUB

SUB offkb
KEY(1) OFF
KEY(2) OFF
KEY(3) OFF
KEY(4) OFF
KEY(5) OFF
KEY(6) OFF
KEY(15) OFF
KEY(16) OFF
KEY(17) OFF
KEY(18) OFF
KEY(19) OFF
KEY(20) OFF
KEY(21) OFF
KEY(22) OFF
KEY(23) OFF
KEY(24) OFF
KEY(25) OFF
END SUB

SUB onkb
KEY(1) ON
KEY(2) ON
KEY(3) ON
KEY(4) ON
KEY(5) ON
KEY(6) ON
KEY(15) ON
KEY(16) ON
KEY(17) ON
KEY(18) ON
KEY(19) ON
KEY(20) ON
KEY(21) ON
KEY(22) ON
KEY(23) ON
KEY(24) ON
KEY(25) ON
END SUB

DEFINT A-Z
SUB palette.fadein
DIM tT(1 TO 3)
FOR i = 1 TO 64
WAIT &H3DA, 8, 8
  FOR o = 0 TO 255
    Palette.Get o, pal
    tT(1) = pal.red
    tT(2) = pal.green
    tT(3) = pal.blue
    IF tT(1) < pData(o, 1) THEN tT(1) = tT(1) + 1
    IF tT(2) < pData(o, 2) THEN tT(2) = tT(2) + 1
    IF tT(3) < pData(o, 3) THEN tT(3) = tT(3) + 1
    pal.red = tT(1)
    pal.green = tT(2)
    pal.blue = tT(3)
    palette.set o, pal
  NEXT o
NEXT i

END SUB

DEFSNG A-Z
SUB palette.fadeout
DIM tT%(1 TO 3)
FOR i% = 0 TO 255
  Palette.Get i%, pal
  pData%(i%, 1) = pal.red
  pData%(i%, 2) = pal.green
  pData%(i%, 3) = pal.blue
NEXT i%
FOR i% = 1 TO 64
WAIT &H3DA, 8, 8
  FOR o% = 0 TO 255
    Palette.Get o%, pal
    tT%(1) = pal.red
    tT%(2) = pal.green
    tT%(3) = pal.blue
    IF tT%(1) > 0 THEN tT%(1) = tT%(1) - 1
    IF tT%(2) > 0 THEN tT%(2) = tT%(2) - 1
    IF tT%(3) > 0 THEN tT%(3) = tT%(3) - 1
    pal.red = tT%(1)
    pal.green = tT%(2)
    pal.blue = tT%(3)
    palette.set o%, pal
  NEXT o%
NEXT i%
END SUB

SUB Palette.Get (nColor%, pInfo AS PaletteType)
OUT &H3C6, &HFF
OUT &H3C7, nColor%
pInfo.red = INP(&H3C9)
pInfo.green = INP(&H3C9)
pInfo.blue = INP(&H3C9)
END SUB

DEFINT A-Z
SUB palette.set (nColor%, pInfo AS PaletteType)
OUT &H3C6, &HFF
OUT &H3C8, nColor%
OUT &H3C9, pInfo.red
OUT &H3C9, pInfo.green
OUT &H3C9, pInfo.blue
END SUB

SUB pfont (text$, X, Y, colour)


DEF SEG = &HFFA6
FOR piece = 1 TO LEN(text$)
	address = (8 * ASC(MID$(text$, piece))) + 14
	FOR hl = 0 TO 7
		mask = PEEK(address + hl) * 128
		LINE (X + kernx, Y + hl)-(X + 8 + kernx, Y + hl), colour, , mask
	NEXT
 kernx = kernx + 8
NEXT
'x = 0
DEF SEG

END SUB

DEFSNG A-Z
SUB pinit
ang = 0: X = 0: Y = 0: map% = 0: fr% = 0: br% = 0
t% = 0: rt% = 0: ew1x% = 0: ewy% = 0: ew2x% = 0
wpn% = 0: lno% = 0
bkey% = 0: rkey% = 0: gkey% = 0
ms$ = "": mcount% = 0: gf% = 0: amm% = 0
FOR v% = 0 TO 4: kbmatrix%(v%) = 0: NEXT
cc% = 0: qwv% = 0
ht% = 0
END SUB

FUNCTION playlevel%
STATIC ocnt%
tstart! = TIMER
playsfx sfx$(7)
DO
movelevel
IF sped% <> 0 THEN
FOR rcc% = 1 TO sped%
FOR rcr% = 1 TO 1000: NEXT
NEXT
END IF
CLS
drawlevel

raycast
IF ht% = 1 AND ocnt% = 1 THEN ht% = 0: ocnt% = 0: cht
IF ht% = 1 AND ocnt% = 0 THEN ocnt% = 1
DEF SEG = 0
POKE 1047, 128

SELECT CASE map%
CASE 0: PCOPY 2, 1
CASE 1: PCOPY 0, 1
END SELECT
IF checkexit% THEN
IF rkey% AND bkey% AND gkey% THEN
playsfx sfx$(10)
playlevel% = 1: palette.fadeout: EXIT FUNCTION
ELSE
playsfx sfx$(6)
SCREEN 7, , 2, 1
ms$ = "You must have all three keys to exit the level": mcount% = 7
SCREEN 7, , 0, 1
END IF
END IF
IF enrgy% = 0 THEN playsfx sfx$(11): playlevel% = 2: palette.fadeout: enrgy% = 100: amm% = 0: EXIT FUNCTION
LOOP
END FUNCTION

SUB playsfx (sfx$)
IF sund% = 1 THEN EXIT SUB
chan% = VAL(MID$(sfx$, 61, 4))
FOR in = 1 TO 60 STEP 4
  reg$ = MID$(c$(chan%), in, 4): reg% = VAL(reg$)
  dat$ = MID$(sfx$, in, 4): dat% = VAL(dat$)
  OUT &H388, reg%: FOR d% = 1 TO 6: B% = INP(&H388): NEXT
  OUT &H389, dat%: FOR d% = 1 TO 35: B% = INP(&H388): NEXT
NEXT
END SUB

SUB Prepcb (code%) STATIC
' Prepares the control block for a given subfunction
' Checks whether cb() is used for IOCTL INPUT or OUTPUT
'
' ARGS: code%           - control block code
' RET:  - correctly dimensioned control block cb()
'       - correctly filled in fields for entire request
'         header
IF ASC(rh(3)) = 3 THEN
	SELECT CASE code%
		CASE 1
			length% = 6
		CASE 4
			length% = 9
		CASE 6
			length% = 5
		CASE 9
			length% = 2
		CASE 10, 11
			length% = 7
		CASE 12, 15
			length% = 11
	END SELECT
ELSE
	SELECT CASE code%
		CASE 0, 2, 5
			length% = 1
		CASE 1
			length% = 2
		CASE 3
			length% = 9
	END SELECT
	END IF

REDIM cb(1 TO length%) AS STRING * 1

cb(1) = CHR$(code%)

'Update address of cb() in rh()
rh(15) = CHR$(lbyte(VARPTR(cb(1))))
rh(16) = CHR$(hbyte(VARPTR(cb(1))))
rh(17) = CHR$(lbyte(VARSEG(cb(1))))
rh(18) = CHR$(hbyte(VARSEG(cb(1))))
'Number of bytes to transfer
rh(19) = CHR$(lbyte(length%))
rh(20) = CHR$(hbyte(length%))

END SUB

SUB Preprh (command%) STATIC
' Prepares the request header for a given command code
'
' ARGS: command%        - command code
' RET:  - correctly dimensioned request header rh()
'       - correctly filled in fields for basic request
'         header

SELECT CASE command%
	CASE 3, 12            'IOCTL Input , IOCTL Output
		rhlength% = 26
	CASE 132              'Play
		rhlength% = 22
	CASE 133, 136         'Pause, Resume
		rhlength% = 13
END SELECT

REDIM rh(1 TO rhlength%) AS STRING * 1
rh(1) = CHR$(rhlength%)
rh(2) = CHR$(drivearray(1, 2))
rh(3) = CHR$(command%)
END SUB

SUB project (wdth%, colour%, pixelno%)
STATIC pstate%, count%
count% = count% + 1
IF count% = 2 THEN
count% = 0
SELECT CASE pstate%
CASE 0: pstate% = 1
CASE 1: pstate% = 0
END SELECT
END IF
IF wdth% = 0 THEN EXIT SUB
wid = 320 / wdth%
SCREEN 7, , 2, 1
SELECT CASE colour%
CASE 1
SELECT CASE wdth%
CASE IS < 25: df% = 9
CASE IS >= 25: df% = 1
END SELECT
LINE (wid * pixelno% - 26 * wid / 26, 100 - wid * 3)-STEP(wid + 26 * wid / 26, wid), df%, BF
LINE (wid * pixelno% - 26 * wid / 26, 100 - wid * 3)-STEP(wid + 26 * wid / 26, 0), 0
LINE (wid * pixelno% - 26 * wid / 26, 100 - wid * 2)-STEP(wid + 26 * wid / 26, 0), 0
CASE 2
LINE (wid * (pixelno% - .2) + 1, 101 + wid * 2)-STEP(wid * 1.4 - 2, wid - 2), 15, BF
LINE (wid * (pixelno% - .2) + 1, 101 + wid * 2)-STEP(wid * 1.4 - 2, wid - 2), 7, B
LINE (wid * (pixelno% - .2), 100 + wid * 2)-STEP(wid * 1.4, wid), 8, B
LINE (wid * (pixelno% + .4), 100 + wid * 2.2)-STEP(wid * .2, wid * .6), 12, BF
LINE (wid * pixelno%, 100 + wid * 2.45)-STEP(wid, wid * .1), 12, BF
CASE 3
LINE (wid * pixelno%, 100 + wid * 2)-STEP(wid, wid), 7, BF
LINE (wid * pixelno%, 100 + wid * 2)-STEP(wid, wid), 8, B
LINE (wid * (pixelno% + .2), 100 + wid * 2)-STEP(wid * .6, wid), 8, B
LINE (wid * (pixelno% + .4), 100 + wid * 2)-STEP(wid * .2, wid), 8, B
FOR iu% = 0 TO 4
LINE (wid * (pixelno% + iu% * .2 + .1), 100 + wid * 2.1)-STEP(0, wid * .8), 8, B
NEXT
CASE 4
LINE (wid * (pixelno% - 2), 100 - wid / 2)-STEP(wid * 4, wid), 12, BF
LINE (wid * (pixelno% - 2), 100 - wid / 2)-STEP(wid * 4, wid), 4, B
LINE (wid * (pixelno% - 1.8), 100 - wid / 2.5)-STEP(wid * .8, 0), 4, B
LINE (wid * (pixelno% - 1.8), 100 - wid / 2.5)-STEP(0, wid * .8), 4, B
LINE -STEP(wid * .8, 0), 4, B
LINE (wid * (pixelno% - 1.8), 100)-STEP(wid * .8, 0), 4, B
LINE (wid * (pixelno% - .8), 100 - wid / 2.5)-STEP(wid * .8, wid * .8), 4
LINE (wid * pixelno%, 100 - wid / 2.5)-STEP(-wid * .8, wid * .8), 4
LINE (wid * (pixelno% + .5), 100 - wid / 2.5)-STEP(0, wid * .8), 4
LINE (wid * (pixelno% + .9), 100 - wid / 2.5)-STEP(wid * .8, 0), 4
LINE (wid * (pixelno% + 1.3), 100 - wid / 2.5)-STEP(0, wid * .8), 4
CASE 5
IF rkey% = 0 THEN lco% = 12: GOSUB drkey
CASE 6
IF gkey% = 0 THEN lco% = 10: GOSUB drkey
CASE 7
IF bkey% = 0 THEN lco% = 9: GOSUB drkey
CASE 9
LINE (wid * pixelno%, 100 - wid * 2)-STEP(wid, wid), 5, BF
LINE (wid * (pixelno% + .2), 100 - wid * 1.7)-STEP(wid * .6, wid * .7), 0, BF
LINE (wid * pixelno% - wid / 2, 100 - wid)-STEP(wid * 2, wid * 2), 5, BF
SELECT CASE pstate%
CASE 0
LINE (wid * pixelno% - wid / 2, 100 + wid)-STEP(wid * .8, wid * 1.1), 5, BF
LINE (wid * pixelno% + wid / 2 + wid * .2, 100 + wid)-STEP(wid * .8, wid * 1.5), 5, BF
LINE (wid * pixelno% - wid / 1.6, 100 + wid * 2.1)-STEP(wid, wid * .5), 5, BF
LINE (wid * (pixelno% + 1) + wid / 1.6, 100 + wid * 2.5)-STEP(-wid, wid * .5), 5, BF
CASE 1
LINE (wid * pixelno% - wid / 2, 100 + wid)-STEP(wid * .8, wid * 1.5), 5, BF
LINE (wid * pixelno% + wid / 2 + wid * .2, 100 + wid)-STEP(wid * .8, wid * 1.1), 5, BF
LINE (wid * pixelno% - wid / 1.6, 100 + wid * 2.5)-STEP(wid, wid * .5), 5, BF
LINE (wid * (pixelno% + 1) + wid / 1.6, 100 + wid * 2.1)-STEP(-wid, wid * .5), 5, BF
END SELECT

LINE (wid * pixelno% - wid, 100 - wid)-STEP(wid / 2, wid * 1.5), 5, BF
LINE (wid * (pixelno% + 1) + wid, 100 - wid)-STEP(-wid / 2, wid * 1.5), 5, BF

LINE (wid * pixelno%, 100 - wid * 2)-STEP(wid, wid), 8, B
LINE (wid * pixelno% - wid / 2, 100 - wid)-STEP(wid * 2, wid * 2), 8, B

SELECT CASE pstate%
CASE 0
LINE (wid * pixelno% - wid / 2, 100 + wid)-STEP(wid * .8, wid * 1.1), 8, B
LINE (wid * pixelno% + wid / 2 + wid * .2, 100 + wid)-STEP(wid * .8, wid * 1.5), 8, B
LINE (wid * pixelno% - wid / 1.6, 100 + wid * 2.1)-STEP(wid, wid * .5), 8, B
LINE (wid * (pixelno% + 1) + wid / 1.6, 100 + wid * 2.5)-STEP(-wid, wid * .5), 8, B
CASE 1
LINE (wid * pixelno% - wid / 2, 100 + wid)-STEP(wid * .8, wid * 1.5), 8, B
LINE (wid * pixelno% + wid / 2 + wid * .2, 100 + wid)-STEP(wid * .8, wid * 1.1), 8, B
LINE (wid * pixelno% - wid / 1.6, 100 + wid * 2.5)-STEP(wid, wid * .5), 8, B
LINE (wid * (pixelno% + 1) + wid / 1.6, 100 + wid * 2.1)-STEP(-wid, wid * .5), 8, B
END SELECT

LINE (wid * pixelno% - wid, 100 - wid)-STEP(wid / 2, wid * 1.5), 8, B
LINE (wid * (pixelno% + 1) + wid, 100 - wid)-STEP(-wid / 2, wid * 1.5), 8, B
LINE (wid * pixelno% - wid / 2, 100 + wid * .6)-STEP(wid * 2, wid * .4), 8, B
LINE (wid * pixelno% - wid * 1.1, 100 + wid * .06)-STEP(wid * .7, wid * .7), 4, BF
CIRCLE (wid * pixelno% - wid * .75, 100 + wid * .35), wid * .45, 8
PSET (wid * pixelno% - wid * .75, 100 + wid * .35), 6

ew1x% = wid * pixelno% - wid * .75: ewy% = 100 + wid * .35: ew2x% = wid * (pixelno% + 1) + wid * .75

LINE (wid * (pixelno% + 1) + wid * 1.1, 100 + wid * .06)-STEP(-wid * .7, wid * .7), 4, BF
CIRCLE (wid * (pixelno% + 1) + wid * .75, 100 + wid * .35), wid * .45, 8
PSET (wid * (pixelno% + 1) + wid * .75, 100 + wid * .35), 6
CASE 10
SELECT CASE wdth%
CASE IS > 40: ww1% = 0: ww2% = 0: ww3% = 8
CASE 30 TO 40: ww1% = 0: ww2% = 8: ww3% = 7
CASE IS < 30: ww1% = 8: ww2% = 7: ww3% = 15
END SELECT

LINE (wid * (pixelno% - 1.375), 100 - wid * 2.65)-STEP(wid * 2.75, wid * 5.3), 0, BF
LINE (wid * (pixelno% - 1.25), 100 - wid * 2.85)-STEP(wid * 2.5, wid * 5.7), ww1%, BF
LINE (wid * (pixelno% - 1.25), 100 - wid * 2.85)-STEP(wid * 2.5, wid * 5.7), 0, B
LINE (wid * (pixelno% - 1), 100 - wid * 2.95)-STEP(wid * 2, wid * 5.9), ww2%, BF
LINE (wid * (pixelno% - 1), 100 - wid * 2.95)-STEP(wid * 2, 0), 0
LINE (wid * (pixelno% - 1), 100 + wid * 2.95)-STEP(wid * 2, 0), 0
LINE (wid * (pixelno% - .5), 100 - wid * 3)-STEP(wid, wid * 6), ww3%, BF
LINE (wid * (pixelno% - .5), 100 - wid * 3)-STEP(wid, 0), 0
LINE (wid * (pixelno% - .5), 100 + wid * 3)-STEP(wid, 0), 0
CASE IS > 10
SELECT CASE colour%
CASE 11: cd% = 3: ch% = 11: GOSUB wall
CASE 12: cd% = 8: ch% = 7: GOSUB wall
CASE 13: cd% = 1: ch% = 9: GOSUB wall
CASE 14: cd% = 2: ch% = 10: GOSUB wall
CASE 15: cd% = 4: ch% = 12: GOSUB wall
END SELECT
LINE (wid * (pixelno% - 1), 100 - wid * 3)-STEP(wid * 2, 0), 0
LINE (wid * (pixelno% - 1), 100 + wid * 3)-STEP(wid * 2, 0), 0
LINE (wid * (pixelno% - 1), 100 - wid)-STEP(wid * 2, 0), 0
LINE (wid * (pixelno% - 1), 100 + wid)-STEP(wid * 2, 0), 0
END SELECT
SCREEN 7, , 0, 1
EXIT SUB

wall:
IF wdth% < 25 THEN aw% = ch%:  ELSE aw% = cd%
LINE (wid * (pixelno% - 1), 100 - wid * 3)-STEP(wid * 2, wid * 6), aw%, BF
RETURN

drkey:
LINE (wid * (pixelno% + .3), 100 + wid * .2)-STEP(wid * .4, wid * .2), lco%, BF
LINE (wid * (pixelno% + .45), 100 + wid * .4)-STEP(wid * .1, wid * .8), lco%, BF
LINE STEP(0, -wid * .2)-STEP(wid * .1, wid * .1), lco%, BF
LINE (wid * (pixelno% + .3), 100 + wid * .2)-STEP(wid * .4, wid * .2), 0, B
LINE (wid * (pixelno% + .45), 100 + wid * .4)-STEP(wid * .1, wid * .8), 0, B
LINE STEP(0, -wid * .2)-STEP(wid * .1, wid * .1), 0, B
LINE STEP(-wid * .25, -wid * .8)-STEP(wid * .2, 0), 0
RETURN
END SUB

DEFINT A-Z
SUB qfont (text$, X, Y, colour)

length = LEN(text$)                    'get characters to print
IF length = 0 THEN EXIT SUB            'check length

FOR char = 0 TO length - 1             'print loop

	 piece$ = MID$(text$, char + 1, 1)   'look at each piece of string
	 aski = ASC(piece$)                  'assign it's ASCII value

	SELECT CASE (piece$)                 'adjust lower case
	 CASE "g": kerny = kerny + 2         'ditto
	 CASE "j": kerny = kerny + 2         'ditto
	 CASE "p": kerny = kerny + 2         'ditto
	 CASE "q": kerny = kerny + 2         'ditto
	 CASE "y": kerny = kerny + 2         'ditto
	END SELECT

	FOR ybit = 0 TO 6                               'top to Bottom
	 FOR xbit = 0 TO 4                              'left to right
		 IF font(aski, xbit, ybit) = 1 THEN           'set bits only
			 PSET (X + xbit + kernx, Y + ybit + kerny), colour   'PSET data
		 END IF
	 NEXT
	NEXT

	SELECT CASE (piece$)                'kern adjusment
	 CASE "i": kernx = kernx + 2        'ditto
	 CASE "j": kernx = kernx + 5        'ditto
	 CASE "l": kernx = kernx + 2        'ditto
	 CASE "r": kernx = kernx + 5        'ditto
	 CASE ".": kernx = kernx + 3        'ditto
	 CASE "(": kernx = kernx + 3        'ditto
	 CASE ")": kernx = kernx + 3        'ditto
	 CASE "'": kernx = kernx + 2        'ditto
	 CASE "!": kernx = kernx + 2        'ditto
	 CASE ELSE: kernx = kernx + 6       'ditto
	END SELECT

	kerny = 0                           'reset

NEXT

END SUB

DEFSNG A-Z
FUNCTION rand%
RANDOMIZE TIMER
rand% = INT(RND * 3) + 7
END FUNCTION

SUB raycast
SCREEN 7, , 2, 1
scenary
SCREEN 7, , 0, 1
w% = 50

FOR X% = 1 TO 100
e% = e% + 1
FOR n% = 0 TO w%       ' - 1

'DRAW "m" + STR$(160 - (w% / 2) + n%) + "," + STR$(75 + e%)
IF POINT(160 - (w% / 2) + n%, 75 + e%) > 0 THEN CALL project(w%, POINT(160 - (w% / 2) + n%, 75 + e%), n%)
NEXT
w% = w% - 2
NEXT
r$ = INKEY$
SCREEN 7, , 2, 1
IF t% = 3 THEN CIRCLE (160, 100), 320 / rt%, 14: CIRCLE (160, 100), 230 / rt%, 14: t% = 0: PAINT (159 + 320 / rt%, 100), 14, 14
IF t% = 2 THEN CIRCLE (160, 100), 320 / rt%, 14: CIRCLE (160, 100), 130 / rt%, 14: t% = 3: PAINT (159 + 320 / rt%, 100), 14, 14
IF t% = 1 THEN CIRCLE (160, 100), 320 / rt%, 14: t% = 2: PAINT (159 + 320 / rt%, 100), 14, 14
gun
checkf
IF qwv% = 1 THEN enrgy% = 100
IF br% = 0 THEN bar
IF ht% = 1 THEN ms$ = ""
IF ms$ <> "" THEN
qfont ms$, 4, 4, 5
mcount% = mcount% - 1
IF mcount% = 0 THEN ms$ = ""
END IF
SCREEN 7, , 0, 1

END SUB

FUNCTION RBAtoHSG& (RBAMin%, RBASec%, RBAFrm%)
RBAtoHSG& = RBAMin% * 4500& + RBASec% * 75 + RBAFrm%
END FUNCTION

SUB rinit
ang = 0: X = 0: Y = 0: map% = 0: fr% = 0: br% = 0
t% = 0: rt% = 0: ew1x% = 0: ewy% = 0: ew2x% = 0
bkey% = 0: rkey% = 0: gkey% = 0
ms$ = "": mcount% = 0: gf% = 0
FOR v% = 0 TO 4: kbmatrix%(v%) = 0: NEXT
ht% = 0
END SUB

SUB savgame
ert$ = "Enter slot number in which the game is to be saved.(1-9)"
SCREEN 7, , 1, 1
qfont ert$, 8, 96, 12
qfont ert$, 7, 95, 11
SCREEN 7, , 0, 1
DO: w$ = INKEY$: LOOP UNTIL (VAL(w$) > 0 AND VAL(w$) < 10) OR w$ = CHR$(27)
IF w$ = CHR$(27) THEN EXIT SUB
time% = INT(TIMER - tstart!)
IF SGN(time%) = -1 THEN time% = time% + 86400
OPEN "sav" + RIGHT$(STR$(VAL(w$)), 1) + ".sav" FOR OUTPUT AS #1
PRINT #1, ang:
PRINT #1, X:
PRINT #1, Y:
PRINT #1, map%:
PRINT #1, br%
PRINT #1, t%:
PRINT #1, rt%:
PRINT #1, wpn%:
PRINT #1, lno%
PRINT #1, bkey%:
PRINT #1, rkey%:
PRINT #1, gkey%
PRINT #1, amm%
PRINT #1, enrgy%
PRINT #1, time%
FOR w% = 0 TO 10
PRINT #1, e$(w%)
PRINT #1, epo%(w%)
PRINT #1, ex$(w%)
PRINT #1, ey$(w%)
PRINT #1, i$(w%)
PRINT #1, amm$(w%)
NEXT
CLOSE #1
END SUB

FUNCTION SCDDeviceStatus%
'Get the dword which contains the parameters
'describing the status of the CD-ROM drive
'
'ARGS:  None
'RET:   Function value  - device parameters

'Device status
'
'DevStat   DB   6         ; Control block code
'      DD   ?         ; Device parameters
'
'The device driver will return a 32-bit value. Bit 0 is the least significant
'bit. The bits are interpreted as follows:
'
'  Bit 0     0    Door closed
'            1    Door open
'
'  Bit 1     0    Door locked
'            1    Door unlocked
'
'  Bit 2     0    Supports only cooked reading
'            1    Supports cooked and raw reading
'
'  Bit 3     0    Read only
'            1    Read/write
'
'  Bit 4     0    Data read only
'            1    Data read and plays audio/video tracks
'
'  Bit 5     0    No interleaving
'            1    Supports interleaving
'
'  Bit 6     0    Reserved
'
'  Bit 7     0    No prefetching
'            1    Supports prefetching requests
'
'  Bit 8     0    No audio channel manipulation
'            1    Supports audio channel manipulation
'
'  Bit 9     0    Supports HSG addressing mode
'            1    Supports HSG and Red Book addressing modes
'
'  Bit 10-31 0    Reserved (all 0)


Preprh 3
Prepcb 6
Call10
SCDDeviceStatus% = ASC(cb(2)) + ASC(cb(3)) * 256
END FUNCTION

SUB SCDDiskInfo (Low%, High%, Leadout&)
'Get general disk information
'
'ARGS:  Variables to return values to
'RET:   low%        - Lowest track on CD
'       high%       - Highest track on CD
'       leadout&    - HSG address of the lead-out
'                     track (end of disk)

Preprh 3
Prepcb 10
Call10
Low% = ASC(cb(2))
High% = ASC(cb(3))
Leadout& = RBAtoHSG(ASC(cb(6)), ASC(cb(5)) - 2, ASC(cb(4)))
END SUB

SUB scdpause
'Pause the audio on the CD
'ARGS:  none
'RET:   none

Preprh 133
Call10
END SUB

SUB SCDPlay (BeginSec&, LengthSec&)
'Play the audio on the CD starting at start& for
'length& sectors
'
'ARGS:  start&      - Location where playback begins
'       length&     - Number of sectors to play
'RET:   none
Preprh 132
rh(14) = CHR$(0)
Byte BeginSec&, b1$, b2$, b3$, b4$
rh(15) = b4$
rh(16) = b3$
rh(17) = b2$
rh(18) = b1$

Byte LengthSec&, b1$, b2$, b3$, b4$
rh(19) = b4$
rh(20) = b3$
rh(21) = b2$
rh(22) = b1$
Call10
END SUB

SUB SCDTrackInfo (track%, start&, ctrl%)
'Get specific track information
'
'ARGS:  track%      - track number you want info about
'       variables to return values to
'RET:   start&      - HSG address where the track begins
'       ctrl%       - track control information

Preprh 3
Prepcb 11
cb(2) = CHR$(track%)
Call10
start& = RBAtoHSG(ASC(cb(5)), ASC(cb(4)) - 2, ASC(cb(3)))
ctrl% = ASC(cb(7))
END SUB

SUB scenary
LINE (0, 0)-(320, 27), 15, BF
LINE (0, 28)-(320, 56), 7, BF
LINE (0, 57)-(320, 81), 8, BF
LINE (0, 82)-(320, 118), 0, BF
LINE (0, 119)-(320, 160), 7, BF
LINE (0, 160)-(320, 200), 15, BF
END SUB

SUB setp7 (tp%)
SCREEN 7, , 7, 1:
CLS
PUT (0, 30), Y%, PSET
SELECT CASE tp%
CASE 0
qfont "LEVEL" + STR$(lno%), 140, 127, 9

qfont "G E T  R E A D Y", 115, 140, 4
CASE 1
FOR v% = 0 TO 10
IF e$(v%) = "0" THEN ene% = ene% + 1
IF i$(v%) = "0" THEN ite% = ite% + 1
IF amm$(v%) = "0" THEN ite% = ite% + 1
time% = INT(TIMER - tstart!)
IF SGN(time%) = -1 THEN time% = time% + 86400
time% = time% + tpst%
min% = INT(time% / 60)
sec% = time% MOD 60
NEXT
COLOR 14: LOCATE 17, 4: PRINT "kills:"; : COLOR 9: PRINT STR$(INT(ene% / 11 * 100)) + "%"
COLOR 14: LOCATE 19, 4: PRINT "items:"; : COLOR 9: PRINT STR$(INT(ite% / 22 * 100)) + "%"
COLOR 14: LOCATE 21, 4: PRINT "time:"; : COLOR 9: PRINT min%; "minute(s)"; sec%; "second(s)"
COLOR 12: LOCATE 23, 9: PRINT "press any key to continue"
END SELECT
SCREEN 7, , 0, 1
END SUB

