'       Bomber Coo!
'
'       (C) 1998 MICOOSOFT
'
'       Controls:
'
'       Player One:
'       Arrow keys to move.  Enter to set bombs.
'
'       Player Two:
'       W,A,S,D to move.  G to set bombs.
'
'       The Cooey Classics!
'
'       This is the third game in the Cooey Classics! series.  It will run
'       under Qbasic or QuickBasic.
'

'$DYNAMIC
DEFINT A-Z

DECLARE SUB InitStats ()
DECLARE SUB ShowSlime (I%)
DECLARE SUB MoveSlime ()
DECLARE SUB P2Boomer (I%)
DECLARE SUB ShowP2 ()
DECLARE SUB P2Dead ()
DECLARE SUB LoadFont ()
DECLARE SUB P1Boomer (I%)
DECLARE SUB LoadTiles ()
DECLARE SUB LoadLevel ()
DECLARE SUB ShowLevel ()
DECLARE SUB ShowP1 ()
DECLARE SUB P1Dead ()
DECLARE SUB PutText (Sentence$, PosX%, PosY%)
DECLARE SUB PutNumber (Value%, PosX%, PosY%, Digits%)

CONST True = -1, False = 0

DIM SHARED Cooey(1039) AS INTEGER
DIM SHARED CooeyMask(1039) AS INTEGER

DIM SHARED Mattress(1039) AS INTEGER
DIM SHARED MattressMask(1039) AS INTEGER

DIM SHARED LevelTiles(519) AS INTEGER

DIM SHARED Bomb(259) AS INTEGER
DIM SHARED BombMask(259) AS INTEGER

DIM SHARED Slime1(129) AS INTEGER
DIM SHARED Slime1M(129) AS INTEGER
DIM SHARED Slime2(129) AS INTEGER
DIM SHARED Slime2M(129) AS INTEGER

DIM SHARED Boom(129) AS INTEGER
DIM SHARED BoomMask(129) AS INTEGER

DIM SHARED Level(0 TO 19, 0 TO 11) AS INTEGER
DIM SHARED ChrSet(33 TO 95, 1 TO 6, 1 TO 6) AS INTEGER

DIM SHARED P1X AS INTEGER, P1Y AS INTEGER, P1Score AS INTEGER
DIM SHARED P1Lives AS INTEGER, P1Dir AS INTEGER, P1Time(2) AS INTEGER
DIM SHARED P1Boom(2) AS INTEGER, Bomb1X(2) AS INTEGER, Bomb1Y(2) AS INTEGER
DIM SHARED B1Type(2) AS INTEGER, P1Over AS INTEGER

DIM SHARED P2X AS INTEGER, P2Y AS INTEGER, P2Score AS INTEGER
DIM SHARED P2Lives AS INTEGER, P2Dir AS INTEGER, P2Time(2) AS INTEGER
DIM SHARED P2Boom(2) AS INTEGER, Bomb2X(2) AS INTEGER, Bomb2Y(2) AS INTEGER
DIM SHARED B2Type(2) AS INTEGER, P2Over AS INTEGER

DIM SHARED SlimeX(2) AS INTEGER, SlimeY(2) AS INTEGER
DIM SHARED Slime(2) AS INTEGER, SlimePic(2) AS INTEGER
DIM SHARED SlimeSpeed!

DIM SHARED EnemyLevel!

PRINT "Loading..."
CALL LoadTiles
CALL LoadLevel
CALL LoadFont

SCREEN 13

DEF SEG = &HA000
BLOAD "title.fsi"
WHILE INKEY$ = "": WEND

EnemyLevel! = 11
CALL InitStats
P1Score = 0: P1Lives = 3
P2Score = 0: P2Lives = 3

DO

    SELECT CASE INKEY$
    CASE CHR$(0) + CHR$(72)
        IF Level(P1X, P1Y - 1) = 0 THEN P1Y = P1Y - 1
        P1Dir = 0
    CASE CHR$(0) + CHR$(80)
        IF Level(P1X, P1Y + 1) = 0 THEN P1Y = P1Y + 1
        P1Dir = 1
    CASE CHR$(0) + CHR$(75)
        IF Level(P1X - 1, P1Y) = 0 THEN P1X = P1X - 1
        P1Dir = 2
    CASE CHR$(0) + CHR$(77)
        IF Level(P1X + 1, P1Y) = 0 THEN P1X = P1X + 1
        P1Dir = 3
    CASE CHR$(13)
        Boom = False
        FOR I = 0 TO 2
            IF P1Boom(I) = False THEN
                P1Boom(I) = True
                P1Time(I) = 10
                Bomb1X(I) = P1X: Bomb1Y(I) = P1Y
                Boom = True
            END IF
            IF Boom THEN EXIT FOR
        NEXT I
    CASE IS = "w", "W"
        IF Level(P2X, P2Y - 1) = 0 THEN P2Y = P2Y - 1
        P2Dir = 0
    CASE IS = "s", "S"
        IF Level(P2X, P2Y + 1) = 0 THEN P2Y = P2Y + 1
        P2Dir = 1
    CASE "a", "A"
        IF Level(P2X - 1, P2Y) = 0 THEN P2X = P2X - 1
        P2Dir = 2
    CASE "d", "D"
        IF Level(P2X + 1, P2Y) = 0 THEN P2X = P2X + 1
        P2Dir = 3
    CASE IS = "G", "g"
        Boom = False
        FOR I = 0 TO 2
            IF P2Boom(I) = False THEN
                P2Boom(I) = True
                P2Time(I) = 10
                Bomb2X(I) = P2X: Bomb2Y(I) = P2Y
                Boom = True
            END IF
            IF Boom THEN EXIT FOR
        NEXT I
    CASE CHR$(27)
        Quit = True
    END SELECT

    FOR I = 0 TO 2
        IF Slime(I) THEN
            IF SlimeX(I) = P1X AND SlimeY(I) = P1Y THEN CALL P1Dead
            IF SlimeX(I) = P2X AND SlimeY(I) = P2Y THEN CALL P2Dead
        END IF
    NEXT I
    CALL ShowLevel

LOOP UNTIL Quit OR P1Over OR P2Over

LINE (0, 0)-(319, 7), 0, BF
IF P1Over THEN
        PutText "Mattress wins the match!", 0, 1
    ELSEIF P2Over THEN
        PutText "Cooey wins the match!", 0, 1
    ELSE
        PutText "Game aborted.", 0, 1
END IF
WHILE INKEY$ = "": WEND

SYSTEM

DATA 3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3
DATA 3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3
DATA 3,0,0,0,1,1,1,1,0,1,1,0,0,1,1,1,0,0,0,3
DATA 3,0,3,3,3,0,3,3,3,1,1,3,3,3,0,3,3,3,0,3
DATA 3,0,3,2,2,0,2,2,3,1,1,3,2,2,0,2,2,3,0,3
DATA 3,1,2,0,1,1,1,0,3,0,0,3,0,1,1,1,0,2,1,3
DATA 3,1,0,0,1,0,0,1,3,0,0,3,1,0,0,1,0,0,1,3
DATA 3,1,3,0,1,1,1,0,3,0,0,3,0,1,1,1,0,3,1,3
DATA 3,0,3,3,3,0,3,3,3,1,1,3,3,3,0,3,3,3,0,3
DATA 3,0,2,2,2,1,2,2,2,1,1,2,2,2,1,2,2,2,0,3
DATA 3,0,0,0,1,1,1,0,0,1,1,0,0,1,1,1,0,0,0,3
DATA 3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3

REM $STATIC
SUB HiScores

END SUB

SUB InitStats

    EnemyLevel! = EnemyLevel! - 1
    IF EnemyLevel! = 0 THEN EnemyLevel! = 1
    P1X = 1: P1Y = 2
    P1Dir = 1

    P2X = 18: P2Y = 10
    P2Dir = 1

    SlimeSpeed! = EnemyLevel! / 2
    SlimeX(0) = 9: SlimeY(0) = 5
    SlimeX(1) = 5: SlimeY(1) = 6
    SlimeX(2) = 14: SlimeY(2) = 6
    Slime(0) = True: Slime(1) = True: Slime(2) = True
    SlimePic(0) = 0: SlimePic(1) = 1: SlimePic(2) = 1

END SUB

SUB LoadFont

    OPEN "bombcoo.bmf" FOR INPUT AS #1

    FOR I = 1 TO 6
        IF I = 1 THEN
                FontNum = 33
            ELSEIF I = 2 THEN
                FontNum = 36
            ELSEIF I = 3 THEN
                FontNum = 39
            ELSEIF I = 4 THEN
                FontNum = 44
            ELSEIF I = 5 THEN
                FontNum = 45
            ELSEIF I = 6 THEN
                FontNum = 46
        END IF
        FOR FontY = 1 TO 6
            FOR FontX = 1 TO 6
                INPUT #1, ChrSet(FontNum, FontX, FontY)
            NEXT FontX
        NEXT FontY
    NEXT I
    FOR I = 48 TO 59
        FOR FontY = 1 TO 6
            FOR FontX = 1 TO 6
                INPUT #1, ChrSet(I, FontX, FontY)
            NEXT FontX
        NEXT FontY
    NEXT I
    FOR FontY = 1 TO 6
        FOR FontX = 1 TO 6
            INPUT #1, ChrSet(63, FontX, FontY)
        NEXT FontX
    NEXT FontY
    FOR I = 65 TO 95
        FOR FontY = 1 TO 6
            FOR FontX = 1 TO 6
                INPUT #1, ChrSet(I, FontX, FontY)
            NEXT FontX
         NEXT FontY
    NEXT I

    CLOSE #1

END SUB

SUB LoadLevel

    RESTORE
    FOR Y = 0 TO 11
        FOR X = 0 TO 19
            READ Level(X, Y)
        NEXT X
    NEXT Y

END SUB

SUB LoadTiles

    DEF SEG = VARSEG(Cooey(0)): BLOAD "coo_d1.spr", VARPTR(Cooey(0))
    DEF SEG = VARSEG(Cooey(130)): BLOAD "coo_d2.spr", VARPTR(Cooey(130))
    DEF SEG = VARSEG(Cooey(260)): BLOAD "coo_u1.spr", VARPTR(Cooey(260))
    DEF SEG = VARSEG(Cooey(390)): BLOAD "coo_u2.spr", VARPTR(Cooey(390))
    DEF SEG = VARSEG(Cooey(4 * 130)): BLOAD "coo_l1.spr", VARPTR(Cooey(4 * 130))
    DEF SEG = VARSEG(Cooey(5 * 130)): BLOAD "coo_l2.spr", VARPTR(Cooey(5 * 130))
    DEF SEG = VARSEG(Cooey(6 * 130)): BLOAD "coo_r1.spr", VARPTR(Cooey(6 * 130))
    DEF SEG = VARSEG(Cooey(7 * 130)): BLOAD "coo_r2.spr", VARPTR(Cooey(7 * 130))

    DEF SEG = VARSEG(CooeyMask(0)): BLOAD "coo_d1.msk", VARPTR(CooeyMask(0))
    DEF SEG = VARSEG(CooeyMask(130)): BLOAD "coo_d2.msk", VARPTR(CooeyMask(130))
    DEF SEG = VARSEG(CooeyMask(260)): BLOAD "coo_u1.msk", VARPTR(CooeyMask(260))
    DEF SEG = VARSEG(CooeyMask(390)): BLOAD "coo_u2.msk", VARPTR(CooeyMask(390))
    DEF SEG = VARSEG(CooeyMask(4 * 130)): BLOAD "coo_l1.msk", VARPTR(CooeyMask(4 * 130))
    DEF SEG = VARSEG(CooeyMask(5 * 130)): BLOAD "coo_l2.msk", VARPTR(CooeyMask(5 * 130))
    DEF SEG = VARSEG(CooeyMask(6 * 130)): BLOAD "coo_r1.msk", VARPTR(CooeyMask(6 * 130))
    DEF SEG = VARSEG(CooeyMask(7 * 130)): BLOAD "coo_r2.msk", VARPTR(CooeyMask(7 * 130))

    DEF SEG = VARSEG(Mattress(0)): BLOAD "mat_d1.spr", VARPTR(Mattress(0))
    DEF SEG = VARSEG(Mattress(130)): BLOAD "mat_d2.spr", VARPTR(Mattress(130))
    DEF SEG = VARSEG(Mattress(260)): BLOAD "mat_u1.spr", VARPTR(Mattress(260))
    DEF SEG = VARSEG(Mattress(390)): BLOAD "mat_u2.spr", VARPTR(Mattress(390))
    DEF SEG = VARSEG(Mattress(4 * 130)): BLOAD "mat_l1.spr", VARPTR(Mattress(4 * 130))
    DEF SEG = VARSEG(Mattress(5 * 130)): BLOAD "mat_l2.spr", VARPTR(Mattress(5 * 130))
    DEF SEG = VARSEG(Mattress(6 * 130)): BLOAD "mat_r1.spr", VARPTR(Mattress(6 * 130))
    DEF SEG = VARSEG(Mattress(7 * 130)): BLOAD "mat_r2.spr", VARPTR(Mattress(7 * 130))

    DEF SEG = VARSEG(MattressMask(0)): BLOAD "mat_d1.msk", VARPTR(MattressMask(0))
    DEF SEG = VARSEG(MattressMask(130)): BLOAD "mat_d2.msk", VARPTR(MattressMask(130))
    DEF SEG = VARSEG(MattressMask(260)): BLOAD "mat_u1.msk", VARPTR(MattressMask(260))
    DEF SEG = VARSEG(MattressMask(390)): BLOAD "mat_u2.msk", VARPTR(MattressMask(390))
    DEF SEG = VARSEG(MattressMask(4 * 130)): BLOAD "mat_l1.msk", VARPTR(MattressMask(4 * 130))
    DEF SEG = VARSEG(MattressMask(5 * 130)): BLOAD "mat_l2.msk", VARPTR(MattressMask(5 * 130))
    DEF SEG = VARSEG(MattressMask(6 * 130)): BLOAD "mat_r1.msk", VARPTR(MattressMask(6 * 130))
    DEF SEG = VARSEG(MattressMask(7 * 130)): BLOAD "mat_r2.msk", VARPTR(MattressMask(7 * 130))
    DEF SEG = VARSEG(LevelTiles(0)): BLOAD "floor1.spr", VARPTR(LevelTiles(0))
    DEF SEG = VARSEG(LevelTiles(130)): BLOAD "rock1.spr", VARPTR(LevelTiles(130))
    DEF SEG = VARSEG(LevelTiles(260)): BLOAD "wall1.spr", VARPTR(LevelTiles(260))
    DEF SEG = VARSEG(LevelTiles(390)): BLOAD "roof1.spr", VARPTR(LevelTiles(390))

    DEF SEG = VARSEG(Bomb(0)): BLOAD "bomb1.spr", VARPTR(Bomb(0))
    DEF SEG = VARSEG(Bomb(130)): BLOAD "bomb2.spr", VARPTR(Bomb(130))

    DEF SEG = VARSEG(BombMask(0)): BLOAD "bomb1.msk", VARPTR(BombMask(0))
    DEF SEG = VARSEG(BombMask(130)): BLOAD "bomb2.msk", VARPTR(BombMask(130))

    DEF SEG = VARSEG(Slime1(0)): BLOAD "slime1.spr", VARPTR(Slime1(0))
    DEF SEG = VARSEG(Slime2(0)): BLOAD "slime2.spr", VARPTR(Slime2(0))

    DEF SEG = VARSEG(Slime1M(0)): BLOAD "slime1.msk", VARPTR(Slime1M(0))
    DEF SEG = VARSEG(Slime2M(0)): BLOAD "slime2.msk", VARPTR(Slime2M(0))

    DEF SEG = VARSEG(Boom(0)): BLOAD "boom.spr", VARPTR(Boom(0))
    DEF SEG = VARSEG(BoomMask(0)): BLOAD "boom.msk", VARPTR(BoomMask(0))

END SUB

SUB MoveSlime STATIC

    IF SlimeMoved! + SlimeSpeed! > TIMER THEN EXIT SUB
    RANDOMIZE TIMER
    FOR I = 0 TO 2
        IF Slime(I) THEN
            SlimeDir = INT(RND * 4) + 1
            IF SlimeDir = 0 AND Level(SlimeX(I), SlimeY(I) - 1) = 0 THEN
                    SlimeY(I) = SlimeY(I) - 1
                ELSEIF SlimeDir = 1 AND Level(SlimeX(I), SlimeY(I) + 1) = 0 THEN
                    SlimeY(I) = SlimeY(I) + 1
                ELSEIF SlimeDir = 2 AND Level(SlimeX(I) - 1, SlimeY(I)) = 0 THEN
                    SlimeX(I) = SlimeX(I) - 1
                ELSEIF SlimeDir = 3 AND Level(SlimeX(I) + 1, SlimeY(I)) = 0 THEN
                    SlimeX(I) = SlimeX(I) + 1
            END IF
            IF SlimeX(I) = P1X AND SlimeY(I) = P1Y THEN CALL P1Dead
            IF SlimeX(I) = P2X AND SlimeY(I) = P2Y THEN CALL P2Dead
        END IF
    NEXT I
    SlimeMoved! = TIMER

END SUB

SUB P1Boomer (I%) STATIC

        IF P1Boom(I) = True THEN
            P1Time(I) = P1Time(I) - 1
            IF P1Time(I) = 0 THEN
                    P1Boom(I) = False
                    PUT (Bomb1X(I) * 16, (Bomb1Y(I) * 16 + 8)), BoomMask, AND
                    PUT (Bomb1X(I) * 16, (Bomb1Y(I) * 16 + 8)), Boom, XOR
                    IF P1X = Bomb1X(I) AND P1Y = Bomb1Y(I) THEN CALL P1Dead
                    IF P2X = Bomb1X(I) AND P2Y = Bomb1Y(I) THEN CALL P2Dead
                    FOR J = 0 TO 2
                        IF SlimeX(J) = Bomb1X(I) AND SlimeY(J) = Bomb1Y(I) THEN
                            Slime(J) = False
                            P1Score = P1Score + 25
                        END IF
                    NEXT J
                    IF Level(Bomb1X(I), Bomb1Y(I) - 1) < 2 THEN
                        PUT (Bomb1X(I) * 16, ((Bomb1Y(I) - 1) * 16 + 8)), BoomMask, AND
                        PUT (Bomb1X(I) * 16, ((Bomb1Y(I) - 1) * 16 + 8)), Boom, XOR
                        IF Level(Bomb1X(I), Bomb1Y(I) - 1) = 1 THEN P1Score = P1Score + 5
                        Level(Bomb1X(I), Bomb1Y(I) - 1) = 0
                        IF P1X = Bomb1X(I) AND P1Y = Bomb1Y(I) - 1 THEN CALL P1Dead
                        IF P2X = Bomb1X(I) AND P2Y = Bomb1Y(I) - 1 THEN CALL P2Dead
                        FOR J = 0 TO 2
                            IF SlimeX(J) = Bomb1X(I) AND SlimeY(J) = Bomb1Y(I) - 1 THEN
                                Slime(J) = False
                                P1Score = P1Score + 25
                            END IF
                        NEXT J
                    END IF
                    IF Level(Bomb1X(I) + 1, Bomb1Y(I)) < 2 THEN
                        PUT ((Bomb1X(I) + 1) * 16, (Bomb1Y(I) * 16 + 8)), BoomMask, AND
                        PUT ((Bomb1X(I) + 1) * 16, (Bomb1Y(I) * 16 + 8)), Boom, XOR
                        IF Level(Bomb1X(I) + 1, Bomb1Y(I)) = 1 THEN P1Score = P1Score + 5
                        Level(Bomb1X(I) + 1, Bomb1Y(I)) = 0
                        IF P1X = Bomb1X(I) + 1 AND P1Y = Bomb1Y(I) THEN CALL P1Dead
                        IF P2X = Bomb1X(I) + 1 AND P2Y = Bomb1Y(I) THEN CALL P2Dead
                        FOR J = 0 TO 2
                            IF SlimeX(J) = Bomb1X(I) + 1 AND SlimeY(J) = Bomb1Y(I) THEN
                                Slime(J) = False
                                P1Score = P1Score + 25
                            END IF
                        NEXT J
                    END IF
                    IF Level(Bomb1X(I), Bomb1Y(I) + 1) < 2 THEN
                        PUT (Bomb1X(I) * 16, ((Bomb1Y(I) + 1) * 16 + 8)), BoomMask, AND
                        PUT (Bomb1X(I) * 16, ((Bomb1Y(I) + 1) * 16 + 8)), Boom, XOR
                        IF Level(Bomb1X(I), Bomb1Y(I) + 1) = 1 THEN P1Score = P1Score + 5
                        Level(Bomb1X(I), Bomb1Y(I) + 1) = 0
                        IF P1X = Bomb1X(I) AND P1Y = Bomb1Y(I) + 1 THEN CALL P1Dead
                        IF P2X = Bomb1X(I) AND P2Y = Bomb1Y(I) + 1 THEN CALL P2Dead
                        FOR J = 0 TO 2
                            IF SlimeX(J) = Bomb1X(I) AND SlimeY(J) = Bomb1Y(I) + 1 THEN
                                Slime(J) = False
                                P1Score = P1Score + 25
                            END IF
                        NEXT J
                    END IF
                    IF Level(Bomb1X(I) - 1, Bomb1Y(I)) < 2 THEN
                        PUT ((Bomb1X(I) - 1) * 16, (Bomb1Y(I) * 16 + 8)), BoomMask, AND
                        PUT ((Bomb1X(I) - 1) * 16, (Bomb1Y(I) * 16 + 8)), Boom, XOR
                        IF Level(Bomb1X(I) - 1, Bomb1Y(I)) = 1 THEN P1Score = P1Score + 5
                        Level(Bomb1X(I) - 1, Bomb1Y(I)) = 0
                        IF P1X = Bomb1X(I) - 1 AND P1Y = Bomb1Y(I) THEN CALL P1Dead
                        IF P2X = Bomb1X(I) - 1 AND P2Y = Bomb1Y(I) THEN CALL P2Dead
                        FOR J = 0 TO 2
                            IF SlimeX(J) = Bomb1X(I) - 1 AND SlimeY(J) = Bomb1Y(I) THEN
                                Slime(J) = False
                                P1Score = P1Score + 25
                            END IF
                        NEXT J
                    END IF
                ELSE
                    IF B1Type(I) = 0 THEN
                            PUT (Bomb1X(I) * 16, Bomb1Y(I) * 16 + 8), BombMask(0), AND
                            PUT (Bomb1X(I) * 16, Bomb1Y(I) * 16 + 8), Bomb(0), XOR
                            B1Type(I) = 1
                        ELSEIF B1Type(I) = 1 THEN
                            PUT (Bomb1X(I) * 16, Bomb1Y(I) * 16 + 8), BombMask(130), AND
                            PUT (Bomb1X(I) * 16, Bomb1Y(I) * 16 + 8), Bomb(130), XOR
                            B1Type(I) = 0
                    END IF
            END IF
        END IF

END SUB

SUB P1Dead

    P1Lives = P1Lives - 1
    P1X = 1: P1Y = 2
    P2Score = P2Score + 50
    IF P1Lives = 0 THEN P1Over = True

END SUB

SUB P2Boomer (I%) STATIC

        IF P2Boom(I) = True THEN
            P2Time(I) = P2Time(I) - 1
            IF P2Time(I) = 0 THEN
                    P2Boom(I) = False
                    PUT (Bomb2X(I) * 16, (Bomb2Y(I) * 16 + 8)), BoomMask, AND
                    PUT (Bomb2X(I) * 16, (Bomb2Y(I) * 16 + 8)), Boom, XOR
                    IF P1X = Bomb2X(I) AND P1Y = Bomb2Y(I) THEN CALL P1Dead
                    IF P2X = Bomb2X(I) AND P2Y = Bomb2Y(I) THEN CALL P2Dead
                    FOR J = 0 TO 2
                        IF SlimeX(J) = Bomb2X(I) AND SlimeY(J) = Bomb2Y(I) THEN
                            Slime(J) = False
                            P2Score = P2Score + 25
                        END IF
                    NEXT J
                    IF Level(Bomb2X(I), Bomb2Y(I) - 1) < 2 THEN
                        PUT (Bomb2X(I) * 16, ((Bomb2Y(I) - 1) * 16 + 8)), BoomMask, AND
                        PUT (Bomb2X(I) * 16, ((Bomb2Y(I) - 1) * 16 + 8)), Boom, XOR
                        IF Level(Bomb2X(I), Bomb2Y(I) - 1) = 1 THEN P2Score = P2Score + 5
                        Level(Bomb2X(I), Bomb2Y(I) - 1) = 0
                        IF P1X = Bomb2X(I) AND P1Y = Bomb2Y(I) - 1 THEN CALL P1Dead
                        IF P2X = Bomb2X(I) AND P2Y = Bomb2Y(I) - 1 THEN CALL P2Dead
                        FOR J = 0 TO 2
                            IF SlimeX(J) = Bomb2X(I) AND SlimeY(J) = Bomb2Y(I) - 1 THEN
                                Slime(J) = False
                                P2Score = P2Score + 25
                            END IF
                        NEXT J
                    END IF
                    IF Level(Bomb2X(I) + 1, Bomb2Y(I)) < 2 THEN
                        PUT ((Bomb2X(I) + 1) * 16, (Bomb2Y(I) * 16 + 8)), BoomMask, AND
                        PUT ((Bomb2X(I) + 1) * 16, (Bomb2Y(I) * 16 + 8)), Boom, XOR
                        IF Level(Bomb2X(I) + 1, Bomb2Y(I)) = 1 THEN P2Score = P2Score + 5
                        Level(Bomb2X(I) + 1, Bomb2Y(I)) = 0
                        IF P1X = Bomb2X(I) + 1 AND P1Y = Bomb2Y(I) THEN CALL P1Dead
                        IF P2X = Bomb2X(I) + 1 AND P2Y = Bomb2Y(I) THEN CALL P2Dead
                        FOR J = 0 TO 2
                            IF SlimeX(J) = Bomb2X(I) + 1 AND SlimeY(J) = Bomb2Y(I) THEN
                                Slime(J) = False
                                P2Score = P2Score + 25
                            END IF
                        NEXT J
                    END IF
                    IF Level(Bomb2X(I), Bomb2Y(I) + 1) < 2 THEN
                        PUT (Bomb2X(I) * 16, ((Bomb2Y(I) + 1) * 16 + 8)), BoomMask, AND
                        PUT (Bomb2X(I) * 16, ((Bomb2Y(I) + 1) * 16 + 8)), Boom, XOR
                        IF Level(Bomb2X(I), Bomb2Y(I) + 1) = 1 THEN P2Score = P2Score + 5
                        Level(Bomb2X(I), Bomb2Y(I) + 1) = 0
                        IF P1X = Bomb2X(I) AND P1Y = Bomb2Y(I) + 1 THEN CALL P1Dead
                        IF P2X = Bomb2X(I) AND P2Y = Bomb2Y(I) + 1 THEN CALL P2Dead
                        FOR J = 0 TO 2
                            IF SlimeX(J) = Bomb2X(I) AND SlimeY(J) = Bomb2Y(I) + 1 THEN
                                Slime(J) = False
                                P2Score = P2Score + 25
                            END IF
                        NEXT J
                    END IF
                    IF Level(Bomb2X(I) - 1, Bomb2Y(I)) < 2 THEN
                        PUT ((Bomb2X(I) - 1) * 16, (Bomb2Y(I) * 16 + 8)), BoomMask, AND
                        PUT ((Bomb2X(I) - 1) * 16, (Bomb2Y(I) * 16 + 8)), Boom, XOR
                        IF Level(Bomb2X(I) - 1, Bomb2Y(I)) = 1 THEN P2Score = P2Score + 5
                        Level(Bomb2X(I) - 1, Bomb2Y(I)) = 0
                        IF P1X = Bomb2X(I) - 1 AND P1Y = Bomb2Y(I) THEN CALL P1Dead
                        IF P2X = Bomb2X(I) - 1 AND P2Y = Bomb2Y(I) THEN CALL P2Dead
                        FOR J = 0 TO 2
                            IF SlimeX(J) = Bomb2X(I) - 1 AND SlimeY(J) = Bomb2Y(I) THEN
                                Slime(J) = False
                                P2Score = P2Score + 25
                            END IF
                        NEXT J
                    END IF
                ELSE
                    IF B2Type(I) = 0 THEN
                            PUT (Bomb2X(I) * 16, Bomb2Y(I) * 16 + 8), BombMask(0), AND
                            PUT (Bomb2X(I) * 16, Bomb2Y(I) * 16 + 8), Bomb(0), XOR
                            B2Type(I) = 1
                        ELSEIF B2Type(I) = 1 THEN
                            PUT (Bomb2X(I) * 16, Bomb2Y(I) * 16 + 8), BombMask(130), AND
                            PUT (Bomb2X(I) * 16, Bomb2Y(I) * 16 + 8), Bomb(130), XOR
                            B2Type(I) = 0
                    END IF
            END IF
        END IF

END SUB

SUB P2Dead

    P2Lives = P2Lives - 1
    P2X = 18: P2Y = 10
    P1Score = P1Score + 50
    IF P2Lives = 0 THEN P2Over = True

END SUB

SUB PutNumber (Value%, PosX%, PosY%, Digits%)

    Sentence$ = RIGHT$(STR$(Value%), LEN(STR$(Value%)) - 1)
    IF Digits% - LEN(Sentence$) > 0 THEN
        Sentence$ = SPACE$(Digits% - LEN(Sentence$)) + Sentence$
    END IF
    FOR Csr = 1 TO LEN(Sentence$)

        CN = ASC(MID$(UCASE$(Sentence$), Csr, 1))
        IF CN = 33 OR CN = 36 OR CN = 39 OR CN > 43 AND CN < 47 OR CN > 47 AND CN < 60 OR CN = 63 OR CN > 64 AND CN < 96 THEN
            FOR FontY = 1 TO 6
                FOR FontX = 1 TO 6
                  IF ChrSet(CN, FontX, FontY) <> 0 THEN PSET (PosX% + (FontX - 1), PosY% + (FontY - 1)), ChrSet(CN, FontX, FontY)
                NEXT FontX
            NEXT FontY
        END IF

        PosX% = PosX% + 6
        IF PosX% >= 320 THEN
            PosX% = 0
            PosY% = PosY% + 6
        END IF

   NEXT Csr

END SUB

SUB PutText (Sentence$, PosX%, PosY%)

    FOR Csr = 1 TO LEN(Sentence$)

        CN = ASC(MID$(UCASE$(Sentence$), Csr, 1))
        IF CN = 33 OR CN = 36 OR CN = 39 OR CN > 43 AND CN < 47 OR CN > 47 AND CN < 60 OR CN = 63 OR CN > 64 AND CN < 96 THEN
            FOR FontY = 1 TO 6
                FOR FontX = 1 TO 6
                  IF ChrSet(CN, FontX, FontY) <> 0 THEN PSET (PosX% + (FontX - 1), PosY% + (FontY - 1)), ChrSet(CN, FontX, FontY)
                NEXT FontX
            NEXT FontY
        END IF

        PosX% = PosX% + 6
        IF PosX% >= 320 THEN
            PosX% = 0
            PosY% = PosY% + 6
        END IF

   NEXT Csr

END SUB

SUB ShowLevel

    FOR Y = 0 TO 11
        FOR X = 0 TO 19
            PUT (X * 16, (Y * 16) + 8), LevelTiles(130 * Level(X, Y)), PSET
            IF X = P1X AND Y = P1Y THEN CALL ShowP1
            IF X = P2X AND Y = P2Y THEN CALL ShowP2
            IF X = SlimeX(0) AND Y = SlimeY(0) THEN CALL ShowSlime(0)
            IF X = SlimeX(1) AND Y = SlimeY(1) THEN CALL ShowSlime(1)
            IF X = SlimeX(2) AND Y = SlimeY(2) THEN CALL ShowSlime(2)
            IF X = Bomb1X(0) AND Y = Bomb1Y(0) + 1 THEN CALL P1Boomer(0)
            IF X = Bomb1X(1) AND Y = Bomb1Y(1) + 1 THEN CALL P1Boomer(1)
            IF X = Bomb1X(2) AND Y = Bomb1Y(2) + 1 THEN CALL P1Boomer(2)
            IF X = Bomb2X(0) AND Y = Bomb2Y(0) + 1 THEN CALL P2Boomer(0)
            IF X = Bomb2X(1) AND Y = Bomb2Y(1) + 1 THEN CALL P2Boomer(1)
            IF X = Bomb2X(2) AND Y = Bomb2Y(2) + 1 THEN CALL P2Boomer(2)
        NEXT X
    NEXT Y

    CALL MoveSlime
    LINE (6 * 9, 1)-(6 * 13, 7), 0, BF
    PutText "P1 Score:", 0, 1
    PutNumber P1Score, 6 * 9, 1, 4
    LINE (6 * 24, 1)-(6 * 25, 7), 0, BF
    PutText "P1 Lives:", 6 * 14, 1
    PutNumber P1Lives, 6 * 24, 1, 1

    LINE (6 * 28, 1)-(6 * 29, 7), 0, BF
    PutText "P2 Lives:", 6 * 28, 1
    PutNumber P2Lives, 6 * 38, 1, 1
    LINE (6 * 49, 1)-(6 * 53, 7), 0, BF
    PutText "P2 Score:", 6 * 40, 1
    PutNumber P2Score, 6 * 49, 1, 4

    IF Slime(0) = False AND Slime(1) = Fasle AND Slime(2) = Fasle THEN
        CALL LoadLevel
        CALL InitStats
    END IF

END SUB

SUB ShowP1 STATIC

    IF P1Dir = 0 THEN
            IF P1Type = 0 THEN
                    PUT (P1X * 16, P1Y * 16 + 8), CooeyMask(2 * 130), AND
                    PUT (P1X * 16, P1Y * 16 + 8), Cooey(2 * 130), XOR
                    P1Type = 1
                ELSEIF P1Type = 1 THEN
                    PUT (P1X * 16, P1Y * 16 + 8), CooeyMask(3 * 130), AND
                    PUT (P1X * 16, P1Y * 16 + 8), Cooey(3 * 130), XOR
                    P1Type = 0
            END IF
        ELSEIF P1Dir = 1 THEN
            IF P1Type = 0 THEN
                    PUT (P1X * 16, P1Y * 16 + 8), CooeyMask(0 * 130), AND
                    PUT (P1X * 16, P1Y * 16 + 8), Cooey(0 * 130), XOR
                    P1Type = 1
                ELSEIF P1Type = 1 THEN
                    PUT (P1X * 16, P1Y * 16 + 8), CooeyMask(1 * 130), AND
                    PUT (P1X * 16, P1Y * 16 + 8), Cooey(1 * 130), XOR
                    P1Type = 0
            END IF
        ELSEIF P1Dir = 2 THEN
            IF P1Type = 0 THEN
                    PUT (P1X * 16, P1Y * 16 + 8), CooeyMask(4 * 130), AND
                    PUT (P1X * 16, P1Y * 16 + 8), Cooey(4 * 130), XOR
                    P1Type = 1
                ELSEIF P1Type = 1 THEN
                    PUT (P1X * 16, P1Y * 16 + 8), CooeyMask(5 * 130), AND
                    PUT (P1X * 16, P1Y * 16 + 8), Cooey(5 * 130), XOR
                    P1Type = 0
            END IF
        ELSEIF P1Dir = 3 THEN
            IF P1Type = 0 THEN
                    PUT (P1X * 16, P1Y * 16 + 8), CooeyMask(6 * 130), AND
                    PUT (P1X * 16, P1Y * 16 + 8), Cooey(6 * 130), XOR
                    P1Type = 1
                ELSEIF P1Type = 1 THEN
                    PUT (P1X * 16, P1Y * 16 + 8), CooeyMask(7 * 130), AND
                    PUT (P1X * 16, P1Y * 16 + 8), Cooey(7 * 130), XOR
                    P1Type = 0
            END IF
    END IF

END SUB

SUB ShowP2 STATIC

    IF P2Dir = 0 THEN
            IF P2Type = 0 THEN
                    PUT (P2X * 16, P2Y * 16 + 8), MattressMask(2 * 130), AND
                    PUT (P2X * 16, P2Y * 16 + 8), Mattress(2 * 130), XOR
                    P2Type = 1
                ELSEIF P2Type = 1 THEN
                    PUT (P2X * 16, P2Y * 16 + 8), MattressMask(3 * 130), AND
                    PUT (P2X * 16, P2Y * 16 + 8), Mattress(3 * 130), XOR
                    P2Type = 0
            END IF
        ELSEIF P2Dir = 1 THEN
            IF P2Type = 0 THEN
                    PUT (P2X * 16, P2Y * 16 + 8), MattressMask(0 * 130), AND
                    PUT (P2X * 16, P2Y * 16 + 8), Mattress(0 * 130), XOR
                    P2Type = 1
                ELSEIF P2Type = 1 THEN
                    PUT (P2X * 16, P2Y * 16 + 8), MattressMask(1 * 130), AND
                    PUT (P2X * 16, P2Y * 16 + 8), Mattress(1 * 130), XOR
                    P2Type = 0
            END IF
        ELSEIF P2Dir = 2 THEN
            IF P2Type = 0 THEN
                    PUT (P2X * 16, P2Y * 16 + 8), MattressMask(4 * 130), AND
                    PUT (P2X * 16, P2Y * 16 + 8), Mattress(4 * 130), XOR
                    P2Type = 1
                ELSEIF P2Type = 1 THEN
                    PUT (P2X * 16, P2Y * 16 + 8), MattressMask(5 * 130), AND
                    PUT (P2X * 16, P2Y * 16 + 8), Mattress(5 * 130), XOR
                    P2Type = 0
            END IF
        ELSEIF P2Dir = 3 THEN
            IF P2Type = 0 THEN
                    PUT (P2X * 16, P2Y * 16 + 8), MattressMask(6 * 130), AND
                    PUT (P2X * 16, P2Y * 16 + 8), Mattress(6 * 130), XOR
                    P2Type = 1
                ELSEIF P2Type = 1 THEN
                    PUT (P2X * 16, P2Y * 16 + 8), MattressMask(7 * 130), AND
                    PUT (P2X * 16, P2Y * 16 + 8), Mattress(7 * 130), XOR
                    P2Type = 0
            END IF
    END IF

END SUB

SUB ShowSlime (I)

    IF Slime(I) THEN
        IF SlimePic(I) = 0 THEN
                PUT (SlimeX(I) * 16, SlimeY(I) * 16 + 8), Slime1M, AND
                PUT (SlimeX(I) * 16, SlimeY(I) * 16 + 8), Slime1, XOR
                SlimePic(I) = 1
            ELSEIF SlimePic(I) = 1 THEN
                PUT (SlimeX(I) * 16, SlimeY(I) * 16 + 8), Slime2M, AND
                PUT (SlimeX(I) * 16, SlimeY(I) * 16 + 8), Slime2, XOR
                SlimePic(I) = 0
        END IF
    END IF

END SUB

