'BRAKBLOX.BAS
'BreakBLOX
'vers: 1.9
'created by Derek Andrews


'subs

DECLARE SUB break.block (x!, y!)
DECLARE SUB check.balls ()
DECLARE SUB clear.blocks ()
DECLARE SUB clear.buffer ()
DECLARE SUB count.blocks ()
DECLARE SUB create.sprites ()
DECLARE SUB delay (time!, interval%)
DECLARE SUB demo ()
DECLARE SUB draw.ball ()
DECLARE SUB draw.blocks ()
DECLARE SUB draw.border ()
DECLARE SUB draw.paddle ()
DECLARE SUB erase.ball ()
DECLARE SUB erase.paddle ()
DECLARE SUB font (strng$, SX%, SY%, XF!, YF!, C%, C2%)
DECLARE SUB game.over ()
DECLARE SUB get.collision ()
DECLARE SUB get.ready ()
DECLARE SUB init.play ()
DECLARE SUB init.prog ()
DECLARE SUB menu ()
DECLARE SUB move.ball ()
DECLARE SUB options ()
DECLARE SUB paddle.left ()
DECLARE SUB paddle.right ()
DECLARE SUB play.game ()
DECLARE SUB print.score ()
DECLARE SUB read.data ()
DECLARE SUB reset.screen ()
DECLARE SUB reset.vals ()
DECLARE SUB score.down ()
DECLARE SUB score.up ()
DECLARE SUB status.bar ()
DECLARE SUB wait.for.event ()


'functions

DECLARE FUNCTION hit.key! ()


'constants

CONST key.up% = 72               'up arrow key
CONST key.down% = 80             'down arrow key
CONST quit% = 16                 'Q key
CONST yes% = 21                  'Y key
CONST no% = 49                   'N key
CONST enter% = 28                'carriage return key
CONST pause% = 25                'P key
CONST total.blocks% = 180        'total number of blocks stored in blocks% array
CONST loseballcoord% = 195       'Y coordinate at which ball is lost
CONST score.interval% = 1000     'number of points needed to earn a new ball
CONST top.score& = 999999        'highest possible score
CONST background% = 198          'background color
CONST wallcolor% = 3             'color of border
CONST wallbounce$ = "MBT255O1L64ABCD"       'sound effects
CONST paddlebounce$ = "MBT255O2L64BBGD"
CONST blockbreak$ = "MBT255O2L64GDAC"
CONST newball$ = "MBMLO3T180L32CEG"
CONST loseball$ = "MFMLO2T230L16BDO1F"


'global variables

DIM SHARED blocksleft%                             'number of blocks left to be broken
DIM SHARED ballx!, bally!, xinc!, yinc!, rad%      'ball variables
DIM SHARED padx%, pady%, padinc%, padw%, padh%     'paddle variables
DIM SHARED ballsleft%                              'number of extra balls left
DIM SHARED score&                                  'score variables
DIM SHARED key.right%, key.left%                   'left and right key variables
DIM SHARED speed%                                  'speed of play


'global arrays

DIM SHARED blocks%(1 TO total.blocks%)     'stores block colors
DIM SHARED ball(21)                        'ball sprite
DIM SHARED paddle(39)                      'paddle sprite


'main program block

init.prog
play.game


'level data---you can edit these or add your own levels
'make sure each one has 180 integers in it. The blocks
'appear on screen as a 15x12 matrix, even though a
'one -dimensional array is used. Organize the data as
'a 15x12 matrix.

DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
DATA 13,13,13,13,13,13,13,13,13,13,13,13,13,13,13
DATA 12,12,12,12,12,12,12,12,12,12,12,12,12,12,12
DATA 10,10,10,10,10,10,10,10,10,10,10,10,10,10,10
DATA 11,11,11,11,11,11,11,11,11,11,11,11,11,11,11
DATA 5,5,5,5,5,5,5,5,5,5,5,5,5,5,5
DATA 14,14,14,14,14,14,14,14,14,14,14,14,14,14,14
DATA 9,9,9,9,9,9,9,9,9,9,9,9,9,9,9
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

DATA 1,0,1,0,1,0,1,0,1,0,1,0,1,0,1
DATA 0,13,0,13,0,13,0,13,0,13,0,13,0,13,0
DATA 12,0,12,0,12,0,12,0,12,0,12,0,12,0,12
DATA 0,10,0,10,0,10,0,10,0,10,0,10,0,10,0
DATA 11,0,11,0,11,0,11,0,11,0,11,0,11,0,11
DATA 0,5,0,5,0,5,0,5,0,5,0,5,0,5,0
DATA 14,0,14,0,14,0,14,0,14,0,14,0,14,0,14
DATA 0,9,0,9,0,9,0,9,0,9,0,9,0,9,0
DATA 1,0,1,0,1,0,1,0,1,0,1,0,1,0,1
DATA 0,13,0,13,0,13,0,13,0,13,0,13,0,13,0
DATA 12,0,12,0,12,0,12,0,12,0,12,0,12,0,12
DATA 0,10,0,10,0,10,0,10,0,10,0,10,0,10,0

DATA 0,0,1,0,0,0,0,1,0,0,0,0,1,0,0
DATA 0,0,8,0,0,0,0,8,0,0,0,0,8,0,0
DATA 0,0,1,0,0,0,0,1,0,0,0,0,1,0,0
DATA 8,8,8,1,1,1,8,8,8,1,1,1,8,8,8
DATA 1,1,1,8,8,8,1,1,1,8,8,8,1,1,1
DATA 8,8,8,1,1,1,8,8,8,1,1,1,8,8,8
DATA 1,1,1,8,8,8,1,1,1,8,8,8,1,1,1
DATA 8,8,8,1,1,1,8,8,8,1,1,1,8,8,8
DATA 1,1,1,8,8,8,1,1,1,8,8,8,1,1,1
DATA 8,8,8,1,1,1,8,8,8,1,1,1,8,8,8
DATA 1,1,1,8,8,8,1,1,1,8,8,8,1,1,1
DATA 8,8,8,1,1,1,8,8,8,1,1,1,8,8,8
  
DATA 0,9,0,0,9,0,0,9,0,0,9,0,0,9,0
DATA 0,7,0,7,15,7,0,7,0,7,15,7,0,7,0
DATA 2,2,2,2,2,2,2,2,2,2,2,2,2,2,2
DATA 0,7,0,7,15,7,0,7,0,7,15,7,0,7,0
DATA 0,9,0,0,9,0,0,9,0,0,9,0,0,9,0
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 0,9,0,0,9,0,0,9,0,0,9,0,0,9,0
DATA 0,7,0,7,8,7,0,7,0,7,8,7,0,7,0
DATA 2,2,2,2,2,2,2,2,2,2,2,2,2,2,2
DATA 0,7,0,7,8,7,0,7,0,7,8,7,0,7,0
DATA 0,9,0,0,9,0,0,9,0,0,9,0,0,9,0
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 10,0,0,0,12,8,8,0,0,0,14,8,8,8,13
DATA 10,8,8,8,12,0,0,2,8,8,14,0,0,0,13
DATA 10,0,0,0,12,8,8,5,0,0,14,8,8,8,13
DATA 10,8,8,8,12,0,0,2,8,8,14,0,0,0,13
DATA 10,0,0,0,12,8,8,5,0,0,14,8,8,8,13
DATA 10,8,8,8,12,0,0,2,8,8,14,0,0,0,13
DATA 10,0,0,0,12,8,8,5,0,0,14,8,8,8,13
DATA 10,8,8,8,12,0,0,2,8,8,14,0,0,0,13
DATA 10,0,0,0,12,8,8,5,0,0,14,8,8,8,13
DATA 10,8,8,8,12,0,0,2,8,8,14,0,0,0,13
DATA 10,0,0,0,12,8,8,5,0,0,14,8,8,8,13

DATA 0,0,0,5,5,0,0,14,0,0,5,5,0,0,0
DATA 0,0,0,8,8,0,0,14,0,0,8,8,0,0,0
DATA 0,0,0,8,8,0,0,14,0,0,8,8,0,0,0
DATA 0,0,0,8,8,0,0,14,0,0,8,8,0,0,0
DATA 0,0,0,1,1,0,0,14,0,0,1,1,0,0,0
DATA 0,2,2,1,1,2,2,14,2,2,1,1,2,2,0
DATA 0,0,0,4,4,0,0,4,0,0,4,4,0,0,0
DATA 15,4,4,4,4,4,4,4,4,4,4,4,4,4,15
DATA 15,13,13,13,13,13,13,13,13,13,13,13,13,13,15
DATA 15,12,12,12,12,12,12,12,12,12,12,12,12,12,15
DATA 15,10,10,10,10,10,10,10,10,10,10,10,10,10,15
DATA 15,11,11,11,11,11,11,11,11,11,11,11,11,11,15

DATA 13,6,0,0,0,4,4,10,0,0,0,0,0,6,5
DATA 0,0,0,6,0,0,0,11,12,12,0,6,0,0,0
DATA 0,6,0,0,0,4,4,10,0,0,0,0,0,6,0
DATA 0,0,0,6,0,0,0,11,12,12,0,6,0,0,0
DATA 0,6,0,0,0,4,4,10,0,0,0,0,0,6,0
DATA 0,0,0,6,0,0,0,11,12,12,0,6,0,0,0
DATA 0,6,0,0,0,4,4,10,0,0,0,0,0,6,0
DATA 0,0,0,6,0,0,0,11,12,12,0,6,0,0,0
DATA 0,6,0,0,0,4,4,10,0,0,0,0,0,6,0
DATA 0,0,0,6,0,0,0,11,12,12,0,6,0,0,0
DATA 0,6,0,0,0,4,4,10,0,0,0,0,0,6,0
DATA 5,0,0,6,0,0,0,11,12,12,0,6,0,0,13

DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 14,5,14,5,14,5,14,5,14,5,14,5,14,5,14
DATA 5,2,5,2,5,2,5,2,5,2,5,2,5,2,5
DATA 14,5,14,5,14,5,14,5,14,5,14,5,14,5,14
DATA 14,5,14,5,14,5,14,5,14,5,14,5,14,5,14
DATA 5,2,5,2,5,2,5,2,5,2,5,2,5,2,5
DATA 14,5,14,5,14,5,14,5,14,5,14,5,14,5,14
DATA 14,5,14,5,14,5,14,5,14,5,14,5,14,5,14
DATA 5,2,5,2,5,2,5,2,5,2,5,2,5,2,5
DATA 14,5,14,5,14,5,14,5,14,5,14,5,14,5,14

DATA 8,9,7,0,8,9,7,4,8,9,7,0,8,9,7
DATA 4,8,9,7,0,8,9,7,4,8,9,7,0,8,9
DATA 7,4,8,9,7,0,8,9,7,4,8,9,7,0,8
DATA 9,7,4,8,9,7,0,8,9,7,4,8,9,7,0
DATA 8,4,7,9,8,0,7,9,8,4,7,9,8,0,7
DATA 9,8,4,7,9,8,0,7,9,8,4,7,9,8,0
DATA 7,9,8,4,7,9,8,0,7,9,8,4,7,9,8
DATA 0,7,9,8,4,7,9,8,0,7,9,8,4,7,9
DATA 8,0,7,9,8,4,7,9,8,0,7,9,8,4,7
DATA 9,8,0,7,9,8,4,7,9,8,0,7,9,8,4
DATA 7,9,8,0,7,9,8,4,7,9,8,0,7,9,8
DATA 4,7,9,8,0,7,9,8,4,7,9,8,0,7,9

DATA 1,1,2,5,0,13,1,1,2,5,0,13,0,4,0
DATA 0,4,0,13,0,5,2,1,1,13,0,5,2,1,1
DATA 1,1,2,5,0,13,1,1,2,5,0,13,0,4,0
DATA 0,4,0,13,0,5,2,1,1,13,0,5,2,1,1
DATA 1,1,2,5,0,13,1,1,2,5,0,13,0,4,0
DATA 0,4,0,13,0,5,2,1,1,13,0,5,2,1,1
DATA 1,1,2,5,0,13,1,1,2,5,0,13,0,4,0
DATA 0,4,0,13,0,5,2,1,1,13,0,5,2,1,1
DATA 1,1,2,5,0,13,1,1,2,5,0,13,0,4,0
DATA 0,4,0,13,0,5,2,1,1,13,0,5,2,1,1
DATA 1,1,2,5,0,13,1,1,2,5,0,13,0,4,0
DATA 0,4,0,13,0,5,2,1,1,13,0,5,2,1,1

DATA 0,0,0,13,0,0,0,0,0,0,0,13,0,0,0
DATA 0,0,0,0,4,0,0,0,0,0,4,0,0,0,0
DATA 0,0,0,0,0,13,0,0,0,13,0,0,0,0,0
DATA 10,10,1,10,10,0,4,0,4,0,10,10,1,10,10
DATA 0,1,10,1,6,6,6,13,6,6,6,1,10,1,0
DATA 0,0,1,0,0,0,4,0,4,0,0,0,1,0,0
DATA 0,0,0,0,0,13,0,0,0,13,0,0,0,0,0
DATA 0,0,0,0,4,0,0,0,0,0,4,0,0,0,0
DATA 0,0,0,13,0,0,0,0,0,0,0,13,0,0,0
DATA 0,0,4,0,0,0,0,0,0,0,0,0,4,0,0
DATA 0,13,0,0,0,0,0,0,0,0,0,0,0,13,0
DATA 4,0,0,0,0,0,0,0,0,0,0,0,0,0,4

DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 19,19,19,19,19,19,19,19,19,19,19,19,19,19,19
DATA 20,20,20,20,20,20,20,20,20,20,20,20,20,20,20
DATA 21,21,21,21,21,21,21,21,21,21,21,21,21,21,21
DATA 22,22,22,22,22,22,22,22,22,22,22,22,22,22,22
DATA 23,23,23,23,23,23,23,23,23,23,23,23,23,23,23
DATA 24,24,24,24,24,24,24,24,24,24,24,24,24,24,24
DATA 25,25,25,25,25,25,25,25,25,25,25,25,25,25,25
DATA 26,26,26,26,26,26,26,26,26,26,26,26,26,26,26
DATA 27,27,27,27,27,27,27,27,27,27,27,27,27,27,27

DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 32,32,32,32,32,32,32,32,32,32,32,32,32,32,32
DATA 33,33,33,33,33,33,33,33,33,33,33,33,33,33,33
DATA 34,34,34,34,34,34,34,34,34,34,34,34,34,34,34
DATA 35,35,35,35,35,35,35,35,35,35,35,35,35,35,35
DATA 36,36,36,36,36,36,36,36,36,36,36,36,36,36,36
DATA 37,37,37,37,37,37,37,37,37,37,37,37,37,37,37
DATA 38,38,38,38,38,38,38,38,38,38,38,38,38,38,38
DATA 39,39,39,39,39,39,39,39,39,39,39,39,39,39,39
DATA 40,40,40,40,40,40,40,40,40,40,40,40,40,40,40
DATA 41,41,41,41,41,41,41,41,41,41,41,41,41,41,41

DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 20,21,22,23,24,25,26,26,26,25,24,23,22,21,20
DATA 20,21,22,23,24,25,26,26,26,25,24,23,22,21,20
DATA 32,33,34,35,36,37,38,38,38,37,36,35,34,33,32
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 20,0,22,0,24,0,26,0,26,0,24,0,22,0,20
DATA 20,21,0,23,0,25,0,26,0,25,0,23,0,21,0
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 32,33,34,35,36,37,38,38,38,37,36,35,34,33,32
DATA 20,21,22,23,24,25,26,26,26,25,24,23,22,21,20
DATA 20,21,22,23,24,25,26,26,26,25,24,23,22,21,20

DATA 138,0,138,0,138,0,138,0,138,0,138,0,138,0,138
DATA 0,44,0,44,0,44,0,44,0,44,0,44,0,44,0
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 1,1,1,8,8,8,1,1,1,8,8,8,1,1,1
DATA 8,8,8,1,1,1,8,8,8,1,1,1,8,8,8
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 1,1,1,8,8,8,1,1,1,8,8,8,1,1,1
DATA 8,8,8,1,1,1,8,8,8,1,1,1,8,8,8
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 0,44,0,44,0,44,0,44,0,44,0,44,0,44,0
DATA 138,0,138,0,138,0,138,0,138,0,138,0,138,0,138

DATA -1     'marks end of level data---when program finds this, it
            'returns to the beginning level.

'paints the region at x!, y! in the background color plays
'the block-breaking sound effect, and decrements the number
'of blocks left. Used only by get.collision.
'
SUB break.block (x!, y!)

PAINT (x!, y!), background%, background%
PLAY blockbreak$
blocksleft% = blocksleft% - 1
score.up
status.bar

END SUB

'checks to see if player is worthy of recieving an extra ball.
'
SUB check.balls

FOR i = 1 TO 100
     IF score& = (i * score.interval%) THEN
          IF ballsleft% < 7 THEN
               ballsleft% = ballsleft% + 1
               PLAY newball$
          END IF
     END IF
NEXT i
     
END SUB

'clears blocks% array to background color.
'
SUB clear.blocks

FOR i = 1 TO total.blocks%
     blocks%(i) = background%
NEXT i

END SUB

'waits until keyboard buffer is null
'
SUB clear.buffer

WHILE LEN(INKEY$): WEND

END SUB

'counts number of blocks not equal to background% color.
'This is vital to the operation of the program, as the
'program never needs to know which block the ball hits,
'it instead counts the number of blocks destroyed.
'
SUB count.blocks

blocksleft% = 0
FOR i = 1 TO total.blocks
     IF blocks%(i) <> background% THEN
          blocksleft% = blocksleft% + 1
     END IF
NEXT i

END SUB

'draws and places sprites into their respective arrays
'this happens so fast that you can't see it.
'
SUB create.sprites

LINE (ballx! - rad%, bally! - rad%)-(ballx! + rad%, bally! + rad%), background%, BF
CIRCLE (ballx!, bally!), rad%, 19
PAINT (ballx!, bally!), 29, 19
CIRCLE (ballx!, bally!), rad% - 1, 23
CIRCLE (ballx!, bally!), rad% - 2, 26
CIRCLE (ballx!, bally!), rad% - 3, 28
CIRCLE (ballx!, bally!), rad% - 4, 29
PSET (ballx! - 2, bally! - 2), 23
PSET (ballx! + 2, bally! - 2), 23
PSET (ballx! - 2, bally! + 2), 23
PSET (ballx! + 2, bally! + 2), 23
GET (ballx! - rad%, bally! - rad%)-(ballx! + rad%, bally! + rad%), ball

LINE (padx% - padw%, pady% - padh%)-(padx% + padw%, pady% + padh%), 22, BF
LINE (padx% - (padw% - 1), pady% - (padh% - 1))-(padx% + (padw% - 1), pady% + (padh% - 1)), 25, B
LINE (padx% - (padw% - 2), pady%)-(padx% + (padw% - 2), pady%), 27
LINE (padx%, pady% - padh%)-(padx%, pady% + padh%), 32
LINE (padx% - 1, pady% - padh%)-(padx% - 1, pady% + padh%), 34
LINE (padx% + 1, pady% - padh%)-(padx% + 1, pady% + padh%), 34
GET (padx% - padw%, pady% - padh%)-(padx% + padw%, pady% + padh%), paddle

END SUB

'delays for time! every interval% calls.
'this avoids the clumsy technique of counting
'in an empty loop to calculate the processor speed,
'which can cause irregular pauses in animation.
'
SUB delay (time!, interval%)

STATIC yespause%
IF yespause% >= interval% THEN
    t! = TIMER
    DO
        clear.buffer
    LOOP UNTIL TIMER - t! >= time!
    yespause% = 0
END IF
IF interval% > 0 THEN yespause% = yespause% + 1

END SUB

'computer plays game after player has waited at the title
'screen for several seconds.
'
SUB demo

RESTORE            'demo restores data each time it runs
init.play
ballsleft% = 3
score& = 0
status.bar
draw.paddle
clear.buffer
scancode% = hit.key     'stores current keycode to tell when player presses a key
time! = TIMER
DO
     draw.ball
     draw.paddle
     delay .01, 6
     get.collision
     erase.ball
     move.ball
     IF ballx! > padx% + (padw% - 5) THEN paddle.right    'if ball is getting away to the right, move paddle right
     IF ballx! < padx% - (padw% - 5) THEN paddle.left     'likewise to the left
     IF blocksleft% = 0 THEN     'if demo finishes level, go to the next
          CLS
          init.play
          status.bar
          delay 1, 0
     END IF
LOOP UNTIL hit.key <> scancode% OR TIMER - time! >= 120    'waits until player presses a key or demo plays for 90 secs

END SUB

'places ball sprite on screen according to ball coordinates
'
SUB draw.ball

PUT (ballx! - rad%, bally! - rad%), ball, PSET

END SUB

'dumps the one-dimensional blocks% array onto screen in a 15x12 matrix.
'
SUB draw.blocks
  
count% = 1     'index variable for blocks% array
FOR DY = 20 TO 130 STEP 10
     FOR DX = 10 TO 300 STEP 20
          IF blocks%(count%) <> background% THEN
               LINE (DX, DY)-STEP(17, 0), 25         'metallic outline
               LINE (DX, DY)-STEP(0, 8), 24
               LINE (DX + 18, DY)-STEP(0, 8), 27
               LINE (DX, DY + 8)-STEP(17, 0), 28
               LINE (DX + 1, DY + 1)-STEP(16, 6), blocks%(count%), BF
          END IF
          count% = count% + 1
     NEXT DX
NEXT DY

END SUB

'draws play border
'
SUB draw.border

LINE (0, 0)-(8, 200), wallcolor%, BF
LINE (0, 0)-(320, 9), wallcolor%, BF
LINE (320, 0)-(310, 200), wallcolor%, BF

END SUB

'places paddle on screen according to paddle coordinates
'
SUB draw.paddle

PUT (padx% - padw%, pady% - padh%), paddle, PSET

END SUB

'erases ball with a background% color box---using XOR screws up the background
'
SUB erase.ball

LINE (ballx! - rad%, bally! - rad%)-(ballx! + rad%, bally! + rad%), background%, BF

END SUB

'draws a background% color box to erase paddle---not used in paddle animation
'
SUB erase.paddle

LINE (padx% - padw%, pady% - padh%)-(padx% + padw%, pady% + padh%), background%, BF

END SUB

'prints strng$ to screen in one of SCREEN 13's many black attributes
'and then scales it by XF! and YF! and increments the image by SX%, SY%
'it makes a shadow background with C2%
'
SUB font (strng$, SX%, SY%, XF!, YF!, C%, C2%)

LOCATE 1, 1
PRINT SPACE$(LEN(strng$) + 1)     'erase any remaining text
LOCATE 1, 1
COLOR 16
PRINT strng$
FOR y = 0 TO 7
     FOR x = 0 TO (LEN(strng$) * 8)
          IF POINT(x, y) <> 0 THEN
               x2 = x * XF!
               y2 = y * YF!
               LINE (x2 + SX%, y2! + SY%)-STEP(XF! - .5, YF! - .5), C%, BF
               LINE (x2 + (SX% - 1), y2! + (SY% - 1))-STEP(XF! - .5, YF! - .5), C2%, BF
          END IF
     NEXT x
NEXT y

END SUB

'notifies player that they have lost, and waits for the player to
'press a key if it is not depressed, or let go and press a key if it
'is depressed
'
SUB game.over

font "GAME OVER", 128, 150, 1, 1, 1, 15
status.bar
draw.paddle
IF hit.key = key.left% OR hit.key = key.right% THEN wait.for.event
DO: clear.buffer: LOOP UNTIL hit.key > 100
wait.for.event

END SUB

'compares position of ball and color of certain pixels around the ball to
'destroy blocks. This is the whole idea behind the BreakBLOX engine. The ball
'moves along, and if what it finds on one of its sides is not equal to the
'background color, it paints what it finds---a block---black. This allows the
'program to avoid detecting which block it hits.
'
SUB get.collision

'ball hits left or right wall
IF POINT(ballx! + (rad% + 2), bally!) = wallcolor% OR POINT(ballx! - (rad% + 2), bally!) = wallcolor% THEN
     xinc! = -xinc!
     PLAY wallbounce$
     EXIT SUB
END IF

'ball hits paddle---the series of conditionals are what make the ball bounce
'at six different angles.
IF ballx! >= padx% - padw% AND ballx! <= padx% + padw% AND bally! + rad% >= pady% - padh% AND bally! + rad% <= pady% + padh% AND yinc! > 0 THEN
     yinc! = -yinc!
     IF ballx! >= padx% AND ballx! < padx% + 5 THEN xinc! = .75
     IF ballx! >= padx% + 5 AND ballx! < padx% + 10 THEN xinc! = 1
     IF ballx! >= padx% + 10 THEN xinc! = 1.5
     IF ballx! <= padx% AND ballx! > padx% - 5 THEN xinc! = -.75
     IF ballx! <= padx% - 5 AND ballx! > padx% - 10 THEN xinc! = -1
     IF ballx! <= padx% - 10 THEN xinc! = -1.5
     PLAY paddlebounce$
     EXIT SUB
END IF

IF bally! > 150 THEN     'if ball is below the blocks then...
    
     'ball hits left side of paddle
     IF bally! >= pady% - padh% AND POINT(ballx! + (rad% + 2), bally! + 2) <> wallcolor% AND POINT(ballx! + (rad% + 2), bally! + 2) <> background% AND xinc! > 0 THEN
          xinc! = -xinc!
          PLAY paddlebounce$
          EXIT SUB
     END IF
     'ball hits right side of paddle
     IF bally! >= pady% - padh% AND POINT(ballx! - (rad% + 2), bally! + 2) <> wallcolor% AND POINT(ballx! - (rad% + 2), bally! + 2) <> background% AND xinc! < 0 THEN
          xinc! = -xinc!
          PLAY paddlebounce$
          EXIT SUB
     END IF
END IF
IF bally! - (rad% + 1) <= 10 AND yinc! < 0 THEN     'ball hits ceiling
     yinc! = -yinc!
     PLAY wallbounce$
     EXIT SUB
END IF

'if this conditional is not used, the ball will think the paddle is a block
'and will destroy it.
IF bally! <= 150 THEN
     'left of ball hits a block
     IF POINT(ballx! - (rad% + 2), bally! + 3) <> wallcolor% AND POINT(ballx! - (rad% + 2), bally! + 3) <> background% AND xinc! < 0 THEN
          xinc! = -xinc!
          break.block ballx! - (rad% + 2), bally! + 3
          EXIT SUB
     END IF
     IF POINT(ballx! - (rad% + 2), bally! - 3) <> wallcolor% AND POINT(ballx! - (rad% + 2), bally! - 3) <> background% AND xinc! < 0 THEN
          xinc! = -xinc!
          break.block ballx! - (rad% + 2), bally! - 3
          EXIT SUB
     END IF
     'right of ball hits a block
     IF POINT(ballx! + (rad% + 2), bally! + 3) <> wallcolor% AND POINT(ballx! + (rad% + 2), bally! + 3) <> background% AND xinc! > 0 THEN
          xinc! = -xinc!
          break.block ballx! + (rad% + 2), bally! + 3
          EXIT SUB
     END IF
     IF POINT(ballx! + (rad% + 2), bally! - 3) <> wallcolor% AND POINT(ballx! + (rad% + 2), bally! - 3) <> background% AND xinc! > 0 THEN
          xinc! = -xinc!
          break.block ballx! + (rad% + 2), bally! - 3
          EXIT SUB
     END IF
     'top of ball hits a block
     IF POINT(ballx! + 3, bally! - (rad% + 2)) <> wallcolor% AND POINT(ballx! + 3, bally! - (rad% + 2)) <> background% AND yinc! < 0 THEN
          yinc! = -yinc!
          break.block ballx! + 3, bally! - (rad% + 2)
          EXIT SUB
     END IF
     IF POINT(ballx! - 3, bally! - (rad% + 2)) <> wallcolor% AND POINT(ballx! - 3, bally! - (rad% + 2)) <> background% AND yinc! < 0 THEN
          yinc! = -yinc!
          break.block ballx! - 3, bally! - (rad% + 2)
          EXIT SUB
     END IF
     'bottom of ball hits a block
     IF POINT(ballx! + 3, bally! + (rad% + 2)) <> wallcolor% AND POINT(ballx! + 3, bally! + (rad% + 2)) <> background% AND yinc! > 0 THEN
          yinc! = -yinc!
          break.block ballx! + 3, bally! + (rad% + 2)
          EXIT SUB
     END IF
     IF POINT(ballx! - 3, bally! + (rad% + 2)) <> wallcolor% AND POINT(ballx! - 3, bally! + (rad% + 2)) <> background% AND yinc! > 0 THEN
          yinc! = -yinc!
          break.block ballx! - 3, bally! + (rad% + 2)
          EXIT SUB
     END IF
END IF

END SUB

'notifies player that game is ready and waits for one second.
'
SUB get.ready

font "Get Ready!", 123, 150, 1, 1, 32, 15
status.bar
delay 1, 0
LINE (120, 145)-(205, 160), background%, BF
status.bar

END SUB

'gets scancode from keyboard port
'The extra code here may not seem necessary, but on some computers,
'the scancode is irregular for the arrow keys. This ignores all codes
'above 215.
'
FUNCTION hit.key

STATIC prev.code%, scancode%
IF scancode% = 0 THEN scancode% = 100     'demo waits for key to be less than 100,
                                          'so it has to be set when program starts.
scancode% = INP(96)
IF scancode% > 215 THEN hit.key = prev.code% ELSE hit.key = scancode%
IF scancode% <= 215 THEN prev.code% = scancode%

END FUNCTION

'sets up program for play
'
SUB init.play

CLS
clear.blocks
read.data
PAINT (160, 100), background%
draw.blocks
draw.border
count.blocks
reset.vals

END SUB

'program initialization---320x200x256 res, random number seed...etc.
'called once.
'
SUB init.prog
       
SCREEN 13: CLS
RANDOMIZE TIMER
clear.buffer
reset.vals
create.sprites
key.left% = 75      'left and right arrow keys and speed
                    'are not stored as constants so they
                    'can be changed in the options menu.
key.right% = 77
speed% = 4

END SUB

'draws title screen, and glowing cursor, which the player can move
'with the up and down arrow keys. branch% is a flag used to direct program
'flow in play.game
'
SUB menu

startmenu:
CLS
PAINT (3, 3), 200
font "BreakBLOX", 14, 30, 4, 10, 46, 5
font "vers 1.9", 66, 33, .8, 1, 76, 170
font "created by Derek Andrews", 77, 107, .9, 1, 76, 170
font "Start Game", 115, 131, 1.2, 1, 138, 14
font "Options", 125, 148, 1.2, 1, 138, 14
font "Exit", 138, 165, 1.2, 1, 138, 14
PSET (10, 10), 80
DRAW "D100 F70 R160 E70 U100 L300"
PAINT (3, 3), 111, 80
selected% = 1
boxcol% = 17
boxcolinc% = 1
time! = TIMER
DO
     IF TIMER - time! >= 15 THEN     'if player STILL hasn't done something for 15 seconds,
                                     'run the demo.
          time! = TIMER
          demo
          GOTO startmenu
     END IF
     boxcol% = boxcol% + boxcolinc%
     IF boxcol% = 16 OR boxcol% = 28 THEN boxcolinc% = -boxcolinc%
     clear.buffer
     delay .01, 2
     SELECT CASE hit.key
          CASE key.up%
               time! = TIMER
               IF selected% > 1 THEN
                    delay .1, 0
                    selected% = selected% - 1
               END IF
          CASE key.down%
               time! = TIMER
               IF selected% < 3 THEN
                    delay .1, 0
                    selected% = selected% + 1
               END IF
          CASE enter%
               time! = TIMER
               IF selected% = 1 THEN EXIT SUB
               IF selected% = 2 THEN options: GOTO startmenu
               IF selected% = 3 THEN reset.screen: clear.buffer: END
     END SELECT
     SELECT CASE selected%
          CASE 1
               LINE (113, 128)-(212, 139), boxcol%, B
               LINE (123, 145)-(193, 157), 200, B
          CASE 2
               LINE (123, 145)-(193, 157), boxcol%, B
               LINE (113, 128)-(212, 139), 200, B
               LINE (136, 162)-(177, 173), 200, B
          CASE 3
               LINE (136, 162)-(177, 173), boxcol%, B
               LINE (123, 145)-(193, 157), 200, B
     END SELECT
LOOP

END SUB

'increments ball coordinates by their speeds
'
SUB move.ball

ballx! = ballx! + xinc!
bally! = bally! + yinc!

END SUB

'displays options menu and glowing cursor, which player can control with
'the up and down arrow keys. The player can select options with the enter key.
'how the values are changed is self-explanatory
'
SUB options

CLS
LINE (0, 30)-(320, 170), background%, BF
LINE (0, 29)-(320, 29), 76
LINE (0, 171)-(320, 171), 76
font "OPTIONS", 120, 15, 1.2, 1, 138, 14
font "Left Key: " + STR$(key.left%), 65, 61, 1.2, 1, 138, 14
font "Right Key: " + STR$(key.right%), 65, 81, 1.2, 1, 138, 14
font "Speed: " + STR$(speed%), 65, 101, 1.2, 1, 138, 14
font "Exit", 68, 121, 1.2, 1, 138, 14
selected% = 1
boxcol% = 17
boxcolinc% = 1
delay .2, 0
clear.buffer
DO
     boxcol% = boxcol% + boxcolinc%
     IF boxcol% = 17 OR boxcol% = 28 THEN boxcolinc% = -boxcolinc%
     clear.buffer
     delay .01, 2
     SELECT CASE hit.key
          CASE key.up%
               IF selected% > 1 THEN
                    delay .1, 0
                    selected% = selected% - 1
               END IF
          CASE key.down%
               IF selected% < 4 THEN
                    delay .1, 0
                    selected% = selected% + 1
               END IF
          CASE enter%
               IF selected% = 1 THEN
                    clear.buffer
                    new.key% = 0
                    delay .2, 0
                    LINE (44, 58)-(60, 70), 4, BF
                    DO
                         scancode% = hit.key
                         DO
                              LINE (64, 58)-(190, 70), boxcol%, B
                              boxcol% = boxcol% + boxcolinc%
                              IF boxcol% = 17 OR boxcol% = 28 THEN boxcolinc% = -boxcolinc%
                              delay .01, 2
                         LOOP UNTIL scancode% <> hit.key
                         IF hit.key <> enter% AND hit.key <> key.right% AND hit.key <> key.up% AND hit.key <> key.down% AND hit.key < 100 THEN new.key% = hit.key
                         IF hit.key = enter% THEN new.key% = key.left%: EXIT DO
                    LOOP UNTIL new.key%
                    IF new.key% <> key.left% THEN
                         font "Left Key: " + STR$(key.left%), 65, 61, 1.2, 1, background%, background%
                         key.left% = new.key%
                         font "Left Key: " + STR$(key.left%), 65, 61, 1.2, 1, 138, 14
                    END IF
                    delay .2, 0
                    LINE (44, 58)-(60, 70), background%, BF
               END IF
               IF selected% = 2 THEN
                    clear.buffer
                    new.key% = 0
                    delay .2, 0
                    LINE (44, 78)-(60, 90), 4, BF
                    DO
                         scancode% = hit.key
                         DO
                              LINE (63, 78)-(200, 90), boxcol%, B
                              boxcol% = boxcol% + boxcolinc%
                              IF boxcol% = 17 OR boxcol% = 28 THEN boxcolinc% = -boxcolinc%
                              delay .01, 2
                         LOOP UNTIL scancode% <> hit.key
                         IF hit.key <> enter% AND hit.key <> key.left% AND hit.key <> key.up% AND hit.key <> key.down% AND hit.key < 100 THEN new.key% = hit.key
                         IF hit.key = enter% THEN new.key% = key.right%: EXIT DO
                    LOOP UNTIL new.key%
                    IF new.key% <> key.right% THEN
                         font "Right Key: " + STR$(key.right%), 65, 81, 1.2, 1, background%, background%
                         key.right% = new.key%
                         font "Right Key: " + STR$(key.right%), 65, 81, 1.2, 1, 138, 14
                    END IF
                    delay .2, 0
                    LINE (44, 78)-(60, 90), background%, BF
               END IF
               IF selected% = 3 THEN
                    clear.buffer
                    delay .2, 0
                    LINE (44, 98)-(60, 110), 4, BF
                    DO
                         clear.buffer
                         IF hit.key = key.left% THEN
                              font "Speed: " + STR$(speed%), 65, 101, 1.2, 1, background%, background%
                              IF speed% > 1 THEN speed% = speed% - 1
                              font "Speed: " + STR$(speed%), 65, 101, 1.2, 1, 138, 14
                              delay .2, 0
                         END IF
                         IF hit.key = key.right% THEN
                              font "Speed: " + STR$(speed%), 65, 101, 1.2, 1, background%, background%
                              IF speed% < 10 THEN speed% = speed% + 1
                              font "Speed: " + STR$(speed%), 65, 101, 1.2, 1, 138, 14
                              delay .2, 0
                         END IF
                         IF hit.key = enter% THEN EXIT DO
                         LINE (63, 98)-(163, 110), boxcol%, B
                         boxcol% = boxcol% + boxcolinc%
                         IF boxcol% = 17 OR boxcol% = 28 THEN boxcolinc% = -boxcolinc%
                         delay .01, 2
                    LOOP
                    delay .2, 0
                    LINE (44, 98)-(60, 110), background%, BF
               END IF
               IF selected% = 4 THEN EXIT DO
     END SELECT
     SELECT CASE selected%
          CASE 1
               LINE (64, 58)-(190, 70), boxcol%, B
               LINE (63, 78)-(200, 90), background%, B
          CASE 2
               LINE (63, 78)-(200, 90), boxcol%, B
               LINE (64, 58)-(190, 70), background%, B
               LINE (63, 98)-(163, 110), background%, B
          CASE 3
               LINE (63, 98)-(163, 110), boxcol%, B
               LINE (63, 78)-(200, 90), background%, B
               LINE (66, 118)-(107, 129), background%, B
          CASE 4
               LINE (66, 118)-(107, 129), boxcol%, B
               LINE (63, 98)-(163, 110), background%, B
     END SELECT
LOOP
delay .2, 0
clear.buffer

END SUB

'moves paddle left and erases pixel size trail behind it.
'this is a really neat technique, because it allows increments to be large,
'but still stop accurately at the walls.
'
SUB paddle.left

FOR i = 1 TO padinc%
     IF padx% > 24 THEN
          LINE (padx% + padw%, pady% - padh%)-(padx% + padw%, pady% + padh%), background%
          padx% = padx% - 1
     ELSE
          EXIT FOR
     END IF
NEXT i

END SUB

'moves paddle right and erases pixel size trail behind it.
'this is a really neat technique, because it allows increments to be large,
'but still stop accurately at the walls.
'
SUB paddle.right

FOR i = 1 TO padinc%
     IF padx% < 294 THEN
          LINE (padx% - padw%, pady% - padh%)-(padx% - padw%, pady% + padh%), background%
          padx% = padx% + 1
     ELSE
          EXIT FOR
     END IF
NEXT i

END SUB

'these are the main play loops.
'
SUB play.game

DO
     menu
     RESTORE            'restore data blocks for new game
     init.play          'initialize screen for play
     ballsleft% = 3     'reset number of extra balls and score
     score& = 0
     status.bar         'draw status bar, paddle, and get ready!
     draw.paddle
     get.ready
     DO     'this is the actual, in-your face animation and play loop. This is the game!
          draw.ball
          draw.paddle
          clear.buffer
          delay .01, speed%
          SELECT CASE hit.key     'anylize scancode
               CASE key.left%
                    paddle.left
               CASE key.right%
                    paddle.right
               CASE quit%
                    clear.buffer
                    font "Quit? Y/N", 123, 150, 1, 1, 1, 15
                    status.bar
                    wait.for.event
                    DO
                         clear.buffer
                         IF hit.key = yes% THEN EXIT DO
                         IF hit.key = no% THEN
                              LINE (120, 145)-(205, 160), background%, BF
                              status.bar
                              EXIT DO
                         END IF
                    LOOP
                    IF hit.key = yes% THEN EXIT DO
               CASE pause%
                    font "*PAUSED*", 127, 150, 1, 1, 1, 15
                    status.bar
                    DO
                         IF LEN(INKEY$) THEN DO: clear.buffer: LOOP UNTIL hit.key > 100
                         wait.for.event
                         IF hit.key = pause% THEN
                              DO: clear.buffer: LOOP UNTIL hit.key > 100
                              LINE (120, 145)-(205, 160), background%, BF
                              status.bar
                              EXIT DO
                         END IF
                    LOOP
          END SELECT
          IF bally! >= loseballcoord% THEN     'if ball falls off screen, then punish player
               draw.paddle
               erase.ball
               ballsleft% = ballsleft% - 1
               score.down
               PLAY loseball$
               IF ballsleft% = 0 THEN     'if player loses all his balls, then game over.
                    game.over
                    EXIT DO
               END IF
               status.bar
               erase.paddle
               reset.vals
               draw.paddle
               get.ready
          END IF
          IF blocksleft% = 0 THEN     'if player completes level, move on to next level
               CLS
               init.play
               status.bar
               draw.paddle
               get.ready
          END IF
          get.collision     'call bounce-getting routine which changes the variables xinc! and yinc!
          erase.ball
          move.ball
     LOOP
LOOP

END SUB

'displays high score and player's current score.
'
SUB print.score

COLOR wallcolor%
LOCATE 1, 1
PRINT STRING$(2, 219)
LOCATE 1, 3
COLOR 40
PRINT "Score: "; LTRIM$(RTRIM$(STR$(score&)))
LOCATE 1, 3 + (LEN(LTRIM$(RTRIM$(STR$(score&)))) + LEN("Score: "))
COLOR wallcolor%
PRINT STRING$(5, 219)
LOCATE 1, 20
COLOR 55
PRINT "Balls Left:"

END SUB

'reads block color data into blocks% array. Only other GOTO statement in
'the whole program. This is absolutely necessary, to reread from the beginning
'when program finds a -1
'
SUB read.data

reread:
FOR i = 1 TO total.blocks%
     READ blocks%(i)
     IF blocks%(i) = -1 THEN RESTORE: GOTO reread
     IF blocks%(i) = 0 THEN blocks%(i) = background%
NEXT i

END SUB

'resets screen for DOS
'
SUB reset.screen

SCREEN 0: CLS
WIDTH 80, 25
COLOR 7, 0

END SUB

'reset program values for play
'
SUB reset.vals

ballx! = 130
bally! = 155
xinc! = 1
yinc! = 1
rad% = 4

padx% = 160
pady% = 188
padinc% = 2
padw% = 15
padh% = 2

END SUB

'decrements score
'
SUB score.down

IF score& - 100 > 0 THEN score& = score& - 100 ELSE score& = 0
print.score

END SUB

'increments score and calls score-checking procedure.
'
SUB score.up

IF score& + 5 > top.score& THEN score& = top.score& ELSE score& = score& + 5
print.score
check.balls

END SUB

'prints score and draws extra balls at top-right corner.
'
SUB status.bar

print.score
place% = 250
LINE (250, 0)-(320, 9), wallcolor%, BF
FOR i = 1 TO ballsleft% - 1
     PUT (place%, 0), ball, PSET
     place% = place% + 9
NEXT i

END SUB

'waits for player to press a key.
'
SUB wait.for.event

clear.buffer
WHILE INKEY$ = "": WEND

END SUB

