'       Bubba's Fantasy
'
'       (C) 1998 BUBBASOFT
'
'       Program Started: May 25th, 1998

' $DYNAMIC

DECLARE SUB PlayMID (FileName$)
DECLARE SUB PlayMIDI (MIDISegment%, MIDIOffset%)
DECLARE SUB LoadMIDI (FileName$, MIDISegment%, MIDIOffset%)
DECLARE FUNCTION BytesRequired& (FileName$)
DECLARE SUB DriversLoaded (SBMIDI%, SBSIM%)
DECLARE FUNCTION MIDIError$ ()
DECLARE SUB PauseMIDI ()
DECLARE SUB ResumeMIDI ()
DECLARE SUB StopMIDI ()
DECLARE FUNCTION TimeMIDI! ()

DECLARE SUB SaveTemp ()
DECLARE SUB AnimateSprites ()
DECLARE SUB SaveGame ()
DECLARE SUB GoToSleep ()
DECLARE SUB Sleepy ()
DECLARE SUB DoItChoice ()
DECLARE SUB LoadFont ()
DECLARE SUB PutText (PosX%, PosY%, Sentence$)
DECLARE SUB ShowOptions ()
DECLARE SUB Delay (Seconds!)
DECLARE SUB Options ()
DECLARE SUB BattleBar ()
DECLARE SUB BubbaReturn ()
DECLARE SUB BubbaAttack ()
DECLARE SUB SetUpSpecial ()
DECLARE SUB ClearEnemyBox ()
DECLARE SUB SetUpItems ()
DECLARE SUB FightChoice ()
DECLARE SUB FightBar ()
DECLARE SUB EnemyFight ()
DECLARE SUB MoveClint ()
DECLARE SUB TopBar ()
DECLARE SUB RestoreBack ()
DECLARE SUB ClearDialog ()
DECLARE SUB AnimateClint ()
DECLARE SUB DialogBoxTop ()
DECLARE SUB IntroStory ()
DECLARE SUB TitleOptions ()
DECLARE SUB LoadMap ()
DECLARE SUB LoadPics ()
DECLARE SUB LoadTiles ()
DECLARE SUB AnimateBubba ()
DECLARE SUB MoveBubba ()
DECLARE SUB LoadData ()
DECLARE SUB ShowLevel ()

'Used by DriversLoaded
DECLARE SUB InternalGetIntVector (IntNum%, Segment%, Offset%)

DIM SHARED MIDI.PLAYTIME AS SINGLE, MIDI.ERROR AS INTEGER
DIM SHARED MIDI.LOADED AS INTEGER, SBMIDI.INTERRUPT AS INTEGER
DIM SHARED SBSIM.INTERRUPT AS INTEGER, PAUSED AS SINGLE
DIM SHARED SENSITIVE AS INTEGER, SOUND.DISABLED AS INTEGER

DriversLoaded SBMIDI.INTERRUPT, SBSIM.INTERRUPT
IF SBMIDI.INTERRUPT = 0 THEN SBMIDI.INTERRUPT = &H80
IF SBSIM.INTERRUPT = 0 THEN SBSIM.INTERRUPT = &H81

DIM SHARED ChrSet(33 TO 122, 1 TO 8, 1 TO 8) AS INTEGER
DIM SHARED TitleCursor$

DIM SHARED Grass(201) AS INTEGER
DIM SHARED Ground(201) AS INTEGER
DIM SHARED Tree(201) AS INTEGER
DIM SHARED Rock(201) AS INTEGER
DIM SHARED Water(201) AS INTEGER
DIM SHARED Water1(201) AS INTEGER
DIM SHARED Water2(201) AS INTEGER
DIM SHARED Water3(201) AS INTEGER
DIM SHARED Water4(201) AS INTEGER
DIM SHARED WaterEdge(201) AS INTEGER

DIM SHARED WoodFloor(201) AS INTEGER
DIM SHARED InsideWall(201) AS INTEGER
DIM SHARED OutsideWall(201) AS INTEGER
DIM SHARED Roof(201) AS INTEGER

DIM SHARED ShopTL(201) AS INTEGER
DIM SHARED ShopTR(201) AS INTEGER
DIM SHARED ShopBL(201) AS INTEGER
DIM SHARED ShopBR(201) AS INTEGER
DIM SHARED Shop(201) AS INTEGER
DIM SHARED ShopW(201) AS INTEGER
DIM SHARED ShopI(201) AS INTEGER

DIM SHARED Bed(201) AS INTEGER
DIM SHARED Table(201) AS INTEGER

DIM SHARED CastleDoor(201) AS INTEGER

DIM SHARED Title(16000)
DIM SHARED BubbaSoft(1258)
DIM SHARED ClintPic(3500)
DIM SHARED BubbaPic(3500)
DIM SHARED FightGrass(10000)
DIM SHARED Pointer(50)
DIM SHARED EnemyBack(804)

DIM SHARED BubbaR1(201)
DIM SHARED BubbaR2(201)
DIM SHARED BubbaL1(201)
DIM SHARED BubbaL2(201)
DIM SHARED BubbaU1(201)
DIM SHARED BubbaU2(201)
DIM SHARED BubbaD1(201)
DIM SHARED BubbaD2(201)
DIM SHARED BubbaA(201)
DIM SHARED ClintR1(201)
DIM SHARED ClintR2(201)
DIM SHARED ClintL1(201)
DIM SHARED ClintL2(201)
DIM SHARED ClintU1(201)
DIM SHARED ClintU2(201)
DIM SHARED ClintD1(201)
DIM SHARED ClintD2(201)

DIM SHARED Geek(804)
DIM SHARED Nerd(804)

DIM SHARED BubbaR1M(201)
DIM SHARED BubbaR2M(201)
DIM SHARED BubbaL1M(201)
DIM SHARED BubbaL2M(201)
DIM SHARED BubbaU1M(201)
DIM SHARED BubbaU2M(201)
DIM SHARED BubbaD1M(201)
DIM SHARED BubbaD2M(201)
DIM SHARED BubbaAM(201)
DIM SHARED ClintR1M(201)
DIM SHARED ClintR2M(201)
DIM SHARED ClintL1M(201)
DIM SHARED ClintL2M(201)
DIM SHARED ClintU1M(201)
DIM SHARED ClintU2M(201)
DIM SHARED ClintD1M(201)
DIM SHARED ClintD2M(201)

DIM SHARED GeekM(804)
DIM SHARED NerdM(804)

DIM SHARED BubbaBack(201)
DIM SHARED BubbaBack2(201)
DIM SHARED ClintBack(201)

DIM SHARED Sprite1U1(201)
DIM SHARED Sprite1U2(201)

DIM SHARED Sprite1U1M(201)
DIM SHARED Sprite1U2M(201)

DIM SHARED Sprite1Back(201)

DIM SHARED MapScreen(0 TO 15, 1 TO 9)
DIM SHARED Map(1 TO 5, 0 TO 15, 1 TO 9) AS INTEGER
DIM SHARED LevelUP(1 TO 10)
DIM SHARED BubLevelUp(1 TO 10)
DIM SHARED BubbaItems$(8)
DIM SHARED BattleItem(8)
DIM SHARED Special$(8)
DIM SHARED SpecialAttack(8)

DIM SHARED BubbaX AS INTEGER, BubbaY AS INTEGER
DIM SHARED BubbaMove AS INTEGER, BubbaMap AS INTEGER
DIM SHARED HP AS INTEGER, MaxHP AS INTEGER
DIM SHARED BP AS INTEGER, MaxBP AS INTEGER
DIM SHARED Attack AS INTEGER, Defense AS INTEGER
DIM SHARED Agility AS INTEGER, Bubbattack AS INTEGER
DIM SHARED Level AS INTEGER, EP AS INTEGER, NextLVL AS INTEGER
DIM SHARED BubLVL AS INTEGER, BubEP AS INTEGER, NextBubLVL AS INTEGER
DIM SHARED Gold AS INTEGER
DIM SHARED MapType AS INTEGER
DIM SHARED EnemyOnMap AS INTEGER
DIM SHARED DoIt AS INTEGER

DIM SHARED ClintX AS INTEGER, ClintY AS INTEGER
DIM SHARED ClintMove AS INTEGER

DIM SHARED Sprite1X AS INTEGER, Sprite1Y AS INTEGER
DIM SHARED Sprite1Move AS INTEGER
DIM SHARED Sprite1OnMap AS INTEGER

CONST MinX = 0, MaxX = 15, MinY = 1, MaxY = 9
CONST True = -1, False = 0

SCREEN 7, , 0, 1

CALL LoadPics
PlayMID "prelude.mid"

PUT (86, 91), BubbaSoft, PSET
PCOPY 0, 1
CALL LoadTiles
CALL LoadFont
CALL LoadData

CLS
PRINT "Free Array Space:"; FRE(-1)
PCOPY 0, 1
WHILE INKEY$ = "": WEND

PUT (0, 0), Title, PSET
CALL TitleOptions

IF TitleCursor$ = "BEGIN" THEN
        BubbaMove = 4
        BubbaX = 7: BubbaY = 4
        BubbaMap = 1
        MapType = 1
        Level = 1: BubLVL = 1
        HP = 65: MaxHP = 65
        BP = 15: MaxBP = 15
        Attack = 15: Defense = 10
        Agility = 5: Bubbattack = 10
        NextLVL = LevelUP(Level)
        NextBubLVL = BubLevelUp(BubLVL)
        EnemyOnMap = False

        ClintMove = 1
        ClintX = 7: ClintY = 9

        StopMIDI
        PlayMID "ff3town2.mid"
        CALL LoadMap
        CALL ShowLevel
        CALL TopBar
        GET (BubbaX * 20, BubbaY * 20)-((BubbaX * 20) + 19, (BubbaY * 20) + 19), BubbaBack
        GET (ClintX * 20, ClintY * 20)-((ClintX * 20) + 19, (ClintY * 20) + 19), ClintBack
        CALL IntroStory

        Special$(1) = "LOVE TAP"
        SpecialAttack(1) = True
        BubbaItems$(1) = "COOKIE"
        BubbaItems$(2) = "COOKIE"
        BubbaItems$(3) = "COOKIE"
        BattleItem(1) = True
        BattleItem(2) = True
        BattleItem(3) = True

        ClintX = -1

    ELSEIF TitleCursor$ = "RESUME" THEN

        OPEN "bf.sav" FOR INPUT AS #1
        INPUT #1, BubbaMap, HP, BP, MaxHP, MaxBP
        INPUT #1, Attack, Defense, Agility, Bubbattack
        INPUT #1, Level, EP, NextLVL, BubLVL, BubEP, NextBubLVL
        INPUT #1, Gold, MapType
        FOR I = 1 TO 8
            INPUT #1, SpecialAttack(I), Special$(I), BubbaItems$(I), BattleItem(I)
        NEXT I
        CLOSE #1
        IF BubbaMap = 1 THEN
            EnemyOnMap = False
            BubbaX = 7: BubbaY = 4
            BubbaMove = 4
            MapType = 1
        END IF
        StopMIDI
        PlayMID "ff3town2.mid"
        CALL LoadMap
        CALL ShowLevel
        CALL TopBar
        GET (BubbaX * 20, BubbaY * 20)-((BubbaX * 20) + 19, (BubbaY * 20) + 19), BubbaBack
END IF

RANDOMIZE TIMER

DO
    SELECT CASE INKEY$
    CASE CHR$(0) + CHR$(72)
        BubbaMove = 1
        IF BubbaY > MinY THEN
                IF MapScreen(BubbaX, BubbaY - 1) < 10 THEN
                    CALL MoveBubba
                    EnemyEncounter = INT(RND * 10)
                    IF EnemyEncounter = 5 AND EnemyOnMap THEN
                        CALL EnemyFight
                        CALL RestoreBack
                    END IF
                END IF
            ELSEIF BubbaY = MinY THEN
                IF BubbaMap = 2 THEN
                        EnemyOnMap = False
                        MapType = 1
                        BubbaMap = 1
                        BubbaY = 9
                        CALL LoadMap
                        CALL ShowLevel
                        GET (BubbaX * 20, BubbaY * 20)-((BubbaX * 20) + 19, (BubbaY * 20) + 19), BubbaBack
                    ELSEIF BubbaMap = 3 THEN
                        EnemyOnMap = True
                        MapType = 1
                        BubbaMap = 2
                        BubbaY = 9
                        CALL LoadMap
                        CALL ShowLevel
                        GET (BubbaX * 20, BubbaY * 20)-((BubbaX * 20) + 19, (BubbaY * 20) + 19), BubbaBack
                    ELSEIF BubbaMap = 4 THEN
                        EnemyOnMap = False
                        MapType = 1
                        BubbaMap = 5
                        BubbaY = 9
                        CALL LoadMap
                        CALL ShowLevel
                        GET (BubbaX * 20, BubbaY * 20)-((BubbaX * 20) + 19, (BubbaY * 20) + 19), BubbaBack
                END IF
        END IF
    CASE CHR$(0) + CHR$(75)
        BubbaMove = 2
        IF BubbaX > MinX THEN
                IF MapScreen(BubbaX - 1, BubbaY) < 10 THEN
                    CALL MoveBubba
                    EnemyEncounter = INT(RND * 10)
                    IF EnemyEncounter = 5 AND EnemyOnMap THEN
                        CALL EnemyFight
                        CALL RestoreBack
                    END IF
                END IF
                IF BubbaMap = 1 AND BubbaX = 7 AND BubbaY = 4 THEN
                    CALL Sleepy
                    CALL SaveGame
                END IF
            ELSEIF BubbaX = MinX THEN
                IF BubbaMap = 3 THEN
                        EnemyOnMap = False
                        MapType = 1
                        BubbaMap = 1
                        BubbaX = 15
                        CALL LoadMap
                        CALL ShowLevel
                        GET (BubbaX * 20, BubbaY * 20)-((BubbaX * 20) + 19, (BubbaY * 20) + 19), BubbaBack
                END IF
        END IF
    CASE CHR$(0) + CHR$(77)
        BubbaMove = 3
        IF BubbaX < MaxX THEN
                IF MapScreen(BubbaX + 1, BubbaY) < 10 THEN
                    CALL MoveBubba
                    EnemyEncounter = INT(RND * 10)
                    IF EnemyEncounter = 5 AND EnemyOnMap THEN
                        CALL EnemyFight
                        CALL RestoreBack
                    END IF
                END IF
            ELSEIF BubbaX = MaxX THEN
                IF BubbaMap = 1 THEN
                        EnemyOnMap = False
                        MapType = 1
                        BubbaMap = 4
                        BubbaX = 0
                        CALL LoadMap
                        CALL ShowLevel
                        GET (BubbaX * 20, BubbaY * 20)-((BubbaX * 20) + 19, (BubbaY * 20) + 19), BubbaBack
                END IF
        END IF
    CASE CHR$(0) + CHR$(80)
        BubbaMove = 4
        IF BubbaY < MaxY THEN
                IF MapScreen(BubbaX, BubbaY + 1) < 10 THEN
                    CALL MoveBubba
                    EnemyEncounter = INT(RND * 10)
                    IF EnemyEncounter = 5 AND EnemyOnMap THEN
                        CALL EnemyFight
                        CALL RestoreBack
                    END IF
                END IF
            ELSEIF BubbaY = MaxY THEN
                IF BubbaMap = 1 THEN
                        EnemyOnMap = True
                        MapType = 1
                        BubbaMap = 2
                        BubbaY = 1
                        CALL LoadMap
                        CALL ShowLevel
                        GET (BubbaX * 20, BubbaY * 20)-((BubbaX * 20) + 19, (BubbaY * 20) + 19), BubbaBack
                    ELSEIF BubbaMap = 2 THEN
                        EnemyOnMap = True
                        MapType = 1
                        BubbaMap = 3
                        BubbaY = 1
                        CALL LoadMap
                        CALL ShowLevel
                        GET (BubbaX * 20, BubbaY * 20)-((BubbaX * 20) + 19, (BubbaY * 20) + 19), BubbaBack
                    ELSEIF BubbaMap = 5 THEN
                        EnemyOnMap = False
                        MapType = 1
                        BubbaMap = 4
                        BubbaY = 1
                        CALL LoadMap
                        CALL ShowLevel
                        GET (BubbaX * 20, BubbaY * 20)-((BubbaX * 20) + 19, (BubbaY * 20) + 19), BubbaBack
                END IF
        END IF
    CASE CHR$(13)
        CALL Options
    CASE CHR$(27)
        Quit = True
    CASE "s", "S"
        CALL SaveTemp
    END SELECT

    IF NOT Quit THEN
        CALL AnimateBubba
        CALL AnimateSprites
        PCOPY 0, 1
        CALL Delay(.2)
    END IF

LOOP UNTIL Quit = True

StopMIDI
SYSTEM

' For Level and BubLevel Up
DATA 100, 250, 500, 800, 1250, 1700, 2500, 4000, 6500, 10000
DATA 10, 25, 50, 80, 125, 170, 250, 400, 650, 1000

REM $STATIC
SUB AnimateBubba STATIC

    PUT (BubbaX * 20, BubbaY * 20), BubbaBack, PSET
    GET (BubbaX * 20, BubbaY * 20)-((BubbaX * 20) + 19, (BubbaY * 20) + 19), BubbaBack
    IF BubbaPos = 0 THEN
            IF BubbaMove = 1 THEN
                    PUT (BubbaX * 20, BubbaY * 20), BubbaU1M, AND
                    PUT (BubbaX * 20, BubbaY * 20), BubbaU1, XOR
                ELSEIF BubbaMove = 2 THEN
                    PUT (BubbaX * 20, BubbaY * 20), BubbaL1M, AND
                    PUT (BubbaX * 20, BubbaY * 20), BubbaL1, XOR
                ELSEIF BubbaMove = 3 THEN
                    PUT (BubbaX * 20, BubbaY * 20), BubbaR1M, AND
                    PUT (BubbaX * 20, BubbaY * 20), BubbaR1, XOR
                ELSEIF BubbaMove = 4 THEN
                    PUT (BubbaX * 20, BubbaY * 20), BubbaD1M, AND
                    PUT (BubbaX * 20, BubbaY * 20), BubbaD1, XOR
            END IF
            BubbaPos = 1
        ELSEIF BubbaPos = 1 THEN
            IF BubbaMove = 1 THEN
                    PUT (BubbaX * 20, BubbaY * 20), BubbaU2M, AND
                    PUT (BubbaX * 20, BubbaY * 20), BubbaU2, XOR
                ELSEIF BubbaMove = 2 THEN
                    PUT (BubbaX * 20, BubbaY * 20), BubbaL2M, AND
                    PUT (BubbaX * 20, BubbaY * 20), BubbaL2, XOR
                ELSEIF BubbaMove = 3 THEN
                    PUT (BubbaX * 20, BubbaY * 20), BubbaR2M, AND
                    PUT (BubbaX * 20, BubbaY * 20), BubbaR2, XOR
                ELSEIF BubbaMove = 4 THEN
                    PUT (BubbaX * 20, BubbaY * 20), BubbaD2M, AND
                    PUT (BubbaX * 20, BubbaY * 20), BubbaD2, XOR
            END IF
            BubbaPos = 0
    END IF

END SUB

SUB AnimateClint STATIC
   
    PUT (ClintX * 20, ClintY * 20), ClintBack, PSET
    GET (ClintX * 20, ClintY * 20)-((ClintX * 20) + 19, (ClintY * 20) + 19), ClintBack
    IF ClintPos = 0 THEN
            IF ClintMove = 1 THEN
                    PUT (ClintX * 20, ClintY * 20), ClintU1M, AND
                    PUT (ClintX * 20, ClintY * 20), ClintU1, XOR
                ELSEIF ClintMove = 2 THEN
                    PUT (ClintX * 20, ClintY * 20), ClintL1M, AND
                    PUT (ClintX * 20, ClintY * 20), ClintL1, XOR
                ELSEIF ClintMove = 3 THEN
                    PUT (ClintX * 20, ClintY * 20), ClintR1M, AND
                    PUT (ClintX * 20, ClintY * 20), ClintR1, XOR
                ELSEIF ClintMove = 4 THEN
                    PUT (ClintX * 20, ClintY * 20), ClintD1M, AND
                    PUT (ClintX * 20, ClintY * 20), ClintD1, XOR
            END IF
            ClintPos = 1
        ELSEIF ClintPos = 1 THEN
            IF ClintMove = 1 THEN
                    PUT (ClintX * 20, ClintY * 20), ClintU2M, AND
                    PUT (ClintX * 20, ClintY * 20), ClintU2, XOR
                ELSEIF ClintMove = 2 THEN
                    PUT (ClintX * 20, ClintY * 20), ClintL2M, AND
                    PUT (ClintX * 20, ClintY * 20), ClintL2, XOR
                ELSEIF ClintMove = 3 THEN
                    PUT (ClintX * 20, ClintY * 20), ClintR2M, AND
                    PUT (ClintX * 20, ClintY * 20), ClintR2, XOR
                ELSEIF ClintMove = 4 THEN
                    PUT (ClintX * 20, ClintY * 20), ClintD2M, AND
                    PUT (ClintX * 20, ClintY * 20), ClintD2, XOR
            END IF
            ClintPos = 0
    END IF
   
END SUB

SUB AnimateSprites STATIC

    IF Sprite1OnMap THEN
            IF Sprite1Move = 1 THEN
                    IF SP1 = 0 THEN
                            PUT (Sprite1X * 20, Sprite1Y * 20), Sprite1Back, PSET
                            PUT (Sprite1X * 20, Sprite1Y * 20), Sprite1U1M, AND
                            PUT (Sprite1X * 20, Sprite1Y * 20), Sprite1U1, XOR
                            SP1 = 1
                        ELSEIF SP1 = 1 THEN
                            PUT (Sprite1X * 20, Sprite1Y * 20), Sprite1Back, PSET
                            PUT (Sprite1X * 20, Sprite1Y * 20), Sprite1U2M, AND
                            PUT (Sprite1X * 20, Sprite1Y * 20), Sprite1U2, XOR
                            SP1 = 0
                    END IF
            END IF
    END IF

END SUB

SUB BattleBar

    LINE (0, 0)-(319, 19), 0, BF
    LINE (0, 0)-(319, 19), 1, B
    LINE (1, 1)-(318, 18), 9, B
    LINE (2, 2)-(317, 17), 1, B

END SUB

SUB BubbaAttack

    PUT (261, 85), BubbaBack2, PSET
    FOR X = 261 TO 175 STEP -3
        GET (X, 85)-(X + 19, 104), BubbaBack2
        PUT (X, 85), BubbaL1M, AND
        PUT (X, 85), BubbaL1, XOR
        PCOPY 0, 1
        PUT (X, 85), BubbaBack2, PSET
    NEXT X
    FOR X = 175 TO 125 STEP -4
        GET (X, 85)-(X + 19, 104), BubbaBack2
        PUT (X, 85), BubbaAM, AND
        PUT (X, 85), BubbaA, XOR
        PCOPY 0, 1
        PUT (X, 85), BubbaBack2, PSET
    NEXT X
    PUT (125, 85), BubbaAM, AND
    PUT (125, 85), BubbaA, XOR

END SUB

SUB BubbaReturn

    PUT (125, 85), BubbaBack2, PSET
    FOR X = 126 TO 260 STEP 5
        GET (X, 85)-(X + 19, 104), BubbaBack2
        PUT (X, 85), BubbaL1M, AND
        PUT (X, 85), BubbaL1, XOR
        PCOPY 0, 1
        PUT (X, 85), BubbaBack2, PSET
    NEXT X
    GET (260, 85)-(279, 104), BubbaBack2
    PUT (260, 85), BubbaL1M, AND
    PUT (260, 85), BubbaL1, XOR

END SUB

FUNCTION BytesRequired& (FileName$)
'Open the file.
FF% = FREEFILE
OPEN FileName$ FOR BINARY AS #FF%
'Store the length of the file.
FileLen& = LOF(FF%)
'Close the file.
CLOSE FF%
'If the length of the file is 0, assume it does not exist and delete it.
IF FileLen& = 0 THEN
    KILL FileName$
    MIDI.ERROR = 1
    EXIT FUNCTION
END IF
'Return the length of the file as the number of bytes required.
BytesRequired& = FileLen&
MIDI.ERROR = 0

END FUNCTION

SUB ClearDialog

    FOR I = 2 TO 8
        LOCATE I, 10: PRINT "                              "
    NEXT I

END SUB

SUB ClearEnemyBox

    LINE (0, 140)-(203, 199), 0, BF
    LINE (0, 140)-(319, 199), 1, B
    LINE (1, 141)-(318, 198), 9, B
    LINE (2, 142)-(317, 197), 1, B

END SUB

SUB Delay (Seconds!)

    BeginTime! = TIMER
    WHILE BeginTime! + Seconds! > TIMER: WEND

END SUB

SUB DialogBoxTop

    LINE (0, 0)-(319, 75), 0, BF
    LINE (0, 0)-(319, 75), 1, B
    LINE (1, 1)-(318, 74), 9, B
    LINE (2, 2)-(317, 73), 1, B
    LINE (63, 2)-(63, 73), 1
    LINE (64, 2)-(64, 73), 9
    LINE (65, 2)-(65, 73), 1

END SUB

SUB DoItChoice

    PUT (80, 40), Pointer, PSET
    PCOPY 0, 1
    DoIt = -1
    DO
        SELECT CASE INKEY$
        CASE CHR$(0) + CHR$(77)
        IF DoIt = -1 THEN
            LINE (80, 40)-(90, 50), 0, BF
            PUT (152, 40), Pointer, PSET
            DoIt = 0
            PCOPY 0, 1
        END IF
        CASE CHR$(0) + CHR$(75)
        IF DoIt = 0 THEN
            LINE (152, 40)-(162, 50), 0, BF
            PUT (80, 40), Pointer, PSET
            DoIt = -1
            PCOPY 0, 1
        END IF
        CASE CHR$(13)
        ChoiceMade = True
        END SELECT
    LOOP UNTIL ChoiceMade

END SUB

SUB DriversLoaded (SBMIDI%, SBSIM%) STATIC
'Open the data file.
FF% = FREEFILE
OPEN "DRIVERS.DAT" FOR BINARY AS #FF%
'If the file is empty, return an error
FileSize& = LOF(FF%)
IF FileSize& = 0 THEN
    CLOSE FF%
    KILL "DRIVERS.DAT"
    MIDI.ERROR = 1
    EXIT SUB
'If the file is not exactly 1 kilobyte in size, return an error
ELSEIF FileSize& <> 1024 THEN
    CLOSE FF%
    MIDI.ERROR = 9
    EXIT SUB
END IF
'Load the driver data.
REDIM DRIVERDATA$(1 TO 5)
FOR I% = 1 TO 4
    DRIVERDATA$(I%) = INPUT$(256, #FF%)
NEXT I%
CLOSE #FF%

'Check the interrupt handlers for int 80h-E1h to see if they contain
'program code from either SBSIM or SBMIDI.
SBMIDI% = 0
SBSIM% = 0
FOR I% = &H80 TO &HE1
    'Get the address of the interrupt handler.
    InternalGetIntVector I%, Segment%, Offset%
    'If the address is null, then the interrupt is not in use, and can be
    'skipped.
    IF Segment% = 0 AND Offset% = 0 THEN GOTO Skip:
    'The following code checks for the drivers by looking for the text
    '"SBMIDI" and "SBSIM" at certain locations in the driver code.  It
    'sounds simplistic, but it's very accurate.  If it doesn't work,
    'a different method is used.
    IF SBMIDI% = 0 THEN
        NewSegment% = CVI(MKI$(CVL(MKI$(Segment%) + CHR$(0) + CHR$(0)) - &H11&))
        DEF SEG = NewSegment%
        TEMP$ = ""
        FOR J% = 1 TO 6
            TEMP$ = TEMP$ + CHR$(PEEK(271 + J%))
        NEXT
        IF TEMP$ = "SBMIDI" THEN SBMIDI% = I%
    END IF
    IF SBSIM% = 0 THEN
        NewSegment% = CVI(MKI$(CVL(MKI$(Segment%) + CHR$(0) + CHR$(0)) - &H1&))
        DEF SEG = NewSegment%
        TEMP$ = ""
        FOR J% = 1 TO 5
            TEMP$ = TEMP$ + CHR$(PEEK(274 + J%))
        NEXT
        IF TEMP$ = "SBSIM" THEN SBSIM% = I%
    END IF

    'This is the second detection method.  It's more complex than the first
    'method, but not really any more accurate.  In fact, it's probably
    'less accurate.  It's kind of a last ditch effort in case the first
    'method fails.

    'Point to the segment of the interrupt handler.
    DEF SEG = Segment%
    'Read 256 bytes of the driver code.
    DRIVERDATA$(5) = ""
    FOR J% = 0 TO 255
        Byte% = PEEK(Offset% + J%)
        DRIVERDATA$(5) = DRIVERDATA$(5) + CHR$(Byte%)
    NEXT J%
    'Check to see if the code matches any of the previously saved data.
    FOR J% = 1 TO 4
        MATCH% = 1
        FOR K% = 0 TO 255
            IF MID$(DRIVERDATA$(J%), K% + 1, 1) <> MID$(DRIVERDATA$(5), K% + 1, 1) THEN
                SELECT CASE K%
                    CASE IS = 14, 15, 113, 114, 235, 236
                    CASE ELSE
                        MATCH% = 0
                        EXIT FOR
                END SELECT
            END IF
        NEXT K%
        IF MATCH% THEN
            IF J% = 1 THEN SBSIM% = I%
            IF J% <> 1 THEN SBMIDI% = I%
        END IF
        IF SBSIM% <> 0 AND SBMIDI% <> 0 THEN EXIT FOR
    NEXT J%
    IF SBSIM% <> 0 AND SBMIDI% <> 0 THEN EXIT FOR
Skip:
NEXT I%
MIDI.ERROR = 0
END SUB

SUB EnemyFight

    StopMIDI
    PlayMID "battle2.mid"
    IF MapType = 1 THEN
        PUT (0, 0), FightGrass, PSET
    END IF
    CALL FightBar

    RANDOMIZE TIMER
    EnemyType = INT(RND * 2)
    IF EnemyType = 0 THEN
            Enemy$ = "Geek"
            EHP = 65: MaxEHP = 65
            EPP = 0: MaxEPP = 0
            EAttack = 5: EDefense = 5
            EAgility = 4: EPowAttack = 0
            EGold = 70: EEP = 30: EBEP = 1
            GET (40, 65)-(79, 104), EnemyBack
            PUT (40, 65), GeekM, AND
            PUT (40, 65), Geek, XOR
        ELSEIF EnemyType = 1 THEN
            Enemy$ = "Nerd"
            EHP = 50: MaxEHP = 50
            EPP = 0: MaxEPP = 0
            EAttack = 7: EDefense = 6
            EAgility = 6: EPowAttack = 0
            EGold = 65: EEP = 40: EBEP = 1
            GET (50, 50)-(75, 111), EnemyBack
            PUT (50, 50), NerdM, AND
            PUT (50, 50), Nerd, XOR
    END IF

    PutText 8, 152, Enemy$
    GET (260, 85)-(279, 104), BubbaBack2
    PUT (260, 85), BubbaL1M, AND
    PUT (260, 85), BubbaL1, XOR
    LINE (209, 185)-(311, 195), 1, B
    PCOPY 0, 1

    DO
        BubbaMeter = BubbaMeter + Agility
        EnemyMeter = EnemyMeter + EAgility
        IF BubbaMeter > 99 THEN
                BubbaMeter = 0
                CALL FightChoice
                Cursor$ = "ATTACK"
                PCOPY 0, 1
                WHILE INKEY$ <> "": WEND
                DO
                    SELECT CASE INKEY$
                    CASE CHR$(0) + CHR$(80)
                    IF Cursor$ = "ATTACK" THEN
                            Cursor$ = "SPECIAL"
                            LINE (5, 151)-(15, 158), 0, BF
                            PUT (5, 159), Pointer, PSET
                            PutText 24, 152, "ATTACK"
                            COLOR 9
                            LOCATE 21, 4: PRINT "SPECIAL"
                            PCOPY 0, 1
                        ELSEIF Cursor$ = "SPECIAL" THEN
                            Cursor$ = "ITEM"
                            LINE (5, 159)-(15, 166), 0, BF
                            PUT (5, 167), Pointer, PSET
                            PutText 24, 160, "SPECIAL"
                            COLOR 9
                            LOCATE 22, 4: PRINT "ITEM"
                            PCOPY 0, 1
                        ELSEIF Cursor$ = "ITEM" THEN
                            Cursor$ = "RUN"
                            LINE (5, 167)-(15, 174), 0, BF
                            PUT (5, 175), Pointer, PSET
                            PutText 24, 168, "ITEM"
                            COLOR 9
                            LOCATE 23, 4: PRINT "RUN"
                            PCOPY 0, 1
                        ELSEIF Cursor$ = "RUN" THEN
                            Cursor$ = "ATTACK"
                            LINE (5, 176)-(15, 183), 0, BF
                            PUT (5, 151), Pointer, PSET
                            PutText 24, 176, "RUN"
                            COLOR 9
                            LOCATE 20, 4: PRINT "ATTACK"
                            PCOPY 0, 1
                    END IF
                    CASE CHR$(0) + CHR$(72)
                    IF Cursor$ = "ATTACK" THEN
                            Cursor$ = "RUN"
                            LINE (5, 151)-(15, 158), 0, BF
                            PUT (5, 175), Pointer, PSET
                            PutText 24, 152, "ATTACK"
                            COLOR 9
                            LOCATE 23, 4: PRINT "RUN"
                            PCOPY 0, 1
                        ELSEIF Cursor$ = "RUN" THEN
                            Cursor$ = "ITEM"
                            LINE (5, 176)-(15, 183), 0, BF
                            PUT (5, 167), Pointer, PSET
                            PutText 24, 176, "RUN"
                            COLOR 9
                            LOCATE 22, 4: PRINT "ITEM"
                            PCOPY 0, 1
                        ELSEIF Cursor$ = "ITEM" THEN
                            Cursor$ = "SPECIAL"
                            LINE (5, 167)-(15, 174), 0, BF
                            PUT (5, 159), Pointer, PSET
                            COLOR 15
                            PutText 24, 168, "ITEM"
                            COLOR 9
                            LOCATE 21, 4: PRINT "SPECIAL"
                            PCOPY 0, 1
                        ELSEIF Cursor$ = "SPECIAL" THEN
                            Cursor$ = "ATTACK"
                            LINE (5, 159)-(15, 166), 0, BF
                            PUT (5, 151), Pointer, PSET
                            PutText 24, 160, "SPECIAL"
                            COLOR 9
                            LOCATE 20, 4: PRINT "ATTACK"
                            PCOPY 0, 1
                    END IF
                    CASE CHR$(13)
                    CALL SaveTemp
                    IF Cursor$ = "ATTACK" THEN
                            Quit = True
                        ELSEIF Cursor$ = "SPECIAL" THEN
                            CALL SetUpSpecial
                            Position = 1
                            PUT (5, 151), Pointer, PSET
                            PCOPY 0, 1
                            WHILE INKEY$ <> "": WEND
                            DO
                                SELECT CASE INKEY$
                                CASE CHR$(0) + CHR$(80)
                                IF Position = 1 THEN
                                        Position = 2
                                        LINE (5, 151)-(15, 158), 0, BF
                                        PUT (5, 159), Pointer, PSET
                                        PCOPY 0, 1
                                    ELSEIF Position = 2 THEN
                                        Position = 3
                                        LINE (5, 159)-(15, 166), 0, BF
                                        PUT (5, 167), Pointer, PSET
                                        PCOPY 0, 1
                                    ELSEIF Position = 3 THEN
                                        Position = 4
                                        LINE (5, 167)-(15, 174), 0, BF
                                        PUT (5, 175), Pointer, PSET
                                        PCOPY 0, 1
                                    ELSEIF Position = 5 THEN
                                        Position = 6
                                        LINE (95, 151)-(105, 158), 0, BF
                                        PUT (95, 159), Pointer, PSET
                                        PCOPY 0, 1
                                    ELSEIF Position = 6 THEN
                                        Position = 7
                                        LINE (95, 159)-(105, 166), 0, BF
                                        PUT (95, 167), Pointer, PSET
                                        PCOPY 0, 1
                                    ELSEIF Position = 7 THEN
                                        Position = 8
                                        LINE (95, 167)-(105, 174), 0, BF
                                        PUT (95, 175), Pointer, PSET
                                        PCOPY 0, 1
                                END IF
                                CASE CHR$(0) + CHR$(72)
                                IF Position = 4 THEN
                                        Position = 3
                                        LINE (5, 175)-(15, 183), 0, BF
                                        PUT (5, 167), Pointer, PSET
                                        PCOPY 0, 1
                                    ELSEIF Position = 3 THEN
                                        Position = 2
                                        LINE (5, 167)-(15, 174), 0, BF
                                        PUT (5, 159), Pointer, PSET
                                        PCOPY 0, 1
                                    ELSEIF Position = 2 THEN
                                        Position = 1
                                        LINE (5, 159)-(15, 166), 0, BF
                                        PUT (5, 151), Pointer, PSET
                                        PCOPY 0, 1
                                    ELSEIF Position = 8 THEN
                                        Position = 7
                                        LINE (95, 175)-(105, 183), 0, BF
                                        PUT (95, 167), Pointer, PSET
                                        PCOPY 0, 1
                                    ELSEIF Position = 7 THEN
                                        Position = 6
                                        LINE (95, 167)-(105, 174), 0, BF
                                        PUT (95, 159), Pointer, PSET
                                        PCOPY 0, 1
                                    ELSEIF Position = 6 THEN
                                        Position = 5
                                        LINE (95, 159)-(105, 166), 0, BF
                                        PUT (95, 151), Pointer, PSET
                                        PCOPY 0, 1
                                END IF
                                CASE CHR$(0) + CHR$(75)
                                IF Position = 5 THEN
                                        Position = 1
                                        LINE (95, 151)-(105, 158), 0, BF
                                        PUT (5, 151), Pointer, PSET
                                        PCOPY 0, 1
                                    ELSEIF Position = 6 THEN
                                        Position = 2
                                        LINE (95, 159)-(105, 166), 0, BF
                                        PUT (5, 159), Pointer, PSET
                                        PCOPY 0, 1
                                    ELSEIF Position = 7 THEN
                                        Position = 3
                                        LINE (95, 167)-(105, 174), 0, BF
                                        PUT (5, 167), Pointer, PSET
                                        PCOPY 0, 1
                                    ELSEIF Position = 8 THEN
                                        Position = 4
                                        LINE (95, 175)-(105, 183), 0, BF
                                        PUT (5, 175), Pointer, PSET
                                        PCOPY 0, 1
                                END IF
                                CASE CHR$(0) + CHR$(77)
                                IF Position = 1 THEN
                                        Position = 5
                                        LINE (5, 151)-(15, 158), 0, BF
                                        PUT (95, 151), Pointer, PSET
                                        PCOPY 0, 1
                                    ELSEIF Position = 2 THEN
                                        Position = 6
                                        LINE (5, 159)-(15, 166), 0, BF
                                        PUT (95, 159), Pointer, PSET
                                        PCOPY 0, 1
                                    ELSEIF Position = 3 THEN
                                        Position = 7
                                        LINE (5, 167)-(15, 174), 0, BF
                                        PUT (95, 167), Pointer, PSET
                                        PCOPY 0, 1
                                    ELSEIF Position = 4 THEN
                                        Position = 8
                                        LINE (5, 175)-(15, 183), 0, BF
                                        PUT (95, 175), Pointer, PSET
                                        PCOPY 0, 1
                                END IF
                                CASE CHR$(13)
                                IF SpecialAttack(Position) = True THEN
                                    Quit = True
                                    Chosen = True
                                END IF
                                END SELECT
                            LOOP UNTIL Chosen
                        ELSEIF Cursor$ = "ITEM" THEN
                            CALL SetUpItems
                            Position = 1
                            PUT (5, 151), Pointer, PSET
                            PCOPY 0, 1
                            WHILE INKEY$ <> "": WEND
                            DO
                                SELECT CASE INKEY$
                                CASE CHR$(0) + CHR$(80)
                                IF Position = 1 THEN
                                        Position = 2
                                        LINE (5, 151)-(15, 158), 0, BF
                                        PUT (5, 159), Pointer, PSET
                                        PCOPY 0, 1
                                    ELSEIF Position = 2 THEN
                                        Position = 3
                                        LINE (5, 159)-(15, 166), 0, BF
                                        PUT (5, 167), Pointer, PSET
                                        PCOPY 0, 1
                                    ELSEIF Position = 3 THEN
                                        Position = 4
                                        LINE (5, 167)-(15, 174), 0, BF
                                        PUT (5, 175), Pointer, PSET
                                        PCOPY 0, 1
                                    ELSEIF Position = 5 THEN
                                        Position = 6
                                        LINE (95, 151)-(105, 158), 0, BF
                                        PUT (95, 159), Pointer, PSET
                                        PCOPY 0, 1
                                    ELSEIF Position = 6 THEN
                                        Position = 7
                                        LINE (95, 159)-(105, 166), 0, BF
                                        PUT (95, 167), Pointer, PSET
                                        PCOPY 0, 1
                                    ELSEIF Position = 7 THEN
                                        Position = 8
                                        LINE (95, 167)-(105, 174), 0, BF
                                        PUT (95, 175), Pointer, PSET
                                        PCOPY 0, 1
                                END IF
                                CASE CHR$(0) + CHR$(72)
                                IF Position = 4 THEN
                                        Position = 3
                                        LINE (5, 175)-(15, 183), 0, BF
                                        PUT (5, 167), Pointer, PSET
                                        PCOPY 0, 1
                                    ELSEIF Position = 3 THEN
                                        Position = 2
                                        LINE (5, 167)-(15, 174), 0, BF
                                        PUT (5, 159), Pointer, PSET
                                        PCOPY 0, 1
                                    ELSEIF Position = 2 THEN
                                        Position = 1
                                        LINE (5, 159)-(15, 166), 0, BF
                                        PUT (5, 151), Pointer, PSET
                                        PCOPY 0, 1
                                    ELSEIF Position = 8 THEN
                                        Position = 7
                                        LINE (95, 175)-(105, 183), 0, BF
                                        PUT (95, 167), Pointer, PSET
                                        PCOPY 0, 1
                                    ELSEIF Position = 7 THEN
                                        Position = 6
                                        LINE (95, 167)-(105, 174), 0, BF
                                        PUT (95, 159), Pointer, PSET
                                        PCOPY 0, 1
                                    ELSEIF Position = 6 THEN
                                        Position = 5
                                        LINE (95, 159)-(105, 166), 0, BF
                                        PUT (95, 151), Pointer, PSET
                                        PCOPY 0, 1
                                END IF
                                CASE CHR$(0) + CHR$(75)
                                IF Position = 5 THEN
                                        Position = 1
                                        LINE (95, 151)-(105, 158), 0, BF
                                        PUT (5, 151), Pointer, PSET
                                        PCOPY 0, 1
                                    ELSEIF Position = 6 THEN
                                        Position = 2
                                        LINE (95, 159)-(105, 166), 0, BF
                                        PUT (5, 159), Pointer, PSET
                                        PCOPY 0, 1
                                    ELSEIF Position = 7 THEN
                                        Position = 3
                                        LINE (95, 167)-(105, 174), 0, BF
                                        PUT (5, 167), Pointer, PSET
                                        PCOPY 0, 1
                                    ELSEIF Position = 8 THEN
                                        Position = 4
                                        LINE (95, 175)-(105, 183), 0, BF
                                        PUT (5, 175), Pointer, PSET
                                        PCOPY 0, 1
                                END IF
                                CASE CHR$(0) + CHR$(77)
                                IF Position = 1 THEN
                                        Position = 5
                                        LINE (5, 151)-(15, 158), 0, BF
                                        PUT (95, 151), Pointer, PSET
                                        PCOPY 0, 1
                                    ELSEIF Position = 2 THEN
                                        Position = 6
                                        LINE (5, 159)-(15, 166), 0, BF
                                        PUT (95, 159), Pointer, PSET
                                        PCOPY 0, 1
                                    ELSEIF Position = 3 THEN
                                        Position = 7
                                        LINE (5, 167)-(15, 174), 0, BF
                                        PUT (95, 167), Pointer, PSET
                                        PCOPY 0, 1
                                    ELSEIF Position = 4 THEN
                                        Position = 8
                                        LINE (5, 175)-(15, 183), 0, BF
                                        PUT (95, 175), Pointer, PSET
                                        PCOPY 0, 1
                                END IF
                                CASE CHR$(13)
                                IF BattleItem(Position) = True THEN
                                    Quit = True
                                    Chosen = True
                                END IF
                                END SELECT
                            LOOP UNTIL Chosen
                        ELSEIF Cursor$ = "RUN" THEN
                            Quit = True
                    END IF
                    END SELECT
                LOOP UNTIL Quit
                CALL ClearEnemyBox
                PutText 8, 152, Enemy$
                IF Cursor$ = "ATTACK" THEN
                        RANDOMIZE TIMER
                        Power = (Attack + (INT(RND * 10) + 1)) * 2
                        Armor = EDefense + (INT(RND * 5) + 1)
                        AttackPower = Power - Armor
                        IF AttackPower < 0 THEN AttackPower = 1
                        EHP = EHP - AttackPower
                        CALL BubbaAttack
                        PutText 40, 96, STR$(AttackPower)
                        PCOPY 0, 1
                        CALL BubbaReturn
                    ELSEIF Cursor$ = "SPECIAL" THEN
                        IF Special$(Position) = "LOVE TAP" THEN
                                IF BP > 4 THEN
                                    BP = BP - 5
                                    COLOR 15
                                    LOCATE 23, 32: PRINT USING "###"; BP
                                    PCOPY 0, 1
                                    RANDOMIZE TIMER
                                    Power = ((Attack + (INT(RND * 10) + 1)) * 2) * 3
                                    Armor = EDefense + (INT(RND * 5) + 1)
                                    AttackPower = Power - Armor
                                    IF AttackPower < 0 THEN AttackPower = 1
                                    EHP = EHP - AttackPower
                                    CALL BubbaAttack
                                    CALL BubbaReturn
                                    CALL BubbaAttack
                                    CALL BubbaReturn
                                    CALL BubbaAttack
                                    PutText 40, 96, STR$(AttackPower)
                                    PCOPY 0, 1
                                    CALL BubbaReturn
                                END IF
                        END IF
                    ELSEIF Cursor$ = "ITEM" THEN
                        IF BubbaItems$(Position) = "COOKIE" THEN
                                BubbaItems$(Position) = ""
                                HP = HP + 50
                                IF HP > MaxHP THEN HP = MaxHP
                                COLOR 15
                                LOCATE 22, 32: PRINT USING "###"; HP
                                PutText 264, 96, "50"
                                COLOR 15
                                PCOPY 0, 1
                        END IF
                    ELSEIF Cursor$ = "RUN" THEN
                        RANDOMIZE TIMER
                        EnemyStop = INT(RND * EAgility) + 1
                        BubbaRun = INT(RND * Agility) + (Agility / 2)
                        IF BubbaRun > EnemyStop THEN
                                RanAway = True
                            ELSE
                                CALL BattleBar
                                PutText 8, 8, "Couldn't run away!"
                                PCOPY 0, 1
                        END IF
                END IF
            ELSEIF EnemyMeter > 99 THEN
                EnemyMeter = 0
                IF MaxEEP > 0 THEN EAChoice = 2 ELSE EAChoice = 1
                RANDOMIZE TIMER
                EAA = INT(RND * EAChoice) + 1
                IF EAA = 1 THEN
                        RANDOMIZE TIMER
                        Power = (EAttack + (INT(RND * 10) + 1)) * 2
                        Armor = Defense + (INT(RND * 5) + 1)
                        AttackPower = Power - Armor
                        IF AttackPower < 0 THEN AttackPower = 1
                        HP = HP - AttackPower
                        PutText 264, 96, STR$(AttackPower)
                        IF HP < 1 THEN HP = 0
                        COLOR 15
                        LOCATE 22, 32: PRINT USING "###"; HP
                        PCOPY 0, 1
                    ELSEIF EAA = 2 THEN
                END IF
        END IF

        CALL Delay(.2)
        IF EHP < 1 THEN Won = True ELSE IF HP < 1 THEN Lost = True
        IF MapType = 1 THEN
            PUT (0, 0), FightGrass, PSET
        END IF
        CALL ClearEnemyBox
        Cursor$ = "": Position = 0
        Chosen = False: Quit = False
        PutText 8, 152, Enemy$
        PUT (260, 85), BubbaBack2, PSET
        GET (260, 85)-(279, 104), BubbaBack2
        PUT (260, 85), BubbaL1M, AND
        PUT (260, 85), BubbaL1, XOR
        IF Enemy$ = "Geek" THEN
                PUT (40, 65), EnemyBack, PSET
                GET (40, 65)-(79, 104), EnemyBack
                PUT (40, 65), GeekM, AND
                PUT (40, 65), Geek, XOR
            ELSEIF Enemy$ = "Nerd" THEN
                PUT (50, 50), EnemyBack, PSET
                GET (50, 50)-(75, 111), EnemyBack
                PUT (50, 50), NerdM, AND
                PUT (50, 50), Nerd, XOR
        END IF
        LINE (210, 186)-(310, 194), 0, BF
        LINE (210, 186)-(210 + BubbaMeter, 194), 14, BF
        PCOPY 0, 1

    LOOP UNTIL Won OR Lost OR RanAway

    IF Won THEN
            StopMIDI
            PlayMID "chotheme.mid"
            IF MapType = 1 THEN
                PUT (0, 0), FightGrass, PSET
            END IF
            PUT (260, 85), BubbaBack2, PSET
            GET (260, 85)-(279, 104), BubbaBack2
            PUT (260, 85), BubbaL1M, AND
            PUT (260, 85), BubbaL1, XOR
            CALL BattleBar
            PutText 8, 8, "Bubba has defeated the " + Enemy$ + "."
            PCOPY 0, 1
            WHILE INKEY$ = "": WEND
            CALL BattleBar
            PutText 8, 8, "Gained" + STR$(EEP) + " experience."
            PCOPY 0, 1
            WHILE INKEY$ = "": WEND
            CALL BattleBar
            PutText 8, 8, "Gained" + STR$(EGold) + " gold."
            PCOPY 0, 1
            WHILE INKEY$ = "": WEND
            CALL BattleBar
            PutText 8, 8, "Gained" + STR$(EBEP) + " Bubba experience."
            PCOPY 0, 1
            WHILE INKEY$ = "": WEND
            EP = EP + EEP
            BubEP = BubEP + EBEP
            Gold = Gold + EGold
            IF EP >= NextLVL AND Level < 10 THEN
                Level = Level + 1
                NextLVL = LevelUP(Level)
                RANDOMIZE TIMER
                StrengthUp = INT(RND * 5) + 1
                DefenseUp = INT(RND * 5) + 1
                AgilityUp = INT(RND * 3) + 1
                BubbattackUp = INT(RND * 5) + 1
                MaxHPUp = INT(RND * 25) + 25
                MaxBPUp = INT(RND * 15) + 10

                Attack = Attack + StrengthUp
                Defense = Defense + DefenseUp
                Agility = Agility + AgilityUp
                Bubbattack = Bubbattack + BubbattackUp
                MaxHP = MaxHP + MaxHPUp
                MaxBP = MaxBP + MaxBPUp
                HP = HP + MaxHPUp
                BP = BP + MaxBPUp
                CALL BattleBar
                PutText 8, 8, "Bubba's level up!"
                PCOPY 0, 1
                WHILE INKEY$ = "": WEND
            END IF
            IF BubEP >= NextBubLVL AND BubLVL < 10 THEN
                BubLVL = BubLVL + 1
                NextBubLVL = BubLevelUp(BubLVL)
                CALL BattleBar
                PutText 8, 8, "Bubba learned a new attack!"
                PCOPY 0, 1
                WHILE INKEY$ = "": WEND
            END IF
        ELSEIF Lost THEN
            StopMIDI
            CALL BattleBar
            PutText 8, 8, "Bubba meets the reaper..."
            PCOPY 0, 1
            WHILE INKEY$ = "": WEND
            Quit = True
        ELSEIF RanAway THEN
            CALL BattleBar
            PutText 8, 8, "Bubba runs away..."
            PCOPY 0, 1
            WHILE INKEY$ = "": WEND
    END IF

    StopMIDI
    PlayMID "ff3town2.mid"
    IF RanAway OR Won THEN
        CALL ShowLevel
        CALL AnimateBubba
        PCOPY 0, 1
    END IF

END SUB

SUB FightBar

    LINE (0, 140)-(319, 199), 0, BF
    LINE (0, 140)-(319, 199), 1, B
    LINE (1, 141)-(318, 198), 9, B
    LINE (2, 142)-(317, 197), 1, B
    LINE (204, 142)-(204, 197), 1
    LINE (205, 142)-(205, 197), 9
    LINE (206, 142)-(206, 197), 1

    COLOR 15
    PutText 216, 152, "Bubba"
    PutText 228, 168, "HP"
    LOCATE 22, 32: PRINT USING "###"; HP
    LOCATE 22, 35: PRINT "/"
    LOCATE 22, 36: PRINT USING "###"; MaxHP
    PutText 228, 176, "BP"
    LOCATE 23, 32: PRINT USING "###"; BP
    LOCATE 23, 35: PRINT "/"
    LOCATE 23, 36: PRINT USING "###"; MaxBP

END SUB

SUB FightChoice

     LINE (210, 186)-(310, 194), 14, BF
     LINE (0, 140)-(100, 199), 0, BF
     LINE (0, 140)-(100, 199), 4, B
     LINE (1, 141)-(99, 198), 12, B
     LINE (2, 142)-(98, 197), 4, B
     COLOR 9
     LOCATE 20, 4: PRINT "ATTACK"
     PutText 24, 160, "SPECIAL"
     PutText 24, 168, "ITEM"
     PutText 24, 176, "RUN"
     PUT (5, 151), Pointer, PSET

END SUB

SUB GoToSleep

    FOR r = 205 TO 1 STEP -15
        CALL ShowLevel
        CIRCLE (159, 99), r, 3
        IF r < 201 THEN
            PAINT (0, 0), 3, 3
            PAINT (319, 0), 3, 3
            PAINT (0, 199), 3, 3
            PAINT (319, 199), 3, 3
        END IF
        PCOPY 0, 1
    NEXT r
    FOR r = 1 TO 225 STEP 15
        CALL ShowLevel
        CIRCLE (159, 99), r, 3
        IF r < 201 THEN
            PAINT (0, 0), 3, 3
            PAINT (319, 0), 3, 3
            PAINT (0, 199), 3, 3
            PAINT (319, 199), 3, 3
        END IF
        PCOPY 0, 1
    NEXT r

END SUB

SUB InternalGetIntVector (IntNum%, Segment%, Offset%)
'If the code hasn't been loaded already, do it now.
IF GetIntVCodeLoaded% = 0 THEN
    asm$ = asm$ + CHR$(&H55)
    asm$ = asm$ + CHR$(&H89) + CHR$(&HE5)
    asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HA)
    asm$ = asm$ + CHR$(&H8A) + CHR$(&H7)
    asm$ = asm$ + CHR$(&HB4) + CHR$(&H35)
    asm$ = asm$ + CHR$(&HCD) + CHR$(&H21)
    asm$ = asm$ + CHR$(&H8C) + CHR$(&HC1)
    asm$ = asm$ + CHR$(&H89) + CHR$(&HDA)
    asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8)
    asm$ = asm$ + CHR$(&H89) + CHR$(&HF)
    asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H6)
    asm$ = asm$ + CHR$(&H89) + CHR$(&H17)
    asm$ = asm$ + CHR$(&H5D)
    asm$ = asm$ + CHR$(&HCB)
    asm$ = asm$ + CHR$(&H34) + CHR$(&H0)
    asm$ = asm$ + CHR$(&H60)
    asm$ = asm$ + CHR$(&H23) + CHR$(&H0)
    GetIntVCodeLoaded% = 1
END IF
'Execute the code
DEF SEG = VARSEG(asm$)
CALL ABSOLUTE(IntNum%, Segment%, Offset%, SADD(asm$))
END SUB

SUB IntroStory

    FOR I = 1 TO 6
        CALL AnimateClint
        CALL AnimateBubba
        FOR X = 1 TO 700: NEXT X
        PCOPY 0, 1
    NEXT I

    FOR I = 1 TO 4
        CALL MoveBubba
        CALL AnimateBubba
        PCOPY 0, 1
    NEXT I

    COLOR 7
    CALL DialogBoxTop
    PUT (3, 3), BubbaPic, PSET
    PutText 72, 8, "Well, hey, hey, hey.  Who"
    PutText 72, 16, "might you be?"
    PCOPY 0, 1
    WHILE INKEY$ = "": WEND
    CALL ClearDialog
    PUT (3, 3), ClintPic, PSET
    PutText 72, 8, "Hi! My name is Clint.  I was"
    PutText 72, 16, "heading to a geek convention"
    PutText 72, 24, "but I seem to be lost now."
    PCOPY 0, 1
    WHILE INKEY$ = "": WEND
    PutText 72, 40, "Could you tell me where Nerdia"
    PutText 72, 48, "Castle is?"
    PCOPY 0, 1
    WHILE INKEY$ = "": WEND
    CALL ClearDialog
    PUT (3, 3), BubbaPic, PSET
    PutText 72, 8, "Nerdia Castle? Yeah, Bubba"
    PutText 72, 16, "know's where it is.  Just head"
    PutText 72, 24, "east from here and you'll"
    PutText 72, 32, "reach it in no time!"
    PCOPY 0, 1
    WHILE INKEY$ = "": WEND
    CALL ClearDialog
    PUT (3, 3), ClintPic, PSET
    PutText 72, 8, "Hey, thank's a lot Mr..."
    PutText 72, 16, "Bubba, wasn't it? If it wasn't"
    PutText 72, 24, "for your help I might have"
    PutText 72, 32, "not made it there by the next"
    PutText 72, 40, "day?"
    PCOPY 0, 1
    WHILE INKEY$ = "": WEND
    CALL ClearDialog
    PUT (3, 3), BubbaPic, PSET
    PutText 72, 8, "No problem."
    PCOPY 0, 1
    WHILE INKEY$ = "": WEND
    PutText 72, 24, "You're tired.  Why don't you"
    PutText 72, 32, "take a rest here in Bubba's"
    PutText 72, 40, "cozy little pad."
    PCOPY 0, 1
    WHILE INKEY$ = "": WEND
    CALL ClearDialog
    PUT (3, 3), ClintPic, PSET
    PutText 72, 8, "Uhh, no thanks.  I really"
    PutText 72, 16, "should be going..."
    PCOPY 0, 1
    WHILE INKEY$ = "": WEND
    CALL ClearDialog
    PUT (3, 3), BubbaPic, PSET
    PutText 72, 8, "Awww, c'mon Clinty-poo,  Bubba"
    PutText 72, 16, "knows lots of fun games that"
    PutText 72, 24, "we could play..."
    PCOPY 0, 1
    WHILE INKEY$ = "": WEND
    PutText 72, 40, "Find Mr. Happy is my favourite"
    PutText 72, 48, "game.  Why don't you play it"
    PutText 72, 56, "with Bubba?"
    PCOPY 0, 1
    WHILE INKEY$ = "": WEND
    CALL ClearDialog
    PUT (3, 3), ClintPic, PSET
    PutText 72, 8, "Find Mr. Happy...?"
    PCOPY 0, 1
    WHILE INKEY$ = "": WEND
    PutText 72, 24, "AAAAAAIIIIIIEEEEEE!"
    PCOPY 0, 1
    WHILE INKEY$ = "": WEND
    CALL RestoreBack

    ClintMove = 3
    FOR I = 1 TO 4
        CALL MoveClint
        CALL AnimateClint
        FOR X = 1 TO 700: NEXT X
        PCOPY 0, 1
    NEXT I
    ClintMove = 1
    FOR I = 1 TO 2
        CALL MoveClint
        CALL AnimateClint
        FOR X = 1 TO 700: NEXT X
        PCOPY 0, 1
    NEXT I
    ClintMove = 3
    FOR I = 1 TO 4
        CALL MoveClint
        CALL AnimateClint
        FOR X = 1 TO 700: NEXT X
        PCOPY 0, 1
    NEXT I
    ClintX = -1
    CALL RestoreBack
   
    COLOR 7
    CALL DialogBoxTop
    CALL ClearDialog
    PUT (3, 3), BubbaPic, PSET
    PutText 72, 8, "Awww, he ran away.  That's not"
    PutText 72, 16, "fair.  He was kinda cute for a"
    PutText 72, 24, "skinny, wimpy geek..."
    PCOPY 0, 1
    WHILE INKEY$ = "": WEND
    PutText 72, 40, "Wait! He said he was going to"
    PutText 72, 48, "Nerdia Castle.  Bubba know's"
    PutText 72, 56, "where that is!"
    PCOPY 0, 1
    WHILE INKEY$ = "": WEND
    CALL ClearDialog
    PutText 72, 8, "Bubba will follow his fantasy"
    PutText 72, 16, "lover boy!"
    PCOPY 0, 1
    WHILE INKEY$ = "": WEND
    CALL RestoreBack

END SUB

SUB LoadAndPlayLarge (FileName$) STATIC
IF SBSIM.INTERRUPT < &H80 AND SENSITIVE <> 0 THEN MIDI.ERROR = 5: EXIT SUB
IF SBSIM.INTERRUPT < &H80 AND SENSITIVE <> 0 THEN MIDI.ERROR = 5: EXIT SUB
'See if an extension was supplied, and if not, add one.
IF INSTR(FileName$, ".") = 0 THEN FileName$ = FileName$ + ".MID"
'Open the file
FF% = FREEFILE
OPEN FileName$ FOR BINARY AS #FF%
'If the file contains no data, return an error
FileLen& = LOF(FF%)
CLOSE #FF%
IF FileLen& = 0 THEN
    KILL FileName$
    MIDI.ERROR = 1
    EXIT SUB
END IF
'The sound driver needs an ASCIIZ string (a string that ends with
'character 0) for a file name.
IF RIGHT$(FileName$, 1) <> CHR$(0) THEN FileName$ = FileName$ + CHR$(0)
'Initialize the MIDI driver and load the file in memory
IF Lasm$ = "" THEN
        Lasm$ = Lasm$ + CHR$(&H55)
        Lasm$ = Lasm$ + CHR$(&H89) + CHR$(&HE5)
        Lasm$ = Lasm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8)
        Lasm$ = Lasm$ + CHR$(&H8B) + CHR$(&H7)
        Lasm$ = Lasm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H6)
        Lasm$ = Lasm$ + CHR$(&H8B) + CHR$(&H17)
        Lasm$ = Lasm$ + CHR$(&HBB) + CHR$(&H0) + CHR$(&H5)
        Lasm$ = Lasm$ + CHR$(&HCD) + CHR$(SBSIM.INTERRUPT)
        Lasm$ = Lasm$ + CHR$(&H5D)
        Lasm$ = Lasm$ + CHR$(&HCB)
END IF
DEF SEG = VARSEG(Lasm$)
Offset% = SADD(Lasm$)
CALL ABSOLUTE(SADD(FileName$), VARSEG(FileName$), Offset%)

'Start the music!!
IF Pasm$ = "" THEN
        Pasm$ = Pasm$ + CHR$(&HBB) + CHR$(&H1) + CHR$(&H5)
        Pasm$ = Pasm$ + CHR$(&HCD) + CHR$(SBSIM.INTERRUPT)
        Pasm$ = Pasm$ + CHR$(&HCB)
END IF
IF SOUND.DISABLED = 0 THEN
    DEF SEG = VARSEG(Pasm$)
    Offset% = SADD(Pasm$)
    CALL ABSOLUTE(Offset%)
    MIDI.PLAYTIME = TIMER
END IF
MIDI.LOADED = 1
MIDI.ERROR = 0
END SUB

SUB LoadData

    FOR I = 1 TO 10
        READ LevelUP(I)
    NEXT I
    FOR I = 1 TO 10
        READ BubLevelUp(I)
    NEXT I

    FOR I = 1 TO 5
        IF I = 1 THEN
                OPEN "bubbaspa.lvl" FOR INPUT AS #1
            ELSEIF I = 2 THEN
                OPEN "marsh.lvl" FOR INPUT AS #1
            ELSEIF I = 3 THEN
                OPEN "marsh2.lvl" FOR INPUT AS #1
            ELSEIF I = 4 THEN
                OPEN "market.lvl" FOR INPUT AS #1
            ELSEIF I = 5 THEN
                OPEN "gates.lvl" FOR INPUT AS #1
        END IF

        FOR Y = 1 TO 9
            FOR X = 0 TO 15
                INPUT #1, Map(I, X, Y)
            NEXT X
        NEXT Y
       
        CLOSE #1
    NEXT I

END SUB

SUB LoadFont

    OPEN "bf.bmf" FOR INPUT AS #1

    FOR I = 33 TO 34
        FOR FontY = 1 TO 8
            FOR FontX = 1 TO 8
                INPUT #1, ChrSet(I, FontX, FontY)
            NEXT FontX
        NEXT FontY
    NEXT I
    FOR I = 36 TO 37
        FOR FontY = 1 TO 8
            FOR FontX = 1 TO 8
                INPUT #1, ChrSet(I, FontX, FontY)
            NEXT FontX
        NEXT FontY
    NEXT I
    FOR I = 39 TO 41
        FOR FontY = 1 TO 8
            FOR FontX = 1 TO 8
                INPUT #1, ChrSet(I, FontX, FontY)
            NEXT FontX
        NEXT FontY
    NEXT I
    FOR I = 44 TO 46
        FOR FontY = 1 TO 8
            FOR FontX = 1 TO 8
                INPUT #1, ChrSet(I, FontX, FontY)
            NEXT FontX
         NEXT FontY
    NEXT I
    FOR I = 48 TO 59
        FOR FontY = 1 TO 8
            FOR FontX = 1 TO 8
                INPUT #1, ChrSet(I, FontX, FontY)
            NEXT FontX
        NEXT FontY
    NEXT I
    FOR I = 63 TO 63
        FOR FontY = 1 TO 8
            FOR FontX = 1 TO 8
                INPUT #1, ChrSet(I, FontX, FontY)
            NEXT FontX
        NEXT FontY
    NEXT I
    FOR I = 65 TO 90
        FOR FontY = 1 TO 8
            FOR FontX = 1 TO 8
                INPUT #1, ChrSet(I, FontX, FontY)
            NEXT FontX
        NEXT FontY
    NEXT I
    FOR I = 97 TO 122
        FOR FontY = 1 TO 8
            FOR FontX = 1 TO 8
                INPUT #1, ChrSet(I, FontX, FontY)
            NEXT FontX
        NEXT FontY
    NEXT I

    CLOSE #1

END SUB

SUB LoadMap

    FOR Y = 1 TO 9
        FOR X = 0 TO 15
            MapScreen(X, Y) = Map(BubbaMap, X, Y)
        NEXT X
    NEXT Y

END SUB

SUB LoadMIDI (FileName$, MIDISegment%, MIDIOffset%) STATIC
IF SBMIDI.INTERRUPT < &H80 AND SENSITIVE <> 0 THEN MIDI.ERROR = 4: EXIT SUB
'See if an extension was supplied, and if not, add one.
IF INSTR(FileName$, ".") = 0 THEN FileName$ = FileName$ + ".MID"
'Open the file
FF% = FREEFILE
OPEN FileName$ FOR BINARY AS #FF%
FileLen& = LOF(FF%)
CLOSE #FF%
'If the file is empty, delete it and exit now.
IF FileLen& = 0 THEN KILL FileName$: MIDI.ERROR = 1: EXIT SUB
'If the file is too large, exit now.
IF FileLen& > 65536 THEN MIDI.ERROR = 2: EXIT SUB
'Make the filename an ASCIIZ string.
FileName$ = FileName$ + CHR$(0)
'Check if the assembly language code has already been loaded;
'if not, do it now.
IF ask$ = "" THEN
        asm$ = asm$ + CHR$(&H1E)
        asm$ = asm$ + CHR$(&H55)
        asm$ = asm$ + CHR$(&H89) + CHR$(&HE5)
        asm$ = asm$ + CHR$(&HB8) + CHR$(&H0) + CHR$(&H3D)
        asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HE)
        asm$ = asm$ + CHR$(&H8B) + CHR$(&H17)
        asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H10)
        asm$ = asm$ + CHR$(&H8E) + CHR$(&H1F)
        asm$ = asm$ + CHR$(&HCD) + CHR$(&H21)
        asm$ = asm$ + CHR$(&H89) + CHR$(&HC6)
        asm$ = asm$ + CHR$(&HB4) + CHR$(&H3F)
        asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8)
        asm$ = asm$ + CHR$(&H8B) + CHR$(&HF)
        asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HA)
        asm$ = asm$ + CHR$(&H8B) + CHR$(&H17)
        asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HC)
        asm$ = asm$ + CHR$(&H8E) + CHR$(&H1F)
        asm$ = asm$ + CHR$(&H89) + CHR$(&HF3)
        asm$ = asm$ + CHR$(&HCD) + CHR$(&H21)
        asm$ = asm$ + CHR$(&HB4) + CHR$(&H3E)
        asm$ = asm$ + CHR$(&HCD) + CHR$(&H21)
        asm$ = asm$ + CHR$(&H5D)
        asm$ = asm$ + CHR$(&H1F)
        asm$ = asm$ + CHR$(&HCA) + CHR$(&HA) + CHR$(&H0)
END IF
'Call the assembly language routine.
DEF SEG = VARSEG(asm$)
CALL ABSOLUTE(VARSEG(FileName$), SADD(FileName$), MIDISegment%, MIDIOffset%, &HFFFF, SADD(asm$))
MIDI.ERROR = 0
END SUB

SUB LoadPics

    DEF SEG = VARSEG(BubbaSoft(0)): BLOAD "bubasoft.16", VARPTR(BubbaSoft(0))
    DEF SEG = VARSEG(Title(0)): BLOAD "title.16", VARPTR(Title(0))
    DEF SEG = VARSEG(ClintPic(0)): BLOAD "clint.16", VARPTR(ClintPic(0))
    DEF SEG = VARSEG(BubbaPic(0)): BLOAD "bubba.16", VARPTR(BubbaPic(0))
    DEF SEG = VARSEG(FightGrass(0)): BLOAD "grass.16", VARPTR(FightGrass(0))
    DEF SEG = VARSEG(Pointer(0)): BLOAD "pointer.16", VARPTR(Pointer(0))

    DEF SEG = VARSEG(Geek(0)): BLOAD "geek.nme", VARPTR(Geek(0))
    DEF SEG = VARSEG(GeekM(0)): BLOAD "geek.msk", VARPTR(GeekM(0))
    DEF SEG = VARSEG(Nerd(0)): BLOAD "nerd.nme", VARPTR(Nerd(0))
    DEF SEG = VARSEG(NerdM(0)): BLOAD "nerd.msk", VARPTR(NerdM(0))

END SUB

SUB LoadTiles

    DEF SEG = VARSEG(Grass(0)): BLOAD "grass.til", VARPTR(Grass(0))
    DEF SEG = VARSEG(Ground(0)): BLOAD "ground.til", VARPTR(Ground(0))
    DEF SEG = VARSEG(Tree(0)): BLOAD "tree.til", VARPTR(Tree(0))
    DEF SEG = VARSEG(Rock(0)): BLOAD "rock.til", VARPTR(Rock(0))
    DEF SEG = VARSEG(Water(0)): BLOAD "water.til", VARPTR(Water(0))
    DEF SEG = VARSEG(Water1(0)): BLOAD "water1.til", VARPTR(Water1(0))
    DEF SEG = VARSEG(Water2(0)): BLOAD "water2.til", VARPTR(Water2(0))
    DEF SEG = VARSEG(Water3(0)): BLOAD "water3.til", VARPTR(Water3(0))
    DEF SEG = VARSEG(Water4(0)): BLOAD "water4.til", VARPTR(Water4(0))
    DEF SEG = VARSEG(WaterEdge(0)): BLOAD "w_edge.til", VARPTR(WaterEdge(0))
 
    DEF SEG = VARSEG(WoodFloor(0)): BLOAD "w_floor.til", VARPTR(WoodFloor(0))
    DEF SEG = VARSEG(InsideWall(0)): BLOAD "i_wall.til", VARPTR(InsideWall(0))
    DEF SEG = VARSEG(OutsideWall(0)): BLOAD "o_wall.til", VARPTR(OutsideWall(0))
    DEF SEG = VARSEG(Roof(0)): BLOAD "roof.til", VARPTR(Roof(0))

    DEF SEG = VARSEG(Bed(0)): BLOAD "bed.til", VARPTR(Bed(0))
    DEF SEG = VARSEG(Table(0)): BLOAD "table.til", VARPTR(Table(0))

    DEF SEG = VARSEG(ShopTL(0)): BLOAD "shop_tl.til", VARPTR(ShopTL(0))
    DEF SEG = VARSEG(ShopBL(0)): BLOAD "shop_bl.til", VARPTR(ShopBL(0))
    DEF SEG = VARSEG(ShopTR(0)): BLOAD "shop_tr.til", VARPTR(ShopTR(0))
    DEF SEG = VARSEG(ShopBR(0)): BLOAD "shop_br.til", VARPTR(ShopBR(0))
    DEF SEG = VARSEG(Shop(0)): BLOAD "shop.til", VARPTR(Shop(0))
    DEF SEG = VARSEG(ShopW(0)): BLOAD "shop_w.til", VARPTR(ShopW(0))
    DEF SEG = VARSEG(ShopI(0)): BLOAD "shop_i.til", VARPTR(ShopI(0))

    DEF SEG = VARSEG(CastleDoor(0)): BLOAD "c_door.til", VARPTR(CastleDoor(0))

    DEF SEG = VARSEG(BubbaR1(0)): BLOAD "bubba_r1.til", VARPTR(BubbaR1(0))
    DEF SEG = VARSEG(BubbaR2(0)): BLOAD "bubba_r2.til", VARPTR(BubbaR2(0))
    DEF SEG = VARSEG(BubbaL1(0)): BLOAD "bubba_l1.til", VARPTR(BubbaL1(0))
    DEF SEG = VARSEG(BubbaL2(0)): BLOAD "bubba_l2.til", VARPTR(BubbaL2(0))
    DEF SEG = VARSEG(BubbaU1(0)): BLOAD "bubba_u1.til", VARPTR(BubbaU1(0))
    DEF SEG = VARSEG(BubbaU2(0)): BLOAD "bubba_u2.til", VARPTR(BubbaU2(0))
    DEF SEG = VARSEG(BubbaD1(0)): BLOAD "bubba_d1.til", VARPTR(BubbaD1(0))
    DEF SEG = VARSEG(BubbaD2(0)): BLOAD "bubba_d2.til", VARPTR(BubbaD2(0))
    DEF SEG = VARSEG(BubbaA(0)): BLOAD "bubba_a.til", VARPTR(BubbaA(0))
    DEF SEG = VARSEG(ClintR1(0)): BLOAD "clint_r1.til", VARPTR(ClintR1(0))
    DEF SEG = VARSEG(ClintR2(0)): BLOAD "clint_r2.til", VARPTR(ClintR2(0))
    DEF SEG = VARSEG(ClintL1(0)): BLOAD "clint_l1.til", VARPTR(ClintL1(0))
    DEF SEG = VARSEG(ClintL2(0)): BLOAD "clint_l2.til", VARPTR(ClintL2(0))
    DEF SEG = VARSEG(ClintU1(0)): BLOAD "clint_u1.til", VARPTR(ClintU1(0))
    DEF SEG = VARSEG(ClintU2(0)): BLOAD "clint_u2.til", VARPTR(ClintU2(0))
    DEF SEG = VARSEG(ClintD1(0)): BLOAD "clint_d1.til", VARPTR(ClintD1(0))
    DEF SEG = VARSEG(ClintD2(0)): BLOAD "clint_d2.til", VARPTR(ClintD2(0))

    DEF SEG = VARSEG(BubbaR1M(0)): BLOAD "bubba_r1.msk", VARPTR(BubbaR1M(0))
    DEF SEG = VARSEG(BubbaR2M(0)): BLOAD "bubba_r2.msk", VARPTR(BubbaR2M(0))
    DEF SEG = VARSEG(BubbaL1M(0)): BLOAD "bubba_l1.msk", VARPTR(BubbaL1M(0))
    DEF SEG = VARSEG(BubbaL2M(0)): BLOAD "bubba_l2.msk", VARPTR(BubbaL2M(0))
    DEF SEG = VARSEG(BubbaU1M(0)): BLOAD "bubba_u1.msk", VARPTR(BubbaU1M(0))
    DEF SEG = VARSEG(BubbaU2M(0)): BLOAD "bubba_u2.msk", VARPTR(BubbaU2M(0))
    DEF SEG = VARSEG(BubbaD1M(0)): BLOAD "bubba_d1.msk", VARPTR(BubbaD1M(0))
    DEF SEG = VARSEG(BubbaD2M(0)): BLOAD "bubba_d2.msk", VARPTR(BubbaD2M(0))
    DEF SEG = VARSEG(BubbaAM(0)): BLOAD "bubba_a.msk", VARPTR(BubbaAM(0))
    DEF SEG = VARSEG(ClintR1M(0)): BLOAD "clint_r1.msk", VARPTR(ClintR1M(0))
    DEF SEG = VARSEG(ClintR2M(0)): BLOAD "clint_r2.msk", VARPTR(ClintR2M(0))
    DEF SEG = VARSEG(ClintL1M(0)): BLOAD "clint_l1.msk", VARPTR(ClintL1M(0))
    DEF SEG = VARSEG(ClintL2M(0)): BLOAD "clint_l2.msk", VARPTR(ClintL2M(0))
    DEF SEG = VARSEG(ClintU1M(0)): BLOAD "clint_u1.msk", VARPTR(ClintU1M(0))
    DEF SEG = VARSEG(ClintU2M(0)): BLOAD "clint_u2.msk", VARPTR(ClintU2M(0))
    DEF SEG = VARSEG(ClintD1M(0)): BLOAD "clint_d1.msk", VARPTR(ClintD1M(0))
    DEF SEG = VARSEG(ClintD2M(0)): BLOAD "clint_d2.msk", VARPTR(ClintD2M(0))

END SUB

FUNCTION MIDIError$
SELECT CASE MIDI.ERROR
        CASE 0: MIDIError$ = "NO ERROR"
        CASE 1: MIDIError$ = "FILE CONTAINS NO DATA"
        CASE 2: MIDIError$ = "FILE IS TOO LARGE"
        CASE 3: MIDIError$ = "NO MIDI FILE PLAYING"
        CASE 4: MIDIError$ = "INVALID SBMIDI INTERRUPT"
        CASE 5: MIDIError$ = "INVALID SBSIM INTERRUPT"
        CASE 6: MIDIError$ = "NO MIXER CHIP"
        CASE 7: MIDIError$ = "COULD NOT DETECT SOUND CARD"
        CASE 8: MIDIError$ = "FEATURE UNAVAILABLE"
        CASE 9: MIDIError$ = "FILE IS CORRUPT"
        CASE 10: MIDIError$ = "INVALID SOUND CARD TYPE"
        CASE ELSE: MIDIError$ = "UNKNOWN ERROR"
END SELECT
END FUNCTION

SUB MoveBubba

    IF BubbaMove = 1 THEN
            PUT (BubbaX * 20, BubbaY * 20), BubbaBack, PSET
            FOR Y = -1 TO -10 STEP -1
                GET (BubbaX * 20, (BubbaY * 20) + Y)-((BubbaX * 20) + 19, ((BubbaY * 20) + Y) + 19), BubbaBack
                PUT (BubbaX * 20, (BubbaY * 20) + Y), BubbaU1M, AND
                PUT (BubbaX * 20, (BubbaY * 20) + Y), BubbaU1, XOR
                PCOPY 0, 1
                FOR I = 1 TO 10: NEXT I
                PUT (BubbaX * 20, (BubbaY * 20) + Y), BubbaBack, PSET
            NEXT Y
            FOR Y = -11 TO -20 STEP -1
                GET (BubbaX * 20, (BubbaY * 20) + Y)-((BubbaX * 20) + 19, ((BubbaY * 20) + Y) + 19), BubbaBack
                PUT (BubbaX * 20, (BubbaY * 20) + Y), BubbaU2M, AND
                PUT (BubbaX * 20, (BubbaY * 20) + Y), BubbaU2, XOR
                PCOPY 0, 1
                FOR I = 1 TO 10: NEXT I
                PUT (BubbaX * 20, (BubbaY * 20) + Y), BubbaBack, PSET
            NEXT Y
            BubbaY = BubbaY - 1
        ELSEIF BubbaMove = 2 THEN
            PUT (BubbaX * 20, BubbaY * 20), BubbaBack, PSET
            FOR X = -1 TO -10 STEP -1
                GET ((BubbaX * 20) + X, BubbaY * 20)-(((BubbaX * 20) + X) + 19, (BubbaY * 20) + 19), BubbaBack
                PUT ((BubbaX * 20) + X, BubbaY * 20), BubbaL1M, AND
                PUT ((BubbaX * 20) + X, BubbaY * 20), BubbaL1, XOR
                PCOPY 0, 1
                FOR I = 1 TO 10: NEXT I
                PUT ((BubbaX * 20) + X, BubbaY * 20), BubbaBack, PSET
            NEXT X
            FOR X = -11 TO -20 STEP -1
                GET ((BubbaX * 20) + X, BubbaY * 20)-(((BubbaX * 20) + X) + 19, (BubbaY * 20) + 19), BubbaBack
                PUT ((BubbaX * 20) + X, BubbaY * 20), BubbaL2M, AND
                PUT ((BubbaX * 20) + X, BubbaY * 20), BubbaL2, XOR
                PCOPY 0, 1
                FOR I = 1 TO 10: NEXT I
                PUT ((BubbaX * 20) + X, BubbaY * 20), BubbaBack, PSET
            NEXT X
            BubbaX = BubbaX - 1
        ELSEIF BubbaMove = 3 THEN
            PUT (BubbaX * 20, BubbaY * 20), BubbaBack, PSET
            FOR X = 1 TO 10
                GET ((BubbaX * 20) + X, BubbaY * 20)-(((BubbaX * 20) + X) + 19, (BubbaY * 20) + 19), BubbaBack
                PUT ((BubbaX * 20) + X, BubbaY * 20), BubbaR1M, AND
                PUT ((BubbaX * 20) + X, BubbaY * 20), BubbaR1, XOR
                PCOPY 0, 1
                FOR I = 1 TO 10: NEXT I
                PUT ((BubbaX * 20) + X, BubbaY * 20), BubbaBack, PSET
            NEXT X
            FOR X = 11 TO 20
                GET ((BubbaX * 20) + X, BubbaY * 20)-(((BubbaX * 20) + X) + 19, (BubbaY * 20) + 19), BubbaBack
                PUT ((BubbaX * 20) + X, BubbaY * 20), BubbaR2M, AND
                PUT ((BubbaX * 20) + X, BubbaY * 20), BubbaR2, XOR
                PCOPY 0, 1
                FOR I = 1 TO 10: NEXT I
                PUT ((BubbaX * 20) + X, BubbaY * 20), BubbaBack, PSET
            NEXT X
            BubbaX = BubbaX + 1
        ELSEIF BubbaMove = 4 THEN
            PUT (BubbaX * 20, BubbaY * 20), BubbaBack, PSET
            FOR Y = 1 TO 10
                GET (BubbaX * 20, (BubbaY * 20) + Y)-((BubbaX * 20) + 19, ((BubbaY * 20) + Y) + 19), BubbaBack
                PUT (BubbaX * 20, (BubbaY * 20) + Y), BubbaD1M, AND
                PUT (BubbaX * 20, (BubbaY * 20) + Y), BubbaD1, XOR
                PCOPY 0, 1
                FOR I = 1 TO 10: NEXT I
                PUT (BubbaX * 20, (BubbaY * 20) + Y), BubbaBack, PSET
            NEXT Y
            FOR Y = 11 TO 20
                GET (BubbaX * 20, (BubbaY * 20) + Y)-((BubbaX * 20) + 19, ((BubbaY * 20) + Y) + 19), BubbaBack
                PUT (BubbaX * 20, (BubbaY * 20) + Y), BubbaD2M, AND
                PUT (BubbaX * 20, (BubbaY * 20) + Y), BubbaD2, XOR
                PCOPY 0, 1
                FOR I = 1 TO 10: NEXT I
                PUT (BubbaX * 20, (BubbaY * 20) + Y), BubbaBack, PSET
            NEXT Y
            BubbaY = BubbaY + 1
    END IF

END SUB

SUB MoveClint
   
    IF ClintMove = 1 THEN
            PUT (ClintX * 20, ClintY * 20), ClintBack, PSET
            FOR Y = -1 TO -10 STEP -1
                GET (ClintX * 20, (ClintY * 20) + Y)-((ClintX * 20) + 19, ((ClintY * 20) + Y) + 19), ClintBack
                PUT (ClintX * 20, (ClintY * 20) + Y), ClintU1M, AND
                PUT (ClintX * 20, (ClintY * 20) + Y), ClintU1, XOR
                PCOPY 0, 1
                FOR I = 1 TO 10: NEXT I
                PUT (ClintX * 20, (ClintY * 20) + Y), ClintBack, PSET
            NEXT Y
            FOR Y = -11 TO -20 STEP -1
                GET (ClintX * 20, (ClintY * 20) + Y)-((ClintX * 20) + 19, ((ClintY * 20) + Y) + 19), ClintBack
                PUT (ClintX * 20, (ClintY * 20) + Y), ClintU2M, AND
                PUT (ClintX * 20, (ClintY * 20) + Y), ClintU2, XOR
                PCOPY 0, 1
                FOR I = 1 TO 10: NEXT I
                PUT (ClintX * 20, (ClintY * 20) + Y), ClintBack, PSET
            NEXT Y
            ClintY = ClintY - 1
        ELSEIF ClintMove = 2 THEN
            PUT (ClintX * 20, ClintY * 20), ClintBack, PSET
            FOR X = -1 TO -10 STEP -1
                GET ((ClintX * 20) + X, ClintY * 20)-(((ClintX * 20) + X) + 19, (ClintY * 20) + 19), ClintBack
                PUT ((ClintX * 20) + X, ClintY * 20), ClintL1M, AND
                PUT ((ClintX * 20) + X, ClintY * 20), ClintL1, XOR
                PCOPY 0, 1
                FOR I = 1 TO 10: NEXT I
                PUT ((ClintX * 20) + X, ClintY * 20), ClintBack, PSET
            NEXT X
            FOR X = -11 TO -20 STEP -1
                GET ((ClintX * 20) + X, ClintY * 20)-(((ClintX * 20) + X) + 19, (ClintY * 20) + 19), ClintBack
                PUT ((ClintX * 20) + X, ClintY * 20), ClintL2M, AND
                PUT ((ClintX * 20) + X, ClintY * 20), ClintL2, XOR
                PCOPY 0, 1
                FOR I = 1 TO 10: NEXT I
                PUT ((ClintX * 20) + X, ClintY * 20), ClintBack, PSET
            NEXT X
            ClintX = ClintX - 1
        ELSEIF ClintMove = 3 THEN
            PUT (ClintX * 20, ClintY * 20), ClintBack, PSET
            FOR X = 1 TO 10
                GET ((ClintX * 20) + X, ClintY * 20)-(((ClintX * 20) + X) + 19, (ClintY * 20) + 19), ClintBack
                PUT ((ClintX * 20) + X, ClintY * 20), ClintR1M, AND
                PUT ((ClintX * 20) + X, ClintY * 20), ClintR1, XOR
                PCOPY 0, 1
                FOR I = 1 TO 10: NEXT I
                PUT ((ClintX * 20) + X, ClintY * 20), ClintBack, PSET
            NEXT X
            FOR X = 11 TO 20
                GET ((ClintX * 20) + X, ClintY * 20)-(((ClintX * 20) + X) + 19, (ClintY * 20) + 19), ClintBack
                PUT ((ClintX * 20) + X, ClintY * 20), ClintR2M, AND
                PUT ((ClintX * 20) + X, ClintY * 20), ClintR2, XOR
                PCOPY 0, 1
                FOR I = 1 TO 10: NEXT I
                PUT ((ClintX * 20) + X, ClintY * 20), ClintBack, PSET
            NEXT X
            ClintX = ClintX + 1
        ELSEIF ClintMove = 4 THEN
            PUT (ClintX * 20, ClintY * 20), ClintBack, PSET
            FOR Y = 1 TO 10
                GET (ClintX * 20, (ClintY * 20) + Y)-((ClintX * 20) + 19, ((ClintY * 20) + Y) + 19), ClintBack
                PUT (ClintX * 20, (ClintY * 20) + Y), ClintD1M, AND
                PUT (ClintX * 20, (ClintY * 20) + Y), ClintD1, XOR
                PCOPY 0, 1
                FOR I = 1 TO 10: NEXT I
                PUT (ClintX * 20, (ClintY * 20) + Y), ClintBack, PSET
            NEXT Y
            FOR Y = 11 TO 20
                GET (ClintX * 20, (ClintY * 20) + Y)-((ClintX * 20) + 19, ((ClintY * 20) + Y) + 19), ClintBack
                PUT (ClintX * 20, (ClintY * 20) + Y), ClintD2M, AND
                PUT (ClintX * 20, (ClintY * 20) + Y), ClintD2, XOR
                PCOPY 0, 1
                FOR I = 1 TO 10: NEXT I
                PUT (ClintX * 20, (ClintY * 20) + Y), ClintBack, PSET
            NEXT Y
            ClintY = ClintY + 1
    END IF
END SUB

SUB Options

    DO
        CALL ShowOptions
        Position = 1
    DO
        SELECT CASE INKEY$
        CASE CHR$(0) + CHR$(80)
        IF Position = 1 THEN
                Position = 2
                LINE (15, 39)-(25, 46), 0, BF
                PUT (15, 47), Pointer
                PutText 32, 40, "ITEMS"
                COLOR 9
                LOCATE 7, 5: PRINT "SPECIAL"
                PCOPY 0, 1
            ELSEIF Position = 2 THEN
                Position = 3
                LINE (15, 47)-(25, 54), 0, BF
                PUT (15, 55), Pointer, PSET
                PutText 32, 48, "SPECIAL"
                COLOR 9
                LOCATE 8, 5: PRINT "EQUIP"
                PCOPY 0, 1
            ELSEIF Position = 3 THEN
                Position = 4
                LINE (15, 55)-(25, 62), 0, BF
                PUT (15, 63), Pointer, PSET
                PutText 32, 56, "EQUIP"
                COLOR 9
                LOCATE 9, 5: PRINT "STATS"
                PCOPY 0, 1
            ELSEIF Position = 4 THEN
                Position = 5
                LINE (15, 63)-(25, 70), 0, BF
                PUT (15, 71), Pointer, PSET
                PutText 32, 64, "STATS"
                COLOR 9
                LOCATE 10, 5: PRINT "EXIT"
                PCOPY 0, 1
        END IF
        CASE CHR$(0) + CHR$(72)
        IF Position = 5 THEN
                Position = 4
                LINE (15, 71)-(25, 78), 0, BF
                PUT (15, 63), Pointer, PSET
                PutText 32, 72, "EXIT"
                COLOR 9
                LOCATE 9, 5: PRINT "STATS"
                PCOPY 0, 1
            ELSEIF Position = 4 THEN
                Position = 3
                LINE (15, 63)-(25, 70), 0, BF
                PUT (15, 55), Pointer, PSET
                PutText 32, 64, "STATS"
                COLOR 9
                LOCATE 8, 5: PRINT "EQUIP"
                PCOPY 0, 1
            ELSEIF Position = 3 THEN
                Position = 2
                LINE (15, 55)-(25, 62), 0, BF
                PUT (15, 47), Pointer, PSET
                PutText 32, 56, "EQUIP"
                COLOR 9
                LOCATE 7, 5: PRINT "SPECIAL"
                PCOPY 0, 1
            ELSEIF Position = 2 THEN
                Position = 1
                LINE (15, 47)-(25, 54), 0, BF
                PUT (15, 39), Pointer, PSET
                PutText 32, 48, "SPECIAL"
                COLOR 9
                LOCATE 6, 5: PRINT "ITEMS"
                PCOPY 0, 1
        END IF
        CASE CHR$(13)
            Quit = True
        END SELECT

    LOOP UNTIL Quit
    Quit = False

    IF Position = 1 THEN
            LINE (120, 30)-(280, 180), 0, BF
            LINE (120, 30)-(280, 180), 1, B
            LINE (121, 31)-(279, 179), 9, B
            LINE (122, 32)-(278, 178), 1, B
            COLOR 9
            LOCATE 6, 19: PRINT BubbaItems$(1)
            COLOR 15
            FOR I = 2 TO 8
                LOCATE 5 + I, 19: PRINT BubbaItems$(I)
            NEXT I
            PCOPY 0, 1
            WHILE INKEY$ = "": WEND
            CALL TopBar
            CALL ShowLevel
            CALL AnimateBubba
        ELSEIF Position = 4 THEN
            LINE (120, 30)-(280, 180), 0, BF
            LINE (120, 30)-(280, 180), 1, B
            LINE (121, 31)-(279, 179), 9, B
            LINE (122, 32)-(278, 178), 1, B
            COLOR 15
            LOCATE 6, 17: PRINT "Bubba"
            LOCATE 8, 17: PRINT "HP"
            LOCATE 9, 17: PRINT "BP"
            LOCATE 10, 17: PRINT "Level"
            LOCATE 12, 17: PRINT "Attack"
            LOCATE 13, 17: PRINT "Defense"
            LOCATE 14, 17: PRINT "Agility"
            LOCATE 15, 17: PRINT "Special"
            LOCATE 17, 17: PRINT "Experience"
            LOCATE 18, 17: PRINT "Level Up"
            LOCATE 19, 17: PRINT "Special EXP"
            LOCATE 20, 17: PRINT "Special Up"
            LOCATE 22, 17: PRINT "Gold"

            LOCATE 8, 26: PRINT USING "####"; HP
            LOCATE 8, 30: PRINT "/"
            LOCATE 8, 31: PRINT USING "####"; MaxHP
            LOCATE 9, 26: PRINT USING "####"; BP
            LOCATE 9, 30: PRINT "/"
            LOCATE 9, 31: PRINT USING "####"; MaxBP
            LOCATE 10, 33: PRINT USING "##"; Level
            LOCATE 12, 32: PRINT USING "###"; Attack
            LOCATE 13, 32: PRINT USING "###"; Defense
            LOCATE 14, 32: PRINT USING "###"; Agility
            LOCATE 15, 32: PRINT USING "###"; Bubbattack
            LOCATE 17, 29: PRINT USING "######"; EP
            LOCATE 18, 29: PRINT USING "######"; NextLVL - EP
            LOCATE 19, 31: PRINT USING "####"; BubEP
            LOCATE 20, 31: PRINT USING "####"; NextBubLVL - BubEP
            LOCATE 22, 29: PRINT USING "######"; Gold
            PCOPY 0, 1
            WHILE INKEY$ = "": WEND
            CALL TopBar
            CALL ShowLevel
            CALL AnimateBubba
        ELSEIF Position = 5 THEN
            CALL TopBar
            CALL ShowLevel
            CALL AnimateBubba
            PCOPY 0, 1
            Quit2 = True
    END IF

    LOOP UNTIL Quit2

END SUB

SUB PauseMIDI
IF SBSIM.INTERRUPT < &H80 AND SENSITIVE <> 0 THEN MIDI.ERROR = 5: EXIT SUB
'If no MIDI file is playing, exit now
IF MIDI.PLAYTIME = 0 THEN
    MIDI.ERROR = 3
    EXIT SUB
END IF
'Pause the music.
IF asm$ = "" THEN
        asm$ = asm$ + CHR$(&HBB) + CHR$(&H3) + CHR$(&H5)
        asm$ = asm$ + CHR$(&HCD) + CHR$(SBSIM.INTERRUPT)
        asm$ = asm$ + CHR$(&HCB)
END IF
DEF SEG = VARSEG(asm$)
Offset% = SADD(asm$)
CALL ABSOLUTE(Offset%)
'Save the number of seconds the MIDI file has been playing.
PAUSED = TimeMIDI!
'If it hasn't been playing long enough for TimeMIDI! to return
'a value greater than 0, change PAUSED to a tiny positive value.
IF PAUSED = 0! THEN PAUSED = .00001
'Indicate that the file has stopped playing.
MIDI.PLAYTIME = 0
MIDI.ERROR = 0
END SUB

SUB PlayMID (FileName$)

    DIM MIDI%(BytesRequired&(FileName$) \ 2)
    LoadMIDI FileName$, VARSEG(MIDI%(0)), VARPTR(MIDI%(0))
    PlayMIDI VARSEG(MIDI%(0)), VARPTR(MIDI%(0))
    ERASE MIDI%

END SUB

SUB PlayMIDI (MIDISegment%, MIDIOffset%) STATIC
IF SBMIDI.INTERRUPT < &H80 AND SENSITIVE <> 0 THEN MIDI.ERROR = 4: EXIT SUB
'Check to see if the MIDI playing code has previously been loaded.
'If not, load it now.
IF asm$ = "" THEN
        'Load the machine codes into a string.
        asm$ = asm$ + CHR$(&H55)
        asm$ = asm$ + CHR$(&H89) + CHR$(&HE5)
        asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8)
        asm$ = asm$ + CHR$(&H8B) + CHR$(&H17)
        asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H6)
        asm$ = asm$ + CHR$(&H8B) + CHR$(&H7)
        asm$ = asm$ + CHR$(&HBB) + CHR$(&H4) + CHR$(&H0)
        asm$ = asm$ + CHR$(&HCD) + CHR$(&H80)
        asm$ = asm$ + CHR$(&HBB) + CHR$(&H5) + CHR$(&H0)
        asm$ = asm$ + CHR$(&HCD) + CHR$(&H80)
        asm$ = asm$ + CHR$(&H5D)
        asm$ = asm$ + CHR$(&HCA) + CHR$(&H4) + CHR$(&H0)
END IF
IF SOUND.DISABLED = 0 THEN
    'Call the machine language routine to play the music.
    DEF SEG = VARSEG(asm$)
    Offset% = SADD(asm$)
    CALL ABSOLUTE(MIDISegment%, MIDIOffset%, Offset%)
    'Start the MIDI timer.
    MIDI.PLAYTIME = TIMER
END IF
END SUB

SUB PutText (PosX%, PosY%, Sentence$)

    FOR Csr = 1 TO LEN(Sentence$)

        CN = ASC(MID$(Sentence$, Csr, 1))
        IF CN = 33 OR CN = 34 OR CN = 36 OR CN = 37 OR CN > 38 AND CN < 42 OR CN > 43 AND CN < 47 OR CN > 47 AND CN < 60 OR CN = 63 OR CN > 64 AND CN < 91 OR CN > 96 THEN
            FOR Y = 1 TO 8
                FOR X = 1 TO 8
                  IF ChrSet(CN, X, Y) <> 0 THEN PSET (PosX% + (X - 1), PosY% + (Y - 1)), ChrSet(CN, X, Y)
                NEXT X
            NEXT Y
        END IF

        PosX% = PosX% + 8
        IF PosX% = 320 THEN
            PosX% = 0
            PosY% = PosY% + 8
        END IF

   NEXT Csr


END SUB

SUB RestoreBack

    CALL ShowLevel
    CALL TopBar
    GET (BubbaX * 20, BubbaY * 20)-((BubbaX * 20) + 19, (BubbaY * 20) + 19), BubbaBack
    IF ClintX > -1 THEN
        GET (ClintX * 20, ClintY * 20)-((ClintX * 20) + 19, (ClintY * 20) + 19), ClintBack
        CALL AnimateClint
    END IF
    CALL AnimateBubba
    PCOPY 0, 1
    CALL Delay(1)

END SUB

SUB ResumeMIDI
IF SBSIM.INTERRUPT < &H80 AND SENSITIVE <> 0 THEN MIDI.ERROR = 5: EXIT SUB
'If no MIDI file is paused, exit now
IF PAUSED = 0! THEN EXIT SUB
'Resume playing.
IF asm$ = "" THEN
        asm$ = ""
        asm$ = asm$ + CHR$(&HBB) + CHR$(&H4) + CHR$(&H5)
        asm$ = asm$ + CHR$(&HCD) + CHR$(SBSIM.INTERRUPT)
        asm$ = asm$ + CHR$(&HCB)
END IF
DEF SEG = VARSEG(asm$)
Offset% = SADD(asm$)
CALL ABSOLUTE(Offset%)
MIDI.PLAYTIME = TIMER - PAUSED
PAUSED = 0!
MIDI.ERROR = 0
END SUB

SUB SaveGame

    OPEN "bf.sav" FOR OUTPUT AS #1
    WRITE #1, BubbaMap, HP, BP, MaxHP, MaxBP
    WRITE #1, Attack, Defense, Agility, Bubbattack
    WRITE #1, Level, EP, NextLVL, BubLVL, BubEP, NextBubLVL
    WRITE #1, Gold, MapType
    FOR I = 1 TO 8
        WRITE #1, SpecialAttack(I), Special$(I), BubbaItems$(I), BattleItem(I)
    NEXT I
    CLOSE #1

END SUB

DEFINT A-Z
SUB SaveTemp STATIC

    SaveFile = SaveFile + 1
    Number$ = RIGHT$(STR$(SaveFile), 1)
    OPEN "bf" + Number$ + ".ega" FOR OUTPUT AS #1
    FOR Y = 0 TO 199
        FOR X = 0 TO 319
            Pixel = POINT(X, Y)
            WRITE #1, Pixel
            PSET (X, Y), 0
        NEXT X
    NEXT Y
    CLOSE #1

END SUB

DEFSNG A-Z
SUB SetUpItems

    CALL ClearEnemyBox
    FOR X = 4 TO 15 STEP 11
        FOR Y = 20 TO 23
            I = I + 1
            LOCATE Y, X
            IF BattleItem(I) THEN
                    COLOR 15
                    PRINT BubbaItems$(I)
                ELSEIF NOT BattleItem(I) THEN
                    COLOR 8
                    PRINT BubbaItems$(I)
            END IF
        NEXT Y
    NEXT X
    PCOPY 0, 1

END SUB

SUB SetUpSpecial

    CALL ClearEnemyBox
    FOR X = 4 TO 15 STEP 11
        FOR Y = 20 TO 23
            I = I + 1
            LOCATE Y, X
            COLOR 15
            PRINT Special$(I)
        NEXT Y
    NEXT X
    PCOPY 0, 1

END SUB

SUB ShowLevel

    FOR Y = 1 TO 9
        FOR X = 0 TO 15
            IF MapScreen(X, Y) = 0 THEN
                    PUT (X * 20, Y * 20), Grass, PSET
                ELSEIF MapScreen(X, Y) = 1 THEN
                    PUT (X * 20, Y * 20), WoodFloor, PSET
                ELSEIF MapScreen(X, Y) = 2 THEN
                    PUT (X * 20, Y * 20), Ground, PSET
                ELSEIF MapScreen(X, Y) = 10 THEN
                    PUT (X * 20, Y * 20), Tree, PSET
                ELSEIF MapScreen(X, Y) = 11 THEN
                    PUT (X * 20, Y * 20), Rock, PSET
                ELSEIF MapScreen(X, Y) = 12 THEN
                    PUT (X * 20, Y * 20), InsideWall, PSET
                ELSEIF MapScreen(X, Y) = 13 THEN
                    PUT (X * 20, Y * 20), OutsideWall, PSET
                ELSEIF MapScreen(X, Y) = 14 THEN
                    PUT (X * 20, Y * 20), Roof, PSET
                ELSEIF MapScreen(X, Y) = 15 THEN
                    PUT (X * 20, Y * 20), Water, PSET
                ELSEIF MapScreen(X, Y) = 16 THEN
                    PUT (X * 20, Y * 20), Water1, PSET
                ELSEIF MapScreen(X, Y) = 17 THEN
                    PUT (X * 20, Y * 20), Water2, PSET
                ELSEIF MapScreen(X, Y) = 18 THEN
                    PUT (X * 20, Y * 20), Water3, PSET
                ELSEIF MapScreen(X, Y) = 19 THEN
                    PUT (X * 20, Y * 20), Water4, PSET
                ELSEIF MapScreen(X, Y) = 20 THEN
                    PUT (X * 20, Y * 20), ShopTL, PSET
                ELSEIF MapScreen(X, Y) = 21 THEN
                    PUT (X * 20, Y * 20), ShopTR, PSET
                ELSEIF MapScreen(X, Y) = 22 THEN
                    PUT (X * 20, Y * 20), ShopBL, PSET
                ELSEIF MapScreen(X, Y) = 23 THEN
                    PUT (X * 20, Y * 20), ShopBR, PSET
                ELSEIF MapScreen(X, Y) = 24 THEN
                    PUT (X * 20, Y * 20), Shop, PSET
                ELSEIF MapScreen(X, Y) = 25 THEN
                    PUT (X * 20, Y * 20), ShopW, PSET
                ELSEIF MapScreen(X, Y) = 26 THEN
                    PUT (X * 20, Y * 20), ShopI, PSET
                ELSEIF MapScreen(X, Y) = 27 THEN
                    PUT (X * 20, Y * 20), WaterEdge, PSET
                ELSEIF MapScreen(X, Y) = 28 THEN
                    PUT (X * 20, Y * 20), CastleDoor, PSET
                ELSEIF MapScreen(X, Y) = 29 THEN
                    PUT (X * 20, Y * 20), Bed, PSET
                ELSEIF MapScreen(X, Y) = 30 THEN
                    PUT (X * 20, Y * 20), Table, PSET
            END IF
        NEXT X
    NEXT Y
    CALL TopBar

END SUB

SUB ShowOptions

    LINE (10, 30)-(100, 95), 0, BF
    LINE (10, 30)-(100, 95), 1, B
    LINE (11, 31)-(99, 94), 9, B
    LINE (12, 32)-(98, 93), 1, B
    COLOR 15
    LOCATE 7, 5: PRINT "SPECIAL"
    LOCATE 8, 5: PRINT "EQUIP"
    LOCATE 9, 5: PRINT "STATS"
    LOCATE 10, 5: PRINT "EXIT"
    COLOR 9
    LOCATE 6, 5: PRINT "ITEMS"
    PUT (15, 39), Pointer, PSET
    PCOPY 0, 1

END SUB

SUB Sleepy

    CALL DialogBoxTop
    PUT (3, 3), BubbaPic, PSET
    PutText 72, 8, "Yawn... Maybe Bubba should"
    PutText 72, 16, "get some sleep..."
    PutText 72, 40, "     Rest     Cancel"
    CALL DoItChoice
    IF DoIt THEN
            CALL ShowLevel
            PCOPY 0, 1
            CALL GoToSleep
            HP = MaxHP
            BP = MaxBP
            CALL DialogBoxTop
            PutText 72, 8, "HP and BP restored!"
            PCOPY 0, 1
            WHILE INKEY$ = "": WEND
            CALL DialogBoxTop
            PutText 72, 8, "Save your game?"
            PutText 72, 40, "     Save     Cancel"
            CALL DoItChoice
            IF DoIt THEN
                CALL SaveGame
                CALL DialogBoxTop
                PutText 72, 8, "Game saved!"
                PCOPY 0, 1
                WHILE INKEY$ = "": WEND
            END IF
        ELSE
            CALL DialogBoxTop
            PutText 72, 8, "Save your game?"
            PutText 72, 40, "     Save     Cancel"
            CALL DoItChoice
            IF DoIt THEN
                CALL SaveGame
                CALL DialogBoxTop
                PutText 72, 8, "Game saved!"
                PCOPY 0, 1
                WHILE INKEY$ = "": WEND
            END IF
    END IF
    CALL ShowLevel
    PCOPY 0, 1

END SUB

SUB StopMIDI STATIC
IF SBMIDI.INTERRUPT < &H80 AND SENSITIVE <> 0 THEN MIDI.ERROR = 4: EXIT SUB
'Stop the music!!
IF asm$ = "" THEN
    asm$ = asm$ + CHR$(&HBB) + CHR$(&H4) + CHR$(&H0)
    asm$ = asm$ + CHR$(&HCD) + CHR$(SBMIDI.INTERRUPT)
    asm$ = asm$ + CHR$(&HCB)
END IF
IF MIDI.PLAYTIME THEN
    DEF SEG = VARSEG(asm$)
    Offset% = SADD(asm$)
    CALL ABSOLUTE(Offset%)
    MIDI.ERROR = 0
ELSE
    MIDI.ERROR = 3
END IF
'No MIDI file is playing, so reset the timer
MIDI.PLAYTIME = 0
END SUB

FUNCTION TimeMIDI!
'If a MIDI file is paused, lock the current playing time
IF PAUSED > 0! THEN
    TimeMIDI! = PAUSED
    MIDI.ERROR = 0
'If a MIDI file is playing, carry out the timing routine
ELSEIF MIDI.PLAYTIME THEN
    'Get the current time
    CurrentTime! = TIMER
    'If midnight has come since the MIDI file started playing, change
    'CurrentTime! accordingly
    IF CurrentTime! - MIDI.PLAYTIME < 0 THEN
        CurrentTime! = 86400 + CurrentTime!
    END IF
    'Get the final result
    TimeMIDI! = CurrentTime! - MIDI.PLAYTIME
    MIDI.ERROR = 0
ELSE
    MIDI.ERROR = 3
END IF
END FUNCTION

SUB TitleOptions

    COLOR 9
    LOCATE 15, 18
    PRINT "BEGIN"
    COLOR 15
    LOCATE 18, 17
    PRINT "RESUME"
    LOCATE 21, 20
    PRINT "END"
    TitleCursor$ = "BEGIN"
    PUT (120, 111), Pointer, PSET
    PCOPY 0, 1
    TEMP% = STICK(0)
   
    DO
        SELECT CASE INKEY$
        CASE CHR$(0) + CHR$(72)
            IF TitleCursor$ = "BEGIN" THEN
                    TitleCursor$ = "END"
                    PUT (120, 163), Pointer, PSET
                    LINE (120, 111)-(130, 118), 0, BF
                    COLOR 15
                    LOCATE 15, 18
                    PRINT "BEGIN"
                    COLOR 9
                    LOCATE 21, 20
                    PRINT "END"
                    PCOPY 0, 1
                ELSEIF TitleCursor$ = "RESUME" THEN
                    TitleCursor$ = "BEGIN"
                    PUT (120, 111), Pointer, PSET
                    LINE (120, 137)-(130, 144), 0, BF
                    COLOR 15
                    LOCATE 18, 17
                    PRINT "RESUME"
                    COLOR 9
                    LOCATE 15, 18
                    PRINT "BEGIN"
                    PCOPY 0, 1
                ELSEIF TitleCursor$ = "END" THEN
                    TitleCursor$ = "RESUME"
                    PUT (120, 137), Pointer, PSET
                    LINE (120, 163)-(130, 170), 0, BF
                    COLOR 15
                    LOCATE 21, 20
                    PRINT "END"
                    COLOR 9
                    LOCATE 18, 17
                    PRINT "RESUME"
                    PCOPY 0, 1
            END IF
        CASE CHR$(0) + CHR$(80)
            IF TitleCursor$ = "BEGIN" THEN
                    TitleCursor$ = "RESUME"
                    PUT (120, 137), Pointer, PSET
                    LINE (120, 111)-(130, 118), 0, BF
                    COLOR 15
                    LOCATE 15, 18
                    PRINT "BEGIN"
                    COLOR 9
                    LOCATE 18, 17
                    PRINT "RESUME"
                    PCOPY 0, 1
                ELSEIF TitleCursor$ = "RESUME" THEN
                    TitleCursor$ = "END"
                    PUT (120, 163), Pointer, PSET
                    LINE (120, 137)-(130, 144), 0, BF
                    COLOR 15
                    LOCATE 18, 17
                    PRINT "RESUME"
                    COLOR 9
                    LOCATE 21, 20
                    PRINT "END"
                    PCOPY 0, 1
                ELSEIF TitleCursor$ = "END" THEN
                    TitleCursor$ = "BEGIN"
                    PUT (120, 111), Pointer, PSET
                    LINE (120, 163)-(130, 170), 0, BF
                    COLOR 15
                    LOCATE 21, 20
                    PRINT "END"
                    COLOR 9
                    LOCATE 15, 18
                    PRINT "BEGIN"
                    PCOPY 0, 1
            END IF
        CASE CHR$(13)
            CALL SaveTemp
            Begin = True
        END SELECT

    LOOP UNTIL Begin

    IF TitleCursor$ = "END" THEN
        COLOR 15
        StopMIDI
        SYSTEM
    END IF

END SUB

SUB TopBar

    LINE (0, 0)-(319, 19), 0, BF
    LINE (0, 0)-(319, 19), 1, B
    LINE (1, 1)-(318, 18), 9, B
    LINE (2, 2)-(317, 17), 1, B

    COLOR 15
    IF BubbaMap = 1 THEN
            PutText 120, 8, "Bubba's Pad"
            Sprite1OnMap = False
        ELSEIF BubbaMap = 2 THEN
            PutText 128, 8, "The Marsh"
            Sprite1OnMap = False
        ELSEIF BubbaMap = 3 THEN
            PutText 128, 8, "The Marsh"
            Sprite1OnMap = True
            DEF SEG = VARSEG(Sprite1U1(0)): BLOAD "scum1.til", VARPTR(Sprite1U1(0))
            DEF SEG = VARSEG(Sprite1U2(0)): BLOAD "scum2.til", VARPTR(Sprite1U2(0))

            DEF SEG = VARSEG(Sprite1U1M(0)): BLOAD "scum1.msk", VARPTR(Sprite1U1M(0))
            DEF SEG = VARSEG(Sprite1U2M(0)): BLOAD "scum2.msk", VARPTR(Sprite1U2M(0))
            Sprite1X = 9: Sprite1Y = 9
            Sprite1Move = 1
            GET (Sprite1X * 20, Sprite1Y * 20)-((Sprite1X * 20) + 19, (Sprite1Y * 20) + 19), Sprite1Back
        ELSEIF BubbaMap = 4 THEN
            PutText 128, 8, "The Market"
            Sprite1OnMap = False
        ELSEIF BubbaMap = 5 THEN
            PutText 88, 8, "Nerdia Castle Gates"
            Sprite1OnMap = False
    END IF

END SUB

