DECLARE SUB printMoveList (L AS ANY)
TYPE four
  live AS INTEGER    'boolean
  score AS INTEGER   '0 to 44
  ready AS INTEGER   '
  side AS INTEGER    'LEFT or RIGHT
END TYPE
TYPE addcell
  who AS INTEGER     'who is in this cell(left,right,empty)
  what AS INTEGER    'what score increment
END TYPE
TYPE cell
  real AS INTEGER
  potL AS INTEGER   'boolean
  potR AS INTEGER   'boolean
  ppotL AS INTEGER  'boolean
  ppotR AS INTEGER  'boolean
  add AS addcell
END TYPE
TYPE col
  state AS INTEGER
  extra AS INTEGER
  calcstate AS INTEGER  'boolean set when state needs to be recalc
  calcadd AS INTEGER    'boolean set when addcell needs to be recalc
  free AS INTEGER       'number of empty cells in this col
END TYPE
TYPE posn
  wt AS INTEGER      '+ is good for Next, - is good for Previous
  wincell AS INTEGER 'a cell in which N can win or if N cant
                     ' then a cell in which P could win
  Ncanwin AS INTEGER 'number of fours where N can win
  Pcanwin AS INTEGER 'number of fours where P can win
  Phaswon AS INTEGER 'boolean
  winnish AS STRING * 1
  WhoisWinning AS INTEGER 'LEFT,RIGHT,or FALSE from winnish analysis
  potwt AS INTEGER   '+ is good for LEFT!!
  ndl AS INTEGER
  ndr AS INTEGER
  ndlr AS INTEGER
  nvr AS INTEGER
  nll AS INTEGER
  nrr AS INTEGER
END TYPE
TYPE pot
  L AS INTEGER 'boolean
  R AS INTEGER 'boolean
END TYPE
TYPE alist
  head AS INTEGER
  tail AS INTEGER
END TYPE
TYPE listitem
  nextl AS INTEGER
  levelcol AS INTEGER
  value AS INTEGER
END TYPE

DEFINT A-Z
DECLARE SUB deleteList (L AS alist)
DECLARE SUB addToTail (L AS alist)
DECLARE SUB appendList (high AS alist, low AS alist)
DECLARE SUB CalcColState (col, poscell() AS cell, poscol() AS col, posn AS posn)
DECLARE FUNCTION CalcPotWt (colstate, colextra)
DECLARE SUB CheckPrdebug (level, depth, prdebug, xbox, ybox)
DECLARE SUB DefineWeights ()
DECLARE SUB EvalBestMove (poscell() AS cell, poscol() AS col, posfour() AS four, posn AS posn, turn, level, depth, value, bestmoves(), movelist AS alist, lb, ub)
DECLARE FUNCTION Fourfound (player, poscell() AS cell, posfour() AS four)
DECLARE SUB GetAutoMove (poscell() AS cell, poscol() AS col, posfour() AS four, posn AS posn, turn, movecell, movecol, depth, advise)
DECLARE SUB GetPlayerMove (poscell() AS cell, poscol() AS col, posfour() AS four, posn AS posn, turn, movecell, movecol)
DECLARE SUB InitDisk (turn)
DECLARE SUB InitFourindex ()
DECLARE SUB lprintmovelist (L AS alist)
DECLARE SUB Lsetaddcell (col, poscell() AS cell, poscol() AS col)
DECLARE SUB Lwinsearch (nsac, poscell() AS cell, poscol() AS col, posfour() AS four, posn AS posn)
DECLARE SUB MakeAMove (poscell() AS cell, poscol() AS col, posfour() AS four, posn AS posn, movecell, movecol, turn, imove)
DECLARE SUB printpot (poscell() AS cell)
DECLARE SUB Rsetaddcell (col, poscell() AS cell, poscol() AS col)
DECLARE SUB Rwinsearch (nsac, poscell() AS cell, poscol() AS col, posfour() AS four, posn AS posn)
DECLARE SUB SetupDiskImages ()
DECLARE SUB SlideDown (ndrop)
DECLARE SUB SlideLeft ()
DECLARE SUB SlideRight ()
DECLARE SUB SortValues (sortcol(), sortval())
DECLARE SUB Updatepos (poscell() AS cell, poscol() AS col, posfour() AS four, posn AS posn, movecell, movecol, turn)
DECLARE SUB Winnishness (poscell() AS cell, poscol() AS col, posfour() AS four, posn AS posn)

CLEAR , , 24000

CONST TRUE = -1
CONST FALSE = NOT TRUE
CONST EMPTY = 0
CONST LEFT = 1
CONST RIGHT = -LEFT
CONST null = 99   'any value not between 0 and 41 will do
CONST DEAD = 99   'any value not between -40 and +40 will do


'now set constants used by winnish calcs
CONST ZVL = 1
CONST ZVR = 2
CONST ZVLR = 4
CONST ZDL = 8
CONST ZDR = 16
CONST ZDLR = 32
CONST ZDDL = 64
CONST ZDDR = 128
CONST ZLL = 256
CONST ZRR = 512

'for Winnishness and setaddcell
DIM SHARED empty0  AS addcell, empty1 AS addcell, left11 AS addcell, right11 AS addcell
empty0.who = EMPTY
empty0.what = 0
empty1.who = EMPTY
empty1.what = 1
left11.who = LEFT
left11.what = 11
right11.who = RIGHT
right11.what = 11

CONST listsize = 7000

DIM SHARED mlist(listsize) AS listitem
FOR i = 1 TO listsize: mlist(i - 1).nextl = i: NEXT i
mlist(listsize).nextl = 0
DIM SHARED freelist AS alist
freelist.head = 1
freelist.tail = listsize
DIM SHARED listside
listside = 0
DIM SHARED Nevalpos AS LONG
DIM SHARED Nesearch AS LONG

DIM SHARED wdebug
DIM SHARED nodebug
nodebug = FALSE
DIM SHARED prlevel(42)
DIM SHARED prbox(42)
FOR L = 0 TO 42
  prlevel(L) = FALSE
  IF L < 14 THEN prbox(L) = L ELSE prbox(L) = 14
NEXT L
wdebug = FALSE

CONST sortlevel = 3

CONST shift = 2
CONST nshift = 14
CONST spacing = nshift * shift
CONST radius = 10
CONST xorig = 640 - 8.5 * spacing
CONST yorig = 480 - 20 - 6.5 * spacing
CONST C0 = 0
CONST Cframe = 9
CONST Cleft1 = 14
CONST Cright1 = 4
'
CONST xmin = xorig
CONST xmax = xorig + 8 * spacing
CONST xl = xorig + .5 * spacing
CONST xr = xl + 7 * spacing
CONST yt = yorig + .5 * spacing
CONST yb = yt + 6 * spacing
DIM SHARED diskcol      'current column of disk for next move
DIM SHARED diskplayer   'player of next move
'
DIM SHARED DiskLeftImage(2000)
DIM SHARED DiskRightImage(2000)
DIM SHARED DiskDownImage(2000)

DIM SHARED player(-1 TO 1) AS STRING

DIM initfour AS four
initfour.live = TRUE
initfour.score = 0

DIM initcell AS cell
initcell.real = EMPTY
initcell.potL = FALSE
initcell.potR = FALSE
initcell.ppotL = FALSE
initcell.ppotR = FALSE
initcell.add = empty0

DIM initcol AS col
initcol.state = 0
initcol.extra = 0
initcol.calcstate = FALSE
initcol.calcadd = FALSE
initcol.free = 6


'
DIM SHARED FourIndex(41, 13)
DIM SHARED CellsOfFour(1 TO 69, 0 TO 3)
InitFourindex
'
DIM SHARED TableOfWeight(0 TO 44) AS INTEGER
DIM SHARED TableOfDeltaTenWt(0 TO 44) AS INTEGER
DIM SHARED TableOfDeltaOneWt(0 TO 44) AS INTEGER
CONST WinWeight = 999
CONST PotWeight = 30
CONST MoveBonus = 20
DefineWeights
'
DIM poscell(41) AS cell
DIM posfour(1 TO 69) AS four
DIM poscol(1 TO 7) AS col
DIM posn AS posn
'
PlayAgain:
'
FOR i = 1 TO 7: poscol(i) = initcol: NEXT i
FOR i = 0 TO 41: poscell(i) = initcell: NEXT i
FOR i = 1 TO 69: posfour(i) = initfour: NEXT i
'
'for each cell on the bottom row
FOR c = 5 TO 41 STEP 6
  'for each four containing this cell increase "ready" by 1
  FOR j = 0 TO 12
    k = FourIndex(c, j)
    IF k = 0 THEN EXIT FOR
    posfour(k).score = posfour(k).score + 1
  NEXT j
NEXT c
'
turn = LEFT  'for first move
'
posn.wt = 0
posn.potwt = 0
posn.wincell = null
posn.Ncanwin = FALSE
posn.Pcanwin = FALSE
posn.Phaswon = FALSE
posn.WhoisWinning = FALSE
posn.winnish = "="
posn.ndl = 0
posn.ndr = 0
posn.ndlr = 0
posn.nvr = 0
posn.nll = 0
posn.nrr = 0
'
CLS
SCREEN 12
'
'Set up who is which player
'
SetupDiskImages
LOCATE 20, 1
PRINT "Do you want two players v each other(2)"
PRINT "        or one player v the computer(1)?"
PRINT
DO: SELECT CASE INKEY$
  CASE "1"
    auto = TRUE: EXIT DO
  CASE "2"
    player(RIGHT) = "human": player(LEFT) = "human": auto = FALSE: EXIT DO
END SELECT: LOOP
IF auto THEN
  PRINT "Do you want to be yellow(y) or red(r)?"
  DO: SELECT CASE INKEY$
    CASE "y", "Y"
      player(LEFT) = "human": player(RIGHT) = "auto": EXIT DO
    CASE "r", "R"
      player(RIGHT) = "human": player(LEFT) = "auto": EXIT DO
  END SELECT: LOOP
  DO
  INPUT "What level for the computer?(number>0 and Enter)"; maxlevel
  LOOP UNTIL maxlevel > 0
END IF
'
'draw frame
'
CLS
LINE (xl - 1, yb)-(xr + 1, yb + 2), Cframe, BF
FOR i = 0 TO 7
  x = xorig + (i + .5) * spacing
  LINE (x - 1, yb)-(x + 1, yt), Cframe, BF
NEXT i
FOR j = 1 TO 6
  y = yorig + (j + .5) * spacing
  LINE (xl, y)-(xr, y), Cframe, , 21845
NEXT j
'
'play upto 42 moves in the game
'
win = 0
FOR imove = 1 TO 42
  InitDisk turn
  IF player(turn) = "human" THEN
    GetPlayerMove poscell(), poscol(), posfour(), posn, turn, movecell, movecol
  ELSE
    IF imove <= 4 AND maxlevel > 2 THEN depth = maxlevel - 2 ELSE depth = maxlevel
    GetAutoMove poscell(), poscol(), posfour(), posn, turn, movecell, movecol, depth, FALSE
  END IF
  MakeAMove poscell(), poscol(), posfour(), posn, movecell, movecol, turn, imove
  IF posn.Phaswon THEN win = -turn: EXIT FOR
NEXT imove
LOCATE 26, 1
IF win = 1 THEN
  PRINT "yellow has won!    ";
ELSEIF win = -1 THEN
  PRINT "   red has won!    ";
ELSE
  PRINT "the game is a draw ";
END IF
PRINT TIME$;
LOCATE 22, 1
PRINT "Do you want to play": PRINT "again(y or n)?";
DO: SELECT CASE INKEY$
  CASE "y", "Y"
    again = TRUE: EXIT DO
  CASE "n", "N"
    again = FALSE: CLS : EXIT DO
  CASE CHR$(27)
     STOP
END SELECT: LOOP
IF again GOTO PlayAgain
END

SUB addToTail (L AS alist)
i = freelist.head: IF i = 0 THEN STOP

freelist.head = mlist(i).nextl
IF L.head = 0 THEN
  L.head = i
ELSE
  mlist(L.tail).nextl = i
END IF
L.tail = i
mlist(i).nextl = 0
END SUB

SUB appendList (high AS alist, low AS alist)
IF high.head = 0 THEN 'high was null
  high = low
ELSEIF low.head <> 0 THEN 'nonempty low list to append
  mlist(high.tail).nextl = low.head
  high.tail = low.tail
END IF
END SUB

SUB CalcColState (col, poscell() AS cell, poscol() AS col, posn AS posn)
'poscell.potL/R                  input:
'poscol(col).state,extra        output:
'poscol(col).calcstate,calcadd  output:
'posn.potwt,ndl,etc             output:
'
' possible state transitions are
'           /VR --DDR
'          /    \_DR+DLR
'         /     \
'        /       >VLR
'       /       /
'      /        /-DL+DLR
'     /   _--VL --DDL          also VL/DL-->LL
'   0 ===<                        & VR/DR-->RR
'     \   \     /-DR+VL
'      \   \    /-DR+VR
'       \   \DR --DR+VLR
'        \      \
'         \      >DLR
'          \    /
'           \DL --DL+VLR
'               \_DL+VR
'               \_DL+VL
'
'
  colstate = 0: colextra = 0
  top = 6 * (col - 1)
  ' look for row with a pot cell
  FOR row = 4 TO 0 STEP -1 'note can't have a pot in row 5
    cell = top + row
    IF poscell(cell).real = EMPTY THEN ' skip nonempty rows
      IF row <> 0 THEN 'check for ZLL or ZRR state
        IF (colstate = 0 OR colstate AND (ZVL OR ZDL)) THEN 'check for ZLL
          IF poscell(cell).potL AND poscell(cell - 1).potL THEN
            colstate = ZLL
            colextra = poscol(col).free - row - 1 'nearness
            EXIT FOR
          END IF
        END IF 'check for ZLL
        IF (colstate = 0 OR colstate AND (ZVR OR ZDR)) THEN 'check for ZRR
          IF poscell(cell).potR AND poscell(cell - 1).potR THEN
            colstate = ZRR
            colextra = poscol(col).free - row - 1 'nearness
            EXIT FOR
          END IF
        END IF 'check for ZRR
      END IF 'row<>0
      ' now do main colstate update,3 cases are  L,R,LR pot
      IF poscell(cell).potL AND poscell(cell).potR THEN   ' LR pot
          IF (cell MOD 2) = 0 THEN 'eVen row
            IF colstate = 0 THEN
              colstate = ZVLR: EXIT FOR
            ELSEIF colstate = ZVL THEN
              colstate = ZVLR: colextra = colextra + LEFT: EXIT FOR
            ELSEIF colstate = ZVR THEN
              colstate = ZVLR: colextra = colextra + RIGHT: EXIT FOR
            ELSEIF colstate = ZDL THEN
              colstate = ZDL + ZVLR: EXIT FOR
            ELSEIF colstate = ZDR THEN
              colstate = ZDR + ZVLR: EXIT FOR
            ELSE
              PRINT "error in colstate setting": STOP
            END IF
          ELSE 'oDd row
            IF colstate = 0 THEN
              colstate = ZDLR: EXIT FOR
            ELSEIF colstate = ZVL THEN
              colstate = ZDL + ZDLR: EXIT FOR
            ELSEIF colstate = ZVR THEN
              colstate = ZDR + ZDLR: EXIT FOR
            ELSEIF colstate = ZDL THEN
              colstate = ZDLR: colextra = colextra + LEFT: EXIT FOR
            ELSEIF colstate = ZDR THEN
              colstate = ZDLR: colextra = colextra + RIGHT: EXIT FOR
            ELSE
              PRINT "error in colstate setting": STOP
            END IF
          END IF 'even/odd
      ELSEIF poscell(cell).potL AND NOT poscell(cell).potR THEN    ' L pot
          IF (cell MOD 2) = 0 THEN 'eVen row
            IF colstate = 0 THEN
              colstate = ZVL
            ELSEIF colstate = ZVL THEN
              colextra = colextra + LEFT
            ELSEIF colstate = ZVR THEN
              colstate = ZVLR: EXIT FOR
            ELSEIF colstate = ZDL THEN
              colstate = ZDL + ZVL
            ELSEIF colstate = ZDR THEN
              colstate = ZDR + ZVL
            ELSE
              PRINT "error in colstate setting": STOP
            END IF
          ELSE 'oDd row
            IF colstate = 0 THEN
              colstate = ZDL
            ELSEIF colstate = ZVL THEN
              colstate = ZDDL: EXIT FOR
            ELSEIF colstate = ZVR THEN
              colextra = colextra + LEFT
            ELSEIF colstate = ZDL THEN
              colextra = colextra + LEFT
            ELSEIF colstate = ZDR THEN
              colstate = ZDLR: EXIT FOR
            ELSE
              PRINT "error in colstate setting": STOP
            END IF
          END IF
      ELSEIF poscell(cell).potR AND NOT poscell(cell).potL THEN     ' R pot
          IF (cell MOD 2) = 0 THEN 'eVen row
            IF colstate = 0 THEN
              colstate = ZVR
            ELSEIF colstate = ZVL THEN
              colstate = ZVLR: EXIT FOR
            ELSEIF colstate = ZVR THEN
              colextra = colextra + RIGHT
            ELSEIF colstate = ZDL THEN
              colstate = ZDL + ZVR
            ELSEIF colstate = ZDR THEN
              colstate = ZDR + ZVR
            ELSE
              PRINT "error in colstate setting": STOP
            END IF
          ELSE 'oDd row
            IF colstate = 0 THEN
              colstate = ZDR
            ELSEIF colstate = ZVL THEN
               colextra = colextra + RIGHT
            ELSEIF colstate = ZVR THEN
              colstate = ZDDR: EXIT FOR
            ELSEIF colstate = ZDL THEN
              colstate = ZDLR: EXIT FOR
            ELSEIF colstate = ZDR THEN
              colextra = colextra + RIGHT
            ELSE
              PRINT "error in colstate setting": STOP
            END IF
          END IF
      END IF ' the check for L,R,LR pot
    END IF 'empty/full row
  NEXT row
IF poscol(col).state <> colstate THEN  ' colstate has changed
  'increment counts based on new state
  IF (colstate AND ZDL) THEN
    posn.ndl = posn.ndl + 1
  ELSEIF (colstate AND ZDDL) THEN
    posn.ndl = posn.ndl + 2
  ELSEIF (colstate AND ZDR) THEN
    posn.ndr = posn.ndr + 1
  ELSEIF (colstate AND ZDDR) THEN
    posn.ndr = posn.ndr + 2
  END IF
  IF (colstate AND ZDLR) THEN posn.ndlr = posn.ndlr + 1
  IF (colstate AND (ZVR OR ZVLR)) THEN posn.nvr = posn.nvr + 1
  IF (colstate AND ZLL) THEN posn.nll = posn.nll + 1
  IF (colstate AND ZRR) THEN posn.nrr = posn.nrr + 1
  'decrement counts based on old state
  oldstate = poscol(col).state
  IF (oldstate AND ZDL) THEN
    posn.ndl = posn.ndl - 1
  ELSEIF (oldstate AND ZDDL) THEN
    posn.ndl = posn.ndl - 2
  ELSEIF (oldstate AND ZDR) THEN
    posn.ndr = posn.ndr - 1
  ELSEIF (oldstate AND ZDDR) THEN
    posn.ndr = posn.ndr - 2
  END IF
  IF (oldstate AND ZDLR) THEN posn.ndlr = posn.ndlr - 1
  IF (oldstate AND (ZVR OR ZVLR)) THEN posn.nvr = posn.nvr - 1
  IF (oldstate AND ZLL) THEN posn.nll = posn.nll - 1
  IF (oldstate AND ZRR) THEN posn.nrr = posn.nrr - 1
  'update potwt
  posn.potwt = posn.potwt + CalcPotWt(colstate, colextra) - CalcPotWt(poscol(col).state, poscol(col).extra)
  '***potwt for ZLL/ZRR uses colextra as nearness
  poscol(col).state = colstate
  poscol(col).extra = colextra
ELSEIF poscol(col).extra <> colextra THEN 'only colextra has changed
  'update potwt
  posn.potwt = posn.potwt + CalcPotWt(colstate, colextra) - CalcPotWt(poscol(col).state, poscol(col).extra)
  poscol(col).extra = colextra
END IF
poscol(col).calcstate = FALSE 'since just done it
' now need to recalc addcells(even if state is same,since pot has changed
poscol(col).calcadd = TRUE
END SUB

FUNCTION CalcPotWt (colstate, colextra)
IF colstate = ZLL THEN
  CalcPotWt = 420 \ colextra
ELSEIF colstate = ZRR THEN
  CalcPotWt = -420 \ colextra
ELSE
  IF colstate AND ZDL THEN     'includes DL+DLR
    potwt = 40
  ELSEIF colstate AND ZDR THEN 'includes DL+DLR
    potwt = -40
  ELSEIF colstate = ZDDL THEN
    potwt = 80
  ELSEIF colstate = ZDDR THEN
    potwt = -80
  ELSE                         'includes DLR
    potwt = 0
  END IF
  IF colstate AND ZVL THEN potwt = potwt + 10
  IF colstate AND ZVR THEN potwt = potwt - 20
  IF colstate AND ZVLR THEN potwt = potwt - 10
  CalcPotWt = potwt + 4 * colextra
END IF
END FUNCTION

SUB CheckPrdebug (level, depth, prdebug, xbox, ybox)
'level     input: the eval level
'depth     input:used to decide if to switch print on
'prdebug  output: whether to print for this level
'xbox     output: one less than first print row
'ybox     output: one less than first print column


prdebug = (depth >= 2) OR wdebug
IF nodebug THEN prdebug = FALSE
IF prdebug THEN
  xbox = 9 * (prbox(level) \ 6)
  ybox = 3 + 13 * (prbox(level) MOD 6)
END IF
END SUB

SUB DefineWeights
TableOfWeight(44) = WinWeight
TableOfWeight(34) = 20
TableOfWeight(33) = 18
TableOfWeight(24) = 20
TableOfWeight(23) = 18
TableOfWeight(22) = 16
TableOfWeight(14) = 7
TableOfWeight(13) = 6
TableOfWeight(12) = 5
TableOfWeight(11) = 4
TableOfDeltaTenWt(44) = TableOfWeight(44) - TableOfWeight(34)
TableOfDeltaTenWt(34) = TableOfWeight(34) - TableOfWeight(24)
TableOfDeltaTenWt(33) = TableOfWeight(33) - TableOfWeight(23)
TableOfDeltaTenWt(24) = TableOfWeight(24) - TableOfWeight(14)
TableOfDeltaTenWt(23) = TableOfWeight(23) - TableOfWeight(13)
TableOfDeltaTenWt(22) = TableOfWeight(22) - TableOfWeight(12)
TableOfDeltaTenWt(14) = TableOfWeight(14)
TableOfDeltaTenWt(13) = TableOfWeight(13)
TableOfDeltaTenWt(12) = TableOfWeight(12)
TableOfDeltaTenWt(11) = TableOfWeight(11)
TableOfDeltaOneWt(34) = TableOfWeight(34) - TableOfWeight(33)
TableOfDeltaOneWt(24) = TableOfWeight(24) - TableOfWeight(23)
TableOfDeltaOneWt(23) = TableOfWeight(23) - TableOfWeight(22)
TableOfDeltaOneWt(14) = TableOfWeight(14) - TableOfWeight(13)
TableOfDeltaOneWt(13) = TableOfWeight(13) - TableOfWeight(12)
TableOfDeltaOneWt(12) = TableOfWeight(12) - TableOfWeight(11)
END SUB

SUB deleteList (L AS alist)
IF L.head <> 0 THEN
  mlist(L.tail).nextl = freelist.head
  freelist.head = L.head
END IF
END SUB

SUB EvalBestMove (poscell() AS cell, poscol() AS col, posfour() AS four, posn AS posn, turn, level, depth, value, bestmoves(), movelist AS alist, lb, ub)
'pos        input: position prior to moves
'turn       input: next to play at pos
'level      input: current number of moves from top of search
'depth      input: depth of search from here down
'value     output: forecast value +good for next to play at pos
'bestmoves output: move sequence giving best value,-1 ends seq.
'movelist  output: xxx
'lb         input: lower bound on search
'ub         input: upper bound on search

'This function searches forward from pos to determine a value for the
'position.  The value is only computed exactly if
'                 lb <= value of position <= ub
'if value<=lb then true value of position maybe < value
'if value>=ub then true value of position maybe > value
 
DIM newposn AS posn
DIM newmovelist AS alist
movelist.head = 0
IF INKEY$ = CHR$(27) THEN STOP
CheckPrdebug level, depth, prdebug, xbox, ybox
IF prdebug THEN
  FOR c = 1 TO 9
    LOCATE xbox + c, ybox: PRINT SPACE$(13);
  NEXT c
  LOCATE xbox + 8, ybox + 1: PRINT USING "L#####U#####"; lb; ub;
  LOCATE xbox + 9, ybox + 1: PRINT USING "## ##"; level; depth;
END IF
IF posn.Phaswon THEN
  'This shouldn't occur as we don't Eval already won positions
  value = -WinWeight
  PRINT "error in Eval": STOP
ELSEIF posn.Ncanwin THEN 'no need to search
  value = WinWeight
  bestmoves(level) = posn.wincell
  bestmoves(level + 1) = -1
ELSEIF posn.Pcanwin THEN 'only search with forced move
  DIM newposcol(1 TO 7) AS col
  DIM newposcell(41) AS cell
  DIM newposfour(1 TO 69) AS four
  DIM mm(42)
  move = posn.wincell: col = (move \ 6) + 1
  IF prdebug THEN LOCATE xbox + col, ybox + 1: PRINT USING "F#M## "; col; move;
  newposn = posn
  FOR i = 1 TO 7: newposcol(i) = poscol(i): NEXT i
  FOR i = 0 TO 41: newposcell(i) = poscell(i): NEXT i
  FOR i = 1 TO 69: newposfour(i) = posfour(i): NEXT i
  Nevalpos = Nevalpos + 1
  Updatepos newposcell(), newposcol(), newposfour(), newposn, move, col, turn
  EvalBestMove newposcell(), newposcol(), newposfour(), newposn, -turn, level + 1, depth, newv, mm(), newmovelist, -ub, -lb
  value = -newv
  CALL addToTail(movelist)
  mlist(movelist.tail).levelcol = level * 8 + col
  mlist(movelist.tail).value = value
  CALL appendList(movelist, newmovelist)
  bestmoves(level) = move
  FOR i = level + 1 TO 42
    bestmoves(i) = mm(i)
    IF mm(i) = -1 THEN EXIT FOR
  NEXT i
  IF prdebug THEN LOCATE xbox + col, ybox + 7: PRINT USING "V#####"; value;
ELSEIF (level > 0) AND (posn.WhoisWinning <> 0) THEN
  'if Someone is Winning don't search,need level>0 so there's a best next move
  IF posn.WhoisWinning = turn THEN value = WinWeight ELSE value = -WinWeight
  bestmoves(level) = -1
  CALL addToTail(movelist)
  mlist(movelist.tail).levelcol = level * 8 + 0
  mlist(movelist.tail).value = value
  CALL appendList(movelist, newmovelist)
ELSEIF (depth = 0) THEN
  'This is a stopping level
  IF turn = LEFT THEN potwt = posn.potwt ELSE potwt = -posn.potwt
  value = posn.wt + potwt + MoveBonus
  bestmoves(level) = -1
ELSE 'Search over all possible next moves
  DIM newposcol(1 TO 7) AS col
  DIM newposcell(41) AS cell
  DIM newposfour(1 TO 69) AS four
  DIM mm(42)
  IF depth >= 3 THEN
    'first do a lower level search to find the best candidate moves and sort
    'into order so the best moves are tried first
    DIM sortcol(7), sortval(7), sortdepth(7)
    FOR col = 1 TO 7
      sortcol(col) = col
      IF poscol(col).free THEN
        move = 6 * (col - 1) + poscol(col).free - 1
        newposn = posn
        FOR i = 1 TO 7: newposcol(i) = poscol(i): NEXT i
        FOR i = 0 TO 41: newposcell(i) = poscell(i): NEXT i
        FOR i = 1 TO 69: newposfour(i) = posfour(i): NEXT i
        Nevalpos = Nevalpos + 1
        Updatepos newposcell(), newposcol(), newposfour(), newposn, move, col, turn
        'minidepth is the depth including this stage
        minidepth = (depth - 1) \ 2' or try max{(depth-1)\2,depth-4}
        EvalBestMove newposcell(), newposcol(), newposfour(), newposn, -turn, level + 1, minidepth - 1, vtest, mm(), newmovelist, -WinWeight, WinWeight
        CALL deleteList(newmovelist)
        sortval(col) = -vtest
        IF prdebug THEN LOCATE xbox + col, ybox + 1: PRINT USING "#####"; -vtest;
      ELSE 'no legal move in this col
        sortval(col) = -1 - WinWeight'puts illegal moves at bottom of sorted list
      END IF
    NEXT col
    SortValues sortcol(), sortval()
    FOR i = 1 TO 7
      sortdepth(i) = depth
      IF sortval(i) = WinWeight OR sortval(i) = -WinWeight THEN sortdepth(i) = minidepth
    NEXT i
    sorted = TRUE
  ELSE
    sorted = FALSE
  END IF
  MaxValSoFar = -1 - WinWeight
  FOR icol = 1 TO 7  'for each possible nextmove,m,in preferred order if sorted
    IF sorted THEN
      col = sortcol(icol)
      newdepth = sortdepth(icol)
    ELSE
      col = icol
      newdepth = depth
    END IF
    IF poscol(col).free THEN
      move = 6 * (col - 1) + poscol(col).free - 1
      IF prdebug THEN LOCATE xbox + col, ybox + 1: PRINT USING "C#M## "; col; move;
      newposn = posn
      FOR i = 1 TO 7: newposcol(i) = poscol(i): NEXT i
      FOR i = 0 TO 41: newposcell(i) = poscell(i): NEXT i
      FOR i = 1 TO 69: newposfour(i) = posfour(i): NEXT i
      Nevalpos = Nevalpos + 1
      Updatepos newposcell(), newposcol(), newposfour(), newposn, move, col, turn
      IF MaxValSoFar > lb THEN newub = -MaxValSoFar ELSE newub = -lb
      IF newdepth <> 0 THEN newdepth = newdepth - 1
      EvalBestMove newposcell(), newposcol(), newposfour(), newposn, -turn, level + 1, newdepth, newv, mm(), newmovelist, -ub, newub
        'here v+is good for N(newpos) so v- is good for P(newpos)=N(pos)
        v = -newv
      IF prdebug THEN LOCATE xbox + col, ybox + 7: PRINT USING "V#####"; v;
      IF level MOD 2 <> listside THEN
        CALL addToTail(movelist)
        mlist(movelist.tail).levelcol = level * 8 + col
        mlist(movelist.tail).value = v
        CALL appendList(movelist, newmovelist)
      END IF
      IF v > MaxValSoFar THEN
        MaxValSoFar = v
        bestmoves(level) = move
        FOR i = level + 1 TO 42
          bestmoves(i) = mm(i)
          IF mm(i) = -1 THEN EXIT FOR
        NEXT i
        IF level MOD 2 = listside THEN
          CALL deleteList(movelist)
          movelist.head = 0
          CALL addToTail(movelist)
          mlist(movelist.tail).levelcol = level * 8 + col
          mlist(movelist.tail).value = v
          CALL appendList(movelist, newmovelist)
        END IF
        IF (v >= ub) THEN EXIT FOR
      ELSE
        IF level MOD 2 = listside THEN CALL deleteList(newmovelist)
      END IF
    END IF
  NEXT icol
  value = MaxValSoFar
  IF value = -1 - WinWeight THEN 'there were no moves so it's a draw
    value = 0
    bestmoves(level) = -1
  END IF
END IF 'We've dealt with all cases
IF prdebug THEN
  LOCATE xbox + 9, ybox + 6: PRINT USING "V#####"; value;
  IF value > ub THEN LOCATE xbox + 9, ybox + 12: PRINT ">";
  IF value < lb THEN LOCATE xbox + 9, ybox + 12: PRINT "<";
END IF

IF wdebug THEN
LOCATE 29, 21: PRINT "  waiting";
DO
  SELECT CASE INKEY$
  CASE CHR$(27)
    STOP
  CASE ""
    'keep waiting
  CASE ELSE
    EXIT DO
  END SELECT
LOOP
LOCATE 29, 21: PRINT "computing";
END IF
END SUB

FUNCTION Fourfound (player, poscell() AS cell, posfour() AS four)
'determine if pos real+add gives a win for player if he plays next
'player input:which player(L or R) are we looking to find a four
'
STATIC ksave  AS INTEGER
IF Nesearch = 0 THEN ksave = 1
Nesearch = Nesearch + 1
Fourfound = FALSE
FOR kk = 0 TO 69
  IF kk = 0 THEN k = ksave ELSE k = kk
  IF posfour(k).live THEN
    score = posfour(k).score
    IF score < 10 OR posfour(k).side = player THEN 'it may be good for player
      FOR c = 0 TO 3
        cell = CellsOfFour(k, c)
        IF poscell(cell).real = EMPTY THEN 'we only need to deal with cells that aren't filled yet
          IF poscell(cell).add.who = -player THEN 'this four no good for player
             score = 0: EXIT FOR
          ELSE 'who =player or empty
            score = score + poscell(cell).add.what
          END IF
        END IF'empty
      NEXT c
      IF score >= 34 THEN Fourfound = TRUE: ksave = k: EXIT FUNCTION
    END IF
  END IF'live
NEXT kk
END FUNCTION

SUB GetAutoMove (poscell() AS cell, poscol() AS col, posfour() AS four, posn AS posn, turn, movecell, movecol, depth, advise)
'pos        input: current position
'turn       input: who is about to move
'movecell   output: the move
'movecol    output: the column of the move
'depth   input: the search level
'
DIM goodmoves(42)
DIM movelist AS alist
IF posn.Ncanwin THEN
  movecell = posn.wincell
ELSEIF posn.Pcanwin AND NOT advise THEN
  movecell = posn.wincell
ELSE
  Nevalpos = 0
  Nesearch = 0
  starttime! = TIMER
  EvalBestMove poscell(), poscol(), posfour(), posn, turn, 0, depth, value, goodmoves(), movelist, -WinWeight, WinWeight
  movecell = goodmoves(0)
  totaltime = TIMER - starttime!
  LOCATE 1, 1
  FOR i = 0 TO 28
    PRINT USING "##"; goodmoves(i)
    IF goodmoves(i) = -1 THEN EXIT FOR
  NEXT i
  LOCATE 30, 1: PRINT SPACE$(45); : LOCATE 30, 1
  PRINT "val"; value; "Nevals"; Nevalpos; "Time"; totaltime; "s";
  PRINT USING " at###ms"; 1000! * totaltime / Nevalpos;
  deleteList movelist
END IF
movecol = (movecell \ 6) + 1
END SUB

SUB GetPlayerMove (poscell() AS cell, poscol() AS col, posfour() AS four, posn AS posn, turn, movecell, movecol)
'pos         input: current position
'turn        input: who is about to move
'movecell    output: the move       
'movecol     output: the column of the move

LeftArrow$ = CHR$(0) + CHR$(75)
RightArrow$ = CHR$(0) + CHR$(77)
DownArrow$ = CHR$(0) + CHR$(80)
F1$ = CHR$(0) + CHR$(59)
F2$ = CHR$(0) + CHR$(60)
escape$ = CHR$(27)

DIM newposn AS posn
DIM newposcol(1 TO 7) AS col
DIM newposcell(41) AS cell
DIM newposfour(1 TO 69) AS four
DIM mm(42)

DO 'until escape or slide down
  SELECT CASE INKEY$
  CASE LeftArrow$
    SlideLeft
  CASE RightArrow$
    SlideRight
  CASE DownArrow$
    IF diskcol = 0 OR diskcol = 8 THEN
      BEEP
    ELSEIF poscol(diskcol).free = 0 THEN
      BEEP
    ELSE
      movecol = diskcol
      movecell = 6 * (movecol - 1) + poscol(movecol).free - 1
      EXIT DO
    END IF
  CASE F1$
    DO
      LOCATE 28, 1: PRINT SPACE$(40): LOCATE 28, 1: INPUT "search level"; depth
    LOOP UNTIL depth > 0
    GetAutoMove poscell(), poscol(), posfour(), posn, turn, movecell, movecol, depth, TRUE
    LOCATE 28, 19:  PRINT "try col"; movecol;
  CASE F2$
    IF diskcol = 0 OR diskcol = 8 THEN
      BEEP
    ELSEIF poscol(diskcol).free = 0 THEN
      BEEP
    ELSE
      DO
        LOCATE 28, 1: PRINT "col"; diskcol; SPACE$(34); : LOCATE 28, 7: INPUT "search level"; depth
      LOOP UNTIL depth > 0
      movecol = diskcol
      movecell = 6 * (movecol - 1) + poscol(movecol).free - 1
      newposn = posn
      FOR i = 1 TO 7: newposcol(i) = poscol(i): NEXT i
      FOR i = 0 TO 41: newposcell(i) = poscell(i): NEXT i
      FOR i = 1 TO 69: newposfour(i) = posfour(i): NEXT i
      Updatepos newposcell(), newposcol(), newposfour(), newposn, movecell, movecol, turn
      GetAutoMove newposcell(), newposcol(), newposfour(), newposn, -turn, amovecell, amovecol, depth, TRUE
      LOCATE 28, 24:  PRINT "val "; "is"; " ??";
    END IF
  CASE escape$
    STOP
  CASE ELSE 'ignore
  END SELECT
LOOP
END SUB

SUB InitDisk (turn)
  IF turn = LEFT THEN
    C1 = Cleft1
    diskcol = 0
  ELSE
    C1 = Cright1
    diskcol = 8
  END IF
  diskplayer = turn
  x = xorig + diskcol * spacing
  y = yorig
  CIRCLE (x, y), radius, C1
  PAINT (x, y), C1, C1
END SUB

SUB InitFourindex
'start with no fours for every cell
FOR cell = 0 TO 41
  FourIndex(cell, 0) = 0
NEXT cell
'remember the cells are numbered like this
'
'      0   6  12  18  24  30  36
'      1   7  13  19  25  31  37
'      2   8  14  20  26  32  38
'      3   9  15  21  27  33  39
'      4  10  16  22  28  34  40
'      5  11  17  23  29  35  41
'
ifour = 0 'this is the id of a set of four cells
          'add 1 each time so start just before the first
'do vertical fours
FOR col = 0 TO 6
  FOR i = 0 TO 2
    ifour = ifour + 1
    FOR c = 0 TO 3 'do all 4 cells in the four
      cell = 6 * col + i + c
      CellsOfFour(ifour, c) = cell
      FOR j = 0 TO 12
        'find the first unallocated fourindex for this cell and set it
        IF FourIndex(cell, j) = 0 THEN
          FourIndex(cell, j) = ifour
          FourIndex(cell, j + 1) = 0
          EXIT FOR
        ELSE 'do nothing
        END IF
      NEXT j
    NEXT c
  NEXT i
NEXT col
'do horizontal fours
FOR row = 0 TO 5
  FOR i = 0 TO 3
    ifour = ifour + 1
    FOR c = 0 TO 3 'do all 4 cells in the four
      cell = 6 * (i + c) + row
      CellsOfFour(ifour, c) = cell
      FOR j = 0 TO 12
        'find the first unallocated fourindex for this cell and set it
        IF FourIndex(cell, j) = 0 THEN
          FourIndex(cell, j) = ifour
          FourIndex(cell, j + 1) = 0
          EXIT FOR
        ELSE 'do nothing
        END IF
      NEXT j
    NEXT c
  NEXT i
NEXT row
'do slant\ fours
FOR row = 0 TO 2
  FOR col = 0 TO 3
    ifour = ifour + 1
    FOR c = 0 TO 3 'do all 4 cells in the four
      cell = row + 6 * col + 7 * c
      CellsOfFour(ifour, c) = cell
      FOR j = 0 TO 12
        'find the first unallocated fourindex for this cell and set it
        IF FourIndex(cell, j) = 0 THEN
          FourIndex(cell, j) = ifour
          FourIndex(cell, j + 1) = 0
          EXIT FOR
        ELSE 'do nothing
        END IF
      NEXT j
    NEXT c
  NEXT col
NEXT row
'do slant/ fours
FOR row = 3 TO 5
  FOR col = 0 TO 3
    ifour = ifour + 1
    FOR c = 0 TO 3 'do all 4 cells in the four
      cell = row + 6 * col + 5 * c
      CellsOfFour(ifour, c) = cell
      FOR j = 0 TO 12
        'find the first unallocated fourindex for this cell and set it
        IF FourIndex(cell, j) = 0 THEN
          FourIndex(cell, j) = ifour
          FourIndex(cell, j + 1) = 0
          EXIT FOR
        ELSE 'do nothing
        END IF
      NEXT j
    NEXT c
  NEXT col
NEXT row
END SUB

SUB lprintmovelist (L AS alist)
LOCATE 29, 1: INPUT ; "filename"; f$: f$ = "\user\mike\" + f$
OPEN f$ FOR OUTPUT AS #1
k = 1: oldlevel = -1: j = L.head
DO WHILE j <> 0
  IF mlist(j).levelcol \ 8 <= oldlevel THEN
    k = k + 1: PRINT #1,
  END IF
  PRINT #1, USING "#"; TAB(1 + (mlist(j).levelcol \ 8) * 6); mlist(j).levelcol MOD 8;
  PRINT #1, USING "#### "; mlist(j).value;
  oldlevel = mlist(j).levelcol \ 8
  j = mlist(j).nextl
LOOP
PRINT #1,
CLOSE #1
END SUB

SUB Lsetaddcell (col, poscell() AS cell, poscol() AS col)
'poscol(col).state,full     input
'poscell.potL,potR          input 'only for cells in this col
'poscell.add               output 'only for cells in this col

'beware! cell.add only set if poscell is empty
'

IF poscol(col).free <> 0 THEN 'ignore full columns
  top = 6 * (col - 1)
  colfree = top + poscol(col).free
'
  SELECT CASE poscol(col).state
  CASE 0, ZVR
    cell = top
'
  CASE ZDL TO ZDL + ZVLR, ZDL + ZDLR, ZDLR, ZDDL, ZVL, ZVLR
    'find lowest potL cell
    FOR cell = colfree - 1 TO top STEP -1
      IF poscell(cell).potL THEN EXIT FOR 'must exit for some cell
    NEXT cell
    potLcell = cell
    FOR cell = top TO potLcell: poscell(cell).add = empty0: NEXT cell
    cell = potLcell + 1
    poscell(cell).add = empty1
    cell = cell + 1
'
  CASE ZDR TO ZDR + ZVLR, ZDR + ZDLR
    'find lowest potR cell
    FOR cell = colfree - 1 TO top STEP -1
      IF poscell(cell).potR THEN EXIT FOR 'must exit for some cell
    NEXT cell
    potRcell = cell 'must be row 1,3 or 4
    IF potRcell - 1 > top THEN 'row 3 or 4
      IF poscell(potRcell - 2).potR THEN
        poscell(potRcell - 3).add = right11
        poscell(potRcell - 2).add = left11
      ELSEIF poscell(potRcell - 3).potL THEN
        poscell(potRcell - 3).add = empty0
        poscell(potRcell - 2).add = empty1
      ELSE  'which can only be if potRcell is row 3
        poscell(potRcell - 3).add = left11
        poscell(potRcell - 2).add = right11
      END IF
    END IF
    poscell(potRcell - 1).add = right11
    poscell(potRcell).add = left11
    poscell(potRcell + 1).add = right11
    cell = potRcell + 2
'
  CASE ZDDR
    poscell(top).add = right11
    poscell(top + 1).add = left11
    poscell(top + 2).add = right11
    poscell(top + 3).add = right11
    poscell(top + 4).add = left11
    poscell(top + 5).add = right11
    cell = top + 6
'
  END SELECT
  ' now cell =highest cell not yet "added",fill these in LR pairs
  ' and the odd one,if present, with R
  DO WHILE colfree >= cell + 2
    poscell(cell).add = left11
    poscell(cell + 1).add = right11
    cell = cell + 2
  LOOP
  IF colfree > cell THEN 'must be the odd one
    poscell(cell).add = right11
    cell = cell + 1
  END IF
  IF cell <> colfree THEN PRINT "error in addcell": STOP
  'finally subtract 1 from lowest empty cell since it was already "ready"
  poscell(colfree - 1).add.what = poscell(colfree - 1).add.what - 1
END IF'ignore full columns
END SUB

SUB Lwinsearch (nsac, poscell() AS cell, poscol() AS col, posfour() AS four, posn AS posn)
'nsac               input: number of cols to sac
'posfour            input: to pass to Fourfound
'poscell.real,add,potL input:
'poscol.state       input:
'posn.WhoisWinning  in/output: FALSE on input

DIM savecell(5) AS addcell
IF nsac = 0 THEN
  IF NOT Fourfound(RIGHT, poscell(), posfour()) THEN posn.WhoisWinning = LEFT
ELSE 'nsac =1
  FOR col = 1 TO 7
    colstate = poscol(col).state
    IF colstate AND (ZDL OR ZDDL) THEN ' col contains DL then sac it!
      'first save addcells of this col to restore later
      top = 6 * (col - 1)
      FOR row = 0 TO 5: savecell(row) = poscell(top + row).add: NEXT row
      'now modify addcells according to state
      IF colstate = ZDL OR colstate = ZDL + ZVR THEN
        IF NOT poscell(top + 3).potL THEN 'special case
          poscell(top).add = left11
          poscell(top + 1).add = right11
          poscell(top + 2).add = left11
          IF poscell(top + 3).real = EMPTY THEN
            poscell(top + 3).add.who = RIGHT
            'note A) don't tamper with "what"
            'note B) if poscell(top+4&/or5)empty then addcell4&or5 is already RIGHT
          ELSE
            poscell(top + 2).add.what = 10
          END IF
        ELSE
          poscell(top).add = left11
          poscell(top + 1).add = right11
          poscell(top + 2).add = left11
          poscell(top + 3).add = right11
          poscell(top + 4).add = left11
          IF poscell(top + 5).real <> EMPTY THEN poscell(top + 4).add.what = 10
          'if empty then addcell(top+5) already ok
        END IF
      ELSEIF colstate = ZDL + ZVL THEN
        poscell(top).add = empty0
        poscell(top + 1).add = empty1
        poscell(top + 2).add = left11
        poscell(top + 3).add = right11
        poscell(top + 4).add = left11
        IF poscell(top + 5).real <> EMPTY THEN poscell(top + 4).add.what = 10
        'if empty then addcell(top+5) already ok
      ELSEIF colstate = ZDDL OR colstate = ZDL + ZDLR THEN
        poscell(top).add = empty0
        poscell(top + 1).add = empty0
        poscell(top + 2).add = empty1
        poscell(top + 3).add = left11
        poscell(top + 4).add = right11
        poscell(top + 5).add = left11
      ELSE
        STOP 'error no other case
      END IF
      'now check if this sac wins for L
      IF NOT Fourfound(RIGHT, poscell(), posfour()) THEN
        posn.WhoisWinning = LEFT
        'reset addcell for this col
        FOR row = 0 TO 5: poscell(top + row).add = savecell(row): NEXT row
        EXIT FOR
      END IF
      'reset addcell for this col
      FOR row = 0 TO 5: poscell(top + row).add = savecell(row): NEXT row
    END IF 'col contains DL
  NEXT col
END IF 'nsac=0/1
END SUB

SUB MakeAMove (poscell() AS cell, poscol() AS col, posfour() AS four, posn AS posn, movecell, movecol, turn, imove)
  DO UNTIL diskcol = movecol
    IF diskcol < movecol THEN SlideRight ELSE SlideLeft
    FOR iii = 1 TO 5000: jjj = 99: NEXT iii
  LOOP
  SlideDown poscol(movecol).free
  Updatepos poscell(), poscol(), posfour(), posn, movecell, movecol, turn
  LOCATE 19 + (imove - 1) \ 4, 40 + ((imove - 1) MOD 4) * 3: PRINT USING "###"; movecell;
  LOCATE 30, 41: PRINT SPACE$(39); : LOCATE 30, 41
  IF posn.Phaswon THEN
    'nothing
  ELSEIF posn.Ncanwin THEN
    PRINT " winning move is "; posn.wincell;
    PRINT "in col"; (posn.wincell \ 6) + 1;
  ELSEIF posn.Pcanwin THEN
    PRINT "  forced move is "; posn.wincell;
    PRINT "in col"; (posn.wincell \ 6) + 1;
  ELSE
    value = posn.wt + MoveBonus
    IF turn = LEFT THEN value = -value
    value = value + posn.potwt
    PRINT "LV"; value; 'from LEFT's view
    PRINT posn.winnish;
    PRINT USING "##"; posn.WhoisWinning;
    PRINT " NDL,DR,DLR,VR"; posn.ndl; posn.ndr; posn.ndlr; posn.nvr;
  END IF
  turn = -turn
END SUB

SUB printMoveList (L AS alist)
FOR k = 1 TO 16: LOCATE k, 1: PRINT SPACE$(80); : NEXT k
VIEW PRINT 1 TO 16
k = 1: oldlevel = -1: j = L.head
DO WHILE j <> 0
  IF mlist(j).levelcol \ 8 <= oldlevel THEN
    k = k + 1: PRINT
    IF k = 9 THEN
      DO
        SELECT CASE INKEY$
        CASE CHR$(27)
          STOP
        CASE ""
          'keep waiting
        CASE ELSE
          EXIT DO
        END SELECT
      LOOP
      k = 1
    END IF
  END IF
  PRINT USING "#"; TAB(1 + (mlist(j).levelcol \ 8) * 6); mlist(j).levelcol MOD 8;
  PRINT USING "#### "; mlist(j).value;
  oldlevel = mlist(j).levelcol \ 8
  j = mlist(j).nextl
LOOP
PRINT
VIEW PRINT
END SUB

SUB printpot (poscell() AS cell)
FOR i = 0 TO 6
FOR j = 0 TO 5
  LOCATE 1 + j, 6 * (i + 1)
  PRINT USING "#"; -poscell(6 * i + j).ppotL;
  PRINT USING "#"; -poscell(6 * i + j).potL;
  PRINT USING "#"; -poscell(6 * i + j).ppotR;
  PRINT USING "#"; -poscell(6 * i + j).potR;
NEXT j
NEXT i
END SUB

SUB Rsetaddcell (col, poscell() AS cell, poscol() AS col)
'poscol(col).state,full     input
'poscell.potL,potR          input 'only for cells in this col
'poscell.add               output 'only for cells in this col

'beware! cell.add only set if poscell is empty
'
IF poscol(col).free <> 0 THEN 'ignore full columns
  top = 6 * (col - 1)
  colfree = top + poscol(col).free
'
  SELECT CASE poscol(col).state
  CASE 0, ZVL
    cell = top
'
  CASE ZDR TO ZDR + ZVLR, ZDR + ZDLR, ZDLR, ZDDR, ZVR, ZVLR
    'find lowest potR cell
    FOR cell = colfree - 1 TO top STEP -1
      IF poscell(cell).potR THEN EXIT FOR 'must exit for some cell
    NEXT cell
    potRcell = cell
    FOR cell = top TO potRcell: poscell(cell).add = empty0: NEXT cell
    cell = potRcell + 1
    poscell(cell).add = empty1
    cell = cell + 1
'
  CASE ZDL TO ZDL + ZVLR, ZDL + ZDLR
    'find lowest potL cell
    FOR cell = colfree - 1 TO top STEP -1
      IF poscell(cell).potL THEN EXIT FOR 'must exit for some cell
    NEXT cell
    potLcell = cell 'must be row 1,3 or 4
    IF potLcell - 1 > top THEN 'row 3 or 4
      IF poscell(potLcell - 2).potL THEN
        poscell(potLcell - 3).add = left11
        poscell(potLcell - 2).add = right11
      ELSEIF poscell(potLcell - 3).potR THEN
        poscell(potLcell - 3).add = empty0
        poscell(potLcell - 2).add = empty1
      ELSE  'which can only be if potLcell is row 3
        poscell(potLcell - 3).add = right11
        poscell(potLcell - 2).add = left11
      END IF
    END IF
    poscell(potLcell - 1).add = left11
    poscell(potLcell).add = right11
    poscell(potLcell + 1).add = left11
    cell = potLcell + 2
'
  CASE ZDDL
    poscell(top).add = left11
    poscell(top + 1).add = right11
    poscell(top + 2).add = left11
    poscell(top + 3).add = left11
    poscell(top + 4).add = right11
    poscell(top + 5).add = left11
    cell = top + 6
'
  END SELECT
  ' now cell =highest cell not yet "added",fill these in RL pairs
  ' and the odd one,if present, with L
  DO WHILE colfree >= cell + 2
    poscell(cell).add = right11
    poscell(cell + 1).add = left11
    cell = cell + 2
  LOOP
  IF colfree > cell THEN 'must be the odd one
    poscell(cell).add = left11
    cell = cell + 1
  END IF
  IF cell <> colfree THEN PRINT "error in addcell": STOP
  'finally subtract 1 from lowest empty cell since it was already "ready"
  poscell(colfree - 1).add.what = poscell(colfree - 1).add.what - 1
END IF'ignore full columns
END SUB

SUB Rwinsearch (nsac, poscell() AS cell, poscol() AS col, posfour() AS four, posn AS posn)
'nsac               input: number of cols to sac
'posfour            input: to pass to Fourfound
'poscell.real,add,potR input:
'poscol.state       input:
'posn.WhoisWinning  in/output: FALSE on input

DIM savecell(5) AS addcell
IF nsac = 0 THEN
  IF NOT Fourfound(LEFT, poscell(), posfour()) THEN posn.WhoisWinning = RIGHT
ELSE 'nsac =1
  FOR col = 1 TO 7
    colstate = poscol(col).state
    IF colstate AND (ZDR OR ZDDR) THEN ' col contains DR then sac it!
      'first save addcells of this col to restore later
      top = 6 * (col - 1)
      FOR row = 0 TO 5: savecell(row) = poscell(top + row).add: NEXT row
      'now modify addcells according to state
      IF colstate = ZDR OR colstate = ZDR + ZVL THEN
        IF NOT poscell(top + 3).potR THEN 'special case
          poscell(top).add = right11
          poscell(top + 1).add = left11
          poscell(top + 2).add = right11
          IF poscell(top + 3).real = EMPTY THEN
            poscell(top + 3).add.who = LEFT
            'note A) don't tamper with "what"
            'note B) if poscell(top+4&/or5)empty then addcell4&or5 is already LEFT
          ELSE
            poscell(top + 2).add.what = 10
          END IF
        ELSE
          poscell(top).add = right11
          poscell(top + 1).add = left11
          poscell(top + 2).add = right11
          poscell(top + 3).add = left11
          poscell(top + 4).add = right11
          IF poscell(top + 5).real <> EMPTY THEN poscell(top + 4).add.what = 10
          'if empty then addcell(top+5) already ok
        END IF
      ELSEIF colstate = ZDR + ZVR THEN
        poscell(top).add = empty0
        poscell(top + 1).add = empty1
        poscell(top + 2).add = right11
        poscell(top + 3).add = left11
        poscell(top + 4).add = right11
        IF poscell(top + 5).real <> EMPTY THEN poscell(top + 4).add.what = 10
        'if empty then addcell(top+5) already ok
      ELSEIF colstate = ZDDR OR colstate = ZDR + ZDLR THEN
        poscell(top).add = empty0
        poscell(top + 1).add = empty0
        poscell(top + 2).add = empty1
        poscell(top + 3).add = right11
        poscell(top + 4).add = left11
        poscell(top + 5).add = right11
      ELSE
        STOP 'error no other case
      END IF
      'now check if this sac wins for R
      IF NOT Fourfound(LEFT, poscell(), posfour()) THEN
        posn.WhoisWinning = RIGHT
        'reset addcell for this col
        FOR row = 0 TO 5: poscell(top + row).add = savecell(row): NEXT row
        EXIT FOR
      END IF
      'reset addcell for this col
      FOR row = 0 TO 5: poscell(top + row).add = savecell(row): NEXT row
    END IF 'col contains DR
  NEXT col
END IF 'nsac=0/1
END SUB

SUB SetupDiskImages
LOCATE 10, 6: PRINT "This is Left"
LOCATE 10, 36: PRINT "Left(yellow) starts"
x = 200
y = 152
C1 = Cleft1
CIRCLE (x, y), radius, C1
PAINT (x, y), C1, C1
GET (x - radius, y - radius)-(x + shift + radius, y + radius), DiskLeftImage(0)
GET (x - shift - radius, y - radius)-(x + radius, y + radius), DiskRightImage(0)
GET (x - radius, y - shift - radius)-(x + radius, y + radius), DiskDownImage(0)

LOCATE 16, 6: PRINT "This is Right"
LOCATE 16, 36: PRINT "Right(red) plays second"
x = 200
y = 248
C1 = Cright1
CIRCLE (x, y), radius, C1
PAINT (x, y), C1, C1
GET (x - radius, y - radius)-(x + shift + radius, y + radius), DiskLeftImage(1000)
GET (x - shift - radius, y - radius)-(x + radius, y + radius), DiskRightImage(1000)
GET (x - radius, y - shift - radius)-(x + radius, y + radius), DiskDownImage(1000)
END SUB

SUB SlideDown (ndrop)
IF diskplayer = LEFT THEN ii = 0 ELSE ii = 1000
x = xorig + diskcol * spacing: y = yorig
FOR j = 1 TO ndrop
  FOR i = 1 TO nshift
    y = y + shift
    PUT (x - radius, y - shift - radius), DiskDownImage(ii), PSET
    'now tidy up frame
    IF j <> 1 THEN
      yy = yorig + (j - .5) * spacing
      LINE (xl, yy)-(xr, yy), Cframe, , 21845
    END IF
  NEXT i
NEXT j
END SUB

SUB SlideLeft
IF diskcol = 0 THEN EXIT SUB
IF diskplayer = LEFT THEN ii = 0 ELSE ii = 1000
x = xorig + diskcol * spacing: y = yorig
FOR i = 1 TO nshift
  x = x - shift
  IF x < xmin THEN x = xmin
  PUT (x - radius, y - radius), DiskLeftImage(ii), PSET
NEXT i
diskcol = diskcol - 1
END SUB

SUB SlideRight
IF diskcol = 8 THEN EXIT SUB
IF diskplayer = LEFT THEN ii = 0 ELSE ii = 1000
x = xorig + diskcol * spacing: y = yorig
FOR i = 1 TO nshift
  x = x + shift
  IF x > xmax THEN x = xmax
  PUT (x - shift - radius, y - radius), DiskRightImage(ii), PSET
NEXT i
diskcol = diskcol + 1
END SUB

SUB SortValues (sortcol(), sortval())
'sorts both arrays into order based on vals
FOR i = 1 TO 6
  test = sortval(i): jj = i
  FOR j = i + 1 TO 7
    IF sortval(j) > test THEN test = sortval(j): jj = j
  NEXT j
  'so jj is the i'th biggest
  IF i <> jj THEN 'swap them
    temp = sortcol(i)
    sortcol(i) = sortcol(jj)
    sortcol(jj) = temp
    temp = sortval(i)
    sortval(i) = sortval(jj)
    sortval(jj) = temp
  END IF
NEXT i
END SUB

SUB Updatepos (poscell() AS cell, poscol() AS col, posfour() AS four, posn AS posn, movecell, movecol, turn)
'
'player "turn" has just played "movecell"
'update the position first
'
poscell(movecell).real = turn
poscol(movecol).free = poscol(movecol).free - 1
poscol(movecol).calcadd = TRUE  'because col has changed
'
posn.Phaswon = FALSE
temp = posn.Ncanwin: posn.Ncanwin = posn.Pcanwin: posn.Pcanwin = temp
posn.wt = -posn.wt
posn.wincell = null
'
'for each four containing movecell
'update its score,etc
FOR j = 0 TO 12
  k = FourIndex(movecell, j)
  IF k = 0 THEN EXIT FOR
  IF posfour(k).live THEN
    score = posfour(k).score
    IF score > 9 THEN 'four already part-filled
      IF posfour(k).side = turn THEN 'P has improved
        score = score + 10
        posfour(k).score = score
        posn.wt = posn.wt - TableOfDeltaTenWt(score)
        IF score = 44 THEN posn.Phaswon = TRUE
        IF score = 34 THEN posn.Pcanwin = posn.Pcanwin + 1
        IF score = 33 THEN 'set ppot for the empty cell
          GOSUB OnlyEmptyCell 'sets variable "ecell"
          cell = ecell
          IF turn = LEFT THEN GOSUB SetppotL ELSE GOSUB SetppotR
        END IF 'score33
      ELSE 'become dead
        posfour(k).live = FALSE
        posn.wt = posn.wt - TableOfWeight(score)' its now better for P
        IF score = 34 THEN posn.Ncanwin = posn.Ncanwin - 1
        IF score = 33 THEN
          cell = movecell
          IF turn = LEFT THEN GOSUB UnsetppotR ELSE GOSUB UnsetppotL
        END IF'score33
      END IF 'P/N benefitted
    ELSE 'four was empty
      posfour(k).side = turn
      score = score + 10
      posfour(k).score = score
      posn.wt = posn.wt - TableOfWeight(score)
    END IF 'four full/empty
  END IF 'four live
NEXT j
IF movecell MOD 6 <> 0 THEN 'there is a cell above movecell
  'for each four containing the "above" cell
  'update its "ready/score" and modify weights accordingly
  cell = movecell - 1
  FOR j = 0 TO 12
    k = FourIndex(cell, j)
    IF k = 0 THEN EXIT FOR
    IF posfour(k).live THEN
      score = posfour(k).score + 1
      posfour(k).score = score
      IF score > 9 THEN 'four already part-filled,so update weight
        IF posfour(k).side = turn THEN 'P has improved
          posn.wt = posn.wt - TableOfDeltaOneWt(score)
          IF score = 34 THEN
            posn.Pcanwin = posn.Pcanwin + 1
            IF turn = LEFT THEN GOSUB UnsetppotL ELSE GOSUB UnsetppotR
          END IF
        ELSE 'N has improved
          posn.wt = posn.wt + TableOfDeltaOneWt(score)
          IF score = 34 THEN
            posn.Ncanwin = posn.Ncanwin + 1
            IF turn = LEFT THEN GOSUB UnsetppotL ELSE GOSUB UnsetppotR
          END IF
        END IF 'P/N improved
      END IF 'partfilled
    END IF 'live
  NEXT j
END IF 'cell above
'
IF posn.Ncanwin THEN 'find a winning move
  FOR k = 1 TO 69
    IF posfour(k).live THEN
      IF posfour(k).score = 34 AND posfour(k).side = -turn THEN
        GOSUB OnlyEmptyCell 'sets ecell
        posn.wincell = ecell
        EXIT FOR
      END IF
    END IF
  NEXT k
ELSEIF posn.Pcanwin THEN 'find a forced move
  FOR k = 1 TO 69
    IF posfour(k).live THEN
      IF posfour(k).score = 34 AND posfour(k).side = turn THEN
        GOSUB OnlyEmptyCell 'sets ecell
        posn.wincell = ecell
        EXIT FOR
      END IF
    END IF
  NEXT k
ELSE 'only do the following when no win/forced move
  FOR col = 1 TO 7
    IF poscol(col).calcstate THEN CalcColState col, poscell(), poscol(), posn
  NEXT col
  CALL Winnishness(poscell(), poscol(), posfour(), posn)
END IF

EXIT SUB
OnlyEmptyCell:
  FOR c = 0 TO 3 'find the only empty cell in the four indexed by k
    IF poscell(CellsOfFour(k, c)).real = EMPTY THEN EXIT FOR
  NEXT c
  IF c = 4 THEN PRINT "Unexpected error in OnlyEmptyCell": STOP
  ecell = CellsOfFour(k, c)
RETURN
SetppotL: 'all these use cell as an input value
  IF NOT poscell(cell).ppotL THEN 'ppotL of cell is changing to true
    poscell(cell).ppotL = TRUE
    col = 1 + (cell \ 6)
    'unless top row, check potR of above cell
    IF cell MOD 6 <> 0 THEN 'potR above will be FALSE; what was it before?
      IF poscell(cell - 1).potR THEN 'potR above is changing to false
        poscell(cell - 1).potR = FALSE
        poscol(col).calcstate = TRUE 'since above cell pot has changed
      END IF
    END IF
    'check ppotR of below cell,as it inhibits potL of cell
    'note cell can't be on bottom row!!!!
    IF NOT poscell(cell + 1).ppotR THEN ' potL of cell should also change
      poscell(cell).potL = TRUE
      poscol(col).calcstate = TRUE 'since this cell pot has changed
    END IF
  END IF
RETURN
SetppotR:
  IF NOT poscell(cell).ppotR THEN 'ppotR of cell is changing to true
    poscell(cell).ppotR = TRUE
    col = 1 + (cell \ 6)
    'unless top row, check potL of above cell
    IF cell MOD 6 <> 0 THEN 'potL  above will be FALSE; what was it before?
      IF poscell(cell - 1).potL THEN  'potL above is changing to false
        poscell(cell - 1).potL = FALSE
        poscol(col).calcstate = TRUE 'since above cell pot has changed
      END IF
    END IF
    'check ppotL of below cell,as it inhibits potR of cell
    'note cell can't be on bottom row!!!!
    IF NOT poscell(cell + 1).ppotL THEN ' potL of cell should also change
      poscell(cell).potR = TRUE
      poscol(col).calcstate = TRUE 'since this pot has changed
    END IF
  END IF
RETURN
UnsetppotL:
  IF poscell(cell).ppotL THEN 'ppotL of cell is changing to false
    poscell(cell).ppotL = FALSE
    col = 1 + (cell \ 6)
    'unless top row, check potR of above cell
    IF cell MOD 6 <> 0 THEN 'potR above was FALSE; what will it be?
      IF poscell(cell - 1).ppotR THEN
        poscell(cell - 1).potR = TRUE 'since NOT ppotL of cell
        poscol(col).calcstate = TRUE 'since above pot has changed
      END IF
    END IF
    'check if potL of this cell has changed
    IF poscell(cell).potL THEN
      poscell(cell).potL = FALSE
      poscol(col).calcstate = TRUE 'since this pot has changed
    END IF
  END IF
RETURN
UnsetppotR:
  IF poscell(cell).ppotR THEN 'ppotR of cell is changing to false
    poscell(cell).ppotR = FALSE
    col = 1 + (cell \ 6)
    'unless top row, check potL of above cell
    IF cell MOD 6 <> 0 THEN 'potL above was FALSE; what will it be?
      IF poscell(cell - 1).ppotL THEN
        poscell(cell - 1).potL = TRUE 'since NOT ppotL of cell
        poscol(col).calcstate = TRUE 'since above pot has changed
      END IF
    END IF
    'check if potR of this cell has changed
    IF poscell(cell).potR THEN
      poscell(cell).potR = FALSE
      poscol(col).calcstate = TRUE 'since this pot has changed
    END IF
  END IF
RETURN
END SUB

SUB Winnishness (poscell() AS cell, poscol() AS col, posfour() AS four, posn AS posn)
'posfour            input: so as to pass to setaddcell
'poscell.add       output: as needed
'posn.winnish      output: as winnish$
'posn.WhoisWinning output: LEFT,RIGHT,or FALSE
'winnish$            calc: L,R,=, or !
'
'
'

posn.WhoisWinning = FALSE
'now determine winnishness
IF posn.nll > 0 OR posn.nrr > 0 THEN
  winnish$ = "!"
ELSE
'determine winnishness according to this table
'                   ndlr
'              zero  odd  even
'        >=+1    L    L    L
' ndl-ndr   0   =/R*  L    R      *according as nvr
'          -1   =/R*  R    R       is zero/non-zero
'        <=-2    R    R    R
'
SELECT CASE posn.ndl - posn.ndr
CASE IS > 0
  winnish$ = "L"
CASE 0
  IF (posn.ndlr MOD 2) = 0 THEN
    IF posn.ndlr = 0 AND posn.nvr = 0 THEN winnish$ = "=" ELSE winnish$ = "R"
  ELSE 'ndlr odd
    winnish$ = "L"
  END IF
CASE -1
  IF posn.ndlr = 0 AND posn.nvr = 0 THEN winnish$ = "=" ELSE winnish$ = "R"
CASE IS <= -2
  winnish$ = "R"
END SELECT
END IF
'LOCATE 26, 1: PRINT SPACE$(30)
'LOCATE 26, 1: PRINT winnish$; " NDL,DR,DLR,VR"; posn.ndl; posn.ndr; posn.ndlr; posn.nvr;
'LOCATE 27, 1: PRINT SPACE$(15): LOCATE 27, 1
IF winnish$ = "L" THEN
  IF (posn.ndl - posn.ndr + posn.ndlr) MOD 2 = 0 THEN nsac = posn.ndr + 1 ELSE nsac = posn.ndr
  IF nsac >= 2 THEN PRINT "sac too complex for now": STOP
  IF posn.winnish <> "L" THEN calcaddall = TRUE 'winnish has changed
  FOR col = 1 TO 7
    IF poscol(col).calcadd OR calcaddall THEN
       Lsetaddcell col, poscell(), poscol()
    END IF
  NEXT col
   Lwinsearch nsac, poscell(), poscol(), posfour(), posn
'  IF posn.WhoisWinning = LEFT THEN PRINT "L winning";  ELSE PRINT ; "not L winning";
ELSEIF winnish$ = "R" THEN
  IF (posn.ndr - posn.ndl + posn.ndlr) MOD 2 = 0 THEN nsac = posn.ndl ELSE nsac = posn.ndl + 1
  IF nsac >= 2 THEN PRINT "sac too complex for now": STOP
  IF posn.winnish <> "R" THEN calcaddall = TRUE 'winnish has changed
  FOR col = 1 TO 7
    IF poscol(col).calcadd OR calcaddall THEN
      Rsetaddcell col, poscell(), poscol()
    END IF
  NEXT col
  Rwinsearch nsac, poscell(), poscol(), posfour(), posn
'  IF posn.WhoisWinning = RIGHT THEN PRINT "R winning";  ELSE PRINT ; "not R winning";
END IF 'L/R winnish
posn.winnish = winnish$
END SUB

