{$A+,B-,D+,E+,F-,G+,I+,L+,N+,O-,P-,Q+,R+,S+,T-,V+,X+,Y+}
{$M 32384,0,80000}
Uses Dos,Crt;
Const
      PalMask = $36C;
      PalRegR = $3C7;
      PalRegW = $3C8;
      PalData = $3C9;

      FadeSpeed = 20; { Fading speed }
      col : array[0..2] of byte= (0,31,12);
      mapsize = 48;

      UnitName : Array[1..3] of String = ('Peasent','Fighter','Dragon');
      UnitCost : Array[1..3] of LongInt = (100,80,200);
      UnitHP : Array[1..3] of Integer = (10,20,25);
      UnitAtak : Array[1..3] of LongInt = (0,2,5);
      UnitWait : Array[1..3] of LongInt = (0,20,5);
      UnitRange : Array[1..3] of LongInt = (0,3,1);

      HouseName : Array[1..3] of String = ('Town Hall','Barracks','Stable');
      HouseCost : Array[1..3] of LongInt = (300,100,500);
      HouseHP : Array[1..3] of LongInt = (1000,500,750);

      StartMoney = 300;
      MaxWood = 30; { maximum wood storage }
      OneWood = 30;

Type TPalette = Array[0..255] of record R,G,B : Byte; End;
     TSpr = Array[0..15,0..15] of byte;
     TFont = Array[0..255,1..6] of byte;
     TMouseBuf = Array[1..16,1..16] of byte;

     TUnit = record
       X,Y,X1,Y1 : Integer;
       dir,ani : ShortInt;
       race : Byte;
       Typ : Byte;
       sel,del : Boolean;
       order : Byte; {0=stop,1=move,2=atak(ox=1 if unit),3=harvest,4=build}
       dolg : Boolean;
       dX,dY : Integer;
       wait : Integer;
       OX,OY: Integer;
       Wood : LongInt;
       HP : LongInt;
       ofs,xp,yp : Integer;
     End;
     THouse = record
       X,Y : Integer;
       typ : ShortInt;
       race : Byte;
       HP : LongInt;
       sel : Boolean;
       del : Boolean;
       order : Byte; {0=nothing,1=building,2=producing}
       Progress : LongInt; { percentage of building }
     End;
     TFire = record
       X1,Y1,X2,Y2 : LongInt;
       typ : Byte;
     End;

Var
PresentX,PresentY : Integer;
DBuf : Pointer; { Double Buffer }
Fnt : ^TFont;
MouseBuf : ^TMouseBuf;
Int1CSave : Pointer;
MouseVis : Boolean;
MouseX,MouseY : Integer;
MouseSpr : ^TSpr;
SegDB : Word;   { Segment of double-buffer }
Pal,NullPal : TPalette; { Palette for sprites and clear palette }
Spr : Array[1..58] of ^TSpr; { Sprites }
X,Y,A,B,C,D,E : LongInt;
map : Array[1..mapsize,1..mapsize] of Byte;
way : Array[1..mapsize,1..mapsize] of Boolean;
xm,ym : LongInt;
S : String;
Time : LongInt;
Timer : LongInt absolute $40:$6c;
Lb,Rb,Mb : Boolean;
mx,my : Integer;
U : Array[1..500] of TUnit;
H : Array[1..500] of THouse;
Fi : Array[1..500] of TFire;
NF,NU,NH : LongInt;
EventOn : Boolean;
mon : Array[1..2] of LongInt;
CatchPresent : Boolean;

{$L spr}
{$L mouse}
{$L fnt}
Procedure Sprites; far; external;
Procedure MouseSp; far; external;
Procedure MyFont; far; external;

Function Sign(A : LongInt) : ShortInt;
Begin
  If A>0 then Sign:=1 else
    If A=0 then Sign:=0 else Sign:=-1;
End;

Procedure ReSetMouse;
Var R : Registers;
Begin
  R.ax:=0;
  Intr($33,R);
End;

Procedure ReadMouseState(Var XMo,YMo : Integer;Var Lb,Mb,Rb : Boolean);
Var R : Registers;
Begin
  R.ax:=3;
  Intr($33,R);
  XMo:=R.cx;
  YMo:=R.dx;
  Lb:=R.bx and 1=1;
  Rb:=R.bx and 2=2;
  Mb:=R.bx and 4=4;
End;

Procedure WaitRelBut;
Var Xm,Ym : Integer;
Lb,Mb,Rb : Boolean;
Begin
  Repeat
    ReadMouseState(Xm,Ym,Lb,Mb,Rb);
  Until Not Lb and Not Rb;
End;

Procedure DrawSpriteD(Spr : TSpr;x,y : Word); assembler;
Asm
  Mov ax,SegDB
  Mov es,ax
  Mov di,y
  Shl di,6
  Mov bx,di
  Shl di,2
  Add di,bx
  Add di,x
  push ds
  lds si,spr
  mov cx,16
@Me1 :
  push cx
  mov cx,16
@Me2 :
  Mov al,[si]
  Cmp al,0
  Je @Me3
  Mov es:[di],al
@Me3 :
  Inc di
  Inc si
  Loop @Me2
  pop cx
  add di,304
  Loop @Me1
  Pop ds
End;

Procedure ReadUnderMouse; assembler;
Asm
  Push ds
  Les di,MouseBuf
  Mov si,MouseY
  Shl si,6
  Mov bx,si
  Shl si,2
  Add si,bx
  Add si,MouseX
  Mov ax,SegA000
  Mov ds,ax
  Mov cx,16
  Cld
@m1 :
  Push cx
  Mov cx,8
  Rep MovsW
  Pop cx
  Add si,304
  Loop @m1
  Pop ds
End;

Procedure ShowUnderMouse; assembler;
Asm
  Push ds
  Mov ax,SegA000
  Mov es,ax
  Mov di,MouseY
  Shl di,6
  Mov bx,di
  Shl di,2
  Add di,bx
  Add di,MouseX
  Lds si,MouseBuf
  Cld
  Mov cx,16
@mm1 :
  Push cx
  Mov cx,8
  Rep MovsW
  Pop cx
  Add di,304
  Loop @mm1
  Pop ds
End;

Procedure DrawSpriteT(Spr : TSpr;x,y : Word); assembler;
Asm
  Mov ax,SegA000
  Mov es,ax
  Mov di,y
  Shl di,6
  Mov bx,di
  Shl di,2
  Add di,bx
  Add di,x
  push ds
  lds si,spr
  mov cx,16
@Metk1 :
  push cx
  mov cx,16
@metk2 :
  Mov al,[si]
  Cmp al,0
  Je @metk3
  Mov es:[di],al
@metk3 :
  Inc si
  Inc di
  Loop @metk2
  pop cx
  add di,304
  Loop @Metk1
  Pop ds
End;

Procedure ShowMous;
Begin
  DrawSpriteT(MouseSpr^,MouseX,MouseY);
End;

Procedure ShowMous2;
Begin
  DrawSpriteD(MouseSpr^,MouseX,MouseY);
End;

Procedure ShowMouse;
Var Lb,Mb,Rb : Boolean;
Begin
  ReadMouseState(MouseX,MouseY,Lb,Mb,Rb);
  MouseX:=MouseX Shr 1;
  MouseVis:=True;
  ReadUnderMouse;
  ShowMous;
End;

Procedure HideMouse;
Begin
  MouseVis:=False;
  ShowUnderMouse;
End;


Procedure ShMo;
Begin
  DrawSpriteD(MouseSpr^,MouseX,MouseY);
End;

Procedure RdMo; assembler;
Asm
  Push ds
  Les di,MouseBuf
  Mov si,MouseY
  Shl si,6
  Mov bx,si
  Shl si,2
  Add si,bx
  Add si,MouseX
  Push si
  Mov ax,SegDB
  Mov ds,ax
  Pop si
  Mov cx,16
  Cld
@m1 :
  Push cx
  Mov cx,8
  Rep MovsW
  Pop cx
  Add si,304
  Loop @m1
  Pop ds
End;

Procedure CheckMainEvent; forward;

{$F+,S-,W-}
procedure TimerHandler; interrupt;
Var xm,ym : Integer;
Lb,Rb,Mb : Boolean;
  begin
    { Timer ISR }
    If MouseVis then
    Begin
      ReadMouseState(xm,ym,Lb,Mb,Rb);
      If (xm Shr 1<>MouseX) or (ym<>MouseY) then
      Begin
        ShowUnderMouse;
        MouseX:=Xm Shr 1;
        MouseY:=Ym;
        If MouseX>304 then MouseX:=304;
        If MouseY>184 then MouseY:=184;
        ReadUnderMouse;
        ShowMous;
      End;
    End;
    If EventOn then CheckMainEvent;
  end;
{$F-,S+}

Procedure GrInit;
var a,b,c : longint;
s,o : Word;
Begin
  New(Fnt);
  S:=Seg(MyFont);
  O:=Ofs(MyFont);
  c:=6;
  For a:=0 to 255 do
    For b:=1 to 6 do
    Begin
      Fnt^[a,b]:=Mem[S:O+c];
      Inc(c);
    End;
  MouseSpr:=@MouseSp;
  New(MouseBuf);
  MouseVis:=False;
  ResetMouse;
  GetIntVec($1C,Int1CSave);
  SetIntVec($1C,@TimerHandler);
  GetMem(DBuf,64000+16);
  SegDB:=Seg(DBuf^)+1;
  asm
    mov ax,13h
    int 10h
  end;
End;

Procedure GrDone;
Begin
  SetIntVec($1C,Int1CSave);
  FreeMem(DBuf,64000+16);
  asm
    mov ax,3
    int 10h
  end;
End;

Procedure PixelD(x,y : Word;Color : Byte); assembler;
Asm
  Mov ax,SegDB
  Mov es,ax
  Mov di,y
  Shl di,6
  Mov bx,di
  Shl di,2
  Add di,bx
  Add di,x
  Mov al,Byte Ptr color
  Mov es : [di],al
End;

Procedure SetPalReg(index,Red,Green,Blue : Byte);
Begin
  Port[PalMask]:=$FF;
  Port[PalRegW]:=index;
  Port[PalData]:=Red;
  Port[PalData]:=Green;
  Port[PalData]:=Blue;
End;

Procedure GetPalReg(index : Byte; Var Red,Green,Blue : Byte);
Begin
  Port[PalMask]:=$FF;
  Port[PalRegR]:=index;
  Red:=Port[PalData];
  Green:=Port[PalData];
  Blue:=Port[PalData];
End;

Procedure SetPalette(Pal : TPalette);
Var I : Byte;
Begin
  For I:=0 to 255 do SetPalReg(I,Pal[I].R,Pal[I].G,Pal[I].B);
End;

Procedure GetPalette(Var Pal :TPalette);
Var I : Byte;
Begin
  For I:=0 to 255 do GetPalReg(I,Pal[I].R,Pal[I].G,Pal[I].B);
End;


Procedure FadePal(Pal : TPalette);
Var A,B : LongInt;
P : TPalette;
T : LongInt;
Begin
  For B:=FadeSpeed downto 0 do
  Begin
    For A:=0 to 255 do
    Begin
      P[A].R:=Trunc(Pal[A].R*B/FadeSpeed);
      P[A].G:=Trunc(Pal[A].G*B/FadeSpeed);
      P[A].B:=Trunc(Pal[A].B*B/FadeSpeed);
    End;
    SetPalette(P);
    T:=MemL[$40:$6c];
    Repeat Until MemL[$40:$6c]-T>=1;
  End;
End;

Procedure LightPal(Pal : TPalette);
Var A,B : LongInt;
P : TPalette;
T : LongInt;
Begin
  For B:=0 to FadeSpeed do
  Begin
    For A:=0 to 255 do
    Begin
      P[A].R:=Trunc(Pal[A].R*B/FadeSpeed);
      P[A].G:=Trunc(Pal[A].G*B/FadeSpeed);
      P[A].B:=Trunc(Pal[A].B*B/FadeSpeed);
    End;
    SetPalette(P);
    T:=MemL[$40:$6c];
    Repeat Until MemL[$40:$6c]-T>=1;
  End;
End;

Procedure ShowDouble; assembler;
Asm
  Mov dl,MouseVis
  Push dx
  Mov MouseVis,0
  Cmp dl,1
  Jne @dal1
  Call RdMo
  Call ShMo
@dal1 :
  Push ds
  Mov ax,SegA000
  Mov es,ax
  Mov di,0
  Mov cx,32000
  Mov ax,SegDB
  Mov ds,ax
  Mov si,0
  Cld
  Rep MovsW
  Pop ds
  Pop dx
  Mov MouseVis,dl
End;

Procedure Cls(Color : Byte); assembler;
asm
  mov ax,0A000h
  mov es,ax
  xor di,di
  mov al,Color
  mov ah,al
  mov cx,32000
  Cld
  rep stosw
End;

Procedure ClsD(Color : Byte); assembler;
asm
  mov es,SegDB
  xor di,di
  mov al,Color
  mov ah,al
  mov cx,32000
  Cld
  rep stosw
End;

Procedure PrintD(S : String;x,y : Word; color : Byte);
Var Segm,i,x1,y1,Off : Word;
  Procedure PrtD(Ch : Char;x,y,off : Word; color : Byte);
  Var WrkSeg,WrkOff,x2,y2,TOff : Word;
  BitMask,O : Byte;
  Begin
    TOff:=Off;
    O:=Ord(CH);
    For y:=1 to 6 do
    Begin
      BitMask:=$20;
      For x:=0 to 5 do
      Begin
        If Fnt^[o,y] and BitMask<>0 then Mem[Segm:(TOff+x)]:=color;
        BitMask:=BitMask shr 1;
      End;
      Inc(TOff,320);
    End;
  End;

Begin
  x1:=x;y1:=y;
  Off:=(y shl 8)+(y shl 6)+x;
  Segm:=SegDB;
  For i:=1 to length(s) do
  Begin
    PrtD(s[i],x1,y1,off,color);
    Inc(x1,6);
    Inc(off,6);
  End;
End;

Procedure ShowTransD(x,y : Word;Spr : Pointer); assembler;
Asm
  Mov ax,SegDB
  Mov es,ax
  Mov di,y
  Shl di,6
  Mov bx,di
  Shl di,2
  Add di,bx
  Add di,x
  push ds
  mov cx,16
  mov bx,16
  lds si,spr
@Met1 :
  push cx
  mov cx,bx
@Met2 :
  mov al,ds:[si]
  cmp al,0
  jz @Met3
  mov es:[di],al
@Met3:
  inc di
  inc si
  loop @Met2
  pop cx
  add di,320
  sub di,bx
  Loop @Met1
  Pop ds
End;

Procedure ShowSprD(x,y : Word;col:byte;Spr : Pointer); assembler;
Asm
  Mov ax,SegDB
  Mov es,ax
  Mov di,y
  Shl di,6
  Mov bx,di
  Shl di,2
  Add di,bx
  Add di,x
  push ds
  mov cx,16
  mov bx,16
  lds si,spr
@Met1 :
  push cx
  mov cx,bx
@Met2 :
  mov al,ds:[si]
  cmp al,1
  jnz @Met4
  mov al,col
@Met4:
  mov es:[di],al
@Met3:
  inc di
  inc si
  loop @Met2
  pop cx
  add di,320
  sub di,bx
  Loop @Met1
  Pop ds
End;

Procedure ShowSprT(x,y : Word;col:byte;Spr : Pointer); assembler;
Asm
  Mov ax,SegDB
  Mov es,ax
  Mov di,y
  Shl di,6
  Mov bx,di
  Shl di,2
  Add di,bx
  Add di,x
  push ds
  mov cx,16
  mov bx,16
  lds si,spr
@Met1 :
  push cx
  mov cx,bx
@Met2 :
  mov al,ds:[si]
  and al,al
  jz @Met3
  cmp al,1
  jnz @Met4
  mov al,col
@Met4:
  mov es:[di],al
@Met3:
  inc di
  inc si
  loop @Met2
  pop cx
  add di,320
  sub di,bx
  Loop @Met1
  Pop ds
End;

procedure ShowImageD(x,y : Integer;spr : Pointer); assembler;
Asm
  Mov ax,SegDB
  Mov es,ax
  Mov di,y
  Shl di,6
  Mov bx,di
  Shl di,2
  Add di,bx
  Add di,x
  push ds
  mov bx,16
  lds si,spr
@Met1 :
  mov cx,8
  rep movsw
  add di,304
  dec bx
  jnz @Met1
  Pop ds
End;

procedure VRT; assembler;
asm
  mov dx,3DAh
@VRT1:
  in al,dx
  test al,8
  jnz @VRT1
@VRT2:
  in al,dx
  test al,8
  jz @VRT2
end;

Procedure PutTrees(X,Y,Pow : LongInt);
Begin
  If (pow>0) and (X>1) and (X<mapsize) and (Y>1) and (Y<mapsize) then
  Begin
    map[X,Y]:=Random(3)+1;
    PutTrees(X-1,Y,Pow-1-Random(3));
    PutTrees(X+1,Y,Pow-1-Random(3));
    PutTrees(X,Y-1,Pow-1-Random(3));
    PutTrees(X,Y+1,Pow-1-Random(3));
  End;
End;

Procedure GenMap;
Begin
  mon[1]:=StartMoney;
  mon[2]:=StartMoney;
  NH:=0;
  FillChar(map,SizeOf(map),4);
  map[1,1]:=12;
  map[mapsize,mapsize]:=12;
  map[1,mapsize]:=12;
  map[mapsize,1]:=12;
  For A:=2 to mapsize-1 do
  Begin
    map[A,1]:=10;
    map[1,A]:=10+Random(2);
    map[A,mapsize]:=10;
    map[mapsize,A]:=10+Random(2);
  End;
  Y:=Random(15)+15;
  X:=11;
  xm:=X-7;
  ym:=Y+5;
  PutTrees(X,Y,15);
  NU:=2;
  U[1].X:=X;
  U[1].Y:=Y+11;
  With U[1] do
  Begin
    Typ:=1;
    race:=1;
    sel:=True;del:=False;wait:=0;dolg:=False;
    ani:=0;dir:=3;
    order:=0;
    HP:=UnitHP[Typ];
    ofs:=0;xp:=0;yp:=0;
    X1:=X;Y1:=Y;
    Wood:=0;
  End;
  X:=mapsize-11;
  Y:=Random(15)+15;
  PutTrees(X,Y,10);
  U[2].X:=X;
  U[2].Y:=Y+8;
  With U[2] do
  Begin
    Typ:=1;
    race:=2;
    sel:=False;del:=False;wait:=0;dolg:=False;
    ani:=0;dir:=3;
    order:=0;
    HP:=UnitHP[Typ];
    ofs:=0;xp:=0;yp:=0;
    X1:=X;Y1:=Y;
    Wood:=0;
  End;
  PresentX:=X+6;
  PresentY:=Y+6;
  For A:=-2 to 2 do
    For B:=-2 to 2 do
      If (A<>0) or (B<>0) then
      Begin
        Inc(NU);
        With U[NU] do
        Begin
          X:=PresentX+A;
          Y:=PresentY+B;
          dolg:=True;
          dX:=X;
          dY:=Y;
          Typ:=2;
          race:=2;
          sel:=False;del:=False;wait:=0;
          ani:=0;dir:=3;
          order:=0;
          HP:=UnitHP[Typ];
          ofs:=0;xp:=0;yp:=0;
          X1:=X;Y1:=Y;
          Wood:=0;
        End;
      End;
End;

Procedure ShowMiniMap;
Begin
  For A:=1 to mapsize do
    For B:=1 to mapsize do
      If map[A,B]<4 then PixelD(A-1,B-1,2) else
      If map[A,B]=4 then PixelD(A-1,B-1,10) else
        PixelD(A-1,B-1,7);
  PixelD(PresentX,PresentY,0);
  For A:=1 to NU do
  Begin
    PixelD(U[A].X,U[A].Y,col[U[A].race]);
  End;
  For A:=1 to NH do
  Begin
    PixelD(H[A].X,H[A].Y,col[H[A].race]);
  End;
  For A:=1 to 16 do
  Begin
    PixelD(xm+A-1,ym,32);
    PixelD(xm+A-1,ym+11,32);
  End;
  For A:=1 to 12 do
  Begin
    PixelD(xm,ym+A-1,32);
    PixelD(xm+15,ym+A-1,32);
  End;
End;

Procedure PutUnit(Var U1 : TUnit;X,Y : Integer);
Var A,B,C,D,E : LongInt;
m : Array[0..mapsize,0..mapsize] of Boolean;
Begin
  FillChar(m,Sizeof(m),True);
  For A:=1 to NU do m[U[A].X,U[A].Y]:=False;
  For A:=1 to NH do m[H[A].X,H[A].Y]:=False;
  A:=1;
  Repeat
    For B:=-A to A do
      For C:=-A to A do
        If (X+B>=1) and (X+B<=mapsize) and (Y+C>=1) and (Y+C<=mapsize) then
          If m[X+B,Y+C] then
          Begin
            U1.X:=X+B;
            U1.Y:=Y+C;
            Exit;
          End;
    Inc(A);
  Until False;
End;

Procedure ShowBigMap;
Var xx,yy,t : LongInt;
Begin
  For A:=1 to 16 do
    For B:=1 to 12 do
    Begin
      ShowImageD(48+A*16,B*16-16,Spr[map[xm+A,ym+B]]);
    End;
  X:=(PresentX-xm)*16;
  Y:=(PresentY-ym)*16;
  If (X>=0) and (X<=255) and (Y>=0) and (Y<=191) then
    ShowTransD(X+64,Y,Spr[5]);
  For A:=1 to NU do
  If U[A].order<>4 then
  Begin
    X:=(U[A].X-xm)*16+U[A].ofs*U[A].xp;
    Y:=(U[A].Y-ym)*16+U[A].ofs*U[A].yp;
    If U[A].order=0 then U[A].ani:=0;
    Case U[A].ani shr 1 of
    0,2:B:=0;
    1:B:=1;
    3:B:=2;
    End;
    If (X>=0) and (X<=239) and (Y>=0) and (Y<=191-16) then
    Begin
      ShowSprT(X+64,Y,col[U[A].race],Spr[U[A].typ*12+U[A].dir*3+B+11]);
      If U[A].sel then
      Begin
        C:=(15*U[A].HP) div UnitHP[U[A].typ];
        If C>=12 then D:=10 else
          If C>=6 then D:=14 else
            D:=4;
        For B:=C downto 0 do
        Begin
          PixelD(X+B+64,Y,D);
          PixelD(X+B+64,Y+1,D);
        End;
        C:=(15*U[A].Wood) div MaxWood;
        For B:=C downto 0 do
        Begin
          PixelD(X+B+64,Y+3,26);
          PixelD(X+B+64,Y+4,26);
        End;
      End;
    End;
    If (U[A].xp<>0) or (U[A].yp<>0) then Inc(U[A].ani);
    If U[A].ani>4 shl 1 -1 then U[A].ani:=0;
  End;
  For A:=1 to NH do
  Begin
    X:=(H[A].X-xm)*16;
    Y:=(H[A].Y-ym)*16;
    If H[A].order=1 then
    Begin
      B:=20+((HouseCost[H[A].typ]-H[A].progress)*3) div HouseCost[H[A].typ];
    End else B:=H[A].typ+12;
    If (X>=0) and (X<=239) and (Y>=0) and (Y<=191-16) then
    Begin
      ShowSprT(X+64,Y,col[H[A].race],Spr[B]);
      If H[A].sel then
      Begin
        C:=(15*H[A].HP) div HouseHP[H[A].typ];
        If C>=12 then D:=10 else
          If C>=6 then D:=14 else
            D:=4;
        For B:=C downto 0 do
        Begin
          PixelD(X+B+64,Y,D);
          PixelD(X+B+64,Y+1,D);
        End;
        If (H[A].race=1) and (H[A].order<>0) then
        Begin
          If H[A].order=1 then
            C:=((HouseCost[H[A].typ]-H[A].progress)*15) div HouseCost[H[A].typ] else
            C:=((UnitCost[H[A].typ]-H[A].progress)*15) div UnitCost[H[A].typ];
          If C>=12 then D:=10 else
            If C>=6 then D:=14 else
              D:=4;
          For B:=C downto 0 do
          Begin
            PixelD(X+B+64,Y+4,D);
            PixelD(X+B+64,Y+5,D);
          End;
        End;
      End;
    End;
    If H[A].order<>0 then
      Dec(H[A].progress);
{    H[A].progress:=0; {---}
    If H[A].progress<=0 then
      If H[A].order=1 then
      Begin
        H[A].order:=0;
        For B:=1 to NU do
          If (U[B].X=H[A].X) and (U[B].Y=H[A].Y) then
          Begin
            U[B].Order:=0;
            PutUnit(U[B],H[A].X,H[A].Y);
          End;
      End else
      If H[A].order=2 then
      Begin
        H[A].order:=0;
        Inc(NU);
        With U[NU] do
        Begin
          X:=0;Y:=0;
          order:=0;
          dir:=3;
          ani:=0;
          race:=H[A].race;typ:=H[A].typ;
          sel:=False;del:=False;wait:=0;dolg:=False;
          OX:=0;OY:=0;Wood:=0;
          ofs:=0;xp:=0;yp:=0;
          HP:=UnitHP[typ];
        End;
        PutUnit(U[NU],H[A].X,H[A].Y);
      End;
  End;
  For A:=1 to NF do
  Case Fi[A].typ of
  1:
    Begin
      X:=Fi[A].X1-Xm;
      Y:=Fi[A].Y1-Ym;
      X:=X*16000+8000;Y:=Y*16000+8000;
      D:=X;E:=Y;
      T:=Abs(Fi[A].X2-Fi[A].X1)*16+Abs(Fi[A].Y2-Fi[A].Y1)*16;
      If (Fi[A].X1=Fi[A].X2) and (Fi[A].Y1=Fi[A].Y2) then
      Begin
        xx:=0;
        yy:=0;
        T:=-1;
      End;
      If Abs(Fi[A].X1-Fi[A].X2)>Abs(Fi[A].Y1-Fi[A].Y2) then
      Begin
        xx:=Sign(Fi[A].X2-Fi[A].X1)*1000;
        yy:=((Fi[A].Y2-Fi[A].Y1)*1000) div Abs(Fi[A].X2-Fi[A].X1);
      End else
      Begin
        yy:=Sign(Fi[A].Y2-Fi[A].Y1)*1000;
        xx:=((Fi[A].X2-Fi[A].X1)*1000) div Abs(Fi[A].Y2-Fi[A].Y1);
      End;
      Repeat
        B:=X div 1000+64;C:=Y div 1000;
        If (B>=64) and (B<320) and (C>=0) and (C<192) then
          PixelD(B,C,1);
        Inc(X,xx);
        Inc(Y,yy);
        If Abs(X-D) div 1000+Abs(Y-E) div 1000>T then Break;
      Until False;
    End;
  2:
    Begin
      X:=(Fi[A].X2-Xm)*16+64;
      Y:=(Fi[A].Y2-Ym)*16;
      If (X>=64) and (X<320) and (Y>=0) and (Y<192) then
      Begin
        ShowTransD(X,Y,Spr[16+Fi[A].X1]);
      End;
    End;
  End;
  ShowImageD(64,0,Spr[7]);
  ShowImageD(320-16,0,Spr[7]);
  ShowImageD(64,11*16,Spr[7]);
  ShowImageD(320-16,11*16,Spr[7]);
  ShowImageD(80,0,Spr[8]);
  ShowImageD(320-32,0,Spr[9]);
  ShowImageD(80,11*16,Spr[8]);
  ShowImageD(320-32,11*16,Spr[9]);
  ShowImageD(64,16,Spr[11]);
  ShowImageD(320-16,16,Spr[11]);
  ShowImageD(64,10*16,Spr[16]);
  ShowImageD(320-16,10*16,Spr[16]);
  For A:=3 to 14 do
  Begin
    ShowImageD(A*16+48,0,Spr[10]);
    ShowImageD(A*16+48,11*16,Spr[10]);
  End;
  For A:=3 to 10 do
  Begin
    ShowImageD(64,A*16-16,Spr[12]);
    ShowImageD(320-16,A*16-16,Spr[12]);
  End;
End;

Procedure SetDest(X,Y : LongInt);
Var A,B,ox,oy : Word;
Begin
  OX:=0;
  For A:=1 to NU do
    If (U[A].race<>1) and (U[A].X=X) and (U[A].Y=Y) then
    Begin
      OX:=1;OY:=A;
    End;
  For A:=1 to NH do
    If (H[A].race<>1) and (H[A].X=X) and (H[A].Y=Y) then
    Begin
      OX:=2;OY:=A;
    End;
  If OX=0 then
  Begin
    For A:=1 to NU do
      If U[A].sel and (U[A].race=1) then
      Begin
        U[A].X1:=X;
        U[A].Y1:=Y;
        U[A].Order:=1;
        If (U[A].X1=U[A].X) and (U[A].Y1=U[A].Y) and (U[A].ofs=0) then U[A].order:=0;
        If (U[A].typ=1) and (map[X+1,Y+1]<4) then
        Begin
          U[A].order:=3; { harvest }
          U[A].OX:=X;
          U[A].OY:=Y;
        End;
      End;
  End else
  Begin
    For A:=1 to NU do
      If U[A].sel and (U[A].race=1) and (U[A].typ<>1) then
      Begin
        U[A].OX:=OX;
        U[A].OY:=OY;
        U[A].Order:=2;
      End;
  End
End;

Procedure CheckMainEvent;
Var mx,my : Integer;
lb,mb,rb : Boolean;
t : Byte;
S,A,B,C : Word;
X,Y : Integer;
is : Array[0..3] of Boolean;
ctrl,shift : Boolean;
Begin
  If Port[$60]=42 then Shift:=True else Shift:=False;
  If Port[$60]=29 then Ctrl:=True else Ctrl:=False;
  ReadMouseState(mx,my,lb,mb,rb);
  mx:=mx shr 1;
  If LB then
  Begin
    If (mx<mapsize) and (my<mapsize) then
    Begin
      xm:=mx-7;
      ym:=my-6;
      If xm<0 then xm:=0;
      If ym<0 then ym:=0;
      If xm>mapsize-16 then xm:=mapsize-16;
      If ym>mapsize-12 then ym:=mapsize-12;
    End else
    If (mx<60) and (my>=60) and (my<80) then
    Begin
      B:=0;
      For A:=1 to NH do
        If (H[A].race=1) and (H[A].sel) then Begin Inc(B);C:=A; End;
      If (B=1) and (H[C].order=0) and (mon[1]>=UnitCost[H[C].typ]) then
      Begin
        Dec(mon[1],UnitCost[H[C].typ]);
        H[C].order:=2;
        H[C].progress:=UnitCost[H[C].typ];
      End;
      B:=0;
      For A:=1 to NU do
        If U[A].sel and (U[A].race=1) and (U[A].typ=1) then Begin C:=A;Inc(B);End;
      If B=1 then
      Begin
        For A:=1 to NU do
          If U[A].sel and (U[A].race=1) and (U[A].typ<>1) then B:=0;
        If B=1 then
        Begin
          If mx<20 then t:=1 else
            If mx<40 then t:=2 else
              If mx<60 then t:=3;
          FillChar(is,Sizeof(is),False);
          is[0]:=True;
          For A:=1 to NH do
            If H[A].race=1 then is[H[A].typ]:=True;
          If (mon[1]>=HouseCost[t]) and is[t-1] then
          Begin
            Dec(mon[1],HouseCost[t]);
            A:=C;
            U[A].order:=4;
            U[A].ani:=0;U[A].xp:=0;U[A].yp:=0;U[A].x1:=U[A].x;U[A].y1:=U[A].y;
            U[A].sel:=False;
            Inc(NH);
            With H[NH] do
            Begin
              X:=U[A].X;
              Y:=U[A].Y;
              Typ:=t;HP:=HouseHP[t];race:=1;sel:=False;order:=1;
              Progress:=HouseCost[t];
            End;
          End;
        End;
      End;
    End else
    If mx>=64 then
    Begin
      X:=(mx-64) shr 4+xm;
      Y:=my shr 4+ym;
      B:=0;
      If Ctrl then
      Begin
        For A:=1 to NU do
          If (U[A].X=X) and (U[A].Y=Y) then U[A].sel:=False;
        For A:=1 to NH do
          If (H[A].X=X) and (H[A].Y=Y) then H[A].sel:=False;
      End else
      Begin
        For A:=1 to NU do
          If (U[A].X=X) and (U[A].Y=Y) then B:=1;
        For A:=1 to NH do
          If (H[A].X=X) and (H[A].Y=Y) then B:=B or 2;
        If B<>0 then
        Begin
          If not Shift then For A:=1 to NU do U[A].sel:=False;
          If not Shift or (Shift and (B and 1=1)) then
          Begin
            For A:=1 to NH do H[A].sel:=False;
            For A:=1 to NH do
              If (H[A].X=X) and (H[A].Y=Y) then
              Begin
                H[A].sel:=True;B:=0;
              End;
          End;
          If B=1 then
            For A:=1 to NU do
              If (U[A].X=X) and (U[A].Y=Y) then U[A].sel:=True;
        End;
      End;
    End;
  End;
  If RB then
  Begin
    If (mx>=80) and (mx<304) then
    Begin
      SetDest((mx-64) shr 4 +xm,my shr 4 +ym);
    End else
      If (mx>0) and (mx<mapsize-1) and (my>0) and (my<mapsize-1) then
        SetDest(mx,my);
  End;
End;

Procedure FindWay(Var U1 : TUnit);
Var w : Array[1..mapsize,1..mapsize] of Byte;
x1,y1,x2,y2 : Array[1..3000] of ShortInt;
nn1,nn2,curn : LongInt;
A : LongInt;
  Procedure Try(x,y : ShortInt);
  Begin
    If (x<1) or (X>mapsize-2) or (y<1) or (Y>mapsize-2) then Exit;
    If w[x+1,y+1]<>1 then Exit;
    w[x+1,y+1]:=curn;
    Inc(nn2);
    x2[nn2]:=x;
    y2[nn2]:=y;
  End;
  Procedure Check(x,y : ShortInt);
  Begin
    If (x<1) or (X>mapsize-2) or (y<1) or (Y>mapsize-2) then Exit;
    If w[x+1,y+1]=curn then
    Begin
      U1.xp:=Sign(x-U1.X);
      U1.yp:=sign(y-U1.Y);
    End;
  End;
Begin
  FillChar(way,SizeOf(way),True);
  For A:=1 to NH do way[H[A].X+1,H[A].Y+1]:=False;
  For A:=1 to NU do
  Begin
    If U[A].ofs=0 then Begin X:=U[A].X;Y:=U[A].Y; End else
    Begin X:=U[A].X+U[A].xp;Y:=U[A].Y+U[A].yp; End;
    way[X+1,Y+1]:=False;
  End;
  Move(way,w,SizeOf(w));
  w[U1.X+1,U1.Y+1]:=1;
  w[U1.X1+1,U1.Y1+1]:=3;
  nn1:=1;
  x1[1]:=U1.X1;
  y1[1]:=U1.Y1;
  curn:=4;
  Repeat
    nn2:=0;
    For A:=1 to nn1 do
    Begin
      Try(x1[A]-1,y1[A]-1);
      Try(x1[A],y1[A]-1);
      Try(x1[A]+1,y1[A]-1);
      Try(x1[A]+1,y1[A]);
      Try(x1[A]+1,y1[A]+1);
      Try(x1[A],y1[A]+1);
      Try(x1[A]-1,y1[A]+1);
      Try(x1[A]-1,y1[A]);
    End;
    Inc(curn);
    nn1:=nn2;
    Move(x2,x1,sizeof(x1));
    Move(Y2,Y1,sizeof(Y1));
  Until (curn>250) or (w[U1.X+1,U1.Y+1]>1) or (nn1=0);
  If w[U1.X+1,U1.Y+1]>1 then
  Begin
    x:=U1.X;y:=U1.Y;
    Dec(curn,2);
    U1.xp:=0;
    U1.yp:=0;
    U1.ani:=0;
    Check(x-1,y-1);
    Check(x,y-1);
    Check(x+1,y-1);
    Check(x+1,y);
    Check(x+1,y+1);
    Check(x,y+1);
    Check(x-1,y+1);
    Check(x-1,y);
    Check(X+Sign(U1.X1-U1.X),Y+Sign(U1.Y1-U1.Y));
  End else
  Begin
    U1.Xp:=Sign(U1.X1-U1.X);
    U1.Yp:=Sign(U1.Y1-U1.Y);
  End;
  If not way[U1.X+U1.xp+1,U1.Y+U1.yp+1] then
  Begin U1.Xp:=0; U1.Yp:=0;Exit;U1.dir:=3; End;
  If U1.Xp=1 then U1.dir:=1 else
    If U1.Xp=-1 then U1.dir:=0 else
    If U1.Yp=1 then U1.dir:=3 else U1.dir:=2;
End;

Procedure MakeWays;
Var A,B : Word;
Xp,Yp : Integer;
Begin
  For A:=1 to NU do U[A].del:=False;
  For A:=1 to NH do H[A].del:=False;
  For A:=1 to NU do
    If (U[A].typ>1) and (((U[A].race>1)) or ((U[A].race=1) and (U[A].order=0))) then
    Begin
      If (U[A].race=1) or (U[A].order<>2) then
      For B:=1 to NH do
        If (A<>B) and (U[A].race<>H[B].race) and
           (Abs(U[A].X-H[B].X)<=UnitRange[U[A].typ]) and (Abs(U[A].Y-H[B].Y)<=UnitRange[U[A].typ]) then
        Begin
          U[A].order:=2;
          U[A].OX:=2;
          U[A].OY:=B;
        End;
      For B:=1 to NU do
        If (A<>B) and (U[A].race<>U[B].race) and
           (Abs(U[A].X-U[B].X)<=UnitRange[U[A].typ]) and (Abs(U[A].Y-U[B].Y)<=UnitRange[U[A].typ]) then
        Begin
          U[A].order:=2;
          U[A].OX:=1;
          U[A].OY:=B;
        End;
      If U[A].dolg and ((U[A].X<>U[A].dX) or (U[A].Y<>U[A].dY)) then
      Begin
        U[A].order:=1;
        U[A].X1:=U[A].dX;U[A].Y1:=U[A].dY;
      End;
    End;
  NF:=0;
  For A:=1 to NU do
  Begin
    If (U[A].ofs=0) and (U[A].order=2) then
    Begin
      If U[A].OX=1 then
      Begin
        U[A].X1:=U[U[A].OY].X;
        U[A].Y1:=U[U[A].OY].Y;
      End else
      Begin
        U[A].X1:=H[U[A].OY].X;
        U[A].Y1:=H[U[A].OY].Y;
      End;
      If U[A].wait>UnitWait[U[A].typ]-2 then
      Begin
        Dec(U[A].wait);
        Inc(NF);
        With Fi[NF] do
        Begin
          X1:=U[A].X;X2:=U[A].X1;
          Y1:=U[A].Y;Y2:=U[A].Y1;
          typ:=U[A].typ-1;
          If typ=2 then X1:=UnitWait[3]-U[A].wait+1;
        End;
        U[A].X1:=U[A].X;U[A].Y1:=U[A].Y;
      End else
      If U[A].wait>0 then
      Begin
        Dec(U[A].wait);
        U[A].X1:=U[A].X;U[A].Y1:=U[A].Y;
      End else
      Case U[A].typ of
        2: If (Abs(U[A].X1-U[A].X)<4) and (Abs(U[A].Y1-U[A].Y)<4) then
           Begin
             Inc(NF);
             With Fi[NF] do
             Begin
               X1:=U[A].X;X2:=U[A].X1;
               Y1:=U[A].Y;Y2:=U[A].Y1;
               typ:=1;
             End;
             U[A].wait:=UnitWait[2];
             U[A].X1:=U[A].X;U[A].Y1:=U[A].Y;
             If U[A].OX=1 then
             Begin
               Dec(U[U[A].OY].HP);
               If U[U[A].OY].HP<=0 then
                 U[U[A].OY].del:=True;
             End else
             Begin
               Dec(H[U[A].OY].HP);
               If H[U[A].OY].HP<=0 then
                 H[U[A].OY].del:=True;
             End;
           End;
        3: If (Abs(U[A].X1-U[A].X)<2) and (Abs(U[A].Y1-U[A].Y)<2) then
           Begin
             Inc(NF);
             With Fi[NF] do
             Begin
               X1:=1;
               X2:=U[A].X1;
               Y1:=U[A].Y;Y2:=U[A].Y1;
               typ:=2;
             End;
             U[A].wait:=UnitWait[3];
             U[A].X1:=U[A].X;U[A].Y1:=U[A].Y;
             If U[A].OX=1 then
             Begin
               Dec(U[U[A].OY].HP);
               If U[U[A].OY].HP<=0 then
                 U[U[A].OY].del:=True;
             End else
             Begin
               Dec(H[U[A].OY].HP);
               If H[U[A].OY].HP<=0 then
                 H[U[A].OY].del:=True;
             End;
           End;
      End;
      FindWay(U[A]);
      If (U[A].X=U[A].X1) and (U[A].Y=U[A].Y1) then
      Begin
        U[A].xp:=0;U[A].yp:=0;
      End;
    End;
    If (U[A].ofs=0) and (U[A].order=3) then
    Begin
      If U[A].Wood<MaxWood then
      Begin
        U[A].X1:=U[A].OX;
        U[A].Y1:=U[A].OY;
      End else
      Begin
        U[A].X1:=U[A].X;
        U[A].Y1:=U[A].Y;
        C:=MaxLongInt;
        For B:=1 to NH do
          If H[B].race=U[A].race then
            If (Abs(H[B].Y-U[A].Y)<C) and (Abs(H[B].X-U[A].X)<C) then
            Begin
              If Abs(H[B].Y-U[A].Y)>Abs(H[B].X-U[A].X) then
                C:=Abs(H[B].Y-U[A].Y) else
                C:=Abs(H[B].X-U[A].X);
              D:=B;
            End;
        If C<>MaxLongInt then
        Begin
          U[A].X1:=H[D].X;
          U[A].Y1:=H[D].Y;
        End;
      End;
      If (U[A].Wood>=MaxWood) and (Abs(U[A].X1-U[A].X)<2) and (Abs(U[A].Y1-U[A].Y)<2)
         and ((U[A].X1<>U[A].OX) or (U[A].Y1<>U[A].OY)) then
      Begin
        Inc(mon[U[A].race],OneWood);
        U[A].Wood:=0;
        U[A].xp:=0;
        U[A].yp:=0;
        X:=MaxInt;Y:=MaxInt;
        For B:=1 to mapsize do
          For C:=1 to mapsize do
            If map[B,C]<4 then
            Begin
              If Abs(U[A].X-B+1)>Abs(U[A].Y-C+1) then
                D:=Abs(U[A].X-B+1) else D:=Abs(U[A].Y-C+1);
              If Abs(U[A].X-X+1)>Abs(U[A].Y-Y+1) then
                E:=Abs(U[A].X-X+1) else E:=Abs(U[A].Y-Y+1);
              If D<E then
              Begin
                X:=B;Y:=C;
              End;
              If (D=E) and (Random(3)=0) then
              Begin
                X:=B;Y:=C;
              End;
            End;
        If X=MaxInt then Begin U[A].order:=0;U[A].ani:=0; End else
        Begin
          U[A].OX:=X-1;U[A].OY:=Y-1;
          U[A].X1:=X-1;U[A].Y1:=Y-1;
        End;
      End;

      If (U[A].X1<>U[A].X) or (U[A].Y<>U[A].Y1) then
        FindWay(U[A]) else
        If map[U[A].X+1,U[A].Y+1]<4 then
          Begin
            U[A].xp:=0;
            U[A].yp:=0;
            If U[A].Wood<MaxWood then Inc(U[A].Wood);
            If U[A].Wood>=MaxWood then map[U[A].X+1,U[A].Y+1]:=6;
          End else
          Begin
            X:=MaxInt;Y:=MaxInt;
            For B:=1 to mapsize do
              For C:=1 to mapsize do
                If map[B,C]<4 then
                Begin
                  If Abs(U[A].X-B+1)>Abs(U[A].Y-C+1) then
                    D:=Abs(U[A].X-B+1) else D:=Abs(U[A].Y-C+1);
                  If Abs(U[A].X-X+1)>Abs(U[A].Y-Y+1) then
                    E:=Abs(U[A].X-X+1) else E:=Abs(U[A].Y-Y+1);
                  If D<E then
                  Begin
                    X:=B;Y:=C;
                  End;
                End;
            If X=MaxInt then Begin U[A].order:=0;U[A].ani:=0; End else
            Begin
              U[A].OX:=X-1;U[A].OY:=Y-1;
              U[A].X1:=X-1;U[A].Y1:=Y-1;
              FindWay(U[A]);
            End;
          End;
    End;
    If (U[A].ofs=0) and (U[A].order=1) then
    Begin
      FindWay(U[A]);
    End;
    If (U[A].order<>0) and (U[A].order<>4) then
    Begin
      Inc(U[A].ofs,2);
      If (U[A].X=U[A].X1) and (U[A].Y=U[A].Y1) then U[A].ofs:=16;
      If U[A].ofs=16 then
      Begin
        Inc(U[A].X,U[A].xp);
        Inc(U[A].Y,U[A].yp);
        If (U[A].X=U[A].X1) and (U[A].Y=U[A].Y1) then
        Begin
          U[A].ani:=0;
          U[A].dir:=3;
          If (U[A].order<>3) and (U[A].order<>2) then U[A].Order:=0;
        End;
        U[A].ofs:=0;
      End;
    End;
  End;
  A:=1;
  Repeat
    If U[A].del then
    Begin
      For B:=1 to NU do
        If (U[B].order=2) and (U[B].OX=1) then
          If U[B].OY=A then
          Begin
            U[B].order:=1;
            U[B].X1:=U[B].X;
            U[B].Y1:=U[B].Y;
          End else
          If U[B].OY=NU then U[B].OY:=A;
      U[A]:=U[NU];
      Dec(NU);
      Dec(A);
    End;
    Inc(A);
  Until A>NU;
  A:=1;
  Repeat
    If H[A].del then
    Begin
      For B:=1 to NU do
        If (U[B].order=2) and (U[B].OX=2) then
          If U[B].OY=A then
          Begin
            U[B].order:=1;
            U[B].X1:=U[B].X;
            U[B].Y1:=U[B].Y;
          End else
          If U[B].OY=NH then U[B].OY:=A;
      H[A]:=H[NH];
      Dec(NH);
      Dec(A);
    End;
    Inc(A);
  Until A>NH;
  For A:=1 to NU do
    If (U[A].race=1) and (U[A].X=PresentX) and (U[A].Y=PresentY) then CatchPresent:=True;
End;

Procedure ShowInfo;
Var is : Array[1..3] of Boolean;
Begin
  PrintD('Your Money:',0,130,31);
  Str(Mon[1],S);
  S:=' $'+S+' ';
  PrintD(S,0,140,31);
  B:=0;
  For A:=1 to NU do
    If (U[A].race=1) and (U[A].sel) and (U[A].typ=1) then Inc(B);
  If B=1 then
  Begin
    For A:=1 to NU do
      If (U[A].race=1) and (U[A].sel) and (U[A].typ<>1) then B:=0;
    If B=1 then
    Begin
      PrintD('Build:',0,50,31);
      ShowSprD(0,60,Col[1],Spr[13]);
      If mon[1]<300 then
        PrintD('300',0,80,4) else
        PrintD('300',0,80,31);
      FillChar(is,Sizeof(is),False);
      For A:=1 to NH do
        If H[A].race=1 then is[H[A].typ]:=True;
      If is[1] then
      Begin
        ShowSprD(20,60,Col[1],Spr[14]);
        If mon[1]<100 then
          PrintD('100',20,80,4) else
          PrintD('100',20,80,31);
      End;
      If is[2] then
      Begin
        ShowSprD(40,60,Col[1],Spr[15]);
        If mon[1]<500 then
          PrintD('500',40,80,4) else
          PrintD('500',40,80,31);
      End;
      ReadMouseState(mx,my,lb,mb,rb);
      mx:=mx shr 1;
      If (mx<20) and (my>=60) and (my<80) then
      Begin
        S:='Left mouse button to build Town Hall. Cost:$300';
        PrintD(S,(320-Length(S)*6) shr 1,193,31);;
      End else
      If is[1] and (mx<40) and (my>=60) and (my<80) then
      Begin
        S:='Left mouse button to build Barracks. Cost:$100';
        PrintD(S,(320-Length(S)*6) shr 1,193,31);;
      End else
      If is[2] and (mx<60) and (my>=60) and (my<80) then
      Begin
        S:='Left mouse button to build Stable. Cost:$500';
        PrintD(S,(320-Length(S)*6) shr 1,193,31);;
      End;
    End;
  End;
  B:=0;
  For A:=1 to NH do
    If (H[A].race=1) and (H[A].sel) then Begin Inc(B);C:=A; End;
  If (B=1) and (H[C].order=0) then
  Begin
    PrintD('Produce',0,50,31);
    ShowSprD(0,60,Col[1],Spr[20+H[C].typ*12]);
    Str(UnitCost[H[C].typ],S);
    S:='$'+S;
    If mon[1]<UnitCost[H[C].typ] then
      PrintD(S,0,80,4) else
      PrintD(S,0,80,31);
    ReadMouseState(mx,my,lb,mb,rb);
    mx:=mx shr 1;
    If (mx<20) and (my>=60) and (my<90) then
    Begin
      S:='Left mouse button to produce '+UnitName[H[C].typ]+'. Cost:'+S;
      PrintD(S,(320-Length(S)*6) shr 1,193,31);;
    End;
  End;
End;

Procedure CPUMove;
Var is : Array[1..3] of Byte;
Begin
  FillChar(is,SizeOf(is),0);
  For A:=1 to NU do
    If U[A].race>1 then Inc(is[U[A].typ]);
  If (is[1]<5) and (mon[2]>=UnitCost[1]) then
  Begin
    For A:=1 to NH do
      If (H[A].race>1) and (H[A].typ=1) and (H[A].order=0) then
      Begin
        Dec(mon[2],UnitCost[1]);
        H[A].order:=2;
        H[A].progress:=UnitCost[1];
        Break;
      End;
  End;
  FillChar(is,SizeOf(is),0);
  For A:=1 to NH do
    If H[A].race>1 then Inc(is[H[A].typ]);
  If (is[1]=0) and (mon[2]>=HouseCost[1]) then
  Begin
    For A:=1 to NU do
      If (U[A].race>1) and (U[A].typ=1) and (U[A].order<>4) then
      Begin
        Dec(mon[2],HouseCost[1]);
        U[A].order:=4;
        U[A].ani:=0;U[A].xp:=0;U[A].yp:=0;U[A].x1:=U[A].x;U[A].y1:=U[A].y;
        U[A].sel:=False;
        Inc(NH);
        With H[NH] do
        Begin
          X:=U[A].X;
          Y:=U[A].Y;
          Typ:=1;HP:=HouseHP[1];race:=2;sel:=False;order:=1;
          Progress:=HouseCost[1];
        End;
        Break;
      End;
  End;
  If (is[1]>0) and ((is[2]<1) or (Random(1000)=976)) and (mon[2]>=HouseCost[2]) then
  Begin
    For A:=1 to NU do
      If (U[A].race>1) and (U[A].typ=1) and (U[A].order<>4) then
      Begin
        Dec(mon[2],HouseCost[2]);
        U[A].order:=4;
        U[A].ani:=0;U[A].xp:=0;U[A].yp:=0;U[A].x1:=U[A].x;U[A].y1:=U[A].y;
        U[A].sel:=False;
        Inc(NH);
        With H[NH] do
        Begin
          X:=U[A].X;
          Y:=U[A].Y;
          Typ:=2;HP:=HouseHP[2];race:=2;sel:=False;order:=1;
          Progress:=HouseCost[2];
        End;
        Break;
      End;
  End;
  If (is[1]>0) and (is[2]>0) and ((is[3]<1) or (Random(1200)=654)) and (mon[2]>=HouseCost[3]) then
  Begin
    For A:=1 to NU do
      If (U[A].race>1) and (U[A].typ=1) and (U[A].order<>4) then
      Begin
        Dec(mon[2],HouseCost[3]);
        U[A].order:=4;
        U[A].ani:=0;U[A].xp:=0;U[A].yp:=0;U[A].x1:=U[A].x;U[A].y1:=U[A].y;
        U[A].sel:=False;
        Inc(NH);
        With H[NH] do
        Begin
          X:=U[A].X;
          Y:=U[A].Y;
          Typ:=3;HP:=HouseHP[3];race:=2;sel:=False;order:=1;
          Progress:=HouseCost[3];
        End;
        Break;
      End;
  End;
  B:=0;
  For A:=1 to NU do
    If (U[A].race>1) and (U[A].typ>1) and not U[A].dolg and (U[A].order<>2) then
      Inc(B);
  If B>14 then B:=9 else B:=0;
  For A:=1 to NU do
    If (U[A].race>1) and (U[A].typ=1) and (U[A].order<3) then
    Begin
      U[A].order:=3;
      X:=MaxInt;Y:=MaxInt;
      For B:=1 to mapsize do
        For C:=1 to mapsize do
          If map[B,C]<4 then
          Begin
            If Abs(U[A].X-B+1)>Abs(U[A].Y-C+1) then
              D:=Abs(U[A].X-B+1) else D:=Abs(U[A].Y-C+1);
            If Abs(U[A].X-X+1)>Abs(U[A].Y-Y+1) then
              E:=Abs(U[A].X-X+1) else E:=Abs(U[A].Y-Y+1);
            If D<E then
            Begin
              X:=B;Y:=C;
            End;
            If (D=E) and (Random(3)=0) then
            Begin
              X:=B;Y:=C;
            End;
          End;
      If X=MaxInt then Begin U[A].order:=0;U[A].ani:=0; End else
      Begin
        U[A].OX:=X-1;U[A].OY:=Y-1;
        U[A].X1:=X-1;U[A].Y1:=Y-1;
      End;
    End else
    If (U[A].race>1) and (U[A].typ>1) and not U[A].dolg and (U[A].order<>2) then
    Begin
      If B=0 then
      Begin
        U[A].order:=1;
        U[A].X1:=PresentX-14;
        U[A].Y1:=PresentY-2;
      End else
      Begin
        Dec(B);
        For C:=1 to NH do
          If H[C].race=1 then
          Begin
            U[A].order:=2;
            U[A].OX:=2;U[A].OY:=C;
          End;
        If U[A].order<>2 then
        For C:=1 to NU do
          If U[C].race=1 then
          Begin
            U[A].order:=2;
            U[A].OX:=1;U[A].OY:=C;
          End;
      End;
    End;
  For A:=1 to NH do
    If (H[A].race>1) and (H[A].typ>1) and (H[A].order=0) and (mon[2]>=UnitCost[H[A].typ]) and (Random(50)=48) then
    Begin
      Dec(mon[2],UnitCost[H[A].typ]);
      H[A].order:=2;
      H[A].progress:=UnitCost[H[A].typ];
    End;
End;

Procedure ShowBirthday; near; external;
{$L balls}

begin
  CatchPresent:=False;
  EventOn:=False;
  Randomize;
  GrInit;
  Cls(0);
  For A:=1 to 58 do
    Spr[A]:=Ptr(Seg(Sprites),Ofs(Sprites)+16*16*(A-1));
  SetPalReg(15,0,0,0);
  GetPalette(Pal);
  FillChar(NullPal,768,0);
  ClsD(0);
  SetPalette(Pal);
  GenMap;
  ShowMouse;
  ClsD(0);
{  X:=0;Y:=0;
  for a:=1 to 58 do
  Begin
  showsprd(X,Y,col[1],spr[a]);
  Inc(X,16);
  If X>320-16 then Inc(Y,16);
  If X>320-16 then X:=0;
  End;
  showdouble;
  readkey;}
  S[1]:=#1;
  EventOn:=True;
  Repeat
    Time:=Timer;
    ClsD(0);
    ShowMinimap;
    ShowBigMap;
    ShowInfo;
    Repeat
    Until Timer-Time<>0;
    VRT;
    ShowDouble;
    ReadMouseState(mx,my,Lb,Mb,Rb);
    mx:=mx shr 1;
    If (mx<=0) and (xm>0) then Dec(xm);
    If (my<=0) and (ym>0) then Dec(ym);
    If (mx>303) and (xm<mapsize-16) then Inc(xm);
    If (my>183) and (ym<mapsize-12) then Inc(ym);
    EventOn:=False;
    CPUMove;
    MakeWays;
    EventOn:=True;
    If KeyPressed then
    Begin
      S[1]:=ReadKey;
    End;
  Until (S[1]=#27) or CatchPresent;
  EventOn:=False;
  HideMouse;
  GrDone;
  If CatchPresent then
    ShowBirthday;
end.