' Thanks for inquiring about my tile editor with super sloppy code.
' As you can see, the editor is tailored to make and save and load and edit
' 20x20 tiles in a normal screen 13 palette. And as an added bonus, it's 100%
' mouse compatible. If you are trying to be the nzp graphic artist, please
' try and draw some stuff up like grass, trees, water, pathway, swords, and
' whatever else, so we see your skill level.
'
' VERSION .08 UPDATE: The picture and colors can be selected and edited with
'                     mouse OR keyboard.
'
' Thanks!
' neozones@geocities.com
' www.geocities.com/~neozones/basfiles/tileed.zip

DEFINT A-Z
DECLARE SUB Center (row%, colour%, text$)
DECLARE FUNCTION MouseInit% ()
DECLARE SUB MouseStatus (Lb%, rb%, xMouse%, yMouse%)
DECLARE SUB MouseRange (X1%, Y1%, x2%, Y2%)
DECLARE SUB MousePut (x%, y%)
DECLARE SUB MouseHide ()
DECLARE SUB MouseDriver (ax%, bx%, cx%, dx%)
DECLARE SUB MouseShow ()
DECLARE SUB MouseLoad ()
DECLARE SUB SetupScreen ()
DECLARE SUB InvertPicture ()
DECLARE SUB LoadTile ()
DECLARE SUB ExitProg ()
DECLARE SUB SaveTile ()

TYPE ColoursType
 High    AS INTEGER
 Norm    AS INTEGER
END TYPE

TYPE BoxLocType
 PalX    AS INTEGER
 PalY    AS INTEGER
 PicX    AS INTEGER
 PicY    AS INTEGER
END TYPE

CONST Dropper = 1, Fill = 2, Drawer = 3
CONST PickColor = 1, EditPic = 2


DIM SHARED Colours AS ColoursType
DIM SHARED BoxLoc AS BoxLocType
DIM SHARED Mouse$, Version$, Tool
DIM SHARED Pic(1 TO 20, 1 TO 20)

Colours.High = 9
Colours.Norm = 15
BoxLoc.PalX = 1
BoxLoc.PalY = 1
BoxLoc.PicX = 1
BoxLoc.PicY = 0

Mouse$ = SPACE$(57)
Version$ = ".08"
KeyOption = PickColor

CLS
SCREEN 13

MouseLoad
SetupScreen
MouseShow
MouseRange 0, 0, 630, 198

Tool = Drawer

DO
 MouseStatus Lb, rb, x, y

 SELECT CASE Lb%
  CASE -1
   IF x / 2 > 20 AND y > 20 AND x / 2 < 120 AND y <= 120 THEN
    FOR i = 20 TO 115 STEP 5
     IF x / 2 >= i AND x / 2 <= i + 5 THEN xval = i
     IF y >= i AND y <= i + 5 THEN yval = i
    NEXT i
   
    SELECT CASE Tool
     CASE Dropper
      LCol = POINT(x / 2 - 1, y - 1)
      LINE (257, 165)-STEP(20, 23), LCol, BF
      LOCATE 20, 32
      PRINT LCol; " "
    
     CASE Fill
      MouseHide
      FOR i = 1 TO 20
       FOR j = 1 TO 20
        Pic(i, j) = LCol
        PSET (i + 123, j + 21), LCol
        LINE (i * 5 + 16, j * 5 + 16)-STEP(3, 3), LCol, BF
       NEXT j
      NEXT i
      MouseShow
    
     CASE Drawer
      MouseHide
      LINE (xval + 1, yval + 1)-STEP(3, 3), LCol, BF
      PSET (xval / 5 - 3 + 123, yval / 5 - 3 + 21), LCol
      Pic(xval / 5 - 3, yval / 5 - 3) = LCol
      MouseShow
    END SELECT
   END IF

   IF y >= 160 THEN
    MouseHide
    LCol = POINT(x / 2 - 1, y - 1)
    LINE (257, 165)-STEP(20, 23), LCol, BF
    LOCATE 20, 32
    PRINT LCol; " "
    MouseShow
   END IF

 END SELECT
 
 SELECT CASE rb%
  CASE -1
   IF x / 2 > 20 AND y > 20 AND x / 2 < 120 AND y <= 120 THEN
    FOR i = 20 TO 115 STEP 5
     IF x / 2 >= i AND x / 2 <= i + 5 THEN xval = i
     IF y >= i AND y <= i + 5 THEN yval = i
    NEXT i
   
    SELECT CASE Tool
     CASE Dropper
      rcol = POINT(x / 2 - 1, y - 1)
      LINE (308, 165)-STEP(-20, 23), rcol, BF
      LOCATE 20, 36
      IF LEN(LTRIM$(RTRIM$(STR$(rcol)))) = 1 THEN PRINT rcol; " " ELSE PRINT RTRIM$(STR$(rcol))
    
     CASE Fill
      MouseHide
      FOR i = 1 TO 20
       FOR j = 1 TO 20
        Pic(i, j) = rcol
        PSET (i + 123, j + 21), rcol
        LINE (i * 5 + 16, j * 5 + 16)-STEP(3, 3), rcol, BF
       NEXT j
      NEXT i
      MouseShow
    
     CASE Drawer
      MouseHide
      LINE (xval + 1, yval + 1)-STEP(3, 3), rcol, BF
      PSET (xval / 5 - 3 + 123, yval / 5 - 3 + 21), rcol
      Pic(xval / 5 - 3, yval / 5 - 3) = rcol
      MouseShow
    END SELECT
  
   END IF

   IF y >= 160 THEN
    MouseHide
    rcol = POINT(x / 2 - 1, y - 1)
    LOCATE 20, 36
    IF LEN(LTRIM$(RTRIM$(STR$(rcol)))) = 1 THEN PRINT rcol; " " ELSE PRINT RTRIM$(STR$(rcol))
    LINE (308, 165)-STEP(-20, 23), rcol, BF
    MouseShow
   END IF

 END SELECT
 
 kbd$ = INKEY$
 IF kbd$ <> "" THEN
  SELECT CASE LCASE$(kbd$)
   CASE "c"
    KeyOption = PickColor
   CASE "e"
    KeyOption = EditPic
  
   CASE "d"
    Tool = Dropper
    MouseHide
    LOCATE 5, 30
    PRINT "X"
    LOCATE 6, 30
    PRINT " "
    LOCATE 7, 30
    PRINT " "
    MouseShow
   CASE "f"
    Tool = Fill
    MouseHide
    LOCATE 5, 30
    PRINT " "
    LOCATE 6, 30
    PRINT "X"
    LOCATE 7, 30
    PRINT " "
    MouseShow
   CASE "w"
    MouseHide
    Tool = Drawer
    LOCATE 5, 30
    PRINT " "
    LOCATE 6, 30
    PRINT " "
    LOCATE 7, 30
    PRINT "X"
    MouseShow
   CASE "i"
    InvertPicture
  
   CASE "l"
    MouseHide
    LoadTile
    LOCATE 20, 2
    PRINT SPACE$(30)
    MouseShow
   CASE "s"
    MouseHide
    SaveTile
    LOCATE 20, 2
    PRINT SPACE$(30)
    MouseShow
   CASE "x"
    MouseHide
    ExitProg
    MouseShow
  END SELECT
  SELECT CASE kbd$
   CASE " "
    SELECT CASE KeyOption
     CASE PickColor
      LCol = POINT(BoxLoc.PalX * 5, BoxLoc.PalY * 5 + 160)
      MouseHide
      LINE (257, 165)-STEP(20, 23), LCol, BF
      LOCATE 20, 32
      PRINT LCol; " "
      MouseShow
     CASE EditPic
      SELECT CASE Tool
       CASE Dropper
        LCol = POINT(BoxLoc.PicX * 5 + 16, BoxLoc.PicY * 5 + 21)
        LINE (257, 165)-STEP(20, 23), LCol, BF
        LOCATE 20, 32
        PRINT LCol; " "
       CASE Fill
        MouseHide
        FOR i = 1 TO 20
         FOR j = 1 TO 20
          Pic(i, j) = LCol
          PSET (i + 123, j + 21), LCol
          LINE (i * 5 + 16, j * 5 + 16)-STEP(3, 3), LCol, BF
         NEXT j
        NEXT i
        MouseShow
       CASE Drawer
        MouseHide
        LINE (BoxLoc.PicX * 5 + 16, BoxLoc.PicY * 5 + 21)-STEP(3, 3), LCol, BF
        PSET (BoxLoc.PicX + 123, BoxLoc.PicY + 22), LCol
        Pic(BoxLoc.PicX, BoxLoc.PicY + 1) = LCol
        MouseShow
     
      END SELECT
    END SELECT
  
   CASE CHR$(0) + "H" ' Up
    SELECT CASE KeyOption
     CASE PickColor
      LINE (BoxLoc.PalX * 5 - 1, BoxLoc.PalY * 5 + 159)-STEP(5, 5), 0, B
      BoxLoc.PalY = BoxLoc.PalY - 1
      IF BoxLoc.PalY = 0 THEN BoxLoc.PalY = 5
      LINE (BoxLoc.PalX * 5 - 1, BoxLoc.PalY * 5 + 159)-STEP(5, 5), 40, B
     CASE EditPic
      LINE (BoxLoc.PicX * 5 + 15, BoxLoc.PicY * 5 + 20)-STEP(5, 5), 19, B
      BoxLoc.PicY = BoxLoc.PicY - 1
      IF BoxLoc.PicY = -1 THEN BoxLoc.PicY = 19
      LINE (BoxLoc.PicX * 5 + 15, BoxLoc.PicY * 5 + 20)-STEP(5, 5), 40, B
     END SELECT
   CASE CHR$(0) + "P" ' Down
    SELECT CASE KeyOption
     CASE PickColor
      LINE (BoxLoc.PalX * 5 - 1, BoxLoc.PalY * 5 + 159)-STEP(5, 5), 0, B
      BoxLoc.PalY = BoxLoc.PalY + 1
      IF BoxLoc.PalY = 6 THEN BoxLoc.PalY = 1
      LINE (BoxLoc.PalX * 5 - 1, BoxLoc.PalY * 5 + 159)-STEP(5, 5), 40, B
     CASE EditPic
      LINE (BoxLoc.PicX * 5 + 15, BoxLoc.PicY * 5 + 20)-STEP(5, 5), 19, B
      BoxLoc.PicY = BoxLoc.PicY + 1
      IF BoxLoc.PicY = 20 THEN BoxLoc.PicY = 0
      LINE (BoxLoc.PicX * 5 + 15, BoxLoc.PicY * 5 + 20)-STEP(5, 5), 40, B
     END SELECT
   CASE CHR$(0) + "K" ' Left
    SELECT CASE KeyOption
     CASE PickColor
      LINE (BoxLoc.PalX * 5 - 1, BoxLoc.PalY * 5 + 159)-STEP(5, 5), 0, B
      BoxLoc.PalX = BoxLoc.PalX - 1
      IF BoxLoc.PalX = 0 THEN BoxLoc.PalX = 50
      LINE (BoxLoc.PalX * 5 - 1, BoxLoc.PalY * 5 + 159)-STEP(5, 5), 40, B
     CASE EditPic
      LINE (BoxLoc.PicX * 5 + 15, BoxLoc.PicY * 5 + 20)-STEP(5, 5), 19, B
      BoxLoc.PicX = BoxLoc.PicX - 1
      IF BoxLoc.PicX = 0 THEN BoxLoc.PicX = 20
      LINE (BoxLoc.PicX * 5 + 15, BoxLoc.PicY * 5 + 20)-STEP(5, 5), 40, B
    END SELECT
   CASE CHR$(0) + "M" ' Right
    SELECT CASE KeyOption
     CASE PickColor
      LINE (BoxLoc.PalX * 5 - 1, BoxLoc.PalY * 5 + 159)-STEP(5, 5), 0, B
      BoxLoc.PalX = BoxLoc.PalX + 1
      IF BoxLoc.PalX = 51 THEN BoxLoc.PalX = 1
      LINE (BoxLoc.PalX * 5 - 1, BoxLoc.PalY * 5 + 159)-STEP(5, 5), 40, B
     CASE EditPic
      LINE (BoxLoc.PicX * 5 + 15, BoxLoc.PicY * 5 + 20)-STEP(5, 5), 19, B
      BoxLoc.PicX = BoxLoc.PicX + 1
      IF BoxLoc.PicX = 21 THEN BoxLoc.PicX = 1
      LINE (BoxLoc.PicX * 5 + 15, BoxLoc.PicY * 5 + 20)-STEP(5, 5), 40, B
     END SELECT
 
  END SELECT


 END IF

keeplooping:
LOOP




MouseData:
DATA 55,89,E5,8B,5E,0C,8B,07,50,8B,5E,0A,8B,07,50,8B
DATA 5E,08,8B,0F,8B,5E,06,8B,17,5B,58,1E,07,CD,33,53
DATA 8B,5E,0C,89,07,58,8B,5E,0A,89,07,8B,5E,08,89,0F
DATA 8B,5E,06,89,17,5D,CA,08,00

SUB Center (row, colour, text$)

LOCATE row, 20 - LEN(text$) / 2
COLOR colour
PRINT text$

END SUB

SUB ExitProg
LOCATE 20, 2
Center 20, 15, "Are you sure [y/n]"
DO
 kbd$ = INKEY$
 IF kbd$ <> "" THEN
  SELECT CASE LCASE$(kbd$)
   CASE "y"
    END
   CASE "n"
    LOCATE 20, 2
    PRINT SPACE$(30)
    EXIT DO
  END SELECT
 END IF
LOOP



END SUB

SUB InvertPicture



END SUB

SUB LoadTile

LOCATE 20, 2
INPUT "Name: ", filename$
IF filename$ = "" THEN EXIT SUB
 
OPEN filename$ FOR INPUT AS #1

   fromh = 1
   toh = 20
   steph = 1
   fromv = 1
   tov = 20
   stepv = 1

IF LEFT$(filename$, 1) = "#" THEN
   fromh = 20
   toh = 1
   steph = -1
   END IF
IF LEFT$(filename$, 1) = "$" THEN
   fromv = 20
   tov = 1
   stepv = -1
   END IF
FOR i = fromv TO tov STEP stepv
FOR j = fromh TO toh STEP steph
  INPUT #1, col
  Pic(i, j) = col
  PSET (i + 123, j + 21), col
  LINE (i * 5 + 16, j * 5 + 16)-STEP(3, 3), col, BF
 NEXT j
NEXT i

LOCATE 20, 2
CLOSE #1
PRINT SPACE$(30)
  


END SUB

DEFLNG A-Z
SUB MouseDriver (ax%, bx%, cx%, dx%)
  DEF SEG = VARSEG(Mouse$)
  Mouse% = SADD(Mouse$)
  CALL Absolute(ax%, bx%, cx%, dx%, Mouse%)
END SUB

SUB MouseHide
 ax% = 2
 MouseDriver ax%, 0, 0, 0
END SUB

FUNCTION MouseInit%
  ax% = 0
  MouseDriver ax%, 0, 0, 0
  MouseInit% = ax%
END FUNCTION

DEFINT A-Z
SUB MouseLoad

RESTORE MouseData
FOR i = 1 TO 57
 READ a$
 H$ = CHR$(VAL("&H" + a$))
 MID$(Mouse$, i, 1) = H$
NEXT i
RESTORE

ms% = MouseInit%

IF NOT ms% THEN
 PRINT "Mouse not found"
 END
END IF



END SUB

DEFLNG A-Z
SUB MousePut (x%, y%)
  ax% = 4
  cx% = x%
  dx% = y%
  MouseDriver ax%, 0, cx%, dx%
END SUB

SUB MouseRange (X1%, Y1%, x2%, Y2%)
  ax% = 7
  cx% = X1%
  dx% = x2%
MouseDriver ax%, 0, cx%, dx%
  ax% = 8
  cx% = Y1%
  dx% = Y2%
  MouseDriver ax%, 0, cx%, dx%
END SUB

SUB MouseShow
  ax% = 1
  MouseDriver ax%, 0, 0, 0
END SUB

SUB MouseStatus (Lb%, rb%, xMouse%, yMouse%)
  ax% = 3
  MouseDriver ax%, bx%, cx%, dx%
  Lb% = ((bx% AND 1) <> 0)
  rb% = ((bx% AND 2) <> 0)
  xMouse% = cx%
  yMouse% = dx%
END SUB

DEFINT A-Z
SUB SaveTile
LOCATE 20, 2
INPUT "Name: ", filename$
IF LEFT$(filename$, 1) = "@" THEN GOTO REVERSE
IF filename$ = "" THEN EXIT SUB
OPEN filename$ FOR OUTPUT AS #1
FOR i = 1 TO 20
 FOR j = 1 TO 20
  IF j = 20 THEN
   B$ = B$ + LTRIM$(RTRIM$(STR$(Pic(i, j))))
  ELSE
   B$ = B$ + LTRIM$(RTRIM$(STR$(Pic(i, j)) + ","))
  END IF
 NEXT j
 PRINT #1, B$
 B$ = ""
NEXT i
CLOSE #1
GOTO ENDS
REVERSE:
IF filename$ = "" THEN EXIT SUB
OPEN filename$ + ".til" FOR OUTPUT AS #1
FOR i = 20 TO 1 STEP -1
 FOR j = 1 TO 20
  IF j = 1 THEN
   B$ = B$ + LTRIM$(RTRIM$(STR$(Pic(i, j))))
  ELSE
   B$ = B$ + LTRIM$(RTRIM$(STR$(Pic(i, j)) + ","))
  END IF
 NEXT j
 PRINT #1, B$
 B$ = ""
NEXT i
CLOSE #1



ENDS:
END SUB

SUB SetupScreen

FOR i = 20 TO 120 STEP 5
 LINE (i, 20)-(i, 120), 19
 LINE (20, i)-(120, i), 19
NEXT i

s = 5

FOR i = 0 TO 250 STEP 5
 LINE (i + s, 165)-STEP(3, 3), i, BF
 LINE (i + s, 170)-STEP(3, 3), i + 1, BF
 LINE (i + s, 175)-STEP(3, 3), i + 2, BF
 LINE (i + s, 180)-STEP(3, 3), i + 3, BF
 LINE (i + s, 185)-STEP(3, 3), i + 4, BF
NEXT i



'COLOR 15
Center 1, 15, "NZP 20x20 Tile Editor - v" + Version$

LINE (122, 20)-STEP(23, 23), 19, B
LINE (1, 10)-(319, 199), 40, B
LINE (2, 11)-(318, 198), 4, B

LOCATE 18, 2

COLOR Colours.High: PRINT "L"; : COLOR Colours.Norm: PRINT "oad "; : COLOR Colours.High: PRINT "S";
COLOR Colours.Norm: PRINT "ave E"; : COLOR Colours.High: PRINT "x"; : COLOR Colours.Norm: PRINT "it"

COLOR Colours.Norm

LOCATE 3, 33
PRINT "Tools:"
LOCATE 5, 29
PRINT "[ ] "; : COLOR Colours.High: PRINT "D"; : COLOR Colours.Norm: PRINT "ropper"
LOCATE 6, 29
PRINT "[ ] "; : COLOR Colours.High: PRINT "F"; : COLOR Colours.Norm: PRINT "ill"
LOCATE 7, 29
PRINT "[X] Dra"; : COLOR Colours.High: PRINT "w"
COLOR Colours.Norm

LINE (27 * 8, 58)-(318, 58), 40
LINE (27 * 8 + 1, 59)-(318, 59), 4
LINE (BoxLoc.PalX * 5 - 1, BoxLoc.PalY * 5 + 159)-STEP(5, 5), 40, B
LINE (BoxLoc.PicX * 5 + 15, BoxLoc.PicY * 5 + 20)-STEP(5, 5), 40, B
LOCATE 9, 29
COLOR Colours.High: PRINT "C"; : COLOR Colours.Norm: PRINT "olor"
LOCATE 10, 29
COLOR Colours.High: PRINT "E"; : COLOR Colours.Norm: PRINT "dit tile"



END SUB

