DEFINT A-Z
'$DYNAMIC

' *** France '98 ***
'
' World Cup Soccer Sim
'
' 1998 - Pasco
'
' Technical Advisors / Playtesting :
'                                   Ross Dunbar
'                                   Ben McNair
'
' Arrows Move
' Space Lobs
' Ctrl Shoots
' Alt Passes/switches to ball's nearest player

'$INCLUDE: 'dims.bas'
ON ERROR GOTO abort

IF INSTR(COMMAND$, "-FPS") THEN fpson = 1

DEF SEG = VARSEG(kbcontrol(0))
BLOAD "keyb.prg", 0
kbcontrol(128) = VARSEG(kbmatrix(0))
kbcontrol(129) = VARPTR(kbmatrix(0))
CALL ABSOLUTE(&H180)
FOR lp = 0 TO 128
	kbmatrix(lp) = 0
NEXT
kbinit = 1
Startup
InitGFX
Title
MainMenu

Startup2

Getteams

InitField

t1num = FIX(RND * 32)
DO
t2num = FIX(RND * 32)
LOOP UNTIL t2num <> t1num

OPEN "graphics\flags2.raw" FOR BINARY ACCESS READ AS #1
FOR lp = 0 TO 31
	IF lp = t1num THEN ct = 0
	IF lp = t2num THEN ct = 1
 
	Spriteinfo(ct + 200).Segment = VARSEG(flags(1, ct)): Spriteinfo(ct + 200).Offset = VARPTR(flags(1, ct))
	Spriteinfo(ct + 200).xsize = 31: Spriteinfo(ct + 200).ysize = 26
	DEF SEG = Spriteinfo(ct + 200).Segment
	of = Spriteinfo(ct + 200).Offset
	FOR y = 0 TO 26
		FOR x = 0 TO 31
			POKE x + y * 32 + of, ASC(INPUT$(1, 1))
		NEXT
	NEXT
	IF lp = t1num THEN ct = 1: nd = nd + 1
	IF lp = t2num THEN ct = 0: nd = nd + 1
	IF nd = 2 THEN GOTO gotteams
NEXT

gotteams:
CLOSE
RESTORE teamabbrev
FOR lp = 0 TO t1num
	READ ab$
NEXT

OPEN "data\" + ab$ + ".wct" FOR INPUT AS #1

FOR lp = 1 TO 22
LINE INPUT #1, pn$
pn = VAL(pn$)
LINE INPUT #1, pname$
IF pn > 22 THEN SOUND 800, 3
playernames(pn, 0) = pname$
LINE INPUT #1, jnk$
NEXT
CLOSE

RESTORE teamabbrev
FOR lp = 0 TO t2num
	READ ab$
NEXT

OPEN "data\" + ab$ + ".wct" FOR INPUT AS #1

FOR lp = 1 TO 22
LINE INPUT #1, pn$
pn = VAL(pn$)
LINE INPUT #1, pname$
playernames(pn, 1) = pname$
LINE INPUT #1, jnk$
NEXT
CLOSE

RESTORE balldists:
FOR lp = 0 TO 7
READ balldists(lp)
NEXT

ymax = 199
sprite 0, 168, 1899, -1
sprite 2, 171, 200, -1
sprite 285, 171, 201, -1

ymax = 167


RANDOMIZE TIMER
stime! = TIMER
DO
	whohad = btnum * 50 + bpnum
	frames& = frames& + 1
	n = 0
	dodrawlines = 0
	kbmatrix(128) = 0
	obx = ballx: oby = bally: obz = ballz
	obpnum = bpnum
	obtnum = btnum
	anyposess = 0
	noactive = 1
	FOR tnum = 0 TO 1
		FOR pnum = 0 TO 10
			teams(tnum, pnum).ox = teams(tnum, pnum).xpos: teams(tnum, pnum).oy = teams(tnum, pnum).ypos
			IF teams(tnum, pnum).active = 1 AND isdemo = 0 THEN
				noactive = noactive - 1
			IF pnum = 0 THEN RightKeeper tnum, pnum
			IF kickin = 0 THEN teams(tnum, pnum).xpos = teams(tnum, pnum).xpos + (kbmatrix(77) - kbmatrix(75)) * 4: teams(tnum, pnum).ypos = teams(tnum, pnum).ypos + (kbmatrix(80) - kbmatrix(72)) * 4
		  
			ELSE
				IF pnum = 0 THEN
					IF tnum = 0 THEN LeftKeeper tnum, pnum ELSE RightKeeper tnum, pnum
					GOTO keeperdone:
				END IF
			n = n + 1
			DoAI tnum, pnum
		  
			END IF
keeperdone:
			IF teams(tnum, pnum).ox <> teams(tnum, pnum).xpos OR teams(tnum, pnum).oy <> teams(tnum, pnum).ypos THEN teams(tnum, pnum).frame = (teams(tnum, pnum).frame + 1) MOD 8: teams(tnum, pnum).lastdx = teams(tnum, pnum).xpos - teams(tnum, pnum).ox _
: teams(tnum, pnum).lastdy = teams(tnum, pnum).ypos - teams(tnum, pnum).oy ELSE teams(tnum, pnum).frame = 2
			IF teams(tnum, pnum).xpos < teams(tnum, pnum).ox THEN teams(tnum, pnum).dir = 0
			IF teams(tnum, pnum).xpos > teams(tnum, pnum).ox THEN teams(tnum, pnum).dir = 1
			IF teams(tnum, pnum).ypos < teams(tnum, pnum).oy THEN teams(tnum, pnum).dir = 2
			IF teams(tnum, pnum).ypos > teams(tnum, pnum).oy THEN teams(tnum, pnum).dir = 3
			IF pnum = 0 THEN teams(tnum, pnum).dir = 1 - tnum: teams(tnum, pnum).frame = 2
			IF ABS(teams(tnum, pnum).xpos - ballx) <= 6 AND ABS(teams(tnum, pnum).ypos - bally) <= 6 AND ABS(teams(tnum, pnum).zpos - ballz) < 3.4 THEN
				'IF pnum <> obpnum OR tnum <> obtnum OR pnum = 0 THEN
				IF tnum * 50 + pnum <> whohad OR pnum = 0 THEN
					teams(btnum, bpnum).posession = 0: teams(tnum, pnum).posession = 1
					IF tnum = 1 THEN teams(btnum, bpnum).active = 0
					btnum = tnum: bpnum = pnum
					IF tnum = 1 THEN teams(tnum, pnum).active = 1
				END IF
			END IF
			IF teams(tnum, pnum).posession = 1 THEN
				anyposess = 1
				'btnum = tnum: bpnum = pnum
				balldx = 0
				balldy = 0
				balldz = 0
				ballz = teams(tnum, pnum).zpos
				SELECT CASE teams(tnum, pnum).dir
					CASE 0: ballx = teams(tnum, pnum).xpos - balldists(teams(tnum, pnum).frame): bally = teams(tnum, pnum).ypos
					CASE 1: ballx = teams(tnum, pnum).xpos + balldists(teams(tnum, pnum).frame): bally = teams(tnum, pnum).ypos
					CASE 2: ballx = teams(tnum, pnum).xpos: bally = teams(tnum, pnum).ypos - balldists(teams(tnum, pnum).frame)
					CASE 3: ballx = teams(tnum, pnum).xpos: bally = teams(tnum, pnum).ypos + balldists(teams(tnum, pnum).frame)
				END SELECT
			END IF
		
			IF teams(tnum, pnum).posession = 1 THEN
				kickthistime = 0
				IF kbmatrix(57) AND teams(tnum, pnum).posession = 1 AND teams(tnum, pnum).active = 1 THEN
					ballgravity = .15
					kickthistime = 1
					IF kickin = 0 THEN normangle = GetAngle(teams(tnum, pnum).lastdx, teams(tnum, pnum).lastdy): maxpower = 5: minpower = 4: zpower = 4: cbangle = normangle: powertimer = 0: curvelevel = 0: maxzpower = 4
					dokick tnum, pnum
					zpower = maxzpower / maxpower * cpower
					kickin = 1
				END IF
			  
				IF kbmatrix(56) AND teams(tnum, pnum).posession = 1 AND teams(tnum, pnum).active = 1 THEN
					ballgravity = .25
					ahead! = GetAngle(teams(tnum, pnum).lastdx, teams(tnum, pnum).lastdy)
					IF kickin = 0 THEN zpower = 1: curvelevel = 0: cbangle = ahead!: cpower = 4
					DoPass ahead! - pion4, ahead! + pion4, tnum, pnum
					kickin = 1
				END IF
			  
				IF kbmatrix(29) AND teams(tnum, pnum).posession = 1 AND teams(tnum, pnum).active = 1 THEN
					ballgravity = .05
					kickthistime = 1
					IF kickin = 0 THEN normangle = GetAngle(teams(tnum, pnum).lastdx, teams(tnum, pnum).lastdy): maxpower = 9: minpower = 7: zpower = .8: cbangle = normangle: powertimer = 0: curvelevel = 0
					dokick tnum, pnum
					kickin = 1
				END IF
			 
				IF kickin = 1 AND kickthistime = 0 THEN
					teams(tnum, pnum).posession = 0: anyposess = 0: kickin = 0
					btnum = 0: bpnum = 0
					balldx = cpower * COS(cbangle)
					balldy = cpower * SIN(cbangle)
					balldz = zpower
					ballx = ballx + balldx
					bally = bally + balldy
					ballz = ballz + balldz
					Sound.DMAPlay "kick2.snd", 200
					curving = 1
				END IF
			END IF
		teams(tnum, pnum).spritenum = teams(tnum, pnum).dir * 8 + teams(tnum, pnum).frame
		IF tnum = 1 AND kbmatrix(56) THEN noactive = 1
		NEXT
	NEXT
  
	IF noactive <> 0 AND isdemo = 0 THEN
	dist! = 8.999999E+07
	'teams(1, 0).active = 0
	FOR lp = 1 TO 10
	teams(1, new).active = 0
	ndist! = (ballx - teams(1, lp).xpos) ^ 2 + (bally - teams(1, lp).ypos) ^ 2
	IF ndist! < dist! THEN dist! = ndist!: new = lp
	NEXT
	IF teams(1, 0).posession = 1 THEN teams(1, 0).active = 1 ELSE teams(1, 0).active = 0: teams(1, new).active = 1

	END IF

  
	curvetime = curvetime - 1
	IF curvetime < 0 AND curving = 1 THEN
		power! = SQR(balldx * balldx + balldy * balldy)
		cbangle = cbangle + curvelevel
		balldx = power! * COS(cbangle)
		balldy = power! * SIN(cbangle)
	END IF

	ballx = ballx + balldx
	bally = bally + balldy
	ballz = ballz + balldz
	IF ballz > 0 THEN balldz = balldz - ballgravity
				
	IF ballz < 0 THEN ballz = 0: curvelevel = curvelevel / 2: balldz = -balldz / 1.8: balldx = balldx / 1.3: balldy = balldy / 1.3: IF balldz < .15 THEN balldz = 0 ELSE Sound.DMAPlay "bounce.snd", 110
	IF ballz = 0 THEN balldx = balldx / 1.02: balldy = balldy / 1.02
	IF ABS(balldx) < .5 THEN balldx = 0
	IF ABS(balldy) < .5 THEN balldy = 0
	IF balldx = 0 AND balldy = 0 AND balldz = 0 THEN curving = 0
	IF ballz > 55 THEN ballz = 55
	IF ballx <> obx OR bally <> oby OR ballz <> obz OR balldz <> 0 THEN
		IF ballx < -98 THEN ballx = -98
		IF bally < -73 THEN bally = -73
		IF ballx > 1138 THEN ballx = 1138
		IF bally > 538 THEN bally = 538
	END IF
  
	LeftGoalCheck
	RightGoalCheck
	Adcollision
	SideLines
	DoRefs

	IF FIX(ballx) <> FIX(obx) OR FIX(bally) <> FIX(oby) OR FIX(ballz) <> FIX(obz) THEN
		bangle# = cbangle + curvlevel * 15
		anglen = FIX(bangle# / pion4)
		DO
			ok = 1
			IF bangle# > pion4 THEN ok = 0: bangle# = bangle# - pion4
		LOOP UNTIL ok
		IF bangle# <= pion4 / 2 THEN bangle# = 0
		IF bangle# >= pion4 / 2 THEN bangle# = pion4
		bangle# = bangle# + anglen * pion4
		bdx! = COS(bangle#)
		bdy! = SIN(bangle#)
		IF ABS(bdx!) < .001 THEN bdx! = 0
		IF ABS(bdy!) < .001 THEN bdy! = 0
		Ballspin (SGN(bdx!) + SGN(bdy!) * 4)
	END IF
	bfram = 55 - 8 * FIX((ballz / 8)) - bfram2
	IF anyposess = 1 THEN cameranx = teams(btnum, bpnum).xpos + (SGN(teams(btnum, bpnum).xpos - teams(btnum, bpnum).ox)) * 140: camerany = teams(btnum, bpnum).ypos + (SGN(teams(btnum, bpnum).ypos - teams(btnum, bpnum).oy)) * 64: cameraspeed = 6
	IF anyposess = 0 THEN cameranx = FIX(ballx): camerany = FIX(bally): cameraspeed = 8

	FOR lp = 1 TO cameraspeed
		camerax = camerax - SGN(camerax - cameranx)
		cameray = cameray - SGN(cameray - camerany)
	NEXT

	ShowField camerax - 160, cameray - 84

LOOP UNTIL kbmatrix(1)
GOTO theend

abort:
endit
ERN = ERR
IF ERL = 64 THEN RESUME nextbit
IF ERN <> 7 THEN GOTO endprog
SCREEN 12
SCREEN 0
PRINT "Out of memory": PRINT "Try using -lomem commandline switch": PRINT : PRINT "Attempting to correct error:": SLEEP 1
IF lomem <> 0 THEN
	PRINT "Sorry, you need more available conventional memory"
	SLEEP 1
	END
ELSE
	OPEN "lowmem.inf" FOR OUTPUT AS #1
	PRINT #1, "Needs More Memory!!!"
	CLOSE
	RUN
END IF

endprog:
SCREEN 12
SCREEN 0
PRINT ERN
ERROR ERN

theend:
endit

dmadata:
DATA 135,131,129,130,143,139,137,&h8A

REM $STATIC
SUB Adcollision
didhit = 0
IF obz < 3.5 AND ballz < 3.5 THEN

	IF obx > -80 AND ballx < -80 THEN ballx = -78: didhit = 1
	IF obx < 1109 AND ballx > 1109 THEN ballx = 1107: didhit = 1
	IF oby > -48 AND bally < -48 THEN bally = -46: didhit = didhit OR 2
	IF oby < 502 AND bally > 502 THEN bally = 500: didhit = didhit OR 2

	IF didhit <> 0 THEN
		Sound.DMAPlay "border.snd", 211
		IF (didhit AND 1) THEN balldx = -balldx ELSE balldx = balldx * 2
		IF (didhit AND 2) THEN balldy = -balldy ELSE balldy = balldy * 2
		balldx = balldx / 6
		balldy = balldy / 6
		balldz = balldz / 6
		curving = 0
  
	END IF

END IF

END SUB

SUB Ballspin (arg)
ob = bfram2
SELECT CASE arg
CASE -5
FOR lp = 0 TO 5
IF bfram2 = spins(3, lp) THEN
f = lp + 1: IF f = 3 THEN f = 0 ELSE IF f = 6 THEN f = 3
bfram2 = spins(3, f): EXIT SUB
END IF
NEXT
bfram2 = spins(3, 0)

CASE -4
FOR lp = 0 TO 5
IF bfram2 = spins(1, lp) THEN
f = lp + 1: IF f = 3 THEN f = 0 ELSE IF f = 6 THEN f = 3
bfram2 = spins(1, f): EXIT SUB
END IF
NEXT
bfram2 = spins(1, 0)

CASE -3
FOR lp = 0 TO 5
IF bfram2 = spins(2, lp) THEN
f = lp + 1: IF f = 3 THEN f = 0 ELSE IF f = 6 THEN f = 3
bfram2 = spins(2, f): EXIT SUB
END IF
NEXT
bfram2 = spins(2, 0)


CASE 1
FOR lp = 0 TO 5
IF bfram2 = spins(0, lp) THEN
f = lp + 1: IF f = 3 THEN f = 0 ELSE IF f = 6 THEN f = 3
bfram2 = spins(0, f): EXIT SUB
END IF
NEXT
bfram2 = spins(0, 0)

CASE 5
FOR lp = 0 TO 5
IF bfram2 = spins(3, lp) THEN
f = lp - 1: IF f = -1 THEN f = 2 ELSE IF f = 2 THEN f = 5
bfram2 = spins(3, f): EXIT SUB
END IF
NEXT
bfram2 = spins(3, 0)


CASE 4
FOR lp = 0 TO 5
IF bfram2 = spins(1, lp) THEN
f = lp - 1: IF f = -1 THEN f = 2 ELSE IF f = 2 THEN f = 5
bfram2 = spins(1, f): EXIT SUB
END IF
NEXT
bfram2 = spins(1, 0)


CASE 3
FOR lp = 0 TO 5
IF bfram2 = spins(2, lp) THEN
f = lp - 1: IF f = -1 THEN f = 2 ELSE IF f = 2 THEN f = 5
bfram2 = spins(2, f): EXIT SUB
END IF
NEXT
bfram2 = spins(2, 0)

CASE -1
FOR lp = 0 TO 5
IF bfram2 = spins(0, lp) THEN
f = lp - 1: IF f = -1 THEN f = 2 ELSE IF f = 2 THEN f = 5
bfram2 = spins(0, f): EXIT SUB
END IF
NEXT
bfram2 = spins(0, 0)

END SELECT

END SUB

SUB DisplayPitch (xoff, yoff) STATIC
FOR y = -1 TO 2
FOR x = -1 TO 2
	sprite -xoff + 688 * x, -yoff + 300 * y, fs1, -1
	sprite -xoff + 688 * x, 150 - yoff + 300 * y, fs2, -1
	sprite -xoff + 344 + 688 * x, -yoff + 300 * y, fs3, -1
	sprite -xoff + 344 + 688 * x, 150 - yoff + 300 * y, fs4, -1
NEXT: NEXT
sprite 460 - xoff, 172 - yoff, 1957, -1

vline -xoff, -yoff, 1039 - xoff, -yoff, 15
vline -xoff, 464 - yoff, 1039 - xoff, 464 - yoff, 15

vline -xoff, -yoff, -xoff, 463 - yoff, 15
vline 520 - xoff, -yoff, 520 - xoff, 463 - yoff, 15
vline 1039 - xoff, -yoff, 1039 - xoff, 463 - yoff, 15

vline -xoff, 56 - yoff, 143 - xoff, 56 - yoff, 15
vline -xoff, 407 - yoff, 143 - xoff, 407 - yoff, 15
vline 143 - xoff, 56 - yoff, 143 - xoff, 407 - yoff, 15

vline -xoff, 152 - yoff, 47 - xoff, 152 - yoff, 15
vline -xoff, 311 - yoff, 47 - xoff, 311 - yoff, 15
vline 47 - xoff, 152 - yoff, 47 - xoff, 311 - yoff, 15

sprite 96 - xoff, 231 - yoff, 1956, -1

vline 894 - xoff, 56 - yoff, 1039 - xoff, 56 - yoff, 15
vline 894 - xoff, 407 - yoff, 1039 - xoff, 407 - yoff, 15
vline 894 - xoff, 56 - yoff, 894 - xoff, 407 - yoff, 15

vline 991 - xoff, 152 - yoff, 1039 - xoff, 152 - yoff, 15
vline 991 - xoff, 311 - yoff, 1039 - xoff, 311 - yoff, 15
vline 991 - xoff, 152 - yoff, 991 - xoff, 311 - yoff, 15

sprite 943 - xoff, 231 - yoff, 1956, -1
END SUB

SUB Do3dparts (xoff, yoff) STATIC

'Flags
tvline -xoff, -yoff, -4 - xoff, 4 - yoff, 0
Line3D 0, 0, 0, 0, 0, 5, 26, xoff, yoff
FOR Z! = 3 TO 5 STEP .2
Line3D 0, 0, Z!, -4, 4, 4, 40, xoff, yoff
NEXT

tvline -xoff, 464 - yoff, -4 - xoff, 460 - yoff, 0
Line3D 0, 464, 0, 0, 464, 5, 26, xoff, yoff
FOR Z! = 3 TO 5 STEP .2
Line3D 0, 464, Z!, -4, 460, 4, 40, xoff, yoff
NEXT

tvline 1039 - xoff, -yoff, 1043 - xoff, 4 - yoff, 0
Line3D 1039, 0, 0, 1039, 0, 5, 26, xoff, yoff
FOR Z! = 3 TO 5 STEP .2
Line3D 1039, 0, Z!, 1043, 4, 4, 40, xoff, yoff
NEXT

tvline 1039 - xoff, 464 - yoff, 1043 - xoff, 460 - yoff, 0
Line3D 1039, 464, 0, 1039, 464, 5, 26, xoff, yoff
FOR Z! = 3 TO 5 STEP .2
Line3D 1039, 464, Z!, 1043, 460, 4, 40, xoff, yoff
NEXT


'Goal (left)
FOR x = 0 TO -30 STEP -netspacing
tvline x - xoff, 200 - yoff, x - xoff, 264 - yoff, 0
NEXT
FOR y = 200 TO 264 STEP netspacing
tvline -30 - xoff, y - yoff, -xoff, y - yoff, 0
NEXT

tvline -60 - xoff, 205 - yoff, -30 - xoff, 200 - yoff, 0
tvline -60 - xoff, 259 - yoff, -30 - xoff, 264 - yoff, 0
tvline -60 - xoff, 205 - yoff, -30 - xoff, 221 - yoff, 0
tvline -60 - xoff, 259 - yoff, -30 - xoff, 243 - yoff, 0


Line3D -30, 200, 0, 0, 200, 0, netcolour, xoff, yoff
Line3D -30, 264, 0, 0, 264, 0, netcolour, xoff, yoff
Line3D 0, 200, 8, -30, 200, 8, netcolour, xoff, yoff
Line3D 0, 264, 8, -30, 264, 8, netcolour, xoff, yoff
Line3D -30, 200, 8, -30, 200, 0, netcolour, xoff, yoff
Line3D -30, 200, 8, -30, 264, 8, netcolour, xoff, yoff
Line3D -30, 200, 0, -30, 264, 0, netcolour, xoff, yoff

Line3D -60, 205, 0, -60, 205, 10, 0, xoff, yoff
Line3D -60, 259, 0, -60, 259, 10, 0, xoff, yoff

Line3D -60, 205, 10, -30, 200, 8, netcolour + 1, xoff, yoff
Line3D -60, 259, 10, -30, 264, 8, netcolour + 1, xoff, yoff
Line3D -60, 205, 10, -30, 221, 8, netcolour + 1, xoff, yoff
Line3D -60, 259, 10, -30, 243, 8, netcolour + 1, xoff, yoff



FOR x = -30 TO 0 STEP netspacing
Line3D x, 200, 8, x, 264, 8, netcolour, xoff, yoff
Line3D x, 200, 8, x, 200, 0, netcolour, xoff, yoff
Line3D x, 264, 8, x, 264, 0, netcolour, xoff, yoff
NEXT

FOR Z! = 0 TO 8 STEP netspacing / 3
Line3D -30, 200, Z!, 0, 200, Z!, netcolour, xoff, yoff
Line3D -30, 264, Z!, 0, 264, Z!, netcolour, xoff, yoff
Line3D -30, 200, Z!, -30, 264, Z!, netcolour, xoff, yoff
NEXT

FOR y = 200 TO 264 STEP netspacing
Line3D -30, y, 8, 0, y, 8, netcolour, xoff, yoff
Line3D -30, y, 0, -30, y, 8, netcolour, xoff, yoff
NEXT

Line3D 0, 200, 8, 0, 264, 8, 20, xoff, yoff
Line3D 0, 200, 8, 0, 200, 0, 20, xoff, yoff
Line3D 0, 264, 8, 0, 264, 0, 20, xoff, yoff


'Goal (right)
tvline 1099 - xoff, 205 - yoff, 1069 - xoff, 200 - yoff, 0
tvline 1099 - xoff, 259 - yoff, 1069 - xoff, 264 - yoff, 0
tvline 1099 - xoff, 205 - yoff, 1069 - xoff, 221 - yoff, 0
tvline 1099 - xoff, 259 - yoff, 1069 - xoff, 243 - yoff, 0


FOR x = 1039 TO 1069 STEP netspacing
tvline x - xoff, 200 - yoff, x - xoff, 264 - yoff, 0
NEXT
FOR y = 200 TO 264 STEP netspacing
tvline 1039 - xoff, y - yoff, 1069 - xoff, y - yoff, 0
NEXT


Line3D 1069, 200, 0, 1039, 200, 0, netcolour, xoff, yoff
Line3D 1069, 264, 0, 1039, 264, 0, netcolour, xoff, yoff
Line3D 1039, 200, 8, 1069, 200, 8, netcolour, xoff, yoff
Line3D 1039, 264, 8, 1069, 264, 8, netcolour, xoff, yoff
Line3D 1069, 200, 8, 1069, 200, 0, netcolour, xoff, yoff
Line3D 1069, 200, 8, 1069, 264, 8, netcolour, xoff, yoff
Line3D 1069, 200, 0, 1069, 264, 0, netcolour, xoff, yoff

FOR x = 1039 TO 1069 STEP netspacing
Line3D x, 200, 8, x, 264, 8, netcolour, xoff, yoff
Line3D x, 200, 8, x, 200, 0, netcolour, xoff, yoff
Line3D x, 264, 8, x, 264, 0, netcolour, xoff, yoff
NEXT

FOR Z! = 0 TO 8 STEP netspacing / 3
Line3D 1069, 200, Z!, 1039, 200, Z!, netcolour, xoff, yoff
Line3D 1069, 264, Z!, 1039, 264, Z!, netcolour, xoff, yoff
Line3D 1069, 200, Z!, 1069, 264, Z!, netcolour, xoff, yoff
NEXT

FOR y = 200 TO 264 STEP netspacing
Line3D 1069, y, 8, 1039, y, 8, netcolour, xoff, yoff
Line3D 1069, y, 0, 1069, y, 8, netcolour, xoff, yoff
NEXT

Line3D 1039, 200, 8, 1039, 264, 8, 20, xoff, yoff
Line3D 1039, 200, 8, 1039, 200, 0, 20, xoff, yoff
Line3D 1039, 264, 8, 1039, 264, 0, 20, xoff, yoff


Line3D 1099, 205, 0, 1099, 205, 10, 0, xoff, yoff
Line3D 1099, 259, 0, 1099, 259, 10, 0, xoff, yoff

Line3D 1099, 205, 10, 1069, 200, 8, netcolour + 1, xoff, yoff
Line3D 1099, 259, 10, 1069, 264, 8, netcolour + 1, xoff, yoff
Line3D 1099, 205, 10, 1069, 221, 8, netcolour + 1, xoff, yoff
Line3D 1099, 259, 10, 1069, 243, 8, netcolour + 1, xoff, yoff


END SUB

SUB DoAI (tnum, pnum) STATIC
IF teams(tnum, pnum).posession = 1 THEN
	teams(tnum, pnum).xpos = teams(tnum, pnum).xpos + 3 * (-tnum * 2 + 1)
	dist! = (1039 * (1 - tnum) - teams(tnum, pnum).xpos) ^ 2 + (232 - teams(tnum, pnum).ypos) ^ 2
	IF dist! < (RND * 100 + 150) ^ 2 AND RND * 50 > 45 THEN
		ballgravity = .05
		zpower = .8
		curvelevel = RND * .04 * SGN(232 - ytarget) * (tnum * 2 - 1)
		curving = 1
		cpower = 6 + RND * 3
		curvetime = cpower / 9 * 11
		kickin = 1
		ytarget = 200 + RND * 64
		cbangle = GetAngle(1039 * (1 - tnum) - teams(tnum, pnum).xpos, ytarget - teams(tnum, pnum).ypos)
		EXIT SUB
	END IF
  
	FOR lp = 0 TO 10
		IF (teams(1 - tnum, lp).xpos - teams(tnum, pnum).xpos) ^ 2 + (teams(1 - tnum, lp).ypos - teams(tnum, pnum).ypos) ^ 2 < 2500 AND RND * 100 > 85 THEN
			GetPlayer tnum, pnum
		END IF
	NEXT
	EXIT SUB
ELSE
	rdist! = 1E+10
	FOR lp = 1 TO 10
		dist! = (ballx - teams(tnum, lp).xpos) ^ 2 + (bally - teams(tnum, lp).ypos) ^ 2
		IF dist! < rdist! THEN rdist! = dist!: nplayer = lp
	NEXT
	IF nplayer = pnum THEN
		angle! = GetAngle(teams(tnum, pnum).xpos - ballx, teams(tnum, pnum).ypos - bally)
		teams(tnum, pnum).xpos = teams(tnum, pnum).xpos - 4 * COS(angle!)
		teams(tnum, pnum).ypos = teams(tnum, pnum).ypos - 4 * SIN(angle!)
	ELSE
			teams(tnum, pnum).xpos = teams(tnum, pnum).xpos - SGN(teams(tnum, pnum).xpos - teams(tnum, pnum).normxpos)
			teams(tnum, pnum).ypos = teams(tnum, pnum).ypos - SGN(teams(tnum, pnum).ypos - teams(tnum, pnum).normypos)
			IF ABS(teams(tnum, pnum).xpos - teams(tnum, pnum).normxpos) < .5 THEN teams(tnum, pnum).xpos = teams(tnum, pnum).normxpos
			IF ABS(teams(tnum, pnum).ypos - teams(tnum, pnum).normypos) < .5 THEN teams(tnum, pnum).ypos = teams(tnum, pnum).normypos
	END IF
END IF
END SUB

SUB dokick (tnum, pnum)
dodrawlines = 1
powertimer = powertimer + 3.1415926535897# / 15
IF powertimer > 3.1415926535897# * 2 THEN powertimer = 0
cpower = (maxpower + minpower) / 2 + COS(powertimer) * (maxpower - minpower) / 2
cbangle = cbangle + (kbmatrix(77) - kbmatrix(75)) * 3.1415926535897# / 40
IF cbangle > normangle + 3.1415926535897# / 8 THEN cbangle = normangle + 3.1415926535897# / 8
IF cbangle < normangle - 3.1415926535897# / 8 THEN cbangle = normangle - 3.1415926535897# / 8
curvelevel = curvelevel + (kbmatrix(72) - kbmatrix(80)) * .0025
IF curvelevel > .04 THEN curvelevel = .04
IF curvelevel < -.04 THEN curvelevel = -.04

drawlines(0, 0) = ballx
drawlines(0, 1) = bally
drawlines(0, 2) = COS(cbangle) * (COS(powertimer) * 15 + 25) + ballx
drawlines(0, 3) = SIN(cbangle) * (COS(powertimer) * 15 + 25) + bally

drawlines(1, 0) = ballx
drawlines(1, 1) = bally
drawlines(1, 2) = COS(cbangle + curvelevel * 12) * (35) + ballx
drawlines(1, 3) = SIN(cbangle + curvelevel * 12) * (35) + bally

curvetime = cpower / maxpower * 11
curving = 1
'teams(tnum, pnum).ypos = teams(tnum, pnum).ypos + (kbmatrix(80) - kbmatrix(72)) * 4

END SUB

SUB DoPass (minangle!, maxangle!, tnum, pnum)
rdist! = 1E+10
ballgravity = .25

FOR lp = 0 TO 10
	IF lp <> pnum THEN
		'dist! = (teams(tnum, pnum).xpos - teams(tnum, lp).xpos) ^ 2 + (teams(tnum, pnum).ypos - teams(tnum, lp).ypos) ^ 2
		'angle! = GetAngle(teams(tnum, lp).xpos - teams(tnum, pnum).xpos, teams(tnum, lp).ypos - teams(tnum, pnum).ypos)
	  
		dist! = (ballx - teams(tnum, lp).xpos) ^ 2 + (bally - teams(tnum, lp).ypos) ^ 2
		angle! = GetAngle(teams(tnum, lp).xpos - ballx, teams(tnum, lp).ypos - bally)
	  
		'IF angle! < -pi THEN angle! = angle! + 2 * pi
		'PRINT angle!; minangle!; maxangle!
		IF (dist! < rdist! AND angle! > minangle! AND angle! < maxangle!) OR (dist! < 2025 AND dist! < rdist!) THEN
			rdist! = dist!
			cbangle = angle!
			cpower = SQR(rdist!) / 15
			zpower = 1
			IF cpower > 8.5 THEN
				zpower = 1 + (cpower - 8.5) / 5
				cpower = 8.5
			END IF
			IF cpower < 5 THEN cpower = 5
		END IF
	END IF
NEXT
'SLEEP 2
kickin = 1
END SUB

SUB DoPlayerSprites (xoff, yoff)
FOR t = 0 TO 1
	FOR p = 0 TO 10
		ymax = 199
		
		IF teams(t, p).active THEN vBOX 201, 173, 254, 178, 0: GPrint2 201, 173, playernames(p + 1, t)
		ymax = 167
	  
		IF (teams(t, p).xpos - xoff < -8 OR teams(t, p).xpos - xoff > 327 OR teams(t, p).ypos - yoff < -8 OR teams(t, p).ypos - yoff > 175) AND teams(t, p).active = 1 AND isdemo = 0 THEN
			nxf = teams(t, p).xpos - xoff
			nyf = teams(t, p).ypos - yoff
			IF teams(t, p).xpos - xoff < -8 THEN nxf = 0: x = -1
			IF teams(t, p).ypos - yoff < -8 THEN nyf = 0: y = -1
			IF teams(t, p).xpos - xoff > 327 THEN nxf = 312: x = 1
			IF teams(t, p).ypos - yoff > 175 THEN nyf = 160: y = 1
				SELECT CASE x + y * 4
					CASE -5: s = 0
					CASE -4: s = 1
					CASE -3: s = 2
					CASE 1: s = 3
					CASE 5: s = 4
					CASE 4: s = 5
					CASE 3: s = 6
					CASE -1: s = 7
				END SELECT
			IF frames& MOD 8 >= 4 THEN sprite nxf, nyf, 1900 + s, 0
		ELSE
			IF p = 0 THEN px2 = teams(t, p).xpos - xoff - (160 - teams(t, p).xpos + xoff) * teams(t, p).zpos / persplevel ELSE px2 = teams(t, p).xpos - xoff
			'IF px2 <> teams(t, p).xpos - xoff THEN t! = TIMER: DO: LOOP UNTIL TIMER - t! > 0
			sprite px2 - 8, teams(t, p).ypos - yoff - 8, teams(t, p).spritenum + (1 - t) * 32, 0
			
		END IF
	NEXT
NEXT
FOR r = 0 TO 2
	sprite refs(r).xpos - xoff - 8, refs(r).ypos - yoff - 8, refs(r).spritenum, 0
NEXT
END SUB

SUB DoRefs

FOR lp = 0 TO 2
	refs(lp).ox = refs(lp).xpos
	refs(lp).oy = refs(lp).ypos
NEXT

angle! = GetAngle(refs(0).xpos - ballx, refs(0).ypos - bally - 50)
dist! = (ballx - refs(0).xpos) ^ 2 + (bally - refs(0).ypos) ^ 2
thex! = ballx
IF thex! < 70 THEN thex! = 70
IF thex! > 969 THEN thex! = 969
IF dist! < 2500 THEN
	refs(0).xpos = refs(0).xpos + 2 * COS(angle!)
	refs(0).ypos = refs(0).ypos + 2 * SIN(angle!)
ELSE
	IF dist! > 22500 THEN
		refs(0).xpos = refs(0).xpos - 3 * COS(angle!)
		refs(0).ypos = refs(0).ypos - 3 * SIN(angle!)
	ELSE
		angle! = GetAngle(refs(0).xpos - thex!, refs(0).ypos - 464 / 1039 * thex!)
		refs(0).xpos = refs(0).xpos - 3.5 * COS(angle!)
		refs(0).ypos = refs(0).ypos - 3.5 * SIN(angle!)
	END IF
END IF

FOR lp = 1 TO 2
	FOR n = 0 TO 2
		IF refs(lp).xpos < ballx THEN refs(lp).xpos = refs(lp).xpos + 1
		IF refs(lp).xpos > ballx THEN refs(lp).xpos = refs(lp).xpos - 1
		IF lp = 1 AND refs(1).xpos < 540 THEN refs(1).xpos = refs(1).xpos + .8
		IF lp = 2 AND refs(2).xpos > 500 THEN refs(2).xpos = refs(2).xpos - .8
  
	NEXT
NEXT


FOR lp = 0 TO 2
	IF refs(lp).ox <> refs(lp).xpos OR refs(lp).oy <> refs(lp).ypos THEN refs(lp).frame = (refs(lp).frame + 1) MOD 8 ELSE refs(lp).frame = 2
	IF refs(lp).xpos < refs(lp).ox THEN refs(lp).dir = 0
	IF refs(lp).xpos > refs(lp).ox THEN refs(lp).dir = 1
	IF refs(lp).ypos < refs(lp).oy THEN refs(lp).dir = 2
	IF refs(lp).ypos > refs(lp).oy THEN refs(lp).dir = 3
	refs(lp).spritenum = refs(lp).dir * 8 + refs(lp).frame + 300
NEXT
END SUB

SUB DrawAdverts (xoff, yoff)

FOR Z! = 0 TO 3.5 STEP .1
IF Z! + .1 > 3.5 THEN col = 25 ELSE col = 15
Line3D -80, -48, Z!, 1109, -48, Z!, col, xoff, yoff
Line3D -80, -48, Z!, -80, 502, Z!, col, xoff, yoff
Line3D 1109, -48, Z!, 1109, 502, Z!, col, xoff, yoff
Line3D -80, 502, Z!, 1109, 502, Z!, col, xoff, yoff
NEXT
FOR x = -80 TO 1110 STEP 70
Line3D x, -48, 0, x, -48, 3.5, 25, xoff, yoff
Line3D x, 502, 0, x, 502, 3.5, 25, xoff, yoff
NEXT
FOR y = -48 TO 502 STEP 70
Line3D -80, y, 0, -80, y, 3.5, 25, xoff, yoff
Line3D 1109, y, 0, 1109, y, 3.5, 25, xoff, yoff
NEXT


END SUB

SUB Drawfield (xoffset, yoffset)
END SUB

SUB endit
IF kbinit = 1 THEN
	DEF SEG = VARSEG(kbcontrol(0))
	CALL ABSOLUTE(&H1B0)
END IF
Sound.DeInitDSP
END SUB

FUNCTION GetAngle# (xch!, ych!)
IF xch! <> 0 THEN angle! = ATN(ABS(ych!) / ABS(xch!) / 1#) ELSE angle! = pion2
IF xch! < 0 THEN angle! = pi - angle!
IF ych! < 0 THEN angle! = -angle!
GetAngle# = angle!
END FUNCTION

SUB GetPlayer (tnum, pnum)
rdist! = 1E+10
ballgravity = .25

FOR lp = 0 TO 10
	IF lp <> pnum THEN
		'dist! = (teams(tnum, pnum).xpos - teams(tnum, lp).xpos) ^ 2 + (teams(tnum, pnum).ypos - teams(tnum, lp).ypos) ^ 2
		'angle! = GetAngle(teams(tnum, lp).xpos - teams(tnum, pnum).xpos, teams(tnum, lp).ypos - teams(tnum, pnum).ypos)
	 
		dist! = (ballx - teams(tnum, lp).xpos) ^ 2 + (bally - teams(tnum, lp).ypos) ^ 2
		angle! = GetAngle(teams(tnum, lp).xpos - ballx, teams(tnum, lp).ypos - bally)
	 
		IF dist! < rdist! AND (RND * 10 > 6 OR lp = 10) THEN
			rdist! = dist!
			cbangle = angle!
			cpower = SQR(rdist!) / 15
			zpower = 1
			IF cpower > 8.5 THEN
				zpower = 1 + (cpower - 8.5) / 5
				cpower = 8.5
			END IF
			IF cpower < 5 THEN cpower = 5
		END IF
	END IF
NEXT
'SLEEP 2
kickin = 1
END SUB

SUB Getteams
11
t1num = FIX(RND * 32)
DO
t2num = FIX(RND * 32)
LOOP UNTIL t2num <> t1num

OPEN "graphics\flags2.raw" FOR BINARY ACCESS READ AS #1
FOR lp = 0 TO 31
	IF lp = t1num THEN ct = 0
	IF lp = t2num THEN ct = 1

	Spriteinfo(ct + 200).Segment = VARSEG(flags(1, ct)): Spriteinfo(ct + 200).Offset = VARPTR(flags(1, ct))
	Spriteinfo(ct + 200).xsize = 31: Spriteinfo(ct + 200).ysize = 26
	DEF SEG = Spriteinfo(ct + 200).Segment
	of = Spriteinfo(ct + 200).Offset
	FOR y = 0 TO 26
		FOR x = 0 TO 31
			POKE x + y * 32 + of, ASC(INPUT$(1, 1))
		NEXT
	NEXT
	IF lp = t1num THEN ct = 1: nd = nd + 1
	IF lp = t2num THEN ct = 0: nd = nd + 1
	IF nd = 2 THEN EXIT FOR
NEXT

CLOSE
RESTORE teamabbrev
FOR lp = 0 TO t1num
	READ ab$
NEXT

OPEN "data\" + ab$ + ".wct" FOR INPUT AS #1

FOR lp = 1 TO 22
LINE INPUT #1, pn$
pn = VAL(pn$)
LINE INPUT #1, pname$
IF pn > 22 THEN SOUND 800, 3
playernames(pn, 0) = pname$
LINE INPUT #1, jnk$
NEXT
CLOSE

RESTORE teamabbrev
FOR lp = 0 TO t2num
	READ ab$
NEXT

OPEN "data\" + ab$ + ".wct" FOR INPUT AS #1

FOR lp = 1 TO 22
LINE INPUT #1, pn$
pn = VAL(pn$)
LINE INPUT #1, pname$
playernames(pn, 1) = pname$
LINE INPUT #1, jnk$
NEXT
CLOSE
12
END SUB

SUB GPrint (xpos, ypos, st$)
st$ = UCASE$(st$)
FOR lp = 1 TO LEN(st$)
kbmatrix(128) = 0
t! = TIMER
t$ = MID$(st$, lp, 1)
IF ASC(t$) > 32 AND ASC(t$) < 94 THEN WAIT &H3DA, 8, 8: WAIT &H3DA, 8: PUT (xpos, ypos), letters(1, ASC(t$) - 33), PSET: xpos = xpos + lwidths(ASC(t$) - 33): Sound.DMAPlay "click.snd", 110
IF ASC(t$) = 32 THEN WAIT &H3DA, 8, 8: WAIT &H3DA, 8: xpos = xpos + 3
IF ASC(t$) = 126 THEN WAIT &H3DA, 8, 8: WAIT &H3DA, 8: PSET (xpos, ypos + 2), 15: PSET (xpos + 1, ypos + 1), 15: PSET (xpos + 2, ypos + 2), 15: PSET (xpos + 3, ypos + 1), 15: xpos = xpos + 4: Sound.DMAPlay "click.snd", 110
IF ASC(t$) = 95 THEN WAIT &H3DA, 8, 8: WAIT &H3DA, 8: PSET (xpos, ypos + 6), 20: PSET (xpos + 1, ypos + 6), 20: PSET (xpos + 2, ypos + 6), 20: PSET (xpos + 3, ypos + 6), 20: xpos = xpos + 4: Sound.DMAPlay "click.snd", 110
DO: LOOP UNTIL TIMER - t! <> 0
NEXT
END SUB

SUB GPrint2 (xpos, ypos, st$)
st$ = UCASE$(st$)
FOR lp = 1 TO LEN(st$)
t$ = MID$(st$, lp, 1)
IF ASC(t$) > 32 AND ASC(t$) < 97 THEN sprite xpos, ypos, ASC(t$) - 33 + 400, -1: xpos = xpos + lwidths(ASC(t$) - 33)
IF ASC(t$) = 32 THEN xpos = xpos + 3
NEXT
END SUB

SUB Help
CLS
PALETTE
GPrint 0, 0, "FRANCE 98 - HELP"
GPrint 0, 15, "ALL YOU REALLY NEED TO KNOW IS THE CONTROLS, RIGHT?"
GPrint 0, 24, "THE PLAYER YOU'RE CURRENTLY USING HAS A FLAHING BLUE"
GPrint 0, 33, "ARROW POINTING TO HIM.  CHANGING ACIVE PLAYERS OCCURS"
GPrint 0, 42, "IN ONE OF TWO WAYS : PRESSING ALT OR HAVING AN INACTIVE"
GPrint 0, 51, "PLAYER RECIEVE / STEAL THE BALL."
GPrint 0, 60, "MOVEMENT, OF COURSE, IS VIA THE ARROW KEYS."
GPrint 0, 69, "PRESSING ALT WHILE IN POSESSION OF THE BALL WILL PASS TO THE"
GPrint 0, 78, "NEAREST PLAYER IN THE DIRECTION YOU ARE FACING."
GPrint 0, 87, "CTRL SHOOTS, SPACE LOBS."
GPrint 0, 96, "WHILE THE SHOOT/LOB KEY IS HELD DOWN TWO LINES BECOME VISIBLE."
GPrint 0, 105, "THE WHITE LINE IS THE DIRECTION THE BALL WILL TAKE, IT'S LENGTH"
GPrint 0, 114, "DETERMINES THE POWER OF THE KICK.  THE RED LINE CHANGES THE"
GPrint 0, 123, "AMOUNT OF CURVE THE BALL HAS.  CHANGING THESE IS MESSY AT THE"
GPrint 0, 132, "MOMENT, UP/DOWN CHANGES CURVE, AND LEFT/RIGHT CHANGES ANGLE."
GPrint 0, 141, "KEEPERS MOVE AUTOMATICALLY, THEY'RE PRETTY STUPID, BUT THEY DO"
GPrint 0, 150, "A DECENT JOB (SOMETIMES!!!)."
GPrint 0, 159, "BY DEFAULT YOU ARE  GOING TO THE LEFT, AND CURRENTLY"
GPrint 0, 168, "ALWAYS HAVE BLUE SHIRTS."
GPrint 200, 190, "PRESS A KEY TO EXIT"

DO
	kbmatrix(128) = 0
	FOR lp = 0 TO 127
		IF kbmatrix(lp) <> 0 THEN exi = 1
	NEXT
LOOP UNTIL exi = 1

DO
	exi = 0
	kbmatrix(128) = 0
	FOR lp = 0 TO 127
		IF kbmatrix(lp) <> 0 THEN exi = 1
	NEXT
LOOP UNTIL exi = 0

END SUB

SUB InitField
RANDOMIZE TIMER
PALETTE 10, 46 * 256
PALETTE 120, 25 * 256
PALETTE 248, 65536 * 42
PALETTE 247, 65536 * 21
PALETTE 246, 256 * 42
PALETTE 245, 256 * 21

PALETTE 244, 256 * 42 + 42
PALETTE 243, 256 * 21 + 21
PALETTE 242, 42
PALETTE 241, 21

PRINT
PRINT "Generating field"
Spriteinfo(2001).Segment = VARSEG(field1(1)): Spriteinfo(2001).Offset = VARPTR(field1(1))
Spriteinfo(2001).xsize = 344: Spriteinfo(2001).ysize = 150
IF lomem = 0 THEN
	Spriteinfo(2002).Segment = VARSEG(field2(1)): Spriteinfo(2002).Offset = VARPTR(field2(1))
	Spriteinfo(2002).xsize = 344: Spriteinfo(2002).ysize = 150
	Spriteinfo(2003).Segment = VARSEG(field3(1)): Spriteinfo(2003).Offset = VARPTR(field3(1))
	Spriteinfo(2003).xsize = 344: Spriteinfo(2003).ysize = 150
	Spriteinfo(2004).Segment = VARSEG(field4(1)): Spriteinfo(2004).Offset = VARPTR(field4(1))
	Spriteinfo(2004).xsize = 344: Spriteinfo(2004).ysize = 150
END IF

FOR lp = 0 TO 7
Spriteinfo(1950 + lp).Segment = VARSEG(markings(1, lp))
Spriteinfo(1950 + lp).Offset = VARPTR(markings(1, lp))
NEXT

IF lomem = 0 THEN fmax = 4 ELSE fmax = 1
FOR fieldnumber = 1 TO fmax
DEF SEG = Spriteinfo(2000 + fieldnumber).Segment: of = Spriteinfo(2000 + fieldnumber).Offset
FOR y = 0 TO 150: FOR x = 0 TO 345
		POKE x + y * 345 + of, 2 + (y \ 15 MOD 2) * 116
NEXT: NEXT

FOR lp = 0 TO 5000
n& = RND * 52246 + of: IF PEEK(n&) = 2 THEN POKE n&, 10 ELSE IF PEEK(n&) = 118 THEN POKE n&, 120
NEXT
NEXT

xoff = 359
yoff = 132
FOR y = -1 TO 2
FOR x = -1 TO 2
	sprite -xoff + 688 * x, -yoff + 300 * y, fs1, -1
	sprite -xoff + 688 * x, 150 - yoff + 300 * y, fs2, -1
	sprite -xoff + 344 + 688 * x, -yoff + 300 * y, fs3, -1
	sprite -xoff + 344 + 688 * x, 150 - yoff + 300 * y, fs4, -1
NEXT: NEXT
PUT (0, 0), vscreen, PSET
CIRCLE (160, 100), 60, 15, , , 1

Spriteinfo(1957).Segment = VARSEG(center(1)): Spriteinfo(1957).Offset = VARPTR(center(1))
Spriteinfo(1957).xsize = 120: Spriteinfo(1957).ysize = 120
sg = Spriteinfo(1957).Segment
of = Spriteinfo(1957).Offset

FOR y = 40 TO 160
	of2 = of + (y - 40) * 121
	of3 = y * 320
	FOR x = 100 TO 220
		DEF SEG = &HA000
		c = PEEK(x + of3)
		DEF SEG = sg
		POKE x - 100 + of2, c
	NEXT
NEXT

DEF SEG = Spriteinfo(1956).Segment: of = Spriteinfo(1956).Offset
Spriteinfo(1956).xsize = 1: Spriteinfo(1956).ysize = 1
FOR lp = 0 TO 3
POKE lp + of, 15
NEXT
CLOSE

Spriteinfo(1899).Segment = VARSEG(statusbar(1)): Spriteinfo(1899).Offset = VARPTR(statusbar(1))
Spriteinfo(1899).xsize = 319: Spriteinfo(1899).ysize = 31
DEF SEG = Spriteinfo(1899).Segment
OPEN "graphics\status.raw" FOR BINARY ACCESS READ AS #1
FOR lp = 0 TO 9919
POKE lp + Spriteinfo(1899).Offset + 320, ASC(INPUT$(1, 1))
NEXT
CLOSE

Spriteinfo(1898).Segment = VARSEG(smlfield(1)): Spriteinfo(1898).Offset = VARPTR(smlfield(1))
Spriteinfo(1898).xsize = 66: Spriteinfo(1898).ysize = 30
DEF SEG = Spriteinfo(1898).Segment
OPEN "graphics\field.raw" FOR BINARY ACCESS READ AS #1
FOR lp = 0 TO 2076
POKE lp + Spriteinfo(1898).Offset, ASC(INPUT$(1, 1))
NEXT
CLOSE


PALETTE 249, 664330

FOR t = 0 TO 1
RESTORE initpos
FOR p = 0 TO 10
READ x, y
teams(t, p).normxpos = x
IF t = 1 THEN teams(t, p).normxpos = 1039 - x
teams(t, p).normypos = y
teams(t, p).xpos = teams(t, p).normxpos
teams(t, p).ypos = teams(t, p).normypos
NEXT
NEXT
ballx = 519
bally = 232
camerax = FIX(ballx): cameray = FIX(bally)

refs(0).xpos = 520
refs(0).ypos = 220
refs(1).xpos = 520
refs(1).ypos = -16
refs(2).xpos = 520
refs(2).ypos = 480


FOR lp = 0 TO 255
	OUT &H3C7, lp
	FOR l = 0 TO 2
		pal(lp, l) = INP(&H3C9)
	NEXT
NEXT

col2 = shadowcolour
	FOR col1 = 0 TO 255
		
		avgr = (pal(col1, 0) + pal(col2, 0)) \ 2
		avgg = (pal(col1, 1) + pal(col2, 1)) \ 2
		avgb = (pal(col1, 2) + pal(col2, 2)) \ 2
		
		dist& = 2000000000
		FOR t = 0 TO 255
			
			rd = pal(t, 0) - avgr
			rg = pal(t, 1) - avgg
			rb = pal(t, 2) - avgb
			ndist& = rd * rd + rg * rg + rb * rb
		 
			
			IF ndist& < dist& THEN
				dist& = ndist&
				ncol = t
				IF dist& = 0 THEN GOTO foundnear
															
			END IF
		NEXT
foundnear:
		translucency(col1) = ncol
	NEXT


END SUB

SUB InitGFX
PRINT "Loading Graphics ";
FOR lp1 = 0 TO 7
FOR lp2 = 0 TO 7
Spriteinfo(1800 + lp1 + lp2 * 8).Segment = VARSEG(balls(1, lp1, lp2)): Spriteinfo(1800 + lp1 + lp2 * 8).Offset = VARPTR(balls(1, lp1, lp2))
Spriteinfo(1800 + lp1 + lp2 * 8).xsize = 15: Spriteinfo(1800 + lp1 + lp2 * 8).ysize = 15
NEXT: NEXT
PRINT ".";
FOR lp = 0 TO 31
Spriteinfo(lp).Segment = VARSEG(player1(1, lp)): Spriteinfo(lp).Offset = VARPTR(player1(1, lp))
Spriteinfo(lp).xsize = 15: Spriteinfo(lp).ysize = 15
NEXT
FOR lp = 0 TO 31
Spriteinfo(lp + 32).Segment = VARSEG(player2(1, lp)): Spriteinfo(lp + 32).Offset = VARPTR(player2(1, lp))
Spriteinfo(lp + 32).xsize = 15: Spriteinfo(lp + 32).ysize = 15
NEXT
FOR lp = 0 TO 31
Spriteinfo(lp + 300).Segment = VARSEG(refsdata(1, lp)): Spriteinfo(lp + 300).Offset = VARPTR(refsdata(1, lp))
Spriteinfo(lp + 300).xsize = 15: Spriteinfo(lp + 300).ysize = 15
NEXT

PRINT ".";
OPEN "graphics\soccer.raw" FOR BINARY ACCESS READ AS #1

FOR lp = 0 TO 6
FOR y = 0 TO 15
FOR x = 0 TO 127
DEF SEG = Spriteinfo(1800 + lp * 8 + x \ 16).Segment
of = Spriteinfo(1800 + lp * 8 + x \ 16).Offset
POKE (x MOD 16) + y * 16 + of, ASC(INPUT$(1, 1))
NEXT: NEXT
PRINT ".";
NEXT

PRINT ".";
FOR lp = 0 TO 3
FOR y = 0 TO 15
FOR x = 0 TO 127
DEF SEG = Spriteinfo(lp * 8 + x \ 16).Segment
of = Spriteinfo(lp * 8 + x \ 16).Offset
POKE (x MOD 16) + y * 16 + of, ASC(INPUT$(1, 1))
NEXT: NEXT
PRINT ".";
NEXT
Spriteinfo(1999).Segment = VARSEG(shadow(1))
Spriteinfo(1999).Offset = VARPTR(shadow(1))
Spriteinfo(1999).xsize = 1
Spriteinfo(1999).ysize = 1
DEF SEG = Spriteinfo(1999).Segment
FOR lp = 0 TO 3
	POKE lp + Spriteinfo(1999).Offset, 19
NEXT

Spriteinfo(1998).Segment = VARSEG(kshadow(1))
Spriteinfo(1998).Offset = VARPTR(kshadow(1))
Spriteinfo(1998).xsize = 5
Spriteinfo(1998).ysize = 11
DEF SEG = Spriteinfo(1998).Segment
RESTORE keepershadow:
FOR lp = 0 TO 71
	READ c
	POKE lp + Spriteinfo(1998).Offset, c
NEXT

FOR lp2 = 0 TO 7
	Spriteinfo(1900 + lp2).Segment = VARSEG(arrows(1, lp2)): Spriteinfo(1900 + lp2).Offset = VARPTR(arrows(1, lp2))
	Spriteinfo(1900 + lp2).xsize = 6: Spriteinfo(1900 + lp2).ysize = 6
NEXT
PRINT ".";
RESTORE arrows
FOR lp = 0 TO 7
	DEF SEG = Spriteinfo(1900 + lp).Segment
	FOR lp2 = 0 TO 48
		READ a
		POKE lp2 + Spriteinfo(1900 + lp).Offset, a
	NEXT
NEXT
PRINT ".";

RESTORE spinbits
FOR lp = 0 TO 3
FOR lp2 = 0 TO 5
READ spins(lp, lp2)
NEXT: NEXT
PRINT ".";
CLOSE


OPEN "graphics\numbers.raw" FOR BINARY ACCESS READ AS #1
FOR lp = 0 TO 10
	Spriteinfo(1750 + lp).Segment = VARSEG(numbers(1, lp)): Spriteinfo(1750 + lp).Offset = VARPTR(numbers(1, lp))
	Spriteinfo(1750 + lp).xsize = 13: Spriteinfo(1750 + lp).ysize = 23
	DEF SEG = Spriteinfo(1750 + lp).Segment
	of = Spriteinfo(1750 + lp).Offset
	FOR y = 0 TO 23
		FOR x = 0 TO 13
		  POKE of + x + y * 14, ASC(INPUT$(1, 1))
		NEXT
	NEXT
NEXT
CLOSE
OPEN "graphics\team2.raw" FOR BINARY ACCESS READ AS #1
PRINT ".";
FOR lp = 0 TO 3
FOR y = 0 TO 15
FOR x = 0 TO 127
DEF SEG = Spriteinfo(lp * 8 + x \ 16 + 32).Segment
of = Spriteinfo(lp * 8 + x \ 16 + 32).Offset
POKE (x MOD 16) + y * 16 + of, ASC(INPUT$(1, 1))
NEXT: NEXT
PRINT ".";
NEXT
CLOSE

OPEN "graphics\refs.raw" FOR BINARY ACCESS READ AS #1
PRINT ".";
FOR lp = 0 TO 3
FOR y = 0 TO 15
FOR x = 0 TO 127
DEF SEG = Spriteinfo(lp * 8 + x \ 16 + 300).Segment
of = Spriteinfo(lp * 8 + x \ 16 + 300).Offset
POKE (x MOD 16) + y * 16 + of, ASC(INPUT$(1, 1))
NEXT: NEXT
PRINT ".";
NEXT
CLOSE

PRINT "Done!"
END SUB

FUNCTION kbhit
FOR lp = 0 TO 128
IF kbmatrix(lp) THEN kbhit = 1
NEXT
END FUNCTION

SUB LeftGoalCheck
polecheck 0, 200

IF obx >= -30 AND obx <= 0 THEN wasingoalx = 1
IF oby >= 200 AND oby <= 264 THEN wasingoaly = 1
IF obz < 8 THEN wasingoalz = 1
wasingoal = (wasingoalx AND wasingoaly AND wasingoalz)

IF ballx >= -30 AND ballx <= 0 THEN isingoalx = 1
IF bally >= 200 AND bally <= 264 THEN isingoaly = 1
IF ballz < 8 THEN isingoalz = 1
isingoal = (isingoalx AND isingoaly AND isingoalz)


'check if goal left
IF isingoal = 0 AND wasingoal AND ballz > 8 THEN
ballz = 6
balldx = balldx / 1.25
balldy = balldy / 1.25
balldz = 0
END IF

IF isingoal = 0 AND wasingoal AND ballx < -30 THEN
ballx = -28
balldx = 0
balldy = balldy / 5
balldz = balldz / 5
END IF

IF isingoal = 0 AND wasingoal AND bally > 264 THEN
bally = 262
balldx = balldx / 3
balldy = -balldy / 8
balldz = balldz / 1.25
END IF

IF isingoal = 0 AND wasingoal AND bally < 200 THEN
bally = 202
balldx = balldx / 1.25
balldy = -balldy / 8
balldz = balldz / 1.25
END IF


' check if goal entered
IF isingoal AND obz > 8 AND ballz < 8 THEN
ballz = 8.5
balldx = balldx / 1.1
balldy = balldy / 1.1
balldz = -balldz / 20
END IF

IF isingoal AND obx < -30 AND ballx > -30 THEN
ballx = -32
balldx = 0
balldy = balldy / 5
balldz = balldz / 5
END IF

IF isingoal AND oby > 264 AND bally < 264 THEN
bally = 268
balldx = balldx / 3
balldy = -balldy / 8
balldz = balldz / 1.25
END IF

IF isingoal AND oby < 200 AND bally > 200 THEN
bally = 198
balldx = balldx / 1.25
balldy = -balldy / 8
balldz = balldz / 1.25
END IF


isingoalx = 0: isingoaly = 0: isingoalz = 0
IF ballx >= -30 AND ballx <= 0 THEN isingoalx = 1
IF bally >= 200 AND bally <= 264 THEN isingoaly = 1
IF ballz < 8 THEN isingoalz = 1
isingoal = (isingoalx AND isingoaly AND isingoalz)

IF wasingoal = 0 AND isingoal = 1 THEN score = score + 1: Sound.DMAPlay "goalsht1.snd", 165: validtime! = TIMER + 5
END SUB

SUB LeftKeeper (tnum, pnum)
IF teams(tnum, pnum).posession = 1 THEN GetPlayer tnum, pnum
IF balldx < -.01 THEN
	'timetogoal! = -ballx / balldx
	timetogoal! = ABS((ballx - 10) / balldx)
	IF timetogoal! < .001 THEN timetogoal! = .001
	yatgoal! = timetogoal! * balldy + bally
  
	dist! = (ballx - teams(tnum, pnum).xpos) ^ 2 + (bally - teams(tnum, pnum).ypos) ^ 2
	IF yatgoal! >= 180 AND yatgoal! <= 284 THEN
		IF ABS(yatgoal! - teams(tnum, pnum).ypos) / timetogoal! > 3 THEN
			IF teams(tnum, pnum).zpos = 0 AND teams(tnum, pnum).dy = 0 THEN
				IF timetogoal! < 10 THEN
					IF balldz > 0 THEN teams(tnum, pnum).dz = 1
					IF ballz > 4 AND balldz > 0 THEN teams(tnum, pnum).dz = 1.2
					IF ballz > 4 AND balldz < 0 THEN teams(tnum, pnum).dz = .85
					IF teams(tnum, pnum).dz < .45 THEN teams(tnum, pnum).dz = .45
					IF teams(tnum, pnum).dz > 1.2 THEN teams(tnum, pnum).dz = 1.2
				END IF
				teams(tnum, pnum).dy = (yatgoal! - teams(tnum, pnum).ypos) / timetogoal!
				teams(tnum, pnum).dx = .2
				IF ABS(teams(tnum, pnum).dy) > 5 THEN teams(tnum, pnum).dy = 5 * SGN(teams(tnum, pnum).dy)
			END IF
		ELSE
			FOR lp = 0 TO 3
				IF teams(tnum, pnum).zpos = 0 THEN
					IF timetogoal! < 8 THEN
						IF balldz > 0 THEN teams(tnum, pnum).dz = 1
						IF ballz > 4 AND balldz > 0 THEN teams(tnum, pnum).dz = 1.2
						IF ballz > 4 AND balldz < 0 THEN teams(tnum, pnum).dz = .85
						IF teams(tnum, pnum).dz < .45 THEN teams(tnum, pnum).dz = .45
						IF teams(tnum, pnum).dz > 1.2 THEN teams(tnum, pnum).dz = 1.2
					END IF
				END IF
				teams(tnum, pnum).ypos = teams(tnum, pnum).ypos + SGN(yatgoal! - teams(tnum, pnum).ypos) \ 1.1
				IF ABS(teams(tnum, pnum).ypos - yatgoal!) < .5 THEN teams(tnum, pnum).ypos = yatgoal!
			NEXT
		END IF
	END IF
ELSE
	IF teams(tnum, pnum).zpos = 0 AND teams(tnum, pnum).dy = 0 THEN
		IF ABS(ballx) > .001 THEN teams(tnum, pnum).normypos = 10 * (bally - 232) / ABS(ballx) + 232
		IF teams(tnum, pnum).posession = 1 THEN teams(tnum, pnum).normypos = 232
		IF teams(tnum, pnum).normypos > 304 THEN teams(tnum, pnum).normypos = 304
		IF teams(tnum, pnum).normypos < 160 THEN teams(tnum, pnum).normypos = 160
				  
		dist! = (ballx - teams(tnum, pnum).xpos) ^ 2 + (bally - teams(tnum, pnum).ypos) ^ 2
		IF dist! < 900 THEN
			angle! = GetAngle(ballx - teams(tnum, pnum).xpos, bally - teams(tnum, pnum).ypos)
			teams(tnum, pnum).xpos = teams(tnum, pnum).xpos + 5 * COS(angle!)
			teams(tnum, pnum).ypos = teams(tnum, pnum).ypos + 5 * SIN(angle!)
		ELSE
			FOR lp = 0 TO 2
				teams(tnum, pnum).xpos = teams(tnum, pnum).xpos - SGN(teams(tnum, pnum).xpos - teams(tnum, pnum).normxpos)
				teams(tnum, pnum).ypos = teams(tnum, pnum).ypos - SGN(teams(tnum, pnum).ypos - teams(tnum, pnum).normypos)
				IF ABS(teams(tnum, pnum).xpos - teams(tnum, pnum).normxpos) < .5 THEN teams(tnum, pnum).xpos = teams(tnum, pnum).normxpos
				IF ABS(teams(tnum, pnum).ypos - teams(tnum, pnum).normypos) < .5 THEN teams(tnum, pnum).ypos = teams(tnum, pnum).normypos
			NEXT
		END IF
	END IF
END IF

teams(tnum, pnum).zpos = teams(tnum, pnum).zpos + teams(tnum, pnum).dz
teams(tnum, pnum).dz = teams(tnum, pnum).dz - .15
IF teams(tnum, pnum).zpos < 0 THEN
	teams(tnum, pnum).zpos = 0
	teams(tnum, pnum).dz = 0
	IF teams(tnum, pnum).dz < .1 THEN teams(tnum, pnum).dz = 0
	teams(tnum, pnum).dy = teams(tnum, pnum).dy / 2
	teams(tnum, pnum).dx = teams(tnum, pnum).dx / 2
	IF teams(tnum, pnum).dy < .1 THEN teams(tnum, pnum).dy = 0
END IF

teams(tnum, pnum).ypos = teams(tnum, pnum).ypos + teams(tnum, pnum).dy
teams(tnum, pnum).xpos = teams(tnum, pnum).xpos + teams(tnum, pnum).dx

END SUB

SUB Line3D (x1, y1, z1!, x2, y2, z2!, col, xoff, yoff) STATIC

linex1 = x1 - xoff - (160 - x1 + xoff) * z1! / persplevel
liney1 = y1 - yoff - (84 - y1 + yoff) * z1! / persplevel

linex2 = x2 - xoff - (160 - x2 + xoff) * z2! / persplevel
liney2 = y2 - yoff - (84 - y2 + yoff) * z2! / persplevel

vline linex1, liney1, linex2, liney2, col

END SUB

SUB MainMenu
SCREEN 13

PRINT "Loading menu"
OPEN "graphics\mainmenu.bin" FOR BINARY ACCESS READ AS #1
j$ = INPUT$(8, 1)
DEF SEG = vscreenseg
FOR lp& = 1 TO 64000
POKE lp& + vscreenloc, ASC(INPUT$(1, 1))
NEXT
CLOSE

FOR lp = 0 TO 255
	OUT &H3C8, lp
	FOR l = 0 TO 2
		OUT &H3C9, 0
	NEXT
NEXT
fadetype = 1

OPEN "graphics\mainmenu.col" FOR BINARY ACCESS READ AS #1
FOR lp = 0 TO 255
	FOR l2 = 0 TO 2
		pal(lp, l2) = ASC(INPUT$(1, 1))
	NEXT
NEXT
CLOSE #1

DEF SEG = &HA000
BLOAD "graphics\mainmenu.bin", 0

FOR Fade = 0 TO 63
	kbmatrix(128) = 0
	FOR lp = 0 TO 255
		OUT &H3C8, lp
		FOR l = 0 TO 2
			OUT &H3C9, pal(lp, l) * Fade \ 63
		NEXT
	NEXT
	SELECT CASE fadetype
		CASE 1: WAIT &H3DA, 8
		CASE 2: t! = TIMER: DO: LOOP UNTIL TIMER - t! <> 0: WAIT &H3DA, 8
	END SELECT
NEXT


menuy = 0
ymax = 199
DO
kbmatrix(128) = 0
IF kbmatrix(1) THEN exi = 1
IF menuz! = 0 THEN
	IF kbmatrix(72) AND menuy > 0 THEN menudy = -1: menudz! = 2.1: Sound.DMAPlay "kick2.snd", 200
	IF kbmatrix(80) AND menuy < 120 THEN menudy = 1: menudz! = 2.1: Sound.DMAPlay "kick2.snd", 200
	IF kbmatrix(29) THEN
		SELECT CASE menuy
			CASE 0: exi = 1: Sound.DMAPlay "goalsht1.snd", 130: validtime! = TIMER + 3
			CASE 41: exi = 1: isdemo = 1: Sound.DMAPlay "goalsht1.snd", 130: validtime! = TIMER + 3
			CASE 82: Help
						FOR lp = 0 TO 255
							OUT &H3C8, lp
							FOR l = 0 TO 2
								OUT &H3C9, pal(lp, l)
							NEXT
						NEXT

		END SELECT
	END IF
END IF
menudz! = menudz! - .1
menuz! = menuz! + menudz!
menuy = menuy + menudy
IF menudz! <= -2 OR menuz! < 0 THEN menudz! = 0: menuz! = 0: menudy = 0
IF menuy MOD 5 = 0 THEN Ballspin menudy * 4
bfram = 55 - 8 * FIX((menuz! / 8)) - bfram2

ballx2! = 25
bally2! = menuy + 61

ballx2! = 25 - (160 - 25) * menuz! / (persplevel * 3)
bally2! = bally2! - (84 - menuy) * menuz! / (persplevel * 3)

DEF SEG = vscreenseg
FOR x = 24 TO 25
FOR y = menuy + 60 TO menuy + 61
POKE x + y * 320 + vscreenloc, 18
NEXT
NEXT

sprite FIX(ballx2!) - 8, FIX(bally2!) - 8, 1800 + bfram, 0

WAIT &H3DA, 8
PUT (0, 0), vscreen, PSET

DEF SEG = vscreenseg
FOR x = 0 TO 28
FOR y = 50 TO 188
POKE x + y * 320 + vscreenloc, 0
NEXT
NEXT


LOOP UNTIL exi = 1

										  
fadetype = 2
FOR Fade = 63 TO 0 STEP -1
	kbmatrix(128) = 0
	FOR lp = 0 TO 255
		OUT &H3C8, lp
		FOR l = 0 TO 2
			OUT &H3C9, pal(lp, l) * Fade \ 63
		NEXT
	NEXT
	SELECT CASE fadetype
		CASE 1: WAIT &H3DA, 8
		CASE 2: t! = TIMER: DO: LOOP UNTIL TIMER - t! <> 0: WAIT &H3DA, 8
	END SELECT
NEXT
CLS
PALETTE
DEF SEG = vscreenseg
vcls
ymax = 167
END SUB

SUB polecheck (polex, poley)
'BEATCH!
END SUB

SUB RightGoalCheck
IF obx >= 1039 AND obx <= 1069 THEN wasingoalx = 1
IF oby >= 200 AND oby <= 264 THEN wasingoaly = 1
IF obz < 8 THEN wasingoalz = 1
wasingoal = (wasingoalx AND wasingoaly AND wasingoalz)

IF ballx > 1039 AND ballx < 1069 THEN isingoalx = 1
IF bally > 200 AND bally < 264 THEN isingoaly = 1
IF ballz < 8 THEN isingoalz = 1
isingoal = (isingoalx AND isingoaly AND isingoalz)


'check if goal left
IF isingoal = 0 AND wasingoal AND ballz > 8 THEN
ballz = 6
balldx = balldx / 1.25
balldy = balldy / 1.25
balldz = 0
END IF

IF isingoal = 0 AND wasingoal AND ballx > 1069 THEN
ballx = 1067
balldx = 0
balldy = balldy / 5
balldz = balldz / 5
END IF

IF isingoal = 0 AND wasingoal AND bally > 264 THEN
bally = 262
balldx = balldx / 3
balldy = -balldy / 8
balldz = balldz / 1.25
END IF

IF isingoal = 0 AND wasingoal AND bally < 200 THEN
bally = 202
balldx = balldx / 1.25
balldy = -balldy / 8
balldz = balldz / 1.25
END IF


' check if goal entered
IF isingoal AND obz > 8 AND ballz < 8 THEN
ballz = 8.5
balldx = balldx / 1.1
balldy = balldy / 1.1
balldz = -balldz / 20
END IF

IF isingoal AND obx > 1069 AND ballx < 1069 THEN
ballx = 1071
balldx = 0
balldy = balldy / 5
balldz = balldz / 5
END IF

IF isingoal AND oby > 264 AND bally < 264 THEN
bally = 268
balldx = balldx / 3
balldy = -balldy / 8
balldz = balldz / 1.25
END IF

IF isingoal AND oby < 200 AND bally > 200 THEN
bally = 198
balldx = balldx / 1.25
balldy = -balldy / 8
balldz = balldz / 1.25
END IF


isingoalx = 0: isingoaly = 0: isingoalz = 0
IF ballx >= 1039 AND ballx <= 1069 THEN isingoalx = 1
IF bally >= 200 AND bally <= 264 THEN isingoaly = 1
IF ballz < 8 THEN isingoalz = 1
isingoal = (isingoalx AND isingoaly AND isingoalz)

IF wasingoal = 0 AND isingoal = 1 THEN score1 = score1 + 1: Sound.DMAPlay "goalsht2.snd", 165: validtime! = TIMER + 5

END SUB

SUB RightKeeper (tnum, pnum)
IF teams(tnum, pnum).posession = 1 THEN GetPlayer tnum, pnum
IF balldx > .01 THEN
	'timetogoal! = 1039 - ballx / balldx
	timetogoal! = ABS((1029 - ballx) / balldx)
	IF timetogoal! < .001 THEN timetogoal! = .001
	yatgoal! = timetogoal! * balldy + bally
	IF yatgoal! >= 180 AND yatgoal! <= 284 THEN
		IF ABS(yatgoal! - teams(tnum, pnum).ypos) / timetogoal! > 3 THEN
			IF teams(tnum, pnum).zpos = 0 AND teams(tnum, pnum).dy = 0 THEN
				IF timetogoal! < 10 THEN
					IF balldz > 0 THEN teams(tnum, pnum).dz = 1
					IF ballz > 4 AND balldz > 0 THEN teams(tnum, pnum).dz = 1.2
					IF ballz > 4 AND balldz < 0 THEN teams(tnum, pnum).dz = .85
					IF teams(tnum, pnum).dz < .45 THEN teams(tnum, pnum).dz = .45
					IF teams(tnum, pnum).dz > 1.2 THEN teams(tnum, pnum).dz = 1.2
				END IF
				teams(tnum, pnum).dy = (yatgoal! - teams(tnum, pnum).ypos) / timetogoal!
				teams(tnum, pnum).dx = .2
				IF ABS(teams(tnum, pnum).dy) > 5 THEN teams(tnum, pnum).dy = 5 * SGN(teams(tnum, pnum).dy)
			END IF
		ELSE
			FOR lp = 0 TO 3
				IF teams(tnum, pnum).zpos = 0 THEN
					IF timetogoal! < 8 THEN
						IF balldz > 0 THEN teams(tnum, pnum).dz = 1
						IF ballz > 4 AND balldz > 0 THEN teams(tnum, pnum).dz = 1.2
						IF ballz > 4 AND balldz < 0 THEN teams(tnum, pnum).dz = .85
						IF teams(tnum, pnum).dz < .45 THEN teams(tnum, pnum).dz = .45
						IF teams(tnum, pnum).dz > 1.2 THEN teams(tnum, pnum).dz = 1.2
					END IF
				END IF
				teams(tnum, pnum).ypos = teams(tnum, pnum).ypos + SGN(yatgoal! - teams(tnum, pnum).ypos) \ 1.1
				IF ABS(teams(tnum, pnum).ypos - yatgoal!) < .5 THEN teams(tnum, pnum).ypos = yatgoal!
			NEXT
		END IF
	END IF
ELSE
	IF teams(tnum, pnum).zpos = 0 AND teams(tnum, pnum).dy = 0 THEN
		IF ABS(ballx) > .001 THEN teams(tnum, pnum).normypos = 10 * (bally - 232) / ABS(ballx) + 232
		IF teams(tnum, pnum).posession = 1 THEN teams(tnum, pnum).normypos = 232
		IF teams(tnum, pnum).normypos > 304 THEN teams(tnum, pnum).normypos = 304
		IF teams(tnum, pnum).normypos < 160 THEN teams(tnum, pnum).normypos = 160
		dist! = (ballx - teams(tnum, pnum).xpos) ^ 2 + (bally - teams(tnum, pnum).ypos) ^ 2
		IF dist! < 900 THEN
			angle! = GetAngle(ballx - teams(tnum, pnum).xpos, bally - teams(tnum, pnum).ypos)
			teams(tnum, pnum).xpos = teams(tnum, pnum).xpos + 5 * COS(angle!)
			teams(tnum, pnum).ypos = teams(tnum, pnum).ypos + 5 * SIN(angle!)
		ELSE
			FOR lp = 0 TO 2
				teams(tnum, pnum).xpos = teams(tnum, pnum).xpos - SGN(teams(tnum, pnum).xpos - teams(tnum, pnum).normxpos)
				teams(tnum, pnum).ypos = teams(tnum, pnum).ypos - SGN(teams(tnum, pnum).ypos - teams(tnum, pnum).normypos)
				IF ABS(teams(tnum, pnum).xpos - teams(tnum, pnum).normxpos) < .5 THEN teams(tnum, pnum).xpos = teams(tnum, pnum).normxpos
				IF ABS(teams(tnum, pnum).ypos - teams(tnum, pnum).normypos) < .5 THEN teams(tnum, pnum).ypos = teams(tnum, pnum).normypos
			NEXT
		END IF
	END IF
END IF

teams(tnum, pnum).zpos = teams(tnum, pnum).zpos + teams(tnum, pnum).dz
teams(tnum, pnum).dz = teams(tnum, pnum).dz - .15
IF teams(tnum, pnum).zpos < 0 THEN
	teams(tnum, pnum).zpos = 0
	teams(tnum, pnum).dz = 0
	IF teams(tnum, pnum).dz < .1 THEN teams(tnum, pnum).dz = 0
	teams(tnum, pnum).dy = teams(tnum, pnum).dy / 2
	teams(tnum, pnum).dx = teams(tnum, pnum).dx / 2
	IF teams(tnum, pnum).dy < .1 THEN teams(tnum, pnum).dy = 0
END IF

teams(tnum, pnum).ypos = teams(tnum, pnum).ypos + teams(tnum, pnum).dy
teams(tnum, pnum).xpos = teams(tnum, pnum).xpos + teams(tnum, pnum).dx


END SUB

SUB ShowField (xoff, yoff)
IF xoff < -100 THEN xoff = -100
IF xoff > 821 THEN xoff = 821
IF yoff < -75 THEN yoff = -75
IF yoff > 372 THEN yoff = 372

DisplayPitch xoff, yoff
'sprite teams(0, 0).xpos - xoff - 3, teams(0, 0).ypos - yoff - 6, 1998, 0
'sprite teams(1, 0).xpos - xoff - 3, teams(1, 0).ypos - yoff - 6, 1998, 0

FOR lp = 0 TO 1
	ix = teams(lp, 0).xpos
	iy = teams(lp, 0).ypos - 6
  
	tvline ix - 3 - xoff, iy + 3 - yoff, ix - 3 - xoff, iy + 8 - yoff, 0
	tvline ix - 2 - xoff, iy + 1 - yoff, ix - 2 - xoff, iy + 10 - yoff, 0
	tvline ix - 1 - xoff, iy - yoff, ix - 1 - xoff, iy + 11 - yoff, 0
	tvline ix - xoff, iy - yoff, ix - xoff, iy + 11 - yoff, 0
	tvline ix + 1 - xoff, iy + 1 - yoff, ix + 1 - xoff, iy + 10 - yoff, 0
	tvline ix + 2 - xoff, iy + 3 - yoff, ix + 2 - xoff, iy + 8 - yoff, 0
  
NEXT


FOR lp = 0 TO 10
IF teams(1, lp).active = 1 AND frames& MOD 8 >= 4 AND isdemo = 0 THEN sprite teams(1, lp).xpos - xoff - 3, teams(1, lp).ypos - yoff + 8, 1901, 0
NEXT
'sprite FIX(ballx) - xoff - 1, FIX(bally) - yoff - 1, 1999, -1
tvline FIX(ballx) - xoff - 1, FIX(bally) - yoff - 1, FIX(ballx) - xoff, FIX(bally) - yoff - 1, 0
tvline FIX(ballx) - xoff - 1, FIX(bally) - yoff, FIX(ballx) - xoff, FIX(bally) - yoff, 0
ballx2! = ballx - xoff
bally2! = bally - yoff
IF ballz > 3.5 OR (ballx > -80 AND ballx < 1109 AND bally > -48 AND bally < 502) THEN DrawAdverts xoff, yoff: high3 = 1

IF ballz > 0 THEN
IF ballz > 5 THEN DoPlayerSprites xoff, yoff: high = 1
IF ballz > 8 THEN Do3dparts xoff, yoff: high2 = 1

ballx2! = ballx2! - (160 - FIX(ballx) + xoff) * ballz / persplevel
bally2! = bally2! - (84 - FIX(bally) + yoff) * ballz / persplevel
END IF
sprite FIX(ballx2!) - 8, FIX(bally2!) - 8, 1800 + bfram, 0
IF high = 0 THEN DoPlayerSprites xoff, yoff
IF high3 = 0 THEN DrawAdverts xoff, yoff
IF high2 = 0 THEN Do3dparts xoff, yoff
ymax = 199
sprite 126, 169, 1898, -1
IF score1 >= 10 THEN s = 1750 + (score1 \ 10) MOD 10 ELSE s = 1760
sprite 40, 173, s, -1
sprite 52, 173, 1750 + score1 MOD 10, -1
IF score >= 10 THEN s = 1750 + (score \ 10) MOD 10 ELSE s = 1760
sprite 255, 173, s, -1
sprite 267, 173, 1750 + score MOD 10, -1
ymax = 167


FOR t = 0 TO 1
FOR p = 0 TO 10
xloc = FIX(teams(t, p).xpos / 16) + 1: yloc = FIX(teams(t, p).ypos / 16) + 1
IF yloc <= 31 AND yloc >= 0 AND xloc >= 0 AND xloc < 67 THEN DEF SEG = vscreenseg: POKE xloc + 126 + (yloc + 169) * 320 + vscreenloc, 40 - 8 * t
NEXT
NEXT

xloc = FIX(ballx / 16) + 1: yloc = FIX(bally / 16) + 1
IF yloc <= 31 AND yloc >= 0 AND xloc >= 0 AND xloc < 67 THEN DEF SEG = vscreenseg: POKE xloc + 126 + (yloc + 169) * 320 + vscreenloc, 15


IF dodrawlines = 1 THEN
vline drawlines(1, 0) - xoff, drawlines(1, 1) - yoff, drawlines(1, 2) - xoff, drawlines(1, 3) - yoff, 40
vline drawlines(0, 0) - xoff, drawlines(0, 1) - yoff, drawlines(0, 2) - xoff, drawlines(0, 3) - yoff, 15
END IF

'WAIT &H3DA, 8
IF TIMER - stime! > 1 AND fpson THEN
fps = frames& / (TIMER - stime!)
IF fps >= 10 THEN s = 1750 + (fps \ 10) MOD 10 ELSE s = 1760
sprite 0, 0, s, -1
sprite 12, 0, 1750 + fps MOD 10, -1
END IF

PUT (0, 0), vscreen, PSET
IF kbmatrix(55) THEN
OPEN "soccersg.raw" FOR OUTPUT AS #1
FOR y = 0 TO 199
FOR x = 0 TO 319
DEF SEG = &HA000
PRINT #1, CHR$(PEEK(x + y * 320));
NEXT
NEXT
CLOSE
END IF
END SUB

SUB SideLines
IF obx >= 0 AND obx <= 1039 AND oby >= 0 AND oby <= 464 THEN wasin = 1
IF ballx >= 0 AND ballx <= 1039 AND bally >= 0 AND bally <= 464 THEN isin = 1
IF wasin = 1 AND isin = 0 THEN Sound.DMAPlay "wshort.snd", 200

END SUB

SUB Sound.DeInitDSP
Sound.WriteDSP &HD3
OUT &H20, &H20
END SUB

SUB Sound.DMAPlay (file$, spd)
SHARED IRQ, dma
IF NoSamples = 0 AND TIMER > validtime! THEN

junk = Sound.ResetDSP

OPEN "sound\" + file$ FOR BINARY ACCESS READ AS #1
	REDIM SndDat(1) AS STRING
	length& = LOF(1) - 1
 
	SndDat(1) = STRING$(LOF(1), 0)
	GET #1, , SndDat(1)': SndDat(1) = RIGHT$(SndDat(1), LEN(SndDat(1)) - 5)
CLOSE #1

Segment& = VARSEG(SndDat(1))
Offset& = SADD(SndDat(1))
IF Segment& < 0 THEN Segment& = Segment& + 65536
IF Offset& < 0 THEN Offset& = Offset& + 65536
MemLoc& = Segment& * 16 + Offset&

OUT &HA, &H4 + dma
OUT &HC, &H0
OUT &HB, &H0

OUT AddPort, MemLoc& AND &HFF
OUT AddPort, (MemLoc& AND &HFFFF&) \ &H100

Page = (MemLoc& AND &HF0000) \ &H10000

OUT PgPort, Page
OUT LenPort, length& AND &HFF
OUT LenPort, (length& AND &HFFFF&) \ &H100
OUT &HA, dma

OUT BasePort + 4, &H22                        'Set volume
OUT BasePort + 5, 255

Sound.WriteDSP &H40
Sound.WriteDSP spd
Sound.WriteDSP &H14
Sound.WriteDSP length& AND &HFF
Sound.WriteDSP ((length& AND &HFFFF&) \ &H100)

END IF
END SUB

SUB Sound.GetBlaster
BasePort = VAL("&h" + MID$(ENVIRON$("BLASTER"), INSTR(ENVIRON$("BLASTER"), "A") + 1, 3))
IRQ = VAL(MID$(ENVIRON$("BLASTER"), INSTR(ENVIRON$("BLASTER"), "I") + 1, 1))
dma = VAL(MID$(ENVIRON$("BLASTER"), INSTR(ENVIRON$("BLASTER"), "D") + 1, 1))
END SUB

FUNCTION Sound.ResetDSP
 OUT BasePort + 6, 1
 OUT BasePort + 6, 0
 FOR n = 1 TO 100
  WAIT &H3DA, 8
  WAIT &H3DA, 12
  IF INP(BasePort + &HE) AND 128 THEN GOTO ok
 NEXT n
 EXIT FUNCTION
ok:
 IF INP(BasePort + &HA) = &HAA THEN
  Sound.ResetDSP = 1

  OUT BasePort + 4, &H0
  OUT BasePort + 5, 0

  SELECT CASE dma
	CASE 0 TO 3
	 MskPort = &HA
	 ModPort = &HB
	 ClrPort = &HC
	CASE ELSE
	 MskPort = &HD4
	 ModPort = &HD6
	 ClrPort = &HD8
  END SELECT

  OUT MskPort, dma + 4
  OUT ClrPort, &H0
  OUT ModPort, 72 + dma
  OUT MskPort, dma

  Sound.WriteDSP &HD1
 
 END IF
END FUNCTION

SUB Sound.WriteDSP (byte)
 SHARED BasePort
 add = BasePort + 12
 s! = TIMER
 DO
  IF ABS(TIMER - s!) >= .5 THEN EXIT DO
 LOOP WHILE INP(add) AND &H80
 OUT add, byte
END SUB

SUB Sound.WriteReg (reg, info)
 OUT &H388, reg
 FOR d = 1 TO 6: x = INP(&H388): NEXT d
 OUT &H389, info
 FOR d = 1 TO 35: x = INP(&H388): NEXT d
END SUB

SUB sprite (x%, y%, num%, arg%) STATIC
Segment = Spriteinfo(num).Segment
Offset = Spriteinfo(num).Offset
xsize = Spriteinfo(num).xsize
ysize = Spriteinfo(num).ysize
IF x < xmin THEN x1 = xmin - x ELSE x1 = 0
IF y < ymin THEN y1 = ymin - y ELSE y1 = 0
IF x > xmax - xsize THEN x2 = xmax - x ELSE x2 = xsize
IF y > ymax - ysize THEN y2 = ymax - y ELSE y2 = ysize
loc2 = vscreenloc + x + y * 320 + x1
xs2 = xsize + 1
SELECT CASE arg
	CASE -1:
		FOR yo = y1 TO y2
			yo2 = yo * 320 + loc2
			off2 = yo * xs2 + Offset + x1
			FOR xo = x1 TO x2
				DEF SEG = Segment
				Ln = PEEK(off2)
				DEF SEG = vscreenseg
				POKE yo2, Ln
				off2 = off2 + 1
				yo2 = yo2 + 1
			NEXT
		NEXT
	CASE ELSE:
		DEF SEG = Segment
		FOR yo = y1 TO y2
			yo2 = yo * 320 + loc2
			off2 = yo * xs2 + Offset + x1
			FOR xo = x1 TO x2
				Ln = PEEK(off2)
				IF Ln <> arg THEN DEF SEG = vscreenseg: POKE yo2, Ln: DEF SEG = Segment
				off2 = off2 + 1
				yo2 = yo2 + 1
			NEXT
		NEXT

END SELECT
END SUB

SUB sprite2 (x%, y%, num%, arg%)
Segment = Spriteinfo(num).Segment
Offset = Spriteinfo(num).Offset
xsize = Spriteinfo(num).xsize
ysize = Spriteinfo(num).ysize
IF x < xmin THEN x1 = xmin - x ELSE x1 = 0
IF y < ymin THEN y1 = ymin - y ELSE y1 = 0
IF x > xmax - xsize THEN x2 = xmax - x ELSE x2 = xsize
IF y > ymax - ysize THEN y2 = ymax - y ELSE y2 = ysize
loc2 = vscreenloc + x + y * 320 + x1
xs2 = xsize + 1
SELECT CASE arg
	CASE -1:
		FOR yo = y1 TO y2
			yo2 = yo * 320 + loc2
			off2 = yo * xs2 + Offset + x1
			FOR xo = x1 TO x2
				DEF SEG = Segment
				Ln = PEEK(off2)
				DEF SEG = vscreenseg
				POKE yo2, Ln
				off2 = off2 + 1
				yo2 = yo2 + 1
			NEXT
		NEXT
	CASE ELSE:
		DEF SEG = Segment
		FOR yo = y1 TO y2
			yo2 = yo * 320 + loc2
			off2 = yo * xs2 + Offset + x1
			FOR xo = x1 TO x2
				Ln = PEEK(off2)
				IF Ln <> arg THEN DEF SEG = vscreenseg: POKE yo2, Ln: DEF SEG = Segment
				off2 = off2 + 1
				yo2 = yo2 + 1
			NEXT
		NEXT

END SELECT
END SUB

SUB Startup

DEF SEG = &HA000
SCREEN 13
FOR lp = 0 TO 255
	OUT &H3C8, lp
	FOR l = 0 TO 2
		OUT &H3C9, 0
	NEXT
NEXT
BLOAD "graphics\text.bin", 0

xpos = 0
FOR lp = 0 TO 59
	oxpos = xpos
	DO
		in = 0
		FOR y = 0 TO 7
			IF POINT(xpos, y) <> 0 THEN in = 1
		NEXT
		xpos = xpos + 1
	LOOP UNTIL in = 0
GET (oxpos, 0)-(xpos - 1, 7), letters(1, lp)
lwidths(lp) = xpos - oxpos
NEXT

CLS
PALETTE
END SUB

SUB Startup2
DEF SEG = &HA000
SCREEN 13
FOR lp = 0 TO 255
	OUT &H3C8, lp
	FOR l = 0 TO 2
		OUT &H3C9, 0
	NEXT
NEXT
OPEN "graphics\font2.raw" FOR BINARY ACCESS READ AS #1
FOR y = 0 TO 4
	FOR x = 0 TO 258
		PSET (x, y), ASC(INPUT$(1, 1))
	NEXT
NEXT

xpos = 0
FOR lp = 0 TO 63
	Spriteinfo(400 + lp).Segment = VARSEG(letters(1, lp)): Spriteinfo(400 + lp).Offset = VARPTR(letters(1, lp))
	Spriteinfo(400 + lp).ysize = 4
	DEF SEG = Spriteinfo(400 + lp).Segment
	of = Spriteinfo(400 + lp).Offset
	oxpos = xpos
	DO
		in = 0
		FOR y = 0 TO 4
			IF POINT(xpos, y) <> 0 THEN in = 1
		NEXT
		xpos = xpos + 1
	LOOP UNTIL in = 0
	lwidths(lp) = xpos - oxpos
	Spriteinfo(400 + lp).xsize = lwidths(lp) - 1
	xs = lwidths(lp)
FOR y = 0 TO 4
	FOR x = oxpos TO xpos - 1
		POKE x - oxpos + y * xs + of, POINT(x, y)
		 'PSET (x, y), 0

	NEXT
NEXT
NEXT
CLOSE
CLS
PALETTE
END SUB

SUB Title
SCREEN 13
CLS
GPrint 0, 0, "FRANCE '98, WORLD CUP SOCCER - DEMO"
GPrint 0, 10, "1998 - PASCO"
GPrint 0, 20, "THIS VERSION RELEASED JULY 14TH 1998"

GPrint 0, 35, "ON MENU USE ARROW KEYS, AND CTRL TO ACCEPT"
GPrint 0, 50, "NEW IN THIS RELEASE:"
GPrint 0, 60, "TEAMS HAVE ALL PLAYER NAMES (ALTHOUGH UNSORTED...)"
GPrint 0, 70, "**MAJOR** -LOMEM COMMANDLINE SWITCH BUG FIXED"
GPrint 0, 80, "CHANGED REF COLOUR TO MATCH CUP FINAL"
GPrint 0, 90, "TRANSLUCENT SHADOWS!!!"


t! = TIMER
DO
	exi = 0
	kbmatrix(128) = 0
	FOR lp = 0 TO 127
		IF kbmatrix(lp) <> 0 THEN exi = 1
	NEXT
LOOP UNTIL exi = 1 OR TIMER - t! > 2

FOR lp = 0 TO 255
	OUT &H3C8, lp
	FOR l = 0 TO 2
		OUT &H3C9, 0
	NEXT
NEXT
fadetype = 1

OPEN "graphics\logo.col" FOR BINARY ACCESS READ AS #1
FOR lp = 0 TO 255
	FOR l2 = 0 TO 2
		pal(lp, l2) = ASC(INPUT$(1, 1))
	NEXT
NEXT
CLOSE #1

DEF SEG = &HA000
BLOAD "graphics\logo.bin", 0

Sound.DMAPlay "goalsht2.snd", 165

FOR Fade = 0 TO 63
	kbmatrix(128) = 0
	FOR lp = 0 TO 255
		OUT &H3C8, lp
		FOR l = 0 TO 2
			OUT &H3C9, pal(lp, l) * Fade \ 63
		NEXT
	NEXT
	SELECT CASE fadetype
		CASE 1: WAIT &H3DA, 8
		CASE 2: t! = TIMER: DO: LOOP UNTIL TIMER - t! <> 0: WAIT &H3DA, 8
	END SELECT
NEXT


t! = TIMER
DO
kbmatrix(128) = 0
LOOP UNTIL TIMER - t! > 2.5

GPrint 64, 118, "http://members.tripod.com/~Pasco_QB"

t! = TIMER
DO
	exi = 0
	kbmatrix(128) = 0
	FOR lp = 0 TO 127
		IF kbmatrix(lp) <> 0 THEN exi = 1
	NEXT
LOOP UNTIL exi = 1 OR TIMER - t! > 1

											
fadetype = 1
FOR Fade = 63 TO 0 STEP -1
	kbmatrix(128) = 0
	FOR lp = 0 TO 255
		OUT &H3C8, lp
		FOR l = 0 TO 2
			OUT &H3C9, pal(lp, l) * Fade \ 63
		NEXT
	NEXT
	SELECT CASE fadetype
		CASE 1: WAIT &H3DA, 8
		CASE 2: t! = TIMER: DO: LOOP UNTIL TIMER - t! <> 0
	END SELECT
NEXT




OPEN "graphics\title.col" FOR BINARY ACCESS READ AS #1
FOR lp = 0 TO 255
	FOR l2 = 0 TO 2
		pal(lp, l2) = ASC(INPUT$(1, 1))
	NEXT
NEXT
CLOSE #1

DEF SEG = &HA000
BLOAD "graphics\title.bin", 0

Sound.DMAPlay "goalsht1.snd", 110

fadetype = 2
FOR Fade = 0 TO 63
	kbmatrix(128) = 0
	FOR lp = 0 TO 255
		OUT &H3C8, lp
		FOR l = 0 TO 2
			OUT &H3C9, pal(lp, l) * Fade \ 63
		NEXT
	NEXT
	SELECT CASE fadetype
		CASE 1: WAIT &H3DA, 8
		CASE 2: t! = TIMER: DO: LOOP UNTIL TIMER - t! <> 0: WAIT &H3DA, 8
	END SELECT
NEXT


t! = TIMER
DO
	exi = 0
	kbmatrix(128) = 0
	FOR lp = 0 TO 127
		IF kbmatrix(lp) <> 0 THEN exi = 1
	NEXT
LOOP UNTIL exi = 1 OR TIMER - t! > 4



fadetype = 1
FOR Fade = 63 TO 0 STEP -1
	kbmatrix(128) = 0
	FOR lp = 0 TO 255
		OUT &H3C8, lp
		FOR l = 0 TO 2
			OUT &H3C9, pal(lp, l) * Fade \ 63
		NEXT
	NEXT
	SELECT CASE fadetype
		CASE 1: WAIT &H3DA, 8
		CASE 2: t! = TIMER: DO: LOOP UNTIL TIMER - t! <> 0
	END SELECT
NEXT
CLS
PALETTE
END SUB

SUB tvline (x1, y1, x2, y2, col)
DEF SEG = vscreenseg
IF x1 = x2 THEN GOTO tvvline
IF y1 = y2 THEN GOTO thvline
IF (x1 < 0 AND x2 < 0) OR (y1 < 0 AND y2 < 0) OR (x1 > 318 AND x2 > 318) OR (y1 > 166 AND y2 > 166) THEN EXIT SUB
IF x1 > x2 THEN SWAP x1, x2: SWAP y1, y2
gradient! = (y2 - y1) / (x2 - x1)

IF ABS(gradient!) <= 1 THEN
	intercept = -gradient! * x1 + y1
	IF x1 < 0 THEN x1 = 0
	IF x2 > 318 THEN x2 = 318
	FOR x = x1 TO x2
		y = gradient! * x + intercept
		IF y >= 0 AND y <= 166 THEN POKE x + y * 320 + vscreenloc, translucency(PEEK(x + y * 320 + vscreenloc))
	NEXT
EXIT SUB
END IF

IF y1 > y2 THEN SWAP x1, x2: SWAP y1, y2
gradient! = (x2 - x1) / (y2 - y1)
intercept = -gradient! * y1 + x1
IF y1 < 0 THEN y1 = 0
IF y2 > 166 THEN y2 = 167
FOR y = y1 TO y2
	x = gradient! * y + intercept
	IF x >= 0 AND x <= 318 THEN POKE x + y * 320 + vscreenloc, translucency(PEEK(x + y * 320 + vscreenloc))
NEXT
EXIT SUB

tvvline:
IF y1 > y2 THEN SWAP y1, y2
IF x1 < 0 OR x1 > 318 THEN EXIT SUB
IF y1 < 0 THEN y1 = 0
IF y2 > 166 THEN y2 = 167
xof = x1 + vscreenloc
FOR y = y1 TO y2
	POKE xof + y * 320, translucency(PEEK(xof + y * 320))
NEXT
EXIT SUB

thvline:
IF x1 > x2 THEN SWAP x1, x2
IF y1 < 0 OR y1 > 166 THEN EXIT SUB
IF x1 < 0 THEN x1 = 0
IF x2 > 318 THEN x2 = 318
yof = y1 * 320 + vscreenloc
FOR x = x1 TO x2
	POKE x + yof, translucency(PEEK(x + yof))
NEXT
EXIT SUB
END SUB

SUB vBOX (x1%, y1%, x2%, y2%, col%)
DEF SEG = vscreenseg%
IF x1% > x2% THEN SWAP x1%, x2%
IF y1% > y2% THEN SWAP y1%, y2%
IF x1% < xmin THEN x1% = xmin
IF x2% > xmax THEN x2% = xmax
IF y1% < ymin THEN y1% = ymin
IF y2% > ymax THEN y2% = ymax
FOR y% = y1% TO y2%
of% = y% * 320 + vscreenloc%
FOR x% = x1% TO x2%
POKE of% + x%, col%
NEXT: NEXT
END SUB

DEFSNG A-Z
SUB vcls
FOR y% = 0 TO 199
FOR x% = 0 TO 319
POKE y% * 320 + x% + vscreenloc%, Ln%
NEXT: NEXT

END SUB

DEFINT A-Z
SUB vline (x1, y1, x2, y2, col) STATIC
DEF SEG = vscreenseg
IF x1 = x2 THEN GOTO vvline
IF y1 = y2 THEN GOTO hvline
IF (x1 < 0 AND x2 < 0) OR (y1 < 0 AND y2 < 0) OR (x1 > 318 AND x2 > 318) OR (y1 > 166 AND y2 > 166) THEN EXIT SUB
IF x1 > x2 THEN SWAP x1, x2: SWAP y1, y2
gradient! = (y2 - y1) / (x2 - x1)

IF ABS(gradient!) <= 1 THEN
	intercept = -gradient! * x1 + y1
	IF x1 < 0 THEN x1 = 0
	IF x2 > 318 THEN x2 = 318
	FOR x = x1 TO x2
		y = gradient! * x + intercept
		IF y >= 0 AND y <= 166 THEN POKE x + y * 320 + vscreenloc, col
	NEXT
EXIT SUB
END IF

IF y1 > y2 THEN SWAP x1, x2: SWAP y1, y2
gradient! = (x2 - x1) / (y2 - y1)
intercept = -gradient! * y1 + x1
IF y1 < 0 THEN y1 = 0
IF y2 > 166 THEN y2 = 167
FOR y = y1 TO y2
	x = gradient! * y + intercept
	IF x >= 0 AND x <= 318 THEN POKE x + y * 320 + vscreenloc, col
NEXT
EXIT SUB

vvline:
IF y1 > y2 THEN SWAP y1, y2
IF x1 < 0 OR x1 > 318 THEN EXIT SUB
IF y1 < 0 THEN y1 = 0
IF y2 > 166 THEN y2 = 167
xof = x1 + vscreenloc
FOR y = y1 TO y2
	POKE xof + y * 320, col
NEXT
EXIT SUB

hvline:
IF x1 > x2 THEN SWAP x1, x2
IF y1 < 0 OR y1 > 166 THEN EXIT SUB
IF x1 < 0 THEN x1 = 0
IF x2 > 318 THEN x2 = 318
yof = y1 * 320 + vscreenloc
FOR x = x1 TO x2
	POKE x + yof, col
NEXT
EXIT SUB
END SUB

