' PRESS SHIFT+F5 TO PLAY!
' The Gates of Hell. This is a cool 3D game.
' By Tim Ward, Wolfgang Bruske, Thomas Gohel, Andrew L. Ayers.
' Wonder around, using the arrow keys, and press Space bar to
' shoot at on coming demons.
' Find the dark tunnel to exit.
' Be carefull, the demons jump at you and tair at your flesh if
' you dont shoot fast.
' Come to http://ntek.8m.com/qbasic/ for more cool QB stuff!
' Enjoy!
' Made, because inspired by now the second best 3D shooter, Birth of The Devil
'                                                             by FIG
'
' Declare subroutines
'
DECLARE SUB RayCaster (viewangle%)
DECLARE SUB InitAsm ()
DECLARE SUB TextMap ()
DECLARE SUB VLine (y1%, y2%, colour%)
DECLARE SUB LoadTextures (file$)
DECLARE SUB TableBuild ()
DECLARE SUB CreatePalette (Filename$)
DECLARE SUB LoadWorld (Filename$)
DECLARE SUB WriteScrn (row%, column%, colour%, Text$)
'
' Define Global Variables
'
health = 100
nuke% = 1
gun = 1
life = 5
DIM SHARED Angle0%, Angle6%, Angle30%, Angle90%, Angle180%, Angle270%, viewangle%
DIM SHARED Angle360%, WorldRow%, WorldColumn%, CellXsize%, CellYsize%, InvCellXsize!, InvCellYsize!
DIM SHARED x%, y%, MaXX%, MaXY%
DIM SHARED StartX%, StartY%, TextureNumber%, TextureColumn%
DIM SHARED Ray%, Scale%, UpperEnd%, LowerEnd%
DIM nuke1(2500)
DIM nuke1m(2500)
DIM nuke2(2500)
DIM nuke2m(2500)
DIM nuke3(10000)
DIM nuke3m(10000)
DIM nuker(2500)
DIM nukerm(2500)
DIM nuke5(1500)
DIM nuke5m(1500)
DIM nuke6(1500)
DIM nuke6m(1500)

ammo = 1000
'
' Define global arrays
'
REDIM SHARED World%(16, 16)
REDIM SHARED Texture%(28671)
REDIM SHARED TanTable!(1920)
REDIM SHARED InvTanTable!(1920)
REDIM SHARED YStep!(1920)
REDIM SHARED XStep!(1920)
REDIM SHARED CosTable!(1920)
REDIM SHARED InvCosTable!(1920)
REDIM SHARED InvSinTable!(1920)
REDIM SHARED Code%(56)
'
MinDistance% = 32
Angle0% = 0
Angle6% = 30
Angle30% = 160
Angle90% = 480
Angle180% = 960
Angle270% = 1440
Angle360% = 1920
WorldRow% = 16
WorldColumn% = 16
CellXsize% = 64
CellYsize% = 64
'
' Initialize maximum world boundries (1024 x 1024 units)
'
MaXX% = (WorldColumn% * CellXsize%)
MaXY% = (WorldRow% * CellYsize%)
'
InvCellXsize! = 1 / CellXsize%
InvCellYsize! = 1 / CellYsize%
'
' Start *---> MAIN <---* loop
'
SCREEN 13
'
DEF SEG = &HA000
virs2 = 10
CALL InitAsm
CALL CreatePalette("TEXTURE.PAL")
BLOAD "evil1.pic"
GET (0, 0)-(62, 98), nuke1
GET (62, 0)-(124, 98), nuke2
GET (160, 0)-(300, 178), nuke3




CLS
BLOAD "evil1m.pic"
GET (0, 0)-(62, 98), nuke1m
GET (62, 0)-(124, 98), nuke2m
GET (160, 0)-(300, 178), nuke3m
CLS
BLOAD "cls.pic"
GET (0, 0)-(62, 98), nuker
GET (0, 0)-(62, 98), nukerm
CLS
BLOAD "stuff.pic"
GET (0, 0)-(45, 60), nuke5
GET (45, 0)-(90, 60), nuke6
BLOAD "stuffm.pic"
GET (0, 0)-(45, 60), nuke5m
GET (45, 0)-(90, 60), nuke6m
CLS
CALL WriteScrn(1, 1, 160, "Level 1-Demon Infested Caves")
'
CALL LoadWorld("MAP.DAT")
CALL LoadTextures("lod.DAT")
CALL TableBuild
'
' Assign player view location (in world coordinates)
'
x% = (StartX% * 64) + 32: y% = (StartY% * 64) + 32: viewangle% = Angle90%
'
DO
1  DX! = 0: dY! = 0
  '
  ' Draw the world!
  '
  CALL RayCaster(viewangle%)
  '
  ' Get user input
  IF virst = 1 THEN
  
  FOR df = 1 TO 1000: NEXT df
  virst = 0: GOTO 1
  
  END IF
  
  DO: key$ = INKEY$:
  
  RANDOMIZE TIMER
  ifnuke = INT(RND * 350) + 1
  
  IF ifnuke = 5 THEN nuke% = 1
  IF nuke% = 1 THEN PUT (120, 50), nuke1m, AND: PUT (120, 50), nuke1, XOR: beavis = beavis + 1: IF beavis = 20 THEN beavis = 0: nuke% = 3: GOTO 1
  IF nuke% = 2 THEN PUT (120, 50), nuke2m, AND: PUT (120, 50), nuke2, XOR: FOR anus = 1 TO 10000: NEXT: nuke% = 0: kills = kills + 1: GOTO 1
  IF nuke% = 3 THEN PUT (70, 18), nuke3m, AND: PUT (70, 18), nuke3, XOR: FOR anus = 1 TO 100000: NEXT: health = health - 5: nuke% = 1: GOTO 1
  PUT (125, 120), nuke5m, AND: PUT (125, 120), nuke5, XOR: gyrus = 0
  
  LOCATE 2, 1: PRINT "Health"; health; "%  Ammo"; ammo
  IF x% > 159 AND y% > 159 AND x% < 161 AND y% < 289 THEN GOTO 50
  LOOP UNTIL key$ <> ""

  SELECT CASE key$
	CASE " "
	IF ammo = 0 THEN GOTO 1
	PUT (125, 120), nuke6m, AND
	PUT (125, 120), nuke6, XOR
	ammo = ammo - 1
	IF nuke% = 1 OR nuke% = 3 THEN nuke% = 2
	CASE CHR$(0) + "K"
	  '
	  ' Rotating left
	  '
	  viewangle% = viewangle% - Angle6%
	  IF viewangle% < Angle0% THEN viewangle% = Angle360% + viewangle%
	CASE CHR$(0) + "M"
	  '
	  ' Rotating right
	  '
	  viewangle% = viewangle% + Angle6%
	  IF viewangle% > Angle360% THEN viewangle% = viewangle% - Angle360%
	CASE CHR$(0) + "H"
	  '
	  ' Moving forward
	  '
	  DX! = COS(6.28 * viewangle% / Angle360%) * 15
	  dY! = SIN(6.28 * viewangle% / Angle360%) * 15
	CASE CHR$(0) + "P"
	  '
	  ' Moving backward
	  '
	  DX! = -(COS(6.28 * viewangle% / Angle360%) * 15)
	  dY! = -(SIN(6.28 * viewangle% / Angle360%) * 15)
	CASE CHR$(27)
	  '
	  ' Player has quit - exit
	  '
	  SCREEN 0: WIDTH 80: CLS : EXIT DO
  END SELECT
  '
  ' Move the player
  '
  x% = x% + DX!
  y% = y% + dY!
  '
  ' Do collision detection with walls
  '
  XCell% = INT(x% / CellXsize%)
  YCell% = INT(y% / CellYsize%)
  XSubCell% = x% AND CellXsize% - 1
  YSubCell% = y% AND CellYsize% - 1
  '
  IF DX! > 0 THEN
	IF World%(XCell% + 1, YCell%) <> 0 AND XSubCell% > (CellXsize% - MinDistance%) THEN
	  x% = x% - (XSubCell% - (CellXsize% - MinDistance%))
	END IF
  ELSE
	IF World%(XCell% - 1, YCell%) <> 0 AND XSubCell% < MinDistance% THEN
	  x% = x% + (MinDistance% - XSubCell%)
	END IF
  END IF
  '
  IF dY! > 0 THEN
	IF World%(XCell%, (YCell% + 1)) <> 0 AND YSubCell% > (CellYsize% - MinDistance%) THEN
	  y% = y% - (YSubCell% - (CellYsize% - MinDistance%))
	END IF
  ELSE
	IF World%(XCell%, (YCell% - 1)) <> 0 AND YSubCell% < MinDistance% THEN
	  y% = y% + (MinDistance% - YSubCell%)
	END IF
  END IF
  '

 LOOP
'
' Deallocate global arrays
'
REDIM SHARED World%(0, 0)
REDIM SHARED Texture%(0)
REDIM SHARED TanTable!(0)
REDIM SHARED InvTanTable!(0)
REDIM SHARED YStep!(0)
REDIM SHARED XStep!(0)
REDIM SHARED CosTable!(0)
REDIM SHARED InvCosTable!(0)
REDIM SHARED InvSinTable!(0)
REDIM SHARED Code%(0)
'
END
50 CLS : PRINT "You have passed the Demon Infested Caves"
PRINT "You must now venture deeper into the    underworld to the fearsome Orc Lairs"
PRINT

bonus = INT(RND * 4) + 1
IF bonus = 1 THEN bonus$ = "Full health!": health = 100
IF bonus = 2 THEN bonus$ = "100 more ammo!": ammo = ammo + 100
IF bonus = 3 THEN bonus$ = "1 Extra life!": life = life + 1
IF bonus = 4 THEN bonus$ = "Gun upgrade!": gun = gun + 1: IF gun > 3 THEN gun = 3
PRINT "BONUS "; bonus$
PRINT
PRINT "GUN "; : IF gun = 1 THEN PRINT "Shotgun" ELSE IF gun = 2 THEN PRINT "Devestator" ELSE IF gun = 3 THEN PRINT "Omega Shockwave"
PRINT "FINAL HEALTH"; health
PRINT "LIVES"; life
PRINT "FINAL AMMO"; ammo
PRINT "KILLS"; kills
points = points + health + ammo + kills + bonus
PRINT "TOTAL POINTS"; points
DO: LOOP WHILE INKEY$ = ""
SCREEN 2: SCREEN 0:
PRINT "Only one level so far on this one."
PRINT "Sorry- I might have made level 2,3,4 or even 5."
PRINT "You dont know cause you only got version 1.4 beta"
PRINT "Come to http://ntek.8m.com/qbasic/ and click on Gates of Hell."
PRINT "It will show you the latest version for download."
PRINT "If you like this game, or wish to work with me on it, write me"
PRINT "        qbasic@ntek.8m.com"

SUB CreatePalette (Filename$)
  '
  ' Load palette data
  '
  inputt$ = SPACE$(768)
  palmask% = &H3C6
  palreg% = &H3C8
  paldata% = &H3C9
  '
  OPEN Filename$ FOR BINARY AS #1
  '
  GET #1, , inputt$
  '
  CLOSE #1
  '
  FOR I% = 1 TO 768 STEP 3
	OUT palmask%, &HFF
	OUT palreg%, count%
	OUT paldata%, ASC(MID$(inputt$, I%, 1))
	OUT paldata%, ASC(MID$(inputt$, I% + 1, 1))
	OUT paldata%, ASC(MID$(inputt$, I% + 2, 1))
	count% = count% + 1
  NEXT
  '
END SUB

SUB InitAsm
  '
  ' Initialize Texture Mapping (TEXTMAP1.ASM) Assembler Routine
  '
  Code$ = "1E5589E58B760CB106D3E689F3B102D3E601DE8B5E0E01DE8B5E1801DE8B4612"
  Code$ = Code$ + "BB0010F7E389C38B7E10B106D3E701DF037E1483EF0731DB8B4E0C83F914"
  Code$ = Code$ + "7C1481F9B4007F0E8B46168ED88A158B461A8ED8881483C3403B5E087E0647"
  Code$ = Code$ + "2B5E08EBF581C64001413B4E0A7ECF5D1FCA1400"
  '
  DEF SEG = VARSEG(Code%(0))
  '
  FOR I% = 0 TO 112
	d% = VAL("&h" + MID$(Code$, I% * 2 + 1, 2))
	POKE VARPTR(Code%(0)) + I%, d%
  NEXT I%
  '
  DEF SEG
  '
END SUB

SUB LoadTextures (file$)
  '
  ' Load in texture maps
  '
  DEF SEG = VARSEG(Texture%(0))
  BLOAD file$, 0
  DEF SEG
  '
END SUB

SUB LoadWorld (Filename$)
  '
  ' Read in World Data Map
  '
  OPEN Filename$ FOR INPUT AS #1
  '
  FOR row% = 1 TO WorldRow%
	'
	LINE INPUT #1, Buffer$
	'
	FOR column% = 1 TO WorldColumn%
	  '
	  World%(column%, row%) = VAL(MID$(Buffer$, column%, 1))
	  '
	  IF MID$(Buffer$, column%, 1) = "A" THEN
	'
	' Set player starting location
	'
	StartX% = column%
	StartY% = row%
	  END IF
	  '
	NEXT
	'
  NEXT
  '
  CLOSE #1
  '
END SUB

SUB RayCaster (viewangle%)
  '
  ' Raycasting Routine - First define some local variables
  '
  DIM CellX%
  DIM CellY%
  DIM XonHorizontal AS SINGLE
  DIM YonVertical AS SINGLE
  DIM DistTOHorizontal AS SINGLE
  DIM DistTOVertical AS SINGLE
  '
  ' Define start sweep angle (View angle - 30 degrees)
  '
  VAngle% = viewangle% - Angle30%
  IF VAngle% < 0 THEN VAngle% = Angle360% + VAngle%
  '
  ' Find first horizontal grid lines
  '
  TempHorizontal% = INT(y% / CellYsize%) * CellYsize%
  TempHorizontal1% = INT(y% / CellYsize%) * CellYsize% + CellYsize%
  '
  ' Find first vertical grid lines
  '
  TempVertical% = INT(x% / CellXsize%) * CellXsize%
  TempVertical1% = INT(x% / CellXsize%) * CellXsize% + CellXsize%
  '
  ' Find distance to both horizontal grid lines
  '
  DiffTOHorizontal% = TempHorizontal% - y%
  DiffTOHorizontal1% = TempHorizontal1% - y%
  '
  ' Find distance to both vertical grid lines
  '
  DiffTOVertical% = TempVertical% - x%
  DiffTOVertical1% = TempVertical1% - x%
  '
  ' Cast out 320 rays (one for each vertical screen line)
  '
  FOR Ray% = 0 TO 319
	'
	' Find horizontal/vertical intercepts based on which quadrant of a unit
	' circle the ray is in...
	'
	IF VAngle% < Angle180% THEN
	  Horizontal% = TempHorizontal1%
	  XonHorizontal = InvTanTable!(VAngle%) * DiffTOHorizontal1% + x%
	  NextHorizontal% = CellYsize%
	  NextY% = 0
	ELSE
	  Horizontal% = TempHorizontal%
	  XonHorizontal = InvTanTable!(VAngle%) * DiffTOHorizontal% + x%
	  NextHorizontal% = -CellYsize%
	  NextY% = -1
	END IF
	'
	IF VAngle% < Angle90% OR VAngle% >= Angle270% THEN
	  Vertical% = TempVertical1%
	  YonVertical = TanTable!(VAngle%) * DiffTOVertical1% + y%
	  NextVertical% = CellXsize%
	  NextX% = 0
	ELSE
	  Vertical% = TempVertical%
	  YonVertical = TanTable!(VAngle%) * DiffTOVertical% + y%
	  NextVertical% = -CellXsize%
	  NextX% = -1
	END IF
	'
	' Step thru horizontal intercepts until a wall is hit, or ray escapes
	'
	DO
	  IF XonHorizontal > MaXX% OR XonHorizontal < 0 THEN
	DistTOHorizontal = 1000000!
	EXIT DO
	  END IF
	  CellX% = INT(XonHorizontal * InvCellXsize!)
	  CellY% = INT(Horizontal% * InvCellYsize!) + NextY%
	  IF World%(CellX%, CellY%) THEN
	DistTOHorizontal = (XonHorizontal - x%) * InvCosTable!(VAngle%)
	TextureNumberHorz% = World%(CellX%, CellY%)
	EXIT DO
	  END IF
	  XonHorizontal = XonHorizontal + XStep!(VAngle%)
	  Horizontal% = Horizontal% + NextHorizontal%
	LOOP
	'
	' Step thru vertical intercepts until a wall is hit, or ray escapes
	'
	DO
	  IF YonVertical > MaXY% OR YonVertical < 0 THEN
	DistTOVertical = 1000000!
	EXIT DO
	  END IF
	  CellX% = INT(Vertical% * InvCellXsize!) + NextX%
	  CellY% = INT(YonVertical * InvCellYsize!)
	  IF World%(CellX%, CellY%) THEN
	TextureNumberVert% = World%(CellX%, CellY%) + 6
	DistTOVertical = (YonVertical - y%) * InvSinTable!(VAngle%)
	EXIT DO
	  END IF
	  YonVertical = YonVertical + YStep!(VAngle%)
	  Vertical% = Vertical% + NextVertical%
	LOOP
	'
	' Draw using closest intercept only
	'
	IF DistTOHorizontal < DistTOVertical THEN
	  '
	  ' Find correct texture strip scale
	  '
	  TextureNumber% = TextureNumberHorz%
	  TextureColumn% = INT(XonHorizontal) MOD CellYsize%
	  Scale% = CosTable!(Ray%) / DistTOHorizontal
	  Scale% = Scale% - Scale% MOD 2
	  '
	  UpperEnd% = 100 - (Scale% \ 2)
	  LowerEnd% = UpperEnd% + Scale%
	  '
	  ' Draw ceiling strip
	  '
	  IF UpperEnd% > 20 THEN CALL VLine(20, UpperEnd%, 36)
	  '
	  ' Draw wall strip
	  '
	  CALL TextMap
	  '
	  ' Draw floor strip
	  '
	  IF LowerEnd% < 180 THEN CALL VLine(LowerEnd%, 180, 215)
	ELSE
	  '
	  ' Find correct texture strip scale
	  '
	  TextureNumber% = TextureNumberVert%
	  TextureColumn% = INT(YonVertical) MOD CellXsize%
	  Scale% = CosTable!(Ray%) / DistTOVertical
	  Scale% = Scale% - Scale% MOD 2
	  '
	  UpperEnd% = 100 - (Scale% \ 2)
	  LowerEnd% = UpperEnd% + Scale%
	  '
	  ' Draw ceiling strip
	  '
	  IF UpperEnd% > 20 THEN CALL VLine(20, UpperEnd%, 36)
	  '
	  ' Draw wall strip
	  '
	  CALL TextMap
	  '
	  ' Draw floor strip
	  '
	  IF LowerEnd% < 180 THEN CALL VLine(LowerEnd%, 180, 215)
	END IF
	'
	' Next angle for ray
	'
	VAngle% = VAngle% + 1
	'
	IF VAngle% >= Angle360% THEN VAngle% = 0
	'
  NEXT

LINE (0, 181)-(340, 340), 1, BF
IF virst <> 1 THEN GOTO 1201
1010 virs = 1
virs2 = virs2 - 1
virs1 = virs1 + 10: IF virs2 = 1 THEN virst = 0
CIRCLE (140, 180 - virs), virs2, 93
1201 END SUB

SUB TableBuild
  '
  ' Precalculate global trig tables for later use to speed up processing
  '
  CALL WriteScrn(12, 3, 161, "Please Wait - Building Trig Tables...")
  '
  DIM RadAngle AS DOUBLE
  '
  FOR I% = Angle0% TO Angle360%
	'
	RadAngle = .0003272 + I% * 3.27249234791667D-03
	'
	TanTable!(I%) = TAN(RadAngle)
	'
	InvTanTable!(I%) = 1 / TanTable!(I%)
	'
	IF I% >= Angle0% AND I% < Angle180% THEN
	  YStep!(I%) = ABS(TanTable!(I%) * CellYsize%)
	ELSE
	  YStep!(I%) = -ABS(TanTable!(I%) * CellYsize%)
	END IF
	'
	IF I% >= Angle90% AND I% < Angle270% THEN
	  XStep!(I%) = -ABS(InvTanTable!(I%) * CellXsize%)
	ELSE
	  XStep!(I%) = ABS(InvTanTable!(I%) * CellXsize%)
	END IF
	'
	InvCosTable!(I%) = 1 / COS(RadAngle)
	InvSinTable!(I%) = 1 / SIN(RadAngle)
	'
  NEXT
  '
  FOR I% = -Angle30% TO Angle30%
	RadAngle = .0003272 + I% * 3.27249234791667D-03
	CosTable!(I% + Angle30%) = 1 / COS(RadAngle) * 12000
  NEXT
  '
END SUB

SUB TextMap
  '
  ' Call assembly raycasting routine
  '
  DEF SEG = VARSEG(Code%(0))
  '
  CALL ABSOLUTE(BYVAL &HA000, BYVAL 0, BYVAL VARSEG(Texture%(0)), BYVAL VARPTR(Texture%(0)), BYVAL TextureNumber% - 1, BYVAL TextureColumn%, BYVAL Ray%, BYVAL UpperEnd%, BYVAL LowerEnd%, BYVAL Scale%, VARPTR(Code%(0)))
  '
  DEF SEG
  '
END SUB

SUB VLine (y1%, y2%, col%)
  '
  ' Draw a vertical line using endpoints, ray number, and color
  '
  LINE (Ray%, y1%)-(Ray%, y2%), col%
  '
END SUB

SUB WriteScrn (row%, column%, colour%, Text$)
  '
  ' Write a string using color specified on screen
  '
  COLOR colour%: LOCATE row%, column%: PRINT Text$;
  '
END SUB

