'===========================================================================
' Subject: GOLF SIMULATOR                     Date: 11-18-98 (18:10)       
'  Author: Dominik Kaspar                     Code: QB, QBasic, PDS        
'  Origin: pedok@pop.agri.ch                Packet: GAMES.ABC
'===========================================================================
'If the error "Directory not found" occurs, change it in line 53

DECLARE SUB SystemSpeedTest ()
DECLARE SUB Center2 (Row!, Text$)
DECLARE SUB Help ()
DECLARE SUB PlayGolf (Demo)
DECLARE SUB ReallyQuit ()
DECLARE SUB HighScoreFileCheck ()
DECLARE SUB HighScoreShow ()
DECLARE SUB HighScoreCheck ()
DECLARE SUB EndOfGame ()
DECLARE SUB WindCalc ()
DECLARE SUB Intro ()
DECLARE SUB MainScreen ()
DECLARE SUB Center (Row!, Text$, Cool!)
DECLARE SUB ShootPrompt ()
DECLARE SUB AskUser (Text$, Range!, Row!, Col!, Hide!)
DECLARE SUB DrawHills (Demo)
DECLARE SUB CoolPrint (XPos!, YPos!, Text$)
DECLARE SUB MeltScreen (Time!)

CONST Pi = 3.141592
CONST G = 9.81

TYPE HighScoreType
     PlayerName AS STRING * 21
     Score      AS INTEGER
END TYPE

DIM SHARED HighScore AS HighScoreType

DIM SHARED SystemSpeed
DIM SHARED PlayerYPos AS INTEGER
DIM SHARED FlagXPos, FlagYPos AS INTEGER
DIM SHARED Speed, Angle AS INTEGER
DIM SHARED TotalTries, PlayerRank AS INTEGER
DIM SHARED Wind
DIM SHARED Answer$
DIM SHARED InfoBarItem AS INTEGER

CLEAR , , 40000                  'delete this line if errors occur...

ON ERROR GOTO Errorhandler
ON TIMER(3) GOSUB InfoBar
ON KEY(1) GOSUB HelpMe

SystemSpeedTest

RANDOMIZE TIMER

SCREEN 7

CHDIR "."                  'change the directory if necessary

Intro
MainScreen

HelpMe:
    Help
RETURN

InfoBar:
    SELECT CASE InfoBarItem
     CASE 0: txt$ = "The worst golf simulator ever."
     CASE 1: txt$ = "Entirely programmed in QBasic."
     CASE 2: txt$ = "No sound effects and still fun."
     CASE 3: txt$ = "Press '2' for some help."
     CASE 4: txt$ = "Press '4' for a demonstration."
     CASE 5: txt$ = "Press '1' to play the game."
     CASE 6: txt$ = "Please write comments to:"
     CASE 7: txt$ = "pedok@pop.agri.ch"
     CASE 8: txt$ = "* * * * * * *"
     CASE 9: txt$ = "Welcome to QBasic GOLF"
    END SELECT
    InfoBarItem = InfoBarItem + 1
    IF InfoBarItem = 10 THEN InfoBarItem = 0
    Center 24, SPACE$(36), 0
    Center 24, txt$, 1
RETURN

Errorhandler:
COLOR 14
SELECT CASE ERR
  CASE 76
    Center 10, "ͻ", 0
    Center 11, " Error!               ", 0
    Center 12, " Directory not found. ", 0
    Center 13, "ͼ", 0
    DO: LOOP UNTIL LEN(INKEY$)
    SYSTEM
  CASE ELSE
    Center 10, "ͻ", 0
    Center 11, " An error has occurred! ", 0
    Center 12, " Number:" + STR$(ERR) + SPACE$(16 - LEN(STR$(ERR))) + "", 0
    Center 13, "ͼ", 0
    DO: LOOP UNTIL LEN(INKEY$)
    RUN
END SELECT

SUB AskUser (Text$, Range, Row, Col, Hide)

 LOCATE Row, Col
 PRINT Text$;
 Answer$ = ""
 DO
   DO
     a$ = INKEY$
   LOOP WHILE a$ = ""
   IF ASC(a$) = 8 THEN
      IF LEN(Answer$) > 0 THEN Answer$ = LEFT$(Answer$, LEN(Answer$) - 1): GOTO 1
   END IF
   SELECT CASE ASC(a$)
          CASE 13: EXIT DO
          CASE 32 TO 255: IF LEN(Answer$) = Range THEN GOTO 1
          Answer$ = Answer$ + a$
   END SELECT
1 : LOCATE Row, Col + LEN(Text$) + 1
    IF Hide = 0 THEN PRINT Answer$;  ELSE PRINT STRING$(LEN(Answer$), 42);
    PRINT SPACE$(Range - (LEN(Answer$)))
    a$ = ""
 LOOP

END SUB

SUB Center (Row, Text$, Cool)
 Column = (40 - LEN(Text$)) \ 2
 LOCATE Row, Column
 IF Cool THEN
    CoolPrint Row, Column, Text$
 ELSE
    PRINT Text$;
 END IF
END SUB

SUB Center2 (Row, Text$)
 Column = (80 - LEN(Text$)) \ 2
 LOCATE Row, Column
 PRINT Text$;
END SUB

SUB CoolPrint (XPos, YPos, Text$)
    LOCATE XPos, YPos
    PRINT Text$;
    FOR i = 0 TO 7
        FOR j = 0 TO 8 * LEN(Text$) - 1
         IF POINT(YPos * 8 - 8 + j, XPos * 8 - 8 + i) = 15 THEN
            PSET (YPos * 8 - 8 + j, XPos * 8 - 8 + i), INT(RND * 2) + 12
         END IF
        NEXT j
    NEXT i
END SUB

SUB DrawHills (Demo)

 IF Demo THEN RANDOMIZE 1

 CLS

'Following lines draw green hills onto the screen:
 OldPos = INT(RND * 50) + 120
 LINE (0, OldPos)-(15, OldPos), 2
 FOR x = 20 TO 320 STEP 5
     IF OldPos >= 170 THEN
        NewPos = OldPos - INT(RND * 5)
     ELSEIF OldPos <= 50 THEN
        NewPos = OldPos + INT(RND * 5)
     ELSE
        NewPos = OldPos + INT(RND * 10) - 5
     END IF
     LINE (x - 5, OldPos)-(x, NewPos), 2
     OldPos = NewPos
 NEXT x
 
 LINE (0, 0)-(319, 199), 2, B
 PAINT (1, 198), 2

'Place the golf player:
 FOR i = 40 TO 199
     IF POINT(3, i + 1) = 2 THEN
        PlayerYPos = i
        EXIT FOR
     END IF
 NEXT i
 PSET (3, PlayerYPos), 15
 DRAW "c5uefduh c4uhger3 c7f2dfhuh2 c4l2u2 c6uldr2"

'Place a flag:
 x = INT(RND * 180) + 100
 FOR i = 40 TO 199
     IF POINT(x, i) = 2 THEN
        FlagXPos = x
        FlagYPos = i
        EXIT FOR
     END IF
 NEXT i
 PSET (FlagXPos, FlagYPos), 0
 DRAW "c15u5c4u3gdlug"

'Status Bar:
 LINE (1, 176)-(318, 198), 0, BF
 LINE (1, 176)-(318, 198), 7, B
 LINE (2, 177)-(317, 197), 15, B
 LINE (3, 178)-(316, 196), 7, B

 WindCalc          'SUB to calculate wind intensity

 PCOPY 0, 2        'Save this landscape

END SUB

SUB Help
PCOPY 0, 4
 CLS

 CoolPrint 1, 1, "ͻ"
 CoolPrint 2, 1, " GOLF - HELP "
 CoolPrint 3, 1, "ͼ"
 CoolPrint 6, 1, "The goal in this fabulous golf simulator"
 CoolPrint 7, 1, "is to hit the randomly  positioned  flag"
 CoolPrint 8, 1, "by entering the right angle  and  enough"
 CoolPrint 9, 1, "force. You can adjust  these  parameters"
 CoolPrint 10, 1, "with the arrow keys  on  your  keyboard."
 CoolPrint 11, 1, "(To make your calculations  more  diffi-"
 CoolPrint 12, 1, " cult, there is always  some  wind  with"
 CoolPrint 13, 1, " quite some influence...)"
 CoolPrint 15, 1, "When you hit the flag, a  new  landscape"
 CoolPrint 16, 1, "will be generated, and after ten  times,"
 CoolPrint 17, 1, "the game is over."
 CoolPrint 18, 1, "If you did a good job, you will have the"
 CoolPrint 19, 1, "opportunity to enter your name into  the"
 CoolPrint 20, 1, "HighScore."
 CoolPrint 24, 1, "Have fun playing GOLF!"

 DO: LOOP UNTIL LEN(INKEY$)
PCOPY 4, 0
END SUB

SUB HighScoreCheck

OPEN "GOLF.DAT" FOR RANDOM AS #1 LEN = LEN(HighScore)

HighScoreFileCheck

GET #1, 10, HighScore
IF TotalTries <= HighScore.Score THEN
   PCOPY 0, 2
   Center 8, "ͻ", 1
   Center 9, " The game is over!           ", 1
   Center 10, " You've reached a place in   ", 1
   Center 11, " the HighScore, please enter ", 1
   Center 12, " your name or initials:      ", 1
   Center 13, "" + SPACE$(29) + "", 1
   Center 14, "" + SPACE$(29) + "", 1
   Center 15, "ͼ", 1

   Answer$ = ""
   COLOR 9
   AskUser "Name:", 21, 14, 6, 0
   COLOR 15

   FOR Rec = 1 TO 10
       GET #1, Rec, HighScore
       IF TotalTries <= HighScore.Score THEN
          FOR i = 9 TO Rec STEP -1
              GET #1, i, HighScore
              PUT #1, i + 1, HighScore
          NEXT i
          HighScore.PlayerName = Answer$
          HighScore.Score = TotalTries
          PlayerRank = Rec
          PUT #1, Rec, HighScore
          EXIT FOR
       END IF
   NEXT Rec
   CLOSE #1

   HighScoreShow
   PlayerRank = 0

   PCOPY 2, 0
END IF

END SUB

SUB HighScoreFileCheck

IF LOF(1) = 0 THEN
   FOR Rec = 1 TO 10
       SELECT CASE (Rec - 1)
           CASE 1: n$ = "           "
           CASE 2: n$ = "             "
           CASE 3: n$ = "               "
           CASE 4: n$ = "           "
           CASE 5: n$ = "           "
           CASE 6: n$ = "            "
           CASE 7: n$ = "      "
           CASE 9: n$ = STRING$(21, 219)
           CASE ELSE: n$ = ""
       END SELECT
       HighScore.PlayerName = n$
       HighScore.Score = Rec * 1000 + INT(RND * 1000)
       PUT #1, Rec, HighScore
   NEXT Rec
END IF

END SUB

SUB HighScoreShow

CLS
Center 1, "Ŀ", 1
Center 2, " HIGHSCORE ", 1
Center 3, "", 1

LOCATE 6: COLOR 9
PRINT "Ŀ"
PRINT " Rank  Name                   Tries "
PRINT "Ĵ"

OPEN "GOLF.DAT" FOR RANDOM AS #1 LEN = LEN(HighScore)

HighScoreFileCheck

FOR Rec = 1 TO 10
    GET #1, Rec, HighScore
    LOCATE Rec + 9, 1
      Rank$ = LTRIM$(RTRIM$(STR$(Rec))) + "."
      Rank$ = "" + SPACE$(5 - LEN(Rank$)) + Rank$ + " "
      PRINT Rank$;
    LOCATE Rec + 9, 10
      IF Rec = PlayerRank THEN COLOR 14
      PRINT HighScore.PlayerName;
      COLOR 9
      PRINT " ";
    LOCATE Rec + 9, 34
      Score$ = LTRIM$(STR$(HighScore.Score))
      Score$ = SPACE$(5 - LEN(Score$)) + Score$ + " "
      PRINT Score$;
NEXT Rec
PRINT ""
COLOR 15

CLOSE #1

DO: LOOP UNTIL LEN(INKEY$)

END SUB

SUB Intro

 CLS

 t = TIMER

 Golf$ = "c4l40d60r40u20r10u10l30d10r10d10l20u40r30u10 bg2p1,4be2" + "br20bd30"
 Golf$ = Golf$ + "c4d30r30u30l30 bd10br10 d10r10u10l10 bu2p1,4bd2" + "br30"
 Golf$ = Golf$ + "c4d20r20u10l10u50l10d40 br2p1,4bl2" + "br20"
 Golf$ = Golf$ + "c4r10d20r10u20r10u10l10u20r10u10l20d30l10d10 be2p1,4bg2"

 LINE (0, 0)-(319, 199), 2, BF
 PSET (90, 40)
 DRAW "s8" + Golf$

 Speed = 45
 Angle = 0

 Vx = Speed * COS(Angle * Pi / 180)
 Vy = Speed * SIN(Angle * Pi / 180)

 Sx = 0
 Sy = 0

 Intv = .002 * SystemSpeed
 f = 2
 DO
   Vy = Vy - Intv * G
   Sx = Sx + Intv * Vx
   Sy = Sy - Intv * Vy
 
  'Hit 'walls':
   IF Sy <= 0 OR Sy >= 199 THEN Vy = -Vy
   IF Sx >= 319 OR Sx <= 0 THEN Vx = -Vx
   
   IF POINT(Sx, Sy) = 2 THEN PSET (Sx, Sy), 15
 LOOP UNTIL TIMER > t + 60 OR LEN(INKEY$)
 
END SUB

SUB MainScreen

KEY(1) ON

DO
 CLS

 COLOR 9
 FOR i = 1 TO 23 STEP 22
     LOCATE i + 0, 1: PRINT "" + STRING$(38, "") + "";
     LOCATE i + 1, 1: PRINT "" + STRING$(38, " ") + "";
     LOCATE i + 2, 1: PRINT "" + STRING$(38, "") + "";
 NEXT i
 COLOR 15
 Center 2, "GOLF - by Dominik Kaspar (1998)", 1
 Center 24, "Welcome to QBasic GOLF", 1

 Center 9, " ͻ", 1
 Center 10, "  [1] Play the game  ", 1
 Center 11, "  [2] Description    ", 1
 Center 12, "  [3] View HighScore ", 1
 Center 13, "  [4] Demo           ", 1
 Center 14, "  [5] Exit Game      ", 1
 Center 15, " ͼ", 1

WaitForKey:
 Key$ = ""
 TIMER ON: KEY(1) OFF
 DO: Key$ = INKEY$: LOOP UNTIL LEN(Key$)
 TIMER OFF: KEY(1) ON
 SELECT CASE Key$
    CASE "1": PlayGolf 0
    CASE "2": Help
    CASE "3": HighScoreShow
    CASE "4": PlayGolf 1
    CASE "5": ReallyQuit
              GOTO WaitForKey
    CASE CHR$(13): PlayGolf 0
    CASE CHR$(27): ReallyQuit
                   GOTO WaitForKey
    CASE ELSE: GOTO WaitForKey
 END SELECT
LOOP

END SUB

SUB MeltScreen (Time)
  DIM Melt%(3000)
  tm = TIMER
  FOR RR = 1 TO 3000
    IF TIMER >= tm + Time THEN EXIT FOR
    xx = INT(RND * 271)
    yx = INT(RND * 150)
    GET (xx, yx)-(xx + 48, yx + 48), Melt%
    PUT (xx, yx + 1), Melt%, PSET
    IF INKEY$ = CHR$(27) THEN EXIT FOR
  NEXT RR
END SUB

SUB PlayGolf (Demo)

NewGame:
   Course = 0
   Tries = 0: TotalTries = 0

NewCourse:
   Course = Course + 1
   Tries = 0

DrawHills Demo

NewTry:
   Tries = Tries + 1
   TotalTries = TotalTries + 1

   LOCATE 24, 15: PRINT "Try:"; STR$(Tries);
   LOCATE 24, 27: PRINT "Course:"; STR$(Course); "/10";
 
   IF Demo THEN
      Speed = INT(RND * 30) + 40
      Angle = INT(RND * 50) + 40
   ELSE
      ShootPrompt
   END IF

Vx = Speed * COS(Angle * Pi / 180)
Vy = Speed * SIN(Angle * Pi / 180)

Sx = 10
Sy = PlayerYPos

Intv = .0002 * SystemSpeed
f = 2
DO
   'Main ball-flying calculations:
          
    Vx = Vx + Wind
    Vy = Vy - Intv * G
    Sx = Sx + Intv * Vx
    Sy = Sy - Intv * Vy

   'Hit flag!
    IF Sx <= FlagXPos AND Sx > (FlagXPos - 3) THEN
       IF Sy <= FlagYPos AND Sy > (FlagYPos - 8) THEN
          Center 11, "ͻ", 1
          Center 12, " You've put it in! ", 1
          Center 13, "ͼ", 1
          DO: LOOP UNTIL LEN(INKEY$)
        IF Demo THEN MainScreen
          Tries = 0
          IF Course = 10 THEN EXIT DO
          GOTO NewCourse
       END IF
    END IF

   'Hit ground:
    IF POINT(Sx, Sy) = 2 THEN
       Center 11, "ͻ", 1
       Center 12, " YOU MISSED! ", 1
       Center 13, "ͼ", 1
       DO: LOOP UNTIL LEN(INKEY$)
     IF Demo THEN MainScreen
       PCOPY 2, 0
       GOTO NewTry
    END IF

   'Hit 'walls':
    IF Sy <= 1 THEN Vy = -Vy
    IF Sx >= 318 OR Sx <= 1 THEN Vx = -Vx
   
    PSET (Sx, Sy), 15
LOOP

HighScoreCheck

Center 10, "ͻ", 1
Center 11, " THE GAME IS OVER! ", 1
Center 12, " Play again? (Y/N) ", 1
Center 13, "ͼ", 1

DO
 Key$ = ""
 DO: Key$ = INKEY$: LOOP UNTIL LEN(Key$)
 SELECT CASE UCASE$(Key$)
       CASE "Y": GOTO NewGame
       CASE "N": MeltScreen 5
                 MainScreen
 END SELECT
LOOP

END SUB

SUB ReallyQuit

 PCOPY 0, 3

 COLOR 14
 Center 10, "ͻ", 0
 Center 11, " Do you really want to ", 0
 Center 12, " quit the game?  (Y/N) ", 0
 Center 13, "ͼ", 0
 COLOR 15
 
DO
 Key$ = ""
 DO: Key$ = INKEY$: LOOP UNTIL LEN(Key$)
 SELECT CASE UCASE$(Key$)
        CASE "Y": EXIT DO
        CASE "N": PCOPY 3, 0
                  EXIT SUB
 END SELECT
LOOP

SCREEN 0
WIDTH 80, 25
COLOR 14, 1
CLS
Center2 2, "           "
Center2 3, "             "
Center2 4, "               "
Center2 5, "           "
Center2 6, "           "
Center2 7, "            "
Center2 8, "      "

Center2 10, "ͻ"
Center2 11, " Programmed by: Dominik Kaspar              "
Center2 12, "                Ahornweg 15                 "
Center2 13, "                5615 Fahrwangen             "
Center2 14, "                Switzerland                 "
Center2 15, "                                            "
Center2 16, "                [e-mail: pedok@pop.agri.ch] "
Center2 17, "ͼ"
Center2 19, "September 5. 1998"
Center2 22, "Unauthorized copying, hiring, lending, public performance or"
Center2 23, "broadcasting is strictly allowed. "
DO: LOOP UNTIL LEN(INKEY$)
SYSTEM

END SUB

SUB ShootPrompt
    PCOPY 0, 1

    CoolPrint 2, 2, "ͻ"
    CoolPrint 3, 2, " Enter FORCE "         'Draw Input Box
    CoolPrint 4, 2, " 0%    (/) "
    CoolPrint 5, 2, "ͼ"
    Speed = 0

    DO
    Key$ = ""
    DO: Key$ = INKEY$: LOOP UNTIL LEN(Key$)
    SELECT CASE Key$
     CASE CHR$(0) + "H":                         'Arrow Key {Up}
          IF Speed < 100 THEN Speed = Speed + 1
     CASE CHR$(0) + "P":                         'Arrow Key {Down}
          IF Speed > 0 THEN Speed = Speed - 1
     CASE CHR$(0) + "K":                         'Arrow Key {Left}
          Speed = 0
     CASE CHR$(0) + "M":                         'Arrow Key {Right}
          Speed = 100
     CASE CHR$(48) TO CHR$(57):                  'Numeric keys {1 to 9)
          Speed = VAL(Key$) * 10
     CASE CHR$(13): EXIT DO
     CASE CHR$(27): ReallyQuit
    END SELECT
    CoolPrint 4, 3, RTRIM$(STR$(Speed)) + "%" + SPACE$(2)
    LOOP

    CoolPrint 3, 2, " Enter ANGLE "
    CoolPrint 4, 2, " 0    (/) "
    Angle = 0

    DO
    Key$ = ""
    DO: Key$ = INKEY$: LOOP UNTIL LEN(Key$)
    SELECT CASE Key$
     CASE CHR$(0) + "H":
          IF Angle < 360 THEN Angle = Angle + 1
     CASE CHR$(0) + "P":
          IF Angle > 0 THEN Angle = Angle - 1
     CASE CHR$(0) + "K": Angle = 0
     CASE CHR$(0) + "M": Angle = 90
     CASE CHR$(48) TO CHR$(57): Angle = VAL(Key$) * 10
     CASE CHR$(13): EXIT DO
     CASE CHR$(27): ReallyQuit
    END SELECT
    CoolPrint 4, 3, RTRIM$(STR$(Angle)) + CHR$(248) + SPACE$(2)
    LOOP

    PCOPY 1, 0
END SUB

SUB SystemSpeedTest

 CLS

 COLOR 7, 0
 LOCATE 1, 1
 PRINT "Checking System Speed..."

 t = TIMER
 FOR i = 1 TO 10000
     LOCATE 1, 25
     PRINT "[" + LTRIM$(RTRIM$(STR$(INT(i / 100)))) + "%]"
 NEXT i
 Dif = t - TIMER

 SystemSpeed = ABS(Dif / 1.4)

END SUB

SUB WindCalc

 WindMax = .001 * SystemSpeed
 Wind = (RND * WindMax * 2) - WindMax
 LOCATE 24, 2: PRINT "Wind:"; 'STR$(Wind);

 LINE (60, 186)-(60 + ABS(Wind) * 30 / WindMax, 188), 9, BF

 IF Wind >= 0 THEN
    PSET (60 + Wind * 30 / WindMax, 188), 9
    DRAW "c9rd2lru6lrfd4eu2f"
 ELSE
    PSET (60, 186), 9
    DRAW "c9lu2rld6rlhu4gd2h"
 END IF

END SUB
