DECLARE SUB BuyOrSellLand (acres!, Bushels!)
DECLARE SUB FeedPeople (Bushels!, population!, Feed!)
DECLARE SUB Harvest (Bushels!, Plant!, Harvested!)
DECLARE SUB HowManyStarve (starved!, population!, Feed!, totalstarved!, Years!)
DECLARE SUB initialize (Plague$, Years!, starved!, Came!, population!, acres!, Harvested!, RatsAte!, Bushels!, Plant!)
DECLARE SUB intro ()
DECLARE SUB NewPeople (acres!, Bushels!, population!, Came!)
DECLARE SUB PlantLand (Bushels!, population!, acres!, Plant!)
DECLARE SUB Rats (Bushels!, RatsAte!)
DECLARE SUB Report (Plague$, Years!, starved!, Came!, population!, acres!, Harvested!, RatsAte!, Bushels!, Plant!)
DECLARE SUB RNDPlague (Plague$)
DECLARE SUB ErrorTrapPlanting (Plant!, acres!, population!, Bushels!)
DECLARE SUB Feederrortrap (Feed!, Bushels!, population!)
DECLARE SUB BuyLandErrorTrap (acres!, Bushels!, buySell!, Landcost!)
DECLARE SUB selllanderrortrap (acres!, Bushels!, buySell!, Landcost!)
DECLARE SUB EndReport (totalstarved!, acres!, population!)
RANDOMIZE (TIMER)
SCREEN 12

'***************************
'*      Kevin Kohler       *
'*         Ham             *
'*        3/6/97           *
'* last edited on 3/14/98  *
'***************************

intro
initialize Plague$, Years, starved, Came, population, acres, Harvested, RatsAte, Bushels, Plant

DO
  CLS
  Report Plague$, Years, starved, Came, population, acres, Harvested, RatsAte, Bushels, Plant
  BuyOrSellLand acres, Bushels
  FeedPeople Bushels, population, Feed
  HowManyStarve starved, population, Feed, totalstarved, Years
  PlantLand Bushels, population, acres, Plant
  Rats Bushels, RatsAte
  Harvest Bushels, Plant, Harvested
  NewPeople acres, Bushels, population, Came
  RNDPlague Plague$
  Years = Years + 1
LOOP UNTIL Years >= 10
EndReport totalstarved, acres, population
END

SUB BuyLandErrorTrap (acres, Bushels, buySell, Landcost)
  DO WHILE buySell < 0 OR (buySell * Landcost) > Bushels
    LOCATE 10, 1
    IF buySell < 0 THEN
      PRINT "Please enter a positive value";
    ELSE
      PRINT "You don't have that many bushels, please enter a different value";
    END IF
    INPUT buySell
  LOOP
END SUB

SUB BuyOrSellLand (acres, Bushels)
  Landcost = INT(10 * RND) + 17
  PRINT "Land is being traded at"; Landcost; "per acre"
  INPUT "How many acres do you want to buy", buySell

  BuyLandErrorTrap acres, Bushels, buySell, Landcost
  
  IF buySell <= 0 THEN
    INPUT "How many acres do you want to sell", buySell
    selllanderrortrap acres, Bushels, buySell, Landcost
    buySell = -buySell
  END IF
  acres = acres + buySell
  Bushels = Bushels - (buySell * Landcost)

  IF buySell <> 0 THEN
    LINE (0, 377)-(640, 480), 0, BF
    Space2 = 0
    space = 377
    FOR TIMES = 1 TO acres
      LINE (Space2, space)-(Space2 + 4, space + 4), 10, BF
      Space2 = Space2 + 6
      IF TIMES / 100 = INT(TIMES / 100) THEN
        space = space + 6
        Space2 = 0
      END IF
    NEXT TIMES
    LINE (0, 280)-(640, 330), 0, BF
    space = 280
    Space2 = 0
    FOR TIMES = 1 TO INT(Bushels / 10)
      LINE (Space2, space + 3)-(Space2 + 2, space), 14, BF
      LINE (Space2 + 1, space + 1)-(Space2 + 1, space + 5), 6
      Space2 = Space2 + 4
      IF TIMES / 159 = INT(TIMES / 159) THEN
        space = space + 7
        Space2 = 0
      END IF
    NEXT TIMES
  END IF

END SUB

SUB EndReport (totalstarved, acres, population)
  CLS
  PRINT "You ended the game with"; acres; "Acres of land"
  PRINT "Throughout your rule on average"; totalstarved; "starved"
  IF (acres / population) < 7.5 OR totalstarved > .35 THEN
    PRINT "As a leader you have faild misserably and you will"
    PRINT "be forever remembered as the one that made ancient"
    PRINT "Sumaria fall."
    ended$ = "y"
  END IF
  IF ((acres / population) > 10 OR totalstarved <= .0625) AND ended$ <> "y" THEN
    PRINT "You will be remembered for all time as the best leader"
    PRINT "ever to lead ancient Sumaria, exepting Hamarabi himslef!!!"
    ended$ = "y"
  END IF
  IF ((acres / population) > 10 AND totalstarved <= .1) AND ended$ <> "y" THEN
    PRINT "every one likes you, but your idiot brother will be remembered"
    PRINT "better, because he burnt down a small city state!!!!!!!!!!!!!!"
    ended$ = "y"
  END IF
  IF ((acres / population) > 10 OR totalstarved <= .15) AND ended$ <> "y" THEN
    PRINT "YOUR NAME WILL BE REMEMBERED, for a year or two!!!"
    ended$ = "y"
  END IF
  IF ((acres / population) > 9 OR totalstarved <= .25) AND ended$ <> "y" THEN
    PRINT "well... not many people wanted to kill you!!!"
    ended$ = "y"
  END IF
  IF ((acres / population) > 7.5 OR totalstarved <= .35) AND ended$ <> "y" THEN
    PRINT "Yep, no one likes you, but at least they don't give"
    PRINT "you the pine cone torcher"
    ended$ = "y"
  END IF

END SUB

SUB ErrorTrapPlanting (Plant, acres, population, Bushels)
  DO WHILE Plant < 0 OR Plant > (Bushels * 2) OR Plant > population * 10 OR Plant > acres
    LOCATE 15, 1
    IF Plant < 0 OR Plant > (Bushels * 2) THEN
      IF Plants < 0 THEN
        INPUT "Please input a posetive number"; Plant
      ELSE
        INPUT "you do not have bushels for all your land"; Plant
      END IF
    END IF
    IF Plant > population * 10 OR Plant > acres THEN
      IF Plant > population * 10 THEN
        INPUT "There are not people for all your fields"; Plant
      ELSE
        INPUT "You don't have that much land"; Plant
      END IF
    END IF
  LOOP
END SUB

SUB Feederrortrap (Feed, Bushels, population)
  DO WHILE Feed < 0 OR Feed > Bushels
    LOCATE 13, 1
    IF Feed < 0 THEN
      INPUT "You must feed your people a positive value of bushels"; Feed
    ELSE
      INPUT "I am sorry to report that you don't have that much food"; Feed
    END IF
  LOOP
END SUB

SUB FeedPeople (Bushels, population, Feed)
  INPUT "How many bushels of grain do you wish to feed your people"; Feed
  Feederrortrap Feed, Bushels, population
  Bushels = Bushels - Feed
  IF Feed <> 0 THEN
    LINE (0, 280)-(640, 330), 0, BF
    space = 280
    Space2 = 0
    FOR TIMES = 1 TO INT(Bushels / 10)
      LINE (Space2, space + 3)-(Space2 + 2, space), 14, BF
      LINE (Space2 + 1, space + 1)-(Space2 + 1, space + 5), 6
      Space2 = Space2 + 4
      IF TIMES / 159 = INT(TIMES / 159) THEN
        space = space + 7
        Space2 = 0
      END IF
    NEXT TIMES
  END IF
END SUB

SUB Harvest (Bushels, Plant, Harvested)
  Harvested = INT(RND * 5) + 1
END SUB

SUB HowManyStarve (starved, population, Feed, totalstarved, Years)
  starved = population - INT(Feed / 20)
  IF starved - population = 0 THEN
    CLS
    PRINT "You are kick out of office"
    PRINT "Every one died of starvation :  ("
    PRINT "Game Over"
    END
  ELSE
    IF (starved / population) >= .45 THEN
      CLS
      PRINT "You are kick out of office"
      PRINT (starved / population); "%  Starved"
      END
    END IF
  END IF
  IF totalstarved <> 0 AND starved <> 0 THEN
    totalstarved = (totalstarved * (Years - 1) + starved) / Years
  END IF
  IF starved < 0 THEN starved = 0
END SUB

SUB initialize (Plague$, Years, starved, Came, population, acres, Harvested, RatsAte, Bushels, Plant)
population = 95
Came = 5
RatsAte = 200
Years = 1
Staved = 0
acres = 1000
Harvested = 3
Bushels = 3000
Plant = 0
END SUB

SUB intro
  LINE (0, 299)-(649, 479), 6, BF
  LINE (0, 300)-(649, 0), 3, BF
  Opens$ = "Y"
  Legs = 0
  FOR T = 1 TO 320 STEP 3
    start = TIMER
    IF Opens$ = "y" THEN
      Legs = Legs + 3
    END IF
    IF Opens$ = "n" THEN
      Legs = Legs - 3
    END IF
    IF Legs >= 30 THEN
      Opens$ = "n"
    END IF
    IF Legs <= 0 THEN
      Opens$ = "y"
    END IF
    CIRCLE (T, 150), 50, 1
    CIRCLE (T + 20, 140), 10, 1
    LINE (T, 200)-(T + 50, 300), 1
    LINE -(T - 50, 300), 1
    LINE -(T, 200), 1
    LINE (T - 5, 225)-(T - 20, 275), 1
    LINE -(T + 20, 275), 1
    LINE -(T + 5, 225), 1
    LINE (T + 40, 175)-(T + 10, 170), 1
    LINE -(T, 165), 1
    LINE (T - Legs, 350)-(T, 300), 1
    LINE (T + Legs, 350)-(T, 300), 1
    IF T > 50 THEN
      CIRCLE (T - 100, (50000 / (T + 200)) - 70), 50, 14
    END IF
    DO
      finish = TIMER
    LOOP UNTIL finish - start > .1
      LINE (T - Legs, 350)-(T, 300), 6
      LINE (T + Legs, 350)-(T, 300), 6
      CIRCLE (T, 150), 50, 3
      CIRCLE (T + 20, 140), 10, 3
      LINE (T, 200)-(T + 50, 300), 3
      LINE -(T - 50, 300), 3
      LINE -(T, 200), 3
      LINE (T - 5, 225)-(T - 20, 275), 3
      LINE -(T + 20, 275), 3
      LINE -(T + 5, 225), 3
      LINE (T + 40, 175)-(T + 10, 170), 3
      LINE -(T, 165), 3
    IF T > 50 THEN
      CIRCLE (T - 100, (50000 / (T + 200)) - 70), 50, 3
    END IF
  NEXT T
  CIRCLE (T, 150), 50, 1
  CIRCLE (T + 20, 140), 10, 1
  CIRCLE (T - 20, 140), 10, 1
  LINE (T, 200)-(T + 50, 300), 1
  LINE -(T - 50, 300), 1
  LINE -(T, 200), 1
  LINE (T - 13, 225)-(T - 45, 275), 1
  LINE -(T - 65, 255), 1
  LINE -(T - 13, 225), 1
  LINE (T + 13, 225)-(T + 45, 275), 1
  LINE -(T + 65, 255), 1
  LINE -(T + 13, 225), 1
  LINE (T - 13, 225)-(T - 45, 275), 3
  LINE -(T - 65, 255), 3
  LINE -(T - 13, 225), 3
  LINE (T + 13, 225)-(T + 45, 275), 3
  LINE -(T + 65, 255), 3
  LINE -(T + 13, 225), 3
  LINE (T, 300)-(T, 350), 1
  CIRCLE (T - 100, (50000 / (T + 200)) - 70), 50, 14
  TIMES = 1
  DO
    start = TIMER
    TIMES = TIMES + 1
    IF TIMES / 2 = INT(TIMES / 2) THEN
      IF TIMES <= 60 THEN
        LINE (T - 20, 173)-(T + 20, 171), 1, BF
        LINE (T - 12, 175)-(T + 12, 169), 1, BF
      END IF
      LINE (T - 13, 225)-(T - 45, 275), 1
      LINE -(T - 65, 255), 1
      LINE -(T - 13, 225), 1
      LINE (T + 13, 225)-(T + 45, 275), 1
      LINE -(T + 65, 255), 1
      LINE -(T + 13, 225), 1
    ELSE
       IF TIMES <= 59 THEN
         LINE (T + 10, 183)-(T - 10, 163), 1, BF
       END IF
      LINE (T + 13, 225)-(T + 45, 175), 1
      LINE -(T + 65, 195), 1
      LINE -(T + 13, 225), 1
      LINE (T - 13, 225)-(T - 45, 175), 1
      LINE -(T - 65, 195), 1
      LINE -(T - 13, 225), 1
    END IF
    DO
      finish = TIMER
    LOOP UNTIL finish - start > .2
    IF TIMES = 10 THEN
      COLOR INT(RND * 14) + 1
      PRINT , , "    Welcome to"
      LINE (0, 0)-(220, 100), 3, BF
      CIRCLE (T - 100, (50000 / (T + 200)) - 70), 50, 14
    END IF
    IF TIMES = 20 THEN
      COLOR INT(RND * 14) + 1
      PRINT , , "     Hamarabi"
      LINE (0, 0)-(220, 100), 3, BF
      CIRCLE (T - 100, (50000 / (T + 200)) - 70), 50, 14
    END IF
    IF TIMES = 30 THEN
      COLOR INT(RND * 14) + 1
      PRINT , , "  where you get to"
      LINE (0, 0)-(220, 100), 3, BF
      CIRCLE (T - 100, (50000 / (T + 200)) - 70), 50, 14
    END IF
    IF TIMES = 40 THEN
      COLOR INT(RND * 14) + 1
      PRINT , , "govern anchent Sumaria"
      LINE (0, 0)-(220, 100), 3, BF
      CIRCLE (T - 100, (50000 / (T + 200)) - 70), 50, 14
    END IF
    IF TIMES = 50 THEN
      COLOR INT(RND * 14) + 1
      PRINT , , "for a ten year period"
      LINE (0, 0)-(220, 100), 3, BF
      CIRCLE (T - 100, (50000 / (T + 200)) - 70), 50, 14
    END IF
    IF TIMES = 60 THEN
      COLOR INT(RND * 14) + 1
      PRINT , , "Press any key to continue"
      LINE (0, 0)-(220, 100), 3, BF
      CIRCLE (T - 100, (50000 / (T + 200)) - 70), 50, 14
    END IF
    IF TIMES / 2 = INT(TIMES / 2) THEN
      IF TIMES <= 60 THEN
        LINE (T - 20, 173)-(T + 20, 171), 3, BF
        LINE (T - 12, 175)-(T + 12, 169), 3, BF
      END IF
      LINE (T - 13, 225)-(T - 45, 275), 3
      LINE -(T - 65, 255), 3
      LINE -(T - 13, 225), 3
      LINE (T + 13, 225)-(T + 45, 275), 3
      LINE -(T + 65, 255), 3
      LINE -(T + 13, 225), 3
    ELSE
      IF TIMES <= 59 THEN
        LINE (T + 10, 188)-(T - 10, 158), 3, BF
      END IF
      LINE (T + 13, 225)-(T + 45, 175), 3
      LINE -(T + 65, 195), 3
      LINE -(T + 13, 225), 3
      LINE (T - 13, 225)-(T - 45, 175), 3
      LINE -(T - 65, 195), 3
      LINE -(T - 13, 225), 3
    END IF
    IF TIMES = 60 THEN
      LINE (T + 20, 170)-(T + 10, 175), 1
      LINE -(T - 10, 175), 1
      LINE -(T - 20, 170), 1
    END IF
  LOOP UNTIL INKEY$ <> ""
  COLOR 15
END SUB

SUB NewPeople (acres, Bushels, population, Came)
  NumberForPopulation = INT(5 * RND) + 1
  Came = INT((((((20 * acres) + Bushels) * NumberForPopulation) / population) / 100) + 1)
END SUB

SUB PlantLand (Bushels, population, acres, Plant)
  INPUT "how many acres do you want to plant with grain"; Plant
  ErrorTrapPlanting Plant, acres, population, Bushels
END SUB

SUB Rats (Bushels, RatsAte)
  RatsAte = INT(RND * 5) + 1
  IF RatsAte = 2 OR RatsAte = 4 THEN
    RatsAte = INT(Bushels / RatsAte)
  ELSE
    RatsAte = 0
  END IF
END SUB

SUB Report (Plague$, Years, starved, Came, population, acres, Harvested, RatsAte, Bushels, Plant)
  population = (population - starved) + Came
  
  Bushels = (Bushels - RatsAte) + (Plant * Harvested)
 
  PRINT "Hamurabi, I beg to report to you"
  PRINT "in year"; Years; ","; starved; "starved, and"; Came; "came to the city."
  IF Plague$ = "y" THEN
    PRINT " of your population died of the plague"
    population = INT(population / 2)
  END IF
  PRINT "The population is now"; population; "."
  PRINT "The city now owns"; acres; "acres."
  PRINT "You harvested"; Harvested; "bushels of grain per acre."
  PRINT "Rats ate"; RatsAte; "bushles."
  PRINT "You now have"; Bushels; "Bushels."

  Space2 = 0
  space = 337
  FOR TIMES = 1 TO population
    CIRCLE (Space2 + 5, space), 5, 14
    CIRCLE (Space2 + 3, space - 1), 1, 3
    CIRCLE (Space2 + 7, space - 1), 1, 3
    Space2 = Space2 + 11
    IF TIMES / 50 = INT(TIMES / 50) THEN
      space = space + 11
      Space2 = 0
    END IF
  NEXT TIMES

  space = 377
  Space2 = 0
  FOR TIMES = 1 TO acres
    LINE (Space2, space)-(Space2 + 4, space + 4), 10, BF
    Space2 = Space2 + 6
    IF TIMES / 100 = INT(TIMES / 100) THEN
      space = space + 6
      Space2 = 0
    END IF
  NEXT TIMES

  space = 280
  Space2 = 0
  FOR TIMES = 1 TO INT(Bushels / 10)
    LINE (Space2, space + 3)-(Space2 + 2, space), 14, BF
    LINE (Space2 + 1, space + 1)-(Space2 + 1, space + 5), 6
    Space2 = Space2 + 4
    IF TIMES / 159 = INT(TIMES / 159) THEN
      space = space + 7
      Space2 = 0
    END IF
  NEXT TIMES
END SUB

SUB RNDPlague (Plague$)
  Plague$ = "n"
  IF INT(RND * 100) + 1 <= 15 THEN
    Plague$ = "y"
  END IF
END SUB

SUB selllanderrortrap (acres, Bushels, buySell, Landcost)
    DO WHILE buySell > acres OR buySell < 0
      LOCATE 11, 1
      IF buySell >= acres THEN
        PRINT "You don't have that much.... try again";
      ELSE
        PRINT "Please enter a posetive number";
      END IF
      INPUT buySell
    LOOP
END SUB

