' HYPER RACERS Z v1.10
' By Pantera55@aol.com

' To run this, use 'hrz.bat'

' This is version 1.10. I did a little clean up in a few areas, including
' the MIDI. Now it loops better, and goes a bit faster. And there is no
' glitch anymore where you will fight another opponent after you lose to
' Firefly. That's it, goodbye.



' HyperDimensionSoft - http://members.aol.com/PANTERA55/
' Email me - PANTERA55@aol.com
' MIDI soundtrack made by RainsMIDI, Inc ->http://www.internetpro.net/~arains

' Read "HRZ.TXT" for more info



' *** SUBS ***
DECLARE SUB melt ()
DECLARE SUB about ()
DECLARE SUB loadgif (a$)
DECLARE SUB stopmidi ()
DECLARE SUB LoadMIDI (Filename$, MIDISegment%, MIDIOffset%)
DECLARE SUB PlayMIDI (MIDISegment%, MIDIOffset%)
DECLARE FUNCTION TimeMIDI! ()
DECLARE SUB LoadandPlayMIDI (Filename$, MIDISegment%, MIDIOffset%)
DECLARE SUB GetIntVector (IntNum%, Segment%, Offset%)
DECLARE FUNCTION BytesRequired& (Filename$)
DECLARE SUB p1die ()
DECLARE SUB p2die ()
DECLARE SUB editspeed ()
DECLARE SUB dead ()
DECLARE SUB winner ()
DECLARE SUB openingscreen ()
DECLARE SUB instructions ()
DECLARE SUB options ()
DECLARE SUB quit ()
DECLARE SUB mainscreen ()
DECLARE SUB p1hit ()
DECLARE SUB p2hit ()
DECLARE SUB updatestatusbar ()
DECLARE SUB putstats ()
DECLARE SUB statusbar ()
DECLARE SUB background4 ()
DECLARE SUB background3 ()
DECLARE SUB background2 ()
DECLARE SUB brickborder ()
DECLARE SUB background1 ()
DECLARE SUB carselectscreen ()
DECLARE SUB setrgb (Nr!, r!, g!, B!)
DECLARE SUB backstart ()
DECLARE SUB backstop ()
DECLARE SUB frontstart ()
DECLARE SUB frontstop ()
DECLARE SUB hdslogo ()
DECLARE SUB coolblocks ()
DECLARE SUB text (x!, y!, word$, col!)
DECLARE SUB lshadow (nx!, ny!, type$, col1!, col2!)
' *** SUBS ***

' *** Variables ***
DIM SHARED p1auto(1 TO 300), p1autom(1 TO 300)
DIM SHARED p2auto(1 TO 300), p2autom(1 TO 300)

DIM SHARED currentspeed
DIM SHARED p1car, p2car
DIM SHARED p1heat, p2heat
DIM SHARED p1auto, p1autom, p2auto, p2autom
DIM SHARED cname$, lname$, no$
DIM SHARED p1x, p1y, p2x, p2y
DIM SHARED p1energy, p2energy
DIM SHARED p1c, p2c
DIM SHARED p1wins, p2wins, round, battle
' *** Variables ***

' *** MIDI Variables ***
DIM SHARED MIDI.PLAYTIME AS SINGLE
DIM SHARED MIDI.ERROR AS INTEGER
DIM SHARED MIDI.LOADED AS INTEGER
DIM SHARED PAUSED AS SINGLE
DIM SHARED SBMIDI.INTERRUPT AS INTEGER
DIM SHARED SBSIM.INTERRUPT AS INTEGER
MIDI.PLAYTIME = 0
MIDI.ERROR = 0
MIDI.LOADED = 0
SBMIDI.INTERRUPT = &H80
SBSIM.INTERRUPT = &H81
' *** MIDI Variables ***

RANDOMIZE TIMER

ON ERROR GOTO 1000

OPEN "setspeed.hds" FOR INPUT AS #1
INPUT #1, currentspeed
CLOSE #1

10

' *** HDS LOGO ***
stopmidi
REDIM MIDI%(BytesRequired&("agony.mid") \ 2)
LoadandPlayMIDI "agony.mid", VARSEG(MIDI%(0)), VARPTR(MIDI%(0))
hdslogo
' *** HDS LOGO ***

mainscreen

carselectscreen

' *** Each Individual Car's Stats ***
SELECT CASE p1car
 CASE IS = 1
  no$ = "1"
  p1speed = .4
  p1defense = 2
  p1power = 3
  p1c = 9
 CASE IS = 2
  no$ = "2"
  p1speed = .7
  p1defense = 2
  p1power = 1
  p1c = 4
 CASE IS = 3
  no$ = "3"
  p1speed = .55
  p1defense = 3
  p1power = 1
  p1c = 10
END SELECT

20

p2car = p1car + 1
IF p2car = 4 THEN p2car = 1

100 ' *** Game restarts from here (God, I love it) ***

IF p2car = 1 THEN
  cno$ = "1"
  p2speed = .4
  p2c = 9
  p2power = 3
  p2defense = 1
END IF

IF p2car = 2 THEN
  cno$ = "2"
  p2speed = .7
  p2c = 4
  p2power = 1
  p2defense = 2
END IF

IF p2car = 3 THEN
  cno$ = "3"
  p2speed = .55
  p2c = 10
  p2power = 1
  p2defense = 3
END IF

IF p2car = 10 THEN
  cno$ = "5"
  p2speed = .7
  p2c = 15
  p2power = 3
  p2defense = 3
END IF
' *** Each Individual Car's Stats ***


' *** INIT car movement ***
cardown$ = "car" + no$ + "1"
carup$ = "car" + no$ + "4"
carleft$ = "car" + no$ + "3"
carright$ = "car" + no$ + "2"
pcardown$ = "car" + cno$ + "1"
pcarup$ = "car" + cno$ + "4"
pcarleft$ = "car" + cno$ + "3"
pcarright$ = "car" + cno$ + "2"
' *** INIT car movement ***

' *** Game ***

' *** Pre-game set variables ***
p1energy = 100
p2energy = 100
p1heat = 0
p2heat = 0
p1x = 50
p1y = 50
p1dir = 2
p2x = 270
p2y = 80
p2dir = 3
' *** Pre-game set variables ***

openingscreen

DO

IF backon = 0 THEN
 backstart

SELECT CASE p2car

 CASE IS = 1
  background1
  songname$ = "gameso~1.mid"
  songplaytime = 114
 CASE IS = 2
  background2
  songname$ = "gameso~2.mid"
  songplaytime = 106
 CASE IS = 3
  background3
  songname$ = "gameso~3.mid"
  songplaytime = 90
 CASE IS = 10
  background4
  songname$ = "gameso~4.mid"
  songplaytime = 63

END SELECT

 REDIM MIDI%(BytesRequired&(songname$) \ 2)
 LoadandPlayMIDI songname$, VARSEG(MIDI%(0)), VARPTR(MIDI%(0))
 putstats
 backon = 1
 backstop

END IF

' *** Music LOOP check ***
IF INT(TimeMIDI!) >= songplaytime THEN
        PlayMIDI VARSEG(MIDI%(0)), VARPTR(MIDI%(0))
END IF
' *** Music LOOP check ***


' *** Key check ***
a$ = INKEY$
'  ** DARK secret **
IF a$ = CHR$(0) + CHR$(134) THEN
   backstart
   LINE (10, 10)-(309, 159), 0, BF
   backstop
END IF
'  ** DARK secret **

' *** Key check ***
IF a$ = CHR$(0) + "P" THEN p1s = p1s + p1speed: p1dir = 1
IF a$ = CHR$(0) + "H" THEN p1s = p1s + p1speed: p1dir = 4
IF a$ = CHR$(0) + "M" THEN p1s = p1s + p1speed: p1dir = 2
IF a$ = CHR$(0) + "K" THEN p1s = p1s + p1speed: p1dir = 3
IF a$ = CHR$(32) THEN IF p1heat <= 90 THEN fire = 1
IF a$ = CHR$(27) THEN END
' *** Key check ***

' *** Movement, boundaries, restrictions ***
IF p1y < 8 THEN p1y = p1y + 5: p1s = p1s * .3 * -1
IF p1x < 10 THEN p1x = p1x + 5: p1s = p1s * .3 * -1
IF p1x > 288 THEN p1x = p1x - 5: p1s = p1s * .3 * -1
IF p1y > 140 THEN p1y = p1y - 5: p1s = p1s * .3 * -1

IF p1dir = 1 THEN p1y = p1y + p1s
IF p1dir = 2 THEN p1x = p1x + p1s
IF p1dir = 3 THEN p1x = p1x - p1s
IF p1dir = 4 THEN p1y = p1y - p1s

IF p1s > p1speed * 7 THEN p1s = p1speed * 7
IF p1s < -p1speed * 7 THEN p1s = p1speed * -7

IF p1s > 0 THEN p1s = p1s - .05
IF p1s < 0 THEN p1s = p1s + .01

IF p1heat > 0 THEN p1heat = p1heat - 1

IF p1dir = 1 THEN lname$ = cardown$
IF p1dir = 2 THEN lname$ = carright$
IF p1dir = 3 THEN lname$ = carleft$
IF p1dir = 4 THEN lname$ = carup$

' *** Computer Movement ***
IF p2y < 8 THEN p2y = p2y + 5: p2s = p2s * .3 * -1
IF p2x < 10 THEN p2x = p2x + 5: p2s = p2s * .3 * -1
IF p2x > 288 THEN p2x = p2x - 5: p2s = p2s * .3 * -1
IF p2y > 140 THEN p2y = p2y - 5: p2s = p2s * .3 * -1

IF p1x < p2x - 100 THEN IF INT(RND * 7) + 1 = 4 THEN p2dir = 3
IF p2x < p1x - 100 THEN IF INT(RND * 7) + 1 = 4 THEN p2dir = 2
IF p1y < p2y - 50 THEN IF INT(RND * 7) + 1 = 4 THEN p2dir = 4
IF p1y > p2y + 50 THEN IF INT(RND * 7) + 1 = 4 THEN p2dir = 1

IF INT(RND * 20) + 1 = 4 THEN p2dir = INT(RND * 4) + 1

IF INT(RND * 3) + 1 = 2 THEN p2s = p2s + (p2speed * 3)

IF p2heat > 0 THEN p2heat = p2heat - 1

IF p2s > p2speed * 7 THEN p2s = p2speed * 7
IF p2s < -p2speed * 7 THEN p2s = p2speed * -7

IF p2s > 0 THEN p2s = p2s - .05
IF p2s < 0 THEN p2s = p2s + .01

IF p2dir = 1 THEN p2y = p2y + p2s
IF p2dir = 2 THEN p2x = p2x + p2s
IF p2dir = 3 THEN p2x = p2x - p2s
IF p2dir = 4 THEN p2y = p2y - p2s

' *** Computer Firing ***
IF p2x > p1x - 15 THEN
 IF p2x + 25 < p1x + 40 THEN
  IF p2heat <= 90 THEN
   IF INT(RND * 7) + 1 = 4 THEN p2fire = 1
  END IF
 END IF
END IF
IF p2y > p1y - 15 THEN
 IF p2y + 25 < p1y + 40 THEN
  IF p2heat <= 90 THEN
   IF INT(RND * 7) + 1 = 4 THEN p2fire = 1
  END IF
 END IF
END IF
' *** Computer Firing ***


IF p2dir = 1 THEN cname$ = pcardown$
IF p2dir = 2 THEN cname$ = pcarright$
IF p2dir = 3 THEN cname$ = pcarleft$
IF p2dir = 4 THEN cname$ = pcarup$
' *** Computer Movement ***

' *** Movement, boundaries, restrictions ***

frontstart

' *** Load Player 1 Movement ***
DEF SEG = VARSEG(p1autom(1))
BLOAD lname$ + "m.hds", VARPTR(p1autom(1))
DEF SEG               ' Restore default BASIC segment.

DEF SEG = VARSEG(p1auto(1))
BLOAD lname$ + ".hds", VARPTR(p1auto(1))
DEF SEG               ' Restore default BASIC segment.

PUT (p1x, p1y), p1autom, AND
PUT (p1x, p1y), p1auto, XOR
' *** Load PLayer 1 Movement ***

' *** Load Player 2 Movement ***
DEF SEG = VARSEG(p2autom(1))
BLOAD cname$ + "m.hds", VARPTR(p2autom(1))
DEF SEG               ' Restore default BASIC segment.

DEF SEG = VARSEG(p2auto(1))
BLOAD cname$ + ".hds", VARPTR(p2auto(1))
DEF SEG               ' Restore default BASIC segment.

PUT (p2x, p2y), p2autom, AND
PUT (p2x, p2y), p2auto, XOR
' *** Load Player 2 Movement ***

' *** Checking firing ***
IF fire = 1 THEN
 IF p1dir = 1 THEN LINE (p1x + 11, p1y + 27)-(p1x + 13, 156), p1c, BF
 IF p1dir = 2 THEN LINE (p1x + 27, p1y + 11)-(305, p1y + 13), p1c, BF
 IF p1dir = 3 THEN LINE (p1x - 2, p1y + 11)-(14, p1y + 13), p1c, BF
 IF p1dir = 4 THEN LINE (p1x + 11, p1y - 2)-(p1x + 13, 14), p1c, BF
 fire = 0
 p1heat = p1heat + 10
' *** Checking P1 Shots ***
 SELECT CASE p1dir
 CASE IS = 1
  IF p1x >= p2x - 10 THEN
   IF p1x + 25 <= p2x + 35 THEN
    IF p2y > p1y THEN
     p2energy = p2energy - (2 + (p1power / 3) - (p2defense / 2))
     p2hit
     p2s = p2s - p1power
     END IF
    END IF
   END IF
 CASE IS = 2
  IF p1y >= p2y - 10 THEN
   IF p1y + 25 <= p2y + 35 THEN
    IF p2x > p1x THEN
    p2energy = p2energy - (2 + (p1power / 3) - (p2defense / 2))
    p2hit
    p2s = p2s - p1power
    END IF
   END IF
  END IF
 CASE IS = 3
  IF p1y >= p2y - 10 THEN
   IF p1y + 25 <= p2y + 35 THEN
    IF p1x > p2x THEN
    p2energy = p2energy - (2 + (p1power / 3) - (p2defense / 2))
    p2hit
    p2s = p2s - p1power
    END IF
   END IF
  END IF
 CASE IS = 4
  IF p1x >= p2x - 10 THEN
   IF p1x + 25 <= p2x + 35 THEN
    IF p1y > p2y THEN
     p2energy = p2energy - (2 + (p1power / 3) - (p2defense / 2))
     p2hit
     p2s = p2s - p1power
     END IF
    END IF
   END IF
 END SELECT
' *** Checking P1 Shots ***
END IF

' *** Checking P2 Firing ***
IF p2fire = 1 THEN
 LINE (14, p2y + 11)-(p2x - 5, p2y + 15), p2c, BF
 LINE (305, p2y + 11)-(p2x + 30, p2y + 15), p2c, BF
 LINE (p2x + 11, 13)-(p2x + 15, p2y - 5), p2c, BF
 LINE (p2x + 11, p2y + 30)-(p2x + 15, 146), p2c, BF
 p2fire = 0
 p2heat = p2heat + 10
' *** Checking P2 Shots ***
IF p2x > p1x - 10 THEN
 IF p2x + 25 < p1x + 35 THEN
  p1hit
  p1energy = p1energy - p2power
  p1s = p1s - p2power
  p1hit
 END IF
END IF
IF p2y > p1y - 10 THEN
 IF p2y + 25 < p1y + 35 THEN
  p1hit
  p1energy = p1energy - (2 + (p2power / 3) - (p1defense / 2))
  p1s = p1s - p2power
  p1hit
 END IF
END IF
' *** Checking P2 Shots ***
END IF
' *** Checking P2 Firing ***


updatestatusbar
frontstop
' *** Checking firing ***

' *** Optimizing Different Computer Settings ***
FOR speedset = 1 TO currentspeed: NEXT
' *** Optimizing Different Computer Settings ***

LOOP UNTIL p1energy <= 0 OR p2energy <= 0

IF p1energy <= 0 THEN p1die
IF p2energy <= 0 THEN p2die

DO: LOOP UNTIL INKEY$ = ""
DO: LOOP UNTIL INKEY$ = ""
DO: LOOP UNTIL INKEY$ = ""

stopmidi

REDIM MIDI%(BytesRequired&("neverend.mid") \ 2)
LoadandPlayMIDI "neverend.mid", VARSEG(MIDI%(0)), VARPTR(MIDI%(0))

IF p1energy <= 0 THEN GOTO 200

CLS
SCREEN 12
win = win + 1
p2car = p2car + 1

COLOR 15
PRINT "You've defeated your enemy!!!"
FOR d = 1 TO 10000: NEXT

IF win = 4 THEN
        stopmidi
        REDIM MIDI%(BytesRequired&("thunder.mid") \ 2)
        LoadandPlayMIDI "thunder.mid", VARSEG(MIDI%(0)), VARPTR(MIDI%(0))
        winner
        GOTO 10
END IF

PRINT "Press a key to enter BATTLE #"; (win + 1); "..."
IF p2car = 4 THEN p2car = 1
IF win = 3 THEN p2car = 10
backon = 0
DO: LOOP UNTIL INKEY$ = ""
DO: LOOP UNTIL INKEY$ <> ""

GOTO 100

200

CLS
SCREEN 12
COLOR 4
PRINT "You've been defeated..."
FOR d = 1 TO 10000: NEXT
PRINT "Would you like to try again (Y/N)?"
DO: LOOP UNTIL INKEY$ = ""

DO: a$ = UCASE$(INKEY$)
IF a$ = "Y" THEN backon = 0: GOTO 100
IF a$ = "N" THEN GOTO 10
LOOP

1000
SCREEN 12
COLOR 15
PRINT "Error occurred"
PRINT "It was error #"; ERR; "."
PRINT "Read the text file included (hrz.txt)."
PRINT "You can email me at Pantera55@aol.com if you can't fix the problem."
SYSTEM




SBMIDIData:
DATA 156,30,6,80,83,81,82,87,86,85,139,236,80,184,14,16,142,216,142,192,88,131,78,24,1,199,70,12,255,255,128,62
DATA 68,1,0,117,59,198,6,68,1,1,251,252,11,219,120,21,129,251,13,0,115,37,131,102,24,254,209,227,255,151,40,0
DATA 137,70,12,235,22,247,219,75,129,251,3,0,115,13,131,102,24,254,209,227,255,151,34,0,137,70,12,198,6,68,1,0
DATA 93,94,95,90,89,91,88,7,31,157,207,156,250,30,6,80,184,14,16,142,216,142,192,161,145,1,1,6,28,0,114,6
DATA 176,32,230,32,235,9,255,6,28,0,156,255,30,18,0,83,81,82,87,86,85,139,236,250,128,62,67,1,0,117,54,140
DATA 22,32,0,137,38,30,0,140,216,142,208,188,66,1,198,6,67,1,1,251,252,131,62,133,1,0,116,10,128,62,21,3
DATA 0,117,3,232,143,4,250,139,38,30,0,142,22,32,0,198,6,67,1,0,251,93,94,95,90,89,91,88,7,31,157,207
DATA 30,6,80,83,81,82,87,86,85,156,184,14,16,142,216,142,192,228,96,10,192,120,18,60,83,117,14,180,2,205,22,36
SBSIMData:
DATA 46,143,6,134,1,46,143,6,132,1,46,143,6,130,1,46,131,14,130,1,1,46,131,62,110,1,0,116,6,184,1,0
DATA 233,193,0,128,255,5,119,25,10,255,116,27,81,80,51,192,138,207,128,225,127,249,211,208,46,35,6,126,1,88,89,117
DATA 6,184,2,0,233,157,0,250,46,140,30,138,1,14,31,140,22,140,1,137,38,142,1,142,22,152,1,139,38,154,1,85
DATA 139,236,86,87,6,83,163,144,1,137,22,148,1,137,14,146,1,180,98,205,33,137,30,150,1,180,80,140,203,205,33,199
DATA 6,110,1,1,0,251,252,50,192,255,30,118,1,139,94,248,83,134,251,3,219,3,219,50,255,254,14,124,1,117,11,129
DATA 6,152,1,0,0,198,6,124,1,20,139,243,91,50,255,30,7,255,156,176,1,114,5,131,38,130,1,254,250,199,6,110
DATA 1,0,0,80,180,80,139,30,150,1,205,33,88,91,7,95,94,139,229,93,139,14,146,1,142,22,140,1,139,38,142,1
DATA 142,30,138,1,46,255,54,130,1,46,255,54,132,1,46,255,54,134,1,207,85,139,236,131,236,10,137,70,248,137,94,250

SUB about
LINE (10, 10)-(309, 159), 17, BF

lshadow 40, 19, "ABOUT", 8, 15
                             
lshadow 30, 39, "PROGRAMMING: PANTERA55 (AOL)", 1, 9
lshadow 30, 49, "     A HYPER DIMENSION SOFT PRODUCTION", 2, 10
lshadow 30, 59, "     HTTP://MEMBERS.AOL.COM/PANTERA55/", 4, 12
lshadow 30, 79, "MIDI PROGRAMMING: KULLCONQER (AOL)", 1, 9
lshadow 30, 89, "     OF RAINSMIDI, INC.", 2, 10
lshadow 30, 99, "     HTTP://WWW.INTERNETPRO.NET/~ARAINS", 4, 12
lshadow 30, 119, "MIDI SOUND DRIVER: JESSE DORLAND", 1, 9
lshadow 30, 129, "    jessedorland at hotmail.com", 4, 12

lshadow 30, 149, "TESTING: HYPER DIMENSION MEMBERS", 2, 10

DO: LOOP UNTIL INKEY$ = ""
DO: LOOP UNTIL INKEY$ <> ""

mainscreen
END SUB

SUB background1
REDIM block(225)
CLS

LINE (0, 0)-(19, 19), 0, BF

FOR n = 1 TO 10
CIRCLE (INT(RND * 19) + 1, INT(RND * 19) + 1), INT(RND * 7) + 1, 14
LINE -(INT(RND * 19) + 1, INT(RND * 19) + 1), 15
NEXT

GET (0, 0)-(19, 19), block

FOR x = 0 TO 300 STEP 20
FOR y = 0 TO 140 STEP 20
PUT (x, y), block, PSET
NEXT
NEXT

brickborder
statusbar

END SUB

SUB background2
REDIM block(225)
LINE (0, 0)-(19, 19), 11, BF
LINE (3, 3)-(16, 16), 3, BF
LINE (6, 6)-(13, 13), 11, BF
LINE (9, 9)-(10, 10), 3, BF
LINE (0, 0)-(19, 19), 15, B
LINE (0, 0)-(19, 19), 15
LINE (0, 19)-(19, 0), 15
GET (0, 0)-(19, 19), block

FOR x = 0 TO 300 STEP 20
FOR y = 0 TO 140 STEP 20
PUT (x, y), block, PSET
NEXT
NEXT

brickborder
statusbar

END SUB

SUB background3
REDIM block(225)
LINE (0, 0)-(19, 19), 13, BF

FOR n = 1 TO 10
rancol = INT(RND * 3) + 1
IF rancol = 3 THEN rancol = 4
CIRCLE (10, 10), n, rancol
NEXT

GET (0, 0)-(19, 19), block

FOR x = 0 TO 300 STEP 20
FOR y = 0 TO 140 STEP 20
PUT (x, y), block, PSET
NEXT
NEXT

brickborder
statusbar

END SUB

SUB background4
REDIM block(225)

LINE (0, 0)-(19, 19), 0, BF
FOR x = 0 TO 19 STEP 2
FOR y = 0 TO 19 STEP 2
LINE (x, 0)-(x + 19, 19), 8
LINE (0, y)-(19, y + 19), 8
LINE (x, 19)-(x + 19, 0), 7
LINE (19, y)-(0, y + 19), 7

NEXT
NEXT

GET (0, 0)-(19, 19), block

FOR x = 0 TO 300 STEP 20
FOR y = 0 TO 140 STEP 20
PUT (x, y), block, PSET
NEXT
NEXT

brickborder
statusbar

END SUB

SUB backstart
SCREEN 7, , 3, 0
PCOPY 3, 1
END SUB

SUB backstop
PCOPY 3, 0
SCREEN 7, , 0, 0
END SUB

SUB brickborder
DIM brick(75)
LINE (0, 0)-(9, 9), 8, BF
LINE (0, 0)-(9, 9), 7, B
LINE (0, 0)-(9, 9), 7
LINE (9, 0)-(0, 9), 7
GET (0, 0)-(9, 9), brick

FOR x = 0 TO 310 STEP 10
PUT (x, 0), brick, PSET
PUT (x, 160), brick, PSET
NEXT

FOR y = 0 TO 150 STEP 10
PUT (0, y), brick, PSET
PUT (310, y), brick, PSET
NEXT

END SUB

FUNCTION BytesRequired& (Filename$)
'Open the file.
FF% = FREEFILE
OPEN Filename$ FOR BINARY AS #FF%
'Store the length of the file.
FileLen& = LOF(FF%)
'Close the file.
CLOSE FF%
'If the length of the file is 0, assume it does not exist and delete it.
IF FileLen& = 0 THEN KILL Filename$
'Return the length of the file as the number of bytes required.
BytesRequired& = FileLen&
END FUNCTION

SUB carselectscreen
DIM clip(1 TO 300)

splace = 32

SCREEN 7
coolblocks

LINE (100, 10)-(220, 20), 8, BF
LINE (100, 10)-(220, 20), 14, B

lshadow 103, 17, "- SELECT YOUR CAR -", 0, 14

LINE (40, 30)-(280, 70), 0, BF
LINE (40, 80)-(280, 120), 0, BF
LINE (40, 130)-(280, 170), 0, BF

DEF SEG = VARSEG(clip(1))
BLOAD "car14.hds", VARPTR(clip(1))
DEF SEG               ' Restore default BASIC segment.
PUT (50, 37), clip, PSET
DEF SEG = VARSEG(clip(1))
BLOAD "car24.hds", VARPTR(clip(1))
DEF SEG               ' Restore default BASIC segment.
PUT (50, 87), clip, PSET
DEF SEG = VARSEG(clip(1))
BLOAD "car34.hds", VARPTR(clip(1))
DEF SEG               ' Restore default BASIC segment.
PUT (50, 137), clip, PSET

lshadow 90, 38, "THE BLUE BEAST", 1, 9
lshadow 95, 48, "  SPEED   - *", 8, 15
lshadow 95, 58, "  DEFENSE - **", 8, 15
lshadow 95, 68, "  POWER   - ***", 8, 15

lshadow 90, 88, "DIMENSIA Z", 4, 12
lshadow 95, 98, "  SPEED   - ***", 8, 15
lshadow 95, 108, "  DEFENSE - ** ", 8, 15
lshadow 95, 118, "  POWER   - *", 8, 15

lshadow 90, 138, "DEFENX", 2, 10
lshadow 95, 148, "  SPEED   - **", 8, 15
lshadow 95, 158, "  DEFENSE - ***", 8, 15
lshadow 95, 168, "  POWER   - *", 8, 15

DO
LINE (240, splace)-(277, splace + 35), 14, BF
LINE (240, splace)-(277, splace + 35), 0, BF


a$ = INKEY$
IF a$ = CHR$(0) + "P" THEN IF splace <> 132 THEN splace = splace + 50
IF a$ = CHR$(0) + "H" THEN IF splace <> 32 THEN splace = splace - 50
LOOP UNTIL a$ = CHR$(13)

LINE (240, splace)-(277, splace + 35), 4, BF

IF splace = 32 THEN p1car = 1
IF splace = 82 THEN p1car = 2
IF splace = 132 THEN p1car = 3

END SUB

SUB coolblocks
DIM block(225)
FOR x = 0 TO 19
FOR y = 0 TO 19
PSET (x, y), 6 + INT(RND * 2) + 1
NEXT
NEXT
LINE (0, 0)-(19, 0), 0
LINE (0, 19)-(19, 19), 0
LINE (0, 9)-(19, 10), 0, B
LINE (9, 0)-(10, 10), 0, B
LINE (0, 10)-(0, 19), 0, B
LINE (19, 10)-(19, 19), 0, B
GET (0, 0)-(19, 19), block

FOR x = 0 TO 300 STEP 20
FOR y = 0 TO 180 STEP 20
PUT (x, y), block, PSET
NEXT
NEXT
LINE (0, 0)-(319, 199), 8, B
LINE (1, 1)-(318, 198), 7, B
END SUB

SUB DriversLoaded (SBMIDI%, SBSIM%) STATIC

'Check the interrupt handlers for int 80h-89h to see if they contain
'program code from either SBSIM or SBMIDI.  Only those 10 interrupts
'are checked because chances are slim that either driver will be loaded
'at int 8Ah or higher, and they will never load themselves below
'80h.

FOR I% = &H80 TO &H8A
    'Get the address of the interrupt handler.
    GetIntVector I%, Segment%, Offset%
    'If the address is null, then the interrupt is not in use, and can be
    'skipped.
    IF Segment% = 0 AND Offset% = 0 THEN GOTO Skip:
 
    'Point to the segment of the interrupt handler.
    DEF SEG = Segment%
    RESTORE SBMIDIData:
    FOR J% = 0 TO 255
        'Read a byte of the SBMIDI program code that has been previously
        'saved.
        READ Byte1%
        'Read a byte of code from the current interrupt handler.
        Byte2% = PEEK(Offset% + J%)
        'Do they match?  If so, we may have found SBMIDI!
        IF Byte1% = Byte2% THEN
            MatchSBMIDI% = 1
        'If not, this interrupt is definitely not occupied by SBMIDI.
        ELSE
            SELECT CASE J%
                CASE IS = 14, 15, 113, 114, 235, 236
                CASE ELSE
                    MatchSBMIDI% = 0
                    EXIT FOR
            END SELECT
        END IF
    NEXT J%
    'If there's a match, set SBMIDI% to the current interrupt.
    IF MatchSBMIDI% THEN SBMIDI% = I%
    RESTORE SBSIMData:
    FOR J% = 0 TO 255
        'Read a byte of the SBSIM program code that has been previously
        'saved.
        READ Byte1%
        'Read a byte of code from the current interrupt handler.
        Byte2% = PEEK(Offset% + J%)
        'If the values match, SBSIM may be loaded at this interrupt.
        IF Byte1% = Byte2% THEN
            MatchSBSIM% = 1
        'If not, then it isn't.
        ELSE
            MatchSBSIM% = 0
            EXIT FOR
        END IF
    NEXT J%
    'If this interrupt handler is a match, set SBSIM% to the current
    'interrupt number.
    IF MatchSBSIM% THEN SBSIM% = I%
 
    'If both SBMIDI% and SBSIM% have been detected, there's no need to
    'check the rest of the interrupt handling routines.
    IF MatchSBMIDI% AND MatchSBSIM% THEN EXIT FOR
Skip:
NEXT I%
END SUB

SUB editspeed

curspeed = currentspeed

SCREEN 12
COLOR 15
PRINT "Sorry that I didn't make this auto, but I'm too lazy. Just press up"
PRINT "and down to make the delay higher or lower. The target FPS is about"
PRINT "8 FPS. That is a good speed. Press ESCAPE when done."

oldtime = INT(TIMER + 1)


DO: a$ = INKEY$
d = d + 1

LOCATE 5, 1: PRINT INT(oldtime)

IF INT(TIMER) >= oldtime THEN
 oldtime = TIMER
 LOCATE 6, 1: PRINT "FPS: "; d
 d = 0
END IF

LOCATE 7, 1: PRINT "Extra delay: "; curspeed

FOR extime = 1 TO 700: NEXT

IF a$ = CHR$(0) + "H" THEN curspeed = curspeed + 25
IF a$ = CHR$(0) + "P" THEN IF curspeed > 0 THEN curspeed = curspeed - 25

FOR extradelay = 1 TO curspeed: NEXT

LOOP UNTIL a$ = CHR$(27)

currentspeed = curspeed

OPEN "setspeed.hds" FOR OUTPUT AS #1
WRITE #1, currentspeed
CLOSE #1

mainscreen
END SUB

SUB frontstart
SCREEN 7, , 2, 0
PCOPY 3, 2
END SUB

SUB frontstop
PCOPY 2, 0
SCREEN 7, , 0, 0
END SUB

DEFINT A-Z
SUB GetIntVector (IntNum%, Segment%, Offset%) STATIC
'If the code hasn't been loaded already, do it now.
IF GetIntVCodeLoaded% = 0 THEN
    asm$ = asm$ + CHR$(&H55)
    asm$ = asm$ + CHR$(&H89) + CHR$(&HE5)
    asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HA)
    asm$ = asm$ + CHR$(&H8A) + CHR$(&H7)
    asm$ = asm$ + CHR$(&HB4) + CHR$(&H35)
    asm$ = asm$ + CHR$(&HCD) + CHR$(&H21)
    asm$ = asm$ + CHR$(&H8C) + CHR$(&HC1)
    asm$ = asm$ + CHR$(&H89) + CHR$(&HDA)
    asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8)
    asm$ = asm$ + CHR$(&H89) + CHR$(&HF)
    asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H6)
    asm$ = asm$ + CHR$(&H89) + CHR$(&H17)
    asm$ = asm$ + CHR$(&H5D)
    asm$ = asm$ + CHR$(&HCB)
    asm$ = asm$ + CHR$(&H34) + CHR$(&H0)
    asm$ = asm$ + CHR$(&H60)
    asm$ = asm$ + CHR$(&H23) + CHR$(&H0)
    GetIntVCodeLoaded% = 1
END IF
'Execute the code
DEF SEG = VARSEG(asm$)
CALL ABSOLUTE(IntNum%, Segment%, Offset%, SADD(asm$))
END SUB

DEFSNG A-Z
SUB hdslogo

SCREEN 7
backstart
coolblocks
backstop

FOR nn = 10 TO 120
frontstart
COLOR 14
LINE (160, 18 + (nn / 5))-(120, 57 + (nn / 5))
LINE -(200, 57 + (nn / 5))
LINE -(160, 18 + (nn / 5))
PAINT (160, 28 + (nn / 5)), 14
COLOR 1
LINE (nn, 80)-(nn + 40, 40)
LINE -(nn + 40, 70)
LINE -(nn, 80)
PAINT (nn + 30, 60), 1
COLOR 2
LINE (320 - nn, 80)-(280 - nn, 40)
LINE -(280 - nn, 70)
LINE -(320 - nn, 80)
PAINT (290 - nn, 60), 2
COLOR 4
LINE (160, 190 - nn)-(200, 200 - nn)
LINE -(120, 200 - nn)
LINE -(160, 190 - nn)
PAINT (160, 195 - nn), 4
frontstop
NEXT

FOR nd = 0 TO 200
LINE (0, 200 - nd)-(320, 200 - nd), 0
setrgb 0, nd / 3.2, nd / 3.2, nd / 3.2
NEXT
setrgb 0, 0, 0, 0

backstart
nn = nn - 1
' *** Triangle ***
COLOR 1
LINE (nn, 80)-(nn + 40, 40)
LINE -(nn + 40, 70)
LINE -(nn, 80)
PAINT (nn + 30, 60), 1
COLOR 2
LINE (320 - nn, 80)-(280 - nn, 40)
LINE -(280 - nn, 70)
LINE -(320 - nn, 80)
PAINT (290 - nn, 60), 2
COLOR 4
LINE (160, 190 - nn)-(200, 200 - nn)
LINE -(120, 200 - nn)
LINE -(160, 190 - nn)
PAINT (160, 195 - nn), 4
COLOR 14
LINE (nn, 80)-(nn + 40, 40)
LINE -(nn + 40, 70)
LINE -(nn, 80)
LINE (320 - nn, 80)-(280 - nn, 40)
LINE -(280 - nn, 70)
LINE -(320 - nn, 80)
LINE (160, 190 - nn)-(200, 200 - nn)
LINE -(120, 200 - nn)
LINE -(160, 190 - nn)
' *** Triangle ***
LINE (242, 186)-(315, 196), 8, BF
LINE (242, 186)-(315, 196), 15, B
lshadow 245, 193, "PRESS A KEY", 0, 14
backstop

dir$ = "Up"
bu = 180
n = 10

DO: LOOP UNTIL INKEY$ = ""

DO
frontstart
n = n + 1
IF n = 64 THEN n = 10
setrgb 1, 0, 0, n
setrgb 2, 0, n, 0
setrgb 4, n, 0, 0
IF dir$ = "Up" THEN bu = bu - 1
IF bu = 80 THEN dir$ = "Down"
IF dir$ = "Down" THEN bu = bu + 1
IF bu = 180 THEN dir$ = "Up"
LINE (85, bu)-(234, bu + 10), 8, BF
LINE (85, bu)-(234, bu + 10), 7, B
lshadow 88, bu + 7, "HYPER DIMENSION SOFTWARE", 0, 15
frontstop

LOOP UNTIL INKEY$ <> ""

setrgb 1, 0, 0, 38
setrgb 2, 0, 38, 0
setrgb 4, 38, 0, 0
END SUB

SUB instructions

LINE (10, 10)-(309, 159), 17, BF

lshadow 40, 19, "INSTRUCTIONS", 24, 31
lshadow 40, 39, "THIS GAME HAS VERY BASIC CONTROLS. USE THE", 23, 29
lshadow 20, 49, "ARROW KEYS TO MOVE YOUR AUTO, AND USE THE", 23, 29
lshadow 20, 59, "SPACEBAR TO FIRE YOUR LAZER. REMEMBER THAT", 23, 29
lshadow 20, 69, "ALTHOUGH YOUR AUTO CANNOT SMASH INTO YOUR", 23, 29
lshadow 20, 79, "ENEMY'S AUTO, IT IS STILL UNWISE TO GET TOO", 23, 29
lshadow 20, 89, "CLOSE, UNLESS YOUR HEAT IS VERY LOW.", 23, 29
lshadow 40, 99, "OVERHEATING WILL MAKE YOUR LAZERS FREEZE,", 23, 29
lshadow 20, 109, "SO USE YOUR LAZERS WISELY. OH, TO GET A TOP", 23, 29
lshadow 20, 119, "SPEED, CONTINUOUSLY TAP THE ARROW KEY OF THE", 23, 29
lshadow 20, 129, "DIRECTION THAT YOU ARE GOING.", 23, 29
lshadow 40, 149, "PRESS A KEY...", 9, 14

DO: LOOP UNTIL INKEY$ = ""
DO: LOOP UNTIL INKEY$ <> ""

mainscreen

END SUB

SUB LoadandPlayMIDI (Filename$, MIDISegment%, MIDIOffset%)
'See if an extension was supplied, and if not, add one.
IF INSTR(Filename$, ".") = 0 THEN Filename$ = Filename$ + ".MID"
'Open the file
FF% = FREEFILE
OPEN Filename$ FOR BINARY AS #FF%
FileLen& = LOF(FF%)
CLOSE #FF%
'If the file is empty, delete it and exit now.
IF FileLen& = 0 THEN KILL Filename$: MIDI.ERROR = 1: EXIT SUB
'If the file is too large, exit now.
IF FileLen& > 65536 THEN MIDI.ERROR = 2: EXIT SUB
'Make the filename an ASCIIZ string.
Filename$ = Filename$ + CHR$(0)
'Check if the MIDI loading code has already been loaded;
'if not, do it now.
IF LoadCodeLoaded% = 0 THEN
        asm1$ = asm1$ + CHR$(&H1E)
        asm1$ = asm1$ + CHR$(&H55)
        asm1$ = asm1$ + CHR$(&H89) + CHR$(&HE5)
        asm1$ = asm1$ + CHR$(&HB8) + CHR$(&H0) + CHR$(&H3D)
        asm1$ = asm1$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HE)
        asm1$ = asm1$ + CHR$(&H8B) + CHR$(&H17)
        asm1$ = asm1$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H10)
        asm1$ = asm1$ + CHR$(&H8E) + CHR$(&H1F)
        asm1$ = asm1$ + CHR$(&HCD) + CHR$(&H21)
        asm1$ = asm1$ + CHR$(&H89) + CHR$(&HC6)
        asm1$ = asm1$ + CHR$(&HB4) + CHR$(&H3F)
        asm1$ = asm1$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8)
        asm1$ = asm1$ + CHR$(&H8B) + CHR$(&HF)
        asm1$ = asm1$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HA)
        asm1$ = asm1$ + CHR$(&H8B) + CHR$(&H17)
        asm1$ = asm1$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HC)
        asm1$ = asm1$ + CHR$(&H8E) + CHR$(&H1F)
        asm1$ = asm1$ + CHR$(&H89) + CHR$(&HF3)
        asm1$ = asm1$ + CHR$(&HCD) + CHR$(&H21)
        asm1$ = asm1$ + CHR$(&HB4) + CHR$(&H3E)
        asm1$ = asm1$ + CHR$(&HCD) + CHR$(&H21)
        asm1$ = asm1$ + CHR$(&H5D)
        asm1$ = asm1$ + CHR$(&H1F)
        asm1$ = asm1$ + CHR$(&HCA) + CHR$(&HA) + CHR$(&H0)
        LoadCodeLoaded% = 1
END IF
'Call the assembly language routine.
DEF SEG = VARSEG(asm1$)
CALL ABSOLUTE(VARSEG(Filename$), SADD(Filename$), MIDISegment%, MIDIOffset%, &HFFFF, SADD(asm1$))
'Check to see if the MIDI playing code has previously been loaded.
'If not, load it now.
IF PlayCodeLoaded% = 0 THEN
        'Load the machine codes into a string.
        asm2$ = asm2$ + CHR$(&H55)
        asm2$ = asm2$ + CHR$(&H89) + CHR$(&HE5)
        asm2$ = asm2$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8)
        asm2$ = asm2$ + CHR$(&H8B) + CHR$(&H17)
        asm2$ = asm2$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H6)
        asm2$ = asm2$ + CHR$(&H8B) + CHR$(&H7)
        asm2$ = asm2$ + CHR$(&HBB) + CHR$(&H4) + CHR$(&H0)
        asm2$ = asm2$ + CHR$(&HCD) + CHR$(SBMIDI.INTERRUPT)
        asm2$ = asm2$ + CHR$(&HBB) + CHR$(&H5) + CHR$(&H0)
        asm2$ = asm2$ + CHR$(&HCD) + CHR$(SBMIDI.INTERRUPT)
        asm2$ = asm2$ + CHR$(&H5D)
        asm2$ = asm2$ + CHR$(&HCA) + CHR$(&H4) + CHR$(&H0)
        'Indicate that the code has been loaded.
        PlayCodeLoaded% = 1
END IF
'Call the machine language routine to play the music.
DEF SEG = VARSEG(asm2$)
CALL ABSOLUTE(MIDISegment%, MIDIOffset%, SADD(asm2$))
'Start the MIDI timer.
MIDI.PLAYTIME = TIMER
END SUB

SUB LoadMIDI (Filename$, MIDISegment%, MIDIOffset%) STATIC
'See if an extension was supplied, and if not, add one.
IF INSTR(Filename$, ".") = 0 THEN Filename$ = Filename$ + ".MID"
'Open the file
FF% = FREEFILE
OPEN Filename$ FOR BINARY AS #FF%
FileLen& = LOF(FF%)
CLOSE #FF%
'If the file is empty, delete it and exit now.
IF FileLen& = 0 THEN KILL Filename$: MIDI.ERROR = 1: EXIT SUB
'If the file is too large, exit now.
IF FileLen& > 65536 THEN MIDI.ERROR = 2: EXIT SUB
'Make the filename an ASCIIZ string.
Filename$ = Filename$ + CHR$(0)
'Check if the assembly language code has already been loaded;
'if not, do it now.
IF CodeLoaded% = 0 THEN
        asm$ = asm$ + CHR$(&H1E)
        asm$ = asm$ + CHR$(&H55)
        asm$ = asm$ + CHR$(&H89) + CHR$(&HE5)
        asm$ = asm$ + CHR$(&HB8) + CHR$(&H0) + CHR$(&H3D)
        asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HE)
        asm$ = asm$ + CHR$(&H8B) + CHR$(&H17)
        asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H10)
        asm$ = asm$ + CHR$(&H8E) + CHR$(&H1F)
        asm$ = asm$ + CHR$(&HCD) + CHR$(&H21)
        asm$ = asm$ + CHR$(&H89) + CHR$(&HC6)
        asm$ = asm$ + CHR$(&HB4) + CHR$(&H3F)
        asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8)
        asm$ = asm$ + CHR$(&H8B) + CHR$(&HF)
        asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HA)
        asm$ = asm$ + CHR$(&H8B) + CHR$(&H17)
        asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HC)
        asm$ = asm$ + CHR$(&H8E) + CHR$(&H1F)
        asm$ = asm$ + CHR$(&H89) + CHR$(&HF3)
        asm$ = asm$ + CHR$(&HCD) + CHR$(&H21)
        asm$ = asm$ + CHR$(&HB4) + CHR$(&H3E)
        asm$ = asm$ + CHR$(&HCD) + CHR$(&H21)
        asm$ = asm$ + CHR$(&H5D)
        asm$ = asm$ + CHR$(&H1F)
        asm$ = asm$ + CHR$(&HCA) + CHR$(&HA) + CHR$(&H0)
        CodeLoaded% = 1
END IF
'Call the assembly language routine.
DEF SEG = VARSEG(asm$)
CALL ABSOLUTE(VARSEG(Filename$), SADD(Filename$), MIDISegment%, MIDIOffset%, &HFFFF, SADD(asm$))
END SUB

SUB lshadow (nx, ny, type$, col1, col2)
                
mx = nx
text nx, ny, type$, col1
text mx + 1, ny, type$, col2

END SUB

SUB mainscreen
SCREEN 13
LINE (10, 10)-(309, 159), 17, BF
LINE (0, 160)-(320, 200), 0, BF
brickborder

FOR y = 10 TO 1 STEP -1
text 118, 20 + y, "HYPER RACERS Z", 26 - y
text 70, 40 + y, "BY PANTERA55 OF HYPER DIMENSION", 26 - y
NEXT

text 118, 20, "HYPER RACERS Z", 31
text 70, 40, "BY PANTERA55 OF HYPER DIMENSION", 31

lshadow 125, 85, "(P)LAY GAME", 1, 9
lshadow 115, 95, "(I)NSTRUCTIONS", 2, 10
lshadow 136, 105, "(D)ELAY", 7, 14
lshadow 136, 115, "(A)BOUT", 8, 15
lshadow 139, 125, "(Q)UIT", 4, 12

lshadow 184, 147, "EMAIL: PANTERA55(AOL)", 1, 15
lshadow 77, 157, "WWW: HTTP://MEMBERS.AOL.COM/PANTERA55/", 4, 15

DO: LOOP UNTIL INKEY$ = ""

DO: a$ = UCASE$(INKEY$)
IF a$ = "I" THEN CALL instructions
IF a$ = "D" THEN editspeed
IF a$ = "Q" THEN CALL quit
IF a$ = "A" THEN CALL about
LOOP UNTIL a$ = "P"

END SUB

SUB melt
DIM meltbox(100)

FOR times = 1 TO 100
squx = 53 + INT(RND * 192) + 1
squy = 27 + INT(RND * 120) + 1
GET (squx, squy)-(squx + 9, squy + 9), meltbox
PUT (squx, squy + 1), meltbox, PSET

LINE (26, 150)-(280, 150), 0
NEXT


END SUB

SUB openingscreen
SCREEN 7
coolblocks

LINE (100, 70)-(220, 100), 0, BF
LINE (100, 70)-(220, 100), 14, B

IF p1car = 1 THEN lshadow 128, 78, "BLUE BEAST", 1, 9
IF p1car = 2 THEN lshadow 128, 78, "DIMENSIA Z", 4, 12
IF p1car = 3 THEN lshadow 140, 78, "DEFENX", 2, 10

lshadow 152, 88, "VS", 7, 15

IF p2car = 1 THEN lshadow 128, 98, "BLUE BEAST", 1, 9
IF p2car = 2 THEN lshadow 128, 98, "DIMENSIA Z", 4, 12
IF p2car = 3 THEN lshadow 140, 98, "DEFENX", 2, 10
IF p2car = 10 THEN lshadow 137, 98, "FIREFLY", 4, 14

DO: LOOP UNTIL INKEY$ = ""
DO: LOOP UNTIL INKEY$ <> ""

stopmidi
END SUB

SUB p1die

expwid = 0

DO
frontstart

DEF SEG = VARSEG(p1autom(1))
BLOAD lname$ + "m.hds", VARPTR(p1autom(1))
DEF SEG               ' Restore default BASIC segment.

DEF SEG = VARSEG(p1auto(1))
BLOAD lname$ + ".hds", VARPTR(p1auto(1))
DEF SEG               ' Restore default BASIC segment.

PUT (p1x, p1y), p1autom, AND
PUT (p1x, p1y), p1auto, XOR

expwid = expwid + 1

CIRCLE (p1x + 12, p1y + 12), expwid, p1c
CIRCLE (p1x + 12, p1y + 12), expwid + 1, 0
CIRCLE (p1x + 12, p1y + 12), expwid + 2, p1c

SOUND 300 + (expwid * 5), .1

frontstop

FOR d = 1 TO (50 + (currenttime * 10))
NEXT

LOOP UNTIL expwid = 20
END SUB

SUB p1hit
CIRCLE (p1x + 12, p1y + 12), (100 - p1energy) / 10, p2c
CIRCLE (p1x + 12, p1y + 12), ((100 - p1energy) / 10) * 2, p2c
CIRCLE (p1x + 12, p1y + 12), ((100 - p1energy) / 10) * 3, p2c
END SUB

SUB p2die

expwid = 0

DO
frontstart

DEF SEG = VARSEG(p2autom(1))
BLOAD cname$ + "m.hds", VARPTR(p2autom(1))
DEF SEG               ' Restore default BASIC segment.

DEF SEG = VARSEG(p1auto(1))
BLOAD cname$ + ".hds", VARPTR(p2auto(1))
DEF SEG               ' Restore default BASIC segment.

PUT (p2x, p2y), p2autom, AND
PUT (p2x, p2y), p2auto, XOR

expwid = expwid + 1

CIRCLE (p2x + 12, p2y + 12), expwid, p2c
CIRCLE (p2x + 12, p2y + 12), expwid + 1, 0
CIRCLE (p2x + 12, p2y + 12), expwid + 2, p2c

SOUND 300 + (expwid * 5), .1

frontstop

FOR d = 1 TO (50 + (currenttime * 10))
NEXT

LOOP UNTIL expwid = 20
END SUB

SUB p2hit
CIRCLE (p2x + 12, p2y + 12), (100 - p2energy) / 10, p1c
CIRCLE (p2x + 12, p2y + 12), ((100 - p2energy) / 10) * 2, p1c
CIRCLE (p2x + 12, p2y + 12), ((100 - p2energy) / 10) * 3, p1c
END SUB

SUB PlayMIDI (MIDISegment%, MIDIOffset%) STATIC
'Check to see if the MIDI playing code has previously been loaded.
'If not, load it now.
IF CodeLoaded% = 0 THEN
        'Load the machine codes into a string.
        asm$ = asm$ + CHR$(&H55)
        asm$ = asm$ + CHR$(&H89) + CHR$(&HE5)
        asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8)
        asm$ = asm$ + CHR$(&H8B) + CHR$(&H17)
        asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H6)
        asm$ = asm$ + CHR$(&H8B) + CHR$(&H7)
        asm$ = asm$ + CHR$(&HBB) + CHR$(&H4) + CHR$(&H0)
        asm$ = asm$ + CHR$(&HCD) + CHR$(&H80)
        asm$ = asm$ + CHR$(&HBB) + CHR$(&H5) + CHR$(&H0)
        asm$ = asm$ + CHR$(&HCD) + CHR$(&H80)
        asm$ = asm$ + CHR$(&H5D)
        asm$ = asm$ + CHR$(&HCA) + CHR$(&H4) + CHR$(&H0)
        'Indicate that the code has been loaded.
        CodeLoaded% = 1
END IF
'Call the machine language routine to play the music.
DEF SEG = VARSEG(asm$)
Offset% = SADD(asm$)
CALL ABSOLUTE(MIDISegment%, MIDIOffset%, Offset%)
'Start the MIDI timer.
MIDI.PLAYTIME = TIMER
END SUB

SUB putstats

SELECT CASE p1car
 CASE IS = 1
  lshadow 20, 180, "THE BLUE BEAST", 0, 9
 CASE IS = 2
  lshadow 20, 180, "DIMENSIA Z", 4, 12
 CASE IS = 3
  lshadow 20, 180, "DEFENX", 2, 10
END SELECT

SELECT CASE p2car
 CASE IS = 1
  lshadow 215, 180, "THE BLUE BEAST", 0, 9
 CASE IS = 2
  lshadow 215, 180, "    DIMENSIA Z", 4, 12
 CASE IS = 3
  lshadow 215, 180, "        DEFENX", 2, 10
 CASE IS = 5
  lshadow 215, 180, "       FIREFLY", 4, 14
END SELECT

lshadow 10, 188, "H", 0, 15
lshadow 10, 196, "P", 0, 15
lshadow 303, 188, "H", 0, 15
lshadow 303, 196, "P", 0, 15

LINE (20, 183)-(122, 188), 0, BF
LINE (20, 183)-(122, 188), 15, B
LINE (300, 183)-(198, 188), 0, BF
LINE (300, 183)-(198, 188), 15, B

LINE (20, 191)-(122, 196), 0, BF
LINE (20, 191)-(122, 196), 15, B
LINE (300, 191)-(198, 196), 0, BF
LINE (300, 191)-(198, 196), 15, B

END SUB

SUB quit

LINE (10, 10)-(309, 159), 17, BF

lshadow 92, 40, "THANKS FOR PLAYING!!!", 4, 12

lshadow 88, 155, "PRESS A KEY TO LEAVE...", 1, 9

DO: LOOP UNTIL INKEY$ = ""
DO: LOOP UNTIL INKEY$ <> ""
stopmidi
SYSTEM
END SUB

SUB setrgb (Nr, r, g, B)
  OUT &H3C8, Nr
  OUT &H3C9, r
  OUT &H3C9, g
  OUT &H3C9, B
END SUB

SUB statusbar
LINE (0, 170)-(319, 199), 1, BF
LINE (1, 170)-(318, 170), 9
LINE (319, 171)-(319, 198), 9
LINE (318, 199)-(1, 199), 9
LINE (0, 171)-(0, 198), 9
PSET (0, 170), 0
PSET (319, 170), 0
PSET (0, 199), 0
PSET (319, 199), 0
END SUB

SUB stopmidi
'Stop the music!!
asm$ = asm$ + CHR$(&HBB) + CHR$(&H4) + CHR$(&H0)
asm$ = asm$ + CHR$(&HCD) + CHR$(SBMIDI.INTERRUPT)
asm$ = asm$ + CHR$(&HCB)
'These next commented lines are for using the converted code.
DEF SEG = VARSEG(asm$)
Offset% = SADD(asm$)
CALL ABSOLUTE(Offset%)
'No MIDI file is playing, so reset the timer
MIDI.PLAYTIME = 0
END SUB

SUB text (x, y, word$, col)

word$ = UCASE$(word$)

FOR t = 1 TO LEN(word$)
a$ = MID$(word$, t, 1)

SELECT CASE a$

CASE IS = "A"
  d$ = "u3e2f2dl3r3d2"
CASE IS = "B"
  d$ = "u5r3fgl2r2fdgl3"
CASE IS = "C"
  d$ = "bm" + STR$(x) + "," + STR$(y - 2) + "u2er2fhl2gd3fr2e"
CASE IS = "D"
  d$ = "u5r2f2dg2l2"
CASE IS = "E"
  d$ = "u5r4l4d2r3l3d3r4"
CASE IS = "F"
  d$ = "u5r4l4d2r3l3"
CASE IS = "G"
  d$ = "bm" + STR$(x) + "," + STR$(y - 2) + "u2er2fhl2gd3fr2eul"
CASE IS = "H"
  d$ = "u5d2r4u2d5"
CASE IS = "I"
  d$ = "r4l2u5r2l4"
CASE IS = "J"
  d$ = "bm" + STR$(x) + "," + STR$(y - 2) + "dfreu4l3r4"
CASE IS = "K"
  d$ = "u5d3re3g3rhf3"
CASE IS = "L"
  d$ = "u5d5r4"
CASE IS = "M"
  d$ = "u5f2e2d5"
CASE IS = "N"
  d$ = "u5f4du5"
CASE IS = "O"
  d$ = "bm" + STR$(x) + "," + STR$(y - 2) + "u2er2fd3gl2h"
CASE IS = "P"
  d$ = "u5r3fdgl3"
CASE IS = "Q"
  d$ = "bm" + STR$(x) + "," + STR$(y - 2) + "u2er2fd3gl2hfr3h2"
CASE IS = "R"
  d$ = "u5r3fdgl3r3fd"
CASE IS = "S"
  d$ = "bm" + STR$(x) + "," + STR$(y - 1) + "fr2euhl2her2f"
CASE IS = "T"
  d$ = "bm" + STR$(x + 2) + "," + STR$(y) + "u5l2r4"
CASE IS = "U"
  d$ = "bm" + STR$(x) + "," + STR$(y - 5) + "d4fr2eu4"
CASE IS = "V"
  d$ = "bm" + STR$(x) + "," + STR$(y - 5) + "d3f2e2u3"
CASE IS = "W"
  d$ = "bm" + STR$(x) + "," + STR$(y - 5) + "d4feudfeu4"
CASE IS = "X"
  d$ = "e2uh2f2e2g2df2"
CASE IS = "Y"
  d$ = "bm" + STR$(x + 2) + "," + STR$(y) + "u2h2udf2e2u"
CASE IS = "Z"
  d$ = "r4udl4e4ul4d"
CASE IS = "1"
  d$ = "bm" + STR$(x + 2) + "," + STR$(y) + "lr2lu5g"
CASE IS = "2"
  d$ = "r4udl4e4hl2g"
CASE IS = "3"
  d$ = "r3euhlrehl3"
CASE IS = "4"
  d$ = "bm" + STR$(x + 3) + "," + STR$(y) + "u5d3rl4u3"
CASE IS = "5"
  d$ = "bm" + STR$(x) + "," + STR$(y - 1) + "fr2euhl3u2r4"
CASE IS = "6"
  d$ = "bm" + STR$(x) + "," + STR$(y - 1) + "fr2euhl3du2er3"
CASE IS = "7"
  d$ = "bm" + STR$(x + 2) + "," + STR$(y) + "u2e2ul4"
CASE IS = "8"
  d$ = "bm" + STR$(x) + "," + STR$(y - 1) + "fr2euhl2geher2f"
CASE IS = "9"
  d$ = "bm" + STR$(x + 1) + "," + STR$(y) + "r2eu3hl2gdfr2"
CASE IS = "0"
  d$ = "bm" + STR$(x) + "," + STR$(y - 2) + "u2er2fd3gl2hre3"
CASE IS = "'"
  d$ = "bm" + STR$(x + 1) + "," + STR$(y - 3) + "e2"
CASE IS = ","
  d$ = "bm" + STR$(x + 1) + "," + STR$(y + 1) + "eu"
CASE IS = "("
  d$ = "bm" + STR$(x + 3) + "," + STR$(y) + "hu3e"
CASE IS = ")"
  d$ = "bm" + STR$(x + 1) + "," + STR$(y) + "eu3h"
CASE IS = "-"
  d$ = "bm" + STR$(x) + "," + STR$(y - 2) + "r4"
CASE IS = ":"
  d2$ = "bm" + STR$(x + 1) + "," + STR$(y - 4) + "u"
  d$ = "bm" + STR$(x + 1) + "," + STR$(y - 1) + "u" + d2$
CASE IS = "/"
  d$ = "e5"
CASE IS = "+"
  d$ = "bm" + STR$(x + 2) + "," + STR$(y - 1) + "u4d2l2r4"
CASE IS = "."
  d$ = "m" + STR$(x) + "," + STR$(y)
CASE IS = "*"
  d$ = "u6r4d6l3u5r2d5lu4"
CASE IS = "~"
  d$ = "bm" + STR$(x) + "," + STR$(y - 4) + "efre"
CASE IS = "!"
  d2$ = "bm" + STR$(x + 2) + "," + STR$(y) + "u"
  d$ = "bm" + STR$(x + 2) + "," + STR$(y - 6) + "fdghurdd" + d2$
CASE IS = " "
  d$ = ""
END SELECT

IF d$ <> "" THEN
  DRAW "bm" + STR$(x) + "," + STR$(y) + "c" + STR$(col) + d$
END IF

xadd = 6
IF a$ = "1" OR a$ = "'" OR a$ = "," OR a$ = ":" THEN xadd = 5
IF a$ = "/" THEN xadd = 7

x = x + xadd

NEXT
END SUB

FUNCTION TimeMIDI!
'If a MIDI file is paused, lock the current playing time
IF PAUSED > 0! THEN
    TimeMIDI! = PAUSED
'If a MIDI file is playing, carry out the timing routine
ELSEIF MIDI.PLAYTIME THEN
    'Get the current time
    currenttime! = TIMER
    'If midnight has come since the MIDI file started playing, change
    'CurrentTime! accordingly
    IF currenttime! - MIDI.PLAYTIME < 0 THEN
        currenttime! = 86400 + currenttime!
    END IF
    'Get the final result
    TimeMIDI! = currenttime! - MIDI.PLAYTIME
ELSE
    MIDI.ERROR = 3
END IF
END FUNCTION

SUB updatestatusbar

LINE (21, 184)-(21 + p1heat, 187), 4, BF
LINE (299, 184)-(299 - p2heat, 187), 4, BF
LINE (21, 192)-(21 + p1energy, 195), 10, BF
LINE (299, 192)-(299 - p2energy, 195), 10, BF

END SUB

SUB winner
DO: LOOP UNTIL INKEY$ = ""

SCREEN 7

backstart
CLS

LINE (70, 34)-(250, 112), 8, BF
lshadow 107, 40, "CONGRATULATIONS!!!", 4, 12
lshadow 77, 50, "YOU HAVE DEFEATED FIREFLY!!!", 1, 9
lshadow 92, 60, "YOU ARE THE CHAMPION!!!", 2, 10

lshadow 97, 80, "SPECIAL THANKS GO TO:", 7, 15
lshadow 117, 90, "RAINSMIDI, INC.", 4, 12
lshadow 120, 100, "JESSE DORLAND", 7, 15
lshadow 87, 110, "THE HYPER DIMENSION GUYS", 2, 10

backstop

DO

frontstart
FOR tilex = 10 TO 285 STEP 25

whatkind = INT(RND * 4) + 1

IF whatkind = 1 THEN lname$ = "car" + no$ + "1"
IF whatkind = 2 THEN lname$ = "car" + no$ + "2"
IF whatkind = 3 THEN lname$ = "car" + no$ + "3"
IF whatkind = 4 THEN lname$ = "car" + no$ + "4"

DEF SEG = VARSEG(p1autom(1))
BLOAD lname$ + "m.hds", VARPTR(p1autom(1))
DEF SEG               ' Restore default BASIC segment.

DEF SEG = VARSEG(p1auto(1))
BLOAD lname$ + ".hds", VARPTR(p1auto(1))
DEF SEG               ' Restore default BASIC segment.

PUT (tilex, 0), p1autom, AND
PUT (tilex, 0), p1auto, XOR

PUT (tilex, 174), p1autom, AND
PUT (tilex, 174), p1auto, XOR

NEXT

FOR tiley = 24 TO 149 STEP 25
whatkind = INT(RND * 4) + 1

IF whatkind = 1 THEN lname$ = "car" + no$ + "1"
IF whatkind = 2 THEN lname$ = "car" + no$ + "2"
IF whatkind = 3 THEN lname$ = "car" + no$ + "3"
IF whatkind = 4 THEN lname$ = "car" + no$ + "4"

DEF SEG = VARSEG(p1autom(1))
BLOAD lname$ + "m.hds", VARPTR(p1autom(1))
DEF SEG               ' Restore default BASIC segment.

DEF SEG = VARSEG(p1auto(1))
BLOAD lname$ + ".hds", VARPTR(p1auto(1))
DEF SEG               ' Restore default BASIC segment.

PUT (10, tiley), p1autom, AND
PUT (10, tiley), p1auto, XOR

PUT (285, tiley), p1autom, AND
PUT (285, tiley), p1auto, XOR

NEXT

frontstop

LOOP UNTIL INKEY$ <> ""

DO
melt
LOOP UNTIL INKEY$ <> ""

END SUB

