' IQ Solitaire   Version 1.0
'
' The purpose of the game is to have the least amount of balls left.
' You remove balls by jumping one over another.
'
' Address: Daniel Fletcher
'          XYZZY Productions
'          P.O. Box 208
'          Taberg, NY  13471-0208
'
' E-Mail: danielfletcher@cyberdude.com   {E-Mail me for updates
'         xyzzyproductions@hotmail.com    to automatically be sent
'         camdenhighschool@hotmail.com    to you.}
'
' Web site: http://www.geocities.com/SiliconValley/Vista/3048/
'
' Birthday: 7-15-1981

DECLARE SUB Center (Row%, Text$)
DECLARE SUB CheckJump ()
DECLARE SUB CheckPieceNumber ()
DECLARE SUB DrawBoard ()
DECLARE SUB DrawFrom ()
DECLARE SUB DrawPegs ()
DECLARE SUB DrawWords (Scale!, Location!, Text$, TextColor!)
DECLARE SUB MouseDriver (AX%, bx%, CX%, DX%)
DECLARE SUB MouseLoad ()
DECLARE SUB MouseHide ()
DECLARE SUB MousePut (X!, Y!)
DECLARE SUB MouseShow ()
DECLARE SUB MouseStatus (LeftButton%, RightButton%, XMouse%, YMouse%)
DECLARE SUB SetUp ()
DECLARE SUB Winner ()
DECLARE FUNCTION CheckForWinner! ()
DECLARE FUNCTION MouseInit% ()

COMMON SHARED PieceNumber, MoveFrom, MoveTo, PegOff
COMMON SHARED XMouse%, YMouse%, Mouse$
DIM SHARED LocationX(15), LocationY(15), Peg(20), Letter$(100)
SCREEN 12

StartInput:
SetUp

MoveFromInput:
DrawPegs
IF CheckForWinner = 1 THEN Winner
DO
    MouseStatus LeftButton%, RightButton%, XMouse%, YMouse%
LOOP UNTIL LeftButton% <> 0
CheckPieceNumber
IF PieceNumber = 0 THEN GOTO MoveFromInput
IF PieceNumber = 999 THEN GOTO Quit
IF Peg(PieceNumber) = 0 THEN GOTO MoveFromInput
MoveFrom = PieceNumber

MoveToInput:
DrawPegs
DrawFrom
IF CheckForWinner = 1 THEN Winner
DO
    MouseStatus LeftButton%, RightButton%, XMouse%, YMouse%
LOOP UNTIL LeftButton% = 0
CheckPieceNumber
IF PieceNumber = 0 THEN GOTO MoveFromInput
IF PieceNumber = 999 THEN GOTO Quit
IF PieceNumber = MoveFrom THEN GOTO MoveFromInput
IF Peg(PieceNumber) = 1 THEN GOTO MoveFromInput
MoveTo = PieceNumber
CheckJump
IF PegOff <> 0 THEN GOTO MoveFromInput
GOTO MoveFromInput

Quit:
Center 26, "Play again (Y/N)?"

DO
    A$ = INKEY$
    A$ = UCASE$(A$)
LOOP UNTIL A$ = "Y" OR A$ = "N"
IF A$ = "Y" THEN RUN
SYSTEM

' DataStatements, don't change them or prog' won't work...
Locations:
DATA 320,70,270,140,370,140,220,210,320,210,420,210,170,280,270,280,370,280,470,280,120,350,220,350,320,350,420,350,520,350

MouseData:
DATA 55,89,E5,8B,5E,0C,8B,07,50,8B,5E,0A,8B,07,50,8B
DATA 5E,08,8B,0F,8B,5E,06,8B,17,5B,58,1E,07,CD,33,53
DATA 8B,5E,0C,89,07,58,8B,5E,0A,89,07,8B,5E,08,89,0F
DATA 8B,5E,06,89,17,5D,CA,08,00

SUB Center (Row%, Text$)
    LOCATE Row%, 41 - LEN(Text$) \ 2
    PRINT Text$;
END SUB

FUNCTION CheckForWinner

CheckForWinner = 1

FOR X = 1 TO 15
IF Peg(X) = 0 THEN GOTO XLoop
SELECT CASE X
CASE 1
    IF Peg(4) = 0 AND Peg(2) = 1 THEN CheckForWinner = 0
    IF Peg(6) = 0 AND Peg(3) = 1 THEN CheckForWinner = 0
CASE 2
    IF Peg(7) = 0 AND Peg(4) = 1 THEN CheckForWinner = 0
    IF Peg(9) = 0 AND Peg(5) = 1 THEN CheckForWinner = 0
CASE 3
    IF Peg(8) = 0 AND Peg(5) = 1 THEN CheckForWinner = 0
    IF Peg(10) = 0 AND Peg(6) = 1 THEN CheckForWinner = 0
CASE 4
    IF Peg(1) = 0 AND Peg(2) = 1 THEN CheckForWinner = 0
    IF Peg(6) = 0 AND Peg(5) = 1 THEN CheckForWinner = 0
    IF Peg(11) = 0 AND Peg(7) = 1 THEN CheckForWinner = 0
    IF Peg(13) = 0 AND Peg(8) = 1 THEN CheckForWinner = 0
CASE 5
    IF Peg(12) = 0 AND Peg(8) = 1 THEN CheckForWinner = 0
    IF Peg(14) = 0 AND Peg(9) = 1 THEN CheckForWinner = 0
CASE 6
    IF Peg(1) = 0 AND Peg(3) = 1 THEN CheckForWinner = 0
    IF Peg(4) = 0 AND Peg(5) = 1 THEN CheckForWinner = 0
    IF Peg(13) = 0 AND Peg(9) = 1 THEN CheckForWinner = 0
    IF Peg(15) = 0 AND Peg(10) = 1 THEN CheckForWinner = 0
CASE 7
    IF Peg(2) = 0 AND Peg(4) = 1 THEN CheckForWinner = 0
    IF Peg(9) = 0 AND Peg(8) = 1 THEN CheckForWinner = 0
CASE 8
    IF Peg(3) = 0 AND Peg(5) = 1 THEN CheckForWinner = 0
    IF Peg(10) = 0 AND Peg(9) = 1 THEN CheckForWinner = 0
CASE 9
    IF Peg(7) = 0 AND Peg(8) = 1 THEN CheckForWinner = 0
    IF Peg(2) = 0 AND Peg(5) = 1 THEN CheckForWinner = 0
CASE 10
    IF Peg(3) = 0 AND Peg(6) = 1 THEN CheckForWinner = 0
    IF Peg(8) = 0 AND Peg(9) = 1 THEN CheckForWinner = 0
CASE 11
    IF Peg(4) = 0 AND Peg(7) = 1 THEN CheckForWinner = 0
    IF Peg(13) = 0 AND Peg(12) = 1 THEN CheckForWinner = 0
CASE 12
    IF Peg(5) = 0 AND Peg(8) = 1 THEN CheckForWinner = 0
    IF Peg(14) = 0 AND Peg(13) = 1 THEN CheckForWinner = 0
CASE 13
    IF Peg(11) = 0 AND Peg(12) = 1 THEN CheckForWinner = 0
    IF Peg(4) = 0 AND Peg(8) = 1 THEN CheckForWinner = 0
    IF Peg(6) = 0 AND Peg(9) = 1 THEN CheckForWinner = 0
    IF Peg(15) = 0 AND Peg(14) = 1 THEN CheckForWinner = 0
CASE 14
    IF Peg(12) = 0 AND Peg(13) = 1 THEN CheckForWinner = 0
    IF Peg(5) = 0 AND Peg(9) = 1 THEN CheckForWinner = 0
CASE 15
    IF Peg(13) = 0 AND Peg(14) = 1 THEN CheckForWinner = 0
    IF Peg(6) = 0 AND Peg(10) = 1 THEN CheckForWinner = 0
END SELECT

XLoop:
NEXT X

END FUNCTION

SUB CheckJump

PegOff = 0

SELECT CASE MoveFrom
CASE 1
    IF MoveTo = 4 AND Peg(2) = 1 THEN PegOff = 2
    IF MoveTo = 6 AND Peg(3) = 1 THEN PegOff = 3
CASE 2
    IF MoveTo = 7 AND Peg(4) = 1 THEN PegOff = 4
    IF MoveTo = 9 AND Peg(5) = 1 THEN PegOff = 5
CASE 3
    IF MoveTo = 8 AND Peg(5) = 1 THEN PegOff = 5
    IF MoveTo = 10 AND Peg(6) = 1 THEN PegOff = 6
CASE 4
    IF MoveTo = 1 AND Peg(2) = 1 THEN PegOff = 2
    IF MoveTo = 6 AND Peg(5) = 1 THEN PegOff = 5
    IF MoveTo = 11 AND Peg(7) = 1 THEN PegOff = 7
    IF MoveTo = 13 AND Peg(8) = 1 THEN PegOff = 8
CASE 5
    IF MoveTo = 12 AND Peg(8) = 1 THEN PegOff = 8
    IF MoveTo = 14 AND Peg(9) = 1 THEN PegOff = 9
CASE 6
    IF MoveTo = 1 AND Peg(3) = 1 THEN PegOff = 3
    IF MoveTo = 4 AND Peg(5) = 1 THEN PegOff = 5
    IF MoveTo = 13 AND Peg(9) = 1 THEN PegOff = 9
    IF MoveTo = 15 AND Peg(10) = 1 THEN PegOff = 10
CASE 7
    IF MoveTo = 2 AND Peg(4) = 1 THEN PegOff = 4
    IF MoveTo = 9 AND Peg(8) = 1 THEN PegOff = 8
CASE 8
    IF MoveTo = 3 AND Peg(5) = 1 THEN PegOff = 5
    IF MoveTo = 10 AND Peg(9) = 1 THEN PegOff = 9
CASE 9
    IF MoveTo = 7 AND Peg(8) = 1 THEN PegOff = 8
    IF MoveTo = 2 AND Peg(5) = 1 THEN PegOff = 5
CASE 10
    IF MoveTo = 3 AND Peg(6) = 1 THEN PegOff = 6
    IF MoveTo = 8 AND Peg(9) = 1 THEN PegOff = 9
CASE 11
    IF MoveTo = 4 AND Peg(7) = 1 THEN PegOff = 7
    IF MoveTo = 13 AND Peg(12) = 1 THEN PegOff = 12
CASE 12
    IF MoveTo = 5 AND Peg(8) = 1 THEN PegOff = 8
    IF MoveTo = 14 AND Peg(13) = 1 THEN PegOff = 13
CASE 13
    IF MoveTo = 11 AND Peg(12) = 1 THEN PegOff = 12
    IF MoveTo = 4 AND Peg(8) = 1 THEN PegOff = 8
    IF MoveTo = 6 AND Peg(9) = 1 THEN PegOff = 9
    IF MoveTo = 15 AND Peg(14) = 1 THEN PegOff = 14
CASE 14
    IF MoveTo = 12 AND Peg(13) = 1 THEN PegOff = 13
    IF MoveTo = 5 AND Peg(9) = 1 THEN PegOff = 9
CASE 15
    IF MoveTo = 13 AND Peg(14) = 1 THEN PegOff = 14
    IF MoveTo = 6 AND Peg(10) = 1 THEN PegOff = 10
END SELECT

IF PegOff > 0 THEN
    Peg(MoveTo) = 1
    Peg(PegOff) = 0
    Peg(MoveFrom) = 0
    Mode = 0
    MoveFrom = 0
END IF

END SUB

SUB CheckPieceNumber

PieceNumber = 0

FOR X = 1 TO 15
    IF XMouse% > LocationX(X) - 26 AND XMouse% < LocationX(X) + 25 AND YMouse% > LocationY(X) - 25 AND YMouse% < LocationY(X) + 13 THEN PieceNumber = X
    IF PieceNumber = X THEN EXIT FOR
NEXT X

IF XMouse% >= 0 AND XMouse% <= 103 AND YMouse% >= 0 AND YMouse% <= 44 THEN PieceNumber = 999

END SUB

SUB DrawBoard

LINE (320, 20)-(50, 380), 15        'Left Side
LINE (320, 20)-(590, 380), 15       'Right Side
LINE (50, 380)-(590, 435), 15, B    'Bottom
LINE (51, 381)-(589, 434), 8, BF    'Bottom

PAINT (320, 26), 8, 15
PAINT (320, 400), 8, 15


PAINT (320, 20), 8, 15

Center 11, "** I-Q Solitaire **"

PSET (0, 42), 0
DRAW "C7U40E2R100F2D40G2L100H2BE5BR12P8,7"
DRAW "C15U30NR20D15NR15D15R20 BR4E20G10NH10F10 BR4U20BU2U1D1BD2D20 BR4BR10U30D10NL10NR10D20"


END SUB

SUB DrawFrom

MouseHide
PAINT (LocationX(MoveFrom), LocationY(MoveFrom)), 7, 15
CIRCLE (LocationX(MoveFrom), LocationY(MoveFrom)), 25, 15, , , .5
MouseShow

END SUB

SUB DrawPegs

MouseHide
FOR X = 1 TO 15
    IF Peg(X) = 1 THEN
        PSET (LocationX(X) - 5, LocationY(X) - 5), 2
        CIRCLE (LocationX(X), LocationY(X)), 25, 2, , 3, .5
        CIRCLE (LocationX(X), LocationY(X)), 25, 15, 3, , .5
        CIRCLE (LocationX(X), LocationY(X)), 25, 15, , 3.1, 1
        PAINT (LocationX(X), LocationY(X) - 10), 2, 15
        'LINE (LocationX(X) - 13, LocationY(X) - 12)-(LocationX(X) + 12, LocationY(X) + 10), 2, BF
    ELSEIF Peg(X) = 0 THEN
        PSET (LocationX(X) - 5, LocationY(X) - 5), 0
        CIRCLE (LocationX(X), LocationY(X)), 25, 8, , 3.1, 1
        PAINT (LocationX(X) - 10, LocationY(X)), 8, 8
        CIRCLE (LocationX(X), LocationY(X)), 25, 15, , , .5
        PAINT (LocationX(X), LocationY(X)), 0, 15
    END IF
NEXT X
MouseShow
END SUB

SUB DrawWords (Scale, Location, Text$, TextColor)

Text$ = UCASE$(Text$)

Letter$(1) = "U30R20D30U15L20R20D15"    'A
Letter$(2) = "U30R17F3D10G2NL18F2D10G3L14H3F3R12BR5"   'B
Letter$(3) = "U30R20L20D30R20"          'C
Letter$(4) = "U30R17F3D24G3L14H3F3R12BR5"   'D
Letter$(5) = "U30R20L20D15R15L15D15R20" 'E
Letter$(6) = "U30R20L20D15R15BR5BD15"   'F
Letter$(8) = "U30D15R20U15D30"          'H
Letter$(9) = "R20L10U30L10R20L10D30R10" 'I
Letter$(12) = "U30D30R20"               'L
Letter$(14) = "U30F20U20D30"            'N
Letter$(15) = "R20L20U30R20D30"         'O
Letter$(17) = "U30R20D30L20R20H5F10H5"  'Q
Letter$(18) = "U30R20D15L20R5F15"       'R
Letter$(19) = "R20U15L20U15R20BD30"     'S
Letter$(20) = "BR10U30L10R20BD30"       'T
Letter$(25) = "BU30F10ND20E10BD30"    'Y
Letter$(32) = "BR20"                    'Space

DRAW "S" + STR$(Scale)
PSET (320 - (LEN(Text$) * (Scale * 3.125)), Location), TextColor
 
FOR DrawTemp = 1 TO LEN(Text$)
        Letter$ = MID$(Text$, DrawTemp, 1)
        A = ASC(Letter$) - 64
        IF Letter$ = " " THEN A = 32
        DRAW Letter$(A) + "BR5"
NEXT DrawTemp

END SUB

SUB Logo

'Fall In
FOR X = 40 TO 1 STEP -2
    'CLS
    DrawWords X, 240 - (X * .75), "IQ SOLITAIRE", 9
NEXT X

'Fall Out
FOR X = 1 TO 8
    CLS
    DrawWords X, 240 - (S * .75), "IQ SOLITAIRE", 9
NEXT X

'By Daniel
FOR X = 480 TO 350 STEP -1
    LINE (110, X - 50)-(540, 480), 0, BF
    DrawWords 4, X, "BY", 9
    DrawWords 4, X + 60, "DANIEL FLETCHER", 9
NEXT X

DO
    A$ = INKEY$
LOOP WHILE A$ = ""

DRAW "S4"

END SUB

SUB MouseDriver (AX%, bx%, CX%, DX%)
  DEF SEG = VARSEG(Mouse$)
  Mouse% = SADD(Mouse$)
  CALL Absolute(AX%, bx%, CX%, DX%, Mouse%)
END SUB

SUB MouseHide
 AX% = 2
 MouseDriver AX%, 0, 0, 0
END SUB

FUNCTION MouseInit%
  AX% = 0
  MouseDriver AX%, 0, 0, 0
  MouseInit% = AX%

END FUNCTION

SUB MouseLoad

RESTORE MouseData
Mouse$ = SPACE$(57)
FOR i% = 1 TO 57
  READ A$
  H$ = CHR$(VAL("&H" + A$))
  MID$(Mouse$, i%, 1) = H$
NEXT i%

MousePut 0, 0
MouseShow

END SUB

SUB MousePut (X, Y)
  AX% = 4
  CX% = X
  DX% = Y
  MouseDriver AX%, 0, CX%, DX%
END SUB

SUB MouseShow
  AX% = 1
  MouseDriver AX%, 0, 0, 0
END SUB

SUB MouseStatus (LeftButton%, RightButton%, XMouse%, YMouse%)
  AX% = 3
  MouseDriver AX%, bx%, CX%, DX%
  LeftButton% = ((bx% AND 1) <> 0)
  RightButton% = ((bx% AND 2) <> 0)
  XMouse% = CX%
  YMouse% = DX%
END SUB

SUB Pause (time)

FOR temp = 1 TO time
NEXT temp

END SUB

SUB SetUp
LOCATE 1, 42: PRINT "This game is simular to checkers. A peg"
LOCATE 2, 44: PRINT "you jump over is removed from the"
LOCATE 3, 46: PRINT "board. Press the right mouse button"
LOCATE 4, 48: PRINT "on a peg - continue holding the"
LOCATE 5, 50: PRINT "button and move the arrow to"
LOCATE 6, 52: PRINT "the empty hole - release"
LOCATE 7, 54: PRINT "the button to complete the"
LOCATE 8, 56: PRINT "move. The goal is to have"
LOCATE 9, 58: PRINT "only one peg left."

'Set Locations
RESTORE Locations
FOR X = 1 TO 15
    READ LocationX(X), LocationY(X)
NEXT X

'Fill Pegs
FOR X = 1 TO 15
        Peg(X) = 1
NEXT X
Peg(5) = 0

'DrawsBoard
DrawBoard

'LoadsMouse
MouseLoad

END SUB

SUB Winner

Center 25, "Game Over!!!"
Balls = 0
FOR X = 1 TO 15
    IF Peg(X) = 1 THEN Balls = Balls + 1
NEXT X
Center 26, "There were" + STR$(Balls) + " balls left."
Center 27, "Play again (Y/N)?"

DO
    A$ = INKEY$
    A$ = UCASE$(A$)
LOOP UNTIL A$ = "Y" OR A$ = "N"
IF A$ = "Y" THEN RUN
CLS
SYSTEM

END SUB

