'=======================================================================
' JungleHunt - Leandro Pardini <lpardini@cefex.com>
'=======================================================================
' Hi everybody! This is the second game I've made, and is based in the
' Nick Kochakian's JungleHunt, posted in the ABC Packets last year.
'
' I modified scoring method a lot, and I've added sound effects, a menu
' to select skill level at runtime, and save/load game routines.
'
' If you run this on QBasic, the optimal GameSpeed setting is 0 for a
' 286/20, 100 for a i486/66 and 200 for a Pentium/120. I don't know
' what are the GameSpeed setting for compiled program (I don't have a
' compiler). If you compile this, please send me a copy.
'=======================================================================

'$STATIC
DEFINT A-Z

DECLARE SUB HiScoreSet ()
DECLARE SUB HiScoreShow ()
DECLARE SUB FadeIn ()
DECLARE SUB FadeOut ()
DECLARE SUB AllBlack ()
DECLARE SUB PlayFX (Num%)
DECLARE SUB SaveFile ()
DECLARE SUB CheckMap (PosX%, PosY%, Dir%)
DECLARE SUB RestoreMap ()
DECLARE SUB ClearScreen (Como%)
DECLARE SUB Menu (MaxOpts%, Opcion%, Lista() AS STRING)
DECLARE SUB ThinPrint (Cadena$, PosX%, PosY%, SizeX%, SizeY%, Spce%, Clr%)
DECLARE SUB MainLoop ()
DECLARE SUB LoadSprites ()
DECLARE SUB CreateMap ()
DECLARE SUB Move (Dir%)
DECLARE SUB SetPos (PosX%, PosY%)

DECLARE FUNCTION Adlib% ()
DECLARE FUNCTION LoadFX% (FileName$)
DECLARE FUNCTION ThinInput$ (Cadena$, PosX%, PosY%, SizeX%, SizeY%, Spce%, Clr%, Bck%, Max%)
DECLARE FUNCTION SelectFile% ()
DECLARE FUNCTION LoadFile% ()
DECLARE FUNCTION PAD$ (Numero%, Cantid%, Codigo%)
DECLARE FUNCTION GameLoop% ()
DECLARE FUNCTION PlayGame% ()

DIM SHARED GfxTree(41)
DIM SHARED GfxGems(41)
DIM SHARED GfxBush(41)
DIM SHARED GfxSpike(41)
DIM SHARED GfxGuy(41)
DIM SHARED GameMap(63, 2 TO 47)
DIM SHARED MaxGems
DIM SHARED Skill, Paleta AS STRING * 48
DIM SHARED GuyX, GuyY, GuyL, GuyG, GuyS, GuyT
DIM SHARED Snd(1 TO 4) AS STRING * 30
DIM SHARED SndAvail, SndActive, GameSpeed

IF Adlib THEN SndAvail = LoadFX("JUNGLE.SND")

OPEN "JUNGLE.CFG" FOR BINARY AS #1
IF LOF(1) = 0 THEN
   GameSpeed = 0
   SndActive = -1
   PUT #1, , GameSpeed
   PUT #1, , SndActive
ELSE
   GET #1, , GameSpeed
   GET #1, , SndActive
END IF
CLOSE #1

RANDOMIZE TIMER

OPEN "Jungle.pal" FOR BINARY ACCESS READ AS #1
GET #1, , Paleta
CLOSE #1

FadeOut

SCREEN 12

MID$(Paleta, 2, 1) = CHR$(12)
AllBlack

LINE (0, 0)-(639, 15), 8, BF
LINE (0, 16)-(639, 16), 7
LINE (0, 17)-(639, 17), 15
LINE (0, 18)-(639, 18), 7
LINE (0, 19)-(639, 19), 8
LINE (0, 460)-(639, 460), 8
LINE (0, 461)-(639, 461), 7
LINE (0, 462)-(639, 462), 15
LINE (0, 463)-(639, 463), 7
LINE (0, 464)-(639, 479), 8, BF

ThinPrint "JUNGLEHUNT", 220, 1, 18, 13, 2, 15

LoadSprites

GuyX = 32
GuyY = 24

FadeIn

MainLoop

FadeOut

SCREEN 0
WIDTH 80
CLS

MID$(Paleta, 2, 1) = CHR$(0)
AllBlack
PRINT "Thanks for play JungleHunt!"
FadeIn

SYSTEM

FUNCTION Adlib%
OUT &H388, &H4: FOR A7 = 1 TO 6: A11 = INP(&H388): NEXT
OUT &H389, &H60: FOR A7 = 1 TO 35: A11 = INP(&H388): NEXT
OUT &H388, &H4: FOR A7 = 1 TO 6: A11 = INP(&H388): NEXT
OUT &H389, &H80: FOR A7 = 1 TO 35: A11 = INP(&H388): NEXT
Astat1 = INP(&H388)
OUT &H388, &H2: FOR A7 = 1 TO 6: A11 = INP(&H388): NEXT
OUT &H389, &HFF: FOR A7 = 1 TO 35: A11 = INP(&H388): NEXT
OUT &H388, &H4: FOR A7 = 1 TO 6: A11 = INP(&H388): NEXT
OUT &H389, &H21: FOR A7 = 1 TO 35: A11 = INP(&H388): NEXT
Astat2 = INP(&H388)
OUT &H388, &H4: FOR A7 = 1 TO 6: A11 = INP(&H388): NEXT
OUT &H389, &H60: FOR A7 = 1 TO 35: A11 = INP(&H388): NEXT
OUT &H388, &H4: FOR A7 = 1 TO 6: A11 = INP(&H388): NEXT
OUT &H389, &H80: FOR A7 = 1 TO 35: A11 = INP(&H388): NEXT
Ares1 = Astat1 AND &HE0: Ares2 = Astat2 AND &HE0
Adlib% = 0: IF Ares1 = 0 AND Ares2 = 192 THEN Adlib% = -1
END FUNCTION

SUB AllBlack
FOR c = 0 TO 15
   OUT &H3C8, c
   OUT &H3C9, 0
   OUT &H3C9, 0
   OUT &H3C9, 0
NEXT c
END SUB

SUB CheckMap (PosX, PosY, Dir)
CanMove = -1
SELECT CASE GameMap(PosX, PosY)
   CASE 1
      GuyS = GuyS - 1
      LINE (152, 1)-(200, 14), 8, BF
      ThinPrint PAD(GuyS, 6, 32), 152, 1, 6, 13, 2, 15
      IF SndAvail AND SndActive THEN PlayFX 1
   CASE 2
      GuyG = GuyG + 1
      GuyS = GuyS + Skill
      LINE (376, 1)-(392, 14), 8, BF
      ThinPrint PAD(GuyG, 2, 32), 376, 1, 6, 13, 2, 15
      LINE (152, 1)-(200, 14), 8, BF
      ThinPrint PAD(GuyS, 6, 32), 152, 1, 6, 13, 2, 15
      IF SndAvail AND SndActive THEN PlayFX 2
   CASE 3
      CanMove = 0
      IF SndAvail AND SndActive THEN PlayFX 3
   CASE 4
      GuyL = GuyL - 10
      GuyS = GuyS - (Skill * 10)
      IF GuyL < 0 THEN GuyL = 0
      LINE (280, 1)-(304, 14), 8, BF
      ThinPrint PAD(GuyL, 3, 32), 280, 1, 6, 13, 2, 15
      IF SndAvail AND SndActive THEN PlayFX 4
END SELECT
IF CanMove THEN
   SELECT CASE Dir
   CASE 1: GuyY = GuyY - 1
   CASE 2: GuyX = GuyX - 1
   CASE 3: GuyX = GuyX + 1
   CASE 4: GuyY = GuyY + 1
   END SELECT
   Move Dir
   GameMap(GuyX, GuyY) = 0
END IF
END SUB

SUB ClearScreen (Como)
IF Como = 1 THEN
   FOR a = 0 TO 639 STEP 2
      LINE (a, 20)-(a, 479), 0
      PUT (GuyX * 10, GuyY * 10), GfxGuy, PSET
      I$ = INKEY$
      FOR Delay = 0 TO GameSpeed: I$ = INKEY$: NEXT Delay
   NEXT a
   FOR a = 639 TO 0 STEP -2
      LINE (a, 20)-(a, 479), 0
      PUT (GuyX * 10, GuyY * 10), GfxGuy, PSET
      I$ = INKEY$
      FOR Delay = 0 TO GameSpeed: I$ = INKEY$: NEXT Delay
   NEXT a
ELSEIF Como = 2 THEN
   FOR a = 0 TO 639 STEP 2
      LINE (a, 20)-(a, 459), 0
      LINE (a, 464)-(a, 479), 8
      PSET (a, 460), 8
      PSET (a, 461), 7
      PSET (a, 462), 15
      PSET (a, 463), 7
      I$ = INKEY$
      FOR Delay = 0 TO GameSpeed: I$ = INKEY$: NEXT Delay
   NEXT a
   FOR a = 639 TO 0 STEP -2
      LINE (a, 20)-(a, 459), 0
      LINE (a, 464)-(a, 479), 8
      PSET (a, 460), 8
      PSET (a, 461), 7
      PSET (a, 462), 15
      PSET (a, 463), 7
      I$ = INKEY$
      FOR Delay = 0 TO GameSpeed: I$ = INKEY$: NEXT Delay
   NEXT a
END IF
END SUB

SUB CreateMap

GuyL = 100
GuyS = GuyS + (Skill * 100)
GuyG = 0
GuyT = 0

SELECT CASE Skill
CASE 1: NumBush = 150: NumTree = 15: NumSpike = 15: NumGems = 30
CASE 2: NumBush = 460: NumTree = 30: NumSpike = 30: NumGems = 40
CASE 3: NumBush = 760: NumTree = 60: NumSpike = 60: NumGems = 60
CASE 4: NumBush = 1220: NumTree = 100: NumSpike = 100: NumGems = 75
CASE 5: NumBush = 1370: NumTree = 150: NumSpike = 160: NumGems = 90
END SELECT

PUT (GuyX * 10, GuyY * 10), GfxGuy, PSET

MaxGems = NumGems

LINE (0, 0)-(639, 15), 8, BF
ThinPrint "SCORE: " + PAD(GuyS, 6, 32) + "    LIVE: 100   GEMS:  0 OF " + STR$(MaxGems) + "   TIME: " + PAD(GuyT, 3, 32), 96, 1, 6, 13, 2, 15

FOR PosX = 0 TO 63
   FOR PosY = 2 TO 47
      GameMap(PosX, PosY) = 0
      I$ = INKEY$
   NEXT PosY
NEXT PosX

DO
   PosX = CINT(RND * 63)
   PosY = CINT(RND * 45) + 2
   IF GameMap(PosX, PosY) = 0 THEN GameMap(PosX, PosY) = 5: EXIT DO
   I$ = INKEY$
LOOP

SetPos PosX, PosY

PUT (GuyX * 10, GuyY * 10), GfxGuy, PSET

FOR a = 1 TO NumBush
   DO
      X = CINT(RND * 63)
      Y = CINT(RND * 45) + 2
      IF GameMap(X, Y) = 0 THEN GameMap(X, Y) = 1: EXIT DO
      I$ = INKEY$
   LOOP
   PUT (X * 10, Y * 10), GfxBush, PSET
NEXT a

FOR a = 1 TO MaxGems
   DO
      X = CINT(RND * 63)
      Y = CINT(RND * 45) + 2
      IF GameMap(X, Y) = 0 THEN GameMap(X, Y) = 2: EXIT DO
      I$ = INKEY$
   LOOP
   PUT (X * 10, Y * 10), GfxGems, PSET
NEXT a

FOR a = 1 TO NumTree
   DO
      X = CINT(RND * 63)
      Y = CINT(RND * 45) + 2
      IF GameMap(X, Y) = 0 THEN GameMap(X, Y) = 3: EXIT DO
      I$ = INKEY$
   LOOP
   PUT (X * 10, Y * 10), GfxTree, PSET
NEXT a

FOR a = 1 TO NumSpike
   DO
      X = CINT(RND * 63)
      Y = CINT(RND * 45) + 2
      IF GameMap(X, Y) = 0 THEN GameMap(X, Y) = 4: EXIT DO
      I$ = INKEY$
   LOOP
   PUT (X * 10, Y * 10), GfxSpike, PSET
NEXT a
  
GameMap(GuyX, GuyY) = 0

END SUB

SUB FadeIn
FOR s = 0 TO 63
   WAIT &H3DA, 8
   FOR c = 0 TO 15
      r = (ASC(MID$(Paleta, (c * 3) + 1, 1)) * s) \ 63
      g = (ASC(MID$(Paleta, (c * 3) + 2, 1)) * s) \ 63
      b = (ASC(MID$(Paleta, (c * 3) + 3, 1)) * s) \ 63
      OUT &H3C8, c
      OUT &H3C9, r
      OUT &H3C9, g
      OUT &H3C9, b
   NEXT c
NEXT s
END SUB

SUB FadeOut
FOR s = 63 TO 0 STEP -1
   WAIT &H3DA, 8
   FOR c = 0 TO 15
      r = (ASC(MID$(Paleta, (c * 3) + 1, 1)) * s) \ 63
      g = (ASC(MID$(Paleta, (c * 3) + 2, 1)) * s) \ 63
      b = (ASC(MID$(Paleta, (c * 3) + 3, 1)) * s) \ 63
      OUT &H3C8, c
      OUT &H3C9, r
      OUT &H3C9, g
      OUT &H3C9, b
   NEXT c
NEXT s
END SUB

FUNCTION GameLoop
   Ganaste = PlayGame
   WHILE Ganaste = 1
      ClearScreen 1
      CreateMap
      Ganaste = PlayGame
   WEND
   IF Ganaste = 0 THEN
      GameLoop = 0
   ELSE
      GameLoop = -1
   END IF
   ClearScreen 2
   LINE (0, 0)-(639, 15), 8, BF
   ThinPrint "JUNGLEHUNT", 220, 1, 18, 13, 2, 15
END FUNCTION

'====<lpardini@cefex.com>=
' Sets a HighScore entry.
'=========================
SUB HiScoreSet

DIM TNombre(10) AS STRING
DIM TPuntos(10)

Lugar = 0

OPEN "Jungle.hsc" FOR INPUT AS #1
FOR Leer = 0 TO 9
   LINE INPUT #1, TNombre(Leer)
   INPUT #1, TPuntos(Leer)
   IF (GuyS > TPuntos(Leer)) AND (Lugar = 0) THEN
      Lugar = Leer
      TNombre(Leer + 1) = TNombre(Leer)
      TPuntos(Leer + 1) = TPuntos(Leer)
      TPuntos(Leer) = GuyS
      Leer = Leer + 1
   END IF
NEXT Leer
CLOSE #1

IF Lugar > 0 THEN
   FOR Mostrar = 0 TO 9
      IF Mostrar = Lugar THEN
         Clr = 15
         Datos$ = STRING$(25, 32) + PAD(GuyS, 5, 32)
      ELSE
         Clr = 7
         Datos$ = TNombre(Mostrar) + STRING$(25 - LEN(TNombre(Mostrar)), 46) + PAD(TPuntos(Mostrar), 5, 46)
      END IF
      ThinPrint Datos$, 20, (Mostrar + 1) * 40, 16, 35, 4, Clr
   NEXT Mostrar
   CLOSE #1
   TNombre(Lugar) = ThinInput("", 20, (Lugar + 1) * 40, 16, 35, 4, 15, 0, 23)
   Datos$ = TNombre(Lugar) + STRING$(25 - LEN(TNombre(Lugar)), 46) + PAD(GuyS, 5, 46)
   ThinPrint Datos$, 20, (Lugar + 1) * 40, 16, 35, 4, 15
   OPEN "Jungle.hsc" FOR OUTPUT AS #1
      FOR Grabar = 0 TO 9
         PRINT #1, TNombre(Grabar)
         PRINT #1, TPuntos(Grabar)
      NEXT Grabar
   CLOSE #1
   WHILE INKEY$ = "": WEND
   LINE (0, 20)-(639, 459), 0, BF
END IF

END SUB

'=======<lpardini@cefex.com>=
' Shows the HighScore table.
'============================
SUB HiScoreShow
LINE (0, 20)-(639, 459), 0, BF

OPEN "Jungle.hsc" FOR INPUT AS #1
FOR Mostrar = 1 TO 10
   LINE INPUT #1, ENombre$
   INPUT #1, EPuntos%
   Datos$ = ENombre$ + STRING$(25 - LEN(ENombre$), 46) + PAD(EPuntos%, 5, 46)
   ThinPrint Datos$, 20, Mostrar * 40, 16, 35, 4, 15
NEXT Mostrar
CLOSE #1

WHILE INKEY$ = "": WEND
LINE (0, 20)-(639, 459), 0, BF
END SUB

FUNCTION LoadFile
   DIM Byte AS STRING * 1
   ThinPrint "SELECT FILE TO LOAD OR PRESS ESC TO ABORT", 1, 465, 6, 13, 2, 15
   Archivo = SelectFile
   LINE (0, 464)-(639, 479), 8, BF
   IF Archivo > 9 THEN
      LoadFile = 0
      LINE (0, 20)-(639, 459), 0, BF
      EXIT FUNCTION
   END IF
   ThinPrint "PLEASE WAIT...", 1, 465, 6, 13, 2, 15
   OPEN "JUNGLE.SV" + LTRIM$(RTRIM$(STR$(Archivo))) FOR BINARY ACCESS READ AS #1
      Info$ = STRING$(30, 32)
      GET #1, , Info$
      Info$ = STRING$(22, 32)
      GET #1, , Skill
      GET #1, , MaxGems
      GET #1, , GuyX
      GET #1, , GuyY
      GET #1, , GuyL
      GET #1, , GuyG
      GET #1, , GuyS
      GET #1, , GuyT
      FOR PosX = 0 TO 63
         FOR PosY = 2 TO 47
            GET #1, , Byte
            GameMap(PosX, PosY) = ASC(Byte)
         NEXT PosY
      NEXT PosX
   CLOSE #1
   LoadFile = -1
   LINE (0, 464)-(639, 479), 8, BF
   LINE (0, 20)-(639, 459), 0, BF
END FUNCTION

FUNCTION LoadFX (FileName$)
OPEN FileName$ FOR BINARY AS #1
IF LOF(1) = 0 THEN LoadFX = 0: CLOSE #1: EXIT FUNCTION
DIM id AS STRING * 4
GET #1, , id
IF MID$(id, 1, 2) <> "SL" THEN LoadFX = 0: CLOSE #1: EXIT FUNCTION
IF MID$(id, 3, 2) <> "10" THEN LoadFX = 0: CLOSE #1: EXIT FUNCTION
GET #1, , NumSound
FOR I = 1 TO NumSound
  GET #1, , Snd(I)
  temp$ = SPACE$(20)
  GET #1, , temp$
NEXT I
CLOSE #1
LoadFX = -1
END FUNCTION

SUB LoadSprites
OPEN "JUNGLE.DAT" FOR BINARY ACCESS READ AS #1
   FOR a = 0 TO 41: GET #1, , GfxBush(a): NEXT a
   FOR a = 0 TO 41: GET #1, , GfxTree(a): NEXT a
   FOR a = 0 TO 41: GET #1, , GfxGems(a): NEXT a
   FOR a = 0 TO 41: GET #1, , GfxSpike(a): NEXT a
   FOR a = 0 TO 41: GET #1, , GfxGuy(a): NEXT a
CLOSE #1
END SUB

SUB MainLoop
DIM MainMenu(1 TO 9) AS STRING
MainMenu(1) = "START NEW GAME"
MainMenu(2) = "CONTINUE CURRENT GAME"
MainMenu(3) = "SAVE CURRENT GAME"
MainMenu(4) = "LOAD SAVED GAME"
MainMenu(5) = "VIEW HIGH SCORES"
MainMenu(6) = "VIEW CREDITS"
MainMenu(7) = "HOW TO PLAY"
MainMenu(8) = "SETUP JUNGLEHUNT"
MainMenu(9) = "QUIT JUNGLEHUNT"

DIM SkillMenu(1 TO 5) AS STRING
SkillMenu(1) = "REALLY EASY"
SkillMenu(2) = "EASY"
SkillMenu(3) = "MEDIUM"
SkillMenu(4) = "HARD"
SkillMenu(5) = "REALLY HARD"

MainOpt = 1
SkillOpt = 3

DO
   Menu 9, MainOpt, MainMenu()
   IF MainOpt = 1 THEN
      Entra$ = "Y"
      IF GameInProgress THEN
         Entra$ = ThinInput("DO YOU WANT TO ABORT CURRENT GAME? ", 1, 465, 6, 13, 2, 15, 8, 1)
         LINE (0, 464)-(639, 479), 8, BF
      END IF
      IF Entra$ = "Y" THEN
         LINE (0, 20)-(639, 459), 0, BF
         Menu 5, SkillOpt, SkillMenu()
         LINE (0, 20)-(639, 459), 0, BF
         IF SkillOpt > 0 THEN
            Skill = SkillOpt
            LINE (0, 460)-(639, 479), 0, BF
            GuyS = 0
            CreateMap
            GameInProgress = GameLoop
            IF GameInProgress = 0 THEN
               ThinPrint "YOU LOST", 200, 210, 25, 60, 5, 15
               WHILE INKEY$ = "": WEND
               LINE (0, 200)-(639, 280), 0, BF
               HiScoreSet
            END IF
         ELSE
            SkillOpt = 3
         END IF
      END IF
   ELSEIF MainOpt = 2 THEN
      IF GameInProgress THEN
         LINE (0, 20)-(639, 479), 0, BF
         RestoreMap
         GameInProgress = GameLoop
         IF GameInProgress = 0 THEN
            ThinPrint "YOU LOST", 200, 210, 25, 60, 5, 15
            WHILE INKEY$ = "": WEND
            LINE (0, 200)-(639, 280), 0, BF
            HiScoreSet
         END IF
      ELSE
         ThinPrint "NO GAME IN PROGRESS - PRESS ANY KEY TO CONTINUE", 1, 465, 6, 13, 2, 15
         WHILE INKEY$ = "": WEND
         LINE (0, 464)-(639, 479), 8, BF
      END IF
   ELSEIF MainOpt = 3 THEN
      IF GameInProgress THEN
         SaveFile
      ELSE
         ThinPrint "NO GAME IN PROGRESS - PRESS ANY KEY TO CONTINUE", 1, 465, 6, 13, 2, 15
         WHILE INKEY$ = "": WEND
         LINE (0, 464)-(639, 479), 8, BF
      END IF
   ELSEIF MainOpt = 4 THEN
      Entra$ = "Y"
      IF GameInProgress THEN
         Entra$ = ThinInput("DO YOU WANT TO ABORT CURRENT GAME? ", 1, 465, 6, 13, 2, 15, 8, 1)
         LINE (0, 464)-(639, 479), 8, BF
      END IF
      IF Entra$ = "Y" THEN GameInProgress = LoadFile
   ELSEIF MainOpt = 5 THEN
      HiScoreShow
   ELSEIF MainOpt = 6 THEN
      LINE (0, 20)-(639, 459), 0, BF
      ThinPrint "ALL CODE AND INTERFACE MADE BY LEANDRO PARDINI", 44, 128, 10, 15, 2, 15
      ThinPrint "ORIGINAL IDEA TAKEN FROM NICK KOCHAKIAN'S JUNGLEHUNT", 34, 158, 9, 15, 2, 15
      ThinPrint "SOUND EFFECTS CREATED USING SOUNDLAB, MADE BY ANGELO MOTTOLA", 20, 188, 8, 15, 2, 15
      ThinPrint "ADLIB DETECTION ROUTINE MADE BY JESSE DORLAND", 50, 218, 9, 15, 3, 15
      ThinPrint "COMMENTS, SUGGESTIONS AND BUG REPORTS ARE ALWAYS WELCOME!", 35, 298, 8, 20, 2, 7
      ThinPrint "FEEL FREE TO EMAIL ME: LPARDINI@CEFEX.COM", 33, 333, 12, 20, 2, 7
      WHILE INKEY$ = "": WEND
      LINE (0, 20)-(639, 459), 0, BF
   ELSEIF MainOpt = 7 THEN
      LINE (0, 20)-(639, 459), 0, BF
      ThinPrint "HOW TO PLAY", 183, 40, 20, 25, 5, 15
      PUT (510, 100), GfxGuy, PSET
      PUT (235, 115), GfxGems, PSET
      PUT (100, 130), GfxBush, PSET
      PUT (95, 145), GfxTree, PSET
      PUT (235, 145), GfxSpike, PSET
      ThinPrint "YOU USE THE ARROW KEYS TO CONTROL THE FUNNY FACE  . THE GOAL", 20, 100, 8, 9, 2, 7
      ThinPrint "IS GET ALL THE GEMS   IN THE LEVEL. YOU CAN CLEAR OUT THE", 35, 115, 8, 9, 2, 7
      ThinPrint "BUSHES   WITH YOUR WHIP, BUT YOU CAN'T DESTROY OR MOVE THE", 30, 130, 8, 9, 2, 7
      ThinPrint "TREES  . THE SPIKES   WILL TAKE TEN LIFE UNITS PER TOUCH.", 35, 145, 8, 9, 2, 7
      ThinPrint "WHEN YOU GET A GEM, YOUR SCORE IS INCREASED BY THE NUMBER OF", 20, 175, 8, 9, 2, 7
      ThinPrint "YOUR SKILL LEVEL; YOU'LL GET FROM ONE POINT IF YOU'RE IN", 40, 190, 8, 9, 2, 7
      ThinPrint "REALLY EASY TO FIVE POINTS IF YOU'RE IN REALLY HARD.", 60, 205, 8, 9, 2, 7
      ThinPrint "EVERY TIME YOU CLEAR OUT A BUSH, YOUR SCORE WILL DECREASE", 35, 235, 8, 9, 2, 7
      ThinPrint "ONE POINT. ALSO, YOUR SCORE WILL DECREASE ONE POINT EVERY", 35, 250, 8, 9, 2, 7
      ThinPrint "SECOND; SO, PLAY FAST IF YOU WANT TO GET MORE POINTS.", 55, 265, 8, 9, 2, 7
      ThinPrint "YOUR LIFE WILL ALSO DECREASE ONE UNIT EVERY 5 SECONDS; SO,", 30, 295, 8, 9, 2, 7
      ThinPrint "YOU CAN ONLY PLAY 500 SECONDS BEFORE DIE. AGAIN, PLAY FAST.", 25, 310, 8, 9, 2, 7
      ThinPrint "WHEN YOU START A NEW GAME MAP, YOUR LIFE POINTS ARE RESET TO", 20, 340, 8, 9, 2, 7
      ThinPrint "ONE HUNDRED, AND YOUR SCORE ARE INCREASED BY YOUR SKILL", 45, 355, 8, 9, 2, 7
      ThinPrint "LEVEL MULTIPLIED BY 100. EXAMPLE, IF YOU'RE IN MEDIUM SKILL", 25, 370, 8, 9, 2, 7
      ThinPrint "LEVEL YOU GET 300 BONUS POINTS. THEN, EVERY TIME YOU LOST", 40, 385, 8, 9, 2, 7
      ThinPrint "LIFE POINTS, YOUR SCORE IS ALSO DECREASED BY THE NUMBER OF", 35, 400, 8, 9, 2, 7
      ThinPrint "POINTS LOST MULTIPLIED BY THE SKILL LEVEL; IN EXAMPLE, IF", 40, 415, 8, 9, 2, 7
      ThinPrint "YOU TOUCH A SPIKE YOUR SCORE IS DECREASED 30 POINTS.", 65, 430, 8, 9, 2, 7
      WHILE INKEY$ = "": WEND
      LINE (0, 20)-(639, 459), 0, BF
   ELSEIF MainOpt = 8 THEN
      LINE (0, 20)-(639, 459), 0, BF
      ThinPrint "GAME SPEED", 197, 88, 20, 25, 5, 15
      ThinPrint "THE GAME SPEED IS USED TO CONTROL SPEED OF FACE'S MOVEMENT", 30, 148, 8, 10, 2, 7
      ThinPrint "AND SCREEN CLEARING ROUTINE. YOU CAN ENTER A NUMBER FROM 0", 30, 163, 8, 10, 2, 7
      ThinPrint "TO 9999, WHERE 0 = FASTEST SETTING.", 145, 178, 8, 10, 2, 7
      ThinPrint "CURRENT SETTING: " + PAD(GameSpeed, 4, 32), 215, 208, 8, 10, 2, 7
      Entra$ = ThinInput("ENTER NEW SETTING: ", 205, 223, 8, 10, 2, 7, 0, 4)
      GameSpeed = VAL(Entra$)
      ThinPrint "SOUND EFFECTS", 158, 278, 20, 25, 5, 15
      ThinPrint "IF YOU HAVE A ADLIB OR COMPATIBLE SOUND CARD AND THE", 60, 338, 8, 10, 2, 7
      ThinPrint "JUNGLE.CFG FILE IS AVAILABLE, YOU CAN HEAR SOUND EFFECTS.", 35, 353, 8, 10, 2, 7
      Entra$ = ThinInput("DO YOU WANT TO ENABLE SOUND EFFECTS? ", 130, 383, 8, 10, 2, 7, 0, 1)
      IF Entra$ = "Y" THEN SndActive = -1 ELSE SndActive = 0
      OPEN "JUNGLE.CFG" FOR BINARY ACCESS WRITE AS #1
         PUT #1, , GameSpeed
         PUT #1, , SndActive
      CLOSE #1
      LINE (0, 464)-(639, 479), 8, BF
      LINE (0, 20)-(639, 459), 0, BF
   ELSEIF MainOpt = 9 OR MainOpt = 0 THEN
      Entra$ = ThinInput("ARE YOU SURE YOU WANT TO QUIT? ", 1, 465, 6, 13, 2, 15, 8, 1)
      IF Entra$ = "Y" THEN
         LINE (0, 464)-(639, 479), 8, BF
         EXIT DO
      END IF
      LINE (0, 464)-(639, 479), 8, BF
      IF MainOpt = 0 THEN MainOpt = 9
   END IF
LOOP

END SUB

SUB Menu (MaxOpts, Opcion, Lista() AS STRING)

Start = 240 - (((MaxOpts + 2) * 35) \ 2)

FOR Muestra = 1 TO MaxOpts
   PosX = 320 - (LEN(Lista(Muestra)) * 20) \ 2
   ThinPrint Lista(Muestra), PosX, (Muestra * 35) + Start, 18, 20, 2, 7
NEXT Muestra

PosX = 320 - (LEN(Lista(Opcion)) * 20) \ 2
ThinPrint Lista(Opcion), PosX, (Opcion * 35) + Start, 18, 20, 2, 15

DO

   SELECT CASE INKEY$
      CASE CHR$(0) + "H"
         IF Opcion > 1 THEN
            PosX = 320 - (LEN(Lista(Opcion)) * 20) \ 2
            ThinPrint Lista(Opcion), PosX, (Opcion * 35) + Start, 18, 20, 2, 7
            Opcion = Opcion - 1
            PosX = 320 - (LEN(Lista(Opcion)) * 20) \ 2
            ThinPrint Lista(Opcion), PosX, (Opcion * 35) + Start, 18, 20, 2, 15
         END IF
         IF SndAvail AND SndActive THEN PlayFX 3
      CASE CHR$(0) + "P"
         IF Opcion < MaxOpts THEN
            PosX = 320 - (LEN(Lista(Opcion)) * 20) \ 2
            ThinPrint Lista(Opcion), PosX, (Opcion * 35) + Start, 18, 20, 2, 7
            Opcion = Opcion + 1
            PosX = 320 - (LEN(Lista(Opcion)) * 20) \ 2
            ThinPrint Lista(Opcion), PosX, (Opcion * 35) + Start, 18, 20, 2, 15
         END IF
         IF SndAvail AND SndActive THEN PlayFX 3
      CASE CHR$(27)
         Opcion = 0
         IF SndAvail AND SndActive THEN PlayFX 4
         EXIT DO
      CASE CHR$(13)
         IF SndAvail AND SndActive THEN PlayFX 2
         EXIT DO
   END SELECT

LOOP
END SUB

SUB Move (Dir)
FOR PosX = 9 TO 0 STEP -1
SELECT CASE Dir
CASE 1
   PUT (GuyX * 10, (GuyY * 10) + PosX), GfxGuy, PSET
   LINE (GuyX * 10, (GuyY * 10) + PosX + 10)-((GuyX * 10) + 9, (GuyY * 10) + PosX + 10), 0
CASE 2
   PUT ((GuyX * 10) + PosX, GuyY * 10), GfxGuy, PSET
   LINE ((GuyX * 10) + PosX + 10, GuyY * 10)-((GuyX * 10) + PosX + 10, (GuyY * 10) + 9), 0
CASE 3
   PUT ((GuyX * 10) - PosX, GuyY * 10), GfxGuy, PSET
   LINE ((GuyX * 10) - PosX - 1, GuyY * 10)-((GuyX * 10) - PosX - 1, (GuyY * 10) + 9), 0
CASE 4
   PUT (GuyX * 10, (GuyY * 10) - PosX), GfxGuy, PSET
   LINE (GuyX * 10, (GuyY * 10) - PosX - 1)-((GuyX * 10) + 9, (GuyY * 10) - PosX - 1), 0
END SELECT
I$ = INKEY$
FOR Delay = 0 TO GameSpeed: I$ = INKEY$: NEXT Delay
NEXT PosX
END SUB

FUNCTION PAD$ (Numero%, Cantid%, Codigo%)
PAD = STRING$(Cantid% - LEN(LTRIM$(RTRIM$(STR$(Numero%)))), Codigo%) + LTRIM$(RTRIM$(STR$(Numero%)))
END FUNCTION

SUB PlayFX (Num)
FOR I = 1 TO 15
  OUT &H388, ASC(MID$(Snd(Num), (I * 2) - 1, 1))
  FOR ii = 1 TO 6: temp = INP(&H388): NEXT ii
  OUT &H389, ASC(MID$(Snd(Num), (I * 2)))
  FOR ii = 1 TO 35: temp = INP(&H388): NEXT ii
NEXT I
END SUB

FUNCTION PlayGame

DIM T1 AS LONG, T2 AS LONG

T1 = TIMER

DO
   I$ = ""
   WHILE I$ = ""
      I$ = INKEY$
      T2 = TIMER
      IF T2 > T1 THEN
         T1 = T2
         GuyT = GuyT + 1
         GuyS = GuyS - 1
         IF GuyT MOD 5 = 0 THEN
            GuyL = GuyL - 1
            GuyS = GuyS - Skill
            LINE (280, 1)-(304, 14), 8, BF
            ThinPrint PAD(GuyL, 3, 32), 280, 1, 6, 13, 2, 15
         END IF
         LINE (152, 1)-(200, 14), 8, BF
         ThinPrint PAD(GuyS, 6, 32), 152, 1, 6, 13, 2, 15
         LINE (520, 1)-(544, 14), 8, BF
         ThinPrint PAD(GuyT, 3, 32), 520, 1, 6, 13, 2, 15
      END IF
   WEND
   SELECT CASE I$
   CASE CHR$(0) + "H"
      IF GuyY > 2 THEN CheckMap GuyX, GuyY - 1, 1
   CASE CHR$(0) + "K"
      IF GuyX > 0 THEN CheckMap GuyX - 1, GuyY, 2
   CASE CHR$(0) + "M"
      IF GuyX < 63 THEN CheckMap GuyX + 1, GuyY, 3
   CASE CHR$(0) + "P"
      IF GuyY < 47 THEN CheckMap GuyX, GuyY + 1, 4
   CASE CHR$(27)
      PlayGame = 2
      EXIT DO
   END SELECT
   IF GuyG = MaxGems THEN PlayGame = 1: EXIT DO
   IF GuyL = 0 THEN PlayGame = 0: EXIT DO
LOOP
END FUNCTION

SUB RestoreMap
 
PUT (GuyX * 10, GuyY * 10), GfxGuy, PSET

LINE (0, 0)-(639, 15), 8, BF
ThinPrint "SCORE: " + PAD(GuyS, 6, 32) + "    LIVE: " + PAD(GuyL, 3, 32) + "   GEMS: " + PAD(GuyG, 2, 32) + " OF " + STR$(MaxGems) + "   TIME: " + PAD(GuyT, 3, 32), 96, 1, 6, 13, 2, 15

FOR PosX = 0 TO 63
   FOR PosY = 2 TO 47
      SELECT CASE GameMap(PosX, PosY)
      CASE 1: PUT (PosX * 10, PosY * 10), GfxBush, PSET
      CASE 2: PUT (PosX * 10, PosY * 10), GfxGems, PSET
      CASE 3: PUT (PosX * 10, PosY * 10), GfxTree, PSET
      CASE 4: PUT (PosX * 10, PosY * 10), GfxSpike, PSET
      END SELECT
      I$ = INKEY$
   NEXT PosY
NEXT PosX
END SUB

SUB SaveFile
   DIM Byte AS STRING * 1
   ThinPrint "SELECT FILE TO SAVE OR PRESS ESC TO ABORT", 1, 465, 6, 13, 2, 15
   Archivo = SelectFile
   LINE (0, 464)-(639, 479), 8, BF
   IF Archivo = 20 THEN
      LINE (0, 20)-(639, 459), 0, BF
      EXIT SUB
   END IF
   Guarda$ = "Y"
   IF Archivo < 10 THEN
      Guarda$ = ThinInput("FILE ALREADY EXISTS. OVERWRITE? ", 1, 465, 6, 13, 2, 15, 8, 1)
      IF Guarda$ = "Y" THEN KILL "JUNGLE.SV" + LTRIM$(RTRIM$(STR$(Archivo)))
      LINE (0, 464)-(639, 479), 8, BF
   ELSE
      Archivo = Archivo - 10
   END IF
   IF Guarda$ = "Y" THEN
      ThinPrint "ENTER A 30-CHARACTER DESCRIPTION FOR THE FILE", 1, 465, 6, 13, 2, 15
      Descrip$ = ""
      WHILE Descrip$ = ""
      LINE (20, (Archivo * 35) + 65)-(619, (Archivo * 35) + 85), 0, BF
      Descrip$ = ThinInput("", 20, (Archivo * 35) + 65, 18, 20, 2, 15, 0, 30)
      WEND
      LINE (0, 464)-(639, 479), 8, BF
      ThinPrint "PLEASE WAIT...", 1, 465, 6, 13, 2, 15
      OPEN "JUNGLE.SV" + LTRIM$(RTRIM$(STR$(Archivo))) FOR BINARY ACCESS WRITE AS #1
         Info$ = Descrip$ + STRING$(30 - LEN(Descrip$), 32)
         PUT #1, , Info$
         PUT #1, , Skill
         PUT #1, , MaxGems
         PUT #1, , GuyX
         PUT #1, , GuyY
         PUT #1, , GuyL
         PUT #1, , GuyG
         PUT #1, , GuyS
         PUT #1, , GuyT
         FOR PosX = 0 TO 63
            FOR PosY = 2 TO 47
               Byte = CHR$(GameMap(PosX, PosY))
               PUT #1, , Byte
            NEXT PosY
         NEXT PosX
      CLOSE #1
      LINE (0, 464)-(639, 479), 8, BF
   END IF
   LINE (0, 20)-(639, 459), 0, BF
END SUB

FUNCTION SelectFile
DIM Descrip(1 TO 10) AS STRING
LINE (0, 20)-(639, 459), 0, BF
FOR Mostrar = 1 TO 10
   OPEN "JUNGLE.SV" + LTRIM$(RTRIM$(STR$(Mostrar - 1))) FOR BINARY ACCESS READ AS #1
   IF LOF(1) <> 2990 THEN
      CLOSE #1
      KILL "JUNGLE.SV" + LTRIM$(RTRIM$(STR$(Mostrar - 1)))
      Descrip(Mostrar) = STRING$(30, 95)
   ELSE
      Descrip(Mostrar) = INPUT$(30, 1)
      CLOSE #1
   ELSE
   END IF
NEXT Mostrar
SelFile = 1
Menu 10, SelFile, Descrip()
IF SelFile = 0 THEN
   SelectFile = 20
ELSEIF Descrip(SelFile) = STRING$(30, 95) THEN
   SelectFile = SelFile + 9
ELSE
   SelectFile = SelFile - 1
END IF
END FUNCTION

SUB SetPos (PosX, PosY)
DO
   IF GuyX = PosX AND GuyY = PosY THEN EXIT DO
   IF GuyX > PosX THEN
      GuyX = GuyX - 1
      Dir = 2
   ELSEIF GuyX < PosX THEN
      GuyX = GuyX + 1
      Dir = 3
   ELSEIF GuyY > PosY THEN
      GuyY = GuyY - 1
      Dir = 1
   ELSEIF GuyY < PosY THEN
      GuyY = GuyY + 1
      Dir = 4
   END IF
   Move Dir
   I$ = INKEY$
LOOP
END SUB

FUNCTION ThinInput$ (Cadena$, PosX, PosY, SizeX, SizeY, Spce, Clr, Bck, Max)
IF Cadena$ <> "" THEN ThinPrint Cadena$, PosX, PosY, SizeX, SizeY, Spce, Clr
TmpString$ = ""
DO
TmpKey$ = UCASE$(INPUT$(1))
SELECT CASE TmpKey$
CASE CHR$(32) TO CHR$(96)
IF Max > 0 THEN
IF LEN(TmpString$) < Max THEN
TmpString$ = TmpString$ + TmpKey$
ThinPrint TmpKey$, PosX, PosY, SizeX, SizeY, Spce, Clr
END IF
ELSE
TmpString$ = TmpString$ + TmpKey$
ThinPrint TmpKey$, PosX, PosY, SizeX, SizeY, Spce, Clr
END IF
CASE CHR$(8)
IF TmpString$ <> "" THEN
PosX = PosX - SizeX - Spce
LINE (PosX, PosY)-(PosX + SizeX, PosY + SizeY), Bck, BF
TmpString$ = LEFT$(TmpString$, LEN(TmpString$) - 1)
END IF
CASE CHR$(13)
ThinInput$ = TmpString$
EXIT DO
CASE CHR$(27)
ThinInput$ = ""
EXIT DO
END SELECT
LOOP
END FUNCTION

SUB ThinPrint (Text$, PosX, PosY, SizeX, SizeY, Spce, Clr)
FOR Char = 1 TO LEN(Text$)
SELECT CASE MID$(Text$, Char, 1)
CASE "!"
LINE (PosX + (SizeX * .5), PosY)-(PosX + (SizeX * .5), PosY + (SizeY * .7)), Clr
LINE (PosX + (SizeX * .4), PosY + (SizeY * .9))-(PosX + (SizeX * .5), PosY + SizeY), Clr
LINE -(PosX + (SizeX * .6), PosY + (SizeY * .9)), Clr
LINE -(PosX + (SizeX * .5), PosY + (SizeY * .8)), Clr
LINE -(PosX + (SizeX * .4), PosY + (SizeY * .9)), Clr
CASE CHR$(34)
LINE (PosX + (SizeX * .3), PosY)-(PosX + (SizeX * .3), PosY + (SizeY * .3)), Clr
LINE (PosX + (SizeX * .7), PosY)-(PosX + (SizeX * .7), PosY + (SizeY * .3)), Clr
CASE "#"
LINE (PosX + (SizeX * .3), PosY)-(PosX + (SizeX * .3), PosY + SizeY), Clr
LINE (PosX + (SizeX * .7), PosY)-(PosX + (SizeX * .7), PosY + SizeY), Clr
LINE (PosX, PosY + (SizeY * .3))-(PosX + SizeX, PosY + (SizeY * .3)), Clr
LINE (PosX, PosY + (SizeY * .7))-(PosX + SizeX, PosY + (SizeY * .7)), Clr
CASE "$"
LINE (PosX + (SizeX * .3), PosY)-(PosX + (SizeX * .3), PosY + SizeY), Clr
LINE (PosX + (SizeX * .7), PosY)-(PosX + (SizeX * .7), PosY + SizeY), Clr
LINE (PosX + SizeX, PosY + (SizeY * .2))-(PosX + (SizeX * .1), PosY + (SizeY * .2)), Clr
LINE -(PosX, PosY + (SizeY * .4)), Clr
LINE -(PosX + (SizeX * .1), PosY + (SizeY * .5)), Clr
LINE -(PosX + (SizeX * .8), PosY + (SizeY * .5)), Clr
LINE -(PosX + (SizeX * .9), PosY + (SizeY * .5)), Clr
LINE -(PosX + SizeX, PosY + (SizeY * .6)), Clr
LINE -(PosX + SizeX, PosY + (SizeY * .7)), Clr
LINE -(PosX + (SizeX * .9), PosY + (SizeY * .8)), Clr
LINE -(PosX, PosY + (SizeY * .8)), Clr
CASE "%"
LINE (PosX + SizeX, PosY)-(PosX, PosY + SizeY), Clr
LINE (PosX + (SizeX * .8), PosY + (SizeY * .8))-(PosX + (SizeX * .7), PosY + (SizeY * .9)), Clr
LINE -(PosX + (SizeX * .8), PosY + SizeY), Clr
LINE -(PosX + (SizeX * .9), PosY + (SizeY * .9)), Clr
LINE -(PosX + (SizeX * .8), PosY + (SizeY * .8)), Clr
LINE (PosX + (SizeX * .2), PosY)-(PosX + (SizeX * .1), PosY + (SizeY * .1)), Clr
LINE -(PosX + (SizeX * .2), PosY + (SizeY * .2)), Clr
LINE -(PosX + (SizeX * .3), PosY + (SizeY * .1)), Clr
LINE -(PosX + (SizeX * .2), PosY), Clr
CASE "&"
LINE (PosX + SizeX, PosY + SizeY)-(PosX + (SizeX * .3), PosY + (SizeY * .3)), Clr
LINE -(PosX + (SizeX * .3), PosY + (SizeY * .1)), Clr
LINE -(PosX + (SizeX * .4), PosY), Clr
LINE -(PosX + (SizeX * .6), PosY), Clr
LINE -(PosX + (SizeX * .7), PosY + (SizeY * .1)), Clr
LINE -(PosX + (SizeX * .7), PosY + (SizeY * .3)), Clr
LINE -(PosX + (SizeX * .1), PosY + (SizeY * .6)), Clr
LINE -(PosX, PosY + (SizeY * .7)), Clr
LINE -(PosX, PosY + (SizeY * .9)), Clr
LINE -(PosX + (SizeX * .1), PosY + SizeY), Clr
LINE -(PosX + (SizeX * .7), PosY + SizeY), Clr
LINE -(PosX + SizeX, PosY + (SizeY * .7)), Clr
CASE "'"
LINE (PosX + (SizeX * .6), PosY)-(PosX + (SizeX * .4), PosY + (SizeY * .2)), Clr
CASE "("
LINE (PosX + (SizeX * .7), PosY)-(PosX + (SizeX * .5), PosY), Clr
LINE -(PosX + (SizeX * .3), PosY + (SizeY * .2)), Clr
LINE -(PosX + (SizeX * .3), PosY + (SizeY * .8)), Clr
LINE -(PosX + (SizeX * .5), PosY + SizeY), Clr
LINE -(PosX + (SizeX * .7), PosY + SizeY), Clr
CASE ")"
LINE (PosX + (SizeX * .3), PosY)-(PosX + (SizeX * .5), PosY), Clr
LINE -(PosX + (SizeX * .7), PosY + (SizeY * .2)), Clr
LINE -(PosX + (SizeX * .7), PosY + (SizeY * .8)), Clr
LINE -(PosX + (SizeX * .5), PosY + SizeY), Clr
LINE -(PosX + (SizeX * .3), PosY + SizeY), Clr
CASE "*"
LINE (PosX + (SizeX * .5), PosY)-(PosX + (SizeX * .5), PosY + SizeY), Clr
LINE (PosX, PosY + (SizeY * .5))-(PosX + SizeX, PosY + (SizeY * .5)), Clr
LINE (PosX, PosY)-(PosX + SizeX, PosY + SizeY), Clr
LINE (PosX + SizeX, PosY)-(PosX, PosY + SizeY), Clr
CASE "+"
LINE (PosX + (SizeX * .5), PosY)-(PosX + (SizeX * .5), PosY + SizeY), Clr
LINE (PosX, PosY + (SizeY * .5))-(PosX + SizeX, PosY + (SizeY * .5)), Clr
CASE ","
LINE (PosX + (SizeX * .6), PosY + (SizeY * .8))-(PosX + (SizeX * .4), PosY + SizeY), Clr
CASE "-"
LINE (PosX, PosY + (SizeY * .5))-(PosX + SizeX, PosY + (SizeY * .5)), Clr
CASE "."
LINE (PosX + (SizeX * .4), PosY + (SizeY * .9))-(PosX + (SizeX * .5), PosY + SizeY), Clr
LINE -(PosX + (SizeX * .6), PosY + (SizeY * .9)), Clr
LINE -(PosX + (SizeX * .5), PosY + (SizeY * .8)), Clr
LINE -(PosX + (SizeX * .4), PosY + (SizeY * .9)), Clr
CASE "/"
LINE (PosX + SizeX, PosY)-(PosX, PosY + SizeY), Clr
CASE "0"
LINE (PosX + (SizeX * .2), PosY)-(PosX + (SizeX * .8), PosY), Clr
LINE -(PosX + SizeX, PosY + (SizeY * .2)), Clr
LINE -(PosX + SizeX, PosY + (SizeY * .8)), Clr
LINE -(PosX + (SizeX * .8), PosY + SizeY), Clr
LINE -(PosX + (SizeX * .2), PosY + SizeY), Clr
LINE -(PosX, PosY + (SizeY * .8)), Clr
LINE -(PosX, PosY + (SizeY * .2)), Clr
LINE -(PosX + (SizeX * .2), PosY), Clr
LINE (PosX + SizeX, PosY)-(PosX, PosY + SizeY), Clr
CASE "1"
LINE (PosX + SizeX, PosY + SizeY)-(PosX + SizeX, PosY), Clr
LINE -(PosX, PosY + (SizeY * .5)), Clr
CASE "2"
LINE (PosX, PosY)-(PosX + (SizeX * .8), PosY), Clr
LINE -(PosX + SizeX, PosY + (SizeY * .2)), Clr
LINE -(PosX + SizeX, PosY + (SizeY * .3)), Clr
LINE -(PosX + (SizeX * .8), PosY + (SizeY * .5)), Clr
LINE -(PosX + (SizeX * .2), PosY + (SizeY * .5)), Clr
LINE -(PosX, PosY + (SizeY * .7)), Clr
LINE -(PosX, PosY + SizeY), Clr
LINE -(PosX + SizeX, PosY + SizeY), Clr
CASE "3"
LINE (PosX, PosY)-(PosX + (SizeX * .8), PosY), Clr
LINE -(PosX + SizeX, PosY + (SizeY * .2)), Clr
LINE -(PosX + SizeX, PosY + (SizeY * .3)), Clr
LINE -(PosX + (SizeX * .8), PosY + (SizeY * .5)), Clr
LINE -(PosX + (SizeX * .2), PosY + (SizeY * .5)), Clr
LINE (PosX + (SizeX * .8), PosY + (SizeY * .5))-(PosX + SizeX, PosY + (SizeY * .7)), Clr
LINE -(PosX + SizeX, PosY + (SizeY * .8)), Clr
LINE -(PosX + (SizeX * .8), PosY + SizeY), Clr
LINE -(PosX, PosY + SizeY), Clr
CASE "4"
LINE (PosX + (SizeX * .2), PosY)-(PosX, PosY + (SizeY * .5)), Clr
LINE -(PosX + SizeX, PosY + (SizeY * .5)), Clr
LINE (PosX + SizeX, PosY)-(PosX + SizeX, PosY + SizeY), Clr
CASE "5"
LINE (PosX + SizeX, PosY)-(PosX, PosY), Clr
LINE -(PosX, PosY + (SizeY * .5)), Clr
LINE -(PosX + (SizeX * .8), PosY + (SizeY * .5)), Clr
LINE -(PosX + SizeX, PosY + (SizeY * .7)), Clr
LINE -(PosX + SizeX, PosY + (SizeY * .8)), Clr
LINE -(PosX + (SizeX * .8), PosY + SizeY), Clr
LINE -(PosX, PosY + SizeY), Clr
CASE "6"
LINE (PosX + SizeX, PosY)-(PosX + (SizeX * .2), PosY), Clr
LINE -(PosX, PosY + (SizeY * .2)), Clr
LINE -(PosX, PosY + (SizeY * .8)), Clr
LINE -(PosX + (SizeX * .2), PosY + SizeY), Clr
LINE -(PosX + (SizeX * .8), PosY + SizeY), Clr
LINE -(PosX + SizeX, PosY + (SizeY * .8)), Clr
LINE -(PosX + SizeX, PosY + (SizeY * .7)), Clr
LINE -(PosX + (SizeX * .8), PosY + (SizeY * .5)), Clr
LINE -(PosX + (SizeX * .2), PosY + (SizeY * .5)), Clr
LINE -(PosX, PosY + (SizeY * .7)), Clr
CASE "7"
LINE (PosX, PosY)-(PosX + SizeX, PosY), Clr
LINE -(PosX, PosY + SizeY), Clr
CASE "8"
LINE (PosX + (SizeX * .2), PosY + (SizeY * .5))-(PosX + (SizeX * .8), PosY + (SizeY * .5)), Clr
LINE -(PosX + SizeX, PosY + (SizeY * .3)), Clr
LINE -(PosX + SizeX, PosY + (SizeY * .2)), Clr
LINE -(PosX + (SizeX * .8), PosY), Clr
LINE -(PosX + (SizeX * .2), PosY), Clr
LINE -(PosX, PosY + (SizeY * .2)), Clr
LINE -(PosX, PosY + (SizeY * .3)), Clr
LINE -(PosX + (SizeX * .2), PosY + (SizeY * .5)), Clr
LINE -(PosX, PosY + (SizeY * .7)), Clr
LINE -(PosX, PosY + (SizeY * .8)), Clr
LINE -(PosX + (SizeX * .2), PosY + SizeY), Clr
LINE -(PosX + (SizeX * .8), PosY + SizeY), Clr
LINE -(PosX + SizeX, PosY + (SizeY * .8)), Clr
LINE -(PosX + SizeX, PosY + (SizeY * .7)), Clr
LINE -(PosX + (SizeX * .8), PosY + (SizeY * .5)), Clr
CASE "9"
LINE (PosX + SizeX, PosY + (SizeY * .5))-(PosX + (SizeX * .2), PosY + (SizeY * .5)), Clr
LINE -(PosX, PosY + (SizeY * .3)), Clr
LINE -(PosX, PosY + (SizeY * .2)), Clr
LINE -(PosX + (SizeX * .2), PosY), Clr
LINE -(PosX + (SizeX * .8), PosY), Clr
LINE -(PosX + SizeX, PosY + (SizeY * .2)), Clr
LINE -(PosX + SizeX, PosY + (SizeY * .8)), Clr
LINE -(PosX + (SizeX * .8), PosY + SizeY), Clr
LINE -(PosX, PosY + SizeY), Clr
CASE ":"
LINE (PosX + (SizeX * .5), PosY + (SizeY * .8))-(PosX + (SizeX * .4), PosY + (SizeY * .9)), Clr
LINE -(PosX + (SizeX * .5), PosY + SizeY), Clr
LINE -(PosX + (SizeX * .6), PosY + (SizeY * .9)), Clr
LINE -(PosX + (SizeX * .5), PosY + (SizeY * .8)), Clr
LINE (PosX + (SizeX * .5), PosY)-(PosX + (SizeX * .4), PosY + (SizeY * .1)), Clr
LINE -(PosX + (SizeX * .5), PosY + (SizeY * .2)), Clr
LINE -(PosX + (SizeX * .6), PosY + (SizeY * .1)), Clr
LINE -(PosX + (SizeX * .5), PosY), Clr
CASE ";"
LINE (PosX + (SizeX * .5), PosY)-(PosX + (SizeX * .4), PosY + (SizeY * .1)), Clr
LINE -(PosX + (SizeX * .5), PosY + (SizeY * .2)), Clr
LINE -(PosX + (SizeX * .6), PosY + (SizeY * .1)), Clr
LINE -(PosX + (SizeX * .5), PosY), Clr
LINE (PosX + (SizeX * .6), PosY + (SizeY * .8))-(PosX + (SizeX * .4), PosY + SizeY), Clr
CASE "<"
LINE (PosX + SizeX, PosY)-(PosX, PosY + (SizeY * .5)), Clr
LINE -(PosX + SizeX, PosY + SizeY), Clr
CASE "="
LINE (PosX, PosY + (SizeY * .3))-(PosX + SizeX, PosY + (SizeY * .3)), Clr
LINE (PosX, PosY + (SizeY * .7))-(PosX + SizeX, PosY + (SizeY * .7)), Clr
CASE ">"
LINE (PosX, PosY)-(PosX + SizeX, PosY + (SizeY * .5)), Clr
LINE -(PosX, PosY + SizeY), Clr
CASE "?"
LINE (PosX, PosY + (SizeY * .2))-(PosX + (SizeX * .2), PosY), Clr
LINE -(PosX + (SizeX * .8), PosY), Clr
LINE -(PosX + SizeX, PosY + (SizeY * .2)), Clr
LINE -(PosX + SizeX, PosY + (SizeY * .3)), Clr
LINE -(PosX + (SizeX * .8), PosY + (SizeY * .5)), Clr
LINE -(PosX + (SizeX * .5), PosY + (SizeY * .5)), Clr
LINE -(PosX + (SizeX * .5), PosY + (SizeY * .7)), Clr
LINE (PosX + (SizeX * .4), PosY + (SizeY * .9))-(PosX + (SizeX * .5), PosY + SizeY), Clr
LINE -(PosX + (SizeX * .6), PosY + (SizeY * .9)), Clr
LINE -(PosX + (SizeX * .5), PosY + (SizeY * .8)), Clr
LINE -(PosX + (SizeX * .4), PosY + (SizeY * .9)), Clr
CASE "@"
LINE (PosX + SizeX, PosY + SizeY)-(PosX + (SizeX * .2), PosY + SizeY), Clr
LINE -(PosX, PosY + (SizeY * .8)), Clr
LINE -(PosX, PosY + (SizeY * .2)), Clr
LINE -(PosX + (SizeX * .2), PosY), Clr
LINE -(PosX + (SizeX * .8), PosY), Clr
LINE -(PosX + SizeX, PosY + (SizeY * .2)), Clr
LINE -(PosX + SizeX, PosY + (SizeY * .7)), Clr
LINE -(PosX + (SizeX * .4), PosY + (SizeY * .7)), Clr
LINE -(PosX + (SizeX * .3), PosY + (SizeY * .6)), Clr
LINE -(PosX + (SizeX * .3), PosY + (SizeY * .4)), Clr
LINE -(PosX + (SizeX * .4), PosY + (SizeY * .3)), Clr
LINE -(PosX + (SizeX * .6), PosY + (SizeY * .3)), Clr
LINE -(PosX + (SizeX * .7), PosY + (SizeY * .4)), Clr
LINE -(PosX + (SizeX * .7), PosY + (SizeY * .7)), Clr
CASE "A"
LINE (PosX, PosY + SizeY)-(PosX, PosY + (SizeY * .2)), Clr
LINE -(PosX + (SizeX * .2), PosY), Clr
LINE -(PosX + (SizeX * .8), PosY), Clr
LINE -(PosX + SizeX, PosY + (SizeY * .2)), Clr
LINE -(PosX + SizeX, PosY + SizeY), Clr
LINE (PosX, PosY + (SizeY * .5))-(PosX + SizeX, PosY + (SizeY * .5)), Clr
CASE "B"
LINE (PosX + (SizeX * .8), PosY + (SizeY * .5))-(PosX + SizeX, PosY + (SizeY * .7)), Clr
LINE -(PosX + SizeX, PosY + (SizeY * .8)), Clr
LINE -(PosX + (SizeX * .8), PosY + SizeY), Clr
LINE -(PosX, PosY + SizeY), Clr
LINE -(PosX, PosY), Clr
LINE -(PosX + (SizeX * .8), PosY), Clr
LINE -(PosX + SizeX, PosY + (SizeY * .2)), Clr
LINE -(PosX + SizeX, PosY + (SizeY * .3)), Clr
LINE -(PosX + (SizeX * .8), PosY + (SizeY * .5)), Clr
LINE -(PosX, PosY + (SizeY * .5)), Clr
CASE "C"
LINE (PosX + SizeX, PosY)-(PosX + (SizeX * .2), PosY), Clr
LINE -(PosX, PosY + (SizeY * .2)), Clr
LINE -(PosX, PosY + (SizeY * .8)), Clr
LINE -(PosX + (SizeX * .2), PosY + SizeY), Clr
LINE -(PosX + SizeX, PosY + SizeY), Clr
CASE "D"
LINE (PosX, PosY + SizeY)-(PosX, PosY), Clr
LINE -(PosX + (SizeX * .8), PosY), Clr
LINE -(PosX + SizeX, PosY + (SizeY * .2)), Clr
LINE -(PosX + SizeX, PosY + (SizeY * .8)), Clr
LINE -(PosX + (SizeX * .8), PosY + SizeY), Clr
LINE -(PosX, PosY + SizeY), Clr
CASE "E"
LINE (PosX + SizeX, PosY)-(PosX, PosY), Clr
LINE -(PosX, PosY + SizeY), Clr
LINE -(PosX + SizeX, PosY + SizeY), Clr
LINE (PosX, PosY + (SizeY * .5))-(PosX + (SizeX * .5), PosY + (SizeY * .5)), Clr
CASE "F"
LINE (PosX + SizeX, PosY)-(PosX, PosY), Clr
LINE -(PosX, PosY + SizeY), Clr
LINE (PosX + (SizeX * .5), PosY + (SizeY * .5))-(PosX, PosY + (SizeY * .5)), Clr
CASE "G"
LINE (PosX + SizeX, PosY)-(PosX + (SizeX * .2), PosY), Clr
LINE -(PosX, PosY + (SizeY * .2)), Clr
LINE -(PosX, PosY + (SizeY * .8)), Clr
LINE -(PosX + (SizeX * .2), PosY + SizeY), Clr
LINE -(PosX + SizeX, PosY + SizeY), Clr
LINE -(PosX + SizeX, PosY + (SizeY * .5)), Clr
LINE -(PosX, PosY + (SizeY * .5)), Clr
CASE "H"
LINE (PosX, PosY)-(PosX, PosY + SizeY), Clr
LINE (PosX + SizeX, PosY)-(PosX + SizeX, PosY + SizeY), Clr
LINE (PosX, PosY + (SizeY * .5))-(PosX + SizeX, PosY + (SizeY * .5)), Clr
CASE "I"
LINE (PosX, PosY)-(PosX + SizeX, PosY), Clr
LINE (PosX, PosY + SizeY)-(PosX + SizeX, PosY + SizeY), Clr
LINE (PosX + (SizeX * .5), PosY)-(PosX + (SizeX * .5), PosY + SizeY), Clr
CASE "J"
LINE (PosX + (SizeX * .5), PosY)-(PosX + SizeX, PosY), Clr
LINE -(PosX + SizeX, PosY + (SizeY * .8)), Clr
LINE -(PosX + (SizeX * .8), PosY + SizeY), Clr
LINE -(PosX + (SizeX * .2), PosY + SizeY), Clr
LINE -(PosX, PosY + (SizeY * .8)), Clr
LINE -(PosX, PosY + (SizeY * .5)), Clr
CASE "K"
LINE (PosX, PosY)-(PosX, PosY + SizeY), Clr
LINE (PosX + SizeX, PosY)-(PosX, PosY + (SizeY * .5)), Clr
LINE -(PosX + SizeX, PosY + SizeY), Clr
CASE "L"
LINE (PosX, PosY)-(PosX, PosY + SizeY), Clr
LINE -(PosX + SizeX, PosY + SizeY), Clr
CASE "M"
LINE (PosX, PosY + SizeY)-(PosX, PosY), Clr
LINE -(PosX + (SizeX * .5), PosY + (SizeY * .5)), Clr
LINE -(PosX + SizeX, PosY), Clr
LINE -(PosX + SizeX, PosY + SizeY), Clr
CASE "N"
LINE (PosX, PosY + SizeY)-(PosX, PosY), Clr
LINE -(PosX + SizeX, PosY + SizeY), Clr
LINE -(PosX + SizeX, PosY), Clr
CASE "O"
LINE (PosX, PosY + (SizeY * .2))-(PosX + (SizeX * .2), PosY), Clr
LINE -(PosX + (SizeX * .8), PosY), Clr
LINE -(PosX + SizeX, PosY + (SizeY * .2)), Clr
LINE -(PosX + SizeX, PosY + (SizeY * .8)), Clr
LINE -(PosX + (SizeX * .8), PosY + SizeY), Clr
LINE -(PosX + (SizeX * .2), PosY + SizeY), Clr
LINE -(PosX, PosY + (SizeY * .8)), Clr
LINE -(PosX, PosY + (SizeY * .2)), Clr
CASE "P"
LINE (PosX, PosY + SizeY)-(PosX, PosY), Clr
LINE -(PosX + (SizeX * .8), PosY), Clr
LINE -(PosX + SizeX, PosY + (SizeY * .2)), Clr
LINE -(PosX + SizeX, PosY + (SizeY * .3)), Clr
LINE -(PosX + (SizeX * .8), PosY + (SizeY * .5)), Clr
LINE -(PosX, PosY + (SizeY * .5)), Clr
CASE "Q"
LINE (PosX, PosY + (SizeY * .2))-(PosX + (SizeX * .2), PosY), Clr
LINE -(PosX + (SizeX * .8), PosY), Clr
LINE -(PosX + SizeX, PosY + (SizeY * .2)), Clr
LINE -(PosX + SizeX, PosY + (SizeY * .8)), Clr
LINE -(PosX + (SizeX * .8), PosY + SizeY), Clr
LINE -(PosX + (SizeX * .2), PosY + SizeY), Clr
LINE -(PosX, PosY + (SizeY * .8)), Clr
LINE -(PosX, PosY + (SizeY * .2)), Clr
LINE (PosX + SizeX, PosY + SizeY)-(PosX + (SizeX * .7), PosY + (SizeY * .7)), Clr
CASE "R"
LINE (PosX, PosY + SizeY)-(PosX, PosY), Clr
LINE -(PosX + (SizeX * .8), PosY), Clr
LINE -(PosX + SizeX, PosY + (SizeY * .2)), Clr
LINE -(PosX + SizeX, PosY + (SizeY * .3)), Clr
LINE -(PosX + (SizeX * .8), PosY + (SizeY * .5)), Clr
LINE -(PosX, PosY + (SizeY * .5)), Clr
LINE (PosX + (SizeX * .5), PosY + (SizeY * .5))-(PosX + SizeX, PosY + SizeY), Clr
CASE "S"
LINE (PosX + SizeX, PosY)-(PosX + (SizeX * .2), PosY), Clr
LINE -(PosX, PosY + (SizeY * .2)), Clr
LINE -(PosX, PosY + (SizeY * .3)), Clr
LINE -(PosX + (SizeX * .2), PosY + (SizeY * .5)), Clr
LINE -(PosX + (SizeX * .8), PosY + (SizeY * .5)), Clr
LINE -(PosX + SizeX, PosY + (SizeY * .7)), Clr
LINE -(PosX + SizeX, PosY + (SizeY * .8)), Clr
LINE -(PosX + (SizeX * .8), PosY + SizeY), Clr
LINE -(PosX, PosY + SizeY), Clr
CASE "T"
LINE (PosX, PosY)-(PosX + SizeX, PosY), Clr
LINE (PosX + (SizeX * .5), PosY)-(PosX + (SizeX * .5), PosY + SizeY), Clr
CASE "U"
LINE (PosX, PosY)-(PosX, PosY + (SizeY * .8)), Clr
LINE -(PosX + (SizeX * .2), PosY + SizeY), Clr
LINE -(PosX + (SizeX * .8), PosY + SizeY), Clr
LINE -(PosX + SizeX, PosY + (SizeY * .9)), Clr
LINE -(PosX + SizeX, PosY), Clr
CASE "V"
LINE (PosX, PosY)-(PosX + (SizeX * .5), PosY + SizeY), Clr
LINE -(PosX + SizeX, PosY), Clr
CASE "W"
LINE (PosX, PosY)-(PosX + (SizeX * .2), PosY + SizeY), Clr
LINE -(PosX + (SizeX * .5), PosY + (SizeY * .6)), Clr
LINE -(PosX + (SizeX * .8), PosY + SizeY), Clr
LINE -(PosX + SizeX, PosY), Clr
CASE "X"
LINE (PosX, PosY)-(PosX + SizeX, PosY + SizeY), Clr
LINE (PosX + SizeX, PosY)-(PosX, PosY + SizeY), Clr
CASE "Y"
LINE (PosX, PosY)-(PosX + (SizeX * .5), PosY + (SizeY * .5)), Clr
LINE -(PosX + SizeX, PosY), Clr
LINE (PosX + (SizeX * .5), PosY + (SizeY * .5))-(PosX + (SizeX * .5), PosY + SizeY), Clr
CASE "Z"
LINE (PosX, PosY)-(PosX + SizeX, PosY), Clr
LINE -(PosX, PosY + SizeY), Clr
LINE -(PosX + SizeX, PosY + SizeY), Clr
CASE "["
LINE (PosX + (SizeX * .8), PosY)-(PosX + (SizeX * .2), PosY), Clr
LINE -(PosX + (SizeX * .2), PosY + SizeY), Clr
LINE -(PosX + (SizeX * .8), PosY + SizeY), Clr
CASE "\"
LINE (PosX, PosY)-(PosX + SizeX, PosY + SizeY), Clr
CASE "]"
LINE (PosX + (SizeX * .2), PosY)-(PosX + (SizeX * .8), PosY), Clr
LINE -(PosX + (SizeX * .8), PosY + SizeY), Clr
LINE -(PosX + (SizeX * .2), PosY + SizeY), Clr
CASE "^"
LINE (PosX + (SizeX * .2), PosY + (SizeY * .3))-(PosX + (SizeX * .5), PosY), Clr
LINE -(PosX + (SizeX * .8), PosY + (SizeY * .3)), Clr
CASE "_"
LINE (PosX, PosY + SizeY)-(PosX + SizeX, PosY + SizeY), Clr
CASE "`"
LINE (PosX + (SizeX * .4), PosY)-(PosX + (SizeX * .6), PosY + (SizeY * .2)), Clr
END SELECT
PosX = PosX + SizeX + Spce
NEXT Char
END SUB

