DECLARE SUB smallfont (x%, y%, space%, text$)
DEFINT A-Z
'$INCLUDE: 'BWSB.BI'           'Include the subs
'$INCLUDE: 'GDMTYPE.BI'

'               *******************************************
'               **Minesweeper By George Gardiner         **
'               **V1.0                                   **
'               **A CRiTiCAL MASS Production 1998        **
'               **Visit our web site!                    **
'               **http://critical.hypermart.net          **
'               **Load with command line:                **
'               **QB /L MSE_QB                           **
'               **Run in directory files are located!    **
'               **eg. C:\MINESWEP> C:\QB\QB /L MSE_QB    **
'               **If you are still having problems, run  **
'               **the .EXE file!                         **
'               **Make sure you run SETUP.EXE and choose **
'               **your sound card!                       **
'               **shadow@georgeg.force9.co.uk            ** 
'               **Please do not leach any of my code!    **
'               *******************************************


TYPE MSEConfigFile
SoundCard AS INTEGER
BaseIO AS INTEGER
IRQ AS INTEGER
DMA AS INTEGER
SoundQuality AS INTEGER
END TYPE
CLS
PRINT "MineSweeper By George Gardiner"
PRINT "Initilising Music + SFX..."
DIM ModHead         AS GDMHeader
DIM SndDevMSE(6)    AS STRING
DIM MSEConfig       AS MSEConfigFile
Freemem& = FRE(-1) - 80000
a& = SETMEM(-Freemem&)
SndDevMSE(1) = "GUS"                   'Gravis Ultrasound
SndDevMSE(2) = "SB1X"                  'Sound Blaster 1.xx
SndDevMSE(3) = "SB2X"                  'Sound Blaster 2.xx
SndDevMSE(4) = "SBPRO"                 'Sound Blaster Pro
SndDevMSE(5) = "SB16"                  'Sound Blaster 16
SndDevMSE(6) = "PAS"                   'Pro AudioSpectrum 16
OPEN "MSE.CFG" FOR BINARY AS 1
GET 1, , MSEConfig
CLOSE 1
IF MSEConfig.SoundCard = 0 THEN
PRINT "No Sound Selected in SETUP. Please run SETUP."
END
END IF
MSE$ = SndDevMSE(MSEConfig.SoundCard) + ".MSE"
SELECT CASE MSEConfig.SoundQuality
CASE 0: Ov = 16
CASE 1: Ov = 22
CASE 2: Ov = 45
CASE 3: Ov = 8
END SELECT
ErrorFlag = LoadMSE(MSE$, 0, Ov, 4096, MSEConfig.BaseIO, MSEConfig.IRQ, MSEConfig.DMA)
SELECT CASE ErrorFlag
CASE 0
CASE 1: PRINT "Base I/O address autodetection failure": END
CASE 2: PRINT "IRQ level autodetection failure": END
CASE 3: PRINT "DMA channel autodetection failure": END
CASE 4: PRINT "DMA channel not supported": END
CASE 6: PRINT "Sound device does not respond": END
CASE 7: PRINT "Memory control blocks destroyed": END
CASE 8: PRINT "Insufficient memory for mixing buffers": END
CASE 9: PRINT "Insufficient memory for MSE file": END
CASE 10: PRINT "MSE has invalid identification string (corrupt/non-existant)": END
CASE 11: PRINT "MSE disk read failure": END
CASE 12: PRINT "MVSOUND.SYS not loaded (required for PAS use)": END
CASE ELSE: PRINT "Unknown error on MSE startup" + STR$(ErrorFlag): END
END SELECT
'Display the actutal settings *used* in the MSE.
PRINT "Addr: "; HEX$(MSEConfig.BaseIO); "h  ";
PRINT "IRQ:"; MSEConfig.IRQ; " ";
PRINT "DMA:"; MSEConfig.DMA
ModFile$ = "autonom"
TestMOD:
IF LEN(ModFile$) = 0 THEN END
IF INSTR(ModFile$, ".") = 0 THEN ModFile$ = ModFile$ + ".GDM"
IF EmsExist THEN ErrorFlag = 1 ELSE ErrorFlag = 0   'Setup EMS use flag
file = FREEFILE
OPEN ModFile$ FOR BINARY AS file
'Load our module
LoadGDM FILEATTR(file, 2), 0, ErrorFlag, VARSEG(ModHead), VARPTR(ModHead)
SELECT CASE ErrorFlag
CASE 0
CASE 1: PRINT "Module is corrupt": END
CASE 2: PRINT "Could not autodetect module type": END
CASE 3: PRINT "Bad format ID": END
CASE 4: PRINT "Out of memory": END
CASE 5: PRINT "Cannot unpack samples": END
CASE 6: PRINT "AdLib samples not supported": END
CASE ELSE: PRINT "Unknown Load Error:" + STR$(ErrorFlag): END
END SELECT
MusicChannels = 0
FOR J = 1 TO 32
  IF ASC(MID$(ModHead.PanMap, J, 1)) <> &HFF THEN
    MusicChannels = MusicChannels + 1
  END IF
NEXT
OverRate& = StartOutput(MusicChannels + 3, 0)
PRINT "Mixing Rate:"; OverRate&; "Hz"
oldtimer! = TIMER
DO
LOOP UNTIL TIMER >= oldtimer! + 1 OR TIMER < 5


'*Main Code Starts Here*******************************************************
DO
INPUT "Enter number of mines (10 - 300):", a$
mines% = VAL(a$)
LOOP UNTIL mines% >= 10 AND mines% <= 300
SCREEN 13
StartMusic

DIM silentspalette(255, 3)
DIM realpalette!(255, 3)
DIM addtorealpalette!(255, 3)

FOR x% = 0 TO 255
 OUT 968, x%
 OUT 969, 0
 OUT 969, 0
 OUT 969, 0
NEXT
file$ = "CM"
BLOAD file$ + ".GFX"
GOSUB fadeinout

FOR x% = 0 TO 255
 OUT 968, x%
 OUT 969, 0
 OUT 969, 0
 OUT 969, 0
NEXT
file$ = "presents"
BLOAD file$ + ".GFX"
GOSUB fadeinout

FOR x% = 0 TO 255
 OUT 968, x%
 OUT 969, 0
 OUT 969, 0
 OUT 969, 0
NEXT
file$ = "agbgg"
BLOAD file$ + ".GFX"
GOSUB fadeinout

FOR x% = 0 TO 255
 OUT 968, x%
 OUT 969, 0
 OUT 969, 0
 OUT 969, 0
NEXT
file$ = "MINE"
BLOAD file$ + ".GFX"
GOSUB fadeinout

FOR x% = 0 TO 255
 OUT 968, x%
 OUT 969, 0
 OUT 969, 0
 OUT 969, 0
NEXT


RANDOMIZE TIMER

markedmines% = mines%
sx% = 15
sy% = 10

DIM graphicalobject%(64, 15)
DIM clearselect%(64)
DIM gridx%(30, 20)
DIM gridy%(30, 20)
DIM grido%(30, 20)
DIM gridc%(30, 20)
DIM gridm%(30, 20)
nopixels% = 50
DIM pixels!(nopixels%, 7)


GOSUB blackoutpalette
GOSUB loadobjectsintomemory
GOSUB makegrid
CLS
FOR stars% = 1 TO 500
 PSET (INT(RND * 320) + 1, INT(RND * 320) + 1), INT(RND * 16) + 16
NEXT

GOSUB displaygrid

GOSUB getselector
GOSUB drawselector
ot! = TIMER
PUT (38, 12), graphicalobject(0, 14), PSET
PUT (68, 12), graphicalobject(0, 15), PSET
CALL smallfont(0, 0, 1, "MINESWEEPER V1.0 BY GEORGE GARDINER")
CALL smallfont(0, 188, 1, "ARROW KEYS MOVE SELECTOR")
CALL smallfont(0, 194, 1, "SPACE = CLEAR   Z = MARK MINE  X = MARK QUESTION  C = CLEAR AROUND")

PALETTE


DO
WAIT &H3DA, 8
IF oldmarkedmines% <> markedmines% THEN
 COLOR 0
 CALL smallfont(44, 15, 1, STR$(oldmarkedmines%))
 COLOR 4
 CALL smallfont(44, 15, 1, STR$(markedmines%))
 oldmarkedmines% = markedmines%
END IF

IF TIMER >= ot! + 1 THEN
 timetaken = timetaken + 1
 ot! = TIMER
 COLOR 0
 CALL smallfont(74, 15, 1, STR$(timetaken - 1))
 COLOR 4
 CALL smallfont(74, 15, 1, STR$(timetaken))
END IF
key$ = INKEY$
IF key$ <> "" AND key$ <> CHR$(27) THEN GOSUB actonuserinput
LOOP UNTIL key$ = CHR$(27)
FOR colors% = 0 TO 63
FOR fade% = 0 TO 255
 OUT 967, fade%
 Red = INP(969)
 Green = INP(969)
 Blue = INP(969)
 Red = Red - 1
 Green = Green - 1
 Blue = Blue - 1
 IF Red < 0 THEN Red = 0
 IF Green < 0 THEN Green = 0
 IF Blue < 0 THEN Blue = 0
 OUT 968, fade%
 OUT 969, Red
 OUT 969, Green
 OUT 969, Blue
 oldtimer! = TIMER
 DO
 LOOP UNTIL oldtimer! >= .04 OR TIMER < 5
NEXT fade%
NEXT colors%

GOTO ender
'*****************************************************************************

loadobjectsintomemory:
FOR objects% = 1 TO 15
 xwidth% = 8
 yhight% = 8
 object$ = STR$(objects%)
 object$ = LTRIM$(object$)
 GOSUB loadobject
 GET (1, 1)-(8, 8), graphicalobject%(0, objects%)
NEXT
RETURN

loadobject:
OPEN object$ + ".raw" FOR BINARY AS #2
FOR y% = 1 TO yhight%
 FOR x% = 1 TO xwidth%
  colour$ = " "
  GET #2, , colour$
  colour% = ASC(colour$)
  PSET (x%, y%), colour%
 NEXT
NEXT
CLOSE #2
RETURN

blackoutpalette:
FOR x% = 0 TO 255
 OUT 968, x%
 OUT 969, 0
 OUT 969, 0
 OUT 969, 0
NEXT
RETURN

makegrid:
FOR putmine% = 1 TO mines%
pickagain:
 x% = INT(RND * 30) + 1
 y% = INT(RND * 20) + 1
 IF grido%(x%, y%) = 10 THEN GOTO pickagain
 grido%(x%, y%) = 10
NEXT
FOR x% = 1 TO 30
 FOR y% = 1 TO 20
 m% = 0
  o% = grido%(x%, y%)
  IF o% = 10 THEN GOTO isamine
 
  IF x% - 1 > 0 AND y% - 1 > 0 THEN
   o% = grido%(x% - 1, y% - 1)
   IF o% = 10 THEN m% = m% + 1
  END IF

  IF y% - 1 > 0 THEN
   o% = grido%(x%, y% - 1)
   IF o% = 10 THEN m% = m% + 1
  END IF

  IF y% - 1 > 0 AND x% + 1 < 31 THEN
   o% = grido%(x% + 1, y% - 1)
   IF o% = 10 THEN m% = m% + 1
  END IF

  IF x% - 1 > 0 THEN
   o% = grido%(x% - 1, y%)
   IF o% = 10 THEN m% = m% + 1
  END IF

  IF x% + 1 < 31 THEN
   o% = grido%(x% + 1, y%)
   IF o% = 10 THEN m% = m% + 1
  END IF

  IF x% - 1 > 0 AND y% + 1 < 21 THEN
   o% = grido%(x% - 1, y% + 1)
   IF o% = 10 THEN m% = m% + 1
  END IF

  IF y% + 1 < 21 THEN
   o% = grido%(x%, y% + 1)
   IF o% = 10 THEN m% = m% + 1
  END IF

  IF x% + 1 < 31 AND y% + 1 < 21 THEN
   o% = grido%(x% + 1, y% + 1)
   IF o% = 10 THEN m% = m% + 1
  END IF

IF m% = 0 THEN m% = 13
grido%(x%, y%) = m%

isamine:
 gridc%(x%, y%) = 1
 NEXT
NEXT

FOR y% = 20 TO (180 - 8) STEP 8
 gpy% = gpy% + 1
 gpx% = 0
 FOR x% = 40 TO (280 - 8) STEP 8
  gpx% = gpx% + 1
  gridx%(gpx%, gpy%) = x%
  gridy%(gpx%, gpy%) = y%
 NEXT
NEXT
RETURN


displaygrid:
FOR x% = 1 TO 30
 FOR y% = 1 TO 20
  IF gridc%(x%, y%) = 1 THEN PUT (gridx%(x%, y%), gridy%(x%, y%)), graphicalobject%(0, 9), PSET: GOTO covered
  o% = grido%(x%, y%)
  IF o% = 10 THEN GOSUB mine
  PUT (gridx%(x%, y%), gridy%(x%, y%)), graphicalobject%(0, o%), PSET
covered:
  IF gridm%(x%, y%) = 1 THEN PUT (gridx%(x%, y%), gridy%(x%, y%)), graphicalobject%(0, 11), PSET
  IF gridm%(x%, y%) = 2 THEN PUT (gridx%(x%, y%), gridy%(x%, y%)), graphicalobject%(0, 12), PSET
 NEXT
NEXT
RETURN


getselector:
GET (gridx%(sx%, sy%), gridy%(sx%, sy%))-(gridx%(sx%, sy%) + 8, gridy%(sx%, sy%) + 8), clearselect%
RETURN

clearselector:
PUT (gridx%(sx%, sy%), gridy%(sx%, sy%)), clearselect%, PSET
RETURN

drawselector:
LINE (gridx%(sx%, sy%), gridy%(sx%, sy%))-(gridx%(sx%, sy%) + 7, gridy%(sx%, sy%) + 7), 4, B
RETURN

actonuserinput:
GOSUB clearselector
IF key$ = CHR$(0) + "H" THEN sy% = sy% - 1
IF key$ = CHR$(0) + "P" THEN sy% = sy% + 1
IF key$ = CHR$(0) + "K" THEN sx% = sx% - 1
IF key$ = CHR$(0) + "M" THEN sx% = sx% + 1
IF sx% = 31 THEN sx% = 1
IF sx% = 0 THEN sx% = 30
IF sy% = 21 THEN sy% = 1
IF sy% = 0 THEN sy% = 20
IF key$ = " " THEN GOSUB liftsquare
IF key$ = "z" OR key$ = "Z" THEN GOSUB markmine
IF key$ = "x" OR key$ = "X" THEN GOSUB markquestion
IF key$ = "c" OR key$ = "C" THEN GOSUB cleararound

GOSUB getselector
GOSUB drawselector
RETURN

liftsquare:
IF gridc%(sx%, sy%) = 1 AND gridm%(sx%, sy%) = 0 THEN
o% = grido%(sx%, sy%)
gridc%(sx%, sy%) = 0
IF o% = 13 THEN GOSUB clearroundblanks: o% = 13
IF o% = 10 THEN GOSUB mine
PUT (gridx%(sx%, sy%), gridy%(sx%, sy%)), graphicalobject(0, o%), PSET
PlaySample MusicChannels + 1, 25, 16000, 64, &HFF

END IF
GOSUB checkforwin
RETURN

mine:
FOR x% = 1 TO 30
 FOR y% = 1 TO 20
  o% = grido%(x%, y%)
  IF o% = 10 THEN PUT (gridx%(x%, y%), gridy%(x%, y%)), graphicalobject(0, o%), PSET
 NEXT
NEXT
PlaySample MusicChannels + 2, 24, 16000, 64, &HFF

x% = gridx%(sx%, sy%)
y% = gridy%(sx%, sy%)
gravity% = 1
colour% = 4

GOSUB initexplodepixels

FOR move% = 1 TO 280
 GOSUB movepixels
NEXT
oldtimer! = TIMER
DO
LOOP UNTIL TIMER >= oldtimer! + 1 OR TIMER < 5
FOR colors% = 0 TO 63
FOR fade% = 0 TO 255
 OUT 967, fade%
 Red = INP(969)
 Green = INP(969)
 Blue = INP(969)
 Red = Red - 1
 Green = Green - 1
 Blue = Blue - 1
 IF Red < 0 THEN Red = 0
 IF Green < 0 THEN Green = 0
 IF Blue < 0 THEN Blue = 0
 OUT 968, fade%
 OUT 969, Red
 OUT 969, Green
 OUT 969, Blue
 oldtimer! = TIMER
 DO
 LOOP UNTIL oldtimer! >= .04 OR TIMER < 5
NEXT fade%
NEXT colors%
GOSUB ender

initexplodepixels:
FOR i% = 1 TO nopixels%
 pixels!(i%, 1) = (RND / 40) + .02
 pixels!(i%, 2) = (RND * 4) - 2
 pixels!(i%, 3) = (RND * 2 + 1)
 pixels!(i%, 4) = pixels!(i%, 1) * gravity%
 pixels!(i%, 5) = x%
 pixels!(i%, 6) = y%
NEXT
RETURN

movepixels:
FOR i% = 1 TO nopixels%
 pixels!(i%, 5) = pixels!(i%, 5) + pixels!(i%, 2)
 pixels!(i%, 6) = pixels!(i%, 6) - pixels!(i%, 3)
 pixels!(i%, 3) = pixels!(i%, 3) - pixels!(i%, 4)
NEXT

FOR i% = 1 TO nopixels%
 pixels!(i%, 7) = POINT(pixels!(i%, 5), pixels!(i%, 6))
NEXT

FOR i% = 1 TO nopixels%
 PSET (pixels!(i%, 5), pixels!(i%, 6)), colour%
NEXT

FOR pause% = 1 TO 60
WAIT &H3DA, 8
WAIT &H3DA, 1
NEXT
WAIT &H3DA, 8

FOR i% = 1 TO nopixels%
 PSET (pixels!(i%, 5), pixels!(i%, 6)), pixels!(i%, 7)
NEXT
RETURN


oldtimer! = TIMER
DO
LOOP UNTIL TIMER >= oldtimer! + 2 OR TIMER < 5
playerwon% = 0
GOTO ender

clearroundblanks:
DO
 hadtowork% = 0
 FOR x% = 1 TO 30
  FOR y% = 1 TO 20
   o% = grido%(x%, y%)
   IF o% = 13 AND gridc%(x%, y%) = 0 THEN
    testifclear% = 0
    IF x% - 1 > 0 AND y% - 1 > 0 THEN testifclear% = testifclear% + gridc%(x% - 1, y% - 1)
    IF y% - 1 > 0 THEN testifclear% = testifclear% + gridc%(x%, y% - 1)
    IF x% + 1 < 31 AND y% - 1 > 0 THEN testifclear% = testifclear% + gridc%(x% + 1, y% - 1)
    IF x% - 1 > 0 THEN testifclear% = testifclear% + gridc%(x% - 1, y%)
    IF x% + 1 < 31 THEN testifclear% = testifclear% + gridc%(x% + 1, y%)
    IF x% - 1 > 0 AND y% + 1 < 21 THEN testifclear% = testifclear% + gridc%(x% - 1, y% + 1)
    IF y% + 1 < 21 THEN testifclear% = testifclear% + gridc%(x%, y% + 1)
    IF x% + 1 < 31 AND y% + 1 < 21 THEN testifclear% = testifclear% + gridc%(x% + 1, y% + 1)
    IF testifclear% > 0 THEN
     hadtowork% = 1
     IF x% - 1 > 0 AND y% - 1 > 0 THEN gridc%(x% - 1, y% - 1) = 0
     IF y% - 1 > 0 THEN gridc%(x%, y% - 1) = 0
     IF x% + 1 < 31 AND y% - 1 > 0 THEN gridc%(x% + 1, y% - 1) = 0
     IF x% - 1 > 0 THEN gridc%(x% - 1, y%) = 0
     IF x% + 1 < 31 THEN gridc%(x% + 1, y%) = 0
     IF x% - 1 > 0 AND y% + 1 < 21 THEN gridc%(x% - 1, y% + 1) = 0
     IF y% + 1 < 21 THEN gridc%(x%, y% + 1) = 0
     IF x% + 1 < 31 AND y% + 1 < 21 THEN gridc%(x% + 1, y% + 1) = 0
    END IF
   END IF
  NEXT
 NEXT
LOOP UNTIL hadtowork% = 0
GOSUB displaygrid
RETURN

markmine:
IF gridc%(sx%, sy%) = 1 AND gridm%(sx%, sy%) <> 1 THEN gridm%(sx%, sy%) = 1: markedmines% = markedmines% - 1: GOTO donemarkmine
IF gridc%(sx%, sy%) = 1 AND gridm%(sx%, sy%) = 1 THEN gridm%(sx%, sy%) = 0:  markedmines% = markedmines% + 1: GOTO donemarkmine
GOTO nomarkminesound
donemarkmine:
PlaySample MusicChannels + 2, 23, 16000, 64, &HFF
GOSUB displaygrid
GOSUB checkforwin
nomarkminesound:
RETURN

markquestion:
IF gridc%(sx%, sy%) = 1 AND gridm%(sx%, sy%) = 1 THEN markedmines% = markedmines% + 1
IF gridc%(sx%, sy%) = 1 AND gridm%(sx%, sy%) <> 2 THEN gridm%(sx%, sy%) = 2: GOTO donemarkquestion
IF gridc%(sx%, sy%) = 1 AND gridm%(sx%, sy%) = 2 THEN gridm%(sx%, sy%) = 0: GOTO donemarkquestion
GOTO noquestionmarksound
donemarkquestion:
PlaySample MusicChannels + 2, 23, 16000, 64, &HFF
GOSUB displaygrid
GOSUB checkforwin
noquestionmarksound:
RETURN

cleararound:
IF gridc%(sx%, sy%) = 0 THEN
 IF grido%(sx%, sy%) >= 1 AND grido%(sx%, sy%) <= 8 THEN
  m% = grido%(sx%, sy%)
  testforflag% = 0
  IF sx% - 1 > 0 AND sy% - 1 > 0 THEN testforflag% = testforflag% + gridm%(sx% - 1, sy% - 1)
  IF sy% - 1 > 0 THEN testforflag% = testforflag% + gridm%(sx%, sy% - 1)
  IF sx% + 1 < 31 AND sy% - 1 > 0 THEN testforflag% = testforflag% + gridm%(sx% + 1, sy% - 1)
  IF sx% - 1 > 0 THEN testforflag% = testforflag% + gridm%(sx% - 1, sy%)
  IF sx% + 1 < 31 THEN testforflag% = testforflag% + gridm%(sx% + 1, sy%)
  IF sx% - 1 > 0 AND sy% + 1 < 21 THEN testforflag% = testforflag% + gridm%(sx% - 1, sy% + 1)
  IF sy% + 1 < 21 THEN testforflag% = testforflag% + gridm%(sx%, sy% + 1)
  IF sx% + 1 < 31 AND sy% + 1 < 21 THEN testforflag% = testforflag% + gridm%(sx% + 1, sy% + 1)
  IF testforflag% = m% THEN
   IF sx% - 1 > 0 AND sy% - 1 > 0 THEN
    IF gridm%(sx% - 1, sy% - 1) = 0 THEN gridc%(sx% - 1, sy% - 1) = 0
   END IF
   IF sy% - 1 > 0 THEN
    IF gridm%(sx%, sy% - 1) = 0 THEN gridc%(sx%, sy% - 1) = 0
   END IF
   IF sx% + 1 < 31 AND sy% - 1 > 0 THEN
    IF gridm%(sx% + 1, sy% - 1) = 0 THEN gridc%(sx% + 1, sy% - 1) = 0
   END IF
   IF sx% - 1 > 0 THEN
    IF gridm%(sx% - 1, sy%) = 0 THEN gridc%(sx% - 1, sy%) = 0
   END IF
   IF sx% + 1 < 31 THEN
    IF gridm%(sx% + 1, sy%) = 0 THEN gridc%(sx% + 1, sy%) = 0
   END IF
   IF sx% - 1 > 0 AND sy% + 1 < 21 THEN
    IF gridm%(sx% - 1, sy% + 1) = 0 THEN gridc%(sx% - 1, sy% + 1) = 0
   END IF
   IF sy% + 1 < 21 THEN
    IF gridm%(sx%, sy% + 1) = 0 THEN gridc%(sx%, sy% + 1) = 0
   END IF
   IF sx% + 1 < 31 AND sy% + 1 < 21 THEN
    IF gridm%(sx% + 1, sy% + 1) = 0 THEN gridc%(sx% + 1, sy% + 1) = 0
   END IF
   GOSUB clearroundblanks
   GOSUB displaygrid
   GOSUB checkforwin
   PlaySample MusicChannels + 1, 25, 16000, 64, &HFF
  END IF
 END IF
END IF
RETURN

checkforwin:
m% = 0
FOR x% = 1 TO 30
 FOR y% = 1 TO 20
  IF grido%(x%, y%) <> 10 AND gridc%(x%, y%) = 0 THEN m% = m% + 1
 NEXT
NEXT
IF m% + mines% = 600 THEN GOSUB playerhaswon

m% = 0
FOR x% = 1 TO 30
 FOR y% = 1 TO 20
  IF grido%(x%, y%) = 10 AND gridm%(x%, y%) = 1 THEN m% = m% + 1
 NEXT
NEXT
IF m% = mines% AND markedmines% = 0 THEN GOSUB playerhaswon
RETURN


RETURN

playerhaswon:
oldtimer! = TIMER
DO
a$ = INKEY$
LOOP UNTIL TIMER >= oldtimer! + 1 OR TIMER < 5
FOR colors% = 0 TO 63
FOR fade% = 0 TO 255
 OUT 967, fade%
 Red = INP(969)
 Green = INP(969)
 Blue = INP(969)
 Red = Red - 1
 Green = Green - 1
 Blue = Blue - 1
 IF Red < 0 THEN Red = 0
 IF Green < 0 THEN Green = 0
 IF Blue < 0 THEN Blue = 0
 OUT 968, fade%
 OUT 969, Red
 OUT 969, Green
 OUT 969, Blue
 oldtimer! = TIMER
 DO
 LOOP UNTIL oldtimer! >= .04 OR TIMER < 5
NEXT fade%
NEXT colors%

playerwon% = 1
DIM pal!(1536)                   'Setup array to store palette.
     
'This makes a nice palette. (change at will)
FOR pal% = 0 TO 63
 pal!(i%) = r!
 pal!(i% + 1) = g!
 pal!(i% + 2) = b!
 IF r! < 63 THEN r! = r! + 1
 IF g! < 63 THEN g! = g! + 1
 IF b! < 63 THEN b! = b! + 1
 i% = i% + 3
NEXT pal%

FOR pal% = 0 TO 63
 pal!(i%) = r!
 pal!(i% + 1) = g!
 pal!(i% + 2) = b!
 IF b! > 0 THEN b! = b! - 1
 i% = i% + 3
NEXT pal%
   
FOR pal% = 0 TO 63
 pal!(i%) = r!
 pal!(i% + 1) = g!
 pal!(i% + 2) = b!
 IF r! > 0 THEN r! = r! - 1
 IF g! > 0 THEN g! = g! - 1
 IF b! < 31 THEN b! = b! + .5
 i% = i% + 3
NEXT pal%

FOR pal% = 0 TO 63
 pal!(i%) = r!
 pal!(i% + 1) = g!
 pal!(i% + 2) = b!
 IF g! < 63 THEN g! = g! + 1
 IF b! > 0 THEN b! = b! - .5
 i% = i% + 3
NEXT pal%

FOR pal% = 0 TO 63
 pal!(i%) = r!
 pal!(i% + 1) = g!
 pal!(i% + 2) = b!
 IF r! < 31 THEN r! = r! + .5
 IF g! > 0 THEN g! = g! - 1
 i% = i% + 3
NEXT pal%

FOR pal% = 0 TO 63
 pal!(i%) = r!
 pal!(i% + 1) = g!
 pal!(i% + 2) = b!
 IF r! < 63 THEN r! = r! + .5
 IF b! < 31 THEN b! = b! + .5
 i% = i% + 3
NEXT pal%

FOR pal% = 0 TO 63
 pal!(i%) = r!
 pal!(i% + 1) = g!
 pal!(i% + 2) = b!
 IF r! > 0 THEN r! = r! - 1
 IF g! < 31 THEN g! = g! + .5
 IF b! < 63 THEN b! = b! + .5
 i% = i% + 3
NEXT pal%
    
FOR pal% = 0 TO 63
 pal!(i%) = r!
 pal!(i% + 1) = g!
 pal!(i% + 2) = b!
 IF g! > 0 THEN g! = g! - .5
 IF b! > 0 THEN b! = b! - 1
 i% = i% + 3
NEXT pal%

CLS
i% = 0
FOR pal% = 1 TO 255             'Apply the palette.
 r! = pal!(i%)
 g! = pal!(i% + 1)
 b! = pal!(i% + 2)
 i% = i% + 3
 OUT 968, pal%
 OUT 969, r!
 OUT 969, g!
 OUT 969, b!
NEXT pal%


BLOAD "congrat.gfx"


DO
oor! = pal!(0)          'Save first colour as it will be overwriten.
oog! = pal!(1)          'Each colour is made up of three bytes (R,G,B)
oob! = pal!(2)


FOR pal% = 3 TO 1535 STEP 3          'Shift all the colours in the palette
 r! = pal!(pal%)                       'down.
 g! = pal!(pal% + 1)
 b! = pal!(pal% + 2)
 pal!(pal% - 3) = r!
 pal!(pal% - 2) = g!
 pal!(pal% - 1) = b!
NEXT pal%

pal!(1533) = oor!                 'Put the colour to the back.
pal!(1534) = oog!
pal!(1535) = oob!

i% = 0
FOR pal% = 1 TO 255             'Apply the new palette
 r! = pal!(i%)
 g! = pal!(i% + 1)
 b! = pal!(i% + 2)
 r! = r! + bri%
 g! = g! + bri%
 b! = b! + bri%
 IF r! > 63 THEN r! = 63
 IF g! > 63 THEN g! = 63
 IF b! > 63 THEN b! = 63
 i% = i% + 3
 OUT 968, pal%
 OUT 969, r!
 OUT 969, g!
 OUT 969, b!
NEXT
a$ = INKEY$                         'Check if a key was pressed
IF a$ <> "" THEN ender% = 1         'If so end.
IF ender% = 1 THEN bri% = bri% + 1  'Increase the brightness.
IF bri% = 64 THEN GOTO fadeout        'When as bright as possible, fade out.
LOOP                                'Go round again!


'Fade out screen.
fadeout:
FOR colors% = 0 TO 63
FOR fade% = 0 TO 255
 OUT 967, fade%
 Red = INP(969)
 Green = INP(969)
 Blue = INP(969)
 Red = Red - 1
 Green = Green - 1
 Blue = Blue - 1
 IF Red < 0 THEN Red = 0
 IF Green < 0 THEN Green = 0
 IF Blue < 0 THEN Blue = 0
 OUT 968, fade%
 OUT 969, Red
 OUT 969, Green
 OUT 969, Blue
 oldtimer! = TIMER
 DO
 LOOP UNTIL oldtimer! >= .04 OR TIMER < 5
NEXT fade%
NEXT colors%
CLS
PALETTE

GOSUB ender
END
RETURN

fadeinout:
colours% = 255
OPEN file$ + ".pal" FOR BINARY AS #2
 FOR x% = 0 TO colours% - 1
  r$ = " ": g$ = " ": b$ = " "
  GET #2, , r$
  GET #2, , g$
  GET #2, , b$
  r% = ASC(r$)
  g% = ASC(g$)
  b% = ASC(b$)
  silentspalette(x%, 1) = r%
  silentspalette(x%, 2) = g%
  silentspalette(x%, 3) = b%
 NEXT
CLOSE #2

FOR col% = 1 TO colours% - 1
 r1% = silentspalette(col%, 1)
 g1% = silentspalette(col%, 2)
 b1% = silentspalette(col%, 3)
 r2% = realpalette!(col%, 1)
 g2% = realpalette!(col%, 2)
 b2% = realpalette!(col%, 3)
 radd! = (r1% - r2%) / 63
 gadd! = (g1% - g2%) / 63
 badd! = (b1% - b2%) / 63
 addtorealpalette!(col%, 1) = radd!
 addtorealpalette!(col%, 2) = gadd!
 addtorealpalette!(col%, 3) = badd!
NEXT

FOR fadein% = 1 TO 63
 FOR col% = 1 TO colours% - 1
  r! = realpalette!(col%, 1)
  g! = realpalette!(col%, 2)
  b! = realpalette!(col%, 3)
  r! = r! + addtorealpalette!(col%, 1)
  g! = g! + addtorealpalette!(col%, 2)
  b! = b! + addtorealpalette!(col%, 3)
  realpalette!(col%, 1) = r!
  realpalette!(col%, 2) = g!
  realpalette!(col%, 3) = b!
  OUT 968, col%
  OUT 969, r!
  OUT 969, g!
  OUT 969, b!
 NEXT
 WAIT &H3DA, 8
NEXT

FOR col% = 1 TO colours% - 1
 addtorealpalette!(col%, 1) = silentspalette(col%, 1) / 63
 addtorealpalette!(col%, 2) = silentspalette(col%, 2) / 63
 addtorealpalette!(col%, 3) = silentspalette(col%, 3) / 63
NEXT

oldtimer! = TIMER
DO
LOOP UNTIL TIMER >= oldtimer! + .5 OR TIMER < 5
IF waitforkey% THEN key$ = INPUT$(1)

FOR fadeout% = 1 TO 63
 FOR col% = 1 TO colours% - 1
  realpalette!(col%, 1) = realpalette!(col%, 1) - addtorealpalette!(col%, 1)
  realpalette!(col%, 2) = realpalette!(col%, 2) - addtorealpalette!(col%, 2)
  realpalette!(col%, 3) = realpalette!(col%, 3) - addtorealpalette!(col%, 3)
  OUT 968, col%
  OUT 969, realpalette!(col%, 1)
  OUT 969, realpalette!(col%, 2)
  OUT 969, realpalette!(col%, 3)
 NEXT
 WAIT &H3DA, 8
NEXT




RETURN



ender:
FOR x% = 0 TO 255
 OUT 968, x%
 OUT 969, 0
 OUT 969, 0
 OUT 969, 0
NEXT
file$ = "foxshot"
BLOAD file$ + ".GFX"
waitforkey% = 1
GOSUB fadeinout

StopBanner
StopMusic
StopOutput
UnloadModule
FreeMSE
IF playerwon% = 1 THEN
SCREEN 0
WIDTH 80, 25
PRINT mines%;
PRINT "Mines Cleared In";
PRINT timetaken;
PRINT "Seconds."
END IF
IF playerwon% = 0 THEN
SCREEN 0
WIDTH 80, 25
PRINT "Bad Luck. Try again!"
END IF
END

SUB smallfont (x%, y%, space%, text$)
FOR g% = 1 TO LEN(text$)
cl$ = LEFT$(text$, g%)
cl$ = RIGHT$(cl$, 1)
cl$ = UCASE$(cl$)

IF cl$ = "A" THEN
LINE (x%, y% + 1)-(x%, y% + 4)
LINE (x% + 3, y% + 1)-(x% + 3, y% + 4)
LINE (x%, y% + 2)-(x% + 3, y% + 2)
LINE (x% + 1, y%)-(x% + 2, y%)
x% = x% + 5
END IF

IF cl$ = "B" THEN
LINE (x%, y%)-(x%, y% + 4)
LINE (x%, y%)-(x% + 2, y%)
LINE (x%, y% + 2)-(x% + 2, y% + 2)
LINE (x%, y% + 4)-(x% + 2, y% + 4)
PSET (x% + 3, y% + 1)
PSET (x% + 3, y% + 3)
x% = x% + 5
END IF

IF cl$ = "C" THEN
LINE (x%, y% + 1)-(x%, y% + 3)
LINE (x% + 1, y%)-(x% + 2, y%)
LINE (x% + 1, y% + 4)-(x% + 2, y% + 4)
PSET (x% + 3, y% + 1)
PSET (x% + 3, y% + 3)
x% = x% + 5
END IF

IF cl$ = "D" THEN
LINE (x%, y%)-(x%, y% + 4)
LINE (x%, y%)-(x% + 2, y%)
LINE (x%, y% + 4)-(x% + 2, y% + 4)
LINE (x% + 3, y% + 1)-(x% + 3, y% + 3)
x% = x% + 5
END IF

IF cl$ = "E" THEN
LINE (x%, y%)-(x%, y% + 4)
LINE (x%, y%)-(x% + 2, y%)
LINE (x%, y% + 2)-(x% + 1, y% + 2)
LINE (x%, y% + 4)-(x% + 2, y% + 4)
x% = x% + 4
END IF

IF cl$ = "F" THEN
LINE (x%, y%)-(x%, y% + 4)
LINE (x%, y%)-(x% + 2, y%)
LINE (x%, y% + 2)-(x% + 1, y% + 2)
x% = x% + 4
END IF

IF cl$ = "G" THEN
LINE (x%, y% + 1)-(x%, y% + 3)
LINE (x% + 1, y%)-(x% + 2, y%)
LINE (x% + 1, y% + 4)-(x% + 2, y% + 4)
LINE (x% + 3, y% + 3)-(x% + 3, y% + 2)
PSET (x% + 2, y% + 2)
x% = x% + 5
END IF

IF cl$ = "H" THEN
LINE (x%, y%)-(x%, y% + 4)
LINE (x% + 3, y%)-(x% + 3, y% + 4)
LINE (x%, y% + 2)-(x% + 3, y% + 2)
x% = x% + 5
END IF

IF cl$ = "I" THEN
LINE (x%, y%)-(x%, y% + 4)
x% = x% + 2
END IF

IF cl$ = "J" THEN
LINE (x% + 3, y%)-(x% + 3, y% + 3)
LINE (x% + 1, y% + 4)-(x% + 2, y% + 4)
PSET (x%, y% + 3)
x% = x% + 5
END IF

IF cl$ = "K" THEN
LINE (x%, y%)-(x%, y% + 4)
LINE (x% + 1, y% + 2)-(x% + 3, y%)
LINE (x% + 1, y% + 2)-(x% + 3, y% + 4)
x% = x% + 5
END IF

IF cl$ = "L" THEN
LINE (x%, y%)-(x%, y% + 4)
LINE (x%, y% + 4)-(x% + 2, y% + 4)
x% = x% + 4
END IF

IF cl$ = "M" THEN
LINE (x%, y%)-(x%, y% + 4)
LINE (x% + 4, y%)-(x% + 4, y% + 4)
LINE (x%, y%)-(x% + 2, y% + 2)
LINE (x% + 2, y% + 2)-(x% + 4, y%)
x% = x% + 6
END IF

IF cl$ = "N" THEN
LINE (x%, y%)-(x%, y% + 4)
LINE (x% + 3, y%)-(x% + 3, y% + 4)
LINE (x% + 1, y% + 1)-(x% + 1, y% + 2)
LINE (x% + 2, y% + 2)-(x% + 2, y% + 3)
x% = x% + 5
END IF

IF cl$ = "O" THEN
LINE (x%, y% + 1)-(x%, y% + 3)
LINE (x% + 3, y% + 1)-(x% + 3, y% + 3)
LINE (x% + 1, y%)-(x% + 2, y%)
LINE (x% + 1, y% + 4)-(x% + 2, y% + 4)
x% = x% + 5
END IF

IF cl$ = "P" THEN
LINE (x%, y%)-(x%, y% + 4)
LINE (x%, y%)-(x% + 2, y%)
LINE (x%, y% + 2)-(x% + 3, y% + 2)
PSET (x% + 3, y% + 1)
x% = x% + 5
END IF

IF cl$ = "Q" THEN
LINE (x%, y% + 1)-(x%, y% + 3)
LINE (x% + 1, y% + 4)-(x% + 3, y% + 2)
LINE (x% + 3, y% + 1)-(x% + 2, y%)
PSET (x% + 3, y% + 4)
PSET (x% + 1, y%)
x% = x% + 5
END IF

IF cl$ = "R" THEN
LINE (x%, y%)-(x%, y% + 4)
LINE (x%, y%)-(x% + 2, y%)
LINE (x%, y% + 2)-(x% + 2, y% + 2)
PSET (x% + 3, y% + 1)
LINE (x% + 3, y% + 3)-(x% + 3, y% + 4)
x% = x% + 5
END IF

IF cl$ = "S" THEN
LINE (x% + 1, y%)-(x% + 3, y%)
LINE (x%, y% + 1)-(x% + 1, y% + 2)
LINE (x% + 2, y% + 2)-(x% + 3, y% + 3)
LINE (x%, y% + 4)-(x% + 2, y% + 4)
x% = x% + 5
END IF

IF cl$ = "T" THEN
LINE (x% + 1, y%)-(x% + 1, y% + 4)
LINE (x%, y%)-(x% + 2, y%)
x% = x% + 4
END IF

IF cl$ = "U" THEN
LINE (x%, y%)-(x%, y% + 3)
LINE (x% + 3, y%)-(x% + 3, y% + 3)
LINE (x% + 1, y% + 4)-(x% + 2, y% + 4)
x% = x% + 5
END IF

IF cl$ = "V" THEN
LINE (x%, y%)-(x%, y% + 2)
LINE (x% + 4, y%)-(x% + 4, y% + 2)
LINE (x%, y% + 2)-(x% + 2, y% + 4)
PSET (x% + 3, y% + 3)
x% = x% + 6
END IF

IF cl$ = "W" THEN
LINE (x%, y%)-(x%, y% + 3)
LINE (x% + 4, y%)-(x% + 4, y% + 3)
LINE (x% + 2, y% + 2)-(x% + 2, y% + 3)
PSET (x% + 1, y% + 4)
PSET (x% + 3, y% + 4)
x% = x% + 6
END IF

IF cl$ = "X" THEN
LINE (x%, y%)-(x% + 4, y% + 4)
LINE (x% + 4, y%)-(x%, y% + 4)
x% = x% + 6
END IF

IF cl$ = "Y" THEN
LINE (x%, y% + 1)-(x% + 2, y% + 3)
LINE (x% + 4, y% + 1)-(x% + 2, y% + 3)
PSET (x%, y%)
PSET (x% + 4, y%)
PSET (x% + 2, y% + 4)
x% = x% + 6
END IF

IF cl$ = "Z" THEN
LINE (x%, y%)-(x% + 3, y%)
LINE (x% + 3, y% + 1)-(x%, y% + 4)
LINE (x%, y% + 4)-(x% + 3, y% + 4)
x% = x% + 5
END IF

IF cl$ = " " THEN x% = x% + 5

IF cl$ = "0" THEN
LINE (x% + 1, y%)-(x% + 3, y%)
LINE (x%, y% + 1)-(x%, y% + 3)
LINE (x% + 1, y% + 4)-(x% + 3, y% + 4)
LINE (x% + 4, y% + 1)-(x% + 4, y% + 3)
LINE (x% + 1, y% + 3)-(x% + 3, y% + 1)
x% = x% + 6
END IF

IF cl$ = "1" THEN
LINE (x% + 1, y%)-(x% + 1, y% + 4)
LINE (x%, y% + 4)-(x% + 2, y% + 4)
PSET (x%, y% + 1)
x% = x% + 4
END IF

IF cl$ = "2" THEN
LINE (x% + 1, y%)-(x% + 3, y%)
LINE (x% + 4, y% + 1)-(x% + 3, y% + 2)
LINE (x% + 2, y% + 2)-(x% + 1, y% + 3)
LINE (x%, y% + 4)-(x% + 4, y% + 4)
PSET (x%, y% + 1)
x% = x% + 6
END IF

IF cl$ = "3" THEN
LINE (x%, y%)-(x% + 2, y%)
LINE (x%, y% + 4)-(x% + 2, y% + 4)
LINE (x% + 1, y% + 2)-(x% + 2, y% + 2)
PSET (x% + 3, y% + 1)
PSET (x% + 3, y% + 3)
x% = x% + 5
END IF

IF cl$ = "4" THEN
LINE (x% + 3, y%)-(x% + 3, y% + 4)
LINE (x%, y% + 3)-(x% + 4, y% + 3)
LINE (x%, y% + 2)-(x% + 2, y%)
x% = x% + 6
END IF

IF cl$ = "5" THEN
LINE (x%, y%)-(x% + 3, y%)
LINE (x%, y%)-(x%, y% + 2)
LINE (x%, y% + 2)-(x% + 3, y% + 2)
LINE (x% + 1, y% + 4)-(x% + 3, y% + 4)
PSET (x% + 4, y% + 3)
x% = x% + 6
END IF

IF cl$ = "6" THEN
LINE (x% + 1, y%)-(x% + 3, y%)
LINE (x% + 1, y% + 2)-(x% + 3, y% + 2)
LINE (x% + 1, y% + 4)-(x% + 3, y% + 4)
LINE (x%, y% + 1)-(x%, y% + 3)
PSET (x% + 4, y% + 3)
x% = x% + 6
END IF

IF cl$ = "7" THEN
LINE (x%, y%)-(x% + 3, y%)
LINE (x% + 3, y% + 1)-(x% + 1, y% + 3)
PSET (x% + 1, y% + 4)
x% = x% + 5
END IF

IF cl$ = "8" THEN
LINE (x% + 1, y%)-(x% + 3, y%)
LINE (x% + 1, y% + 2)-(x% + 3, y% + 2)
LINE (x% + 1, y% + 4)-(x% + 3, y% + 4)
PSET (x%, y% + 1)
PSET (x%, y% + 3)
PSET (x% + 4, y% + 1)
PSET (x% + 4, y% + 3)
x% = x% + 6
END IF

IF cl$ = "9" THEN
LINE (x% + 1, y%)-(x% + 3, y%)
LINE (x% + 1, y% + 2)-(x% + 3, y% + 2)
LINE (x% + 1, y% + 4)-(x% + 3, y% + 4)
LINE (x% + 4, y% + 1)-(x% + 4, y% + 3)
PSET (x%, y% + 1)
x% = x% + 6
END IF

IF cl$ = "," THEN
LINE (x%, y% + 4)-(x% + 1, y% + 3)
x% = x% + 3
END IF

IF cl$ = "." THEN
PSET (x%, y% + 4)
x% = x% + 2
END IF

IF cl$ = "!" THEN
LINE (x%, y%)-(x%, y% + 2)
PSET (x%, y% + 4)
x% = x% + 2
END IF

IF cl$ = CHR$(34) THEN
LINE (x%, y%)-(x%, y% + 1)
LINE (x% + 2, y%)-(x% + 2, y% + 1)
x% = x% + 4
END IF

IF cl$ = "#" THEN
LINE (x% + 1, y%)-(x% + 1, y% + 4)
LINE (x% + 3, y%)-(x% + 3, y% + 4)
LINE (x%, y% + 1)-(x% + 4, y% + 1)
LINE (x%, y% + 3)-(x% + 4, y% + 3)
x% = x% + 6
END IF

IF cl$ = "$" THEN
LINE (x% + 1, y%)-(x% + 1, y% + 4)
LINE (x%, y% + 1)-(x%, y% + 2)
LINE (x% + 2, y% + 2)-(x% + 2, y% + 3)
PSET (x%, y% + 4)
PSET (x% + 2, y%)
x% = x% + 4
END IF

IF cl$ = "%" THEN
LINE (x% + 4, y%)-(x%, y% + 4)
PSET (x%, y%)
PSET (x% + 4, y% + 4)
x% = x% + 6
END IF

IF cl$ = "^" THEN
PSET (x%, y% + 1)
PSET (x% + 2, y% + 1)
PSET (x% + 1, y%)
x% = x% + 4
END IF

IF cl$ = "&" THEN
LINE (x% + 1, y% + 4)-(x% + 3, y% + 4)
LINE (x% + 1, y% + 4)-(x% + 1, y% + 1)
LINE (x% + 1, y% + 3)-(x% + 3, y% + 1)
LINE (x% + 3, y% + 3)-(x% + 4, y% + 3)
PSET (x%, y% + 3)
PSET (x% + 2, y%)
x% = x% + 6
END IF

IF cl$ = "*" THEN
LINE (x% + 1, y% + 1)-(x% + 1, y% + 3)
LINE (x% + 2, y% + 1)-(x% + 2, y% + 3)
LINE (x% + 3, y% + 1)-(x% + 3, y% + 3)
LINE (x%, y% + 2)-(x% + 4, y% + 2)
PSET (x%, y%)
PSET (x% + 2, y%)
PSET (x% + 4, y%)
PSET (x%, y% + 4)
PSET (x% + 2, y% + 4)
PSET (x% + 4, y% + 4)
x% = x% + 6
END IF

IF cl$ = "(" THEN
LINE (x%, y% + 1)-(x%, y% + 3)
PSET (x% + 1, y%)
PSET (x% + 1, y% + 4)
x% = x% + 4
END IF

IF cl$ = ")" THEN
LINE (x% + 1, y% + 1)-(x% + 1, y% + 3)
PSET (x%, y%)
PSET (x%, y% + 4)
x% = x% + 4
END IF

IF cl$ = "+" THEN
LINE (x% + 2, y%)-(x% + 2, y% + 4)
LINE (x%, y% + 2)-(x% + 4, y% + 2)
x% = x% + 6
END IF

IF cl$ = "-" THEN
LINE (x%, y% + 2)-(x% + 4, y% + 2)
x% = x% + 6
END IF

IF cl$ = "=" THEN
LINE (x%, y% + 2)-(x% + 2, y% + 2)
LINE (x%, y% + 4)-(x% + 2, y% + 4)
x% = x% + 4
END IF

IF cl$ = "<" THEN
LINE (x% + 2, y%)-(x%, y% + 2)
LINE (x%, y% + 2)-(x% + 2, y% + 4)
x% = x% + 4
END IF

IF cl$ = ">" THEN
LINE (x%, y%)-(x% + 2, y% + 2)
LINE (x% + 2, y% + 2)-(x%, y% + 4)
x% = x% + 4
END IF

IF cl$ = "?" THEN
LINE (x%, y%)-(x% + 2, y%)
LINE (x% + 1, y% + 2)-(x% + 2, y% + 2)
PSET (x% + 3, y% + 1)
PSET (x% + 1, y% + 4)
x% = x% + 5
END IF

IF cl$ = "\" THEN
LINE (x%, y%)-(x% + 4, y% + 4)
x% = x% + 6
END IF

IF cl$ = "/" THEN
LINE (x% + 4, y%)-(x%, y% + 4)
x% = x% + 6
END IF

IF cl$ = ":" THEN
PSET (x%, y%)
PSET (x%, y% + 4)
x% = x% + 2
END IF

x% = x% + space% - 1

NEXT g%



END SUB

