DEFINT A-Z

DECLARE SUB Begin ()
DECLARE SUB Center (x, Text$)
DECLARE SUB Choose (x, y, Text$, Choice$, Choices$)
DECLARE SUB DeleteBlock ()
DECLARE SUB DeleteField ()
DECLARE SUB DisplayHelp ()
DECLARE SUB DisplayMessage ()
DECLARE SUB DisplayList ()
DECLARE SUB DrawBar ()
DECLARE SUB DrawBlock ()
DECLARE SUB DrawBox (x, y, w, h, Shadow)
DECLARE SUB Help ()
DECLARE SUB InputBox (x, y, Prompt$, Text$, MaxLength)
DECLARE SUB LoadField ()
DECLARE SUB Main ()
DECLARE SUB SaveField ()
OPTION BASE 1
COMMON SHARED AutoDraw, AutoDelete, CursorX, CursorY, ErrorOccured, FieldFile$, FieldName$
COMMON SHARED Fields, Fld, FldInTop, JustDeleted, JustDrawn, LstFldFile$
COMMON SHARED SelectedField, TopRow
ON ERROR GOTO ErrorTrap
DIM SHARED Block$(46, 80), HelpText$(100), LstFldFile$(250), LstFldName$(250)
AutoDelete = 0: AutoDraw = 0: CursorX = 1: CursorY = 1: FieldName$ = "": Fields = 0
SCREEN 0: WIDTH 80, 50: COLOR 7, 0: CLS
CALL Begin
CALL Main

ErrorTrap:
ErrorOccured = -1
 IF NOT FileName$ = "" THEN MID$(FileName$, 1, 1) = UCASE$(LEFT$(FileName$, 1))
PCOPY 0, 3
 DO
  COLOR 12, 4
  DrawBox 19, 24, 30, 3, 0
  LOCATE 20
  e = ERR
   IF e = 53 THEN
    Center 0, "Cannot find: " + CHR$(34) + FileName$ + CHR$(34) + "."
   ELSEIF e = 55 OR e = 64 THEN
    Center 0, "Cannot open:"
    Center 0, CHR$(34) + FileName$ + CHR$(34) + "."
   ELSEIF e = 61 THEN
    Center 0, "Not enough diskspace."
   ELSEIF e = 62 THEN
    Center 0, "Error while reading:"
    Center 0, CHR$(34) + FileName$ + CHR$(34) + "."
   ELSEIF e = 70 THEN
    Center 0, "Disk or file is "
    Center 0, "write protected."
   ELSEIF e = 71 THEN
    Center 0, "Disk is not in drive."
   ELSEIF e = 72 THEN
    Center 0, "The disk is damaged."
   ELSE
    Center 0, "Unexpected error."
   END IF
  Center 0, "Error code:" + STR$(e)
  COLOR 0, 7: Center 24, " 1 = Retry  2 = Ignore  3 = Quit "
   DO
    Choice$ = INKEY$
   LOOP WHILE Choice$ = ""
  PCOPY 3, 0
   IF Choice$ = "1" THEN RESUME
   IF Choice$ = "2" THEN RESUME NEXT
   IF Choice$ = "3" THEN WIDTH 80, 25: COLOR 7, 0: CLS : SYSTEM
 LOOP

SUB Begin
FileName$ = "Fields.lst"
OPEN "Fields.lst" FOR BINARY AS 1
 IF LOF(1) = 0 THEN
  CLOSE 1
  KILL "Fields.lst"
 ELSE
  Fields = ASC(INPUT$(1, 1))
 END IF
CLOSE 1
END SUB

SUB Center (x, Text$)
 IF x > 0 THEN LOCATE x
LOCATE , INT(40 - (LEN(Text$) / 2))
PRINT Text$
END SUB

SUB Choose (x, y, Text$, Choice$, Choices$)
LOCATE x, y: PRINT Text$
 DO
  Choice$ = UCASE$(INPUT$(1))
   IF INSTR(Choices$, Choice$) THEN EXIT DO
 LOOP
LOCATE x, y: PRINT SPACE$(LEN(Text$))
END SUB

SUB DeleteBlock
 IF JustDrawn THEN JustDrawn = 0: EXIT SUB
Block$(CursorX, CursorY) = ""
LOCATE CursorX, CursorY: PRINT " "
 IF AutoDraw THEN JustDeleted = -1
END SUB

SUB DeleteField
ErrorOccured = 0
FileName$ = LstFldFile$(SelectedField) + ".fld"
KILL LstFldFile$(SelectedField) + ".fld"
 IF NOT ErrorOccured THEN
  FileName$ = "Fields.lst"
  OPEN "Fields.lst" FOR INPUT AS 1: CLOSE 1
  OPEN "Fields.lst" FOR BINARY AS 1
   IF LOF(1) = 0 THEN
    CLOSE 1
    KILL "Fields.lst"
   ELSE
    Fields = ASC(INPUT$(1, 1))
     IF Fields > 0 THEN Fields = Fields - 1
    OPEN "Fields.tmp" FOR OUTPUT AS 2
     PRINT #2, CHR$(Fields);
      FOR Fld = 1 TO Fields + 1
        IF LOC(1) = LOF(1) THEN EXIT FOR
       l = ASC(INPUT$(1, 1)): FldFile$ = INPUT$(l, 1)
       l = ASC(INPUT$(1, 1)): FldName$ = INPUT$(l, 1)
        IF NOT Fld = SelectedField THEN PRINT #2, CHR$(LEN(FldFile$)); FldFile$; CHR$(LEN(FldName$)); FldName$;
        IF Fld = 250 THEN EXIT FOR
      NEXT Fld
    CLOSE 2, 1
    KILL "Fields.lst"
    NAME "Fields.tmp" AS "Fields.lst"
   END IF
 END IF
END SUB

SUB DisplayHelp
DrawBox 10, 20, 38, 20, 1
Center 10, "Help"
Row = 11
 FOR HLine = TopRow TO TopRow + 19
  LOCATE Row, 21
  PRINT HelpText$(HLine)
  Row = Row + 1
 NEXT HLine
END SUB

SUB DisplayList
Row = 11
 FOR Fld = FldInTop TO FldInTop + 29
   IF Fld > 250 THEN EXIT FOR
  l = LEN(LstFldName$(Fld))
   IF Fld = SelectedField THEN COLOR 0, 2 ELSE COLOR 0, 7
  LOCATE Row, 27: PRINT LstFldName$(Fld); SPACE$(26 - l)
  Row = Row + 1
 NEXT Fld
END SUB

SUB DisplayMessage
PCOPY 0, 1
COLOR 0, 7
DrawBox 20, 23, 32, 3, 1
LOCATE 21, 25: PRINT "You cannot draw here because"
LOCATE , 25: PRINT "this is the starting point for"
LOCATE , 25: PRINT "the monsters or the player."
Key$ = INPUT$(1)
PCOPY 1, 0
END SUB

SUB DrawBar
 IF NOT AutoDraw AND NOT AutoDelete THEN Status$ = ""
 IF AutoDraw THEN Status$ = "Autodraw is on."
 IF AutoDelete THEN Status$ = "Autodelete is on."
COLOR 15, 1
LOCATE 47, 1
PRINT USING " F1 = Help  X: ## Y: ## "; CursorX; CursorY;
PRINT USING " \" + SPACE$(18) + "\  Name: \" + SPACE$(23) + "\  "; Status$; FieldName$
END SUB

SUB DrawBlock
 IF JustDeleted THEN JustDeleted = 0: EXIT SUB
 IF CursorX = 2 AND CursorY = 2 THEN
  DisplayMessage
 ELSEIF CursorX > 20 AND CursorX < 27 AND CursorY > 36 AND CursorY < 44 THEN
  DisplayMessage
 ELSE
  COLOR 2, 0: LOCATE CursorX, CursorY: PRINT ""
  Block$(CursorX, CursorY) = ""
 END IF
 IF AutoDelete THEN JustDrawn = -1
END SUB

SUB DrawBox (x, y, w, h, Shadow)
LOCATE x, y: PRINT ""; STRING$(w, ""); ""
 FOR BoxX = 1 TO h
  LOCATE , y: PRINT ""; SPACE$(w); "";
   IF Shadow THEN PRINT "" ELSE PRINT
 NEXT BoxX
LOCATE , y: PRINT ""; STRING$(w, ""); "";
 IF Shadow THEN PRINT "": LOCATE , y + 1: PRINT STRING$(w + 2, "") ELSE PRINT
END SUB

SUB Help
ERASE HelpText$
PCOPY 0, 1
TopRow = 1
FileName$ = "Drawhelp.hlp"
OPEN "Drawhelp.hlp" FOR INPUT AS 1: CLOSE 1
OPEN "Drawhelp.hlp" FOR BINARY AS 1
 IF LOF(1) = 0 THEN
  CLOSE 1
  KILL "Drawhelp.hlp"
 ELSE
  HLine = 1
   DO UNTIL LOC(1) = LOF(1)
    Format$ = INPUT$(1, 1)
     DO
      Char$ = INPUT$(1, 1)
       IF Char$ = CHR$(10) OR LOC(1) = LOF(1) THEN EXIT DO
      HelpText$(HLine) = HelpText$(HLine) + Char$
     LOOP
     IF Format$ = "" THEN
      HelpText$(HLine) = STRING$(38, 196)
     ELSEIF Format$ = "=" THEN
      HelpText$(HLine) = STRING$(38, 205)
     ELSEIF Format$ = ">" THEN
      HelpText$(HLine) = SPACE$(19 - (LEN(HelpText$(HLine)) \ 2)) + HelpText$(HLine)
     END IF
    HLine = HLine + 1
   LOOP
  CLOSE 1
 END IF

COLOR 0, 7
 DO
  DisplayHelp
   DO
    Key$ = INKEY$
   LOOP WHILE Key$ = ""
   IF Key$ = CHR$(0) + "H" THEN IF TopRow > 1 THEN TopRow = TopRow - 1
   IF Key$ = CHR$(0) + "P" THEN IF TopRow < 80 THEN TopRow = TopRow + 1
   IF Key$ = CHR$(27) THEN PCOPY 1, 0: EXIT SUB
 LOOP
END SUB

SUB InputBox (x, y, Prompt$, Text$, MaxLength)
 DO
  COLOR 7, 0
  LOCATE x, y: PRINT Prompt$; Text$; : COLOR 23: PRINT "_ "
   DO
    Key$ = INKEY$
   LOOP WHILE Key$ = ""
  l = LEN(Text$)
   IF Key$ = CHR$(8) THEN
    IF l > 0 THEN Text$ = LEFT$(Text$, l - 1)
   ELSEIF Key$ = CHR$(13) THEN
    EXIT DO
   ELSEIF Key$ = CHR$(27) THEN
    Text$ = "": EXIT DO
   ELSEIF ASC(Key$) > 31 THEN
    IF l < MaxLength THEN Text$ = Text$ + Key$
   END IF
 LOOP
COLOR 7
LOCATE x, y: PRINT SPACE$(LEN(Prompt$) + l + 2)
END SUB

SUB LoadField
PCOPY 0, 1
ERASE LstFldFile$, LstFldName$
 IF Fields = 0 THEN
  COLOR 0, 7
  DrawBox 19, 25, 28, 1, 1
  Center 20, "There are no saved fields."
  Key$ = INPUT$(1)
  PCOPY 1, 0
  EXIT SUB
 END IF

Cursor2X = 1
FldInTop = 1
SelectedField = 1
COLOR 0, 7
DrawBox 10, 26, 26, 30, 1
Center 10, "Select a field."
FileName$ = "Fields.lst"
OPEN "Fields.lst" FOR INPUT AS 1: CLOSE 1
OPEN "Fields.lst" FOR BINARY AS 1
 IF LOF(1) = 0 THEN
  CLOSE 1
  KILL "Fields.lst"
 ELSE
  Fields = ASC(INPUT$(1, 1))
   FOR Fld = 1 TO Fields
     IF LOC(1) = LOF(1) THEN EXIT FOR
    l = ASC(INPUT$(1, 1)): LstFldFile$(Fld) = INPUT$(l, 1)
    l = ASC(INPUT$(1, 1)): LstFldName$(Fld) = INPUT$(l, 1)
   NEXT Fld
 END IF
CLOSE 1
 DO
  DisplayList
   DO
    Key$ = INKEY$
   LOOP WHILE Key$ = ""
  IF Key$ = CHR$(0) + "H" THEN
   IF SelectedField > 0 THEN
    SelectedField = SelectedField - 1
     IF Cursor2X > 1 THEN Cursor2X = Cursor2X - 1 ELSE FldInTop = FldInTop - 1
   END IF
  ELSEIF Key$ = CHR$(0) + "P" THEN
   IF SelectedField < 250 THEN
    SelectedField = SelectedField + 1
     IF Cursor2X < 30 THEN Cursor2X = Cursor2X + 1 ELSE FldInTop = FldInTop + 1
   END IF
  ELSEIF Key$ = CHR$(13) AND NOT LstFldFile$(SelectedField) = "" THEN
   PCOPY 1, 0
   COLOR 2, 0
   FieldFile$ = LstFldFile$(SelectedField)
   FileName$ = FieldFile$ + ".fld"
   OPEN FieldFile$ + ".fld" FOR INPUT AS 1
    FOR Row = 1 TO 46
     FieldRow$ = INPUT$(80, 1)
     LOCATE Row, 1: PRINT FieldRow$
      FOR Column = 1 TO 80
       Block$(Row, Column) = MID$(FieldRow$, Column, 1)
      NEXT Column
    NEXT Row
   CLOSE 1
   CursorX = 1: CursorY = 1
   FieldName$ = LstFldName$(SelectedField)
   EXIT SUB
  ELSEIF Key$ = CHR$(27) THEN
   PCOPY 1, 0: EXIT SUB
  ELSEIF Key$ = CHR$(0) + "S" THEN
   PCOPY 0, 2
   COLOR 7, 4
   DrawBox 10, 27, 24, 1, 1
   Choose 11, 29, "Delete this field y/n?", Choice$, "YN"
    IF Choice$ = "Y" THEN
     DeleteField
     PCOPY 1, 0: EXIT SUB
    END IF
   PCOPY 2, 0
  END IF
 LOOP
END SUB

SUB Main
 DO
  DrawBar
   IF Block$(CursorX, CursorY) = "" THEN COLOR 23, 2 ELSE COLOR 23, 0
  LOCATE CursorX, CursorY: PRINT ""
   DO
    Key$ = INKEY$
   LOOP WHILE Key$ = ""
  COLOR 2, 0: LOCATE CursorX, CursorY
   IF Block$(CursorX, CursorY) = "" THEN PRINT "" ELSE PRINT " "
   IF Key$ = CHR$(0) + "H" THEN
    IF AutoDraw THEN DrawBlock
    IF AutoDelete THEN DeleteBlock
    IF CursorX = 1 THEN CursorX = 46 ELSE CursorX = CursorX - 1
   ELSEIF Key$ = CHR$(0) + "P" THEN
    IF AutoDraw THEN DrawBlock
    IF AutoDelete THEN DeleteBlock
    IF CursorX = 46 THEN CursorX = 1 ELSE CursorX = CursorX + 1
   ELSEIF Key$ = CHR$(0) + "K" THEN
    IF AutoDraw THEN DrawBlock
    IF AutoDelete THEN DeleteBlock
    IF CursorY = 1 THEN CursorY = 80 ELSE CursorY = CursorY - 1
   ELSEIF Key$ = CHR$(0) + "M" THEN
    IF AutoDraw THEN DrawBlock
    IF AutoDelete THEN DeleteBlock
    IF CursorY = 80 THEN CursorY = 1 ELSE CursorY = CursorY + 1
   ELSEIF Key$ = CHR$(8) THEN
    AutoDraw = 0
    AutoDelete = NOT AutoDelete
   ELSEIF Key$ = CHR$(9) THEN
    AutoDelete = 0
    AutoDraw = NOT AutoDraw
   ELSEIF Key$ = CHR$(13) THEN
    IF CursorX = 2 AND CursorY = 2 THEN
     DisplayMessage
    ELSEIF CursorX > 20 AND CursorX < 27 AND CursorY > 36 AND CursorY < 44 THEN
     DisplayMessage
    ELSE
     DrawBlock
    END IF
   ELSEIF Key$ = CHR$(14) THEN
    COLOR 7, 0
    Choose 47, 1, " Do you want to start drawing a new field y/n? ", Choice$, "YN"
     IF Choice$ = "Y" THEN RUN "Draw"
   ELSEIF Key$ = CHR$(27) THEN
    COLOR 7, 0: LOCATE 47, 1: PRINT SPACE$(80)
    Choose 47, 3, " Do you want to quit y/n? ", Choice$, "YN"
     IF Choice$ = "Y" THEN WIDTH 80, 25: COLOR 7, 0: CLS : SYSTEM
   ELSEIF Key$ = CHR$(0) + ";" THEN
    CALL Help
   ELSEIF Key$ = CHR$(0) + "S" THEN
    DeleteBlock
   ELSEIF Key$ = CHR$(0) + "<" THEN
    SaveField
   ELSEIF Key$ = CHR$(0) + "=" THEN
    LoadField
   END IF
 LOOP
END SUB

SUB SaveField
PCOPY 0, 1
 IF Fields = 250 THEN
  COLOR 0, 7
  DrawBox 19, 19, 40, 2, 1
  Center 20, "No more fields can be added."
  Center 0, "A maximum of 250 fields can be stored."
  Key$ = INPUT$(1)
  PCOPY 1, 0
  EXIT SUB
 ELSE
  Fields = Fields + 1
 END IF

COLOR 15, 0
LOCATE 47, 1: PRINT SPACE$(80)
Text$ = FieldFile$
 IF INSTR(Text$, ".") THEN Text$ = LEFT$(Text$, INSTR(Text$, ".") - 1)
InputBox 47, 3, " Enter filename for playfield: ", Text$, 8
 IF Text$ = "" THEN EXIT SUB
 IF INSTR(Text$, ".") THEN Text$ = LEFT$(Text$, INSTR(Text$, ".") - 1)
FieldFile$ = Text$
InputBox 47, 3, " Enter name for playfield: ", Text$, 25
FieldName$ = Text$

ErrorOccured = 0
FileName$ = FieldFile$ + ".fld"
OPEN FieldFile$ + ".fld" FOR BINARY AS 1
 IF LOF(1) = 0 THEN
  CLOSE 1
  KILL FieldFile$ + ".fld"
   IF NOT ErrorOccured THEN
    FileName$ = "Fields.lst"
     OPEN "Fields.lst" FOR APPEND AS 1
      PRINT #1, CHR$(LEN(FieldFile$)); FieldFile$; CHR$(LEN(FieldName$)); FieldName$;
      SEEK #1, 1
      PRINT #1, CHR$(Fields);
     CLOSE 1
   END IF
 ELSE
  CLOSE 1
  Choose 47, 3, "Field already exists, do you want to replace the field y/n?", Choice$, "YN"
   IF Choice$ = "N" THEN EXIT SUB
 END IF
FileName$ = FieldFile$ + ".fld"
OPEN FieldFile$ + ".fld" FOR OUTPUT AS 1
 FOR Row = 1 TO 46
  FOR Column = 1 TO 80
   IF Block$(Row, Column) = "" THEN PRINT #1, "";  ELSE PRINT #1, " ";
  NEXT Column
 NEXT Row
CLOSE 1
END SUB

