DEFINT A-Z

DECLARE SUB Begin ()
DECLARE SUB Center (x, Text$)
DECLARE SUB ChngMnstrDrctnX ()
DECLARE SUB ChngMnstrDrctnY ()
DECLARE SUB Delay (Seconds AS SINGLE)
DECLARE SUB DisplayHelp ()
DECLARE SUB DisplayList ()
DECLARE SUB DisplayMenu ()
DECLARE SUB DisplayScores ()
DECLARE SUB DisplayTitle ()
DECLARE SUB DrawBox (x, y, w, h, Shadow)
DECLARE SUB GameOver ()
DECLARE SUB GetJoystickStatus ()
DECLARE SUB Help ()
DECLARE SUB InputBox (x, y, Prompt$, Text$, MaxLength)
DECLARE SUB LoadField ()
DECLARE SUB MakeMonsters ()
DECLARE SUB MoveMonsters ()
DECLARE SUB MovePlayer ()
DECLARE SUB RedrawField ()
DECLARE SUB SaveSettings ()
DECLARE SUB ScoreList ()
DECLARE SUB SelectField ()
DECLARE SUB StartGame ()
OPTION BASE 0
COMMON SHARED CharDelay AS SINGLE, CharDrctn, CharX, CharY, CntrdStckX, CntrdStckY, DotsLeft, FieldFile$
COMMON SHARED FieldName$, Fields, FileName$, Fld, FldInTop, JoySensetivity, JoystickOn, Lives, Mnstr
COMMON SHARED Mnstrs, MnstrDelay AS SINGLE, NextDrctn, PlayerName$, PrevLives, SelectedField, SoundOn, TopRow, TotalDots
ON ERROR GOTO ErrorTrap
DIM SHARED MnstrX(10), MnstrY(10), MnstrDrctnX(10), MnstrDrctnY(10), MnstrColor(10)
DIM SHARED ScrNameLst$(11), ScrScoreLst$(11), ScrDateLst$(11), ScrFieldLst$(11)
DIM SHARED Block$(48, 81), DelayStart(4) AS SINGLE, HelpText$(100), MenuHelp$(9), MenuOption$(9), State$(-1 TO 0)
DIM SHARED LstFldFile$(250), LstFldName$(250)
SCREEN 0: WIDTH 80, 50: COLOR 7, 0: CLS
RANDOMIZE TIMER
Begin
DisplayMenu
StartGame
SaveSettings
RUN "Monsters"

ErrorTrap:
 IF NOT FileName$ = "" THEN MID$(FileName$, 1, 1) = UCASE$(LEFT$(FileName$, 1))
PCOPY 0, 3
 DO
  COLOR 12, 4
  DrawBox 19, 24, 30, 3, 0
  LOCATE 20
  ErrorCode = ERR
   IF ErrorCode = 53 THEN
    Center 0, "Cannot find: " + CHR$(34) + FileName$ + CHR$(34) + "."
   ELSEIF ErrorCode = 55 OR ErrorCode = 64 THEN
    Center 0, "Cannot open:"
    Center 0, CHR$(34) + FileName$ + CHR$(34) + "."
   ELSEIF ErrorCode = 61 THEN
    Center 0, "Not enough diskspace."
   ELSEIF ErrorCode = 62 THEN
    Center 0, "Error while reading:"
    Center 0, CHR$(34) + FileName$ + CHR$(34) + "."
   ELSEIF ErrorCode = 70 THEN
    Center 0, "Disk or file is "
    Center 0, "write protected."
   ELSEIF ErrorCode = 71 THEN
    Center 0, "Disk is not in drive."
   ELSEIF ErrorCode = 72 THEN
    Center 0, "The disk is damaged."
   ELSE
    Center 0, "Unexpected error."
   END IF
  Center 0, "Error code:" + STR$(ErrorCode)
  COLOR 0, 7: Center 24, " 1 = Retry  2 = Ignore  3 = Quit  "
   DO
    Choice$ = INKEY$
   LOOP WHILE Choice$ = ""
  PCOPY 3, 0
   IF Choice$ = "1" THEN RESUME
   IF Choice$ = "2" THEN RESUME NEXT
   IF Choice$ = "3" THEN WIDTH 80, 25: COLOR 7, 0: CLS : SYSTEM
 LOOP

SUB Begin
FileName$ = "Fields.lst"
OPEN "Fields.lst" FOR BINARY AS 1
 IF LOF(1) = 0 THEN
  CLOSE 1
  KILL "Fields.lst"
 ELSE
  Fields = ASC(INPUT$(1, 1))
 END IF
CLOSE 1

 IF Fields = 0 THEN
  COLOR 0, 7
  DrawBox 19, 25, 28, 1, 1
  Center 20, "There are no saved fields."
  Key$ = INPUT$(1)
  WIDTH 80, 25: COLOR 7, 0: CLS : SYSTEM
 END IF

FileName$ = "Monsters.set"
OPEN "Monsters.set" FOR BINARY AS 1
 IF LOF(1) = 0 THEN
  CLOSE 1
  KILL "Monsters.set"
  CharDelay = .01
  JoystickOn = 0
  Lives = 2
  Mnstrs = 9
  MnstrDelay = .02
  SoundOn = -1
 ELSE
  CharDelay = (100 - ASC(INPUT$(1, 1))) / 100
  JoystickOn = -ASC(INPUT$(1, 1))
  Lives = ASC(INPUT$(1, 1))
  MnstrDelay = (100 - ASC(INPUT$(1, 1))) / 100
  Mnstrs = ASC(INPUT$(1, 1))
  SoundOn = -ASC(INPUT$(1, 1))
  CLOSE 1
 END IF
PrevLives = Lives
MakeMonsters
END SUB

SUB Center (x, Text$)
 IF x > 0 THEN LOCATE x
LOCATE , INT(40 - (LEN(Text$) / 2))
PRINT Text$
END SUB

SUB ChngMnstrDrctnX
MnstrDrctnX(Mnstr) = CINT(RND * 1) + 1
END SUB

SUB ChngMnstrDrctnY
MnstrDrctnY(Mnstr) = CINT(RND * 1) + 1
END SUB

SUB Delay (Seconds AS SINGLE)
DelayStart(4) = TIMER
 DO UNTIL TIMER > DelayStart(4) OR TIMER < 3
 LOOP
END SUB

SUB DisplayHelp
DrawBox 10, 20, 38, 20, 1
Center 10, "Help"
Row = 11
 FOR HLine = TopRow TO TopRow + 19
  LOCATE Row, 21
  PRINT HelpText$(HLine)
  Row = Row + 1
 NEXT HLine
END SUB

SUB DisplayList
Row = 11
 FOR Fld = FldInTop TO FldInTop + 29
   IF Fld > 250 THEN EXIT FOR
  l = LEN(LstFldName$(Fld))
   IF Fld = SelectedField THEN COLOR 0, 2 ELSE COLOR 0, 7
  LOCATE Row, 27: PRINT LstFldName$(Fld); SPACE$(26 - l)
  Row = Row + 1
 NEXT Fld
END SUB

SUB DisplayMenu
CursorX = 0
State$(-1) = "on": State$(0) = "off"
MenuOption$(0) = "Begin game"
MenuOption$(1) = "Joystick on/off"
MenuOption$(2) = "Sound on/off"
MenuOption$(3) = "Monsters' speed"
MenuOption$(4) = "Player's speed"
MenuOption$(5) = "Number of lives"
MenuOption$(6) = "Number of monsters"
MenuOption$(7) = "Help"
MenuOption$(8) = "View score list"
MenuOption$(9) = "Quit"
MenuHelp$(0) = "Press Enter to play."
MenuHelp$(1) = "The joystick is turned " + State$(JoystickOn) + "."
MenuHelp$(2) = "The sound is turned " + State$(SoundOn) + "."
MenuHelp$(3) = "The speed is set at:" + STR$(CINT(100 - (MnstrDelay * 100))) + ", use +/- to change."
MenuHelp$(4) = "The speed is set at:" + STR$(CINT(100 - (CharDelay * 100))) + ", use +/- to change."
MenuHelp$(5) = "Lives:" + STR$(Lives + 1) + ", use +/- to change."
MenuHelp$(6) = "Number of monsters:" + STR$(Mnstrs + 1) + ", use +/- to change."
MenuHelp$(7) = "Help."
MenuHelp$(8) = "View the score list."
MenuHelp$(9) = "Exit the program."
DisplayTitle
COLOR 7: PRINT STRING$(80, "")
LOCATE 46: PRINT STRING$(80, "")
COLOR 15: Center 0, "Monsters, By: Peter Swinkels, ***1998***, version 1.18"
COLOR 3
 FOR Optn = 0 TO 9
  LOCATE (Optn + 6) * 2, 6: PRINT MenuOption$(Optn)
 NEXT Optn
COLOR 2: Center 45, "Use " + CHR$(24) + "/" + CHR$(25) + " to move cursor."
 DO
  COLOR 3, 1
  LOCATE (CursorX + 6) * 2, 5: PRINT " "; MenuOption$(CursorX); SPACE$(20 - LEN(MenuOption$(CursorX)))
   DO
    Key$ = INKEY$
   LOOP WHILE Key$ = ""
  COLOR 3, 0
  LOCATE (CursorX + 6) * 2, 5: PRINT " "; MenuOption$(CursorX); SPACE$(20 - LEN(MenuOption$(CursorX)))
  LOCATE 45, 1: PRINT SPACE$(80)
   IF Key$ = CHR$(0) + "H" THEN
    IF CursorX = 0 THEN CursorX = 9 ELSE CursorX = CursorX - 1
   ELSEIF Key$ = CHR$(0) + "P" THEN
    IF CursorX = 9 THEN CursorX = 0 ELSE CursorX = CursorX + 1
   ELSEIF Key$ = CHR$(13) THEN
    IF CursorX = 1 THEN
      IF JoystickOn THEN JoystickOn = 0 ELSE JoystickOn = -1
     MenuHelp$(1) = "The joystick is turned " + State$(JoystickOn) + "."
    ELSEIF CursorX = 2 THEN
      IF SoundOn THEN SoundOn = 0 ELSE SoundOn = -1
     MenuHelp$(2) = "The sound is turned " + State$(SoundOn) + "."
    ELSE
     COLOR , 0
      IF CursorX = 0 THEN
       CLS
       InputBox 5, 6, "Enter your name: ", Text$, 10
        IF Text$ = "-" OR Text$ = "" THEN SaveSettings: RUN "Monsters"
       SWAP PlayerName$, Text$
        IF JoystickOn THEN
         COLOR 7
         LOCATE 5, 6: PRINT "Please enter joystick sensetivity (1-9):"
          DO
           JoySensetivity = VAL(INPUT$(1))
          LOOP UNTIL JoySensetivity > 0 AND JoySensetivity < 10
         JoySensetivity = JoySensetivity * 3
        END IF
       SelectField
       EXIT SUB
      END IF
      IF CursorX = 7 THEN SaveSettings: CALL Help: RUN "Monsters"
      IF CursorX = 8 THEN SaveSettings: DisplayScores: RUN "Monsters"
      IF CursorX = 9 THEN SaveSettings: WIDTH 80, 25: COLOR 7, 0: CLS : SYSTEM
     END IF
   ELSEIF CursorX = 3 THEN
     IF Key$ = "-" THEN IF CINT(MnstrDelay * 100) >= 100 THEN MnstrDelay = 0 ELSE MnstrDelay = MnstrDelay + .01
     IF Key$ = "+" THEN IF CINT(MnstrDelay * 100) <= 0 THEN MnstrDelay = 1 ELSE MnstrDelay = MnstrDelay - .01
    MenuHelp$(3) = "The speed is set at:" + STR$(CINT(100 - (MnstrDelay * 100))) + ", use +/- to change."
   ELSEIF CursorX = 4 THEN
     IF Key$ = "-" THEN IF CINT(CharDelay * 100) >= 100 THEN CharDelay = 0 ELSE CharDelay = CharDelay + .01
     IF Key$ = "+" THEN IF CINT(CharDelay * 100) <= 0 THEN CharDelay = 1 ELSE CharDelay = CharDelay - .01
    MenuHelp$(4) = "The speed is set at:" + STR$(CINT(100 - (CharDelay * 100))) + ", use +/- to change."
   ELSEIF CursorX = 5 THEN
     IF Key$ = "-" THEN IF Lives = 0 THEN Lives = 4 ELSE Lives = Lives - 1
     IF Key$ = "+" THEN IF Lives = 4 THEN Lives = 0 ELSE Lives = Lives + 1
    MenuHelp$(5) = "Lives:" + STR$(Lives + 1) + ", use +/- to change."
    PrevLives = Lives
   ELSEIF CursorX = 6 THEN
     IF Key$ = "-" THEN IF Mnstrs = 2 THEN Mnstrs = 9 ELSE Mnstrs = Mnstrs - 1
     IF Key$ = "+" THEN IF Mnstrs = 9 THEN Mnstrs = 2 ELSE Mnstrs = Mnstrs + 1
    MenuHelp$(6) = "Number of monsters:" + STR$(Mnstrs + 1) + ", use +/- to change."
   END IF
  COLOR 2: Center 45, MenuHelp$(CursorX)
 LOOP
END SUB

SUB DisplayScores
 IF FieldName$ = "" THEN
  CLS
  COLOR 15
  Center 7, "Select a field to display scorelist for:"
  SelectField
 END IF
ERASE ScrNameLst$, ScrScoreLst$, ScrDateLst$, ScrFieldLst$
DotsLeft = TotalDots - DotsLeft
COLOR 1, 0: CLS
PRINT STRING$(80, "")
COLOR 2
FileName$ = "Scorelst.dat"
OPEN "Scorelst.dat" FOR INPUT AS 1
 DO UNTIL EOF(1)
  LINE INPUT #1, Score$
  Center 0, Score$
 LOOP
CLOSE 1
COLOR 1: PRINT STRING$(80, "")

FileName$ = "Scores.lst"
OPEN "Scores.lst" FOR BINARY AS 1
 IF LOF(1) = 0 THEN
  IF NOT PlayerName$ = "" THEN
   CLOSE 1
   OPEN "Scores.lst" FOR OUTPUT AS 1
    COLOR 23
    PRINT USING "   \        \ ### \        \ "; PlayerName$; DotsLeft; DATE$; FieldName$
    PRINT #1, CHR$(LEN(PlayerName$)); PlayerName$; CHR$(LEN(STR$(DotsLeft))); STR$(DotsLeft); CHR$(LEN(DATE$)); DATE$; CHR$(LEN(FieldName$)); FieldName$;
   CLOSE 1
  ELSE
   CLOSE 1
   KILL "Scores.lst"
   COLOR 14
   PRINT "There are no scores."
  END IF
 ELSE
  Score = 1
   DO UNTIL LOC(1) = LOF(1)
    l = ASC(INPUT$(1, 1)): ScrName$ = INPUT$(l, 1)
    l = ASC(INPUT$(1, 1)): ScrScore$ = INPUT$(l, 1)
    l = ASC(INPUT$(1, 1)): ScrDate$ = INPUT$(l, 1)
    l = ASC(INPUT$(1, 1)): ScrField$ = INPUT$(l, 1)
     IF ScrField$ = FieldName$ THEN
      ScrNameLst$(Score) = ScrName$
      ScrScoreLst$(Score) = ScrScore$
      ScrDateLst$(Score) = ScrDate$
      ScrFieldLst$(Score) = ScrField$
      Score = Score + 1
     END IF
   LOOP
  CLOSE 1
   IF NOT PlayerName$ = "" THEN
    FoundAt = 0
     FOR Score = 1 TO 10
      IF VAL(ScrScoreLst$(Score)) = DotsLeft THEN FoundAt = Score
     NEXT Score
     IF FoundAt = 0 THEN FoundAt = 11
    ScrScoreLst$(FoundAt) = STR$(DotsLeft)
    ScrNameLst$(FoundAt) = PlayerName$
    ScrDateLst$(FoundAt) = DATE$
    ScrFieldLst$(FoundAt) = FieldName$
   END IF
  
   FOR Score1 = 1 TO 11
    FOR Score2 = 1 TO 11
     IF VAL(ScrScoreLst$(Score2)) < VAL(ScrScoreLst$(Score1)) AND NOT Score1 = Score2 THEN
      SWAP ScrNameLst$(Score1), ScrNameLst$(Score2)
      SWAP ScrScoreLst$(Score1), ScrScoreLst$(Score2)
      SWAP ScrDateLst$(Score1), ScrDateLst$(Score2)
      SWAP ScrFieldLst$(Score1), ScrFieldLst$(Score2)
     END IF
    NEXT Score2
   NEXT Score1

  FileName$ = "Scores.tmp"
  OPEN "Scores.tmp" FOR OUTPUT AS 1
    FOR Score = 1 TO 10
     IF VAL(ScrScoreLst$(Score)) > 0 THEN
       IF NOT PlayerName$ = "" AND VAL(ScrScoreLst$(Score)) = DotsLeft THEN COLOR 23 ELSE COLOR 7
      PRINT USING "   \        \ ### \        \ "; ScrNameLst$(Score); VAL(ScrScoreLst$(Score)); ScrDateLst$(Score); ScrFieldLst$(Score)
      PRINT #1, CHR$(LEN(ScrNameLst$(Score))); ScrNameLst$(Score); CHR$(LEN(ScrScoreLst$(Score))); ScrScoreLst$(Score); CHR$(LEN(ScrDateLst$(Score))); ScrDateLst$(Score); CHR$(LEN(ScrFieldLst$(Score))); ScrFieldLst$(Score);
     END IF
    NEXT Score
   OPEN "Scores.lst" FOR BINARY AS 2
    l = ASC(INPUT$(1, 2)): ScrName$ = INPUT$(l, 2)
    l = ASC(INPUT$(1, 2)): ScrScore$ = INPUT$(l, 2)
    l = ASC(INPUT$(1, 2)): ScrDate$ = INPUT$(l, 2)
    l = ASC(INPUT$(1, 2)): ScrField$ = INPUT$(l, 2)
     IF NOT ScrField$ = FieldName$ THEN
      PRINT #1, CHR$(LEN(ScrName$)); ScrName$; CHR$(LEN(ScrScore$)); ScrScore$; CHR$(LEN(ScrDate$)); ScrDate$; CHR$(LEN(ScrField$)); ScrField$;
     END IF
   CLOSE 2
  CLOSE 1
  FileName$ = "Scores.lst"
  KILL "Scores.lst"
  FileName$ = "Scores.tmp"
  NAME "Scores.tmp" AS "Scores.lst"
 END IF
Key$ = INPUT$(1)
END SUB

SUB DisplayTitle
COLOR 15, 0: LOCATE 1, 1
FileName$ = "Title.dat"
OPEN "Title.dat" FOR INPUT AS 1
 DO UNTIL EOF(1)
  LINE INPUT #1, Row$
  PRINT Row$
 LOOP
CLOSE 1
END SUB

SUB DrawBox (x, y, w, h, Shadow)
LOCATE x, y: PRINT ""; STRING$(w, ""); ""
 FOR BoxX = 1 TO h
  LOCATE , y: PRINT ""; SPC(w); "";
   IF Shadow THEN PRINT "" ELSE PRINT
 NEXT BoxX
LOCATE , y: PRINT ""; STRING$(w, ""); "";
 IF Shadow THEN PRINT "": LOCATE , y + 1: PRINT STRING$(w + 2, "") ELSE PRINT
END SUB

SUB GameOver
DIM Pic$(3)
Pic$(3) = ""
Pic$(2) = "_"
Pic$(1) = "*"
Pic$(0) = " "
Pic = 3
COLOR 15
DelayStart(3) = TIMER
 DO
  IF TIMER > DelayStart(3) + .3 THEN
    IF SoundOn THEN SOUND (Pic * 30) + 37, 3 ELSE Delay .5
   LOCATE CharX, CharY: PRINT Pic$(Pic)
    IF Pic = 0 THEN EXIT DO ELSE Pic = Pic - 1
   DelayStart(3) = TIMER
  ELSE
   IF TIMER < 3 THEN DelayStart(3) = TIMER
  END IF
 LOOP
COLOR 0, 7
DrawBox 20, 22, 34, 2, 0
Center 21, "Game over!"
Center 0, "Do you want to play again y/n?"
 DO
  Answer$ = UCASE$(INPUT$(1))
 LOOP UNTIL Answer$ = "Y" OR Answer$ = "N"
DisplayScores
 IF Answer$ = "N" THEN SaveSettings: WIDTH 80, 25: COLOR 7, 0: CLS : SYSTEM
END SUB

SUB GetJoystickStatus
JoystickX = STICK(0)
JoystickY = STICK(1)
 IF JoystickY < CntrdStckY - JoySensetivity AND NOT Block$(CharX - 1, CharY) = "" THEN CharDrctn = 1
 IF JoystickY > CntrdStckY + JoySensetivity AND NOT Block$(CharX + 1, CharY) = "" THEN CharDrctn = 2
 IF JoystickX < CntrdStckX - JoySensetivity AND NOT Block$(CharX, CharY - 1) = "" THEN CharDrctn = 3
 IF JoystickX > CntrdStckX + JoySensetivity AND NOT Block$(CharX, CharY + 1) = "" THEN CharDrctn = 4
END SUB

SUB Help
ERASE HelpText$
PCOPY 0, 1
TopRow = 1
FileName$ = "Help.hlp"
OPEN "Help.hlp" FOR INPUT AS 1: CLOSE 1
OPEN "Help.hlp" FOR BINARY AS 1
 IF LOF(1) = 0 THEN
  CLOSE 1
  KILL "Help.hlp"
 ELSE
  HLine = 1
   DO UNTIL LOC(1) = LOF(1)
    Format$ = INPUT$(1, 1)
     DO
      Char$ = INPUT$(1, 1)
       IF Char$ = CHR$(10) OR LOC(1) = LOF(1) THEN EXIT DO
      HelpText$(HLine) = HelpText$(HLine) + Char$
     LOOP
     IF Format$ = "" THEN
      HelpText$(HLine) = STRING$(38, 196)
     ELSEIF Format$ = "=" THEN
      HelpText$(HLine) = STRING$(38, 205)
     ELSEIF Format$ = ">" THEN
      HelpText$(HLine) = SPACE$(19 - (LEN(HelpText$(HLine)) \ 2)) + HelpText$(HLine)
     END IF
    HLine = HLine + 1
   LOOP
  CLOSE 1
 END IF

COLOR 0, 7
 DO
  DisplayHelp
   DO
    Key$ = INKEY$
   LOOP WHILE Key$ = ""
   IF Key$ = CHR$(0) + "H" THEN IF TopRow > 1 THEN TopRow = TopRow - 1
   IF Key$ = CHR$(0) + "P" THEN IF TopRow < 80 THEN TopRow = TopRow + 1
   IF Key$ = CHR$(27) THEN PCOPY 1, 0: EXIT SUB
 LOOP
END SUB

SUB InputBox (x, y, Prompt$, Text$, MaxLength)
 DO
  COLOR 7, 0
  LOCATE x, y: PRINT Prompt$; Text$; : COLOR 23: PRINT "_ "
   DO
    Key$ = INKEY$
   LOOP WHILE Key$ = ""
  l = LEN(Text$)
   IF Key$ = CHR$(8) THEN
    IF l > 0 THEN Text$ = LEFT$(Text$, l - 1)
   ELSEIF Key$ = CHR$(13) THEN
    EXIT DO
   ELSEIF Key$ = CHR$(27) THEN
    Text$ = "": EXIT DO
   ELSEIF ASC(Key$) > 31 THEN
    IF l < MaxLength THEN Text$ = Text$ + Key$
   END IF
 LOOP
LOCATE x, y: PRINT SPACE$(LEN(Prompt$) + l + 2)
END SUB

SUB LoadField
COLOR 2, 0: CLS
FileName$ = FieldFile$ + ".fld"
OPEN FieldFile$ + ".fld" FOR INPUT AS 1
 FOR Row = 1 TO 46
  FieldRow$ = INPUT$(80, 1)
  LOCATE Row, 1: PRINT FieldRow$
   FOR Column = 1 TO 80
    Block$(Row, Column) = MID$(FieldRow$, Column, 1)
   NEXT Column
 NEXT Row
CLOSE 1

COLOR 14
DotsLeft = 0
 FOR x = 1 TO 46 STEP 2
  FOR y = 1 TO 80 STEP 2
   IF NOT Block$(x, y) = "" THEN
    Block$(x, y) = "."
    LOCATE x, y: PRINT Block$(x, y)
    DotsLeft = DotsLeft + 1
   END IF
  NEXT y
 NEXT x
TotalDots = DotsLeft
END SUB

SUB MakeMonsters
 FOR Mnstr = 1 TO 11
  MnstrX(Mnstr - 1) = CINT(RND * 5) + 21
  MnstrY(Mnstr - 1) = CINT(RND * 5) + 37
  MnstrColor(Mnstr - 1) = CINT(RND * 13) + 1
  MnstrDrctnX(Mnstr - 1) = CINT(RND * 1) + 1
  MnstrDrctnY(Mnstr - 1) = CINT(RND * 1) + 1
 NEXT Mnstr
END SUB

SUB MoveMonsters
 IF TIMER >= DelayStart(1) + MnstrDelay THEN
   FOR Mnstr = 0 TO Mnstrs
    COLOR 14: LOCATE MnstrX(Mnstr), MnstrY(Mnstr)
     IF Block$(MnstrX(Mnstr), MnstrY(Mnstr)) = "." THEN PRINT "." ELSE PRINT " "
     IF MnstrDrctnX(Mnstr) = 1 THEN
      IF MnstrX(Mnstr) > 1 AND NOT Block$(MnstrX(Mnstr) - 1, MnstrY(Mnstr)) = "" THEN MnstrX(Mnstr) = MnstrX(Mnstr) - 1 ELSE ChngMnstrDrctnX
     ELSEIF MnstrDrctnX(Mnstr) = 2 THEN
      IF MnstrX(Mnstr) < 46 AND NOT Block$(MnstrX(Mnstr) + 1, MnstrY(Mnstr)) = "" THEN MnstrX(Mnstr) = MnstrX(Mnstr) + 1 ELSE ChngMnstrDrctnX
     END IF
     IF MnstrDrctnY(Mnstr) = 1 THEN
      IF MnstrY(Mnstr) > 1 AND NOT Block$(MnstrX(Mnstr), MnstrY(Mnstr) - 1) = "" THEN MnstrY(Mnstr) = MnstrY(Mnstr) - 1 ELSE ChngMnstrDrctnY
     ELSEIF MnstrDrctnY(Mnstr) = 2 THEN
      IF MnstrY(Mnstr) < 80 AND NOT Block$(MnstrX(Mnstr), MnstrY(Mnstr) + 1) = "" THEN MnstrY(Mnstr) = MnstrY(Mnstr) + 1 ELSE ChngMnstrDrctnY
     END IF
    COLOR MnstrColor(Mnstr)
    LOCATE MnstrX(Mnstr), MnstrY(Mnstr): PRINT CHR$(2)
   NEXT Mnstr
  DelayStart(1) = TIMER
 ELSE
  IF TIMER < 3 THEN DelayStart(1) = TIMER
 END IF
END SUB

SUB MovePlayer
 IF NOT Block$(CharX - 1, CharY) = "" AND NextDrctn = 1 THEN NextDrctn = 0: CharDrctn = 1
 IF NOT Block$(CharX + 1, CharY) = "" AND NextDrctn = 2 THEN NextDrctn = 0: CharDrctn = 2
 IF NOT Block$(CharX, CharY - 1) = "" AND NextDrctn = 3 THEN NextDrctn = 0: CharDrctn = 3
 IF NOT Block$(CharX, CharY + 1) = "" AND NextDrctn = 4 THEN NextDrctn = 0: CharDrctn = 4
 FOR Mnstr = 0 TO Mnstrs
  IF MnstrX(Mnstr) >= CharX - 1 AND MnstrY(Mnstr) >= CharY - 1 AND MnstrX(Mnstr) <= CharX + 1 AND MnstrY(Mnstr) <= CharY + 1 THEN
   IF Lives = 0 THEN
    SaveSettings
    CALL GameOver
    RUN "Monsters"
   ELSE
    Lives = Lives - 1
     IF SoundOn THEN SOUND 37, 1: SOUND 100, 1
    COLOR 12: LOCATE 47, 1: PRINT "Lives: "; STRING$(Lives + 1, 1); " "
    COLOR 0, 7: DrawBox 10, 24, 30, 2, 0
    Center 11, "You got caught!"
    Center 0, "Press Enter to continue."
     DO
      Key$ = INPUT$(1)
     LOOP UNTIL Key$ = CHR$(13)
    COLOR , 0
    RedrawField
    JoystickX = 0: JoystickY = 0
    CharX = 2: CharY = 2: CharDrctn = 0: NextDrctn = 0
    MakeMonsters
    EXIT FOR
   END IF
  END IF
 NEXT Mnstr
 IF TIMER > DelayStart(2) + CharDelay THEN
   IF DotsLeft = 0 THEN
    COLOR 0, 7: DrawBox 10, 24, 30, 2, 0
    COLOR 16: Center 11, "You won!"
    COLOR 0: Center 0, "Press a key to continue."
    Key$ = INPUT$(1)
    SaveSettings
    DisplayScores
    RUN "Monsters"
   ELSE
    FOR x = -1 TO 1
     FOR y = -1 TO 1
      IF Block$(CharX + x, CharY + y) = "." THEN
       Block$(CharX + x, CharY + y) = " "
       LOCATE CharX + x, CharY + y: PRINT " "
        IF SoundOn THEN SOUND 37, .03
       DotsLeft = DotsLeft - 1
      END IF
     NEXT y
    NEXT x
   END IF
  LOCATE CharX, CharY: PRINT " "
   IF CharDrctn = 1 THEN
    IF CharX > 1 AND NOT Block$(CharX - 1, CharY) = "" THEN CharX = CharX - 1
   ELSEIF CharDrctn = 2 THEN
    IF CharX < 46 AND NOT Block$(CharX + 1, CharY) = "" THEN CharX = CharX + 1
   ELSEIF CharDrctn = 3 THEN
    IF CharY > 1 AND NOT Block$(CharX, CharY - 1) = "" THEN CharY = CharY - 1
   ELSEIF CharDrctn = 4 THEN
    IF CharY < 80 AND NOT Block$(CharX, CharY + 1) = "" THEN CharY = CharY + 1
   END IF
  LOCATE CharX, CharY: COLOR 15: PRINT CHR$(1)
  DelayStart(2) = TIMER
 ELSE
  IF TIMER < 3 THEN DelayStart(2) = TIMER
 END IF
END SUB

SUB RedrawField
COLOR 12: LOCATE 47, 1: PRINT "Lives: "; STRING$(Lives + 1, 1); " "
 FOR x = 1 TO 47
  FOR y = 1 TO 80
    IF Block$(x, y) = "." THEN COLOR 14 ELSE COLOR 2
   LOCATE x, y: PRINT Block$(x, y)
  NEXT y
 NEXT x
END SUB

SUB SaveSettings
FileName$ = "Monsters.set"
OPEN "Monsters.set" FOR OUTPUT AS 1
 PRINT #1, CHR$(CINT(100 - CharDelay * 100));
 PRINT #1, CHR$(-JoystickOn);
 PRINT #1, CHR$(PrevLives);
 PRINT #1, CHR$(CINT(100 - MnstrDelay * 100));
 PRINT #1, CHR$(Mnstrs);
 PRINT #1, CHR$(-SoundOn);
CLOSE 1
END SUB

SUB SelectField
ERASE LstFldFile$, LstFldName$
CursorX = 1
FldInTop = 1
SelectedField = 1
PCOPY 0, 1
COLOR 0, 7: DrawBox 10, 26, 26, 30, 1
Center 10, "Select a field."
FileName$ = "Fields.lst"
OPEN "Fields.lst" FOR INPUT AS 1: CLOSE 1
OPEN "Fields.lst" FOR BINARY AS 1
 Fields = ASC(INPUT$(1, 1))
  FOR Fld = 1 TO Fields
    IF LOC(1) = LOF(1) THEN Fields = Fld: EXIT FOR
   l = ASC(INPUT$(1, 1)): LstFldFile$(Fld) = INPUT$(l, 1)
   l = ASC(INPUT$(1, 1)): LstFldName$(Fld) = INPUT$(l, 1)
  NEXT Fld
CLOSE 1
 DO
  DisplayList
   DO
    Key$ = INKEY$
   LOOP WHILE Key$ = ""
  IF Key$ = CHR$(0) + "H" THEN
   IF SelectedField > 1 THEN
    SelectedField = SelectedField - 1
     IF CursorX > 1 THEN CursorX = CursorX - 1 ELSE FldInTop = FldInTop - 1
   END IF
  ELSEIF Key$ = CHR$(0) + "P" THEN
   IF SelectedField < 100 THEN
    SelectedField = SelectedField + 1
     IF CursorX < 30 THEN CursorX = CursorX + 1 ELSE FldInTop = FldInTop + 1
   END IF
  ELSEIF Key$ = CHR$(13) AND NOT LstFldFile$(SelectedField) = "" THEN
   FieldFile$ = LstFldFile$(SelectedField)
   FieldName$ = LstFldName$(SelectedField)
   EXIT SUB
  ELSEIF Key$ = CHR$(27) THEN
   PCOPY 1, 0: RUN "Monsters"
  END IF
 LOOP
END SUB

SUB StartGame
CharX = 2: CharY = 2: NextDrctn = 0
 IF JoystickOn THEN
  COLOR , 0: CLS
  COLOR 12: LOCATE 3, 5: PRINT "Make sure the joystick is centered."
  LOCATE , 6: PRINT "Press a key "
  Key$ = INPUT$(1)
  CntrdStckX = STICK(0): CntrdStckY = STICK(1)
 END IF
LoadField
DelayStart(1) = TIMER
DelayStart(2) = TIMER
COLOR 12: LOCATE 47, 1: PRINT "Lives: "; STRING$(Lives + 1, 1); " "
 DO
  DO
    IF JoystickOn THEN GetJoystickStatus
   MovePlayer
   MoveMonsters
   Key$ = UCASE$(INKEY$)
  LOOP WHILE Key$ = ""
  IF NOT JoystickOn THEN
   IF Key$ = CHR$(0) + "H" THEN
    IF NOT Block$(CharX - 1, CharY) = "" THEN CharDrctn = 1: NextDrctn = 0 ELSE NextDrctn = 1
   ELSEIF Key$ = CHR$(0) + "P" THEN
    IF NOT Block$(CharX + 1, CharY) = "" THEN CharDrctn = 2: NextDrctn = 0 ELSE NextDrctn = 2
   ELSEIF Key$ = CHR$(0) + "K" THEN
    IF NOT Block$(CharX, CharY - 1) = "" THEN CharDrctn = 3: NextDrctn = 0 ELSE NextDrctn = 3
   ELSEIF Key$ = CHR$(0) + "M" THEN
    IF NOT Block$(CharX, CharY + 1) = "" THEN CharDrctn = 4: NextDrctn = 0 ELSE NextDrctn = 4
   ELSEIF Key$ = CHR$(0) + "O" THEN
    CharDrctn = 0: NextDrctn = 0
   END IF
  END IF
  IF Key$ = "J" AND JoystickOn THEN
   CntrdStckX = STICK(0): CntrdStckY = STICK(1)
  ELSEIF Key$ = "P" THEN
   COLOR 0, 7: DrawBox 10, 24, 30, 2, 0
   Center 11, "Pause."
   Center 0, "Press any key to continue."
    DO
     IF TIMER < 3 THEN
      DelayStart(1) = TIMER
      DelayStart(2) = TIMER
     END IF
    LOOP WHILE INKEY$ = ""
   COLOR , 0
   RedrawField
  END IF
  IF Key$ = CHR$(27) THEN EXIT SUB
 LOOP
END SUB

